#! /bin/sh
set -e
if test ! -f instsrc -o ! -f src/srclisp.blf; then
    echo "You must run $0 in the Allegro directory."
    exit 1
fi
rm -f temp.tbz2
echo 'Creating temp.tbz2...'
./instsrc lisp-source src/srclisp.blf temp.tbz2
echo 'Extracting source files from temp.tbz2...'
./bunzip2 < temp.tbz2 | tar xf -
rm -f temp.tbz2
