;
;#include <stdlib.h>
;#include <gtk/gtk.h>
;
;int main( int argc,
;	   char *argv[] )
;{
;    GtkWidget *window;
;    GtkWidget *event_box;
;    GtkWidget *label;
;    
;    gtk_init (&argc, &argv);
;    
;    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
;    
;    gtk_window_set_title (GTK_WINDOW (window), "Event Box");
;    
;    g_signal_connect (G_OBJECT (window), "destroy",
;		       G_CALLBACK (exit), NULL);
;    
;    gtk_container_set_border_width (GTK_CONTAINER (window), 10);
;    
;    /* Create an EventBox and add it to our toplevel window */
;    
;    event_box = gtk_event_box_new ();
;    gtk_container_add (GTK_CONTAINER (window), event_box);
;    gtk_widget_show (event_box);
;    
;    /* Create a long label */
;    
;    label = gtk_label_new ("Click here to quit, quit, quit, quit, quit");
;    gtk_container_add (GTK_CONTAINER (event_box), label);
;    gtk_widget_show (label);
;    
;    /* Clip it short. */
;    gtk_widget_set_size_request (label, 110, 20);
;    
;    /* And bind an action to it */
;    gtk_widget_set_events (event_box, GDK_BUTTON_PRESS_MASK);
;    g_signal_connect (G_OBJECT (event_box), "button_press_event",
;		       G_CALLBACK (exit), NULL);
;    
;    /* Yet one more thing you need an X window for ... */
;    
;    gtk_widget_realize (event_box);
;    gdk_window_set_cursor (event_box->window, gdk_cursor_new (GDK_HAND1));
;    
;    gtk_widget_show (window);
;    
;    gtk_main ();
;    
;    return 0;
;}

(defpackage "10.01-eventbox" (:use :excl :common-lisp))
(in-package "10.01-eventbox")

(defun eventbox ()
  (let ((window nil)
	(event-box nil)
	(label nil))
    
    (gtk:gtk_init 0 0)
   
    (setq window (gtk:gtk_window_new gtk:GTK_WINDOW_TOPLEVEL))

    (gtk:gtk_window_set_title (gtk:GTK_WINDOW window) "Event Box")
    
    (gtk:g_signal_connect (gtk:G_OBJECT window) "destroy"
			  (gtk:G_CALLBACK
			   (ff:get-entry-point "gtk_exit"))
			  gtk:NULL)
    (gtk:gtk_container_set_border_width (gtk:GTK_CONTAINER window) 10)

    (setq event-box (gtk:gtk_event_box_new))
    (gtk:gtk_container_add (gtk:GTK_CONTAINER window) event-box)
    (gtk:gtk_widget_show event-box)

    (setq label (gtk:gtk_label_new "Click here to quit quit quit quit quit"))
    (gtk:gtk_container_add (gtk:GTK_CONTAINER event-box) label)
    (gtk:gtk_widget_show label)

    (gtk:gtk_widget_set_size_request label 110 20)

    (gtk:gtk_widget_set_events event-box gtk:GDK_BUTTON_PRESS_MASK)
    (gtk:g_signal_connect (gtk:G_OBJECT event-box) "button_press_event"
			  (gtk:G_CALLBACK
			   (ff:get-entry-point "gtk_exit"))
			  gtk:NULL)

    (gtk:gtk_widget_realize event-box)
    (gtk:gdk_window_set_cursor
     (ff:fslot-value-typed 'gtk:GtkWidget nil event-box 'gtk::window)
     (gtk:gdk_cursor_new gtk:GDK_HAND1))

    (gtk:gtk_widget_show window)
    
    #+original (gtk:gtk_main)
    #-original (gtk:gtk-main)))



(flet ((run-example (name function)
	 ;; workaround for bogus (imo) redef. warnings generated by defvar
	 (declare (special gtk::*run-example*))
	 (unless (boundp 'gtk::*run-example*)
	   (setq gtk::*run-example* t))
	 (when gtk::*run-example*
	   (mp:process-run-function
	    (format nil "GTK+ Example: ~a" name)
	    function))))
  (run-example "10.01-eventbox" #'eventbox))
