;;
;; copyright (c) 1996-2002 Franz Inc, Berkeley, CA  - All rights reserved.
;; copyright (c) 2002-2004 Franz Inc, Oakland, CA - All rights reserved.
;;
;; The software, data and information contained herein are proprietary
;; to, and comprise valuable trade secrets of, Franz, Inc.  They are
;; given in confidence by Franz, Inc. pursuant to a written license
;; agreement, and may be stored and used only in accordance with the terms
;; of such license.
;;
;; Restricted Rights Legend
;; ------------------------
;; Use, duplication, and disclosure of the software, data and information
;; contained herein by any agency, department or entity of the U.S.
;; Government are subject to restrictions of Restricted Rights for
;; Commercial Software developed at private expense as specified in 
;; DOD FAR Supplement 52.227-7013 (c) (1) (ii), as applicable.

;; This file is derived from the output of Allegro CL Lisp-to-C Binder
;; Version 1.6.3(1.6.3).  The original is at the bottom of this file
;; following the line including "Begin Original".


;; Changes to cbind output:
;;  Fix expressions: WARNING: Unsupported operator in expression |
;;  Fix expressions: WARNING: Unsupported expression: ~

;;; chee   08feb11 bug20020 removing a defpatch here from 8.2

#+use-in-case-mode
(excl::in-case-mode :ww)

;; Copy of cbind/cdbind.cl
;;
(eval-when (load compile eval)
  ;; poor man's require
  (unless (fboundp (find-symbol (string :bind-c-constant) 'ff))
    (load (compile-file-if-needed "cdbind.cl"))))

(defpackage :gtk
  #+use-in-case-mode (:mode :independent)
  (:use common-lisp)
  (:import-from :excl :if* :then :else :elseif :thenret))

(in-package :gtk)

;; Have not yet figured out what determines this value
(defvar gpointer-to-string-ef :default)

#+linuxppc (setq gpointer-to-string-ef :fat)

(eval-when (compile load eval)
  (export 'gpointer-to-string-ef))

#+ignore
(eval-when (load)
  (unless (eq #.excl:*current-case-mode* excl:*current-case-mode*)
    (with-simple-restart (continue-loading-file "Continue loading the file.")
      (error "~
The current case mode does not match that used when compiling this file.  ~
Continuing to load this file may result in inconsistent definitions.  ~
Recompilation is recommended."))))

#+removed
(defmacro skip-in-ansi-mode (name type
			     &body body)
  (if* (eq ':case-insensitive-upper
	   excl:*current-case-mode*)
     then `(warn "~
The ~a definition for ~s is being skipped in ANSI mode because this ~
definition conflicts with another definition whose name differs only by case."
		 ',type ',name)
     else `(progn
	     ,@body)))

;; Copied from cbind/cmnbind.cl.
;; Should this be in cdbind.cl?
(in-package :ff)

;;; chee   15jan09 bug18243 remove this auto-generated definition that
;;;        inadvertently wiped out the CL boolean type
#+removed
(def-foreign-type boolean :int)

(def-foreign-type hold    ;;; <60> holder for unsigned conversions
    (:union 
     (signed-long :long)
     (unsigned-long :unsigned-long)
     (short-holder (:struct (dummy-short :short) (unsigned-short :short)))
     (byte-holder (:struct (dummy-bytes (:array :char 3)) 
			   (unsigned-byte :unsigned-char)))))

;;; chee   20aug07 bug17351 use :nat rather than :int for pointer
;;;        return values, to work on 64-bit platforms
(eval-when (compile load eval)

  (def-fwrapper bind-c-function-char*-wrapper (&rest args)
    (declare (ignore args))
    (let* ((result (call-next-fwrapper))
	   (nresult nil))
      (dolist (r result)
	(if* (and (listp r)
		  (eq 'ff:def-foreign-call (car r)))
	   then ;; First, we change any arguments specified as (x (* :char))
		;; to (x (* :char)
		;;       (or string (array (unsigned-byte 8) (*)) integer))
		;;
		(let ((args (third r))
		      (nargs nil))
		  (dolist (arg args)
		    (if* (and (listp arg)
			      (equal '(* :char) (second arg))
			      (null (rest (rest arg))))
		       then ;; We have (x (* :char)).
			    ;; Change it to
			    ;; (x (* :char)
			    ;;    (or string
			    ;;        (array (unsigned-byte 8) (*))
			    ;;        integer))
			    (push (list (first arg)
					(second arg)
					'(or string
					  (array (unsigned-byte 8) (*))
					  integer))
				  nargs)
		       else (push arg nargs)))
		  (setq nargs (nreverse nargs))
		  (push (cons (first r)
			      (cons (second r)
				    (cons nargs
					  (rest (rest (rest r))))))
			nresult))
		;; Now we change any pointer return-types to return :nat
		;; because some of the functions returning char* are not
		;; actually returning strings.
		(do ((nlist (car nresult) (cdr nlist)))
		    ((null nlist))
		  (when (eq ':returning (car nlist))
		    (let ((return-type (cadr nlist)))
		      (when (and (listp return-type)
				 (listp (car return-type))
				 (eq '* (caar return-type))
				 (null (cdr return-type)))
			(setf (cadr nlist) :nat))) ;; bug17351
		    (return)))
	   else (push r nresult)))
      (setq nresult (nreverse nresult))
      nresult))

  (fwrap 'ff:bind-c-function :bind-c-function-char*-wrapper
	 'bind-c-function-char*-wrapper)
  )

(cl:in-package #:gtk)


;; ---------------------------------------------------

;; /usr/include/iso/stddef_iso.h:53 <1> typedef int ptrdiff_t;
(ff:bind-c-type ptrdiff_t :int)  

;; /usr/include/iso/stddef_iso.h:62 <2> typedef unsigned int size_t;
(ff:bind-c-type size_t :unsigned-int)  

;; ---------------------------------------------------

;; /usr/include/stddef.h:39 <3> typedef long wchar_t;
(ff:bind-c-type wchar_t :long)  

;; ---------------------------------------------------

;; /usr/include/float.h:25 <4> extern int __flt_rounds( void);
(ff:bind-c-function __flt_rounds
     :unconverted-entry-name "__flt_rounds"
     :c-modifiers ("extern")
     :c-return-type ("int")
     :return-type :int
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:36 <5> 
;; typedef signed char gint8;
(ff:bind-c-type gint8 :char)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:37 <6> 
;; typedef unsigned char guint8;
(ff:bind-c-type guint8 :unsigned-char)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:38 <7> 
;; typedef signed short gint16;
(ff:bind-c-type gint16 :short)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:39 <8> 
;; typedef unsigned short guint16;
(ff:bind-c-type guint16 :unsigned-short)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:42 <9> 
;; typedef signed int gint32;
(ff:bind-c-type gint32 :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:43 <10> 
;; typedef unsigned int guint32;
(ff:bind-c-type guint32 :unsigned-int)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:48 <11> 
;; typedef signed long long gint64;

;;WARNING:  'long long' is implemented as a struct of 2 long!
(ff:bind-c-type gint64 ff:long-long)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:49 <12> 
;; typedef unsigned long long guint64;

;;WARNING:  'long long' is implemented as a struct of 2 long!
(ff:bind-c-type guint64 ff:unsigned-long-long)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:59 <13> 
;; typedef gint32 gssize;
(ff:bind-c-type gssize gint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:60 <14> 
;; typedef guint32 gsize;
(ff:bind-c-type gsize guint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:111 <15> 
;; typedef struct _GStaticMutex GStaticMutex;
(ff:bind-c-typedef _GStaticMutex
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStaticMutex _GStaticMutex)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:112 <16> 
;; struct _GStaticMutex {
;;         struct _GMutex* runtime_mutex; union {
;;         char pad[  0x000000018]; double dummy_double; void*
;;   dummy_pointer; long
;;    dummy_long; } static_mutex; };
(ff:bind-c-type _GStaticMutex (:struct
  (runtime_mutex (* _GMutex))   ;; struct _GMutex* runtime_mutex
  (static_mutex (:union   ;; union{} static_mutex
    (pad (:array :char 24))   ;; char pad[  0x000000018]
    (dummy_double :double)   ;; double dummy_double
    (dummy_pointer (* :void))   ;; void* dummy_pointer
    (dummy_long :long)   ;; long dummy_long
    ))  ;; slot static_mutex
  ))   ;; bind-c-type _GStaticMutex
(ff:bind-c-typedef GStaticMutex _GStaticMutex) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:128 <17> 
;; typedef union _GSystemThread GSystemThread;
(ff:bind-c-typedef _GSystemThread
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSystemThread _GSystemThread)  

;; /net/fritter/home/cox/gtk2/fritter/i/lib/glib-2.0/include/glibconfig.h:129 <18> 
;; union _GSystemThread {
;;         char data[  0x000000004]; double dummy_double; void*
;;   dummy_pointer; long
;;    dummy_long; };
(ff:bind-c-type _GSystemThread (:union
  (data (:array :char 4))   ;; char data[  0x000000004]
  (dummy_double :double)   ;; double dummy_double
  (dummy_pointer (* :void))   ;; void* dummy_pointer
  (dummy_long :long)   ;; long dummy_long
  ))   ;; bind-c-type _GSystemThread
(ff:bind-c-typedef GSystemThread _GSystemThread) ;;  final declaration 

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:41 <19> 
;; typedef char gchar;
(ff:bind-c-type gchar :char)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:42 <20> 
;; typedef short gshort;
(ff:bind-c-type gshort :short)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:43 <21> 
;; typedef long glong;
(ff:bind-c-type glong :long)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:44 <22> 
;; typedef int gint;
(ff:bind-c-type gint :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:45 <23> 
;; typedef gint gboolean;
(ff:bind-c-type gboolean gint)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:47 <24> 
;; typedef unsigned char guchar;
(ff:bind-c-type guchar :unsigned-char)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:48 <25> 
;; typedef unsigned short gushort;
(ff:bind-c-type gushort :unsigned-short)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:49 <26> 
;; typedef unsigned long gulong;
(ff:bind-c-type gulong :unsigned-long)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:50 <27> 
;; typedef unsigned int guint;
(ff:bind-c-type guint :unsigned-int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:52 <28> 
;; typedef float gfloat;
(ff:bind-c-type gfloat :float)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:53 <29> 
;; typedef double gdouble;
(ff:bind-c-type gdouble :double)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:66 <30> 
;; typedef void* gpointer;
(ff:bind-c-type gpointer (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:67 <31> 
;; typedef const void* gconstpointer;
(ff:bind-c-type gconstpointer (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:69 <32> 
;; typedef gint(* GCompareFunc)( gconstpointer a, gconstpointer b);
(ff:bind-c-type GCompareFunc (* gint))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:71 <33> 
;; typedef gint(* GCompareDataFunc)( gconstpointer a, gconstpointer b,
;;   gpointer
;;    user_data);
(ff:bind-c-type GCompareDataFunc (* gint))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:74 <34> 
;; typedef gboolean(* GEqualFunc)( gconstpointer a, gconstpointer b);
(ff:bind-c-type GEqualFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:76 <35> 
;; typedef void(* GDestroyNotify)( gpointer data);
(ff:bind-c-type GDestroyNotify (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:77 <36> 
;; typedef void(* GFunc)( gpointer data, gpointer user_data);
(ff:bind-c-type GFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:79 <37> 
;; typedef guint(* GHashFunc)( gconstpointer key);
(ff:bind-c-type GHashFunc (* guint))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:80 <38> 
;; typedef void(* GHFunc)( gpointer key, gpointer value, gpointer user_data
;;   );
(ff:bind-c-type GHFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:83 <39> 
;; typedef void(* GFreeFunc)( gpointer data);
(ff:bind-c-type GFreeFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:262 <40> 
;; typedef union _GDoubleIEEE754 GDoubleIEEE754;
(ff:bind-c-typedef _GDoubleIEEE754
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GDoubleIEEE754 _GDoubleIEEE754)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:263 <41> 
;; typedef union _GFloatIEEE754 GFloatIEEE754;
(ff:bind-c-typedef _GFloatIEEE754
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GFloatIEEE754 _GFloatIEEE754)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:289 <42> 
;; union _GFloatIEEE754 {
;;         gfloat v_float; struct {
;;         guint sign:  0x000000001; guint biased_exponent:  0x000000008;
;;   guint mantissa
;;   :  0x000000017; } mpn; };

;;WARNING: Strange bitfield sign type (guint) will be retrieved as an unsigned integer.

;;WARNING: Bitfield alignment may not match your compiler's

;;WARNING: Strange bitfield biased_exponent type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield mantissa type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GFloatIEEE754 (:union
  (v_float gfloat)   ;; gfloat v_float
  (mpn (:struct   ;; struct{} mpn
    (sign (:bit 1))   ;; guint sign:  0x000000001
    (biased_exponent (:bit 8))   ;; guint biased_exponent:  0x000000008
    (mantissa (:bit 23))   ;; guint mantissa:  0x000000017
    ))  ;; slot mpn
  ))   ;; bind-c-type _GFloatIEEE754
(ff:bind-c-typedef GFloatIEEE754 _GFloatIEEE754) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:298 <43> 
;; union _GDoubleIEEE754 {
;;         gdouble v_double; struct {
;;         guint sign:  0x000000001; guint biased_exponent:  0x00000000b;
;;   guint mantissa_high
;;   :  0x000000014; guint mantissa_low:  0x000000020; } mpn; };

;;WARNING: Strange bitfield sign type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield biased_exponent type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield mantissa_high type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield mantissa_low type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GDoubleIEEE754 (:union
  (v_double gdouble)   ;; gdouble v_double
  (mpn (:struct   ;; struct{} mpn
    (sign (:bit 1))   ;; guint sign:  0x000000001
    (biased_exponent (:bit 11))   ;; guint biased_exponent:  0x00000000b
    (mantissa_high (:bit 20))   ;; guint mantissa_high:  0x000000014
    (mantissa_low (:bit 32))   ;; guint mantissa_low:  0x000000020
    ))  ;; slot mpn
  ))   ;; bind-c-type _GDoubleIEEE754
(ff:bind-c-typedef GDoubleIEEE754
                   _GDoubleIEEE754) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:312 <44> 
;; typedef struct _GTimeVal GTimeVal;
(ff:bind-c-typedef _GTimeVal
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTimeVal _GTimeVal)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtypes.h:314 <45> 
;; struct _GTimeVal { glong tv_sec; glong tv_usec; };
(ff:bind-c-type _GTimeVal (:struct
  (tv_sec glong)   ;; glong tv_sec
  (tv_usec glong)   ;; glong tv_usec
  ))   ;; bind-c-type _GTimeVal
(ff:bind-c-typedef GTimeVal _GTimeVal) ;;  final declaration 

;; ---------------------------------------------------

;; /usr/include/sys/machtypes.h:33 <46> 
;; typedef struct _label_t { long val[  0x000000002]; } label_t;
(ff:bind-c-type _label_t (:struct
  (val (:array :long 2))   ;; long val[  0x000000002]
  ))   ;; bind-c-type _label_t
(ff:bind-c-type label_t _label_t)  

;; /usr/include/sys/machtypes.h:37 <47> typedef unsigned char lock_t;
(ff:bind-c-type lock_t :unsigned-char)  

;; ---------------------------------------------------

;; /usr/include/sys/int_types.h:62 <48> typedef char int8_t;
(ff:bind-c-type int8_t :char)  

;; /usr/include/sys/int_types.h:68 <49> typedef short int16_t;
(ff:bind-c-type int16_t :short)  

;; /usr/include/sys/int_types.h:69 <50> typedef int int32_t;
(ff:bind-c-type int32_t :int)  

;; /usr/include/sys/int_types.h:78 <51> typedef unsigned char uint8_t;
(ff:bind-c-type uint8_t :unsigned-char)  

;; /usr/include/sys/int_types.h:79 <52> typedef unsigned short uint16_t;
(ff:bind-c-type uint16_t :unsigned-short)  

;; /usr/include/sys/int_types.h:80 <53> typedef unsigned int uint32_t;
(ff:bind-c-type uint32_t :unsigned-int)  

;; /usr/include/sys/int_types.h:97 <54> typedef int32_t intmax_t;
(ff:bind-c-type intmax_t int32_t)  

;; /usr/include/sys/int_types.h:98 <55> typedef uint32_t uintmax_t;
(ff:bind-c-type uintmax_t uint32_t)  

;; /usr/include/sys/int_types.h:110 <56> typedef int intptr_t;
(ff:bind-c-type intptr_t :int)  

;; /usr/include/sys/int_types.h:111 <57> typedef unsigned int uintptr_t;
(ff:bind-c-type uintptr_t :unsigned-int)  

;; /usr/include/sys/int_types.h:119 <58> typedef char int_least8_t;
(ff:bind-c-type int_least8_t :char)  

;; /usr/include/sys/int_types.h:125 <59> typedef short int_least16_t;
(ff:bind-c-type int_least16_t :short)  

;; /usr/include/sys/int_types.h:126 <60> typedef int int_least32_t;
(ff:bind-c-type int_least32_t :int)  

;; /usr/include/sys/int_types.h:135 <61> 
;; typedef unsigned char uint_least8_t;
(ff:bind-c-type uint_least8_t :unsigned-char)  

;; /usr/include/sys/int_types.h:136 <62> 
;; typedef unsigned short uint_least16_t;
(ff:bind-c-type uint_least16_t :unsigned-short)  

;; /usr/include/sys/int_types.h:137 <63> 
;; typedef unsigned int uint_least32_t;
(ff:bind-c-type uint_least32_t :unsigned-int)  

;; ---------------------------------------------------

;; /usr/include/sys/types.h:57 <64> 
;; typedef union { double _d; int32_t _l[  0x000000002]; } longlong_t;
(ff:bind-c-type longlong_t (:union
  (_d :double)   ;; double _d
  (_l (:array int32_t 2))   ;; int32_t _l[  0x000000002]
  ))   ;; bind-c-type longlong_t

;; /usr/include/sys/types.h:61 <65> 
;; typedef union { double _d; uint32_t _l[  0x000000002]; } u_longlong_t;
(ff:bind-c-type u_longlong_t (:union
  (_d :double)   ;; double _d
  (_l (:array uint32_t 2))   ;; uint32_t _l[  0x000000002]
  ))   ;; bind-c-type u_longlong_t

;; /usr/include/sys/types.h:76 <66> typedef long t_scalar_t;
(ff:bind-c-type t_scalar_t :long)  

;; /usr/include/sys/types.h:77 <67> typedef unsigned long t_uscalar_t;
(ff:bind-c-type t_uscalar_t :unsigned-long)  

;; /usr/include/sys/types.h:83 <68> typedef unsigned char uchar_t;
(ff:bind-c-type uchar_t :unsigned-char)  

;; /usr/include/sys/types.h:84 <69> typedef unsigned short ushort_t;
(ff:bind-c-type ushort_t :unsigned-short)  

;; /usr/include/sys/types.h:85 <70> typedef unsigned int uint_t;
(ff:bind-c-type uint_t :unsigned-int)  

;; /usr/include/sys/types.h:86 <71> typedef unsigned long ulong_t;
(ff:bind-c-type ulong_t :unsigned-long)  

;; /usr/include/sys/types.h:88 <72> typedef char* caddr_t;
(ff:bind-c-type caddr_t (* :char))  

;; /usr/include/sys/types.h:89 <73> typedef long daddr_t;
(ff:bind-c-type daddr_t :long)  

;; /usr/include/sys/types.h:90 <74> typedef short cnt_t;
(ff:bind-c-type cnt_t :short)  

;; /usr/include/sys/types.h:93 <75> typedef ulong_t paddr_t;
(ff:bind-c-type paddr_t ulong_t)  

;; /usr/include/sys/types.h:110 <76> typedef ulong_t pfn_t;
(ff:bind-c-type pfn_t ulong_t)  

;; /usr/include/sys/types.h:111 <77> typedef ulong_t pgcnt_t;
(ff:bind-c-type pgcnt_t ulong_t)  

;; /usr/include/sys/types.h:112 <78> typedef long spgcnt_t;
(ff:bind-c-type spgcnt_t :long)  

;; /usr/include/sys/types.h:114 <79> typedef uchar_t use_t;
(ff:bind-c-type use_t uchar_t)  

;; /usr/include/sys/types.h:115 <80> typedef short sysid_t;
(ff:bind-c-type sysid_t :short)  

;; /usr/include/sys/types.h:116 <81> typedef short index_t;
(ff:bind-c-type index_t :short)  

;; /usr/include/sys/types.h:117 <82> typedef void* timeout_id_t;
(ff:bind-c-type timeout_id_t (* :void))  

;; /usr/include/sys/types.h:118 <83> typedef void* bufcall_id_t;
(ff:bind-c-type bufcall_id_t (* :void))  

;; /usr/include/sys/types.h:132 <84> typedef long off_t;
(ff:bind-c-type off_t :long)  

;; /usr/include/sys/types.h:148 <85> typedef ulong_t ino_t;
(ff:bind-c-type ino_t ulong_t)  

;; /usr/include/sys/types.h:149 <86> typedef long blkcnt_t;
(ff:bind-c-type blkcnt_t :long)  

;; /usr/include/sys/types.h:150 <87> typedef ulong_t fsblkcnt_t;
(ff:bind-c-type fsblkcnt_t ulong_t)  

;; /usr/include/sys/types.h:151 <88> typedef ulong_t fsfilcnt_t;
(ff:bind-c-type fsfilcnt_t ulong_t)  

;; /usr/include/sys/types.h:176 <89> typedef long blksize_t;
(ff:bind-c-type blksize_t :long)  

;; /usr/include/sys/types.h:182 <90> 
;; typedef enum { B_FALSE, B_TRUE } boolean_t;
(ff:bind-c-constant B_FALSE 0) ;;  B_FALSE 
(ff:bind-c-constant B_TRUE 1) ;;  B_TRUE 
(ff:bind-c-type boolean_t :int)  

;; /usr/include/sys/types.h:196 <91> 
;; typedef union { double _d; int32_t _l[  0x000000002]; } pad64_t;
(ff:bind-c-type pad64_t (:union
  (_d :double)   ;; double _d
  (_l (:array int32_t 2))   ;; int32_t _l[  0x000000002]
  ))   ;; bind-c-type pad64_t

;; /usr/include/sys/types.h:200 <92> 
;; typedef union { double _d; uint32_t _l[  0x000000002]; } upad64_t;
(ff:bind-c-type upad64_t (:union
  (_d :double)   ;; double _d
  (_l (:array uint32_t 2))   ;; uint32_t _l[  0x000000002]
  ))   ;; bind-c-type upad64_t

;; /usr/include/sys/types.h:206 <93> typedef longlong_t offset_t;
(ff:bind-c-type offset_t longlong_t)  

;; /usr/include/sys/types.h:207 <94> typedef u_longlong_t u_offset_t;
(ff:bind-c-type u_offset_t u_longlong_t)  

;; /usr/include/sys/types.h:208 <95> typedef u_longlong_t len_t;
(ff:bind-c-type len_t u_longlong_t)  

;; /usr/include/sys/types.h:209 <96> typedef longlong_t diskaddr_t;
(ff:bind-c-type diskaddr_t longlong_t)  

;; /usr/include/sys/types.h:227 <97> 
;; typedef union {
;;         offset_t _f; struct {
;;         int32_t _u; int32_t _l; } _p; } lloff_t;
(ff:bind-c-type lloff_t (:union
  (_f offset_t)   ;; offset_t _f
  (_p (:struct   ;; struct{} _p
    (_u int32_t)   ;; int32_t _u
    (_l int32_t)   ;; int32_t _l
    ))  ;; slot _p
  ))   ;; bind-c-type lloff_t

;; /usr/include/sys/types.h:247 <98> 
;; typedef union {
;;         diskaddr_t _f; struct {
;;         int32_t _u; int32_t _l; } _p; } lldaddr_t;
(ff:bind-c-type lldaddr_t (:union
  (_f diskaddr_t)   ;; diskaddr_t _f
  (_p (:struct   ;; struct{} _p
    (_u int32_t)   ;; int32_t _u
    (_l int32_t)   ;; int32_t _l
    ))  ;; slot _p
  ))   ;; bind-c-type lldaddr_t

;; /usr/include/sys/types.h:256 <99> typedef uint_t k_fltset_t;
(ff:bind-c-type k_fltset_t uint_t)  

;; /usr/include/sys/types.h:270 <100> typedef long id_t;
(ff:bind-c-type id_t :long)  

;; /usr/include/sys/types.h:277 <101> typedef uint_t useconds_t;
(ff:bind-c-type useconds_t uint_t)  

;; /usr/include/sys/types.h:281 <102> typedef long suseconds_t;
(ff:bind-c-type suseconds_t :long)  

;; /usr/include/sys/types.h:291 <103> typedef ulong_t major_t;
(ff:bind-c-type major_t ulong_t)  

;; /usr/include/sys/types.h:292 <104> typedef ulong_t minor_t;
(ff:bind-c-type minor_t ulong_t)  

;; /usr/include/sys/types.h:298 <105> typedef short pri_t;
(ff:bind-c-type pri_t :short)  

;; /usr/include/sys/types.h:311 <106> typedef ushort_t o_mode_t;
(ff:bind-c-type o_mode_t ushort_t)  

;; /usr/include/sys/types.h:312 <107> typedef short o_dev_t;
(ff:bind-c-type o_dev_t :short)  

;; /usr/include/sys/types.h:313 <108> typedef ushort_t o_uid_t;
(ff:bind-c-type o_uid_t ushort_t)  

;; /usr/include/sys/types.h:314 <109> typedef o_uid_t o_gid_t;
(ff:bind-c-type o_gid_t o_uid_t)  

;; /usr/include/sys/types.h:315 <110> typedef short o_nlink_t;
(ff:bind-c-type o_nlink_t :short)  

;; /usr/include/sys/types.h:316 <111> typedef short o_pid_t;
(ff:bind-c-type o_pid_t :short)  

;; /usr/include/sys/types.h:317 <112> typedef ushort_t o_ino_t;
(ff:bind-c-type o_ino_t ushort_t)  

;; /usr/include/sys/types.h:323 <113> typedef int key_t;
(ff:bind-c-type key_t :int)  

;; /usr/include/sys/types.h:327 <114> typedef ulong_t mode_t;
(ff:bind-c-type mode_t ulong_t)  

;; /usr/include/sys/types.h:335 <115> typedef long uid_t;
(ff:bind-c-type uid_t :long)  

;; /usr/include/sys/types.h:339 <116> typedef uid_t gid_t;
(ff:bind-c-type gid_t uid_t)  

;; /usr/include/sys/types.h:341 <117> typedef id_t taskid_t;
(ff:bind-c-type taskid_t id_t)  

;; /usr/include/sys/types.h:342 <118> typedef id_t projid_t;
(ff:bind-c-type projid_t id_t)  

;; /usr/include/sys/types.h:349 <119> typedef unsigned int pthread_t;
(ff:bind-c-type pthread_t :unsigned-int)  

;; /usr/include/sys/types.h:350 <120> typedef unsigned int pthread_key_t;
(ff:bind-c-type pthread_key_t :unsigned-int)  

;; /usr/include/sys/types.h:352 <121> 
;; typedef struct _pthread_mutex {
;;         struct {
;;         uint16_t __pthread_mutex_flag1; uint8_t __pthread_mutex_flag2;
;;   uint8_t
;;    __pthread_mutex_ceiling; uint32_t __pthread_mutex_type; }
;;   __pthread_mutex_flags;
;;              union {
;;         struct {
;;         uint8_t __pthread_mutex_pad[  0x000000008]; }
;;   __pthread_mutex_lock64;
;;              upad64_t __pthread_mutex_owner64; } __pthread_mutex_lock;
;;   upad64_t __pthread_mutex_data;
;;    } pthread_mutex_t;
(ff:bind-c-type _pthread_mutex (:struct
  (__pthread_mutex_flags (:struct   ;; struct{} __pthread_mutex_flags
    (__pthread_mutex_flag1 uint16_t)   ;; uint16_t __pthread_mutex_flag1
    (__pthread_mutex_flag2 uint8_t)   ;; uint8_t __pthread_mutex_flag2
    (__pthread_mutex_ceiling uint8_t)   ;; uint8_t __pthread_mutex_ceiling
    (__pthread_mutex_type uint32_t)   ;; uint32_t __pthread_mutex_type
    ))  ;; slot __pthread_mutex_flags
  (__pthread_mutex_lock (:union   ;; union{} __pthread_mutex_lock
    (__pthread_mutex_lock64 (:struct   ;; struct{} __pthread_mutex_lock64
      (__pthread_mutex_pad (:array uint8_t
                            8))   ;;
      ;;  uint8_t __pthread_mutex_pad[  0x000000008]
      ))  ;; slot __pthread_mutex_lock64
    (__pthread_mutex_owner64 upad64_t)   ;;
    ;;  upad64_t __pthread_mutex_owner64
    ))  ;; slot __pthread_mutex_lock
  (__pthread_mutex_data upad64_t)   ;; upad64_t __pthread_mutex_data
  ))   ;; bind-c-type _pthread_mutex
(ff:bind-c-type pthread_mutex_t _pthread_mutex)  

;; /usr/include/sys/types.h:368 <122> 
;; typedef struct _pthread_cond {
;;         struct {
;;         uint8_t __pthread_cond_flag[  0x000000004]; uint32_t
;;   __pthread_cond_type;
;;    } __pthread_cond_flags; upad64_t __pthread_cond_data; }
;;   pthread_cond_t
;;   ;
(ff:bind-c-type _pthread_cond (:struct
  (__pthread_cond_flags (:struct   ;; struct{} __pthread_cond_flags
    (__pthread_cond_flag (:array uint8_t
                          4))   ;;
    ;;  uint8_t __pthread_cond_flag[  0x000000004]
    (__pthread_cond_type uint32_t)   ;; uint32_t __pthread_cond_type
    ))  ;; slot __pthread_cond_flags
  (__pthread_cond_data upad64_t)   ;; upad64_t __pthread_cond_data
  ))   ;; bind-c-type _pthread_cond
(ff:bind-c-type pthread_cond_t _pthread_cond)  

;; /usr/include/sys/types.h:379 <123> 
;; typedef struct _pthread_rwlock {
;;         int32_t __pthread_rwlock_readers; uint16_t
;;   __pthread_rwlock_type; uint16_t
;;    __pthread_rwlock_magic; upad64_t __pthread_rwlock_pad1[
;;   0x000000003];
;;              upad64_t __pthread_rwlock_pad2[  0x000000002]; upad64_t
;;   __pthread_rwlock_pad3
;;   [  0x000000002]; } pthread_rwlock_t;
(ff:bind-c-type _pthread_rwlock (:struct
  (__pthread_rwlock_readers int32_t)   ;; int32_t __pthread_rwlock_readers
  (__pthread_rwlock_type uint16_t)   ;; uint16_t __pthread_rwlock_type
  (__pthread_rwlock_magic uint16_t)   ;; uint16_t __pthread_rwlock_magic
  (__pthread_rwlock_pad1 (:array upad64_t
                          3))   ;;
  ;;  upad64_t __pthread_rwlock_pad1[  0x000000003]
  (__pthread_rwlock_pad2 (:array upad64_t
                          2))   ;;
  ;;  upad64_t __pthread_rwlock_pad2[  0x000000002]
  (__pthread_rwlock_pad3 (:array upad64_t
                          2))   ;;
  ;;  upad64_t __pthread_rwlock_pad3[  0x000000002]
  ))   ;; bind-c-type _pthread_rwlock
(ff:bind-c-type pthread_rwlock_t _pthread_rwlock)  

;; /usr/include/sys/types.h:391 <124> 
;; typedef struct _pthread_attr { void* __pthread_attrp; } pthread_attr_t;
(ff:bind-c-type _pthread_attr (:struct
  (__pthread_attrp (* :void))   ;; void* __pthread_attrp
  ))   ;; bind-c-type _pthread_attr
(ff:bind-c-type pthread_attr_t _pthread_attr)  

;; /usr/include/sys/types.h:399 <125> 
;; typedef struct _pthread_mutexattr {
;;         void* __pthread_mutexattrp; } pthread_mutexattr_t;
(ff:bind-c-type _pthread_mutexattr (:struct
  (__pthread_mutexattrp (* :void))   ;; void* __pthread_mutexattrp
  ))   ;; bind-c-type _pthread_mutexattr
(ff:bind-c-type pthread_mutexattr_t _pthread_mutexattr)  

;; /usr/include/sys/types.h:407 <126> 
;; typedef struct _pthread_condattr {
;;         void* __pthread_condattrp; } pthread_condattr_t;
(ff:bind-c-type _pthread_condattr (:struct
  (__pthread_condattrp (* :void))   ;; void* __pthread_condattrp
  ))   ;; bind-c-type _pthread_condattr
(ff:bind-c-type pthread_condattr_t _pthread_condattr)  

;; /usr/include/sys/types.h:414 <127> 
;; typedef struct _once {
;;         upad64_t __pthread_once_pad[  0x000000004]; } pthread_once_t;
(ff:bind-c-type _once (:struct
  (__pthread_once_pad (:array upad64_t
                       4))   ;;
  ;;  upad64_t __pthread_once_pad[  0x000000004]
  ))   ;; bind-c-type _once
(ff:bind-c-type pthread_once_t _once)  

;; /usr/include/sys/types.h:422 <128> 
;; typedef struct _pthread_rwlockattr {
;;         void* __pthread_rwlockattrp; } pthread_rwlockattr_t;
(ff:bind-c-type _pthread_rwlockattr (:struct
  (__pthread_rwlockattrp (* :void))   ;; void* __pthread_rwlockattrp
  ))   ;; bind-c-type _pthread_rwlockattr
(ff:bind-c-type pthread_rwlockattr_t _pthread_rwlockattr)  

;; /usr/include/sys/types.h:426 <129> typedef ulong_t dev_t;
(ff:bind-c-type dev_t ulong_t)  

;; /usr/include/sys/types.h:432 <130> typedef ulong_t nlink_t;
(ff:bind-c-type nlink_t ulong_t)  

;; /usr/include/sys/types.h:433 <131> typedef long pid_t;
(ff:bind-c-type pid_t :long)  

;; /usr/include/sys/types.h:450 <132> typedef int ssize_t;
(ff:bind-c-type ssize_t :int)  

;; /usr/include/sys/types.h:456 <133> typedef long time_t;
(ff:bind-c-type time_t :long)  

;; /usr/include/sys/types.h:461 <134> typedef long clock_t;
(ff:bind-c-type clock_t :long)  

;; /usr/include/sys/types.h:466 <135> typedef int clockid_t;
(ff:bind-c-type clockid_t :int)  

;; /usr/include/sys/types.h:471 <136> typedef int timer_t;
(ff:bind-c-type timer_t :int)  

;; /usr/include/sys/types.h:478 <137> typedef unsigned char unchar;
(ff:bind-c-type unchar :unsigned-char)  

;; /usr/include/sys/types.h:479 <138> typedef unsigned short ushort;
(ff:bind-c-type ushort :unsigned-short)  

;; /usr/include/sys/types.h:480 <139> typedef unsigned int uint;
(ff:bind-c-type uint :unsigned-int)  

;; /usr/include/sys/types.h:481 <140> typedef unsigned long ulong;
(ff:bind-c-type ulong :unsigned-long)  

;; /usr/include/sys/types.h:532 <141> typedef unsigned char u_char;
(ff:bind-c-type u_char :unsigned-char)  

;; /usr/include/sys/types.h:533 <142> typedef unsigned short u_short;
(ff:bind-c-type u_short :unsigned-short)  

;; /usr/include/sys/types.h:534 <143> typedef unsigned int u_int;
(ff:bind-c-type u_int :unsigned-int)  

;; /usr/include/sys/types.h:535 <144> typedef unsigned long u_long;
(ff:bind-c-type u_long :unsigned-long)  

;; /usr/include/sys/types.h:536 <145> 
;; typedef struct _quad { int val[  0x000000002]; } quad_t;
(ff:bind-c-type _quad (:struct
  (val (:array :int 2))   ;; int val[  0x000000002]
  ))   ;; bind-c-type _quad
(ff:bind-c-type quad_t _quad)  

;; /usr/include/sys/types.h:537 <146> typedef quad_t quad;
(ff:bind-c-type quad quad_t)  

;; ---------------------------------------------------

;; /usr/include/sys/time.h:49 <147> 
;; struct timeval { time_t tv_sec; suseconds_t tv_usec; };
(ff:bind-c-type timeval (:struct
  (tv_sec time_t)   ;; time_t tv_sec
  (tv_usec suseconds_t)   ;; suseconds_t tv_usec
  ))   ;; bind-c-type timeval

;; /usr/include/sys/time.h:82 <148> 
;; struct timezone { int tz_minuteswest; int tz_dsttime; };
(ff:bind-c-type timezone (:struct
  (tz_minuteswest :int)   ;; int tz_minuteswest
  (tz_dsttime :int)   ;; int tz_dsttime
  ))   ;; bind-c-type timezone

;; /usr/include/sys/time.h:155 <149> 
;; struct itimerval {
;;         struct timeval it_interval; struct timeval it_value; };
(ff:bind-c-type itimerval (:struct
  (it_interval timeval)   ;; struct timeval it_interval
  (it_value timeval)   ;; struct timeval it_value
  ))   ;; bind-c-type itimerval

;; /usr/include/sys/time.h:203 <150> typedef longlong_t hrtime_t;
(ff:bind-c-type hrtime_t longlong_t)  

;; /usr/include/sys/time.h:318 <151> 
;; int adjtime( struct timeval*, struct timeval*);
(ff:bind-c-function adjtime
     :unconverted-entry-name "adjtime"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("struct" "timeval" "*") ("struct" "timeval" "*"))
     :c-arg-names (Arg0 Arg1)
     :arguments ((* timeval) (* timeval))
     :strings-convert t
     )

;; /usr/include/sys/time.h:329 <152> 
;; int getitimer( int, struct itimerval*);
(ff:bind-c-function getitimer
     :unconverted-entry-name "getitimer"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("int") ("struct" "itimerval" "*"))
     :c-arg-names (Arg0 Arg1)
     :arguments (:int (* itimerval))
     :strings-convert t
     )

;; /usr/include/sys/time.h:330 <153> 
;; int utimes( const char*, const struct timeval*);
(ff:bind-c-function utimes
     :unconverted-entry-name "utimes"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("const" "char" "*")
                   ("const" "struct" "timeval" "*"))
     :c-arg-names (Arg0 Arg1)
     :arguments ((* :char) (* timeval))
     :strings-convert t
     )

;; /usr/include/sys/time.h:334 <154> 
;; int setitimer( int, struct itimerval*, struct itimerval*);
(ff:bind-c-function setitimer
     :unconverted-entry-name "setitimer"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("int") ("struct" "itimerval" "*")
                   ("struct" "itimerval" "*"))
     :c-arg-names (Arg0 Arg1 Arg2)
     :arguments (:int (* itimerval) (* itimerval))
     :strings-convert t
     )

;; /usr/include/sys/time.h:367 <155> 
;; int settimeofday( struct timeval*, void*);
(ff:bind-c-function settimeofday
     :unconverted-entry-name "settimeofday"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("struct" "timeval" "*") ("void" "*"))
     :c-arg-names (Arg0 Arg1)
     :arguments ((* timeval) (* :void))
     :strings-convert t
     )

;; /usr/include/sys/time.h:369 <156> hrtime_t gethrtime( void);

;;NOTE: C wrapper needed to return structure or union type
;;   hrtime_t.
(ff:bind-c-function gethrtime
     :unconverted-entry-name "ACL_gethrtime"
     :c-return-type ("hrtime_t" "*")
     :return-type (* hrtime_t)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /usr/include/sys/time.h:370 <157> hrtime_t gethrvtime( void);

;;NOTE: C wrapper needed to return structure or union type
;;   hrtime_t.
(ff:bind-c-function gethrvtime
     :unconverted-entry-name "ACL_gethrvtime"
     :c-return-type ("hrtime_t" "*")
     :return-type (* hrtime_t)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /usr/include/sys/time.h:387 <158> 
;; int gettimeofday( struct timeval*, void*);
(ff:bind-c-function gettimeofday
     :unconverted-entry-name "gettimeofday"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("struct" "timeval" "*") ("void" "*"))
     :c-arg-names (Arg0 Arg1)
     :arguments ((* timeval) (* :void))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /usr/include/iso/time_iso.h:69 <159> 
;; struct tm {
;;         int tm_sec; int tm_min; int tm_hour; int tm_mday; int tm_mon;
;;   int tm_year;
;;              int tm_wday; int tm_yday; int tm_isdst; };
(ff:bind-c-type tm (:struct
  (tm_sec :int)   ;; int tm_sec
  (tm_min :int)   ;; int tm_min
  (tm_hour :int)   ;; int tm_hour
  (tm_mday :int)   ;; int tm_mday
  (tm_mon :int)   ;; int tm_mon
  (tm_year :int)   ;; int tm_year
  (tm_wday :int)   ;; int tm_wday
  (tm_yday :int)   ;; int tm_yday
  (tm_isdst :int)   ;; int tm_isdst
  ))   ;; bind-c-type tm

;; /usr/include/iso/time_iso.h:84 <160> 
;; extern char* asctime( const struct tm*);
(ff:bind-c-function asctime
     :unconverted-entry-name "asctime"
     :c-modifiers ("extern")
     :c-return-type ("char" "*")
     :return-type (* :char)
     :c-arg-types (("const" "struct" "tm" "*"))
     :c-arg-names (Arg0)
     :arguments ((* tm))
     :strings-convert t
     )

;; /usr/include/iso/time_iso.h:85 <161> extern clock_t clock( void);
(ff:bind-c-function clock
     :unconverted-entry-name "clock"
     :c-modifiers ("extern")
     :c-return-type ("clock_t")
     :return-type clock_t
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /usr/include/iso/time_iso.h:86 <162> extern char* ctime( const time_t*);
(ff:bind-c-function ctime
     :unconverted-entry-name "ctime"
     :c-modifiers ("extern")
     :c-return-type ("char" "*")
     :return-type (* :char)
     :c-arg-types (("const" "time_t" "*"))
     :c-arg-names (Arg0)
     :arguments ((* time_t))
     :strings-convert t
     )

;; /usr/include/iso/time_iso.h:87 <163> 
;; extern double difftime( time_t, time_t);
(ff:bind-c-function difftime
     :unconverted-entry-name "difftime"
     :c-modifiers ("extern")
     :c-return-type ("double")
     :return-type :double
     :c-arg-types (("time_t") ("time_t"))
     :c-arg-names (Arg0 Arg1)
     :arguments (time_t time_t)
     :strings-convert t
     )

;; /usr/include/iso/time_iso.h:88 <164> 
;; extern struct tm* gmtime( const time_t*);
(ff:bind-c-function gmtime
     :unconverted-entry-name "gmtime"
     :c-modifiers ("extern")
     :c-return-type ("struct" "tm" "*")
     :return-type (* tm)
     :c-arg-types (("const" "time_t" "*"))
     :c-arg-names (Arg0)
     :arguments ((* time_t))
     :strings-convert t
     )

;; /usr/include/iso/time_iso.h:89 <165> 
;; extern struct tm* localtime( const time_t*);
(ff:bind-c-function localtime
     :unconverted-entry-name "localtime"
     :c-modifiers ("extern")
     :c-return-type ("struct" "tm" "*")
     :return-type (* tm)
     :c-arg-types (("const" "time_t" "*"))
     :c-arg-names (Arg0)
     :arguments ((* time_t))
     :strings-convert t
     )

;; /usr/include/iso/time_iso.h:90 <166> extern time_t mktime( struct tm*);
(ff:bind-c-function mktime
     :unconverted-entry-name "mktime"
     :c-modifiers ("extern")
     :c-return-type ("time_t")
     :return-type time_t
     :c-arg-types (("struct" "tm" "*"))
     :c-arg-names (Arg0)
     :arguments ((* tm))
     :strings-convert t
     )

(eval-when (compile load eval)
  (shadow 'time))

;; /usr/include/iso/time_iso.h:91 <167> extern time_t time( time_t*);
(ff:bind-c-function time
     :unconverted-entry-name "time"
     :c-modifiers ("extern")
     :c-return-type ("time_t")
     :return-type time_t
     :c-arg-types (("time_t" "*"))
     :c-arg-names (Arg0)
     :arguments ((* time_t))
     :strings-convert t
     )

;; /usr/include/iso/time_iso.h:92 <168> 
;; extern size_t strftime( char*, size_t, const char*, const struct tm*);
(ff:bind-c-function strftime
     :unconverted-entry-name "strftime"
     :c-modifiers ("extern")
     :c-return-type ("size_t")
     :return-type size_t
     :c-arg-types (("char" "*") ("size_t") ("const" "char" "*")
                   ("const" "struct" "tm" "*"))
     :c-arg-names (Arg0 Arg1 Arg2 Arg3)
     :arguments ((* :char) size_t (* :char) (* tm))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /usr/include/sys/select.h:45 <169> typedef long fd_mask;
(ff:bind-c-type fd_mask :long)  

;; /usr/include/sys/select.h:47 <170> typedef long fds_mask;
(ff:bind-c-type fds_mask :long)  

;; /usr/include/sys/select.h:73 <171> 
;; typedef struct fd_set {
;;         long fds_bits[(((  0x000000400) +((( SIZEOF( fds_mask)*
;;   0x000000008)
;;   ) -  0x000000001)) /(( SIZEOF( fds_mask)*  0x000000008)))]; } fd_set;
(ff:bind-c-type fd_set (:struct
  (fds_bits (:array :long
             16))   ;;
  ;;  long fds_bits[(((  0x000000400) +((( SIZEOF( fds_mask)*  0x000000008)) -  0x000000001
  ;; )) /(( SIZEOF( fds_mask)*  0x000000008)))]
  ))   ;; bind-c-type fd_set

;; /usr/include/sys/select.h:97 <172> 
;; extern int select( int, fd_set*, fd_set*, fd_set*, struct timeval*);
(ff:bind-c-function select
     :unconverted-entry-name "select"
     :c-modifiers ("extern")
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("int") ("fd_set" "*") ("fd_set" "*") ("fd_set" "*")
                   ("struct" "timeval" "*"))
     :c-arg-names (Arg0 Arg1 Arg2 Arg3 Arg4)
     :arguments (:int (* fd_set) (* fd_set) (* fd_set) (* timeval))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /usr/include/alloca.h:38 <173> extern void* __builtin_alloca( size_t);
(ff:bind-c-function __builtin_alloca
     :unconverted-entry-name "__builtin_alloca"
     :c-modifiers ("extern")
     :c-return-type ("void" "*")
     :return-type (* :void)
     :c-arg-types (("size_t"))
     :c-arg-names (Arg0)
     :arguments (size_t)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:34 <174> 
;; typedef struct _GArray GArray;
(ff:bind-c-typedef _GArray
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GArray _GArray)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:35 <175> 
;; typedef struct _GByteArray GByteArray;
(ff:bind-c-typedef _GByteArray
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GByteArray _GByteArray)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:36 <176> 
;; typedef struct _GPtrArray GPtrArray;
(ff:bind-c-typedef _GPtrArray
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GPtrArray _GPtrArray)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:38 <177> 
;; struct _GArray { gchar* data; guint len; };
(ff:bind-c-type _GArray (:struct
  (data (* gchar))   ;; gchar* data
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GArray
(ff:bind-c-typedef GArray _GArray) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:44 <178> 
;; struct _GByteArray { guint8* data; guint len; };
(ff:bind-c-type _GByteArray (:struct
  (data (* guint8))   ;; guint8* data
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GByteArray
(ff:bind-c-typedef GByteArray _GByteArray) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:50 <179> 
;; struct _GPtrArray { gpointer* pdata; guint len; };
(ff:bind-c-type _GPtrArray (:struct
  (pdata (* gpointer))   ;; gpointer* pdata
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GPtrArray
(ff:bind-c-typedef GPtrArray _GPtrArray) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:66 <180> 
;; GArray* g_array_new( gboolean zero_terminated, gboolean clear, guint
;;   element_size
;;   );
(ff:bind-c-function g_array_new
     :unconverted-entry-name "g_array_new"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("gboolean") ("gboolean") ("guint"))
     :c-arg-names (zero_terminated clear element_size)
     :arguments (gboolean gboolean guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:69 <181> 
;; GArray* g_array_sized_new( gboolean zero_terminated, gboolean clear,
;;   guint
;;    element_size, guint reserved_size);
(ff:bind-c-function g_array_sized_new
     :unconverted-entry-name "g_array_sized_new"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("gboolean") ("gboolean") ("guint") ("guint"))
     :c-arg-names (zero_terminated clear element_size reserved_size)
     :arguments (gboolean gboolean guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:73 <182> 
;; gchar* g_array_free( GArray* array, gboolean free_segment);
(ff:bind-c-function g_array_free
     :unconverted-entry-name "g_array_free"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GArray" "*") ("gboolean"))
     :c-arg-names (array free_segment)
     :arguments ((* GArray) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:75 <183> 
;; GArray* g_array_append_vals( GArray* array, gconstpointer data, guint
;;    len);
(ff:bind-c-function g_array_append_vals
     :unconverted-entry-name "g_array_append_vals"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("gconstpointer") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GArray) gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:78 <184> 
;; GArray* g_array_prepend_vals( GArray* array, gconstpointer data, guint
;;    len);
(ff:bind-c-function g_array_prepend_vals
     :unconverted-entry-name "g_array_prepend_vals"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("gconstpointer") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GArray) gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:81 <185> 
;; GArray* g_array_insert_vals( GArray* array, guint index, gconstpointer
;;    data, guint len);
(ff:bind-c-function g_array_insert_vals
     :unconverted-entry-name "g_array_insert_vals"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint") ("gconstpointer") ("guint"))
     :c-arg-names (array index data len)
     :arguments ((* GArray) guint gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:85 <186> 
;; GArray* g_array_set_size( GArray* array, guint length);
(ff:bind-c-function g_array_set_size
     :unconverted-entry-name "g_array_set_size"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint"))
     :c-arg-names (array length)
     :arguments ((* GArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:87 <187> 
;; GArray* g_array_remove_index( GArray* array, guint index);
(ff:bind-c-function g_array_remove_index
     :unconverted-entry-name "g_array_remove_index"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:89 <188> 
;; GArray* g_array_remove_index_fast( GArray* array, guint index);
(ff:bind-c-function g_array_remove_index_fast
     :unconverted-entry-name "g_array_remove_index_fast"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:91 <189> 
;; void g_array_sort( GArray* array, GCompareFunc compare_func);
(ff:bind-c-function g_array_sort
     :unconverted-entry-name "g_array_sort"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GArray" "*") ("GCompareFunc"))
     :c-arg-names (array compare_func)
     :arguments ((* GArray) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:93 <190> 
;; void g_array_sort_with_data( GArray* array, GCompareDataFunc
;;   compare_func,
;;              gpointer user_data);
(ff:bind-c-function g_array_sort_with_data
     :unconverted-entry-name "g_array_sort_with_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GArray" "*") ("GCompareDataFunc") ("gpointer"))
     :c-arg-names (array compare_func user_data)
     :arguments ((* GArray) GCompareDataFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:103 <191> 
;; GPtrArray* g_ptr_array_new( void);
(ff:bind-c-function g_ptr_array_new
     :unconverted-entry-name "g_ptr_array_new"
     :c-return-type ("GPtrArray" "*")
     :return-type (* GPtrArray)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:104 <192> 
;; GPtrArray* g_ptr_array_sized_new( guint reserved_size);
(ff:bind-c-function g_ptr_array_sized_new
     :unconverted-entry-name "g_ptr_array_sized_new"
     :c-return-type ("GPtrArray" "*")
     :return-type (* GPtrArray)
     :c-arg-types (("guint"))
     :c-arg-names (reserved_size)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:105 <193> 
;; gpointer* g_ptr_array_free( GPtrArray* array, gboolean free_seg);
(ff:bind-c-function g_ptr_array_free
     :unconverted-entry-name "g_ptr_array_free"
     :c-return-type ("gpointer" "*")
     :return-type (* gpointer)
     :c-arg-types (("GPtrArray" "*") ("gboolean"))
     :c-arg-names (array free_seg)
     :arguments ((* GPtrArray) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:107 <194> 
;; void g_ptr_array_set_size( GPtrArray* array, gint length);
(ff:bind-c-function g_ptr_array_set_size
     :unconverted-entry-name "g_ptr_array_set_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPtrArray" "*") ("gint"))
     :c-arg-names (array length)
     :arguments ((* GPtrArray) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:109 <195> 
;; gpointer g_ptr_array_remove_index( GPtrArray* array, guint index);
(ff:bind-c-function g_ptr_array_remove_index
     :unconverted-entry-name "g_ptr_array_remove_index"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GPtrArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GPtrArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:111 <196> 
;; gpointer g_ptr_array_remove_index_fast( GPtrArray* array, guint index);
(ff:bind-c-function g_ptr_array_remove_index_fast
     :unconverted-entry-name "g_ptr_array_remove_index_fast"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GPtrArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GPtrArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:113 <197> 
;; gboolean g_ptr_array_remove( GPtrArray* array, gpointer data);
(ff:bind-c-function g_ptr_array_remove
     :unconverted-entry-name "g_ptr_array_remove"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GPtrArray" "*") ("gpointer"))
     :c-arg-names (array data)
     :arguments ((* GPtrArray) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:115 <198> 
;; gboolean g_ptr_array_remove_fast( GPtrArray* array, gpointer data);
(ff:bind-c-function g_ptr_array_remove_fast
     :unconverted-entry-name "g_ptr_array_remove_fast"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GPtrArray" "*") ("gpointer"))
     :c-arg-names (array data)
     :arguments ((* GPtrArray) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:117 <199> 
;; void g_ptr_array_add( GPtrArray* array, gpointer data);
(ff:bind-c-function g_ptr_array_add
     :unconverted-entry-name "g_ptr_array_add"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPtrArray" "*") ("gpointer"))
     :c-arg-names (array data)
     :arguments ((* GPtrArray) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:119 <200> 
;; void g_ptr_array_sort( GPtrArray* array, GCompareFunc compare_func);
(ff:bind-c-function g_ptr_array_sort
     :unconverted-entry-name "g_ptr_array_sort"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPtrArray" "*") ("GCompareFunc"))
     :c-arg-names (array compare_func)
     :arguments ((* GPtrArray) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:121 <201> 
;; void g_ptr_array_sort_with_data( GPtrArray* array, GCompareDataFunc
;;   compare_func,
;;              gpointer user_data);
(ff:bind-c-function g_ptr_array_sort_with_data
     :unconverted-entry-name "g_ptr_array_sort_with_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPtrArray" "*") ("GCompareDataFunc") ("gpointer"))
     :c-arg-names (array compare_func user_data)
     :arguments ((* GPtrArray) GCompareDataFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:130 <202> 
;; GByteArray* g_byte_array_new( void);
(ff:bind-c-function g_byte_array_new
     :unconverted-entry-name "g_byte_array_new"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:131 <203> 
;; GByteArray* g_byte_array_sized_new( guint reserved_size);
(ff:bind-c-function g_byte_array_sized_new
     :unconverted-entry-name "g_byte_array_sized_new"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("guint"))
     :c-arg-names (reserved_size)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:132 <204> 
;; guint8* g_byte_array_free( GByteArray* array, gboolean free_segment);
(ff:bind-c-function g_byte_array_free
     :unconverted-entry-name "g_byte_array_free"
     :c-return-type ("guint8" "*")
     :return-type (* guint8)
     :c-arg-types (("GByteArray" "*") ("gboolean"))
     :c-arg-names (array free_segment)
     :arguments ((* GByteArray) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:134 <205> 
;; GByteArray* g_byte_array_append( GByteArray* array, const guint8* data,
;;              guint len);
(ff:bind-c-function g_byte_array_append
     :unconverted-entry-name "g_byte_array_append"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("const" "guint8" "*") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GByteArray) (* guint8) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:137 <206> 
;; GByteArray* g_byte_array_prepend( GByteArray* array, const guint8* data,
;;              guint len);
(ff:bind-c-function g_byte_array_prepend
     :unconverted-entry-name "g_byte_array_prepend"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("const" "guint8" "*") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GByteArray) (* guint8) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:140 <207> 
;; GByteArray* g_byte_array_set_size( GByteArray* array, guint length);
(ff:bind-c-function g_byte_array_set_size
     :unconverted-entry-name "g_byte_array_set_size"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("guint"))
     :c-arg-names (array length)
     :arguments ((* GByteArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:142 <208> 
;; GByteArray* g_byte_array_remove_index( GByteArray* array, guint index);
(ff:bind-c-function g_byte_array_remove_index
     :unconverted-entry-name "g_byte_array_remove_index"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GByteArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:144 <209> 
;; GByteArray* g_byte_array_remove_index_fast( GByteArray* array, guint
;;   index
;;   );
(ff:bind-c-function g_byte_array_remove_index_fast
     :unconverted-entry-name "g_byte_array_remove_index_fast"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GByteArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:146 <210> 
;; void g_byte_array_sort( GByteArray* array, GCompareFunc compare_func);
(ff:bind-c-function g_byte_array_sort
     :unconverted-entry-name "g_byte_array_sort"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GByteArray" "*") ("GCompareFunc"))
     :c-arg-names (array compare_func)
     :arguments ((* GByteArray) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/garray.h:148 <211> 
;; void g_byte_array_sort_with_data( GByteArray* array, GCompareDataFunc
;;    compare_func, gpointer user_data);
(ff:bind-c-function g_byte_array_sort_with_data
     :unconverted-entry-name "g_byte_array_sort_with_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GByteArray" "*") ("GCompareDataFunc") ("gpointer"))
     :c-arg-names (array compare_func user_data)
     :arguments ((* GByteArray) GCompareDataFunc gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gquark.h:34 <212> 
;; typedef guint32 GQuark;
(ff:bind-c-type GQuark guint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gquark.h:38 <213> 
;; GQuark g_quark_try_string( const gchar* string);
(ff:bind-c-function g_quark_try_string
     :all-names ((g_quark_try_string . "g_quark_try_string")
                 (gtk_object_data_try_key . "gtk_object_data_try_key"))
     :unconverted-entry-name "g_quark_try_string"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gquark.h:39 <214> 
;; GQuark g_quark_from_static_string( const gchar* string);
(ff:bind-c-function g_quark_from_static_string
     :unconverted-entry-name "g_quark_from_static_string"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gquark.h:40 <215> 
;; GQuark g_quark_from_string( const gchar* string);
(ff:bind-c-function g_quark_from_string
     :all-names ((g_quark_from_string . "g_quark_from_string")
                 (gtk_object_data_force_id
                  . "gtk_object_data_force_id"))
     :unconverted-entry-name "g_quark_from_string"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gquark.h:41 <216> 
;; const gchar* g_quark_to_string( GQuark quark);
(ff:bind-c-function g_quark_to_string
     :unconverted-entry-name "g_quark_to_string"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GQuark"))
     :c-arg-names (quark)
     :arguments (GQuark)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:28 <217> 
;; typedef struct _GError GError;
(ff:bind-c-typedef _GError
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GError _GError)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:30 <218> 
;; struct _GError { GQuark domain; gint code; gchar* message; };
(ff:bind-c-type _GError (:struct
  (domain GQuark)   ;; GQuark domain
  (code gint)   ;; gint code
  (message (* gchar))   ;; gchar* message
  ))   ;; bind-c-type _GError
(ff:bind-c-typedef GError _GError) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:37 <219> 
;; GError* g_error_new( GQuark domain, gint code, const gchar* format,
;;   ELLIPSIS
;;   );

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_error_new
     :unconverted-entry-name "g_error_new"
     :c-return-type ("GError" "*")
     :return-type (* GError)
     :c-arg-types (("GQuark") ("gint") ("const" "gchar" "*") "...")
     :c-arg-names (domain code format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:42 <220> 
;; GError* g_error_new_literal( GQuark domain, gint code, const gchar*
;;   message
;;   );
(ff:bind-c-function g_error_new_literal
     :unconverted-entry-name "g_error_new_literal"
     :c-return-type ("GError" "*")
     :return-type (* GError)
     :c-arg-types (("GQuark") ("gint") ("const" "gchar" "*"))
     :c-arg-names (domain code message)
     :arguments (GQuark gint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:46 <221> 
;; void g_error_free( GError* error);
(ff:bind-c-function g_error_free
     :unconverted-entry-name "g_error_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GError" "*"))
     :c-arg-names (error)
     :arguments ((* GError))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:47 <222> 
;; GError* g_error_copy( const GError* error);
(ff:bind-c-function g_error_copy
     :unconverted-entry-name "g_error_copy"
     :c-return-type ("GError" "*")
     :return-type (* GError)
     :c-arg-types (("const" "GError" "*"))
     :c-arg-names (error)
     :arguments ((* GError))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:49 <223> 
;; gboolean g_error_matches( const GError* error, GQuark domain, gint
;;   code);
(ff:bind-c-function g_error_matches
     :unconverted-entry-name "g_error_matches"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GError" "*") ("GQuark") ("gint"))
     :c-arg-names (error domain code)
     :arguments ((* GError) GQuark gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:56 <224> 
;; void g_set_error( GError** err, GQuark domain, gint code, const gchar
;;   * format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_set_error
     :unconverted-entry-name "g_set_error"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GError" "*" "*") ("GQuark") ("gint")
                   ("const" "gchar" "*") "...")
     :c-arg-names (err domain code format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:64 <225> 
;; void g_propagate_error( GError** dest, GError* src);
(ff:bind-c-function g_propagate_error
     :unconverted-entry-name "g_propagate_error"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GError" "*" "*") ("GError" "*"))
     :c-arg-names (dest src)
     :arguments ((* (* GError)) (* GError))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gerror.h:68 <226> 
;; void g_clear_error( GError** err);
(ff:bind-c-function g_clear_error
     :unconverted-entry-name "g_clear_error"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GError" "*" "*"))
     :c-arg-names (err)
     :arguments ((* (* GError)))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:38 <227> 
;; extern GQuark g_thread_error_quark( void);
(ff:bind-c-function g_thread_error_quark
     :unconverted-entry-name "g_thread_error_quark"
     :c-modifiers ("extern")
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:41 <228> 
;; typedef enum { G_THREAD_ERROR_AGAIN } GThreadError;
(ff:bind-c-constant G_THREAD_ERROR_AGAIN 0) ;;  G_THREAD_ERROR_AGAIN 
(ff:bind-c-type GThreadError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:46 <229> 
;; typedef gpointer(* GThreadFunc)( gpointer data);
(ff:bind-c-type GThreadFunc (* gpointer))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:48 <230> 
;; typedef enum {
;;         G_THREAD_PRIORITY_LOW, G_THREAD_PRIORITY_NORMAL,
;;   G_THREAD_PRIORITY_HIGH,
;;              G_THREAD_PRIORITY_URGENT } GThreadPriority;
(ff:bind-c-constant G_THREAD_PRIORITY_LOW 0) ;;  G_THREAD_PRIORITY_LOW 
(ff:bind-c-constant G_THREAD_PRIORITY_NORMAL
                    1) ;;
;;   G_THREAD_PRIORITY_NORMAL 
(ff:bind-c-constant G_THREAD_PRIORITY_HIGH
                    2) ;;
;;   G_THREAD_PRIORITY_HIGH 
(ff:bind-c-constant G_THREAD_PRIORITY_URGENT
                    3) ;;
;;   G_THREAD_PRIORITY_URGENT 
(ff:bind-c-type GThreadPriority :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:56 <231> 
;; typedef struct _GThread GThread;
(ff:bind-c-typedef _GThread
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GThread _GThread)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:57 <232> 
;; struct _GThread {
;;         GThreadFunc func; gpointer data; gboolean joinable;
;;   GThreadPriority priority;
;;    };
(ff:bind-c-type _GThread (:struct
  (func GThreadFunc)   ;; GThreadFunc func
  (data gpointer)   ;; gpointer data
  (joinable gboolean)   ;; gboolean joinable
  (priority GThreadPriority)   ;; GThreadPriority priority
  ))   ;; bind-c-type _GThread
(ff:bind-c-typedef GThread _GThread) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:65 <233> 
;; typedef struct _GMutex GMutex;
(ff:bind-c-typedef _GMutex
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMutex _GMutex)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:66 <234> 
;; typedef struct _GCond GCond;
(ff:bind-c-typedef _GCond
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GCond _GCond)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:67 <235> 
;; typedef struct _GPrivate GPrivate;
(ff:bind-c-typedef _GPrivate
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GPrivate _GPrivate)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:68 <236> 
;; typedef struct _GStaticPrivate GStaticPrivate;
(ff:bind-c-typedef _GStaticPrivate
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStaticPrivate _GStaticPrivate)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:70 <237> 
;; typedef struct _GThreadFunctions GThreadFunctions;
(ff:bind-c-typedef _GThreadFunctions
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GThreadFunctions _GThreadFunctions)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:71 <238> 
;; struct _GThreadFunctions {
;;         GMutex*(* mutex_new)( void); void(* mutex_lock)( GMutex* mutex);
;;   gboolean
;;   (* mutex_trylock)( GMutex* mutex); void(* mutex_unlock)( GMutex* mutex
;;   ); void(* mutex_free)( GMutex* mutex); GCond*(* cond_new)( void); void
;;   (* cond_signal)( GCond* cond); void(* cond_broadcast)( GCond* cond);
;;   void
;;   (* cond_wait)( GCond* cond, GMutex* mutex); gboolean(* cond_timed_wait
;;   )( GCond* cond, GMutex* mutex, GTimeVal* end_time); void(* cond_free)(
;;    GCond* cond); GPrivate*(* private_new)( GDestroyNotify destructor);
;;   gpointer
;;   (* private_get)( GPrivate* private_key); void(* private_set)( GPrivate
;;   * private_key, gpointer data); void(* thread_create)( GThreadFunc
;;   func,
;;              gpointer data, gulong stack_size, gboolean joinable,
;;   gboolean bound, GThreadPriority
;;    priority, gpointer thread, GError** error); void(* thread_yield)(
;;   void
;;   ); void(* thread_join)( gpointer thread); void(* thread_exit)( void);
;;   void
;;   (* thread_set_priority)( gpointer thread, GThreadPriority priority);
;;   void
;;   (* thread_self)( gpointer thread); gboolean(* thread_equal)( gpointer
;;   thread1,
;;              gpointer thread2); };
(ff:bind-c-type _GThreadFunctions (:struct
  (mutex_new ff:function-pointer)   ;; GMutex*(* mutex_new)( void)
  (mutex_lock ff:function-pointer)   ;; void(* mutex_lock)( GMutex* mutex)
  (mutex_trylock ff:function-pointer)   ;;
  ;;  gboolean(* mutex_trylock)( GMutex* mutex)
  (mutex_unlock ff:function-pointer)   ;;
  ;;  void(* mutex_unlock)( GMutex* mutex)
  (mutex_free ff:function-pointer)   ;; void(* mutex_free)( GMutex* mutex)
  (cond_new ff:function-pointer)   ;; GCond*(* cond_new)( void)
  (cond_signal ff:function-pointer)   ;; void(* cond_signal)( GCond* cond)
  (cond_broadcast ff:function-pointer)   ;;
  ;;  void(* cond_broadcast)( GCond* cond)
  (cond_wait ff:function-pointer)   ;;
  ;;  void(* cond_wait)( GCond* cond, GMutex* mutex)
  (cond_timed_wait ff:function-pointer)   ;;
  ;;  gboolean(* cond_timed_wait)( GCond* cond, GMutex* mutex, GTimeVal* end_time)
  (cond_free ff:function-pointer)   ;; void(* cond_free)( GCond* cond)
  (private_new ff:function-pointer)   ;;
  ;;  GPrivate*(* private_new)( GDestroyNotify destructor)
  (private_get ff:function-pointer)   ;;
  ;;  gpointer(* private_get)( GPrivate* private_key)
  (private_set ff:function-pointer)   ;;
  ;;  void(* private_set)( GPrivate* private_key, gpointer data)
  (thread_create ff:function-pointer)   ;;
  ;;  void(* thread_create)( GThreadFunc func, gpointer data, gulong stack_size,
  ;;            gboolean joinable, gboolean bound, GThreadPriority priority, gpointer
  ;;  thread, GError** error)
  (thread_yield ff:function-pointer)   ;; void(* thread_yield)( void)
  (thread_join ff:function-pointer)   ;;
  ;;  void(* thread_join)( gpointer thread)
  (thread_exit ff:function-pointer)   ;; void(* thread_exit)( void)
  (thread_set_priority ff:function-pointer)   ;;
  ;;  void(* thread_set_priority)( gpointer thread, GThreadPriority priority)
  (thread_self ff:function-pointer)   ;;
  ;;  void(* thread_self)( gpointer thread)
  (thread_equal ff:function-pointer)   ;;
  ;;  gboolean(* thread_equal)( gpointer thread1, gpointer thread2)
  ))   ;; bind-c-type _GThreadFunctions
(ff:bind-c-typedef GThreadFunctions
                   _GThreadFunctions) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:109 <239> 
;; extern GThreadFunctions g_thread_functions_for_glib_use;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_thread_functions_for_glib_use"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:110 <240> 
;; extern gboolean g_thread_use_default_impl;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_thread_use_default_impl"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:111 <241> 
;; extern gboolean g_threads_got_initialized;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_threads_got_initialized"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:117 <242> 
;; void g_thread_init( GThreadFunctions* vtable);
(ff:bind-c-function g_thread_init
     :unconverted-entry-name "g_thread_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GThreadFunctions" "*"))
     :c-arg-names (vtable)
     :arguments ((* GThreadFunctions))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:126 <243> 
;; void g_thread_init_with_errorcheck_mutexes( GThreadFunctions* vtable);
(ff:bind-c-function g_thread_init_with_errorcheck_mutexes
     :unconverted-entry-name "g_thread_init_with_errorcheck_mutexes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GThreadFunctions" "*"))
     :c-arg-names (vtable)
     :arguments ((* GThreadFunctions))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:136 <244> 
;; GMutex* g_static_mutex_get_mutex_impl( GMutex** mutex);
(ff:bind-c-function g_static_mutex_get_mutex_impl
     :unconverted-entry-name "g_static_mutex_get_mutex_impl"
     :c-return-type ("GMutex" "*")
     :return-type (* GMutex)
     :c-arg-types (("GMutex" "*" "*"))
     :c-arg-names (mutex)
     :arguments ((* (* GMutex)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:202 <245> 
;; GThread* g_thread_create_full( GThreadFunc func, gpointer data, gulong
;;    stack_size, gboolean joinable, gboolean bound, GThreadPriority
;;   priority,
;;              GError** error);
(ff:bind-c-function g_thread_create_full
     :unconverted-entry-name "g_thread_create_full"
     :c-return-type ("GThread" "*")
     :return-type (* GThread)
     :c-arg-types (("GThreadFunc") ("gpointer") ("gulong") ("gboolean")
                   ("gboolean") ("GThreadPriority") ("GError" "*" "*"))
     :c-arg-names (func data stack_size joinable bound priority error)
     :arguments (GThreadFunc gpointer gulong gboolean gboolean
                 GThreadPriority (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:209 <246> 
;; GThread* g_thread_self( void);
(ff:bind-c-function g_thread_self
     :unconverted-entry-name "g_thread_self"
     :c-return-type ("GThread" "*")
     :return-type (* GThread)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:210 <247> 
;; void g_thread_exit( gpointer retval);
(ff:bind-c-function g_thread_exit
     :unconverted-entry-name "g_thread_exit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (retval)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:211 <248> 
;; gpointer g_thread_join( GThread* thread);
(ff:bind-c-function g_thread_join
     :unconverted-entry-name "g_thread_join"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GThread" "*"))
     :c-arg-names (thread)
     :arguments ((* GThread))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:213 <249> 
;; void g_thread_set_priority( GThread* thread, GThreadPriority priority);
(ff:bind-c-function g_thread_set_priority
     :unconverted-entry-name "g_thread_set_priority"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GThread" "*") ("GThreadPriority"))
     :c-arg-names (thread priority)
     :arguments ((* GThread) GThreadPriority)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:227 <250> 
;; void g_static_mutex_init( GStaticMutex* mutex);
(ff:bind-c-function g_static_mutex_init
     :unconverted-entry-name "g_static_mutex_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:228 <251> 
;; void g_static_mutex_free( GStaticMutex* mutex);
(ff:bind-c-function g_static_mutex_free
     :unconverted-entry-name "g_static_mutex_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:230 <252> 
;; struct _GStaticPrivate { guint index; };
(ff:bind-c-type _GStaticPrivate (:struct
  (index guint)   ;; guint index
  ))   ;; bind-c-type _GStaticPrivate
(ff:bind-c-typedef GStaticPrivate
                   _GStaticPrivate) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:235 <253> 
;; void g_static_private_init( GStaticPrivate* private_key);
(ff:bind-c-function g_static_private_init
     :unconverted-entry-name "g_static_private_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticPrivate" "*"))
     :c-arg-names (private_key)
     :arguments ((* GStaticPrivate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:236 <254> 
;; gpointer g_static_private_get( GStaticPrivate* private_key);
(ff:bind-c-function g_static_private_get
     :unconverted-entry-name "g_static_private_get"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GStaticPrivate" "*"))
     :c-arg-names (private_key)
     :arguments ((* GStaticPrivate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:237 <255> 
;; void g_static_private_set( GStaticPrivate* private_key, gpointer data,
;;              GDestroyNotify notify);
(ff:bind-c-function g_static_private_set
     :unconverted-entry-name "g_static_private_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticPrivate" "*") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (private_key data notify)
     :arguments ((* GStaticPrivate) gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:240 <256> 
;; void g_static_private_free( GStaticPrivate* private_key);
(ff:bind-c-function g_static_private_free
     :unconverted-entry-name "g_static_private_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticPrivate" "*"))
     :c-arg-names (private_key)
     :arguments ((* GStaticPrivate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:242 <257> 
;; typedef struct _GStaticRecMutex GStaticRecMutex;
(ff:bind-c-typedef _GStaticRecMutex
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStaticRecMutex _GStaticRecMutex)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:243 <258> 
;; struct _GStaticRecMutex {
;;         GStaticMutex mutex; guint depth; GSystemThread owner; };
(ff:bind-c-type _GStaticRecMutex (:struct
  (mutex GStaticMutex)   ;; GStaticMutex mutex
  (depth guint)   ;; guint depth
  (owner GSystemThread)   ;; GSystemThread owner
  ))   ;; bind-c-type _GStaticRecMutex
(ff:bind-c-typedef GStaticRecMutex
                   _GStaticRecMutex) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:251 <259> 
;; void g_static_rec_mutex_init( GStaticRecMutex* mutex);
(ff:bind-c-function g_static_rec_mutex_init
     :unconverted-entry-name "g_static_rec_mutex_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRecMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticRecMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:252 <260> 
;; void g_static_rec_mutex_lock( GStaticRecMutex* mutex);
(ff:bind-c-function g_static_rec_mutex_lock
     :unconverted-entry-name "g_static_rec_mutex_lock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRecMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticRecMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:253 <261> 
;; gboolean g_static_rec_mutex_trylock( GStaticRecMutex* mutex);
(ff:bind-c-function g_static_rec_mutex_trylock
     :unconverted-entry-name "g_static_rec_mutex_trylock"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GStaticRecMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticRecMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:254 <262> 
;; void g_static_rec_mutex_unlock( GStaticRecMutex* mutex);
(ff:bind-c-function g_static_rec_mutex_unlock
     :unconverted-entry-name "g_static_rec_mutex_unlock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRecMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticRecMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:255 <263> 
;; void g_static_rec_mutex_lock_full( GStaticRecMutex* mutex, guint depth);
(ff:bind-c-function g_static_rec_mutex_lock_full
     :unconverted-entry-name "g_static_rec_mutex_lock_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRecMutex" "*") ("guint"))
     :c-arg-names (mutex depth)
     :arguments ((* GStaticRecMutex) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:257 <264> 
;; guint g_static_rec_mutex_unlock_full( GStaticRecMutex* mutex);
(ff:bind-c-function g_static_rec_mutex_unlock_full
     :unconverted-entry-name "g_static_rec_mutex_unlock_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GStaticRecMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticRecMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:258 <265> 
;; void g_static_rec_mutex_free( GStaticRecMutex* mutex);
(ff:bind-c-function g_static_rec_mutex_free
     :unconverted-entry-name "g_static_rec_mutex_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRecMutex" "*"))
     :c-arg-names (mutex)
     :arguments ((* GStaticRecMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:260 <266> 
;; typedef struct _GStaticRWLock GStaticRWLock;
(ff:bind-c-typedef _GStaticRWLock
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStaticRWLock _GStaticRWLock)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:261 <267> 
;; struct _GStaticRWLock {
;;         GStaticMutex mutex; GCond* read_cond; GCond* write_cond; guint
;;   read_counter;
;;              gboolean write; guint want_to_read; guint want_to_write; };
(ff:bind-c-type _GStaticRWLock (:struct
  (mutex GStaticMutex)   ;; GStaticMutex mutex
  (read_cond (* GCond))   ;; GCond* read_cond
  (write_cond (* GCond))   ;; GCond* write_cond
  (read_counter guint)   ;; guint read_counter
  (write gboolean)   ;; gboolean write
  (want_to_read guint)   ;; guint want_to_read
  (want_to_write guint)   ;; guint want_to_write
  ))   ;; bind-c-type _GStaticRWLock
(ff:bind-c-typedef GStaticRWLock _GStaticRWLock) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:274 <268> 
;; void g_static_rw_lock_init( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_init
     :unconverted-entry-name "g_static_rw_lock_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:275 <269> 
;; void g_static_rw_lock_reader_lock( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_reader_lock
     :unconverted-entry-name "g_static_rw_lock_reader_lock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:276 <270> 
;; gboolean g_static_rw_lock_reader_trylock( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_reader_trylock
     :unconverted-entry-name "g_static_rw_lock_reader_trylock"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:277 <271> 
;; void g_static_rw_lock_reader_unlock( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_reader_unlock
     :unconverted-entry-name "g_static_rw_lock_reader_unlock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:278 <272> 
;; void g_static_rw_lock_writer_lock( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_writer_lock
     :unconverted-entry-name "g_static_rw_lock_writer_lock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:279 <273> 
;; gboolean g_static_rw_lock_writer_trylock( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_writer_trylock
     :unconverted-entry-name "g_static_rw_lock_writer_trylock"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:280 <274> 
;; void g_static_rw_lock_writer_unlock( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_writer_unlock
     :unconverted-entry-name "g_static_rw_lock_writer_unlock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:281 <275> 
;; void g_static_rw_lock_free( GStaticRWLock* lock);
(ff:bind-c-function g_static_rw_lock_free
     :unconverted-entry-name "g_static_rw_lock_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticRWLock" "*"))
     :c-arg-names (lock)
     :arguments ((* GStaticRWLock))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthread.h:292 <276> 
;; extern void glib_dummy_decl( void);
(ff:bind-c-function glib_dummy_decl
     :unconverted-entry-name "glib_dummy_decl"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:34 <277> 
;; typedef struct _GAsyncQueue GAsyncQueue;
(ff:bind-c-typedef _GAsyncQueue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GAsyncQueue _GAsyncQueue)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:40 <278> 
;; GAsyncQueue* g_async_queue_new( void);
(ff:bind-c-function g_async_queue_new
     :unconverted-entry-name "g_async_queue_new"
     :c-return-type ("GAsyncQueue" "*")
     :return-type (* GAsyncQueue)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:46 <279> 
;; void g_async_queue_lock( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_lock
     :unconverted-entry-name "g_async_queue_lock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:47 <280> 
;; void g_async_queue_unlock( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_unlock
     :unconverted-entry-name "g_async_queue_unlock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:56 <281> 
;; void g_async_queue_ref( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_ref
     :unconverted-entry-name "g_async_queue_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:57 <282> 
;; void g_async_queue_ref_unlocked( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_ref_unlocked
     :unconverted-entry-name "g_async_queue_ref_unlocked"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:58 <283> 
;; void g_async_queue_unref( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_unref
     :unconverted-entry-name "g_async_queue_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:59 <284> 
;; void g_async_queue_unref_and_unlock( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_unref_and_unlock
     :unconverted-entry-name "g_async_queue_unref_and_unlock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:62 <285> 
;; void g_async_queue_push( GAsyncQueue* queue, gpointer data);
(ff:bind-c-function g_async_queue_push
     :unconverted-entry-name "g_async_queue_push"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*") ("gpointer"))
     :c-arg-names (queue data)
     :arguments ((* GAsyncQueue) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:64 <286> 
;; void g_async_queue_push_unlocked( GAsyncQueue* queue, gpointer data);
(ff:bind-c-function g_async_queue_push_unlocked
     :unconverted-entry-name "g_async_queue_push_unlocked"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAsyncQueue" "*") ("gpointer"))
     :c-arg-names (queue data)
     :arguments ((* GAsyncQueue) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:69 <287> 
;; gpointer g_async_queue_pop( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_pop
     :unconverted-entry-name "g_async_queue_pop"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:70 <288> 
;; gpointer g_async_queue_pop_unlocked( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_pop_unlocked
     :unconverted-entry-name "g_async_queue_pop_unlocked"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:73 <289> 
;; gpointer g_async_queue_try_pop( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_try_pop
     :unconverted-entry-name "g_async_queue_try_pop"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:74 <290> 
;; gpointer g_async_queue_try_pop_unlocked( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_try_pop_unlocked
     :unconverted-entry-name "g_async_queue_try_pop_unlocked"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:78 <291> 
;; gpointer g_async_queue_timed_pop( GAsyncQueue* queue, GTimeVal* end_time
;;   );
(ff:bind-c-function g_async_queue_timed_pop
     :unconverted-entry-name "g_async_queue_timed_pop"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GAsyncQueue" "*") ("GTimeVal" "*"))
     :c-arg-names (queue end_time)
     :arguments ((* GAsyncQueue) (* GTimeVal))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:80 <292> 
;; gpointer g_async_queue_timed_pop_unlocked( GAsyncQueue* queue, GTimeVal
;;   * end_time);
(ff:bind-c-function g_async_queue_timed_pop_unlocked
     :unconverted-entry-name "g_async_queue_timed_pop_unlocked"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GAsyncQueue" "*") ("GTimeVal" "*"))
     :c-arg-names (queue end_time)
     :arguments ((* GAsyncQueue) (* GTimeVal))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:89 <293> 
;; gint g_async_queue_length( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_length
     :unconverted-entry-name "g_async_queue_length"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gasyncqueue.h:90 <294> 
;; gint g_async_queue_length_unlocked( GAsyncQueue* queue);
(ff:bind-c-function g_async_queue_length_unlocked
     :unconverted-entry-name "g_async_queue_length_unlocked"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GAsyncQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GAsyncQueue))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gbacktrace.h:43 <295> 
;; void g_on_error_query( const gchar* prg_name);
(ff:bind-c-function g_on_error_query
     :unconverted-entry-name "g_on_error_query"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (prg_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gbacktrace.h:44 <296> 
;; void g_on_error_stack_trace( const gchar* prg_name);
(ff:bind-c-function g_on_error_stack_trace
     :unconverted-entry-name "g_on_error_stack_trace"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (prg_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:34 <297> 
;; typedef struct _GAllocator GAllocator;
(ff:bind-c-typedef _GAllocator
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GAllocator _GAllocator)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:35 <298> 
;; typedef struct _GMemChunk GMemChunk;
(ff:bind-c-typedef _GMemChunk
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMemChunk _GMemChunk)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:36 <299> 
;; typedef struct _GMemVTable GMemVTable;
(ff:bind-c-typedef _GMemVTable
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMemVTable _GMemVTable)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:48 <300> 
;; gpointer g_malloc( gulong n_bytes);
(ff:bind-c-function g_malloc
     :unconverted-entry-name "g_malloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gulong"))
     :c-arg-names (n_bytes)
     :arguments (gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:49 <301> 
;; gpointer g_malloc0( gulong n_bytes);
(ff:bind-c-function g_malloc0
     :unconverted-entry-name "g_malloc0"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gulong"))
     :c-arg-names (n_bytes)
     :arguments (gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:50 <302> 
;; gpointer g_realloc( gpointer mem, gulong n_bytes);
(ff:bind-c-function g_realloc
     :unconverted-entry-name "g_realloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer") ("gulong"))
     :c-arg-names (mem n_bytes)
     :arguments (gpointer gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:52 <303> 
;; void g_free( gpointer mem);
(ff:bind-c-function g_free
     :unconverted-entry-name "g_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (mem)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:53 <304> 
;; gpointer g_try_malloc( gulong n_bytes);
(ff:bind-c-function g_try_malloc
     :unconverted-entry-name "g_try_malloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gulong"))
     :c-arg-names (n_bytes)
     :arguments (gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:54 <305> 
;; gpointer g_try_realloc( gpointer mem, gulong n_bytes);
(ff:bind-c-function g_try_realloc
     :unconverted-entry-name "g_try_realloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer") ("gulong"))
     :c-arg-names (mem n_bytes)
     :arguments (gpointer gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:72 <306> 
;; struct _GMemVTable {
;;         gpointer(* malloc)( gsize n_bytes); gpointer(* realloc)(
;;   gpointer mem,
;;              gsize n_bytes); void(* free)( gpointer mem); gpointer(*
;;   calloc)( gsize
;;    n_blocks, gsize n_block_bytes); gpointer(* try_malloc)( gsize n_bytes
;;   ); gpointer(* try_realloc)( gpointer mem, gsize n_bytes); };
(ff:bind-c-type _GMemVTable (:struct
  (malloc ff:function-pointer)   ;; gpointer(* malloc)( gsize n_bytes)
  (realloc ff:function-pointer)   ;;
  ;;  gpointer(* realloc)( gpointer mem, gsize n_bytes)
  (free ff:function-pointer)   ;; void(* free)( gpointer mem)
  (calloc ff:function-pointer)   ;;
  ;;  gpointer(* calloc)( gsize n_blocks, gsize n_block_bytes)
  (try_malloc ff:function-pointer)   ;;
  ;;  gpointer(* try_malloc)( gsize n_bytes)
  (try_realloc ff:function-pointer)   ;;
  ;;  gpointer(* try_realloc)( gpointer mem, gsize n_bytes)
  ))   ;; bind-c-type _GMemVTable
(ff:bind-c-typedef GMemVTable _GMemVTable) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:85 <307> 
;; void g_mem_set_vtable( GMemVTable* vtable);
(ff:bind-c-function g_mem_set_vtable
     :unconverted-entry-name "g_mem_set_vtable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemVTable" "*"))
     :c-arg-names (vtable)
     :arguments ((* GMemVTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:86 <308> 
;; gboolean g_mem_is_system_malloc( void);
(ff:bind-c-function g_mem_is_system_malloc
     :unconverted-entry-name "g_mem_is_system_malloc"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:90 <309> 
;; extern GMemVTable* glib_mem_profiler_table;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_mem_profiler_table"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:91 <310> 
;; void g_mem_profile( void);
(ff:bind-c-function g_mem_profile
     :unconverted-entry-name "g_mem_profile"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:135 <311> 
;; GMemChunk* g_mem_chunk_new( const gchar* name, gint atom_size, gulong
;;    area_size, gint type);
(ff:bind-c-function g_mem_chunk_new
     :unconverted-entry-name "g_mem_chunk_new"
     :c-return-type ("GMemChunk" "*")
     :return-type (* GMemChunk)
     :c-arg-types (("const" "gchar" "*") ("gint") ("gulong") ("gint"))
     :c-arg-names (name atom_size area_size type)
     :arguments ((* gchar) gint gulong gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:139 <312> 
;; void g_mem_chunk_destroy( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_destroy
     :unconverted-entry-name "g_mem_chunk_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:140 <313> 
;; gpointer g_mem_chunk_alloc( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_alloc
     :unconverted-entry-name "g_mem_chunk_alloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:141 <314> 
;; gpointer g_mem_chunk_alloc0( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_alloc0
     :unconverted-entry-name "g_mem_chunk_alloc0"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:142 <315> 
;; void g_mem_chunk_free( GMemChunk* mem_chunk, gpointer mem);
(ff:bind-c-function g_mem_chunk_free
     :unconverted-entry-name "g_mem_chunk_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*") ("gpointer"))
     :c-arg-names (mem_chunk mem)
     :arguments ((* GMemChunk) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:144 <316> 
;; void g_mem_chunk_clean( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_clean
     :unconverted-entry-name "g_mem_chunk_clean"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:145 <317> 
;; void g_mem_chunk_reset( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_reset
     :unconverted-entry-name "g_mem_chunk_reset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:146 <318> 
;; void g_mem_chunk_print( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_print
     :unconverted-entry-name "g_mem_chunk_print"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:147 <319> 
;; void g_mem_chunk_info( void);
(ff:bind-c-function g_mem_chunk_info
     :unconverted-entry-name "g_mem_chunk_info"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:157 <320> 
;; void g_blow_chunks( void);
(ff:bind-c-function g_blow_chunks
     :unconverted-entry-name "g_blow_chunks"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:162 <321> 
;; GAllocator* g_allocator_new( const gchar* name, guint n_preallocs);
(ff:bind-c-function g_allocator_new
     :unconverted-entry-name "g_allocator_new"
     :c-return-type ("GAllocator" "*")
     :return-type (* GAllocator)
     :c-arg-types (("const" "gchar" "*") ("guint"))
     :c-arg-names (name n_preallocs)
     :arguments ((* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmem.h:164 <322> 
;; void g_allocator_free( GAllocator* allocator);
(ff:bind-c-function g_allocator_free
     :unconverted-entry-name "g_allocator_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:34 <323> 
;; typedef struct _GList GList;
(ff:bind-c-typedef _GList
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GList _GList)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:36 <324> 
;; struct _GList { gpointer data; GList* next; GList* prev; };
(ff:bind-c-type _GList (:struct
  (data gpointer)   ;; gpointer data
  (next (* GList))   ;; GList* next
  (prev (* GList))   ;; GList* prev
  ))   ;; bind-c-type _GList
(ff:bind-c-typedef GList _GList) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:45 <325> 
;; void g_list_push_allocator( GAllocator* allocator);
(ff:bind-c-function g_list_push_allocator
     :unconverted-entry-name "g_list_push_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:46 <326> 
;; void g_list_pop_allocator( void);
(ff:bind-c-function g_list_pop_allocator
     :unconverted-entry-name "g_list_pop_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:47 <327> 
;; GList* g_list_alloc( void);
(ff:bind-c-function g_list_alloc
     :unconverted-entry-name "g_list_alloc"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:48 <328> 
;; void g_list_free( GList* list);
(ff:bind-c-function g_list_free
     :unconverted-entry-name "g_list_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:49 <329> 
;; void g_list_free_1( GList* list);
(ff:bind-c-function g_list_free_1
     :unconverted-entry-name "g_list_free_1"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:50 <330> 
;; GList* g_list_append( GList* list, gpointer data);
(ff:bind-c-function g_list_append
     :unconverted-entry-name "g_list_append"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:52 <331> 
;; GList* g_list_prepend( GList* list, gpointer data);
(ff:bind-c-function g_list_prepend
     :unconverted-entry-name "g_list_prepend"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:54 <332> 
;; GList* g_list_insert( GList* list, gpointer data, gint position);
(ff:bind-c-function g_list_insert
     :unconverted-entry-name "g_list_insert"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer") ("gint"))
     :c-arg-names (list data position)
     :arguments ((* GList) gpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:57 <333> 
;; GList* g_list_insert_sorted( GList* list, gpointer data, GCompareFunc
;;    func);
(ff:bind-c-function g_list_insert_sorted
     :unconverted-entry-name "g_list_insert_sorted"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GList) gpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:60 <334> 
;; GList* g_list_insert_before( GList* list, GList* sibling, gpointer
;;   data);
(ff:bind-c-function g_list_insert_before
     :unconverted-entry-name "g_list_insert_before"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GList" "*") ("gpointer"))
     :c-arg-names (list sibling data)
     :arguments ((* GList) (* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:63 <335> 
;; GList* g_list_concat( GList* list1, GList* list2);
(ff:bind-c-function g_list_concat
     :unconverted-entry-name "g_list_concat"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GList" "*"))
     :c-arg-names (list1 list2)
     :arguments ((* GList) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:65 <336> 
;; GList* g_list_remove( GList* list, gconstpointer data);
(ff:bind-c-function g_list_remove
     :unconverted-entry-name "g_list_remove"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:67 <337> 
;; GList* g_list_remove_all( GList* list, gconstpointer data);
(ff:bind-c-function g_list_remove_all
     :unconverted-entry-name "g_list_remove_all"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:69 <338> 
;; GList* g_list_remove_link( GList* list, GList* llink);
(ff:bind-c-function g_list_remove_link
     :unconverted-entry-name "g_list_remove_link"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GList" "*"))
     :c-arg-names (list llink)
     :arguments ((* GList) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:71 <339> 
;; GList* g_list_delete_link( GList* list, GList* link);
(ff:bind-c-function g_list_delete_link
     :unconverted-entry-name "g_list_delete_link"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GList" "*"))
     :c-arg-names (list link)
     :arguments ((* GList) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:73 <340> 
;; GList* g_list_reverse( GList* list);
(ff:bind-c-function g_list_reverse
     :unconverted-entry-name "g_list_reverse"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:74 <341> 
;; GList* g_list_copy( GList* list);
(ff:bind-c-function g_list_copy
     :unconverted-entry-name "g_list_copy"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:75 <342> 
;; GList* g_list_nth( GList* list, guint n);
(ff:bind-c-function g_list_nth
     :unconverted-entry-name "g_list_nth"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:77 <343> 
;; GList* g_list_nth_prev( GList* list, guint n);
(ff:bind-c-function g_list_nth_prev
     :unconverted-entry-name "g_list_nth_prev"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:79 <344> 
;; GList* g_list_find( GList* list, gconstpointer data);
(ff:bind-c-function g_list_find
     :unconverted-entry-name "g_list_find"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:81 <345> 
;; GList* g_list_find_custom( GList* list, gconstpointer data, GCompareFunc
;;    func);
(ff:bind-c-function g_list_find_custom
     :unconverted-entry-name "g_list_find_custom"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gconstpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GList) gconstpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:84 <346> 
;; gint g_list_position( GList* list, GList* llink);
(ff:bind-c-function g_list_position
     :unconverted-entry-name "g_list_position"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GList" "*") ("GList" "*"))
     :c-arg-names (list llink)
     :arguments ((* GList) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:86 <347> 
;; gint g_list_index( GList* list, gconstpointer data);
(ff:bind-c-function g_list_index
     :unconverted-entry-name "g_list_index"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:88 <348> 
;; GList* g_list_last( GList* list);
(ff:bind-c-function g_list_last
     :unconverted-entry-name "g_list_last"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:89 <349> 
;; GList* g_list_first( GList* list);
(ff:bind-c-function g_list_first
     :unconverted-entry-name "g_list_first"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:90 <350> 
;; guint g_list_length( GList* list);
(ff:bind-c-function g_list_length
     :unconverted-entry-name "g_list_length"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:91 <351> 
;; void g_list_foreach( GList* list, GFunc func, gpointer user_data);
(ff:bind-c-function g_list_foreach
     :unconverted-entry-name "g_list_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GList" "*") ("GFunc") ("gpointer"))
     :c-arg-names (list func user_data)
     :arguments ((* GList) GFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:94 <352> 
;; GList* g_list_sort( GList* list, GCompareFunc compare_func);
(ff:bind-c-function g_list_sort
     :unconverted-entry-name "g_list_sort"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GCompareFunc"))
     :c-arg-names (list compare_func)
     :arguments ((* GList) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:96 <353> 
;; GList* g_list_sort_with_data( GList* list, GCompareDataFunc
;;   compare_func,
;;              gpointer user_data);
(ff:bind-c-function g_list_sort_with_data
     :unconverted-entry-name "g_list_sort_with_data"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GCompareDataFunc") ("gpointer"))
     :c-arg-names (list compare_func user_data)
     :arguments ((* GList) GCompareDataFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/glist.h:99 <354> 
;; gpointer g_list_nth_data( GList* list, guint n);
(ff:bind-c-function g_list_nth_data
     :unconverted-entry-name "g_list_nth_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GList) guint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:34 <355> 
;; typedef struct _GCache GCache;
(ff:bind-c-typedef _GCache
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GCache _GCache)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:36 <356> 
;; typedef gpointer(* GCacheNewFunc)( gpointer key);
(ff:bind-c-type GCacheNewFunc (* gpointer))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:37 <357> 
;; typedef gpointer(* GCacheDupFunc)( gpointer value);
(ff:bind-c-type GCacheDupFunc (* gpointer))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:38 <358> 
;; typedef void(* GCacheDestroyFunc)( gpointer value);
(ff:bind-c-type GCacheDestroyFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:42 <359> 
;; GCache* g_cache_new( GCacheNewFunc value_new_func, GCacheDestroyFunc
;;   value_destroy_func,
;;              GCacheDupFunc key_dup_func, GCacheDestroyFunc
;;   key_destroy_func, GHashFunc
;;    hash_key_func, GHashFunc hash_value_func, GEqualFunc key_equal_func);
(ff:bind-c-function g_cache_new
     :unconverted-entry-name "g_cache_new"
     :c-return-type ("GCache" "*")
     :return-type (* GCache)
     :c-arg-types (("GCacheNewFunc") ("GCacheDestroyFunc")
                   ("GCacheDupFunc") ("GCacheDestroyFunc")
                   ("GHashFunc") ("GHashFunc") ("GEqualFunc"))
     :c-arg-names (value_new_func value_destroy_func key_dup_func
                   key_destroy_func hash_key_func hash_value_func
                   key_equal_func)
     :arguments (GCacheNewFunc GCacheDestroyFunc GCacheDupFunc
                 GCacheDestroyFunc GHashFunc GHashFunc GEqualFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:49 <360> 
;; void g_cache_destroy( GCache* cache);
(ff:bind-c-function g_cache_destroy
     :unconverted-entry-name "g_cache_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*"))
     :c-arg-names (cache)
     :arguments ((* GCache))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:50 <361> 
;; gpointer g_cache_insert( GCache* cache, gpointer key);
(ff:bind-c-function g_cache_insert
     :unconverted-entry-name "g_cache_insert"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GCache" "*") ("gpointer"))
     :c-arg-names (cache key)
     :arguments ((* GCache) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:52 <362> 
;; void g_cache_remove( GCache* cache, gconstpointer value);
(ff:bind-c-function g_cache_remove
     :unconverted-entry-name "g_cache_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*") ("gconstpointer"))
     :c-arg-names (cache value)
     :arguments ((* GCache) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:54 <363> 
;; void g_cache_key_foreach( GCache* cache, GHFunc func, gpointer user_data
;;   );
(ff:bind-c-function g_cache_key_foreach
     :unconverted-entry-name "g_cache_key_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*") ("GHFunc") ("gpointer"))
     :c-arg-names (cache func user_data)
     :arguments ((* GCache) GHFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcache.h:57 <364> 
;; void g_cache_value_foreach( GCache* cache, GHFunc func, gpointer
;;   user_data
;;   );
(ff:bind-c-function g_cache_value_foreach
     :unconverted-entry-name "g_cache_value_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*") ("GHFunc") ("gpointer"))
     :c-arg-names (cache func user_data)
     :arguments ((* GCache) GHFunc gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:34 <365> 
;; typedef struct _GCompletion GCompletion;
(ff:bind-c-typedef _GCompletion
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GCompletion _GCompletion)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:36 <366> 
;; typedef gchar*(* GCompletionFunc)( gpointer);
(ff:bind-c-type GCompletionFunc (* gchar))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:41 <367> 
;; typedef gint(* GCompletionStrncmpFunc)( const gchar* s1, const gchar*
;;    s2, gsize n);
(ff:bind-c-type GCompletionStrncmpFunc (* gint))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:45 <368> 
;; struct _GCompletion {
;;         GList* items; GCompletionFunc func; gchar* prefix; GList* cache;
;;   GCompletionStrncmpFunc
;;    strncmp_func; };
(ff:bind-c-type _GCompletion (:struct
  (items (* GList))   ;; GList* items
  (func GCompletionFunc)   ;; GCompletionFunc func
  (prefix (* gchar))   ;; gchar* prefix
  (cache (* GList))   ;; GList* cache
  (strncmp_func GCompletionStrncmpFunc)   ;;
  ;;  GCompletionStrncmpFunc strncmp_func
  ))   ;; bind-c-type _GCompletion
(ff:bind-c-typedef GCompletion _GCompletion) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:55 <369> 
;; GCompletion* g_completion_new( GCompletionFunc func);
(ff:bind-c-function g_completion_new
     :unconverted-entry-name "g_completion_new"
     :c-return-type ("GCompletion" "*")
     :return-type (* GCompletion)
     :c-arg-types (("GCompletionFunc"))
     :c-arg-names (func)
     :arguments (GCompletionFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:56 <370> 
;; void g_completion_add_items( GCompletion* cmp, GList* items);
(ff:bind-c-function g_completion_add_items
     :unconverted-entry-name "g_completion_add_items"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*") ("GList" "*"))
     :c-arg-names (cmp items)
     :arguments ((* GCompletion) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:58 <371> 
;; void g_completion_remove_items( GCompletion* cmp, GList* items);
(ff:bind-c-function g_completion_remove_items
     :unconverted-entry-name "g_completion_remove_items"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*") ("GList" "*"))
     :c-arg-names (cmp items)
     :arguments ((* GCompletion) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:60 <372> 
;; void g_completion_clear_items( GCompletion* cmp);
(ff:bind-c-function g_completion_clear_items
     :unconverted-entry-name "g_completion_clear_items"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*"))
     :c-arg-names (cmp)
     :arguments ((* GCompletion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:61 <373> 
;; GList* g_completion_complete( GCompletion* cmp, gchar* prefix, gchar*
;;   * new_prefix);
(ff:bind-c-function g_completion_complete
     :unconverted-entry-name "g_completion_complete"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GCompletion" "*") ("gchar" "*") ("gchar" "*" "*"))
     :c-arg-names (cmp prefix new_prefix)
     :arguments ((* GCompletion) (* gchar) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:64 <374> 
;; void g_completion_set_compare( GCompletion* cmp, GCompletionStrncmpFunc
;;    strncmp_func);
(ff:bind-c-function g_completion_set_compare
     :unconverted-entry-name "g_completion_set_compare"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*") ("GCompletionStrncmpFunc"))
     :c-arg-names (cmp strncmp_func)
     :arguments ((* GCompletion) GCompletionStrncmpFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gcompletion.h:66 <375> 
;; void g_completion_free( GCompletion* cmp);
(ff:bind-c-function g_completion_free
     :unconverted-entry-name "g_completion_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*"))
     :c-arg-names (cmp)
     :arguments ((* GCompletion))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:35 <376> 
;; typedef enum {
;;         G_CONVERT_ERROR_NO_CONVERSION, G_CONVERT_ERROR_ILLEGAL_SEQUENCE,
;;   G_CONVERT_ERROR_FAILED,
;;              G_CONVERT_ERROR_PARTIAL_INPUT, G_CONVERT_ERROR_BAD_URI,
;;   G_CONVERT_ERROR_NOT_ABSOLUTE_PATH
;;    } GConvertError;
(ff:bind-c-constant G_CONVERT_ERROR_NO_CONVERSION
                    0) ;;
;;   G_CONVERT_ERROR_NO_CONVERSION 
(ff:bind-c-constant G_CONVERT_ERROR_ILLEGAL_SEQUENCE
                    1) ;;
;;   G_CONVERT_ERROR_ILLEGAL_SEQUENCE 
(ff:bind-c-constant G_CONVERT_ERROR_FAILED
                    2) ;;
;;   G_CONVERT_ERROR_FAILED 
(ff:bind-c-constant G_CONVERT_ERROR_PARTIAL_INPUT
                    3) ;;
;;   G_CONVERT_ERROR_PARTIAL_INPUT 
(ff:bind-c-constant G_CONVERT_ERROR_BAD_URI
                    4) ;;
;;   G_CONVERT_ERROR_BAD_URI 
(ff:bind-c-constant G_CONVERT_ERROR_NOT_ABSOLUTE_PATH
                    5) ;;
;;   G_CONVERT_ERROR_NOT_ABSOLUTE_PATH 
(ff:bind-c-type GConvertError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:46 <377> 
;; GQuark g_convert_error_quark( void);
(ff:bind-c-function g_convert_error_quark
     :unconverted-entry-name "g_convert_error_quark"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:50 <378> 
;; typedef struct _GIConv* GIConv;
(ff:bind-c-typedef _GIConv
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GIConv (* _GIConv))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:52 <379> 
;; GIConv g_iconv_open( const gchar* to_codeset, const gchar*
;;   from_codeset);
(ff:bind-c-function g_iconv_open
     :unconverted-entry-name "g_iconv_open"
     :c-return-type ("GIConv")
     :return-type GIConv
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (to_codeset from_codeset)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:54 <380> 
;; size_t g_iconv( GIConv converter, gchar** inbuf, gsize* inbytes_left,
;;              gchar** outbuf, gsize* outbytes_left);
(ff:bind-c-function g_iconv
     :unconverted-entry-name "g_iconv"
     :c-return-type ("size_t")
     :return-type size_t
     :c-arg-types (("GIConv") ("gchar" "*" "*") ("gsize" "*")
                   ("gchar" "*" "*") ("gsize" "*"))
     :c-arg-names (converter inbuf inbytes_left outbuf outbytes_left)
     :arguments (GIConv (* (* gchar)) (* gsize) (* (* gchar)) (* gsize))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:59 <381> 
;; gint g_iconv_close( GIConv converter);
(ff:bind-c-function g_iconv_close
     :unconverted-entry-name "g_iconv_close"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GIConv"))
     :c-arg-names (converter)
     :arguments (GIConv)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:62 <382> 
;; gchar* g_convert( const gchar* str, gssize len, const gchar* to_codeset,
;;              const gchar* from_codeset, gsize* bytes_read, gsize*
;;   bytes_written, GError
;;   ** error);
(ff:bind-c-function g_convert
     :unconverted-entry-name "g_convert"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize")
                   ("const" "gchar" "*") ("const" "gchar" "*")
                   ("gsize" "*") ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (str len to_codeset from_codeset bytes_read
                   bytes_written error)
     :arguments ((* gchar) gssize (* gchar) (* gchar) (* gsize)
                 (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:69 <383> 
;; gchar* g_convert_with_iconv( const gchar* str, gssize len, GIConv
;;   converter,
;;              gsize* bytes_read, gsize* bytes_written, GError** error);
(ff:bind-c-function g_convert_with_iconv
     :unconverted-entry-name "g_convert_with_iconv"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("GIConv")
                   ("gsize" "*") ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (str len converter bytes_read bytes_written error)
     :arguments ((* gchar) gssize GIConv (* gsize) (* gsize)
                 (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:75 <384> 
;; gchar* g_convert_with_fallback( const gchar* str, gssize len, const
;;   gchar
;;   * to_codeset, const gchar* from_codeset, gchar* fallback, gsize*
;;   bytes_read,
;;              gsize* bytes_written, GError** error);
(ff:bind-c-function g_convert_with_fallback
     :unconverted-entry-name "g_convert_with_fallback"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize")
                   ("const" "gchar" "*") ("const" "gchar" "*")
                   ("gchar" "*") ("gsize" "*") ("gsize" "*")
                   ("GError" "*" "*"))
     :c-arg-names (str len to_codeset from_codeset fallback bytes_read
                   bytes_written error)
     :arguments ((* gchar) gssize (* gchar) (* gchar) (* gchar)
                 (* gsize) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:87 <385> 
;; gchar* g_locale_to_utf8( const gchar* opsysstring, gssize len, gsize*
;;    bytes_read, gsize* bytes_written, GError** error);
(ff:bind-c-function g_locale_to_utf8
     :unconverted-entry-name "g_locale_to_utf8"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("gsize" "*")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (opsysstring len bytes_read bytes_written error)
     :arguments ((* gchar) gssize (* gsize) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:92 <386> 
;; gchar* g_locale_from_utf8( const gchar* utf8string, gssize len, gsize
;;   * bytes_read, gsize* bytes_written, GError** error);
(ff:bind-c-function g_locale_from_utf8
     :unconverted-entry-name "g_locale_from_utf8"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("gsize" "*")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (utf8string len bytes_read bytes_written error)
     :arguments ((* gchar) gssize (* gsize) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:101 <387> 
;; gchar* g_filename_to_utf8( const gchar* opsysstring, gssize len, gsize
;;   * bytes_read, gsize* bytes_written, GError** error);
(ff:bind-c-function g_filename_to_utf8
     :unconverted-entry-name "g_filename_to_utf8"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("gsize" "*")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (opsysstring len bytes_read bytes_written error)
     :arguments ((* gchar) gssize (* gsize) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:106 <388> 
;; gchar* g_filename_from_utf8( const gchar* utf8string, gssize len, gsize
;;   * bytes_read, gsize* bytes_written, GError** error);
(ff:bind-c-function g_filename_from_utf8
     :unconverted-entry-name "g_filename_from_utf8"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("gsize" "*")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (utf8string len bytes_read bytes_written error)
     :arguments ((* gchar) gssize (* gsize) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:112 <389> 
;; gchar* g_filename_from_uri( const char* uri, char** hostname, GError*
;;   * error);
(ff:bind-c-function g_filename_from_uri
     :unconverted-entry-name "g_filename_from_uri"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "char" "*") ("char" "*" "*")
                   ("GError" "*" "*"))
     :c-arg-names (uri hostname error)
     :arguments ((* :char) (* (* :char)) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gconvert.h:116 <390> 
;; gchar* g_filename_to_uri( const char* filename, const char* hostname,
;;              GError** error);
(ff:bind-c-function g_filename_to_uri
     :unconverted-entry-name "g_filename_to_uri"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "char" "*") ("const" "char" "*")
                   ("GError" "*" "*"))
     :c-arg-names (filename hostname error)
     :arguments ((* :char) (* :char) (* (* GError)))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:34 <391> 
;; typedef struct _GData GData;
(ff:bind-c-typedef _GData
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GData _GData)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:36 <392> 
;; typedef void(* GDataForeachFunc)( GQuark key_id, gpointer data, gpointer
;;    user_data);
(ff:bind-c-type GDataForeachFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:42 <393> 
;; void g_datalist_init( GData** datalist);
(ff:bind-c-function g_datalist_init
     :unconverted-entry-name "g_datalist_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*"))
     :c-arg-names (datalist)
     :arguments ((* (* GData)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:43 <394> 
;; void g_datalist_clear( GData** datalist);
(ff:bind-c-function g_datalist_clear
     :unconverted-entry-name "g_datalist_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*"))
     :c-arg-names (datalist)
     :arguments ((* (* GData)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:44 <395> 
;; gpointer g_datalist_id_get_data( GData** datalist, GQuark key_id);
(ff:bind-c-function g_datalist_id_get_data
     :unconverted-entry-name "g_datalist_id_get_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GData" "*" "*") ("GQuark"))
     :c-arg-names (datalist key_id)
     :arguments ((* (* GData)) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:46 <396> 
;; void g_datalist_id_set_data_full( GData** datalist, GQuark key_id,
;;   gpointer
;;    data, GDestroyNotify destroy_func);
(ff:bind-c-function g_datalist_id_set_data_full
     :unconverted-entry-name "g_datalist_id_set_data_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*") ("GQuark") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (datalist key_id data destroy_func)
     :arguments ((* (* GData)) GQuark gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:50 <397> 
;; gpointer g_datalist_id_remove_no_notify( GData** datalist, GQuark key_id
;;   );
(ff:bind-c-function g_datalist_id_remove_no_notify
     :unconverted-entry-name "g_datalist_id_remove_no_notify"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GData" "*" "*") ("GQuark"))
     :c-arg-names (datalist key_id)
     :arguments ((* (* GData)) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:52 <398> 
;; void g_datalist_foreach( GData** datalist, GDataForeachFunc func,
;;   gpointer
;;    user_data);
(ff:bind-c-function g_datalist_foreach
     :unconverted-entry-name "g_datalist_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*") ("GDataForeachFunc") ("gpointer"))
     :c-arg-names (datalist func user_data)
     :arguments ((* (* GData)) GDataForeachFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:73 <399> 
;; void g_dataset_destroy( gconstpointer dataset_location);
(ff:bind-c-function g_dataset_destroy
     :unconverted-entry-name "g_dataset_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer"))
     :c-arg-names (dataset_location)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:74 <400> 
;; gpointer g_dataset_id_get_data( gconstpointer dataset_location, GQuark
;;    key_id);
(ff:bind-c-function g_dataset_id_get_data
     :unconverted-entry-name "g_dataset_id_get_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gconstpointer") ("GQuark"))
     :c-arg-names (dataset_location key_id)
     :arguments (gconstpointer GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:76 <401> 
;; void g_dataset_id_set_data_full( gconstpointer dataset_location, GQuark
;;    key_id, gpointer data, GDestroyNotify destroy_func);
(ff:bind-c-function g_dataset_id_set_data_full
     :unconverted-entry-name "g_dataset_id_set_data_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer") ("GQuark") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (dataset_location key_id data destroy_func)
     :arguments (gconstpointer GQuark gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:80 <402> 
;; gpointer g_dataset_id_remove_no_notify( gconstpointer dataset_location,
;;              GQuark key_id);
(ff:bind-c-function g_dataset_id_remove_no_notify
     :unconverted-entry-name "g_dataset_id_remove_no_notify"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gconstpointer") ("GQuark"))
     :c-arg-names (dataset_location key_id)
     :arguments (gconstpointer GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdataset.h:82 <403> 
;; void g_dataset_foreach( gconstpointer dataset_location, GDataForeachFunc
;;    func, gpointer user_data);
(ff:bind-c-function g_dataset_foreach
     :unconverted-entry-name "g_dataset_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer") ("GDataForeachFunc") ("gpointer"))
     :c-arg-names (dataset_location func user_data)
     :arguments (gconstpointer GDataForeachFunc gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:43 <404> 
;; typedef gint32 GTime;
(ff:bind-c-type GTime gint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:44 <405> 
;; typedef guint16 GDateYear;
(ff:bind-c-type GDateYear guint16)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:45 <406> 
;; typedef guint8 GDateDay;
(ff:bind-c-type GDateDay guint8)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:46 <407> 
;; typedef struct _GDate GDate;
(ff:bind-c-typedef _GDate
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GDate _GDate)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:48 <408> 
;; struct tm;

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:51 <409> 
;; typedef enum {
;;         G_DATE_DAY =  0x000000000, G_DATE_MONTH =  0x000000001,
;;   G_DATE_YEAR =
;;     0x000000002 } GDateDMY;
(ff:bind-c-constant G_DATE_DAY 0) ;;  G_DATE_DAY =  0x000000000 
(ff:bind-c-constant G_DATE_MONTH 1) ;;  G_DATE_MONTH =  0x000000001 
(ff:bind-c-constant G_DATE_YEAR 2) ;;  G_DATE_YEAR =  0x000000002 
(ff:bind-c-type GDateDMY :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:59 <410> 
;; typedef enum {
;;         G_DATE_BAD_WEEKDAY =  0x000000000, G_DATE_MONDAY =  0x000000001,
;;   G_DATE_TUESDAY
;;    =  0x000000002, G_DATE_WEDNESDAY =  0x000000003, G_DATE_THURSDAY =
;;   0x000000004,
;;              G_DATE_FRIDAY =  0x000000005, G_DATE_SATURDAY =
;;   0x000000006, G_DATE_SUNDAY
;;    =  0x000000007 } GDateWeekday;
(ff:bind-c-constant G_DATE_BAD_WEEKDAY
                    0) ;;
;;   G_DATE_BAD_WEEKDAY =  0x000000000 
(ff:bind-c-constant G_DATE_MONDAY 1) ;;  G_DATE_MONDAY =  0x000000001 
(ff:bind-c-constant G_DATE_TUESDAY 2) ;;  G_DATE_TUESDAY =  0x000000002 
(ff:bind-c-constant G_DATE_WEDNESDAY
                    3) ;;
;;   G_DATE_WEDNESDAY =  0x000000003 
(ff:bind-c-constant G_DATE_THURSDAY
                    4) ;;
;;   G_DATE_THURSDAY =  0x000000004 
(ff:bind-c-constant G_DATE_FRIDAY 5) ;;  G_DATE_FRIDAY =  0x000000005 
(ff:bind-c-constant G_DATE_SATURDAY
                    6) ;;
;;   G_DATE_SATURDAY =  0x000000006 
(ff:bind-c-constant G_DATE_SUNDAY 7) ;;  G_DATE_SUNDAY =  0x000000007 
(ff:bind-c-type GDateWeekday :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:70 <411> 
;; typedef enum {
;;         G_DATE_BAD_MONTH =  0x000000000, G_DATE_JANUARY =  0x000000001,
;;   G_DATE_FEBRUARY
;;    =  0x000000002, G_DATE_MARCH =  0x000000003, G_DATE_APRIL =
;;   0x000000004,
;;              G_DATE_MAY =  0x000000005, G_DATE_JUNE =  0x000000006,
;;   G_DATE_JULY =  0x000000007,
;;              G_DATE_AUGUST =  0x000000008, G_DATE_SEPTEMBER =
;;   0x000000009, G_DATE_OCTOBER
;;    =  0x00000000a, G_DATE_NOVEMBER =  0x00000000b, G_DATE_DECEMBER =
;;   0x00000000c
;;    } GDateMonth;
(ff:bind-c-constant G_DATE_BAD_MONTH
                    0) ;;
;;   G_DATE_BAD_MONTH =  0x000000000 
(ff:bind-c-constant G_DATE_JANUARY 1) ;;  G_DATE_JANUARY =  0x000000001 
(ff:bind-c-constant G_DATE_FEBRUARY
                    2) ;;
;;   G_DATE_FEBRUARY =  0x000000002 
(ff:bind-c-constant G_DATE_MARCH 3) ;;  G_DATE_MARCH =  0x000000003 
(ff:bind-c-constant G_DATE_APRIL 4) ;;  G_DATE_APRIL =  0x000000004 
(ff:bind-c-constant G_DATE_MAY 5) ;;  G_DATE_MAY =  0x000000005 
(ff:bind-c-constant G_DATE_JUNE 6) ;;  G_DATE_JUNE =  0x000000006 
(ff:bind-c-constant G_DATE_JULY 7) ;;  G_DATE_JULY =  0x000000007 
(ff:bind-c-constant G_DATE_AUGUST 8) ;;  G_DATE_AUGUST =  0x000000008 
(ff:bind-c-constant G_DATE_SEPTEMBER
                    9) ;;
;;   G_DATE_SEPTEMBER =  0x000000009 
(ff:bind-c-constant G_DATE_OCTOBER
                    10) ;;
;;   G_DATE_OCTOBER =  0x00000000a 
(ff:bind-c-constant G_DATE_NOVEMBER
                    11) ;;
;;   G_DATE_NOVEMBER =  0x00000000b 
(ff:bind-c-constant G_DATE_DECEMBER
                    12) ;;
;;   G_DATE_DECEMBER =  0x00000000c 
(ff:bind-c-type GDateMonth :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:96 <412> 
;; struct _GDate {
;;         guint julian_days:  0x000000020; guint julian:  0x000000001;
;;   guint dmy
;;   :  0x000000001; guint day:  0x000000006; guint month:  0x000000004;
;;   guint
;;    year:  0x000000010; };

;;WARNING: Strange bitfield julian_days type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield julian type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield dmy type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield day type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield month type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield year type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GDate (:struct
  (julian_days (:bit 32))   ;; guint julian_days:  0x000000020
  (julian (:bit 1))   ;; guint julian:  0x000000001
  (dmy (:bit 1))   ;; guint dmy:  0x000000001
  (day (:bit 6))   ;; guint day:  0x000000006
  (month (:bit 4))   ;; guint month:  0x000000004
  (year (:bit 16))   ;; guint year:  0x000000010
  ))   ;; bind-c-type _GDate
(ff:bind-c-typedef GDate _GDate) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:117 <413> 
;; GDate* g_date_new( void);
(ff:bind-c-function g_date_new
     :unconverted-entry-name "g_date_new"
     :c-return-type ("GDate" "*")
     :return-type (* GDate)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:118 <414> 
;; GDate* g_date_new_dmy( GDateDay day, GDateMonth month, GDateYear year);
(ff:bind-c-function g_date_new_dmy
     :unconverted-entry-name "g_date_new_dmy"
     :c-return-type ("GDate" "*")
     :return-type (* GDate)
     :c-arg-types (("GDateDay") ("GDateMonth") ("GDateYear"))
     :c-arg-names (day month year)
     :arguments (GDateDay GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:121 <415> 
;; GDate* g_date_new_julian( guint32 julian_day);
(ff:bind-c-function g_date_new_julian
     :unconverted-entry-name "g_date_new_julian"
     :c-return-type ("GDate" "*")
     :return-type (* GDate)
     :c-arg-types (("guint32"))
     :c-arg-names (julian_day)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:122 <416> 
;; void g_date_free( GDate* date);
(ff:bind-c-function g_date_free
     :unconverted-entry-name "g_date_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:129 <417> 
;; gboolean g_date_valid( const GDate* date);
(ff:bind-c-function g_date_valid
     :unconverted-entry-name "g_date_valid"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:130 <418> 
;; gboolean g_date_valid_day( GDateDay day);
(ff:bind-c-function g_date_valid_day
     :unconverted-entry-name "g_date_valid_day"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateDay"))
     :c-arg-names (day)
     :arguments (GDateDay)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:131 <419> 
;; gboolean g_date_valid_month( GDateMonth month);
(ff:bind-c-function g_date_valid_month
     :unconverted-entry-name "g_date_valid_month"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateMonth"))
     :c-arg-names (month)
     :arguments (GDateMonth)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:132 <420> 
;; gboolean g_date_valid_year( GDateYear year);
(ff:bind-c-function g_date_valid_year
     :unconverted-entry-name "g_date_valid_year"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:133 <421> 
;; gboolean g_date_valid_weekday( GDateWeekday weekday);
(ff:bind-c-function g_date_valid_weekday
     :unconverted-entry-name "g_date_valid_weekday"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateWeekday"))
     :c-arg-names (weekday)
     :arguments (GDateWeekday)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:134 <422> 
;; gboolean g_date_valid_julian( guint32 julian_date);
(ff:bind-c-function g_date_valid_julian
     :unconverted-entry-name "g_date_valid_julian"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint32"))
     :c-arg-names (julian_date)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:135 <423> 
;; gboolean g_date_valid_dmy( GDateDay day, GDateMonth month, GDateYear
;;   year
;;   );
(ff:bind-c-function g_date_valid_dmy
     :unconverted-entry-name "g_date_valid_dmy"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateDay") ("GDateMonth") ("GDateYear"))
     :c-arg-names (day month year)
     :arguments (GDateDay GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:139 <424> 
;; GDateWeekday g_date_get_weekday( const GDate* date);
(ff:bind-c-function g_date_get_weekday
     :all-names ((g_date_weekday . "g_date_weekday")
                 (g_date_get_weekday . "g_date_get_weekday"))
     :unconverted-entry-name "g_date_get_weekday"
     :c-return-type ("GDateWeekday")
     :return-type GDateWeekday
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:140 <425> 
;; GDateMonth g_date_get_month( const GDate* date);
(ff:bind-c-function g_date_get_month
     :all-names ((g_date_month_f . "g_date_month"); bug15263
                 (g_date_get_month . "g_date_get_month"))
     :unconverted-entry-name "g_date_get_month"
     :c-return-type ("GDateMonth")
     :return-type GDateMonth
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:141 <426> 
;; GDateYear g_date_get_year( const GDate* date);
(ff:bind-c-function g_date_get_year
     :all-names ((g_date_year_f . "g_date_year"); bug15263
                 (g_date_get_year . "g_date_get_year"))
     :unconverted-entry-name "g_date_get_year"
     :c-return-type ("GDateYear")
     :return-type GDateYear
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:142 <427> 
;; GDateDay g_date_get_day( const GDate* date);
(ff:bind-c-function g_date_get_day
     :all-names ((g_date_day_f . "g_date_day"); bug15263
                 (g_date_get_day . "g_date_get_day"))
     :unconverted-entry-name "g_date_get_day"
     :c-return-type ("GDateDay")
     :return-type GDateDay
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:143 <428> 
;; guint32 g_date_get_julian( const GDate* date);
(ff:bind-c-function g_date_get_julian
     :all-names ((g_date_julian . "g_date_julian")
                 (g_date_get_julian . "g_date_get_julian"))
     :unconverted-entry-name "g_date_get_julian"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:144 <429> 
;; guint g_date_get_day_of_year( const GDate* date);
(ff:bind-c-function g_date_get_day_of_year
     :all-names ((g_date_day_of_year . "g_date_day_of_year")
                 (g_date_get_day_of_year . "g_date_get_day_of_year"))
     :unconverted-entry-name "g_date_get_day_of_year"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:151 <430> 
;; guint g_date_get_monday_week_of_year( const GDate* date);
(ff:bind-c-function g_date_get_monday_week_of_year
     :all-names ((g_date_monday_week_of_year
                  . "g_date_monday_week_of_year")
                 (g_date_get_monday_week_of_year
                  . "g_date_get_monday_week_of_year"))
     :unconverted-entry-name "g_date_get_monday_week_of_year"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:152 <431> 
;; guint g_date_get_sunday_week_of_year( const GDate* date);
(ff:bind-c-function g_date_get_sunday_week_of_year
     :all-names ((g_date_sunday_week_of_year
                  . "g_date_sunday_week_of_year")
                 (g_date_get_sunday_week_of_year
                  . "g_date_get_sunday_week_of_year"))
     :unconverted-entry-name "g_date_get_sunday_week_of_year"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:158 <432> 
;; void g_date_clear( GDate* date, guint n_dates);
(ff:bind-c-function g_date_clear
     :unconverted-entry-name "g_date_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_dates)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:165 <433> 
;; void g_date_set_parse( GDate* date, const gchar* str);
(ff:bind-c-function g_date_set_parse
     :unconverted-entry-name "g_date_set_parse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("const" "gchar" "*"))
     :c-arg-names (date str)
     :arguments ((* GDate) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:167 <434> 
;; void g_date_set_time( GDate* date, GTime time);
(ff:bind-c-function g_date_set_time
     :unconverted-entry-name "g_date_set_time"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GTime"))
     :c-arg-names (date time)
     :arguments ((* GDate) GTime)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:169 <435> 
;; void g_date_set_month( GDate* date, GDateMonth month);
(ff:bind-c-function g_date_set_month
     :unconverted-entry-name "g_date_set_month"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateMonth"))
     :c-arg-names (date month)
     :arguments ((* GDate) GDateMonth)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:171 <436> 
;; void g_date_set_day( GDate* date, GDateDay day);
(ff:bind-c-function g_date_set_day
     :unconverted-entry-name "g_date_set_day"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateDay"))
     :c-arg-names (date day)
     :arguments ((* GDate) GDateDay)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:173 <437> 
;; void g_date_set_year( GDate* date, GDateYear year);
(ff:bind-c-function g_date_set_year
     :unconverted-entry-name "g_date_set_year"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateYear"))
     :c-arg-names (date year)
     :arguments ((* GDate) GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:175 <438> 
;; void g_date_set_dmy( GDate* date, GDateDay day, GDateMonth month,
;;   GDateYear
;;    y);
(ff:bind-c-function g_date_set_dmy
     :unconverted-entry-name "g_date_set_dmy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateDay") ("GDateMonth")
                   ("GDateYear"))
     :c-arg-names (date day month y)
     :arguments ((* GDate) GDateDay GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:179 <439> 
;; void g_date_set_julian( GDate* date, guint32 julian_date);
(ff:bind-c-function g_date_set_julian
     :unconverted-entry-name "g_date_set_julian"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint32"))
     :c-arg-names (date julian_date)
     :arguments ((* GDate) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:181 <440> 
;; gboolean g_date_is_first_of_month( const GDate* date);
(ff:bind-c-function g_date_is_first_of_month
     :unconverted-entry-name "g_date_is_first_of_month"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:182 <441> 
;; gboolean g_date_is_last_of_month( const GDate* date);
(ff:bind-c-function g_date_is_last_of_month
     :unconverted-entry-name "g_date_is_last_of_month"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:185 <442> 
;; void g_date_add_days( GDate* date, guint n_days);
(ff:bind-c-function g_date_add_days
     :unconverted-entry-name "g_date_add_days"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_days)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:187 <443> 
;; void g_date_subtract_days( GDate* date, guint n_days);
(ff:bind-c-function g_date_subtract_days
     :unconverted-entry-name "g_date_subtract_days"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_days)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:191 <444> 
;; void g_date_add_months( GDate* date, guint n_months);
(ff:bind-c-function g_date_add_months
     :unconverted-entry-name "g_date_add_months"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_months)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:193 <445> 
;; void g_date_subtract_months( GDate* date, guint n_months);
(ff:bind-c-function g_date_subtract_months
     :unconverted-entry-name "g_date_subtract_months"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_months)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:197 <446> 
;; void g_date_add_years( GDate* date, guint n_years);
(ff:bind-c-function g_date_add_years
     :unconverted-entry-name "g_date_add_years"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_years)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:199 <447> 
;; void g_date_subtract_years( GDate* date, guint n_years);
(ff:bind-c-function g_date_subtract_years
     :unconverted-entry-name "g_date_subtract_years"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_years)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:201 <448> 
;; gboolean g_date_is_leap_year( GDateYear year);
(ff:bind-c-function g_date_is_leap_year
     :unconverted-entry-name "g_date_is_leap_year"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:202 <449> 
;; guint8 g_date_get_days_in_month( GDateMonth month, GDateYear year);
(ff:bind-c-function g_date_get_days_in_month
     :all-names ((g_date_days_in_month . "g_date_days_in_month")
                 (g_date_get_days_in_month
                  . "g_date_get_days_in_month"))
     :unconverted-entry-name "g_date_get_days_in_month"
     :c-return-type ("guint8")
     :return-type guint8
     :c-arg-types (("GDateMonth") ("GDateYear"))
     :c-arg-names (month year)
     :arguments (GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:204 <450> 
;; guint8 g_date_get_monday_weeks_in_year( GDateYear year);
(ff:bind-c-function g_date_get_monday_weeks_in_year
     :all-names ((g_date_monday_weeks_in_year
                  . "g_date_monday_weeks_in_year")
                 (g_date_get_monday_weeks_in_year
                  . "g_date_get_monday_weeks_in_year"))
     :unconverted-entry-name "g_date_get_monday_weeks_in_year"
     :c-return-type ("guint8")
     :return-type guint8
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:205 <451> 
;; guint8 g_date_get_sunday_weeks_in_year( GDateYear year);
(ff:bind-c-function g_date_get_sunday_weeks_in_year
     :all-names ((g_date_sunday_weeks_in_year
                  . "g_date_sunday_weeks_in_year")
                 (g_date_get_sunday_weeks_in_year
                  . "g_date_get_sunday_weeks_in_year"))
     :unconverted-entry-name "g_date_get_sunday_weeks_in_year"
     :c-return-type ("guint8")
     :return-type guint8
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:209 <452> 
;; gint g_date_days_between( const GDate* date1, const GDate* date2);
(ff:bind-c-function g_date_days_between
     :unconverted-entry-name "g_date_days_between"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "GDate" "*") ("const" "GDate" "*"))
     :c-arg-names (date1 date2)
     :arguments ((* GDate) (* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:213 <453> 
;; gint g_date_compare( const GDate* lhs, const GDate* rhs);
(ff:bind-c-function g_date_compare
     :unconverted-entry-name "g_date_compare"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "GDate" "*") ("const" "GDate" "*"))
     :c-arg-names (lhs rhs)
     :arguments ((* GDate) (* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:215 <454> 
;; void g_date_to_struct_tm( const GDate* date, struct tm* tm);
(ff:bind-c-function g_date_to_struct_tm
     :unconverted-entry-name "g_date_to_struct_tm"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GDate" "*") ("struct" "*"))
     :c-arg-names (date tm)
     :arguments ((* GDate) (* tm))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:218 <455> 
;; void g_date_clamp( GDate* date, const GDate* min_date, const GDate*
;;   max_date
;;   );
(ff:bind-c-function g_date_clamp
     :unconverted-entry-name "g_date_clamp"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("const" "GDate" "*")
                   ("const" "GDate" "*"))
     :c-arg-names (date min_date max_date)
     :arguments ((* GDate) (* GDate) (* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:223 <456> 
;; void g_date_order( GDate* date1, GDate* date2);
(ff:bind-c-function g_date_order
     :unconverted-entry-name "g_date_order"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDate" "*"))
     :c-arg-names (date1 date2)
     :arguments ((* GDate) (* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdate.h:228 <457> 
;; gsize g_date_strftime( gchar* s, gsize slen, const gchar* format, const
;;    GDate* date);
(ff:bind-c-function g_date_strftime
     :unconverted-entry-name "g_date_strftime"
     :c-return-type ("gsize")
     :return-type gsize
     :c-arg-types (("gchar" "*") ("gsize") ("const" "gchar" "*")
                   ("const" "GDate" "*"))
     :c-arg-names (s slen format date)
     :arguments ((* gchar) gsize (* gchar) (* GDate))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdir.h:8 <458> 
;; typedef struct _GDir GDir;
(ff:bind-c-typedef _GDir
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GDir _GDir)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdir.h:10 <459> 
;; GDir* g_dir_open( const gchar* path, guint flags, GError** error);
(ff:bind-c-function g_dir_open
     :unconverted-entry-name "g_dir_open"
     :c-return-type ("GDir" "*")
     :return-type (* GDir)
     :c-arg-types (("const" "gchar" "*") ("guint") ("GError" "*" "*"))
     :c-arg-names (path flags error)
     :arguments ((* gchar) guint (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdir.h:13 <460> 
;; const gchar* g_dir_read_name( GDir* dir);
(ff:bind-c-function g_dir_read_name
     :unconverted-entry-name "g_dir_read_name"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GDir" "*"))
     :c-arg-names (dir)
     :arguments ((* GDir))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdir.h:14 <461> 
;; void g_dir_rewind( GDir* dir);
(ff:bind-c-function g_dir_rewind
     :unconverted-entry-name "g_dir_rewind"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDir" "*"))
     :c-arg-names (dir)
     :arguments ((* GDir))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gdir.h:15 <462> 
;; void g_dir_close( GDir* dir);
(ff:bind-c-function g_dir_close
     :unconverted-entry-name "g_dir_close"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDir" "*"))
     :c-arg-names (dir)
     :arguments ((* GDir))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:30 <463> 
;; typedef enum {
;;         G_FILE_ERROR_EXIST, G_FILE_ERROR_ISDIR, G_FILE_ERROR_ACCES,
;;   G_FILE_ERROR_NAMETOOLONG,
;;              G_FILE_ERROR_NOENT, G_FILE_ERROR_NOTDIR, G_FILE_ERROR_NXIO,
;;   G_FILE_ERROR_NODEV,
;;              G_FILE_ERROR_ROFS, G_FILE_ERROR_TXTBSY, G_FILE_ERROR_FAULT,
;;   G_FILE_ERROR_LOOP,
;;              G_FILE_ERROR_NOSPC, G_FILE_ERROR_NOMEM, G_FILE_ERROR_MFILE,
;;   G_FILE_ERROR_NFILE,
;;              G_FILE_ERROR_BADF, G_FILE_ERROR_INVAL, G_FILE_ERROR_PIPE,
;;   G_FILE_ERROR_AGAIN,
;;              G_FILE_ERROR_INTR, G_FILE_ERROR_IO, G_FILE_ERROR_PERM,
;;   G_FILE_ERROR_FAILED
;;    } GFileError;
(ff:bind-c-constant G_FILE_ERROR_EXIST 0) ;;  G_FILE_ERROR_EXIST 
(ff:bind-c-constant G_FILE_ERROR_ISDIR 1) ;;  G_FILE_ERROR_ISDIR 
(ff:bind-c-constant G_FILE_ERROR_ACCES 2) ;;  G_FILE_ERROR_ACCES 
(ff:bind-c-constant G_FILE_ERROR_NAMETOOLONG
                    3) ;;
;;   G_FILE_ERROR_NAMETOOLONG 
(ff:bind-c-constant G_FILE_ERROR_NOENT 4) ;;  G_FILE_ERROR_NOENT 
(ff:bind-c-constant G_FILE_ERROR_NOTDIR 5) ;;  G_FILE_ERROR_NOTDIR 
(ff:bind-c-constant G_FILE_ERROR_NXIO 6) ;;  G_FILE_ERROR_NXIO 
(ff:bind-c-constant G_FILE_ERROR_NODEV 7) ;;  G_FILE_ERROR_NODEV 
(ff:bind-c-constant G_FILE_ERROR_ROFS 8) ;;  G_FILE_ERROR_ROFS 
(ff:bind-c-constant G_FILE_ERROR_TXTBSY 9) ;;  G_FILE_ERROR_TXTBSY 
(ff:bind-c-constant G_FILE_ERROR_FAULT 10) ;;  G_FILE_ERROR_FAULT 
(ff:bind-c-constant G_FILE_ERROR_LOOP 11) ;;  G_FILE_ERROR_LOOP 
(ff:bind-c-constant G_FILE_ERROR_NOSPC 12) ;;  G_FILE_ERROR_NOSPC 
(ff:bind-c-constant G_FILE_ERROR_NOMEM 13) ;;  G_FILE_ERROR_NOMEM 
(ff:bind-c-constant G_FILE_ERROR_MFILE 14) ;;  G_FILE_ERROR_MFILE 
(ff:bind-c-constant G_FILE_ERROR_NFILE 15) ;;  G_FILE_ERROR_NFILE 
(ff:bind-c-constant G_FILE_ERROR_BADF 16) ;;  G_FILE_ERROR_BADF 
(ff:bind-c-constant G_FILE_ERROR_INVAL 17) ;;  G_FILE_ERROR_INVAL 
(ff:bind-c-constant G_FILE_ERROR_PIPE 18) ;;  G_FILE_ERROR_PIPE 
(ff:bind-c-constant G_FILE_ERROR_AGAIN 19) ;;  G_FILE_ERROR_AGAIN 
(ff:bind-c-constant G_FILE_ERROR_INTR 20) ;;  G_FILE_ERROR_INTR 
(ff:bind-c-constant G_FILE_ERROR_IO 21) ;;  G_FILE_ERROR_IO 
(ff:bind-c-constant G_FILE_ERROR_PERM 22) ;;  G_FILE_ERROR_PERM 
(ff:bind-c-constant G_FILE_ERROR_FAILED 23) ;;  G_FILE_ERROR_FAILED 
(ff:bind-c-type GFileError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:62 <464> 
;; typedef enum {
;;         G_FILE_TEST_IS_REGULAR =  0x000000001 LSHIFT  0x000000000,
;;   G_FILE_TEST_IS_SYMLINK
;;    =  0x000000001 LSHIFT  0x000000001, G_FILE_TEST_IS_DIR =  0x000000001
;;    LSHIFT  0x000000002, G_FILE_TEST_IS_EXECUTABLE =  0x000000001 LSHIFT
;;   0x000000003,
;;              G_FILE_TEST_EXISTS =  0x000000001 LSHIFT  0x000000004 }
;;   GFileTest;
(ff:bind-c-constant G_FILE_TEST_IS_REGULAR
                    1) ;;
;;   G_FILE_TEST_IS_REGULAR =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_FILE_TEST_IS_SYMLINK
                    2) ;;
;;   G_FILE_TEST_IS_SYMLINK =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_FILE_TEST_IS_DIR
                    4) ;;
;;   G_FILE_TEST_IS_DIR =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_FILE_TEST_IS_EXECUTABLE
                    8) ;;
;;   G_FILE_TEST_IS_EXECUTABLE =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_FILE_TEST_EXISTS
                    16) ;;
;;   G_FILE_TEST_EXISTS =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-type GFileTest :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:71 <465> 
;; GQuark g_file_error_quark( void);
(ff:bind-c-function g_file_error_quark
     :unconverted-entry-name "g_file_error_quark"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:73 <466> 
;; GFileError g_file_error_from_errno( gint err_no);
(ff:bind-c-function g_file_error_from_errno
     :unconverted-entry-name "g_file_error_from_errno"
     :c-return-type ("GFileError")
     :return-type GFileError
     :c-arg-types (("gint"))
     :c-arg-names (err_no)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:75 <467> 
;; gboolean g_file_test( const gchar* filename, GFileTest test);
(ff:bind-c-function g_file_test
     :unconverted-entry-name "g_file_test"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("GFileTest"))
     :c-arg-names (filename test)
     :arguments ((* gchar) GFileTest)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:77 <468> 
;; gboolean g_file_get_contents( const gchar* filename, gchar** contents,
;;              gsize* length, GError** error);
(ff:bind-c-function g_file_get_contents
     :unconverted-entry-name "g_file_get_contents"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (filename contents length error)
     :arguments ((* gchar) (* (* gchar)) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:84 <469> 
;; int g_mkstemp( char* tmpl);
(ff:bind-c-function g_mkstemp
     :unconverted-entry-name "g_mkstemp"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("char" "*"))
     :c-arg-names (tmpl)
     :arguments ((* :char))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:87 <470> 
;; int g_file_open_tmp( const char* tmpl, char** name_used, GError**
;;   error);
(ff:bind-c-function g_file_open_tmp
     :unconverted-entry-name "g_file_open_tmp"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("const" "char" "*") ("char" "*" "*")
                   ("GError" "*" "*"))
     :c-arg-names (tmpl name_used error)
     :arguments ((* :char) (* (* :char)) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:91 <471> 
;; gchar* g_build_path( const gchar* separator, const gchar* first_element
;;   , ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_build_path
     :unconverted-entry-name "g_build_path"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*") "...")
     :c-arg-names (separator first_element)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gfileutils.h:94 <472> 
;; gchar* g_build_filename( const gchar* first_element, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_build_filename
     :unconverted-entry-name "g_build_filename"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (first_element)
     :arguments nil
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:34 <473> 
;; typedef struct _GHashTable GHashTable;
(ff:bind-c-typedef _GHashTable
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GHashTable _GHashTable)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:36 <474> 
;; typedef gboolean(* GHRFunc)( gpointer key, gpointer value, gpointer
;;   user_data
;;   );
(ff:bind-c-type GHRFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:42 <475> 
;; GHashTable* g_hash_table_new( GHashFunc hash_func, GEqualFunc
;;   key_equal_func
;;   );
(ff:bind-c-function g_hash_table_new
     :unconverted-entry-name "g_hash_table_new"
     :c-return-type ("GHashTable" "*")
     :return-type (* GHashTable)
     :c-arg-types (("GHashFunc") ("GEqualFunc"))
     :c-arg-names (hash_func key_equal_func)
     :arguments (GHashFunc GEqualFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:44 <476> 
;; GHashTable* g_hash_table_new_full( GHashFunc hash_func, GEqualFunc
;;   key_equal_func,
;;              GDestroyNotify key_destroy_func, GDestroyNotify
;;   value_destroy_func);
(ff:bind-c-function g_hash_table_new_full
     :unconverted-entry-name "g_hash_table_new_full"
     :c-return-type ("GHashTable" "*")
     :return-type (* GHashTable)
     :c-arg-types (("GHashFunc") ("GEqualFunc") ("GDestroyNotify")
                   ("GDestroyNotify"))
     :c-arg-names (hash_func key_equal_func key_destroy_func
                   value_destroy_func)
     :arguments (GHashFunc GEqualFunc GDestroyNotify GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:48 <477> 
;; void g_hash_table_destroy( GHashTable* hash_table);
(ff:bind-c-function g_hash_table_destroy
     :unconverted-entry-name "g_hash_table_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*"))
     :c-arg-names (hash_table)
     :arguments ((* GHashTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:49 <478> 
;; void g_hash_table_insert( GHashTable* hash_table, gpointer key, gpointer
;;    value);
(ff:bind-c-function g_hash_table_insert
     :unconverted-entry-name "g_hash_table_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*") ("gpointer") ("gpointer"))
     :c-arg-names (hash_table key value)
     :arguments ((* GHashTable) gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:52 <479> 
;; void g_hash_table_replace( GHashTable* hash_table, gpointer key,
;;   gpointer
;;    value);
(ff:bind-c-function g_hash_table_replace
     :unconverted-entry-name "g_hash_table_replace"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*") ("gpointer") ("gpointer"))
     :c-arg-names (hash_table key value)
     :arguments ((* GHashTable) gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:55 <480> 
;; gboolean g_hash_table_remove( GHashTable* hash_table, gconstpointer
;;   key);
(ff:bind-c-function g_hash_table_remove
     :unconverted-entry-name "g_hash_table_remove"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GHashTable" "*") ("gconstpointer"))
     :c-arg-names (hash_table key)
     :arguments ((* GHashTable) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:57 <481> 
;; gboolean g_hash_table_steal( GHashTable* hash_table, gconstpointer key);
(ff:bind-c-function g_hash_table_steal
     :unconverted-entry-name "g_hash_table_steal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GHashTable" "*") ("gconstpointer"))
     :c-arg-names (hash_table key)
     :arguments ((* GHashTable) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:59 <482> 
;; gpointer g_hash_table_lookup( GHashTable* hash_table, gconstpointer
;;   key);
(ff:bind-c-function g_hash_table_lookup
     :unconverted-entry-name "g_hash_table_lookup"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GHashTable" "*") ("gconstpointer"))
     :c-arg-names (hash_table key)
     :arguments ((* GHashTable) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:61 <483> 
;; gboolean g_hash_table_lookup_extended( GHashTable* hash_table,
;;   gconstpointer
;;    lookup_key, gpointer* orig_key, gpointer* value);
(ff:bind-c-function g_hash_table_lookup_extended
     :unconverted-entry-name "g_hash_table_lookup_extended"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GHashTable" "*") ("gconstpointer")
                   ("gpointer" "*") ("gpointer" "*"))
     :c-arg-names (hash_table lookup_key orig_key value)
     :arguments ((* GHashTable) gconstpointer (* gpointer) (* gpointer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:65 <484> 
;; void g_hash_table_foreach( GHashTable* hash_table, GHFunc func, gpointer
;;    user_data);
(ff:bind-c-function g_hash_table_foreach
     :unconverted-entry-name "g_hash_table_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*") ("GHFunc") ("gpointer"))
     :c-arg-names (hash_table func user_data)
     :arguments ((* GHashTable) GHFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:68 <485> 
;; guint g_hash_table_foreach_remove( GHashTable* hash_table, GHRFunc func,
;;              gpointer user_data);
(ff:bind-c-function g_hash_table_foreach_remove
     :unconverted-entry-name "g_hash_table_foreach_remove"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GHashTable" "*") ("GHRFunc") ("gpointer"))
     :c-arg-names (hash_table func user_data)
     :arguments ((* GHashTable) GHRFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:71 <486> 
;; guint g_hash_table_foreach_steal( GHashTable* hash_table, GHRFunc func,
;;              gpointer user_data);
(ff:bind-c-function g_hash_table_foreach_steal
     :unconverted-entry-name "g_hash_table_foreach_steal"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GHashTable" "*") ("GHRFunc") ("gpointer"))
     :c-arg-names (hash_table func user_data)
     :arguments ((* GHashTable) GHRFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:74 <487> 
;; guint g_hash_table_size( GHashTable* hash_table);
(ff:bind-c-function g_hash_table_size
     :unconverted-entry-name "g_hash_table_size"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GHashTable" "*"))
     :c-arg-names (hash_table)
     :arguments ((* GHashTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:87 <488> 
;; gboolean g_str_equal( gconstpointer v, gconstpointer v2);
(ff:bind-c-function g_str_equal
     :unconverted-entry-name "g_str_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gconstpointer") ("gconstpointer"))
     :c-arg-names (v v2)
     :arguments (gconstpointer gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:89 <489> 
;; guint g_str_hash( gconstpointer v);
(ff:bind-c-function g_str_hash
     :unconverted-entry-name "g_str_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gconstpointer"))
     :c-arg-names (v)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:91 <490> 
;; gboolean g_int_equal( gconstpointer v, gconstpointer v2);
(ff:bind-c-function g_int_equal
     :unconverted-entry-name "g_int_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gconstpointer") ("gconstpointer"))
     :c-arg-names (v v2)
     :arguments (gconstpointer gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:93 <491> 
;; guint g_int_hash( gconstpointer v);
(ff:bind-c-function g_int_hash
     :unconverted-entry-name "g_int_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gconstpointer"))
     :c-arg-names (v)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:101 <492> 
;; guint g_direct_hash( gconstpointer v);
(ff:bind-c-function g_direct_hash
     :unconverted-entry-name "g_direct_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gconstpointer"))
     :c-arg-names (v)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghash.h:102 <493> 
;; gboolean g_direct_equal( gconstpointer v, gconstpointer v2);
(ff:bind-c-function g_direct_equal
     :unconverted-entry-name "g_direct_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gconstpointer") ("gconstpointer"))
     :c-arg-names (v v2)
     :arguments (gconstpointer gconstpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:36 <494> 
;; typedef struct _GHook GHook;
(ff:bind-c-typedef _GHook
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GHook _GHook)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:37 <495> 
;; typedef struct _GHookList GHookList;
(ff:bind-c-typedef _GHookList
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GHookList _GHookList)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:39 <496> 
;; typedef gint(* GHookCompareFunc)( GHook* new_hook, GHook* sibling);
(ff:bind-c-type GHookCompareFunc (* gint))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:41 <497> 
;; typedef gboolean(* GHookFindFunc)( GHook* hook, gpointer data);
(ff:bind-c-type GHookFindFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:43 <498> 
;; typedef void(* GHookMarshaller)( GHook* hook, gpointer marshal_data);
(ff:bind-c-type GHookMarshaller (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:45 <499> 
;; typedef gboolean(* GHookCheckMarshaller)( GHook* hook, gpointer
;;   marshal_data
;;   );
(ff:bind-c-type GHookCheckMarshaller (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:47 <500> 
;; typedef void(* GHookFunc)( gpointer data);
(ff:bind-c-type GHookFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:48 <501> 
;; typedef gboolean(* GHookCheckFunc)( gpointer data);
(ff:bind-c-type GHookCheckFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:49 <502> 
;; typedef void(* GHookFinalizeFunc)( GHookList* hook_list, GHook* hook);
(ff:bind-c-type GHookFinalizeFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:51 <503> 
;; typedef enum {
;;         G_HOOK_FLAG_ACTIVE =  0x000000001 LSHIFT  0x000000000,
;;   G_HOOK_FLAG_IN_CALL
;;    =  0x000000001 LSHIFT  0x000000001, G_HOOK_FLAG_MASK =  0x00000000f }
;;    GHookFlagMask;
(ff:bind-c-constant G_HOOK_FLAG_ACTIVE
                    1) ;;
;;   G_HOOK_FLAG_ACTIVE =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_HOOK_FLAG_IN_CALL
                    2) ;;
;;   G_HOOK_FLAG_IN_CALL =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_HOOK_FLAG_MASK
                    15) ;;
;;   G_HOOK_FLAG_MASK =  0x00000000f 
(ff:bind-c-type GHookFlagMask :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:61 <504> 
;; struct _GHookList {
;;         gulong seq_id; guint hook_size:  0x000000010; guint is_setup:
;;   0x000000001;
;;              GHook* hooks; GMemChunk* hook_memchunk; GHookFinalizeFunc
;;   finalize_hook;
;;              gpointer dummy[  0x000000002]; };

;;WARNING: Strange bitfield hook_size type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_setup type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GHookList (:struct
  (seq_id gulong)   ;; gulong seq_id
  (hook_size (:bit 16))   ;; guint hook_size:  0x000000010
  (is_setup (:bit 1))   ;; guint is_setup:  0x000000001
  (hooks (* GHook))   ;; GHook* hooks
  (hook_memchunk (* GMemChunk))   ;; GMemChunk* hook_memchunk
  (finalize_hook GHookFinalizeFunc)   ;; GHookFinalizeFunc finalize_hook
  (dummy (:array gpointer 2))   ;; gpointer dummy[  0x000000002]
  ))   ;; bind-c-type _GHookList
(ff:bind-c-typedef GHookList _GHookList) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:71 <505> 
;; struct _GHook {
;;         gpointer data; GHook* next; GHook* prev; guint ref_count; gulong
;;   hook_id;
;;              guint flags; gpointer func; GDestroyNotify destroy; };
(ff:bind-c-type _GHook (:struct
  (data gpointer)   ;; gpointer data
  (next (* GHook))   ;; GHook* next
  (prev (* GHook))   ;; GHook* prev
  (ref_count guint)   ;; guint ref_count
  (hook_id gulong)   ;; gulong hook_id
  (flags guint)   ;; guint flags
  (func gpointer)   ;; gpointer func
  (destroy GDestroyNotify)   ;; GDestroyNotify destroy
  ))   ;; bind-c-type _GHook
(ff:bind-c-typedef GHook _GHook) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:102 <506> 
;; void g_hook_list_init( GHookList* hook_list, guint hook_size);
(ff:bind-c-function g_hook_list_init
     :unconverted-entry-name "g_hook_list_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("guint"))
     :c-arg-names (hook_list hook_size)
     :arguments ((* GHookList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:104 <507> 
;; void g_hook_list_clear( GHookList* hook_list);
(ff:bind-c-function g_hook_list_clear
     :unconverted-entry-name "g_hook_list_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*"))
     :c-arg-names (hook_list)
     :arguments ((* GHookList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:105 <508> 
;; GHook* g_hook_alloc( GHookList* hook_list);
(ff:bind-c-function g_hook_alloc
     :unconverted-entry-name "g_hook_alloc"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*"))
     :c-arg-names (hook_list)
     :arguments ((* GHookList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:106 <509> 
;; void g_hook_free( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_free
     :unconverted-entry-name "g_hook_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:108 <510> 
;; void g_hook_ref( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_ref
     :unconverted-entry-name "g_hook_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:110 <511> 
;; void g_hook_unref( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_unref
     :unconverted-entry-name "g_hook_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:112 <512> 
;; gboolean g_hook_destroy( GHookList* hook_list, gulong hook_id);
(ff:bind-c-function g_hook_destroy
     :unconverted-entry-name "g_hook_destroy"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GHookList" "*") ("gulong"))
     :c-arg-names (hook_list hook_id)
     :arguments ((* GHookList) gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:114 <513> 
;; void g_hook_destroy_link( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_destroy_link
     :unconverted-entry-name "g_hook_destroy_link"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:116 <514> 
;; void g_hook_prepend( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_prepend
     :unconverted-entry-name "g_hook_prepend"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:118 <515> 
;; void g_hook_insert_before( GHookList* hook_list, GHook* sibling, GHook
;;   * hook);
(ff:bind-c-function g_hook_insert_before
     :unconverted-entry-name "g_hook_insert_before"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*") ("GHook" "*"))
     :c-arg-names (hook_list sibling hook)
     :arguments ((* GHookList) (* GHook) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:121 <516> 
;; void g_hook_insert_sorted( GHookList* hook_list, GHook* hook,
;;   GHookCompareFunc
;;    func);
(ff:bind-c-function g_hook_insert_sorted
     :unconverted-entry-name "g_hook_insert_sorted"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*") ("GHookCompareFunc"))
     :c-arg-names (hook_list hook func)
     :arguments ((* GHookList) (* GHook) GHookCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:124 <517> 
;; GHook* g_hook_get( GHookList* hook_list, gulong hook_id);
(ff:bind-c-function g_hook_get
     :unconverted-entry-name "g_hook_get"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gulong"))
     :c-arg-names (hook_list hook_id)
     :arguments ((* GHookList) gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:126 <518> 
;; GHook* g_hook_find( GHookList* hook_list, gboolean need_valids,
;;   GHookFindFunc
;;    func, gpointer data);
(ff:bind-c-function g_hook_find
     :unconverted-entry-name "g_hook_find"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("GHookFindFunc")
                   ("gpointer"))
     :c-arg-names (hook_list need_valids func data)
     :arguments ((* GHookList) gboolean GHookFindFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:130 <519> 
;; GHook* g_hook_find_data( GHookList* hook_list, gboolean need_valids,
;;   gpointer
;;    data);
(ff:bind-c-function g_hook_find_data
     :unconverted-entry-name "g_hook_find_data"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("gpointer"))
     :c-arg-names (hook_list need_valids data)
     :arguments ((* GHookList) gboolean gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:133 <520> 
;; GHook* g_hook_find_func( GHookList* hook_list, gboolean need_valids,
;;   gpointer
;;    func);
(ff:bind-c-function g_hook_find_func
     :unconverted-entry-name "g_hook_find_func"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("gpointer"))
     :c-arg-names (hook_list need_valids func)
     :arguments ((* GHookList) gboolean gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:136 <521> 
;; GHook* g_hook_find_func_data( GHookList* hook_list, gboolean
;;   need_valids,
;;              gpointer func, gpointer data);
(ff:bind-c-function g_hook_find_func_data
     :unconverted-entry-name "g_hook_find_func_data"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("gpointer")
                   ("gpointer"))
     :c-arg-names (hook_list need_valids func data)
     :arguments ((* GHookList) gboolean gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:141 <522> 
;; GHook* g_hook_first_valid( GHookList* hook_list, gboolean may_be_in_call
;;   );
(ff:bind-c-function g_hook_first_valid
     :unconverted-entry-name "g_hook_first_valid"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean"))
     :c-arg-names (hook_list may_be_in_call)
     :arguments ((* GHookList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:146 <523> 
;; GHook* g_hook_next_valid( GHookList* hook_list, GHook* hook, gboolean
;;    may_be_in_call);
(ff:bind-c-function g_hook_next_valid
     :unconverted-entry-name "g_hook_next_valid"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("GHook" "*") ("gboolean"))
     :c-arg-names (hook_list hook may_be_in_call)
     :arguments ((* GHookList) (* GHook) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:150 <524> 
;; gint g_hook_compare_ids( GHook* new_hook, GHook* sibling);
(ff:bind-c-function g_hook_compare_ids
     :unconverted-entry-name "g_hook_compare_ids"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GHook" "*") ("GHook" "*"))
     :c-arg-names (new_hook sibling)
     :arguments ((* GHook) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:157 <525> 
;; void g_hook_list_invoke( GHookList* hook_list, gboolean may_recurse);
(ff:bind-c-function g_hook_list_invoke
     :unconverted-entry-name "g_hook_list_invoke"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean"))
     :c-arg-names (hook_list may_recurse)
     :arguments ((* GHookList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:162 <526> 
;; void g_hook_list_invoke_check( GHookList* hook_list, gboolean
;;   may_recurse
;;   );
(ff:bind-c-function g_hook_list_invoke_check
     :unconverted-entry-name "g_hook_list_invoke_check"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean"))
     :c-arg-names (hook_list may_recurse)
     :arguments ((* GHookList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:166 <527> 
;; void g_hook_list_marshal( GHookList* hook_list, gboolean may_recurse,
;;              GHookMarshaller marshaller, gpointer marshal_data);
(ff:bind-c-function g_hook_list_marshal
     :unconverted-entry-name "g_hook_list_marshal"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean") ("GHookMarshaller")
                   ("gpointer"))
     :c-arg-names (hook_list may_recurse marshaller marshal_data)
     :arguments ((* GHookList) gboolean GHookMarshaller gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/ghook.h:170 <528> 
;; void g_hook_list_marshal_check( GHookList* hook_list, gboolean
;;   may_recurse,
;;              GHookCheckMarshaller marshaller, gpointer marshal_data);
(ff:bind-c-function g_hook_list_marshal_check
     :unconverted-entry-name "g_hook_list_marshal_check"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean")
                   ("GHookCheckMarshaller") ("gpointer"))
     :c-arg-names (hook_list may_recurse marshaller marshal_data)
     :arguments ((* GHookList) gboolean GHookCheckMarshaller gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:34 <529> 
;; typedef struct _GSList GSList;
(ff:bind-c-typedef _GSList
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSList _GSList)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:36 <530> 
;; struct _GSList { gpointer data; GSList* next; };
(ff:bind-c-type _GSList (:struct
  (data gpointer)   ;; gpointer data
  (next (* GSList))   ;; GSList* next
  ))   ;; bind-c-type _GSList
(ff:bind-c-typedef GSList _GSList) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:44 <531> 
;; void g_slist_push_allocator( GAllocator* allocator);
(ff:bind-c-function g_slist_push_allocator
     :unconverted-entry-name "g_slist_push_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:45 <532> 
;; void g_slist_pop_allocator( void);
(ff:bind-c-function g_slist_pop_allocator
     :unconverted-entry-name "g_slist_pop_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:46 <533> 
;; GSList* g_slist_alloc( void);
(ff:bind-c-function g_slist_alloc
     :unconverted-entry-name "g_slist_alloc"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:47 <534> 
;; void g_slist_free( GSList* list);
(ff:bind-c-function g_slist_free
     :unconverted-entry-name "g_slist_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:48 <535> 
;; void g_slist_free_1( GSList* list);
(ff:bind-c-function g_slist_free_1
     :unconverted-entry-name "g_slist_free_1"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:49 <536> 
;; GSList* g_slist_append( GSList* list, gpointer data);
(ff:bind-c-function g_slist_append
     :unconverted-entry-name "g_slist_append"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:51 <537> 
;; GSList* g_slist_prepend( GSList* list, gpointer data);
(ff:bind-c-function g_slist_prepend
     :unconverted-entry-name "g_slist_prepend"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:53 <538> 
;; GSList* g_slist_insert( GSList* list, gpointer data, gint position);
(ff:bind-c-function g_slist_insert
     :unconverted-entry-name "g_slist_insert"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer") ("gint"))
     :c-arg-names (list data position)
     :arguments ((* GSList) gpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:56 <539> 
;; GSList* g_slist_insert_sorted( GSList* list, gpointer data, GCompareFunc
;;    func);
(ff:bind-c-function g_slist_insert_sorted
     :unconverted-entry-name "g_slist_insert_sorted"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GSList) gpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:59 <540> 
;; GSList* g_slist_insert_before( GSList* slist, GSList* sibling, gpointer
;;    data);
(ff:bind-c-function g_slist_insert_before
     :unconverted-entry-name "g_slist_insert_before"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GSList" "*") ("gpointer"))
     :c-arg-names (slist sibling data)
     :arguments ((* GSList) (* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:62 <541> 
;; GSList* g_slist_concat( GSList* list1, GSList* list2);
(ff:bind-c-function g_slist_concat
     :unconverted-entry-name "g_slist_concat"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (list1 list2)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:64 <542> 
;; GSList* g_slist_remove( GSList* list, gconstpointer data);
(ff:bind-c-function g_slist_remove
     :unconverted-entry-name "g_slist_remove"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:66 <543> 
;; GSList* g_slist_remove_all( GSList* list, gconstpointer data);
(ff:bind-c-function g_slist_remove_all
     :unconverted-entry-name "g_slist_remove_all"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:68 <544> 
;; GSList* g_slist_remove_link( GSList* list, GSList* link);
(ff:bind-c-function g_slist_remove_link
     :unconverted-entry-name "g_slist_remove_link"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (list link)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:70 <545> 
;; GSList* g_slist_delete_link( GSList* list, GSList* link);
(ff:bind-c-function g_slist_delete_link
     :unconverted-entry-name "g_slist_delete_link"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (list link)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:72 <546> 
;; GSList* g_slist_reverse( GSList* list);
(ff:bind-c-function g_slist_reverse
     :unconverted-entry-name "g_slist_reverse"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:73 <547> 
;; GSList* g_slist_copy( GSList* list);
(ff:bind-c-function g_slist_copy
     :unconverted-entry-name "g_slist_copy"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:74 <548> 
;; GSList* g_slist_nth( GSList* list, guint n);
(ff:bind-c-function g_slist_nth
     :unconverted-entry-name "g_slist_nth"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GSList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:76 <549> 
;; GSList* g_slist_find( GSList* list, gconstpointer data);
(ff:bind-c-function g_slist_find
     :unconverted-entry-name "g_slist_find"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:78 <550> 
;; GSList* g_slist_find_custom( GSList* list, gconstpointer data,
;;   GCompareFunc
;;    func);
(ff:bind-c-function g_slist_find_custom
     :unconverted-entry-name "g_slist_find_custom"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gconstpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GSList) gconstpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:81 <551> 
;; gint g_slist_position( GSList* list, GSList* llink);
(ff:bind-c-function g_slist_position
     :unconverted-entry-name "g_slist_position"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (list llink)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:83 <552> 
;; gint g_slist_index( GSList* list, gconstpointer data);
(ff:bind-c-function g_slist_index
     :unconverted-entry-name "g_slist_index"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GSList" "*") ("gconstpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:85 <553> 
;; GSList* g_slist_last( GSList* list);
(ff:bind-c-function g_slist_last
     :unconverted-entry-name "g_slist_last"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:86 <554> 
;; guint g_slist_length( GSList* list);
(ff:bind-c-function g_slist_length
     :unconverted-entry-name "g_slist_length"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:87 <555> 
;; void g_slist_foreach( GSList* list, GFunc func, gpointer user_data);
(ff:bind-c-function g_slist_foreach
     :unconverted-entry-name "g_slist_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSList" "*") ("GFunc") ("gpointer"))
     :c-arg-names (list func user_data)
     :arguments ((* GSList) GFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:90 <556> 
;; GSList* g_slist_sort( GSList* list, GCompareFunc compare_func);
(ff:bind-c-function g_slist_sort
     :unconverted-entry-name "g_slist_sort"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GCompareFunc"))
     :c-arg-names (list compare_func)
     :arguments ((* GSList) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:92 <557> 
;; GSList* g_slist_sort_with_data( GSList* list, GCompareDataFunc
;;   compare_func,
;;              gpointer user_data);
(ff:bind-c-function g_slist_sort_with_data
     :unconverted-entry-name "g_slist_sort_with_data"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GCompareDataFunc") ("gpointer"))
     :c-arg-names (list compare_func user_data)
     :arguments ((* GSList) GCompareDataFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gslist.h:95 <558> 
;; gpointer g_slist_nth_data( GSList* list, guint n);
(ff:bind-c-function g_slist_nth_data
     :unconverted-entry-name "g_slist_nth_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GSList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GSList) guint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:28 <559> 
;; typedef struct _GMainContext GMainContext;
(ff:bind-c-typedef _GMainContext
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMainContext _GMainContext)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:29 <560> 
;; typedef struct _GMainLoop GMainLoop;
(ff:bind-c-typedef _GMainLoop
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMainLoop _GMainLoop)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:30 <561> 
;; typedef struct _GSource GSource;
(ff:bind-c-typedef _GSource
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSource _GSource)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:31 <562> 
;; typedef struct _GSourceCallbackFuncs GSourceCallbackFuncs;
(ff:bind-c-typedef _GSourceCallbackFuncs
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSourceCallbackFuncs _GSourceCallbackFuncs)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:32 <563> 
;; typedef struct _GSourceFuncs GSourceFuncs;
(ff:bind-c-typedef _GSourceFuncs
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSourceFuncs _GSourceFuncs)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:34 <564> 
;; typedef gboolean(* GSourceFunc)( gpointer data);
(ff:bind-c-type GSourceFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:36 <565> 
;; struct _GSource {
;;         gpointer callback_data; GSourceCallbackFuncs* callback_funcs;
;;   GSourceFuncs
;;   * source_funcs; guint ref_count; GMainContext* context; gint priority;
;;              guint flags; guint source_id; GSList* poll_fds; GSource*
;;   prev; GSource
;;   * next; gpointer reserved1; gpointer reserved2; };
(ff:bind-c-type _GSource (:struct
  (callback_data gpointer)   ;; gpointer callback_data
  (callback_funcs (* GSourceCallbackFuncs))   ;;
  ;;  GSourceCallbackFuncs* callback_funcs
  (source_funcs (* GSourceFuncs))   ;; GSourceFuncs* source_funcs
  (ref_count guint)   ;; guint ref_count
  (context (* GMainContext))   ;; GMainContext* context
  (priority gint)   ;; gint priority
  (flags guint)   ;; guint flags
  (source_id guint)   ;; guint source_id
  (poll_fds (* GSList))   ;; GSList* poll_fds
  (prev (* GSource))   ;; GSource* prev
  (next (* GSource))   ;; GSource* next
  (reserved1 gpointer)   ;; gpointer reserved1
  (reserved2 gpointer)   ;; gpointer reserved2
  ))   ;; bind-c-type _GSource
(ff:bind-c-typedef GSource _GSource) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:60 <566> 
;; struct _GSourceCallbackFuncs {
;;         void(* ref)( gpointer cb_data); void(* unref)( gpointer
;;   cb_data); void
;;   (* get)( gpointer cb_data, GSource* source, GSourceFunc* func,
;;   gpointer
;;   * data); };
(ff:bind-c-type _GSourceCallbackFuncs (:struct
  (ref ff:function-pointer)   ;; void(* ref)( gpointer cb_data)
  (unref ff:function-pointer)   ;; void(* unref)( gpointer cb_data)
  (get ff:function-pointer)   ;;
  ;;  void(* get)( gpointer cb_data, GSource* source, GSourceFunc* func, gpointer
  ;; * data)
  ))   ;; bind-c-type _GSourceCallbackFuncs
(ff:bind-c-typedef GSourceCallbackFuncs
                   _GSourceCallbackFuncs) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:70 <567> 
;; typedef void(* GSourceDummyMarshal)( void);
(ff:bind-c-type GSourceDummyMarshal (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:72 <568> 
;; struct _GSourceFuncs {
;;         gboolean(* prepare)( GSource* source, gint* timeout); gboolean(*
;;   check
;;   )( GSource* source); gboolean(* dispatch)( GSource* source,
;;   GSourceFunc
;;    callback, gpointer user_data); void(* finalize)( GSource* source);
;;   GSourceFunc
;;    closure_callback; GSourceDummyMarshal closure_marshal; };
(ff:bind-c-type _GSourceFuncs (:struct
  (prepare ff:function-pointer)   ;;
  ;;  gboolean(* prepare)( GSource* source, gint* timeout)
  (check ff:function-pointer)   ;; gboolean(* check)( GSource* source)
  (dispatch ff:function-pointer)   ;;
  ;;  gboolean(* dispatch)( GSource* source, GSourceFunc callback, gpointer user_data
  ;; )
  (finalize ff:function-pointer)   ;; void(* finalize)( GSource* source)
  (closure_callback GSourceFunc)   ;; GSourceFunc closure_callback
  (closure_marshal GSourceDummyMarshal)   ;;
  ;;  GSourceDummyMarshal closure_marshal
  ))   ;; bind-c-type _GSourceFuncs
(ff:bind-c-typedef GSourceFuncs _GSourceFuncs) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:115 <569> 
;; typedef struct _GPollFD GPollFD;
(ff:bind-c-typedef _GPollFD
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GPollFD _GPollFD)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:116 <570> 
;; typedef gint(* GPollFunc)( GPollFD* ufds, guint nfsd, gint timeout);
(ff:bind-c-type GPollFunc (* gint))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:120 <571> 
;; struct _GPollFD { gint fd; gushort events; gushort revents; };
(ff:bind-c-type _GPollFD (:struct
  (fd gint)   ;; gint fd
  (events gushort)   ;; gushort events
  (revents gushort)   ;; gushort revents
  ))   ;; bind-c-type _GPollFD
(ff:bind-c-typedef GPollFD _GPollFD) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:137 <572> 
;; GMainContext* g_main_context_new( void);
(ff:bind-c-function g_main_context_new
     :unconverted-entry-name "g_main_context_new"
     :c-return-type ("GMainContext" "*")
     :return-type (* GMainContext)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:138 <573> 
;; void g_main_context_ref( GMainContext* context);
(ff:bind-c-function g_main_context_ref
     :unconverted-entry-name "g_main_context_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:139 <574> 
;; void g_main_context_unref( GMainContext* context);
(ff:bind-c-function g_main_context_unref
     :unconverted-entry-name "g_main_context_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:140 <575> 
;; GMainContext* g_main_context_default( void);
(ff:bind-c-function g_main_context_default
     :unconverted-entry-name "g_main_context_default"
     :c-return-type ("GMainContext" "*")
     :return-type (* GMainContext)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:142 <576> 
;; gboolean g_main_context_iteration( GMainContext* context, gboolean
;;   may_block
;;   );
(ff:bind-c-function g_main_context_iteration
     :unconverted-entry-name "g_main_context_iteration"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMainContext" "*") ("gboolean"))
     :c-arg-names (context may_block)
     :arguments ((* GMainContext) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:144 <577> 
;; gboolean g_main_context_pending( GMainContext* context);
(ff:bind-c-function g_main_context_pending
     :unconverted-entry-name "g_main_context_pending"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:148 <578> 
;; GSource* g_main_context_find_source_by_id( GMainContext* context, guint
;;    source_id);
(ff:bind-c-function g_main_context_find_source_by_id
     :unconverted-entry-name "g_main_context_find_source_by_id"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types (("GMainContext" "*") ("guint"))
     :c-arg-names (context source_id)
     :arguments ((* GMainContext) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:150 <579> 
;; GSource* g_main_context_find_source_by_user_data( GMainContext* context,
;;              gpointer user_data);
(ff:bind-c-function g_main_context_find_source_by_user_data
     :unconverted-entry-name "g_main_context_find_source_by_user_data"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types (("GMainContext" "*") ("gpointer"))
     :c-arg-names (context user_data)
     :arguments ((* GMainContext) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:152 <580> 
;; GSource* g_main_context_find_source_by_funcs_user_data( GMainContext*
;;    context, GSourceFuncs* funcs, gpointer user_data);
(ff:bind-c-function g_main_context_find_source_by_funcs_user_data
     :unconverted-entry-name "g_main_context_find_source_by_funcs_user_data"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types (("GMainContext" "*") ("GSourceFuncs" "*")
                   ("gpointer"))
     :c-arg-names (context funcs user_data)
     :arguments ((* GMainContext) (* GSourceFuncs) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:158 <581> 
;; void g_main_context_wakeup( GMainContext* context);
(ff:bind-c-function g_main_context_wakeup
     :unconverted-entry-name "g_main_context_wakeup"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:159 <582> 
;; gboolean g_main_context_acquire( GMainContext* context);
(ff:bind-c-function g_main_context_acquire
     :unconverted-entry-name "g_main_context_acquire"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:160 <583> 
;; void g_main_context_release( GMainContext* context);
(ff:bind-c-function g_main_context_release
     :unconverted-entry-name "g_main_context_release"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:161 <584> 
;; gboolean g_main_context_wait( GMainContext* context, GCond* cond, GMutex
;;   * mutex);
(ff:bind-c-function g_main_context_wait
     :unconverted-entry-name "g_main_context_wait"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMainContext" "*") ("GCond" "*") ("GMutex" "*"))
     :c-arg-names (context cond mutex)
     :arguments ((* GMainContext) (* GCond) (* GMutex))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:165 <585> 
;; gboolean g_main_context_prepare( GMainContext* context, gint* priority);
(ff:bind-c-function g_main_context_prepare
     :unconverted-entry-name "g_main_context_prepare"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMainContext" "*") ("gint" "*"))
     :c-arg-names (context priority)
     :arguments ((* GMainContext) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:167 <586> 
;; gint g_main_context_query( GMainContext* context, gint max_priority,
;;   gint
;;   * timeout, GPollFD* fds, gint n_fds);
(ff:bind-c-function g_main_context_query
     :unconverted-entry-name "g_main_context_query"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GMainContext" "*") ("gint") ("gint" "*")
                   ("GPollFD" "*") ("gint"))
     :c-arg-names (context max_priority timeout fds n_fds)
     :arguments ((* GMainContext) gint (* gint) (* GPollFD) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:172 <587> 
;; gint g_main_context_check( GMainContext* context, gint max_priority,
;;   GPollFD
;;   * fds, gint n_fds);
(ff:bind-c-function g_main_context_check
     :unconverted-entry-name "g_main_context_check"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GMainContext" "*") ("gint") ("GPollFD" "*")
                   ("gint"))
     :c-arg-names (context max_priority fds n_fds)
     :arguments ((* GMainContext) gint (* GPollFD) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:176 <588> 
;; void g_main_context_dispatch( GMainContext* context);
(ff:bind-c-function g_main_context_dispatch
     :unconverted-entry-name "g_main_context_dispatch"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:178 <589> 
;; void g_main_context_set_poll_func( GMainContext* context, GPollFunc func
;;   );
(ff:bind-c-function g_main_context_set_poll_func
     :unconverted-entry-name "g_main_context_set_poll_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*") ("GPollFunc"))
     :c-arg-names (context func)
     :arguments ((* GMainContext) GPollFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:180 <590> 
;; GPollFunc g_main_context_get_poll_func( GMainContext* context);
(ff:bind-c-function g_main_context_get_poll_func
     :unconverted-entry-name "g_main_context_get_poll_func"
     :c-return-type ("GPollFunc")
     :return-type GPollFunc
     :c-arg-types (("GMainContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:184 <591> 
;; void g_main_context_add_poll( GMainContext* context, GPollFD* fd, gint
;;    priority);
(ff:bind-c-function g_main_context_add_poll
     :unconverted-entry-name "g_main_context_add_poll"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*") ("GPollFD" "*") ("gint"))
     :c-arg-names (context fd priority)
     :arguments ((* GMainContext) (* GPollFD) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:187 <592> 
;; void g_main_context_remove_poll( GMainContext* context, GPollFD* fd);
(ff:bind-c-function g_main_context_remove_poll
     :unconverted-entry-name "g_main_context_remove_poll"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainContext" "*") ("GPollFD" "*"))
     :c-arg-names (context fd)
     :arguments ((* GMainContext) (* GPollFD))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:192 <593> 
;; GMainLoop* g_main_loop_new( GMainContext* context, gboolean is_running);
(ff:bind-c-function g_main_loop_new
     :unconverted-entry-name "g_main_loop_new"
     :c-return-type ("GMainLoop" "*")
     :return-type (* GMainLoop)
     :c-arg-types (("GMainContext" "*") ("gboolean"))
     :c-arg-names (context is_running)
     :arguments ((* GMainContext) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:194 <594> 
;; void g_main_loop_run( GMainLoop* loop);
(ff:bind-c-function g_main_loop_run
     :unconverted-entry-name "g_main_loop_run"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:195 <595> 
;; void g_main_loop_quit( GMainLoop* loop);
(ff:bind-c-function g_main_loop_quit
     :unconverted-entry-name "g_main_loop_quit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:196 <596> 
;; GMainLoop* g_main_loop_ref( GMainLoop* loop);
(ff:bind-c-function g_main_loop_ref
     :unconverted-entry-name "g_main_loop_ref"
     :c-return-type ("GMainLoop" "*")
     :return-type (* GMainLoop)
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:197 <597> 
;; void g_main_loop_unref( GMainLoop* loop);
(ff:bind-c-function g_main_loop_unref
     :unconverted-entry-name "g_main_loop_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:198 <598> 
;; gboolean g_main_loop_is_running( GMainLoop* loop);
(ff:bind-c-function g_main_loop_is_running
     :unconverted-entry-name "g_main_loop_is_running"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:199 <599> 
;; GMainContext* g_main_loop_get_context( GMainLoop* loop);
(ff:bind-c-function g_main_loop_get_context
     :unconverted-entry-name "g_main_loop_get_context"
     :c-return-type ("GMainContext" "*")
     :return-type (* GMainContext)
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:203 <600> 
;; GSource* g_source_new( GSourceFuncs* source_funcs, guint struct_size);
(ff:bind-c-function g_source_new
     :unconverted-entry-name "g_source_new"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types (("GSourceFuncs" "*") ("guint"))
     :c-arg-names (source_funcs struct_size)
     :arguments ((* GSourceFuncs) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:205 <601> 
;; GSource* g_source_ref( GSource* source);
(ff:bind-c-function g_source_ref
     :unconverted-entry-name "g_source_ref"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types (("GSource" "*"))
     :c-arg-names (source)
     :arguments ((* GSource))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:206 <602> 
;; void g_source_unref( GSource* source);
(ff:bind-c-function g_source_unref
     :unconverted-entry-name "g_source_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*"))
     :c-arg-names (source)
     :arguments ((* GSource))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:208 <603> 
;; guint g_source_attach( GSource* source, GMainContext* context);
(ff:bind-c-function g_source_attach
     :unconverted-entry-name "g_source_attach"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GSource" "*") ("GMainContext" "*"))
     :c-arg-names (source context)
     :arguments ((* GSource) (* GMainContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:210 <604> 
;; void g_source_destroy( GSource* source);
(ff:bind-c-function g_source_destroy
     :unconverted-entry-name "g_source_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*"))
     :c-arg-names (source)
     :arguments ((* GSource))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:212 <605> 
;; void g_source_set_priority( GSource* source, gint priority);
(ff:bind-c-function g_source_set_priority
     :unconverted-entry-name "g_source_set_priority"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("gint"))
     :c-arg-names (source priority)
     :arguments ((* GSource) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:214 <606> 
;; gint g_source_get_priority( GSource* source);
(ff:bind-c-function g_source_get_priority
     :unconverted-entry-name "g_source_get_priority"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GSource" "*"))
     :c-arg-names (source)
     :arguments ((* GSource))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:215 <607> 
;; void g_source_set_can_recurse( GSource* source, gboolean can_recurse);
(ff:bind-c-function g_source_set_can_recurse
     :unconverted-entry-name "g_source_set_can_recurse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("gboolean"))
     :c-arg-names (source can_recurse)
     :arguments ((* GSource) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:217 <608> 
;; gboolean g_source_get_can_recurse( GSource* source);
(ff:bind-c-function g_source_get_can_recurse
     :unconverted-entry-name "g_source_get_can_recurse"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GSource" "*"))
     :c-arg-names (source)
     :arguments ((* GSource))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:218 <609> 
;; guint g_source_get_id( GSource* source);
(ff:bind-c-function g_source_get_id
     :unconverted-entry-name "g_source_get_id"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GSource" "*"))
     :c-arg-names (source)
     :arguments ((* GSource))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:220 <610> 
;; GMainContext* g_source_get_context( GSource* source);
(ff:bind-c-function g_source_get_context
     :unconverted-entry-name "g_source_get_context"
     :c-return-type ("GMainContext" "*")
     :return-type (* GMainContext)
     :c-arg-types (("GSource" "*"))
     :c-arg-names (source)
     :arguments ((* GSource))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:222 <611> 
;; void g_source_set_callback( GSource* source, GSourceFunc func, gpointer
;;    data, GDestroyNotify notify);
(ff:bind-c-function g_source_set_callback
     :unconverted-entry-name "g_source_set_callback"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("GSourceFunc") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (source func data notify)
     :arguments ((* GSource) GSourceFunc gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:229 <612> 
;; void g_source_set_callback_indirect( GSource* source, gpointer
;;   callback_data,
;;              GSourceCallbackFuncs* callback_funcs);
(ff:bind-c-function g_source_set_callback_indirect
     :unconverted-entry-name "g_source_set_callback_indirect"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("gpointer")
                   ("GSourceCallbackFuncs" "*"))
     :c-arg-names (source callback_data callback_funcs)
     :arguments ((* GSource) gpointer (* GSourceCallbackFuncs))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:233 <613> 
;; void g_source_add_poll( GSource* source, GPollFD* fd);
(ff:bind-c-function g_source_add_poll
     :unconverted-entry-name "g_source_add_poll"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("GPollFD" "*"))
     :c-arg-names (source fd)
     :arguments ((* GSource) (* GPollFD))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:235 <614> 
;; void g_source_remove_poll( GSource* source, GPollFD* fd);
(ff:bind-c-function g_source_remove_poll
     :unconverted-entry-name "g_source_remove_poll"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("GPollFD" "*"))
     :c-arg-names (source fd)
     :arguments ((* GSource) (* GPollFD))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:238 <615> 
;; void g_source_get_current_time( GSource* source, GTimeVal* timeval);
(ff:bind-c-function g_source_get_current_time
     :unconverted-entry-name "g_source_get_current_time"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("GTimeVal" "*"))
     :c-arg-names (source timeval)
     :arguments ((* GSource) (* GTimeVal))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:247 <616> 
;; GSource* g_idle_source_new( void);
(ff:bind-c-function g_idle_source_new
     :unconverted-entry-name "g_idle_source_new"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:248 <617> 
;; GSource* g_timeout_source_new( guint interval);
(ff:bind-c-function g_timeout_source_new
     :unconverted-entry-name "g_timeout_source_new"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types (("guint"))
     :c-arg-names (interval)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:252 <618> 
;; void g_get_current_time( GTimeVal* result);
(ff:bind-c-function g_get_current_time
     :unconverted-entry-name "g_get_current_time"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimeVal" "*"))
     :c-arg-names (result)
     :arguments ((* GTimeVal))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:277 <619> 
;; gboolean g_source_remove( guint tag);
(ff:bind-c-function g_source_remove
     :unconverted-entry-name "g_source_remove"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint"))
     :c-arg-names (tag)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:278 <620> 
;; gboolean g_source_remove_by_user_data( gpointer user_data);
(ff:bind-c-function g_source_remove_by_user_data
     :unconverted-entry-name "g_source_remove_by_user_data"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gpointer"))
     :c-arg-names (user_data)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:279 <621> 
;; gboolean g_source_remove_by_funcs_user_data( GSourceFuncs* funcs,
;;   gpointer
;;    user_data);
(ff:bind-c-function g_source_remove_by_funcs_user_data
     :unconverted-entry-name "g_source_remove_by_funcs_user_data"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GSourceFuncs" "*") ("gpointer"))
     :c-arg-names (funcs user_data)
     :arguments ((* GSourceFuncs) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:283 <622> 
;; guint g_timeout_add_full( gint priority, guint interval, GSourceFunc
;;   function,
;;              gpointer data, GDestroyNotify notify);
(ff:bind-c-function g_timeout_add_full
     :unconverted-entry-name "g_timeout_add_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gint") ("guint") ("GSourceFunc") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (priority interval function data notify)
     :arguments (gint guint GSourceFunc gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:288 <623> 
;; guint g_timeout_add( guint interval, GSourceFunc function, gpointer data
;;   );
(ff:bind-c-function g_timeout_add
     :unconverted-entry-name "g_timeout_add"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint") ("GSourceFunc") ("gpointer"))
     :c-arg-names (interval function data)
     :arguments (guint GSourceFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:291 <624> 
;; guint g_idle_add( GSourceFunc function, gpointer data);
(ff:bind-c-function g_idle_add
     :unconverted-entry-name "g_idle_add"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GSourceFunc") ("gpointer"))
     :c-arg-names #'data
     :arguments (GSourceFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:293 <625> 
;; guint g_idle_add_full( gint priority, GSourceFunc function, gpointer
;;   data,
;;              GDestroyNotify notify);
(ff:bind-c-function g_idle_add_full
     :unconverted-entry-name "g_idle_add_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gint") ("GSourceFunc") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (priority function data notify)
     :arguments (gint GSourceFunc gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:297 <626> 
;; gboolean g_idle_remove_by_data( gpointer data);
(ff:bind-c-function g_idle_remove_by_data
     :unconverted-entry-name "g_idle_remove_by_data"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gpointer"))
     :c-arg-names (data)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:300 <627> 
;; extern GSourceFuncs g_timeout_funcs;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_timeout_funcs"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmain.h:301 <628> 
;; extern GSourceFuncs g_idle_funcs;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_idle_funcs"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:30 <629> 
;; typedef guint32 gunichar;
(ff:bind-c-type gunichar guint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:31 <630> 
;; typedef guint16 gunichar2;
(ff:bind-c-type gunichar2 guint16)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:36 <631> 
;; typedef enum {
;;         G_UNICODE_CONTROL, G_UNICODE_FORMAT, G_UNICODE_UNASSIGNED,
;;   G_UNICODE_PRIVATE_USE,
;;              G_UNICODE_SURROGATE, G_UNICODE_LOWERCASE_LETTER,
;;   G_UNICODE_MODIFIER_LETTER,
;;              G_UNICODE_OTHER_LETTER, G_UNICODE_TITLECASE_LETTER,
;;   G_UNICODE_UPPERCASE_LETTER,
;;              G_UNICODE_COMBINING_MARK, G_UNICODE_ENCLOSING_MARK,
;;   G_UNICODE_NON_SPACING_MARK,
;;              G_UNICODE_DECIMAL_NUMBER, G_UNICODE_LETTER_NUMBER,
;;   G_UNICODE_OTHER_NUMBER,
;;              G_UNICODE_CONNECT_PUNCTUATION, G_UNICODE_DASH_PUNCTUATION,
;;   G_UNICODE_CLOSE_PUNCTUATION,
;;              G_UNICODE_FINAL_PUNCTUATION, G_UNICODE_INITIAL_PUNCTUATION,
;;   G_UNICODE_OTHER_PUNCTUATION,
;;              G_UNICODE_OPEN_PUNCTUATION, G_UNICODE_CURRENCY_SYMBOL,
;;   G_UNICODE_MODIFIER_SYMBOL,
;;              G_UNICODE_MATH_SYMBOL, G_UNICODE_OTHER_SYMBOL,
;;   G_UNICODE_LINE_SEPARATOR,
;;              G_UNICODE_PARAGRAPH_SEPARATOR, G_UNICODE_SPACE_SEPARATOR }
;;   GUnicodeType
;;   ;
(ff:bind-c-constant G_UNICODE_CONTROL 0) ;;  G_UNICODE_CONTROL 
(ff:bind-c-constant G_UNICODE_FORMAT 1) ;;  G_UNICODE_FORMAT 
(ff:bind-c-constant G_UNICODE_UNASSIGNED 2) ;;  G_UNICODE_UNASSIGNED 
(ff:bind-c-constant G_UNICODE_PRIVATE_USE 3) ;;  G_UNICODE_PRIVATE_USE 
(ff:bind-c-constant G_UNICODE_SURROGATE 4) ;;  G_UNICODE_SURROGATE 
(ff:bind-c-constant G_UNICODE_LOWERCASE_LETTER
                    5) ;;
;;   G_UNICODE_LOWERCASE_LETTER 
(ff:bind-c-constant G_UNICODE_MODIFIER_LETTER
                    6) ;;
;;   G_UNICODE_MODIFIER_LETTER 
(ff:bind-c-constant G_UNICODE_OTHER_LETTER
                    7) ;;
;;   G_UNICODE_OTHER_LETTER 
(ff:bind-c-constant G_UNICODE_TITLECASE_LETTER
                    8) ;;
;;   G_UNICODE_TITLECASE_LETTER 
(ff:bind-c-constant G_UNICODE_UPPERCASE_LETTER
                    9) ;;
;;   G_UNICODE_UPPERCASE_LETTER 
(ff:bind-c-constant G_UNICODE_COMBINING_MARK
                    10) ;;
;;   G_UNICODE_COMBINING_MARK 
(ff:bind-c-constant G_UNICODE_ENCLOSING_MARK
                    11) ;;
;;   G_UNICODE_ENCLOSING_MARK 
(ff:bind-c-constant G_UNICODE_NON_SPACING_MARK
                    12) ;;
;;   G_UNICODE_NON_SPACING_MARK 
(ff:bind-c-constant G_UNICODE_DECIMAL_NUMBER
                    13) ;;
;;   G_UNICODE_DECIMAL_NUMBER 
(ff:bind-c-constant G_UNICODE_LETTER_NUMBER
                    14) ;;
;;   G_UNICODE_LETTER_NUMBER 
(ff:bind-c-constant G_UNICODE_OTHER_NUMBER
                    15) ;;
;;   G_UNICODE_OTHER_NUMBER 
(ff:bind-c-constant G_UNICODE_CONNECT_PUNCTUATION
                    16) ;;
;;   G_UNICODE_CONNECT_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_DASH_PUNCTUATION
                    17) ;;
;;   G_UNICODE_DASH_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_CLOSE_PUNCTUATION
                    18) ;;
;;   G_UNICODE_CLOSE_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_FINAL_PUNCTUATION
                    19) ;;
;;   G_UNICODE_FINAL_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_INITIAL_PUNCTUATION
                    20) ;;
;;   G_UNICODE_INITIAL_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_OTHER_PUNCTUATION
                    21) ;;
;;   G_UNICODE_OTHER_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_OPEN_PUNCTUATION
                    22) ;;
;;   G_UNICODE_OPEN_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_CURRENCY_SYMBOL
                    23) ;;
;;   G_UNICODE_CURRENCY_SYMBOL 
(ff:bind-c-constant G_UNICODE_MODIFIER_SYMBOL
                    24) ;;
;;   G_UNICODE_MODIFIER_SYMBOL 
(ff:bind-c-constant G_UNICODE_MATH_SYMBOL 25) ;;  G_UNICODE_MATH_SYMBOL 
(ff:bind-c-constant G_UNICODE_OTHER_SYMBOL
                    26) ;;
;;   G_UNICODE_OTHER_SYMBOL 
(ff:bind-c-constant G_UNICODE_LINE_SEPARATOR
                    27) ;;
;;   G_UNICODE_LINE_SEPARATOR 
(ff:bind-c-constant G_UNICODE_PARAGRAPH_SEPARATOR
                    28) ;;
;;   G_UNICODE_PARAGRAPH_SEPARATOR 
(ff:bind-c-constant G_UNICODE_SPACE_SEPARATOR
                    29) ;;
;;   G_UNICODE_SPACE_SEPARATOR 
(ff:bind-c-type GUnicodeType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:73 <632> 
;; typedef enum {
;;         G_UNICODE_BREAK_MANDATORY, G_UNICODE_BREAK_CARRIAGE_RETURN,
;;   G_UNICODE_BREAK_LINE_FEED,
;;              G_UNICODE_BREAK_COMBINING_MARK, G_UNICODE_BREAK_SURROGATE,
;;   G_UNICODE_BREAK_ZERO_WIDTH_SPACE,
;;              G_UNICODE_BREAK_INSEPARABLE,
;;   G_UNICODE_BREAK_NON_BREAKING_GLUE, G_UNICODE_BREAK_CONTINGENT,
;;              G_UNICODE_BREAK_SPACE, G_UNICODE_BREAK_AFTER,
;;   G_UNICODE_BREAK_BEFORE,
;;              G_UNICODE_BREAK_BEFORE_AND_AFTER, G_UNICODE_BREAK_HYPHEN,
;;   G_UNICODE_BREAK_NON_STARTER,
;;              G_UNICODE_BREAK_OPEN_PUNCTUATION,
;;   G_UNICODE_BREAK_CLOSE_PUNCTUATION, G_UNICODE_BREAK_QUOTATION,
;;              G_UNICODE_BREAK_EXCLAMATION, G_UNICODE_BREAK_IDEOGRAPHIC,
;;   G_UNICODE_BREAK_NUMERIC,
;;              G_UNICODE_BREAK_INFIX_SEPARATOR, G_UNICODE_BREAK_SYMBOL,
;;   G_UNICODE_BREAK_ALPHABETIC,
;;              G_UNICODE_BREAK_PREFIX, G_UNICODE_BREAK_POSTFIX,
;;   G_UNICODE_BREAK_COMPLEX_CONTEXT,
;;              G_UNICODE_BREAK_AMBIGUOUS, G_UNICODE_BREAK_UNKNOWN }
;;   GUnicodeBreakType
;;   ;
(ff:bind-c-constant G_UNICODE_BREAK_MANDATORY
                    0) ;;
;;   G_UNICODE_BREAK_MANDATORY 
(ff:bind-c-constant G_UNICODE_BREAK_CARRIAGE_RETURN
                    1) ;;
;;   G_UNICODE_BREAK_CARRIAGE_RETURN 
(ff:bind-c-constant G_UNICODE_BREAK_LINE_FEED
                    2) ;;
;;   G_UNICODE_BREAK_LINE_FEED 
(ff:bind-c-constant G_UNICODE_BREAK_COMBINING_MARK
                    3) ;;
;;   G_UNICODE_BREAK_COMBINING_MARK 
(ff:bind-c-constant G_UNICODE_BREAK_SURROGATE
                    4) ;;
;;   G_UNICODE_BREAK_SURROGATE 
(ff:bind-c-constant G_UNICODE_BREAK_ZERO_WIDTH_SPACE
                    5) ;;
;;   G_UNICODE_BREAK_ZERO_WIDTH_SPACE 
(ff:bind-c-constant G_UNICODE_BREAK_INSEPARABLE
                    6) ;;
;;   G_UNICODE_BREAK_INSEPARABLE 
(ff:bind-c-constant G_UNICODE_BREAK_NON_BREAKING_GLUE
                    7) ;;
;;   G_UNICODE_BREAK_NON_BREAKING_GLUE 
(ff:bind-c-constant G_UNICODE_BREAK_CONTINGENT
                    8) ;;
;;   G_UNICODE_BREAK_CONTINGENT 
(ff:bind-c-constant G_UNICODE_BREAK_SPACE 9) ;;  G_UNICODE_BREAK_SPACE 
(ff:bind-c-constant G_UNICODE_BREAK_AFTER 10) ;;  G_UNICODE_BREAK_AFTER 
(ff:bind-c-constant G_UNICODE_BREAK_BEFORE
                    11) ;;
;;   G_UNICODE_BREAK_BEFORE 
(ff:bind-c-constant G_UNICODE_BREAK_BEFORE_AND_AFTER
                    12) ;;
;;   G_UNICODE_BREAK_BEFORE_AND_AFTER 
(ff:bind-c-constant G_UNICODE_BREAK_HYPHEN
                    13) ;;
;;   G_UNICODE_BREAK_HYPHEN 
(ff:bind-c-constant G_UNICODE_BREAK_NON_STARTER
                    14) ;;
;;   G_UNICODE_BREAK_NON_STARTER 
(ff:bind-c-constant G_UNICODE_BREAK_OPEN_PUNCTUATION
                    15) ;;
;;   G_UNICODE_BREAK_OPEN_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_BREAK_CLOSE_PUNCTUATION
                    16) ;;
;;   G_UNICODE_BREAK_CLOSE_PUNCTUATION 
(ff:bind-c-constant G_UNICODE_BREAK_QUOTATION
                    17) ;;
;;   G_UNICODE_BREAK_QUOTATION 
(ff:bind-c-constant G_UNICODE_BREAK_EXCLAMATION
                    18) ;;
;;   G_UNICODE_BREAK_EXCLAMATION 
(ff:bind-c-constant G_UNICODE_BREAK_IDEOGRAPHIC
                    19) ;;
;;   G_UNICODE_BREAK_IDEOGRAPHIC 
(ff:bind-c-constant G_UNICODE_BREAK_NUMERIC
                    20) ;;
;;   G_UNICODE_BREAK_NUMERIC 
(ff:bind-c-constant G_UNICODE_BREAK_INFIX_SEPARATOR
                    21) ;;
;;   G_UNICODE_BREAK_INFIX_SEPARATOR 
(ff:bind-c-constant G_UNICODE_BREAK_SYMBOL
                    22) ;;
;;   G_UNICODE_BREAK_SYMBOL 
(ff:bind-c-constant G_UNICODE_BREAK_ALPHABETIC
                    23) ;;
;;   G_UNICODE_BREAK_ALPHABETIC 
(ff:bind-c-constant G_UNICODE_BREAK_PREFIX
                    24) ;;
;;   G_UNICODE_BREAK_PREFIX 
(ff:bind-c-constant G_UNICODE_BREAK_POSTFIX
                    25) ;;
;;   G_UNICODE_BREAK_POSTFIX 
(ff:bind-c-constant G_UNICODE_BREAK_COMPLEX_CONTEXT
                    26) ;;
;;   G_UNICODE_BREAK_COMPLEX_CONTEXT 
(ff:bind-c-constant G_UNICODE_BREAK_AMBIGUOUS
                    27) ;;
;;   G_UNICODE_BREAK_AMBIGUOUS 
(ff:bind-c-constant G_UNICODE_BREAK_UNKNOWN
                    28) ;;
;;   G_UNICODE_BREAK_UNKNOWN 
(ff:bind-c-type GUnicodeBreakType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:112 <633> 
;; gboolean g_get_charset( const char** charset);
(ff:bind-c-function g_get_charset
     :unconverted-entry-name "g_get_charset"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "char" "*" "*"))
     :c-arg-names (charset)
     :arguments ((* (* :char)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:116 <634> 
;; gboolean g_unichar_isalnum( gunichar c);
(ff:bind-c-function g_unichar_isalnum
     :unconverted-entry-name "g_unichar_isalnum"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:117 <635> 
;; gboolean g_unichar_isalpha( gunichar c);
(ff:bind-c-function g_unichar_isalpha
     :unconverted-entry-name "g_unichar_isalpha"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:118 <636> 
;; gboolean g_unichar_iscntrl( gunichar c);
(ff:bind-c-function g_unichar_iscntrl
     :unconverted-entry-name "g_unichar_iscntrl"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:119 <637> 
;; gboolean g_unichar_isdigit( gunichar c);
(ff:bind-c-function g_unichar_isdigit
     :unconverted-entry-name "g_unichar_isdigit"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:120 <638> 
;; gboolean g_unichar_isgraph( gunichar c);
(ff:bind-c-function g_unichar_isgraph
     :unconverted-entry-name "g_unichar_isgraph"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:121 <639> 
;; gboolean g_unichar_islower( gunichar c);
(ff:bind-c-function g_unichar_islower
     :unconverted-entry-name "g_unichar_islower"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:122 <640> 
;; gboolean g_unichar_isprint( gunichar c);
(ff:bind-c-function g_unichar_isprint
     :unconverted-entry-name "g_unichar_isprint"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:123 <641> 
;; gboolean g_unichar_ispunct( gunichar c);
(ff:bind-c-function g_unichar_ispunct
     :unconverted-entry-name "g_unichar_ispunct"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:124 <642> 
;; gboolean g_unichar_isspace( gunichar c);
(ff:bind-c-function g_unichar_isspace
     :unconverted-entry-name "g_unichar_isspace"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:125 <643> 
;; gboolean g_unichar_isupper( gunichar c);
(ff:bind-c-function g_unichar_isupper
     :unconverted-entry-name "g_unichar_isupper"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:126 <644> 
;; gboolean g_unichar_isxdigit( gunichar c);
(ff:bind-c-function g_unichar_isxdigit
     :unconverted-entry-name "g_unichar_isxdigit"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:127 <645> 
;; gboolean g_unichar_istitle( gunichar c);
(ff:bind-c-function g_unichar_istitle
     :unconverted-entry-name "g_unichar_istitle"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:128 <646> 
;; gboolean g_unichar_isdefined( gunichar c);
(ff:bind-c-function g_unichar_isdefined
     :unconverted-entry-name "g_unichar_isdefined"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:129 <647> 
;; gboolean g_unichar_iswide( gunichar c);
(ff:bind-c-function g_unichar_iswide
     :unconverted-entry-name "g_unichar_iswide"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:133 <648> 
;; gunichar g_unichar_toupper( gunichar c);
(ff:bind-c-function g_unichar_toupper
     :unconverted-entry-name "g_unichar_toupper"
     :c-return-type ("gunichar")
     :return-type gunichar
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:134 <649> 
;; gunichar g_unichar_tolower( gunichar c);
(ff:bind-c-function g_unichar_tolower
     :unconverted-entry-name "g_unichar_tolower"
     :c-return-type ("gunichar")
     :return-type gunichar
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:135 <650> 
;; gunichar g_unichar_totitle( gunichar c);
(ff:bind-c-function g_unichar_totitle
     :unconverted-entry-name "g_unichar_totitle"
     :c-return-type ("gunichar")
     :return-type gunichar
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:139 <651> 
;; gint g_unichar_digit_value( gunichar c);
(ff:bind-c-function g_unichar_digit_value
     :unconverted-entry-name "g_unichar_digit_value"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:141 <652> 
;; gint g_unichar_xdigit_value( gunichar c);
(ff:bind-c-function g_unichar_xdigit_value
     :unconverted-entry-name "g_unichar_xdigit_value"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:144 <653> 
;; GUnicodeType g_unichar_type( gunichar c);
(ff:bind-c-function g_unichar_type
     :unconverted-entry-name "g_unichar_type"
     :c-return-type ("GUnicodeType")
     :return-type GUnicodeType
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:147 <654> 
;; GUnicodeBreakType g_unichar_break_type( gunichar c);
(ff:bind-c-function g_unichar_break_type
     :unconverted-entry-name "g_unichar_break_type"
     :c-return-type ("GUnicodeBreakType")
     :return-type GUnicodeBreakType
     :c-arg-types (("gunichar"))
     :c-arg-names (c)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:153 <655> 
;; void g_unicode_canonical_ordering( gunichar* string, gsize len);
(ff:bind-c-function g_unicode_canonical_ordering
     :unconverted-entry-name "g_unicode_canonical_ordering"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gunichar" "*") ("gsize"))
     :c-arg-names (string len)
     :arguments ((* gunichar) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:159 <656> 
;; gunichar* g_unicode_canonical_decomposition( gunichar ch, gsize*
;;   result_len
;;   );
(ff:bind-c-function g_unicode_canonical_decomposition
     :unconverted-entry-name "g_unicode_canonical_decomposition"
     :c-return-type ("gunichar" "*")
     :return-type (* gunichar)
     :c-arg-types (("gunichar") ("gsize" "*"))
     :c-arg-names (ch result_len)
     :arguments (gunichar (* gsize))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:164 <657> 
;; extern const gchar* const g_utf8_skip;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_utf8_skip"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:168 <658> 
;; gunichar g_utf8_get_char( const gchar* p);
(ff:bind-c-function g_utf8_get_char
     :unconverted-entry-name "g_utf8_get_char"
     :c-return-type ("gunichar")
     :return-type gunichar
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (p)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:169 <659> 
;; gunichar g_utf8_get_char_validated( const gchar* p, gssize max_len);
(ff:bind-c-function g_utf8_get_char_validated
     :unconverted-entry-name "g_utf8_get_char_validated"
     :c-return-type ("gunichar")
     :return-type gunichar
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (p max_len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:172 <660> 
;; gchar* g_utf8_offset_to_pointer( const gchar* str, glong offset);
(ff:bind-c-function g_utf8_offset_to_pointer
     :unconverted-entry-name "g_utf8_offset_to_pointer"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("glong"))
     :c-arg-names (str offset)
     :arguments ((* gchar) glong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:174 <661> 
;; glong g_utf8_pointer_to_offset( const gchar* str, const gchar* pos);
(ff:bind-c-function g_utf8_pointer_to_offset
     :unconverted-entry-name "g_utf8_pointer_to_offset"
     :c-return-type ("glong")
     :return-type glong
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (str pos)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:176 <662> 
;; gchar* g_utf8_prev_char( const gchar* p);
(ff:bind-c-function g_utf8_prev_char
     :unconverted-entry-name "g_utf8_prev_char"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (p)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:177 <663> 
;; gchar* g_utf8_find_next_char( const gchar* p, const gchar* end);
(ff:bind-c-function g_utf8_find_next_char
     :unconverted-entry-name "g_utf8_find_next_char"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (p end)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:179 <664> 
;; gchar* g_utf8_find_prev_char( const gchar* str, const gchar* p);
(ff:bind-c-function g_utf8_find_prev_char
     :unconverted-entry-name "g_utf8_find_prev_char"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (str p)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:182 <665> 
;; glong g_utf8_strlen( const gchar* p, gssize max);
(ff:bind-c-function g_utf8_strlen
     :unconverted-entry-name "g_utf8_strlen"
     :c-return-type ("glong")
     :return-type glong
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (p max)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:186 <666> 
;; gchar* g_utf8_strncpy( gchar* dest, const gchar* src, gsize n);
(ff:bind-c-function g_utf8_strncpy
     :unconverted-entry-name "g_utf8_strncpy"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*") ("const" "gchar" "*") ("gsize"))
     :c-arg-names (dest src n)
     :arguments ((* gchar) (* gchar) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:192 <667> 
;; gchar* g_utf8_strchr( const gchar* p, gssize len, gunichar c);
(ff:bind-c-function g_utf8_strchr
     :unconverted-entry-name "g_utf8_strchr"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("gunichar"))
     :c-arg-names (p len c)
     :arguments ((* gchar) gssize gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:195 <668> 
;; gchar* g_utf8_strrchr( const gchar* p, gssize len, gunichar c);
(ff:bind-c-function g_utf8_strrchr
     :unconverted-entry-name "g_utf8_strrchr"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("gunichar"))
     :c-arg-names (p len c)
     :arguments ((* gchar) gssize gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:199 <669> 
;; gunichar2* g_utf8_to_utf16( const gchar* str, glong len, glong*
;;   items_read,
;;              glong* items_written, GError** error);
(ff:bind-c-function g_utf8_to_utf16
     :unconverted-entry-name "g_utf8_to_utf16"
     :c-return-type ("gunichar2" "*")
     :return-type (* gunichar2)
     :c-arg-types (("const" "gchar" "*") ("glong") ("glong" "*")
                   ("glong" "*") ("GError" "*" "*"))
     :c-arg-names (str len items_read items_written error)
     :arguments ((* gchar) glong (* glong) (* glong) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:204 <670> 
;; gunichar* g_utf8_to_ucs4( const gchar* str, glong len, glong*
;;   items_read,
;;              glong* items_written, GError** error);
(ff:bind-c-function g_utf8_to_ucs4
     :unconverted-entry-name "g_utf8_to_ucs4"
     :c-return-type ("gunichar" "*")
     :return-type (* gunichar)
     :c-arg-types (("const" "gchar" "*") ("glong") ("glong" "*")
                   ("glong" "*") ("GError" "*" "*"))
     :c-arg-names (str len items_read items_written error)
     :arguments ((* gchar) glong (* glong) (* glong) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:209 <671> 
;; gunichar* g_utf8_to_ucs4_fast( const gchar* str, glong len, glong*
;;   items_written
;;   );
(ff:bind-c-function g_utf8_to_ucs4_fast
     :unconverted-entry-name "g_utf8_to_ucs4_fast"
     :c-return-type ("gunichar" "*")
     :return-type (* gunichar)
     :c-arg-types (("const" "gchar" "*") ("glong") ("glong" "*"))
     :c-arg-names (str len items_written)
     :arguments ((* gchar) glong (* glong))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:212 <672> 
;; gunichar* g_utf16_to_ucs4( const gunichar2* str, glong len, glong*
;;   items_read,
;;              glong* items_written, GError** error);
(ff:bind-c-function g_utf16_to_ucs4
     :unconverted-entry-name "g_utf16_to_ucs4"
     :c-return-type ("gunichar" "*")
     :return-type (* gunichar)
     :c-arg-types (("const" "gunichar2" "*") ("glong") ("glong" "*")
                   ("glong" "*") ("GError" "*" "*"))
     :c-arg-names (str len items_read items_written error)
     :arguments ((* gunichar2) glong (* glong) (* glong) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:217 <673> 
;; gchar* g_utf16_to_utf8( const gunichar2* str, glong len, glong*
;;   items_read,
;;              glong* items_written, GError** error);
(ff:bind-c-function g_utf16_to_utf8
     :unconverted-entry-name "g_utf16_to_utf8"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gunichar2" "*") ("glong") ("glong" "*")
                   ("glong" "*") ("GError" "*" "*"))
     :c-arg-names (str len items_read items_written error)
     :arguments ((* gunichar2) glong (* glong) (* glong) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:222 <674> 
;; gunichar2* g_ucs4_to_utf16( const gunichar* str, glong len, glong*
;;   items_read,
;;              glong* items_written, GError** error);
(ff:bind-c-function g_ucs4_to_utf16
     :unconverted-entry-name "g_ucs4_to_utf16"
     :c-return-type ("gunichar2" "*")
     :return-type (* gunichar2)
     :c-arg-types (("const" "gunichar" "*") ("glong") ("glong" "*")
                   ("glong" "*") ("GError" "*" "*"))
     :c-arg-names (str len items_read items_written error)
     :arguments ((* gunichar) glong (* glong) (* glong) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:227 <675> 
;; gchar* g_ucs4_to_utf8( const gunichar* str, glong len, glong*
;;   items_read,
;;              glong* items_written, GError** error);
(ff:bind-c-function g_ucs4_to_utf8
     :unconverted-entry-name "g_ucs4_to_utf8"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gunichar" "*") ("glong") ("glong" "*")
                   ("glong" "*") ("GError" "*" "*"))
     :c-arg-names (str len items_read items_written error)
     :arguments ((* gunichar) glong (* glong) (* glong) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:237 <676> 
;; gint g_unichar_to_utf8( gunichar c, gchar* outbuf);
(ff:bind-c-function g_unichar_to_utf8
     :unconverted-entry-name "g_unichar_to_utf8"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gunichar") ("gchar" "*"))
     :c-arg-names (c outbuf)
     :arguments (gunichar (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:244 <677> 
;; gboolean g_utf8_validate( const gchar* str, gssize max_len, const gchar
;;   ** end);
(ff:bind-c-function g_utf8_validate
     :unconverted-entry-name "g_utf8_validate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("gssize")
                   ("const" "gchar" "*" "*"))
     :c-arg-names (str max_len end)
     :arguments ((* gchar) gssize (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:249 <678> 
;; gboolean g_unichar_validate( gunichar ch);
(ff:bind-c-function g_unichar_validate
     :unconverted-entry-name "g_unichar_validate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gunichar"))
     :c-arg-names (ch)
     :arguments (gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:251 <679> 
;; gchar* g_utf8_strup( const gchar* str, gssize len);
(ff:bind-c-function g_utf8_strup
     :unconverted-entry-name "g_utf8_strup"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (str len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:253 <680> 
;; gchar* g_utf8_strdown( const gchar* str, gssize len);
(ff:bind-c-function g_utf8_strdown
     :unconverted-entry-name "g_utf8_strdown"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (str len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:255 <681> 
;; gchar* g_utf8_casefold( const gchar* str, gssize len);
(ff:bind-c-function g_utf8_casefold
     :unconverted-entry-name "g_utf8_casefold"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (str len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:258 <682> 
;; typedef enum {
;;         G_NORMALIZE_DEFAULT, G_NORMALIZE_NFD = G_NORMALIZE_DEFAULT,
;;   G_NORMALIZE_DEFAULT_COMPOSE,
;;              G_NORMALIZE_NFC = G_NORMALIZE_DEFAULT_COMPOSE,
;;   G_NORMALIZE_ALL, G_NORMALIZE_NFKD
;;    = G_NORMALIZE_ALL, G_NORMALIZE_ALL_COMPOSE, G_NORMALIZE_NFKC =
;;   G_NORMALIZE_ALL_COMPOSE
;;    } GNormalizeMode;
(ff:bind-c-constant G_NORMALIZE_DEFAULT 0) ;;  G_NORMALIZE_DEFAULT 
(ff:bind-c-constant G_NORMALIZE_NFD
                    G_NORMALIZE_DEFAULT) ;;
;;   G_NORMALIZE_NFD = G_NORMALIZE_DEFAULT 
(ff:bind-c-constant G_NORMALIZE_DEFAULT_COMPOSE
                    1) ;;
;;   G_NORMALIZE_DEFAULT_COMPOSE 
(ff:bind-c-constant G_NORMALIZE_NFC
                    G_NORMALIZE_DEFAULT_COMPOSE) ;;
;;   G_NORMALIZE_NFC = G_NORMALIZE_DEFAULT_COMPOSE 
(ff:bind-c-constant G_NORMALIZE_ALL 2) ;;  G_NORMALIZE_ALL 
(ff:bind-c-constant G_NORMALIZE_NFKD
                    G_NORMALIZE_ALL) ;;
;;   G_NORMALIZE_NFKD = G_NORMALIZE_ALL 
(ff:bind-c-constant G_NORMALIZE_ALL_COMPOSE
                    3) ;;
;;   G_NORMALIZE_ALL_COMPOSE 
(ff:bind-c-constant G_NORMALIZE_NFKC
                    G_NORMALIZE_ALL_COMPOSE) ;;
;;   G_NORMALIZE_NFKC = G_NORMALIZE_ALL_COMPOSE 
(ff:bind-c-type GNormalizeMode :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:269 <683> 
;; gchar* g_utf8_normalize( const gchar* str, gssize len, GNormalizeMode
;;    mode);
(ff:bind-c-function g_utf8_normalize
     :unconverted-entry-name "g_utf8_normalize"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize") ("GNormalizeMode"))
     :c-arg-names (str len mode)
     :arguments ((* gchar) gssize GNormalizeMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:273 <684> 
;; gint g_utf8_collate( const gchar* str1, const gchar* str2);
(ff:bind-c-function g_utf8_collate
     :unconverted-entry-name "g_utf8_collate"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (str1 str2)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gunicode.h:275 <685> 
;; gchar* g_utf8_collate_key( const gchar* str, gssize len);
(ff:bind-c-function g_utf8_collate_key
     :unconverted-entry-name "g_utf8_collate_key"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (str len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:35 <686> 
;; typedef struct _GString GString;
(ff:bind-c-typedef _GString
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GString _GString)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:36 <687> 
;; typedef struct _GStringChunk GStringChunk;
(ff:bind-c-typedef _GStringChunk
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStringChunk _GStringChunk)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:38 <688> 
;; struct _GString { gchar* str; gsize len; gsize allocated_len; };
(ff:bind-c-type _GString (:struct
  (str (* gchar))   ;; gchar* str
  (len gsize)   ;; gsize len
  (allocated_len gsize)   ;; gsize allocated_len
  ))   ;; bind-c-type _GString
(ff:bind-c-typedef GString _GString) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:47 <689> 
;; GStringChunk* g_string_chunk_new( gsize size);
(ff:bind-c-function g_string_chunk_new
     :unconverted-entry-name "g_string_chunk_new"
     :c-return-type ("GStringChunk" "*")
     :return-type (* GStringChunk)
     :c-arg-types (("gsize"))
     :c-arg-names (size)
     :arguments (gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:48 <690> 
;; void g_string_chunk_free( GStringChunk* chunk);
(ff:bind-c-function g_string_chunk_free
     :unconverted-entry-name "g_string_chunk_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStringChunk" "*"))
     :c-arg-names (chunk)
     :arguments ((* GStringChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:49 <691> 
;; gchar* g_string_chunk_insert( GStringChunk* chunk, const gchar* string);
(ff:bind-c-function g_string_chunk_insert
     :unconverted-entry-name "g_string_chunk_insert"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GStringChunk" "*") ("const" "gchar" "*"))
     :c-arg-names (chunk string)
     :arguments ((* GStringChunk) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:51 <692> 
;; gchar* g_string_chunk_insert_const( GStringChunk* chunk, const gchar*
;;    string);
(ff:bind-c-function g_string_chunk_insert_const
     :unconverted-entry-name "g_string_chunk_insert_const"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GStringChunk" "*") ("const" "gchar" "*"))
     :c-arg-names (chunk string)
     :arguments ((* GStringChunk) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:57 <693> 
;; GString* g_string_new( const gchar* init);
(ff:bind-c-function g_string_new
     :unconverted-entry-name "g_string_new"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (init)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:58 <694> 
;; GString* g_string_new_len( const gchar* init, gssize len);
(ff:bind-c-function g_string_new_len
     :unconverted-entry-name "g_string_new_len"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (init len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:60 <695> 
;; GString* g_string_sized_new( gsize dfl_size);
(ff:bind-c-function g_string_sized_new
     :unconverted-entry-name "g_string_sized_new"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("gsize"))
     :c-arg-names (dfl_size)
     :arguments (gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:61 <696> 
;; gchar* g_string_free( GString* string, gboolean free_segment);
(ff:bind-c-function g_string_free
     :unconverted-entry-name "g_string_free"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GString" "*") ("gboolean"))
     :c-arg-names (string free_segment)
     :arguments ((* GString) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:63 <697> 
;; gboolean g_string_equal( const GString* v, const GString* v2);
(ff:bind-c-function g_string_equal
     :unconverted-entry-name "g_string_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GString" "*") ("const" "GString" "*"))
     :c-arg-names (v v2)
     :arguments ((* GString) (* GString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:65 <698> 
;; guint g_string_hash( const GString* str);
(ff:bind-c-function g_string_hash
     :unconverted-entry-name "g_string_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GString" "*"))
     :c-arg-names (str)
     :arguments ((* GString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:66 <699> 
;; GString* g_string_assign( GString* string, const gchar* rval);
(ff:bind-c-function g_string_assign
     :unconverted-entry-name "g_string_assign"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*"))
     :c-arg-names (string rval)
     :arguments ((* GString) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:68 <700> 
;; GString* g_string_truncate( GString* string, gsize len);
(ff:bind-c-function g_string_truncate
     :unconverted-entry-name "g_string_truncate"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gsize"))
     :c-arg-names (string len)
     :arguments ((* GString) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:70 <701> 
;; GString* g_string_set_size( GString* string, gsize len);
(ff:bind-c-function g_string_set_size
     :unconverted-entry-name "g_string_set_size"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gsize"))
     :c-arg-names (string len)
     :arguments ((* GString) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:72 <702> 
;; GString* g_string_insert_len( GString* string, gssize pos, const gchar
;;   * val, gssize len);
(ff:bind-c-function g_string_insert_len
     :unconverted-entry-name "g_string_insert_len"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gssize") ("const" "gchar" "*")
                   ("gssize"))
     :c-arg-names (string pos val len)
     :arguments ((* GString) gssize (* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:76 <703> 
;; GString* g_string_append( GString* string, const gchar* val);
(ff:bind-c-function g_string_append
     :unconverted-entry-name "g_string_append"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*"))
     :c-arg-names (string val)
     :arguments ((* GString) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:78 <704> 
;; GString* g_string_append_len( GString* string, const gchar* val, gssize
;;    len);
(ff:bind-c-function g_string_append_len
     :unconverted-entry-name "g_string_append_len"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*") ("gssize"))
     :c-arg-names (string val len)
     :arguments ((* GString) (* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:81 <705> 
;; GString* g_string_append_c( GString* string, gchar c);
(ff:bind-c-function g_string_append_c
     :unconverted-entry-name "g_string_append_c"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gchar"))
     :c-arg-names (string c)
     :arguments ((* GString) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:83 <706> 
;; GString* g_string_append_unichar( GString* string, gunichar wc);
(ff:bind-c-function g_string_append_unichar
     :unconverted-entry-name "g_string_append_unichar"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gunichar"))
     :c-arg-names (string wc)
     :arguments ((* GString) gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:85 <707> 
;; GString* g_string_prepend( GString* string, const gchar* val);
(ff:bind-c-function g_string_prepend
     :unconverted-entry-name "g_string_prepend"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*"))
     :c-arg-names (string val)
     :arguments ((* GString) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:87 <708> 
;; GString* g_string_prepend_c( GString* string, gchar c);
(ff:bind-c-function g_string_prepend_c
     :unconverted-entry-name "g_string_prepend_c"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gchar"))
     :c-arg-names (string c)
     :arguments ((* GString) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:89 <709> 
;; GString* g_string_prepend_unichar( GString* string, gunichar wc);
(ff:bind-c-function g_string_prepend_unichar
     :unconverted-entry-name "g_string_prepend_unichar"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gunichar"))
     :c-arg-names (string wc)
     :arguments ((* GString) gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:91 <710> 
;; GString* g_string_prepend_len( GString* string, const gchar* val, gssize
;;    len);
(ff:bind-c-function g_string_prepend_len
     :unconverted-entry-name "g_string_prepend_len"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*") ("gssize"))
     :c-arg-names (string val len)
     :arguments ((* GString) (* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:94 <711> 
;; GString* g_string_insert( GString* string, gssize pos, const gchar*
;;   val);
(ff:bind-c-function g_string_insert
     :unconverted-entry-name "g_string_insert"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gssize") ("const" "gchar" "*"))
     :c-arg-names (string pos val)
     :arguments ((* GString) gssize (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:97 <712> 
;; GString* g_string_insert_c( GString* string, gssize pos, gchar c);
(ff:bind-c-function g_string_insert_c
     :unconverted-entry-name "g_string_insert_c"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gssize") ("gchar"))
     :c-arg-names (string pos c)
     :arguments ((* GString) gssize gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:100 <713> 
;; GString* g_string_insert_unichar( GString* string, gssize pos, gunichar
;;    wc);
(ff:bind-c-function g_string_insert_unichar
     :unconverted-entry-name "g_string_insert_unichar"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gssize") ("gunichar"))
     :c-arg-names (string pos wc)
     :arguments ((* GString) gssize gunichar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:103 <714> 
;; GString* g_string_erase( GString* string, gssize pos, gssize len);
(ff:bind-c-function g_string_erase
     :unconverted-entry-name "g_string_erase"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gssize") ("gssize"))
     :c-arg-names (string pos len)
     :arguments ((* GString) gssize gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:106 <715> 
;; GString* g_string_ascii_down( GString* string);
(ff:bind-c-function g_string_ascii_down
     :unconverted-entry-name "g_string_ascii_down"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*"))
     :c-arg-names (string)
     :arguments ((* GString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:107 <716> 
;; GString* g_string_ascii_up( GString* string);
(ff:bind-c-function g_string_ascii_up
     :unconverted-entry-name "g_string_ascii_up"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*"))
     :c-arg-names (string)
     :arguments ((* GString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:108 <717> 
;; void g_string_printf( GString* string, const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_string_printf
     :all-names ((g_string_printf . "g_string_printf")
                 (g_string_sprintf . "g_string_sprintf"))
     :unconverted-entry-name "g_string_printf"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GString" "*") ("const" "gchar" "*") "...")
     :c-arg-names (string format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:111 <718> 
;; void g_string_append_printf( GString* string, const gchar* format,
;;   ELLIPSIS
;;   );

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_string_append_printf
     :all-names ((g_string_sprintfa . "g_string_sprintfa")
                 (g_string_append_printf . "g_string_append_printf"))
     :unconverted-entry-name "g_string_append_printf"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GString" "*") ("const" "gchar" "*") "...")
     :c-arg-names (string format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:122 <719> 
;; GString* g_string_down( GString* string);
(ff:bind-c-function g_string_down
     :unconverted-entry-name "g_string_down"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*"))
     :c-arg-names (string)
     :arguments ((* GString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstring.h:123 <720> 
;; GString* g_string_up( GString* string);
(ff:bind-c-function g_string_up
     :unconverted-entry-name "g_string_up"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*"))
     :c-arg-names (string)
     :arguments ((* GString))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:39 <721> 
;; typedef struct _GIOChannel GIOChannel;
(ff:bind-c-typedef _GIOChannel
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GIOChannel _GIOChannel)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:40 <722> 
;; typedef struct _GIOFuncs GIOFuncs;
(ff:bind-c-typedef _GIOFuncs
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GIOFuncs _GIOFuncs)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:42 <723> 
;; typedef enum {
;;         G_IO_ERROR_NONE, G_IO_ERROR_AGAIN, G_IO_ERROR_INVAL,
;;   G_IO_ERROR_UNKNOWN
;;    } GIOError;
(ff:bind-c-constant G_IO_ERROR_NONE 0) ;;  G_IO_ERROR_NONE 
(ff:bind-c-constant G_IO_ERROR_AGAIN 1) ;;  G_IO_ERROR_AGAIN 
(ff:bind-c-constant G_IO_ERROR_INVAL 2) ;;  G_IO_ERROR_INVAL 
(ff:bind-c-constant G_IO_ERROR_UNKNOWN 3) ;;  G_IO_ERROR_UNKNOWN 
(ff:bind-c-type GIOError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:52 <724> 
;; typedef enum {
;;         G_IO_CHANNEL_ERROR_FBIG, G_IO_CHANNEL_ERROR_INVAL,
;;   G_IO_CHANNEL_ERROR_IO,
;;              G_IO_CHANNEL_ERROR_ISDIR, G_IO_CHANNEL_ERROR_NOSPC,
;;   G_IO_CHANNEL_ERROR_NXIO,
;;              G_IO_CHANNEL_ERROR_OVERFLOW, G_IO_CHANNEL_ERROR_PIPE,
;;   G_IO_CHANNEL_ERROR_FAILED
;;    } GIOChannelError;
(ff:bind-c-constant G_IO_CHANNEL_ERROR_FBIG
                    0) ;;
;;   G_IO_CHANNEL_ERROR_FBIG 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_INVAL
                    1) ;;
;;   G_IO_CHANNEL_ERROR_INVAL 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_IO 2) ;;  G_IO_CHANNEL_ERROR_IO 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_ISDIR
                    3) ;;
;;   G_IO_CHANNEL_ERROR_ISDIR 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_NOSPC
                    4) ;;
;;   G_IO_CHANNEL_ERROR_NOSPC 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_NXIO
                    5) ;;
;;   G_IO_CHANNEL_ERROR_NXIO 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_OVERFLOW
                    6) ;;
;;   G_IO_CHANNEL_ERROR_OVERFLOW 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_PIPE
                    7) ;;
;;   G_IO_CHANNEL_ERROR_PIPE 
(ff:bind-c-constant G_IO_CHANNEL_ERROR_FAILED
                    8) ;;
;;   G_IO_CHANNEL_ERROR_FAILED 
(ff:bind-c-type GIOChannelError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:67 <725> 
;; typedef enum {
;;         G_IO_STATUS_ERROR, G_IO_STATUS_NORMAL, G_IO_STATUS_EOF,
;;   G_IO_STATUS_AGAIN
;;    } GIOStatus;
(ff:bind-c-constant G_IO_STATUS_ERROR 0) ;;  G_IO_STATUS_ERROR 
(ff:bind-c-constant G_IO_STATUS_NORMAL 1) ;;  G_IO_STATUS_NORMAL 
(ff:bind-c-constant G_IO_STATUS_EOF 2) ;;  G_IO_STATUS_EOF 
(ff:bind-c-constant G_IO_STATUS_AGAIN 3) ;;  G_IO_STATUS_AGAIN 
(ff:bind-c-type GIOStatus :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:75 <726> 
;; typedef enum { G_SEEK_CUR, G_SEEK_SET, G_SEEK_END } GSeekType;
(ff:bind-c-constant G_SEEK_CUR 0) ;;  G_SEEK_CUR 
(ff:bind-c-constant G_SEEK_SET 1) ;;  G_SEEK_SET 
(ff:bind-c-constant G_SEEK_END 2) ;;  G_SEEK_END 
(ff:bind-c-type GSeekType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:82 <727> 
;; typedef enum {
;;         G_IO_IN =  0x000000001, G_IO_OUT =  0x000000004, G_IO_PRI =
;;   0x000000002,
;;              G_IO_ERR =  0x000000008, G_IO_HUP =  0x000000010, G_IO_NVAL
;;   =  0x000000020
;;    } GIOCondition;
(ff:bind-c-constant G_IO_IN 1) ;;  G_IO_IN =  0x000000001 
(ff:bind-c-constant G_IO_OUT 4) ;;  G_IO_OUT =  0x000000004 
(ff:bind-c-constant G_IO_PRI 2) ;;  G_IO_PRI =  0x000000002 
(ff:bind-c-constant G_IO_ERR 8) ;;  G_IO_ERR =  0x000000008 
(ff:bind-c-constant G_IO_HUP 16) ;;  G_IO_HUP =  0x000000010 
(ff:bind-c-constant G_IO_NVAL 32) ;;  G_IO_NVAL =  0x000000020 
(ff:bind-c-type GIOCondition :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:92 <728> 
;; typedef enum {
;;         G_IO_FLAG_APPEND =  0x000000001 LSHIFT  0x000000000,
;;   G_IO_FLAG_NONBLOCK
;;    =  0x000000001 LSHIFT  0x000000001, G_IO_FLAG_IS_READABLE =
;;   0x000000001
;;    LSHIFT  0x000000002, G_IO_FLAG_IS_WRITEABLE =  0x000000001 LSHIFT
;;   0x000000003,
;;              G_IO_FLAG_IS_SEEKABLE =  0x000000001 LSHIFT  0x000000004,
;;   G_IO_FLAG_MASK
;;    =(  0x000000001 LSHIFT  0x000000005) -  0x000000001,
;;   G_IO_FLAG_GET_MASK
;;    = G_IO_FLAG_MASK, G_IO_FLAG_SET_MASK = G_IO_FLAG_APPEND |
;;   G_IO_FLAG_NONBLOCK
;;    } GIOFlags;
(ff:bind-c-constant G_IO_FLAG_APPEND
                    1) ;;
;;   G_IO_FLAG_APPEND =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_IO_FLAG_NONBLOCK
                    2) ;;
;;   G_IO_FLAG_NONBLOCK =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_IO_FLAG_IS_READABLE
                    4) ;;
;;   G_IO_FLAG_IS_READABLE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_IO_FLAG_IS_WRITEABLE
                    8) ;;
;;   G_IO_FLAG_IS_WRITEABLE =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_IO_FLAG_IS_SEEKABLE
                    16) ;;
;;   G_IO_FLAG_IS_SEEKABLE =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_IO_FLAG_MASK
                    31) ;;
;;   G_IO_FLAG_MASK =(  0x000000001 LSHIFT  0x000000005) -  0x000000001 
(ff:bind-c-constant G_IO_FLAG_GET_MASK
                    G_IO_FLAG_MASK) ;;
;;   G_IO_FLAG_GET_MASK = G_IO_FLAG_MASK 

(ff:bind-c-constant G_IO_FLAG_SET_MASK 
		    (logior G_IO_FLAG_APPEND  G_IO_FLAG_NONBLOCK))
;;   G_IO_FLAG_SET_MASK = G_IO_FLAG_APPEND | G_IO_FLAG_NONBLOCK 
(ff:bind-c-type GIOFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:104 <729> 
;; struct _GIOChannel {
;;         guint ref_count; GIOFuncs* funcs; gchar* encoding; GIConv
;;   read_cd; GIConv
;;    write_cd; gchar* line_term; guint line_term_len; gsize buf_size;
;;   GString
;;   * read_buf; GString* encoded_read_buf; GString* write_buf; gchar
;;   partial_write_buf
;;   [  0x000000006]; guint use_buffer:  0x000000001; guint do_encode:
;;   0x000000001;
;;              guint close_on_unref:  0x000000001; guint is_readable:
;;   0x000000001; guint
;;    is_writeable:  0x000000001; guint is_seekable:  0x000000001; gpointer
;;    reserved1; gpointer reserved2; };

;;WARNING: Strange bitfield use_buffer type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield do_encode type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield close_on_unref type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_readable type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_writeable type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_seekable type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GIOChannel (:struct
  (ref_count guint)   ;; guint ref_count
  (funcs (* GIOFuncs))   ;; GIOFuncs* funcs
  (encoding (* gchar))   ;; gchar* encoding
  (read_cd GIConv)   ;; GIConv read_cd
  (write_cd GIConv)   ;; GIConv write_cd
  (line_term (* gchar))   ;; gchar* line_term
  (line_term_len guint)   ;; guint line_term_len
  (buf_size gsize)   ;; gsize buf_size
  (read_buf (* GString))   ;; GString* read_buf
  (encoded_read_buf (* GString))   ;; GString* encoded_read_buf
  (write_buf (* GString))   ;; GString* write_buf
  (partial_write_buf (:array gchar
                      6))   ;;
  ;;  gchar partial_write_buf[  0x000000006]
  (use_buffer (:bit 1))   ;; guint use_buffer:  0x000000001
  (do_encode (:bit 1))   ;; guint do_encode:  0x000000001
  (close_on_unref (:bit 1))   ;; guint close_on_unref:  0x000000001
  (is_readable (:bit 1))   ;; guint is_readable:  0x000000001
  (is_writeable (:bit 1))   ;; guint is_writeable:  0x000000001
  (is_seekable (:bit 1))   ;; guint is_seekable:  0x000000001
  (reserved1 gpointer)   ;; gpointer reserved1
  (reserved2 gpointer)   ;; gpointer reserved2
  ))   ;; bind-c-type _GIOChannel
(ff:bind-c-typedef GIOChannel _GIOChannel) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:135 <730> 
;; typedef gboolean(* GIOFunc)( GIOChannel* source, GIOCondition condition,
;;              gpointer data);
(ff:bind-c-type GIOFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:138 <731> 
;; struct _GIOFuncs {
;;         GIOStatus(* io_read)( GIOChannel* channel, gchar* buf, gsize
;;   count, gsize
;;   * bytes_read, GError** err); GIOStatus(* io_write)( GIOChannel*
;;   channel,
;;              const gchar* buf, gsize count, gsize* bytes_written,
;;   GError** err); GIOStatus
;;   (* io_seek)( GIOChannel* channel, gint64 offset, GSeekType type,
;;   GError
;;   ** err); GIOStatus(* io_close)( GIOChannel* channel, GError** err);
;;   GSource
;;   *(* io_create_watch)( GIOChannel* channel, GIOCondition condition);
;;   void
;;   (* io_free)( GIOChannel* channel); GIOStatus(* io_set_flags)(
;;   GIOChannel
;;   * channel, GIOFlags flags, GError** err); GIOFlags(* io_get_flags)(
;;   GIOChannel
;;   * channel); };
(ff:bind-c-type _GIOFuncs (:struct
  (io_read ff:function-pointer)   ;;
  ;;  GIOStatus(* io_read)( GIOChannel* channel, gchar* buf, gsize count, gsize* bytes_read,
  ;;            GError** err)
  (io_write ff:function-pointer)   ;;
  ;;  GIOStatus(* io_write)( GIOChannel* channel, const gchar* buf, gsize count, gsize
  ;; * bytes_written, GError** err)
  (io_seek ff:function-pointer)   ;;
  ;;  GIOStatus(* io_seek)( GIOChannel* channel, gint64 offset, GSeekType type, GError
  ;; ** err)
  (io_close ff:function-pointer)   ;;
  ;;  GIOStatus(* io_close)( GIOChannel* channel, GError** err)
  (io_create_watch ff:function-pointer)   ;;
  ;;  GSource*(* io_create_watch)( GIOChannel* channel, GIOCondition condition)
  (io_free ff:function-pointer)   ;; void(* io_free)( GIOChannel* channel)
  (io_set_flags ff:function-pointer)   ;;
  ;;  GIOStatus(* io_set_flags)( GIOChannel* channel, GIOFlags flags, GError** err)
  (io_get_flags ff:function-pointer)   ;;
  ;;  GIOFlags(* io_get_flags)( GIOChannel* channel)
  ))   ;; bind-c-type _GIOFuncs
(ff:bind-c-typedef GIOFuncs _GIOFuncs) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:165 <732> 
;; void g_io_channel_init( GIOChannel* channel);
(ff:bind-c-function g_io_channel_init
     :unconverted-entry-name "g_io_channel_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:166 <733> 
;; void g_io_channel_ref( GIOChannel* channel);
(ff:bind-c-function g_io_channel_ref
     :unconverted-entry-name "g_io_channel_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:167 <734> 
;; void g_io_channel_unref( GIOChannel* channel);
(ff:bind-c-function g_io_channel_unref
     :unconverted-entry-name "g_io_channel_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:170 <735> 
;; GIOError g_io_channel_read( GIOChannel* channel, gchar* buf, gsize
;;   count,
;;              gsize* bytes_read);
(ff:bind-c-function g_io_channel_read
     :unconverted-entry-name "g_io_channel_read"
     :c-return-type ("GIOError")
     :return-type GIOError
     :c-arg-types (("GIOChannel" "*") ("gchar" "*") ("gsize")
                   ("gsize" "*"))
     :c-arg-names (channel buf count bytes_read)
     :arguments ((* GIOChannel) (* gchar) gsize (* gsize))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:174 <736> 
;; GIOError g_io_channel_write( GIOChannel* channel, const gchar* buf,
;;   gsize
;;    count, gsize* bytes_written);
(ff:bind-c-function g_io_channel_write
     :unconverted-entry-name "g_io_channel_write"
     :c-return-type ("GIOError")
     :return-type GIOError
     :c-arg-types (("GIOChannel" "*") ("const" "gchar" "*") ("gsize")
                   ("gsize" "*"))
     :c-arg-names (channel buf count bytes_written)
     :arguments ((* GIOChannel) (* gchar) gsize (* gsize))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:178 <737> 
;; GIOError g_io_channel_seek( GIOChannel* channel, gint64 offset,
;;   GSeekType
;;    type);

;;NOTE: C wrapper needed to pass structure or union type
;;   gint64
;;   as argument.
(ff:bind-c-function g_io_channel_seek
     :unconverted-entry-name "ACL_g_io_channel_seek"
     :c-return-type ("GIOError")
     :return-type GIOError
     :c-arg-types (("GIOChannel" "*") ("gint64" "*") ("GSeekType"))
     :c-arg-names (channel offset type)
     :arguments ((* GIOChannel) (* gint64) GSeekType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:181 <738> 
;; void g_io_channel_close( GIOChannel* channel);
(ff:bind-c-function g_io_channel_close
     :unconverted-entry-name "g_io_channel_close"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:184 <739> 
;; GIOStatus g_io_channel_shutdown( GIOChannel* channel, gboolean flush,
;;              GError** err);
(ff:bind-c-function g_io_channel_shutdown
     :unconverted-entry-name "g_io_channel_shutdown"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("gboolean") ("GError" "*" "*"))
     :c-arg-names (channel flush err)
     :arguments ((* GIOChannel) gboolean (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:187 <740> 
;; guint g_io_add_watch_full( GIOChannel* channel, gint priority,
;;   GIOCondition
;;    condition, GIOFunc func, gpointer user_data, GDestroyNotify notify);
(ff:bind-c-function g_io_add_watch_full
     :unconverted-entry-name "g_io_add_watch_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GIOChannel" "*") ("gint") ("GIOCondition")
                   ("GIOFunc") ("gpointer") ("GDestroyNotify"))
     :c-arg-names (channel priority condition func user_data notify)
     :arguments ((* GIOChannel) gint GIOCondition GIOFunc gpointer
                 GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:193 <741> 
;; GSource* g_io_create_watch( GIOChannel* channel, GIOCondition
;;   condition);
(ff:bind-c-function g_io_create_watch
     :unconverted-entry-name "g_io_create_watch"
     :c-return-type ("GSource" "*")
     :return-type (* GSource)
     :c-arg-types (("GIOChannel" "*") ("GIOCondition"))
     :c-arg-names (channel condition)
     :arguments ((* GIOChannel) GIOCondition)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:195 <742> 
;; guint g_io_add_watch( GIOChannel* channel, GIOCondition condition,
;;   GIOFunc
;;    func, gpointer user_data);
(ff:bind-c-function g_io_add_watch
     :unconverted-entry-name "g_io_add_watch"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GIOChannel" "*") ("GIOCondition") ("GIOFunc")
                   ("gpointer"))
     :c-arg-names (channel condition func user_data)
     :arguments ((* GIOChannel) GIOCondition GIOFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:203 <743> 
;; void g_io_channel_set_buffer_size( GIOChannel* channel, gsize size);
(ff:bind-c-function g_io_channel_set_buffer_size
     :unconverted-entry-name "g_io_channel_set_buffer_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*") ("gsize"))
     :c-arg-names (channel size)
     :arguments ((* GIOChannel) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:205 <744> 
;; gsize g_io_channel_get_buffer_size( GIOChannel* channel);
(ff:bind-c-function g_io_channel_get_buffer_size
     :unconverted-entry-name "g_io_channel_get_buffer_size"
     :c-return-type ("gsize")
     :return-type gsize
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:206 <745> 
;; GIOCondition g_io_channel_get_buffer_condition( GIOChannel* channel);
(ff:bind-c-function g_io_channel_get_buffer_condition
     :unconverted-entry-name "g_io_channel_get_buffer_condition"
     :c-return-type ("GIOCondition")
     :return-type GIOCondition
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:207 <746> 
;; GIOStatus g_io_channel_set_flags( GIOChannel* channel, GIOFlags flags,
;;              GError** error);
(ff:bind-c-function g_io_channel_set_flags
     :unconverted-entry-name "g_io_channel_set_flags"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("GIOFlags") ("GError" "*" "*"))
     :c-arg-names (channel flags error)
     :arguments ((* GIOChannel) GIOFlags (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:210 <747> 
;; GIOFlags g_io_channel_get_flags( GIOChannel* channel);
(ff:bind-c-function g_io_channel_get_flags
     :unconverted-entry-name "g_io_channel_get_flags"
     :c-return-type ("GIOFlags")
     :return-type GIOFlags
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:211 <748> 
;; void g_io_channel_set_line_term( GIOChannel* channel, const gchar*
;;   line_term,
;;              gint length);
(ff:bind-c-function g_io_channel_set_line_term
     :unconverted-entry-name "g_io_channel_set_line_term"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (channel line_term length)
     :arguments ((* GIOChannel) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:214 <749> 
;; const gchar* g_io_channel_get_line_term( GIOChannel* channel, gint*
;;   length
;;   );
(ff:bind-c-function g_io_channel_get_line_term
     :unconverted-entry-name "g_io_channel_get_line_term"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GIOChannel" "*") ("gint" "*"))
     :c-arg-names (channel length)
     :arguments ((* GIOChannel) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:216 <750> 
;; void g_io_channel_set_buffered( GIOChannel* channel, gboolean buffered);
(ff:bind-c-function g_io_channel_set_buffered
     :unconverted-entry-name "g_io_channel_set_buffered"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*") ("gboolean"))
     :c-arg-names (channel buffered)
     :arguments ((* GIOChannel) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:218 <751> 
;; gboolean g_io_channel_get_buffered( GIOChannel* channel);
(ff:bind-c-function g_io_channel_get_buffered
     :unconverted-entry-name "g_io_channel_get_buffered"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:219 <752> 
;; GIOStatus g_io_channel_set_encoding( GIOChannel* channel, const gchar
;;   * encoding, GError** error);
(ff:bind-c-function g_io_channel_set_encoding
     :unconverted-entry-name "g_io_channel_set_encoding"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("const" "gchar" "*")
                   ("GError" "*" "*"))
     :c-arg-names (channel encoding error)
     :arguments ((* GIOChannel) (* gchar) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:222 <753> 
;; const gchar* g_io_channel_get_encoding( GIOChannel* channel);
(ff:bind-c-function g_io_channel_get_encoding
     :unconverted-entry-name "g_io_channel_get_encoding"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:223 <754> 
;; void g_io_channel_set_close_on_unref( GIOChannel* channel, gboolean
;;   do_close
;;   );
(ff:bind-c-function g_io_channel_set_close_on_unref
     :unconverted-entry-name "g_io_channel_set_close_on_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*") ("gboolean"))
     :c-arg-names (channel do_close)
     :arguments ((* GIOChannel) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:225 <755> 
;; gboolean g_io_channel_get_close_on_unref( GIOChannel* channel);
(ff:bind-c-function g_io_channel_get_close_on_unref
     :unconverted-entry-name "g_io_channel_get_close_on_unref"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:228 <756> 
;; GIOStatus g_io_channel_flush( GIOChannel* channel, GError** error);
(ff:bind-c-function g_io_channel_flush
     :unconverted-entry-name "g_io_channel_flush"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("GError" "*" "*"))
     :c-arg-names (channel error)
     :arguments ((* GIOChannel) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:230 <757> 
;; GIOStatus g_io_channel_read_line( GIOChannel* channel, gchar**
;;   str_return,
;;              gsize* length, gsize* terminator_pos, GError** error);
(ff:bind-c-function g_io_channel_read_line
     :unconverted-entry-name "g_io_channel_read_line"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("gchar" "*" "*") ("gsize" "*")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (channel str_return length terminator_pos error)
     :arguments ((* GIOChannel) (* (* gchar)) (* gsize) (* gsize)
                 (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:235 <758> 
;; GIOStatus g_io_channel_read_line_string( GIOChannel* channel, GString
;;   * buffer, gsize* terminator_pos, GError** error);
(ff:bind-c-function g_io_channel_read_line_string
     :unconverted-entry-name "g_io_channel_read_line_string"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("GString" "*") ("gsize" "*")
                   ("GError" "*" "*"))
     :c-arg-names (channel buffer terminator_pos error)
     :arguments ((* GIOChannel) (* GString) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:239 <759> 
;; GIOStatus g_io_channel_read_to_end( GIOChannel* channel, gchar**
;;   str_return,
;;              gsize* length, GError** error);
(ff:bind-c-function g_io_channel_read_to_end
     :unconverted-entry-name "g_io_channel_read_to_end"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("gchar" "*" "*") ("gsize" "*")
                   ("GError" "*" "*"))
     :c-arg-names (channel str_return length error)
     :arguments ((* GIOChannel) (* (* gchar)) (* gsize) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:243 <760> 
;; GIOStatus g_io_channel_read_chars( GIOChannel* channel, gchar* buf,
;;   gsize
;;    count, gsize* bytes_read, GError** error);
(ff:bind-c-function g_io_channel_read_chars
     :unconverted-entry-name "g_io_channel_read_chars"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("gchar" "*") ("gsize")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (channel buf count bytes_read error)
     :arguments ((* GIOChannel) (* gchar) gsize (* gsize)
                 (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:248 <761> 
;; GIOStatus g_io_channel_read_unichar( GIOChannel* channel, gunichar*
;;   thechar,
;;              GError** error);
(ff:bind-c-function g_io_channel_read_unichar
     :unconverted-entry-name "g_io_channel_read_unichar"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("gunichar" "*")
                   ("GError" "*" "*"))
     :c-arg-names (channel thechar error)
     :arguments ((* GIOChannel) (* gunichar) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:251 <762> 
;; GIOStatus g_io_channel_write_chars( GIOChannel* channel, const gchar*
;;    buf, gssize count, gsize* bytes_written, GError** error);
(ff:bind-c-function g_io_channel_write_chars
     :unconverted-entry-name "g_io_channel_write_chars"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("const" "gchar" "*") ("gssize")
                   ("gsize" "*") ("GError" "*" "*"))
     :c-arg-names (channel buf count bytes_written error)
     :arguments ((* GIOChannel) (* gchar) gssize (* gsize)
                 (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:256 <763> 
;; GIOStatus g_io_channel_write_unichar( GIOChannel* channel, gunichar
;;   thechar,
;;              GError** error);
(ff:bind-c-function g_io_channel_write_unichar
     :unconverted-entry-name "g_io_channel_write_unichar"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("gunichar") ("GError" "*" "*"))
     :c-arg-names (channel thechar error)
     :arguments ((* GIOChannel) gunichar (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:259 <764> 
;; GIOStatus g_io_channel_seek_position( GIOChannel* channel, gint64
;;   offset,
;;              GSeekType type, GError** error);

;;NOTE: C wrapper needed to pass structure or union type
;;   gint64
;;   as argument.
(ff:bind-c-function g_io_channel_seek_position
     :unconverted-entry-name "ACL_g_io_channel_seek_position"
     :c-return-type ("GIOStatus")
     :return-type GIOStatus
     :c-arg-types (("GIOChannel" "*") ("gint64" "*") ("GSeekType")
                   ("GError" "*" "*"))
     :c-arg-names (channel offset type error)
     :arguments ((* GIOChannel) (* gint64) GSeekType (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:263 <765> 
;; GIOChannel* g_io_channel_new_file( const gchar* filename, const gchar
;;   * mode, GError** error);
(ff:bind-c-function g_io_channel_new_file
     :unconverted-entry-name "g_io_channel_new_file"
     :c-return-type ("GIOChannel" "*")
     :return-type (* GIOChannel)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("GError" "*" "*"))
     :c-arg-names (filename mode error)
     :arguments ((* gchar) (* gchar) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:269 <766> 
;; GQuark g_io_channel_error_quark( void);
(ff:bind-c-function g_io_channel_error_quark
     :unconverted-entry-name "g_io_channel_error_quark"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:270 <767> 
;; GIOChannelError g_io_channel_error_from_errno( gint en);
(ff:bind-c-function g_io_channel_error_from_errno
     :unconverted-entry-name "g_io_channel_error_from_errno"
     :c-return-type ("GIOChannelError")
     :return-type GIOChannelError
     :c-arg-types (("gint"))
     :c-arg-names (en)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:290 <768> 
;; GIOChannel* g_io_channel_unix_new( int fd);
(ff:bind-c-function g_io_channel_unix_new
     :unconverted-entry-name "g_io_channel_unix_new"
     :c-return-type ("GIOChannel" "*")
     :return-type (* GIOChannel)
     :c-arg-types (("int"))
     :c-arg-names (fd)
     :arguments (:int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:291 <769> 
;; gint g_io_channel_unix_get_fd( GIOChannel* channel);
(ff:bind-c-function g_io_channel_unix_get_fd
     :unconverted-entry-name "g_io_channel_unix_get_fd"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/giochannel.h:295 <770> 
;; extern GSourceFuncs g_io_watch_funcs;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_io_watch_funcs"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:28 <771> 
;; typedef enum {
;;         G_MARKUP_ERROR_BAD_UTF8, G_MARKUP_ERROR_EMPTY,
;;   G_MARKUP_ERROR_PARSE, G_MARKUP_ERROR_UNKNOWN_ELEMENT,
;;              G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE,
;;   G_MARKUP_ERROR_INVALID_CONTENT } GMarkupError
;;   ;
(ff:bind-c-constant G_MARKUP_ERROR_BAD_UTF8
                    0) ;;
;;   G_MARKUP_ERROR_BAD_UTF8 
(ff:bind-c-constant G_MARKUP_ERROR_EMPTY 1) ;;  G_MARKUP_ERROR_EMPTY 
(ff:bind-c-constant G_MARKUP_ERROR_PARSE 2) ;;  G_MARKUP_ERROR_PARSE 
(ff:bind-c-constant G_MARKUP_ERROR_UNKNOWN_ELEMENT
                    3) ;;
;;   G_MARKUP_ERROR_UNKNOWN_ELEMENT 
(ff:bind-c-constant G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE
                    4) ;;
;;   G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE 
(ff:bind-c-constant G_MARKUP_ERROR_INVALID_CONTENT
                    5) ;;
;;   G_MARKUP_ERROR_INVALID_CONTENT 
(ff:bind-c-type GMarkupError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:43 <772> 
;; GQuark g_markup_error_quark( void);
(ff:bind-c-function g_markup_error_quark
     :unconverted-entry-name "g_markup_error_quark"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:45 <773> 
;; typedef enum {
;;         G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG =  0x000000001 LSHIFT
;;   0x000000000
;;    } GMarkupParseFlags;
(ff:bind-c-constant G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG
                    1) ;;
;;   G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-type GMarkupParseFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:52 <774> 
;; typedef struct _GMarkupParseContext GMarkupParseContext;
(ff:bind-c-typedef _GMarkupParseContext
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMarkupParseContext _GMarkupParseContext)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:53 <775> 
;; typedef struct _GMarkupParser GMarkupParser;
(ff:bind-c-typedef _GMarkupParser
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMarkupParser _GMarkupParser)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:55 <776> 
;; struct _GMarkupParser {
;;         void(* start_element)( GMarkupParseContext* context, const
;;   gchar* element_name,
;;              const gchar** attribute_names, const gchar**
;;   attribute_values, gpointer
;;    user_data, GError** error); void(* end_element)( GMarkupParseContext*
;;    context, const gchar* element_name, gpointer user_data, GError**
;;   error
;;   ); void(* text)( GMarkupParseContext* context, const gchar* text,
;;   gsize
;;    text_len, gpointer user_data, GError** error); void(* passthrough)(
;;   GMarkupParseContext
;;   * context, const gchar* passthrough_text, gsize text_len, gpointer
;;   user_data,
;;              GError** error); void(* error)( GMarkupParseContext*
;;   context, GError*
;;    error, gpointer user_data); };
(ff:bind-c-type _GMarkupParser (:struct
  (start_element ff:function-pointer)   ;;
  ;;  void(* start_element)( GMarkupParseContext* context, const gchar* element_name,
  ;;            const gchar** attribute_names, const gchar** attribute_values, gpointer
  ;;  user_data, GError** error)
  (end_element ff:function-pointer)   ;;
  ;;  void(* end_element)( GMarkupParseContext* context, const gchar* element_name,
  ;;            gpointer user_data, GError** error)
  (text ff:function-pointer)   ;;
  ;;  void(* text)( GMarkupParseContext* context, const gchar* text, gsize text_len,
  ;;            gpointer user_data, GError** error)
  (passthrough ff:function-pointer)   ;;
  ;;  void(* passthrough)( GMarkupParseContext* context, const gchar* passthrough_text,
  ;;            gsize text_len, gpointer user_data, GError** error)
  (error ff:function-pointer)   ;;
  ;;  void(* error)( GMarkupParseContext* context, GError* error, gpointer user_data
  ;; )
  ))   ;; bind-c-type _GMarkupParser
(ff:bind-c-typedef GMarkupParser _GMarkupParser) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:98 <777> 
;; GMarkupParseContext* g_markup_parse_context_new( const GMarkupParser*
;;    parser, GMarkupParseFlags flags, gpointer user_data, GDestroyNotify
;;   user_data_dnotify
;;   );
(ff:bind-c-function g_markup_parse_context_new
     :unconverted-entry-name "g_markup_parse_context_new"
     :c-return-type ("GMarkupParseContext" "*")
     :return-type (* GMarkupParseContext)
     :c-arg-types (("const" "GMarkupParser" "*") ("GMarkupParseFlags")
                   ("gpointer") ("GDestroyNotify"))
     :c-arg-names (parser flags user_data user_data_dnotify)
     :arguments ((* GMarkupParser) GMarkupParseFlags gpointer
                 GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:102 <778> 
;; void g_markup_parse_context_free( GMarkupParseContext* context);
(ff:bind-c-function g_markup_parse_context_free
     :unconverted-entry-name "g_markup_parse_context_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMarkupParseContext" "*"))
     :c-arg-names (context)
     :arguments ((* GMarkupParseContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:103 <779> 
;; gboolean g_markup_parse_context_parse( GMarkupParseContext* context,
;;   const
;;    gchar* text, gssize text_len, GError** error);
(ff:bind-c-function g_markup_parse_context_parse
     :unconverted-entry-name "g_markup_parse_context_parse"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMarkupParseContext" "*") ("const" "gchar" "*")
                   ("gssize") ("GError" "*" "*"))
     :c-arg-names (context text text_len error)
     :arguments ((* GMarkupParseContext) (* gchar) gssize
                 (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:108 <780> 
;; gboolean g_markup_parse_context_end_parse( GMarkupParseContext* context,
;;              GError** error);
(ff:bind-c-function g_markup_parse_context_end_parse
     :unconverted-entry-name "g_markup_parse_context_end_parse"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMarkupParseContext" "*") ("GError" "*" "*"))
     :c-arg-names (context error)
     :arguments ((* GMarkupParseContext) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:112 <781> 
;; void g_markup_parse_context_get_position( GMarkupParseContext* context,
;;              gint* line_number, gint* char_number);
(ff:bind-c-function g_markup_parse_context_get_position
     :unconverted-entry-name "g_markup_parse_context_get_position"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMarkupParseContext" "*") ("gint" "*")
                   ("gint" "*"))
     :c-arg-names (context line_number char_number)
     :arguments ((* GMarkupParseContext) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmarkup.h:117 <782> 
;; gchar* g_markup_escape_text( const gchar* text, gssize length);
(ff:bind-c-function g_markup_escape_text
     :unconverted-entry-name "g_markup_escape_text"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (text length)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /usr/include/sys/va_list.h:26 <783> typedef void* __va_list;
(ff:bind-c-type __va_list (* :void))  

;; ---------------------------------------------------

;; /usr/include/iso/stdarg_iso.h:48 <784> typedef __va_list va_list;
(ff:bind-c-type va_list __va_list)  

;; /usr/include/iso/stdarg_iso.h:117 <785> extern void va_end( __va_list);
(ff:bind-c-function va_end
     :unconverted-entry-name "va_end"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("__va_list"))
     :c-arg-names (Arg0)
     :arguments (__va_list)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:43 <786> 
;; gsize g_printf_string_upper_bound( const gchar* format, va_list args);
(ff:bind-c-function g_printf_string_upper_bound
     :unconverted-entry-name "g_printf_string_upper_bound"
     :c-return-type ("gsize")
     :return-type gsize
     :c-arg-types (("const" "gchar" "*") ("va_list"))
     :c-arg-names (format args)
     :arguments ((* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:53 <787> 
;; typedef enum {
;;         G_LOG_FLAG_RECURSION =  0x000000001 LSHIFT  0x000000000,
;;   G_LOG_FLAG_FATAL
;;    =  0x000000001 LSHIFT  0x000000001, G_LOG_LEVEL_ERROR =  0x000000001
;;   LSHIFT
;;     0x000000002, G_LOG_LEVEL_CRITICAL =  0x000000001 LSHIFT
;;   0x000000003,
;;              G_LOG_LEVEL_WARNING =  0x000000001 LSHIFT  0x000000004,
;;   G_LOG_LEVEL_MESSAGE
;;    =  0x000000001 LSHIFT  0x000000005, G_LOG_LEVEL_INFO =  0x000000001
;;   LSHIFT
;;     0x000000006, G_LOG_LEVEL_DEBUG =  0x000000001 LSHIFT  0x000000007,
;;   G_LOG_LEVEL_MASK
;;    = ~( G_LOG_FLAG_RECURSION | G_LOG_FLAG_FATAL) } GLogLevelFlags;
(ff:bind-c-constant G_LOG_FLAG_RECURSION
                    1) ;;
;;   G_LOG_FLAG_RECURSION =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_LOG_FLAG_FATAL
                    2) ;;
;;   G_LOG_FLAG_FATAL =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_LOG_LEVEL_ERROR
                    4) ;;
;;   G_LOG_LEVEL_ERROR =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_LOG_LEVEL_CRITICAL
                    8) ;;
;;   G_LOG_LEVEL_CRITICAL =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_LOG_LEVEL_WARNING
                    16) ;;
;;   G_LOG_LEVEL_WARNING =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_LOG_LEVEL_MESSAGE
                    32) ;;
;;   G_LOG_LEVEL_MESSAGE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant G_LOG_LEVEL_INFO
                    64) ;;
;;   G_LOG_LEVEL_INFO =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant G_LOG_LEVEL_DEBUG
                    128) ;;
;;   G_LOG_LEVEL_DEBUG =  0x000000001 LSHIFT  0x000000007 

(ff:bind-c-constant G_LOG_LEVEL_MASK
		    (lognot (logior G_LOG_FLAG_RECURSION G_LOG_FLAG_FATAL)))
;;   G_LOG_LEVEL_MASK = ~( G_LOG_FLAG_RECURSION | G_LOG_FLAG_FATAL) 
(ff:bind-c-type GLogLevelFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:73 <788> 
;; typedef void(* GLogFunc)( const gchar* log_domain, GLogLevelFlags
;;   log_level,
;;              const gchar* message, gpointer user_data);
(ff:bind-c-type GLogFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:80 <789> 
;; guint g_log_set_handler( const gchar* log_domain, GLogLevelFlags
;;   log_levels,
;;              GLogFunc log_func, gpointer user_data);
(ff:bind-c-function g_log_set_handler
     :unconverted-entry-name "g_log_set_handler"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags")
                   ("GLogFunc") ("gpointer"))
     :c-arg-names (log_domain log_levels log_func user_data)
     :arguments ((* gchar) GLogLevelFlags GLogFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:84 <790> 
;; void g_log_remove_handler( const gchar* log_domain, guint handler_id);
(ff:bind-c-function g_log_remove_handler
     :unconverted-entry-name "g_log_remove_handler"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("guint"))
     :c-arg-names (log_domain handler_id)
     :arguments ((* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:86 <791> 
;; void g_log_default_handler( const gchar* log_domain, GLogLevelFlags
;;   log_level,
;;              const gchar* message, gpointer unused_data);
(ff:bind-c-function g_log_default_handler
     :unconverted-entry-name "g_log_default_handler"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags")
                   ("const" "gchar" "*") ("gpointer"))
     :c-arg-names (log_domain log_level message unused_data)
     :arguments ((* gchar) GLogLevelFlags (* gchar) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:90 <792> 
;; void g_log( const gchar* log_domain, GLogLevelFlags log_level, const
;;   gchar
;;   * format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_log
     :unconverted-entry-name "g_log"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags")
                   ("const" "gchar" "*") "...")
     :c-arg-names (log_domain log_level format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:94 <793> 
;; void g_logv( const gchar* log_domain, GLogLevelFlags log_level, const
;;    gchar* format, va_list args);
(ff:bind-c-function g_logv
     :unconverted-entry-name "g_logv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags")
                   ("const" "gchar" "*") ("va_list"))
     :c-arg-names (log_domain log_level format args)
     :arguments ((* gchar) GLogLevelFlags (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:98 <794> 
;; GLogLevelFlags g_log_set_fatal_mask( const gchar* log_domain,
;;   GLogLevelFlags
;;    fatal_mask);
(ff:bind-c-function g_log_set_fatal_mask
     :unconverted-entry-name "g_log_set_fatal_mask"
     :c-return-type ("GLogLevelFlags")
     :return-type GLogLevelFlags
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags"))
     :c-arg-names (log_domain fatal_mask)
     :arguments ((* gchar) GLogLevelFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:100 <795> 
;; GLogLevelFlags g_log_set_always_fatal( GLogLevelFlags fatal_mask);
(ff:bind-c-function g_log_set_always_fatal
     :unconverted-entry-name "g_log_set_always_fatal"
     :c-return-type ("GLogLevelFlags")
     :return-type GLogLevelFlags
     :c-arg-types (("GLogLevelFlags"))
     :c-arg-names (fatal_mask)
     :arguments (GLogLevelFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:170 <796> 
;; typedef void(* GPrintFunc)( const gchar* string);
(ff:bind-c-type GPrintFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:171 <797> 
;; void g_print( const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_print
     :unconverted-entry-name "g_print"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:173 <798> 
;; GPrintFunc g_set_print_handler( GPrintFunc func);
(ff:bind-c-function g_set_print_handler
     :unconverted-entry-name "g_set_print_handler"
     :c-return-type ("GPrintFunc")
     :return-type GPrintFunc
     :c-arg-types (("GPrintFunc"))
     :c-arg-names (func)
     :arguments (GPrintFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:174 <799> 
;; void g_printerr( const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_printerr
     :unconverted-entry-name "g_printerr"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gmessages.h:176 <800> 
;; GPrintFunc g_set_printerr_handler( GPrintFunc func);
(ff:bind-c-function g_set_printerr_handler
     :unconverted-entry-name "g_set_printerr_handler"
     :c-return-type ("GPrintFunc")
     :return-type GPrintFunc
     :c-arg-types (("GPrintFunc"))
     :c-arg-names (func)
     :arguments (GPrintFunc)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:34 <801> 
;; typedef struct _GNode GNode;
(ff:bind-c-typedef _GNode
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GNode _GNode)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:37 <802> 
;; typedef enum {
;;         G_TRAVERSE_LEAFS =  0x000000001 LSHIFT  0x000000000,
;;   G_TRAVERSE_NON_LEAFS
;;    =  0x000000001 LSHIFT  0x000000001, G_TRAVERSE_ALL = G_TRAVERSE_LEAFS
;;    | G_TRAVERSE_NON_LEAFS, G_TRAVERSE_MASK =  0x000000003 }
;;   GTraverseFlags
;;   ;
(ff:bind-c-constant G_TRAVERSE_LEAFS
                    1) ;;
;;   G_TRAVERSE_LEAFS =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_TRAVERSE_NON_LEAFS
                    2) ;;
;;   G_TRAVERSE_NON_LEAFS =  0x000000001 LSHIFT  0x000000001 

(ff:bind-c-constant G_TRAVERSE_ALL
		    (logior G_TRAVERSE_LEAFS G_TRAVERSE_NON_LEAFS))
;;   G_TRAVERSE_ALL = G_TRAVERSE_LEAFS | G_TRAVERSE_NON_LEAFS 
(ff:bind-c-constant G_TRAVERSE_MASK
                    3) ;;
;;   G_TRAVERSE_MASK =  0x000000003 
(ff:bind-c-type GTraverseFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:46 <803> 
;; typedef enum {
;;         G_IN_ORDER, G_PRE_ORDER, G_POST_ORDER, G_LEVEL_ORDER }
;;   GTraverseType;
(ff:bind-c-constant G_IN_ORDER 0) ;;  G_IN_ORDER 
(ff:bind-c-constant G_PRE_ORDER 1) ;;  G_PRE_ORDER 
(ff:bind-c-constant G_POST_ORDER 2) ;;  G_POST_ORDER 
(ff:bind-c-constant G_LEVEL_ORDER 3) ;;  G_LEVEL_ORDER 
(ff:bind-c-type GTraverseType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:54 <804> 
;; typedef gboolean(* GNodeTraverseFunc)( GNode* node, gpointer data);
(ff:bind-c-type GNodeTraverseFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:56 <805> 
;; typedef void(* GNodeForeachFunc)( GNode* node, gpointer data);
(ff:bind-c-type GNodeForeachFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:61 <806> 
;; struct _GNode {
;;         gpointer data; GNode* next; GNode* prev; GNode* parent; GNode*
;;   children;
;;    };
(ff:bind-c-type _GNode (:struct
  (data gpointer)   ;; gpointer data
  (next (* GNode))   ;; GNode* next
  (prev (* GNode))   ;; GNode* prev
  (parent (* GNode))   ;; GNode* parent
  (children (* GNode))   ;; GNode* children
  ))   ;; bind-c-type _GNode
(ff:bind-c-typedef GNode _GNode) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:75 <807> 
;; void g_node_push_allocator( GAllocator* allocator);
(ff:bind-c-function g_node_push_allocator
     :unconverted-entry-name "g_node_push_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:76 <808> 
;; void g_node_pop_allocator( void);
(ff:bind-c-function g_node_pop_allocator
     :unconverted-entry-name "g_node_pop_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:77 <809> 
;; GNode* g_node_new( gpointer data);
(ff:bind-c-function g_node_new
     :unconverted-entry-name "g_node_new"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("gpointer"))
     :c-arg-names (data)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:78 <810> 
;; void g_node_destroy( GNode* root);
(ff:bind-c-function g_node_destroy
     :unconverted-entry-name "g_node_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*"))
     :c-arg-names (root)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:79 <811> 
;; void g_node_unlink( GNode* node);
(ff:bind-c-function g_node_unlink
     :unconverted-entry-name "g_node_unlink"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:80 <812> 
;; GNode* g_node_copy( GNode* node);
(ff:bind-c-function g_node_copy
     :unconverted-entry-name "g_node_copy"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:81 <813> 
;; GNode* g_node_insert( GNode* parent, gint position, GNode* node);
(ff:bind-c-function g_node_insert
     :unconverted-entry-name "g_node_insert"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("gint") ("GNode" "*"))
     :c-arg-names (parent position node)
     :arguments ((* GNode) gint (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:84 <814> 
;; GNode* g_node_insert_before( GNode* parent, GNode* sibling, GNode*
;;   node);
(ff:bind-c-function g_node_insert_before
     :unconverted-entry-name "g_node_insert_before"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GNode" "*") ("GNode" "*"))
     :c-arg-names (parent sibling node)
     :arguments ((* GNode) (* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:87 <815> 
;; GNode* g_node_insert_after( GNode* parent, GNode* sibling, GNode* node);
(ff:bind-c-function g_node_insert_after
     :unconverted-entry-name "g_node_insert_after"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GNode" "*") ("GNode" "*"))
     :c-arg-names (parent sibling node)
     :arguments ((* GNode) (* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:90 <816> 
;; GNode* g_node_prepend( GNode* parent, GNode* node);
(ff:bind-c-function g_node_prepend
     :unconverted-entry-name "g_node_prepend"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GNode" "*"))
     :c-arg-names (parent node)
     :arguments ((* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:92 <817> 
;; guint g_node_n_nodes( GNode* root, GTraverseFlags flags);
(ff:bind-c-function g_node_n_nodes
     :unconverted-entry-name "g_node_n_nodes"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*") ("GTraverseFlags"))
     :c-arg-names (root flags)
     :arguments ((* GNode) GTraverseFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:94 <818> 
;; GNode* g_node_get_root( GNode* node);
(ff:bind-c-function g_node_get_root
     :unconverted-entry-name "g_node_get_root"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:95 <819> 
;; gboolean g_node_is_ancestor( GNode* node, GNode* descendant);
(ff:bind-c-function g_node_is_ancestor
     :unconverted-entry-name "g_node_is_ancestor"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GNode" "*") ("GNode" "*"))
     :c-arg-names (node descendant)
     :arguments ((* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:97 <820> 
;; guint g_node_depth( GNode* node);
(ff:bind-c-function g_node_depth
     :unconverted-entry-name "g_node_depth"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:98 <821> 
;; GNode* g_node_find( GNode* root, GTraverseType order, GTraverseFlags
;;   flags,
;;              gpointer data);
(ff:bind-c-function g_node_find
     :unconverted-entry-name "g_node_find"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GTraverseType") ("GTraverseFlags")
                   ("gpointer"))
     :c-arg-names (root order flags data)
     :arguments ((* GNode) GTraverseType GTraverseFlags gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:120 <822> 
;; void g_node_traverse( GNode* root, GTraverseType order, GTraverseFlags
;;    flags, gint max_depth, GNodeTraverseFunc func, gpointer data);
(ff:bind-c-function g_node_traverse
     :unconverted-entry-name "g_node_traverse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*") ("GTraverseType") ("GTraverseFlags")
                   ("gint") ("GNodeTraverseFunc") ("gpointer"))
     :c-arg-names (root order flags max_depth func data)
     :arguments ((* GNode) GTraverseType GTraverseFlags gint
                 GNodeTraverseFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:132 <823> 
;; guint g_node_max_height( GNode* root);
(ff:bind-c-function g_node_max_height
     :unconverted-entry-name "g_node_max_height"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*"))
     :c-arg-names (root)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:134 <824> 
;; void g_node_children_foreach( GNode* node, GTraverseFlags flags,
;;   GNodeForeachFunc
;;    func, gpointer data);
(ff:bind-c-function g_node_children_foreach
     :unconverted-entry-name "g_node_children_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*") ("GTraverseFlags")
                   ("GNodeForeachFunc") ("gpointer"))
     :c-arg-names (node flags func data)
     :arguments ((* GNode) GTraverseFlags GNodeForeachFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:138 <825> 
;; void g_node_reverse_children( GNode* node);
(ff:bind-c-function g_node_reverse_children
     :unconverted-entry-name "g_node_reverse_children"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:139 <826> 
;; guint g_node_n_children( GNode* node);
(ff:bind-c-function g_node_n_children
     :unconverted-entry-name "g_node_n_children"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:140 <827> 
;; GNode* g_node_nth_child( GNode* node, guint n);
(ff:bind-c-function g_node_nth_child
     :unconverted-entry-name "g_node_nth_child"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("guint"))
     :c-arg-names (node n)
     :arguments ((* GNode) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:142 <828> 
;; GNode* g_node_last_child( GNode* node);
(ff:bind-c-function g_node_last_child
     :unconverted-entry-name "g_node_last_child"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:143 <829> 
;; GNode* g_node_find_child( GNode* node, GTraverseFlags flags, gpointer
;;    data);
(ff:bind-c-function g_node_find_child
     :unconverted-entry-name "g_node_find_child"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GTraverseFlags") ("gpointer"))
     :c-arg-names (node flags data)
     :arguments ((* GNode) GTraverseFlags gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:146 <830> 
;; gint g_node_child_position( GNode* node, GNode* child);
(ff:bind-c-function g_node_child_position
     :unconverted-entry-name "g_node_child_position"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GNode" "*") ("GNode" "*"))
     :c-arg-names (node child)
     :arguments ((* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:148 <831> 
;; gint g_node_child_index( GNode* node, gpointer data);
(ff:bind-c-function g_node_child_index
     :unconverted-entry-name "g_node_child_index"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GNode" "*") ("gpointer"))
     :c-arg-names (node data)
     :arguments ((* GNode) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:151 <832> 
;; GNode* g_node_first_sibling( GNode* node);
(ff:bind-c-function g_node_first_sibling
     :unconverted-entry-name "g_node_first_sibling"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gnode.h:152 <833> 
;; GNode* g_node_last_sibling( GNode* node);
(ff:bind-c-function g_node_last_sibling
     :unconverted-entry-name "g_node_last_sibling"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gpattern.h:27 <834> 
;; typedef struct _GPatternSpec GPatternSpec;
(ff:bind-c-typedef _GPatternSpec
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GPatternSpec _GPatternSpec)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gpattern.h:29 <835> 
;; GPatternSpec* g_pattern_spec_new( const gchar* pattern);
(ff:bind-c-function g_pattern_spec_new
     :unconverted-entry-name "g_pattern_spec_new"
     :c-return-type ("GPatternSpec" "*")
     :return-type (* GPatternSpec)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (pattern)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gpattern.h:30 <836> 
;; void g_pattern_spec_free( GPatternSpec* pspec);
(ff:bind-c-function g_pattern_spec_free
     :unconverted-entry-name "g_pattern_spec_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPatternSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GPatternSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gpattern.h:31 <837> 
;; gboolean g_pattern_spec_equal( GPatternSpec* pspec1, GPatternSpec*
;;   pspec2
;;   );
(ff:bind-c-function g_pattern_spec_equal
     :unconverted-entry-name "g_pattern_spec_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GPatternSpec" "*") ("GPatternSpec" "*"))
     :c-arg-names (pspec1 pspec2)
     :arguments ((* GPatternSpec) (* GPatternSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gpattern.h:33 <838> 
;; gboolean g_pattern_match( GPatternSpec* pspec, guint string_length,
;;   const
;;    gchar* string, const gchar* string_reversed);
(ff:bind-c-function g_pattern_match
     :unconverted-entry-name "g_pattern_match"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GPatternSpec" "*") ("guint") ("const" "gchar" "*")
                   ("const" "gchar" "*"))
     :c-arg-names (pspec string_length string string_reversed)
     :arguments ((* GPatternSpec) guint (* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gpattern.h:37 <839> 
;; gboolean g_pattern_match_string( GPatternSpec* pspec, const gchar*
;;   string
;;   );
(ff:bind-c-function g_pattern_match_string
     :unconverted-entry-name "g_pattern_match_string"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GPatternSpec" "*") ("const" "gchar" "*"))
     :c-arg-names (pspec string)
     :arguments ((* GPatternSpec) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gpattern.h:39 <840> 
;; gboolean g_pattern_match_simple( const gchar* pattern, const gchar*
;;   string
;;   );
(ff:bind-c-function g_pattern_match_simple
     :unconverted-entry-name "g_pattern_match_simple"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (pattern string)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gprimes.h:43 <841> 
;; guint g_spaced_primes_closest( guint num);
(ff:bind-c-function g_spaced_primes_closest
     :unconverted-entry-name "g_spaced_primes_closest"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint"))
     :c-arg-names (num)
     :arguments (guint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqsort.h:35 <842> 
;; void g_qsort_with_data( gconstpointer pbase, gint total_elems, size_t
;;    size, GCompareDataFunc compare_func, gpointer user_data);
(ff:bind-c-function g_qsort_with_data
     :unconverted-entry-name "g_qsort_with_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer") ("gint") ("size_t")
                   ("GCompareDataFunc") ("gpointer"))
     :c-arg-names (pbase total_elems size compare_func user_data)
     :arguments (gconstpointer gint size_t GCompareDataFunc gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:34 <843> 
;; typedef struct _GQueue GQueue;
(ff:bind-c-typedef _GQueue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GQueue _GQueue)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:36 <844> 
;; struct _GQueue { GList* head; GList* tail; guint length; };
(ff:bind-c-type _GQueue (:struct
  (head (* GList))   ;; GList* head
  (tail (* GList))   ;; GList* tail
  (length guint)   ;; guint length
  ))   ;; bind-c-type _GQueue
(ff:bind-c-typedef GQueue _GQueue) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:45 <845> 
;; GQueue* g_queue_new( void);
(ff:bind-c-function g_queue_new
     :unconverted-entry-name "g_queue_new"
     :c-return-type ("GQueue" "*")
     :return-type (* GQueue)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:46 <846> 
;; void g_queue_free( GQueue* queue);
(ff:bind-c-function g_queue_free
     :unconverted-entry-name "g_queue_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:47 <847> 
;; void g_queue_push_head( GQueue* queue, gpointer data);
(ff:bind-c-function g_queue_push_head
     :unconverted-entry-name "g_queue_push_head"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GQueue" "*") ("gpointer"))
     :c-arg-names (queue data)
     :arguments ((* GQueue) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:49 <848> 
;; void g_queue_push_tail( GQueue* queue, gpointer data);
(ff:bind-c-function g_queue_push_tail
     :unconverted-entry-name "g_queue_push_tail"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GQueue" "*") ("gpointer"))
     :c-arg-names (queue data)
     :arguments ((* GQueue) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:51 <849> 
;; gpointer g_queue_pop_head( GQueue* queue);
(ff:bind-c-function g_queue_pop_head
     :unconverted-entry-name "g_queue_pop_head"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:52 <850> 
;; gpointer g_queue_pop_tail( GQueue* queue);
(ff:bind-c-function g_queue_pop_tail
     :unconverted-entry-name "g_queue_pop_tail"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:53 <851> 
;; gboolean g_queue_is_empty( GQueue* queue);
(ff:bind-c-function g_queue_is_empty
     :unconverted-entry-name "g_queue_is_empty"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:54 <852> 
;; gpointer g_queue_peek_head( GQueue* queue);
(ff:bind-c-function g_queue_peek_head
     :unconverted-entry-name "g_queue_peek_head"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:55 <853> 
;; gpointer g_queue_peek_tail( GQueue* queue);
(ff:bind-c-function g_queue_peek_tail
     :unconverted-entry-name "g_queue_peek_tail"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:56 <854> 
;; void g_queue_push_head_link( GQueue* queue, GList* link);
(ff:bind-c-function g_queue_push_head_link
     :unconverted-entry-name "g_queue_push_head_link"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GQueue" "*") ("GList" "*"))
     :c-arg-names (queue link)
     :arguments ((* GQueue) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:58 <855> 
;; void g_queue_push_tail_link( GQueue* queue, GList* link);
(ff:bind-c-function g_queue_push_tail_link
     :unconverted-entry-name "g_queue_push_tail_link"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GQueue" "*") ("GList" "*"))
     :c-arg-names (queue link)
     :arguments ((* GQueue) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:60 <856> 
;; GList* g_queue_pop_head_link( GQueue* queue);
(ff:bind-c-function g_queue_pop_head_link
     :unconverted-entry-name "g_queue_pop_head_link"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gqueue.h:61 <857> 
;; GList* g_queue_pop_tail_link( GQueue* queue);
(ff:bind-c-function g_queue_pop_tail_link
     :unconverted-entry-name "g_queue_pop_tail_link"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GQueue" "*"))
     :c-arg-names (queue)
     :arguments ((* GQueue))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:34 <858> 
;; typedef struct _GRand GRand;
(ff:bind-c-typedef _GRand
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GRand _GRand)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:45 <859> 
;; GRand* g_rand_new_with_seed( guint32 seed);
(ff:bind-c-function g_rand_new_with_seed
     :unconverted-entry-name "g_rand_new_with_seed"
     :c-return-type ("GRand" "*")
     :return-type (* GRand)
     :c-arg-types (("guint32"))
     :c-arg-names (seed)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:46 <860> 
;; GRand* g_rand_new( void);
(ff:bind-c-function g_rand_new
     :unconverted-entry-name "g_rand_new"
     :c-return-type ("GRand" "*")
     :return-type (* GRand)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:47 <861> 
;; void g_rand_free( GRand* rand);
(ff:bind-c-function g_rand_free
     :unconverted-entry-name "g_rand_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRand" "*"))
     :c-arg-names (rand)
     :arguments ((* GRand))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:49 <862> 
;; void g_rand_set_seed( GRand* rand, guint32 seed);
(ff:bind-c-function g_rand_set_seed
     :unconverted-entry-name "g_rand_set_seed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRand" "*") ("guint32"))
     :c-arg-names (rand seed)
     :arguments ((* GRand) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:54 <863> 
;; guint32 g_rand_int( GRand* rand);
(ff:bind-c-function g_rand_int
     :unconverted-entry-name "g_rand_int"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types (("GRand" "*"))
     :c-arg-names (rand)
     :arguments ((* GRand))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:55 <864> 
;; gint32 g_rand_int_range( GRand* rand, gint32 begin, gint32 end);
(ff:bind-c-function g_rand_int_range
     :unconverted-entry-name "g_rand_int_range"
     :c-return-type ("gint32")
     :return-type gint32
     :c-arg-types (("GRand" "*") ("gint32") ("gint32"))
     :c-arg-names (rand begin end)
     :arguments ((* GRand) gint32 gint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:58 <865> 
;; gdouble g_rand_double( GRand* rand);
(ff:bind-c-function g_rand_double
     :unconverted-entry-name "g_rand_double"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("GRand" "*"))
     :c-arg-names (rand)
     :arguments ((* GRand))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:59 <866> 
;; gdouble g_rand_double_range( GRand* rand, gdouble begin, gdouble end);
(ff:bind-c-function g_rand_double_range
     :unconverted-entry-name "g_rand_double_range"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("GRand" "*") ("gdouble") ("gdouble"))
     :c-arg-names (rand begin end)
     :arguments ((* GRand) gdouble gdouble)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:63 <867> 
;; void g_random_set_seed( guint32 seed);
(ff:bind-c-function g_random_set_seed
     :unconverted-entry-name "g_random_set_seed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32"))
     :c-arg-names (seed)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:67 <868> 
;; guint32 g_random_int( void);
(ff:bind-c-function g_random_int
     :unconverted-entry-name "g_random_int"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:68 <869> 
;; gint32 g_random_int_range( gint32 begin, gint32 end);
(ff:bind-c-function g_random_int_range
     :unconverted-entry-name "g_random_int_range"
     :c-return-type ("gint32")
     :return-type gint32
     :c-arg-types (("gint32") ("gint32"))
     :c-arg-names (begin end)
     :arguments (gint32 gint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:70 <870> 
;; gdouble g_random_double( void);
(ff:bind-c-function g_random_double
     :unconverted-entry-name "g_random_double"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grand.h:71 <871> 
;; gdouble g_random_double_range( gdouble begin, gdouble end);
(ff:bind-c-function g_random_double_range
     :unconverted-entry-name "g_random_double_range"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("gdouble") ("gdouble"))
     :c-arg-names (begin end)
     :arguments (gdouble gdouble)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:34 <872> 
;; typedef struct _GRelation GRelation;
(ff:bind-c-typedef _GRelation
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GRelation _GRelation)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:35 <873> 
;; typedef struct _GTuples GTuples;
(ff:bind-c-typedef _GTuples
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTuples _GTuples)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:37 <874> 
;; struct _GTuples { guint len; };
(ff:bind-c-type _GTuples (:struct
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GTuples
(ff:bind-c-typedef GTuples _GTuples) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:65 <875> 
;; GRelation* g_relation_new( gint fields);
(ff:bind-c-function g_relation_new
     :unconverted-entry-name "g_relation_new"
     :c-return-type ("GRelation" "*")
     :return-type (* GRelation)
     :c-arg-types (("gint"))
     :c-arg-names (fields)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:66 <876> 
;; void g_relation_destroy( GRelation* relation);
(ff:bind-c-function g_relation_destroy
     :unconverted-entry-name "g_relation_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*"))
     :c-arg-names (relation)
     :arguments ((* GRelation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:67 <877> 
;; void g_relation_index( GRelation* relation, gint field, GHashFunc
;;   hash_func,
;;              GEqualFunc key_equal_func);
(ff:bind-c-function g_relation_index
     :unconverted-entry-name "g_relation_index"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*") ("gint") ("GHashFunc")
                   ("GEqualFunc"))
     :c-arg-names (relation field hash_func key_equal_func)
     :arguments ((* GRelation) gint GHashFunc GEqualFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:71 <878> 
;; void g_relation_insert( GRelation* relation, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_relation_insert
     :unconverted-entry-name "g_relation_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*") "...")
     :c-arg-names (relation)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:73 <879> 
;; gint g_relation_delete( GRelation* relation, gconstpointer key, gint
;;   field
;;   );
(ff:bind-c-function g_relation_delete
     :unconverted-entry-name "g_relation_delete"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GRelation" "*") ("gconstpointer") ("gint"))
     :c-arg-names (relation key field)
     :arguments ((* GRelation) gconstpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:76 <880> 
;; GTuples* g_relation_select( GRelation* relation, gconstpointer key, gint
;;    field);
(ff:bind-c-function g_relation_select
     :unconverted-entry-name "g_relation_select"
     :c-return-type ("GTuples" "*")
     :return-type (* GTuples)
     :c-arg-types (("GRelation" "*") ("gconstpointer") ("gint"))
     :c-arg-names (relation key field)
     :arguments ((* GRelation) gconstpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:79 <881> 
;; gint g_relation_count( GRelation* relation, gconstpointer key, gint
;;   field
;;   );
(ff:bind-c-function g_relation_count
     :unconverted-entry-name "g_relation_count"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GRelation" "*") ("gconstpointer") ("gint"))
     :c-arg-names (relation key field)
     :arguments ((* GRelation) gconstpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:82 <882> 
;; gboolean g_relation_exists( GRelation* relation, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_relation_exists
     :unconverted-entry-name "g_relation_exists"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GRelation" "*") "...")
     :c-arg-names (relation)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:84 <883> 
;; void g_relation_print( GRelation* relation);
(ff:bind-c-function g_relation_print
     :unconverted-entry-name "g_relation_print"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*"))
     :c-arg-names (relation)
     :arguments ((* GRelation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:86 <884> 
;; void g_tuples_destroy( GTuples* tuples);
(ff:bind-c-function g_tuples_destroy
     :unconverted-entry-name "g_tuples_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTuples" "*"))
     :c-arg-names (tuples)
     :arguments ((* GTuples))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/grel.h:87 <885> 
;; gpointer g_tuples_index( GTuples* tuples, gint index, gint field);
(ff:bind-c-function g_tuples_index
     :unconverted-entry-name "g_tuples_index"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GTuples" "*") ("gint") ("gint"))
     :c-arg-names (tuples index field)
     :arguments ((* GTuples) gint gint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:34 <886> 
;; typedef struct _GScanner GScanner;
(ff:bind-c-typedef _GScanner
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GScanner _GScanner)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:35 <887> 
;; typedef struct _GScannerConfig GScannerConfig;
(ff:bind-c-typedef _GScannerConfig
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GScannerConfig _GScannerConfig)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:36 <888> 
;; typedef union _GTokenValue GTokenValue;
(ff:bind-c-typedef _GTokenValue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTokenValue _GTokenValue)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:38 <889> 
;; typedef void(* GScannerMsgFunc)( GScanner* scanner, gchar* message,
;;   gboolean
;;    error);
(ff:bind-c-type GScannerMsgFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:59 <890> 
;; typedef enum {
;;         G_ERR_UNKNOWN, G_ERR_UNEXP_EOF, G_ERR_UNEXP_EOF_IN_STRING,
;;   G_ERR_UNEXP_EOF_IN_COMMENT,
;;              G_ERR_NON_DIGIT_IN_CONST, G_ERR_DIGIT_RADIX,
;;   G_ERR_FLOAT_RADIX, G_ERR_FLOAT_MALFORMED
;;    } GErrorType;
(ff:bind-c-constant G_ERR_UNKNOWN 0) ;;  G_ERR_UNKNOWN 
(ff:bind-c-constant G_ERR_UNEXP_EOF 1) ;;  G_ERR_UNEXP_EOF 
(ff:bind-c-constant G_ERR_UNEXP_EOF_IN_STRING
                    2) ;;
;;   G_ERR_UNEXP_EOF_IN_STRING 
(ff:bind-c-constant G_ERR_UNEXP_EOF_IN_COMMENT
                    3) ;;
;;   G_ERR_UNEXP_EOF_IN_COMMENT 
(ff:bind-c-constant G_ERR_NON_DIGIT_IN_CONST
                    4) ;;
;;   G_ERR_NON_DIGIT_IN_CONST 
(ff:bind-c-constant G_ERR_DIGIT_RADIX 5) ;;  G_ERR_DIGIT_RADIX 
(ff:bind-c-constant G_ERR_FLOAT_RADIX 6) ;;  G_ERR_FLOAT_RADIX 
(ff:bind-c-constant G_ERR_FLOAT_MALFORMED 7) ;;  G_ERR_FLOAT_MALFORMED 
(ff:bind-c-type GErrorType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:72 <891> 
;; typedef enum {
;;         G_TOKEN_EOF =  0x000000000, G_TOKEN_LEFT_PAREN =  0x000000028,
;;   G_TOKEN_RIGHT_PAREN
;;    =  0x000000029, G_TOKEN_LEFT_CURLY =  0x00000007b,
;;   G_TOKEN_RIGHT_CURLY
;;    =  0x00000007d, G_TOKEN_LEFT_BRACE =  0x00000005b,
;;   G_TOKEN_RIGHT_BRACE
;;    =  0x00000005d, G_TOKEN_EQUAL_SIGN =  0x00000003d, G_TOKEN_COMMA =
;;   0x00000002c,
;;              G_TOKEN_NONE =  0x000000100, G_TOKEN_ERROR, G_TOKEN_CHAR,
;;   G_TOKEN_BINARY,
;;              G_TOKEN_OCTAL, G_TOKEN_INT, G_TOKEN_HEX, G_TOKEN_FLOAT,
;;   G_TOKEN_STRING,
;;              G_TOKEN_SYMBOL, G_TOKEN_IDENTIFIER,
;;   G_TOKEN_IDENTIFIER_NULL, G_TOKEN_COMMENT_SINGLE,
;;              G_TOKEN_COMMENT_MULTI, G_TOKEN_LAST } GTokenType;
(ff:bind-c-constant G_TOKEN_EOF 0) ;;  G_TOKEN_EOF =  0x000000000 
(ff:bind-c-constant G_TOKEN_LEFT_PAREN
                    40) ;;
;;   G_TOKEN_LEFT_PAREN =  0x000000028 
(ff:bind-c-constant G_TOKEN_RIGHT_PAREN
                    41) ;;
;;   G_TOKEN_RIGHT_PAREN =  0x000000029 
(ff:bind-c-constant G_TOKEN_LEFT_CURLY
                    123) ;;
;;   G_TOKEN_LEFT_CURLY =  0x00000007b 
(ff:bind-c-constant G_TOKEN_RIGHT_CURLY
                    125) ;;
;;   G_TOKEN_RIGHT_CURLY =  0x00000007d 
(ff:bind-c-constant G_TOKEN_LEFT_BRACE
                    91) ;;
;;   G_TOKEN_LEFT_BRACE =  0x00000005b 
(ff:bind-c-constant G_TOKEN_RIGHT_BRACE
                    93) ;;
;;   G_TOKEN_RIGHT_BRACE =  0x00000005d 
(ff:bind-c-constant G_TOKEN_EQUAL_SIGN
                    61) ;;
;;   G_TOKEN_EQUAL_SIGN =  0x00000003d 
(ff:bind-c-constant G_TOKEN_COMMA 44) ;;  G_TOKEN_COMMA =  0x00000002c 
(ff:bind-c-constant G_TOKEN_NONE 256) ;;  G_TOKEN_NONE =  0x000000100 
(ff:bind-c-constant G_TOKEN_ERROR 0) ;;  G_TOKEN_ERROR 
(ff:bind-c-constant G_TOKEN_CHAR 1) ;;  G_TOKEN_CHAR 
(ff:bind-c-constant G_TOKEN_BINARY 2) ;;  G_TOKEN_BINARY 
(ff:bind-c-constant G_TOKEN_OCTAL 3) ;;  G_TOKEN_OCTAL 
(ff:bind-c-constant G_TOKEN_INT 4) ;;  G_TOKEN_INT 
(ff:bind-c-constant G_TOKEN_HEX 5) ;;  G_TOKEN_HEX 
(ff:bind-c-constant G_TOKEN_FLOAT 6) ;;  G_TOKEN_FLOAT 
(ff:bind-c-constant G_TOKEN_STRING 7) ;;  G_TOKEN_STRING 
(ff:bind-c-constant G_TOKEN_SYMBOL 8) ;;  G_TOKEN_SYMBOL 
(ff:bind-c-constant G_TOKEN_IDENTIFIER 9) ;;  G_TOKEN_IDENTIFIER 
(ff:bind-c-constant G_TOKEN_IDENTIFIER_NULL
                    10) ;;
;;   G_TOKEN_IDENTIFIER_NULL 
(ff:bind-c-constant G_TOKEN_COMMENT_SINGLE
                    11) ;;
;;   G_TOKEN_COMMENT_SINGLE 
(ff:bind-c-constant G_TOKEN_COMMENT_MULTI 12) ;;  G_TOKEN_COMMENT_MULTI 
(ff:bind-c-constant G_TOKEN_LAST 13) ;;  G_TOKEN_LAST 
(ff:bind-c-type GTokenType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:106 <892> 
;; union _GTokenValue {
;;         gpointer v_symbol; gchar* v_identifier; gulong v_binary; gulong
;;   v_octal;
;;              gulong v_int; gdouble v_float; gulong v_hex; gchar*
;;   v_string; gchar* v_comment;
;;              guchar v_char; guint v_error; };
(ff:bind-c-type _GTokenValue (:union
  (v_symbol gpointer)   ;; gpointer v_symbol
  (v_identifier (* gchar))   ;; gchar* v_identifier
  (v_binary gulong)   ;; gulong v_binary
  (v_octal gulong)   ;; gulong v_octal
  (v_int gulong)   ;; gulong v_int
  (v_float gdouble)   ;; gdouble v_float
  (v_hex gulong)   ;; gulong v_hex
  (v_string (* gchar))   ;; gchar* v_string
  (v_comment (* gchar))   ;; gchar* v_comment
  (v_char guchar)   ;; guchar v_char
  (v_error guint)   ;; guint v_error
  ))   ;; bind-c-type _GTokenValue
(ff:bind-c-typedef GTokenValue _GTokenValue) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:121 <893> 
;; struct _GScannerConfig {
;;         gchar* cset_skip_characters; gchar* cset_identifier_first;
;;   gchar* cset_identifier_nth;
;;              gchar* cpair_comment_single; guint case_sensitive:
;;   0x000000001; guint
;;    skip_comment_multi:  0x000000001; guint skip_comment_single:
;;   0x000000001;
;;              guint scan_comment_multi:  0x000000001; guint
;;   scan_identifier:  0x000000001;
;;              guint scan_identifier_1char:  0x000000001; guint
;;   scan_identifier_NULL
;;   :  0x000000001; guint scan_symbols:  0x000000001; guint scan_binary:
;;   0x000000001;
;;              guint scan_octal:  0x000000001; guint scan_float:
;;   0x000000001; guint
;;    scan_hex:  0x000000001; guint scan_hex_dollar:  0x000000001; guint
;;   scan_string_sq
;;   :  0x000000001; guint scan_string_dq:  0x000000001; guint
;;   numbers_2_int
;;   :  0x000000001; guint int_2_float:  0x000000001; guint
;;   identifier_2_string
;;   :  0x000000001; guint char_2_token:  0x000000001; guint symbol_2_token
;;   :  0x000000001; guint scope_0_fallback:  0x000000001; guint
;;   padding_dummy;
;;    };

;;WARNING: Strange bitfield case_sensitive type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield skip_comment_multi type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield skip_comment_single type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_comment_multi type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_identifier type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_identifier_1char type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_identifier_NULL type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_symbols type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_binary type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_octal type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_float type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_hex type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_hex_dollar type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_string_sq type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_string_dq type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield numbers_2_int type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield int_2_float type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield identifier_2_string type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield char_2_token type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield symbol_2_token type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scope_0_fallback type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GScannerConfig (:struct
  (cset_skip_characters (* gchar))   ;; gchar* cset_skip_characters
  (cset_identifier_first (* gchar))   ;; gchar* cset_identifier_first
  (cset_identifier_nth (* gchar))   ;; gchar* cset_identifier_nth
  (cpair_comment_single (* gchar))   ;; gchar* cpair_comment_single
  (case_sensitive (:bit 1))   ;; guint case_sensitive:  0x000000001
  (skip_comment_multi (:bit
                       1))   ;;
  ;;  guint skip_comment_multi:  0x000000001
  (skip_comment_single (:bit
                        1))   ;;
  ;;  guint skip_comment_single:  0x000000001
  (scan_comment_multi (:bit
                       1))   ;;
  ;;  guint scan_comment_multi:  0x000000001
  (scan_identifier (:bit 1))   ;; guint scan_identifier:  0x000000001
  (scan_identifier_1char (:bit
                          1))   ;;
  ;;  guint scan_identifier_1char:  0x000000001
  (scan_identifier_NULL (:bit
                         1))   ;;
  ;;  guint scan_identifier_NULL:  0x000000001
  (scan_symbols (:bit 1))   ;; guint scan_symbols:  0x000000001
  (scan_binary (:bit 1))   ;; guint scan_binary:  0x000000001
  (scan_octal (:bit 1))   ;; guint scan_octal:  0x000000001
  (scan_float (:bit 1))   ;; guint scan_float:  0x000000001
  (scan_hex (:bit 1))   ;; guint scan_hex:  0x000000001
  (scan_hex_dollar (:bit 1))   ;; guint scan_hex_dollar:  0x000000001
  (scan_string_sq (:bit 1))   ;; guint scan_string_sq:  0x000000001
  (scan_string_dq (:bit 1))   ;; guint scan_string_dq:  0x000000001
  (numbers_2_int (:bit 1))   ;; guint numbers_2_int:  0x000000001
  (int_2_float (:bit 1))   ;; guint int_2_float:  0x000000001
  (identifier_2_string (:bit
                        1))   ;;
  ;;  guint identifier_2_string:  0x000000001
  (char_2_token (:bit 1))   ;; guint char_2_token:  0x000000001
  (symbol_2_token (:bit 1))   ;; guint symbol_2_token:  0x000000001
  (scope_0_fallback (:bit 1))   ;; guint scope_0_fallback:  0x000000001
  (padding_dummy guint)   ;; guint padding_dummy
  ))   ;; bind-c-type _GScannerConfig
(ff:bind-c-typedef GScannerConfig
                   _GScannerConfig) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:160 <894> 
;; struct _GScanner {
;;         gpointer user_data; guint max_parse_errors; guint parse_errors;
;;   const
;;    gchar* input_name; GData* qdata; GScannerConfig* config; GTokenType
;;   token;
;;              GTokenValue value; guint line; guint position; GTokenType
;;   next_token;
;;              GTokenValue next_value; guint next_line; guint
;;   next_position; GHashTable
;;   * symbol_table; gint input_fd; const gchar* text; const gchar*
;;   text_end;
;;              gchar* buffer; guint scope_id; GScannerMsgFunc msg_handler;
;;   };
(ff:bind-c-type _GScanner (:struct
  (user_data gpointer)   ;; gpointer user_data
  (max_parse_errors guint)   ;; guint max_parse_errors
  (parse_errors guint)   ;; guint parse_errors
  (input_name (* gchar))   ;; const gchar* input_name
  (qdata (* GData))   ;; GData* qdata
  (config (* GScannerConfig))   ;; GScannerConfig* config
  (token GTokenType)   ;; GTokenType token
  (value GTokenValue)   ;; GTokenValue value
  (line guint)   ;; guint line
  (position guint)   ;; guint position
  (next_token GTokenType)   ;; GTokenType next_token
  (next_value GTokenValue)   ;; GTokenValue next_value
  (next_line guint)   ;; guint next_line
  (next_position guint)   ;; guint next_position
  (symbol_table (* GHashTable))   ;; GHashTable* symbol_table
  (input_fd gint)   ;; gint input_fd
  (text (* gchar))   ;; const gchar* text
  (text_end (* gchar))   ;; const gchar* text_end
  (buffer (* gchar))   ;; gchar* buffer
  (scope_id guint)   ;; guint scope_id
  (msg_handler GScannerMsgFunc)   ;; GScannerMsgFunc msg_handler
  ))   ;; bind-c-type _GScanner
(ff:bind-c-typedef GScanner _GScanner) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:202 <895> 
;; GScanner* g_scanner_new( const GScannerConfig* config_templ);
(ff:bind-c-function g_scanner_new
     :unconverted-entry-name "g_scanner_new"
     :c-return-type ("GScanner" "*")
     :return-type (* GScanner)
     :c-arg-types (("const" "GScannerConfig" "*"))
     :c-arg-names (config_templ)
     :arguments ((* GScannerConfig))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:203 <896> 
;; void g_scanner_destroy( GScanner* scanner);
(ff:bind-c-function g_scanner_destroy
     :unconverted-entry-name "g_scanner_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:204 <897> 
;; void g_scanner_input_file( GScanner* scanner, gint input_fd);
(ff:bind-c-function g_scanner_input_file
     :unconverted-entry-name "g_scanner_input_file"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("gint"))
     :c-arg-names (scanner input_fd)
     :arguments ((* GScanner) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:206 <898> 
;; void g_scanner_sync_file_offset( GScanner* scanner);
(ff:bind-c-function g_scanner_sync_file_offset
     :unconverted-entry-name "g_scanner_sync_file_offset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:207 <899> 
;; void g_scanner_input_text( GScanner* scanner, const gchar* text, guint
;;    text_len);
(ff:bind-c-function g_scanner_input_text
     :unconverted-entry-name "g_scanner_input_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*") ("guint"))
     :c-arg-names (scanner text text_len)
     :arguments ((* GScanner) (* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:210 <900> 
;; GTokenType g_scanner_get_next_token( GScanner* scanner);
(ff:bind-c-function g_scanner_get_next_token
     :unconverted-entry-name "g_scanner_get_next_token"
     :c-return-type ("GTokenType")
     :return-type GTokenType
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:211 <901> 
;; GTokenType g_scanner_peek_next_token( GScanner* scanner);
(ff:bind-c-function g_scanner_peek_next_token
     :unconverted-entry-name "g_scanner_peek_next_token"
     :c-return-type ("GTokenType")
     :return-type GTokenType
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:212 <902> 
;; GTokenType g_scanner_cur_token( GScanner* scanner);
(ff:bind-c-function g_scanner_cur_token
     :unconverted-entry-name "g_scanner_cur_token"
     :c-return-type ("GTokenType")
     :return-type GTokenType
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:213 <903> 
;; GTokenValue g_scanner_cur_value( GScanner* scanner);

;;NOTE: C wrapper needed to return structure or union type
;;   GTokenValue.
(ff:bind-c-function g_scanner_cur_value
     :unconverted-entry-name "ACL_g_scanner_cur_value"
     :c-return-type ("GTokenValue" "*")
     :return-type (* GTokenValue)
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:214 <904> 
;; guint g_scanner_cur_line( GScanner* scanner);
(ff:bind-c-function g_scanner_cur_line
     :unconverted-entry-name "g_scanner_cur_line"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:215 <905> 
;; guint g_scanner_cur_position( GScanner* scanner);
(ff:bind-c-function g_scanner_cur_position
     :unconverted-entry-name "g_scanner_cur_position"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:216 <906> 
;; gboolean g_scanner_eof( GScanner* scanner);
(ff:bind-c-function g_scanner_eof
     :unconverted-entry-name "g_scanner_eof"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:217 <907> 
;; guint g_scanner_set_scope( GScanner* scanner, guint scope_id);
(ff:bind-c-function g_scanner_set_scope
     :unconverted-entry-name "g_scanner_set_scope"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GScanner" "*") ("guint"))
     :c-arg-names (scanner scope_id)
     :arguments ((* GScanner) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:219 <908> 
;; void g_scanner_scope_add_symbol( GScanner* scanner, guint scope_id,
;;   const
;;    gchar* symbol, gpointer value);
(ff:bind-c-function g_scanner_scope_add_symbol
     :unconverted-entry-name "g_scanner_scope_add_symbol"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("guint") ("const" "gchar" "*")
                   ("gpointer"))
     :c-arg-names (scanner scope_id symbol value)
     :arguments ((* GScanner) guint (* gchar) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:223 <909> 
;; void g_scanner_scope_remove_symbol( GScanner* scanner, guint scope_id,
;;              const gchar* symbol);
(ff:bind-c-function g_scanner_scope_remove_symbol
     :unconverted-entry-name "g_scanner_scope_remove_symbol"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("guint") ("const" "gchar" "*"))
     :c-arg-names (scanner scope_id symbol)
     :arguments ((* GScanner) guint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:226 <910> 
;; gpointer g_scanner_scope_lookup_symbol( GScanner* scanner, guint
;;   scope_id,
;;              const gchar* symbol);
(ff:bind-c-function g_scanner_scope_lookup_symbol
     :unconverted-entry-name "g_scanner_scope_lookup_symbol"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GScanner" "*") ("guint") ("const" "gchar" "*"))
     :c-arg-names (scanner scope_id symbol)
     :arguments ((* GScanner) guint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:229 <911> 
;; void g_scanner_scope_foreach_symbol( GScanner* scanner, guint scope_id,
;;              GHFunc func, gpointer user_data);
(ff:bind-c-function g_scanner_scope_foreach_symbol
     :unconverted-entry-name "g_scanner_scope_foreach_symbol"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("guint") ("GHFunc") ("gpointer"))
     :c-arg-names (scanner scope_id func user_data)
     :arguments ((* GScanner) guint GHFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:233 <912> 
;; gpointer g_scanner_lookup_symbol( GScanner* scanner, const gchar* symbol
;;   );
(ff:bind-c-function g_scanner_lookup_symbol
     :unconverted-entry-name "g_scanner_lookup_symbol"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*"))
     :c-arg-names (scanner symbol)
     :arguments ((* GScanner) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:235 <913> 
;; void g_scanner_unexp_token( GScanner* scanner, GTokenType
;;   expected_token,
;;              const gchar* identifier_spec, const gchar* symbol_spec,
;;   const gchar* symbol_name,
;;              const gchar* message, gint is_error);
(ff:bind-c-function g_scanner_unexp_token
     :unconverted-entry-name "g_scanner_unexp_token"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("GTokenType")
                   ("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (scanner expected_token identifier_spec symbol_spec
                   symbol_name message is_error)
     :arguments ((* GScanner) GTokenType (* gchar) (* gchar) (* gchar)
                 (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:242 <914> 
;; void g_scanner_error( GScanner* scanner, const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_scanner_error
     :unconverted-entry-name "g_scanner_error"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*") "...")
     :c-arg-names (scanner format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gscanner.h:245 <915> 
;; void g_scanner_warn( GScanner* scanner, const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_scanner_warn
     :unconverted-entry-name "g_scanner_warn"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*") "...")
     :c-arg-names (scanner format)
     :arguments nil
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gshell.h:30 <916> 
;; typedef enum {
;;         G_SHELL_ERROR_BAD_QUOTING, G_SHELL_ERROR_EMPTY_STRING,
;;   G_SHELL_ERROR_FAILED
;;    } GShellError;
(ff:bind-c-constant G_SHELL_ERROR_BAD_QUOTING
                    0) ;;
;;   G_SHELL_ERROR_BAD_QUOTING 
(ff:bind-c-constant G_SHELL_ERROR_EMPTY_STRING
                    1) ;;
;;   G_SHELL_ERROR_EMPTY_STRING 
(ff:bind-c-constant G_SHELL_ERROR_FAILED 2) ;;  G_SHELL_ERROR_FAILED 
(ff:bind-c-type GShellError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gshell.h:39 <917> 
;; GQuark g_shell_error_quark( void);
(ff:bind-c-function g_shell_error_quark
     :unconverted-entry-name "g_shell_error_quark"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gshell.h:41 <918> 
;; gchar* g_shell_quote( const gchar* unquoted_string);
(ff:bind-c-function g_shell_quote
     :unconverted-entry-name "g_shell_quote"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (unquoted_string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gshell.h:42 <919> 
;; gchar* g_shell_unquote( const gchar* quoted_string, GError** error);
(ff:bind-c-function g_shell_unquote
     :unconverted-entry-name "g_shell_unquote"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("GError" "*" "*"))
     :c-arg-names (quoted_string error)
     :arguments ((* gchar) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gshell.h:44 <920> 
;; gboolean g_shell_parse_argv( const gchar* command_line, gint* argcp,
;;   gchar
;;   *** argvp, GError** error);
(ff:bind-c-function g_shell_parse_argv
     :unconverted-entry-name "g_shell_parse_argv"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("gint" "*")
                   ("gchar" "*" "*" "*") ("GError" "*" "*"))
     :c-arg-names (command_line argcp argvp error)
     :arguments ((* gchar) (* gint) (* (* (* gchar))) (* (* GError)))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:31 <921> 
;; typedef enum {
;;         G_SPAWN_ERROR_FORK, G_SPAWN_ERROR_READ, G_SPAWN_ERROR_CHDIR,
;;   G_SPAWN_ERROR_ACCES,
;;              G_SPAWN_ERROR_PERM, G_SPAWN_ERROR_2BIG,
;;   G_SPAWN_ERROR_NOEXEC, G_SPAWN_ERROR_NAMETOOLONG,
;;              G_SPAWN_ERROR_NOENT, G_SPAWN_ERROR_NOMEM,
;;   G_SPAWN_ERROR_NOTDIR, G_SPAWN_ERROR_LOOP,
;;              G_SPAWN_ERROR_TXTBUSY, G_SPAWN_ERROR_IO,
;;   G_SPAWN_ERROR_NFILE, G_SPAWN_ERROR_MFILE,
;;              G_SPAWN_ERROR_INVAL, G_SPAWN_ERROR_ISDIR,
;;   G_SPAWN_ERROR_LIBBAD, G_SPAWN_ERROR_FAILED
;;    } GSpawnError;
(ff:bind-c-constant G_SPAWN_ERROR_FORK 0) ;;  G_SPAWN_ERROR_FORK 
(ff:bind-c-constant G_SPAWN_ERROR_READ 1) ;;  G_SPAWN_ERROR_READ 
(ff:bind-c-constant G_SPAWN_ERROR_CHDIR 2) ;;  G_SPAWN_ERROR_CHDIR 
(ff:bind-c-constant G_SPAWN_ERROR_ACCES 3) ;;  G_SPAWN_ERROR_ACCES 
(ff:bind-c-constant G_SPAWN_ERROR_PERM 4) ;;  G_SPAWN_ERROR_PERM 
(ff:bind-c-constant G_SPAWN_ERROR_2BIG 5) ;;  G_SPAWN_ERROR_2BIG 
(ff:bind-c-constant G_SPAWN_ERROR_NOEXEC 6) ;;  G_SPAWN_ERROR_NOEXEC 
(ff:bind-c-constant G_SPAWN_ERROR_NAMETOOLONG
                    7) ;;
;;   G_SPAWN_ERROR_NAMETOOLONG 
(ff:bind-c-constant G_SPAWN_ERROR_NOENT 8) ;;  G_SPAWN_ERROR_NOENT 
(ff:bind-c-constant G_SPAWN_ERROR_NOMEM 9) ;;  G_SPAWN_ERROR_NOMEM 
(ff:bind-c-constant G_SPAWN_ERROR_NOTDIR 10) ;;  G_SPAWN_ERROR_NOTDIR 
(ff:bind-c-constant G_SPAWN_ERROR_LOOP 11) ;;  G_SPAWN_ERROR_LOOP 
(ff:bind-c-constant G_SPAWN_ERROR_TXTBUSY 12) ;;  G_SPAWN_ERROR_TXTBUSY 
(ff:bind-c-constant G_SPAWN_ERROR_IO 13) ;;  G_SPAWN_ERROR_IO 
(ff:bind-c-constant G_SPAWN_ERROR_NFILE 14) ;;  G_SPAWN_ERROR_NFILE 
(ff:bind-c-constant G_SPAWN_ERROR_MFILE 15) ;;  G_SPAWN_ERROR_MFILE 
(ff:bind-c-constant G_SPAWN_ERROR_INVAL 16) ;;  G_SPAWN_ERROR_INVAL 
(ff:bind-c-constant G_SPAWN_ERROR_ISDIR 17) ;;  G_SPAWN_ERROR_ISDIR 
(ff:bind-c-constant G_SPAWN_ERROR_LIBBAD 18) ;;  G_SPAWN_ERROR_LIBBAD 
(ff:bind-c-constant G_SPAWN_ERROR_FAILED 19) ;;  G_SPAWN_ERROR_FAILED 
(ff:bind-c-type GSpawnError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:57 <922> 
;; typedef void(* GSpawnChildSetupFunc)( gpointer user_data);
(ff:bind-c-type GSpawnChildSetupFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:59 <923> 
;; typedef enum {
;;         G_SPAWN_LEAVE_DESCRIPTORS_OPEN =  0x000000001 LSHIFT
;;   0x000000000, G_SPAWN_DO_NOT_REAP_CHILD
;;    =  0x000000001 LSHIFT  0x000000001, G_SPAWN_SEARCH_PATH =
;;   0x000000001
;;    LSHIFT  0x000000002, G_SPAWN_STDOUT_TO_DEV_NULL =  0x000000001 LSHIFT
;;     0x000000003, G_SPAWN_STDERR_TO_DEV_NULL =  0x000000001 LSHIFT
;;   0x000000004,
;;              G_SPAWN_CHILD_INHERITS_STDIN =  0x000000001 LSHIFT
;;   0x000000005, G_SPAWN_FILE_AND_ARGV_ZERO
;;    =  0x000000001 LSHIFT  0x000000006 } GSpawnFlags;
(ff:bind-c-constant G_SPAWN_LEAVE_DESCRIPTORS_OPEN
                    1) ;;
;;   G_SPAWN_LEAVE_DESCRIPTORS_OPEN =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_SPAWN_DO_NOT_REAP_CHILD
                    2) ;;
;;   G_SPAWN_DO_NOT_REAP_CHILD =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_SPAWN_SEARCH_PATH
                    4) ;;
;;   G_SPAWN_SEARCH_PATH =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_SPAWN_STDOUT_TO_DEV_NULL
                    8) ;;
;;   G_SPAWN_STDOUT_TO_DEV_NULL =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_SPAWN_STDERR_TO_DEV_NULL
                    16) ;;
;;   G_SPAWN_STDERR_TO_DEV_NULL =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_SPAWN_CHILD_INHERITS_STDIN
                    32) ;;
;;   G_SPAWN_CHILD_INHERITS_STDIN =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant G_SPAWN_FILE_AND_ARGV_ZERO
                    64) ;;
;;   G_SPAWN_FILE_AND_ARGV_ZERO =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-type GSpawnFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:72 <924> 
;; GQuark g_spawn_error_quark( void);
(ff:bind-c-function g_spawn_error_quark
     :unconverted-entry-name "g_spawn_error_quark"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:74 <925> 
;; gboolean g_spawn_async( const gchar* working_directory, gchar** argv,
;;              gchar** envp, GSpawnFlags flags, GSpawnChildSetupFunc
;;   child_setup, gpointer
;;    user_data, gint* child_pid, GError** error);
(ff:bind-c-function g_spawn_async
     :unconverted-entry-name "g_spawn_async"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*")
                   ("gchar" "*" "*") ("GSpawnFlags")
                   ("GSpawnChildSetupFunc") ("gpointer") ("gint" "*")
                   ("GError" "*" "*"))
     :c-arg-names (working_directory argv envp flags child_setup
                   user_data child_pid error)
     :arguments ((* gchar) (* (* gchar)) (* (* gchar)) GSpawnFlags
                 GSpawnChildSetupFunc gpointer (* gint) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:87 <926> 
;; gboolean g_spawn_async_with_pipes( const gchar* working_directory, gchar
;;   ** argv, gchar** envp, GSpawnFlags flags, GSpawnChildSetupFunc
;;   child_setup,
;;              gpointer user_data, gint* child_pid, gint* standard_input,
;;   gint* standard_output,
;;              gint* standard_error, GError** error);
(ff:bind-c-function g_spawn_async_with_pipes
     :unconverted-entry-name "g_spawn_async_with_pipes"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*")
                   ("gchar" "*" "*") ("GSpawnFlags")
                   ("GSpawnChildSetupFunc") ("gpointer") ("gint" "*")
                   ("gint" "*") ("gint" "*") ("gint" "*")
                   ("GError" "*" "*"))
     :c-arg-names (working_directory argv envp flags child_setup
                   user_data child_pid standard_input standard_output
                   standard_error error)
     :arguments ((* gchar) (* (* gchar)) (* (* gchar)) GSpawnFlags
                 GSpawnChildSetupFunc gpointer (* gint) (* gint)
                 (* gint) (* gint) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:104 <927> 
;; gboolean g_spawn_sync( const gchar* working_directory, gchar** argv,
;;   gchar
;;   ** envp, GSpawnFlags flags, GSpawnChildSetupFunc child_setup, gpointer
;;    user_data, gchar** standard_output, gchar** standard_error, gint*
;;   exit_status,
;;              GError** error);
(ff:bind-c-function g_spawn_sync
     :unconverted-entry-name "g_spawn_sync"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*")
                   ("gchar" "*" "*") ("GSpawnFlags")
                   ("GSpawnChildSetupFunc") ("gpointer")
                   ("gchar" "*" "*") ("gchar" "*" "*") ("gint" "*")
                   ("GError" "*" "*"))
     :c-arg-names (working_directory argv envp flags child_setup
                   user_data standard_output standard_error exit_status
                   error)
     :arguments ((* gchar) (* (* gchar)) (* (* gchar)) GSpawnFlags
                 GSpawnChildSetupFunc gpointer (* (* gchar))
                 (* (* gchar)) (* gint) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:115 <928> 
;; gboolean g_spawn_command_line_sync( const gchar* command_line, gchar*
;;   * standard_output, gchar** standard_error, gint* exit_status, GError**
;;    error);
(ff:bind-c-function g_spawn_command_line_sync
     :unconverted-entry-name "g_spawn_command_line_sync"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*")
                   ("gchar" "*" "*") ("gint" "*") ("GError" "*" "*"))
     :c-arg-names (command_line standard_output standard_error
                   exit_status error)
     :arguments ((* gchar) (* (* gchar)) (* (* gchar)) (* gint)
                 (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gspawn.h:120 <929> 
;; gboolean g_spawn_command_line_async( const gchar* command_line, GError
;;   ** error);
(ff:bind-c-function g_spawn_command_line_async
     :unconverted-entry-name "g_spawn_command_line_async"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("GError" "*" "*"))
     :c-arg-names (command_line error)
     :arguments ((* gchar) (* (* GError)))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:36 <930> 
;; typedef enum {
;;         G_ASCII_ALNUM =  0x000000001 LSHIFT  0x000000000, G_ASCII_ALPHA
;;   =  0x000000001
;;    LSHIFT  0x000000001, G_ASCII_CNTRL =  0x000000001 LSHIFT
;;   0x000000002,
;;              G_ASCII_DIGIT =  0x000000001 LSHIFT  0x000000003,
;;   G_ASCII_GRAPH =  0x000000001
;;    LSHIFT  0x000000004, G_ASCII_LOWER =  0x000000001 LSHIFT
;;   0x000000005,
;;              G_ASCII_PRINT =  0x000000001 LSHIFT  0x000000006,
;;   G_ASCII_PUNCT =  0x000000001
;;    LSHIFT  0x000000007, G_ASCII_SPACE =  0x000000001 LSHIFT
;;   0x000000008,
;;              G_ASCII_UPPER =  0x000000001 LSHIFT  0x000000009,
;;   G_ASCII_XDIGIT =  0x000000001
;;    LSHIFT  0x00000000a } GAsciiType;
(ff:bind-c-constant G_ASCII_ALNUM
                    1) ;;
;;   G_ASCII_ALNUM =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_ASCII_ALPHA
                    2) ;;
;;   G_ASCII_ALPHA =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_ASCII_CNTRL
                    4) ;;
;;   G_ASCII_CNTRL =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_ASCII_DIGIT
                    8) ;;
;;   G_ASCII_DIGIT =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_ASCII_GRAPH
                    16) ;;
;;   G_ASCII_GRAPH =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_ASCII_LOWER
                    32) ;;
;;   G_ASCII_LOWER =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant G_ASCII_PRINT
                    64) ;;
;;   G_ASCII_PRINT =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant G_ASCII_PUNCT
                    128) ;;
;;   G_ASCII_PUNCT =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant G_ASCII_SPACE
                    256) ;;
;;   G_ASCII_SPACE =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant G_ASCII_UPPER
                    512) ;;
;;   G_ASCII_UPPER =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant G_ASCII_XDIGIT
                    1024) ;;
;;   G_ASCII_XDIGIT =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-type GAsciiType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:50 <931> 
;; extern const guint16* const g_ascii_table;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_ascii_table"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:85 <932> 
;; gchar g_ascii_tolower( gchar c);
(ff:bind-c-function g_ascii_tolower
     :unconverted-entry-name "g_ascii_tolower"
     :c-return-type ("gchar")
     :return-type gchar
     :c-arg-types (("gchar"))
     :c-arg-names (c)
     :arguments (gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:86 <933> 
;; gchar g_ascii_toupper( gchar c);
(ff:bind-c-function g_ascii_toupper
     :unconverted-entry-name "g_ascii_toupper"
     :c-return-type ("gchar")
     :return-type gchar
     :c-arg-types (("gchar"))
     :c-arg-names (c)
     :arguments (gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:88 <934> 
;; gint g_ascii_digit_value( gchar c);
(ff:bind-c-function g_ascii_digit_value
     :unconverted-entry-name "g_ascii_digit_value"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gchar"))
     :c-arg-names (c)
     :arguments (gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:89 <935> 
;; gint g_ascii_xdigit_value( gchar c);
(ff:bind-c-function g_ascii_xdigit_value
     :unconverted-entry-name "g_ascii_xdigit_value"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gchar"))
     :c-arg-names (c)
     :arguments (gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:95 <936> 
;; gchar* g_strdelimit( gchar* string, const gchar* delimiters, gchar
;;   new_delimiter
;;   );
(ff:bind-c-function g_strdelimit
     :unconverted-entry-name "g_strdelimit"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*") ("const" "gchar" "*") ("gchar"))
     :c-arg-names (string delimiters new_delimiter)
     :arguments ((* gchar) (* gchar) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:98 <937> 
;; gchar* g_strcanon( gchar* string, const gchar* valid_chars, gchar
;;   substitutor
;;   );
(ff:bind-c-function g_strcanon
     :unconverted-entry-name "g_strcanon"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*") ("const" "gchar" "*") ("gchar"))
     :c-arg-names (string valid_chars substitutor)
     :arguments ((* gchar) (* gchar) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:101 <938> 
;; const gchar* g_strerror( gint errnum);
(ff:bind-c-function g_strerror
     :unconverted-entry-name "g_strerror"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gint"))
     :c-arg-names (errnum)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:102 <939> 
;; const gchar* g_strsignal( gint signum);
(ff:bind-c-function g_strsignal
     :unconverted-entry-name "g_strsignal"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gint"))
     :c-arg-names (signum)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:103 <940> 
;; gchar* g_strreverse( gchar* string);
(ff:bind-c-function g_strreverse
     :unconverted-entry-name "g_strreverse"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:104 <941> 
;; gsize g_strlcpy( gchar* dest, const gchar* src, gsize dest_size);
(ff:bind-c-function g_strlcpy
     :unconverted-entry-name "g_strlcpy"
     :c-return-type ("gsize")
     :return-type gsize
     :c-arg-types (("gchar" "*") ("const" "gchar" "*") ("gsize"))
     :c-arg-names (dest src dest_size)
     :arguments ((* gchar) (* gchar) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:107 <942> 
;; gsize g_strlcat( gchar* dest, const gchar* src, gsize dest_size);
(ff:bind-c-function g_strlcat
     :unconverted-entry-name "g_strlcat"
     :c-return-type ("gsize")
     :return-type gsize
     :c-arg-types (("gchar" "*") ("const" "gchar" "*") ("gsize"))
     :c-arg-names (dest src dest_size)
     :arguments ((* gchar) (* gchar) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:110 <943> 
;; gchar* g_strstr_len( const gchar* haystack, gssize haystack_len, const
;;    gchar* needle);
(ff:bind-c-function g_strstr_len
     :unconverted-entry-name "g_strstr_len"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize")
                   ("const" "gchar" "*"))
     :c-arg-names (haystack haystack_len needle)
     :arguments ((* gchar) gssize (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:113 <944> 
;; gchar* g_strrstr( const gchar* haystack, const gchar* needle);
(ff:bind-c-function g_strrstr
     :unconverted-entry-name "g_strrstr"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (haystack needle)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:115 <945> 
;; gchar* g_strrstr_len( const gchar* haystack, gssize haystack_len, const
;;    gchar* needle);
(ff:bind-c-function g_strrstr_len
     :unconverted-entry-name "g_strrstr_len"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize")
                   ("const" "gchar" "*"))
     :c-arg-names (haystack haystack_len needle)
     :arguments ((* gchar) gssize (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:121 <946> 
;; gdouble g_strtod( const gchar* nptr, gchar** endptr);
(ff:bind-c-function g_strtod
     :unconverted-entry-name "g_strtod"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*"))
     :c-arg-names (nptr endptr)
     :arguments ((* gchar) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:123 <947> 
;; gdouble g_ascii_strtod( const gchar* nptr, gchar** endptr);
(ff:bind-c-function g_ascii_strtod
     :unconverted-entry-name "g_ascii_strtod"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*"))
     :c-arg-names (nptr endptr)
     :arguments ((* gchar) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:129 <948> 
;; gchar* g_ascii_dtostr( gchar* buffer, gint buf_len, gdouble d);
(ff:bind-c-function g_ascii_dtostr
     :unconverted-entry-name "g_ascii_dtostr"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*") ("gint") ("gdouble"))
     :c-arg-names (buffer buf_len d)
     :arguments ((* gchar) gint gdouble)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:132 <949> 
;; gchar* g_ascii_formatd( gchar* buffer, gint buf_len, const gchar*
;;   format,
;;              gdouble d);
(ff:bind-c-function g_ascii_formatd
     :unconverted-entry-name "g_ascii_formatd"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*") ("gint") ("const" "gchar" "*")
                   ("gdouble"))
     :c-arg-names (buffer buf_len format d)
     :arguments ((* gchar) gint (* gchar) gdouble)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:138 <950> 
;; gchar* g_strchug( gchar* string);
(ff:bind-c-function g_strchug
     :unconverted-entry-name "g_strchug"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:140 <951> 
;; gchar* g_strchomp( gchar* string);
(ff:bind-c-function g_strchomp
     :unconverted-entry-name "g_strchomp"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:144 <952> 
;; gint g_ascii_strcasecmp( const gchar* s1, const gchar* s2);
(ff:bind-c-function g_ascii_strcasecmp
     :unconverted-entry-name "g_ascii_strcasecmp"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (s1 s2)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:146 <953> 
;; gint g_ascii_strncasecmp( const gchar* s1, const gchar* s2, gsize n);
(ff:bind-c-function g_ascii_strncasecmp
     :unconverted-entry-name "g_ascii_strncasecmp"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("gsize"))
     :c-arg-names (s1 s2 n)
     :arguments ((* gchar) (* gchar) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:149 <954> 
;; gchar* g_ascii_strdown( const gchar* str, gssize len);
(ff:bind-c-function g_ascii_strdown
     :unconverted-entry-name "g_ascii_strdown"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (str len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:151 <955> 
;; gchar* g_ascii_strup( const gchar* str, gssize len);
(ff:bind-c-function g_ascii_strup
     :unconverted-entry-name "g_ascii_strup"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gssize"))
     :c-arg-names (str len)
     :arguments ((* gchar) gssize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:161 <956> 
;; gint g_strcasecmp( const gchar* s1, const gchar* s2);
(ff:bind-c-function g_strcasecmp
     :unconverted-entry-name "g_strcasecmp"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (s1 s2)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:163 <957> 
;; gint g_strncasecmp( const gchar* s1, const gchar* s2, guint n);
(ff:bind-c-function g_strncasecmp
     :unconverted-entry-name "g_strncasecmp"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("guint"))
     :c-arg-names (s1 s2 n)
     :arguments ((* gchar) (* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:166 <958> 
;; gchar* g_strdown( gchar* string);
(ff:bind-c-function g_strdown
     :unconverted-entry-name "g_strdown"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:167 <959> 
;; gchar* g_strup( gchar* string);
(ff:bind-c-function g_strup
     :unconverted-entry-name "g_strup"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:174 <960> 
;; gchar* g_strdup( const gchar* str);
(ff:bind-c-function g_strdup
     :unconverted-entry-name "g_strdup"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (str)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:175 <961> 
;; gchar* g_strdup_printf( const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_strdup_printf
     :unconverted-entry-name "g_strdup_printf"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:177 <962> 
;; gchar* g_strdup_vprintf( const gchar* format, va_list args);
(ff:bind-c-function g_strdup_vprintf
     :unconverted-entry-name "g_strdup_vprintf"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("va_list"))
     :c-arg-names (format args)
     :arguments ((* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:179 <963> 
;; gchar* g_strndup( const gchar* str, gsize n);
(ff:bind-c-function g_strndup
     :unconverted-entry-name "g_strndup"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gsize"))
     :c-arg-names (str n)
     :arguments ((* gchar) gsize)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:181 <964> 
;; gchar* g_strnfill( gsize length, gchar fill_char);
(ff:bind-c-function g_strnfill
     :unconverted-entry-name "g_strnfill"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gsize") ("gchar"))
     :c-arg-names (length fill_char)
     :arguments (gsize gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:183 <965> 
;; gchar* g_strconcat( const gchar* string1, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_strconcat
     :unconverted-entry-name "g_strconcat"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (string1)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:185 <966> 
;; gchar* g_strjoin( const gchar* separator, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_strjoin
     :unconverted-entry-name "g_strjoin"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (separator)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:191 <967> 
;; gchar* g_strcompress( const gchar* source);
(ff:bind-c-function g_strcompress
     :unconverted-entry-name "g_strcompress"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (source)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:201 <968> 
;; gchar* g_strescape( const gchar* source, const gchar* exceptions);
(ff:bind-c-function g_strescape
     :unconverted-entry-name "g_strescape"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (source exceptions)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:204 <969> 
;; gpointer g_memdup( gconstpointer mem, guint byte_size);
(ff:bind-c-function g_memdup
     :unconverted-entry-name "g_memdup"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gconstpointer") ("guint"))
     :c-arg-names (mem byte_size)
     :arguments (gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:215 <970> 
;; gchar** g_strsplit( const gchar* string, const gchar* delimiter, gint
;;    max_tokens);
(ff:bind-c-function g_strsplit
     :unconverted-entry-name "g_strsplit"
     :c-return-type ("gchar" "*" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (string delimiter max_tokens)
     :arguments ((* gchar) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:218 <971> 
;; gchar* g_strjoinv( const gchar* separator, gchar** str_array);
(ff:bind-c-function g_strjoinv
     :unconverted-entry-name "g_strjoinv"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*"))
     :c-arg-names (separator str_array)
     :arguments ((* gchar) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:220 <972> 
;; void g_strfreev( gchar** str_array);
(ff:bind-c-function g_strfreev
     :unconverted-entry-name "g_strfreev"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gchar" "*" "*"))
     :c-arg-names (str_array)
     :arguments ((* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:221 <973> 
;; gchar** g_strdupv( gchar** str_array);
(ff:bind-c-function g_strdupv
     :unconverted-entry-name "g_strdupv"
     :c-return-type ("gchar" "*" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*" "*"))
     :c-arg-names (str_array)
     :arguments ((* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gstrfuncs.h:223 <974> 
;; gchar* g_stpcpy( gchar* dest, const char* src);
(ff:bind-c-function g_stpcpy
     :unconverted-entry-name "g_stpcpy"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*") ("const" "char" "*"))
     :c-arg-names (dest src)
     :arguments ((* gchar) (* :char))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:34 <975> 
;; typedef struct _GThreadPool GThreadPool;
(ff:bind-c-typedef _GThreadPool
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GThreadPool _GThreadPool)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:41 <976> 
;; struct _GThreadPool {
;;         GFunc func; gpointer user_data; gboolean exclusive; };
(ff:bind-c-type _GThreadPool (:struct
  (func GFunc)   ;; GFunc func
  (user_data gpointer)   ;; gpointer user_data
  (exclusive gboolean)   ;; gboolean exclusive
  ))   ;; bind-c-type _GThreadPool
(ff:bind-c-typedef GThreadPool _GThreadPool) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:53 <977> 
;; GThreadPool* g_thread_pool_new( GFunc func, gpointer user_data, gint
;;   max_threads,
;;              gboolean exclusive, GError** error);
(ff:bind-c-function g_thread_pool_new
     :unconverted-entry-name "g_thread_pool_new"
     :c-return-type ("GThreadPool" "*")
     :return-type (* GThreadPool)
     :c-arg-types (("GFunc") ("gpointer") ("gint") ("gboolean")
                   ("GError" "*" "*"))
     :c-arg-names (func user_data max_threads exclusive error)
     :arguments (GFunc gpointer gint gboolean (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:63 <978> 
;; void g_thread_pool_push( GThreadPool* pool, gpointer data, GError**
;;   error
;;   );
(ff:bind-c-function g_thread_pool_push
     :unconverted-entry-name "g_thread_pool_push"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GThreadPool" "*") ("gpointer") ("GError" "*" "*"))
     :c-arg-names (pool data error)
     :arguments ((* GThreadPool) gpointer (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:70 <979> 
;; void g_thread_pool_set_max_threads( GThreadPool* pool, gint max_threads,
;;              GError** error);
(ff:bind-c-function g_thread_pool_set_max_threads
     :unconverted-entry-name "g_thread_pool_set_max_threads"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GThreadPool" "*") ("gint") ("GError" "*" "*"))
     :c-arg-names (pool max_threads error)
     :arguments ((* GThreadPool) gint (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:73 <980> 
;; gint g_thread_pool_get_max_threads( GThreadPool* pool);
(ff:bind-c-function g_thread_pool_get_max_threads
     :unconverted-entry-name "g_thread_pool_get_max_threads"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GThreadPool" "*"))
     :c-arg-names (pool)
     :arguments ((* GThreadPool))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:77 <981> 
;; guint g_thread_pool_get_num_threads( GThreadPool* pool);
(ff:bind-c-function g_thread_pool_get_num_threads
     :unconverted-entry-name "g_thread_pool_get_num_threads"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GThreadPool" "*"))
     :c-arg-names (pool)
     :arguments ((* GThreadPool))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:80 <982> 
;; guint g_thread_pool_unprocessed( GThreadPool* pool);
(ff:bind-c-function g_thread_pool_unprocessed
     :unconverted-entry-name "g_thread_pool_unprocessed"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GThreadPool" "*"))
     :c-arg-names (pool)
     :arguments ((* GThreadPool))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:86 <983> 
;; void g_thread_pool_free( GThreadPool* pool, gboolean immediate, gboolean
;;    wait);
(ff:bind-c-function g_thread_pool_free
     :unconverted-entry-name "g_thread_pool_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GThreadPool" "*") ("gboolean") ("gboolean"))
     :c-arg-names (pool immediate wait)
     :arguments ((* GThreadPool) gboolean gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:92 <984> 
;; void g_thread_pool_set_max_unused_threads( gint max_threads);
(ff:bind-c-function g_thread_pool_set_max_unused_threads
     :unconverted-entry-name "g_thread_pool_set_max_unused_threads"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint"))
     :c-arg-names (max_threads)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:93 <985> 
;; gint g_thread_pool_get_max_unused_threads( void);
(ff:bind-c-function g_thread_pool_get_max_unused_threads
     :unconverted-entry-name "g_thread_pool_get_max_unused_threads"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:94 <986> 
;; guint g_thread_pool_get_num_unused_threads( void);
(ff:bind-c-function g_thread_pool_get_num_unused_threads
     :unconverted-entry-name "g_thread_pool_get_num_unused_threads"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gthreadpool.h:97 <987> 
;; void g_thread_pool_stop_unused_threads( void);
(ff:bind-c-function g_thread_pool_stop_unused_threads
     :unconverted-entry-name "g_thread_pool_stop_unused_threads"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:38 <988> 
;; typedef struct _GTimer GTimer;
(ff:bind-c-typedef _GTimer
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTimer _GTimer)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:42 <989> 
;; GTimer* g_timer_new( void);
(ff:bind-c-function g_timer_new
     :unconverted-entry-name "g_timer_new"
     :c-return-type ("GTimer" "*")
     :return-type (* GTimer)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:43 <990> 
;; void g_timer_destroy( GTimer* timer);
(ff:bind-c-function g_timer_destroy
     :unconverted-entry-name "g_timer_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:44 <991> 
;; void g_timer_start( GTimer* timer);
(ff:bind-c-function g_timer_start
     :unconverted-entry-name "g_timer_start"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:45 <992> 
;; void g_timer_stop( GTimer* timer);
(ff:bind-c-function g_timer_stop
     :unconverted-entry-name "g_timer_stop"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:46 <993> 
;; void g_timer_reset( GTimer* timer);
(ff:bind-c-function g_timer_reset
     :unconverted-entry-name "g_timer_reset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:47 <994> 
;; gdouble g_timer_elapsed( GTimer* timer, gulong* microseconds);
(ff:bind-c-function g_timer_elapsed
     :unconverted-entry-name "g_timer_elapsed"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("GTimer" "*") ("gulong" "*"))
     :c-arg-names (timer microseconds)
     :arguments ((* GTimer) (* gulong))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:50 <995> 
;; void g_usleep( gulong microseconds);
(ff:bind-c-function g_usleep
     :unconverted-entry-name "g_usleep"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gulong"))
     :c-arg-names (microseconds)
     :arguments (gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtimer.h:52 <996> 
;; void g_time_val_add( GTimeVal* time, glong microseconds);
(ff:bind-c-function g_time_val_add
     :unconverted-entry-name "g_time_val_add"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimeVal" "*") ("glong"))
     :c-arg-names (time microseconds)
     :arguments ((* GTimeVal) glong)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:34 <997> 
;; typedef struct _GTree GTree;
(ff:bind-c-typedef _GTree
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTree _GTree)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:36 <998> 
;; typedef gboolean(* GTraverseFunc)( gpointer key, gpointer value,
;;   gpointer
;;    data);
(ff:bind-c-type GTraverseFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:42 <999> 
;; GTree* g_tree_new( GCompareFunc key_compare_func);
(ff:bind-c-function g_tree_new
     :unconverted-entry-name "g_tree_new"
     :c-return-type ("GTree" "*")
     :return-type (* GTree)
     :c-arg-types (("GCompareFunc"))
     :c-arg-names (key_compare_func)
     :arguments (GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:43 <1000> 
;; GTree* g_tree_new_with_data( GCompareDataFunc key_compare_func, gpointer
;;    key_compare_data);
(ff:bind-c-function g_tree_new_with_data
     :unconverted-entry-name "g_tree_new_with_data"
     :c-return-type ("GTree" "*")
     :return-type (* GTree)
     :c-arg-types (("GCompareDataFunc") ("gpointer"))
     :c-arg-names (key_compare_func key_compare_data)
     :arguments (GCompareDataFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:45 <1001> 
;; GTree* g_tree_new_full( GCompareDataFunc key_compare_func, gpointer
;;   key_compare_data,
;;              GDestroyNotify key_destroy_func, GDestroyNotify
;;   value_destroy_func);
(ff:bind-c-function g_tree_new_full
     :unconverted-entry-name "g_tree_new_full"
     :c-return-type ("GTree" "*")
     :return-type (* GTree)
     :c-arg-types (("GCompareDataFunc") ("gpointer") ("GDestroyNotify")
                   ("GDestroyNotify"))
     :c-arg-names (key_compare_func key_compare_data key_destroy_func
                   value_destroy_func)
     :arguments (GCompareDataFunc gpointer GDestroyNotify
                 GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:49 <1002> 
;; void g_tree_destroy( GTree* tree);
(ff:bind-c-function g_tree_destroy
     :unconverted-entry-name "g_tree_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*"))
     :c-arg-names (tree)
     :arguments ((* GTree))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:50 <1003> 
;; void g_tree_insert( GTree* tree, gpointer key, gpointer value);
(ff:bind-c-function g_tree_insert
     :unconverted-entry-name "g_tree_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("gpointer") ("gpointer"))
     :c-arg-names (tree key value)
     :arguments ((* GTree) gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:53 <1004> 
;; void g_tree_replace( GTree* tree, gpointer key, gpointer value);
(ff:bind-c-function g_tree_replace
     :unconverted-entry-name "g_tree_replace"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("gpointer") ("gpointer"))
     :c-arg-names (tree key value)
     :arguments ((* GTree) gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:56 <1005> 
;; void g_tree_remove( GTree* tree, gconstpointer key);
(ff:bind-c-function g_tree_remove
     :unconverted-entry-name "g_tree_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("gconstpointer"))
     :c-arg-names (tree key)
     :arguments ((* GTree) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:58 <1006> 
;; void g_tree_steal( GTree* tree, gconstpointer key);
(ff:bind-c-function g_tree_steal
     :unconverted-entry-name "g_tree_steal"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("gconstpointer"))
     :c-arg-names (tree key)
     :arguments ((* GTree) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:60 <1007> 
;; gpointer g_tree_lookup( GTree* tree, gconstpointer key);
(ff:bind-c-function g_tree_lookup
     :unconverted-entry-name "g_tree_lookup"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GTree" "*") ("gconstpointer"))
     :c-arg-names (tree key)
     :arguments ((* GTree) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:62 <1008> 
;; gboolean g_tree_lookup_extended( GTree* tree, gconstpointer lookup_key,
;;              gpointer* orig_key, gpointer* value);
(ff:bind-c-function g_tree_lookup_extended
     :unconverted-entry-name "g_tree_lookup_extended"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GTree" "*") ("gconstpointer") ("gpointer" "*")
                   ("gpointer" "*"))
     :c-arg-names (tree lookup_key orig_key value)
     :arguments ((* GTree) gconstpointer (* gpointer) (* gpointer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:66 <1009> 
;; void g_tree_foreach( GTree* tree, GTraverseFunc func, gpointer user_data
;;   );
(ff:bind-c-function g_tree_foreach
     :unconverted-entry-name "g_tree_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("GTraverseFunc") ("gpointer"))
     :c-arg-names (tree func user_data)
     :arguments ((* GTree) GTraverseFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:71 <1010> 
;; void g_tree_traverse( GTree* tree, GTraverseFunc traverse_func,
;;   GTraverseType
;;    traverse_type, gpointer user_data);
(ff:bind-c-function g_tree_traverse
     :unconverted-entry-name "g_tree_traverse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("GTraverseFunc") ("GTraverseType")
                   ("gpointer"))
     :c-arg-names (tree traverse_func traverse_type user_data)
     :arguments ((* GTree) GTraverseFunc GTraverseType gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:77 <1011> 
;; gpointer g_tree_search( GTree* tree, GCompareFunc search_func,
;;   gconstpointer
;;    user_data);
(ff:bind-c-function g_tree_search
     :unconverted-entry-name "g_tree_search"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GTree" "*") ("GCompareFunc") ("gconstpointer"))
     :c-arg-names (tree search_func user_data)
     :arguments ((* GTree) GCompareFunc gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:80 <1012> 
;; gint g_tree_height( GTree* tree);
(ff:bind-c-function g_tree_height
     :unconverted-entry-name "g_tree_height"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GTree" "*"))
     :c-arg-names (tree)
     :arguments ((* GTree))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gtree.h:81 <1013> 
;; gint g_tree_nnodes( GTree* tree);
(ff:bind-c-function g_tree_nnodes
     :unconverted-entry-name "g_tree_nnodes"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GTree" "*"))
     :c-arg-names (tree)
     :arguments ((* GTree))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:116 <1014> 
;; const gchar* g_get_user_name( void);
(ff:bind-c-function g_get_user_name
     :unconverted-entry-name "g_get_user_name"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:117 <1015> 
;; const gchar* g_get_real_name( void);
(ff:bind-c-function g_get_real_name
     :unconverted-entry-name "g_get_real_name"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:118 <1016> 
;; const gchar* g_get_home_dir( void);
(ff:bind-c-function g_get_home_dir
     :unconverted-entry-name "g_get_home_dir"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:119 <1017> 
;; const gchar* g_get_tmp_dir( void);
(ff:bind-c-function g_get_tmp_dir
     :unconverted-entry-name "g_get_tmp_dir"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:120 <1018> 
;; gchar* g_get_prgname( void);
(ff:bind-c-function g_get_prgname
     :unconverted-entry-name "g_get_prgname"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:121 <1019> 
;; void g_set_prgname( const gchar* prgname);
(ff:bind-c-function g_set_prgname
     :unconverted-entry-name "g_set_prgname"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (prgname)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:124 <1020> 
;; typedef struct _GDebugKey GDebugKey;
(ff:bind-c-typedef _GDebugKey
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GDebugKey _GDebugKey)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:125 <1021> 
;; struct _GDebugKey { gchar* key; guint value; };
(ff:bind-c-type _GDebugKey (:struct
  (key (* gchar))   ;; gchar* key
  (value guint)   ;; guint value
  ))   ;; bind-c-type _GDebugKey
(ff:bind-c-typedef GDebugKey _GDebugKey) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:133 <1022> 
;; guint g_parse_debug_string( const gchar* string, const GDebugKey* keys,
;;              guint nkeys);
(ff:bind-c-function g_parse_debug_string
     :unconverted-entry-name "g_parse_debug_string"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("const" "GDebugKey" "*")
                   ("guint"))
     :c-arg-names (string keys nkeys)
     :arguments ((* gchar) (* GDebugKey) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:137 <1023> 
;; gint g_snprintf( gchar* string, gulong n, gchar const* format,
;;   ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_snprintf
     :unconverted-entry-name "g_snprintf"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gchar" "*") ("gulong") ("gchar" "*") "...")
     :c-arg-names (string n format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:141 <1024> 
;; gint g_vsnprintf( gchar* string, gulong n, gchar const* format, va_list
;;    args);
(ff:bind-c-function g_vsnprintf
     :unconverted-entry-name "g_vsnprintf"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gchar" "*") ("gulong") ("gchar" "*") ("va_list"))
     :c-arg-names (string n format args)
     :arguments ((* gchar) gulong (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:147 <1025> 
;; gboolean g_path_is_absolute( const gchar* file_name);
(ff:bind-c-function g_path_is_absolute
     :unconverted-entry-name "g_path_is_absolute"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:150 <1026> 
;; const gchar* g_path_skip_root( const gchar* file_name);
(ff:bind-c-function g_path_skip_root
     :unconverted-entry-name "g_path_skip_root"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:158 <1027> 
;; const gchar* g_basename( const gchar* file_name);
(ff:bind-c-function g_basename
     :unconverted-entry-name "g_basename"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:164 <1028> 
;; gchar* g_get_current_dir( void);
(ff:bind-c-function g_get_current_dir
     :unconverted-entry-name "g_get_current_dir"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:165 <1029> 
;; gchar* g_path_get_basename( const gchar* file_name);
(ff:bind-c-function g_path_get_basename
     :unconverted-entry-name "g_path_get_basename"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:166 <1030> 
;; gchar* g_path_get_dirname( const gchar* file_name);
(ff:bind-c-function g_path_get_dirname
     :all-names ((g_dirname . "g_dirname")
                 (g_path_get_dirname . "g_path_get_dirname"))
     :unconverted-entry-name "g_path_get_dirname"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:170 <1031> 
;; void g_nullify_pointer( gpointer* nullify_location);
(ff:bind-c-function g_nullify_pointer
     :unconverted-entry-name "g_nullify_pointer"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer" "*"))
     :c-arg-names (nullify_location)
     :arguments ((* gpointer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:177 <1032> 
;; const gchar* g_getenv( const gchar* variable);
(ff:bind-c-function g_getenv
     :unconverted-entry-name "g_getenv"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (variable)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:184 <1033> 
;; typedef void(* GVoidFunc)( void);
(ff:bind-c-type GVoidFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:195 <1034> 
;; void g_atexit( GVoidFunc func);
(ff:bind-c-function g_atexit
     :unconverted-entry-name "g_atexit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GVoidFunc"))
     :c-arg-names (func)
     :arguments (GVoidFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:198 <1035> 
;; gchar* g_find_program_in_path( const gchar* program);
(ff:bind-c-function g_find_program_in_path
     :unconverted-entry-name "g_find_program_in_path"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (program)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:202 <1036> 
;; static inline gint g_bit_nth_lsf( gulong mask, gint nth_bit);
(ff:bind-c-function g_bit_nth_lsf
     :unconverted-entry-name "g_bit_nth_lsf"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "gint")
     :return-type gint
     :c-arg-types (("gulong") ("gint"))
     :c-arg-names (mask nth_bit)
     :arguments (gulong gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:204 <1037> 
;; static inline gint g_bit_nth_msf( gulong mask, gint nth_bit);
(ff:bind-c-function g_bit_nth_msf
     :unconverted-entry-name "g_bit_nth_msf"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "gint")
     :return-type gint
     :c-arg-types (("gulong") ("gint"))
     :c-arg-names (mask nth_bit)
     :arguments (gulong gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:206 <1038> 
;; static inline guint g_bit_storage( gulong number);
(ff:bind-c-function g_bit_storage
     :unconverted-entry-name "g_bit_storage"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "guint")
     :return-type guint
     :c-arg-types (("gulong"))
     :c-arg-names (number)
     :arguments (gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:211 <1039> 
;; typedef struct _GTrashStack GTrashStack;
(ff:bind-c-typedef _GTrashStack
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTrashStack _GTrashStack)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:212 <1040> 
;; struct _GTrashStack { GTrashStack* next; };
(ff:bind-c-type _GTrashStack (:struct
  (next (* GTrashStack))   ;; GTrashStack* next
  ))   ;; bind-c-type _GTrashStack
(ff:bind-c-typedef GTrashStack _GTrashStack) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:217 <1041> 
;; static inline void g_trash_stack_push( GTrashStack** stack_p, gpointer
;;    data_p);
(ff:bind-c-function g_trash_stack_push
     :unconverted-entry-name "g_trash_stack_push"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "void")
     :return-type :void
     :c-arg-types (("GTrashStack" "*" "*") ("gpointer"))
     :c-arg-names (stack_p data_p)
     :arguments ((* (* GTrashStack)) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:219 <1042> 
;; static inline gpointer g_trash_stack_pop( GTrashStack** stack_p);
(ff:bind-c-function g_trash_stack_pop
     :unconverted-entry-name "g_trash_stack_pop"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "gpointer")
     :return-type gpointer
     :c-arg-types (("GTrashStack" "*" "*"))
     :c-arg-names (stack_p)
     :arguments ((* (* GTrashStack)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:220 <1043> 
;; static inline gpointer g_trash_stack_peek( GTrashStack** stack_p);
(ff:bind-c-function g_trash_stack_peek
     :unconverted-entry-name "g_trash_stack_peek"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "gpointer")
     :return-type gpointer
     :c-arg-types (("GTrashStack" "*" "*"))
     :c-arg-names (stack_p)
     :arguments ((* (* GTrashStack)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:221 <1044> 
;; static inline guint g_trash_stack_height( GTrashStack** stack_p);
(ff:bind-c-function g_trash_stack_height
     :unconverted-entry-name "g_trash_stack_height"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "guint")
     :return-type guint
     :c-arg-types (("GTrashStack" "*" "*"))
     :c-arg-names (stack_p)
     :arguments ((* (* GTrashStack)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:226 <1045> 
;; static inline gint g_bit_nth_lsf( gulong mask, gint nth_bit) {
;;         DO {
;;         nth_bit PLUSPLUS;
;;         IF( mask &(  0x000000001 LSHIFT( gulong) nth_bit)) RETURN
;;   nth_bit;
;;         } WHILE( nth_bit ARITHCOMPARE  0x000000020);
;;         RETURN -  0x000000001;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:239 <1046> 
;; static inline gint g_bit_nth_msf( gulong mask, gint nth_bit) {
;;         IF( nth_bit ARITHCOMPARE  0x000000000) nth_bit =  0x000000004*
;;   0x000000008
;;   ;
;;         DO {
;;         nth_bit MINUSMINUS;
;;         IF( mask &(  0x000000001 LSHIFT( gulong) nth_bit)) RETURN
;;   nth_bit;
;;         } WHILE( nth_bit ARITHCOMPARE  0x000000000);
;;         RETURN -  0x000000001;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:254 <1047> 
;; static inline guint g_bit_storage( gulong number) {
;;         register guint n_bits =  0x000000000;
;;         DO {
;;         n_bits PLUSPLUS;
;;         number ASSIGN  0x000000001;
;;         } WHILE( number);
;;         RETURN n_bits;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:267 <1048> 
;; static inline void g_trash_stack_push( GTrashStack** stack_p, gpointer
;;    data_p) {
;;         GTrashStack* data =( GTrashStack*) data_p;
;;         data POINTSAT next =* stack_p;
;;        * stack_p = data;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:276 <1049> 
;; static inline gpointer g_trash_stack_pop( GTrashStack** stack_p) {
;;         GTrashStack* data;
;;         data =* stack_p;
;;         IF( data) {
;;        * stack_p = data POINTSAT next;
;;         data POINTSAT next =  0x000000000;
;;         } RETURN data;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:293 <1050> 
;; static inline gpointer g_trash_stack_peek( GTrashStack** stack_p) {
;;         GTrashStack* data;
;;         data =* stack_p;
;;         RETURN data;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:302 <1051> 
;; static inline guint g_trash_stack_height( GTrashStack** stack_p) {
;;         GTrashStack* data;
;;         guint i =  0x000000000;
;;         FOR( data =* stack_p;
;;         data;
;;         data = data POINTSAT next) i PLUSPLUS;
;;         RETURN i;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:319 <1052> 
;; extern const guint glib_major_version;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_major_version"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:320 <1053> 
;; extern const guint glib_minor_version;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_minor_version"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:321 <1054> 
;; extern const guint glib_micro_version;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_micro_version"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:322 <1055> 
;; extern const guint glib_interface_age;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_interface_age"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/glib/gutils.h:323 <1056> 
;; extern const guint glib_binary_age;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_binary_age"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:29 <1057> 
;; typedef struct _PangoCoverage PangoCoverage;
(ff:bind-c-typedef _PangoCoverage
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoCoverage _PangoCoverage)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:31 <1058> 
;; typedef enum {
;;         PANGO_COVERAGE_NONE, PANGO_COVERAGE_FALLBACK,
;;   PANGO_COVERAGE_APPROXIMATE,
;;              PANGO_COVERAGE_EXACT } PangoCoverageLevel;
(ff:bind-c-constant PANGO_COVERAGE_NONE 0) ;;  PANGO_COVERAGE_NONE 
(ff:bind-c-constant PANGO_COVERAGE_FALLBACK
                    1) ;;
;;   PANGO_COVERAGE_FALLBACK 
(ff:bind-c-constant PANGO_COVERAGE_APPROXIMATE
                    2) ;;
;;   PANGO_COVERAGE_APPROXIMATE 
(ff:bind-c-constant PANGO_COVERAGE_EXACT 3) ;;  PANGO_COVERAGE_EXACT 
(ff:bind-c-type PangoCoverageLevel :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:38 <1059> 
;; PangoCoverage* pango_coverage_new( void);
(ff:bind-c-function pango_coverage_new
     :unconverted-entry-name "pango_coverage_new"
     :c-return-type ("PangoCoverage" "*")
     :return-type (* PangoCoverage)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:39 <1060> 
;; PangoCoverage* pango_coverage_ref( PangoCoverage* coverage);
(ff:bind-c-function pango_coverage_ref
     :unconverted-entry-name "pango_coverage_ref"
     :c-return-type ("PangoCoverage" "*")
     :return-type (* PangoCoverage)
     :c-arg-types (("PangoCoverage" "*"))
     :c-arg-names (coverage)
     :arguments ((* PangoCoverage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:40 <1061> 
;; void pango_coverage_unref( PangoCoverage* coverage);
(ff:bind-c-function pango_coverage_unref
     :unconverted-entry-name "pango_coverage_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoCoverage" "*"))
     :c-arg-names (coverage)
     :arguments ((* PangoCoverage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:41 <1062> 
;; PangoCoverage* pango_coverage_copy( PangoCoverage* coverage);
(ff:bind-c-function pango_coverage_copy
     :unconverted-entry-name "pango_coverage_copy"
     :c-return-type ("PangoCoverage" "*")
     :return-type (* PangoCoverage)
     :c-arg-types (("PangoCoverage" "*"))
     :c-arg-names (coverage)
     :arguments ((* PangoCoverage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:42 <1063> 
;; PangoCoverageLevel pango_coverage_get( PangoCoverage* coverage, int
;;   index
;;   );
(ff:bind-c-function pango_coverage_get
     :unconverted-entry-name "pango_coverage_get"
     :c-return-type ("PangoCoverageLevel")
     :return-type PangoCoverageLevel
     :c-arg-types (("PangoCoverage" "*") ("int"))
     :c-arg-names (coverage index)
     :arguments ((* PangoCoverage) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:44 <1064> 
;; void pango_coverage_set( PangoCoverage* coverage, int index,
;;   PangoCoverageLevel
;;    level);
(ff:bind-c-function pango_coverage_set
     :unconverted-entry-name "pango_coverage_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoCoverage" "*") ("int") ("PangoCoverageLevel"))
     :c-arg-names (coverage index level)
     :arguments ((* PangoCoverage) :int PangoCoverageLevel)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:47 <1065> 
;; void pango_coverage_max( PangoCoverage* coverage, PangoCoverage* other);
(ff:bind-c-function pango_coverage_max
     :unconverted-entry-name "pango_coverage_max"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoCoverage" "*") ("PangoCoverage" "*"))
     :c-arg-names (coverage other)
     :arguments ((* PangoCoverage) (* PangoCoverage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:50 <1066> 
;; void pango_coverage_to_bytes( PangoCoverage* coverage, guchar** bytes,
;;              int* n_bytes);
(ff:bind-c-function pango_coverage_to_bytes
     :unconverted-entry-name "pango_coverage_to_bytes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoCoverage" "*") ("guchar" "*" "*") ("int" "*"))
     :c-arg-names (coverage bytes n_bytes)
     :arguments ((* PangoCoverage) (* (* guchar)) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-coverage.h:53 <1067> 
;; PangoCoverage* pango_coverage_from_bytes( guchar* bytes, int n_bytes);
(ff:bind-c-function pango_coverage_from_bytes
     :unconverted-entry-name "pango_coverage_from_bytes"
     :c-return-type ("PangoCoverage" "*")
     :return-type (* PangoCoverage)
     :c-arg-types (("guchar" "*") ("int"))
     :c-arg-names (bytes n_bytes)
     :arguments ((* guchar) :int)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:92 <1068> 
;; typedef gulong GType;
(ff:bind-c-type GType gulong)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:96 <1069> 
;; typedef struct _GValue GValue;
(ff:bind-c-typedef _GValue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GValue _GValue)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:97 <1070> 
;; typedef union _GTypeCValue GTypeCValue;
(ff:bind-c-typedef _GTypeCValue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeCValue _GTypeCValue)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:98 <1071> 
;; typedef struct _GTypePlugin GTypePlugin;
(ff:bind-c-typedef _GTypePlugin
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypePlugin _GTypePlugin)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:99 <1072> 
;; typedef struct _GTypeClass GTypeClass;
(ff:bind-c-typedef _GTypeClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeClass _GTypeClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:100 <1073> 
;; typedef struct _GTypeInterface GTypeInterface;
(ff:bind-c-typedef _GTypeInterface
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeInterface _GTypeInterface)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:101 <1074> 
;; typedef struct _GTypeInstance GTypeInstance;
(ff:bind-c-typedef _GTypeInstance
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeInstance _GTypeInstance)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:102 <1075> 
;; typedef struct _GTypeInfo GTypeInfo;
(ff:bind-c-typedef _GTypeInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeInfo _GTypeInfo)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:103 <1076> 
;; typedef struct _GTypeFundamentalInfo GTypeFundamentalInfo;
(ff:bind-c-typedef _GTypeFundamentalInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeFundamentalInfo _GTypeFundamentalInfo)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:104 <1077> 
;; typedef struct _GInterfaceInfo GInterfaceInfo;
(ff:bind-c-typedef _GInterfaceInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GInterfaceInfo _GInterfaceInfo)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:105 <1078> 
;; typedef struct _GTypeValueTable GTypeValueTable;
(ff:bind-c-typedef _GTypeValueTable
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeValueTable _GTypeValueTable)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:106 <1079> 
;; typedef struct _GTypeQuery GTypeQuery;
(ff:bind-c-typedef _GTypeQuery
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeQuery _GTypeQuery)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:111 <1080> 
;; struct _GTypeClass { GType g_type; };
(ff:bind-c-type _GTypeClass (:struct
  (g_type GType)   ;; GType g_type
  ))   ;; bind-c-type _GTypeClass
(ff:bind-c-typedef GTypeClass _GTypeClass) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:116 <1081> 
;; struct _GTypeInstance { GTypeClass* g_class; };
(ff:bind-c-type _GTypeInstance (:struct
  (g_class (* GTypeClass))   ;; GTypeClass* g_class
  ))   ;; bind-c-type _GTypeInstance
(ff:bind-c-typedef GTypeInstance _GTypeInstance) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:121 <1082> 
;; struct _GTypeInterface { GType g_type; GType g_instance_type; };
(ff:bind-c-type _GTypeInterface (:struct
  (g_type GType)   ;; GType g_type
  (g_instance_type GType)   ;; GType g_instance_type
  ))   ;; bind-c-type _GTypeInterface
(ff:bind-c-typedef GTypeInterface
                   _GTypeInterface) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:127 <1083> 
;; struct _GTypeQuery {
;;         GType type; const gchar* type_name; guint class_size; guint
;;   instance_size;
;;    };
(ff:bind-c-type _GTypeQuery (:struct
  (type GType)   ;; GType type
  (type_name (* gchar))   ;; const gchar* type_name
  (class_size guint)   ;; guint class_size
  (instance_size guint)   ;; guint instance_size
  ))   ;; bind-c-type _GTypeQuery
(ff:bind-c-typedef GTypeQuery _GTypeQuery) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:155 <1084> 
;; typedef enum {
;;         G_TYPE_DEBUG_NONE =  0x000000000, G_TYPE_DEBUG_OBJECTS =
;;   0x000000001
;;    LSHIFT  0x000000000, G_TYPE_DEBUG_SIGNALS =  0x000000001 LSHIFT
;;   0x000000001,
;;              G_TYPE_DEBUG_MASK =  0x000000003 } GTypeDebugFlags;
(ff:bind-c-constant G_TYPE_DEBUG_NONE
                    0) ;;
;;   G_TYPE_DEBUG_NONE =  0x000000000 
(ff:bind-c-constant G_TYPE_DEBUG_OBJECTS
                    1) ;;
;;   G_TYPE_DEBUG_OBJECTS =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_TYPE_DEBUG_SIGNALS
                    2) ;;
;;   G_TYPE_DEBUG_SIGNALS =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_TYPE_DEBUG_MASK
                    3) ;;
;;   G_TYPE_DEBUG_MASK =  0x000000003 
(ff:bind-c-type GTypeDebugFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:165 <1085> 
;; void g_type_init( void);
(ff:bind-c-function g_type_init
     :unconverted-entry-name "g_type_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:166 <1086> 
;; void g_type_init_with_debug_flags( GTypeDebugFlags debug_flags);
(ff:bind-c-function g_type_init_with_debug_flags
     :unconverted-entry-name "g_type_init_with_debug_flags"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypeDebugFlags"))
     :c-arg-names (debug_flags)
     :arguments (GTypeDebugFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:167 <1087> 
;; const gchar* g_type_name( GType type);
(ff:bind-c-function g_type_name
     :unconverted-entry-name "g_type_name"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:168 <1088> 
;; GQuark g_type_qname( GType type);
(ff:bind-c-function g_type_qname
     :unconverted-entry-name "g_type_qname"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:169 <1089> 
;; GType g_type_from_name( const gchar* name);
(ff:bind-c-function g_type_from_name
     :unconverted-entry-name "g_type_from_name"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:170 <1090> 
;; GType g_type_parent( GType type);
(ff:bind-c-function g_type_parent
     :unconverted-entry-name "g_type_parent"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:171 <1091> 
;; guint g_type_depth( GType type);
(ff:bind-c-function g_type_depth
     :unconverted-entry-name "g_type_depth"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:172 <1092> 
;; GType g_type_next_base( GType leaf_type, GType root_type);
(ff:bind-c-function g_type_next_base
     :unconverted-entry-name "g_type_next_base"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("GType") ("GType"))
     :c-arg-names (leaf_type root_type)
     :arguments (GType GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:174 <1093> 
;; gboolean g_type_is_a( GType type, GType is_a_type);
(ff:bind-c-function g_type_is_a
     :unconverted-entry-name "g_type_is_a"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GType") ("GType"))
     :c-arg-names (type is_a_type)
     :arguments (GType GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:176 <1094> 
;; gpointer g_type_class_ref( GType type);
(ff:bind-c-function g_type_class_ref
     :unconverted-entry-name "g_type_class_ref"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:177 <1095> 
;; gpointer g_type_class_peek( GType type);
(ff:bind-c-function g_type_class_peek
     :unconverted-entry-name "g_type_class_peek"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:178 <1096> 
;; void g_type_class_unref( gpointer g_class);
(ff:bind-c-function g_type_class_unref
     :unconverted-entry-name "g_type_class_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (g_class)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:179 <1097> 
;; gpointer g_type_class_peek_parent( gpointer g_class);
(ff:bind-c-function g_type_class_peek_parent
     :unconverted-entry-name "g_type_class_peek_parent"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer"))
     :c-arg-names (g_class)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:180 <1098> 
;; gpointer g_type_interface_peek( gpointer instance_class, GType
;;   iface_type
;;   );
(ff:bind-c-function g_type_interface_peek
     :unconverted-entry-name "g_type_interface_peek"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer") ("GType"))
     :c-arg-names (instance_class iface_type)
     :arguments (gpointer GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:182 <1099> 
;; gpointer g_type_interface_peek_parent( gpointer g_iface);
(ff:bind-c-function g_type_interface_peek_parent
     :unconverted-entry-name "g_type_interface_peek_parent"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer"))
     :c-arg-names (g_iface)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:185 <1100> 
;; GType* g_type_children( GType type, guint* n_children);
(ff:bind-c-function g_type_children
     :unconverted-entry-name "g_type_children"
     :c-return-type ("GType" "*")
     :return-type (* GType)
     :c-arg-types (("GType") ("guint" "*"))
     :c-arg-names (type n_children)
     :arguments (GType (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:187 <1101> 
;; GType* g_type_interfaces( GType type, guint* n_interfaces);
(ff:bind-c-function g_type_interfaces
     :unconverted-entry-name "g_type_interfaces"
     :c-return-type ("GType" "*")
     :return-type (* GType)
     :c-arg-types (("GType") ("guint" "*"))
     :c-arg-names (type n_interfaces)
     :arguments (GType (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:191 <1102> 
;; void g_type_set_qdata( GType type, GQuark quark, gpointer data);
(ff:bind-c-function g_type_set_qdata
     :unconverted-entry-name "g_type_set_qdata"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GQuark") ("gpointer"))
     :c-arg-names (type quark data)
     :arguments (GType GQuark gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:194 <1103> 
;; gpointer g_type_get_qdata( GType type, GQuark quark);
(ff:bind-c-function g_type_get_qdata
     :unconverted-entry-name "g_type_get_qdata"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GType") ("GQuark"))
     :c-arg-names (type quark)
     :arguments (GType GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:196 <1104> 
;; void g_type_query( GType type, GTypeQuery* query);
(ff:bind-c-function g_type_query
     :unconverted-entry-name "g_type_query"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GTypeQuery" "*"))
     :c-arg-names (type query)
     :arguments (GType (* GTypeQuery))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:201 <1105> 
;; typedef void(* GBaseInitFunc)( gpointer g_class);
(ff:bind-c-type GBaseInitFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:202 <1106> 
;; typedef void(* GBaseFinalizeFunc)( gpointer g_class);
(ff:bind-c-type GBaseFinalizeFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:203 <1107> 
;; typedef void(* GClassInitFunc)( gpointer g_class, gpointer class_data);
(ff:bind-c-type GClassInitFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:205 <1108> 
;; typedef void(* GClassFinalizeFunc)( gpointer g_class, gpointer
;;   class_data
;;   );
(ff:bind-c-type GClassFinalizeFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:207 <1109> 
;; typedef void(* GInstanceInitFunc)( GTypeInstance* instance, gpointer
;;   g_class
;;   );
(ff:bind-c-type GInstanceInitFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:209 <1110> 
;; typedef void(* GInterfaceInitFunc)( gpointer g_iface, gpointer
;;   iface_data
;;   );
(ff:bind-c-type GInterfaceInitFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:211 <1111> 
;; typedef void(* GInterfaceFinalizeFunc)( gpointer g_iface, gpointer
;;   iface_data
;;   );
(ff:bind-c-type GInterfaceFinalizeFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:213 <1112> 
;; typedef gboolean(* GTypeClassCacheFunc)( gpointer cache_data, GTypeClass
;;   * g_class);
(ff:bind-c-type GTypeClassCacheFunc (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:215 <1113> 
;; typedef enum {
;;         G_TYPE_FLAG_CLASSED =(  0x000000001 LSHIFT  0x000000000),
;;   G_TYPE_FLAG_INSTANTIATABLE
;;    =(  0x000000001 LSHIFT  0x000000001), G_TYPE_FLAG_DERIVABLE =(
;;   0x000000001
;;    LSHIFT  0x000000002), G_TYPE_FLAG_DEEP_DERIVABLE =(  0x000000001
;;   LSHIFT
;;     0x000000003) } GTypeFundamentalFlags;
(ff:bind-c-constant G_TYPE_FLAG_CLASSED
                    1) ;;
;;   G_TYPE_FLAG_CLASSED =(  0x000000001 LSHIFT  0x000000000) 
(ff:bind-c-constant G_TYPE_FLAG_INSTANTIATABLE
                    2) ;;
;;   G_TYPE_FLAG_INSTANTIATABLE =(  0x000000001 LSHIFT  0x000000001) 
(ff:bind-c-constant G_TYPE_FLAG_DERIVABLE
                    4) ;;
;;   G_TYPE_FLAG_DERIVABLE =(  0x000000001 LSHIFT  0x000000002) 
(ff:bind-c-constant G_TYPE_FLAG_DEEP_DERIVABLE
                    8) ;;
;;   G_TYPE_FLAG_DEEP_DERIVABLE =(  0x000000001 LSHIFT  0x000000003) 
(ff:bind-c-type GTypeFundamentalFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:222 <1114> 
;; typedef enum {
;;         G_TYPE_FLAG_ABSTRACT =(  0x000000001 LSHIFT  0x000000004),
;;   G_TYPE_FLAG_VALUE_ABSTRACT
;;    =(  0x000000001 LSHIFT  0x000000005) } GTypeFlags;
(ff:bind-c-constant G_TYPE_FLAG_ABSTRACT
                    16) ;;
;;   G_TYPE_FLAG_ABSTRACT =(  0x000000001 LSHIFT  0x000000004) 
(ff:bind-c-constant G_TYPE_FLAG_VALUE_ABSTRACT
                    32) ;;
;;   G_TYPE_FLAG_VALUE_ABSTRACT =(  0x000000001 LSHIFT  0x000000005) 
(ff:bind-c-type GTypeFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:227 <1115> 
;; struct _GTypeInfo {
;;         guint16 class_size; GBaseInitFunc base_init; GBaseFinalizeFunc
;;   base_finalize;
;;              GClassInitFunc class_init; GClassFinalizeFunc
;;   class_finalize; gconstpointer
;;    class_data; guint16 instance_size; guint16 n_preallocs;
;;   GInstanceInitFunc
;;    instance_init; const GTypeValueTable* value_table; };
(ff:bind-c-type _GTypeInfo (:struct
  (class_size guint16)   ;; guint16 class_size
  (base_init GBaseInitFunc)   ;; GBaseInitFunc base_init
  (base_finalize GBaseFinalizeFunc)   ;; GBaseFinalizeFunc base_finalize
  (class_init GClassInitFunc)   ;; GClassInitFunc class_init
  (class_finalize GClassFinalizeFunc)   ;;
  ;;  GClassFinalizeFunc class_finalize
  (class_data gconstpointer)   ;; gconstpointer class_data
  (instance_size guint16)   ;; guint16 instance_size
  (n_preallocs guint16)   ;; guint16 n_preallocs
  (instance_init GInstanceInitFunc)   ;; GInstanceInitFunc instance_init
  (value_table (* GTypeValueTable))   ;; const GTypeValueTable* value_table
  ))   ;; bind-c-type _GTypeInfo
(ff:bind-c-typedef GTypeInfo _GTypeInfo) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:248 <1116> 
;; struct _GTypeFundamentalInfo { GTypeFundamentalFlags type_flags; };
(ff:bind-c-type _GTypeFundamentalInfo (:struct
  (type_flags GTypeFundamentalFlags)   ;; GTypeFundamentalFlags type_flags
  ))   ;; bind-c-type _GTypeFundamentalInfo
(ff:bind-c-typedef GTypeFundamentalInfo
                   _GTypeFundamentalInfo) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:252 <1117> 
;; struct _GInterfaceInfo {
;;         GInterfaceInitFunc interface_init; GInterfaceFinalizeFunc
;;   interface_finalize;
;;              gpointer interface_data; };
(ff:bind-c-type _GInterfaceInfo (:struct
  (interface_init GInterfaceInitFunc)   ;;
  ;;  GInterfaceInitFunc interface_init
  (interface_finalize GInterfaceFinalizeFunc)   ;;
  ;;  GInterfaceFinalizeFunc interface_finalize
  (interface_data gpointer)   ;; gpointer interface_data
  ))   ;; bind-c-type _GInterfaceInfo
(ff:bind-c-typedef GInterfaceInfo
                   _GInterfaceInfo) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:258 <1118> 
;; struct _GTypeValueTable {
;;         void(* value_init)( GValue* value); void(* value_free)( GValue*
;;   value
;;   ); void(* value_copy)( const GValue* src_value, GValue* dest_value);
;;   gpointer
;;   (* value_peek_pointer)( const GValue* value); gchar* collect_format;
;;   gchar
;;   *(* collect_value)( GValue* value, guint n_collect_values, GTypeCValue
;;   * collect_values, guint collect_flags); gchar* lcopy_format; gchar*(*
;;   lcopy_value
;;   )( const GValue* value, guint n_collect_values, GTypeCValue*
;;   collect_values,
;;              guint collect_flags); };
(ff:bind-c-type _GTypeValueTable (:struct
  (value_init ff:function-pointer)   ;; void(* value_init)( GValue* value)
  (value_free ff:function-pointer)   ;; void(* value_free)( GValue* value)
  (value_copy ff:function-pointer)   ;;
  ;;  void(* value_copy)( const GValue* src_value, GValue* dest_value)
  (value_peek_pointer ff:function-pointer)   ;;
  ;;  gpointer(* value_peek_pointer)( const GValue* value)
  (collect_format (* gchar))   ;; gchar* collect_format
  (collect_value ff:function-pointer)   ;;
  ;;  gchar*(* collect_value)( GValue* value, guint n_collect_values, GTypeCValue
  ;; * collect_values, guint collect_flags)
  (lcopy_format (* gchar))   ;; gchar* lcopy_format
  (lcopy_value ff:function-pointer)   ;;
  ;;  gchar*(* lcopy_value)( const GValue* value, guint n_collect_values, GTypeCValue
  ;; * collect_values, guint collect_flags)
  ))   ;; bind-c-type _GTypeValueTable
(ff:bind-c-typedef GTypeValueTable
                   _GTypeValueTable) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:277 <1119> 
;; GType g_type_register_static( GType parent_type, const gchar* type_name,
;;              const GTypeInfo* info, GTypeFlags flags);
(ff:bind-c-function g_type_register_static
     :unconverted-entry-name "g_type_register_static"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("GType") ("const" "gchar" "*")
                   ("const" "GTypeInfo" "*") ("GTypeFlags"))
     :c-arg-names (parent_type type_name info flags)
     :arguments (GType (* gchar) (* GTypeInfo) GTypeFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:281 <1120> 
;; GType g_type_register_dynamic( GType parent_type, const gchar*
;;   type_name,
;;              GTypePlugin* plugin, GTypeFlags flags);
(ff:bind-c-function g_type_register_dynamic
     :unconverted-entry-name "g_type_register_dynamic"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("GType") ("const" "gchar" "*") ("GTypePlugin" "*")
                   ("GTypeFlags"))
     :c-arg-names (parent_type type_name plugin flags)
     :arguments (GType (* gchar) (* GTypePlugin) GTypeFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:285 <1121> 
;; GType g_type_register_fundamental( GType type_id, const gchar*
;;   type_name,
;;              const GTypeInfo* info, const GTypeFundamentalInfo* finfo,
;;   GTypeFlags flags
;;   );
(ff:bind-c-function g_type_register_fundamental
     :unconverted-entry-name "g_type_register_fundamental"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("GType") ("const" "gchar" "*")
                   ("const" "GTypeInfo" "*")
                   ("const" "GTypeFundamentalInfo" "*") ("GTypeFlags"))
     :c-arg-names (type_id type_name info finfo flags)
     :arguments (GType (* gchar) (* GTypeInfo) (* GTypeFundamentalInfo)
                 GTypeFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:290 <1122> 
;; void g_type_add_interface_static( GType instance_type, GType
;;   interface_type,
;;              const GInterfaceInfo* info);
(ff:bind-c-function g_type_add_interface_static
     :unconverted-entry-name "g_type_add_interface_static"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GType") ("const" "GInterfaceInfo" "*"))
     :c-arg-names (instance_type interface_type info)
     :arguments (GType GType (* GInterfaceInfo))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:293 <1123> 
;; void g_type_add_interface_dynamic( GType instance_type, GType
;;   interface_type,
;;              GTypePlugin* plugin);
(ff:bind-c-function g_type_add_interface_dynamic
     :unconverted-entry-name "g_type_add_interface_dynamic"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GType") ("GTypePlugin" "*"))
     :c-arg-names (instance_type interface_type plugin)
     :arguments (GType GType (* GTypePlugin))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:296 <1124> 
;; void g_type_interface_add_prerequisite( GType interface_type, GType
;;   prerequisite_type
;;   );
(ff:bind-c-function g_type_interface_add_prerequisite
     :unconverted-entry-name "g_type_interface_add_prerequisite"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GType"))
     :c-arg-names (interface_type prerequisite_type)
     :arguments (GType GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:301 <1125> 
;; GTypePlugin* g_type_get_plugin( GType type);
(ff:bind-c-function g_type_get_plugin
     :unconverted-entry-name "g_type_get_plugin"
     :c-return-type ("GTypePlugin" "*")
     :return-type (* GTypePlugin)
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:302 <1126> 
;; GTypePlugin* g_type_interface_get_plugin( GType instance_type, GType
;;   implementation_type
;;   );
(ff:bind-c-function g_type_interface_get_plugin
     :unconverted-entry-name "g_type_interface_get_plugin"
     :c-return-type ("GTypePlugin" "*")
     :return-type (* GTypePlugin)
     :c-arg-types (("GType") ("GType"))
     :c-arg-names (instance_type implementation_type)
     :arguments (GType GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:304 <1127> 
;; GType g_type_fundamental_next( void);
(ff:bind-c-function g_type_fundamental_next
     :unconverted-entry-name "g_type_fundamental_next"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:305 <1128> 
;; GType g_type_fundamental( GType type_id);
(ff:bind-c-function g_type_fundamental
     :unconverted-entry-name "g_type_fundamental"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("GType"))
     :c-arg-names (type_id)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:306 <1129> 
;; GTypeInstance* g_type_create_instance( GType type);
(ff:bind-c-function g_type_create_instance
     :unconverted-entry-name "g_type_create_instance"
     :c-return-type ("GTypeInstance" "*")
     :return-type (* GTypeInstance)
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:307 <1130> 
;; void g_type_free_instance( GTypeInstance* instance);
(ff:bind-c-function g_type_free_instance
     :unconverted-entry-name "g_type_free_instance"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypeInstance" "*"))
     :c-arg-names (instance)
     :arguments ((* GTypeInstance))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:308 <1131> 
;; void g_type_add_class_cache_func( gpointer cache_data,
;;   GTypeClassCacheFunc
;;    cache_func);
(ff:bind-c-function g_type_add_class_cache_func
     :unconverted-entry-name "g_type_add_class_cache_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("GTypeClassCacheFunc"))
     :c-arg-names (cache_data cache_func)
     :arguments (gpointer GTypeClassCacheFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:310 <1132> 
;; void g_type_remove_class_cache_func( gpointer cache_data,
;;   GTypeClassCacheFunc
;;    cache_func);
(ff:bind-c-function g_type_remove_class_cache_func
     :unconverted-entry-name "g_type_remove_class_cache_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("GTypeClassCacheFunc"))
     :c-arg-names (cache_data cache_func)
     :arguments (gpointer GTypeClassCacheFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:312 <1133> 
;; void g_type_class_unref_uncached( gpointer g_class);
(ff:bind-c-function g_type_class_unref_uncached
     :unconverted-entry-name "g_type_class_unref_uncached"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (g_class)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:313 <1134> 
;; GTypeValueTable* g_type_value_table_peek( GType type);
(ff:bind-c-function g_type_value_table_peek
     :unconverted-entry-name "g_type_value_table_peek"
     :c-return-type ("GTypeValueTable" "*")
     :return-type (* GTypeValueTable)
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:317 <1135> 
;; gboolean g_type_check_instance( GTypeInstance* instance);
(ff:bind-c-function g_type_check_instance
     :unconverted-entry-name "g_type_check_instance"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GTypeInstance" "*"))
     :c-arg-names (instance)
     :arguments ((* GTypeInstance))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:318 <1136> 
;; GTypeInstance* g_type_check_instance_cast( GTypeInstance* instance,
;;   GType
;;    iface_type);
(ff:bind-c-function g_type_check_instance_cast_f; bug15263
     :unconverted-entry-name "g_type_check_instance_cast"
     :c-return-type ("GTypeInstance" "*")
     :return-type (* GTypeInstance)
     :c-arg-types (("GTypeInstance" "*") ("GType"))
     :c-arg-names (instance iface_type)
     :arguments ((* GTypeInstance) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:320 <1137> 
;; gboolean g_type_check_instance_is_a( GTypeInstance* instance, GType
;;   iface_type
;;   );
(ff:bind-c-function g_type_check_instance_is_a
     :unconverted-entry-name "g_type_check_instance_is_a"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GTypeInstance" "*") ("GType"))
     :c-arg-names (instance iface_type)
     :arguments ((* GTypeInstance) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:322 <1138> 
;; GTypeClass* g_type_check_class_cast( GTypeClass* g_class, GType
;;   is_a_type
;;   );
(ff:bind-c-function g_type_check_class_cast_f; bug15263
     :unconverted-entry-name "g_type_check_class_cast"
     :c-return-type ("GTypeClass" "*")
     :return-type (* GTypeClass)
     :c-arg-types (("GTypeClass" "*") ("GType"))
     :c-arg-names (g_class is_a_type)
     :arguments ((* GTypeClass) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:324 <1139> 
;; gboolean g_type_check_class_is_a( GTypeClass* g_class, GType is_a_type);
(ff:bind-c-function g_type_check_class_is_a
     :unconverted-entry-name "g_type_check_class_is_a"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GTypeClass" "*") ("GType"))
     :c-arg-names (g_class is_a_type)
     :arguments ((* GTypeClass) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:326 <1140> 
;; gboolean g_type_check_is_value_type( GType type);
(ff:bind-c-function g_type_check_is_value_type
     :unconverted-entry-name "g_type_check_is_value_type"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GType"))
     :c-arg-names (type)
     :arguments (GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:327 <1141> 
;; gboolean g_type_check_value( GValue* value);
(ff:bind-c-function g_type_check_value
     :unconverted-entry-name "g_type_check_value"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:328 <1142> 
;; gboolean g_type_check_value_holds( GValue* value, GType type);
(ff:bind-c-function g_type_check_value_holds
     :unconverted-entry-name "g_type_check_value_holds"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GValue" "*") ("GType"))
     :c-arg-names (value type)
     :arguments ((* GValue) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:330 <1143> 
;; gboolean g_type_test_flags( GType type, guint flags);
(ff:bind-c-function g_type_test_flags
     :unconverted-entry-name "g_type_test_flags"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GType") ("guint"))
     :c-arg-names (type flags)
     :arguments (GType guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:335 <1144> 
;; const gchar* g_type_name_from_instance( GTypeInstance* instance);
(ff:bind-c-function g_type_name_from_instance
     :unconverted-entry-name "g_type_name_from_instance"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GTypeInstance" "*"))
     :c-arg-names (instance)
     :arguments ((* GTypeInstance))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:336 <1145> 
;; const gchar* g_type_name_from_class( GTypeClass* g_class);
(ff:bind-c-function g_type_name_from_class
     :unconverted-entry-name "g_type_name_from_class"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GTypeClass" "*"))
     :c-arg-names (g_class)
     :arguments ((* GTypeClass))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtype.h:376 <1146> 
;; extern GTypeDebugFlags _g_type_debug_flags;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "_g_type_debug_flags"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:36 <1147> 
;; typedef gpointer(* GBoxedCopyFunc)( gpointer boxed);
(ff:bind-c-type GBoxedCopyFunc (* gpointer))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:37 <1148> 
;; typedef void(* GBoxedFreeFunc)( gpointer boxed);
(ff:bind-c-type GBoxedFreeFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:41 <1149> 
;; gpointer g_boxed_copy( GType boxed_type, gconstpointer src_boxed);
(ff:bind-c-function g_boxed_copy
     :unconverted-entry-name "g_boxed_copy"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GType") ("gconstpointer"))
     :c-arg-names (boxed_type src_boxed)
     :arguments (GType gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:43 <1150> 
;; void g_boxed_free( GType boxed_type, gpointer boxed);
(ff:bind-c-function g_boxed_free
     :unconverted-entry-name "g_boxed_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("gpointer"))
     :c-arg-names (boxed_type boxed)
     :arguments (GType gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:45 <1151> 
;; void g_value_set_boxed( GValue* value, gconstpointer v_boxed);
(ff:bind-c-function g_value_set_boxed
     :unconverted-entry-name "g_value_set_boxed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gconstpointer"))
     :c-arg-names (value v_boxed)
     :arguments ((* GValue) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:47 <1152> 
;; void g_value_set_static_boxed( GValue* value, gconstpointer v_boxed);
(ff:bind-c-function g_value_set_static_boxed
     :unconverted-entry-name "g_value_set_static_boxed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gconstpointer"))
     :c-arg-names (value v_boxed)
     :arguments ((* GValue) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:49 <1153> 
;; gpointer g_value_get_boxed( const GValue* value);
(ff:bind-c-function g_value_get_boxed
     :unconverted-entry-name "g_value_get_boxed"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:50 <1154> 
;; gpointer g_value_dup_boxed( const GValue* value);
(ff:bind-c-function g_value_dup_boxed
     :unconverted-entry-name "g_value_dup_boxed"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:54 <1155> 
;; GType g_boxed_type_register_static( const gchar* name, GBoxedCopyFunc
;;    boxed_copy, GBoxedFreeFunc boxed_free);
(ff:bind-c-function g_boxed_type_register_static
     :unconverted-entry-name "g_boxed_type_register_static"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("const" "gchar" "*") ("GBoxedCopyFunc")
                   ("GBoxedFreeFunc"))
     :c-arg-names (name boxed_copy boxed_free)
     :arguments ((* gchar) GBoxedCopyFunc GBoxedFreeFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:67 <1156> 
;; void g_value_set_boxed_take_ownership( GValue* value, gconstpointer
;;   v_boxed
;;   );
(ff:bind-c-function g_value_set_boxed_take_ownership
     :unconverted-entry-name "g_value_set_boxed_take_ownership"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gconstpointer"))
     :c-arg-names (value v_boxed)
     :arguments ((* GValue) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:69 <1157> 
;; GType g_closure_get_type( void);
(ff:bind-c-function g_closure_get_type
     :unconverted-entry-name "g_closure_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:70 <1158> 
;; GType g_value_get_type( void);
(ff:bind-c-function g_value_get_type
     :unconverted-entry-name "g_value_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:71 <1159> 
;; GType g_value_array_get_type( void);
(ff:bind-c-function g_value_array_get_type
     :unconverted-entry-name "g_value_array_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gboxed.h:72 <1160> 
;; GType g_gstring_get_type( void);
(ff:bind-c-function g_gstring_get_type
     :unconverted-entry-name "g_gstring_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:46 <1161> 
;; typedef struct _GEnumClass GEnumClass;
(ff:bind-c-typedef _GEnumClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GEnumClass _GEnumClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:47 <1162> 
;; typedef struct _GFlagsClass GFlagsClass;
(ff:bind-c-typedef _GFlagsClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GFlagsClass _GFlagsClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:48 <1163> 
;; typedef struct _GEnumValue GEnumValue;
(ff:bind-c-typedef _GEnumValue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GEnumValue _GEnumValue)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:49 <1164> 
;; typedef struct _GFlagsValue GFlagsValue;
(ff:bind-c-typedef _GFlagsValue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GFlagsValue _GFlagsValue)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:50 <1165> 
;; struct _GEnumClass {
;;         GTypeClass g_type_class; gint minimum; gint maximum; guint
;;   n_values; GEnumValue
;;   * values; };
(ff:bind-c-type _GEnumClass (:struct
  (g_type_class GTypeClass)   ;; GTypeClass g_type_class
  (minimum gint)   ;; gint minimum
  (maximum gint)   ;; gint maximum
  (n_values guint)   ;; guint n_values
  (values (* GEnumValue))   ;; GEnumValue* values
  ))   ;; bind-c-type _GEnumClass
(ff:bind-c-typedef GEnumClass _GEnumClass) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:59 <1166> 
;; struct _GFlagsClass {
;;         GTypeClass g_type_class; guint mask; guint n_values;
;;   GFlagsValue* values;
;;    };
(ff:bind-c-type _GFlagsClass (:struct
  (g_type_class GTypeClass)   ;; GTypeClass g_type_class
  (mask guint)   ;; guint mask
  (n_values guint)   ;; guint n_values
  (values (* GFlagsValue))   ;; GFlagsValue* values
  ))   ;; bind-c-type _GFlagsClass
(ff:bind-c-typedef GFlagsClass _GFlagsClass) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:67 <1167> 
;; struct _GEnumValue { gint value; gchar* value_name; gchar* value_nick;
;;   };
(ff:bind-c-type _GEnumValue (:struct
  (value gint)   ;; gint value
  (value_name (* gchar))   ;; gchar* value_name
  (value_nick (* gchar))   ;; gchar* value_nick
  ))   ;; bind-c-type _GEnumValue
(ff:bind-c-typedef GEnumValue _GEnumValue) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:73 <1168> 
;; struct _GFlagsValue {
;;         guint value; gchar* value_name; gchar* value_nick; };
(ff:bind-c-type _GFlagsValue (:struct
  (value guint)   ;; guint value
  (value_name (* gchar))   ;; gchar* value_name
  (value_nick (* gchar))   ;; gchar* value_nick
  ))   ;; bind-c-type _GFlagsValue
(ff:bind-c-typedef GFlagsValue _GFlagsValue) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:82 <1169> 
;; GEnumValue* g_enum_get_value( GEnumClass* enum_class, gint value);
(ff:bind-c-function g_enum_get_value
     :unconverted-entry-name "g_enum_get_value"
     :c-return-type ("GEnumValue" "*")
     :return-type (* GEnumValue)
     :c-arg-types (("GEnumClass" "*") ("gint"))
     :c-arg-names (enum_class value)
     :arguments ((* GEnumClass) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:84 <1170> 
;; GEnumValue* g_enum_get_value_by_name( GEnumClass* enum_class, const
;;   gchar
;;   * name);
(ff:bind-c-function g_enum_get_value_by_name
     :unconverted-entry-name "g_enum_get_value_by_name"
     :c-return-type ("GEnumValue" "*")
     :return-type (* GEnumValue)
     :c-arg-types (("GEnumClass" "*") ("const" "gchar" "*"))
     :c-arg-names (enum_class name)
     :arguments ((* GEnumClass) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:86 <1171> 
;; GEnumValue* g_enum_get_value_by_nick( GEnumClass* enum_class, const
;;   gchar
;;   * nick);
(ff:bind-c-function g_enum_get_value_by_nick
     :unconverted-entry-name "g_enum_get_value_by_nick"
     :c-return-type ("GEnumValue" "*")
     :return-type (* GEnumValue)
     :c-arg-types (("GEnumClass" "*") ("const" "gchar" "*"))
     :c-arg-names (enum_class nick)
     :arguments ((* GEnumClass) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:88 <1172> 
;; GFlagsValue* g_flags_get_first_value( GFlagsClass* flags_class, guint
;;    value);
(ff:bind-c-function g_flags_get_first_value
     :unconverted-entry-name "g_flags_get_first_value"
     :c-return-type ("GFlagsValue" "*")
     :return-type (* GFlagsValue)
     :c-arg-types (("GFlagsClass" "*") ("guint"))
     :c-arg-names (flags_class value)
     :arguments ((* GFlagsClass) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:90 <1173> 
;; GFlagsValue* g_flags_get_value_by_name( GFlagsClass* flags_class, const
;;    gchar* name);
(ff:bind-c-function g_flags_get_value_by_name
     :unconverted-entry-name "g_flags_get_value_by_name"
     :c-return-type ("GFlagsValue" "*")
     :return-type (* GFlagsValue)
     :c-arg-types (("GFlagsClass" "*") ("const" "gchar" "*"))
     :c-arg-names (flags_class name)
     :arguments ((* GFlagsClass) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:92 <1174> 
;; GFlagsValue* g_flags_get_value_by_nick( GFlagsClass* flags_class, const
;;    gchar* nick);
(ff:bind-c-function g_flags_get_value_by_nick
     :unconverted-entry-name "g_flags_get_value_by_nick"
     :c-return-type ("GFlagsValue" "*")
     :return-type (* GFlagsValue)
     :c-arg-types (("GFlagsClass" "*") ("const" "gchar" "*"))
     :c-arg-names (flags_class nick)
     :arguments ((* GFlagsClass) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:94 <1175> 
;; void g_value_set_enum( GValue* value, gint v_enum);
(ff:bind-c-function g_value_set_enum
     :unconverted-entry-name "g_value_set_enum"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gint"))
     :c-arg-names (value v_enum)
     :arguments ((* GValue) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:96 <1176> 
;; gint g_value_get_enum( const GValue* value);
(ff:bind-c-function g_value_get_enum
     :unconverted-entry-name "g_value_get_enum"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:97 <1177> 
;; void g_value_set_flags( GValue* value, guint v_flags);
(ff:bind-c-function g_value_set_flags
     :unconverted-entry-name "g_value_set_flags"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("guint"))
     :c-arg-names (value v_flags)
     :arguments ((* GValue) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:99 <1178> 
;; guint g_value_get_flags( const GValue* value);
(ff:bind-c-function g_value_get_flags
     :unconverted-entry-name "g_value_get_flags"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:107 <1179> 
;; GType g_enum_register_static( const gchar* name, const GEnumValue*
;;   const_static_values
;;   );
(ff:bind-c-function g_enum_register_static
     :unconverted-entry-name "g_enum_register_static"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("const" "gchar" "*") ("const" "GEnumValue" "*"))
     :c-arg-names (name const_static_values)
     :arguments ((* gchar) (* GEnumValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:109 <1180> 
;; GType g_flags_register_static( const gchar* name, const GFlagsValue*
;;   const_static_values
;;   );
(ff:bind-c-function g_flags_register_static
     :unconverted-entry-name "g_flags_register_static"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("const" "gchar" "*") ("const" "GFlagsValue" "*"))
     :c-arg-names (name const_static_values)
     :arguments ((* gchar) (* GFlagsValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:114 <1181> 
;; void g_enum_complete_type_info( GType g_enum_type, GTypeInfo* info,
;;   const
;;    GEnumValue* const_values);
(ff:bind-c-function g_enum_complete_type_info
     :unconverted-entry-name "g_enum_complete_type_info"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GTypeInfo" "*")
                   ("const" "GEnumValue" "*"))
     :c-arg-names (g_enum_type info const_values)
     :arguments (GType (* GTypeInfo) (* GEnumValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/genums.h:117 <1182> 
;; void g_flags_complete_type_info( GType g_flags_type, GTypeInfo* info,
;;              const GFlagsValue* const_values);
(ff:bind-c-function g_flags_complete_type_info
     :unconverted-entry-name "g_flags_complete_type_info"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GTypeInfo" "*")
                   ("const" "GFlagsValue" "*"))
     :c-arg-names (g_flags_type info const_values)
     :arguments (GType (* GTypeInfo) (* GFlagsValue))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:41 <1183> 
;; typedef void(* GValueTransform)( const GValue* src_value, GValue*
;;   dest_value
;;   );
(ff:bind-c-type GValueTransform (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:43 <1184> 
;; struct _GValue {
;;         GType g_type; union {
;;         gint v_int; guint v_uint; glong v_long; gulong v_ulong; gint64
;;   v_int64;
;;              guint64 v_uint64; gfloat v_float; gdouble v_double;
;;   gpointer v_pointer;
;;    } data[  0x000000002]; };
(ff:bind-c-type _GValue (:struct
  (g_type GType)   ;; GType g_type
  (data (:array (:union   ;; union{} data[  0x000000002]
    (v_int gint)   ;; gint v_int
    (v_uint guint)   ;; guint v_uint
    (v_long glong)   ;; glong v_long
    (v_ulong gulong)   ;; gulong v_ulong
    (v_int64 gint64)   ;; gint64 v_int64
    (v_uint64 guint64)   ;; guint64 v_uint64
    (v_float gfloat)   ;; gfloat v_float
    (v_double gdouble)   ;; gdouble v_double
    (v_pointer gpointer)   ;; gpointer v_pointer
    ) 2))  ;; slot data
  ))   ;; bind-c-type _GValue
(ff:bind-c-typedef GValue _GValue) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:64 <1185> 
;; GValue* g_value_init( GValue* value, GType g_type);
(ff:bind-c-function g_value_init
     :unconverted-entry-name "g_value_init"
     :c-return-type ("GValue" "*")
     :return-type (* GValue)
     :c-arg-types (("GValue" "*") ("GType"))
     :c-arg-names (value g_type)
     :arguments ((* GValue) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:66 <1186> 
;; void g_value_copy( const GValue* src_value, GValue* dest_value);
(ff:bind-c-function g_value_copy
     :unconverted-entry-name "g_value_copy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GValue" "*") ("GValue" "*"))
     :c-arg-names (src_value dest_value)
     :arguments ((* GValue) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:68 <1187> 
;; GValue* g_value_reset( GValue* value);
(ff:bind-c-function g_value_reset
     :unconverted-entry-name "g_value_reset"
     :c-return-type ("GValue" "*")
     :return-type (* GValue)
     :c-arg-types (("GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:69 <1188> 
;; void g_value_unset( GValue* value);
(ff:bind-c-function g_value_unset
     :unconverted-entry-name "g_value_unset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:70 <1189> 
;; void g_value_set_instance( GValue* value, gpointer instance);
(ff:bind-c-function g_value_set_instance
     :unconverted-entry-name "g_value_set_instance"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gpointer"))
     :c-arg-names (value instance)
     :arguments ((* GValue) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:75 <1190> 
;; gboolean g_value_fits_pointer( const GValue* value);
(ff:bind-c-function g_value_fits_pointer
     :unconverted-entry-name "g_value_fits_pointer"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:76 <1191> 
;; gpointer g_value_peek_pointer( const GValue* value);
(ff:bind-c-function g_value_peek_pointer
     :unconverted-entry-name "g_value_peek_pointer"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:80 <1192> 
;; gboolean g_value_type_compatible( GType src_type, GType dest_type);
(ff:bind-c-function g_value_type_compatible
     :unconverted-entry-name "g_value_type_compatible"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GType") ("GType"))
     :c-arg-names (src_type dest_type)
     :arguments (GType GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:82 <1193> 
;; gboolean g_value_type_transformable( GType src_type, GType dest_type);
(ff:bind-c-function g_value_type_transformable
     :unconverted-entry-name "g_value_type_transformable"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GType") ("GType"))
     :c-arg-names (src_type dest_type)
     :arguments (GType GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:84 <1194> 
;; gboolean g_value_transform( const GValue* src_value, GValue*
;;   dest_value);
(ff:bind-c-function g_value_transform
     :unconverted-entry-name "g_value_transform"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GValue" "*") ("GValue" "*"))
     :c-arg-names (src_value dest_value)
     :arguments ((* GValue) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvalue.h:86 <1195> 
;; void g_value_register_transform_func( GType src_type, GType dest_type,
;;              GValueTransform transform_func);
(ff:bind-c-function g_value_register_transform_func
     :unconverted-entry-name "g_value_register_transform_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType") ("GType") ("GValueTransform"))
     :c-arg-names (src_type dest_type transform_func)
     :arguments (GType GType GValueTransform)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:49 <1196> 
;; typedef enum {
;;         G_PARAM_READABLE =  0x000000001 LSHIFT  0x000000000,
;;   G_PARAM_WRITABLE
;;    =  0x000000001 LSHIFT  0x000000001, G_PARAM_CONSTRUCT =  0x000000001
;;   LSHIFT
;;     0x000000002, G_PARAM_CONSTRUCT_ONLY =  0x000000001 LSHIFT
;;   0x000000003,
;;              G_PARAM_LAX_VALIDATION =  0x000000001 LSHIFT  0x000000004,
;;   G_PARAM_PRIVATE
;;    =  0x000000001 LSHIFT  0x000000005 } GParamFlags;
(ff:bind-c-constant G_PARAM_READABLE
                    1) ;;
;;   G_PARAM_READABLE =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_PARAM_WRITABLE
                    2) ;;
;;   G_PARAM_WRITABLE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_PARAM_CONSTRUCT
                    4) ;;
;;   G_PARAM_CONSTRUCT =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_PARAM_CONSTRUCT_ONLY
                    8) ;;
;;   G_PARAM_CONSTRUCT_ONLY =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_PARAM_LAX_VALIDATION
                    16) ;;
;;   G_PARAM_LAX_VALIDATION =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_PARAM_PRIVATE
                    32) ;;
;;   G_PARAM_PRIVATE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-type GParamFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:65 <1197> 
;; typedef struct _GParamSpec GParamSpec;
(ff:bind-c-typedef _GParamSpec
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpec _GParamSpec)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:66 <1198> 
;; typedef struct _GParamSpecClass GParamSpecClass;
(ff:bind-c-typedef _GParamSpecClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecClass _GParamSpecClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:67 <1199> 
;; typedef struct _GParameter GParameter;
(ff:bind-c-typedef _GParameter
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParameter _GParameter)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:68 <1200> 
;; typedef struct _GParamSpecPool GParamSpecPool;
(ff:bind-c-typedef _GParamSpecPool
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecPool _GParamSpecPool)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:69 <1201> 
;; struct _GParamSpec {
;;         GTypeInstance g_type_instance; gchar* name; GParamFlags flags;
;;   GType value_type;
;;              GType owner_type; gchar* _nick; gchar* _blurb; GData*
;;   qdata; guint ref_count;
;;              guint param_id; };
(ff:bind-c-type _GParamSpec (:struct
  (g_type_instance GTypeInstance)   ;; GTypeInstance g_type_instance
  (name (* gchar))   ;; gchar* name
  (flags GParamFlags)   ;; GParamFlags flags
  (value_type GType)   ;; GType value_type
  (owner_type GType)   ;; GType owner_type
  (_nick (* gchar))   ;; gchar* _nick
  (_blurb (* gchar))   ;; gchar* _blurb
  (qdata (* GData))   ;; GData* qdata
  (ref_count guint)   ;; guint ref_count
  (param_id guint)   ;; guint param_id
  ))   ;; bind-c-type _GParamSpec
(ff:bind-c-typedef GParamSpec _GParamSpec) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:85 <1202> 
;; struct _GParamSpecClass {
;;         GTypeClass g_type_class; GType value_type; void(* finalize)(
;;   GParamSpec
;;   * pspec); void(* value_set_default)( GParamSpec* pspec, GValue*
;;   value);
;;              gboolean(* value_validate)( GParamSpec* pspec, GValue*
;;   value); gint(*
;;    values_cmp)( GParamSpec* pspec, const GValue* value1, const GValue*
;;   value2
;;   ); gpointer dummy[  0x000000004]; };
(ff:bind-c-type _GParamSpecClass (:struct
  (g_type_class GTypeClass)   ;; GTypeClass g_type_class
  (value_type GType)   ;; GType value_type
  (finalize ff:function-pointer)   ;; void(* finalize)( GParamSpec* pspec)
  (value_set_default ff:function-pointer)   ;;
  ;;  void(* value_set_default)( GParamSpec* pspec, GValue* value)
  (value_validate ff:function-pointer)   ;;
  ;;  gboolean(* value_validate)( GParamSpec* pspec, GValue* value)
  (values_cmp ff:function-pointer)   ;;
  ;;  gint(* values_cmp)( GParamSpec* pspec, const GValue* value1, const GValue*
  ;;  value2)
  (dummy (:array gpointer 4))   ;; gpointer dummy[  0x000000004]
  ))   ;; bind-c-type _GParamSpecClass
(ff:bind-c-typedef GParamSpecClass
                   _GParamSpecClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:103 <1203> 
;; struct _GParameter { const gchar* name; GValue value; };
(ff:bind-c-type _GParameter (:struct
  (name (* gchar))   ;; const gchar* name
  (value GValue)   ;; GValue value
  ))   ;; bind-c-type _GParameter
(ff:bind-c-typedef GParameter _GParameter) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:111 <1204> 
;; GParamSpec* g_param_spec_ref( GParamSpec* pspec);
(ff:bind-c-function g_param_spec_ref
     :unconverted-entry-name "g_param_spec_ref"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("GParamSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:112 <1205> 
;; void g_param_spec_unref( GParamSpec* pspec);
(ff:bind-c-function g_param_spec_unref
     :unconverted-entry-name "g_param_spec_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GParamSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:113 <1206> 
;; void g_param_spec_sink( GParamSpec* pspec);
(ff:bind-c-function g_param_spec_sink
     :unconverted-entry-name "g_param_spec_sink"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GParamSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:114 <1207> 
;; gpointer g_param_spec_get_qdata( GParamSpec* pspec, GQuark quark);
(ff:bind-c-function g_param_spec_get_qdata
     :unconverted-entry-name "g_param_spec_get_qdata"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GParamSpec" "*") ("GQuark"))
     :c-arg-names (pspec quark)
     :arguments ((* GParamSpec) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:116 <1208> 
;; void g_param_spec_set_qdata( GParamSpec* pspec, GQuark quark, gpointer
;;    data);
(ff:bind-c-function g_param_spec_set_qdata
     :unconverted-entry-name "g_param_spec_set_qdata"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GParamSpec" "*") ("GQuark") ("gpointer"))
     :c-arg-names (pspec quark data)
     :arguments ((* GParamSpec) GQuark gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:119 <1209> 
;; void g_param_spec_set_qdata_full( GParamSpec* pspec, GQuark quark,
;;   gpointer
;;    data, GDestroyNotify destroy);
(ff:bind-c-function g_param_spec_set_qdata_full
     :unconverted-entry-name "g_param_spec_set_qdata_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GParamSpec" "*") ("GQuark") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (pspec quark data destroy)
     :arguments ((* GParamSpec) GQuark gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:123 <1210> 
;; gpointer g_param_spec_steal_qdata( GParamSpec* pspec, GQuark quark);
(ff:bind-c-function g_param_spec_steal_qdata
     :unconverted-entry-name "g_param_spec_steal_qdata"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GParamSpec" "*") ("GQuark"))
     :c-arg-names (pspec quark)
     :arguments ((* GParamSpec) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:125 <1211> 
;; void g_param_value_set_default( GParamSpec* pspec, GValue* value);
(ff:bind-c-function g_param_value_set_default
     :unconverted-entry-name "g_param_value_set_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GParamSpec" "*") ("GValue" "*"))
     :c-arg-names (pspec value)
     :arguments ((* GParamSpec) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:127 <1212> 
;; gboolean g_param_value_defaults( GParamSpec* pspec, GValue* value);
(ff:bind-c-function g_param_value_defaults
     :unconverted-entry-name "g_param_value_defaults"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GParamSpec" "*") ("GValue" "*"))
     :c-arg-names (pspec value)
     :arguments ((* GParamSpec) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:129 <1213> 
;; gboolean g_param_value_validate( GParamSpec* pspec, GValue* value);
(ff:bind-c-function g_param_value_validate
     :unconverted-entry-name "g_param_value_validate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GParamSpec" "*") ("GValue" "*"))
     :c-arg-names (pspec value)
     :arguments ((* GParamSpec) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:131 <1214> 
;; gboolean g_param_value_convert( GParamSpec* pspec, const GValue*
;;   src_value,
;;              GValue* dest_value, gboolean strict_validation);
(ff:bind-c-function g_param_value_convert
     :unconverted-entry-name "g_param_value_convert"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GParamSpec" "*") ("const" "GValue" "*")
                   ("GValue" "*") ("gboolean"))
     :c-arg-names (pspec src_value dest_value strict_validation)
     :arguments ((* GParamSpec) (* GValue) (* GValue) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:135 <1215> 
;; gint g_param_values_cmp( GParamSpec* pspec, const GValue* value1, const
;;    GValue* value2);
(ff:bind-c-function g_param_values_cmp
     :unconverted-entry-name "g_param_values_cmp"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GParamSpec" "*") ("const" "GValue" "*")
                   ("const" "GValue" "*"))
     :c-arg-names (pspec value1 value2)
     :arguments ((* GParamSpec) (* GValue) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:138 <1216> 
;; const gchar* g_param_spec_get_name( GParamSpec* pspec);
(ff:bind-c-function g_param_spec_get_name
     :unconverted-entry-name "g_param_spec_get_name"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GParamSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:139 <1217> 
;; const gchar* g_param_spec_get_nick( GParamSpec* pspec);
(ff:bind-c-function g_param_spec_get_nick
     :unconverted-entry-name "g_param_spec_get_nick"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GParamSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:140 <1218> 
;; const gchar* g_param_spec_get_blurb( GParamSpec* pspec);
(ff:bind-c-function g_param_spec_get_blurb
     :unconverted-entry-name "g_param_spec_get_blurb"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GParamSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:141 <1219> 
;; void g_value_set_param( GValue* value, GParamSpec* param);
(ff:bind-c-function g_value_set_param
     :unconverted-entry-name "g_value_set_param"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("GParamSpec" "*"))
     :c-arg-names (value param)
     :arguments ((* GValue) (* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:143 <1220> 
;; GParamSpec* g_value_get_param( const GValue* value);
(ff:bind-c-function g_value_get_param
     :unconverted-entry-name "g_value_get_param"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:144 <1221> 
;; GParamSpec* g_value_dup_param( const GValue* value);
(ff:bind-c-function g_value_dup_param
     :unconverted-entry-name "g_value_dup_param"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:148 <1222> 
;; void g_value_set_param_take_ownership( GValue* value, GParamSpec*
;;   param);
(ff:bind-c-function g_value_set_param_take_ownership
     :unconverted-entry-name "g_value_set_param_take_ownership"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("GParamSpec" "*"))
     :c-arg-names (value param)
     :arguments ((* GValue) (* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:153 <1223> 
;; typedef struct _GParamSpecTypeInfo GParamSpecTypeInfo;
(ff:bind-c-typedef _GParamSpecTypeInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecTypeInfo _GParamSpecTypeInfo)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:154 <1224> 
;; struct _GParamSpecTypeInfo {
;;         guint16 instance_size; guint16 n_preallocs; void(*
;;   instance_init)( GParamSpec
;;   * pspec); GType value_type; void(* finalize)( GParamSpec* pspec); void
;;   (* value_set_default)( GParamSpec* pspec, GValue* value); gboolean(*
;;   value_validate
;;   )( GParamSpec* pspec, GValue* value); gint(* values_cmp)( GParamSpec*
;;   pspec,
;;              const GValue* value1, const GValue* value2); };
(ff:bind-c-type _GParamSpecTypeInfo (:struct
  (instance_size guint16)   ;; guint16 instance_size
  (n_preallocs guint16)   ;; guint16 n_preallocs
  (instance_init ff:function-pointer)   ;;
  ;;  void(* instance_init)( GParamSpec* pspec)
  (value_type GType)   ;; GType value_type
  (finalize ff:function-pointer)   ;; void(* finalize)( GParamSpec* pspec)
  (value_set_default ff:function-pointer)   ;;
  ;;  void(* value_set_default)( GParamSpec* pspec, GValue* value)
  (value_validate ff:function-pointer)   ;;
  ;;  gboolean(* value_validate)( GParamSpec* pspec, GValue* value)
  (values_cmp ff:function-pointer)   ;;
  ;;  gint(* values_cmp)( GParamSpec* pspec, const GValue* value1, const GValue*
  ;;  value2)
  ))   ;; bind-c-type _GParamSpecTypeInfo
(ff:bind-c-typedef GParamSpecTypeInfo
                   _GParamSpecTypeInfo) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:172 <1225> 
;; GType g_param_type_register_static( const gchar* name, const
;;   GParamSpecTypeInfo
;;   * pspec_info);
(ff:bind-c-function g_param_type_register_static
     :unconverted-entry-name "g_param_type_register_static"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("const" "gchar" "*")
                   ("const" "GParamSpecTypeInfo" "*"))
     :c-arg-names (name pspec_info)
     :arguments ((* gchar) (* GParamSpecTypeInfo))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:176 <1226> 
;; GType _g_param_type_register_static_constant( const gchar* name, const
;;    GParamSpecTypeInfo* pspec_info, GType opt_type);
(ff:bind-c-function _g_param_type_register_static_constant
     :unconverted-entry-name "_g_param_type_register_static_constant"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("const" "gchar" "*")
                   ("const" "GParamSpecTypeInfo" "*") ("GType"))
     :c-arg-names (name pspec_info opt_type)
     :arguments ((* gchar) (* GParamSpecTypeInfo) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:182 <1227> 
;; gpointer g_param_spec_internal( GType param_type, const gchar* name,
;;   const
;;    gchar* nick, const gchar* blurb, GParamFlags flags);
(ff:bind-c-function g_param_spec_internal
     :unconverted-entry-name "g_param_spec_internal"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GType") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("const" "gchar" "*")
                   ("GParamFlags"))
     :c-arg-names (param_type name nick blurb flags)
     :arguments (GType (* gchar) (* gchar) (* gchar) GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:187 <1228> 
;; GParamSpecPool* g_param_spec_pool_new( gboolean type_prefixing);
(ff:bind-c-function g_param_spec_pool_new
     :unconverted-entry-name "g_param_spec_pool_new"
     :c-return-type ("GParamSpecPool" "*")
     :return-type (* GParamSpecPool)
     :c-arg-types (("gboolean"))
     :c-arg-names (type_prefixing)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:188 <1229> 
;; void g_param_spec_pool_insert( GParamSpecPool* pool, GParamSpec* pspec,
;;              GType owner_type);
(ff:bind-c-function g_param_spec_pool_insert
     :unconverted-entry-name "g_param_spec_pool_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GParamSpecPool" "*") ("GParamSpec" "*") ("GType"))
     :c-arg-names (pool pspec owner_type)
     :arguments ((* GParamSpecPool) (* GParamSpec) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:191 <1230> 
;; void g_param_spec_pool_remove( GParamSpecPool* pool, GParamSpec* pspec);
(ff:bind-c-function g_param_spec_pool_remove
     :unconverted-entry-name "g_param_spec_pool_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GParamSpecPool" "*") ("GParamSpec" "*"))
     :c-arg-names (pool pspec)
     :arguments ((* GParamSpecPool) (* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:193 <1231> 
;; GParamSpec* g_param_spec_pool_lookup( GParamSpecPool* pool, const gchar
;;   * param_name, GType owner_type, gboolean walk_ancestors);
(ff:bind-c-function g_param_spec_pool_lookup
     :unconverted-entry-name "g_param_spec_pool_lookup"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("GParamSpecPool" "*") ("const" "gchar" "*")
                   ("GType") ("gboolean"))
     :c-arg-names (pool param_name owner_type walk_ancestors)
     :arguments ((* GParamSpecPool) (* gchar) GType gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:197 <1232> 
;; GList* g_param_spec_pool_list_owned( GParamSpecPool* pool, GType
;;   owner_type
;;   );
(ff:bind-c-function g_param_spec_pool_list_owned
     :unconverted-entry-name "g_param_spec_pool_list_owned"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GParamSpecPool" "*") ("GType"))
     :c-arg-names (pool owner_type)
     :arguments ((* GParamSpecPool) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparam.h:199 <1233> 
;; GParamSpec** g_param_spec_pool_list( GParamSpecPool* pool, GType
;;   owner_type,
;;              guint* n_pspecs_p);
(ff:bind-c-function g_param_spec_pool_list
     :unconverted-entry-name "g_param_spec_pool_list"
     :c-return-type ("GParamSpec" "*" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("GParamSpecPool" "*") ("GType") ("guint" "*"))
     :c-arg-names (pool owner_type n_pspecs_p)
     :arguments ((* GParamSpecPool) GType (* guint))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:39 <1234> 
;; typedef struct _GClosure GClosure;
(ff:bind-c-typedef _GClosure
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GClosure _GClosure)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:40 <1235> 
;; typedef struct _GClosureNotifyData GClosureNotifyData;
(ff:bind-c-typedef _GClosureNotifyData
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GClosureNotifyData _GClosureNotifyData)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:41 <1236> 
;; typedef void(* GCallback)( void);
(ff:bind-c-type GCallback (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:42 <1237> 
;; typedef void(* GClosureNotify)( gpointer data, GClosure* closure);
(ff:bind-c-type GClosureNotify (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:44 <1238> 
;; typedef void(* GClosureMarshal)( GClosure* closure, GValue*
;;   return_value,
;;              guint n_param_values, const GValue* param_values, gpointer
;;   invocation_hint,
;;              gpointer marshal_data);
(ff:bind-c-type GClosureMarshal (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:50 <1239> 
;; typedef struct _GCClosure GCClosure;
(ff:bind-c-typedef _GCClosure
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GCClosure _GCClosure)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:54 <1240> 
;; struct _GClosureNotifyData { gpointer data; GClosureNotify notify; };
(ff:bind-c-type _GClosureNotifyData (:struct
  (data gpointer)   ;; gpointer data
  (notify GClosureNotify)   ;; GClosureNotify notify
  ))   ;; bind-c-type _GClosureNotifyData
(ff:bind-c-typedef GClosureNotifyData
                   _GClosureNotifyData) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:59 <1241> 
;; struct _GClosure {
;;         guint ref_count:  0x00000000f; guint meta_marshal:  0x000000001;
;;   guint
;;    n_guards:  0x000000001; guint n_fnotifiers:  0x000000002; guint
;;   n_inotifiers
;;   :  0x000000008; guint in_inotify:  0x000000001; guint floating:
;;   0x000000001;
;;              guint derivative_flag:  0x000000001; guint in_marshal:
;;   0x000000001; guint
;;    is_invalid:  0x000000001; void(* marshal)( GClosure* closure, GValue*
;;    return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data); gpointer data;
;;   GClosureNotifyData
;;   * notifiers; };

;;WARNING: Strange bitfield ref_count type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield meta_marshal type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield n_guards type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield n_fnotifiers type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield n_inotifiers type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield in_inotify type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield floating type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield derivative_flag type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield in_marshal type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_invalid type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GClosure (:struct
  (ref_count (:bit 15))   ;; guint ref_count:  0x00000000f
  (meta_marshal (:bit 1))   ;; guint meta_marshal:  0x000000001
  (n_guards (:bit 1))   ;; guint n_guards:  0x000000001
  (n_fnotifiers (:bit 2))   ;; guint n_fnotifiers:  0x000000002
  (n_inotifiers (:bit 8))   ;; guint n_inotifiers:  0x000000008
  (in_inotify (:bit 1))   ;; guint in_inotify:  0x000000001
  (floating (:bit 1))   ;; guint floating:  0x000000001
  (derivative_flag (:bit 1))   ;; guint derivative_flag:  0x000000001
  (in_marshal (:bit 1))   ;; guint in_marshal:  0x000000001
  (is_invalid (:bit 1))   ;; guint is_invalid:  0x000000001
  (marshal ff:function-pointer)   ;;
  ;;  void(* marshal)( GClosure* closure, GValue* return_value, guint n_param_values,
  ;;            const GValue* param_values, gpointer invocation_hint, gpointer marshal_data
  ;; )
  (data gpointer)   ;; gpointer data
  (notifiers (* GClosureNotifyData))   ;; GClosureNotifyData* notifiers
  ))   ;; bind-c-type _GClosure
(ff:bind-c-typedef GClosure _GClosure) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:95 <1242> 
;; struct _GCClosure { GClosure closure; gpointer callback; };
(ff:bind-c-type _GCClosure (:struct
  (closure GClosure)   ;; GClosure closure
  (callback gpointer)   ;; gpointer callback
  ))   ;; bind-c-type _GCClosure
(ff:bind-c-typedef GCClosure _GCClosure) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:103 <1243> 
;; GClosure* g_cclosure_new( GCallback callback_func, gpointer user_data,
;;              GClosureNotify destroy_data);
(ff:bind-c-function g_cclosure_new
     :unconverted-entry-name "g_cclosure_new"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("GCallback") ("gpointer") ("GClosureNotify"))
     :c-arg-names (callback_func user_data destroy_data)
     :arguments (GCallback gpointer GClosureNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:106 <1244> 
;; GClosure* g_cclosure_new_swap( GCallback callback_func, gpointer
;;   user_data,
;;              GClosureNotify destroy_data);
(ff:bind-c-function g_cclosure_new_swap
     :unconverted-entry-name "g_cclosure_new_swap"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("GCallback") ("gpointer") ("GClosureNotify"))
     :c-arg-names (callback_func user_data destroy_data)
     :arguments (GCallback gpointer GClosureNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:109 <1245> 
;; GClosure* g_signal_type_cclosure_new( GType itype, guint struct_offset);
(ff:bind-c-function g_signal_type_cclosure_new
     :unconverted-entry-name "g_signal_type_cclosure_new"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("GType") ("guint"))
     :c-arg-names (itype struct_offset)
     :arguments (GType guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:114 <1246> 
;; GClosure* g_closure_ref( GClosure* closure);
(ff:bind-c-function g_closure_ref
     :unconverted-entry-name "g_closure_ref"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("GClosure" "*"))
     :c-arg-names (closure)
     :arguments ((* GClosure))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:115 <1247> 
;; void g_closure_sink( GClosure* closure);
(ff:bind-c-function g_closure_sink
     :unconverted-entry-name "g_closure_sink"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*"))
     :c-arg-names (closure)
     :arguments ((* GClosure))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:116 <1248> 
;; void g_closure_unref( GClosure* closure);
(ff:bind-c-function g_closure_unref
     :unconverted-entry-name "g_closure_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*"))
     :c-arg-names (closure)
     :arguments ((* GClosure))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:118 <1249> 
;; GClosure* g_closure_new_simple( guint sizeof_closure, gpointer data);
(ff:bind-c-function g_closure_new_simple
     :unconverted-entry-name "g_closure_new_simple"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("guint") ("gpointer"))
     :c-arg-names (sizeof_closure data)
     :arguments (guint gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:120 <1250> 
;; void g_closure_add_finalize_notifier( GClosure* closure, gpointer
;;   notify_data,
;;              GClosureNotify notify_func);
(ff:bind-c-function g_closure_add_finalize_notifier
     :unconverted-entry-name "g_closure_add_finalize_notifier"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("gpointer") ("GClosureNotify"))
     :c-arg-names (closure notify_data notify_func)
     :arguments ((* GClosure) gpointer GClosureNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:123 <1251> 
;; void g_closure_remove_finalize_notifier( GClosure* closure, gpointer
;;   notify_data,
;;              GClosureNotify notify_func);
(ff:bind-c-function g_closure_remove_finalize_notifier
     :unconverted-entry-name "g_closure_remove_finalize_notifier"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("gpointer") ("GClosureNotify"))
     :c-arg-names (closure notify_data notify_func)
     :arguments ((* GClosure) gpointer GClosureNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:126 <1252> 
;; void g_closure_add_invalidate_notifier( GClosure* closure, gpointer
;;   notify_data,
;;              GClosureNotify notify_func);
(ff:bind-c-function g_closure_add_invalidate_notifier
     :unconverted-entry-name "g_closure_add_invalidate_notifier"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("gpointer") ("GClosureNotify"))
     :c-arg-names (closure notify_data notify_func)
     :arguments ((* GClosure) gpointer GClosureNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:129 <1253> 
;; void g_closure_remove_invalidate_notifier( GClosure* closure, gpointer
;;    notify_data, GClosureNotify notify_func);
(ff:bind-c-function g_closure_remove_invalidate_notifier
     :unconverted-entry-name "g_closure_remove_invalidate_notifier"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("gpointer") ("GClosureNotify"))
     :c-arg-names (closure notify_data notify_func)
     :arguments ((* GClosure) gpointer GClosureNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:132 <1254> 
;; void g_closure_add_marshal_guards( GClosure* closure, gpointer
;;   pre_marshal_data,
;;              GClosureNotify pre_marshal_notify, gpointer
;;   post_marshal_data, GClosureNotify
;;    post_marshal_notify);
(ff:bind-c-function g_closure_add_marshal_guards
     :unconverted-entry-name "g_closure_add_marshal_guards"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("gpointer") ("GClosureNotify")
                   ("gpointer") ("GClosureNotify"))
     :c-arg-names (closure pre_marshal_data pre_marshal_notify
                   post_marshal_data post_marshal_notify)
     :arguments ((* GClosure) gpointer GClosureNotify gpointer
                 GClosureNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:137 <1255> 
;; void g_closure_set_marshal( GClosure* closure, GClosureMarshal marshal);
(ff:bind-c-function g_closure_set_marshal
     :unconverted-entry-name "g_closure_set_marshal"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GClosureMarshal"))
     :c-arg-names (closure marshal)
     :arguments ((* GClosure) GClosureMarshal)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:139 <1256> 
;; void g_closure_set_meta_marshal( GClosure* closure, gpointer
;;   marshal_data,
;;              GClosureMarshal meta_marshal);
(ff:bind-c-function g_closure_set_meta_marshal
     :unconverted-entry-name "g_closure_set_meta_marshal"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("gpointer") ("GClosureMarshal"))
     :c-arg-names (closure marshal_data meta_marshal)
     :arguments ((* GClosure) gpointer GClosureMarshal)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:142 <1257> 
;; void g_closure_invalidate( GClosure* closure);
(ff:bind-c-function g_closure_invalidate
     :unconverted-entry-name "g_closure_invalidate"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*"))
     :c-arg-names (closure)
     :arguments ((* GClosure))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gclosure.h:143 <1258> 
;; void g_closure_invoke( GClosure* closure, GValue* return_value, guint
;;    n_param_values, const GValue* param_values, gpointer invocation_hint)
;;   ;
(ff:bind-c-function g_closure_invoke
     :unconverted-entry-name "g_closure_invoke"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:7 <1259> 
;; extern void g_cclosure_marshal_VOID__VOID( GClosure* closure, GValue*
;;    return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__VOID
     :all-names ((gtk_marshal_NONE__NONE . "gtk_marshal_NONE__NONE")
                 (gtk_marshal_VOID__VOID . "gtk_marshal_VOID__VOID")
                 (gtk_signal_default_marshaller
                  . "gtk_signal_default_marshaller")
                 (g_cclosure_marshal_VOID__VOID
                  . "g_cclosure_marshal_VOID__VOID"))
     :unconverted-entry-name "g_cclosure_marshal_VOID__VOID"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:15 <1260> 
;; extern void g_cclosure_marshal_VOID__BOOLEAN( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__BOOLEAN
     :unconverted-entry-name "g_cclosure_marshal_VOID__BOOLEAN"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:23 <1261> 
;; extern void g_cclosure_marshal_VOID__CHAR( GClosure* closure, GValue*
;;    return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__CHAR
     :unconverted-entry-name "g_cclosure_marshal_VOID__CHAR"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:31 <1262> 
;; extern void g_cclosure_marshal_VOID__UCHAR( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__UCHAR
     :unconverted-entry-name "g_cclosure_marshal_VOID__UCHAR"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:39 <1263> 
;; extern void g_cclosure_marshal_VOID__INT( GClosure* closure, GValue*
;;   return_value,
;;              guint n_param_values, const GValue* param_values, gpointer
;;   invocation_hint,
;;              gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__INT
     :unconverted-entry-name "g_cclosure_marshal_VOID__INT"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:47 <1264> 
;; extern void g_cclosure_marshal_VOID__UINT( GClosure* closure, GValue*
;;    return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__UINT
     :unconverted-entry-name "g_cclosure_marshal_VOID__UINT"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:55 <1265> 
;; extern void g_cclosure_marshal_VOID__LONG( GClosure* closure, GValue*
;;    return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__LONG
     :unconverted-entry-name "g_cclosure_marshal_VOID__LONG"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:63 <1266> 
;; extern void g_cclosure_marshal_VOID__ULONG( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__ULONG
     :unconverted-entry-name "g_cclosure_marshal_VOID__ULONG"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:71 <1267> 
;; extern void g_cclosure_marshal_VOID__ENUM( GClosure* closure, GValue*
;;    return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__ENUM
     :unconverted-entry-name "g_cclosure_marshal_VOID__ENUM"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:79 <1268> 
;; extern void g_cclosure_marshal_VOID__FLAGS( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__FLAGS
     :unconverted-entry-name "g_cclosure_marshal_VOID__FLAGS"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:87 <1269> 
;; extern void g_cclosure_marshal_VOID__FLOAT( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__FLOAT
     :unconverted-entry-name "g_cclosure_marshal_VOID__FLOAT"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:95 <1270> 
;; extern void g_cclosure_marshal_VOID__DOUBLE( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__DOUBLE
     :unconverted-entry-name "g_cclosure_marshal_VOID__DOUBLE"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:103 <1271> 
;; extern void g_cclosure_marshal_VOID__STRING( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__STRING
     :all-names ((gtk_marshal_VOID__STRING
                  . "gtk_marshal_VOID__STRING")
                 (gtk_marshal_NONE__STRING
                  . "gtk_marshal_NONE__STRING")
                 (g_cclosure_marshal_VOID__STRING
                  . "g_cclosure_marshal_VOID__STRING"))
     :unconverted-entry-name "g_cclosure_marshal_VOID__STRING"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:111 <1272> 
;; extern void g_cclosure_marshal_VOID__PARAM( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__PARAM
     :unconverted-entry-name "g_cclosure_marshal_VOID__PARAM"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:119 <1273> 
;; extern void g_cclosure_marshal_VOID__BOXED( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__BOXED
     :unconverted-entry-name "g_cclosure_marshal_VOID__BOXED"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:127 <1274> 
;; extern void g_cclosure_marshal_VOID__POINTER( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__POINTER
     :unconverted-entry-name "g_cclosure_marshal_VOID__POINTER"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:135 <1275> 
;; extern void g_cclosure_marshal_VOID__OBJECT( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__OBJECT
     :unconverted-entry-name "g_cclosure_marshal_VOID__OBJECT"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:143 <1276> 
;; extern void g_cclosure_marshal_STRING__OBJECT_POINTER( GClosure*
;;   closure,
;;              GValue* return_value, guint n_param_values, const GValue*
;;   param_values,
;;              gpointer invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_STRING__OBJECT_POINTER
     :unconverted-entry-name "g_cclosure_marshal_STRING__OBJECT_POINTER"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:151 <1277> 
;; extern void g_cclosure_marshal_VOID__UINT_POINTER( GClosure* closure,
;;              GValue* return_value, guint n_param_values, const GValue*
;;   param_values,
;;              gpointer invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_VOID__UINT_POINTER
     :unconverted-entry-name "g_cclosure_marshal_VOID__UINT_POINTER"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gmarshal.h:159 <1278> 
;; extern void g_cclosure_marshal_BOOLEAN__FLAGS( GClosure* closure, GValue
;;   * return_value, guint n_param_values, const GValue* param_values,
;;   gpointer
;;    invocation_hint, gpointer marshal_data);
(ff:bind-c-function g_cclosure_marshal_BOOLEAN__FLAGS
     :all-names ((g_cclosure_marshal_BOOL__FLAGS
                  . "g_cclosure_marshal_BOOL__FLAGS")
                 (g_cclosure_marshal_BOOLEAN__FLAGS
                  . "g_cclosure_marshal_BOOLEAN__FLAGS"))
     :unconverted-entry-name "g_cclosure_marshal_BOOLEAN__FLAGS"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GClosure" "*") ("GValue" "*") ("guint")
                   ("const" "GValue" "*") ("gpointer") ("gpointer"))
     :c-arg-names (closure return_value n_param_values param_values
                   invocation_hint marshal_data)
     :arguments ((* GClosure) (* GValue) guint (* GValue) gpointer
                 gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /usr/include/sys/iso/signal_iso.h:80 <1279> extern long _sysconf( int);
(ff:bind-c-function _sysconf
     :unconverted-entry-name "_sysconf"
     :c-modifiers ("extern")
     :c-return-type ("long")
     :return-type :long
     :c-arg-types (("int"))
     :c-arg-names (Arg0)
     :arguments (:int)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /usr/include/iso/signal_iso.h:41 <1280> typedef int sig_atomic_t;
(ff:bind-c-type sig_atomic_t :int)  

;; /usr/include/iso/signal_iso.h:48 <1281> 
;; extern void(* signal( int, void(*)( int)))( int);
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "signal"))

;; /usr/include/iso/signal_iso.h:50 <1282> extern int raise( int);
(ff:bind-c-function raise
     :unconverted-entry-name "raise"
     :c-modifiers ("extern")
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("int"))
     :c-arg-names (Arg0)
     :arguments (:int)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /usr/include/signal.h:46 <1283> extern const char** _sys_siglistp;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "_sys_siglistp"))

;; /usr/include/signal.h:47 <1284> extern const int _sys_siglistn;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "_sys_siglistn"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:35 <1285> 
;; typedef struct _GSignalQuery GSignalQuery;
(ff:bind-c-typedef _GSignalQuery
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSignalQuery _GSignalQuery)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:36 <1286> 
;; typedef struct _GSignalInvocationHint GSignalInvocationHint;
(ff:bind-c-typedef _GSignalInvocationHint
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSignalInvocationHint _GSignalInvocationHint)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:37 <1287> 
;; typedef GClosureMarshal GSignalCMarshaller;
(ff:bind-c-type GSignalCMarshaller GClosureMarshal)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:38 <1288> 
;; typedef gboolean(* GSignalEmissionHook)( GSignalInvocationHint* ihint,
;;              guint n_param_values, const GValue* param_values, gpointer
;;   data);
(ff:bind-c-type GSignalEmissionHook (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:42 <1289> 
;; typedef gboolean(* GSignalAccumulator)( GSignalInvocationHint* ihint,
;;              GValue* return_accu, const GValue* handler_return, gpointer
;;   data);
(ff:bind-c-type GSignalAccumulator (* gboolean))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:49 <1290> 
;; typedef enum {
;;         G_SIGNAL_RUN_FIRST =  0x000000001 LSHIFT  0x000000000,
;;   G_SIGNAL_RUN_LAST
;;    =  0x000000001 LSHIFT  0x000000001, G_SIGNAL_RUN_CLEANUP =
;;   0x000000001
;;    LSHIFT  0x000000002, G_SIGNAL_NO_RECURSE =  0x000000001 LSHIFT
;;   0x000000003,
;;              G_SIGNAL_DETAILED =  0x000000001 LSHIFT  0x000000004,
;;   G_SIGNAL_ACTION
;;    =  0x000000001 LSHIFT  0x000000005, G_SIGNAL_NO_HOOKS =  0x000000001
;;   LSHIFT
;;     0x000000006 } GSignalFlags;
(ff:bind-c-constant G_SIGNAL_RUN_FIRST
                    1) ;;
;;   G_SIGNAL_RUN_FIRST =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_SIGNAL_RUN_LAST
                    2) ;;
;;   G_SIGNAL_RUN_LAST =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_SIGNAL_RUN_CLEANUP
                    4) ;;
;;   G_SIGNAL_RUN_CLEANUP =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_SIGNAL_NO_RECURSE
                    8) ;;
;;   G_SIGNAL_NO_RECURSE =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_SIGNAL_DETAILED
                    16) ;;
;;   G_SIGNAL_DETAILED =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_SIGNAL_ACTION
                    32) ;;
;;   G_SIGNAL_ACTION =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant G_SIGNAL_NO_HOOKS
                    64) ;;
;;   G_SIGNAL_NO_HOOKS =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-type GSignalFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:60 <1291> 
;; typedef enum {
;;         G_CONNECT_AFTER =  0x000000001 LSHIFT  0x000000000,
;;   G_CONNECT_SWAPPED
;;    =  0x000000001 LSHIFT  0x000000001 } GConnectFlags;
(ff:bind-c-constant G_CONNECT_AFTER
                    1) ;;
;;   G_CONNECT_AFTER =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_CONNECT_SWAPPED
                    2) ;;
;;   G_CONNECT_SWAPPED =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-type GConnectFlags :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:65 <1292> 
;; typedef enum {
;;         G_SIGNAL_MATCH_ID =  0x000000001 LSHIFT  0x000000000,
;;   G_SIGNAL_MATCH_DETAIL
;;    =  0x000000001 LSHIFT  0x000000001, G_SIGNAL_MATCH_CLOSURE =
;;   0x000000001
;;    LSHIFT  0x000000002, G_SIGNAL_MATCH_FUNC =  0x000000001 LSHIFT
;;   0x000000003,
;;              G_SIGNAL_MATCH_DATA =  0x000000001 LSHIFT  0x000000004,
;;   G_SIGNAL_MATCH_UNBLOCKED
;;    =  0x000000001 LSHIFT  0x000000005 } GSignalMatchType;
(ff:bind-c-constant G_SIGNAL_MATCH_ID
                    1) ;;
;;   G_SIGNAL_MATCH_ID =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_SIGNAL_MATCH_DETAIL
                    2) ;;
;;   G_SIGNAL_MATCH_DETAIL =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_SIGNAL_MATCH_CLOSURE
                    4) ;;
;;   G_SIGNAL_MATCH_CLOSURE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_SIGNAL_MATCH_FUNC
                    8) ;;
;;   G_SIGNAL_MATCH_FUNC =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_SIGNAL_MATCH_DATA
                    16) ;;
;;   G_SIGNAL_MATCH_DATA =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_SIGNAL_MATCH_UNBLOCKED
                    32) ;;
;;   G_SIGNAL_MATCH_UNBLOCKED =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-type GSignalMatchType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:79 <1293> 
;; struct _GSignalInvocationHint {
;;         guint signal_id; GQuark detail; GSignalFlags run_type; };
(ff:bind-c-type _GSignalInvocationHint (:struct
  (signal_id guint)   ;; guint signal_id
  (detail GQuark)   ;; GQuark detail
  (run_type GSignalFlags)   ;; GSignalFlags run_type
  ))   ;; bind-c-type _GSignalInvocationHint
(ff:bind-c-typedef GSignalInvocationHint
                   _GSignalInvocationHint) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:85 <1294> 
;; struct _GSignalQuery {
;;         guint signal_id; const gchar* signal_name; GType itype;
;;   GSignalFlags signal_flags;
;;              GType return_type; guint n_params; const GType*
;;   param_types; };
(ff:bind-c-type _GSignalQuery (:struct
  (signal_id guint)   ;; guint signal_id
  (signal_name (* gchar))   ;; const gchar* signal_name
  (itype GType)   ;; GType itype
  (signal_flags GSignalFlags)   ;; GSignalFlags signal_flags
  (return_type GType)   ;; GType return_type
  (n_params guint)   ;; guint n_params
  (param_types (* GType))   ;; const GType* param_types
  ))   ;; bind-c-type _GSignalQuery
(ff:bind-c-typedef GSignalQuery _GSignalQuery) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:98 <1295> 
;; guint g_signal_newv( const gchar* signal_name, GType itype, GSignalFlags
;;    signal_flags, GClosure* class_closure, GSignalAccumulator
;;   accumulator,
;;              gpointer accu_data, GSignalCMarshaller c_marshaller, GType
;;   return_type,
;;              guint n_params, GType* param_types);
(ff:bind-c-function g_signal_newv
     :unconverted-entry-name "g_signal_newv"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GType") ("GSignalFlags")
                   ("GClosure" "*") ("GSignalAccumulator") ("gpointer")
                   ("GSignalCMarshaller") ("GType") ("guint")
                   ("GType" "*"))
     :c-arg-names (signal_name itype signal_flags class_closure
                   accumulator accu_data c_marshaller return_type
                   n_params param_types)
     :arguments ((* gchar) GType GSignalFlags (* GClosure)
                 GSignalAccumulator gpointer GSignalCMarshaller GType
                 guint (* GType))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:108 <1296> 
;; guint g_signal_new_valist( const gchar* signal_name, GType itype,
;;   GSignalFlags
;;    signal_flags, GClosure* class_closure, GSignalAccumulator
;;   accumulator,
;;              gpointer accu_data, GSignalCMarshaller c_marshaller, GType
;;   return_type,
;;              guint n_params, va_list args);
(ff:bind-c-function g_signal_new_valist
     :unconverted-entry-name "g_signal_new_valist"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GType") ("GSignalFlags")
                   ("GClosure" "*") ("GSignalAccumulator") ("gpointer")
                   ("GSignalCMarshaller") ("GType") ("guint")
                   ("va_list"))
     :c-arg-names (signal_name itype signal_flags class_closure
                   accumulator accu_data c_marshaller return_type
                   n_params args)
     :arguments ((* gchar) GType GSignalFlags (* GClosure)
                 GSignalAccumulator gpointer GSignalCMarshaller GType
                 guint va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:118 <1297> 
;; guint g_signal_new( const gchar* signal_name, GType itype, GSignalFlags
;;    signal_flags, guint class_offset, GSignalAccumulator accumulator,
;;   gpointer
;;    accu_data, GSignalCMarshaller c_marshaller, GType return_type, guint
;;   n_params
;;   , ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_signal_new
     :unconverted-entry-name "g_signal_new"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GType") ("GSignalFlags")
                   ("guint") ("GSignalAccumulator") ("gpointer")
                   ("GSignalCMarshaller") ("GType") ("guint") "...")
     :c-arg-names (signal_name itype signal_flags class_offset
                   accumulator accu_data c_marshaller return_type
                   n_params)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:128 <1298> 
;; void g_signal_emitv( const GValue* instance_and_params, guint signal_id,
;;              GQuark detail, GValue* return_value);
(ff:bind-c-function g_signal_emitv
     :unconverted-entry-name "g_signal_emitv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GValue" "*") ("guint") ("GQuark")
                   ("GValue" "*"))
     :c-arg-names (instance_and_params signal_id detail return_value)
     :arguments ((* GValue) guint GQuark (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:132 <1299> 
;; void g_signal_emit_valist( gpointer instance, guint signal_id, GQuark
;;    detail, va_list var_args);
(ff:bind-c-function g_signal_emit_valist
     :unconverted-entry-name "g_signal_emit_valist"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("guint") ("GQuark") ("va_list"))
     :c-arg-names (instance signal_id detail var_args)
     :arguments (gpointer guint GQuark va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:136 <1300> 
;; void g_signal_emit( gpointer instance, guint signal_id, GQuark detail
;;   , ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_signal_emit
     :unconverted-entry-name "g_signal_emit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("guint") ("GQuark") "...")
     :c-arg-names (instance signal_id detail)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:140 <1301> 
;; void g_signal_emit_by_name( gpointer instance, const gchar*
;;   detailed_signal
;;   , ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_signal_emit_by_name
     :unconverted-entry-name "g_signal_emit_by_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("const" "gchar" "*") "...")
     :c-arg-names (instance detailed_signal)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:143 <1302> 
;; guint g_signal_lookup( const gchar* name, GType itype);
(ff:bind-c-function g_signal_lookup
     :unconverted-entry-name "g_signal_lookup"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GType"))
     :c-arg-names (name itype)
     :arguments ((* gchar) GType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:145 <1303> 
;; const gchar* g_signal_name( guint signal_id);
(ff:bind-c-function g_signal_name
     :unconverted-entry-name "g_signal_name"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("guint"))
     :c-arg-names (signal_id)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:146 <1304> 
;; void g_signal_query( guint signal_id, GSignalQuery* query);
(ff:bind-c-function g_signal_query
     :unconverted-entry-name "g_signal_query"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint") ("GSignalQuery" "*"))
     :c-arg-names (signal_id query)
     :arguments (guint (* GSignalQuery))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:148 <1305> 
;; guint* g_signal_list_ids( GType itype, guint* n_ids);
(ff:bind-c-function g_signal_list_ids
     :unconverted-entry-name "g_signal_list_ids"
     :c-return-type ("guint" "*")
     :return-type (* guint)
     :c-arg-types (("GType") ("guint" "*"))
     :c-arg-names (itype n_ids)
     :arguments (GType (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:150 <1306> 
;; gboolean g_signal_parse_name( const gchar* detailed_signal, GType itype,
;;              guint* signal_id_p, GQuark* detail_p, gboolean
;;   force_detail_quark);
(ff:bind-c-function g_signal_parse_name
     :unconverted-entry-name "g_signal_parse_name"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("GType") ("guint" "*")
                   ("GQuark" "*") ("gboolean"))
     :c-arg-names (detailed_signal itype signal_id_p detail_p
                   force_detail_quark)
     :arguments ((* gchar) GType (* guint) (* GQuark) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:155 <1307> 
;; GSignalInvocationHint* g_signal_get_invocation_hint( gpointer instance);
(ff:bind-c-function g_signal_get_invocation_hint
     :unconverted-entry-name "g_signal_get_invocation_hint"
     :c-return-type ("GSignalInvocationHint" "*")
     :return-type (* GSignalInvocationHint)
     :c-arg-types (("gpointer"))
     :c-arg-names (instance)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:159 <1308> 
;; void g_signal_stop_emission( gpointer instance, guint signal_id, GQuark
;;    detail);
(ff:bind-c-function g_signal_stop_emission
     :unconverted-entry-name "g_signal_stop_emission"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("guint") ("GQuark"))
     :c-arg-names (instance signal_id detail)
     :arguments (gpointer guint GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:162 <1309> 
;; void g_signal_stop_emission_by_name( gpointer instance, const gchar*
;;   detailed_signal
;;   );
(ff:bind-c-function g_signal_stop_emission_by_name
     :unconverted-entry-name "g_signal_stop_emission_by_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("const" "gchar" "*"))
     :c-arg-names (instance detailed_signal)
     :arguments (gpointer (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:164 <1310> 
;; gulong g_signal_add_emission_hook( guint signal_id, GQuark quark,
;;   GSignalEmissionHook
;;    hook_func, gpointer hook_data, GDestroyNotify data_destroy);
(ff:bind-c-function g_signal_add_emission_hook
     :unconverted-entry-name "g_signal_add_emission_hook"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("guint") ("GQuark") ("GSignalEmissionHook")
                   ("gpointer") ("GDestroyNotify"))
     :c-arg-names (signal_id quark hook_func hook_data data_destroy)
     :arguments (guint GQuark GSignalEmissionHook gpointer
                 GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:169 <1311> 
;; void g_signal_remove_emission_hook( guint signal_id, gulong hook_id);
(ff:bind-c-function g_signal_remove_emission_hook
     :unconverted-entry-name "g_signal_remove_emission_hook"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint") ("gulong"))
     :c-arg-names (signal_id hook_id)
     :arguments (guint gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:174 <1312> 
;; gboolean g_signal_has_handler_pending( gpointer instance, guint
;;   signal_id,
;;              GQuark detail, gboolean may_be_blocked);
(ff:bind-c-function g_signal_has_handler_pending
     :unconverted-entry-name "g_signal_has_handler_pending"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gpointer") ("guint") ("GQuark") ("gboolean"))
     :c-arg-names (instance signal_id detail may_be_blocked)
     :arguments (gpointer guint GQuark gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:178 <1313> 
;; gulong g_signal_connect_closure_by_id( gpointer instance, guint
;;   signal_id,
;;              GQuark detail, GClosure* closure, gboolean after);
(ff:bind-c-function g_signal_connect_closure_by_id
     :unconverted-entry-name "g_signal_connect_closure_by_id"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("gpointer") ("guint") ("GQuark") ("GClosure" "*")
                   ("gboolean"))
     :c-arg-names (instance signal_id detail closure after)
     :arguments (gpointer guint GQuark (* GClosure) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:183 <1314> 
;; gulong g_signal_connect_closure( gpointer instance, const gchar*
;;   detailed_signal,
;;              GClosure* closure, gboolean after);
(ff:bind-c-function g_signal_connect_closure
     :unconverted-entry-name "g_signal_connect_closure"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("gpointer") ("const" "gchar" "*") ("GClosure" "*")
                   ("gboolean"))
     :c-arg-names (instance detailed_signal closure after)
     :arguments (gpointer (* gchar) (* GClosure) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:187 <1315> 
;; gulong g_signal_connect_data( gpointer instance, const gchar*
;;   detailed_signal,
;;              GCallback c_handler, gpointer data, GClosureNotify
;;   destroy_data, GConnectFlags
;;    connect_flags);
(ff:bind-c-function g_signal_connect_data
     :unconverted-entry-name "g_signal_connect_data"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("gpointer") ("const" "gchar" "*") ("GCallback")
                   ("gpointer") ("GClosureNotify") ("GConnectFlags"))
     :c-arg-names (instance detailed_signal c_handler data destroy_data
                   connect_flags)
     :arguments (gpointer (* gchar) GCallback gpointer GClosureNotify
                 GConnectFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:193 <1316> 
;; void g_signal_handler_block( gpointer instance, gulong handler_id);
(ff:bind-c-function g_signal_handler_block
     :unconverted-entry-name "g_signal_handler_block"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("gulong"))
     :c-arg-names (instance handler_id)
     :arguments (gpointer gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:195 <1317> 
;; void g_signal_handler_unblock( gpointer instance, gulong handler_id);
(ff:bind-c-function g_signal_handler_unblock
     :unconverted-entry-name "g_signal_handler_unblock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("gulong"))
     :c-arg-names (instance handler_id)
     :arguments (gpointer gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:197 <1318> 
;; void g_signal_handler_disconnect( gpointer instance, gulong handler_id);
(ff:bind-c-function g_signal_handler_disconnect
     :unconverted-entry-name "g_signal_handler_disconnect"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("gulong"))
     :c-arg-names (instance handler_id)
     :arguments (gpointer gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:199 <1319> 
;; gboolean g_signal_handler_is_connected( gpointer instance, gulong
;;   handler_id
;;   );
(ff:bind-c-function g_signal_handler_is_connected
     :unconverted-entry-name "g_signal_handler_is_connected"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gpointer") ("gulong"))
     :c-arg-names (instance handler_id)
     :arguments (gpointer gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:201 <1320> 
;; gulong g_signal_handler_find( gpointer instance, GSignalMatchType mask,
;;              guint signal_id, GQuark detail, GClosure* closure, gpointer
;;   func, gpointer
;;    data);
(ff:bind-c-function g_signal_handler_find
     :unconverted-entry-name "g_signal_handler_find"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("gpointer") ("GSignalMatchType") ("guint")
                   ("GQuark") ("GClosure" "*") ("gpointer")
                   ("gpointer"))
     :c-arg-names (instance mask signal_id detail closure func data)
     :arguments (gpointer GSignalMatchType guint GQuark (* GClosure)
                 gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:208 <1321> 
;; guint g_signal_handlers_block_matched( gpointer instance,
;;   GSignalMatchType
;;    mask, guint signal_id, GQuark detail, GClosure* closure, gpointer
;;   func,
;;              gpointer data);
(ff:bind-c-function g_signal_handlers_block_matched
     :unconverted-entry-name "g_signal_handlers_block_matched"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gpointer") ("GSignalMatchType") ("guint")
                   ("GQuark") ("GClosure" "*") ("gpointer")
                   ("gpointer"))
     :c-arg-names (instance mask signal_id detail closure func data)
     :arguments (gpointer GSignalMatchType guint GQuark (* GClosure)
                 gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:215 <1322> 
;; guint g_signal_handlers_unblock_matched( gpointer instance,
;;   GSignalMatchType
;;    mask, guint signal_id, GQuark detail, GClosure* closure, gpointer
;;   func,
;;              gpointer data);
(ff:bind-c-function g_signal_handlers_unblock_matched
     :unconverted-entry-name "g_signal_handlers_unblock_matched"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gpointer") ("GSignalMatchType") ("guint")
                   ("GQuark") ("GClosure" "*") ("gpointer")
                   ("gpointer"))
     :c-arg-names (instance mask signal_id detail closure func data)
     :arguments (gpointer GSignalMatchType guint GQuark (* GClosure)
                 gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:222 <1323> 
;; guint g_signal_handlers_disconnect_matched( gpointer instance,
;;   GSignalMatchType
;;    mask, guint signal_id, GQuark detail, GClosure* closure, gpointer
;;   func,
;;              gpointer data);
(ff:bind-c-function g_signal_handlers_disconnect_matched
     :unconverted-entry-name "g_signal_handlers_disconnect_matched"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gpointer") ("GSignalMatchType") ("guint")
                   ("GQuark") ("GClosure" "*") ("gpointer")
                   ("gpointer"))
     :c-arg-names (instance mask signal_id detail closure func data)
     :arguments (gpointer GSignalMatchType guint GQuark (* GClosure)
                 gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:232 <1324> 
;; void g_signal_override_class_closure( guint signal_id, GType
;;   instance_type,
;;              GClosure* class_closure);
(ff:bind-c-function g_signal_override_class_closure
     :unconverted-entry-name "g_signal_override_class_closure"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint") ("GType") ("GClosure" "*"))
     :c-arg-names (signal_id instance_type class_closure)
     :arguments (guint GType (* GClosure))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:235 <1325> 
;; void g_signal_chain_from_overridden( const GValue* instance_and_params,
;;              GValue* return_value);
(ff:bind-c-function g_signal_chain_from_overridden
     :unconverted-entry-name "g_signal_chain_from_overridden"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GValue" "*") ("GValue" "*"))
     :c-arg-names (instance_and_params return_value)
     :arguments ((* GValue) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:258 <1326> 
;; void g_signal_handlers_destroy( gpointer instance);
(ff:bind-c-function g_signal_handlers_destroy
     :unconverted-entry-name "g_signal_handlers_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (instance)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsignal.h:259 <1327> 
;; void _g_signals_destroy( GType itype);
(ff:bind-c-function _g_signals_destroy
     :unconverted-entry-name "_g_signals_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GType"))
     :c-arg-names (itype)
     :arguments (GType)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:50 <1328> 
;; typedef struct _GObject GObject;
(ff:bind-c-typedef _GObject
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GObject _GObject)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:51 <1329> 
;; typedef struct _GObjectClass GObjectClass;
(ff:bind-c-typedef _GObjectClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GObjectClass _GObjectClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:52 <1330> 
;; typedef struct _GObjectConstructParam GObjectConstructParam;
(ff:bind-c-typedef _GObjectConstructParam
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GObjectConstructParam _GObjectConstructParam)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:53 <1331> 
;; typedef void(* GObjectGetPropertyFunc)( GObject* object, guint
;;   property_id,
;;              GValue* value, GParamSpec* pspec);
(ff:bind-c-type GObjectGetPropertyFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:57 <1332> 
;; typedef void(* GObjectSetPropertyFunc)( GObject* object, guint
;;   property_id,
;;              const GValue* value, GParamSpec* pspec);
(ff:bind-c-type GObjectSetPropertyFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:61 <1333> 
;; typedef void(* GObjectFinalizeFunc)( GObject* object);
(ff:bind-c-type GObjectFinalizeFunc (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:62 <1334> 
;; typedef void(* GWeakNotify)( gpointer data, GObject*
;;   where_the_object_was
;;   );
(ff:bind-c-type GWeakNotify (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:64 <1335> 
;; struct _GObject {
;;         GTypeInstance g_type_instance; guint ref_count; GData* qdata; };
(ff:bind-c-type _GObject (:struct
  (g_type_instance GTypeInstance)   ;; GTypeInstance g_type_instance
  (ref_count guint)   ;; guint ref_count
  (qdata (* GData))   ;; GData* qdata
  ))   ;; bind-c-type _GObject
(ff:bind-c-typedef GObject _GObject) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:72 <1336> 
;; struct _GObjectClass {
;;         GTypeClass g_type_class; GSList* construct_properties;
;;   GObject*(* constructor
;;   )( GType type, guint n_construct_properties, GObjectConstructParam*
;;   construct_properties
;;   ); void(* set_property)( GObject* object, guint property_id, const
;;   GValue
;;   * value, GParamSpec* pspec); void(* get_property)( GObject* object,
;;   guint
;;    property_id, GValue* value, GParamSpec* pspec); void(* dispose)(
;;   GObject
;;   * object); void(* finalize)( GObject* object); void(*
;;   dispatch_properties_changed
;;   )( GObject* object, guint n_pspecs, GParamSpec** pspecs); void(*
;;   notify
;;   )( GObject* object, GParamSpec* pspec); gpointer pdummy[
;;   0x000000008];
;;    };
(ff:bind-c-type _GObjectClass (:struct
  (g_type_class GTypeClass)   ;; GTypeClass g_type_class
  (construct_properties (* GSList))   ;; GSList* construct_properties
  (constructor ff:function-pointer)   ;;
  ;;  GObject*(* constructor)( GType type, guint n_construct_properties, GObjectConstructParam
  ;; * construct_properties)
  (set_property ff:function-pointer)   ;;
  ;;  void(* set_property)( GObject* object, guint property_id, const GValue* value,
  ;;            GParamSpec* pspec)
  (get_property ff:function-pointer)   ;;
  ;;  void(* get_property)( GObject* object, guint property_id, GValue* value, GParamSpec
  ;; * pspec)
  (dispose ff:function-pointer)   ;; void(* dispose)( GObject* object)
  (finalize ff:function-pointer)   ;; void(* finalize)( GObject* object)
  (dispatch_properties_changed ff:function-pointer)   ;;
  ;;  void(* dispatch_properties_changed)( GObject* object, guint n_pspecs, GParamSpec
  ;; ** pspecs)
  (notify ff:function-pointer)   ;;
  ;;  void(* notify)( GObject* object, GParamSpec* pspec)
  (pdummy (:array gpointer 8))   ;; gpointer pdummy[  0x000000008]
  ))   ;; bind-c-type _GObjectClass
(ff:bind-c-typedef GObjectClass _GObjectClass) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:105 <1337> 
;; struct _GObjectConstructParam { GParamSpec* pspec; GValue* value; };
(ff:bind-c-type _GObjectConstructParam (:struct
  (pspec (* GParamSpec))   ;; GParamSpec* pspec
  (value (* GValue))   ;; GValue* value
  ))   ;; bind-c-type _GObjectConstructParam
(ff:bind-c-typedef GObjectConstructParam
                   _GObjectConstructParam) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:113 <1338> 
;; void g_object_class_install_property( GObjectClass* oclass, guint
;;   property_id,
;;              GParamSpec* pspec);
(ff:bind-c-function g_object_class_install_property
     :unconverted-entry-name "g_object_class_install_property"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObjectClass" "*") ("guint") ("GParamSpec" "*"))
     :c-arg-names (oclass property_id pspec)
     :arguments ((* GObjectClass) guint (* GParamSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:116 <1339> 
;; GParamSpec* g_object_class_find_property( GObjectClass* oclass, const
;;    gchar* property_name);
(ff:bind-c-function g_object_class_find_property
     :unconverted-entry-name "g_object_class_find_property"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("GObjectClass" "*") ("const" "gchar" "*"))
     :c-arg-names (oclass property_name)
     :arguments ((* GObjectClass) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:118 <1340> 
;; GParamSpec** g_object_class_list_properties( GObjectClass* oclass, guint
;;   * n_properties);
(ff:bind-c-function g_object_class_list_properties
     :unconverted-entry-name "g_object_class_list_properties"
     :c-return-type ("GParamSpec" "*" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("GObjectClass" "*") ("guint" "*"))
     :c-arg-names (oclass n_properties)
     :arguments ((* GObjectClass) (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:120 <1341> 
;; gpointer g_object_new( GType object_type, const gchar*
;;   first_property_name
;;   , ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_object_new
     :unconverted-entry-name "g_object_new"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GType") ("const" "gchar" "*") "...")
     :c-arg-names (object_type first_property_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:123 <1342> 
;; gpointer g_object_newv( GType object_type, guint n_parameters,
;;   GParameter
;;   * parameters);
(ff:bind-c-function g_object_newv
     :unconverted-entry-name "g_object_newv"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GType") ("guint") ("GParameter" "*"))
     :c-arg-names (object_type n_parameters parameters)
     :arguments (GType guint (* GParameter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:126 <1343> 
;; GObject* g_object_new_valist( GType object_type, const gchar*
;;   first_property_name,
;;              va_list var_args);
(ff:bind-c-function g_object_new_valist
     :unconverted-entry-name "g_object_new_valist"
     :c-return-type ("GObject" "*")
     :return-type (* GObject)
     :c-arg-types (("GType") ("const" "gchar" "*") ("va_list"))
     :c-arg-names (object_type first_property_name var_args)
     :arguments (GType (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:129 <1344> 
;; void g_object_set( gpointer object, const gchar* first_property_name,
;;    ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_object_set
     :unconverted-entry-name "g_object_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("const" "gchar" "*") "...")
     :c-arg-names (object first_property_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:132 <1345> 
;; void g_object_get( gpointer object, const gchar* first_property_name,
;;    ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_object_get
     :unconverted-entry-name "g_object_get"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("const" "gchar" "*") "...")
     :c-arg-names (object first_property_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:135 <1346> 
;; gpointer g_object_connect( gpointer object, const gchar* signal_spec,
;;    ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_object_connect
     :unconverted-entry-name "g_object_connect"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer") ("const" "gchar" "*") "...")
     :c-arg-names (object signal_spec)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:138 <1347> 
;; void g_object_disconnect( gpointer object, const gchar* signal_spec,
;;   ELLIPSIS
;;   );

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_object_disconnect
     :unconverted-entry-name "g_object_disconnect"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer") ("const" "gchar" "*") "...")
     :c-arg-names (object signal_spec)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:141 <1348> 
;; void g_object_set_valist( GObject* object, const gchar*
;;   first_property_name,
;;              va_list var_args);
(ff:bind-c-function g_object_set_valist
     :unconverted-entry-name "g_object_set_valist"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("const" "gchar" "*") ("va_list"))
     :c-arg-names (object first_property_name var_args)
     :arguments ((* GObject) (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:144 <1349> 
;; void g_object_get_valist( GObject* object, const gchar*
;;   first_property_name,
;;              va_list var_args);
(ff:bind-c-function g_object_get_valist
     :unconverted-entry-name "g_object_get_valist"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("const" "gchar" "*") ("va_list"))
     :c-arg-names (object first_property_name var_args)
     :arguments ((* GObject) (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:147 <1350> 
;; void g_object_set_property( GObject* object, const gchar* property_name,
;;              const GValue* value);
(ff:bind-c-function g_object_set_property
     :unconverted-entry-name "g_object_set_property"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("const" "gchar" "*")
                   ("const" "GValue" "*"))
     :c-arg-names (object property_name value)
     :arguments ((* GObject) (* gchar) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:150 <1351> 
;; void g_object_get_property( GObject* object, const gchar* property_name,
;;              GValue* value);
(ff:bind-c-function g_object_get_property
     :unconverted-entry-name "g_object_get_property"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("const" "gchar" "*") ("GValue" "*"))
     :c-arg-names (object property_name value)
     :arguments ((* GObject) (* gchar) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:153 <1352> 
;; void g_object_freeze_notify( GObject* object);
(ff:bind-c-function g_object_freeze_notify
     :unconverted-entry-name "g_object_freeze_notify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*"))
     :c-arg-names (object)
     :arguments ((* GObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:154 <1353> 
;; void g_object_notify( GObject* object, const gchar* property_name);
(ff:bind-c-function g_object_notify
     :unconverted-entry-name "g_object_notify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object property_name)
     :arguments ((* GObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:156 <1354> 
;; void g_object_thaw_notify( GObject* object);
(ff:bind-c-function g_object_thaw_notify
     :unconverted-entry-name "g_object_thaw_notify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*"))
     :c-arg-names (object)
     :arguments ((* GObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:157 <1355> 
;; gpointer g_object_ref( gpointer object);
(ff:bind-c-function g_object_ref
     :all-names ((g_object_ref . "g_object_ref")
                 (gtk_accel_group_ref . "gtk_accel_group_ref"))
     :unconverted-entry-name "g_object_ref"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer"))
     :c-arg-names (object)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:158 <1356> 
;; void g_object_unref( gpointer object);
(ff:bind-c-function g_object_unref
     :all-names ((g_object_unref . "g_object_unref")
                 (gtk_accel_group_unref . "gtk_accel_group_unref"))
     :unconverted-entry-name "g_object_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (object)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:159 <1357> 
;; void g_object_weak_ref( GObject* object, GWeakNotify notify, gpointer
;;    data);
(ff:bind-c-function g_object_weak_ref
     :unconverted-entry-name "g_object_weak_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("GWeakNotify") ("gpointer"))
     :c-arg-names (object notify data)
     :arguments ((* GObject) GWeakNotify gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:162 <1358> 
;; void g_object_weak_unref( GObject* object, GWeakNotify notify, gpointer
;;    data);
(ff:bind-c-function g_object_weak_unref
     :unconverted-entry-name "g_object_weak_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("GWeakNotify") ("gpointer"))
     :c-arg-names (object notify data)
     :arguments ((* GObject) GWeakNotify gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:165 <1359> 
;; void g_object_add_weak_pointer( GObject* object, gpointer*
;;   weak_pointer_location
;;   );
(ff:bind-c-function g_object_add_weak_pointer
     :unconverted-entry-name "g_object_add_weak_pointer"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("gpointer" "*"))
     :c-arg-names (object weak_pointer_location)
     :arguments ((* GObject) (* gpointer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:167 <1360> 
;; void g_object_remove_weak_pointer( GObject* object, gpointer*
;;   weak_pointer_location
;;   );
(ff:bind-c-function g_object_remove_weak_pointer
     :unconverted-entry-name "g_object_remove_weak_pointer"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("gpointer" "*"))
     :c-arg-names (object weak_pointer_location)
     :arguments ((* GObject) (* gpointer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:169 <1361> 
;; gpointer g_object_get_qdata( GObject* object, GQuark quark);
(ff:bind-c-function g_object_get_qdata
     :unconverted-entry-name "g_object_get_qdata"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GObject" "*") ("GQuark"))
     :c-arg-names (object quark)
     :arguments ((* GObject) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:171 <1362> 
;; void g_object_set_qdata( GObject* object, GQuark quark, gpointer data);
(ff:bind-c-function g_object_set_qdata
     :unconverted-entry-name "g_object_set_qdata"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("GQuark") ("gpointer"))
     :c-arg-names (object quark data)
     :arguments ((* GObject) GQuark gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:174 <1363> 
;; void g_object_set_qdata_full( GObject* object, GQuark quark, gpointer
;;    data, GDestroyNotify destroy);
(ff:bind-c-function g_object_set_qdata_full
     :unconverted-entry-name "g_object_set_qdata_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("GQuark") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (object quark data destroy)
     :arguments ((* GObject) GQuark gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:178 <1364> 
;; gpointer g_object_steal_qdata( GObject* object, GQuark quark);
(ff:bind-c-function g_object_steal_qdata
     :unconverted-entry-name "g_object_steal_qdata"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GObject" "*") ("GQuark"))
     :c-arg-names (object quark)
     :arguments ((* GObject) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:180 <1365> 
;; gpointer g_object_get_data( GObject* object, const gchar* key);
(ff:bind-c-function g_object_get_data
     :unconverted-entry-name "g_object_get_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object key)
     :arguments ((* GObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:182 <1366> 
;; void g_object_set_data( GObject* object, const gchar* key, gpointer data
;;   );
(ff:bind-c-function g_object_set_data
     :unconverted-entry-name "g_object_set_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("const" "gchar" "*") ("gpointer"))
     :c-arg-names (object key data)
     :arguments ((* GObject) (* gchar) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:185 <1367> 
;; void g_object_set_data_full( GObject* object, const gchar* key, gpointer
;;    data, GDestroyNotify destroy);
(ff:bind-c-function g_object_set_data_full
     :unconverted-entry-name "g_object_set_data_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("const" "gchar" "*") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (object key data destroy)
     :arguments ((* GObject) (* gchar) gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:189 <1368> 
;; gpointer g_object_steal_data( GObject* object, const gchar* key);
(ff:bind-c-function g_object_steal_data
     :unconverted-entry-name "g_object_steal_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object key)
     :arguments ((* GObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:191 <1369> 
;; void g_object_watch_closure( GObject* object, GClosure* closure);
(ff:bind-c-function g_object_watch_closure
     :unconverted-entry-name "g_object_watch_closure"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*") ("GClosure" "*"))
     :c-arg-names (object closure)
     :arguments ((* GObject) (* GClosure))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:193 <1370> 
;; GClosure* g_cclosure_new_object( GCallback callback_func, GObject*
;;   object
;;   );
(ff:bind-c-function g_cclosure_new_object
     :unconverted-entry-name "g_cclosure_new_object"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("GCallback") ("GObject" "*"))
     :c-arg-names (callback_func object)
     :arguments (GCallback (* GObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:195 <1371> 
;; GClosure* g_cclosure_new_object_swap( GCallback callback_func, GObject
;;   * object);
(ff:bind-c-function g_cclosure_new_object_swap
     :unconverted-entry-name "g_cclosure_new_object_swap"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("GCallback") ("GObject" "*"))
     :c-arg-names (callback_func object)
     :arguments (GCallback (* GObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:197 <1372> 
;; GClosure* g_closure_new_object( guint sizeof_closure, GObject* object);
(ff:bind-c-function g_closure_new_object
     :unconverted-entry-name "g_closure_new_object"
     :c-return-type ("GClosure" "*")
     :return-type (* GClosure)
     :c-arg-types (("guint") ("GObject" "*"))
     :c-arg-names (sizeof_closure object)
     :arguments (guint (* GObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:199 <1373> 
;; void g_value_set_object( GValue* value, gpointer v_object);
(ff:bind-c-function g_value_set_object
     :unconverted-entry-name "g_value_set_object"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gpointer"))
     :c-arg-names (value v_object)
     :arguments ((* GValue) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:201 <1374> 
;; gpointer g_value_get_object( const GValue* value);
(ff:bind-c-function g_value_get_object
     :unconverted-entry-name "g_value_get_object"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:202 <1375> 
;; GObject* g_value_dup_object( const GValue* value);
(ff:bind-c-function g_value_dup_object
     :unconverted-entry-name "g_value_dup_object"
     :c-return-type ("GObject" "*")
     :return-type (* GObject)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:203 <1376> 
;; gulong g_signal_connect_object( gpointer instance, const gchar*
;;   detailed_signal,
;;              GCallback c_handler, gpointer gobject, GConnectFlags
;;   connect_flags);
(ff:bind-c-function g_signal_connect_object
     :unconverted-entry-name "g_signal_connect_object"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("gpointer") ("const" "gchar" "*") ("GCallback")
                   ("gpointer") ("GConnectFlags"))
     :c-arg-names (instance detailed_signal c_handler gobject
                   connect_flags)
     :arguments (gpointer (* gchar) GCallback gpointer GConnectFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:211 <1377> 
;; void g_object_run_dispose( GObject* object);
(ff:bind-c-function g_object_run_dispose
     :unconverted-entry-name "g_object_run_dispose"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GObject" "*"))
     :c-arg-names (object)
     :arguments ((* GObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gobject.h:215 <1378> 
;; void g_value_set_object_take_ownership( GValue* value, gpointer v_object
;;   );
(ff:bind-c-function g_value_set_object_take_ownership
     :unconverted-entry-name "g_value_set_object_take_ownership"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gpointer"))
     :c-arg-names (value v_object)
     :arguments ((* GValue) gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:99 <1379> 
;; typedef struct _GParamSpecChar GParamSpecChar;
(ff:bind-c-typedef _GParamSpecChar
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecChar _GParamSpecChar)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:100 <1380> 
;; typedef struct _GParamSpecUChar GParamSpecUChar;
(ff:bind-c-typedef _GParamSpecUChar
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecUChar _GParamSpecUChar)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:101 <1381> 
;; typedef struct _GParamSpecBoolean GParamSpecBoolean;
(ff:bind-c-typedef _GParamSpecBoolean
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecBoolean _GParamSpecBoolean)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:102 <1382> 
;; typedef struct _GParamSpecInt GParamSpecInt;
(ff:bind-c-typedef _GParamSpecInt
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecInt _GParamSpecInt)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:103 <1383> 
;; typedef struct _GParamSpecUInt GParamSpecUInt;
(ff:bind-c-typedef _GParamSpecUInt
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecUInt _GParamSpecUInt)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:104 <1384> 
;; typedef struct _GParamSpecLong GParamSpecLong;
(ff:bind-c-typedef _GParamSpecLong
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecLong _GParamSpecLong)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:105 <1385> 
;; typedef struct _GParamSpecULong GParamSpecULong;
(ff:bind-c-typedef _GParamSpecULong
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecULong _GParamSpecULong)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:106 <1386> 
;; typedef struct _GParamSpecInt64 GParamSpecInt64;
(ff:bind-c-typedef _GParamSpecInt64
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecInt64 _GParamSpecInt64)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:107 <1387> 
;; typedef struct _GParamSpecUInt64 GParamSpecUInt64;
(ff:bind-c-typedef _GParamSpecUInt64
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecUInt64 _GParamSpecUInt64)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:108 <1388> 
;; typedef struct _GParamSpecUnichar GParamSpecUnichar;
(ff:bind-c-typedef _GParamSpecUnichar
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecUnichar _GParamSpecUnichar)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:109 <1389> 
;; typedef struct _GParamSpecEnum GParamSpecEnum;
(ff:bind-c-typedef _GParamSpecEnum
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecEnum _GParamSpecEnum)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:110 <1390> 
;; typedef struct _GParamSpecFlags GParamSpecFlags;
(ff:bind-c-typedef _GParamSpecFlags
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecFlags _GParamSpecFlags)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:111 <1391> 
;; typedef struct _GParamSpecFloat GParamSpecFloat;
(ff:bind-c-typedef _GParamSpecFloat
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecFloat _GParamSpecFloat)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:112 <1392> 
;; typedef struct _GParamSpecDouble GParamSpecDouble;
(ff:bind-c-typedef _GParamSpecDouble
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecDouble _GParamSpecDouble)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:113 <1393> 
;; typedef struct _GParamSpecString GParamSpecString;
(ff:bind-c-typedef _GParamSpecString
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecString _GParamSpecString)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:114 <1394> 
;; typedef struct _GParamSpecParam GParamSpecParam;
(ff:bind-c-typedef _GParamSpecParam
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecParam _GParamSpecParam)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:115 <1395> 
;; typedef struct _GParamSpecBoxed GParamSpecBoxed;
(ff:bind-c-typedef _GParamSpecBoxed
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecBoxed _GParamSpecBoxed)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:116 <1396> 
;; typedef struct _GParamSpecPointer GParamSpecPointer;
(ff:bind-c-typedef _GParamSpecPointer
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecPointer _GParamSpecPointer)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:117 <1397> 
;; typedef struct _GParamSpecValueArray GParamSpecValueArray;
(ff:bind-c-typedef _GParamSpecValueArray
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecValueArray _GParamSpecValueArray)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:118 <1398> 
;; typedef struct _GParamSpecObject GParamSpecObject;
(ff:bind-c-typedef _GParamSpecObject
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GParamSpecObject _GParamSpecObject)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:120 <1399> 
;; struct _GParamSpecChar {
;;         GParamSpec parent_instance; gint8 minimum; gint8 maximum; gint8
;;   default_value;
;;    };
(ff:bind-c-type _GParamSpecChar (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum gint8)   ;; gint8 minimum
  (maximum gint8)   ;; gint8 maximum
  (default_value gint8)   ;; gint8 default_value
  ))   ;; bind-c-type _GParamSpecChar
(ff:bind-c-typedef GParamSpecChar
                   _GParamSpecChar) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:128 <1400> 
;; struct _GParamSpecUChar {
;;         GParamSpec parent_instance; guint8 minimum; guint8 maximum;
;;   guint8 default_value;
;;    };
(ff:bind-c-type _GParamSpecUChar (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum guint8)   ;; guint8 minimum
  (maximum guint8)   ;; guint8 maximum
  (default_value guint8)   ;; guint8 default_value
  ))   ;; bind-c-type _GParamSpecUChar
(ff:bind-c-typedef GParamSpecUChar
                   _GParamSpecUChar) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:136 <1401> 
;; struct _GParamSpecBoolean {
;;         GParamSpec parent_instance; gboolean default_value; };
(ff:bind-c-type _GParamSpecBoolean (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (default_value gboolean)   ;; gboolean default_value
  ))   ;; bind-c-type _GParamSpecBoolean
(ff:bind-c-typedef GParamSpecBoolean
                   _GParamSpecBoolean) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:142 <1402> 
;; struct _GParamSpecInt {
;;         GParamSpec parent_instance; gint minimum; gint maximum; gint
;;   default_value;
;;    };
(ff:bind-c-type _GParamSpecInt (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum gint)   ;; gint minimum
  (maximum gint)   ;; gint maximum
  (default_value gint)   ;; gint default_value
  ))   ;; bind-c-type _GParamSpecInt
(ff:bind-c-typedef GParamSpecInt _GParamSpecInt) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:150 <1403> 
;; struct _GParamSpecUInt {
;;         GParamSpec parent_instance; guint minimum; guint maximum; guint
;;   default_value;
;;    };
(ff:bind-c-type _GParamSpecUInt (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum guint)   ;; guint minimum
  (maximum guint)   ;; guint maximum
  (default_value guint)   ;; guint default_value
  ))   ;; bind-c-type _GParamSpecUInt
(ff:bind-c-typedef GParamSpecUInt
                   _GParamSpecUInt) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:158 <1404> 
;; struct _GParamSpecLong {
;;         GParamSpec parent_instance; glong minimum; glong maximum; glong
;;   default_value;
;;    };
(ff:bind-c-type _GParamSpecLong (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum glong)   ;; glong minimum
  (maximum glong)   ;; glong maximum
  (default_value glong)   ;; glong default_value
  ))   ;; bind-c-type _GParamSpecLong
(ff:bind-c-typedef GParamSpecLong
                   _GParamSpecLong) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:166 <1405> 
;; struct _GParamSpecULong {
;;         GParamSpec parent_instance; gulong minimum; gulong maximum;
;;   gulong default_value;
;;    };
(ff:bind-c-type _GParamSpecULong (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum gulong)   ;; gulong minimum
  (maximum gulong)   ;; gulong maximum
  (default_value gulong)   ;; gulong default_value
  ))   ;; bind-c-type _GParamSpecULong
(ff:bind-c-typedef GParamSpecULong
                   _GParamSpecULong) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:174 <1406> 
;; struct _GParamSpecInt64 {
;;         GParamSpec parent_instance; gint64 minimum; gint64 maximum;
;;   gint64 default_value;
;;    };
(ff:bind-c-type _GParamSpecInt64 (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum gint64)   ;; gint64 minimum
  (maximum gint64)   ;; gint64 maximum
  (default_value gint64)   ;; gint64 default_value
  ))   ;; bind-c-type _GParamSpecInt64
(ff:bind-c-typedef GParamSpecInt64
                   _GParamSpecInt64) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:182 <1407> 
;; struct _GParamSpecUInt64 {
;;         GParamSpec parent_instance; guint64 minimum; guint64 maximum;
;;   guint64
;;    default_value; };
(ff:bind-c-type _GParamSpecUInt64 (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum guint64)   ;; guint64 minimum
  (maximum guint64)   ;; guint64 maximum
  (default_value guint64)   ;; guint64 default_value
  ))   ;; bind-c-type _GParamSpecUInt64
(ff:bind-c-typedef GParamSpecUInt64
                   _GParamSpecUInt64) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:190 <1408> 
;; struct _GParamSpecUnichar {
;;         GParamSpec parent_instance; gunichar default_value; };
(ff:bind-c-type _GParamSpecUnichar (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (default_value gunichar)   ;; gunichar default_value
  ))   ;; bind-c-type _GParamSpecUnichar
(ff:bind-c-typedef GParamSpecUnichar
                   _GParamSpecUnichar) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:196 <1409> 
;; struct _GParamSpecEnum {
;;         GParamSpec parent_instance; GEnumClass* enum_class; gint
;;   default_value;
;;    };
(ff:bind-c-type _GParamSpecEnum (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (enum_class (* GEnumClass))   ;; GEnumClass* enum_class
  (default_value gint)   ;; gint default_value
  ))   ;; bind-c-type _GParamSpecEnum
(ff:bind-c-typedef GParamSpecEnum
                   _GParamSpecEnum) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:203 <1410> 
;; struct _GParamSpecFlags {
;;         GParamSpec parent_instance; GFlagsClass* flags_class; guint
;;   default_value;
;;    };
(ff:bind-c-type _GParamSpecFlags (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (flags_class (* GFlagsClass))   ;; GFlagsClass* flags_class
  (default_value guint)   ;; guint default_value
  ))   ;; bind-c-type _GParamSpecFlags
(ff:bind-c-typedef GParamSpecFlags
                   _GParamSpecFlags) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:210 <1411> 
;; struct _GParamSpecFloat {
;;         GParamSpec parent_instance; gfloat minimum; gfloat maximum;
;;   gfloat default_value;
;;              gfloat epsilon; };
(ff:bind-c-type _GParamSpecFloat (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum gfloat)   ;; gfloat minimum
  (maximum gfloat)   ;; gfloat maximum
  (default_value gfloat)   ;; gfloat default_value
  (epsilon gfloat)   ;; gfloat epsilon
  ))   ;; bind-c-type _GParamSpecFloat
(ff:bind-c-typedef GParamSpecFloat
                   _GParamSpecFloat) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:219 <1412> 
;; struct _GParamSpecDouble {
;;         GParamSpec parent_instance; gdouble minimum; gdouble maximum;
;;   gdouble
;;    default_value; gdouble epsilon; };
(ff:bind-c-type _GParamSpecDouble (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (minimum gdouble)   ;; gdouble minimum
  (maximum gdouble)   ;; gdouble maximum
  (default_value gdouble)   ;; gdouble default_value
  (epsilon gdouble)   ;; gdouble epsilon
  ))   ;; bind-c-type _GParamSpecDouble
(ff:bind-c-typedef GParamSpecDouble
                   _GParamSpecDouble) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:228 <1413> 
;; struct _GParamSpecString {
;;         GParamSpec parent_instance; gchar* default_value; gchar*
;;   cset_first; gchar
;;   * cset_nth; gchar substitutor; guint null_fold_if_empty:  0x000000001;
;;              guint ensure_non_null:  0x000000001; };

;;WARNING: Strange bitfield null_fold_if_empty type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield ensure_non_null type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GParamSpecString (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (default_value (* gchar))   ;; gchar* default_value
  (cset_first (* gchar))   ;; gchar* cset_first
  (cset_nth (* gchar))   ;; gchar* cset_nth
  (substitutor gchar)   ;; gchar substitutor
  (null_fold_if_empty (:bit
                       1))   ;;
  ;;  guint null_fold_if_empty:  0x000000001
  (ensure_non_null (:bit 1))   ;; guint ensure_non_null:  0x000000001
  ))   ;; bind-c-type _GParamSpecString
(ff:bind-c-typedef GParamSpecString
                   _GParamSpecString) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:239 <1414> 
;; struct _GParamSpecParam { GParamSpec parent_instance; };
(ff:bind-c-type _GParamSpecParam (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  ))   ;; bind-c-type _GParamSpecParam
(ff:bind-c-typedef GParamSpecParam
                   _GParamSpecParam) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:243 <1415> 
;; struct _GParamSpecBoxed { GParamSpec parent_instance; };
(ff:bind-c-type _GParamSpecBoxed (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  ))   ;; bind-c-type _GParamSpecBoxed
(ff:bind-c-typedef GParamSpecBoxed
                   _GParamSpecBoxed) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:247 <1416> 
;; struct _GParamSpecPointer { GParamSpec parent_instance; };
(ff:bind-c-type _GParamSpecPointer (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  ))   ;; bind-c-type _GParamSpecPointer
(ff:bind-c-typedef GParamSpecPointer
                   _GParamSpecPointer) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:251 <1417> 
;; struct _GParamSpecValueArray {
;;         GParamSpec parent_instance; GParamSpec* element_spec; guint
;;   fixed_n_elements;
;;    };
(ff:bind-c-type _GParamSpecValueArray (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  (element_spec (* GParamSpec))   ;; GParamSpec* element_spec
  (fixed_n_elements guint)   ;; guint fixed_n_elements
  ))   ;; bind-c-type _GParamSpecValueArray
(ff:bind-c-typedef GParamSpecValueArray
                   _GParamSpecValueArray) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:257 <1418> 
;; struct _GParamSpecObject { GParamSpec parent_instance; };
(ff:bind-c-type _GParamSpecObject (:struct
  (parent_instance GParamSpec)   ;; GParamSpec parent_instance
  ))   ;; bind-c-type _GParamSpecObject
(ff:bind-c-typedef GParamSpecObject
                   _GParamSpecObject) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:263 <1419> 
;; GParamSpec* g_param_spec_char( const gchar* name, const gchar* nick,
;;   const
;;    gchar* blurb, gint8 minimum, gint8 maximum, gint8 default_value,
;;   GParamFlags
;;    flags);
(ff:bind-c-function g_param_spec_char
     :unconverted-entry-name "g_param_spec_char"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gint8") ("gint8") ("gint8")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) gint8 gint8 gint8
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:270 <1420> 
;; GParamSpec* g_param_spec_uchar( const gchar* name, const gchar* nick,
;;              const gchar* blurb, guint8 minimum, guint8 maximum, guint8
;;   default_value,
;;              GParamFlags flags);
(ff:bind-c-function g_param_spec_uchar
     :unconverted-entry-name "g_param_spec_uchar"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("guint8") ("guint8")
                   ("guint8") ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) guint8 guint8 guint8
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:277 <1421> 
;; GParamSpec* g_param_spec_boolean( const gchar* name, const gchar* nick,
;;              const gchar* blurb, gboolean default_value, GParamFlags
;;   flags);
(ff:bind-c-function g_param_spec_boolean
     :unconverted-entry-name "g_param_spec_boolean"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gboolean") ("GParamFlags"))
     :c-arg-names (name nick blurb default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) gboolean GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:282 <1422> 
;; GParamSpec* g_param_spec_int( const gchar* name, const gchar* nick,
;;   const
;;    gchar* blurb, gint minimum, gint maximum, gint default_value,
;;   GParamFlags
;;    flags);
(ff:bind-c-function g_param_spec_int
     :unconverted-entry-name "g_param_spec_int"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gint") ("gint") ("gint")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) gint gint gint
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:289 <1423> 
;; GParamSpec* g_param_spec_uint( const gchar* name, const gchar* nick,
;;   const
;;    gchar* blurb, guint minimum, guint maximum, guint default_value,
;;   GParamFlags
;;    flags);
(ff:bind-c-function g_param_spec_uint
     :unconverted-entry-name "g_param_spec_uint"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("guint") ("guint") ("guint")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) guint guint guint
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:296 <1424> 
;; GParamSpec* g_param_spec_long( const gchar* name, const gchar* nick,
;;   const
;;    gchar* blurb, glong minimum, glong maximum, glong default_value,
;;   GParamFlags
;;    flags);
(ff:bind-c-function g_param_spec_long
     :unconverted-entry-name "g_param_spec_long"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("glong") ("glong") ("glong")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) glong glong glong
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:303 <1425> 
;; GParamSpec* g_param_spec_ulong( const gchar* name, const gchar* nick,
;;              const gchar* blurb, gulong minimum, gulong maximum, gulong
;;   default_value,
;;              GParamFlags flags);
(ff:bind-c-function g_param_spec_ulong
     :unconverted-entry-name "g_param_spec_ulong"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gulong") ("gulong")
                   ("gulong") ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) gulong gulong gulong
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:310 <1426> 
;; GParamSpec* g_param_spec_int64( const gchar* name, const gchar* nick,
;;              const gchar* blurb, gint64 minimum, gint64 maximum, gint64
;;   default_value,
;;              GParamFlags flags);

;;NOTE: C wrapper needed to pass structure or union type
;;   gint64
;;   as argument.

;;NOTE: C wrapper needed to pass structure or union type
;;   gint64
;;   as argument.

;;NOTE: C wrapper needed to pass structure or union type
;;   gint64
;;   as argument.
(ff:bind-c-function g_param_spec_int64
     :unconverted-entry-name "ACL_g_param_spec_int64"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gint64" "*") ("gint64" "*")
                   ("gint64" "*") ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) (* gint64) (* gint64)
                 (* gint64) GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:317 <1427> 
;; GParamSpec* g_param_spec_uint64( const gchar* name, const gchar* nick,
;;              const gchar* blurb, guint64 minimum, guint64 maximum,
;;   guint64 default_value,
;;              GParamFlags flags);

;;NOTE: C wrapper needed to pass structure or union type
;;   guint64
;;   as argument.

;;NOTE: C wrapper needed to pass structure or union type
;;   guint64
;;   as argument.

;;NOTE: C wrapper needed to pass structure or union type
;;   guint64
;;   as argument.
(ff:bind-c-function g_param_spec_uint64
     :unconverted-entry-name "ACL_g_param_spec_uint64"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("guint64" "*")
                   ("guint64" "*") ("guint64" "*") ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) (* guint64) (* guint64)
                 (* guint64) GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:324 <1428> 
;; GParamSpec* g_param_spec_unichar( const gchar* name, const gchar* nick,
;;              const gchar* blurb, gunichar default_value, GParamFlags
;;   flags);
(ff:bind-c-function g_param_spec_unichar
     :unconverted-entry-name "g_param_spec_unichar"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gunichar") ("GParamFlags"))
     :c-arg-names (name nick blurb default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) gunichar GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:329 <1429> 
;; GParamSpec* g_param_spec_enum( const gchar* name, const gchar* nick,
;;   const
;;    gchar* blurb, GType enum_type, gint default_value, GParamFlags flags)
;;   ;
(ff:bind-c-function g_param_spec_enum
     :unconverted-entry-name "g_param_spec_enum"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("GType") ("gint")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb enum_type default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) GType gint GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:335 <1430> 
;; GParamSpec* g_param_spec_flags( const gchar* name, const gchar* nick,
;;              const gchar* blurb, GType flags_type, guint default_value,
;;   GParamFlags
;;    flags);
(ff:bind-c-function g_param_spec_flags
     :unconverted-entry-name "g_param_spec_flags"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("GType") ("guint")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb flags_type default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) GType guint GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:341 <1431> 
;; GParamSpec* g_param_spec_float( const gchar* name, const gchar* nick,
;;              const gchar* blurb, gfloat minimum, gfloat maximum, gfloat
;;   default_value,
;;              GParamFlags flags);
(ff:bind-c-function g_param_spec_float
     :unconverted-entry-name "g_param_spec_float"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gfloat") ("gfloat")
                   ("gfloat") ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) gfloat gfloat gfloat
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:348 <1432> 
;; GParamSpec* g_param_spec_double( const gchar* name, const gchar* nick,
;;              const gchar* blurb, gdouble minimum, gdouble maximum,
;;   gdouble default_value,
;;              GParamFlags flags);
(ff:bind-c-function g_param_spec_double
     :unconverted-entry-name "g_param_spec_double"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gdouble") ("gdouble")
                   ("gdouble") ("GParamFlags"))
     :c-arg-names (name nick blurb minimum maximum default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) gdouble gdouble gdouble
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:355 <1433> 
;; GParamSpec* g_param_spec_string( const gchar* name, const gchar* nick,
;;              const gchar* blurb, const gchar* default_value, GParamFlags
;;   flags);
(ff:bind-c-function g_param_spec_string
     :unconverted-entry-name "g_param_spec_string"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("const" "gchar" "*")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb default_value flags)
     :arguments ((* gchar) (* gchar) (* gchar) (* gchar) GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:360 <1434> 
;; GParamSpec* g_param_spec_param( const gchar* name, const gchar* nick,
;;              const gchar* blurb, GType param_type, GParamFlags flags);
(ff:bind-c-function g_param_spec_param
     :unconverted-entry-name "g_param_spec_param"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("GType") ("GParamFlags"))
     :c-arg-names (name nick blurb param_type flags)
     :arguments ((* gchar) (* gchar) (* gchar) GType GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:365 <1435> 
;; GParamSpec* g_param_spec_boxed( const gchar* name, const gchar* nick,
;;              const gchar* blurb, GType boxed_type, GParamFlags flags);
(ff:bind-c-function g_param_spec_boxed
     :unconverted-entry-name "g_param_spec_boxed"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("GType") ("GParamFlags"))
     :c-arg-names (name nick blurb boxed_type flags)
     :arguments ((* gchar) (* gchar) (* gchar) GType GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:370 <1436> 
;; GParamSpec* g_param_spec_pointer( const gchar* name, const gchar* nick,
;;              const gchar* blurb, GParamFlags flags);
(ff:bind-c-function g_param_spec_pointer
     :unconverted-entry-name "g_param_spec_pointer"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("GParamFlags"))
     :c-arg-names (name nick blurb flags)
     :arguments ((* gchar) (* gchar) (* gchar) GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:374 <1437> 
;; GParamSpec* g_param_spec_value_array( const gchar* name, const gchar*
;;    nick, const gchar* blurb, GParamSpec* element_spec, GParamFlags flags
;;   );
(ff:bind-c-function g_param_spec_value_array
     :unconverted-entry-name "g_param_spec_value_array"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("GParamSpec" "*")
                   ("GParamFlags"))
     :c-arg-names (name nick blurb element_spec flags)
     :arguments ((* gchar) (* gchar) (* gchar) (* GParamSpec)
                 GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:379 <1438> 
;; GParamSpec* g_param_spec_object( const gchar* name, const gchar* nick,
;;              const gchar* blurb, GType object_type, GParamFlags flags);
(ff:bind-c-function g_param_spec_object
     :unconverted-entry-name "g_param_spec_object"
     :c-return-type ("GParamSpec" "*")
     :return-type (* GParamSpec)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("GType") ("GParamFlags"))
     :c-arg-names (name nick blurb object_type flags)
     :arguments ((* gchar) (* gchar) (* gchar) GType GParamFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gparamspecs.h:410 <1439> 
;; extern GType* g_param_spec_types;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_param_spec_types"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsourceclosure.h:29 <1440> 
;; void g_source_set_closure( GSource* source, GClosure* closure);
(ff:bind-c-function g_source_set_closure
     :unconverted-entry-name "g_source_set_closure"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSource" "*") ("GClosure" "*"))
     :c-arg-names (source closure)
     :arguments ((* GSource) (* GClosure))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsourceclosure.h:32 <1441> 
;; GType g_io_channel_get_type( void);
(ff:bind-c-function g_io_channel_get_type
     :unconverted-entry-name "g_io_channel_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gsourceclosure.h:33 <1442> 
;; GType g_io_condition_get_type( void);
(ff:bind-c-function g_io_condition_get_type
     :unconverted-entry-name "g_io_condition_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:30 <1443> 
;; typedef struct _GTypeModule GTypeModule;
(ff:bind-c-typedef _GTypeModule
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeModule _GTypeModule)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:31 <1444> 
;; typedef struct _GTypeModuleClass GTypeModuleClass;
(ff:bind-c-typedef _GTypeModuleClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypeModuleClass _GTypeModuleClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:40 <1445> 
;; struct _GTypeModule {
;;         GObject parent_instance; guint use_count; GSList* type_infos;
;;   GSList*
;;    interface_infos; gchar* name; };
(ff:bind-c-type _GTypeModule (:struct
  (parent_instance GObject)   ;; GObject parent_instance
  (use_count guint)   ;; guint use_count
  (type_infos (* GSList))   ;; GSList* type_infos
  (interface_infos (* GSList))   ;; GSList* interface_infos
  (name (* gchar))   ;; gchar* name
  ))   ;; bind-c-type _GTypeModule
(ff:bind-c-typedef GTypeModule _GTypeModule) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:50 <1446> 
;; struct _GTypeModuleClass {
;;         GObjectClass parent_class; gboolean(* load)( GTypeModule*
;;   module); void
;;   (* unload)( GTypeModule* module); void(* reserved1)( void); void(*
;;   reserved2
;;   )( void); void(* reserved3)( void); void(* reserved4)( void); };
(ff:bind-c-type _GTypeModuleClass (:struct
  (parent_class GObjectClass)   ;; GObjectClass parent_class
  (load ff:function-pointer)   ;; gboolean(* load)( GTypeModule* module)
  (unload ff:function-pointer)   ;; void(* unload)( GTypeModule* module)
  (reserved1 ff:function-pointer)   ;; void(* reserved1)( void)
  (reserved2 ff:function-pointer)   ;; void(* reserved2)( void)
  (reserved3 ff:function-pointer)   ;; void(* reserved3)( void)
  (reserved4 ff:function-pointer)   ;; void(* reserved4)( void)
  ))   ;; bind-c-type _GTypeModuleClass
(ff:bind-c-typedef GTypeModuleClass
                   _GTypeModuleClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:64 <1447> 
;; GType g_type_module_get_type( void);
(ff:bind-c-function g_type_module_get_type
     :unconverted-entry-name "g_type_module_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:65 <1448> 
;; gboolean g_type_module_use( GTypeModule* module);
(ff:bind-c-function g_type_module_use
     :unconverted-entry-name "g_type_module_use"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GTypeModule" "*"))
     :c-arg-names (module)
     :arguments ((* GTypeModule))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:66 <1449> 
;; void g_type_module_unuse( GTypeModule* module);
(ff:bind-c-function g_type_module_unuse
     :unconverted-entry-name "g_type_module_unuse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypeModule" "*"))
     :c-arg-names (module)
     :arguments ((* GTypeModule))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:67 <1450> 
;; void g_type_module_set_name( GTypeModule* module, const gchar* name);
(ff:bind-c-function g_type_module_set_name
     :unconverted-entry-name "g_type_module_set_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypeModule" "*") ("const" "gchar" "*"))
     :c-arg-names (module name)
     :arguments ((* GTypeModule) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:69 <1451> 
;; GType g_type_module_register_type( GTypeModule* module, GType
;;   parent_type,
;;              const gchar* type_name, const GTypeInfo* type_info,
;;   GTypeFlags flags)
;;   ;
(ff:bind-c-function g_type_module_register_type
     :unconverted-entry-name "g_type_module_register_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("GTypeModule" "*") ("GType") ("const" "gchar" "*")
                   ("const" "GTypeInfo" "*") ("GTypeFlags"))
     :c-arg-names (module parent_type type_name type_info flags)
     :arguments ((* GTypeModule) GType (* gchar) (* GTypeInfo)
                 GTypeFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypemodule.h:74 <1452> 
;; void g_type_module_add_interface( GTypeModule* module, GType
;;   instance_type,
;;              GType interface_type, const GInterfaceInfo*
;;   interface_info);
(ff:bind-c-function g_type_module_add_interface
     :unconverted-entry-name "g_type_module_add_interface"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypeModule" "*") ("GType") ("GType")
                   ("const" "GInterfaceInfo" "*"))
     :c-arg-names (module instance_type interface_type interface_info)
     :arguments ((* GTypeModule) GType GType (* GInterfaceInfo))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:40 <1453> 
;; typedef struct _GTypePluginClass GTypePluginClass;
(ff:bind-c-typedef _GTypePluginClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTypePluginClass _GTypePluginClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:41 <1454> 
;; typedef void(* GTypePluginUse)( GTypePlugin* plugin);
(ff:bind-c-type GTypePluginUse (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:42 <1455> 
;; typedef void(* GTypePluginUnuse)( GTypePlugin* plugin);
(ff:bind-c-type GTypePluginUnuse (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:43 <1456> 
;; typedef void(* GTypePluginCompleteTypeInfo)( GTypePlugin* plugin, GType
;;    g_type, GTypeInfo* info, GTypeValueTable* value_table);
(ff:bind-c-type GTypePluginCompleteTypeInfo (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:47 <1457> 
;; typedef void(* GTypePluginCompleteInterfaceInfo)( GTypePlugin* plugin,
;;              GType interface_type, GType instance_type, GInterfaceInfo*
;;   info);
(ff:bind-c-type GTypePluginCompleteInterfaceInfo (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:51 <1458> 
;; struct _GTypePluginClass {
;;         GTypeInterface base_iface; GTypePluginUse use_plugin;
;;   GTypePluginUnuse
;;    unuse_plugin; GTypePluginCompleteTypeInfo complete_type_info;
;;   GTypePluginCompleteInterfaceInfo
;;    complete_interface_info; };
(ff:bind-c-type _GTypePluginClass (:struct
  (base_iface GTypeInterface)   ;; GTypeInterface base_iface
  (use_plugin GTypePluginUse)   ;; GTypePluginUse use_plugin
  (unuse_plugin GTypePluginUnuse)   ;; GTypePluginUnuse unuse_plugin
  (complete_type_info GTypePluginCompleteTypeInfo)   ;;
  ;;  GTypePluginCompleteTypeInfo complete_type_info
  (complete_interface_info GTypePluginCompleteInterfaceInfo)   ;;
  ;;  GTypePluginCompleteInterfaceInfo complete_interface_info
  ))   ;; bind-c-type _GTypePluginClass
(ff:bind-c-typedef GTypePluginClass
                   _GTypePluginClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:63 <1459> 
;; GType g_type_plugin_get_type( void);
(ff:bind-c-function g_type_plugin_get_type
     :unconverted-entry-name "g_type_plugin_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:64 <1460> 
;; void g_type_plugin_use( GTypePlugin* plugin);
(ff:bind-c-function g_type_plugin_use
     :unconverted-entry-name "g_type_plugin_use"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypePlugin" "*"))
     :c-arg-names (plugin)
     :arguments ((* GTypePlugin))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:65 <1461> 
;; void g_type_plugin_unuse( GTypePlugin* plugin);
(ff:bind-c-function g_type_plugin_unuse
     :unconverted-entry-name "g_type_plugin_unuse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypePlugin" "*"))
     :c-arg-names (plugin)
     :arguments ((* GTypePlugin))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:66 <1462> 
;; void g_type_plugin_complete_type_info( GTypePlugin* plugin, GType
;;   g_type,
;;              GTypeInfo* info, GTypeValueTable* value_table);
(ff:bind-c-function g_type_plugin_complete_type_info
     :unconverted-entry-name "g_type_plugin_complete_type_info"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypePlugin" "*") ("GType") ("GTypeInfo" "*")
                   ("GTypeValueTable" "*"))
     :c-arg-names (plugin g_type info value_table)
     :arguments ((* GTypePlugin) GType (* GTypeInfo)
                 (* GTypeValueTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gtypeplugin.h:70 <1463> 
;; void g_type_plugin_complete_interface_info( GTypePlugin* plugin, GType
;;    interface_type, GType instance_type, GInterfaceInfo* info);
(ff:bind-c-function g_type_plugin_complete_interface_info
     :unconverted-entry-name "g_type_plugin_complete_interface_info"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTypePlugin" "*") ("GType") ("GType")
                   ("GInterfaceInfo" "*"))
     :c-arg-names (plugin interface_type instance_type info)
     :arguments ((* GTypePlugin) GType GType (* GInterfaceInfo))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:37 <1464> 
;; typedef struct _GValueArray GValueArray;
(ff:bind-c-typedef _GValueArray
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GValueArray _GValueArray)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:38 <1465> 
;; struct _GValueArray {
;;         guint n_values; GValue* values; guint n_prealloced; };
(ff:bind-c-type _GValueArray (:struct
  (n_values guint)   ;; guint n_values
  (values (* GValue))   ;; GValue* values
  (n_prealloced guint)   ;; guint n_prealloced
  ))   ;; bind-c-type _GValueArray
(ff:bind-c-typedef GValueArray _GValueArray) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:49 <1466> 
;; GValue* g_value_array_get_nth( GValueArray* value_array, guint index);
(ff:bind-c-function g_value_array_get_nth
     :unconverted-entry-name "g_value_array_get_nth"
     :c-return-type ("GValue" "*")
     :return-type (* GValue)
     :c-arg-types (("GValueArray" "*") ("guint"))
     :c-arg-names (value_array index)
     :arguments ((* GValueArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:51 <1467> 
;; GValueArray* g_value_array_new( guint n_prealloced);
(ff:bind-c-function g_value_array_new
     :unconverted-entry-name "g_value_array_new"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("guint"))
     :c-arg-names (n_prealloced)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:52 <1468> 
;; void g_value_array_free( GValueArray* value_array);
(ff:bind-c-function g_value_array_free
     :unconverted-entry-name "g_value_array_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValueArray" "*"))
     :c-arg-names (value_array)
     :arguments ((* GValueArray))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:53 <1469> 
;; GValueArray* g_value_array_copy( const GValueArray* value_array);
(ff:bind-c-function g_value_array_copy
     :unconverted-entry-name "g_value_array_copy"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("const" "GValueArray" "*"))
     :c-arg-names (value_array)
     :arguments ((* GValueArray))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:54 <1470> 
;; GValueArray* g_value_array_prepend( GValueArray* value_array, const
;;   GValue
;;   * value);
(ff:bind-c-function g_value_array_prepend
     :unconverted-entry-name "g_value_array_prepend"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("GValueArray" "*") ("const" "GValue" "*"))
     :c-arg-names (value_array value)
     :arguments ((* GValueArray) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:56 <1471> 
;; GValueArray* g_value_array_append( GValueArray* value_array, const
;;   GValue
;;   * value);
(ff:bind-c-function g_value_array_append
     :unconverted-entry-name "g_value_array_append"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("GValueArray" "*") ("const" "GValue" "*"))
     :c-arg-names (value_array value)
     :arguments ((* GValueArray) (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:58 <1472> 
;; GValueArray* g_value_array_insert( GValueArray* value_array, guint
;;   index,
;;              const GValue* value);
(ff:bind-c-function g_value_array_insert
     :unconverted-entry-name "g_value_array_insert"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("GValueArray" "*") ("guint") ("const" "GValue" "*"))
     :c-arg-names (value_array index value)
     :arguments ((* GValueArray) guint (* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:61 <1473> 
;; GValueArray* g_value_array_remove( GValueArray* value_array, guint index
;;   );
(ff:bind-c-function g_value_array_remove
     :unconverted-entry-name "g_value_array_remove"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("GValueArray" "*") ("guint"))
     :c-arg-names (value_array index)
     :arguments ((* GValueArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:63 <1474> 
;; GValueArray* g_value_array_sort( GValueArray* value_array, GCompareFunc
;;    compare_func);
(ff:bind-c-function g_value_array_sort
     :unconverted-entry-name "g_value_array_sort"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("GValueArray" "*") ("GCompareFunc"))
     :c-arg-names (value_array compare_func)
     :arguments ((* GValueArray) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluearray.h:65 <1475> 
;; GValueArray* g_value_array_sort_with_data( GValueArray* value_array,
;;   GCompareDataFunc
;;    compare_func, gpointer user_data);
(ff:bind-c-function g_value_array_sort_with_data
     :unconverted-entry-name "g_value_array_sort_with_data"
     :c-return-type ("GValueArray" "*")
     :return-type (* GValueArray)
     :c-arg-types (("GValueArray" "*") ("GCompareDataFunc")
                   ("gpointer"))
     :c-arg-names (value_array compare_func user_data)
     :arguments ((* GValueArray) GCompareDataFunc gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:49 <1476> 
;; void g_value_set_char( GValue* value, gchar v_char);
(ff:bind-c-function g_value_set_char
     :unconverted-entry-name "g_value_set_char"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gchar"))
     :c-arg-names (value v_char)
     :arguments ((* GValue) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:51 <1477> 
;; gchar g_value_get_char( const GValue* value);
(ff:bind-c-function g_value_get_char
     :unconverted-entry-name "g_value_get_char"
     :c-return-type ("gchar")
     :return-type gchar
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:52 <1478> 
;; void g_value_set_uchar( GValue* value, guchar v_uchar);
(ff:bind-c-function g_value_set_uchar
     :unconverted-entry-name "g_value_set_uchar"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("guchar"))
     :c-arg-names (value v_uchar)
     :arguments ((* GValue) guchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:54 <1479> 
;; guchar g_value_get_uchar( const GValue* value);
(ff:bind-c-function g_value_get_uchar
     :unconverted-entry-name "g_value_get_uchar"
     :c-return-type ("guchar")
     :return-type guchar
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:55 <1480> 
;; void g_value_set_boolean( GValue* value, gboolean v_boolean);
(ff:bind-c-function g_value_set_boolean
     :unconverted-entry-name "g_value_set_boolean"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gboolean"))
     :c-arg-names (value v_boolean)
     :arguments ((* GValue) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:57 <1481> 
;; gboolean g_value_get_boolean( const GValue* value);
(ff:bind-c-function g_value_get_boolean
     :unconverted-entry-name "g_value_get_boolean"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:58 <1482> 
;; void g_value_set_int( GValue* value, gint v_int);
(ff:bind-c-function g_value_set_int
     :unconverted-entry-name "g_value_set_int"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gint"))
     :c-arg-names (value v_int)
     :arguments ((* GValue) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:60 <1483> 
;; gint g_value_get_int( const GValue* value);
(ff:bind-c-function g_value_get_int
     :unconverted-entry-name "g_value_get_int"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:61 <1484> 
;; void g_value_set_uint( GValue* value, guint v_uint);
(ff:bind-c-function g_value_set_uint
     :unconverted-entry-name "g_value_set_uint"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("guint"))
     :c-arg-names (value v_uint)
     :arguments ((* GValue) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:63 <1485> 
;; guint g_value_get_uint( const GValue* value);
(ff:bind-c-function g_value_get_uint
     :unconverted-entry-name "g_value_get_uint"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:64 <1486> 
;; void g_value_set_long( GValue* value, glong v_long);
(ff:bind-c-function g_value_set_long
     :unconverted-entry-name "g_value_set_long"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("glong"))
     :c-arg-names (value v_long)
     :arguments ((* GValue) glong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:66 <1487> 
;; glong g_value_get_long( const GValue* value);
(ff:bind-c-function g_value_get_long
     :unconverted-entry-name "g_value_get_long"
     :c-return-type ("glong")
     :return-type glong
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:67 <1488> 
;; void g_value_set_ulong( GValue* value, gulong v_ulong);
(ff:bind-c-function g_value_set_ulong
     :unconverted-entry-name "g_value_set_ulong"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gulong"))
     :c-arg-names (value v_ulong)
     :arguments ((* GValue) gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:69 <1489> 
;; gulong g_value_get_ulong( const GValue* value);
(ff:bind-c-function g_value_get_ulong
     :unconverted-entry-name "g_value_get_ulong"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:70 <1490> 
;; void g_value_set_int64( GValue* value, gint64 v_int64);

;;NOTE: C wrapper needed to pass structure or union type
;;   gint64
;;   as argument.
(ff:bind-c-function g_value_set_int64
     :unconverted-entry-name "ACL_g_value_set_int64"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gint64" "*"))
     :c-arg-names (value v_int64)
     :arguments ((* GValue) (* gint64))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:72 <1491> 
;; gint64 g_value_get_int64( const GValue* value);

;;NOTE: C wrapper needed to return structure or union type
;;   gint64.
(ff:bind-c-function g_value_get_int64
     :unconverted-entry-name "ACL_g_value_get_int64"
     :c-return-type ("gint64" "*")
     :return-type (* gint64)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:73 <1492> 
;; void g_value_set_uint64( GValue* value, guint64 v_uint64);

;;NOTE: C wrapper needed to pass structure or union type
;;   guint64
;;   as argument.
(ff:bind-c-function g_value_set_uint64
     :unconverted-entry-name "ACL_g_value_set_uint64"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("guint64" "*"))
     :c-arg-names (value v_uint64)
     :arguments ((* GValue) (* guint64))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:75 <1493> 
;; guint64 g_value_get_uint64( const GValue* value);

;;NOTE: C wrapper needed to return structure or union type
;;   guint64.
(ff:bind-c-function g_value_get_uint64
     :unconverted-entry-name "ACL_g_value_get_uint64"
     :c-return-type ("guint64" "*")
     :return-type (* guint64)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:76 <1494> 
;; void g_value_set_float( GValue* value, gfloat v_float);
(ff:bind-c-function g_value_set_float
     :unconverted-entry-name "g_value_set_float"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gfloat"))
     :c-arg-names (value v_float)
     :arguments ((* GValue) gfloat)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:78 <1495> 
;; gfloat g_value_get_float( const GValue* value);
(ff:bind-c-function g_value_get_float
     :unconverted-entry-name "g_value_get_float"
     :c-return-type ("gfloat")
     :return-type gfloat
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:79 <1496> 
;; void g_value_set_double( GValue* value, gdouble v_double);
(ff:bind-c-function g_value_set_double
     :unconverted-entry-name "g_value_set_double"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gdouble"))
     :c-arg-names (value v_double)
     :arguments ((* GValue) gdouble)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:81 <1497> 
;; gdouble g_value_get_double( const GValue* value);
(ff:bind-c-function g_value_get_double
     :unconverted-entry-name "g_value_get_double"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:82 <1498> 
;; void g_value_set_string( GValue* value, const gchar* v_string);
(ff:bind-c-function g_value_set_string
     :unconverted-entry-name "g_value_set_string"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("const" "gchar" "*"))
     :c-arg-names (value v_string)
     :arguments ((* GValue) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:84 <1499> 
;; void g_value_set_static_string( GValue* value, const gchar* v_string);
(ff:bind-c-function g_value_set_static_string
     :unconverted-entry-name "g_value_set_static_string"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("const" "gchar" "*"))
     :c-arg-names (value v_string)
     :arguments ((* GValue) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:86 <1500> 
;; const gchar* g_value_get_string( const GValue* value);
(ff:bind-c-function g_value_get_string
     :unconverted-entry-name "g_value_get_string"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:87 <1501> 
;; gchar* g_value_dup_string( const GValue* value);
(ff:bind-c-function g_value_dup_string
     :unconverted-entry-name "g_value_dup_string"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:88 <1502> 
;; void g_value_set_pointer( GValue* value, gpointer v_pointer);
(ff:bind-c-function g_value_set_pointer
     :unconverted-entry-name "g_value_set_pointer"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gpointer"))
     :c-arg-names (value v_pointer)
     :arguments ((* GValue) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:90 <1503> 
;; gpointer g_value_get_pointer( const GValue* value);
(ff:bind-c-function g_value_get_pointer
     :unconverted-entry-name "g_value_get_pointer"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:94 <1504> 
;; GType g_pointer_type_register_static( const gchar* name);
(ff:bind-c-function g_pointer_type_register_static
     :unconverted-entry-name "g_pointer_type_register_static"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:97 <1505> 
;; gchar* g_strdup_value_contents( const GValue* value);
(ff:bind-c-function g_strdup_value_contents
     :unconverted-entry-name "g_strdup_value_contents"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "GValue" "*"))
     :c-arg-names (value)
     :arguments ((* GValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:101 <1506> 
;; void g_value_set_string_take_ownership( GValue* value, gchar* v_string);
(ff:bind-c-function g_value_set_string_take_ownership
     :unconverted-entry-name "g_value_set_string_take_ownership"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GValue" "*") ("gchar" "*"))
     :c-arg-names (value v_string)
     :arguments ((* GValue) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/glib-2.0/gobject/gvaluetypes.h:106 <1507> 
;; typedef gchar* gchararray;
(ff:bind-c-type gchararray (* gchar))  

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:30 <1508> 
;; typedef struct _PangoLogAttr PangoLogAttr;
(ff:bind-c-typedef _PangoLogAttr
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoLogAttr _PangoLogAttr)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:32 <1509> 
;; typedef struct _PangoEngineLang PangoEngineLang;
(ff:bind-c-typedef _PangoEngineLang
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoEngineLang _PangoEngineLang)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:33 <1510> 
;; typedef struct _PangoEngineShape PangoEngineShape;
(ff:bind-c-typedef _PangoEngineShape
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoEngineShape _PangoEngineShape)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:35 <1511> 
;; typedef struct _PangoFont PangoFont;
(ff:bind-c-typedef _PangoFont
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoFont _PangoFont)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:36 <1512> 
;; typedef struct _PangoRectangle PangoRectangle;
(ff:bind-c-typedef _PangoRectangle
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoRectangle _PangoRectangle)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:39 <1513> 
;; typedef struct _PangoLanguage PangoLanguage;
(ff:bind-c-typedef _PangoLanguage
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoLanguage _PangoLanguage)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:43 <1514> 
;; typedef guint32 PangoGlyph;
(ff:bind-c-type PangoGlyph guint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:48 <1515> 
;; struct _PangoRectangle { int x; int y; int width; int height; };
(ff:bind-c-type _PangoRectangle (:struct
  (x :int)   ;; int x
  (y :int)   ;; int y
  (width :int)   ;; int width
  (height :int)   ;; int height
  ))   ;; bind-c-type _PangoRectangle
(ff:bind-c-typedef PangoRectangle
                   _PangoRectangle) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:72 <1516> 
;; typedef enum {
;;         PANGO_DIRECTION_LTR, PANGO_DIRECTION_RTL,
;;   PANGO_DIRECTION_TTB_LTR, PANGO_DIRECTION_TTB_RTL
;;    } PangoDirection;
(ff:bind-c-constant PANGO_DIRECTION_LTR 0) ;;  PANGO_DIRECTION_LTR 
(ff:bind-c-constant PANGO_DIRECTION_RTL 1) ;;  PANGO_DIRECTION_RTL 
(ff:bind-c-constant PANGO_DIRECTION_TTB_LTR
                    2) ;;
;;   PANGO_DIRECTION_TTB_LTR 
(ff:bind-c-constant PANGO_DIRECTION_TTB_RTL
                    3) ;;
;;   PANGO_DIRECTION_TTB_RTL 
(ff:bind-c-type PangoDirection :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:81 <1517> 
;; GType pango_language_get_type( void);
(ff:bind-c-function pango_language_get_type
     :unconverted-entry-name "pango_language_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:82 <1518> 
;; PangoLanguage* pango_language_from_string( const char* language);
(ff:bind-c-function pango_language_from_string
     :unconverted-entry-name "pango_language_from_string"
     :c-return-type ("PangoLanguage" "*")
     :return-type (* PangoLanguage)
     :c-arg-types (("const" "char" "*"))
     :c-arg-names (language)
     :arguments ((* :char))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-types.h:85 <1519> 
;; gboolean pango_language_matches( PangoLanguage* language, const char*
;;    range_list);
(ff:bind-c-function pango_language_matches
     :unconverted-entry-name "pango_language_matches"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLanguage" "*") ("const" "char" "*"))
     :c-arg-names (language range_list)
     :arguments ((* PangoLanguage) (* :char))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:32 <1520> 
;; typedef struct _PangoFontDescription PangoFontDescription;
(ff:bind-c-typedef _PangoFontDescription
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoFontDescription _PangoFontDescription)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:33 <1521> 
;; typedef struct _PangoFontMetrics PangoFontMetrics;
(ff:bind-c-typedef _PangoFontMetrics
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoFontMetrics _PangoFontMetrics)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:43 <1522> 
;; typedef enum {
;;         PANGO_STYLE_NORMAL, PANGO_STYLE_OBLIQUE, PANGO_STYLE_ITALIC }
;;   PangoStyle
;;   ;
(ff:bind-c-constant PANGO_STYLE_NORMAL 0) ;;  PANGO_STYLE_NORMAL 
(ff:bind-c-constant PANGO_STYLE_OBLIQUE 1) ;;  PANGO_STYLE_OBLIQUE 
(ff:bind-c-constant PANGO_STYLE_ITALIC 2) ;;  PANGO_STYLE_ITALIC 
(ff:bind-c-type PangoStyle :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:49 <1523> 
;; typedef enum {
;;         PANGO_VARIANT_NORMAL, PANGO_VARIANT_SMALL_CAPS } PangoVariant;
(ff:bind-c-constant PANGO_VARIANT_NORMAL 0) ;;  PANGO_VARIANT_NORMAL 
(ff:bind-c-constant PANGO_VARIANT_SMALL_CAPS
                    1) ;;
;;   PANGO_VARIANT_SMALL_CAPS 
(ff:bind-c-type PangoVariant :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:54 <1524> 
;; typedef enum {
;;         PANGO_WEIGHT_ULTRALIGHT =  0x0000000c8, PANGO_WEIGHT_LIGHT =
;;   0x00000012c,
;;              PANGO_WEIGHT_NORMAL =  0x000000190, PANGO_WEIGHT_BOLD =
;;   0x0000002bc,
;;              PANGO_WEIGHT_ULTRABOLD =  0x000000320, PANGO_WEIGHT_HEAVY =
;;   0x000000384
;;    } PangoWeight;
(ff:bind-c-constant PANGO_WEIGHT_ULTRALIGHT
                    200) ;;
;;   PANGO_WEIGHT_ULTRALIGHT =  0x0000000c8 
(ff:bind-c-constant PANGO_WEIGHT_LIGHT
                    300) ;;
;;   PANGO_WEIGHT_LIGHT =  0x00000012c 
(ff:bind-c-constant PANGO_WEIGHT_NORMAL
                    400) ;;
;;   PANGO_WEIGHT_NORMAL =  0x000000190 
(ff:bind-c-constant PANGO_WEIGHT_BOLD
                    700) ;;
;;   PANGO_WEIGHT_BOLD =  0x0000002bc 
(ff:bind-c-constant PANGO_WEIGHT_ULTRABOLD
                    800) ;;
;;   PANGO_WEIGHT_ULTRABOLD =  0x000000320 
(ff:bind-c-constant PANGO_WEIGHT_HEAVY
                    900) ;;
;;   PANGO_WEIGHT_HEAVY =  0x000000384 
(ff:bind-c-type PangoWeight :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:63 <1525> 
;; typedef enum {
;;         PANGO_STRETCH_ULTRA_CONDENSED, PANGO_STRETCH_EXTRA_CONDENSED,
;;   PANGO_STRETCH_CONDENSED,
;;              PANGO_STRETCH_SEMI_CONDENSED, PANGO_STRETCH_NORMAL,
;;   PANGO_STRETCH_SEMI_EXPANDED,
;;              PANGO_STRETCH_EXPANDED, PANGO_STRETCH_EXTRA_EXPANDED,
;;   PANGO_STRETCH_ULTRA_EXPANDED
;;    } PangoStretch;
(ff:bind-c-constant PANGO_STRETCH_ULTRA_CONDENSED
                    0) ;;
;;   PANGO_STRETCH_ULTRA_CONDENSED 
(ff:bind-c-constant PANGO_STRETCH_EXTRA_CONDENSED
                    1) ;;
;;   PANGO_STRETCH_EXTRA_CONDENSED 
(ff:bind-c-constant PANGO_STRETCH_CONDENSED
                    2) ;;
;;   PANGO_STRETCH_CONDENSED 
(ff:bind-c-constant PANGO_STRETCH_SEMI_CONDENSED
                    3) ;;
;;   PANGO_STRETCH_SEMI_CONDENSED 
(ff:bind-c-constant PANGO_STRETCH_NORMAL 4) ;;  PANGO_STRETCH_NORMAL 
(ff:bind-c-constant PANGO_STRETCH_SEMI_EXPANDED
                    5) ;;
;;   PANGO_STRETCH_SEMI_EXPANDED 
(ff:bind-c-constant PANGO_STRETCH_EXPANDED
                    6) ;;
;;   PANGO_STRETCH_EXPANDED 
(ff:bind-c-constant PANGO_STRETCH_EXTRA_EXPANDED
                    7) ;;
;;   PANGO_STRETCH_EXTRA_EXPANDED 
(ff:bind-c-constant PANGO_STRETCH_ULTRA_EXPANDED
                    8) ;;
;;   PANGO_STRETCH_ULTRA_EXPANDED 
(ff:bind-c-type PangoStretch :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:75 <1526> 
;; typedef enum {
;;         PANGO_FONT_MASK_FAMILY =  0x000000001 LSHIFT  0x000000000,
;;   PANGO_FONT_MASK_STYLE
;;    =  0x000000001 LSHIFT  0x000000001, PANGO_FONT_MASK_VARIANT =
;;   0x000000001
;;    LSHIFT  0x000000002, PANGO_FONT_MASK_WEIGHT =  0x000000001 LSHIFT
;;   0x000000003,
;;              PANGO_FONT_MASK_STRETCH =  0x000000001 LSHIFT  0x000000004,
;;   PANGO_FONT_MASK_SIZE
;;    =  0x000000001 LSHIFT  0x000000005 } PangoFontMask;
(ff:bind-c-constant PANGO_FONT_MASK_FAMILY
                    1) ;;
;;   PANGO_FONT_MASK_FAMILY =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant PANGO_FONT_MASK_STYLE
                    2) ;;
;;   PANGO_FONT_MASK_STYLE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant PANGO_FONT_MASK_VARIANT
                    4) ;;
;;   PANGO_FONT_MASK_VARIANT =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant PANGO_FONT_MASK_WEIGHT
                    8) ;;
;;   PANGO_FONT_MASK_WEIGHT =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant PANGO_FONT_MASK_STRETCH
                    16) ;;
;;   PANGO_FONT_MASK_STRETCH =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant PANGO_FONT_MASK_SIZE
                    32) ;;
;;   PANGO_FONT_MASK_SIZE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-type PangoFontMask :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:99 <1527> 
;; GType pango_font_description_get_type( void);
(ff:bind-c-function pango_font_description_get_type
     :unconverted-entry-name "pango_font_description_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:100 <1528> 
;; PangoFontDescription* pango_font_description_new( void);
(ff:bind-c-function pango_font_description_new
     :unconverted-entry-name "pango_font_description_new"
     :c-return-type ("PangoFontDescription" "*")
     :return-type (* PangoFontDescription)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:101 <1529> 
;; PangoFontDescription* pango_font_description_copy( const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_copy
     :unconverted-entry-name "pango_font_description_copy"
     :c-return-type ("PangoFontDescription" "*")
     :return-type (* PangoFontDescription)
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:102 <1530> 
;; PangoFontDescription* pango_font_description_copy_static( const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_copy_static
     :unconverted-entry-name "pango_font_description_copy_static"
     :c-return-type ("PangoFontDescription" "*")
     :return-type (* PangoFontDescription)
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:103 <1531> 
;; guint pango_font_description_hash( const PangoFontDescription* desc);
(ff:bind-c-function pango_font_description_hash
     :unconverted-entry-name "pango_font_description_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:104 <1532> 
;; gboolean pango_font_description_equal( const PangoFontDescription*
;;   desc1,
;;              const PangoFontDescription* desc2);
(ff:bind-c-function pango_font_description_equal
     :unconverted-entry-name "pango_font_description_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "PangoFontDescription" "*")
                   ("const" "PangoFontDescription" "*"))
     :c-arg-names (desc1 desc2)
     :arguments ((* PangoFontDescription) (* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:106 <1533> 
;; void pango_font_description_free( PangoFontDescription* desc);
(ff:bind-c-function pango_font_description_free
     :unconverted-entry-name "pango_font_description_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:107 <1534> 
;; void pango_font_descriptions_free( PangoFontDescription** descs, int
;;   n_descs
;;   );
(ff:bind-c-function pango_font_descriptions_free
     :unconverted-entry-name "pango_font_descriptions_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*" "*") ("int"))
     :c-arg-names (descs n_descs)
     :arguments ((* (* PangoFontDescription)) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:110 <1535> 
;; void pango_font_description_set_family( PangoFontDescription* desc,
;;   const
;;    char* family);
(ff:bind-c-function pango_font_description_set_family
     :unconverted-entry-name "pango_font_description_set_family"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("const" "char" "*"))
     :c-arg-names (desc family)
     :arguments ((* PangoFontDescription) (* :char))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:112 <1536> 
;; void pango_font_description_set_family_static( PangoFontDescription*
;;   desc,
;;              const char* family);
(ff:bind-c-function pango_font_description_set_family_static
     :unconverted-entry-name "pango_font_description_set_family_static"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("const" "char" "*"))
     :c-arg-names (desc family)
     :arguments ((* PangoFontDescription) (* :char))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:114 <1537> 
;; const char* pango_font_description_get_family( const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_get_family
     :unconverted-entry-name "pango_font_description_get_family"
     :c-modifiers ("const")
     :c-return-type ("const" "char" "*")
     :return-type (* :char)
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:115 <1538> 
;; void pango_font_description_set_style( PangoFontDescription* desc,
;;   PangoStyle
;;    style);
(ff:bind-c-function pango_font_description_set_style
     :unconverted-entry-name "pango_font_description_set_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("PangoStyle"))
     :c-arg-names (desc style)
     :arguments ((* PangoFontDescription) PangoStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:117 <1539> 
;; PangoStyle pango_font_description_get_style( const PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_get_style
     :unconverted-entry-name "pango_font_description_get_style"
     :c-return-type ("PangoStyle")
     :return-type PangoStyle
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:118 <1540> 
;; void pango_font_description_set_variant( PangoFontDescription* desc,
;;   PangoVariant
;;    variant);
(ff:bind-c-function pango_font_description_set_variant
     :unconverted-entry-name "pango_font_description_set_variant"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("PangoVariant"))
     :c-arg-names (desc variant)
     :arguments ((* PangoFontDescription) PangoVariant)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:120 <1541> 
;; PangoVariant pango_font_description_get_variant( const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_get_variant
     :unconverted-entry-name "pango_font_description_get_variant"
     :c-return-type ("PangoVariant")
     :return-type PangoVariant
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:121 <1542> 
;; void pango_font_description_set_weight( PangoFontDescription* desc,
;;   PangoWeight
;;    weight);
(ff:bind-c-function pango_font_description_set_weight
     :unconverted-entry-name "pango_font_description_set_weight"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("PangoWeight"))
     :c-arg-names (desc weight)
     :arguments ((* PangoFontDescription) PangoWeight)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:123 <1543> 
;; PangoWeight pango_font_description_get_weight( const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_get_weight
     :unconverted-entry-name "pango_font_description_get_weight"
     :c-return-type ("PangoWeight")
     :return-type PangoWeight
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:124 <1544> 
;; void pango_font_description_set_stretch( PangoFontDescription* desc,
;;   PangoStretch
;;    stretch);
(ff:bind-c-function pango_font_description_set_stretch
     :unconverted-entry-name "pango_font_description_set_stretch"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("PangoStretch"))
     :c-arg-names (desc stretch)
     :arguments ((* PangoFontDescription) PangoStretch)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:126 <1545> 
;; PangoStretch pango_font_description_get_stretch( const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_get_stretch
     :unconverted-entry-name "pango_font_description_get_stretch"
     :c-return-type ("PangoStretch")
     :return-type PangoStretch
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:127 <1546> 
;; void pango_font_description_set_size( PangoFontDescription* desc, gint
;;    size);
(ff:bind-c-function pango_font_description_set_size
     :unconverted-entry-name "pango_font_description_set_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("gint"))
     :c-arg-names (desc size)
     :arguments ((* PangoFontDescription) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:129 <1547> 
;; gint pango_font_description_get_size( const PangoFontDescription* desc);
(ff:bind-c-function pango_font_description_get_size
     :unconverted-entry-name "pango_font_description_get_size"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:131 <1548> 
;; PangoFontMask pango_font_description_get_set_fields( const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_font_description_get_set_fields
     :unconverted-entry-name "pango_font_description_get_set_fields"
     :c-return-type ("PangoFontMask")
     :return-type PangoFontMask
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:132 <1549> 
;; void pango_font_description_unset_fields( PangoFontDescription* desc,
;;              PangoFontMask to_unset);
(ff:bind-c-function pango_font_description_unset_fields
     :unconverted-entry-name "pango_font_description_unset_fields"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*") ("PangoFontMask"))
     :c-arg-names (desc to_unset)
     :arguments ((* PangoFontDescription) PangoFontMask)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:135 <1550> 
;; void pango_font_description_merge( PangoFontDescription* desc, const
;;   PangoFontDescription
;;   * desc_to_merge, gboolean replace_existing);
(ff:bind-c-function pango_font_description_merge
     :unconverted-entry-name "pango_font_description_merge"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*")
                   ("const" "PangoFontDescription" "*") ("gboolean"))
     :c-arg-names (desc desc_to_merge replace_existing)
     :arguments ((* PangoFontDescription) (* PangoFontDescription)
                 gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:138 <1551> 
;; void pango_font_description_merge_static( PangoFontDescription* desc,
;;              const PangoFontDescription* desc_to_merge, gboolean
;;   replace_existing)
;;   ;
(ff:bind-c-function pango_font_description_merge_static
     :unconverted-entry-name "pango_font_description_merge_static"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontDescription" "*")
                   ("const" "PangoFontDescription" "*") ("gboolean"))
     :c-arg-names (desc desc_to_merge replace_existing)
     :arguments ((* PangoFontDescription) (* PangoFontDescription)
                 gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:142 <1552> 
;; gboolean pango_font_description_better_match( const PangoFontDescription
;;   * desc, const PangoFontDescription* old_match, const
;;   PangoFontDescription
;;   * new_match);
(ff:bind-c-function pango_font_description_better_match
     :unconverted-entry-name "pango_font_description_better_match"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "PangoFontDescription" "*")
                   ("const" "PangoFontDescription" "*")
                   ("const" "PangoFontDescription" "*"))
     :c-arg-names (desc old_match new_match)
     :arguments ((* PangoFontDescription) (* PangoFontDescription)
                 (* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:146 <1553> 
;; PangoFontDescription* pango_font_description_from_string( const char*
;;    str);
(ff:bind-c-function pango_font_description_from_string
     :unconverted-entry-name "pango_font_description_from_string"
     :c-return-type ("PangoFontDescription" "*")
     :return-type (* PangoFontDescription)
     :c-arg-types (("const" "char" "*"))
     :c-arg-names (str)
     :arguments ((* :char))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:147 <1554> 
;; char* pango_font_description_to_string( const PangoFontDescription* desc
;;   );
(ff:bind-c-function pango_font_description_to_string
     :unconverted-entry-name "pango_font_description_to_string"
     :c-return-type ("char" "*")
     :return-type (* :char)
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:148 <1555> 
;; char* pango_font_description_to_filename( const PangoFontDescription*
;;    desc);
(ff:bind-c-function pango_font_description_to_filename
     :unconverted-entry-name "pango_font_description_to_filename"
     :c-return-type ("char" "*")
     :return-type (* :char)
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:155 <1556> 
;; GType pango_font_metrics_get_type( void);
(ff:bind-c-function pango_font_metrics_get_type
     :unconverted-entry-name "pango_font_metrics_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:156 <1557> 
;; PangoFontMetrics* pango_font_metrics_ref( PangoFontMetrics* metrics);
(ff:bind-c-function pango_font_metrics_ref
     :unconverted-entry-name "pango_font_metrics_ref"
     :c-return-type ("PangoFontMetrics" "*")
     :return-type (* PangoFontMetrics)
     :c-arg-types (("PangoFontMetrics" "*"))
     :c-arg-names (metrics)
     :arguments ((* PangoFontMetrics))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:157 <1558> 
;; void pango_font_metrics_unref( PangoFontMetrics* metrics);
(ff:bind-c-function pango_font_metrics_unref
     :unconverted-entry-name "pango_font_metrics_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontMetrics" "*"))
     :c-arg-names (metrics)
     :arguments ((* PangoFontMetrics))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:158 <1559> 
;; int pango_font_metrics_get_ascent( PangoFontMetrics* metrics);
(ff:bind-c-function pango_font_metrics_get_ascent
     :unconverted-entry-name "pango_font_metrics_get_ascent"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoFontMetrics" "*"))
     :c-arg-names (metrics)
     :arguments ((* PangoFontMetrics))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:159 <1560> 
;; int pango_font_metrics_get_descent( PangoFontMetrics* metrics);
(ff:bind-c-function pango_font_metrics_get_descent
     :unconverted-entry-name "pango_font_metrics_get_descent"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoFontMetrics" "*"))
     :c-arg-names (metrics)
     :arguments ((* PangoFontMetrics))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:160 <1561> 
;; int pango_font_metrics_get_approximate_char_width( PangoFontMetrics*
;;   metrics
;;   );
(ff:bind-c-function pango_font_metrics_get_approximate_char_width
     :unconverted-entry-name "pango_font_metrics_get_approximate_char_width"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoFontMetrics" "*"))
     :c-arg-names (metrics)
     :arguments ((* PangoFontMetrics))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:161 <1562> 
;; int pango_font_metrics_get_approximate_digit_width( PangoFontMetrics*
;;    metrics);
(ff:bind-c-function pango_font_metrics_get_approximate_digit_width
     :unconverted-entry-name "pango_font_metrics_get_approximate_digit_width"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoFontMetrics" "*"))
     :c-arg-names (metrics)
     :arguments ((* PangoFontMetrics))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:187 <1563> 
;; typedef struct _PangoFontFamily PangoFontFamily;
(ff:bind-c-typedef _PangoFontFamily
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoFontFamily _PangoFontFamily)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:188 <1564> 
;; typedef struct _PangoFontFace PangoFontFace;
(ff:bind-c-typedef _PangoFontFace
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoFontFace _PangoFontFace)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:190 <1565> 
;; GType pango_font_family_get_type( void);
(ff:bind-c-function pango_font_family_get_type
     :unconverted-entry-name "pango_font_family_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:192 <1566> 
;; void pango_font_family_list_faces( PangoFontFamily* family,
;;   PangoFontFace
;;   *** faces, int* n_faces);
(ff:bind-c-function pango_font_family_list_faces
     :unconverted-entry-name "pango_font_family_list_faces"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontFamily" "*")
                   ("PangoFontFace" "*" "*" "*") ("int" "*"))
     :c-arg-names (family faces n_faces)
     :arguments ((* PangoFontFamily) (* (* (* PangoFontFace))) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:195 <1567> 
;; const char* pango_font_family_get_name( PangoFontFamily* family);
(ff:bind-c-function pango_font_family_get_name
     :unconverted-entry-name "pango_font_family_get_name"
     :c-modifiers ("const")
     :c-return-type ("const" "char" "*")
     :return-type (* :char)
     :c-arg-types (("PangoFontFamily" "*"))
     :c-arg-names (family)
     :arguments ((* PangoFontFamily))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:236 <1568> 
;; GType pango_font_face_get_type( void);
(ff:bind-c-function pango_font_face_get_type
     :unconverted-entry-name "pango_font_face_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:238 <1569> 
;; PangoFontDescription* pango_font_face_describe( PangoFontFace* face);
(ff:bind-c-function pango_font_face_describe
     :unconverted-entry-name "pango_font_face_describe"
     :c-return-type ("PangoFontDescription" "*")
     :return-type (* PangoFontDescription)
     :c-arg-types (("PangoFontFace" "*"))
     :c-arg-names (face)
     :arguments ((* PangoFontFace))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:239 <1570> 
;; const char* pango_font_face_get_face_name( PangoFontFace* face);
(ff:bind-c-function pango_font_face_get_face_name
     :unconverted-entry-name "pango_font_face_get_face_name"
     :c-modifiers ("const")
     :c-return-type ("const" "char" "*")
     :return-type (* :char)
     :c-arg-types (("PangoFontFace" "*"))
     :c-arg-names (face)
     :arguments ((* PangoFontFace))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:278 <1571> 
;; GType pango_font_get_type( void);
(ff:bind-c-function pango_font_get_type
     :unconverted-entry-name "pango_font_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:280 <1572> 
;; PangoFontDescription* pango_font_describe( PangoFont* font);
(ff:bind-c-function pango_font_describe
     :unconverted-entry-name "pango_font_describe"
     :c-return-type ("PangoFontDescription" "*")
     :return-type (* PangoFontDescription)
     :c-arg-types (("PangoFont" "*"))
     :c-arg-names (font)
     :arguments ((* PangoFont))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:281 <1573> 
;; PangoCoverage* pango_font_get_coverage( PangoFont* font, PangoLanguage
;;   * language);
(ff:bind-c-function pango_font_get_coverage
     :unconverted-entry-name "pango_font_get_coverage"
     :c-return-type ("PangoCoverage" "*")
     :return-type (* PangoCoverage)
     :c-arg-types (("PangoFont" "*") ("PangoLanguage" "*"))
     :c-arg-names (font language)
     :arguments ((* PangoFont) (* PangoLanguage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:283 <1574> 
;; PangoEngineShape* pango_font_find_shaper( PangoFont* font, PangoLanguage
;;   * language, guint32 ch);
(ff:bind-c-function pango_font_find_shaper
     :unconverted-entry-name "pango_font_find_shaper"
     :c-return-type ("PangoEngineShape" "*")
     :return-type (* PangoEngineShape)
     :c-arg-types (("PangoFont" "*") ("PangoLanguage" "*") ("guint32"))
     :c-arg-names (font language ch)
     :arguments ((* PangoFont) (* PangoLanguage) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:286 <1575> 
;; PangoFontMetrics* pango_font_get_metrics( PangoFont* font, PangoLanguage
;;   * language);
(ff:bind-c-function pango_font_get_metrics
     :unconverted-entry-name "pango_font_get_metrics"
     :c-return-type ("PangoFontMetrics" "*")
     :return-type (* PangoFontMetrics)
     :c-arg-types (("PangoFont" "*") ("PangoLanguage" "*"))
     :c-arg-names (font language)
     :arguments ((* PangoFont) (* PangoLanguage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-font.h:288 <1576> 
;; void pango_font_get_glyph_extents( PangoFont* font, PangoGlyph glyph,
;;              PangoRectangle* ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_font_get_glyph_extents
     :unconverted-entry-name "pango_font_get_glyph_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFont" "*") ("PangoGlyph")
                   ("PangoRectangle" "*") ("PangoRectangle" "*"))
     :c-arg-names (font glyph ink_rect logical_rect)
     :arguments ((* PangoFont) PangoGlyph (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:32 <1577> 
;; typedef struct _PangoColor PangoColor;
(ff:bind-c-typedef _PangoColor
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoColor _PangoColor)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:34 <1578> 
;; struct _PangoColor { guint16 red; guint16 green; guint16 blue; };
(ff:bind-c-type _PangoColor (:struct
  (red guint16)   ;; guint16 red
  (green guint16)   ;; guint16 green
  (blue guint16)   ;; guint16 blue
  ))   ;; bind-c-type _PangoColor
(ff:bind-c-typedef PangoColor _PangoColor) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:42 <1579> 
;; GType pango_color_get_type( void);
(ff:bind-c-function pango_color_get_type
     :unconverted-entry-name "pango_color_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:44 <1580> 
;; PangoColor* pango_color_copy( const PangoColor* src);
(ff:bind-c-function pango_color_copy
     :unconverted-entry-name "pango_color_copy"
     :c-return-type ("PangoColor" "*")
     :return-type (* PangoColor)
     :c-arg-types (("const" "PangoColor" "*"))
     :c-arg-names (src)
     :arguments ((* PangoColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:45 <1581> 
;; void pango_color_free( PangoColor* color);
(ff:bind-c-function pango_color_free
     :unconverted-entry-name "pango_color_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoColor" "*"))
     :c-arg-names (color)
     :arguments ((* PangoColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:46 <1582> 
;; gboolean pango_color_parse( PangoColor* color, const char* spec);
(ff:bind-c-function pango_color_parse
     :unconverted-entry-name "pango_color_parse"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoColor" "*") ("const" "char" "*"))
     :c-arg-names (color spec)
     :arguments ((* PangoColor) (* :char))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:51 <1583> 
;; typedef struct _PangoAttribute PangoAttribute;
(ff:bind-c-typedef _PangoAttribute
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttribute _PangoAttribute)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:52 <1584> 
;; typedef struct _PangoAttrClass PangoAttrClass;
(ff:bind-c-typedef _PangoAttrClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrClass _PangoAttrClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:54 <1585> 
;; typedef struct _PangoAttrString PangoAttrString;
(ff:bind-c-typedef _PangoAttrString
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrString _PangoAttrString)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:55 <1586> 
;; typedef struct _PangoAttrLanguage PangoAttrLanguage;
(ff:bind-c-typedef _PangoAttrLanguage
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrLanguage _PangoAttrLanguage)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:56 <1587> 
;; typedef struct _PangoAttrInt PangoAttrInt;
(ff:bind-c-typedef _PangoAttrInt
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrInt _PangoAttrInt)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:57 <1588> 
;; typedef struct _PangoAttrFloat PangoAttrFloat;
(ff:bind-c-typedef _PangoAttrFloat
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrFloat _PangoAttrFloat)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:58 <1589> 
;; typedef struct _PangoAttrColor PangoAttrColor;
(ff:bind-c-typedef _PangoAttrColor
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrColor _PangoAttrColor)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:59 <1590> 
;; typedef struct _PangoAttrFontDesc PangoAttrFontDesc;
(ff:bind-c-typedef _PangoAttrFontDesc
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrFontDesc _PangoAttrFontDesc)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:60 <1591> 
;; typedef struct _PangoAttrShape PangoAttrShape;
(ff:bind-c-typedef _PangoAttrShape
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrShape _PangoAttrShape)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:63 <1592> 
;; typedef struct _PangoAttrList PangoAttrList;
(ff:bind-c-typedef _PangoAttrList
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrList _PangoAttrList)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:64 <1593> 
;; typedef struct _PangoAttrIterator PangoAttrIterator;
(ff:bind-c-typedef _PangoAttrIterator
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAttrIterator _PangoAttrIterator)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:66 <1594> 
;; typedef enum {
;;         PANGO_ATTR_INVALID, PANGO_ATTR_LANGUAGE, PANGO_ATTR_FAMILY,
;;   PANGO_ATTR_STYLE,
;;              PANGO_ATTR_WEIGHT, PANGO_ATTR_VARIANT, PANGO_ATTR_STRETCH,
;;   PANGO_ATTR_SIZE,
;;              PANGO_ATTR_FONT_DESC, PANGO_ATTR_FOREGROUND,
;;   PANGO_ATTR_BACKGROUND, PANGO_ATTR_UNDERLINE,
;;              PANGO_ATTR_STRIKETHROUGH, PANGO_ATTR_RISE,
;;   PANGO_ATTR_SHAPE, PANGO_ATTR_SCALE
;;    } PangoAttrType;
(ff:bind-c-constant PANGO_ATTR_INVALID 0) ;;  PANGO_ATTR_INVALID 
(ff:bind-c-constant PANGO_ATTR_LANGUAGE 1) ;;  PANGO_ATTR_LANGUAGE 
(ff:bind-c-constant PANGO_ATTR_FAMILY 2) ;;  PANGO_ATTR_FAMILY 
(ff:bind-c-constant PANGO_ATTR_STYLE 3) ;;  PANGO_ATTR_STYLE 
(ff:bind-c-constant PANGO_ATTR_WEIGHT 4) ;;  PANGO_ATTR_WEIGHT 
(ff:bind-c-constant PANGO_ATTR_VARIANT 5) ;;  PANGO_ATTR_VARIANT 
(ff:bind-c-constant PANGO_ATTR_STRETCH 6) ;;  PANGO_ATTR_STRETCH 
(ff:bind-c-constant PANGO_ATTR_SIZE 7) ;;  PANGO_ATTR_SIZE 
(ff:bind-c-constant PANGO_ATTR_FONT_DESC 8) ;;  PANGO_ATTR_FONT_DESC 
(ff:bind-c-constant PANGO_ATTR_FOREGROUND 9) ;;  PANGO_ATTR_FOREGROUND 
(ff:bind-c-constant PANGO_ATTR_BACKGROUND 10) ;;  PANGO_ATTR_BACKGROUND 
(ff:bind-c-constant PANGO_ATTR_UNDERLINE 11) ;;  PANGO_ATTR_UNDERLINE 
(ff:bind-c-constant PANGO_ATTR_STRIKETHROUGH
                    12) ;;
;;   PANGO_ATTR_STRIKETHROUGH 
(ff:bind-c-constant PANGO_ATTR_RISE 13) ;;  PANGO_ATTR_RISE 
(ff:bind-c-constant PANGO_ATTR_SHAPE 14) ;;  PANGO_ATTR_SHAPE 
(ff:bind-c-constant PANGO_ATTR_SCALE 15) ;;  PANGO_ATTR_SCALE 
(ff:bind-c-type PangoAttrType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:86 <1595> 
;; typedef enum {
;;         PANGO_UNDERLINE_NONE, PANGO_UNDERLINE_SINGLE,
;;   PANGO_UNDERLINE_DOUBLE,
;;              PANGO_UNDERLINE_LOW } PangoUnderline;
(ff:bind-c-constant PANGO_UNDERLINE_NONE 0) ;;  PANGO_UNDERLINE_NONE 
(ff:bind-c-constant PANGO_UNDERLINE_SINGLE
                    1) ;;
;;   PANGO_UNDERLINE_SINGLE 
(ff:bind-c-constant PANGO_UNDERLINE_DOUBLE
                    2) ;;
;;   PANGO_UNDERLINE_DOUBLE 
(ff:bind-c-constant PANGO_UNDERLINE_LOW 3) ;;  PANGO_UNDERLINE_LOW 
(ff:bind-c-type PangoUnderline :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:93 <1596> 
;; struct _PangoAttribute {
;;         const PangoAttrClass* klass; guint start_index; guint end_index;
;;   };
(ff:bind-c-type _PangoAttribute (:struct
  (klass (* PangoAttrClass))   ;; const PangoAttrClass* klass
  (start_index guint)   ;; guint start_index
  (end_index guint)   ;; guint end_index
  ))   ;; bind-c-type _PangoAttribute
(ff:bind-c-typedef PangoAttribute
                   _PangoAttribute) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:100 <1597> 
;; struct _PangoAttrClass {
;;         PangoAttrType type; PangoAttribute*(* copy)( const
;;   PangoAttribute* attr
;;   ); void(* destroy)( PangoAttribute* attr); gboolean(* equal)( const
;;   PangoAttribute
;;   * attr1, const PangoAttribute* attr2); };
(ff:bind-c-type _PangoAttrClass (:struct
  (type PangoAttrType)   ;; PangoAttrType type
  (copy ff:function-pointer)   ;;
  ;;  PangoAttribute*(* copy)( const PangoAttribute* attr)
  (destroy ff:function-pointer)   ;; void(* destroy)( PangoAttribute* attr)
  (equal ff:function-pointer)   ;;
  ;;  gboolean(* equal)( const PangoAttribute* attr1, const PangoAttribute* attr2)
  ))   ;; bind-c-type _PangoAttrClass
(ff:bind-c-typedef PangoAttrClass
                   _PangoAttrClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:108 <1598> 
;; struct _PangoAttrString { PangoAttribute attr; char* value; };
(ff:bind-c-type _PangoAttrString (:struct
  (attr PangoAttribute)   ;; PangoAttribute attr
  (value (* :char))   ;; char* value
  ))   ;; bind-c-type _PangoAttrString
(ff:bind-c-typedef PangoAttrString
                   _PangoAttrString) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:114 <1599> 
;; struct _PangoAttrLanguage { PangoAttribute attr; PangoLanguage* value;
;;   };
(ff:bind-c-type _PangoAttrLanguage (:struct
  (attr PangoAttribute)   ;; PangoAttribute attr
  (value (* PangoLanguage))   ;; PangoLanguage* value
  ))   ;; bind-c-type _PangoAttrLanguage
(ff:bind-c-typedef PangoAttrLanguage
                   _PangoAttrLanguage) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:120 <1600> 
;; struct _PangoAttrInt { PangoAttribute attr; int value; };
(ff:bind-c-type _PangoAttrInt (:struct
  (attr PangoAttribute)   ;; PangoAttribute attr
  (value :int)   ;; int value
  ))   ;; bind-c-type _PangoAttrInt
(ff:bind-c-typedef PangoAttrInt _PangoAttrInt) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:126 <1601> 
;; struct _PangoAttrFloat { PangoAttribute attr; double value; };
(ff:bind-c-type _PangoAttrFloat (:struct
  (attr PangoAttribute)   ;; PangoAttribute attr
  (value :double)   ;; double value
  ))   ;; bind-c-type _PangoAttrFloat
(ff:bind-c-typedef PangoAttrFloat
                   _PangoAttrFloat) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:132 <1602> 
;; struct _PangoAttrColor { PangoAttribute attr; PangoColor color; };
(ff:bind-c-type _PangoAttrColor (:struct
  (attr PangoAttribute)   ;; PangoAttribute attr
  (color PangoColor)   ;; PangoColor color
  ))   ;; bind-c-type _PangoAttrColor
(ff:bind-c-typedef PangoAttrColor
                   _PangoAttrColor) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:138 <1603> 
;; struct _PangoAttrShape {
;;         PangoAttribute attr; PangoRectangle ink_rect; PangoRectangle
;;   logical_rect;
;;    };
(ff:bind-c-type _PangoAttrShape (:struct
  (attr PangoAttribute)   ;; PangoAttribute attr
  (ink_rect PangoRectangle)   ;; PangoRectangle ink_rect
  (logical_rect PangoRectangle)   ;; PangoRectangle logical_rect
  ))   ;; bind-c-type _PangoAttrShape
(ff:bind-c-typedef PangoAttrShape
                   _PangoAttrShape) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:145 <1604> 
;; struct _PangoAttrFontDesc {
;;         PangoAttribute attr; PangoFontDescription* desc; };
(ff:bind-c-type _PangoAttrFontDesc (:struct
  (attr PangoAttribute)   ;; PangoAttribute attr
  (desc (* PangoFontDescription))   ;; PangoFontDescription* desc
  ))   ;; bind-c-type _PangoAttrFontDesc
(ff:bind-c-typedef PangoAttrFontDesc
                   _PangoAttrFontDesc) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:151 <1605> 
;; PangoAttrType pango_attr_type_register( const gchar* name);
(ff:bind-c-function pango_attr_type_register
     :unconverted-entry-name "pango_attr_type_register"
     :c-return-type ("PangoAttrType")
     :return-type PangoAttrType
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:153 <1606> 
;; PangoAttribute* pango_attribute_copy( const PangoAttribute* attr);
(ff:bind-c-function pango_attribute_copy
     :unconverted-entry-name "pango_attribute_copy"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("const" "PangoAttribute" "*"))
     :c-arg-names (attr)
     :arguments ((* PangoAttribute))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:154 <1607> 
;; void pango_attribute_destroy( PangoAttribute* attr);
(ff:bind-c-function pango_attribute_destroy
     :unconverted-entry-name "pango_attribute_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttribute" "*"))
     :c-arg-names (attr)
     :arguments ((* PangoAttribute))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:155 <1608> 
;; gboolean pango_attribute_equal( const PangoAttribute* attr1, const
;;   PangoAttribute
;;   * attr2);
(ff:bind-c-function pango_attribute_equal
     :unconverted-entry-name "pango_attribute_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "PangoAttribute" "*")
                   ("const" "PangoAttribute" "*"))
     :c-arg-names (attr1 attr2)
     :arguments ((* PangoAttribute) (* PangoAttribute))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:158 <1609> 
;; PangoAttribute* pango_attr_language_new( PangoLanguage* language);
(ff:bind-c-function pango_attr_language_new
     :unconverted-entry-name "pango_attr_language_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("PangoLanguage" "*"))
     :c-arg-names (language)
     :arguments ((* PangoLanguage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:159 <1610> 
;; PangoAttribute* pango_attr_family_new( const char* family);
(ff:bind-c-function pango_attr_family_new
     :unconverted-entry-name "pango_attr_family_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("const" "char" "*"))
     :c-arg-names (family)
     :arguments ((* :char))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:160 <1611> 
;; PangoAttribute* pango_attr_foreground_new( guint16 red, guint16 green,
;;              guint16 blue);
(ff:bind-c-function pango_attr_foreground_new
     :unconverted-entry-name "pango_attr_foreground_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("guint16") ("guint16") ("guint16"))
     :c-arg-names (red green blue)
     :arguments (guint16 guint16 guint16)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:163 <1612> 
;; PangoAttribute* pango_attr_background_new( guint16 red, guint16 green,
;;              guint16 blue);
(ff:bind-c-function pango_attr_background_new
     :unconverted-entry-name "pango_attr_background_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("guint16") ("guint16") ("guint16"))
     :c-arg-names (red green blue)
     :arguments (guint16 guint16 guint16)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:166 <1613> 
;; PangoAttribute* pango_attr_size_new( int size);
(ff:bind-c-function pango_attr_size_new
     :unconverted-entry-name "pango_attr_size_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("int"))
     :c-arg-names (size)
     :arguments (:int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:167 <1614> 
;; PangoAttribute* pango_attr_style_new( PangoStyle style);
(ff:bind-c-function pango_attr_style_new
     :unconverted-entry-name "pango_attr_style_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("PangoStyle"))
     :c-arg-names (style)
     :arguments (PangoStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:168 <1615> 
;; PangoAttribute* pango_attr_weight_new( PangoWeight weight);
(ff:bind-c-function pango_attr_weight_new
     :unconverted-entry-name "pango_attr_weight_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("PangoWeight"))
     :c-arg-names (weight)
     :arguments (PangoWeight)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:169 <1616> 
;; PangoAttribute* pango_attr_variant_new( PangoVariant variant);
(ff:bind-c-function pango_attr_variant_new
     :unconverted-entry-name "pango_attr_variant_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("PangoVariant"))
     :c-arg-names (variant)
     :arguments (PangoVariant)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:170 <1617> 
;; PangoAttribute* pango_attr_stretch_new( PangoStretch stretch);
(ff:bind-c-function pango_attr_stretch_new
     :unconverted-entry-name "pango_attr_stretch_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("PangoStretch"))
     :c-arg-names (stretch)
     :arguments (PangoStretch)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:171 <1618> 
;; PangoAttribute* pango_attr_font_desc_new( const PangoFontDescription*
;;    desc);
(ff:bind-c-function pango_attr_font_desc_new
     :unconverted-entry-name "pango_attr_font_desc_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("const" "PangoFontDescription" "*"))
     :c-arg-names (desc)
     :arguments ((* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:172 <1619> 
;; PangoAttribute* pango_attr_underline_new( PangoUnderline underline);
(ff:bind-c-function pango_attr_underline_new
     :unconverted-entry-name "pango_attr_underline_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("PangoUnderline"))
     :c-arg-names (underline)
     :arguments (PangoUnderline)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:173 <1620> 
;; PangoAttribute* pango_attr_strikethrough_new( gboolean strikethrough);
(ff:bind-c-function pango_attr_strikethrough_new
     :unconverted-entry-name "pango_attr_strikethrough_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("gboolean"))
     :c-arg-names (strikethrough)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:174 <1621> 
;; PangoAttribute* pango_attr_rise_new( int rise);
(ff:bind-c-function pango_attr_rise_new
     :unconverted-entry-name "pango_attr_rise_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("int"))
     :c-arg-names (rise)
     :arguments (:int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:175 <1622> 
;; PangoAttribute* pango_attr_shape_new( const PangoRectangle* ink_rect,
;;              const PangoRectangle* logical_rect);
(ff:bind-c-function pango_attr_shape_new
     :unconverted-entry-name "pango_attr_shape_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("const" "PangoRectangle" "*")
                   ("const" "PangoRectangle" "*"))
     :c-arg-names (ink_rect logical_rect)
     :arguments ((* PangoRectangle) (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:177 <1623> 
;; PangoAttribute* pango_attr_scale_new( double scale_factor);
(ff:bind-c-function pango_attr_scale_new
     :unconverted-entry-name "pango_attr_scale_new"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("double"))
     :c-arg-names (scale_factor)
     :arguments (:double)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:179 <1624> 
;; GType pango_attr_list_get_type( void);
(ff:bind-c-function pango_attr_list_get_type
     :unconverted-entry-name "pango_attr_list_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:180 <1625> 
;; PangoAttrList* pango_attr_list_new( void);
(ff:bind-c-function pango_attr_list_new
     :unconverted-entry-name "pango_attr_list_new"
     :c-return-type ("PangoAttrList" "*")
     :return-type (* PangoAttrList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:181 <1626> 
;; void pango_attr_list_ref( PangoAttrList* list);
(ff:bind-c-function pango_attr_list_ref
     :unconverted-entry-name "pango_attr_list_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrList" "*"))
     :c-arg-names (list)
     :arguments ((* PangoAttrList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:182 <1627> 
;; void pango_attr_list_unref( PangoAttrList* list);
(ff:bind-c-function pango_attr_list_unref
     :unconverted-entry-name "pango_attr_list_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrList" "*"))
     :c-arg-names (list)
     :arguments ((* PangoAttrList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:183 <1628> 
;; PangoAttrList* pango_attr_list_copy( PangoAttrList* list);
(ff:bind-c-function pango_attr_list_copy
     :unconverted-entry-name "pango_attr_list_copy"
     :c-return-type ("PangoAttrList" "*")
     :return-type (* PangoAttrList)
     :c-arg-types (("PangoAttrList" "*"))
     :c-arg-names (list)
     :arguments ((* PangoAttrList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:184 <1629> 
;; void pango_attr_list_insert( PangoAttrList* list, PangoAttribute* attr);
(ff:bind-c-function pango_attr_list_insert
     :unconverted-entry-name "pango_attr_list_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrList" "*") ("PangoAttribute" "*"))
     :c-arg-names (list attr)
     :arguments ((* PangoAttrList) (* PangoAttribute))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:186 <1630> 
;; void pango_attr_list_insert_before( PangoAttrList* list, PangoAttribute
;;   * attr);
(ff:bind-c-function pango_attr_list_insert_before
     :unconverted-entry-name "pango_attr_list_insert_before"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrList" "*") ("PangoAttribute" "*"))
     :c-arg-names (list attr)
     :arguments ((* PangoAttrList) (* PangoAttribute))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:188 <1631> 
;; void pango_attr_list_change( PangoAttrList* list, PangoAttribute* attr);
(ff:bind-c-function pango_attr_list_change
     :unconverted-entry-name "pango_attr_list_change"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrList" "*") ("PangoAttribute" "*"))
     :c-arg-names (list attr)
     :arguments ((* PangoAttrList) (* PangoAttribute))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:190 <1632> 
;; void pango_attr_list_splice( PangoAttrList* list, PangoAttrList* other,
;;              gint pos, gint len);
(ff:bind-c-function pango_attr_list_splice
     :unconverted-entry-name "pango_attr_list_splice"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrList" "*") ("PangoAttrList" "*") ("gint")
                   ("gint"))
     :c-arg-names (list other pos len)
     :arguments ((* PangoAttrList) (* PangoAttrList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:194 <1633> 
;; PangoAttrIterator* pango_attr_list_get_iterator( PangoAttrList* list);
(ff:bind-c-function pango_attr_list_get_iterator
     :unconverted-entry-name "pango_attr_list_get_iterator"
     :c-return-type ("PangoAttrIterator" "*")
     :return-type (* PangoAttrIterator)
     :c-arg-types (("PangoAttrList" "*"))
     :c-arg-names (list)
     :arguments ((* PangoAttrList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:196 <1634> 
;; void pango_attr_iterator_range( PangoAttrIterator* iterator, gint*
;;   start,
;;              gint* end);
(ff:bind-c-function pango_attr_iterator_range
     :unconverted-entry-name "pango_attr_iterator_range"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrIterator" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (iterator start end)
     :arguments ((* PangoAttrIterator) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:199 <1635> 
;; gboolean pango_attr_iterator_next( PangoAttrIterator* iterator);
(ff:bind-c-function pango_attr_iterator_next
     :unconverted-entry-name "pango_attr_iterator_next"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoAttrIterator" "*"))
     :c-arg-names (iterator)
     :arguments ((* PangoAttrIterator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:200 <1636> 
;; PangoAttrIterator* pango_attr_iterator_copy( PangoAttrIterator* iterator
;;   );
(ff:bind-c-function pango_attr_iterator_copy
     :unconverted-entry-name "pango_attr_iterator_copy"
     :c-return-type ("PangoAttrIterator" "*")
     :return-type (* PangoAttrIterator)
     :c-arg-types (("PangoAttrIterator" "*"))
     :c-arg-names (iterator)
     :arguments ((* PangoAttrIterator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:201 <1637> 
;; void pango_attr_iterator_destroy( PangoAttrIterator* iterator);
(ff:bind-c-function pango_attr_iterator_destroy
     :unconverted-entry-name "pango_attr_iterator_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrIterator" "*"))
     :c-arg-names (iterator)
     :arguments ((* PangoAttrIterator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:202 <1638> 
;; PangoAttribute* pango_attr_iterator_get( PangoAttrIterator* iterator,
;;              PangoAttrType type);
(ff:bind-c-function pango_attr_iterator_get
     :unconverted-entry-name "pango_attr_iterator_get"
     :c-return-type ("PangoAttribute" "*")
     :return-type (* PangoAttribute)
     :c-arg-types (("PangoAttrIterator" "*") ("PangoAttrType"))
     :c-arg-names (iterator type)
     :arguments ((* PangoAttrIterator) PangoAttrType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:204 <1639> 
;; void pango_attr_iterator_get_font( PangoAttrIterator* iterator,
;;   PangoFontDescription
;;   * desc, PangoLanguage** language, GSList** extra_attrs);
(ff:bind-c-function pango_attr_iterator_get_font
     :unconverted-entry-name "pango_attr_iterator_get_font"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoAttrIterator" "*")
                   ("PangoFontDescription" "*")
                   ("PangoLanguage" "*" "*") ("GSList" "*" "*"))
     :c-arg-names (iterator desc language extra_attrs)
     :arguments ((* PangoAttrIterator) (* PangoFontDescription)
                 (* (* PangoLanguage)) (* (* GSList)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-attributes.h:210 <1640> 
;; gboolean pango_parse_markup( const char* markup_text, int length,
;;   gunichar
;;    accel_marker, PangoAttrList** attr_list, char** text, gunichar*
;;   accel_char,
;;              GError** error);
(ff:bind-c-function pango_parse_markup
     :unconverted-entry-name "pango_parse_markup"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "char" "*") ("int") ("gunichar")
                   ("PangoAttrList" "*" "*") ("char" "*" "*")
                   ("gunichar" "*") ("GError" "*" "*"))
     :c-arg-names (markup_text length accel_marker attr_list text
                   accel_char error)
     :arguments ((* :char) :int gunichar (* (* PangoAttrList))
                 (* (* :char)) (* gunichar) (* (* GError)))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:30 <1641> 
;; typedef struct _PangoAnalysis PangoAnalysis;
(ff:bind-c-typedef _PangoAnalysis
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoAnalysis _PangoAnalysis)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:31 <1642> 
;; typedef struct _PangoItem PangoItem;
(ff:bind-c-typedef _PangoItem
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoItem _PangoItem)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:33 <1643> 
;; struct _PangoAnalysis {
;;         PangoEngineShape* shape_engine; PangoEngineLang* lang_engine;
;;   PangoFont
;;   * font; guint8 level; PangoLanguage* language; GSList* extra_attrs; };
(ff:bind-c-type _PangoAnalysis (:struct
  (shape_engine (* PangoEngineShape))   ;; PangoEngineShape* shape_engine
  (lang_engine (* PangoEngineLang))   ;; PangoEngineLang* lang_engine
  (font (* PangoFont))   ;; PangoFont* font
  (level guint8)   ;; guint8 level
  (language (* PangoLanguage))   ;; PangoLanguage* language
  (extra_attrs (* GSList))   ;; GSList* extra_attrs
  ))   ;; bind-c-type _PangoAnalysis
(ff:bind-c-typedef PangoAnalysis _PangoAnalysis) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:43 <1644> 
;; struct _PangoItem {
;;         gint offset; gint length; gint num_chars; PangoAnalysis
;;   analysis; };
(ff:bind-c-type _PangoItem (:struct
  (offset gint)   ;; gint offset
  (length gint)   ;; gint length
  (num_chars gint)   ;; gint num_chars
  (analysis PangoAnalysis)   ;; PangoAnalysis analysis
  ))   ;; bind-c-type _PangoItem
(ff:bind-c-typedef PangoItem _PangoItem) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:51 <1645> 
;; PangoItem* pango_item_new( void);
(ff:bind-c-function pango_item_new
     :unconverted-entry-name "pango_item_new"
     :c-return-type ("PangoItem" "*")
     :return-type (* PangoItem)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:52 <1646> 
;; PangoItem* pango_item_copy( PangoItem* item);
(ff:bind-c-function pango_item_copy
     :unconverted-entry-name "pango_item_copy"
     :c-return-type ("PangoItem" "*")
     :return-type (* PangoItem)
     :c-arg-types (("PangoItem" "*"))
     :c-arg-names (item)
     :arguments ((* PangoItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:53 <1647> 
;; void pango_item_free( PangoItem* item);
(ff:bind-c-function pango_item_free
     :unconverted-entry-name "pango_item_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoItem" "*"))
     :c-arg-names (item)
     :arguments ((* PangoItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-item.h:54 <1648> 
;; PangoItem* pango_item_split( PangoItem* orig, int split_index, int
;;   split_offset
;;   );
(ff:bind-c-function pango_item_split
     :unconverted-entry-name "pango_item_split"
     :c-return-type ("PangoItem" "*")
     :return-type (* PangoItem)
     :c-arg-types (("PangoItem" "*") ("int") ("int"))
     :c-arg-names (orig split_index split_offset)
     :arguments ((* PangoItem) :int :int)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-break.h:33 <1649> 
;; struct _PangoLogAttr {
;;         guint is_line_break:  0x000000001; guint is_mandatory_break:
;;   0x000000001;
;;              guint is_char_break:  0x000000001; guint is_white:
;;   0x000000001; guint
;;    is_cursor_position:  0x000000001; guint is_word_start:  0x000000001;
;;   guint
;;    is_word_end:  0x000000001; guint is_sentence_boundary:  0x000000001;
;;   guint
;;    is_sentence_start:  0x000000001; guint is_sentence_end:  0x000000001;
;;    };

;;WARNING: Strange bitfield is_line_break type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_mandatory_break type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_char_break type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_white type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_cursor_position type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_word_start type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_word_end type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_sentence_boundary type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_sentence_start type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield is_sentence_end type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _PangoLogAttr (:struct
  (is_line_break (:bit 1))   ;; guint is_line_break:  0x000000001
  (is_mandatory_break (:bit
                       1))   ;;
  ;;  guint is_mandatory_break:  0x000000001
  (is_char_break (:bit 1))   ;; guint is_char_break:  0x000000001
  (is_white (:bit 1))   ;; guint is_white:  0x000000001
  (is_cursor_position (:bit
                       1))   ;;
  ;;  guint is_cursor_position:  0x000000001
  (is_word_start (:bit 1))   ;; guint is_word_start:  0x000000001
  (is_word_end (:bit 1))   ;; guint is_word_end:  0x000000001
  (is_sentence_boundary (:bit
                         1))   ;;
  ;;  guint is_sentence_boundary:  0x000000001
  (is_sentence_start (:bit
                      1))   ;;
  ;;  guint is_sentence_start:  0x000000001
  (is_sentence_end (:bit 1))   ;; guint is_sentence_end:  0x000000001
  ))   ;; bind-c-type _PangoLogAttr
(ff:bind-c-typedef PangoLogAttr _PangoLogAttr) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-break.h:72 <1650> 
;; void pango_break( const gchar* text, int length, PangoAnalysis*
;;   analysis,
;;              PangoLogAttr* attrs, int attrs_len);
(ff:bind-c-function pango_break
     :unconverted-entry-name "pango_break"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("int") ("PangoAnalysis" "*")
                   ("PangoLogAttr" "*") ("int"))
     :c-arg-names (text length analysis attrs attrs_len)
     :arguments ((* gchar) :int (* PangoAnalysis) (* PangoLogAttr) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-break.h:78 <1651> 
;; void pango_find_paragraph_boundary( const gchar* text, gint length, gint
;;   * paragraph_delimiter_index, gint* next_paragraph_start);
(ff:bind-c-function pango_find_paragraph_boundary
     :unconverted-entry-name "pango_find_paragraph_boundary"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("gint") ("gint" "*")
                   ("gint" "*"))
     :c-arg-names (text length paragraph_delimiter_index
                   next_paragraph_start)
     :arguments ((* gchar) gint (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-break.h:83 <1652> 
;; void pango_get_log_attrs( const char* text, int length, int level,
;;   PangoLanguage
;;   * language, PangoLogAttr* log_attrs, int attrs_len);
(ff:bind-c-function pango_get_log_attrs
     :unconverted-entry-name "pango_get_log_attrs"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "char" "*") ("int") ("int")
                   ("PangoLanguage" "*") ("PangoLogAttr" "*") ("int"))
     :c-arg-names (text length level language log_attrs attrs_len)
     :arguments ((* :char) :int :int (* PangoLanguage) (* PangoLogAttr)
                 :int)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontset.h:40 <1653> 
;; GType pango_fontset_get_type( void);
(ff:bind-c-function pango_fontset_get_type
     :unconverted-entry-name "pango_fontset_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontset.h:42 <1654> 
;; typedef struct _PangoFontset PangoFontset;
(ff:bind-c-typedef _PangoFontset
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoFontset _PangoFontset)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontset.h:44 <1655> 
;; PangoFont* pango_fontset_get_font( PangoFontset* fontset, guint wc);
(ff:bind-c-function pango_fontset_get_font
     :unconverted-entry-name "pango_fontset_get_font"
     :c-return-type ("PangoFont" "*")
     :return-type (* PangoFont)
     :c-arg-types (("PangoFontset" "*") ("guint"))
     :c-arg-names (fontset wc)
     :arguments ((* PangoFontset) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontset.h:46 <1656> 
;; PangoFontMetrics* pango_fontset_get_metrics( PangoFontset* fontset);
(ff:bind-c-function pango_fontset_get_metrics
     :unconverted-entry-name "pango_fontset_get_metrics"
     :c-return-type ("PangoFontMetrics" "*")
     :return-type (* PangoFontMetrics)
     :c-arg-types (("PangoFontset" "*"))
     :c-arg-names (fontset)
     :arguments ((* PangoFontset))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontmap.h:34 <1657> 
;; typedef struct _PangoContext PangoContext;
(ff:bind-c-typedef _PangoContext
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoContext _PangoContext)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontmap.h:35 <1658> 
;; typedef struct _PangoFontMap PangoFontMap;
(ff:bind-c-typedef _PangoFontMap
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoFontMap _PangoFontMap)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontmap.h:37 <1659> 
;; GType pango_font_map_get_type( void);
(ff:bind-c-function pango_font_map_get_type
     :unconverted-entry-name "pango_font_map_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontmap.h:38 <1660> 
;; PangoFont* pango_font_map_load_font( PangoFontMap* fontmap, PangoContext
;;   * context, const PangoFontDescription* desc);
(ff:bind-c-function pango_font_map_load_font
     :unconverted-entry-name "pango_font_map_load_font"
     :c-return-type ("PangoFont" "*")
     :return-type (* PangoFont)
     :c-arg-types (("PangoFontMap" "*") ("PangoContext" "*")
                   ("const" "PangoFontDescription" "*"))
     :c-arg-names (fontmap context desc)
     :arguments ((* PangoFontMap) (* PangoContext)
                 (* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontmap.h:41 <1661> 
;; PangoFontset* pango_font_map_load_fontset( PangoFontMap* fontmap,
;;   PangoContext
;;   * context, const PangoFontDescription* desc, PangoLanguage* language);
(ff:bind-c-function pango_font_map_load_fontset
     :unconverted-entry-name "pango_font_map_load_fontset"
     :c-return-type ("PangoFontset" "*")
     :return-type (* PangoFontset)
     :c-arg-types (("PangoFontMap" "*") ("PangoContext" "*")
                   ("const" "PangoFontDescription" "*")
                   ("PangoLanguage" "*"))
     :c-arg-names (fontmap context desc language)
     :arguments ((* PangoFontMap) (* PangoContext)
                 (* PangoFontDescription) (* PangoLanguage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-fontmap.h:45 <1662> 
;; void pango_font_map_list_families( PangoFontMap* fontmap,
;;   PangoFontFamily
;;   *** families, int* n_families);
(ff:bind-c-function pango_font_map_list_families
     :unconverted-entry-name "pango_font_map_list_families"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoFontMap" "*") ("PangoFontFamily" "*" "*" "*")
                   ("int" "*"))
     :c-arg-names (fontmap families n_families)
     :arguments ((* PangoFontMap) (* (* (* PangoFontFamily))) (* :int))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:36 <1663> 
;; typedef struct _PangoContextClass PangoContextClass;
(ff:bind-c-typedef _PangoContextClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoContextClass _PangoContextClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:50 <1664> 
;; GType pango_context_get_type( void);
(ff:bind-c-function pango_context_get_type
     :unconverted-entry-name "pango_context_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:58 <1665> 
;; void pango_context_list_families( PangoContext* context, PangoFontFamily
;;   *** families, int* n_families);
(ff:bind-c-function pango_context_list_families
     :unconverted-entry-name "pango_context_list_families"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoContext" "*") ("PangoFontFamily" "*" "*" "*")
                   ("int" "*"))
     :c-arg-names (context families n_families)
     :arguments ((* PangoContext) (* (* (* PangoFontFamily))) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:61 <1666> 
;; PangoFont* pango_context_load_font( PangoContext* context, const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_context_load_font
     :unconverted-entry-name "pango_context_load_font"
     :c-return-type ("PangoFont" "*")
     :return-type (* PangoFont)
     :c-arg-types (("PangoContext" "*")
                   ("const" "PangoFontDescription" "*"))
     :c-arg-names (context desc)
     :arguments ((* PangoContext) (* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:63 <1667> 
;; PangoFontset* pango_context_load_fontset( PangoContext* context, const
;;    PangoFontDescription* desc, PangoLanguage* language);
(ff:bind-c-function pango_context_load_fontset
     :unconverted-entry-name "pango_context_load_fontset"
     :c-return-type ("PangoFontset" "*")
     :return-type (* PangoFontset)
     :c-arg-types (("PangoContext" "*")
                   ("const" "PangoFontDescription" "*")
                   ("PangoLanguage" "*"))
     :c-arg-names (context desc language)
     :arguments ((* PangoContext) (* PangoFontDescription)
                 (* PangoLanguage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:67 <1668> 
;; PangoFontMetrics* pango_context_get_metrics( PangoContext* context,
;;   const
;;    PangoFontDescription* desc, PangoLanguage* language);
(ff:bind-c-function pango_context_get_metrics
     :unconverted-entry-name "pango_context_get_metrics"
     :c-return-type ("PangoFontMetrics" "*")
     :return-type (* PangoFontMetrics)
     :c-arg-types (("PangoContext" "*")
                   ("const" "PangoFontDescription" "*")
                   ("PangoLanguage" "*"))
     :c-arg-names (context desc language)
     :arguments ((* PangoContext) (* PangoFontDescription)
                 (* PangoLanguage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:71 <1669> 
;; void pango_context_set_font_description( PangoContext* context, const
;;    PangoFontDescription* desc);
(ff:bind-c-function pango_context_set_font_description
     :unconverted-entry-name "pango_context_set_font_description"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoContext" "*")
                   ("const" "PangoFontDescription" "*"))
     :c-arg-names (context desc)
     :arguments ((* PangoContext) (* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:73 <1670> 
;; PangoFontDescription* pango_context_get_font_description( PangoContext
;;   * context);
(ff:bind-c-function pango_context_get_font_description
     :unconverted-entry-name "pango_context_get_font_description"
     :c-return-type ("PangoFontDescription" "*")
     :return-type (* PangoFontDescription)
     :c-arg-types (("PangoContext" "*"))
     :c-arg-names (context)
     :arguments ((* PangoContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:74 <1671> 
;; PangoLanguage* pango_context_get_language( PangoContext* context);
(ff:bind-c-function pango_context_get_language
     :unconverted-entry-name "pango_context_get_language"
     :c-return-type ("PangoLanguage" "*")
     :return-type (* PangoLanguage)
     :c-arg-types (("PangoContext" "*"))
     :c-arg-names (context)
     :arguments ((* PangoContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:75 <1672> 
;; void pango_context_set_language( PangoContext* context, PangoLanguage
;;   * language);
(ff:bind-c-function pango_context_set_language
     :unconverted-entry-name "pango_context_set_language"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoContext" "*") ("PangoLanguage" "*"))
     :c-arg-names (context language)
     :arguments ((* PangoContext) (* PangoLanguage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:77 <1673> 
;; void pango_context_set_base_dir( PangoContext* context, PangoDirection
;;    direction);
(ff:bind-c-function pango_context_set_base_dir
     :unconverted-entry-name "pango_context_set_base_dir"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoContext" "*") ("PangoDirection"))
     :c-arg-names (context direction)
     :arguments ((* PangoContext) PangoDirection)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:79 <1674> 
;; PangoDirection pango_context_get_base_dir( PangoContext* context);
(ff:bind-c-function pango_context_get_base_dir
     :unconverted-entry-name "pango_context_get_base_dir"
     :c-return-type ("PangoDirection")
     :return-type PangoDirection
     :c-arg-types (("PangoContext" "*"))
     :c-arg-names (context)
     :arguments ((* PangoContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-context.h:85 <1675> 
;; GList* pango_itemize( PangoContext* context, const char* text, int
;;   start_index,
;;              int length, PangoAttrList* attrs, PangoAttrIterator*
;;   cached_iter);
(ff:bind-c-function pango_itemize
     :unconverted-entry-name "pango_itemize"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("PangoContext" "*") ("const" "char" "*") ("int")
                   ("int") ("PangoAttrList" "*")
                   ("PangoAttrIterator" "*"))
     :c-arg-names (context text start_index length attrs cached_iter)
     :arguments ((* PangoContext) (* :char) :int :int (* PangoAttrList)
                 (* PangoAttrIterator))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:30 <1676> 
;; typedef struct _PangoGlyphGeometry PangoGlyphGeometry;
(ff:bind-c-typedef _PangoGlyphGeometry
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoGlyphGeometry _PangoGlyphGeometry)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:31 <1677> 
;; typedef struct _PangoGlyphVisAttr PangoGlyphVisAttr;
(ff:bind-c-typedef _PangoGlyphVisAttr
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoGlyphVisAttr _PangoGlyphVisAttr)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:32 <1678> 
;; typedef struct _PangoGlyphInfo PangoGlyphInfo;
(ff:bind-c-typedef _PangoGlyphInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoGlyphInfo _PangoGlyphInfo)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:33 <1679> 
;; typedef struct _PangoGlyphString PangoGlyphString;
(ff:bind-c-typedef _PangoGlyphString
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoGlyphString _PangoGlyphString)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:36 <1680> 
;; typedef gint32 PangoGlyphUnit;
(ff:bind-c-type PangoGlyphUnit gint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:40 <1681> 
;; struct _PangoGlyphGeometry {
;;         PangoGlyphUnit width; PangoGlyphUnit x_offset; PangoGlyphUnit
;;   y_offset;
;;    };
(ff:bind-c-type _PangoGlyphGeometry (:struct
  (width PangoGlyphUnit)   ;; PangoGlyphUnit width
  (x_offset PangoGlyphUnit)   ;; PangoGlyphUnit x_offset
  (y_offset PangoGlyphUnit)   ;; PangoGlyphUnit y_offset
  ))   ;; bind-c-type _PangoGlyphGeometry
(ff:bind-c-typedef PangoGlyphGeometry
                   _PangoGlyphGeometry) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:49 <1682> 
;; struct _PangoGlyphVisAttr { guint is_cluster_start:  0x000000001; };

;;WARNING: Strange bitfield is_cluster_start type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _PangoGlyphVisAttr (:struct
  (is_cluster_start (:bit 1))   ;; guint is_cluster_start:  0x000000001
  ))   ;; bind-c-type _PangoGlyphVisAttr
(ff:bind-c-typedef PangoGlyphVisAttr
                   _PangoGlyphVisAttr) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:56 <1683> 
;; struct _PangoGlyphInfo {
;;         PangoGlyph glyph; PangoGlyphGeometry geometry; PangoGlyphVisAttr
;;   attr;
;;    };
(ff:bind-c-type _PangoGlyphInfo (:struct
  (glyph PangoGlyph)   ;; PangoGlyph glyph
  (geometry PangoGlyphGeometry)   ;; PangoGlyphGeometry geometry
  (attr PangoGlyphVisAttr)   ;; PangoGlyphVisAttr attr
  ))   ;; bind-c-type _PangoGlyphInfo
(ff:bind-c-typedef PangoGlyphInfo
                   _PangoGlyphInfo) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:66 <1684> 
;; struct _PangoGlyphString {
;;         gint num_glyphs; PangoGlyphInfo* glyphs; gint* log_clusters;
;;   gint space;
;;    };
(ff:bind-c-type _PangoGlyphString (:struct
  (num_glyphs gint)   ;; gint num_glyphs
  (glyphs (* PangoGlyphInfo))   ;; PangoGlyphInfo* glyphs
  (log_clusters (* gint))   ;; gint* log_clusters
  (space gint)   ;; gint space
  ))   ;; bind-c-type _PangoGlyphString
(ff:bind-c-typedef PangoGlyphString
                   _PangoGlyphString) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:84 <1685> 
;; PangoGlyphString* pango_glyph_string_new( void);
(ff:bind-c-function pango_glyph_string_new
     :unconverted-entry-name "pango_glyph_string_new"
     :c-return-type ("PangoGlyphString" "*")
     :return-type (* PangoGlyphString)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:85 <1686> 
;; void pango_glyph_string_set_size( PangoGlyphString* string, gint new_len
;;   );
(ff:bind-c-function pango_glyph_string_set_size
     :unconverted-entry-name "pango_glyph_string_set_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoGlyphString" "*") ("gint"))
     :c-arg-names (string new_len)
     :arguments ((* PangoGlyphString) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:87 <1687> 
;; GType pango_glyph_string_get_type( void);
(ff:bind-c-function pango_glyph_string_get_type
     :unconverted-entry-name "pango_glyph_string_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:88 <1688> 
;; PangoGlyphString* pango_glyph_string_copy( PangoGlyphString* string);
(ff:bind-c-function pango_glyph_string_copy
     :unconverted-entry-name "pango_glyph_string_copy"
     :c-return-type ("PangoGlyphString" "*")
     :return-type (* PangoGlyphString)
     :c-arg-types (("PangoGlyphString" "*"))
     :c-arg-names (string)
     :arguments ((* PangoGlyphString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:89 <1689> 
;; void pango_glyph_string_free( PangoGlyphString* string);
(ff:bind-c-function pango_glyph_string_free
     :unconverted-entry-name "pango_glyph_string_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoGlyphString" "*"))
     :c-arg-names (string)
     :arguments ((* PangoGlyphString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:90 <1690> 
;; void pango_glyph_string_extents( PangoGlyphString* glyphs, PangoFont*
;;    font, PangoRectangle* ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_glyph_string_extents
     :unconverted-entry-name "pango_glyph_string_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoGlyphString" "*") ("PangoFont" "*")
                   ("PangoRectangle" "*") ("PangoRectangle" "*"))
     :c-arg-names (glyphs font ink_rect logical_rect)
     :arguments ((* PangoGlyphString) (* PangoFont) (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:95 <1691> 
;; void pango_glyph_string_extents_range( PangoGlyphString* glyphs, int
;;   start,
;;              int end, PangoFont* font, PangoRectangle* ink_rect,
;;   PangoRectangle* logical_rect
;;   );
(ff:bind-c-function pango_glyph_string_extents_range
     :unconverted-entry-name "pango_glyph_string_extents_range"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoGlyphString" "*") ("int") ("int")
                   ("PangoFont" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (glyphs start end font ink_rect logical_rect)
     :arguments ((* PangoGlyphString) :int :int (* PangoFont)
                 (* PangoRectangle) (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:102 <1692> 
;; void pango_glyph_string_get_logical_widths( PangoGlyphString* glyphs,
;;              const char* text, int length, int embedding_level, int*
;;   logical_widths
;;   );
(ff:bind-c-function pango_glyph_string_get_logical_widths
     :unconverted-entry-name "pango_glyph_string_get_logical_widths"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoGlyphString" "*") ("const" "char" "*")
                   ("int") ("int") ("int" "*"))
     :c-arg-names (glyphs text length embedding_level logical_widths)
     :arguments ((* PangoGlyphString) (* :char) :int :int (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:108 <1693> 
;; void pango_glyph_string_index_to_x( PangoGlyphString* glyphs, char*
;;   text,
;;              int length, PangoAnalysis* analysis, int index, gboolean
;;   trailing, int
;;   * x_pos);
(ff:bind-c-function pango_glyph_string_index_to_x
     :unconverted-entry-name "pango_glyph_string_index_to_x"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoGlyphString" "*") ("char" "*") ("int")
                   ("PangoAnalysis" "*") ("int") ("gboolean")
                   ("int" "*"))
     :c-arg-names (glyphs text length analysis index trailing x_pos)
     :arguments ((* PangoGlyphString) (* :char) :int (* PangoAnalysis)
                 :int gboolean (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:115 <1694> 
;; void pango_glyph_string_x_to_index( PangoGlyphString* glyphs, char*
;;   text,
;;              int length, PangoAnalysis* analysis, int x_pos, int* index,
;;   int* trailing
;;   );
(ff:bind-c-function pango_glyph_string_x_to_index
     :unconverted-entry-name "pango_glyph_string_x_to_index"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoGlyphString" "*") ("char" "*") ("int")
                   ("PangoAnalysis" "*") ("int") ("int" "*")
                   ("int" "*"))
     :c-arg-names (glyphs text length analysis x_pos index trailing)
     :arguments ((* PangoGlyphString) (* :char) :int (* PangoAnalysis)
                 :int (* :int) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:125 <1695> 
;; void pango_shape( const gchar* text, gint length, PangoAnalysis*
;;   analysis,
;;              PangoGlyphString* glyphs);
(ff:bind-c-function pango_shape
     :unconverted-entry-name "pango_shape"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("gint") ("PangoAnalysis" "*")
                   ("PangoGlyphString" "*"))
     :c-arg-names (text length analysis glyphs)
     :arguments ((* gchar) gint (* PangoAnalysis) (* PangoGlyphString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-glyph.h:130 <1696> 
;; GList* pango_reorder_items( GList* logical_items);
(ff:bind-c-function pango_reorder_items
     :unconverted-entry-name "pango_reorder_items"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (logical_items)
     :arguments ((* GList))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:13 <1697> 
;; GType pango_attr_type_get_type( void);
(ff:bind-c-function pango_attr_type_get_type
     :unconverted-entry-name "pango_attr_type_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:16 <1698> 
;; GType pango_underline_get_type( void);
(ff:bind-c-function pango_underline_get_type
     :unconverted-entry-name "pango_underline_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:21 <1699> 
;; GType pango_coverage_level_get_type( void);
(ff:bind-c-function pango_coverage_level_get_type
     :unconverted-entry-name "pango_coverage_level_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:26 <1700> 
;; GType pango_style_get_type( void);
(ff:bind-c-function pango_style_get_type
     :unconverted-entry-name "pango_style_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:29 <1701> 
;; GType pango_variant_get_type( void);
(ff:bind-c-function pango_variant_get_type
     :unconverted-entry-name "pango_variant_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:32 <1702> 
;; GType pango_weight_get_type( void);
(ff:bind-c-function pango_weight_get_type
     :unconverted-entry-name "pango_weight_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:35 <1703> 
;; GType pango_stretch_get_type( void);
(ff:bind-c-function pango_stretch_get_type
     :unconverted-entry-name "pango_stretch_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:38 <1704> 
;; GType pango_font_mask_get_type( void);
(ff:bind-c-function pango_font_mask_get_type
     :unconverted-entry-name "pango_font_mask_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:43 <1705> 
;; GType pango_alignment_get_type( void);
(ff:bind-c-function pango_alignment_get_type
     :unconverted-entry-name "pango_alignment_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:46 <1706> 
;; GType pango_wrap_mode_get_type( void);
(ff:bind-c-function pango_wrap_mode_get_type
     :unconverted-entry-name "pango_wrap_mode_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:51 <1707> 
;; GType pango_tab_align_get_type( void);
(ff:bind-c-function pango_tab_align_get_type
     :unconverted-entry-name "pango_tab_align_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-enum-types.h:56 <1708> 
;; GType pango_direction_get_type( void);
(ff:bind-c-function pango_direction_get_type
     :unconverted-entry-name "pango_direction_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:29 <1709> 
;; typedef struct _PangoTabArray PangoTabArray;
(ff:bind-c-typedef _PangoTabArray
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoTabArray _PangoTabArray)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:31 <1710> 
;; typedef enum { PANGO_TAB_LEFT } PangoTabAlign;
(ff:bind-c-constant PANGO_TAB_LEFT 0) ;;  PANGO_TAB_LEFT 
(ff:bind-c-type PangoTabAlign :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:46 <1711> 
;; PangoTabArray* pango_tab_array_new( gint initial_size, gboolean
;;   positions_in_pixels
;;   );
(ff:bind-c-function pango_tab_array_new
     :unconverted-entry-name "pango_tab_array_new"
     :c-return-type ("PangoTabArray" "*")
     :return-type (* PangoTabArray)
     :c-arg-types (("gint") ("gboolean"))
     :c-arg-names (initial_size positions_in_pixels)
     :arguments (gint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:48 <1712> 
;; PangoTabArray* pango_tab_array_new_with_positions( gint size, gboolean
;;    positions_in_pixels, PangoTabAlign first_alignment, gint
;;   first_position
;;   , ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function pango_tab_array_new_with_positions
     :unconverted-entry-name "pango_tab_array_new_with_positions"
     :c-return-type ("PangoTabArray" "*")
     :return-type (* PangoTabArray)
     :c-arg-types (("gint") ("gboolean") ("PangoTabAlign") ("gint")
                   "...")
     :c-arg-names (size positions_in_pixels first_alignment
                   first_position)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:53 <1713> 
;; GType pango_tab_array_get_type( void);
(ff:bind-c-function pango_tab_array_get_type
     :unconverted-entry-name "pango_tab_array_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:54 <1714> 
;; PangoTabArray* pango_tab_array_copy( PangoTabArray* src);
(ff:bind-c-function pango_tab_array_copy
     :unconverted-entry-name "pango_tab_array_copy"
     :c-return-type ("PangoTabArray" "*")
     :return-type (* PangoTabArray)
     :c-arg-types (("PangoTabArray" "*"))
     :c-arg-names (src)
     :arguments ((* PangoTabArray))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:55 <1715> 
;; void pango_tab_array_free( PangoTabArray* tab_array);
(ff:bind-c-function pango_tab_array_free
     :unconverted-entry-name "pango_tab_array_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoTabArray" "*"))
     :c-arg-names (tab_array)
     :arguments ((* PangoTabArray))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:56 <1716> 
;; gint pango_tab_array_get_size( PangoTabArray* tab_array);
(ff:bind-c-function pango_tab_array_get_size
     :unconverted-entry-name "pango_tab_array_get_size"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("PangoTabArray" "*"))
     :c-arg-names (tab_array)
     :arguments ((* PangoTabArray))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:57 <1717> 
;; void pango_tab_array_resize( PangoTabArray* tab_array, gint new_size);
(ff:bind-c-function pango_tab_array_resize
     :unconverted-entry-name "pango_tab_array_resize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoTabArray" "*") ("gint"))
     :c-arg-names (tab_array new_size)
     :arguments ((* PangoTabArray) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:59 <1718> 
;; void pango_tab_array_set_tab( PangoTabArray* tab_array, gint tab_index,
;;              PangoTabAlign alignment, gint location);
(ff:bind-c-function pango_tab_array_set_tab
     :unconverted-entry-name "pango_tab_array_set_tab"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoTabArray" "*") ("gint") ("PangoTabAlign")
                   ("gint"))
     :c-arg-names (tab_array tab_index alignment location)
     :arguments ((* PangoTabArray) gint PangoTabAlign gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:63 <1719> 
;; void pango_tab_array_get_tab( PangoTabArray* tab_array, gint tab_index,
;;              PangoTabAlign* alignment, gint* location);
(ff:bind-c-function pango_tab_array_get_tab
     :unconverted-entry-name "pango_tab_array_get_tab"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoTabArray" "*") ("gint") ("PangoTabAlign" "*")
                   ("gint" "*"))
     :c-arg-names (tab_array tab_index alignment location)
     :arguments ((* PangoTabArray) gint (* PangoTabAlign) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:67 <1720> 
;; void pango_tab_array_get_tabs( PangoTabArray* tab_array, PangoTabAlign
;;   ** alignments, gint** locations);
(ff:bind-c-function pango_tab_array_get_tabs
     :unconverted-entry-name "pango_tab_array_get_tabs"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoTabArray" "*") ("PangoTabAlign" "*" "*")
                   ("gint" "*" "*"))
     :c-arg-names (tab_array alignments locations)
     :arguments ((* PangoTabArray) (* (* PangoTabAlign)) (* (* gint)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-tabs.h:71 <1721> 
;; gboolean pango_tab_array_get_positions_in_pixels( PangoTabArray*
;;   tab_array
;;   );
(ff:bind-c-function pango_tab_array_get_positions_in_pixels
     :unconverted-entry-name "pango_tab_array_get_positions_in_pixels"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoTabArray" "*"))
     :c-arg-names (tab_array)
     :arguments ((* PangoTabArray))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:32 <1722> 
;; typedef struct _PangoLayout PangoLayout;
(ff:bind-c-typedef _PangoLayout
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoLayout _PangoLayout)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:33 <1723> 
;; typedef struct _PangoLayoutClass PangoLayoutClass;
(ff:bind-c-typedef _PangoLayoutClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoLayoutClass _PangoLayoutClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:34 <1724> 
;; typedef struct _PangoLayoutLine PangoLayoutLine;
(ff:bind-c-typedef _PangoLayoutLine
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoLayoutLine _PangoLayoutLine)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:35 <1725> 
;; typedef struct _PangoLayoutRun PangoLayoutRun;
(ff:bind-c-typedef _PangoLayoutRun
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoLayoutRun _PangoLayoutRun)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:37 <1726> 
;; typedef enum {
;;         PANGO_ALIGN_LEFT, PANGO_ALIGN_CENTER, PANGO_ALIGN_RIGHT }
;;   PangoAlignment
;;   ;
(ff:bind-c-constant PANGO_ALIGN_LEFT 0) ;;  PANGO_ALIGN_LEFT 
(ff:bind-c-constant PANGO_ALIGN_CENTER 1) ;;  PANGO_ALIGN_CENTER 
(ff:bind-c-constant PANGO_ALIGN_RIGHT 2) ;;  PANGO_ALIGN_RIGHT 
(ff:bind-c-type PangoAlignment :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:43 <1727> 
;; typedef enum { PANGO_WRAP_WORD, PANGO_WRAP_CHAR } PangoWrapMode;
(ff:bind-c-constant PANGO_WRAP_WORD 0) ;;  PANGO_WRAP_WORD 
(ff:bind-c-constant PANGO_WRAP_CHAR 1) ;;  PANGO_WRAP_CHAR 
(ff:bind-c-type PangoWrapMode :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:48 <1728> 
;; struct _PangoLayoutLine {
;;         PangoLayout* layout; gint start_index; gint length; GSList*
;;   runs; };
(ff:bind-c-type _PangoLayoutLine (:struct
  (layout (* PangoLayout))   ;; PangoLayout* layout
  (start_index gint)   ;; gint start_index
  (length gint)   ;; gint length
  (runs (* GSList))   ;; GSList* runs
  ))   ;; bind-c-type _PangoLayoutLine
(ff:bind-c-typedef PangoLayoutLine
                   _PangoLayoutLine) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:56 <1729> 
;; struct _PangoLayoutRun { PangoItem* item; PangoGlyphString* glyphs; };
(ff:bind-c-type _PangoLayoutRun (:struct
  (item (* PangoItem))   ;; PangoItem* item
  (glyphs (* PangoGlyphString))   ;; PangoGlyphString* glyphs
  ))   ;; bind-c-type _PangoLayoutRun
(ff:bind-c-typedef PangoLayoutRun
                   _PangoLayoutRun) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:74 <1730> 
;; GType pango_layout_get_type( void);
(ff:bind-c-function pango_layout_get_type
     :unconverted-entry-name "pango_layout_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:75 <1731> 
;; PangoLayout* pango_layout_new( PangoContext* context);
(ff:bind-c-function pango_layout_new
     :unconverted-entry-name "pango_layout_new"
     :c-return-type ("PangoLayout" "*")
     :return-type (* PangoLayout)
     :c-arg-types (("PangoContext" "*"))
     :c-arg-names (context)
     :arguments ((* PangoContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:76 <1732> 
;; PangoLayout* pango_layout_copy( PangoLayout* src);
(ff:bind-c-function pango_layout_copy
     :unconverted-entry-name "pango_layout_copy"
     :c-return-type ("PangoLayout" "*")
     :return-type (* PangoLayout)
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (src)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:78 <1733> 
;; PangoContext* pango_layout_get_context( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_context
     :unconverted-entry-name "pango_layout_get_context"
     :c-return-type ("PangoContext" "*")
     :return-type (* PangoContext)
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:80 <1734> 
;; void pango_layout_set_attributes( PangoLayout* layout, PangoAttrList*
;;    attrs);
(ff:bind-c-function pango_layout_set_attributes
     :unconverted-entry-name "pango_layout_set_attributes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("PangoAttrList" "*"))
     :c-arg-names (layout attrs)
     :arguments ((* PangoLayout) (* PangoAttrList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:82 <1735> 
;; PangoAttrList* pango_layout_get_attributes( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_attributes
     :unconverted-entry-name "pango_layout_get_attributes"
     :c-return-type ("PangoAttrList" "*")
     :return-type (* PangoAttrList)
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:84 <1736> 
;; void pango_layout_set_text( PangoLayout* layout, const char* text, int
;;    length);
(ff:bind-c-function pango_layout_set_text
     :unconverted-entry-name "pango_layout_set_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("const" "char" "*") ("int"))
     :c-arg-names (layout text length)
     :arguments ((* PangoLayout) (* :char) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:87 <1737> 
;; const char* pango_layout_get_text( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_text
     :unconverted-entry-name "pango_layout_get_text"
     :c-modifiers ("const")
     :c-return-type ("const" "char" "*")
     :return-type (* :char)
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:89 <1738> 
;; void pango_layout_set_markup( PangoLayout* layout, const char* markup,
;;              int length);
(ff:bind-c-function pango_layout_set_markup
     :unconverted-entry-name "pango_layout_set_markup"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("const" "char" "*") ("int"))
     :c-arg-names (layout markup length)
     :arguments ((* PangoLayout) (* :char) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:93 <1739> 
;; void pango_layout_set_markup_with_accel( PangoLayout* layout, const char
;;   * markup, int length, gunichar accel_marker, gunichar* accel_char);
(ff:bind-c-function pango_layout_set_markup_with_accel
     :unconverted-entry-name "pango_layout_set_markup_with_accel"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("const" "char" "*") ("int")
                   ("gunichar") ("gunichar" "*"))
     :c-arg-names (layout markup length accel_marker accel_char)
     :arguments ((* PangoLayout) (* :char) :int gunichar (* gunichar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:99 <1740> 
;; void pango_layout_set_font_description( PangoLayout* layout, const
;;   PangoFontDescription
;;   * desc);
(ff:bind-c-function pango_layout_set_font_description
     :unconverted-entry-name "pango_layout_set_font_description"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*")
                   ("const" "PangoFontDescription" "*"))
     :c-arg-names (layout desc)
     :arguments ((* PangoLayout) (* PangoFontDescription))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:101 <1741> 
;; void pango_layout_set_width( PangoLayout* layout, int width);
(ff:bind-c-function pango_layout_set_width
     :unconverted-entry-name "pango_layout_set_width"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("int"))
     :c-arg-names (layout width)
     :arguments ((* PangoLayout) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:103 <1742> 
;; int pango_layout_get_width( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_width
     :unconverted-entry-name "pango_layout_get_width"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:104 <1743> 
;; void pango_layout_set_wrap( PangoLayout* layout, PangoWrapMode wrap);
(ff:bind-c-function pango_layout_set_wrap
     :unconverted-entry-name "pango_layout_set_wrap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("PangoWrapMode"))
     :c-arg-names (layout wrap)
     :arguments ((* PangoLayout) PangoWrapMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:106 <1744> 
;; PangoWrapMode pango_layout_get_wrap( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_wrap
     :unconverted-entry-name "pango_layout_get_wrap"
     :c-return-type ("PangoWrapMode")
     :return-type PangoWrapMode
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:107 <1745> 
;; void pango_layout_set_indent( PangoLayout* layout, int indent);
(ff:bind-c-function pango_layout_set_indent
     :unconverted-entry-name "pango_layout_set_indent"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("int"))
     :c-arg-names (layout indent)
     :arguments ((* PangoLayout) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:109 <1746> 
;; int pango_layout_get_indent( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_indent
     :unconverted-entry-name "pango_layout_get_indent"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:110 <1747> 
;; void pango_layout_set_spacing( PangoLayout* layout, int spacing);
(ff:bind-c-function pango_layout_set_spacing
     :unconverted-entry-name "pango_layout_set_spacing"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("int"))
     :c-arg-names (layout spacing)
     :arguments ((* PangoLayout) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:112 <1748> 
;; int pango_layout_get_spacing( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_spacing
     :unconverted-entry-name "pango_layout_get_spacing"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:113 <1749> 
;; void pango_layout_set_justify( PangoLayout* layout, gboolean justify);
(ff:bind-c-function pango_layout_set_justify
     :unconverted-entry-name "pango_layout_set_justify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("gboolean"))
     :c-arg-names (layout justify)
     :arguments ((* PangoLayout) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:115 <1750> 
;; gboolean pango_layout_get_justify( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_justify
     :unconverted-entry-name "pango_layout_get_justify"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:116 <1751> 
;; void pango_layout_set_alignment( PangoLayout* layout, PangoAlignment
;;   alignment
;;   );
(ff:bind-c-function pango_layout_set_alignment
     :unconverted-entry-name "pango_layout_set_alignment"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("PangoAlignment"))
     :c-arg-names (layout alignment)
     :arguments ((* PangoLayout) PangoAlignment)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:118 <1752> 
;; PangoAlignment pango_layout_get_alignment( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_alignment
     :unconverted-entry-name "pango_layout_get_alignment"
     :c-return-type ("PangoAlignment")
     :return-type PangoAlignment
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:120 <1753> 
;; void pango_layout_set_tabs( PangoLayout* layout, PangoTabArray* tabs);
(ff:bind-c-function pango_layout_set_tabs
     :unconverted-entry-name "pango_layout_set_tabs"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("PangoTabArray" "*"))
     :c-arg-names (layout tabs)
     :arguments ((* PangoLayout) (* PangoTabArray))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:123 <1754> 
;; PangoTabArray* pango_layout_get_tabs( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_tabs
     :unconverted-entry-name "pango_layout_get_tabs"
     :c-return-type ("PangoTabArray" "*")
     :return-type (* PangoTabArray)
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:125 <1755> 
;; void pango_layout_set_single_paragraph_mode( PangoLayout* layout,
;;   gboolean
;;    setting);
(ff:bind-c-function pango_layout_set_single_paragraph_mode
     :unconverted-entry-name "pango_layout_set_single_paragraph_mode"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("gboolean"))
     :c-arg-names (layout setting)
     :arguments ((* PangoLayout) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:127 <1756> 
;; gboolean pango_layout_get_single_paragraph_mode( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_single_paragraph_mode
     :unconverted-entry-name "pango_layout_get_single_paragraph_mode"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:129 <1757> 
;; void pango_layout_context_changed( PangoLayout* layout);
(ff:bind-c-function pango_layout_context_changed
     :unconverted-entry-name "pango_layout_context_changed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:131 <1758> 
;; void pango_layout_get_log_attrs( PangoLayout* layout, PangoLogAttr**
;;   attrs,
;;              gint* n_attrs);
(ff:bind-c-function pango_layout_get_log_attrs
     :unconverted-entry-name "pango_layout_get_log_attrs"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("PangoLogAttr" "*" "*")
                   ("gint" "*"))
     :c-arg-names (layout attrs n_attrs)
     :arguments ((* PangoLayout) (* (* PangoLogAttr)) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:135 <1759> 
;; void pango_layout_index_to_pos( PangoLayout* layout, int index,
;;   PangoRectangle
;;   * pos);
(ff:bind-c-function pango_layout_index_to_pos
     :unconverted-entry-name "pango_layout_index_to_pos"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("int") ("PangoRectangle" "*"))
     :c-arg-names (layout index pos)
     :arguments ((* PangoLayout) :int (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:138 <1760> 
;; void pango_layout_get_cursor_pos( PangoLayout* layout, int index,
;;   PangoRectangle
;;   * strong_pos, PangoRectangle* weak_pos);
(ff:bind-c-function pango_layout_get_cursor_pos
     :unconverted-entry-name "pango_layout_get_cursor_pos"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("int") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (layout index strong_pos weak_pos)
     :arguments ((* PangoLayout) :int (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:142 <1761> 
;; void pango_layout_move_cursor_visually( PangoLayout* layout, gboolean
;;    strong, int old_index, int old_trailing, int direction, int*
;;   new_index,
;;              int* new_trailing);
(ff:bind-c-function pango_layout_move_cursor_visually
     :unconverted-entry-name "pango_layout_move_cursor_visually"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("gboolean") ("int") ("int")
                   ("int") ("int" "*") ("int" "*"))
     :c-arg-names (layout strong old_index old_trailing direction
                   new_index new_trailing)
     :arguments ((* PangoLayout) gboolean :int :int :int (* :int)
                 (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:149 <1762> 
;; gboolean pango_layout_xy_to_index( PangoLayout* layout, int x, int y,
;;              int* index, int* trailing);
(ff:bind-c-function pango_layout_xy_to_index
     :unconverted-entry-name "pango_layout_xy_to_index"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayout" "*") ("int") ("int") ("int" "*")
                   ("int" "*"))
     :c-arg-names (layout x y index trailing)
     :arguments ((* PangoLayout) :int :int (* :int) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:154 <1763> 
;; void pango_layout_get_extents( PangoLayout* layout, PangoRectangle*
;;   ink_rect,
;;              PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_get_extents
     :unconverted-entry-name "pango_layout_get_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (layout ink_rect logical_rect)
     :arguments ((* PangoLayout) (* PangoRectangle) (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:157 <1764> 
;; void pango_layout_get_pixel_extents( PangoLayout* layout, PangoRectangle
;;   * ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_get_pixel_extents
     :unconverted-entry-name "pango_layout_get_pixel_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (layout ink_rect logical_rect)
     :arguments ((* PangoLayout) (* PangoRectangle) (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:160 <1765> 
;; void pango_layout_get_size( PangoLayout* layout, int* width, int* height
;;   );
(ff:bind-c-function pango_layout_get_size
     :unconverted-entry-name "pango_layout_get_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("int" "*") ("int" "*"))
     :c-arg-names (layout width height)
     :arguments ((* PangoLayout) (* :int) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:163 <1766> 
;; void pango_layout_get_pixel_size( PangoLayout* layout, int* width, int
;;   * height);
(ff:bind-c-function pango_layout_get_pixel_size
     :unconverted-entry-name "pango_layout_get_pixel_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayout" "*") ("int" "*") ("int" "*"))
     :c-arg-names (layout width height)
     :arguments ((* PangoLayout) (* :int) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:167 <1767> 
;; int pango_layout_get_line_count( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_line_count
     :unconverted-entry-name "pango_layout_get_line_count"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:168 <1768> 
;; PangoLayoutLine* pango_layout_get_line( PangoLayout* layout, int line);
(ff:bind-c-function pango_layout_get_line
     :unconverted-entry-name "pango_layout_get_line"
     :c-return-type ("PangoLayoutLine" "*")
     :return-type (* PangoLayoutLine)
     :c-arg-types (("PangoLayout" "*") ("int"))
     :c-arg-names (layout line)
     :arguments ((* PangoLayout) :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:170 <1769> 
;; GSList* pango_layout_get_lines( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_lines
     :unconverted-entry-name "pango_layout_get_lines"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:172 <1770> 
;; void pango_layout_line_ref( PangoLayoutLine* line);
(ff:bind-c-function pango_layout_line_ref
     :unconverted-entry-name "pango_layout_line_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutLine" "*"))
     :c-arg-names (line)
     :arguments ((* PangoLayoutLine))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:173 <1771> 
;; void pango_layout_line_unref( PangoLayoutLine* line);
(ff:bind-c-function pango_layout_line_unref
     :unconverted-entry-name "pango_layout_line_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutLine" "*"))
     :c-arg-names (line)
     :arguments ((* PangoLayoutLine))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:174 <1772> 
;; gboolean pango_layout_line_x_to_index( PangoLayoutLine* line, int x_pos,
;;              int* index, int* trailing);
(ff:bind-c-function pango_layout_line_x_to_index
     :unconverted-entry-name "pango_layout_line_x_to_index"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayoutLine" "*") ("int") ("int" "*")
                   ("int" "*"))
     :c-arg-names (line x_pos index trailing)
     :arguments ((* PangoLayoutLine) :int (* :int) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:178 <1773> 
;; void pango_layout_line_index_to_x( PangoLayoutLine* line, int index,
;;   gboolean
;;    trailing, int* x_pos);
(ff:bind-c-function pango_layout_line_index_to_x
     :unconverted-entry-name "pango_layout_line_index_to_x"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutLine" "*") ("int") ("gboolean")
                   ("int" "*"))
     :c-arg-names (line index trailing x_pos)
     :arguments ((* PangoLayoutLine) :int gboolean (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:182 <1774> 
;; void pango_layout_line_get_x_ranges( PangoLayoutLine* line, int
;;   start_index,
;;              int end_index, int** ranges, int* n_ranges);
(ff:bind-c-function pango_layout_line_get_x_ranges
     :unconverted-entry-name "pango_layout_line_get_x_ranges"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutLine" "*") ("int") ("int")
                   ("int" "*" "*") ("int" "*"))
     :c-arg-names (line start_index end_index ranges n_ranges)
     :arguments ((* PangoLayoutLine) :int :int (* (* :int)) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:187 <1775> 
;; void pango_layout_line_get_extents( PangoLayoutLine* line,
;;   PangoRectangle
;;   * ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_line_get_extents
     :unconverted-entry-name "pango_layout_line_get_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutLine" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (line ink_rect logical_rect)
     :arguments ((* PangoLayoutLine) (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:190 <1776> 
;; void pango_layout_line_get_pixel_extents( PangoLayoutLine* layout_line,
;;              PangoRectangle* ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_line_get_pixel_extents
     :unconverted-entry-name "pango_layout_line_get_pixel_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutLine" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (layout_line ink_rect logical_rect)
     :arguments ((* PangoLayoutLine) (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:194 <1777> 
;; typedef struct _PangoLayoutIter PangoLayoutIter;
(ff:bind-c-typedef _PangoLayoutIter
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type PangoLayoutIter _PangoLayoutIter)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:196 <1778> 
;; PangoLayoutIter* pango_layout_get_iter( PangoLayout* layout);
(ff:bind-c-function pango_layout_get_iter
     :unconverted-entry-name "pango_layout_get_iter"
     :c-return-type ("PangoLayoutIter" "*")
     :return-type (* PangoLayoutIter)
     :c-arg-types (("PangoLayout" "*"))
     :c-arg-names (layout)
     :arguments ((* PangoLayout))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:197 <1779> 
;; void pango_layout_iter_free( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_free
     :unconverted-entry-name "pango_layout_iter_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:199 <1780> 
;; int pango_layout_iter_get_index( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_get_index
     :unconverted-entry-name "pango_layout_iter_get_index"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:200 <1781> 
;; PangoLayoutRun* pango_layout_iter_get_run( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_get_run
     :unconverted-entry-name "pango_layout_iter_get_run"
     :c-return-type ("PangoLayoutRun" "*")
     :return-type (* PangoLayoutRun)
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:201 <1782> 
;; PangoLayoutLine* pango_layout_iter_get_line( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_get_line
     :unconverted-entry-name "pango_layout_iter_get_line"
     :c-return-type ("PangoLayoutLine" "*")
     :return-type (* PangoLayoutLine)
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:202 <1783> 
;; gboolean pango_layout_iter_at_last_line( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_at_last_line
     :unconverted-entry-name "pango_layout_iter_at_last_line"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:204 <1784> 
;; gboolean pango_layout_iter_next_char( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_next_char
     :unconverted-entry-name "pango_layout_iter_next_char"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:205 <1785> 
;; gboolean pango_layout_iter_next_cluster( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_next_cluster
     :unconverted-entry-name "pango_layout_iter_next_cluster"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:206 <1786> 
;; gboolean pango_layout_iter_next_run( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_next_run
     :unconverted-entry-name "pango_layout_iter_next_run"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:207 <1787> 
;; gboolean pango_layout_iter_next_line( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_next_line
     :unconverted-entry-name "pango_layout_iter_next_line"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:209 <1788> 
;; void pango_layout_iter_get_char_extents( PangoLayoutIter* iter,
;;   PangoRectangle
;;   * logical_rect);
(ff:bind-c-function pango_layout_iter_get_char_extents
     :unconverted-entry-name "pango_layout_iter_get_char_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutIter" "*") ("PangoRectangle" "*"))
     :c-arg-names (iter logical_rect)
     :arguments ((* PangoLayoutIter) (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:211 <1789> 
;; void pango_layout_iter_get_cluster_extents( PangoLayoutIter* iter,
;;   PangoRectangle
;;   * ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_iter_get_cluster_extents
     :unconverted-entry-name "pango_layout_iter_get_cluster_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutIter" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (iter ink_rect logical_rect)
     :arguments ((* PangoLayoutIter) (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:214 <1790> 
;; void pango_layout_iter_get_run_extents( PangoLayoutIter* iter,
;;   PangoRectangle
;;   * ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_iter_get_run_extents
     :unconverted-entry-name "pango_layout_iter_get_run_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutIter" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (iter ink_rect logical_rect)
     :arguments ((* PangoLayoutIter) (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:217 <1791> 
;; void pango_layout_iter_get_line_extents( PangoLayoutIter* iter,
;;   PangoRectangle
;;   * ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_iter_get_line_extents
     :unconverted-entry-name "pango_layout_iter_get_line_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutIter" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (iter ink_rect logical_rect)
     :arguments ((* PangoLayoutIter) (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:223 <1792> 
;; void pango_layout_iter_get_line_yrange( PangoLayoutIter* iter, int* y0,
;;              int* y1);
(ff:bind-c-function pango_layout_iter_get_line_yrange
     :unconverted-entry-name "pango_layout_iter_get_line_yrange"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutIter" "*") ("int" "*") ("int" "*"))
     :c-arg-names (iter y0 y1)
     :arguments ((* PangoLayoutIter) (* :int) (* :int))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:226 <1793> 
;; void pango_layout_iter_get_layout_extents( PangoLayoutIter* iter,
;;   PangoRectangle
;;   * ink_rect, PangoRectangle* logical_rect);
(ff:bind-c-function pango_layout_iter_get_layout_extents
     :unconverted-entry-name "pango_layout_iter_get_layout_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("PangoLayoutIter" "*") ("PangoRectangle" "*")
                   ("PangoRectangle" "*"))
     :c-arg-names (iter ink_rect logical_rect)
     :arguments ((* PangoLayoutIter) (* PangoRectangle)
                 (* PangoRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/pango-1.0/pango/pango-layout.h:229 <1794> 
;; int pango_layout_iter_get_baseline( PangoLayoutIter* iter);
(ff:bind-c-function pango_layout_iter_get_baseline
     :unconverted-entry-name "pango_layout_iter_get_baseline"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("PangoLayoutIter" "*"))
     :c-arg-names (iter)
     :arguments ((* PangoLayoutIter))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:66 <1795> 
;; typedef struct _GdkPoint GdkPoint;
(ff:bind-c-typedef _GdkPoint
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPoint _GdkPoint)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:67 <1796> 
;; typedef struct _GdkRectangle GdkRectangle;
(ff:bind-c-typedef _GdkRectangle
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkRectangle _GdkRectangle)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:68 <1797> 
;; typedef struct _GdkSegment GdkSegment;
(ff:bind-c-typedef _GdkSegment
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkSegment _GdkSegment)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:69 <1798> 
;; typedef struct _GdkSpan GdkSpan;
(ff:bind-c-typedef _GdkSpan
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkSpan _GdkSpan)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:76 <1799> 
;; typedef guint32 GdkWChar;
(ff:bind-c-type GdkWChar guint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:78 <1800> 
;; typedef struct _GdkAtom* GdkAtom;
(ff:bind-c-typedef _GdkAtom
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkAtom (* _GdkAtom))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:89 <1801> 
;; typedef guint32 GdkNativeWindow;
(ff:bind-c-type GdkNativeWindow guint32)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:94 <1802> 
;; typedef struct _GdkColor GdkColor;
(ff:bind-c-typedef _GdkColor
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkColor _GdkColor)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:95 <1803> 
;; typedef struct _GdkColormap GdkColormap;
(ff:bind-c-typedef _GdkColormap
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkColormap _GdkColormap)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:96 <1804> 
;; typedef struct _GdkCursor GdkCursor;
(ff:bind-c-typedef _GdkCursor
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkCursor _GdkCursor)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:97 <1805> 
;; typedef struct _GdkFont GdkFont;
(ff:bind-c-typedef _GdkFont
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkFont _GdkFont)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:98 <1806> 
;; typedef struct _GdkGC GdkGC;
(ff:bind-c-typedef _GdkGC
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkGC _GdkGC)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:99 <1807> 
;; typedef struct _GdkImage GdkImage;
(ff:bind-c-typedef _GdkImage
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkImage _GdkImage)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:100 <1808> 
;; typedef struct _GdkRegion GdkRegion;
(ff:bind-c-typedef _GdkRegion
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkRegion _GdkRegion)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:101 <1809> 
;; typedef struct _GdkVisual GdkVisual;
(ff:bind-c-typedef _GdkVisual
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkVisual _GdkVisual)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:103 <1810> 
;; typedef struct _GdkDrawable GdkDrawable;
(ff:bind-c-typedef _GdkDrawable
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkDrawable _GdkDrawable)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:104 <1811> 
;; typedef struct _GdkDrawable GdkBitmap;
(ff:bind-c-type GdkBitmap _GdkDrawable)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:105 <1812> 
;; typedef struct _GdkDrawable GdkPixmap;
(ff:bind-c-type GdkPixmap _GdkDrawable)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:106 <1813> 
;; typedef struct _GdkDrawable GdkWindow;
(ff:bind-c-type GdkWindow _GdkDrawable)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:108 <1814> 
;; typedef enum { GDK_LSB_FIRST, GDK_MSB_FIRST } GdkByteOrder;
(ff:bind-c-constant GDK_LSB_FIRST 0) ;;  GDK_LSB_FIRST 
(ff:bind-c-constant GDK_MSB_FIRST 1) ;;  GDK_MSB_FIRST 
(ff:bind-c-type GdkByteOrder :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:116 <1815> 
;; typedef enum {
;;         GDK_SHIFT_MASK =  0x000000001 LSHIFT  0x000000000, GDK_LOCK_MASK
;;   =  0x000000001
;;    LSHIFT  0x000000001, GDK_CONTROL_MASK =  0x000000001 LSHIFT
;;   0x000000002,
;;              GDK_MOD1_MASK =  0x000000001 LSHIFT  0x000000003,
;;   GDK_MOD2_MASK =  0x000000001
;;    LSHIFT  0x000000004, GDK_MOD3_MASK =  0x000000001 LSHIFT
;;   0x000000005,
;;              GDK_MOD4_MASK =  0x000000001 LSHIFT  0x000000006,
;;   GDK_MOD5_MASK =  0x000000001
;;    LSHIFT  0x000000007, GDK_BUTTON1_MASK =  0x000000001 LSHIFT
;;   0x000000008,
;;              GDK_BUTTON2_MASK =  0x000000001 LSHIFT  0x000000009,
;;   GDK_BUTTON3_MASK
;;    =  0x000000001 LSHIFT  0x00000000a, GDK_BUTTON4_MASK =  0x000000001
;;   LSHIFT
;;     0x00000000b, GDK_BUTTON5_MASK =  0x000000001 LSHIFT  0x00000000c,
;;   GDK_RELEASE_MASK
;;    =  0x000000001 LSHIFT  0x00000001e, GDK_MODIFIER_MASK =
;;   GDK_RELEASE_MASK
;;    |  0x000001fff } GdkModifierType;
(ff:bind-c-constant GDK_SHIFT_MASK
                    1) ;;
;;   GDK_SHIFT_MASK =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_LOCK_MASK
                    2) ;;
;;   GDK_LOCK_MASK =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_CONTROL_MASK
                    4) ;;
;;   GDK_CONTROL_MASK =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_MOD1_MASK
                    8) ;;
;;   GDK_MOD1_MASK =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_MOD2_MASK
                    16) ;;
;;   GDK_MOD2_MASK =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_MOD3_MASK
                    32) ;;
;;   GDK_MOD3_MASK =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_MOD4_MASK
                    64) ;;
;;   GDK_MOD4_MASK =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GDK_MOD5_MASK
                    128) ;;
;;   GDK_MOD5_MASK =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GDK_BUTTON1_MASK
                    256) ;;
;;   GDK_BUTTON1_MASK =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant GDK_BUTTON2_MASK
                    512) ;;
;;   GDK_BUTTON2_MASK =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant GDK_BUTTON3_MASK
                    1024) ;;
;;   GDK_BUTTON3_MASK =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-constant GDK_BUTTON4_MASK
                    2048) ;;
;;   GDK_BUTTON4_MASK =  0x000000001 LSHIFT  0x00000000b 
(ff:bind-c-constant GDK_BUTTON5_MASK
                    4096) ;;
;;   GDK_BUTTON5_MASK =  0x000000001 LSHIFT  0x00000000c 
(ff:bind-c-constant GDK_RELEASE_MASK
                    1073741824) ;;
;;   GDK_RELEASE_MASK =  0x000000001 LSHIFT  0x00000001e 

(ff:bind-c-constant GDK_MODIFIER_MASK
		    (logior GDK_RELEASE_MASK #x000001fff))
;;   GDK_MODIFIER_MASK = GDK_RELEASE_MASK |  0x000001fff 
(ff:bind-c-type GdkModifierType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:137 <1816> 
;; typedef enum {
;;         GDK_INPUT_READ =  0x000000001 LSHIFT  0x000000000,
;;   GDK_INPUT_WRITE =  0x000000001
;;    LSHIFT  0x000000001, GDK_INPUT_EXCEPTION =  0x000000001 LSHIFT
;;   0x000000002
;;    } GdkInputCondition;
(ff:bind-c-constant GDK_INPUT_READ
                    1) ;;
;;   GDK_INPUT_READ =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_INPUT_WRITE
                    2) ;;
;;   GDK_INPUT_WRITE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_INPUT_EXCEPTION
                    4) ;;
;;   GDK_INPUT_EXCEPTION =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-type GdkInputCondition :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:144 <1817> 
;; typedef enum {
;;         GDK_OK =  0x000000000, GDK_ERROR = -  0x000000001,
;;   GDK_ERROR_PARAM = -
;;     0x000000002, GDK_ERROR_FILE = -  0x000000003, GDK_ERROR_MEM = -
;;   0x000000004
;;    } GdkStatus;
(ff:bind-c-constant GDK_OK 0) ;;  GDK_OK =  0x000000000 
(ff:bind-c-constant GDK_ERROR -1) ;;  GDK_ERROR = -  0x000000001 
(ff:bind-c-constant GDK_ERROR_PARAM
                    -2) ;;
;;   GDK_ERROR_PARAM = -  0x000000002 
(ff:bind-c-constant GDK_ERROR_FILE
                    -3) ;;
;;   GDK_ERROR_FILE = -  0x000000003 
(ff:bind-c-constant GDK_ERROR_MEM
                    -4) ;;
;;   GDK_ERROR_MEM = -  0x000000004 
(ff:bind-c-type GdkStatus :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:157 <1818> 
;; typedef enum {
;;         GDK_GRAB_SUCCESS =  0x000000000, GDK_GRAB_ALREADY_GRABBED =
;;   0x000000001,
;;              GDK_GRAB_INVALID_TIME =  0x000000002, GDK_GRAB_NOT_VIEWABLE
;;   =  0x000000003,
;;              GDK_GRAB_FROZEN =  0x000000004 } GdkGrabStatus;
(ff:bind-c-constant GDK_GRAB_SUCCESS
                    0) ;;
;;   GDK_GRAB_SUCCESS =  0x000000000 
(ff:bind-c-constant GDK_GRAB_ALREADY_GRABBED
                    1) ;;
;;   GDK_GRAB_ALREADY_GRABBED =  0x000000001 
(ff:bind-c-constant GDK_GRAB_INVALID_TIME
                    2) ;;
;;   GDK_GRAB_INVALID_TIME =  0x000000002 
(ff:bind-c-constant GDK_GRAB_NOT_VIEWABLE
                    3) ;;
;;   GDK_GRAB_NOT_VIEWABLE =  0x000000003 
(ff:bind-c-constant GDK_GRAB_FROZEN
                    4) ;;
;;   GDK_GRAB_FROZEN =  0x000000004 
(ff:bind-c-type GdkGrabStatus :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:166 <1819> 
;; typedef void(* GdkInputFunction)( gpointer data, gint source,
;;   GdkInputCondition
;;    condition);
(ff:bind-c-type GdkInputFunction (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:170 <1820> 
;; typedef void(* GdkDestroyNotify)( gpointer data);
(ff:bind-c-type GdkDestroyNotify (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:172 <1821> 
;; struct _GdkPoint { gint x; gint y; };
(ff:bind-c-type _GdkPoint (:struct
  (x gint)   ;; gint x
  (y gint)   ;; gint y
  ))   ;; bind-c-type _GdkPoint
(ff:bind-c-typedef GdkPoint _GdkPoint) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:178 <1822> 
;; struct _GdkRectangle { gint x; gint y; gint width; gint height; };
(ff:bind-c-type _GdkRectangle (:struct
  (x gint)   ;; gint x
  (y gint)   ;; gint y
  (width gint)   ;; gint width
  (height gint)   ;; gint height
  ))   ;; bind-c-type _GdkRectangle
(ff:bind-c-typedef GdkRectangle _GdkRectangle) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:186 <1823> 
;; struct _GdkSegment { gint x1; gint y1; gint x2; gint y2; };
(ff:bind-c-type _GdkSegment (:struct
  (x1 gint)   ;; gint x1
  (y1 gint)   ;; gint y1
  (x2 gint)   ;; gint x2
  (y2 gint)   ;; gint y2
  ))   ;; bind-c-type _GdkSegment
(ff:bind-c-typedef GdkSegment _GdkSegment) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdktypes.h:194 <1824> 
;; struct _GdkSpan { gint x; gint y; gint width; };
(ff:bind-c-type _GdkSpan (:struct
  (x gint)   ;; gint x
  (y gint)   ;; gint y
  (width gint)   ;; gint width
  ))   ;; bind-c-type _GdkSpan
(ff:bind-c-typedef GdkSpan _GdkSpan) ;;  final declaration 

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:17 <1825> 
;; struct _GdkColor {
;;         guint32 pixel; guint16 red; guint16 green; guint16 blue; };
(ff:bind-c-type _GdkColor (:struct
  (pixel guint32)   ;; guint32 pixel
  (red guint16)   ;; guint16 red
  (green guint16)   ;; guint16 green
  (blue guint16)   ;; guint16 blue
  ))   ;; bind-c-type _GdkColor
(ff:bind-c-typedef GdkColor _GdkColor) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:28 <1826> 
;; typedef struct _GdkColormapClass GdkColormapClass;
(ff:bind-c-typedef _GdkColormapClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkColormapClass _GdkColormapClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:39 <1827> 
;; struct _GdkColormap {
;;         GObject parent_instance; gint size; GdkColor* colors; GdkVisual*
;;   visual;
;;              gpointer windowing_data; };
(ff:bind-c-type _GdkColormap (:struct
  (parent_instance GObject)   ;; GObject parent_instance
  (size gint)   ;; gint size
  (colors (* GdkColor))   ;; GdkColor* colors
  (visual (* GdkVisual))   ;; GdkVisual* visual
  (windowing_data gpointer)   ;; gpointer windowing_data
  ))   ;; bind-c-type _GdkColormap
(ff:bind-c-typedef GdkColormap _GdkColormap) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:53 <1828> 
;; struct _GdkColormapClass { GObjectClass parent_class; };
(ff:bind-c-type _GdkColormapClass (:struct
  (parent_class GObjectClass)   ;; GObjectClass parent_class
  ))   ;; bind-c-type _GdkColormapClass
(ff:bind-c-typedef GdkColormapClass
                   _GdkColormapClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:59 <1829> 
;; GType gdk_colormap_get_type( void);
(ff:bind-c-function gdk_colormap_get_type
     :unconverted-entry-name "gdk_colormap_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:61 <1830> 
;; GdkColormap* gdk_colormap_new( GdkVisual* visual, gboolean allocate);
(ff:bind-c-function gdk_colormap_new
     :unconverted-entry-name "gdk_colormap_new"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GdkVisual" "*") ("gboolean"))
     :c-arg-names (visual allocate)
     :arguments ((* GdkVisual) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:65 <1831> 
;; GdkColormap* gdk_colormap_ref( GdkColormap* cmap);
(ff:bind-c-function gdk_colormap_ref
     :unconverted-entry-name "gdk_colormap_ref"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (cmap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:66 <1832> 
;; void gdk_colormap_unref( GdkColormap* cmap);
(ff:bind-c-function gdk_colormap_unref
     :unconverted-entry-name "gdk_colormap_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (cmap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:69 <1833> 
;; GdkColormap* gdk_colormap_get_system( void);
(ff:bind-c-function gdk_colormap_get_system
     :unconverted-entry-name "gdk_colormap_get_system"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:71 <1834> 
;; gint gdk_colormap_get_system_size( void);
(ff:bind-c-function gdk_colormap_get_system_size
     :unconverted-entry-name "gdk_colormap_get_system_size"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:72 <1835> 
;; void gdk_colormap_change( GdkColormap* colormap, gint ncolors);
(ff:bind-c-function gdk_colormap_change
     :unconverted-entry-name "gdk_colormap_change"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("gint"))
     :c-arg-names (colormap ncolors)
     :arguments ((* GdkColormap) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:76 <1836> 
;; gint gdk_colormap_alloc_colors( GdkColormap* colormap, GdkColor* colors,
;;              gint ncolors, gboolean writeable, gboolean best_match,
;;   gboolean* success
;;   );
(ff:bind-c-function gdk_colormap_alloc_colors
     :unconverted-entry-name "gdk_colormap_alloc_colors"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gint")
                   ("gboolean") ("gboolean") ("gboolean" "*"))
     :c-arg-names (colormap colors ncolors writeable best_match success)
     :arguments ((* GdkColormap) (* GdkColor) gint gboolean gboolean
                 (* gboolean))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:82 <1837> 
;; gboolean gdk_colormap_alloc_color( GdkColormap* colormap, GdkColor*
;;   color,
;;              gboolean writeable, gboolean best_match);
(ff:bind-c-function gdk_colormap_alloc_color
     :unconverted-entry-name "gdk_colormap_alloc_color"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gboolean")
                   ("gboolean"))
     :c-arg-names (colormap color writeable best_match)
     :arguments ((* GdkColormap) (* GdkColor) gboolean gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:86 <1838> 
;; void gdk_colormap_free_colors( GdkColormap* colormap, GdkColor* colors,
;;              gint ncolors);
(ff:bind-c-function gdk_colormap_free_colors
     :unconverted-entry-name "gdk_colormap_free_colors"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gint"))
     :c-arg-names (colormap colors ncolors)
     :arguments ((* GdkColormap) (* GdkColor) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:89 <1839> 
;; void gdk_colormap_query_color( GdkColormap* colormap, gulong pixel,
;;   GdkColor
;;   * result);
(ff:bind-c-function gdk_colormap_query_color
     :unconverted-entry-name "gdk_colormap_query_color"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("gulong") ("GdkColor" "*"))
     :c-arg-names (colormap pixel result)
     :arguments ((* GdkColormap) gulong (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:93 <1840> 
;; GdkVisual* gdk_colormap_get_visual( GdkColormap* colormap);
(ff:bind-c-function gdk_colormap_get_visual
     :unconverted-entry-name "gdk_colormap_get_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (colormap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:95 <1841> 
;; GdkColor* gdk_color_copy( const GdkColor* color);
(ff:bind-c-function gdk_color_copy
     :unconverted-entry-name "gdk_color_copy"
     :c-return-type ("GdkColor" "*")
     :return-type (* GdkColor)
     :c-arg-types (("const" "GdkColor" "*"))
     :c-arg-names (color)
     :arguments ((* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:96 <1842> 
;; void gdk_color_free( GdkColor* color);
(ff:bind-c-function gdk_color_free
     :unconverted-entry-name "gdk_color_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColor" "*"))
     :c-arg-names (color)
     :arguments ((* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:97 <1843> 
;; gint gdk_color_parse( const gchar* spec, GdkColor* color);
(ff:bind-c-function gdk_color_parse
     :unconverted-entry-name "gdk_color_parse"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("GdkColor" "*"))
     :c-arg-names (spec color)
     :arguments ((* gchar) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:99 <1844> 
;; guint gdk_color_hash( const GdkColor* colora);
(ff:bind-c-function gdk_color_hash
     :unconverted-entry-name "gdk_color_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GdkColor" "*"))
     :c-arg-names (colora)
     :arguments ((* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:100 <1845> 
;; gboolean gdk_color_equal( const GdkColor* colora, const GdkColor* colorb
;;   );
(ff:bind-c-function gdk_color_equal
     :unconverted-entry-name "gdk_color_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GdkColor" "*") ("const" "GdkColor" "*"))
     :c-arg-names (colora colorb)
     :arguments ((* GdkColor) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:103 <1846> 
;; GType gdk_color_get_type( void);
(ff:bind-c-function gdk_color_get_type
     :unconverted-entry-name "gdk_color_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:107 <1847> 
;; void gdk_colors_store( GdkColormap* colormap, GdkColor* colors, gint
;;   ncolors
;;   );
(ff:bind-c-function gdk_colors_store
     :unconverted-entry-name "gdk_colors_store"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gint"))
     :c-arg-names (colormap colors ncolors)
     :arguments ((* GdkColormap) (* GdkColor) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:110 <1848> 
;; gint gdk_colors_alloc( GdkColormap* colormap, gboolean contiguous,
;;   gulong
;;   * planes, gint nplanes, gulong* pixels, gint npixels);
(ff:bind-c-function gdk_colors_alloc
     :unconverted-entry-name "gdk_colors_alloc"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColormap" "*") ("gboolean") ("gulong" "*")
                   ("gint") ("gulong" "*") ("gint"))
     :c-arg-names (colormap contiguous planes nplanes pixels npixels)
     :arguments ((* GdkColormap) gboolean (* gulong) gint (* gulong)
                 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:116 <1849> 
;; void gdk_colors_free( GdkColormap* colormap, gulong* pixels, gint
;;   npixels,
;;              gulong planes);
(ff:bind-c-function gdk_colors_free
     :unconverted-entry-name "gdk_colors_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("gulong" "*") ("gint")
                   ("gulong"))
     :c-arg-names (colormap pixels npixels planes)
     :arguments ((* GdkColormap) (* gulong) gint gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:120 <1850> 
;; gint gdk_color_white( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_white
     :unconverted-entry-name "gdk_color_white"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:122 <1851> 
;; gint gdk_color_black( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_black
     :unconverted-entry-name "gdk_color_black"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:124 <1852> 
;; gint gdk_color_alloc( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_alloc
     :unconverted-entry-name "gdk_color_alloc"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcolor.h:126 <1853> 
;; gint gdk_color_change( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_change
     :unconverted-entry-name "gdk_color_change"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcursor.h:14 <1854> 
;; typedef enum {
;;         GDK_X_CURSOR =  0x000000000, GDK_ARROW =  0x000000002,
;;   GDK_BASED_ARROW_DOWN
;;    =  0x000000004, GDK_BASED_ARROW_UP =  0x000000006, GDK_BOAT =
;;   0x000000008,
;;              GDK_BOGOSITY =  0x00000000a, GDK_BOTTOM_LEFT_CORNER =
;;   0x00000000c, GDK_BOTTOM_RIGHT_CORNER
;;    =  0x00000000e, GDK_BOTTOM_SIDE =  0x000000010, GDK_BOTTOM_TEE =
;;   0x000000012,
;;              GDK_BOX_SPIRAL =  0x000000014, GDK_CENTER_PTR =
;;   0x000000016, GDK_CIRCLE
;;    =  0x000000018, GDK_CLOCK =  0x00000001a, GDK_COFFEE_MUG =
;;   0x00000001c,
;;              GDK_CROSS =  0x00000001e, GDK_CROSS_REVERSE =  0x000000020,
;;   GDK_CROSSHAIR
;;    =  0x000000022, GDK_DIAMOND_CROSS =  0x000000024, GDK_DOT =
;;   0x000000026,
;;              GDK_DOTBOX =  0x000000028, GDK_DOUBLE_ARROW =  0x00000002a,
;;   GDK_DRAFT_LARGE
;;    =  0x00000002c, GDK_DRAFT_SMALL =  0x00000002e, GDK_DRAPED_BOX =
;;   0x000000030,
;;              GDK_EXCHANGE =  0x000000032, GDK_FLEUR =  0x000000034,
;;   GDK_GOBBLER =  0x000000036,
;;              GDK_GUMBY =  0x000000038, GDK_HAND1 =  0x00000003a,
;;   GDK_HAND2 =  0x00000003c,
;;              GDK_HEART =  0x00000003e, GDK_ICON =  0x000000040,
;;   GDK_IRON_CROSS =  0x000000042,
;;              GDK_LEFT_PTR =  0x000000044, GDK_LEFT_SIDE =  0x000000046,
;;   GDK_LEFT_TEE
;;    =  0x000000048, GDK_LEFTBUTTON =  0x00000004a, GDK_LL_ANGLE =
;;   0x00000004c,
;;              GDK_LR_ANGLE =  0x00000004e, GDK_MAN =  0x000000050,
;;   GDK_MIDDLEBUTTON
;;    =  0x000000052, GDK_MOUSE =  0x000000054, GDK_PENCIL =  0x000000056,
;;   GDK_PIRATE
;;    =  0x000000058, GDK_PLUS =  0x00000005a, GDK_QUESTION_ARROW =
;;   0x00000005c,
;;              GDK_RIGHT_PTR =  0x00000005e, GDK_RIGHT_SIDE =
;;   0x000000060, GDK_RIGHT_TEE
;;    =  0x000000062, GDK_RIGHTBUTTON =  0x000000064, GDK_RTL_LOGO =
;;   0x000000066,
;;              GDK_SAILBOAT =  0x000000068, GDK_SB_DOWN_ARROW =
;;   0x00000006a, GDK_SB_H_DOUBLE_ARROW
;;    =  0x00000006c, GDK_SB_LEFT_ARROW =  0x00000006e, GDK_SB_RIGHT_ARROW
;;   =
;;     0x000000070, GDK_SB_UP_ARROW =  0x000000072, GDK_SB_V_DOUBLE_ARROW =
;;     0x000000074, GDK_SHUTTLE =  0x000000076, GDK_SIZING =  0x000000078,
;;   GDK_SPIDER
;;    =  0x00000007a, GDK_SPRAYCAN =  0x00000007c, GDK_STAR =  0x00000007e,
;;              GDK_TARGET =  0x000000080, GDK_TCROSS =  0x000000082,
;;   GDK_TOP_LEFT_ARROW
;;    =  0x000000084, GDK_TOP_LEFT_CORNER =  0x000000086,
;;   GDK_TOP_RIGHT_CORNER
;;    =  0x000000088, GDK_TOP_SIDE =  0x00000008a, GDK_TOP_TEE =
;;   0x00000008c,
;;              GDK_TREK =  0x00000008e, GDK_UL_ANGLE =  0x000000090,
;;   GDK_UMBRELLA =  0x000000092,
;;              GDK_UR_ANGLE =  0x000000094, GDK_WATCH =  0x000000096,
;;   GDK_XTERM =  0x000000098,
;;              GDK_LAST_CURSOR, GDK_CURSOR_IS_PIXMAP = -  0x000000001 }
;;   GdkCursorType
;;   ;
(ff:bind-c-constant GDK_X_CURSOR 0) ;;  GDK_X_CURSOR =  0x000000000 
(ff:bind-c-constant GDK_ARROW 2) ;;  GDK_ARROW =  0x000000002 
(ff:bind-c-constant GDK_BASED_ARROW_DOWN
                    4) ;;
;;   GDK_BASED_ARROW_DOWN =  0x000000004 
(ff:bind-c-constant GDK_BASED_ARROW_UP
                    6) ;;
;;   GDK_BASED_ARROW_UP =  0x000000006 
(ff:bind-c-constant GDK_BOAT 8) ;;  GDK_BOAT =  0x000000008 
(ff:bind-c-constant GDK_BOGOSITY 10) ;;  GDK_BOGOSITY =  0x00000000a 
(ff:bind-c-constant GDK_BOTTOM_LEFT_CORNER
                    12) ;;
;;   GDK_BOTTOM_LEFT_CORNER =  0x00000000c 
(ff:bind-c-constant GDK_BOTTOM_RIGHT_CORNER
                    14) ;;
;;   GDK_BOTTOM_RIGHT_CORNER =  0x00000000e 
(ff:bind-c-constant GDK_BOTTOM_SIDE
                    16) ;;
;;   GDK_BOTTOM_SIDE =  0x000000010 
(ff:bind-c-constant GDK_BOTTOM_TEE
                    18) ;;
;;   GDK_BOTTOM_TEE =  0x000000012 
(ff:bind-c-constant GDK_BOX_SPIRAL
                    20) ;;
;;   GDK_BOX_SPIRAL =  0x000000014 
(ff:bind-c-constant GDK_CENTER_PTR
                    22) ;;
;;   GDK_CENTER_PTR =  0x000000016 
(ff:bind-c-constant GDK_CIRCLE 24) ;;  GDK_CIRCLE =  0x000000018 
(ff:bind-c-constant GDK_CLOCK 26) ;;  GDK_CLOCK =  0x00000001a 
(ff:bind-c-constant GDK_COFFEE_MUG
                    28) ;;
;;   GDK_COFFEE_MUG =  0x00000001c 
(ff:bind-c-constant GDK_CROSS 30) ;;  GDK_CROSS =  0x00000001e 
(ff:bind-c-constant GDK_CROSS_REVERSE
                    32) ;;
;;   GDK_CROSS_REVERSE =  0x000000020 
(ff:bind-c-constant GDK_CROSSHAIR 34) ;;  GDK_CROSSHAIR =  0x000000022 
(ff:bind-c-constant GDK_DIAMOND_CROSS
                    36) ;;
;;   GDK_DIAMOND_CROSS =  0x000000024 
(ff:bind-c-constant GDK_DOT 38) ;;  GDK_DOT =  0x000000026 
(ff:bind-c-constant GDK_DOTBOX 40) ;;  GDK_DOTBOX =  0x000000028 
(ff:bind-c-constant GDK_DOUBLE_ARROW
                    42) ;;
;;   GDK_DOUBLE_ARROW =  0x00000002a 
(ff:bind-c-constant GDK_DRAFT_LARGE
                    44) ;;
;;   GDK_DRAFT_LARGE =  0x00000002c 
(ff:bind-c-constant GDK_DRAFT_SMALL
                    46) ;;
;;   GDK_DRAFT_SMALL =  0x00000002e 
(ff:bind-c-constant GDK_DRAPED_BOX
                    48) ;;
;;   GDK_DRAPED_BOX =  0x000000030 
(ff:bind-c-constant GDK_EXCHANGE 50) ;;  GDK_EXCHANGE =  0x000000032 
(ff:bind-c-constant GDK_FLEUR 52) ;;  GDK_FLEUR =  0x000000034 
(ff:bind-c-constant GDK_GOBBLER 54) ;;  GDK_GOBBLER =  0x000000036 
(ff:bind-c-constant GDK_GUMBY 56) ;;  GDK_GUMBY =  0x000000038 
(ff:bind-c-constant GDK_HAND1 58) ;;  GDK_HAND1 =  0x00000003a 
(ff:bind-c-constant GDK_HAND2 60) ;;  GDK_HAND2 =  0x00000003c 
(ff:bind-c-constant GDK_HEART 62) ;;  GDK_HEART =  0x00000003e 
(ff:bind-c-constant GDK_ICON 64) ;;  GDK_ICON =  0x000000040 
(ff:bind-c-constant GDK_IRON_CROSS
                    66) ;;
;;   GDK_IRON_CROSS =  0x000000042 
(ff:bind-c-constant GDK_LEFT_PTR 68) ;;  GDK_LEFT_PTR =  0x000000044 
(ff:bind-c-constant GDK_LEFT_SIDE 70) ;;  GDK_LEFT_SIDE =  0x000000046 
(ff:bind-c-constant GDK_LEFT_TEE 72) ;;  GDK_LEFT_TEE =  0x000000048 
(ff:bind-c-constant GDK_LEFTBUTTON
                    74) ;;
;;   GDK_LEFTBUTTON =  0x00000004a 
(ff:bind-c-constant GDK_LL_ANGLE 76) ;;  GDK_LL_ANGLE =  0x00000004c 
(ff:bind-c-constant GDK_LR_ANGLE 78) ;;  GDK_LR_ANGLE =  0x00000004e 
(ff:bind-c-constant GDK_MAN 80) ;;  GDK_MAN =  0x000000050 
(ff:bind-c-constant GDK_MIDDLEBUTTON
                    82) ;;
;;   GDK_MIDDLEBUTTON =  0x000000052 
(ff:bind-c-constant GDK_MOUSE 84) ;;  GDK_MOUSE =  0x000000054 
(ff:bind-c-constant GDK_PENCIL 86) ;;  GDK_PENCIL =  0x000000056 
(ff:bind-c-constant GDK_PIRATE 88) ;;  GDK_PIRATE =  0x000000058 
(ff:bind-c-constant GDK_PLUS 90) ;;  GDK_PLUS =  0x00000005a 
(ff:bind-c-constant GDK_QUESTION_ARROW
                    92) ;;
;;   GDK_QUESTION_ARROW =  0x00000005c 
(ff:bind-c-constant GDK_RIGHT_PTR 94) ;;  GDK_RIGHT_PTR =  0x00000005e 
(ff:bind-c-constant GDK_RIGHT_SIDE
                    96) ;;
;;   GDK_RIGHT_SIDE =  0x000000060 
(ff:bind-c-constant GDK_RIGHT_TEE 98) ;;  GDK_RIGHT_TEE =  0x000000062 
(ff:bind-c-constant GDK_RIGHTBUTTON
                    100) ;;
;;   GDK_RIGHTBUTTON =  0x000000064 
(ff:bind-c-constant GDK_RTL_LOGO 102) ;;  GDK_RTL_LOGO =  0x000000066 
(ff:bind-c-constant GDK_SAILBOAT 104) ;;  GDK_SAILBOAT =  0x000000068 
(ff:bind-c-constant GDK_SB_DOWN_ARROW
                    106) ;;
;;   GDK_SB_DOWN_ARROW =  0x00000006a 
(ff:bind-c-constant GDK_SB_H_DOUBLE_ARROW
                    108) ;;
;;   GDK_SB_H_DOUBLE_ARROW =  0x00000006c 
(ff:bind-c-constant GDK_SB_LEFT_ARROW
                    110) ;;
;;   GDK_SB_LEFT_ARROW =  0x00000006e 
(ff:bind-c-constant GDK_SB_RIGHT_ARROW
                    112) ;;
;;   GDK_SB_RIGHT_ARROW =  0x000000070 
(ff:bind-c-constant GDK_SB_UP_ARROW
                    114) ;;
;;   GDK_SB_UP_ARROW =  0x000000072 
(ff:bind-c-constant GDK_SB_V_DOUBLE_ARROW
                    116) ;;
;;   GDK_SB_V_DOUBLE_ARROW =  0x000000074 
(ff:bind-c-constant GDK_SHUTTLE 118) ;;  GDK_SHUTTLE =  0x000000076 
(ff:bind-c-constant GDK_SIZING 120) ;;  GDK_SIZING =  0x000000078 
(ff:bind-c-constant GDK_SPIDER 122) ;;  GDK_SPIDER =  0x00000007a 
(ff:bind-c-constant GDK_SPRAYCAN 124) ;;  GDK_SPRAYCAN =  0x00000007c 
(ff:bind-c-constant GDK_STAR 126) ;;  GDK_STAR =  0x00000007e 
(ff:bind-c-constant GDK_TARGET 128) ;;  GDK_TARGET =  0x000000080 
(ff:bind-c-constant GDK_TCROSS 130) ;;  GDK_TCROSS =  0x000000082 
(ff:bind-c-constant GDK_TOP_LEFT_ARROW
                    132) ;;
;;   GDK_TOP_LEFT_ARROW =  0x000000084 
(ff:bind-c-constant GDK_TOP_LEFT_CORNER
                    134) ;;
;;   GDK_TOP_LEFT_CORNER =  0x000000086 
(ff:bind-c-constant GDK_TOP_RIGHT_CORNER
                    136) ;;
;;   GDK_TOP_RIGHT_CORNER =  0x000000088 
(ff:bind-c-constant GDK_TOP_SIDE 138) ;;  GDK_TOP_SIDE =  0x00000008a 
(ff:bind-c-constant GDK_TOP_TEE 140) ;;  GDK_TOP_TEE =  0x00000008c 
(ff:bind-c-constant GDK_TREK 142) ;;  GDK_TREK =  0x00000008e 
(ff:bind-c-constant GDK_UL_ANGLE 144) ;;  GDK_UL_ANGLE =  0x000000090 
(ff:bind-c-constant GDK_UMBRELLA 146) ;;  GDK_UMBRELLA =  0x000000092 
(ff:bind-c-constant GDK_UR_ANGLE 148) ;;  GDK_UR_ANGLE =  0x000000094 
(ff:bind-c-constant GDK_WATCH 150) ;;  GDK_WATCH =  0x000000096 
(ff:bind-c-constant GDK_XTERM 152) ;;  GDK_XTERM =  0x000000098 
(ff:bind-c-constant GDK_LAST_CURSOR 0) ;;  GDK_LAST_CURSOR 
(ff:bind-c-constant GDK_CURSOR_IS_PIXMAP
                    -1) ;;
;;   GDK_CURSOR_IS_PIXMAP = -  0x000000001 
(ff:bind-c-type GdkCursorType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcursor.h:97 <1855> 
;; struct _GdkCursor { GdkCursorType type; guint ref_count; };
(ff:bind-c-type _GdkCursor (:struct
  (type GdkCursorType)   ;; GdkCursorType type
  (ref_count guint)   ;; guint ref_count
  ))   ;; bind-c-type _GdkCursor
(ff:bind-c-typedef GdkCursor _GdkCursor) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcursor.h:106 <1856> 
;; GType gdk_cursor_get_type( void);
(ff:bind-c-function gdk_cursor_get_type
     :unconverted-entry-name "gdk_cursor_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcursor.h:108 <1857> 
;; GdkCursor* gdk_cursor_new( GdkCursorType cursor_type);
(ff:bind-c-function gdk_cursor_new
     :unconverted-entry-name "gdk_cursor_new"
     :c-return-type ("GdkCursor" "*")
     :return-type (* GdkCursor)
     :c-arg-types (("GdkCursorType"))
     :c-arg-names (cursor_type)
     :arguments (GdkCursorType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcursor.h:109 <1858> 
;; GdkCursor* gdk_cursor_new_from_pixmap( GdkPixmap* source, GdkPixmap*
;;   mask,
;;              GdkColor* fg, GdkColor* bg, gint x, gint y);
(ff:bind-c-function gdk_cursor_new_from_pixmap
     :unconverted-entry-name "gdk_cursor_new_from_pixmap"
     :c-return-type ("GdkCursor" "*")
     :return-type (* GdkCursor)
     :c-arg-types (("GdkPixmap" "*") ("GdkPixmap" "*") ("GdkColor" "*")
                   ("GdkColor" "*") ("gint") ("gint"))
     :c-arg-names (source mask fg bg x y)
     :arguments ((* GdkPixmap) (* GdkPixmap) (* GdkColor) (* GdkColor)
                 gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcursor.h:115 <1859> 
;; GdkCursor* gdk_cursor_ref( GdkCursor* cursor);
(ff:bind-c-function gdk_cursor_ref
     :unconverted-entry-name "gdk_cursor_ref"
     :c-return-type ("GdkCursor" "*")
     :return-type (* GdkCursor)
     :c-arg-types (("GdkCursor" "*"))
     :c-arg-names (cursor)
     :arguments ((* GdkCursor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkcursor.h:116 <1860> 
;; void gdk_cursor_unref( GdkCursor* cursor);
(ff:bind-c-function gdk_cursor_unref
     :all-names ((gdk_cursor_unref . "gdk_cursor_unref")
                 (gdk_cursor_destroy . "gdk_cursor_destroy"))
     :unconverted-entry-name "gdk_cursor_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkCursor" "*"))
     :c-arg-names (cursor)
     :arguments ((* GdkCursor))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:10 <1861> 
;; typedef struct _GdkDragContext GdkDragContext;
(ff:bind-c-typedef _GdkDragContext
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkDragContext _GdkDragContext)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:12 <1862> 
;; typedef enum {
;;         GDK_ACTION_DEFAULT =  0x000000001 LSHIFT  0x000000000,
;;   GDK_ACTION_COPY
;;    =  0x000000001 LSHIFT  0x000000001, GDK_ACTION_MOVE =  0x000000001
;;   LSHIFT
;;     0x000000002, GDK_ACTION_LINK =  0x000000001 LSHIFT  0x000000003,
;;   GDK_ACTION_PRIVATE
;;    =  0x000000001 LSHIFT  0x000000004, GDK_ACTION_ASK =  0x000000001
;;   LSHIFT
;;     0x000000005 } GdkDragAction;
(ff:bind-c-constant GDK_ACTION_DEFAULT
                    1) ;;
;;   GDK_ACTION_DEFAULT =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_ACTION_COPY
                    2) ;;
;;   GDK_ACTION_COPY =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_ACTION_MOVE
                    4) ;;
;;   GDK_ACTION_MOVE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_ACTION_LINK
                    8) ;;
;;   GDK_ACTION_LINK =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_ACTION_PRIVATE
                    16) ;;
;;   GDK_ACTION_PRIVATE =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_ACTION_ASK
                    32) ;;
;;   GDK_ACTION_ASK =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-type GdkDragAction :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:22 <1863> 
;; typedef enum {
;;         GDK_DRAG_PROTO_MOTIF, GDK_DRAG_PROTO_XDND,
;;   GDK_DRAG_PROTO_ROOTWIN, GDK_DRAG_PROTO_NONE,
;;              GDK_DRAG_PROTO_WIN32_DROPFILES, GDK_DRAG_PROTO_OLE2,
;;   GDK_DRAG_PROTO_LOCAL
;;    } GdkDragProtocol;
(ff:bind-c-constant GDK_DRAG_PROTO_MOTIF 0) ;;  GDK_DRAG_PROTO_MOTIF 
(ff:bind-c-constant GDK_DRAG_PROTO_XDND 1) ;;  GDK_DRAG_PROTO_XDND 
(ff:bind-c-constant GDK_DRAG_PROTO_ROOTWIN
                    2) ;;
;;   GDK_DRAG_PROTO_ROOTWIN 
(ff:bind-c-constant GDK_DRAG_PROTO_NONE 3) ;;  GDK_DRAG_PROTO_NONE 
(ff:bind-c-constant GDK_DRAG_PROTO_WIN32_DROPFILES
                    4) ;;
;;   GDK_DRAG_PROTO_WIN32_DROPFILES 
(ff:bind-c-constant GDK_DRAG_PROTO_OLE2 5) ;;  GDK_DRAG_PROTO_OLE2 
(ff:bind-c-constant GDK_DRAG_PROTO_LOCAL 6) ;;  GDK_DRAG_PROTO_LOCAL 
(ff:bind-c-type GdkDragProtocol :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:38 <1864> 
;; typedef struct _GdkDragContextClass GdkDragContextClass;
(ff:bind-c-typedef _GdkDragContextClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkDragContextClass _GdkDragContextClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:47 <1865> 
;; struct _GdkDragContext {
;;         GObject parent_instance; GdkDragProtocol protocol; gboolean
;;   is_source;
;;              GdkWindow* source_window; GdkWindow* dest_window; GList*
;;   targets; GdkDragAction
;;    actions; GdkDragAction suggested_action; GdkDragAction action;
;;   guint32
;;    start_time; gpointer windowing_data; };
(ff:bind-c-type _GdkDragContext (:struct
  (parent_instance GObject)   ;; GObject parent_instance
  (protocol GdkDragProtocol)   ;; GdkDragProtocol protocol
  (is_source gboolean)   ;; gboolean is_source
  (source_window (* GdkWindow))   ;; GdkWindow* source_window
  (dest_window (* GdkWindow))   ;; GdkWindow* dest_window
  (targets (* GList))   ;; GList* targets
  (actions GdkDragAction)   ;; GdkDragAction actions
  (suggested_action GdkDragAction)   ;; GdkDragAction suggested_action
  (action GdkDragAction)   ;; GdkDragAction action
  (start_time guint32)   ;; guint32 start_time
  (windowing_data gpointer)   ;; gpointer windowing_data
  ))   ;; bind-c-type _GdkDragContext
(ff:bind-c-typedef GdkDragContext
                   _GdkDragContext) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:71 <1866> 
;; struct _GdkDragContextClass { GObjectClass parent_class; };
(ff:bind-c-type _GdkDragContextClass (:struct
  (parent_class GObjectClass)   ;; GObjectClass parent_class
  ))   ;; bind-c-type _GdkDragContextClass
(ff:bind-c-typedef GdkDragContextClass
                   _GdkDragContextClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:79 <1867> 
;; GType gdk_drag_context_get_type( void);
(ff:bind-c-function gdk_drag_context_get_type
     :unconverted-entry-name "gdk_drag_context_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:80 <1868> 
;; GdkDragContext* gdk_drag_context_new( void);
(ff:bind-c-function gdk_drag_context_new
     :unconverted-entry-name "gdk_drag_context_new"
     :c-return-type ("GdkDragContext" "*")
     :return-type (* GdkDragContext)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:83 <1869> 
;; void gdk_drag_context_ref( GdkDragContext* context);
(ff:bind-c-function gdk_drag_context_ref
     :unconverted-entry-name "gdk_drag_context_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*"))
     :c-arg-names (context)
     :arguments ((* GdkDragContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:84 <1870> 
;; void gdk_drag_context_unref( GdkDragContext* context);
(ff:bind-c-function gdk_drag_context_unref
     :unconverted-entry-name "gdk_drag_context_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*"))
     :c-arg-names (context)
     :arguments ((* GdkDragContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:89 <1871> 
;; void gdk_drag_status( GdkDragContext* context, GdkDragAction action,
;;   guint32
;;    time);
(ff:bind-c-function gdk_drag_status_f	; bug15263
     :unconverted-entry-name "gdk_drag_status"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("GdkDragAction") ("guint32"))
     :c-arg-names (context action time)
     :arguments ((* GdkDragContext) GdkDragAction guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:92 <1872> 
;; void gdk_drop_reply( GdkDragContext* context, gboolean ok, guint32
;;   time);
(ff:bind-c-function gdk_drop_reply
     :unconverted-entry-name "gdk_drop_reply"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("gboolean") ("guint32"))
     :c-arg-names (context ok time)
     :arguments ((* GdkDragContext) gboolean guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:95 <1873> 
;; void gdk_drop_finish( GdkDragContext* context, gboolean success, guint32
;;    time);
(ff:bind-c-function gdk_drop_finish
     :unconverted-entry-name "gdk_drop_finish"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("gboolean") ("guint32"))
     :c-arg-names (context success time)
     :arguments ((* GdkDragContext) gboolean guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:98 <1874> 
;; GdkAtom gdk_drag_get_selection( GdkDragContext* context);
(ff:bind-c-function gdk_drag_get_selection
     :unconverted-entry-name "gdk_drag_get_selection"
     :c-return-type ("GdkAtom")
     :return-type GdkAtom
     :c-arg-types (("GdkDragContext" "*"))
     :c-arg-names (context)
     :arguments ((* GdkDragContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:102 <1875> 
;; GdkDragContext* gdk_drag_begin( GdkWindow* window, GList* targets);
(ff:bind-c-function gdk_drag_begin
     :unconverted-entry-name "gdk_drag_begin"
     :c-return-type ("GdkDragContext" "*")
     :return-type (* GdkDragContext)
     :c-arg-types (("GdkWindow" "*") ("GList" "*"))
     :c-arg-names (window targets)
     :arguments ((* GdkWindow) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:104 <1876> 
;; guint32 gdk_drag_get_protocol( guint32 xid, GdkDragProtocol* protocol);
(ff:bind-c-function gdk_drag_get_protocol
     :unconverted-entry-name "gdk_drag_get_protocol"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types (("guint32") ("GdkDragProtocol" "*"))
     :c-arg-names (xid protocol)
     :arguments (guint32 (* GdkDragProtocol))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:106 <1877> 
;; void gdk_drag_find_window( GdkDragContext* context, GdkWindow*
;;   drag_window,
;;              gint x_root, gint y_root, GdkWindow** dest_window,
;;   GdkDragProtocol* protocol
;;   );
(ff:bind-c-function gdk_drag_find_window
     :unconverted-entry-name "gdk_drag_find_window"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("GdkWindow" "*") ("gint")
                   ("gint") ("GdkWindow" "*" "*")
                   ("GdkDragProtocol" "*"))
     :c-arg-names (context drag_window x_root y_root dest_window
                   protocol)
     :arguments ((* GdkDragContext) (* GdkWindow) gint gint
                 (* (* GdkWindow)) (* GdkDragProtocol))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:112 <1878> 
;; gboolean gdk_drag_motion( GdkDragContext* context, GdkWindow*
;;   dest_window,
;;              GdkDragProtocol protocol, gint x_root, gint y_root,
;;   GdkDragAction suggested_action,
;;              GdkDragAction possible_actions, guint32 time);
(ff:bind-c-function gdk_drag_motion_f	; bug15263
     :unconverted-entry-name "gdk_drag_motion"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkDragContext" "*") ("GdkWindow" "*")
                   ("GdkDragProtocol") ("gint") ("gint")
                   ("GdkDragAction") ("GdkDragAction") ("guint32"))
     :c-arg-names (context dest_window protocol x_root y_root
                   suggested_action possible_actions time)
     :arguments ((* GdkDragContext) (* GdkWindow) GdkDragProtocol gint
                 gint GdkDragAction GdkDragAction guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:120 <1879> 
;; void gdk_drag_drop( GdkDragContext* context, guint32 time);
(ff:bind-c-function gdk_drag_drop
     :unconverted-entry-name "gdk_drag_drop"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("guint32"))
     :c-arg-names (context time)
     :arguments ((* GdkDragContext) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdnd.h:122 <1880> 
;; void gdk_drag_abort( GdkDragContext* context, guint32 time);
(ff:bind-c-function gdk_drag_abort
     :unconverted-entry-name "gdk_drag_abort"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("guint32"))
     :c-arg-names (context time)
     :arguments ((* GdkDragContext) guint32)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:11 <1881> 
;; typedef struct _GdkGCValues GdkGCValues;
(ff:bind-c-typedef _GdkGCValues
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkGCValues _GdkGCValues)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:12 <1882> 
;; typedef struct _GdkGCClass GdkGCClass;
(ff:bind-c-typedef _GdkGCClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkGCClass _GdkGCClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:20 <1883> 
;; typedef enum {
;;         GDK_CAP_NOT_LAST, GDK_CAP_BUTT, GDK_CAP_ROUND,
;;   GDK_CAP_PROJECTING } GdkCapStyle
;;   ;
(ff:bind-c-constant GDK_CAP_NOT_LAST 0) ;;  GDK_CAP_NOT_LAST 
(ff:bind-c-constant GDK_CAP_BUTT 1) ;;  GDK_CAP_BUTT 
(ff:bind-c-constant GDK_CAP_ROUND 2) ;;  GDK_CAP_ROUND 
(ff:bind-c-constant GDK_CAP_PROJECTING 3) ;;  GDK_CAP_PROJECTING 
(ff:bind-c-type GdkCapStyle :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:34 <1884> 
;; typedef enum {
;;         GDK_SOLID, GDK_TILED, GDK_STIPPLED, GDK_OPAQUE_STIPPLED }
;;   GdkFill;
(ff:bind-c-constant GDK_SOLID 0) ;;  GDK_SOLID 
(ff:bind-c-constant GDK_TILED 1) ;;  GDK_TILED 
(ff:bind-c-constant GDK_STIPPLED 2) ;;  GDK_STIPPLED 
(ff:bind-c-constant GDK_OPAQUE_STIPPLED 3) ;;  GDK_OPAQUE_STIPPLED 
(ff:bind-c-type GdkFill :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:60 <1885> 
;; typedef enum {
;;         GDK_COPY, GDK_INVERT, GDK_XOR, GDK_CLEAR, GDK_AND,
;;   GDK_AND_REVERSE, GDK_AND_INVERT,
;;              GDK_NOOP, GDK_OR, GDK_EQUIV, GDK_OR_REVERSE,
;;   GDK_COPY_INVERT, GDK_OR_INVERT,
;;              GDK_NAND, GDK_NOR, GDK_SET } GdkFunction;
(ff:bind-c-constant GDK_COPY 0) ;;  GDK_COPY 
(ff:bind-c-constant GDK_INVERT 1) ;;  GDK_INVERT 
(ff:bind-c-constant GDK_XOR 2) ;;  GDK_XOR 
(ff:bind-c-constant GDK_CLEAR 3) ;;  GDK_CLEAR 
(ff:bind-c-constant GDK_AND 4) ;;  GDK_AND 
(ff:bind-c-constant GDK_AND_REVERSE 5) ;;  GDK_AND_REVERSE 
(ff:bind-c-constant GDK_AND_INVERT 6) ;;  GDK_AND_INVERT 
(ff:bind-c-constant GDK_NOOP 7) ;;  GDK_NOOP 
(ff:bind-c-constant GDK_OR 8) ;;  GDK_OR 
(ff:bind-c-constant GDK_EQUIV 9) ;;  GDK_EQUIV 
(ff:bind-c-constant GDK_OR_REVERSE 10) ;;  GDK_OR_REVERSE 
(ff:bind-c-constant GDK_COPY_INVERT 11) ;;  GDK_COPY_INVERT 
(ff:bind-c-constant GDK_OR_INVERT 12) ;;  GDK_OR_INVERT 
(ff:bind-c-constant GDK_NAND 13) ;;  GDK_NAND 
(ff:bind-c-constant GDK_NOR 14) ;;  GDK_NOR 
(ff:bind-c-constant GDK_SET 15) ;;  GDK_SET 
(ff:bind-c-type GdkFunction :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:85 <1886> 
;; typedef enum {
;;         GDK_JOIN_MITER, GDK_JOIN_ROUND, GDK_JOIN_BEVEL } GdkJoinStyle;
(ff:bind-c-constant GDK_JOIN_MITER 0) ;;  GDK_JOIN_MITER 
(ff:bind-c-constant GDK_JOIN_ROUND 1) ;;  GDK_JOIN_ROUND 
(ff:bind-c-constant GDK_JOIN_BEVEL 2) ;;  GDK_JOIN_BEVEL 
(ff:bind-c-type GdkJoinStyle :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:97 <1887> 
;; typedef enum {
;;         GDK_LINE_SOLID, GDK_LINE_ON_OFF_DASH, GDK_LINE_DOUBLE_DASH }
;;   GdkLineStyle
;;   ;
(ff:bind-c-constant GDK_LINE_SOLID 0) ;;  GDK_LINE_SOLID 
(ff:bind-c-constant GDK_LINE_ON_OFF_DASH 1) ;;  GDK_LINE_ON_OFF_DASH 
(ff:bind-c-constant GDK_LINE_DOUBLE_DASH 2) ;;  GDK_LINE_DOUBLE_DASH 
(ff:bind-c-type GdkLineStyle :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:104 <1888> 
;; typedef enum {
;;         GDK_CLIP_BY_CHILDREN =  0x000000000, GDK_INCLUDE_INFERIORS =
;;   0x000000001
;;    } GdkSubwindowMode;
(ff:bind-c-constant GDK_CLIP_BY_CHILDREN
                    0) ;;
;;   GDK_CLIP_BY_CHILDREN =  0x000000000 
(ff:bind-c-constant GDK_INCLUDE_INFERIORS
                    1) ;;
;;   GDK_INCLUDE_INFERIORS =  0x000000001 
(ff:bind-c-type GdkSubwindowMode :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:110 <1889> 
;; typedef enum {
;;         GDK_GC_FOREGROUND =  0x000000001 LSHIFT  0x000000000,
;;   GDK_GC_BACKGROUND
;;    =  0x000000001 LSHIFT  0x000000001, GDK_GC_FONT =  0x000000001 LSHIFT
;;     0x000000002, GDK_GC_FUNCTION =  0x000000001 LSHIFT  0x000000003,
;;   GDK_GC_FILL
;;    =  0x000000001 LSHIFT  0x000000004, GDK_GC_TILE =  0x000000001 LSHIFT
;;     0x000000005, GDK_GC_STIPPLE =  0x000000001 LSHIFT  0x000000006,
;;   GDK_GC_CLIP_MASK
;;    =  0x000000001 LSHIFT  0x000000007, GDK_GC_SUBWINDOW =  0x000000001
;;   LSHIFT
;;     0x000000008, GDK_GC_TS_X_ORIGIN =  0x000000001 LSHIFT  0x000000009,
;;   GDK_GC_TS_Y_ORIGIN
;;    =  0x000000001 LSHIFT  0x00000000a, GDK_GC_CLIP_X_ORIGIN =
;;   0x000000001
;;    LSHIFT  0x00000000b, GDK_GC_CLIP_Y_ORIGIN =  0x000000001 LSHIFT
;;   0x00000000c,
;;              GDK_GC_EXPOSURES =  0x000000001 LSHIFT  0x00000000d,
;;   GDK_GC_LINE_WIDTH
;;    =  0x000000001 LSHIFT  0x00000000e, GDK_GC_LINE_STYLE =  0x000000001
;;   LSHIFT
;;     0x00000000f, GDK_GC_CAP_STYLE =  0x000000001 LSHIFT  0x000000010,
;;   GDK_GC_JOIN_STYLE
;;    =  0x000000001 LSHIFT  0x000000011 } GdkGCValuesMask;
(ff:bind-c-constant GDK_GC_FOREGROUND
                    1) ;;
;;   GDK_GC_FOREGROUND =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_GC_BACKGROUND
                    2) ;;
;;   GDK_GC_BACKGROUND =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_GC_FONT
                    4) ;;
;;   GDK_GC_FONT =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_GC_FUNCTION
                    8) ;;
;;   GDK_GC_FUNCTION =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_GC_FILL
                    16) ;;
;;   GDK_GC_FILL =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_GC_TILE
                    32) ;;
;;   GDK_GC_TILE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_GC_STIPPLE
                    64) ;;
;;   GDK_GC_STIPPLE =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GDK_GC_CLIP_MASK
                    128) ;;
;;   GDK_GC_CLIP_MASK =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GDK_GC_SUBWINDOW
                    256) ;;
;;   GDK_GC_SUBWINDOW =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant GDK_GC_TS_X_ORIGIN
                    512) ;;
;;   GDK_GC_TS_X_ORIGIN =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant GDK_GC_TS_Y_ORIGIN
                    1024) ;;
;;   GDK_GC_TS_Y_ORIGIN =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-constant GDK_GC_CLIP_X_ORIGIN
                    2048) ;;
;;   GDK_GC_CLIP_X_ORIGIN =  0x000000001 LSHIFT  0x00000000b 
(ff:bind-c-constant GDK_GC_CLIP_Y_ORIGIN
                    4096) ;;
;;   GDK_GC_CLIP_Y_ORIGIN =  0x000000001 LSHIFT  0x00000000c 
(ff:bind-c-constant GDK_GC_EXPOSURES
                    8192) ;;
;;   GDK_GC_EXPOSURES =  0x000000001 LSHIFT  0x00000000d 
(ff:bind-c-constant GDK_GC_LINE_WIDTH
                    16384) ;;
;;   GDK_GC_LINE_WIDTH =  0x000000001 LSHIFT  0x00000000e 
(ff:bind-c-constant GDK_GC_LINE_STYLE
                    32768) ;;
;;   GDK_GC_LINE_STYLE =  0x000000001 LSHIFT  0x00000000f 
(ff:bind-c-constant GDK_GC_CAP_STYLE
                    65536) ;;
;;   GDK_GC_CAP_STYLE =  0x000000001 LSHIFT  0x000000010 
(ff:bind-c-constant GDK_GC_JOIN_STYLE
                    131072) ;;
;;   GDK_GC_JOIN_STYLE =  0x000000001 LSHIFT  0x000000011 
(ff:bind-c-type GdkGCValuesMask :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:132 <1890> 
;; struct _GdkGCValues {
;;         GdkColor foreground; GdkColor background; GdkFont* font;
;;   GdkFunction function;
;;              GdkFill fill; GdkPixmap* tile; GdkPixmap* stipple;
;;   GdkPixmap* clip_mask;
;;              GdkSubwindowMode subwindow_mode; gint ts_x_origin; gint
;;   ts_y_origin; gint
;;    clip_x_origin; gint clip_y_origin; gint graphics_exposures; gint
;;   line_width;
;;              GdkLineStyle line_style; GdkCapStyle cap_style;
;;   GdkJoinStyle join_style;
;;    };
(ff:bind-c-type _GdkGCValues (:struct
  (foreground GdkColor)   ;; GdkColor foreground
  (background GdkColor)   ;; GdkColor background
  (font (* GdkFont))   ;; GdkFont* font
  (function GdkFunction)   ;; GdkFunction function
  (fill GdkFill)   ;; GdkFill fill
  (tile (* GdkPixmap))   ;; GdkPixmap* tile
  (stipple (* GdkPixmap))   ;; GdkPixmap* stipple
  (clip_mask (* GdkPixmap))   ;; GdkPixmap* clip_mask
  (subwindow_mode GdkSubwindowMode)   ;; GdkSubwindowMode subwindow_mode
  (ts_x_origin gint)   ;; gint ts_x_origin
  (ts_y_origin gint)   ;; gint ts_y_origin
  (clip_x_origin gint)   ;; gint clip_x_origin
  (clip_y_origin gint)   ;; gint clip_y_origin
  (graphics_exposures gint)   ;; gint graphics_exposures
  (line_width gint)   ;; gint line_width
  (line_style GdkLineStyle)   ;; GdkLineStyle line_style
  (cap_style GdkCapStyle)   ;; GdkCapStyle cap_style
  (join_style GdkJoinStyle)   ;; GdkJoinStyle join_style
  ))   ;; bind-c-type _GdkGCValues
(ff:bind-c-typedef GdkGCValues _GdkGCValues) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:161 <1891> 
;; struct _GdkGC {
;;         GObject parent_instance; gint clip_x_origin; gint clip_y_origin;
;;   gint
;;    ts_x_origin; gint ts_y_origin; GdkColormap* colormap; };
(ff:bind-c-type _GdkGC (:struct
  (parent_instance GObject)   ;; GObject parent_instance
  (clip_x_origin gint)   ;; gint clip_x_origin
  (clip_y_origin gint)   ;; gint clip_y_origin
  (ts_x_origin gint)   ;; gint ts_x_origin
  (ts_y_origin gint)   ;; gint ts_y_origin
  (colormap (* GdkColormap))   ;; GdkColormap* colormap
  ))   ;; bind-c-type _GdkGC
(ff:bind-c-typedef GdkGC _GdkGC) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:173 <1892> 
;; struct _GdkGCClass {
;;         GObjectClass parent_class; void(* get_values)( GdkGC* gc,
;;   GdkGCValues
;;   * values); void(* set_values)( GdkGC* gc, GdkGCValues* values,
;;   GdkGCValuesMask
;;    mask); void(* set_dashes)( GdkGC* gc, gint dash_offset, gint8
;;   dash_list
;;   [], gint n); void(* _gdk_reserved1)( void); void(* _gdk_reserved2)(
;;   void
;;   ); void(* _gdk_reserved3)( void); void(* _gdk_reserved4)( void); };
(ff:bind-c-type _GdkGCClass (:struct
  (parent_class GObjectClass)   ;; GObjectClass parent_class
  (get_values ff:function-pointer)   ;;
  ;;  void(* get_values)( GdkGC* gc, GdkGCValues* values)
  (set_values ff:function-pointer)   ;;
  ;;  void(* set_values)( GdkGC* gc, GdkGCValues* values, GdkGCValuesMask mask)
  (set_dashes ff:function-pointer)   ;;
  ;;  void(* set_dashes)( GdkGC* gc, gint dash_offset, gint8 dash_list[], gint n
  ;; )
  (_gdk_reserved1 ff:function-pointer)   ;; void(* _gdk_reserved1)( void)
  (_gdk_reserved2 ff:function-pointer)   ;; void(* _gdk_reserved2)( void)
  (_gdk_reserved3 ff:function-pointer)   ;; void(* _gdk_reserved3)( void)
  (_gdk_reserved4 ff:function-pointer)   ;; void(* _gdk_reserved4)( void)
  ))   ;; bind-c-type _GdkGCClass
(ff:bind-c-typedef GdkGCClass _GdkGCClass) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:195 <1893> 
;; GType gdk_gc_get_type( void);
(ff:bind-c-function gdk_gc_get_type
     :unconverted-entry-name "gdk_gc_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:196 <1894> 
;; GdkGC* gdk_gc_new( GdkDrawable* drawable);
(ff:bind-c-function gdk_gc_new
     :unconverted-entry-name "gdk_gc_new"
     :c-return-type ("GdkGC" "*")
     :return-type (* GdkGC)
     :c-arg-types (("GdkDrawable" "*"))
     :c-arg-names (drawable)
     :arguments ((* GdkDrawable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:197 <1895> 
;; GdkGC* gdk_gc_new_with_values( GdkDrawable* drawable, GdkGCValues*
;;   values,
;;              GdkGCValuesMask values_mask);
(ff:bind-c-function gdk_gc_new_with_values
     :unconverted-entry-name "gdk_gc_new_with_values"
     :c-return-type ("GdkGC" "*")
     :return-type (* GdkGC)
     :c-arg-types (("GdkDrawable" "*") ("GdkGCValues" "*")
                   ("GdkGCValuesMask"))
     :c-arg-names (drawable values values_mask)
     :arguments ((* GdkDrawable) (* GdkGCValues) GdkGCValuesMask)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:202 <1896> 
;; GdkGC* gdk_gc_ref( GdkGC* gc);
(ff:bind-c-function gdk_gc_ref
     :unconverted-entry-name "gdk_gc_ref"
     :c-return-type ("GdkGC" "*")
     :return-type (* GdkGC)
     :c-arg-types (("GdkGC" "*"))
     :c-arg-names (gc)
     :arguments ((* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:203 <1897> 
;; void gdk_gc_unref( GdkGC* gc);
(ff:bind-c-function gdk_gc_unref
     :all-names ((gdk_gc_unref . "gdk_gc_unref")
                 (gdk_gc_destroy . "gdk_gc_destroy"))
     :unconverted-entry-name "gdk_gc_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*"))
     :c-arg-names (gc)
     :arguments ((* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:206 <1898> 
;; void gdk_gc_get_values( GdkGC* gc, GdkGCValues* values);
(ff:bind-c-function gdk_gc_get_values
     :unconverted-entry-name "gdk_gc_get_values"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkGCValues" "*"))
     :c-arg-names (gc values)
     :arguments ((* GdkGC) (* GdkGCValues))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:208 <1899> 
;; void gdk_gc_set_values( GdkGC* gc, GdkGCValues* values, GdkGCValuesMask
;;    values_mask);
(ff:bind-c-function gdk_gc_set_values
     :unconverted-entry-name "gdk_gc_set_values"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkGCValues" "*")
                   ("GdkGCValuesMask"))
     :c-arg-names (gc values values_mask)
     :arguments ((* GdkGC) (* GdkGCValues) GdkGCValuesMask)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:211 <1900> 
;; void gdk_gc_set_foreground( GdkGC* gc, GdkColor* color);
(ff:bind-c-function gdk_gc_set_foreground
     :unconverted-entry-name "gdk_gc_set_foreground"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkColor" "*"))
     :c-arg-names (gc color)
     :arguments ((* GdkGC) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:213 <1901> 
;; void gdk_gc_set_background( GdkGC* gc, GdkColor* color);
(ff:bind-c-function gdk_gc_set_background
     :unconverted-entry-name "gdk_gc_set_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkColor" "*"))
     :c-arg-names (gc color)
     :arguments ((* GdkGC) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:216 <1902> 
;; void gdk_gc_set_font( GdkGC* gc, GdkFont* font);
(ff:bind-c-function gdk_gc_set_font
     :unconverted-entry-name "gdk_gc_set_font"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkFont" "*"))
     :c-arg-names (gc font)
     :arguments ((* GdkGC) (* GdkFont))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:219 <1903> 
;; void gdk_gc_set_function( GdkGC* gc, GdkFunction function);
(ff:bind-c-function gdk_gc_set_function
     :unconverted-entry-name "gdk_gc_set_function"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkFunction"))
     :c-arg-names (gc function)
     :arguments ((* GdkGC) GdkFunction)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:221 <1904> 
;; void gdk_gc_set_fill( GdkGC* gc, GdkFill fill);
(ff:bind-c-function gdk_gc_set_fill
     :unconverted-entry-name "gdk_gc_set_fill"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkFill"))
     :c-arg-names (gc fill)
     :arguments ((* GdkGC) GdkFill)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:223 <1905> 
;; void gdk_gc_set_tile( GdkGC* gc, GdkPixmap* tile);
(ff:bind-c-function gdk_gc_set_tile
     :unconverted-entry-name "gdk_gc_set_tile"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkPixmap" "*"))
     :c-arg-names (gc tile)
     :arguments ((* GdkGC) (* GdkPixmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:225 <1906> 
;; void gdk_gc_set_stipple( GdkGC* gc, GdkPixmap* stipple);
(ff:bind-c-function gdk_gc_set_stipple
     :unconverted-entry-name "gdk_gc_set_stipple"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkPixmap" "*"))
     :c-arg-names (gc stipple)
     :arguments ((* GdkGC) (* GdkPixmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:227 <1907> 
;; void gdk_gc_set_ts_origin( GdkGC* gc, gint x, gint y);
(ff:bind-c-function gdk_gc_set_ts_origin
     :unconverted-entry-name "gdk_gc_set_ts_origin"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("gint"))
     :c-arg-names (gc x y)
     :arguments ((* GdkGC) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:230 <1908> 
;; void gdk_gc_set_clip_origin( GdkGC* gc, gint x, gint y);
(ff:bind-c-function gdk_gc_set_clip_origin
     :unconverted-entry-name "gdk_gc_set_clip_origin"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("gint"))
     :c-arg-names (gc x y)
     :arguments ((* GdkGC) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:233 <1909> 
;; void gdk_gc_set_clip_mask( GdkGC* gc, GdkBitmap* mask);
(ff:bind-c-function gdk_gc_set_clip_mask
     :unconverted-entry-name "gdk_gc_set_clip_mask"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkBitmap" "*"))
     :c-arg-names (gc mask)
     :arguments ((* GdkGC) (* GdkBitmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:235 <1910> 
;; void gdk_gc_set_clip_rectangle( GdkGC* gc, GdkRectangle* rectangle);
(ff:bind-c-function gdk_gc_set_clip_rectangle
     :unconverted-entry-name "gdk_gc_set_clip_rectangle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkRectangle" "*"))
     :c-arg-names (gc rectangle)
     :arguments ((* GdkGC) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:237 <1911> 
;; void gdk_gc_set_clip_region( GdkGC* gc, GdkRegion* region);
(ff:bind-c-function gdk_gc_set_clip_region
     :unconverted-entry-name "gdk_gc_set_clip_region"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkRegion" "*"))
     :c-arg-names (gc region)
     :arguments ((* GdkGC) (* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:239 <1912> 
;; void gdk_gc_set_subwindow( GdkGC* gc, GdkSubwindowMode mode);
(ff:bind-c-function gdk_gc_set_subwindow
     :unconverted-entry-name "gdk_gc_set_subwindow"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkSubwindowMode"))
     :c-arg-names (gc mode)
     :arguments ((* GdkGC) GdkSubwindowMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:241 <1913> 
;; void gdk_gc_set_exposures( GdkGC* gc, gboolean exposures);
(ff:bind-c-function gdk_gc_set_exposures
     :unconverted-entry-name "gdk_gc_set_exposures"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gboolean"))
     :c-arg-names (gc exposures)
     :arguments ((* GdkGC) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:243 <1914> 
;; void gdk_gc_set_line_attributes( GdkGC* gc, gint line_width,
;;   GdkLineStyle
;;    line_style, GdkCapStyle cap_style, GdkJoinStyle join_style);
(ff:bind-c-function gdk_gc_set_line_attributes
     :unconverted-entry-name "gdk_gc_set_line_attributes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("GdkLineStyle")
                   ("GdkCapStyle") ("GdkJoinStyle"))
     :c-arg-names (gc line_width line_style cap_style join_style)
     :arguments ((* GdkGC) gint GdkLineStyle GdkCapStyle GdkJoinStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:248 <1915> 
;; void gdk_gc_set_dashes( GdkGC* gc, gint dash_offset, gint8 dash_list[
;;   ], gint n);
(ff:bind-c-function gdk_gc_set_dashes
     :unconverted-entry-name "gdk_gc_set_dashes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("gint8" "[" "]") ("gint"))
     :c-arg-names (gc dash_offset dash_list n)
     :arguments ((* GdkGC) gint (* gint8) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:252 <1916> 
;; void gdk_gc_offset( GdkGC* gc, gint x_offset, gint y_offset);
(ff:bind-c-function gdk_gc_offset
     :unconverted-entry-name "gdk_gc_offset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("gint"))
     :c-arg-names (gc x_offset y_offset)
     :arguments ((* GdkGC) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:255 <1917> 
;; void gdk_gc_copy( GdkGC* dst_gc, GdkGC* src_gc);
(ff:bind-c-function gdk_gc_copy
     :unconverted-entry-name "gdk_gc_copy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkGC" "*"))
     :c-arg-names (dst_gc src_gc)
     :arguments ((* GdkGC) (* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:259 <1918> 
;; void gdk_gc_set_colormap( GdkGC* gc, GdkColormap* colormap);
(ff:bind-c-function gdk_gc_set_colormap
     :unconverted-entry-name "gdk_gc_set_colormap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkColormap" "*"))
     :c-arg-names (gc colormap)
     :arguments ((* GdkGC) (* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:261 <1919> 
;; GdkColormap* gdk_gc_get_colormap( GdkGC* gc);
(ff:bind-c-function gdk_gc_get_colormap
     :unconverted-entry-name "gdk_gc_get_colormap"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GdkGC" "*"))
     :c-arg-names (gc)
     :arguments ((* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:262 <1920> 
;; void gdk_gc_set_rgb_fg_color( GdkGC* gc, GdkColor* color);
(ff:bind-c-function gdk_gc_set_rgb_fg_color
     :unconverted-entry-name "gdk_gc_set_rgb_fg_color"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkColor" "*"))
     :c-arg-names (gc color)
     :arguments ((* GdkGC) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkgc.h:264 <1921> 
;; void gdk_gc_set_rgb_bg_color( GdkGC* gc, GdkColor* color);
(ff:bind-c-function gdk_gc_set_rgb_bg_color
     :unconverted-entry-name "gdk_gc_set_rgb_bg_color"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkColor" "*"))
     :c-arg-names (gc color)
     :arguments ((* GdkGC) (* GdkColor))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:36 <1922> 
;; typedef struct _GdkRgbCmap GdkRgbCmap;
(ff:bind-c-typedef _GdkRgbCmap
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkRgbCmap _GdkRgbCmap)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:38 <1923> 
;; struct _GdkRgbCmap {
;;         guint32 colors[  0x000000100]; gint n_colors; GSList* info_list;
;;   };
(ff:bind-c-type _GdkRgbCmap (:struct
  (colors (:array guint32 256))   ;; guint32 colors[  0x000000100]
  (n_colors gint)   ;; gint n_colors
  (info_list (* GSList))   ;; GSList* info_list
  ))   ;; bind-c-type _GdkRgbCmap
(ff:bind-c-typedef GdkRgbCmap _GdkRgbCmap) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:47 <1924> 
;; void gdk_rgb_init( void);
(ff:bind-c-function gdk_rgb_init
     :unconverted-entry-name "gdk_rgb_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:49 <1925> 
;; gulong gdk_rgb_xpixel_from_rgb( guint32 rgb);
(ff:bind-c-function gdk_rgb_xpixel_from_rgb
     :unconverted-entry-name "gdk_rgb_xpixel_from_rgb"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("guint32"))
     :c-arg-names (rgb)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:50 <1926> 
;; void gdk_rgb_gc_set_foreground( GdkGC* gc, guint32 rgb);
(ff:bind-c-function gdk_rgb_gc_set_foreground
     :unconverted-entry-name "gdk_rgb_gc_set_foreground"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("guint32"))
     :c-arg-names (gc rgb)
     :arguments ((* GdkGC) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:52 <1927> 
;; void gdk_rgb_gc_set_background( GdkGC* gc, guint32 rgb);
(ff:bind-c-function gdk_rgb_gc_set_background
     :unconverted-entry-name "gdk_rgb_gc_set_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("guint32"))
     :c-arg-names (gc rgb)
     :arguments ((* GdkGC) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:57 <1928> 
;; void gdk_rgb_find_color( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_rgb_find_color
     :unconverted-entry-name "gdk_rgb_find_color"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:60 <1929> 
;; typedef enum {
;;         GDK_RGB_DITHER_NONE, GDK_RGB_DITHER_NORMAL, GDK_RGB_DITHER_MAX }
;;   GdkRgbDither
;;   ;
(ff:bind-c-constant GDK_RGB_DITHER_NONE 0) ;;  GDK_RGB_DITHER_NONE 
(ff:bind-c-constant GDK_RGB_DITHER_NORMAL 1) ;;  GDK_RGB_DITHER_NORMAL 
(ff:bind-c-constant GDK_RGB_DITHER_MAX 2) ;;  GDK_RGB_DITHER_MAX 
(ff:bind-c-type GdkRgbDither :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:67 <1930> 
;; void gdk_draw_rgb_image( GdkDrawable* drawable, GdkGC* gc, gint x, gint
;;    y, gint width, gint height, GdkRgbDither dith, guchar* rgb_buf, gint
;;   rowstride
;;   );
(ff:bind-c-function gdk_draw_rgb_image
     :unconverted-entry-name "gdk_draw_rgb_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*")
                   ("gint"))
     :c-arg-names (drawable gc x y width height dith rgb_buf rowstride)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint
                 GdkRgbDither (* guchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:76 <1931> 
;; void gdk_draw_rgb_image_dithalign( GdkDrawable* drawable, GdkGC* gc,
;;   gint
;;    x, gint y, gint width, gint height, GdkRgbDither dith, guchar*
;;   rgb_buf,
;;              gint rowstride, gint xdith, gint ydith);
(ff:bind-c-function gdk_draw_rgb_image_dithalign
     :unconverted-entry-name "gdk_draw_rgb_image_dithalign"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc x y width height dith rgb_buf rowstride
                   xdith ydith)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint
                 GdkRgbDither (* guchar) gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:87 <1932> 
;; void gdk_draw_rgb_32_image( GdkDrawable* drawable, GdkGC* gc, gint x,
;;              gint y, gint width, gint height, GdkRgbDither dith, guchar*
;;   buf, gint
;;    rowstride);
(ff:bind-c-function gdk_draw_rgb_32_image
     :unconverted-entry-name "gdk_draw_rgb_32_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*")
                   ("gint"))
     :c-arg-names (drawable gc x y width height dith buf rowstride)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint
                 GdkRgbDither (* guchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:96 <1933> 
;; void gdk_draw_rgb_32_image_dithalign( GdkDrawable* drawable, GdkGC* gc,
;;              gint x, gint y, gint width, gint height, GdkRgbDither dith,
;;   guchar* buf,
;;              gint rowstride, gint xdith, gint ydith);
(ff:bind-c-function gdk_draw_rgb_32_image_dithalign
     :unconverted-entry-name "gdk_draw_rgb_32_image_dithalign"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc x y width height dith buf rowstride
                   xdith ydith)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint
                 GdkRgbDither (* guchar) gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:107 <1934> 
;; void gdk_draw_gray_image( GdkDrawable* drawable, GdkGC* gc, gint x, gint
;;    y, gint width, gint height, GdkRgbDither dith, guchar* buf, gint
;;   rowstride
;;   );
(ff:bind-c-function gdk_draw_gray_image
     :unconverted-entry-name "gdk_draw_gray_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*")
                   ("gint"))
     :c-arg-names (drawable gc x y width height dith buf rowstride)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint
                 GdkRgbDither (* guchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:116 <1935> 
;; void gdk_draw_indexed_image( GdkDrawable* drawable, GdkGC* gc, gint x,
;;              gint y, gint width, gint height, GdkRgbDither dith, guchar*
;;   buf, gint
;;    rowstride, GdkRgbCmap* cmap);
(ff:bind-c-function gdk_draw_indexed_image
     :unconverted-entry-name "gdk_draw_indexed_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*")
                   ("gint") ("GdkRgbCmap" "*"))
     :c-arg-names (drawable gc x y width height dith buf rowstride cmap)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint
                 GdkRgbDither (* guchar) gint (* GdkRgbCmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:126 <1936> 
;; GdkRgbCmap* gdk_rgb_cmap_new( guint32* colors, gint n_colors);
(ff:bind-c-function gdk_rgb_cmap_new
     :unconverted-entry-name "gdk_rgb_cmap_new"
     :c-return-type ("GdkRgbCmap" "*")
     :return-type (* GdkRgbCmap)
     :c-arg-types (("guint32" "*") ("gint"))
     :c-arg-names (colors n_colors)
     :arguments ((* guint32) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:128 <1937> 
;; void gdk_rgb_cmap_free( GdkRgbCmap* cmap);
(ff:bind-c-function gdk_rgb_cmap_free
     :unconverted-entry-name "gdk_rgb_cmap_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkRgbCmap" "*"))
     :c-arg-names (cmap)
     :arguments ((* GdkRgbCmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:132 <1938> 
;; gboolean gdk_rgb_ditherable( void);
(ff:bind-c-function gdk_rgb_ditherable
     :unconverted-entry-name "gdk_rgb_ditherable"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:133 <1939> 
;; void gdk_rgb_set_verbose( gboolean verbose);
(ff:bind-c-function gdk_rgb_set_verbose
     :unconverted-entry-name "gdk_rgb_set_verbose"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gboolean"))
     :c-arg-names (verbose)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:136 <1940> 
;; void gdk_rgb_set_install( gboolean install);
(ff:bind-c-function gdk_rgb_set_install
     :unconverted-entry-name "gdk_rgb_set_install"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gboolean"))
     :c-arg-names (install)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:137 <1941> 
;; void gdk_rgb_set_min_colors( gint min_colors);
(ff:bind-c-function gdk_rgb_set_min_colors
     :unconverted-entry-name "gdk_rgb_set_min_colors"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint"))
     :c-arg-names (min_colors)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:139 <1942> 
;; GdkColormap* gdk_rgb_get_colormap( void);
(ff:bind-c-function gdk_rgb_get_colormap
     :all-names ((gdk_rgb_get_cmap . "gdk_rgb_get_cmap")
                 (gdk_rgb_get_colormap . "gdk_rgb_get_colormap"))
     :unconverted-entry-name "gdk_rgb_get_colormap"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkrgb.h:140 <1943> 
;; GdkVisual* gdk_rgb_get_visual( void);
(ff:bind-c-function gdk_rgb_get_visual
     :unconverted-entry-name "gdk_rgb_get_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-features.h:9 <1944> 
;; extern const guint gdk_pixbuf_major_version, gdk_pixbuf_minor_version,
;;              gdk_pixbuf_micro_version;

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-features.h:9 <Declaration 1 in <1944>> 
;; extern const guint gdk_pixbuf_major_version
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "gdk_pixbuf_major_version"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-features.h:9 <Declaration 2 in <1944>> 
;; extern const guint gdk_pixbuf_minor_version
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "gdk_pixbuf_minor_version"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-features.h:9 <Declaration 3 in <1944>> 
;; extern const guint gdk_pixbuf_micro_version
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "gdk_pixbuf_micro_version"))

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-features.h:10 <1945> 
;; extern const char* gdk_pixbuf_version;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "gdk_pixbuf_version"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:38 <1946> 
;; typedef enum {
;;         GDK_PIXBUF_ALPHA_BILEVEL, GDK_PIXBUF_ALPHA_FULL }
;;   GdkPixbufAlphaMode;
(ff:bind-c-constant GDK_PIXBUF_ALPHA_BILEVEL
                    0) ;;
;;   GDK_PIXBUF_ALPHA_BILEVEL 
(ff:bind-c-constant GDK_PIXBUF_ALPHA_FULL 1) ;;  GDK_PIXBUF_ALPHA_FULL 
(ff:bind-c-type GdkPixbufAlphaMode :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:48 <1947> 
;; typedef enum { GDK_COLORSPACE_RGB } GdkColorspace;
(ff:bind-c-constant GDK_COLORSPACE_RGB 0) ;;  GDK_COLORSPACE_RGB 
(ff:bind-c-type GdkColorspace :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:53 <1948> 
;; typedef struct _GdkPixbuf GdkPixbuf;
(ff:bind-c-typedef _GdkPixbuf
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPixbuf _GdkPixbuf)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:54 <1949> 
;; typedef struct _GdkPixbufAnimation GdkPixbufAnimation;
(ff:bind-c-typedef _GdkPixbufAnimation
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPixbufAnimation _GdkPixbufAnimation)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:55 <1950> 
;; typedef struct _GdkPixbufAnimationIter GdkPixbufAnimationIter;
(ff:bind-c-typedef _GdkPixbufAnimationIter
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPixbufAnimationIter _GdkPixbufAnimationIter)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:56 <1951> 
;; typedef struct _GdkPixbufFrame GdkPixbufFrame;
(ff:bind-c-typedef _GdkPixbufFrame
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPixbufFrame _GdkPixbufFrame)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:71 <1952> 
;; typedef void(* GdkPixbufDestroyNotify)( guchar* pixels, gpointer data);
(ff:bind-c-type GdkPixbufDestroyNotify (* :void))  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:75 <1953> 
;; typedef enum {
;;         GDK_PIXBUF_ERROR_CORRUPT_IMAGE,
;;   GDK_PIXBUF_ERROR_INSUFFICIENT_MEMORY,
;;              GDK_PIXBUF_ERROR_BAD_OPTION, GDK_PIXBUF_ERROR_UNKNOWN_TYPE,
;;   GDK_PIXBUF_ERROR_UNSUPPORTED_OPERATION,
;;              GDK_PIXBUF_ERROR_FAILED } GdkPixbufError;
(ff:bind-c-constant GDK_PIXBUF_ERROR_CORRUPT_IMAGE
                    0) ;;
;;   GDK_PIXBUF_ERROR_CORRUPT_IMAGE 
(ff:bind-c-constant GDK_PIXBUF_ERROR_INSUFFICIENT_MEMORY
                    1) ;;
;;   GDK_PIXBUF_ERROR_INSUFFICIENT_MEMORY 
(ff:bind-c-constant GDK_PIXBUF_ERROR_BAD_OPTION
                    2) ;;
;;   GDK_PIXBUF_ERROR_BAD_OPTION 
(ff:bind-c-constant GDK_PIXBUF_ERROR_UNKNOWN_TYPE
                    3) ;;
;;   GDK_PIXBUF_ERROR_UNKNOWN_TYPE 
(ff:bind-c-constant GDK_PIXBUF_ERROR_UNSUPPORTED_OPERATION
                    4) ;;
;;   GDK_PIXBUF_ERROR_UNSUPPORTED_OPERATION 
(ff:bind-c-constant GDK_PIXBUF_ERROR_FAILED
                    5) ;;
;;   GDK_PIXBUF_ERROR_FAILED 
(ff:bind-c-type GdkPixbufError :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:89 <1954> 
;; GQuark gdk_pixbuf_error_quark( void);
(ff:bind-c-function gdk_pixbuf_error_quark
     :unconverted-entry-name "gdk_pixbuf_error_quark"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:93 <1955> 
;; GType gdk_pixbuf_get_type( void);
(ff:bind-c-function gdk_pixbuf_get_type
     :unconverted-entry-name "gdk_pixbuf_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:98 <1956> 
;; GdkPixbuf* gdk_pixbuf_ref( GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_ref
     :unconverted-entry-name "gdk_pixbuf_ref"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:99 <1957> 
;; void gdk_pixbuf_unref( GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_unref
     :unconverted-entry-name "gdk_pixbuf_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:104 <1958> 
;; GdkColorspace gdk_pixbuf_get_colorspace( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_colorspace
     :unconverted-entry-name "gdk_pixbuf_get_colorspace"
     :c-return-type ("GdkColorspace")
     :return-type GdkColorspace
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:105 <1959> 
;; int gdk_pixbuf_get_n_channels( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_n_channels
     :unconverted-entry-name "gdk_pixbuf_get_n_channels"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:106 <1960> 
;; gboolean gdk_pixbuf_get_has_alpha( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_has_alpha
     :unconverted-entry-name "gdk_pixbuf_get_has_alpha"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:107 <1961> 
;; int gdk_pixbuf_get_bits_per_sample( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_bits_per_sample
     :unconverted-entry-name "gdk_pixbuf_get_bits_per_sample"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:108 <1962> 
;; guchar* gdk_pixbuf_get_pixels( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_pixels
     :unconverted-entry-name "gdk_pixbuf_get_pixels"
     :c-return-type ("guchar" "*")
     :return-type (* guchar)
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:109 <1963> 
;; int gdk_pixbuf_get_width( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_width
     :unconverted-entry-name "gdk_pixbuf_get_width"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:110 <1964> 
;; int gdk_pixbuf_get_height( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_height
     :unconverted-entry-name "gdk_pixbuf_get_height"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:111 <1965> 
;; int gdk_pixbuf_get_rowstride( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_get_rowstride
     :unconverted-entry-name "gdk_pixbuf_get_rowstride"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:116 <1966> 
;; GdkPixbuf* gdk_pixbuf_new( GdkColorspace colorspace, gboolean has_alpha,
;;              int bits_per_sample, int width, int height);
(ff:bind-c-function gdk_pixbuf_new
     :unconverted-entry-name "gdk_pixbuf_new"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("GdkColorspace") ("gboolean") ("int") ("int")
                   ("int"))
     :c-arg-names (colorspace has_alpha bits_per_sample width height)
     :arguments (GdkColorspace gboolean :int :int :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:121 <1967> 
;; GdkPixbuf* gdk_pixbuf_copy( const GdkPixbuf* pixbuf);
(ff:bind-c-function gdk_pixbuf_copy
     :unconverted-entry-name "gdk_pixbuf_copy"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("const" "GdkPixbuf" "*"))
     :c-arg-names (pixbuf)
     :arguments ((* GdkPixbuf))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:124 <1968> 
;; GdkPixbuf* gdk_pixbuf_new_subpixbuf( GdkPixbuf* src_pixbuf, int src_x,
;;              int src_y, int width, int height);
(ff:bind-c-function gdk_pixbuf_new_subpixbuf
     :unconverted-entry-name "gdk_pixbuf_new_subpixbuf"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("GdkPixbuf" "*") ("int") ("int") ("int") ("int"))
     :c-arg-names (src_pixbuf src_x src_y width height)
     :arguments ((* GdkPixbuf) :int :int :int :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:132 <1969> 
;; GdkPixbuf* gdk_pixbuf_new_from_file( const char* filename, GError**
;;   error
;;   );
(ff:bind-c-function gdk_pixbuf_new_from_file
     :unconverted-entry-name "gdk_pixbuf_new_from_file"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("const" "char" "*") ("GError" "*" "*"))
     :c-arg-names (filename error)
     :arguments ((* :char) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:135 <1970> 
;; GdkPixbuf* gdk_pixbuf_new_from_data( const guchar* data, GdkColorspace
;;    colorspace, gboolean has_alpha, int bits_per_sample, int width, int
;;   height,
;;              int rowstride, GdkPixbufDestroyNotify destroy_fn, gpointer
;;   destroy_fn_data
;;   );
(ff:bind-c-function gdk_pixbuf_new_from_data
     :unconverted-entry-name "gdk_pixbuf_new_from_data"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("const" "guchar" "*") ("GdkColorspace")
                   ("gboolean") ("int") ("int") ("int") ("int")
                   ("GdkPixbufDestroyNotify") ("gpointer"))
     :c-arg-names (data colorspace has_alpha bits_per_sample width
                   height rowstride destroy_fn destroy_fn_data)
     :arguments ((* guchar) GdkColorspace gboolean :int :int :int :int
                 GdkPixbufDestroyNotify gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:144 <1971> 
;; GdkPixbuf* gdk_pixbuf_new_from_xpm_data( const char** data);
(ff:bind-c-function gdk_pixbuf_new_from_xpm_data
     :unconverted-entry-name "gdk_pixbuf_new_from_xpm_data"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("const" "char" "*" "*"))
     :c-arg-names (data)
     :arguments ((* (* :char)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:145 <1972> 
;; GdkPixbuf* gdk_pixbuf_new_from_inline( gint data_length, const guint8
;;   * data, gboolean copy_pixels, GError** error);
(ff:bind-c-function gdk_pixbuf_new_from_inline
     :unconverted-entry-name "gdk_pixbuf_new_from_inline"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("gint") ("const" "guint8" "*") ("gboolean")
                   ("GError" "*" "*"))
     :c-arg-names (data_length data copy_pixels error)
     :arguments (gint (* guint8) gboolean (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:151 <1973> 
;; void gdk_pixbuf_fill( GdkPixbuf* pixbuf, guint32 pixel);
(ff:bind-c-function gdk_pixbuf_fill
     :unconverted-entry-name "gdk_pixbuf_fill"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkPixbuf" "*") ("guint32"))
     :c-arg-names (pixbuf pixel)
     :arguments ((* GdkPixbuf) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:156 <1974> 
;; gboolean gdk_pixbuf_save( GdkPixbuf* pixbuf, const char* filename, const
;;    char* type, GError** error, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gdk_pixbuf_save
     :unconverted-entry-name "gdk_pixbuf_save"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkPixbuf" "*") ("const" "char" "*")
                   ("const" "char" "*") ("GError" "*" "*") "...")
     :c-arg-names (pixbuf filename type error)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:162 <1975> 
;; gboolean gdk_pixbuf_savev( GdkPixbuf* pixbuf, const char* filename,
;;   const
;;    char* type, char** option_keys, char** option_values, GError** error)
;;   ;
(ff:bind-c-function gdk_pixbuf_savev
     :unconverted-entry-name "gdk_pixbuf_savev"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkPixbuf" "*") ("const" "char" "*")
                   ("const" "char" "*") ("char" "*" "*")
                   ("char" "*" "*") ("GError" "*" "*"))
     :c-arg-names (pixbuf filename type option_keys option_values error)
     :arguments ((* GdkPixbuf) (* :char) (* :char) (* (* :char))
                 (* (* :char)) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:170 <1976> 
;; GdkPixbuf* gdk_pixbuf_add_alpha( const GdkPixbuf* pixbuf, gboolean
;;   substitute_color,
;;              guchar r, guchar g, guchar b);
(ff:bind-c-function gdk_pixbuf_add_alpha
     :unconverted-entry-name "gdk_pixbuf_add_alpha"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("const" "GdkPixbuf" "*") ("gboolean") ("guchar")
                   ("guchar") ("guchar"))
     :c-arg-names (pixbuf substitute_color r g b)
     :arguments ((* GdkPixbuf) gboolean guchar guchar guchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:174 <1977> 
;; void gdk_pixbuf_copy_area( const GdkPixbuf* src_pixbuf, int src_x, int
;;    src_y, int width, int height, GdkPixbuf* dest_pixbuf, int dest_x, int
;;    dest_y);
(ff:bind-c-function gdk_pixbuf_copy_area
     :unconverted-entry-name "gdk_pixbuf_copy_area"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GdkPixbuf" "*") ("int") ("int") ("int")
                   ("int") ("GdkPixbuf" "*") ("int") ("int"))
     :c-arg-names (src_pixbuf src_x src_y width height dest_pixbuf
                   dest_x dest_y)
     :arguments ((* GdkPixbuf) :int :int :int :int (* GdkPixbuf) :int
                 :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:181 <1978> 
;; void gdk_pixbuf_saturate_and_pixelate( const GdkPixbuf* src, GdkPixbuf
;;   * dest, gfloat saturation, gboolean pixelate);
(ff:bind-c-function gdk_pixbuf_saturate_and_pixelate
     :unconverted-entry-name "gdk_pixbuf_saturate_and_pixelate"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GdkPixbuf" "*") ("GdkPixbuf" "*")
                   ("gfloat") ("gboolean"))
     :c-arg-names (src dest saturation pixelate)
     :arguments ((* GdkPixbuf) (* GdkPixbuf) gfloat gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:194 <1979> 
;; typedef enum {
;;         GDK_INTERP_NEAREST, GDK_INTERP_TILES, GDK_INTERP_BILINEAR,
;;   GDK_INTERP_HYPER
;;    } GdkInterpType;
(ff:bind-c-constant GDK_INTERP_NEAREST 0) ;;  GDK_INTERP_NEAREST 
(ff:bind-c-constant GDK_INTERP_TILES 1) ;;  GDK_INTERP_TILES 
(ff:bind-c-constant GDK_INTERP_BILINEAR 2) ;;  GDK_INTERP_BILINEAR 
(ff:bind-c-constant GDK_INTERP_HYPER 3) ;;  GDK_INTERP_HYPER 
(ff:bind-c-type GdkInterpType :int)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:201 <1980> 
;; void gdk_pixbuf_scale( const GdkPixbuf* src, GdkPixbuf* dest, int
;;   dest_x,
;;              int dest_y, int dest_width, int dest_height, double
;;   offset_x, double offset_y,
;;              double scale_x, double scale_y, GdkInterpType interp_type);
(ff:bind-c-function gdk_pixbuf_scale
     :unconverted-entry-name "gdk_pixbuf_scale"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GdkPixbuf" "*") ("GdkPixbuf" "*") ("int")
                   ("int") ("int") ("int") ("double") ("double")
                   ("double") ("double") ("GdkInterpType"))
     :c-arg-names (src dest dest_x dest_y dest_width dest_height
                   offset_x offset_y scale_x scale_y interp_type)
     :arguments ((* GdkPixbuf) (* GdkPixbuf) :int :int :int :int
                 :double :double :double :double GdkInterpType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:212 <1981> 
;; void gdk_pixbuf_composite( const GdkPixbuf* src, GdkPixbuf* dest, int
;;    dest_x, int dest_y, int dest_width, int dest_height, double offset_x,
;;              double offset_y, double scale_x, double scale_y,
;;   GdkInterpType interp_type,
;;              int overall_alpha);
(ff:bind-c-function gdk_pixbuf_composite
     :unconverted-entry-name "gdk_pixbuf_composite"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GdkPixbuf" "*") ("GdkPixbuf" "*") ("int")
                   ("int") ("int") ("int") ("double") ("double")
                   ("double") ("double") ("GdkInterpType") ("int"))
     :c-arg-names (src dest dest_x dest_y dest_width dest_height
                   offset_x offset_y scale_x scale_y interp_type
                   overall_alpha)
     :arguments ((* GdkPixbuf) (* GdkPixbuf) :int :int :int :int
                 :double :double :double :double GdkInterpType :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:224 <1982> 
;; void gdk_pixbuf_composite_color( const GdkPixbuf* src, GdkPixbuf* dest,
;;              int dest_x, int dest_y, int dest_width, int dest_height,
;;   double offset_x,
;;              double offset_y, double scale_x, double scale_y,
;;   GdkInterpType interp_type,
;;              int overall_alpha, int check_x, int check_y, int
;;   check_size, guint32 color1,
;;              guint32 color2);
(ff:bind-c-function gdk_pixbuf_composite_color
     :unconverted-entry-name "gdk_pixbuf_composite_color"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "GdkPixbuf" "*") ("GdkPixbuf" "*") ("int")
                   ("int") ("int") ("int") ("double") ("double")
                   ("double") ("double") ("GdkInterpType") ("int")
                   ("int") ("int") ("int") ("guint32") ("guint32"))
     :c-arg-names (src dest dest_x dest_y dest_width dest_height
                   offset_x offset_y scale_x scale_y interp_type
                   overall_alpha check_x check_y check_size color1
                   color2)
     :arguments ((* GdkPixbuf) (* GdkPixbuf) :int :int :int :int
                 :double :double :double :double GdkInterpType :int
                 :int :int :int guint32 guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:242 <1983> 
;; GdkPixbuf* gdk_pixbuf_scale_simple( const GdkPixbuf* src, int
;;   dest_width,
;;              int dest_height, GdkInterpType interp_type);
(ff:bind-c-function gdk_pixbuf_scale_simple
     :unconverted-entry-name "gdk_pixbuf_scale_simple"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("const" "GdkPixbuf" "*") ("int") ("int")
                   ("GdkInterpType"))
     :c-arg-names (src dest_width dest_height interp_type)
     :arguments ((* GdkPixbuf) :int :int GdkInterpType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:247 <1984> 
;; GdkPixbuf* gdk_pixbuf_composite_color_simple( const GdkPixbuf* src, int
;;    dest_width, int dest_height, GdkInterpType interp_type, int
;;   overall_alpha,
;;              int check_size, guint32 color1, guint32 color2);
(ff:bind-c-function gdk_pixbuf_composite_color_simple
     :unconverted-entry-name "gdk_pixbuf_composite_color_simple"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("const" "GdkPixbuf" "*") ("int") ("int")
                   ("GdkInterpType") ("int") ("int") ("guint32")
                   ("guint32"))
     :c-arg-names (src dest_width dest_height interp_type overall_alpha
                   check_size color1 color2)
     :arguments ((* GdkPixbuf) :int :int GdkInterpType :int :int
                 guint32 guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:260 <1985> 
;; GType gdk_pixbuf_animation_get_type( void);
(ff:bind-c-function gdk_pixbuf_animation_get_type
     :unconverted-entry-name "gdk_pixbuf_animation_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:262 <1986> 
;; GdkPixbufAnimation* gdk_pixbuf_animation_new_from_file( const char*
;;   filename,
;;              GError** error);
(ff:bind-c-function gdk_pixbuf_animation_new_from_file
     :unconverted-entry-name "gdk_pixbuf_animation_new_from_file"
     :c-return-type ("GdkPixbufAnimation" "*")
     :return-type (* GdkPixbufAnimation)
     :c-arg-types (("const" "char" "*") ("GError" "*" "*"))
     :c-arg-names (filename error)
     :arguments ((* :char) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:266 <1987> 
;; GdkPixbufAnimation* gdk_pixbuf_animation_ref( GdkPixbufAnimation*
;;   animation
;;   );
(ff:bind-c-function gdk_pixbuf_animation_ref
     :unconverted-entry-name "gdk_pixbuf_animation_ref"
     :c-return-type ("GdkPixbufAnimation" "*")
     :return-type (* GdkPixbufAnimation)
     :c-arg-types (("GdkPixbufAnimation" "*"))
     :c-arg-names (animation)
     :arguments ((* GdkPixbufAnimation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:267 <1988> 
;; void gdk_pixbuf_animation_unref( GdkPixbufAnimation* animation);
(ff:bind-c-function gdk_pixbuf_animation_unref
     :unconverted-entry-name "gdk_pixbuf_animation_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkPixbufAnimation" "*"))
     :c-arg-names (animation)
     :arguments ((* GdkPixbufAnimation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:270 <1989> 
;; int gdk_pixbuf_animation_get_width( GdkPixbufAnimation* animation);
(ff:bind-c-function gdk_pixbuf_animation_get_width
     :unconverted-entry-name "gdk_pixbuf_animation_get_width"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("GdkPixbufAnimation" "*"))
     :c-arg-names (animation)
     :arguments ((* GdkPixbufAnimation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:271 <1990> 
;; int gdk_pixbuf_animation_get_height( GdkPixbufAnimation* animation);
(ff:bind-c-function gdk_pixbuf_animation_get_height
     :unconverted-entry-name "gdk_pixbuf_animation_get_height"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("GdkPixbufAnimation" "*"))
     :c-arg-names (animation)
     :arguments ((* GdkPixbufAnimation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:272 <1991> 
;; gboolean gdk_pixbuf_animation_is_static_image( GdkPixbufAnimation*
;;   animation
;;   );
(ff:bind-c-function gdk_pixbuf_animation_is_static_image
     :unconverted-entry-name "gdk_pixbuf_animation_is_static_image"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkPixbufAnimation" "*"))
     :c-arg-names (animation)
     :arguments ((* GdkPixbufAnimation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:273 <1992> 
;; GdkPixbuf* gdk_pixbuf_animation_get_static_image( GdkPixbufAnimation*
;;    animation);
(ff:bind-c-function gdk_pixbuf_animation_get_static_image
     :unconverted-entry-name "gdk_pixbuf_animation_get_static_image"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("GdkPixbufAnimation" "*"))
     :c-arg-names (animation)
     :arguments ((* GdkPixbufAnimation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:275 <1993> 
;; GdkPixbufAnimationIter* gdk_pixbuf_animation_get_iter(
;;   GdkPixbufAnimation
;;   * animation, const GTimeVal* start_time);
(ff:bind-c-function gdk_pixbuf_animation_get_iter
     :unconverted-entry-name "gdk_pixbuf_animation_get_iter"
     :c-return-type ("GdkPixbufAnimationIter" "*")
     :return-type (* GdkPixbufAnimationIter)
     :c-arg-types (("GdkPixbufAnimation" "*") ("const" "GTimeVal" "*"))
     :c-arg-names (animation start_time)
     :arguments ((* GdkPixbufAnimation) (* GTimeVal))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:277 <1994> 
;; GType gdk_pixbuf_animation_iter_get_type( void);
(ff:bind-c-function gdk_pixbuf_animation_iter_get_type
     :unconverted-entry-name "gdk_pixbuf_animation_iter_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:278 <1995> 
;; int gdk_pixbuf_animation_iter_get_delay_time( GdkPixbufAnimationIter*
;;    iter);
(ff:bind-c-function gdk_pixbuf_animation_iter_get_delay_time
     :unconverted-entry-name "gdk_pixbuf_animation_iter_get_delay_time"
     :c-return-type ("int")
     :return-type :int
     :c-arg-types (("GdkPixbufAnimationIter" "*"))
     :c-arg-names (iter)
     :arguments ((* GdkPixbufAnimationIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:279 <1996> 
;; GdkPixbuf* gdk_pixbuf_animation_iter_get_pixbuf( GdkPixbufAnimationIter
;;   * iter);
(ff:bind-c-function gdk_pixbuf_animation_iter_get_pixbuf
     :unconverted-entry-name "gdk_pixbuf_animation_iter_get_pixbuf"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("GdkPixbufAnimationIter" "*"))
     :c-arg-names (iter)
     :arguments ((* GdkPixbufAnimationIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:280 <1997> 
;; gboolean gdk_pixbuf_animation_iter_on_currently_loading_frame(
;;   GdkPixbufAnimationIter
;;   * iter);
(ff:bind-c-function gdk_pixbuf_animation_iter_on_currently_loading_frame
     :unconverted-entry-name "gdk_pixbuf_animation_iter_on_currently_loading_frame"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkPixbufAnimationIter" "*"))
     :c-arg-names (iter)
     :arguments ((* GdkPixbufAnimationIter))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:281 <1998> 
;; gboolean gdk_pixbuf_animation_iter_advance( GdkPixbufAnimationIter*
;;   iter,
;;              const GTimeVal* current_time);
(ff:bind-c-function gdk_pixbuf_animation_iter_advance
     :unconverted-entry-name "gdk_pixbuf_animation_iter_advance"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkPixbufAnimationIter" "*")
                   ("const" "GTimeVal" "*"))
     :c-arg-names (iter current_time)
     :arguments ((* GdkPixbufAnimationIter) (* GTimeVal))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf.h:287 <1999> 
;; const gchar* gdk_pixbuf_get_option( GdkPixbuf* pixbuf, const gchar*
;;   key);
(ff:bind-c-function gdk_pixbuf_get_option
     :unconverted-entry-name "gdk_pixbuf_get_option"
     :c-modifiers ("const")
     :c-return-type ("const" "gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GdkPixbuf" "*") ("const" "gchar" "*"))
     :c-arg-names (pixbuf key)
     :arguments ((* GdkPixbuf) (* gchar))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:39 <2000> 
;; typedef struct _GdkPixbufLoader GdkPixbufLoader;
(ff:bind-c-typedef _GdkPixbufLoader
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPixbufLoader _GdkPixbufLoader)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:40 <2001> 
;; struct _GdkPixbufLoader { GObject parent_instance; gpointer priv; };
(ff:bind-c-type _GdkPixbufLoader (:struct
  (parent_instance GObject)   ;; GObject parent_instance
  (priv gpointer)   ;; gpointer priv
  ))   ;; bind-c-type _GdkPixbufLoader
(ff:bind-c-typedef GdkPixbufLoader
                   _GdkPixbufLoader) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:48 <2002> 
;; typedef struct _GdkPixbufLoaderClass GdkPixbufLoaderClass;
(ff:bind-c-typedef _GdkPixbufLoaderClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPixbufLoaderClass _GdkPixbufLoaderClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:49 <2003> 
;; struct _GdkPixbufLoaderClass {
;;         GObjectClass parent_class; void(* area_prepared)(
;;   GdkPixbufLoader* loader
;;   ); void(* area_updated)( GdkPixbufLoader* loader, int x, int y, int
;;   width,
;;              int height); void(* closed)( GdkPixbufLoader* loader); };
(ff:bind-c-type _GdkPixbufLoaderClass (:struct
  (parent_class GObjectClass)   ;; GObjectClass parent_class
  (area_prepared ff:function-pointer)   ;;
  ;;  void(* area_prepared)( GdkPixbufLoader* loader)
  (area_updated ff:function-pointer)   ;;
  ;;  void(* area_updated)( GdkPixbufLoader* loader, int x, int y, int width, int
  ;;  height)
  (closed ff:function-pointer)   ;;
  ;;  void(* closed)( GdkPixbufLoader* loader)
  ))   ;; bind-c-type _GdkPixbufLoaderClass
(ff:bind-c-typedef GdkPixbufLoaderClass
                   _GdkPixbufLoaderClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:66 <2004> 
;; GType gdk_pixbuf_loader_get_type( void);
(ff:bind-c-function gdk_pixbuf_loader_get_type
     :unconverted-entry-name "gdk_pixbuf_loader_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:67 <2005> 
;; GdkPixbufLoader* gdk_pixbuf_loader_new( void);
(ff:bind-c-function gdk_pixbuf_loader_new
     :unconverted-entry-name "gdk_pixbuf_loader_new"
     :c-return-type ("GdkPixbufLoader" "*")
     :return-type (* GdkPixbufLoader)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:68 <2006> 
;; GdkPixbufLoader* gdk_pixbuf_loader_new_with_type( const char*
;;   image_type,
;;              GError** error);
(ff:bind-c-function gdk_pixbuf_loader_new_with_type
     :unconverted-entry-name "gdk_pixbuf_loader_new_with_type"
     :c-return-type ("GdkPixbufLoader" "*")
     :return-type (* GdkPixbufLoader)
     :c-arg-types (("const" "char" "*") ("GError" "*" "*"))
     :c-arg-names (image_type error)
     :arguments ((* :char) (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:70 <2007> 
;; gboolean gdk_pixbuf_loader_write( GdkPixbufLoader* loader, const guchar
;;   * buf, gsize count, GError** error);
(ff:bind-c-function gdk_pixbuf_loader_write
     :unconverted-entry-name "gdk_pixbuf_loader_write"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkPixbufLoader" "*") ("const" "guchar" "*")
                   ("gsize") ("GError" "*" "*"))
     :c-arg-names (loader buf count error)
     :arguments ((* GdkPixbufLoader) (* guchar) gsize (* (* GError)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:74 <2008> 
;; GdkPixbuf* gdk_pixbuf_loader_get_pixbuf( GdkPixbufLoader* loader);
(ff:bind-c-function gdk_pixbuf_loader_get_pixbuf
     :unconverted-entry-name "gdk_pixbuf_loader_get_pixbuf"
     :c-return-type ("GdkPixbuf" "*")
     :return-type (* GdkPixbuf)
     :c-arg-types (("GdkPixbufLoader" "*"))
     :c-arg-names (loader)
     :arguments ((* GdkPixbufLoader))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:75 <2009> 
;; GdkPixbufAnimation* gdk_pixbuf_loader_get_animation( GdkPixbufLoader*
;;    loader);
(ff:bind-c-function gdk_pixbuf_loader_get_animation
     :unconverted-entry-name "gdk_pixbuf_loader_get_animation"
     :c-return-type ("GdkPixbufAnimation" "*")
     :return-type (* GdkPixbufAnimation)
     :c-arg-types (("GdkPixbufLoader" "*"))
     :c-arg-names (loader)
     :arguments ((* GdkPixbufLoader))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-loader.h:76 <2010> 
;; gboolean gdk_pixbuf_loader_close( GdkPixbufLoader* loader, GError**
;;   error
;;   );
(ff:bind-c-function gdk_pixbuf_loader_close
     :unconverted-entry-name "gdk_pixbuf_loader_close"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkPixbufLoader" "*") ("GError" "*" "*"))
     :c-arg-names (loader error)
     :arguments ((* GdkPixbufLoader) (* (* GError)))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-enum-types.h:13 <2011> 
;; GType gdk_pixbuf_alpha_mode_get_type( void);
(ff:bind-c-function gdk_pixbuf_alpha_mode_get_type
     :unconverted-entry-name "gdk_pixbuf_alpha_mode_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-enum-types.h:16 <2012> 
;; GType gdk_colorspace_get_type( void);
(ff:bind-c-function gdk_colorspace_get_type
     :unconverted-entry-name "gdk_colorspace_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-enum-types.h:19 <2013> 
;; GType gdk_pixbuf_error_get_type( void);
(ff:bind-c-function gdk_pixbuf_error_get_type
     :unconverted-entry-name "gdk_pixbuf_error_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk-pixbuf/gdk-pixbuf-enum-types.h:22 <2014> 
;; GType gdk_interp_type_get_type( void);
(ff:bind-c-function gdk_interp_type_get_type
     :unconverted-entry-name "gdk_interp_type_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:13 <2015> 
;; typedef struct _GdkDrawableClass GdkDrawableClass;
(ff:bind-c-typedef _GdkDrawableClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkDrawableClass _GdkDrawableClass)  

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:22 <2016> 
;; struct _GdkDrawable { GObject parent_instance; };
(ff:bind-c-type _GdkDrawable (:struct
  (parent_instance GObject)   ;; GObject parent_instance
  ))   ;; bind-c-type _GdkDrawable
(ff:bind-c-typedef GdkWindow _GdkDrawable) ;;  final declaration 
(ff:bind-c-typedef GdkPixmap _GdkDrawable) ;;  final declaration 
(ff:bind-c-typedef GdkBitmap _GdkDrawable) ;;  final declaration 
(ff:bind-c-typedef GdkDrawable _GdkDrawable) ;;  final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:27 <2017> 
;; struct _GdkDrawableClass {
;;         GObjectClass parent_class; GdkGC*(* create_gc)( GdkDrawable*
;;   drawable,
;;              GdkGCValues* values, GdkGCValuesMask mask); void(*
;;   draw_rectangle)( GdkDrawable
;;   * drawable, GdkGC* gc, gint filled, gint x, gint y, gint width, gint
;;   height
;;   ); void(* draw_arc)( GdkDrawable* drawable, GdkGC* gc, gint filled,
;;   gint
;;    x, gint y, gint width, gint height, gint angle1, gint angle2); void(*
;;    draw_polygon)( GdkDrawable* drawable, GdkGC* gc, gint filled,
;;   GdkPoint
;;   * points, gint npoints); void(* draw_text)( GdkDrawable* drawable,
;;   GdkFont
;;   * font, GdkGC* gc, gint x, gint y, const gchar* text, gint text_length
;;   ); void(* draw_text_wc)( GdkDrawable* drawable, GdkFont* font, GdkGC*
;;   gc,
;;              gint x, gint y, const GdkWChar* text, gint text_length);
;;   void(* draw_drawable
;;   )( GdkDrawable* drawable, GdkGC* gc, GdkDrawable* src, gint xsrc, gint
;;    ysrc, gint xdest, gint ydest, gint width, gint height); void(*
;;   draw_points
;;   )( GdkDrawable* drawable, GdkGC* gc, GdkPoint* points, gint npoints);
;;   void
;;   (* draw_segments)( GdkDrawable* drawable, GdkGC* gc, GdkSegment* segs,
;;              gint nsegs); void(* draw_lines)( GdkDrawable* drawable,
;;   GdkGC* gc, GdkPoint
;;   * points, gint npoints); void(* draw_glyphs)( GdkDrawable* drawable,
;;   GdkGC
;;   * gc, PangoFont* font, gint x, gint y, PangoGlyphString* glyphs); void
;;   (* draw_image)( GdkDrawable* drawable, GdkGC* gc, GdkImage* image,
;;   gint
;;    xsrc, gint ysrc, gint xdest, gint ydest, gint width, gint height);
;;   gint
;;   (* get_depth)( GdkDrawable* drawable); void(* get_size)( GdkDrawable*
;;   drawable,
;;              gint* width, gint* height); void(* set_colormap)(
;;   GdkDrawable* drawable,
;;              GdkColormap* cmap); GdkColormap*(* get_colormap)(
;;   GdkDrawable* drawable
;;   ); GdkVisual*(* get_visual)( GdkDrawable* drawable); GdkImage*(*
;;   get_image
;;   )( GdkDrawable* drawable, gint x, gint y, gint width, gint height);
;;   GdkRegion
;;   *(* get_clip_region)( GdkDrawable* drawable); GdkRegion*(*
;;   get_visible_region
;;   )( GdkDrawable* drawable); GdkDrawable*(* get_composite_drawable)(
;;   GdkDrawable
;;   * drawable, gint x, gint y, gint width, gint height, gint*
;;   composite_x_offset,
;;              gint* composite_y_offset); void(* _draw_pixbuf)(
;;   GdkDrawable* drawable,
;;              GdkGC* gc, GdkPixbuf* pixbuf, gint src_x, gint src_y, gint
;;   dest_x, gint
;;    dest_y, gint width, gint height, GdkRgbDither dither, gint x_dither,
;;   gint
;;    y_dither); GdkImage*(* _copy_to_image)( GdkDrawable* drawable,
;;   GdkImage
;;   * image, gint src_x, gint src_y, gint dest_x, gint dest_y, gint width,
;;              gint height); void(* _gdk_reserved1)( void); void(*
;;   _gdk_reserved2)( void
;;   ); void(* _gdk_reserved3)( void); void(* _gdk_reserved4)( void); void(
;;   * _gdk_reserved5)( void); void(* _gdk_reserved6)( void); void(*
;;   _gdk_reserved7
;;   )( void); void(* _gdk_reserved9)( void); void(* _gdk_reserved10)( void
;;   ); void(* _gdk_reserved11)( void); void(* _gdk_reserved12)( void);
;;   void
;;   (* _gdk_reserved13)( void); void(* _gdk_reserved14)( void); void(*
;;   _gdk_reserved15
;;   )( void); void(* _gdk_reserved16)( void); };
(ff:bind-c-type _GdkDrawableClass (:struct
  (parent_class GObjectClass)   ;; GObjectClass parent_class
  (create_gc ff:function-pointer)   ;;
  ;;  GdkGC*(* create_gc)( GdkDrawable* drawable, GdkGCValues* values, GdkGCValuesMask
  ;;  mask)
  (draw_rectangle ff:function-pointer)   ;;
  ;;  void(* draw_rectangle)( GdkDrawable* drawable, GdkGC* gc, gint filled, gint
  ;;  x, gint y, gint width, gint height)
  (draw_arc ff:function-pointer)   ;;
  ;;  void(* draw_arc)( GdkDrawable* drawable, GdkGC* gc, gint filled, gint x, gint
  ;;  y, gint width, gint height, gint angle1, gint angle2)
  (draw_polygon ff:function-pointer)   ;;
  ;;  void(* draw_polygon)( GdkDrawable* drawable, GdkGC* gc, gint filled, GdkPoint
  ;; * points, gint npoints)
  (draw_text ff:function-pointer)   ;;
  ;;  void(* draw_text)( GdkDrawable* drawable, GdkFont* font, GdkGC* gc, gint x,
  ;;            gint y, const gchar* text, gint text_length)
  (draw_text_wc ff:function-pointer)   ;;
  ;;  void(* draw_text_wc)( GdkDrawable* drawable, GdkFont* font, GdkGC* gc, gint
  ;;  x, gint y, const GdkWChar* text, gint text_length)
  (draw_drawable ff:function-pointer)   ;;
  ;;  void(* draw_drawable)( GdkDrawable* drawable, GdkGC* gc, GdkDrawable* src,
  ;;            gint xsrc, gint ysrc, gint xdest, gint ydest, gint width, gint height
  ;; )
  (draw_points ff:function-pointer)   ;;
  ;;  void(* draw_points)( GdkDrawable* drawable, GdkGC* gc, GdkPoint* points, gint
  ;;  npoints)
  (draw_segments ff:function-pointer)   ;;
  ;;  void(* draw_segments)( GdkDrawable* drawable, GdkGC* gc, GdkSegment* segs,
  ;;            gint nsegs)
  (draw_lines ff:function-pointer)   ;;
  ;;  void(* draw_lines)( GdkDrawable* drawable, GdkGC* gc, GdkPoint* points, gint
  ;;  npoints)
  (draw_glyphs ff:function-pointer)   ;;
  ;;  void(* draw_glyphs)( GdkDrawable* drawable, GdkGC* gc, PangoFont* font, gint
  ;;  x, gint y, PangoGlyphString* glyphs)
  (draw_image ff:function-pointer)   ;;
  ;;  void(* draw_image)( GdkDrawable* drawable, GdkGC* gc, GdkImage* image, gint
  ;;  xsrc, gint ysrc, gint xdest, gint ydest, gint width, gint height)
  (get_depth ff:function-pointer)   ;;
  ;;  gint(* get_depth)( GdkDrawable* drawable)
  (get_size ff:function-pointer)   ;;
  ;;  void(* get_size)( GdkDrawable* drawable, gint* width, gint* height)
  (set_colormap ff:function-pointer)   ;;
  ;;  void(* set_colormap)( GdkDrawable* drawable, GdkColormap* cmap)
  (get_colormap ff:function-pointer)   ;;
  ;;  GdkColormap*(* get_colormap)( GdkDrawable* drawable)
  (get_visual ff:function-pointer)   ;;
  ;;  GdkVisual*(* get_visual)( GdkDrawable* drawable)
  (get_image ff:function-pointer)   ;;
  ;;  GdkImage*(* get_image)( GdkDrawable* drawable, gint x, gint y, gint width, gint
  ;;  height)
  (get_clip_region ff:function-pointer)   ;;
  ;;  GdkRegion*(* get_clip_region)( GdkDrawable* drawable)
  (get_visible_region ff:function-pointer)   ;;
  ;;  GdkRegion*(* get_visible_region)( GdkDrawable* drawable)
  (get_composite_drawable ff:function-pointer)   ;;
  ;;  GdkDrawable*(* get_composite_drawable)( GdkDrawable* drawable, gint x, gint y, gint
  ;;  width, gint height, gint* composite_x_offset, gint* composite_y_offset
  ;; )
  (_draw_pixbuf ff:function-pointer)   ;;
  ;;  void(* _draw_pixbuf)( GdkDrawable* drawable, GdkGC* gc, GdkPixbuf* pixbuf,
  ;;            gint src_x, gint src_y, gint dest_x, gint dest_y, gint width, gint height,
  ;;            GdkRgbDither dither, gint x_dither, gint y_dither)
  (_copy_to_image ff:function-pointer)   ;;
  ;;  GdkImage*(* _copy_to_image)( GdkDrawable* drawable, GdkImage* image, gint src_x,
  ;;            gint src_y, gint dest_x, gint dest_y, gint width, gint height)
  (_gdk_reserved1 ff:function-pointer)   ;; void(* _gdk_reserved1)( void)
  (_gdk_reserved2 ff:function-pointer)   ;; void(* _gdk_reserved2)( void)
  (_gdk_reserved3 ff:function-pointer)   ;; void(* _gdk_reserved3)( void)
  (_gdk_reserved4 ff:function-pointer)   ;; void(* _gdk_reserved4)( void)
  (_gdk_reserved5 ff:function-pointer)   ;; void(* _gdk_reserved5)( void)
  (_gdk_reserved6 ff:function-pointer)   ;; void(* _gdk_reserved6)( void)
  (_gdk_reserved7 ff:function-pointer)   ;; void(* _gdk_reserved7)( void)
  (_gdk_reserved9 ff:function-pointer)   ;; void(* _gdk_reserved9)( void)
  (_gdk_reserved10 ff:function-pointer)   ;; void(* _gdk_reserved10)( void)
  (_gdk_reserved11 ff:function-pointer)   ;; void(* _gdk_reserved11)( void)
  (_gdk_reserved12 ff:function-pointer)   ;; void(* _gdk_reserved12)( void)
  (_gdk_reserved13 ff:function-pointer)   ;; void(* _gdk_reserved13)( void)
  (_gdk_reserved14 ff:function-pointer)   ;; void(* _gdk_reserved14)( void)
  (_gdk_reserved15 ff:function-pointer)   ;; void(* _gdk_reserved15)( void)
  (_gdk_reserved16 ff:function-pointer)   ;; void(* _gdk_reserved16)( void)
  ))   ;; bind-c-type _GdkDrawableClass
(ff:bind-c-typedef GdkDrawableClass
                   _GdkDrawableClass) ;;
;;   final declaration 

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:175 <2018> 
;; GType gdk_drawable_get_type( void);
(ff:bind-c-function gdk_drawable_get_type
     :unconverted-entry-name "gdk_drawable_get_type"
     :c-return-type ("GType")
     :return-type GType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:181 <2019> 
;; void gdk_drawable_set_data( GdkDrawable* drawable, const gchar* key,
;;   gpointer
;;    data, GDestroyNotify destroy_func);
(ff:bind-c-function gdk_drawable_set_data
     :unconverted-entry-name "gdk_drawable_set_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("const" "gchar" "*")
                   ("gpointer") ("GDestroyNotify"))
     :c-arg-names (drawable key data destroy_func)
     :arguments ((* GdkDrawable) (* gchar) gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:185 <2020> 
;; gpointer gdk_drawable_get_data( GdkDrawable* drawable, const gchar*
;;   key);
(ff:bind-c-function gdk_drawable_get_data
     :unconverted-entry-name "gdk_drawable_get_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GdkDrawable" "*") ("const" "gchar" "*"))
     :c-arg-names (drawable key)
     :arguments ((* GdkDrawable) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:189 <2021> 
;; void gdk_drawable_get_size( GdkDrawable* drawable, gint* width, gint*
;;    height);
(ff:bind-c-function gdk_drawable_get_size
     :all-names ((gdk_window_get_size . "gdk_window_get_size")
                 (gdk_drawable_get_size . "gdk_drawable_get_size"))
     :unconverted-entry-name "gdk_drawable_get_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (drawable width height)
     :arguments ((* GdkDrawable) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:192 <2022> 
;; void gdk_drawable_set_colormap( GdkDrawable* drawable, GdkColormap*
;;   colormap
;;   );
(ff:bind-c-function gdk_drawable_set_colormap
     :all-names ((gdk_window_set_colormap . "gdk_window_set_colormap")
                 (gdk_drawable_set_colormap
                  . "gdk_drawable_set_colormap"))
     :unconverted-entry-name "gdk_drawable_set_colormap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkColormap" "*"))
     :c-arg-names (drawable colormap)
     :arguments ((* GdkDrawable) (* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:194 <2023> 
;; GdkColormap* gdk_drawable_get_colormap( GdkDrawable* drawable);
(ff:bind-c-function gdk_drawable_get_colormap
     :all-names ((gdk_window_get_colormap . "gdk_window_get_colormap")
                 (gdk_drawable_get_colormap
                  . "gdk_drawable_get_colormap"))
     :unconverted-entry-name "gdk_drawable_get_colormap"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GdkDrawable" "*"))
     :c-arg-names (drawable)
     :arguments ((* GdkDrawable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:195 <2024> 
;; GdkVisual* gdk_drawable_get_visual( GdkDrawable* drawable);
(ff:bind-c-function gdk_drawable_get_visual
     :all-names ((gdk_window_get_visual . "gdk_window_get_visual")
                 (gdk_drawable_get_visual . "gdk_drawable_get_visual"))
     :unconverted-entry-name "gdk_drawable_get_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("GdkDrawable" "*"))
     :c-arg-names (drawable)
     :arguments ((* GdkDrawable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:196 <2025> 
;; gint gdk_drawable_get_depth( GdkDrawable* drawable);
(ff:bind-c-function gdk_drawable_get_depth
     :unconverted-entry-name "gdk_drawable_get_depth"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkDrawable" "*"))
     :c-arg-names (drawable)
     :arguments ((* GdkDrawable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:199 <2026> 
;; GdkDrawable* gdk_drawable_ref( GdkDrawable* drawable);
(ff:bind-c-function gdk_drawable_ref
     :all-names ((gdk_bitmap_ref . "gdk_bitmap_ref")
                 (gdk_window_ref . "gdk_window_ref")
                 (gdk_pixmap_ref . "gdk_pixmap_ref")
                 (gdk_drawable_ref . "gdk_drawable_ref"))
     :unconverted-entry-name "gdk_drawable_ref"
     :c-return-type ("GdkDrawable" "*")
     :return-type (* GdkDrawable)
     :c-arg-types (("GdkDrawable" "*"))
     :c-arg-names (drawable)
     :arguments ((* GdkDrawable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:200 <2027> 
;; void gdk_drawable_unref( GdkDrawable* drawable);
(ff:bind-c-function gdk_drawable_unref
     :all-names ((gdk_pixmap_unref . "gdk_pixmap_unref")
                 (gdk_window_unref . "gdk_window_unref")
                 (gdk_bitmap_unref . "gdk_bitmap_unref")
                 (gdk_drawable_unref . "gdk_drawable_unref"))
     :unconverted-entry-name "gdk_drawable_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*"))
     :c-arg-names (drawable)
     :arguments ((* GdkDrawable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:205 <2028> 
;; void gdk_draw_point( GdkDrawable* drawable, GdkGC* gc, gint x, gint y);
(ff:bind-c-function gdk_draw_point
     :unconverted-entry-name "gdk_draw_point"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint"))
     :c-arg-names (drawable gc x y)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:209 <2029> 
;; void gdk_draw_line( GdkDrawable* drawable, GdkGC* gc, gint x1, gint y1,
;;              gint x2, gint y2);
(ff:bind-c-function gdk_draw_line
     :unconverted-entry-name "gdk_draw_line"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint"))
     :c-arg-names (drawable gc x1 y1 x2 y2)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:215 <2030> 
;; void gdk_draw_rectangle( GdkDrawable* drawable, GdkGC* gc, gint filled,
;;              gint x, gint y, gint width, gint height);
(ff:bind-c-function gdk_draw_rectangle
     :unconverted-entry-name "gdk_draw_rectangle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc filled x y width height)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:222 <2031> 
;; void gdk_draw_arc( GdkDrawable* drawable, GdkGC* gc, gint filled, gint
;;    x, gint y, gint width, gint height, gint angle1, gint angle2);
(ff:bind-c-function gdk_draw_arc
     :unconverted-entry-name "gdk_draw_arc"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc filled x y width height angle1 angle2)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint gint
                 gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:231 <2032> 
;; void gdk_draw_polygon( GdkDrawable* drawable, GdkGC* gc, gint filled,
;;              GdkPoint* points, gint npoints);
(ff:bind-c-function gdk_draw_polygon
     :unconverted-entry-name "gdk_draw_polygon"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint")
                   ("GdkPoint" "*") ("gint"))
     :c-arg-names (drawable gc filled points npoints)
     :arguments ((* GdkDrawable) (* GdkGC) gint (* GdkPoint) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:237 <2033> 
;; void gdk_draw_string( GdkDrawable* drawable, GdkFont* font, GdkGC* gc,
;;              gint x, gint y, const gchar* string);
(ff:bind-c-function gdk_draw_string
     :unconverted-entry-name "gdk_draw_string"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkFont" "*") ("GdkGC" "*")
                   ("gint") ("gint") ("const" "gchar" "*"))
     :c-arg-names (drawable font gc x y string)
     :arguments ((* GdkDrawable) (* GdkFont) (* GdkGC) gint gint
                 (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:243 <2034> 
;; void gdk_draw_text( GdkDrawable* drawable, GdkFont* font, GdkGC* gc,
;;   gint
;;    x, gint y, const gchar* text, gint text_length);
(ff:bind-c-function gdk_draw_text
     :unconverted-entry-name "gdk_draw_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkFont" "*") ("GdkGC" "*")
                   ("gint") ("gint") ("const" "gchar" "*") ("gint"))
     :c-arg-names (drawable font gc x y text text_length)
     :arguments ((* GdkDrawable) (* GdkFont) (* GdkGC) gint gint
                 (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk2/fritter/i/include/gtk-2.0/gdk/gdkdrawable.h:250 <2035> 
;; void gdk_draw_text_wc( GdkDrawable* drawable, GdkFont* font, GdkGC* gc,
;;              gint x, gint y, const GdkWChar* text, gint text_length);
(ff:bind-c-function gdk_draw_text_wc
     :unconverted-entry-name "gdk_draw_text_wc"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkFont" "*") ("GdkGC" "*")
                   ("gint") ("gint") ("const" "GdkWChar" "*") ("gint"))
  