;; This is an automatically generated file.  Make changes in
;; the definition file, not here.

(defpackage :swig.opengl
  (:use :common-lisp :ff :excl)
  (:export #:*swig-identifier-converter* #:*swig-module-name*
           #:*void* #:*swig-expoert-list*))
(in-package :swig.opengl)

(eval-when (compile load eval)
  (defparameter *swig-identifier-converter* 'identifier-convert-null)
  (defparameter *swig-module-name* :opengl))

(defpackage :opengl
  (:use :common-lisp :swig.opengl :ff :excl))


;; $Id: opengl.cl,v 1.2 2007/05/04 18:12:29 mikel Exp $

(eval-when (compile load eval)

;;; You can define your own identifier converter if you want.
;;; Use the -identifier-converter command line argument to
;;; specify its name.

(eval-when (:compile-toplevel :load-toplevel :execute)
   (cl::defparameter *swig-export-list* nil))

(cl::defconstant *void* :..void..)

;; parsers to aid in finding SWIG definitions in files.
(cl::defun scm-p1 (form)
  (let* ((info (cl::second form))
	 (id (car info))
	 (id-args (if (eq (cl::car form) 'swig-dispatcher)
		      (cl::cdr info)
		      (cl::cddr info))))
    (cl::apply *swig-identifier-converter* id 
	   (cl::progn (cl::when (cl::eq (cl::car form) 'swig-dispatcher)
		    (cl::remf id-args :arities))
		  id-args))))

(cl::defmacro defswig1 (name (&rest args) &body body)
  `(cl::progn (cl::defmacro ,name ,args
	    ,@body)
	  (excl::define-simple-parser ,name scm-p1)) )

(cl::defmacro defswig2 (name (&rest args) &body body)
  `(cl::progn (cl::defmacro ,name ,args
	    ,@body)
	  (excl::define-simple-parser ,name second)))

(defun read-symbol-from-string (string)
  (cl::multiple-value-bind (result position)
      (cl::read-from-string string nil "eof" :preserve-whitespace t)
    (cl::if (cl::and (cl::symbolp result)
    	             (cl::eql position (cl::length string)))
        result
	(cl::multiple-value-bind (sym)
	    (cl::intern string)
	  sym))))

(cl::defun full-name (id type arity class)
  (cl::case type
    (:getter (cl::format nil "~@[~A_~]~A" class id))
    (:constructor (cl::format nil "new_~A~@[~A~]" id arity))
    (:destructor (cl::format nil "delete_~A" id))
    (:type (cl::format nil "ff_~A" id))
    (:slot id)
    (:ff-operator (cl::format nil "ffi_~A" id))
    (otherwise (cl::format nil "~@[~A_~]~A~@[~A~]"
                       class id arity))))
  
(cl::defun identifier-convert-null (id &key type class arity)
  (cl::if (cl::eq type :setter)
      `(cl::setf ,(identifier-convert-null
               id :type :getter :class class :arity arity))
      (read-symbol-from-string (full-name id type arity class))))

(cl::defun identifier-convert-lispify (cname &key type class arity)
  (cl::assert (cl::stringp cname))
  (cl::when (cl::eq type :setter)
    (cl::return-from identifier-convert-lispify
      `(cl::setf ,(identifier-convert-lispify
               cname :type :getter :class class :arity arity))))
  (cl::setq cname (full-name cname type arity class))
  (cl::if (cl::eq type :constant)
      (cl::setf cname (cl::format nil "*~A*" cname)))
  (cl::setf cname (excl::replace-regexp cname "_" "-"))
  (cl::let ((lastcase :other)
       	    newcase char res)
    (cl::dotimes (n (cl::length cname))
      (cl::setf char (cl::schar cname n))
      (excl::if* (cl::alpha-char-p char)
         then
              (cl::setf newcase (cl::if (cl::upper-case-p char) :upper :lower))

              (cl::when (cl::or (cl::and (cl::eq lastcase :upper)
	      				 (cl::eq newcase :lower))
                                (cl::and (cl::eq lastcase :lower)
					 (cl::eq newcase :upper)))
                ;; case change... add a dash
                (cl::push #\- res)
                (cl::setf newcase :other))

              (cl::push (cl::char-downcase char) res)

              (cl::setf lastcase newcase)

         else
              (cl::push char res)
              (cl::setf lastcase :other)))
    (read-symbol-from-string (cl::coerce (cl::nreverse res) 'string))))

(cl::defun id-convert-and-export (name &rest kwargs)
  (cl::multiple-value-bind (symbol package)
      (cl::apply *swig-identifier-converter* name kwargs)
    (cl::let ((args (cl::list (cl::if (cl::consp symbol)
    	     	    	         (cl::cadr symbol) symbol)
                      (cl::or package cl::*package*))))
      (cl::apply #'cl::export args)
      (cl::pushnew args *swig-export-list*))
    symbol))

(cl::defmacro swig-insert-id (name namespace &key (type :type) class)
  `(cl::let ((cl::*package* (cl::find-package ,(package-name-for-namespace namespace))))
    (id-convert-and-export ,name :type ,type :class ,class)))

(defswig2 swig-defconstant (string value)
  (cl::let ((symbol (id-convert-and-export string :type :constant)))
    `(cl::eval-when (compile load eval)
       (cl::defconstant ,symbol ,value))))

(cl::defun maybe-reorder-args (funcname arglist)
  ;; in the foreign setter function the new value will be the last argument
  ;; in Lisp it needs to be the first
  (cl::if (cl::consp funcname)
      (cl::append (cl::last arglist) (cl::butlast arglist))
      arglist))

(cl::defun maybe-return-value (funcname arglist)
  ;; setf functions should return the new value
  (cl::when (cl::consp funcname)
    `(,(cl::if (cl::consp (cl::car arglist))
           (cl::caar arglist)
           (cl::car arglist)))))

(cl::defun swig-anyvarargs-p (arglist)
  (cl::member :SWIG__varargs_ arglist))

(defswig1 swig-defun ((name &optional (mangled-name name)
                            &key (type :operator) class arity)
                      arglist kwargs
		      &body body)
  (cl::let* ((symbol (id-convert-and-export name :type type
                          :arity arity :class class))
             (mangle (excl::if* (cl::string-equal name mangled-name)
                      then (id-convert-and-export 
				    (cl::cond
					  ((cl::eq type :setter) (cl::format nil "~A-set" name))
					  ((cl::eq type :getter) (cl::format nil "~A-get" name))
					  (t name))
				    :type :ff-operator :arity arity :class class)
                      else (cl::intern mangled-name)))
         (defun-args (maybe-reorder-args
                      symbol
		      (cl::mapcar #'cl::car (cl::and (cl::not (cl::equal arglist '(:void)))
					 (cl::loop as i in arglist
					       when (cl::eq (cl::car i) :p+)
					       collect (cl::cdr i))))))
	 (ffargs (cl::if (cl::equal arglist '(:void))
	 	      arglist
		    (cl::mapcar #'cl::cdr arglist)))
	 )
    (cl::when (swig-anyvarargs-p ffargs)
      (cl::setq ffargs '()))
    `(cl::eval-when (compile load eval)
       (excl::compiler-let ((*record-xref-info* nil))
         (ff:def-foreign-call (,mangle ,mangled-name) ,ffargs ,@kwargs))
       (cl::macrolet ((swig-ff-call (&rest args)
                      (cl::cons ',mangle args)))
         (cl::defun ,symbol ,defun-args
           ,@body
           ,@(maybe-return-value symbol defun-args))))))

(defswig1 swig-defmethod ((name &optional (mangled-name name)
	  	                &key (type :operator) class arity)
                          ffargs kwargs
                          &body body)
  (cl::let* ((symbol (id-convert-and-export name :type type
                          :arity arity :class class))
         (mangle (cl::intern mangled-name))
         (defmethod-args (maybe-reorder-args
                          symbol
                          (cl::unless (cl::equal ffargs '(:void))
                            (cl::loop for (lisparg name dispatch) in ffargs
			    	  when (eq lisparg :p+)
                                  collect `(,name ,dispatch)))))
         (ffargs (cl::if (cl::equal ffargs '(:void))
                     ffargs
                     (cl::loop for (nil name nil . ffi) in ffargs
                           collect `(,name ,@ffi)))))
    `(cl::eval-when (compile load eval)
       (excl::compiler-let ((*record-xref-info* nil))
         (ff:def-foreign-call (,mangle ,mangled-name) ,ffargs ,@kwargs))
       (cl::macrolet ((swig-ff-call (&rest args)
                      (cl::cons ',mangle args)))
         (cl::defmethod ,symbol ,defmethod-args
           ,@body
           ,@(maybe-return-value symbol defmethod-args))))))

(defswig1 swig-dispatcher ((name &key (type :operator) class arities))
  (cl::let ((symbol (id-convert-and-export name
                         :type type :class class)))
    `(cl::eval-when (compile load eval)
       (cl::defun ,symbol (&rest args)
         (cl::case (cl::length args)
           ,@(cl::loop for arity in arities
                   for symbol-n = (id-convert-and-export name
                                           :type type :class class :arity arity)
                   collect `(,arity (cl::apply #',symbol-n args)))
	   (t (cl::error "No applicable wrapper-methods for foreign call ~a with args ~a of classes ~a" ',symbol args (cl::mapcar #'(cl::lambda (x) (cl::class-name (cl::class-of x))) args)))
	   )))))

(defswig2 swig-def-foreign-stub (name)
  (cl::let ((lsymbol (id-convert-and-export name :type :class))
	    (symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (compile load eval)
	(ff:def-foreign-type ,symbol (:class ))
	(cl::defclass ,lsymbol (ff:foreign-pointer) ()))))

(defswig2 swig-def-foreign-class (name supers &rest rest)
  (cl::let ((lsymbol (id-convert-and-export name :type :class))
	    (symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (compile load eval)
       (ff:def-foreign-type ,symbol ,@rest)
       (cl::defclass ,lsymbol ,supers
	 ((foreign-type :initform ',symbol :initarg :foreign-type
			:accessor foreign-pointer-type))))))

(defswig2 swig-def-foreign-type (name &rest rest)
  (cl::let ((symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (compile load eval)
       (ff:def-foreign-type ,symbol ,@rest))))

(defswig2 swig-def-synonym-type (synonym of ff-synonym)
  `(cl::eval-when (compile load eval)
     (cl::setf (cl::find-class ',synonym) (cl::find-class ',of))
     (ff:def-foreign-type ,ff-synonym (:struct ))))

(cl::defun package-name-for-namespace (namespace)
  (excl::list-to-delimited-string
   (cl::cons *swig-module-name*
         (cl::mapcar #'(cl::lambda (name)
                     (cl::string
                      (cl::funcall *swig-identifier-converter*
                               name
                               :type :namespace)))
                 namespace))
   "."))

(cl::defmacro swig-defpackage (namespace)
  (cl::let* ((parent-namespaces (cl::maplist #'cl::reverse (cl::cdr (cl::reverse namespace))))
             (parent-strings (cl::mapcar #'package-name-for-namespace
                                 parent-namespaces))
             (string (package-name-for-namespace namespace)))
    `(cl::eval-when (compile load eval)
      (cl::defpackage ,string
        (:use :swig :ff #+ignore '(:common-lisp :ff :excl)
              ,@parent-strings ,*swig-module-name*)
	(:import-from :cl :* :nil :t)))))

(cl::defmacro swig-in-package (namespace)
  `(cl::eval-when (compile load eval)
    (cl::in-package ,(package-name-for-namespace namespace))))

(defswig2 swig-defvar (name mangled-name &key type (ftype :unsigned-natural))
  (cl::let ((symbol (id-convert-and-export name :type type)))
    `(cl::eval-when (compile load eval)
      (ff:def-foreign-variable (,symbol ,mangled-name) :type ,ftype))))

) ;; eval-when

(cl::eval-when (compile eval)
  (cl::flet ((starts-with-p (str prefix)
              (cl::and (cl::>= (cl::length str) (cl::length prefix))
                (cl::string= str prefix :end1 (cl::length prefix)))))
    (cl::export (cl::loop for sym being each present-symbol of cl::*package*
                  when (cl::or (starts-with-p (cl::symbol-name sym) (cl::symbol-name :swig-))
                           (starts-with-p (cl::symbol-name sym) (cl::symbol-name :identifier-convert-)))
                  collect sym))))



;; typical locations are /usr/lib and /usr/X11R6/lib.
#+linux
(progn
  (load "libGL.so")
  (load "libGLU.so")
  (load "libXi.so")
  (load "libXmu.so"))
#+mswindows
(progn
  (load "opengl32.dll")
  (load "glu32.dll"))
#+macosx
(progn
  (load "/System/Library/Frameworks/OpenGL.framework/OpenGL" :foreign t)
  (load "/System/Library/Frameworks/GLUT.framework/GLUT" :foreign t)
 )


(in-package :opengl)
(swig-def-foreign-type "GLenum"
  :unsigned-int)
(swig-def-foreign-type "GLboolean"
  :unsigned-char)
(swig-def-foreign-type "GLbitfield"
  :unsigned-int)
(swig-def-foreign-type "GLbyte"
  :char)
(swig-def-foreign-type "GLshort"
  :short)
(swig-def-foreign-type "GLint"
  :int)
(swig-def-foreign-type "GLsizei"
  :int)
(swig-def-foreign-type "GLubyte"
  :unsigned-char)
(swig-def-foreign-type "GLushort"
  :unsigned-short)
(swig-def-foreign-type "GLuint"
  :unsigned-int)
(swig-def-foreign-type "GLfloat"
  :float)
(swig-def-foreign-type "GLclampf"
  :float)
(swig-def-foreign-type "GLdouble"
  :double)
(swig-def-foreign-type "GLclampd"
  :double)
(swig-def-foreign-type "GLvoid"
  :void)
(swig-def-foreign-type "PFNGLARRAYELEMENTEXTPROC"
  (* (:function (#.(swig-insert-id "GLint" () :type :type) ) :void)))
(swig-def-foreign-type "PFNGLDRAWARRAYSEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLint" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) ) :void)))
(swig-def-foreign-type "PFNGLVERTEXPOINTEREXTPROC"
  (* (:function (#.(swig-insert-id "GLint" () :type :type) #.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLNORMALPOINTEREXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLCOLORPOINTEREXTPROC"
  (* (:function (#.(swig-insert-id "GLint" () :type :type) #.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLINDEXPOINTEREXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLTEXCOORDPOINTEREXTPROC"
  (* (:function (#.(swig-insert-id "GLint" () :type :type) #.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLEDGEFLAGPOINTEREXTPROC"
  (* (:function (#.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) (* #.(swig-insert-id "GLboolean" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLGETPOINTERVEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) (* (* #.(swig-insert-id "GLvoid" () :type :type))) ) :void)))
(swig-def-foreign-type "PFNGLARRAYELEMENTARRAYEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLDRAWRANGEELEMENTSWINPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLuint" () :type :type) #.(swig-insert-id "GLuint" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLenum" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLADDSWAPHINTRECTWINPROC"
  (* (:function (#.(swig-insert-id "GLint" () :type :type) #.(swig-insert-id "GLint" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) ) :void)))
(swig-def-foreign-type "PFNGLCOLORTABLEEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLenum" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLCOLORSUBTABLEEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLsizei" () :type :type) #.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLenum" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLGETCOLORTABLEEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLenum" () :type :type) (* #.(swig-insert-id "GLvoid" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLGETCOLORTABLEPARAMETERIVEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLenum" () :type :type) (* #.(swig-insert-id "GLint" () :type :type)) ) :void)))
(swig-def-foreign-type "PFNGLGETCOLORTABLEPARAMETERFVEXTPROC"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) #.(swig-insert-id "GLenum" () :type :type) (* #.(swig-insert-id "GLfloat" () :type :type)) ) :void)))
(swig-def-foreign-type "GLUnurbs"
  (* :void))
(swig-def-foreign-type "GLUquadric"
  (* :void))
(swig-def-foreign-type "GLUtesselator"
  (* :void))
(swig-def-foreign-type "GLUnurbsObj"
  (* :void))
(swig-def-foreign-type "GLUquadricObj"
  (* :void))
(swig-def-foreign-type "GLUtesselatorObj"
  (* :void))
(swig-def-foreign-type "GLUtriangulatorObj"
  (* :void))
(swig-def-foreign-type "GLUquadricErrorProc"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) ) :void)))
(swig-def-foreign-type "GLUtessBeginProc"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) ) :void)))
(swig-def-foreign-type "GLUtessEdgeFlagProc"
  (* (:function (#.(swig-insert-id "GLboolean" () :type :type) ) :void)))
(swig-def-foreign-type "GLUtessVertexProc"
  (* (:function ((* :void) ) :void)))
(swig-def-foreign-type "GLUtessEndProc"
  (* (:function (:void ) :void)))
(swig-def-foreign-type "GLUtessErrorProc"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) ) :void)))
(swig-def-foreign-type "GLUtessCombineProc"
  (* (:function ((:array #.(swig-insert-id "GLdouble" () :type :type) 3) (:array (* :void) 4) (:array #.(swig-insert-id "GLfloat" () :type :type) 4) (* (* :void)) ) :void)))
(swig-def-foreign-type "GLUtessBeginDataProc"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) (* :void) ) :void)))
(swig-def-foreign-type "GLUtessEdgeFlagDataProc"
  (* (:function (#.(swig-insert-id "GLboolean" () :type :type) (* :void) ) :void)))
(swig-def-foreign-type "GLUtessVertexDataProc"
  (* (:function ((* :void) (* :void) ) :void)))
(swig-def-foreign-type "GLUtessEndDataProc"
  (* (:function ((* :void) ) :void)))
(swig-def-foreign-type "GLUtessErrorDataProc"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) (* :void) ) :void)))
(swig-def-foreign-type "GLUtessCombineDataProc"
  (* (:function ((:array #.(swig-insert-id "GLdouble" () :type :type) 3) (:array (* :void) 4) (:array #.(swig-insert-id "GLfloat" () :type :type) 4) (* (* :void)) (* :void) ) :void)))
(swig-def-foreign-type "GLUnurbsErrorProc"
  (* (:function (#.(swig-insert-id "GLenum" () :type :type) ) :void)))

(swig-in-package ())

(swig-defconstant "GL_VERSION_1_1" 1)
(swig-defconstant "GL_ACCUM" #x0100)
(swig-defconstant "GL_LOAD" #x0101)
(swig-defconstant "GL_RETURN" #x0102)
(swig-defconstant "GL_MULT" #x0103)
(swig-defconstant "GL_ADD" #x0104)
(swig-defconstant "GL_NEVER" #x0200)
(swig-defconstant "GL_LESS" #x0201)
(swig-defconstant "GL_EQUAL" #x0202)
(swig-defconstant "GL_LEQUAL" #x0203)
(swig-defconstant "GL_GREATER" #x0204)
(swig-defconstant "GL_NOTEQUAL" #x0205)
(swig-defconstant "GL_GEQUAL" #x0206)
(swig-defconstant "GL_ALWAYS" #x0207)
(swig-defconstant "GL_CURRENT_BIT" #x00000001)
(swig-defconstant "GL_POINT_BIT" #x00000002)
(swig-defconstant "GL_LINE_BIT" #x00000004)
(swig-defconstant "GL_POLYGON_BIT" #x00000008)
(swig-defconstant "GL_POLYGON_STIPPLE_BIT" #x00000010)
(swig-defconstant "GL_PIXEL_MODE_BIT" #x00000020)
(swig-defconstant "GL_LIGHTING_BIT" #x00000040)
(swig-defconstant "GL_FOG_BIT" #x00000080)
(swig-defconstant "GL_DEPTH_BUFFER_BIT" #x00000100)
(swig-defconstant "GL_ACCUM_BUFFER_BIT" #x00000200)
(swig-defconstant "GL_STENCIL_BUFFER_BIT" #x00000400)
(swig-defconstant "GL_VIEWPORT_BIT" #x00000800)
(swig-defconstant "GL_TRANSFORM_BIT" #x00001000)
(swig-defconstant "GL_ENABLE_BIT" #x00002000)
(swig-defconstant "GL_COLOR_BUFFER_BIT" #x00004000)
(swig-defconstant "GL_HINT_BIT" #x00008000)
(swig-defconstant "GL_EVAL_BIT" #x00010000)
(swig-defconstant "GL_LIST_BIT" #x00020000)
(swig-defconstant "GL_TEXTURE_BIT" #x00040000)
(swig-defconstant "GL_SCISSOR_BIT" #x00080000)
(swig-defconstant "GL_ALL_ATTRIB_BITS" #x000fffff)
(swig-defconstant "GL_POINTS" #x0000)
(swig-defconstant "GL_LINES" #x0001)
(swig-defconstant "GL_LINE_LOOP" #x0002)
(swig-defconstant "GL_LINE_STRIP" #x0003)
(swig-defconstant "GL_TRIANGLES" #x0004)
(swig-defconstant "GL_TRIANGLE_STRIP" #x0005)
(swig-defconstant "GL_TRIANGLE_FAN" #x0006)
(swig-defconstant "GL_QUADS" #x0007)
(swig-defconstant "GL_QUAD_STRIP" #x0008)
(swig-defconstant "GL_POLYGON" #x0009)
(swig-defconstant "GL_ZERO" 0)
(swig-defconstant "GL_ONE" 1)
(swig-defconstant "GL_SRC_COLOR" #x0300)
(swig-defconstant "GL_ONE_MINUS_SRC_COLOR" #x0301)
(swig-defconstant "GL_SRC_ALPHA" #x0302)
(swig-defconstant "GL_ONE_MINUS_SRC_ALPHA" #x0303)
(swig-defconstant "GL_DST_ALPHA" #x0304)
(swig-defconstant "GL_ONE_MINUS_DST_ALPHA" #x0305)
(swig-defconstant "GL_DST_COLOR" #x0306)
(swig-defconstant "GL_ONE_MINUS_DST_COLOR" #x0307)
(swig-defconstant "GL_SRC_ALPHA_SATURATE" #x0308)
(swig-defconstant "GL_TRUE" 1)
(swig-defconstant "GL_FALSE" 0)
(swig-defconstant "GL_CLIP_PLANE0" #x3000)
(swig-defconstant "GL_CLIP_PLANE1" #x3001)
(swig-defconstant "GL_CLIP_PLANE2" #x3002)
(swig-defconstant "GL_CLIP_PLANE3" #x3003)
(swig-defconstant "GL_CLIP_PLANE4" #x3004)
(swig-defconstant "GL_CLIP_PLANE5" #x3005)
(swig-defconstant "GL_BYTE" #x1400)
(swig-defconstant "GL_UNSIGNED_BYTE" #x1401)
(swig-defconstant "GL_SHORT" #x1402)
(swig-defconstant "GL_UNSIGNED_SHORT" #x1403)
(swig-defconstant "GL_INT" #x1404)
(swig-defconstant "GL_UNSIGNED_INT" #x1405)
(swig-defconstant "GL_FLOAT" #x1406)
(swig-defconstant "GL_2_BYTES" #x1407)
(swig-defconstant "GL_3_BYTES" #x1408)
(swig-defconstant "GL_4_BYTES" #x1409)
(swig-defconstant "GL_DOUBLE" #x140A)
(swig-defconstant "GL_NONE" 0)
(swig-defconstant "GL_FRONT_LEFT" #x0400)
(swig-defconstant "GL_FRONT_RIGHT" #x0401)
(swig-defconstant "GL_BACK_LEFT" #x0402)
(swig-defconstant "GL_BACK_RIGHT" #x0403)
(swig-defconstant "GL_FRONT" #x0404)
(swig-defconstant "GL_BACK" #x0405)
(swig-defconstant "GL_LEFT" #x0406)
(swig-defconstant "GL_RIGHT" #x0407)
(swig-defconstant "GL_FRONT_AND_BACK" #x0408)
(swig-defconstant "GL_AUX0" #x0409)
(swig-defconstant "GL_AUX1" #x040A)
(swig-defconstant "GL_AUX2" #x040B)
(swig-defconstant "GL_AUX3" #x040C)
(swig-defconstant "GL_NO_ERROR" 0)
(swig-defconstant "GL_INVALID_ENUM" #x0500)
(swig-defconstant "GL_INVALID_VALUE" #x0501)
(swig-defconstant "GL_INVALID_OPERATION" #x0502)
(swig-defconstant "GL_STACK_OVERFLOW" #x0503)
(swig-defconstant "GL_STACK_UNDERFLOW" #x0504)
(swig-defconstant "GL_OUT_OF_MEMORY" #x0505)
(swig-defconstant "GL_2D" #x0600)
(swig-defconstant "GL_3D" #x0601)
(swig-defconstant "GL_3D_COLOR" #x0602)
(swig-defconstant "GL_3D_COLOR_TEXTURE" #x0603)
(swig-defconstant "GL_4D_COLOR_TEXTURE" #x0604)
(swig-defconstant "GL_PASS_THROUGH_TOKEN" #x0700)
(swig-defconstant "GL_POINT_TOKEN" #x0701)
(swig-defconstant "GL_LINE_TOKEN" #x0702)
(swig-defconstant "GL_POLYGON_TOKEN" #x0703)
(swig-defconstant "GL_BITMAP_TOKEN" #x0704)
(swig-defconstant "GL_DRAW_PIXEL_TOKEN" #x0705)
(swig-defconstant "GL_COPY_PIXEL_TOKEN" #x0706)
(swig-defconstant "GL_LINE_RESET_TOKEN" #x0707)
(swig-defconstant "GL_EXP" #x0800)
(swig-defconstant "GL_EXP2" #x0801)
(swig-defconstant "GL_CW" #x0900)
(swig-defconstant "GL_CCW" #x0901)
(swig-defconstant "GL_COEFF" #x0A00)
(swig-defconstant "GL_ORDER" #x0A01)
(swig-defconstant "GL_DOMAIN" #x0A02)
(swig-defconstant "GL_CURRENT_COLOR" #x0B00)
(swig-defconstant "GL_CURRENT_INDEX" #x0B01)
(swig-defconstant "GL_CURRENT_NORMAL" #x0B02)
(swig-defconstant "GL_CURRENT_TEXTURE_COORDS" #x0B03)
(swig-defconstant "GL_CURRENT_RASTER_COLOR" #x0B04)
(swig-defconstant "GL_CURRENT_RASTER_INDEX" #x0B05)
(swig-defconstant "GL_CURRENT_RASTER_TEXTURE_COORDS" #x0B06)
(swig-defconstant "GL_CURRENT_RASTER_POSITION" #x0B07)
(swig-defconstant "GL_CURRENT_RASTER_POSITION_VALID" #x0B08)
(swig-defconstant "GL_CURRENT_RASTER_DISTANCE" #x0B09)
(swig-defconstant "GL_POINT_SMOOTH" #x0B10)
(swig-defconstant "GL_POINT_SIZE" #x0B11)
(swig-defconstant "GL_POINT_SIZE_RANGE" #x0B12)
(swig-defconstant "GL_POINT_SIZE_GRANULARITY" #x0B13)
(swig-defconstant "GL_LINE_SMOOTH" #x0B20)
(swig-defconstant "GL_LINE_WIDTH" #x0B21)
(swig-defconstant "GL_LINE_WIDTH_RANGE" #x0B22)
(swig-defconstant "GL_LINE_WIDTH_GRANULARITY" #x0B23)
(swig-defconstant "GL_LINE_STIPPLE" #x0B24)
(swig-defconstant "GL_LINE_STIPPLE_PATTERN" #x0B25)
(swig-defconstant "GL_LINE_STIPPLE_REPEAT" #x0B26)
(swig-defconstant "GL_LIST_MODE" #x0B30)
(swig-defconstant "GL_MAX_LIST_NESTING" #x0B31)
(swig-defconstant "GL_LIST_BASE" #x0B32)
(swig-defconstant "GL_LIST_INDEX" #x0B33)
(swig-defconstant "GL_POLYGON_MODE" #x0B40)
(swig-defconstant "GL_POLYGON_SMOOTH" #x0B41)
(swig-defconstant "GL_POLYGON_STIPPLE" #x0B42)
(swig-defconstant "GL_EDGE_FLAG" #x0B43)
(swig-defconstant "GL_CULL_FACE" #x0B44)
(swig-defconstant "GL_CULL_FACE_MODE" #x0B45)
(swig-defconstant "GL_FRONT_FACE" #x0B46)
(swig-defconstant "GL_LIGHTING" #x0B50)
(swig-defconstant "GL_LIGHT_MODEL_LOCAL_VIEWER" #x0B51)
(swig-defconstant "GL_LIGHT_MODEL_TWO_SIDE" #x0B52)
(swig-defconstant "GL_LIGHT_MODEL_AMBIENT" #x0B53)
(swig-defconstant "GL_SHADE_MODEL" #x0B54)
(swig-defconstant "GL_COLOR_MATERIAL_FACE" #x0B55)
(swig-defconstant "GL_COLOR_MATERIAL_PARAMETER" #x0B56)
(swig-defconstant "GL_COLOR_MATERIAL" #x0B57)
(swig-defconstant "GL_FOG" #x0B60)
(swig-defconstant "GL_FOG_INDEX" #x0B61)
(swig-defconstant "GL_FOG_DENSITY" #x0B62)
(swig-defconstant "GL_FOG_START" #x0B63)
(swig-defconstant "GL_FOG_END" #x0B64)
(swig-defconstant "GL_FOG_MODE" #x0B65)
(swig-defconstant "GL_FOG_COLOR" #x0B66)
(swig-defconstant "GL_DEPTH_RANGE" #x0B70)
(swig-defconstant "GL_DEPTH_TEST" #x0B71)
(swig-defconstant "GL_DEPTH_WRITEMASK" #x0B72)
(swig-defconstant "GL_DEPTH_CLEAR_VALUE" #x0B73)
(swig-defconstant "GL_DEPTH_FUNC" #x0B74)
(swig-defconstant "GL_ACCUM_CLEAR_VALUE" #x0B80)
(swig-defconstant "GL_STENCIL_TEST" #x0B90)
(swig-defconstant "GL_STENCIL_CLEAR_VALUE" #x0B91)
(swig-defconstant "GL_STENCIL_FUNC" #x0B92)
(swig-defconstant "GL_STENCIL_VALUE_MASK" #x0B93)
(swig-defconstant "GL_STENCIL_FAIL" #x0B94)
(swig-defconstant "GL_STENCIL_PASS_DEPTH_FAIL" #x0B95)
(swig-defconstant "GL_STENCIL_PASS_DEPTH_PASS" #x0B96)
(swig-defconstant "GL_STENCIL_REF" #x0B97)
(swig-defconstant "GL_STENCIL_WRITEMASK" #x0B98)
(swig-defconstant "GL_MATRIX_MODE" #x0BA0)
(swig-defconstant "GL_NORMALIZE" #x0BA1)
(swig-defconstant "GL_VIEWPORT" #x0BA2)
(swig-defconstant "GL_MODELVIEW_STACK_DEPTH" #x0BA3)
(swig-defconstant "GL_PROJECTION_STACK_DEPTH" #x0BA4)
(swig-defconstant "GL_TEXTURE_STACK_DEPTH" #x0BA5)
(swig-defconstant "GL_MODELVIEW_MATRIX" #x0BA6)
(swig-defconstant "GL_PROJECTION_MATRIX" #x0BA7)
(swig-defconstant "GL_TEXTURE_MATRIX" #x0BA8)
(swig-defconstant "GL_ATTRIB_STACK_DEPTH" #x0BB0)
(swig-defconstant "GL_CLIENT_ATTRIB_STACK_DEPTH" #x0BB1)
(swig-defconstant "GL_ALPHA_TEST" #x0BC0)
(swig-defconstant "GL_ALPHA_TEST_FUNC" #x0BC1)
(swig-defconstant "GL_ALPHA_TEST_REF" #x0BC2)
(swig-defconstant "GL_DITHER" #x0BD0)
(swig-defconstant "GL_BLEND_DST" #x0BE0)
(swig-defconstant "GL_BLEND_SRC" #x0BE1)
(swig-defconstant "GL_BLEND" #x0BE2)
(swig-defconstant "GL_LOGIC_OP_MODE" #x0BF0)
(swig-defconstant "GL_INDEX_LOGIC_OP" #x0BF1)
(swig-defconstant "GL_COLOR_LOGIC_OP" #x0BF2)
(swig-defconstant "GL_AUX_BUFFERS" #x0C00)
(swig-defconstant "GL_DRAW_BUFFER" #x0C01)
(swig-defconstant "GL_READ_BUFFER" #x0C02)
(swig-defconstant "GL_SCISSOR_BOX" #x0C10)
(swig-defconstant "GL_SCISSOR_TEST" #x0C11)
(swig-defconstant "GL_INDEX_CLEAR_VALUE" #x0C20)
(swig-defconstant "GL_INDEX_WRITEMASK" #x0C21)
(swig-defconstant "GL_COLOR_CLEAR_VALUE" #x0C22)
(swig-defconstant "GL_COLOR_WRITEMASK" #x0C23)
(swig-defconstant "GL_INDEX_MODE" #x0C30)
(swig-defconstant "GL_RGBA_MODE" #x0C31)
(swig-defconstant "GL_DOUBLEBUFFER" #x0C32)
(swig-defconstant "GL_STEREO" #x0C33)
(swig-defconstant "GL_RENDER_MODE" #x0C40)
(swig-defconstant "GL_PERSPECTIVE_CORRECTION_HINT" #x0C50)
(swig-defconstant "GL_POINT_SMOOTH_HINT" #x0C51)
(swig-defconstant "GL_LINE_SMOOTH_HINT" #x0C52)
(swig-defconstant "GL_POLYGON_SMOOTH_HINT" #x0C53)
(swig-defconstant "GL_FOG_HINT" #x0C54)
(swig-defconstant "GL_TEXTURE_GEN_S" #x0C60)
(swig-defconstant "GL_TEXTURE_GEN_T" #x0C61)
(swig-defconstant "GL_TEXTURE_GEN_R" #x0C62)
(swig-defconstant "GL_TEXTURE_GEN_Q" #x0C63)
(swig-defconstant "GL_PIXEL_MAP_I_TO_I" #x0C70)
(swig-defconstant "GL_PIXEL_MAP_S_TO_S" #x0C71)
(swig-defconstant "GL_PIXEL_MAP_I_TO_R" #x0C72)
(swig-defconstant "GL_PIXEL_MAP_I_TO_G" #x0C73)
(swig-defconstant "GL_PIXEL_MAP_I_TO_B" #x0C74)
(swig-defconstant "GL_PIXEL_MAP_I_TO_A" #x0C75)
(swig-defconstant "GL_PIXEL_MAP_R_TO_R" #x0C76)
(swig-defconstant "GL_PIXEL_MAP_G_TO_G" #x0C77)
(swig-defconstant "GL_PIXEL_MAP_B_TO_B" #x0C78)
(swig-defconstant "GL_PIXEL_MAP_A_TO_A" #x0C79)
(swig-defconstant "GL_PIXEL_MAP_I_TO_I_SIZE" #x0CB0)
(swig-defconstant "GL_PIXEL_MAP_S_TO_S_SIZE" #x0CB1)
(swig-defconstant "GL_PIXEL_MAP_I_TO_R_SIZE" #x0CB2)
(swig-defconstant "GL_PIXEL_MAP_I_TO_G_SIZE" #x0CB3)
(swig-defconstant "GL_PIXEL_MAP_I_TO_B_SIZE" #x0CB4)
(swig-defconstant "GL_PIXEL_MAP_I_TO_A_SIZE" #x0CB5)
(swig-defconstant "GL_PIXEL_MAP_R_TO_R_SIZE" #x0CB6)
(swig-defconstant "GL_PIXEL_MAP_G_TO_G_SIZE" #x0CB7)
(swig-defconstant "GL_PIXEL_MAP_B_TO_B_SIZE" #x0CB8)
(swig-defconstant "GL_PIXEL_MAP_A_TO_A_SIZE" #x0CB9)
(swig-defconstant "GL_UNPACK_SWAP_BYTES" #x0CF0)
(swig-defconstant "GL_UNPACK_LSB_FIRST" #x0CF1)
(swig-defconstant "GL_UNPACK_ROW_LENGTH" #x0CF2)
(swig-defconstant "GL_UNPACK_SKIP_ROWS" #x0CF3)
(swig-defconstant "GL_UNPACK_SKIP_PIXELS" #x0CF4)
(swig-defconstant "GL_UNPACK_ALIGNMENT" #x0CF5)
(swig-defconstant "GL_PACK_SWAP_BYTES" #x0D00)
(swig-defconstant "GL_PACK_LSB_FIRST" #x0D01)
(swig-defconstant "GL_PACK_ROW_LENGTH" #x0D02)
(swig-defconstant "GL_PACK_SKIP_ROWS" #x0D03)
(swig-defconstant "GL_PACK_SKIP_PIXELS" #x0D04)
(swig-defconstant "GL_PACK_ALIGNMENT" #x0D05)
(swig-defconstant "GL_MAP_COLOR" #x0D10)
(swig-defconstant "GL_MAP_STENCIL" #x0D11)
(swig-defconstant "GL_INDEX_SHIFT" #x0D12)
(swig-defconstant "GL_INDEX_OFFSET" #x0D13)
(swig-defconstant "GL_RED_SCALE" #x0D14)
(swig-defconstant "GL_RED_BIAS" #x0D15)
(swig-defconstant "GL_ZOOM_X" #x0D16)
(swig-defconstant "GL_ZOOM_Y" #x0D17)
(swig-defconstant "GL_GREEN_SCALE" #x0D18)
(swig-defconstant "GL_GREEN_BIAS" #x0D19)
(swig-defconstant "GL_BLUE_SCALE" #x0D1A)
(swig-defconstant "GL_BLUE_BIAS" #x0D1B)
(swig-defconstant "GL_ALPHA_SCALE" #x0D1C)
(swig-defconstant "GL_ALPHA_BIAS" #x0D1D)
(swig-defconstant "GL_DEPTH_SCALE" #x0D1E)
(swig-defconstant "GL_DEPTH_BIAS" #x0D1F)
(swig-defconstant "GL_MAX_EVAL_ORDER" #x0D30)
(swig-defconstant "GL_MAX_LIGHTS" #x0D31)
(swig-defconstant "GL_MAX_CLIP_PLANES" #x0D32)
(swig-defconstant "GL_MAX_TEXTURE_SIZE" #x0D33)
(swig-defconstant "GL_MAX_PIXEL_MAP_TABLE" #x0D34)
(swig-defconstant "GL_MAX_ATTRIB_STACK_DEPTH" #x0D35)
(swig-defconstant "GL_MAX_MODELVIEW_STACK_DEPTH" #x0D36)
(swig-defconstant "GL_MAX_NAME_STACK_DEPTH" #x0D37)
(swig-defconstant "GL_MAX_PROJECTION_STACK_DEPTH" #x0D38)
(swig-defconstant "GL_MAX_TEXTURE_STACK_DEPTH" #x0D39)
(swig-defconstant "GL_MAX_VIEWPORT_DIMS" #x0D3A)
(swig-defconstant "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH" #x0D3B)
(swig-defconstant "GL_SUBPIXEL_BITS" #x0D50)
(swig-defconstant "GL_INDEX_BITS" #x0D51)
(swig-defconstant "GL_RED_BITS" #x0D52)
(swig-defconstant "GL_GREEN_BITS" #x0D53)
(swig-defconstant "GL_BLUE_BITS" #x0D54)
(swig-defconstant "GL_ALPHA_BITS" #x0D55)
(swig-defconstant "GL_DEPTH_BITS" #x0D56)
(swig-defconstant "GL_STENCIL_BITS" #x0D57)
(swig-defconstant "GL_ACCUM_RED_BITS" #x0D58)
(swig-defconstant "GL_ACCUM_GREEN_BITS" #x0D59)
(swig-defconstant "GL_ACCUM_BLUE_BITS" #x0D5A)
(swig-defconstant "GL_ACCUM_ALPHA_BITS" #x0D5B)
(swig-defconstant "GL_NAME_STACK_DEPTH" #x0D70)
(swig-defconstant "GL_AUTO_NORMAL" #x0D80)
(swig-defconstant "GL_MAP1_COLOR_4" #x0D90)
(swig-defconstant "GL_MAP1_INDEX" #x0D91)
(swig-defconstant "GL_MAP1_NORMAL" #x0D92)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_1" #x0D93)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_2" #x0D94)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_3" #x0D95)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_4" #x0D96)
(swig-defconstant "GL_MAP1_VERTEX_3" #x0D97)
(swig-defconstant "GL_MAP1_VERTEX_4" #x0D98)
(swig-defconstant "GL_MAP2_COLOR_4" #x0DB0)
(swig-defconstant "GL_MAP2_INDEX" #x0DB1)
(swig-defconstant "GL_MAP2_NORMAL" #x0DB2)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_1" #x0DB3)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_2" #x0DB4)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_3" #x0DB5)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_4" #x0DB6)
(swig-defconstant "GL_MAP2_VERTEX_3" #x0DB7)
(swig-defconstant "GL_MAP2_VERTEX_4" #x0DB8)
(swig-defconstant "GL_MAP1_GRID_DOMAIN" #x0DD0)
(swig-defconstant "GL_MAP1_GRID_SEGMENTS" #x0DD1)
(swig-defconstant "GL_MAP2_GRID_DOMAIN" #x0DD2)
(swig-defconstant "GL_MAP2_GRID_SEGMENTS" #x0DD3)
(swig-defconstant "GL_TEXTURE_1D" #x0DE0)
(swig-defconstant "GL_TEXTURE_2D" #x0DE1)
(swig-defconstant "GL_FEEDBACK_BUFFER_POINTER" #x0DF0)
(swig-defconstant "GL_FEEDBACK_BUFFER_SIZE" #x0DF1)
(swig-defconstant "GL_FEEDBACK_BUFFER_TYPE" #x0DF2)
(swig-defconstant "GL_SELECTION_BUFFER_POINTER" #x0DF3)
(swig-defconstant "GL_SELECTION_BUFFER_SIZE" #x0DF4)
(swig-defconstant "GL_TEXTURE_WIDTH" #x1000)
(swig-defconstant "GL_TEXTURE_HEIGHT" #x1001)
(swig-defconstant "GL_TEXTURE_INTERNAL_FORMAT" #x1003)
(swig-defconstant "GL_TEXTURE_BORDER_COLOR" #x1004)
(swig-defconstant "GL_TEXTURE_BORDER" #x1005)
(swig-defconstant "GL_DONT_CARE" #x1100)
(swig-defconstant "GL_FASTEST" #x1101)
(swig-defconstant "GL_NICEST" #x1102)
(swig-defconstant "GL_LIGHT0" #x4000)
(swig-defconstant "GL_LIGHT1" #x4001)
(swig-defconstant "GL_LIGHT2" #x4002)
(swig-defconstant "GL_LIGHT3" #x4003)
(swig-defconstant "GL_LIGHT4" #x4004)
(swig-defconstant "GL_LIGHT5" #x4005)
(swig-defconstant "GL_LIGHT6" #x4006)
(swig-defconstant "GL_LIGHT7" #x4007)
(swig-defconstant "GL_AMBIENT" #x1200)
(swig-defconstant "GL_DIFFUSE" #x1201)
(swig-defconstant "GL_SPECULAR" #x1202)
(swig-defconstant "GL_POSITION" #x1203)
(swig-defconstant "GL_SPOT_DIRECTION" #x1204)
(swig-defconstant "GL_SPOT_EXPONENT" #x1205)
(swig-defconstant "GL_SPOT_CUTOFF" #x1206)
(swig-defconstant "GL_CONSTANT_ATTENUATION" #x1207)
(swig-defconstant "GL_LINEAR_ATTENUATION" #x1208)
(swig-defconstant "GL_QUADRATIC_ATTENUATION" #x1209)
(swig-defconstant "GL_COMPILE" #x1300)
(swig-defconstant "GL_COMPILE_AND_EXECUTE" #x1301)
(swig-defconstant "GL_CLEAR" #x1500)
(swig-defconstant "GL_AND" #x1501)
(swig-defconstant "GL_AND_REVERSE" #x1502)
(swig-defconstant "GL_COPY" #x1503)
(swig-defconstant "GL_AND_INVERTED" #x1504)
(swig-defconstant "GL_NOOP" #x1505)
(swig-defconstant "GL_XOR" #x1506)
(swig-defconstant "GL_OR" #x1507)
(swig-defconstant "GL_NOR" #x1508)
(swig-defconstant "GL_EQUIV" #x1509)
(swig-defconstant "GL_INVERT" #x150A)
(swig-defconstant "GL_OR_REVERSE" #x150B)
(swig-defconstant "GL_COPY_INVERTED" #x150C)
(swig-defconstant "GL_OR_INVERTED" #x150D)
(swig-defconstant "GL_NAND" #x150E)
(swig-defconstant "GL_SET" #x150F)
(swig-defconstant "GL_EMISSION" #x1600)
(swig-defconstant "GL_SHININESS" #x1601)
(swig-defconstant "GL_AMBIENT_AND_DIFFUSE" #x1602)
(swig-defconstant "GL_COLOR_INDEXES" #x1603)
(swig-defconstant "GL_MODELVIEW" #x1700)
(swig-defconstant "GL_PROJECTION" #x1701)
(swig-defconstant "GL_TEXTURE" #x1702)
(swig-defconstant "GL_COLOR" #x1800)
(swig-defconstant "GL_DEPTH" #x1801)
(swig-defconstant "GL_STENCIL" #x1802)
(swig-defconstant "GL_COLOR_INDEX" #x1900)
(swig-defconstant "GL_STENCIL_INDEX" #x1901)
(swig-defconstant "GL_DEPTH_COMPONENT" #x1902)
(swig-defconstant "GL_RED" #x1903)
(swig-defconstant "GL_GREEN" #x1904)
(swig-defconstant "GL_BLUE" #x1905)
(swig-defconstant "GL_ALPHA" #x1906)
(swig-defconstant "GL_RGB" #x1907)
(swig-defconstant "GL_RGBA" #x1908)
(swig-defconstant "GL_LUMINANCE" #x1909)
(swig-defconstant "GL_LUMINANCE_ALPHA" #x190A)
(swig-defconstant "GL_BITMAP" #x1A00)
(swig-defconstant "GL_POINT" #x1B00)
(swig-defconstant "GL_LINE" #x1B01)
(swig-defconstant "GL_FILL" #x1B02)
(swig-defconstant "GL_RENDER" #x1C00)
(swig-defconstant "GL_FEEDBACK" #x1C01)
(swig-defconstant "GL_SELECT" #x1C02)
(swig-defconstant "GL_FLAT" #x1D00)
(swig-defconstant "GL_SMOOTH" #x1D01)
(swig-defconstant "GL_KEEP" #x1E00)
(swig-defconstant "GL_REPLACE" #x1E01)
(swig-defconstant "GL_INCR" #x1E02)
(swig-defconstant "GL_DECR" #x1E03)
(swig-defconstant "GL_VENDOR" #x1F00)
(swig-defconstant "GL_RENDERER" #x1F01)
(swig-defconstant "GL_VERSION" #x1F02)
(swig-defconstant "GL_EXTENSIONS" #x1F03)
(swig-defconstant "GL_S" #x2000)
(swig-defconstant "GL_T" #x2001)
(swig-defconstant "GL_R" #x2002)
(swig-defconstant "GL_Q" #x2003)
(swig-defconstant "GL_MODULATE" #x2100)
(swig-defconstant "GL_DECAL" #x2101)
(swig-defconstant "GL_TEXTURE_ENV_MODE" #x2200)
(swig-defconstant "GL_TEXTURE_ENV_COLOR" #x2201)
(swig-defconstant "GL_TEXTURE_ENV" #x2300)
(swig-defconstant "GL_EYE_LINEAR" #x2400)
(swig-defconstant "GL_OBJECT_LINEAR" #x2401)
(swig-defconstant "GL_SPHERE_MAP" #x2402)
(swig-defconstant "GL_TEXTURE_GEN_MODE" #x2500)
(swig-defconstant "GL_OBJECT_PLANE" #x2501)
(swig-defconstant "GL_EYE_PLANE" #x2502)
(swig-defconstant "GL_NEAREST" #x2600)
(swig-defconstant "GL_LINEAR" #x2601)
(swig-defconstant "GL_NEAREST_MIPMAP_NEAREST" #x2700)
(swig-defconstant "GL_LINEAR_MIPMAP_NEAREST" #x2701)
(swig-defconstant "GL_NEAREST_MIPMAP_LINEAR" #x2702)
(swig-defconstant "GL_LINEAR_MIPMAP_LINEAR" #x2703)
(swig-defconstant "GL_TEXTURE_MAG_FILTER" #x2800)
(swig-defconstant "GL_TEXTURE_MIN_FILTER" #x2801)
(swig-defconstant "GL_TEXTURE_WRAP_S" #x2802)
(swig-defconstant "GL_TEXTURE_WRAP_T" #x2803)
(swig-defconstant "GL_CLAMP" #x2900)
(swig-defconstant "GL_REPEAT" #x2901)
(swig-defconstant "GL_CLIENT_PIXEL_STORE_BIT" #x00000001)
(swig-defconstant "GL_CLIENT_VERTEX_ARRAY_BIT" #x00000002)
(swig-defconstant "GL_CLIENT_ALL_ATTRIB_BITS" #xffffffff)
(swig-defconstant "GL_POLYGON_OFFSET_FACTOR" #x8038)
(swig-defconstant "GL_POLYGON_OFFSET_UNITS" #x2A00)
(swig-defconstant "GL_POLYGON_OFFSET_POINT" #x2A01)
(swig-defconstant "GL_POLYGON_OFFSET_LINE" #x2A02)
(swig-defconstant "GL_POLYGON_OFFSET_FILL" #x8037)
(swig-defconstant "GL_ALPHA4" #x803B)
(swig-defconstant "GL_ALPHA8" #x803C)
(swig-defconstant "GL_ALPHA12" #x803D)
(swig-defconstant "GL_ALPHA16" #x803E)
(swig-defconstant "GL_LUMINANCE4" #x803F)
(swig-defconstant "GL_LUMINANCE8" #x8040)
(swig-defconstant "GL_LUMINANCE12" #x8041)
(swig-defconstant "GL_LUMINANCE16" #x8042)
(swig-defconstant "GL_LUMINANCE4_ALPHA4" #x8043)
(swig-defconstant "GL_LUMINANCE6_ALPHA2" #x8044)
(swig-defconstant "GL_LUMINANCE8_ALPHA8" #x8045)
(swig-defconstant "GL_LUMINANCE12_ALPHA4" #x8046)
(swig-defconstant "GL_LUMINANCE12_ALPHA12" #x8047)
(swig-defconstant "GL_LUMINANCE16_ALPHA16" #x8048)
(swig-defconstant "GL_INTENSITY" #x8049)
(swig-defconstant "GL_INTENSITY4" #x804A)
(swig-defconstant "GL_INTENSITY8" #x804B)
(swig-defconstant "GL_INTENSITY12" #x804C)
(swig-defconstant "GL_INTENSITY16" #x804D)
(swig-defconstant "GL_R3_G3_B2" #x2A10)
(swig-defconstant "GL_RGB4" #x804F)
(swig-defconstant "GL_RGB5" #x8050)
(swig-defconstant "GL_RGB8" #x8051)
(swig-defconstant "GL_RGB10" #x8052)
(swig-defconstant "GL_RGB12" #x8053)
(swig-defconstant "GL_RGB16" #x8054)
(swig-defconstant "GL_RGBA2" #x8055)
(swig-defconstant "GL_RGBA4" #x8056)
(swig-defconstant "GL_RGB5_A1" #x8057)
(swig-defconstant "GL_RGBA8" #x8058)
(swig-defconstant "GL_RGB10_A2" #x8059)
(swig-defconstant "GL_RGBA12" #x805A)
(swig-defconstant "GL_RGBA16" #x805B)
(swig-defconstant "GL_TEXTURE_RED_SIZE" #x805C)
(swig-defconstant "GL_TEXTURE_GREEN_SIZE" #x805D)
(swig-defconstant "GL_TEXTURE_BLUE_SIZE" #x805E)
(swig-defconstant "GL_TEXTURE_ALPHA_SIZE" #x805F)
(swig-defconstant "GL_TEXTURE_LUMINANCE_SIZE" #x8060)
(swig-defconstant "GL_TEXTURE_INTENSITY_SIZE" #x8061)
(swig-defconstant "GL_PROXY_TEXTURE_1D" #x8063)
(swig-defconstant "GL_PROXY_TEXTURE_2D" #x8064)
(swig-defconstant "GL_TEXTURE_PRIORITY" #x8066)
(swig-defconstant "GL_TEXTURE_RESIDENT" #x8067)
(swig-defconstant "GL_TEXTURE_BINDING_1D" #x8068)
(swig-defconstant "GL_TEXTURE_BINDING_2D" #x8069)
(swig-defconstant "GL_VERTEX_ARRAY" #x8074)
(swig-defconstant "GL_NORMAL_ARRAY" #x8075)
(swig-defconstant "GL_COLOR_ARRAY" #x8076)
(swig-defconstant "GL_INDEX_ARRAY" #x8077)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY" #x8078)
(swig-defconstant "GL_EDGE_FLAG_ARRAY" #x8079)
(swig-defconstant "GL_VERTEX_ARRAY_SIZE" #x807A)
(swig-defconstant "GL_VERTEX_ARRAY_TYPE" #x807B)
(swig-defconstant "GL_VERTEX_ARRAY_STRIDE" #x807C)
(swig-defconstant "GL_NORMAL_ARRAY_TYPE" #x807E)
(swig-defconstant "GL_NORMAL_ARRAY_STRIDE" #x807F)
(swig-defconstant "GL_COLOR_ARRAY_SIZE" #x8081)
(swig-defconstant "GL_COLOR_ARRAY_TYPE" #x8082)
(swig-defconstant "GL_COLOR_ARRAY_STRIDE" #x8083)
(swig-defconstant "GL_INDEX_ARRAY_TYPE" #x8085)
(swig-defconstant "GL_INDEX_ARRAY_STRIDE" #x8086)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_SIZE" #x8088)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_TYPE" #x8089)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_STRIDE" #x808A)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_STRIDE" #x808C)
(swig-defconstant "GL_VERTEX_ARRAY_POINTER" #x808E)
(swig-defconstant "GL_NORMAL_ARRAY_POINTER" #x808F)
(swig-defconstant "GL_COLOR_ARRAY_POINTER" #x8090)
(swig-defconstant "GL_INDEX_ARRAY_POINTER" #x8091)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_POINTER" #x8092)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_POINTER" #x8093)
(swig-defconstant "GL_V2F" #x2A20)
(swig-defconstant "GL_V3F" #x2A21)
(swig-defconstant "GL_C4UB_V2F" #x2A22)
(swig-defconstant "GL_C4UB_V3F" #x2A23)
(swig-defconstant "GL_C3F_V3F" #x2A24)
(swig-defconstant "GL_N3F_V3F" #x2A25)
(swig-defconstant "GL_C4F_N3F_V3F" #x2A26)
(swig-defconstant "GL_T2F_V3F" #x2A27)
(swig-defconstant "GL_T4F_V4F" #x2A28)
(swig-defconstant "GL_T2F_C4UB_V3F" #x2A29)
(swig-defconstant "GL_T2F_C3F_V3F" #x2A2A)
(swig-defconstant "GL_T2F_N3F_V3F" #x2A2B)
(swig-defconstant "GL_T2F_C4F_N3F_V3F" #x2A2C)
(swig-defconstant "GL_T4F_C4F_N3F_V4F" #x2A2D)
(swig-defconstant "GL_EXT_vertex_array" 1)
(swig-defconstant "GL_EXT_bgra" 1)
(swig-defconstant "GL_EXT_paletted_texture" 1)
(swig-defconstant "GL_WIN_swap_hint" 1)
(swig-defconstant "GL_WIN_draw_range_elements" 1)
(swig-defconstant "GL_VERTEX_ARRAY_EXT" #x8074)
(swig-defconstant "GL_NORMAL_ARRAY_EXT" #x8075)
(swig-defconstant "GL_COLOR_ARRAY_EXT" #x8076)
(swig-defconstant "GL_INDEX_ARRAY_EXT" #x8077)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_EXT" #x8078)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_EXT" #x8079)
(swig-defconstant "GL_VERTEX_ARRAY_SIZE_EXT" #x807A)
(swig-defconstant "GL_VERTEX_ARRAY_TYPE_EXT" #x807B)
(swig-defconstant "GL_VERTEX_ARRAY_STRIDE_EXT" #x807C)
(swig-defconstant "GL_VERTEX_ARRAY_COUNT_EXT" #x807D)
(swig-defconstant "GL_NORMAL_ARRAY_TYPE_EXT" #x807E)
(swig-defconstant "GL_NORMAL_ARRAY_STRIDE_EXT" #x807F)
(swig-defconstant "GL_NORMAL_ARRAY_COUNT_EXT" #x8080)
(swig-defconstant "GL_COLOR_ARRAY_SIZE_EXT" #x8081)
(swig-defconstant "GL_COLOR_ARRAY_TYPE_EXT" #x8082)
(swig-defconstant "GL_COLOR_ARRAY_STRIDE_EXT" #x8083)
(swig-defconstant "GL_COLOR_ARRAY_COUNT_EXT" #x8084)
(swig-defconstant "GL_INDEX_ARRAY_TYPE_EXT" #x8085)
(swig-defconstant "GL_INDEX_ARRAY_STRIDE_EXT" #x8086)
(swig-defconstant "GL_INDEX_ARRAY_COUNT_EXT" #x8087)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_SIZE_EXT" #x8088)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_TYPE_EXT" #x8089)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_STRIDE_EXT" #x808A)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_COUNT_EXT" #x808B)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_STRIDE_EXT" #x808C)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_COUNT_EXT" #x808D)
(swig-defconstant "GL_VERTEX_ARRAY_POINTER_EXT" #x808E)
(swig-defconstant "GL_NORMAL_ARRAY_POINTER_EXT" #x808F)
(swig-defconstant "GL_COLOR_ARRAY_POINTER_EXT" #x8090)
(swig-defconstant "GL_INDEX_ARRAY_POINTER_EXT" #x8091)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_POINTER_EXT" #x8092)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_POINTER_EXT" #x8093)
(swig-defconstant "GL_DOUBLE_EXT" #x140A)
(swig-defconstant "GL_BGR_EXT" #x80E0)
(swig-defconstant "GL_BGRA_EXT" #x80E1)
(swig-defconstant "GL_COLOR_TABLE_FORMAT_EXT" #x80D8)
(swig-defconstant "GL_COLOR_TABLE_WIDTH_EXT" #x80D9)
(swig-defconstant "GL_COLOR_TABLE_RED_SIZE_EXT" #x80DA)
(swig-defconstant "GL_COLOR_TABLE_GREEN_SIZE_EXT" #x80DB)
(swig-defconstant "GL_COLOR_TABLE_BLUE_SIZE_EXT" #x80DC)
(swig-defconstant "GL_COLOR_TABLE_ALPHA_SIZE_EXT" #x80DD)
(swig-defconstant "GL_COLOR_TABLE_LUMINANCE_SIZE_EXT" #x80DE)
(swig-defconstant "GL_COLOR_TABLE_INTENSITY_SIZE_EXT" #x80DF)
(swig-defconstant "GL_COLOR_INDEX1_EXT" #x80E2)
(swig-defconstant "GL_COLOR_INDEX2_EXT" #x80E3)
(swig-defconstant "GL_COLOR_INDEX4_EXT" #x80E4)
(swig-defconstant "GL_COLOR_INDEX8_EXT" #x80E5)
(swig-defconstant "GL_COLOR_INDEX12_EXT" #x80E6)
(swig-defconstant "GL_COLOR_INDEX16_EXT" #x80E7)
(swig-defconstant "GL_MAX_ELEMENTS_VERTICES_WIN" #x80E8)
(swig-defconstant "GL_MAX_ELEMENTS_INDICES_WIN" #x80E9)
(swig-defconstant "GL_PHONG_WIN" #x80EA)
(swig-defconstant "GL_PHONG_HINT_WIN" #x80EB)
(swig-defconstant "GL_FOG_SPECULAR_TEXTURE_WIN" #x80EC)
(swig-defconstant "GL_LOGIC_OP" #x0BF1)
(swig-defconstant "GL_TEXTURE_COMPONENTS" #x1003)
(swig-defun ("glAccum" "glAccum")
  ((:p+ PARM0_op  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_value  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_op))
  (cl::let ((SWIG_arg1 PARM1_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glAlphaFunc" "glAlphaFunc")
  ((:p+ PARM0_func  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_ref  #.(swig-insert-id "GLclampf" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (cl::let ((SWIG_arg1 PARM1_ref))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glAreTexturesResident" "glAreTexturesResident")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) )
   (:p+ PARM2_residences  (* #.(swig-insert-id "GLboolean" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (cl::let ((SWIG_arg2 PARM2_residences))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glArrayElement" "glArrayElement")
  ((:p+ PARM0_i  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_i))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBegin" "glBegin")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBindTexture" "glBindTexture")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_texture  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_texture))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBitmap" "glBitmap")
  ((:p+ PARM0_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_xorig  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_yorig  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM4_xmove  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM5_ymove  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM6_bitmap  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (cl::let ((SWIG_arg1 PARM1_height))
  (cl::let ((SWIG_arg2 PARM2_xorig))
  (cl::let ((SWIG_arg3 PARM3_yorig))
  (cl::let ((SWIG_arg4 PARM4_xmove))
  (cl::let ((SWIG_arg5 PARM5_ymove))
  (cl::let ((SWIG_arg6 PARM6_bitmap))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBlendFunc" "glBlendFunc")
  ((:p+ PARM0_sfactor  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_dfactor  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_sfactor))
  (cl::let ((SWIG_arg1 PARM1_dfactor))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCallList" "glCallList")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCallLists" "glCallLists")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_lists  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_lists))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClear" "glClear")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLbitfield" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearAccum" "glClearAccum")
  ((:p+ PARM0_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearColor" "glClearColor")
  ((:p+ PARM0_red  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLclampf" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearDepth" "glClearDepth")
  ((:p+ PARM0_depth  #.(swig-insert-id "GLclampd" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_depth))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearIndex" "glClearIndex")
  ((:p+ PARM0_c  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearStencil" "glClearStencil")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClipPlane" "glClipPlane")
  ((:p+ PARM0_plane  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_equation  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_plane))
  (cl::let ((SWIG_arg1 PARM1_equation))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3b" "glColor3b")
  ((:p+ PARM0_red  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLbyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3bv" "glColor3bv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3d" "glColor3d")
  ((:p+ PARM0_red  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3dv" "glColor3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3f" "glColor3f")
  ((:p+ PARM0_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3fv" "glColor3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3i" "glColor3i")
  ((:p+ PARM0_red  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3iv" "glColor3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3s" "glColor3s")
  ((:p+ PARM0_red  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3sv" "glColor3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3ub" "glColor3ub")
  ((:p+ PARM0_red  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3ubv" "glColor3ubv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3ui" "glColor3ui")
  ((:p+ PARM0_red  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3uiv" "glColor3uiv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3us" "glColor3us")
  ((:p+ PARM0_red  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLushort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3usv" "glColor3usv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4b" "glColor4b")
  ((:p+ PARM0_red  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM3_alpha  #.(swig-insert-id "GLbyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4bv" "glColor4bv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4d" "glColor4d")
  ((:p+ PARM0_red  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4dv" "glColor4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4f" "glColor4f")
  ((:p+ PARM0_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4fv" "glColor4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4i" "glColor4i")
  ((:p+ PARM0_red  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4iv" "glColor4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4s" "glColor4s")
  ((:p+ PARM0_red  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4sv" "glColor4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4ub" "glColor4ub")
  ((:p+ PARM0_red  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM3_alpha  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4ubv" "glColor4ubv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4ui" "glColor4ui")
  ((:p+ PARM0_red  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4uiv" "glColor4uiv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4us" "glColor4us")
  ((:p+ PARM0_red  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLushort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4usv" "glColor4usv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorMask" "glColorMask")
  ((:p+ PARM0_red  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM3_alpha  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorMaterial" "glColorMaterial")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorPointer" "glColorPointer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_stride))
  (cl::let ((SWIG_arg3 PARM3_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyPixels" "glCopyPixels")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexImage1D" "glCopyTexImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalFormat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_border  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalFormat))
  (cl::let ((SWIG_arg3 PARM3_x))
  (cl::let ((SWIG_arg4 PARM4_y))
  (cl::let ((SWIG_arg5 PARM5_width))
  (cl::let ((SWIG_arg6 PARM6_border))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexImage2D" "glCopyTexImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalFormat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_border  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalFormat))
  (cl::let ((SWIG_arg3 PARM3_x))
  (cl::let ((SWIG_arg4 PARM4_y))
  (cl::let ((SWIG_arg5 PARM5_width))
  (cl::let ((SWIG_arg6 PARM6_height))
  (cl::let ((SWIG_arg7 PARM7_border))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexSubImage1D" "glCopyTexSubImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_x))
  (cl::let ((SWIG_arg4 PARM4_y))
  (cl::let ((SWIG_arg5 PARM5_width))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexSubImage2D" "glCopyTexSubImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_x))
  (cl::let ((SWIG_arg5 PARM5_y))
  (cl::let ((SWIG_arg6 PARM6_width))
  (cl::let ((SWIG_arg7 PARM7_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCullFace" "glCullFace")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteLists" "glDeleteLists")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_range  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (cl::let ((SWIG_arg1 PARM1_range))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteTextures" "glDeleteTextures")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDepthFunc" "glDepthFunc")
  ((:p+ PARM0_func  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDepthMask" "glDepthMask")
  ((:p+ PARM0_flag  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_flag))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDepthRange" "glDepthRange")
  ((:p+ PARM0_zNear  #.(swig-insert-id "GLclampd" () :type :type) )
   (:p+ PARM1_zFar  #.(swig-insert-id "GLclampd" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_zNear))
  (cl::let ((SWIG_arg1 PARM1_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDisable" "glDisable")
  ((:p+ PARM0_cap  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_cap))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDisableClientState" "glDisableClientState")
  ((:p+ PARM0_array  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_array))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawArrays" "glDrawArrays")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_first  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_count  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_first))
  (cl::let ((SWIG_arg2 PARM2_count))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawBuffer" "glDrawBuffer")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawElements" "glDrawElements")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_indices  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_type))
  (cl::let ((SWIG_arg3 PARM3_indices))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawPixels" "glDrawPixels")
  ((:p+ PARM0_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (cl::let ((SWIG_arg1 PARM1_height))
  (cl::let ((SWIG_arg2 PARM2_format))
  (cl::let ((SWIG_arg3 PARM3_type))
  (cl::let ((SWIG_arg4 PARM4_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEdgeFlag" "glEdgeFlag")
  ((:p+ PARM0_flag  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_flag))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEdgeFlagPointer" "glEdgeFlagPointer")
  ((:p+ PARM0_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_stride))
  (cl::let ((SWIG_arg1 PARM1_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEdgeFlagv" "glEdgeFlagv")
  ((:p+ PARM0_flag  (* #.(swig-insert-id "GLboolean" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_flag))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEnable" "glEnable")
  ((:p+ PARM0_cap  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_cap))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEnableClientState" "glEnableClientState")
  ((:p+ PARM0_array  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_array))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEnd" "glEnd")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEndList" "glEndList")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1d" "glEvalCoord1d")
  ((:p+ PARM0_u  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1dv" "glEvalCoord1dv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1f" "glEvalCoord1f")
  ((:p+ PARM0_u  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1fv" "glEvalCoord1fv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2d" "glEvalCoord2d")
  ((:p+ PARM0_u  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_v  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2dv" "glEvalCoord2dv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2f" "glEvalCoord2f")
  ((:p+ PARM0_u  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_v  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2fv" "glEvalCoord2fv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalMesh1" "glEvalMesh1")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_i1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_i2  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_i1))
  (cl::let ((SWIG_arg2 PARM2_i2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalMesh2" "glEvalMesh2")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_i1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_i2  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_j1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_j2  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_i1))
  (cl::let ((SWIG_arg2 PARM2_i2))
  (cl::let ((SWIG_arg3 PARM3_j1))
  (cl::let ((SWIG_arg4 PARM4_j2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalPoint1" "glEvalPoint1")
  ((:p+ PARM0_i  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_i))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalPoint2" "glEvalPoint2")
  ((:p+ PARM0_i  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_j  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_i))
  (cl::let ((SWIG_arg1 PARM1_j))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFeedbackBuffer" "glFeedbackBuffer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_buffer  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_buffer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFinish" "glFinish")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFlush" "glFlush")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogf" "glFogf")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogfv" "glFogfv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogi" "glFogi")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogiv" "glFogiv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFrontFace" "glFrontFace")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFrustum" "glFrustum")
  ((:p+ PARM0_left  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_right  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_bottom  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_top  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_zNear  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_zFar  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_left))
  (cl::let ((SWIG_arg1 PARM1_right))
  (cl::let ((SWIG_arg2 PARM2_bottom))
  (cl::let ((SWIG_arg3 PARM3_top))
  (cl::let ((SWIG_arg4 PARM4_zNear))
  (cl::let ((SWIG_arg5 PARM5_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGenLists" "glGenLists")
  ((:p+ PARM0_range  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (#.(swig-insert-id "GLuint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_range))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGenTextures" "glGenTextures")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetBooleanv" "glGetBooleanv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLboolean" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetClipPlane" "glGetClipPlane")
  ((:p+ PARM0_plane  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_equation  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_plane))
  (cl::let ((SWIG_arg1 PARM1_equation))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetDoublev" "glGetDoublev")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetError" "glGetError")
  (:void)
  (:returning (#.(swig-insert-id "GLenum" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::setq ACL_ffresult (swig-ff-call))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetFloatv" "glGetFloatv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetIntegerv" "glGetIntegerv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetLightfv" "glGetLightfv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetLightiv" "glGetLightiv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMapdv" "glGetMapdv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_query  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_query))
  (cl::let ((SWIG_arg2 PARM2_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMapfv" "glGetMapfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_query  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_query))
  (cl::let ((SWIG_arg2 PARM2_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMapiv" "glGetMapiv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_query  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_query))
  (cl::let ((SWIG_arg2 PARM2_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMaterialfv" "glGetMaterialfv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMaterialiv" "glGetMaterialiv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPixelMapfv" "glGetPixelMapfv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_values  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPixelMapuiv" "glGetPixelMapuiv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_values  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPixelMapusv" "glGetPixelMapusv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_values  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPointerv" "glGetPointerv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* (* #.(swig-insert-id "GLvoid" () :type :type))) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPolygonStipple" "glGetPolygonStipple")
  ((:p+ PARM0_mask  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetString" "glGetString")
  ((:p+ PARM0_name  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* #.(swig-insert-id "GLubyte" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
    (cl:let* ((address (swig-ff-call SWIG_arg0)))
    (cl:setq ACL_ffresult (cl:if (cl:eq address 0) 0
      	     		  	 (excl:native-to-string address))))  )
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexEnvfv" "glGetTexEnvfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexEnviv" "glGetTexEnviv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexGendv" "glGetTexGendv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexGenfv" "glGetTexGenfv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexGeniv" "glGetTexGeniv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexImage" "glGetTexImage")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_format))
  (cl::let ((SWIG_arg3 PARM3_type))
  (cl::let ((SWIG_arg4 PARM4_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexLevelParameterfv" "glGetTexLevelParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_pname))
  (cl::let ((SWIG_arg3 PARM3_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexLevelParameteriv" "glGetTexLevelParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_pname))
  (cl::let ((SWIG_arg3 PARM3_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexParameterfv" "glGetTexParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexParameteriv" "glGetTexParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glHint" "glHint")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexMask" "glIndexMask")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexPointer" "glIndexPointer")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::let ((SWIG_arg1 PARM1_stride))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexd" "glIndexd")
  ((:p+ PARM0_c  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexdv" "glIndexdv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexf" "glIndexf")
  ((:p+ PARM0_c  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexfv" "glIndexfv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexi" "glIndexi")
  ((:p+ PARM0_c  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexiv" "glIndexiv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexs" "glIndexs")
  ((:p+ PARM0_c  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexsv" "glIndexsv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexub" "glIndexub")
  ((:p+ PARM0_c  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexubv" "glIndexubv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glInitNames" "glInitNames")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glInterleavedArrays" "glInterleavedArrays")
  ((:p+ PARM0_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_format))
  (cl::let ((SWIG_arg1 PARM1_stride))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsEnabled" "glIsEnabled")
  ((:p+ PARM0_cap  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_cap))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsList" "glIsList")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsTexture" "glIsTexture")
  ((:p+ PARM0_texture  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_texture))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModelf" "glLightModelf")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModelfv" "glLightModelfv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModeli" "glLightModeli")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModeliv" "glLightModeliv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightf" "glLightf")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightfv" "glLightfv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLighti" "glLighti")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightiv" "glLightiv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLineStipple" "glLineStipple")
  ((:p+ PARM0_factor  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_pattern  #.(swig-insert-id "GLushort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_factor))
  (cl::let ((SWIG_arg1 PARM1_pattern))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLineWidth" "glLineWidth")
  ((:p+ PARM0_width  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glListBase" "glListBase")
  ((:p+ PARM0_base  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_base))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadIdentity" "glLoadIdentity")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadMatrixd" "glLoadMatrixd")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadMatrixf" "glLoadMatrixf")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadName" "glLoadName")
  ((:p+ PARM0_name  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLogicOp" "glLogicOp")
  ((:p+ PARM0_opcode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_opcode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap1d" "glMap1d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_order  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_points  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_order))
  (cl::let ((SWIG_arg5 PARM5_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap1f" "glMap1f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_order  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_points  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_order))
  (cl::let ((SWIG_arg5 PARM5_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap2d" "glMap2d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_ustride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_uorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_v1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM6_v2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM7_vstride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM8_vorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_points  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_ustride))
  (cl::let ((SWIG_arg4 PARM4_uorder))
  (cl::let ((SWIG_arg5 PARM5_v1))
  (cl::let ((SWIG_arg6 PARM6_v2))
  (cl::let ((SWIG_arg7 PARM7_vstride))
  (cl::let ((SWIG_arg8 PARM8_vorder))
  (cl::let ((SWIG_arg9 PARM9_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap2f" "glMap2f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_ustride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_uorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_v1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM6_v2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM7_vstride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM8_vorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_points  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_ustride))
  (cl::let ((SWIG_arg4 PARM4_uorder))
  (cl::let ((SWIG_arg5 PARM5_v1))
  (cl::let ((SWIG_arg6 PARM6_v2))
  (cl::let ((SWIG_arg7 PARM7_vstride))
  (cl::let ((SWIG_arg8 PARM8_vorder))
  (cl::let ((SWIG_arg9 PARM9_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid1d" "glMapGrid1d")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid1f" "glMapGrid1f")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid2d" "glMapGrid2d")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_vn  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_v1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_v2  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_vn))
  (cl::let ((SWIG_arg4 PARM4_v1))
  (cl::let ((SWIG_arg5 PARM5_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid2f" "glMapGrid2f")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_vn  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_v1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM5_v2  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_vn))
  (cl::let ((SWIG_arg4 PARM4_v1))
  (cl::let ((SWIG_arg5 PARM5_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMaterialf" "glMaterialf")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMaterialfv" "glMaterialfv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMateriali" "glMateriali")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMaterialiv" "glMaterialiv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMatrixMode" "glMatrixMode")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultMatrixd" "glMultMatrixd")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultMatrixf" "glMultMatrixf")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNewList" "glNewList")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3b" "glNormal3b")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM1_ny  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM2_nz  #.(swig-insert-id "GLbyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3bv" "glNormal3bv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3d" "glNormal3d")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3dv" "glNormal3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3f" "glNormal3f")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3fv" "glNormal3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3i" "glNormal3i")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3iv" "glNormal3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3s" "glNormal3s")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3sv" "glNormal3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormalPointer" "glNormalPointer")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::let ((SWIG_arg1 PARM1_stride))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glOrtho" "glOrtho")
  ((:p+ PARM0_left  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_right  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_bottom  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_top  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_zNear  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_zFar  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_left))
  (cl::let ((SWIG_arg1 PARM1_right))
  (cl::let ((SWIG_arg2 PARM2_bottom))
  (cl::let ((SWIG_arg3 PARM3_top))
  (cl::let ((SWIG_arg4 PARM4_zNear))
  (cl::let ((SWIG_arg5 PARM5_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPassThrough" "glPassThrough")
  ((:p+ PARM0_token  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_token))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelMapfv" "glPixelMapfv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mapsize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_values  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_mapsize))
  (cl::let ((SWIG_arg2 PARM2_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelMapuiv" "glPixelMapuiv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mapsize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_values  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_mapsize))
  (cl::let ((SWIG_arg2 PARM2_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelMapusv" "glPixelMapusv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mapsize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_values  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_mapsize))
  (cl::let ((SWIG_arg2 PARM2_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelStoref" "glPixelStoref")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelStorei" "glPixelStorei")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelTransferf" "glPixelTransferf")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelTransferi" "glPixelTransferi")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelZoom" "glPixelZoom")
  ((:p+ PARM0_xfactor  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_yfactor  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_xfactor))
  (cl::let ((SWIG_arg1 PARM1_yfactor))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPointSize" "glPointSize")
  ((:p+ PARM0_size  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPolygonMode" "glPolygonMode")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPolygonOffset" "glPolygonOffset")
  ((:p+ PARM0_factor  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_units  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_factor))
  (cl::let ((SWIG_arg1 PARM1_units))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPolygonStipple" "glPolygonStipple")
  ((:p+ PARM0_mask  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopAttrib" "glPopAttrib")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopClientAttrib" "glPopClientAttrib")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopMatrix" "glPopMatrix")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopName" "glPopName")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPrioritizeTextures" "glPrioritizeTextures")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) )
   (:p+ PARM2_priorities  (* #.(swig-insert-id "GLclampf" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (cl::let ((SWIG_arg2 PARM2_priorities))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushAttrib" "glPushAttrib")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLbitfield" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushClientAttrib" "glPushClientAttrib")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLbitfield" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushMatrix" "glPushMatrix")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushName" "glPushName")
  ((:p+ PARM0_name  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2d" "glRasterPos2d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2dv" "glRasterPos2dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2f" "glRasterPos2f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2fv" "glRasterPos2fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2i" "glRasterPos2i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2iv" "glRasterPos2iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2s" "glRasterPos2s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2sv" "glRasterPos2sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3d" "glRasterPos3d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3dv" "glRasterPos3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3f" "glRasterPos3f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3fv" "glRasterPos3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3i" "glRasterPos3i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3iv" "glRasterPos3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3s" "glRasterPos3s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3sv" "glRasterPos3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4d" "glRasterPos4d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4dv" "glRasterPos4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4f" "glRasterPos4f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4fv" "glRasterPos4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4i" "glRasterPos4i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4iv" "glRasterPos4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4s" "glRasterPos4s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4sv" "glRasterPos4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glReadBuffer" "glReadBuffer")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glReadPixels" "glReadPixels")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectd" "glRectd")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectdv" "glRectdv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectf" "glRectf")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectfv" "glRectfv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRecti" "glRecti")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectiv" "glRectiv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRects" "glRects")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectsv" "glRectsv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLshort" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRenderMode" "glRenderMode")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRotated" "glRotated")
  ((:p+ PARM0_angle  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_angle))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRotatef" "glRotatef")
  ((:p+ PARM0_angle  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_angle))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glScaled" "glScaled")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glScalef" "glScalef")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glScissor" "glScissor")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSelectBuffer" "glSelectBuffer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_buffer  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_buffer))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glShadeModel" "glShadeModel")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilFunc" "glStencilFunc")
  ((:p+ PARM0_func  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_ref  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (cl::let ((SWIG_arg1 PARM1_ref))
  (cl::let ((SWIG_arg2 PARM2_mask))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilMask" "glStencilMask")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilOp" "glStencilOp")
  ((:p+ PARM0_fail  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_zfail  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_zpass  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_fail))
  (cl::let ((SWIG_arg1 PARM1_zfail))
  (cl::let ((SWIG_arg2 PARM2_zpass))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1d" "glTexCoord1d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1dv" "glTexCoord1dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1f" "glTexCoord1f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1fv" "glTexCoord1fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1i" "glTexCoord1i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1iv" "glTexCoord1iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1s" "glTexCoord1s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1sv" "glTexCoord1sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2d" "glTexCoord2d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2dv" "glTexCoord2dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2f" "glTexCoord2f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2fv" "glTexCoord2fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2i" "glTexCoord2i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2iv" "glTexCoord2iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2s" "glTexCoord2s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2sv" "glTexCoord2sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3d" "glTexCoord3d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3dv" "glTexCoord3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3f" "glTexCoord3f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3fv" "glTexCoord3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3i" "glTexCoord3i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3iv" "glTexCoord3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3s" "glTexCoord3s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3sv" "glTexCoord3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4d" "glTexCoord4d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4dv" "glTexCoord4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4f" "glTexCoord4f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4fv" "glTexCoord4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4i" "glTexCoord4i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4iv" "glTexCoord4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4s" "glTexCoord4s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4sv" "glTexCoord4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoordPointer" "glTexCoordPointer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_stride))
  (cl::let ((SWIG_arg3 PARM3_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnvf" "glTexEnvf")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnvfv" "glTexEnvfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnvi" "glTexEnvi")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnviv" "glTexEnviv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGend" "glTexGend")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGendv" "glTexGendv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGenf" "glTexGenf")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGenfv" "glTexGenfv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGeni" "glTexGeni")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGeniv" "glTexGeniv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexImage1D" "glTexImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_border))
  (cl::let ((SWIG_arg5 PARM5_format))
  (cl::let ((SWIG_arg6 PARM6_type))
  (cl::let ((SWIG_arg7 PARM7_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexImage2D" "glTexImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM8_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_height))
  (cl::let ((SWIG_arg5 PARM5_border))
  (cl::let ((SWIG_arg6 PARM6_format))
  (cl::let ((SWIG_arg7 PARM7_type))
  (cl::let ((SWIG_arg8 PARM8_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameterf" "glTexParameterf")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameterfv" "glTexParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameteri" "glTexParameteri")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameteriv" "glTexParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexSubImage1D" "glTexSubImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexSubImage2D" "glTexSubImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM8_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_width))
  (cl::let ((SWIG_arg5 PARM5_height))
  (cl::let ((SWIG_arg6 PARM6_format))
  (cl::let ((SWIG_arg7 PARM7_type))
  (cl::let ((SWIG_arg8 PARM8_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTranslated" "glTranslated")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTranslatef" "glTranslatef")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2d" "glVertex2d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2dv" "glVertex2dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2f" "glVertex2f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2fv" "glVertex2fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2i" "glVertex2i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2iv" "glVertex2iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2s" "glVertex2s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2sv" "glVertex2sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3d" "glVertex3d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3dv" "glVertex3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3f" "glVertex3f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3fv" "glVertex3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3i" "glVertex3i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3iv" "glVertex3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3s" "glVertex3s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3sv" "glVertex3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4d" "glVertex4d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4dv" "glVertex4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4f" "glVertex4f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4fv" "glVertex4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4i" "glVertex4i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4iv" "glVertex4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4s" "glVertex4s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4sv" "glVertex4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexPointer" "glVertexPointer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_stride))
  (cl::let ((SWIG_arg3 PARM3_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glViewport" "glViewport")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluErrorString" "gluErrorString")
  ((:p+ PARM0_errCode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* #.(swig-insert-id "GLubyte" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_errCode))
    (cl:let* ((address (swig-ff-call SWIG_arg0)))
    (cl:setq ACL_ffresult (cl:if (cl:eq address 0) 0
      	     		  	 (excl:native-to-string address))))  )
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluErrorUnicodeStringEXT" "gluErrorUnicodeStringEXT")
  ((:p+ PARM0_errCode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* :unsigned-short) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_errCode))
  (cl::setq ACL_ffresult (excl:native-to-string (swig-ff-call SWIG_arg0)
:external-format #+little-endian :fat-le #-little-endian :fat)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluGetString" "gluGetString")
  ((:p+ PARM0_name  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* #.(swig-insert-id "GLubyte" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
    (cl:let* ((address (swig-ff-call SWIG_arg0)))
    (cl:setq ACL_ffresult (cl:if (cl:eq address 0) 0
      	     		  	 (excl:native-to-string address))))  )
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluOrtho2D" "gluOrtho2D")
  ((:p+ PARM0_left  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_right  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_bottom  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_top  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_left))
  (cl::let ((SWIG_arg1 PARM1_right))
  (cl::let ((SWIG_arg2 PARM2_bottom))
  (cl::let ((SWIG_arg3 PARM3_top))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPerspective" "gluPerspective")
  ((:p+ PARM0_fovy  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_aspect  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_zNear  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_zFar  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_fovy))
  (cl::let ((SWIG_arg1 PARM1_aspect))
  (cl::let ((SWIG_arg2 PARM2_zNear))
  (cl::let ((SWIG_arg3 PARM3_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPickMatrix" "gluPickMatrix")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_viewport  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_viewport))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluLookAt" "gluLookAt")
  ((:p+ PARM0_eyex  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_eyey  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_eyez  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_centerx  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_centery  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_centerz  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM6_upx  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM7_upy  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM8_upz  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_eyex))
  (cl::let ((SWIG_arg1 PARM1_eyey))
  (cl::let ((SWIG_arg2 PARM2_eyez))
  (cl::let ((SWIG_arg3 PARM3_centerx))
  (cl::let ((SWIG_arg4 PARM4_centery))
  (cl::let ((SWIG_arg5 PARM5_centerz))
  (cl::let ((SWIG_arg6 PARM6_upx))
  (cl::let ((SWIG_arg7 PARM7_upy))
  (cl::let ((SWIG_arg8 PARM8_upz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluProject" "gluProject")
  ((:p+ PARM0_objx  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_objy  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_objz  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_modelMatrix  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM4_projMatrix  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM5_viewport  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM6_winx  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM7_winy  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM8_winz  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_objx))
  (cl::let ((SWIG_arg1 PARM1_objy))
  (cl::let ((SWIG_arg2 PARM2_objz))
  (cl::let ((SWIG_arg3 PARM3_modelMatrix))
  (cl::let ((SWIG_arg4 PARM4_projMatrix))
  (cl::let ((SWIG_arg5 PARM5_viewport))
  (cl::let ((SWIG_arg6 PARM6_winx))
  (cl::let ((SWIG_arg7 PARM7_winy))
  (cl::let ((SWIG_arg8 PARM8_winz))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluUnProject" "gluUnProject")
  ((:p+ PARM0_winx  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_winy  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_winz  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_modelMatrix  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM4_projMatrix  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM5_viewport  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM6_objx  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM7_objy  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM8_objz  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_winx))
  (cl::let ((SWIG_arg1 PARM1_winy))
  (cl::let ((SWIG_arg2 PARM2_winz))
  (cl::let ((SWIG_arg3 PARM3_modelMatrix))
  (cl::let ((SWIG_arg4 PARM4_projMatrix))
  (cl::let ((SWIG_arg5 PARM5_viewport))
  (cl::let ((SWIG_arg6 PARM6_objx))
  (cl::let ((SWIG_arg7 PARM7_objy))
  (cl::let ((SWIG_arg8 PARM8_objz))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluScaleImage" "gluScaleImage")
  ((:p+ PARM0_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_widthin  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_heightin  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_typein  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_datain  (* :void) )
   (:p+ PARM5_widthout  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_heightout  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_typeout  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM8_dataout  (* :void) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_format))
  (cl::let ((SWIG_arg1 PARM1_widthin))
  (cl::let ((SWIG_arg2 PARM2_heightin))
  (cl::let ((SWIG_arg3 PARM3_typein))
  (cl::let ((SWIG_arg4 PARM4_datain))
  (cl::let ((SWIG_arg5 PARM5_widthout))
  (cl::let ((SWIG_arg6 PARM6_heightout))
  (cl::let ((SWIG_arg7 PARM7_typeout))
  (cl::let ((SWIG_arg8 PARM8_dataout))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild1DMipmaps" "gluBuild1DMipmaps")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_components  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_data  (* :void) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_components))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_format))
  (cl::let ((SWIG_arg4 PARM4_type))
  (cl::let ((SWIG_arg5 PARM5_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild2DMipmaps" "gluBuild2DMipmaps")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_components  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_data  (* :void) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_components))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNewQuadric" "gluNewQuadric")
  (:void)
  (:returning ((* #.(swig-insert-id "GLUquadric" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance 'ff:foreign-pointer :foreign-address address)))
     (cl:when (cl:and nil (cl:not (cl:zerop address)))
       (excl:schedule-finalization new-inst #'identity))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDeleteQuadric" "gluDeleteQuadric")
  ((:p+ PARM0_state  (* #.(swig-insert-id "GLUquadric" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_state))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricNormals" "gluQuadricNormals")
  ((:p+ PARM0_quadObject  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_normals  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quadObject))
  (cl::let ((SWIG_arg1 PARM1_normals))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricTexture" "gluQuadricTexture")
  ((:p+ PARM0_quadObject  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_textureCoords  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quadObject))
  (cl::let ((SWIG_arg1 PARM1_textureCoords))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricOrientation" "gluQuadricOrientation")
  ((:p+ PARM0_quadObject  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_orientation  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quadObject))
  (cl::let ((SWIG_arg1 PARM1_orientation))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricDrawStyle" "gluQuadricDrawStyle")
  ((:p+ PARM0_quadObject  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_drawStyle  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quadObject))
  (cl::let ((SWIG_arg1 PARM1_drawStyle))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluCylinder" "gluCylinder")
  ((:p+ PARM0_qobj  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_baseRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_topRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_qobj))
  (cl::let ((SWIG_arg1 PARM1_baseRadius))
  (cl::let ((SWIG_arg2 PARM2_topRadius))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_slices))
  (cl::let ((SWIG_arg5 PARM5_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDisk" "gluDisk")
  ((:p+ PARM0_qobj  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_innerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_outerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_loops  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_qobj))
  (cl::let ((SWIG_arg1 PARM1_innerRadius))
  (cl::let ((SWIG_arg2 PARM2_outerRadius))
  (cl::let ((SWIG_arg3 PARM3_slices))
  (cl::let ((SWIG_arg4 PARM4_loops))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPartialDisk" "gluPartialDisk")
  ((:p+ PARM0_qobj  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_innerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_outerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_loops  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_startAngle  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM6_sweepAngle  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_qobj))
  (cl::let ((SWIG_arg1 PARM1_innerRadius))
  (cl::let ((SWIG_arg2 PARM2_outerRadius))
  (cl::let ((SWIG_arg3 PARM3_slices))
  (cl::let ((SWIG_arg4 PARM4_loops))
  (cl::let ((SWIG_arg5 PARM5_startAngle))
  (cl::let ((SWIG_arg6 PARM6_sweepAngle))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluSphere" "gluSphere")
  ((:p+ PARM0_qobj  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_radius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_qobj))
  (cl::let ((SWIG_arg1 PARM1_radius))
  (cl::let ((SWIG_arg2 PARM2_slices))
  (cl::let ((SWIG_arg3 PARM3_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricCallback" "gluQuadricCallback")
  ((:p+ PARM0_qobj  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_fn  (* (:function ( ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_qobj))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_fn))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNewTess" "gluNewTess")
  (:void)
  (:returning ((* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance 'ff:foreign-pointer :foreign-address address)))
     (cl:when (cl:and nil (cl:not (cl:zerop address)))
       (excl:schedule-finalization new-inst #'identity))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDeleteTess" "gluDeleteTess")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessBeginPolygon" "gluTessBeginPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_polygon_data  (* :void) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_polygon_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessBeginContour" "gluTessBeginContour")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessVertex" "gluTessVertex")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_coords  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM2_data  (* :void) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_coords))
  (cl::let ((SWIG_arg2 PARM2_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessEndContour" "gluTessEndContour")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessEndPolygon" "gluTessEndPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessProperty" "gluTessProperty")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_value  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessNormal" "gluTessNormal")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessCallback" "gluTessCallback")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_fn  (* (:function ( ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_fn))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluGetTessProperty" "gluGetTessProperty")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNewNurbsRenderer" "gluNewNurbsRenderer")
  (:void)
  (:returning ((* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance 'ff:foreign-pointer :foreign-address address)))
     (cl:when (cl:and nil (cl:not (cl:zerop address)))
       (excl:schedule-finalization new-inst #'identity))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDeleteNurbsRenderer" "gluDeleteNurbsRenderer")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBeginSurface" "gluBeginSurface")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBeginCurve" "gluBeginCurve")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndCurve" "gluEndCurve")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndSurface" "gluEndSurface")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBeginTrim" "gluBeginTrim")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndTrim" "gluEndTrim")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPwlCurve" "gluPwlCurve")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_count  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_array  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_array))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsCurve" "gluNurbsCurve")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_nknots  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_knot  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_ctlarray  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM5_order  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (cl::let ((SWIG_arg1 PARM1_nknots))
  (cl::let ((SWIG_arg2 PARM2_knot))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_ctlarray))
  (cl::let ((SWIG_arg5 PARM5_order))
  (cl::let ((SWIG_arg6 PARM6_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsSurface" "gluNurbsSurface")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_sknot_count  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_sknot  (* :float) )
   (:p+ PARM3_tknot_count  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_tknot  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM5_s_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_t_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_ctlarray  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM8_sorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_torder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM10_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (cl::let ((SWIG_arg1 PARM1_sknot_count))
  (cl::let ((SWIG_arg2 PARM2_sknot))
  (cl::let ((SWIG_arg3 PARM3_tknot_count))
  (cl::let ((SWIG_arg4 PARM4_tknot))
  (cl::let ((SWIG_arg5 PARM5_s_stride))
  (cl::let ((SWIG_arg6 PARM6_t_stride))
  (cl::let ((SWIG_arg7 PARM7_ctlarray))
  (cl::let ((SWIG_arg8 PARM8_sorder))
  (cl::let ((SWIG_arg9 PARM9_torder))
  (cl::let ((SWIG_arg10 PARM10_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9 SWIG_arg10))))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluLoadSamplingMatrices" "gluLoadSamplingMatrices")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_modelMatrix  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM2_projMatrix  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM3_viewport  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (cl::let ((SWIG_arg1 PARM1_modelMatrix))
  (cl::let ((SWIG_arg2 PARM2_projMatrix))
  (cl::let ((SWIG_arg3 PARM3_viewport))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsProperty" "gluNurbsProperty")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_property  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_value  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (cl::let ((SWIG_arg1 PARM1_property))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluGetNurbsProperty" "gluGetNurbsProperty")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_property  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (cl::let ((SWIG_arg1 PARM1_property))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsCallback" "gluNurbsCallback")
  ((:p+ PARM0_nobj  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_fn  (* (:function ( ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nobj))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_fn))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defconstant "GLU_VERSION_1_1" 1)
(swig-defconstant "GLU_VERSION_1_2" 1)
(swig-defconstant "GLU_INVALID_ENUM" 100900)
(swig-defconstant "GLU_INVALID_VALUE" 100901)
(swig-defconstant "GLU_OUT_OF_MEMORY" 100902)
(swig-defconstant "GLU_INCOMPATIBLE_GL_VERSION" 100903)
(swig-defconstant "GLU_VERSION" 100800)
(swig-defconstant "GLU_EXTENSIONS" 100801)
(swig-defconstant "GLU_TRUE" 1)
(swig-defconstant "GLU_FALSE" 0)
(swig-defconstant "GLU_SMOOTH" 100000)
(swig-defconstant "GLU_FLAT" 100001)
(swig-defconstant "GLU_NONE" 100002)
(swig-defconstant "GLU_POINT" 100010)
(swig-defconstant "GLU_LINE" 100011)
(swig-defconstant "GLU_FILL" 100012)
(swig-defconstant "GLU_SILHOUETTE" 100013)
(swig-defconstant "GLU_OUTSIDE" 100020)
(swig-defconstant "GLU_INSIDE" 100021)
(swig-defconstant "GLU_TESS_MAX_COORD" 1.0d150)
(swig-defconstant "GLU_TESS_WINDING_RULE" 100140)
(swig-defconstant "GLU_TESS_BOUNDARY_ONLY" 100141)
(swig-defconstant "GLU_TESS_TOLERANCE" 100142)
(swig-defconstant "GLU_TESS_WINDING_ODD" 100130)
(swig-defconstant "GLU_TESS_WINDING_NONZERO" 100131)
(swig-defconstant "GLU_TESS_WINDING_POSITIVE" 100132)
(swig-defconstant "GLU_TESS_WINDING_NEGATIVE" 100133)
(swig-defconstant "GLU_TESS_WINDING_ABS_GEQ_TWO" 100134)
(swig-defconstant "GLU_TESS_BEGIN" 100100)
(swig-defconstant "GLU_TESS_VERTEX" 100101)
(swig-defconstant "GLU_TESS_END" 100102)
(swig-defconstant "GLU_TESS_ERROR" 100103)
(swig-defconstant "GLU_TESS_EDGE_FLAG" 100104)
(swig-defconstant "GLU_TESS_COMBINE" 100105)
(swig-defconstant "GLU_TESS_BEGIN_DATA" 100106)
(swig-defconstant "GLU_TESS_VERTEX_DATA" 100107)
(swig-defconstant "GLU_TESS_END_DATA" 100108)
(swig-defconstant "GLU_TESS_ERROR_DATA" 100109)
(swig-defconstant "GLU_TESS_EDGE_FLAG_DATA" 100110)
(swig-defconstant "GLU_TESS_COMBINE_DATA" 100111)
(swig-defconstant "GLU_TESS_ERROR1" 100151)
(swig-defconstant "GLU_TESS_ERROR2" 100152)
(swig-defconstant "GLU_TESS_ERROR3" 100153)
(swig-defconstant "GLU_TESS_ERROR4" 100154)
(swig-defconstant "GLU_TESS_ERROR5" 100155)
(swig-defconstant "GLU_TESS_ERROR6" 100156)
(swig-defconstant "GLU_TESS_ERROR7" 100157)
(swig-defconstant "GLU_TESS_ERROR8" 100158)
(swig-defconstant "GLU_TESS_MISSING_BEGIN_POLYGON" 100151)
(swig-defconstant "GLU_TESS_MISSING_BEGIN_CONTOUR" 100152)
(swig-defconstant "GLU_TESS_MISSING_END_POLYGON" 100153)
(swig-defconstant "GLU_TESS_MISSING_END_CONTOUR" 100154)
(swig-defconstant "GLU_TESS_COORD_TOO_LARGE" 100155)
(swig-defconstant "GLU_TESS_NEED_COMBINE_CALLBACK" 100156)
(swig-defconstant "GLU_AUTO_LOAD_MATRIX" 100200)
(swig-defconstant "GLU_CULLING" 100201)
(swig-defconstant "GLU_SAMPLING_TOLERANCE" 100203)
(swig-defconstant "GLU_DISPLAY_MODE" 100204)
(swig-defconstant "GLU_PARAMETRIC_TOLERANCE" 100202)
(swig-defconstant "GLU_SAMPLING_METHOD" 100205)
(swig-defconstant "GLU_U_STEP" 100206)
(swig-defconstant "GLU_V_STEP" 100207)
(swig-defconstant "GLU_PATH_LENGTH" 100215)
(swig-defconstant "GLU_PARAMETRIC_ERROR" 100216)
(swig-defconstant "GLU_DOMAIN_DISTANCE" 100217)
(swig-defconstant "GLU_MAP1_TRIM_2" 100210)
(swig-defconstant "GLU_MAP1_TRIM_3" 100211)
(swig-defconstant "GLU_OUTLINE_POLYGON" 100240)
(swig-defconstant "GLU_OUTLINE_PATCH" 100241)
(swig-defconstant "GLU_NURBS_ERROR1" 100251)
(swig-defconstant "GLU_NURBS_ERROR2" 100252)
(swig-defconstant "GLU_NURBS_ERROR3" 100253)
(swig-defconstant "GLU_NURBS_ERROR4" 100254)
(swig-defconstant "GLU_NURBS_ERROR5" 100255)
(swig-defconstant "GLU_NURBS_ERROR6" 100256)
(swig-defconstant "GLU_NURBS_ERROR7" 100257)
(swig-defconstant "GLU_NURBS_ERROR8" 100258)
(swig-defconstant "GLU_NURBS_ERROR9" 100259)
(swig-defconstant "GLU_NURBS_ERROR10" 100260)
(swig-defconstant "GLU_NURBS_ERROR11" 100261)
(swig-defconstant "GLU_NURBS_ERROR12" 100262)
(swig-defconstant "GLU_NURBS_ERROR13" 100263)
(swig-defconstant "GLU_NURBS_ERROR14" 100264)
(swig-defconstant "GLU_NURBS_ERROR15" 100265)
(swig-defconstant "GLU_NURBS_ERROR16" 100266)
(swig-defconstant "GLU_NURBS_ERROR17" 100267)
(swig-defconstant "GLU_NURBS_ERROR18" 100268)
(swig-defconstant "GLU_NURBS_ERROR19" 100269)
(swig-defconstant "GLU_NURBS_ERROR20" 100270)
(swig-defconstant "GLU_NURBS_ERROR21" 100271)
(swig-defconstant "GLU_NURBS_ERROR22" 100272)
(swig-defconstant "GLU_NURBS_ERROR23" 100273)
(swig-defconstant "GLU_NURBS_ERROR24" 100274)
(swig-defconstant "GLU_NURBS_ERROR25" 100275)
(swig-defconstant "GLU_NURBS_ERROR26" 100276)
(swig-defconstant "GLU_NURBS_ERROR27" 100277)
(swig-defconstant "GLU_NURBS_ERROR28" 100278)
(swig-defconstant "GLU_NURBS_ERROR29" 100279)
(swig-defconstant "GLU_NURBS_ERROR30" 100280)
(swig-defconstant "GLU_NURBS_ERROR31" 100281)
(swig-defconstant "GLU_NURBS_ERROR32" 100282)
(swig-defconstant "GLU_NURBS_ERROR33" 100283)
(swig-defconstant "GLU_NURBS_ERROR34" 100284)
(swig-defconstant "GLU_NURBS_ERROR35" 100285)
(swig-defconstant "GLU_NURBS_ERROR36" 100286)
(swig-defconstant "GLU_NURBS_ERROR37" 100287)
(swig-defun ("gluBeginPolygon" "gluBeginPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNextContour" "gluNextContour")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndPolygon" "gluEndPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defconstant "GLU_CW" 100120)
(swig-defconstant "GLU_CCW" 100121)
(swig-defconstant "GLU_INTERIOR" 100122)
(swig-defconstant "GLU_EXTERIOR" 100123)
(swig-defconstant "GLU_UNKNOWN" 100124)
(swig-defconstant "GLU_BEGIN" 100100)
(swig-defconstant "GLU_VERTEX" 100101)
(swig-defconstant "GLU_END" 100102)
(swig-defconstant "GLU_ERROR" 100103)
(swig-defconstant "GLU_EDGE_FLAG" 100104)

(in-package :swig.opengl)

(macrolet ((swig-do-export ()
                 `(dolist (s ',*swig-export-list*)
                    (apply #'export s))))
   (swig-do-export))

(setq *swig-export-list* nil)

