;; $Id: deliver.cl,v 1.4 2004/03/21 15:48:10 layer Exp $

(in-package :user)

(setq excl::*break-on-warnings* t)

(when *console-app*
  (push :testapp-windows-console-app *features*))

(compile-file "test.cl")

(generate-application
 "test"
 "dist/"
 (append (when *debug-testapp* '(:inspect :trace))
	 '(#-mswindows :process :list2 :seq2 "test.fasl"))
 :restart-init-function 'main
 #-mswindows
 :application-administration
 #-mswindows ;; Quiet startup (See below for Windows version of this.)
 '(:resource-command-line "-Q")
 :read-init-files nil			; don't read ACL init files
 :print-startup-message nil		; don't print ACL startup messages
 :ignore-command-line-arguments t	; ignore ACL (not app) cmd line options
 :suppress-allegro-cl-banner t

 ;; Change the following to `t', if:
 ;; - the program (vs. data) is large
 ;; - you'll have lots of users of the app (so sharing the code is important)
 :purify nil

 ;; don't give autoload warning, but you should still be aware that
 ;; autoloads.out will contain a list of autoloadable names.
 :autoload-warning nil

 :include-debugger *debug-testapp*
 :include-tpl *debug-testapp*
 :include-ide nil
 :include-devel-env nil
 :include-compiler nil
 :discard-arglists (not *debug-testapp*)
 :discard-local-name-info (not *debug-testapp*)
 :discard-source-file-info (not *debug-testapp*)
 :discard-xref-info (not *debug-testapp*)
 
 ;; for debugging:
 :verbose nil
 :build-input "build.in"
 :build-output "build.out"
 
 :runtime :standard
 )

#+mswindows ;; Quiet startup:
(when (not *console-app*)
  (run-shell-command
   ;; Replace +cm with +cn to see the window, but have it not be in the
   ;; foreground.
   (format nil "\"~a\" -o dist/test.exe +B +M +cm -Q"
	   (translate-logical-pathname "sys:bin;setcmd.exe"))
   :show-window :hide))

#+mswindows
(when *console-app*
  (delete-file "dist/test.exe")
  (sys:copy-file "sys:buildi.exe" "dist/test.exe"))
