;/* example-start arrow arrow.c */
;
;#include <gtk/gtk.h>
;
;/* Create an Arrow widget with the specified parameters
; * and pack it into a button */
;GtkWidget *create_arrow_button( GtkArrowType  arrow_type,
;				 GtkShadowType shadow_type )
;{
;  GtkWidget *button;
;  GtkWidget *arrow;
;
;  button = gtk_button_new();
;  arrow = gtk_arrow_new (arrow_type, shadow_type);
;
;  gtk_container_add (GTK_CONTAINER (button), arrow);
;  
;  gtk_widget_show(button);
;  gtk_widget_show(arrow);
;
;  return(button);
;}
;
;int main( int   argc,
;	   char *argv[] )
;{
;  /* GtkWidget is the storage type for widgets */
;  GtkWidget *window;
;  GtkWidget *button;
;  GtkWidget *box;
;
;  /* Initialize the toolkit */
;  gtk_init (&argc, &argv);
;
;  /* Create a new window */
;  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
;
;  gtk_window_set_title (GTK_WINDOW (window), "Arrow Buttons");
;
;  /* It's a good idea to do this for all windows. */
;  gtk_signal_connect (GTK_OBJECT (window), "destroy",
;		       GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
;
;  /* Sets the border width of the window. */
;  gtk_container_set_border_width (GTK_CONTAINER (window), 10);
;
;  /* Create a box to hold the arrows/buttons */
;  box = gtk_hbox_new (FALSE, 0);
;  gtk_container_set_border_width (GTK_CONTAINER (box), 2);
;  gtk_container_add (GTK_CONTAINER (window), box);
;
;  /* Pack and show all our widgets */
;  gtk_widget_show(box);
;
;  button = create_arrow_button(GTK_ARROW_UP, GTK_SHADOW_IN);
;  gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 3);
;
;  button = create_arrow_button(GTK_ARROW_DOWN, GTK_SHADOW_OUT);
;  gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 3);
;  
;  button = create_arrow_button(GTK_ARROW_LEFT, GTK_SHADOW_ETCHED_IN);
;  gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 3);
;  
;  button = create_arrow_button(GTK_ARROW_RIGHT, GTK_SHADOW_ETCHED_OUT);
;  gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 3);
;  
;  gtk_widget_show (window);
;  
;  /* Rest in gtk_main and wait for the fun to begin! */
;  gtk_main ();
;  
;  return(0);
;}
;/* example-end */

(defpackage "09.02-arrow" (:use :excl :common-lisp))
(in-package "09.02-arrow")

(defun create-arrow-button (arrow-type shadow-type)
  (let ((button (gtk:gtk_button_new))
	(arrow (gtk:gtk_arrow_new arrow-type shadow-type)))

    (gtk:gtk_container_add (gtk:GTK_CONTAINER button) arrow)
    (gtk:gtk_widget_show button)
    (gtk:gtk_widget_show arrow)

    button))

(ff:defun-foreign-callable cb-gtk-main-quit ()
  (gtk:gtk-main-quit))

(defun arrow ()
  (let ((window nil)
	(button nil)
	(box nil))

    (gtk:gtk_init 0 0)
    (setq window (gtk:gtk_window_new gtk:GTK_WINDOW_TOPLEVEL))
    (gtk:gtk_window_set_title (gtk:GTK_WINDOW window) "Arrow Buttons")
    (gtk:gtk_signal_connect (gtk:GTK_OBJECT window) "destroy"
			    (gtk:GTK_SIGNAL_FUNC
			     #+original (ff:get-entry-point "gtk_main_quit")
			     #-original (ff:register-foreign-callable
					 'cb-gtk-main-quit))
			    gtk:NULL)
    (gtk:gtk_container_set_border_width (gtk:GTK_CONTAINER window) 10)
    (setq box (gtk:gtk_hbox_new gtk:FALSE 0))
    (gtk:gtk_container_set_border_width (gtk:GTK_CONTAINER box) 2)
    (gtk:gtk_container_add (gtk:GTK_CONTAINER window) box)

    (gtk:gtk_widget_show box)

    (setq button (create-arrow-button gtk:GTK_ARROW_UP gtk:GTK_SHADOW_IN))

    ;; extra
    (let ((tooltips (gtk:gtk_tooltips_new)))
      (gtk:gtk_tooltips_set_tip tooltips button "This is UP button" gtk:NULL))

    (gtk:gtk_box_pack_start (gtk:GTK_BOX box) button gtk:FALSE gtk:FALSE 3)

    (setq button (create-arrow-button gtk:GTK_ARROW_DOWN gtk:GTK_SHADOW_OUT))
    (gtk:gtk_box_pack_start (gtk:GTK_BOX box) button gtk:FALSE gtk:FALSE 3)

    (setq button (create-arrow-button gtk:GTK_ARROW_LEFT
				      gtk:GTK_SHADOW_ETCHED_IN))
    (gtk:gtk_box_pack_start (gtk:GTK_BOX box) button gtk:FALSE gtk:FALSE 3)

    (setq button (create-arrow-button gtk:GTK_ARROW_RIGHT
				      gtk:GTK_SHADOW_ETCHED_OUT))
    (gtk:gtk_box_pack_start (gtk:GTK_BOX box) button gtk:FALSE gtk:FALSE 3)

    (gtk:gtk_widget_show window)

    #+original (gtk:gtk_main)
    #-original (gtk:gtk-main)))

(flet ((run-example (name function)
	 ;; workaround for bogus (imo) redef. warnings generated by defvar
	 (declare (special gtk::*run-example*))
	 (unless (boundp 'gtk::*run-example*)
	   (setq gtk::*run-example* t))
	 (when gtk::*run-example*
	   (mp:process-run-function
	    (format nil "GTK+ Example: ~a" name)
	    function))))
  (run-example "09.02-arrow" #'arrow))
