;;
;; copyright (c) 1996-2000 Franz Inc, Berkeley, CA  - All rights reserved.
;; copyright (c) 2000-2004 Franz Inc, Oakland, CA - All rights reserved.
;;
;; The software, data and information contained herein are proprietary
;; to, and comprise valuable trade secrets of, Franz, Inc.  They are
;; given in confidence by Franz, Inc. pursuant to a written license
;; agreement, and may be stored and used only in accordance with the terms
;; of such license.
;;
;; Restricted Rights Legend
;; ------------------------
;; Use, duplication, and disclosure of the software, data and information
;; contained herein by any agency, department or entity of the U.S.
;; Government are subject to restrictions of Restricted Rights for
;; Commercial Software developed at private expense as specified in 
;; DOD FAR Supplement 52.227-7013 (c) (1) (ii), as applicable.

;; $Id: gtk12.cl,v 1.4 2004/01/16 19:24:53 layer Exp $

;; This file is derived from the output of Allegro CL Lisp-to-C Binder
;; Version 1.6.1(1.6.1).  The original is at the bottom of this file
;; following the line including "Begin Original".

;; Copy of cbind/cdbind.cl
;;
(eval-when (load compile eval)
  ;; poor man's require
  (unless (fboundp (find-symbol (string :bind-c-constant) 'ff))
    (load (compile-file-if-needed "/net/fritter/home/cox/gtk/cdbind.cl"))))

(defpackage :gtk
  (:use common-lisp)
  (:import-from :excl :if* :then :else :elseif :thenret))

(in-package :gtk)

;; Have not yet figured out what determines this value
(defvar gpointer-to-string-ef :default)

#+linuxppc (setq gpointer-to-string-ef :fat)

(eval-when (compile load eval)
  (export 'gpointer-to-string-ef))

(eval-when (load)
  (unless (eq #.excl:*current-case-mode* excl:*current-case-mode*)
    (with-simple-restart (continue-loading-file "Continue loading the file.")
      (error "~
The current case mode does not match that used when compiling this file.  ~
Continuing to load this file may result in inconsistent definitions.  ~
Recompilation is recommended."))))

#+removed
(defmacro skip-in-ansi-mode (name type
			     &body body)
  (if* (eq ':case-insensitive-upper
	   excl:*current-case-mode*)
     then `(warn "~
The ~a definition for ~s is being skipped in ANSI mode because this ~
definition conflicts with another definition whose name differs only by case."
		 ',type ',name)
     else `(progn
	     ,@body)))

;; Copied from cbind/cmnbind.cl.
;; Should this be in cdbind.cl?
(in-package :ff)

(def-foreign-type dummy-forward-struct (:struct (nil (:array :int 1))))

(def-foreign-type boolean :int)

(def-foreign-type hold    ;;; <60> holder for unsigned conversions
    (:union 
     (signed-long :long)
     (unsigned-long :unsigned-long)
     (short-holder (:struct (dummy-short :short) (unsigned-short :short)))
     (byte-holder (:struct (dummy-bytes (:array :char 3)) 
			    (unsigned-byte :unsigned-char)))))

;; these will get the storage right (if not the alignement) ??? <65>

(def-foreign-type long-long (:struct (nil :long) (nil :long)))

(def-foreign-type unsigned-long-long (:struct (nil :long) (nil :long)))

(def-foreign-type long-double (:struct (nil :double) (nil :double)))

(def-foreign-type function-pointer (* :void))

;; bug11046 workaround
;;
  
;; Wrap macro fwrappers in compile environment
;;
(eval-when (compile)

  (defvar .symbol-types. (make-hash-table))

  (def-fwrapper bind-c-type-symbol-types-wrapper (&rest args)
    (destructuring-bind ((macrof-name id &rest def) &rest macrof-args) args
      (declare (ignore macrof-name macrof-args))
      (let ((result (list (call-next-fwrapper))))
	(when (and (null (cdr def))
		   (symbolp (car def)))
	  (pushnew id (gethash (car def) .symbol-types.)))
	(dolist (prev-def (gethash id .symbol-types.))
	  #+debug (format t "~&; Redefining ~s to ~s~%" prev-def id)
	  (push `(bind-c-type ,prev-def ,id) result))
	(cons 'progn (nreverse result)))))

  (fwrap 'ff:bind-c-typedef :bind-c-type-symbol-types-wrapper
	 'bind-c-type-symbol-types-wrapper)
  (fwrap 'ff:bind-c-type :bind-c-type-symbol-types-wrapper
	 'bind-c-type-symbol-types-wrapper)
  )

(eval-when (compile load eval)

  (def-fwrapper bind-c-function-char*-wrapper (&rest args)
    (declare (ignore args))
    (let* ((result (call-next-fwrapper))
	   (nresult nil))
      (dolist (r result)
	(if* (and (listp r)
		  (eq 'ff:def-foreign-call (car r)))
	   then (let ((args (third r))
		      (nargs nil))
		  (dolist (arg args)
		    (if* (and (listp arg)
			      (equal '(* :char) (second arg))
			      (null (rest (rest arg))))
		       then ;; We have (x (* :char)).
			    ;; Change it to
			    ;; (x (* :char)
			    ;;    (or string
			    ;;        (array (unsigned-byte 8) (*))
			    ;;        integer))
			    (push (list (first arg)
					(second arg)
					'(or string
					  (array (unsigned-byte 8) (*))
					  integer))
				  nargs)
		       else (push arg nargs)))
		  (setq nargs (nreverse nargs))
		  (push (cons (first r)
			      (cons (second r)
				    (cons nargs
					  (rest (rest (rest r))))))
			nresult))
	   else (push r nresult)))
      (setq nresult (nreverse nresult))
      nresult))

  (fwrap 'ff:bind-c-function :bind-c-function-char*-wrapper
	 'bind-c-function-char*-wrapper)
  )

(cl:in-package #:gtk)


;; ---------------------------------------------------

;; /usr/include/float.h:25 <1> extern int __flt_rounds( void);
(ff:bind-c-function __flt_rounds
     :unconverted-entry-name "__flt_rounds"
     :c-modifiers ("extern")
     :c-return-type ("int")
     :return-type :int
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:28 <2> 
;; typedef signed char gint8;
(ff:bind-c-type gint8 :char)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:29 <3> 
;; typedef unsigned char guint8;
(ff:bind-c-type guint8 :unsigned-char)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:30 <4> 
;; typedef signed short gint16;
(ff:bind-c-type gint16 :short)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:31 <5> 
;; typedef unsigned short guint16;
(ff:bind-c-type guint16 :unsigned-short)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:32 <6> 
;; typedef signed int gint32;
(ff:bind-c-type gint32 :int)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:33 <7> 
;; typedef unsigned int guint32;
(ff:bind-c-type guint32 :unsigned-int)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:43 <8> 
;; typedef signed long long gint64;

;;WARNING:  'long long' is implemented as a struct of 2 long!
(ff:bind-c-type gint64 ff:long-long)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:44 <9> 
;; typedef unsigned long long guint64;

;;WARNING:  'long long' is implemented as a struct of 2 long!
(ff:bind-c-type guint64 ff:unsigned-long-long)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:79 <10> 
;; typedef struct _GStaticMutex GStaticMutex;
(ff:bind-c-typedef _GStaticMutex
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStaticMutex _GStaticMutex)  

;; /net/fritter/home/cox/gtk/spot/i/lib/glib/include/glibconfig.h:80 <11> 
;; struct _GStaticMutex {
;;         struct _GMutex* runtime_mutex; union {
;;         char pad[  0x000000018]; double dummy_double; void*
;;   dummy_pointer; long
;;    dummy_long; } aligned_pad_u; };
(ff:bind-c-type _GStaticMutex (:struct
  (runtime_mutex (* _GMutex))   ;; struct _GMutex* runtime_mutex
  (aligned_pad_u (:union   ;; union{} aligned_pad_u
    (pad (:array :char 24))   ;; char pad[  0x000000018]
    (dummy_double :double)   ;; double dummy_double
    (dummy_pointer (* :void))   ;; void* dummy_pointer
    (dummy_long :long)   ;; long dummy_long
    ))  ;; slot aligned_pad_u
  ))   ;; bind-c-type _GStaticMutex

;; ---------------------------------------------------

;; /usr/include/sys/va_list.h:26 <12> typedef void* __va_list;
(ff:bind-c-type __va_list (* :void))  

;; ---------------------------------------------------

;; /usr/include/stdarg.h:34 <13> typedef __va_list va_list;
(ff:bind-c-type va_list __va_list)  

;; /usr/include/stdarg.h:82 <14> extern void va_end( va_list);
(ff:bind-c-function va_end
     :unconverted-entry-name "va_end"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("va_list"))
     :c-arg-names (Arg0)
     :arguments (va_list)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:473 <15> 
;; typedef char gchar;
(ff:bind-c-type gchar :char)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:474 <16> 
;; typedef short gshort;
(ff:bind-c-type gshort :short)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:475 <17> 
;; typedef long glong;
(ff:bind-c-type glong :long)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:476 <18> 
;; typedef int gint;
(ff:bind-c-type gint :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:477 <19> 
;; typedef gint gboolean;
(ff:bind-c-type gboolean gint)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:479 <20> 
;; typedef unsigned char guchar;
(ff:bind-c-type guchar :unsigned-char)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:480 <21> 
;; typedef unsigned short gushort;
(ff:bind-c-type gushort :unsigned-short)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:481 <22> 
;; typedef unsigned long gulong;
(ff:bind-c-type gulong :unsigned-long)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:482 <23> 
;; typedef unsigned int guint;
(ff:bind-c-type guint :unsigned-int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:484 <24> 
;; typedef float gfloat;
(ff:bind-c-type gfloat :float)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:485 <25> 
;; typedef double gdouble;
(ff:bind-c-type gdouble :double)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:498 <26> 
;; typedef void* gpointer;
(ff:bind-c-type gpointer (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:499 <27> 
;; typedef const void* gconstpointer;
(ff:bind-c-type gconstpointer (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:502 <28> 
;; typedef gint32 gssize;
(ff:bind-c-type gssize gint32)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:503 <29> 
;; typedef guint32 gsize;
(ff:bind-c-type gsize guint32)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:504 <30> 
;; typedef guint32 GQuark;
(ff:bind-c-type GQuark guint32)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:505 <31> 
;; typedef gint32 GTime;
(ff:bind-c-type GTime gint32)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:676 <32> 
;; extern const guint glib_major_version;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_major_version"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:677 <33> 
;; extern const guint glib_minor_version;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_minor_version"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:678 <34> 
;; extern const guint glib_micro_version;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_micro_version"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:679 <35> 
;; extern const guint glib_interface_age;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_interface_age"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:680 <36> 
;; extern const guint glib_binary_age;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "glib_binary_age"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:690 <37> 
;; typedef struct _GAllocator GAllocator;
(ff:bind-c-typedef _GAllocator
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GAllocator _GAllocator)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:691 <38> 
;; typedef struct _GArray GArray;
(ff:bind-c-typedef _GArray ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GArray _GArray)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:692 <39> 
;; typedef struct _GByteArray GByteArray;
(ff:bind-c-typedef _GByteArray
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GByteArray _GByteArray)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:693 <40> 
;; typedef struct _GCache GCache;
(ff:bind-c-typedef _GCache ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GCache _GCache)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:694 <41> 
;; typedef struct _GCompletion GCompletion;
(ff:bind-c-typedef _GCompletion
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GCompletion _GCompletion)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:695 <42> 
;; typedef struct _GData GData;
(ff:bind-c-typedef _GData ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GData _GData)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:696 <43> 
;; typedef struct _GDebugKey GDebugKey;
(ff:bind-c-typedef _GDebugKey ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GDebugKey _GDebugKey)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:697 <44> 
;; typedef struct _GHashTable GHashTable;
(ff:bind-c-typedef _GHashTable
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GHashTable _GHashTable)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:698 <45> 
;; typedef struct _GHook GHook;
(ff:bind-c-typedef _GHook ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GHook _GHook)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:699 <46> 
;; typedef struct _GHookList GHookList;
(ff:bind-c-typedef _GHookList ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GHookList _GHookList)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:700 <47> 
;; typedef struct _GList GList;
(ff:bind-c-typedef _GList ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GList _GList)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:701 <48> 
;; typedef struct _GMemChunk GMemChunk;
(ff:bind-c-typedef _GMemChunk ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMemChunk _GMemChunk)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:702 <49> 
;; typedef struct _GNode GNode;
(ff:bind-c-typedef _GNode ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GNode _GNode)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:703 <50> 
;; typedef struct _GPtrArray GPtrArray;
(ff:bind-c-typedef _GPtrArray ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GPtrArray _GPtrArray)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:704 <51> 
;; typedef struct _GRelation GRelation;
(ff:bind-c-typedef _GRelation ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GRelation _GRelation)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:705 <52> 
;; typedef struct _GScanner GScanner;
(ff:bind-c-typedef _GScanner ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GScanner _GScanner)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:706 <53> 
;; typedef struct _GScannerConfig GScannerConfig;
(ff:bind-c-typedef _GScannerConfig
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GScannerConfig _GScannerConfig)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:707 <54> 
;; typedef struct _GSList GSList;
(ff:bind-c-typedef _GSList ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSList _GSList)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:708 <55> 
;; typedef struct _GString GString;
(ff:bind-c-typedef _GString ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GString _GString)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:709 <56> 
;; typedef struct _GStringChunk GStringChunk;
(ff:bind-c-typedef _GStringChunk
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStringChunk _GStringChunk)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:710 <57> 
;; typedef struct _GTimer GTimer;
(ff:bind-c-typedef _GTimer ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTimer _GTimer)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:711 <58> 
;; typedef struct _GTree GTree;
(ff:bind-c-typedef _GTree ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GTree _GTree)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:712 <59> 
;; typedef struct _GTuples GTuples;
(ff:bind-c-typedef _GTuples ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTuples _GTuples)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:713 <60> 
;; typedef union _GTokenValue GTokenValue;
(ff:bind-c-typedef _GTokenValue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTokenValue _GTokenValue)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:714 <61> 
;; typedef struct _GIOChannel GIOChannel;
(ff:bind-c-typedef _GIOChannel
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GIOChannel _GIOChannel)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:717 <62> 
;; typedef enum {
;;         G_TRAVERSE_LEAFS =  0x000000001 LSHIFT  0x000000000,
;;   G_TRAVERSE_NON_LEAFS
;;    =  0x000000001 LSHIFT  0x000000001, G_TRAVERSE_ALL = G_TRAVERSE_LEAFS
;;    | G_TRAVERSE_NON_LEAFS, G_TRAVERSE_MASK =  0x000000003 }
;;   GTraverseFlags
;;   ;
(ff:bind-c-constant G_TRAVERSE_LEAFS
                    1) ;;
;;   G_TRAVERSE_LEAFS =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_TRAVERSE_NON_LEAFS
                    2) ;;
;;   G_TRAVERSE_NON_LEAFS =  0x000000001 LSHIFT  0x000000001 

(ff:bind-c-constant G_TRAVERSE_ALL
		    (logior G_TRAVERSE_LEAFS G_TRAVERSE_NON_LEAFS))
;;   G_TRAVERSE_ALL = G_TRAVERSE_LEAFS | G_TRAVERSE_NON_LEAFS
(ff:bind-c-constant G_TRAVERSE_MASK 3) ;;  G_TRAVERSE_MASK =  0x000000003 
(ff:bind-c-type GTraverseFlags :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:726 <63> 
;; typedef enum {
;;         G_IN_ORDER, G_PRE_ORDER, G_POST_ORDER, G_LEVEL_ORDER }
;;   GTraverseType;
(ff:bind-c-constant G_IN_ORDER 0) ;;  G_IN_ORDER 
(ff:bind-c-constant G_PRE_ORDER 1) ;;  G_PRE_ORDER 
(ff:bind-c-constant G_POST_ORDER 2) ;;  G_POST_ORDER 
(ff:bind-c-constant G_LEVEL_ORDER 3) ;;  G_LEVEL_ORDER 
(ff:bind-c-type GTraverseType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:741 <64> 
;; typedef enum {
;;         G_LOG_FLAG_RECURSION =  0x000000001 LSHIFT  0x000000000,
;;   G_LOG_FLAG_FATAL
;;    =  0x000000001 LSHIFT  0x000000001, G_LOG_LEVEL_ERROR =  0x000000001
;;   LSHIFT
;;     0x000000002, G_LOG_LEVEL_CRITICAL =  0x000000001 LSHIFT
;;   0x000000003,
;;              G_LOG_LEVEL_WARNING =  0x000000001 LSHIFT  0x000000004,
;;   G_LOG_LEVEL_MESSAGE
;;    =  0x000000001 LSHIFT  0x000000005, G_LOG_LEVEL_INFO =  0x000000001
;;   LSHIFT
;;     0x000000006, G_LOG_LEVEL_DEBUG =  0x000000001 LSHIFT  0x000000007,
;;   G_LOG_LEVEL_MASK
;;    = ~( G_LOG_FLAG_RECURSION | G_LOG_FLAG_FATAL) } GLogLevelFlags;
(ff:bind-c-constant G_LOG_FLAG_RECURSION
                    1) ;;
;;   G_LOG_FLAG_RECURSION =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_LOG_FLAG_FATAL
                    2) ;;
;;   G_LOG_FLAG_FATAL =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_LOG_LEVEL_ERROR
                    4) ;;
;;   G_LOG_LEVEL_ERROR =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant G_LOG_LEVEL_CRITICAL
                    8) ;;
;;   G_LOG_LEVEL_CRITICAL =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant G_LOG_LEVEL_WARNING
                    16) ;;
;;   G_LOG_LEVEL_WARNING =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant G_LOG_LEVEL_MESSAGE
                    32) ;;
;;   G_LOG_LEVEL_MESSAGE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant G_LOG_LEVEL_INFO
                    64) ;;
;;   G_LOG_LEVEL_INFO =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant G_LOG_LEVEL_DEBUG
                    128) ;;
;;   G_LOG_LEVEL_DEBUG =  0x000000001 LSHIFT  0x000000007 

(ff:bind-c-constant G_LOG_LEVEL_MASK
		    (lognot (logior G_LOG_FLAG_RECURSION G_LOG_FLAG_FATAL)))
;;   G_LOG_LEVEL_MASK = ~( G_LOG_FLAG_RECURSION | G_LOG_FLAG_FATAL) 
(ff:bind-c-type GLogLevelFlags :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:762 <65> 
;; typedef gpointer(* GCacheNewFunc)( gpointer key);
(ff:bind-c-type GCacheNewFunc (* gpointer))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:763 <66> 
;; typedef gpointer(* GCacheDupFunc)( gpointer value);
(ff:bind-c-type GCacheDupFunc (* gpointer))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:764 <67> 
;; typedef void(* GCacheDestroyFunc)( gpointer value);
(ff:bind-c-type GCacheDestroyFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:765 <68> 
;; typedef gint(* GCompareFunc)( gconstpointer a, gconstpointer b);
(ff:bind-c-type GCompareFunc (* gint))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:767 <69> 
;; typedef gchar*(* GCompletionFunc)( gpointer);
(ff:bind-c-type GCompletionFunc (* gchar))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:768 <70> 
;; typedef void(* GDestroyNotify)( gpointer data);
(ff:bind-c-type GDestroyNotify (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:769 <71> 
;; typedef void(* GDataForeachFunc)( GQuark key_id, gpointer data, gpointer
;;    user_data);
(ff:bind-c-type GDataForeachFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:772 <72> 
;; typedef void(* GFunc)( gpointer data, gpointer user_data);
(ff:bind-c-type GFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:774 <73> 
;; typedef guint(* GHashFunc)( gconstpointer key);
(ff:bind-c-type GHashFunc (* guint))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:775 <74> 
;; typedef void(* GFreeFunc)( gpointer data);
(ff:bind-c-type GFreeFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:776 <75> 
;; typedef void(* GHFunc)( gpointer key, gpointer value, gpointer user_data
;;   );
(ff:bind-c-type GHFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:779 <76> 
;; typedef gboolean(* GHRFunc)( gpointer key, gpointer value, gpointer
;;   user_data
;;   );
(ff:bind-c-type GHRFunc (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:782 <77> 
;; typedef gint(* GHookCompareFunc)( GHook* new_hook, GHook* sibling);
(ff:bind-c-type GHookCompareFunc (* gint))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:784 <78> 
;; typedef gboolean(* GHookFindFunc)( GHook* hook, gpointer data);
(ff:bind-c-type GHookFindFunc (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:786 <79> 
;; typedef void(* GHookMarshaller)( GHook* hook, gpointer data);
(ff:bind-c-type GHookMarshaller (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:788 <80> 
;; typedef gboolean(* GHookCheckMarshaller)( GHook* hook, gpointer data);
(ff:bind-c-type GHookCheckMarshaller (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:790 <81> 
;; typedef void(* GHookFunc)( gpointer data);
(ff:bind-c-type GHookFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:791 <82> 
;; typedef gboolean(* GHookCheckFunc)( gpointer data);
(ff:bind-c-type GHookCheckFunc (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:792 <83> 
;; typedef void(* GHookFreeFunc)( GHookList* hook_list, GHook* hook);
(ff:bind-c-type GHookFreeFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:794 <84> 
;; typedef void(* GLogFunc)( const gchar* log_domain, GLogLevelFlags
;;   log_level,
;;              const gchar* message, gpointer user_data);
(ff:bind-c-type GLogFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:798 <85> 
;; typedef gboolean(* GNodeTraverseFunc)( GNode* node, gpointer data);
(ff:bind-c-type GNodeTraverseFunc (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:800 <86> 
;; typedef void(* GNodeForeachFunc)( GNode* node, gpointer data);
(ff:bind-c-type GNodeForeachFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:802 <87> 
;; typedef gint(* GSearchFunc)( gpointer key, gpointer data);
(ff:bind-c-type GSearchFunc (* gint))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:804 <88> 
;; typedef void(* GScannerMsgFunc)( GScanner* scanner, gchar* message, gint
;;    error);
(ff:bind-c-type GScannerMsgFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:807 <89> 
;; typedef gint(* GTraverseFunc)( gpointer key, gpointer value, gpointer
;;    data);
(ff:bind-c-type GTraverseFunc (* gint))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:810 <90> 
;; typedef void(* GVoidFunc)( void);
(ff:bind-c-type GVoidFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:813 <91> 
;; struct _GList { gpointer data; GList* next; GList* prev; };
(ff:bind-c-type _GList (:struct
  (data gpointer)   ;; gpointer data
  (next (* GList))   ;; GList* next
  (prev (* GList))   ;; GList* prev
  ))   ;; bind-c-type _GList

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:820 <92> 
;; struct _GSList { gpointer data; GSList* next; };
(ff:bind-c-type _GSList (:struct
  (data gpointer)   ;; gpointer data
  (next (* GSList))   ;; GSList* next
  ))   ;; bind-c-type _GSList

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:826 <93> 
;; struct _GString { gchar* str; gint len; };
(ff:bind-c-type _GString (:struct
  (str (* gchar))   ;; gchar* str
  (len gint)   ;; gint len
  ))   ;; bind-c-type _GString

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:832 <94> 
;; struct _GArray { gchar* data; guint len; };
(ff:bind-c-type _GArray (:struct
  (data (* gchar))   ;; gchar* data
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GArray

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:838 <95> 
;; struct _GByteArray { guint8* data; guint len; };
(ff:bind-c-type _GByteArray (:struct
  (data (* guint8))   ;; guint8* data
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GByteArray

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:844 <96> 
;; struct _GPtrArray { gpointer* pdata; guint len; };
(ff:bind-c-type _GPtrArray (:struct
  (pdata (* gpointer))   ;; gpointer* pdata
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GPtrArray

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:850 <97> 
;; struct _GTuples { guint len; };
(ff:bind-c-type _GTuples (:struct
  (len guint)   ;; guint len
  ))   ;; bind-c-type _GTuples

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:855 <98> 
;; struct _GDebugKey { gchar* key; guint value; };
(ff:bind-c-type _GDebugKey (:struct
  (key (* gchar))   ;; gchar* key
  (value guint)   ;; guint value
  ))   ;; bind-c-type _GDebugKey

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:864 <99> 
;; void g_list_push_allocator( GAllocator* allocator);
(ff:bind-c-function g_list_push_allocator
     :unconverted-entry-name "g_list_push_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:865 <100> 
;; void g_list_pop_allocator( void);
(ff:bind-c-function g_list_pop_allocator
     :unconverted-entry-name "g_list_pop_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:866 <101> 
;; GList* g_list_alloc( void);
(ff:bind-c-function g_list_alloc
     :unconverted-entry-name "g_list_alloc"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:867 <102> 
;; void g_list_free( GList* list);
(ff:bind-c-function g_list_free
     :unconverted-entry-name "g_list_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:868 <103> 
;; void g_list_free_1( GList* list);
(ff:bind-c-function g_list_free_1
     :unconverted-entry-name "g_list_free_1"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:869 <104> 
;; GList* g_list_append( GList* list, gpointer data);
(ff:bind-c-function g_list_append
     :unconverted-entry-name "g_list_append"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:871 <105> 
;; GList* g_list_prepend( GList* list, gpointer data);
(ff:bind-c-function g_list_prepend
     :unconverted-entry-name "g_list_prepend"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:873 <106> 
;; GList* g_list_insert( GList* list, gpointer data, gint position);
(ff:bind-c-function g_list_insert
     :unconverted-entry-name "g_list_insert"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer") ("gint"))
     :c-arg-names (list data position)
     :arguments ((* GList) gpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:876 <107> 
;; GList* g_list_insert_sorted( GList* list, gpointer data, GCompareFunc
;;    func);
(ff:bind-c-function g_list_insert_sorted
     :unconverted-entry-name "g_list_insert_sorted"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GList) gpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:879 <108> 
;; GList* g_list_concat( GList* list1, GList* list2);
(ff:bind-c-function g_list_concat
     :unconverted-entry-name "g_list_concat"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GList" "*"))
     :c-arg-names (list1 list2)
     :arguments ((* GList) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:881 <109> 
;; GList* g_list_remove( GList* list, gpointer data);
(ff:bind-c-function g_list_remove
     :unconverted-entry-name "g_list_remove"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:883 <110> 
;; GList* g_list_remove_link( GList* list, GList* llink);
(ff:bind-c-function g_list_remove_link
     :unconverted-entry-name "g_list_remove_link"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GList" "*"))
     :c-arg-names (list llink)
     :arguments ((* GList) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:885 <111> 
;; GList* g_list_reverse( GList* list);
(ff:bind-c-function g_list_reverse
     :unconverted-entry-name "g_list_reverse"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:886 <112> 
;; GList* g_list_copy( GList* list);
(ff:bind-c-function g_list_copy
     :unconverted-entry-name "g_list_copy"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:887 <113> 
;; GList* g_list_nth( GList* list, guint n);
(ff:bind-c-function g_list_nth
     :unconverted-entry-name "g_list_nth"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:889 <114> 
;; GList* g_list_find( GList* list, gpointer data);
(ff:bind-c-function g_list_find
     :unconverted-entry-name "g_list_find"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:891 <115> 
;; GList* g_list_find_custom( GList* list, gpointer data, GCompareFunc func
;;   );
(ff:bind-c-function g_list_find_custom
     :unconverted-entry-name "g_list_find_custom"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("gpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GList) gpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:894 <116> 
;; gint g_list_position( GList* list, GList* llink);
(ff:bind-c-function g_list_position
     :unconverted-entry-name "g_list_position"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GList" "*") ("GList" "*"))
     :c-arg-names (list llink)
     :arguments ((* GList) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:896 <117> 
;; gint g_list_index( GList* list, gpointer data);
(ff:bind-c-function g_list_index
     :unconverted-entry-name "g_list_index"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:898 <118> 
;; GList* g_list_last( GList* list);
(ff:bind-c-function g_list_last
     :unconverted-entry-name "g_list_last"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:899 <119> 
;; GList* g_list_first( GList* list);
(ff:bind-c-function g_list_first
     :unconverted-entry-name "g_list_first"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:900 <120> 
;; guint g_list_length( GList* list);
(ff:bind-c-function g_list_length
     :unconverted-entry-name "g_list_length"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GList" "*"))
     :c-arg-names (list)
     :arguments ((* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:901 <121> 
;; void g_list_foreach( GList* list, GFunc func, gpointer user_data);
(ff:bind-c-function g_list_foreach
     :unconverted-entry-name "g_list_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GList" "*") ("GFunc") ("gpointer"))
     :c-arg-names (list func user_data)
     :arguments ((* GList) GFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:904 <122> 
;; GList* g_list_sort( GList* list, GCompareFunc compare_func);
(ff:bind-c-function g_list_sort
     :unconverted-entry-name "g_list_sort"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GList" "*") ("GCompareFunc"))
     :c-arg-names (list compare_func)
     :arguments ((* GList) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:906 <123> 
;; gpointer g_list_nth_data( GList* list, guint n);
(ff:bind-c-function g_list_nth_data
     :unconverted-entry-name "g_list_nth_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:914 <124> 
;; void g_slist_push_allocator( GAllocator* allocator);
(ff:bind-c-function g_slist_push_allocator
     :unconverted-entry-name "g_slist_push_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:915 <125> 
;; void g_slist_pop_allocator( void);
(ff:bind-c-function g_slist_pop_allocator
     :unconverted-entry-name "g_slist_pop_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:916 <126> 
;; GSList* g_slist_alloc( void);
(ff:bind-c-function g_slist_alloc
     :unconverted-entry-name "g_slist_alloc"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:917 <127> 
;; void g_slist_free( GSList* list);
(ff:bind-c-function g_slist_free
     :unconverted-entry-name "g_slist_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:918 <128> 
;; void g_slist_free_1( GSList* list);
(ff:bind-c-function g_slist_free_1
     :unconverted-entry-name "g_slist_free_1"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:919 <129> 
;; GSList* g_slist_append( GSList* list, gpointer data);
(ff:bind-c-function g_slist_append
     :unconverted-entry-name "g_slist_append"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:921 <130> 
;; GSList* g_slist_prepend( GSList* list, gpointer data);
(ff:bind-c-function g_slist_prepend
     :unconverted-entry-name "g_slist_prepend"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:923 <131> 
;; GSList* g_slist_insert( GSList* list, gpointer data, gint position);
(ff:bind-c-function g_slist_insert
     :unconverted-entry-name "g_slist_insert"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer") ("gint"))
     :c-arg-names (list data position)
     :arguments ((* GSList) gpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:926 <132> 
;; GSList* g_slist_insert_sorted( GSList* list, gpointer data, GCompareFunc
;;    func);
(ff:bind-c-function g_slist_insert_sorted
     :unconverted-entry-name "g_slist_insert_sorted"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GSList) gpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:929 <133> 
;; GSList* g_slist_concat( GSList* list1, GSList* list2);
(ff:bind-c-function g_slist_concat
     :unconverted-entry-name "g_slist_concat"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (list1 list2)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:931 <134> 
;; GSList* g_slist_remove( GSList* list, gpointer data);
(ff:bind-c-function g_slist_remove
     :unconverted-entry-name "g_slist_remove"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:933 <135> 
;; GSList* g_slist_remove_link( GSList* list, GSList* llink);
(ff:bind-c-function g_slist_remove_link
     :unconverted-entry-name "g_slist_remove_link"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (list llink)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:935 <136> 
;; GSList* g_slist_reverse( GSList* list);
(ff:bind-c-function g_slist_reverse
     :unconverted-entry-name "g_slist_reverse"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:936 <137> 
;; GSList* g_slist_copy( GSList* list);
(ff:bind-c-function g_slist_copy
     :unconverted-entry-name "g_slist_copy"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:937 <138> 
;; GSList* g_slist_nth( GSList* list, guint n);
(ff:bind-c-function g_slist_nth
     :unconverted-entry-name "g_slist_nth"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GSList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:939 <139> 
;; GSList* g_slist_find( GSList* list, gpointer data);
(ff:bind-c-function g_slist_find
     :unconverted-entry-name "g_slist_find"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:941 <140> 
;; GSList* g_slist_find_custom( GSList* list, gpointer data, GCompareFunc
;;    func);
(ff:bind-c-function g_slist_find_custom
     :unconverted-entry-name "g_slist_find_custom"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("gpointer") ("GCompareFunc"))
     :c-arg-names (list data func)
     :arguments ((* GSList) gpointer GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:944 <141> 
;; gint g_slist_position( GSList* list, GSList* llink);
(ff:bind-c-function g_slist_position
     :unconverted-entry-name "g_slist_position"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (list llink)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:946 <142> 
;; gint g_slist_index( GSList* list, gpointer data);
(ff:bind-c-function g_slist_index
     :unconverted-entry-name "g_slist_index"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GSList" "*") ("gpointer"))
     :c-arg-names (list data)
     :arguments ((* GSList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:948 <143> 
;; GSList* g_slist_last( GSList* list);
(ff:bind-c-function g_slist_last
     :unconverted-entry-name "g_slist_last"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:949 <144> 
;; guint g_slist_length( GSList* list);
(ff:bind-c-function g_slist_length
     :unconverted-entry-name "g_slist_length"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GSList" "*"))
     :c-arg-names (list)
     :arguments ((* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:950 <145> 
;; void g_slist_foreach( GSList* list, GFunc func, gpointer user_data);
(ff:bind-c-function g_slist_foreach
     :unconverted-entry-name "g_slist_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSList" "*") ("GFunc") ("gpointer"))
     :c-arg-names (list func user_data)
     :arguments ((* GSList) GFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:953 <146> 
;; GSList* g_slist_sort( GSList* list, GCompareFunc compare_func);
(ff:bind-c-function g_slist_sort
     :unconverted-entry-name "g_slist_sort"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GSList" "*") ("GCompareFunc"))
     :c-arg-names (list compare_func)
     :arguments ((* GSList) GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:955 <147> 
;; gpointer g_slist_nth_data( GSList* list, guint n);
(ff:bind-c-function g_slist_nth_data
     :unconverted-entry-name "g_slist_nth_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GSList" "*") ("guint"))
     :c-arg-names (list n)
     :arguments ((* GSList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:962 <148> 
;; GHashTable* g_hash_table_new( GHashFunc hash_func, GCompareFunc
;;   key_compare_func
;;   );
(ff:bind-c-function g_hash_table_new
     :unconverted-entry-name "g_hash_table_new"
     :c-return-type ("GHashTable" "*")
     :return-type (* GHashTable)
     :c-arg-types (("GHashFunc") ("GCompareFunc"))
     :c-arg-names (hash_func key_compare_func)
     :arguments (GHashFunc GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:964 <149> 
;; void g_hash_table_destroy( GHashTable* hash_table);
(ff:bind-c-function g_hash_table_destroy
     :unconverted-entry-name "g_hash_table_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*"))
     :c-arg-names (hash_table)
     :arguments ((* GHashTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:965 <150> 
;; void g_hash_table_insert( GHashTable* hash_table, gpointer key, gpointer
;;    value);
(ff:bind-c-function g_hash_table_insert
     :unconverted-entry-name "g_hash_table_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*") ("gpointer") ("gpointer"))
     :c-arg-names (hash_table key value)
     :arguments ((* GHashTable) gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:968 <151> 
;; void g_hash_table_remove( GHashTable* hash_table, gconstpointer key);
(ff:bind-c-function g_hash_table_remove
     :unconverted-entry-name "g_hash_table_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*") ("gconstpointer"))
     :c-arg-names (hash_table key)
     :arguments ((* GHashTable) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:970 <152> 
;; gpointer g_hash_table_lookup( GHashTable* hash_table, gconstpointer
;;   key);
(ff:bind-c-function g_hash_table_lookup
     :unconverted-entry-name "g_hash_table_lookup"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GHashTable" "*") ("gconstpointer"))
     :c-arg-names (hash_table key)
     :arguments ((* GHashTable) gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:972 <153> 
;; gboolean g_hash_table_lookup_extended( GHashTable* hash_table,
;;   gconstpointer
;;    lookup_key, gpointer* orig_key, gpointer* value);
(ff:bind-c-function g_hash_table_lookup_extended
     :unconverted-entry-name "g_hash_table_lookup_extended"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GHashTable" "*") ("gconstpointer") ("gpointer" "*")
                   ("gpointer" "*"))
     :c-arg-names (hash_table lookup_key orig_key value)
     :arguments ((* GHashTable) gconstpointer (* gpointer) (* gpointer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:976 <154> 
;; void g_hash_table_freeze( GHashTable* hash_table);
(ff:bind-c-function g_hash_table_freeze
     :unconverted-entry-name "g_hash_table_freeze"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*"))
     :c-arg-names (hash_table)
     :arguments ((* GHashTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:977 <155> 
;; void g_hash_table_thaw( GHashTable* hash_table);
(ff:bind-c-function g_hash_table_thaw
     :unconverted-entry-name "g_hash_table_thaw"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*"))
     :c-arg-names (hash_table)
     :arguments ((* GHashTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:978 <156> 
;; void g_hash_table_foreach( GHashTable* hash_table, GHFunc func, gpointer
;;    user_data);
(ff:bind-c-function g_hash_table_foreach
     :unconverted-entry-name "g_hash_table_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHashTable" "*") ("GHFunc") ("gpointer"))
     :c-arg-names (hash_table func user_data)
     :arguments ((* GHashTable) GHFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:981 <157> 
;; guint g_hash_table_foreach_remove( GHashTable* hash_table, GHRFunc func,
;;              gpointer user_data);
(ff:bind-c-function g_hash_table_foreach_remove
     :unconverted-entry-name "g_hash_table_foreach_remove"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GHashTable" "*") ("GHRFunc") ("gpointer"))
     :c-arg-names (hash_table func user_data)
     :arguments ((* GHashTable) GHRFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:984 <158> 
;; guint g_hash_table_size( GHashTable* hash_table);
(ff:bind-c-function g_hash_table_size
     :unconverted-entry-name "g_hash_table_size"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GHashTable" "*"))
     :c-arg-names (hash_table)
     :arguments ((* GHashTable))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:989 <159> 
;; GCache* g_cache_new( GCacheNewFunc value_new_func, GCacheDestroyFunc
;;   value_destroy_func,
;;              GCacheDupFunc key_dup_func, GCacheDestroyFunc
;;   key_destroy_func, GHashFunc
;;    hash_key_func, GHashFunc hash_value_func, GCompareFunc
;;   key_compare_func
;;   );
(ff:bind-c-function g_cache_new
     :unconverted-entry-name "g_cache_new"
     :c-return-type ("GCache" "*")
     :return-type (* GCache)
     :c-arg-types (("GCacheNewFunc") ("GCacheDestroyFunc") ("GCacheDupFunc")
                   ("GCacheDestroyFunc") ("GHashFunc") ("GHashFunc")
                   ("GCompareFunc"))
     :c-arg-names (value_new_func value_destroy_func key_dup_func
                   key_destroy_func hash_key_func hash_value_func
                   key_compare_func)
     :arguments (GCacheNewFunc GCacheDestroyFunc GCacheDupFunc
                 GCacheDestroyFunc GHashFunc GHashFunc GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:996 <160> 
;; void g_cache_destroy( GCache* cache);
(ff:bind-c-function g_cache_destroy
     :unconverted-entry-name "g_cache_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*"))
     :c-arg-names (cache)
     :arguments ((* GCache))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:997 <161> 
;; gpointer g_cache_insert( GCache* cache, gpointer key);
(ff:bind-c-function g_cache_insert
     :unconverted-entry-name "g_cache_insert"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GCache" "*") ("gpointer"))
     :c-arg-names (cache key)
     :arguments ((* GCache) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:999 <162> 
;; void g_cache_remove( GCache* cache, gpointer value);
(ff:bind-c-function g_cache_remove
     :unconverted-entry-name "g_cache_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*") ("gpointer"))
     :c-arg-names (cache value)
     :arguments ((* GCache) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1001 <163> 
;; void g_cache_key_foreach( GCache* cache, GHFunc func, gpointer user_data
;;   );
(ff:bind-c-function g_cache_key_foreach
     :unconverted-entry-name "g_cache_key_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*") ("GHFunc") ("gpointer"))
     :c-arg-names (cache func user_data)
     :arguments ((* GCache) GHFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1004 <164> 
;; void g_cache_value_foreach( GCache* cache, GHFunc func, gpointer
;;   user_data
;;   );
(ff:bind-c-function g_cache_value_foreach
     :unconverted-entry-name "g_cache_value_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCache" "*") ("GHFunc") ("gpointer"))
     :c-arg-names (cache func user_data)
     :arguments ((* GCache) GHFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1011 <165> 
;; GTree* g_tree_new( GCompareFunc key_compare_func);
(ff:bind-c-function g_tree_new
     :unconverted-entry-name "g_tree_new"
     :c-return-type ("GTree" "*")
     :return-type (* GTree)
     :c-arg-types (("GCompareFunc"))
     :c-arg-names (key_compare_func)
     :arguments (GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1012 <166> 
;; void g_tree_destroy( GTree* tree);
(ff:bind-c-function g_tree_destroy
     :unconverted-entry-name "g_tree_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*"))
     :c-arg-names (tree)
     :arguments ((* GTree))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1013 <167> 
;; void g_tree_insert( GTree* tree, gpointer key, gpointer value);
(ff:bind-c-function g_tree_insert
     :unconverted-entry-name "g_tree_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("gpointer") ("gpointer"))
     :c-arg-names (tree key value)
     :arguments ((* GTree) gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1016 <168> 
;; void g_tree_remove( GTree* tree, gpointer key);
(ff:bind-c-function g_tree_remove
     :unconverted-entry-name "g_tree_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("gpointer"))
     :c-arg-names (tree key)
     :arguments ((* GTree) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1018 <169> 
;; gpointer g_tree_lookup( GTree* tree, gpointer key);
(ff:bind-c-function g_tree_lookup
     :unconverted-entry-name "g_tree_lookup"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GTree" "*") ("gpointer"))
     :c-arg-names (tree key)
     :arguments ((* GTree) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1020 <170> 
;; void g_tree_traverse( GTree* tree, GTraverseFunc traverse_func,
;;   GTraverseType
;;    traverse_type, gpointer data);
(ff:bind-c-function g_tree_traverse
     :unconverted-entry-name "g_tree_traverse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTree" "*") ("GTraverseFunc") ("GTraverseType")
                   ("gpointer"))
     :c-arg-names (tree traverse_func traverse_type data)
     :arguments ((* GTree) GTraverseFunc GTraverseType gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1024 <171> 
;; gpointer g_tree_search( GTree* tree, GSearchFunc search_func, gpointer
;;    data);
(ff:bind-c-function g_tree_search
     :unconverted-entry-name "g_tree_search"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GTree" "*") ("GSearchFunc") ("gpointer"))
     :c-arg-names (tree search_func data)
     :arguments ((* GTree) GSearchFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1027 <172> 
;; gint g_tree_height( GTree* tree);
(ff:bind-c-function g_tree_height
     :unconverted-entry-name "g_tree_height"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GTree" "*"))
     :c-arg-names (tree)
     :arguments ((* GTree))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1028 <173> 
;; gint g_tree_nnodes( GTree* tree);
(ff:bind-c-function g_tree_nnodes
     :unconverted-entry-name "g_tree_nnodes"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GTree" "*"))
     :c-arg-names (tree)
     :arguments ((* GTree))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1034 <174> 
;; struct _GNode {
;;         gpointer data; GNode* next; GNode* prev; GNode* parent; GNode*
;;   children;
;;    };
(ff:bind-c-type _GNode (:struct
  (data gpointer)   ;; gpointer data
  (next (* GNode))   ;; GNode* next
  (prev (* GNode))   ;; GNode* prev
  (parent (* GNode))   ;; GNode* parent
  (children (* GNode))   ;; GNode* children
  ))   ;; bind-c-type _GNode

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1048 <175> 
;; void g_node_push_allocator( GAllocator* allocator);
(ff:bind-c-function g_node_push_allocator
     :unconverted-entry-name "g_node_push_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1049 <176> 
;; void g_node_pop_allocator( void);
(ff:bind-c-function g_node_pop_allocator
     :unconverted-entry-name "g_node_pop_allocator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1050 <177> 
;; GNode* g_node_new( gpointer data);
(ff:bind-c-function g_node_new
     :unconverted-entry-name "g_node_new"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("gpointer"))
     :c-arg-names (data)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1051 <178> 
;; void g_node_destroy( GNode* root);
(ff:bind-c-function g_node_destroy
     :unconverted-entry-name "g_node_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*"))
     :c-arg-names (root)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1052 <179> 
;; void g_node_unlink( GNode* node);
(ff:bind-c-function g_node_unlink
     :unconverted-entry-name "g_node_unlink"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1053 <180> 
;; GNode* g_node_insert( GNode* parent, gint position, GNode* node);
(ff:bind-c-function g_node_insert
     :unconverted-entry-name "g_node_insert"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("gint") ("GNode" "*"))
     :c-arg-names (parent position node)
     :arguments ((* GNode) gint (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1056 <181> 
;; GNode* g_node_insert_before( GNode* parent, GNode* sibling, GNode*
;;   node);
(ff:bind-c-function g_node_insert_before
     :unconverted-entry-name "g_node_insert_before"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GNode" "*") ("GNode" "*"))
     :c-arg-names (parent sibling node)
     :arguments ((* GNode) (* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1059 <182> 
;; GNode* g_node_prepend( GNode* parent, GNode* node);
(ff:bind-c-function g_node_prepend
     :unconverted-entry-name "g_node_prepend"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GNode" "*"))
     :c-arg-names (parent node)
     :arguments ((* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1061 <183> 
;; guint g_node_n_nodes( GNode* root, GTraverseFlags flags);
(ff:bind-c-function g_node_n_nodes
     :unconverted-entry-name "g_node_n_nodes"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*") ("GTraverseFlags"))
     :c-arg-names (root flags)
     :arguments ((* GNode) GTraverseFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1063 <184> 
;; GNode* g_node_get_root( GNode* node);
(ff:bind-c-function g_node_get_root
     :unconverted-entry-name "g_node_get_root"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1064 <185> 
;; gboolean g_node_is_ancestor( GNode* node, GNode* descendant);
(ff:bind-c-function g_node_is_ancestor
     :unconverted-entry-name "g_node_is_ancestor"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GNode" "*") ("GNode" "*"))
     :c-arg-names (node descendant)
     :arguments ((* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1066 <186> 
;; guint g_node_depth( GNode* node);
(ff:bind-c-function g_node_depth
     :unconverted-entry-name "g_node_depth"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1067 <187> 
;; GNode* g_node_find( GNode* root, GTraverseType order, GTraverseFlags
;;   flags,
;;              gpointer data);
(ff:bind-c-function g_node_find
     :unconverted-entry-name "g_node_find"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GTraverseType") ("GTraverseFlags")
                   ("gpointer"))
     :c-arg-names (root order flags data)
     :arguments ((* GNode) GTraverseType GTraverseFlags gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1089 <188> 
;; void g_node_traverse( GNode* root, GTraverseType order, GTraverseFlags
;;    flags, gint max_depth, GNodeTraverseFunc func, gpointer data);
(ff:bind-c-function g_node_traverse
     :unconverted-entry-name "g_node_traverse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*") ("GTraverseType") ("GTraverseFlags") ("gint")
                   ("GNodeTraverseFunc") ("gpointer"))
     :c-arg-names (root order flags max_depth func data)
     :arguments ((* GNode) GTraverseType GTraverseFlags gint GNodeTraverseFunc
                 gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1101 <189> 
;; guint g_node_max_height( GNode* root);
(ff:bind-c-function g_node_max_height
     :unconverted-entry-name "g_node_max_height"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*"))
     :c-arg-names (root)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1103 <190> 
;; void g_node_children_foreach( GNode* node, GTraverseFlags flags,
;;   GNodeForeachFunc
;;    func, gpointer data);
(ff:bind-c-function g_node_children_foreach
     :unconverted-entry-name "g_node_children_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*") ("GTraverseFlags") ("GNodeForeachFunc")
                   ("gpointer"))
     :c-arg-names (node flags func data)
     :arguments ((* GNode) GTraverseFlags GNodeForeachFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1107 <191> 
;; void g_node_reverse_children( GNode* node);
(ff:bind-c-function g_node_reverse_children
     :unconverted-entry-name "g_node_reverse_children"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1108 <192> 
;; guint g_node_n_children( GNode* node);
(ff:bind-c-function g_node_n_children
     :unconverted-entry-name "g_node_n_children"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1109 <193> 
;; GNode* g_node_nth_child( GNode* node, guint n);
(ff:bind-c-function g_node_nth_child
     :unconverted-entry-name "g_node_nth_child"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("guint"))
     :c-arg-names (node n)
     :arguments ((* GNode) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1111 <194> 
;; GNode* g_node_last_child( GNode* node);
(ff:bind-c-function g_node_last_child
     :unconverted-entry-name "g_node_last_child"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1112 <195> 
;; GNode* g_node_find_child( GNode* node, GTraverseFlags flags, gpointer
;;    data);
(ff:bind-c-function g_node_find_child
     :unconverted-entry-name "g_node_find_child"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*") ("GTraverseFlags") ("gpointer"))
     :c-arg-names (node flags data)
     :arguments ((* GNode) GTraverseFlags gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1115 <196> 
;; gint g_node_child_position( GNode* node, GNode* child);
(ff:bind-c-function g_node_child_position
     :unconverted-entry-name "g_node_child_position"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GNode" "*") ("GNode" "*"))
     :c-arg-names (node child)
     :arguments ((* GNode) (* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1117 <197> 
;; gint g_node_child_index( GNode* node, gpointer data);
(ff:bind-c-function g_node_child_index
     :unconverted-entry-name "g_node_child_index"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GNode" "*") ("gpointer"))
     :c-arg-names (node data)
     :arguments ((* GNode) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1120 <198> 
;; GNode* g_node_first_sibling( GNode* node);
(ff:bind-c-function g_node_first_sibling
     :unconverted-entry-name "g_node_first_sibling"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1121 <199> 
;; GNode* g_node_last_sibling( GNode* node);
(ff:bind-c-function g_node_last_sibling
     :unconverted-entry-name "g_node_last_sibling"
     :c-return-type ("GNode" "*")
     :return-type (* GNode)
     :c-arg-types (("GNode" "*"))
     :c-arg-names (node)
     :arguments ((* GNode))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1134 <200> 
;; typedef enum {
;;         G_HOOK_FLAG_ACTIVE =  0x000000001 LSHIFT  0x000000000,
;;   G_HOOK_FLAG_IN_CALL
;;    =  0x000000001 LSHIFT  0x000000001, G_HOOK_FLAG_MASK =  0x00000000f }
;;    GHookFlagMask;
(ff:bind-c-constant G_HOOK_FLAG_ACTIVE
                    1) ;;
;;   G_HOOK_FLAG_ACTIVE =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant G_HOOK_FLAG_IN_CALL
                    2) ;;
;;   G_HOOK_FLAG_IN_CALL =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant G_HOOK_FLAG_MASK 15) ;;
;;   G_HOOK_FLAG_MASK =  0x00000000f 
(ff:bind-c-type GHookFlagMask :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1143 <201> 
;; struct _GHookList {
;;         guint seq_id; guint hook_size; guint is_setup:  0x000000001;
;;   GHook* hooks;
;;              GMemChunk* hook_memchunk; GHookFreeFunc hook_free;
;;   GHookFreeFunc hook_destroy;
;;    };

;;WARNING: Strange bitfield is_setup type (guint) will be retrieved as an unsigned integer.

;;WARNING: Bitfield alignment may not match your compiler's
(ff:bind-c-type _GHookList (:struct
  (seq_id guint)   ;; guint seq_id
  (hook_size guint)   ;; guint hook_size
  (is_setup (:bit 1))   ;; guint is_setup:  0x000000001
  (hooks (* GHook))   ;; GHook* hooks
  (hook_memchunk (* GMemChunk))   ;; GMemChunk* hook_memchunk
  (hook_free GHookFreeFunc)   ;; GHookFreeFunc hook_free
  (hook_destroy GHookFreeFunc)   ;; GHookFreeFunc hook_destroy
  ))   ;; bind-c-type _GHookList

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1154 <202> 
;; struct _GHook {
;;         gpointer data; GHook* next; GHook* prev; guint ref_count; guint
;;   hook_id;
;;              guint flags; gpointer func; GDestroyNotify destroy; };
(ff:bind-c-type _GHook (:struct
  (data gpointer)   ;; gpointer data
  (next (* GHook))   ;; GHook* next
  (prev (* GHook))   ;; GHook* prev
  (ref_count guint)   ;; guint ref_count
  (hook_id guint)   ;; guint hook_id
  (flags guint)   ;; guint flags
  (func gpointer)   ;; gpointer func
  (destroy GDestroyNotify)   ;; GDestroyNotify destroy
  ))   ;; bind-c-type _GHook

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1177 <203> 
;; void g_hook_list_init( GHookList* hook_list, guint hook_size);
(ff:bind-c-function g_hook_list_init
     :unconverted-entry-name "g_hook_list_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("guint"))
     :c-arg-names (hook_list hook_size)
     :arguments ((* GHookList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1179 <204> 
;; void g_hook_list_clear( GHookList* hook_list);
(ff:bind-c-function g_hook_list_clear
     :unconverted-entry-name "g_hook_list_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*"))
     :c-arg-names (hook_list)
     :arguments ((* GHookList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1180 <205> 
;; GHook* g_hook_alloc( GHookList* hook_list);
(ff:bind-c-function g_hook_alloc
     :unconverted-entry-name "g_hook_alloc"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*"))
     :c-arg-names (hook_list)
     :arguments ((* GHookList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1181 <206> 
;; void g_hook_free( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_free
     :unconverted-entry-name "g_hook_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1183 <207> 
;; void g_hook_ref( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_ref
     :unconverted-entry-name "g_hook_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1185 <208> 
;; void g_hook_unref( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_unref
     :unconverted-entry-name "g_hook_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1187 <209> 
;; gboolean g_hook_destroy( GHookList* hook_list, guint hook_id);
(ff:bind-c-function g_hook_destroy
     :unconverted-entry-name "g_hook_destroy"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GHookList" "*") ("guint"))
     :c-arg-names (hook_list hook_id)
     :arguments ((* GHookList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1189 <210> 
;; void g_hook_destroy_link( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_destroy_link
     :unconverted-entry-name "g_hook_destroy_link"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1191 <211> 
;; void g_hook_prepend( GHookList* hook_list, GHook* hook);
(ff:bind-c-function g_hook_prepend
     :unconverted-entry-name "g_hook_prepend"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*"))
     :c-arg-names (hook_list hook)
     :arguments ((* GHookList) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1193 <212> 
;; void g_hook_insert_before( GHookList* hook_list, GHook* sibling, GHook
;;   * hook);
(ff:bind-c-function g_hook_insert_before
     :unconverted-entry-name "g_hook_insert_before"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*") ("GHook" "*"))
     :c-arg-names (hook_list sibling hook)
     :arguments ((* GHookList) (* GHook) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1196 <213> 
;; void g_hook_insert_sorted( GHookList* hook_list, GHook* hook,
;;   GHookCompareFunc
;;    func);
(ff:bind-c-function g_hook_insert_sorted
     :unconverted-entry-name "g_hook_insert_sorted"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("GHook" "*") ("GHookCompareFunc"))
     :c-arg-names (hook_list hook func)
     :arguments ((* GHookList) (* GHook) GHookCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1199 <214> 
;; GHook* g_hook_get( GHookList* hook_list, guint hook_id);
(ff:bind-c-function g_hook_get
     :unconverted-entry-name "g_hook_get"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("guint"))
     :c-arg-names (hook_list hook_id)
     :arguments ((* GHookList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1201 <215> 
;; GHook* g_hook_find( GHookList* hook_list, gboolean need_valids,
;;   GHookFindFunc
;;    func, gpointer data);
(ff:bind-c-function g_hook_find
     :unconverted-entry-name "g_hook_find"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("GHookFindFunc")
                   ("gpointer"))
     :c-arg-names (hook_list need_valids func data)
     :arguments ((* GHookList) gboolean GHookFindFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1205 <216> 
;; GHook* g_hook_find_data( GHookList* hook_list, gboolean need_valids,
;;   gpointer
;;    data);
(ff:bind-c-function g_hook_find_data
     :unconverted-entry-name "g_hook_find_data"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("gpointer"))
     :c-arg-names (hook_list need_valids data)
     :arguments ((* GHookList) gboolean gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1208 <217> 
;; GHook* g_hook_find_func( GHookList* hook_list, gboolean need_valids,
;;   gpointer
;;    func);
(ff:bind-c-function g_hook_find_func
     :unconverted-entry-name "g_hook_find_func"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("gpointer"))
     :c-arg-names (hook_list need_valids func)
     :arguments ((* GHookList) gboolean gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1211 <218> 
;; GHook* g_hook_find_func_data( GHookList* hook_list, gboolean
;;   need_valids,
;;              gpointer func, gpointer data);
(ff:bind-c-function g_hook_find_func_data
     :unconverted-entry-name "g_hook_find_func_data"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean") ("gpointer") ("gpointer"))
     :c-arg-names (hook_list need_valids func data)
     :arguments ((* GHookList) gboolean gpointer gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1216 <219> 
;; GHook* g_hook_first_valid( GHookList* hook_list, gboolean may_be_in_call
;;   );
(ff:bind-c-function g_hook_first_valid
     :unconverted-entry-name "g_hook_first_valid"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("gboolean"))
     :c-arg-names (hook_list may_be_in_call)
     :arguments ((* GHookList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1221 <220> 
;; GHook* g_hook_next_valid( GHookList* hook_list, GHook* hook, gboolean
;;    may_be_in_call);
(ff:bind-c-function g_hook_next_valid
     :unconverted-entry-name "g_hook_next_valid"
     :c-return-type ("GHook" "*")
     :return-type (* GHook)
     :c-arg-types (("GHookList" "*") ("GHook" "*") ("gboolean"))
     :c-arg-names (hook_list hook may_be_in_call)
     :arguments ((* GHookList) (* GHook) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1226 <221> 
;; gint g_hook_compare_ids( GHook* new_hook, GHook* sibling);
(ff:bind-c-function g_hook_compare_ids
     :unconverted-entry-name "g_hook_compare_ids"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GHook" "*") ("GHook" "*"))
     :c-arg-names (new_hook sibling)
     :arguments ((* GHook) (* GHook))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1235 <222> 
;; void g_hook_list_invoke( GHookList* hook_list, gboolean may_recurse);
(ff:bind-c-function g_hook_list_invoke
     :unconverted-entry-name "g_hook_list_invoke"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean"))
     :c-arg-names (hook_list may_recurse)
     :arguments ((* GHookList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1240 <223> 
;; void g_hook_list_invoke_check( GHookList* hook_list, gboolean
;;   may_recurse
;;   );
(ff:bind-c-function g_hook_list_invoke_check
     :unconverted-entry-name "g_hook_list_invoke_check"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean"))
     :c-arg-names (hook_list may_recurse)
     :arguments ((* GHookList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1244 <224> 
;; void g_hook_list_marshal( GHookList* hook_list, gboolean may_recurse,
;;              GHookMarshaller marshaller, gpointer data);
(ff:bind-c-function g_hook_list_marshal
     :unconverted-entry-name "g_hook_list_marshal"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean") ("GHookMarshaller")
                   ("gpointer"))
     :c-arg-names (hook_list may_recurse marshaller data)
     :arguments ((* GHookList) gboolean GHookMarshaller gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1248 <225> 
;; void g_hook_list_marshal_check( GHookList* hook_list, gboolean
;;   may_recurse,
;;              GHookCheckMarshaller marshaller, gpointer data);
(ff:bind-c-function g_hook_list_marshal_check
     :unconverted-entry-name "g_hook_list_marshal_check"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GHookList" "*") ("gboolean") ("GHookCheckMarshaller")
                   ("gpointer"))
     :c-arg-names (hook_list may_recurse marshaller data)
     :arguments ((* GHookList) gboolean GHookCheckMarshaller gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1263 <226> 
;; void g_on_error_query( const gchar* prg_name);
(ff:bind-c-function g_on_error_query
     :unconverted-entry-name "g_on_error_query"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (prg_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1264 <227> 
;; void g_on_error_stack_trace( const gchar* prg_name);
(ff:bind-c-function g_on_error_stack_trace
     :unconverted-entry-name "g_on_error_stack_trace"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (prg_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1269 <228> 
;; extern const gchar* g_log_domain_glib;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_log_domain_glib"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1270 <229> 
;; guint g_log_set_handler( const gchar* log_domain, GLogLevelFlags
;;   log_levels,
;;              GLogFunc log_func, gpointer user_data);
(ff:bind-c-function g_log_set_handler
     :unconverted-entry-name "g_log_set_handler"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags") ("GLogFunc")
                   ("gpointer"))
     :c-arg-names (log_domain log_levels log_func user_data)
     :arguments ((* gchar) GLogLevelFlags GLogFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1274 <230> 
;; void g_log_remove_handler( const gchar* log_domain, guint handler_id);
(ff:bind-c-function g_log_remove_handler
     :unconverted-entry-name "g_log_remove_handler"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("guint"))
     :c-arg-names (log_domain handler_id)
     :arguments ((* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1276 <231> 
;; void g_log_default_handler( const gchar* log_domain, GLogLevelFlags
;;   log_level,
;;              const gchar* message, gpointer unused_data);
(ff:bind-c-function g_log_default_handler
     :unconverted-entry-name "g_log_default_handler"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags")
                   ("const" "gchar" "*") ("gpointer"))
     :c-arg-names (log_domain log_level message unused_data)
     :arguments ((* gchar) GLogLevelFlags (* gchar) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1280 <232> 
;; void g_log( const gchar* log_domain, GLogLevelFlags log_level, const
;;   gchar
;;   * format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_log
     :unconverted-entry-name "g_log"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags")
                   ("const" "gchar" "*") "...")
     :c-arg-names (log_domain log_level format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1284 <233> 
;; void g_logv( const gchar* log_domain, GLogLevelFlags log_level, const
;;    gchar* format, va_list args);
(ff:bind-c-function g_logv
     :unconverted-entry-name "g_logv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags")
                   ("const" "gchar" "*") ("va_list"))
     :c-arg-names (log_domain log_level format args)
     :arguments ((* gchar) GLogLevelFlags (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1288 <234> 
;; GLogLevelFlags g_log_set_fatal_mask( const gchar* log_domain,
;;   GLogLevelFlags
;;    fatal_mask);
(ff:bind-c-function g_log_set_fatal_mask
     :unconverted-entry-name "g_log_set_fatal_mask"
     :c-return-type ("GLogLevelFlags")
     :return-type GLogLevelFlags
     :c-arg-types (("const" "gchar" "*") ("GLogLevelFlags"))
     :c-arg-names (log_domain fatal_mask)
     :arguments ((* gchar) GLogLevelFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1290 <235> 
;; GLogLevelFlags g_log_set_always_fatal( GLogLevelFlags fatal_mask);
(ff:bind-c-function g_log_set_always_fatal
     :unconverted-entry-name "g_log_set_always_fatal"
     :c-return-type ("GLogLevelFlags")
     :return-type GLogLevelFlags
     :c-arg-types (("GLogLevelFlags"))
     :c-arg-names (fatal_mask)
     :arguments (GLogLevelFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1321 <236> 
;; static void g_error( const gchar* format, ELLIPSIS) {
;;         va_list args;
;;        ( void)( args =( va_list) & __builtin_va_alist);
;;         g_logv((( gchar*)  0x000000000), G_LOG_LEVEL_ERROR, format,
;;   args);
;;        ( void)  0x000000000;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1330 <237> 
;; static void g_message( const gchar* format, ELLIPSIS) {
;;         va_list args;
;;        ( void)( args =( va_list) & __builtin_va_alist);
;;         g_logv((( gchar*)  0x000000000), G_LOG_LEVEL_MESSAGE, format,
;;   args);
;;        ( void)  0x000000000;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1339 <238> 
;; static void g_warning( const gchar* format, ELLIPSIS) {
;;         va_list args;
;;        ( void)( args =( va_list) & __builtin_va_alist);
;;         g_logv((( gchar*)  0x000000000), G_LOG_LEVEL_WARNING, format,
;;   args);
;;        ( void)  0x000000000;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1350 <239> 
;; typedef void(* GPrintFunc)( const gchar* string);
(ff:bind-c-type GPrintFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1351 <240> 
;; void g_print( const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_print
     :unconverted-entry-name "g_print"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1353 <241> 
;; GPrintFunc g_set_print_handler( GPrintFunc func);
(ff:bind-c-function g_set_print_handler
     :unconverted-entry-name "g_set_print_handler"
     :c-return-type ("GPrintFunc")
     :return-type GPrintFunc
     :c-arg-types (("GPrintFunc"))
     :c-arg-names (func)
     :arguments (GPrintFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1354 <242> 
;; void g_printerr( const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_printerr
     :unconverted-entry-name "g_printerr"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1356 <243> 
;; GPrintFunc g_set_printerr_handler( GPrintFunc func);
(ff:bind-c-function g_set_printerr_handler
     :unconverted-entry-name "g_set_printerr_handler"
     :c-return-type ("GPrintFunc")
     :return-type GPrintFunc
     :c-arg-types (("GPrintFunc"))
     :c-arg-names (func)
     :arguments (GPrintFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1359 <244> 
;; typedef void(* GErrorFunc)( const gchar* str);
(ff:bind-c-type GErrorFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1360 <245> 
;; typedef void(* GWarningFunc)( const gchar* str);
(ff:bind-c-type GWarningFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1361 <246> 
;; GErrorFunc g_set_error_handler( GErrorFunc func);
(ff:bind-c-function g_set_error_handler
     :unconverted-entry-name "g_set_error_handler"
     :c-return-type ("GErrorFunc")
     :return-type GErrorFunc
     :c-arg-types (("GErrorFunc"))
     :c-arg-names (func)
     :arguments (GErrorFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1362 <247> 
;; GWarningFunc g_set_warning_handler( GWarningFunc func);
(ff:bind-c-function g_set_warning_handler
     :unconverted-entry-name "g_set_warning_handler"
     :c-return-type ("GWarningFunc")
     :return-type GWarningFunc
     :c-arg-types (("GWarningFunc"))
     :c-arg-names (func)
     :arguments (GWarningFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1363 <248> 
;; GPrintFunc g_set_message_handler( GPrintFunc func);
(ff:bind-c-function g_set_message_handler
     :unconverted-entry-name "g_set_message_handler"
     :c-return-type ("GPrintFunc")
     :return-type GPrintFunc
     :c-arg-types (("GPrintFunc"))
     :c-arg-names (func)
     :arguments (GPrintFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1377 <249> 
;; gpointer g_malloc( gulong size);
(ff:bind-c-function g_malloc
     :unconverted-entry-name "g_malloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gulong"))
     :c-arg-names (size)
     :arguments (gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1378 <250> 
;; gpointer g_malloc0( gulong size);
(ff:bind-c-function g_malloc0
     :unconverted-entry-name "g_malloc0"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gulong"))
     :c-arg-names (size)
     :arguments (gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1379 <251> 
;; gpointer g_realloc( gpointer mem, gulong size);
(ff:bind-c-function g_realloc
     :unconverted-entry-name "g_realloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gpointer") ("gulong"))
     :c-arg-names (mem size)
     :arguments (gpointer gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1381 <252> 
;; void g_free( gpointer mem);
(ff:bind-c-function g_free
     :unconverted-entry-name "g_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (mem)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1385 <253> 
;; void g_mem_profile( void);
(ff:bind-c-function g_mem_profile
     :unconverted-entry-name "g_mem_profile"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1386 <254> 
;; void g_mem_check( gpointer mem);
(ff:bind-c-function g_mem_check
     :unconverted-entry-name "g_mem_check"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gpointer"))
     :c-arg-names (mem)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1390 <255> 
;; GAllocator* g_allocator_new( const gchar* name, guint n_preallocs);
(ff:bind-c-function g_allocator_new
     :unconverted-entry-name "g_allocator_new"
     :c-return-type ("GAllocator" "*")
     :return-type (* GAllocator)
     :c-arg-types (("const" "gchar" "*") ("guint"))
     :c-arg-names (name n_preallocs)
     :arguments ((* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1392 <256> 
;; void g_allocator_free( GAllocator* allocator);
(ff:bind-c-function g_allocator_free
     :unconverted-entry-name "g_allocator_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GAllocator" "*"))
     :c-arg-names (allocator)
     :arguments ((* GAllocator))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1421 <257> 
;; GMemChunk* g_mem_chunk_new( gchar* name, gint atom_size, gulong
;;   area_size,
;;              gint type);
(ff:bind-c-function g_mem_chunk_new
     :unconverted-entry-name "g_mem_chunk_new"
     :c-return-type ("GMemChunk" "*")
     :return-type (* GMemChunk)
     :c-arg-types (("gchar" "*") ("gint") ("gulong") ("gint"))
     :c-arg-names (name atom_size area_size type)
     :arguments ((* gchar) gint gulong gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1425 <258> 
;; void g_mem_chunk_destroy( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_destroy
     :unconverted-entry-name "g_mem_chunk_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1426 <259> 
;; gpointer g_mem_chunk_alloc( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_alloc
     :unconverted-entry-name "g_mem_chunk_alloc"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1427 <260> 
;; gpointer g_mem_chunk_alloc0( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_alloc0
     :unconverted-entry-name "g_mem_chunk_alloc0"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1428 <261> 
;; void g_mem_chunk_free( GMemChunk* mem_chunk, gpointer mem);
(ff:bind-c-function g_mem_chunk_free
     :unconverted-entry-name "g_mem_chunk_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*") ("gpointer"))
     :c-arg-names (mem_chunk mem)
     :arguments ((* GMemChunk) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1430 <262> 
;; void g_mem_chunk_clean( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_clean
     :unconverted-entry-name "g_mem_chunk_clean"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1431 <263> 
;; void g_mem_chunk_reset( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_reset
     :unconverted-entry-name "g_mem_chunk_reset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1432 <264> 
;; void g_mem_chunk_print( GMemChunk* mem_chunk);
(ff:bind-c-function g_mem_chunk_print
     :unconverted-entry-name "g_mem_chunk_print"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMemChunk" "*"))
     :c-arg-names (mem_chunk)
     :arguments ((* GMemChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1433 <265> 
;; void g_mem_chunk_info( void);
(ff:bind-c-function g_mem_chunk_info
     :unconverted-entry-name "g_mem_chunk_info"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1443 <266> 
;; void g_blow_chunks( void);
(ff:bind-c-function g_blow_chunks
     :unconverted-entry-name "g_blow_chunks"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1448 <267> 
;; GTimer* g_timer_new( void);
(ff:bind-c-function g_timer_new
     :unconverted-entry-name "g_timer_new"
     :c-return-type ("GTimer" "*")
     :return-type (* GTimer)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1449 <268> 
;; void g_timer_destroy( GTimer* timer);
(ff:bind-c-function g_timer_destroy
     :unconverted-entry-name "g_timer_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1450 <269> 
;; void g_timer_start( GTimer* timer);
(ff:bind-c-function g_timer_start
     :unconverted-entry-name "g_timer_start"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1451 <270> 
;; void g_timer_stop( GTimer* timer);
(ff:bind-c-function g_timer_stop
     :unconverted-entry-name "g_timer_stop"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1452 <271> 
;; void g_timer_reset( GTimer* timer);
(ff:bind-c-function g_timer_reset
     :unconverted-entry-name "g_timer_reset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimer" "*"))
     :c-arg-names (timer)
     :arguments ((* GTimer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1453 <272> 
;; gdouble g_timer_elapsed( GTimer* timer, gulong* microseconds);
(ff:bind-c-function g_timer_elapsed
     :unconverted-entry-name "g_timer_elapsed"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("GTimer" "*") ("gulong" "*"))
     :c-arg-names (timer microseconds)
     :arguments ((* GTimer) (* gulong))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1461 <273> 
;; gchar* g_strdelimit( gchar* string, const gchar* delimiters, gchar
;;   new_delimiter
;;   );
(ff:bind-c-function g_strdelimit
     :unconverted-entry-name "g_strdelimit"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*") ("const" "gchar" "*") ("gchar"))
     :c-arg-names (string delimiters new_delimiter)
     :arguments ((* gchar) (* gchar) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1464 <274> 
;; gdouble g_strtod( const gchar* nptr, gchar** endptr);
(ff:bind-c-function g_strtod
     :unconverted-entry-name "g_strtod"
     :c-return-type ("gdouble")
     :return-type gdouble
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*"))
     :c-arg-names (nptr endptr)
     :arguments ((* gchar) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1466 <275> 
;; gchar* g_strerror( gint errnum);
(ff:bind-c-function g_strerror
     :unconverted-entry-name "g_strerror"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gint"))
     :c-arg-names (errnum)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1467 <276> 
;; gchar* g_strsignal( gint signum);
(ff:bind-c-function g_strsignal
     :unconverted-entry-name "g_strsignal"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gint"))
     :c-arg-names (signum)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1468 <277> 
;; gint g_strcasecmp( const gchar* s1, const gchar* s2);
(ff:bind-c-function g_strcasecmp
     :unconverted-entry-name "g_strcasecmp"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (s1 s2)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1470 <278> 
;; gint g_strncasecmp( const gchar* s1, const gchar* s2, guint n);
(ff:bind-c-function g_strncasecmp
     :unconverted-entry-name "g_strncasecmp"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*") ("guint"))
     :c-arg-names (s1 s2 n)
     :arguments ((* gchar) (* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1473 <279> 
;; void g_strdown( gchar* string);
(ff:bind-c-function g_strdown
     :unconverted-entry-name "g_strdown"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1474 <280> 
;; void g_strup( gchar* string);
(ff:bind-c-function g_strup
     :unconverted-entry-name "g_strup"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1475 <281> 
;; void g_strreverse( gchar* string);
(ff:bind-c-function g_strreverse
     :unconverted-entry-name "g_strreverse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1477 <282> 
;; gchar* g_strchug( gchar* string);
(ff:bind-c-function g_strchug
     :unconverted-entry-name "g_strchug"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1479 <283> 
;; gchar* g_strchomp( gchar* string);
(ff:bind-c-function g_strchomp
     :unconverted-entry-name "g_strchomp"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1486 <284> 
;; gchar* g_strdup( const gchar* str);
(ff:bind-c-function g_strdup
     :unconverted-entry-name "g_strdup"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (str)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1487 <285> 
;; gchar* g_strdup_printf( const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_strdup_printf
     :unconverted-entry-name "g_strdup_printf"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1489 <286> 
;; gchar* g_strdup_vprintf( const gchar* format, va_list args);
(ff:bind-c-function g_strdup_vprintf
     :unconverted-entry-name "g_strdup_vprintf"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("va_list"))
     :c-arg-names (format args)
     :arguments ((* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1491 <287> 
;; gchar* g_strndup( const gchar* str, guint n);
(ff:bind-c-function g_strndup
     :unconverted-entry-name "g_strndup"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("guint"))
     :c-arg-names (str n)
     :arguments ((* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1493 <288> 
;; gchar* g_strnfill( guint length, gchar fill_char);
(ff:bind-c-function g_strnfill
     :unconverted-entry-name "g_strnfill"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("guint") ("gchar"))
     :c-arg-names (length fill_char)
     :arguments (guint gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1495 <289> 
;; gchar* g_strconcat( const gchar* string1, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_strconcat
     :unconverted-entry-name "g_strconcat"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (string1)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1497 <290> 
;; gchar* g_strjoin( const gchar* separator, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_strjoin
     :unconverted-entry-name "g_strjoin"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") "...")
     :c-arg-names (separator)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1499 <291> 
;; gchar* g_strescape( gchar* string);
(ff:bind-c-function g_strescape
     :unconverted-entry-name "g_strescape"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1500 <292> 
;; gpointer g_memdup( gconstpointer mem, guint byte_size);
(ff:bind-c-function g_memdup
     :unconverted-entry-name "g_memdup"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gconstpointer") ("guint"))
     :c-arg-names (mem byte_size)
     :arguments (gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1510 <293> 
;; gchar** g_strsplit( const gchar* string, const gchar* delimiter, gint
;;    max_tokens);
(ff:bind-c-function g_strsplit
     :unconverted-entry-name "g_strsplit"
     :c-return-type ("gchar" "*" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (string delimiter max_tokens)
     :arguments ((* gchar) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1513 <294> 
;; gchar* g_strjoinv( const gchar* separator, gchar** str_array);
(ff:bind-c-function g_strjoinv
     :unconverted-entry-name "g_strjoinv"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*") ("gchar" "*" "*"))
     :c-arg-names (separator str_array)
     :arguments ((* gchar) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1515 <295> 
;; void g_strfreev( gchar** str_array);
(ff:bind-c-function g_strfreev
     :unconverted-entry-name "g_strfreev"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gchar" "*" "*"))
     :c-arg-names (str_array)
     :arguments ((* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1521 <296> 
;; guint g_printf_string_upper_bound( const gchar* format, va_list args);
(ff:bind-c-function g_printf_string_upper_bound
     :unconverted-entry-name "g_printf_string_upper_bound"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("va_list"))
     :c-arg-names (format args)
     :arguments ((* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1527 <297> 
;; gchar* g_get_user_name( void);
(ff:bind-c-function g_get_user_name
     :unconverted-entry-name "g_get_user_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1528 <298> 
;; gchar* g_get_real_name( void);
(ff:bind-c-function g_get_real_name
     :unconverted-entry-name "g_get_real_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1529 <299> 
;; gchar* g_get_home_dir( void);
(ff:bind-c-function g_get_home_dir
     :unconverted-entry-name "g_get_home_dir"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1530 <300> 
;; gchar* g_get_tmp_dir( void);
(ff:bind-c-function g_get_tmp_dir
     :unconverted-entry-name "g_get_tmp_dir"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1531 <301> 
;; gchar* g_get_prgname( void);
(ff:bind-c-function g_get_prgname
     :unconverted-entry-name "g_get_prgname"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1532 <302> 
;; void g_set_prgname( const gchar* prgname);
(ff:bind-c-function g_set_prgname
     :unconverted-entry-name "g_set_prgname"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (prgname)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1537 <303> 
;; guint g_parse_debug_string( const gchar* string, GDebugKey* keys, guint
;;    nkeys);
(ff:bind-c-function g_parse_debug_string
     :unconverted-entry-name "g_parse_debug_string"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GDebugKey" "*") ("guint"))
     :c-arg-names (string keys nkeys)
     :arguments ((* gchar) (* GDebugKey) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1540 <304> 
;; gint g_snprintf( gchar* string, gulong n, gchar const* format,
;;   ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_snprintf
     :unconverted-entry-name "g_snprintf"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gchar" "*") ("gulong") ("gchar" "*") "...")
     :c-arg-names (string n format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1544 <305> 
;; gint g_vsnprintf( gchar* string, gulong n, gchar const* format, va_list
;;    args);
(ff:bind-c-function g_vsnprintf
     :unconverted-entry-name "g_vsnprintf"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gchar" "*") ("gulong") ("gchar" "*") ("va_list"))
     :c-arg-names (string n format args)
     :arguments ((* gchar) gulong (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1548 <306> 
;; gchar* g_basename( const gchar* file_name);
(ff:bind-c-function g_basename
     :unconverted-entry-name "g_basename"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1550 <307> 
;; gboolean g_path_is_absolute( const gchar* file_name);
(ff:bind-c-function g_path_is_absolute
     :unconverted-entry-name "g_path_is_absolute"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1552 <308> 
;; gchar* g_path_skip_root( gchar* file_name);
(ff:bind-c-function g_path_skip_root
     :unconverted-entry-name "g_path_skip_root"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1555 <309> 
;; gchar* g_dirname( const gchar* file_name);
(ff:bind-c-function g_dirname
     :unconverted-entry-name "g_dirname"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (file_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1556 <310> 
;; gchar* g_get_current_dir( void);
(ff:bind-c-function g_get_current_dir
     :unconverted-entry-name "g_get_current_dir"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1560 <311> 
;; gchar* g_getenv( const gchar* variable);
(ff:bind-c-function g_getenv
     :unconverted-entry-name "g_getenv"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (variable)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1568 <312> 
;; void g_atexit( GVoidFunc func);
(ff:bind-c-function g_atexit
     :unconverted-entry-name "g_atexit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GVoidFunc"))
     :c-arg-names (func)
     :arguments (GVoidFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1573 <313> 
;; static inline gint g_bit_nth_lsf( guint32 mask, gint nth_bit);
(ff:bind-c-function g_bit_nth_lsf
     :unconverted-entry-name "g_bit_nth_lsf"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "gint")
     :return-type gint
     :c-arg-types (("guint32") ("gint"))
     :c-arg-names (mask nth_bit)
     :arguments (guint32 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1576 <314> 
;; static inline gint g_bit_nth_lsf( guint32 mask, gint nth_bit) {
;;         DO {
;;         nth_bit PLUSPLUS;
;;         IF( mask &(  0x000000001 LSHIFT( guint) nth_bit)) RETURN
;;   nth_bit;
;;         } WHILE( nth_bit ARITHCOMPARE  0x000000020);
;;         RETURN -  0x000000001;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1591 <315> 
;; static inline gint g_bit_nth_msf( guint32 mask, gint nth_bit);
(ff:bind-c-function g_bit_nth_msf
     :unconverted-entry-name "g_bit_nth_msf"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "gint")
     :return-type gint
     :c-arg-types (("guint32") ("gint"))
     :c-arg-names (mask nth_bit)
     :arguments (guint32 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1594 <316> 
;; static inline gint g_bit_nth_msf( guint32 mask, gint nth_bit) {
;;         IF( nth_bit ARITHCOMPARE  0x000000000) nth_bit =  0x000000020;
;;         DO {
;;         nth_bit MINUSMINUS;
;;         IF( mask &(  0x000000001 LSHIFT( guint) nth_bit)) RETURN
;;   nth_bit;
;;         } WHILE( nth_bit ARITHCOMPARE  0x000000000);
;;         RETURN -  0x000000001;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1611 <317> 
;; static inline guint g_bit_storage( guint number);
(ff:bind-c-function g_bit_storage
     :unconverted-entry-name "g_bit_storage"
     :c-modifiers ("static" "inline")
     :c-return-type ("inline" "guint")
     :return-type guint
     :c-arg-types (("guint"))
     :c-arg-names (number)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1613 <318> 
;; static inline guint g_bit_storage( guint number) {
;;         register guint n_bits =  0x000000000;
;;         DO {
;;         n_bits PLUSPLUS;
;;         number ASSIGN  0x000000001;
;;         } WHILE( number);
;;         RETURN n_bits;
;;         }

;;WARNING: Ignoring function _definition_ in header file.

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1630 <319> 
;; GStringChunk* g_string_chunk_new( gint size);
(ff:bind-c-function g_string_chunk_new
     :unconverted-entry-name "g_string_chunk_new"
     :c-return-type ("GStringChunk" "*")
     :return-type (* GStringChunk)
     :c-arg-types (("gint"))
     :c-arg-names (size)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1631 <320> 
;; void g_string_chunk_free( GStringChunk* chunk);
(ff:bind-c-function g_string_chunk_free
     :unconverted-entry-name "g_string_chunk_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStringChunk" "*"))
     :c-arg-names (chunk)
     :arguments ((* GStringChunk))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1632 <321> 
;; gchar* g_string_chunk_insert( GStringChunk* chunk, const gchar* string);
(ff:bind-c-function g_string_chunk_insert
     :unconverted-entry-name "g_string_chunk_insert"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GStringChunk" "*") ("const" "gchar" "*"))
     :c-arg-names (chunk string)
     :arguments ((* GStringChunk) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1634 <322> 
;; gchar* g_string_chunk_insert_const( GStringChunk* chunk, const gchar*
;;    string);
(ff:bind-c-function g_string_chunk_insert_const
     :unconverted-entry-name "g_string_chunk_insert_const"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GStringChunk" "*") ("const" "gchar" "*"))
     :c-arg-names (chunk string)
     :arguments ((* GStringChunk) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1640 <323> 
;; GString* g_string_new( const gchar* init);
(ff:bind-c-function g_string_new
     :unconverted-entry-name "g_string_new"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (init)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1641 <324> 
;; GString* g_string_sized_new( guint dfl_size);
(ff:bind-c-function g_string_sized_new
     :unconverted-entry-name "g_string_sized_new"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("guint"))
     :c-arg-names (dfl_size)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1642 <325> 
;; void g_string_free( GString* string, gint free_segment);
(ff:bind-c-function g_string_free
     :unconverted-entry-name "g_string_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GString" "*") ("gint"))
     :c-arg-names (string free_segment)
     :arguments ((* GString) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1644 <326> 
;; GString* g_string_assign( GString* lval, const gchar* rval);
(ff:bind-c-function g_string_assign
     :unconverted-entry-name "g_string_assign"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*"))
     :c-arg-names (lval rval)
     :arguments ((* GString) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1646 <327> 
;; GString* g_string_truncate( GString* string, gint len);
(ff:bind-c-function g_string_truncate
     :unconverted-entry-name "g_string_truncate"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gint"))
     :c-arg-names (string len)
     :arguments ((* GString) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1648 <328> 
;; GString* g_string_append( GString* string, const gchar* val);
(ff:bind-c-function g_string_append
     :unconverted-entry-name "g_string_append"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*"))
     :c-arg-names (string val)
     :arguments ((* GString) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1650 <329> 
;; GString* g_string_append_c( GString* string, gchar c);
(ff:bind-c-function g_string_append_c
     :unconverted-entry-name "g_string_append_c"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gchar"))
     :c-arg-names (string c)
     :arguments ((* GString) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1652 <330> 
;; GString* g_string_prepend( GString* string, const gchar* val);
(ff:bind-c-function g_string_prepend
     :unconverted-entry-name "g_string_prepend"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("const" "gchar" "*"))
     :c-arg-names (string val)
     :arguments ((* GString) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1654 <331> 
;; GString* g_string_prepend_c( GString* string, gchar c);
(ff:bind-c-function g_string_prepend_c
     :unconverted-entry-name "g_string_prepend_c"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gchar"))
     :c-arg-names (string c)
     :arguments ((* GString) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1656 <332> 
;; GString* g_string_insert( GString* string, gint pos, const gchar* val);
(ff:bind-c-function g_string_insert
     :unconverted-entry-name "g_string_insert"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gint") ("const" "gchar" "*"))
     :c-arg-names (string pos val)
     :arguments ((* GString) gint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1659 <333> 
;; GString* g_string_insert_c( GString* string, gint pos, gchar c);
(ff:bind-c-function g_string_insert_c
     :unconverted-entry-name "g_string_insert_c"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gint") ("gchar"))
     :c-arg-names (string pos c)
     :arguments ((* GString) gint gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1662 <334> 
;; GString* g_string_erase( GString* string, gint pos, gint len);
(ff:bind-c-function g_string_erase
     :unconverted-entry-name "g_string_erase"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*") ("gint") ("gint"))
     :c-arg-names (string pos len)
     :arguments ((* GString) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1665 <335> 
;; GString* g_string_down( GString* string);
(ff:bind-c-function g_string_down
     :unconverted-entry-name "g_string_down"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*"))
     :c-arg-names (string)
     :arguments ((* GString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1666 <336> 
;; GString* g_string_up( GString* string);
(ff:bind-c-function g_string_up
     :unconverted-entry-name "g_string_up"
     :c-return-type ("GString" "*")
     :return-type (* GString)
     :c-arg-types (("GString" "*"))
     :c-arg-names (string)
     :arguments ((* GString))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1667 <337> 
;; void g_string_sprintf( GString* string, const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_string_sprintf
     :unconverted-entry-name "g_string_sprintf"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GString" "*") ("const" "gchar" "*") "...")
     :c-arg-names (string format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1670 <338> 
;; void g_string_sprintfa( GString* string, const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_string_sprintfa
     :unconverted-entry-name "g_string_sprintfa"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GString" "*") ("const" "gchar" "*") "...")
     :c-arg-names (string format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1685 <339> 
;; GArray* g_array_new( gboolean zero_terminated, gboolean clear, guint
;;   element_size
;;   );
(ff:bind-c-function g_array_new
     :unconverted-entry-name "g_array_new"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("gboolean") ("gboolean") ("guint"))
     :c-arg-names (zero_terminated clear element_size)
     :arguments (gboolean gboolean guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1688 <340> 
;; void g_array_free( GArray* array, gboolean free_segment);
(ff:bind-c-function g_array_free
     :unconverted-entry-name "g_array_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GArray" "*") ("gboolean"))
     :c-arg-names (array free_segment)
     :arguments ((* GArray) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1690 <341> 
;; GArray* g_array_append_vals( GArray* array, gconstpointer data, guint
;;    len);
(ff:bind-c-function g_array_append_vals
     :unconverted-entry-name "g_array_append_vals"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("gconstpointer") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GArray) gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1693 <342> 
;; GArray* g_array_prepend_vals( GArray* array, gconstpointer data, guint
;;    len);
(ff:bind-c-function g_array_prepend_vals
     :unconverted-entry-name "g_array_prepend_vals"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("gconstpointer") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GArray) gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1696 <343> 
;; GArray* g_array_insert_vals( GArray* array, guint index, gconstpointer
;;    data, guint len);
(ff:bind-c-function g_array_insert_vals
     :unconverted-entry-name "g_array_insert_vals"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint") ("gconstpointer") ("guint"))
     :c-arg-names (array index data len)
     :arguments ((* GArray) guint gconstpointer guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1700 <344> 
;; GArray* g_array_set_size( GArray* array, guint length);
(ff:bind-c-function g_array_set_size
     :unconverted-entry-name "g_array_set_size"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint"))
     :c-arg-names (array length)
     :arguments ((* GArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1702 <345> 
;; GArray* g_array_remove_index( GArray* array, guint index);
(ff:bind-c-function g_array_remove_index
     :unconverted-entry-name "g_array_remove_index"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1704 <346> 
;; GArray* g_array_remove_index_fast( GArray* array, guint index);
(ff:bind-c-function g_array_remove_index_fast
     :unconverted-entry-name "g_array_remove_index_fast"
     :c-return-type ("GArray" "*")
     :return-type (* GArray)
     :c-arg-types (("GArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1713 <347> 
;; GPtrArray* g_ptr_array_new( void);
(ff:bind-c-function g_ptr_array_new
     :unconverted-entry-name "g_ptr_array_new"
     :c-return-type ("GPtrArray" "*")
     :return-type (* GPtrArray)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1714 <348> 
;; void g_ptr_array_free( GPtrArray* array, gboolean free_seg);
(ff:bind-c-function g_ptr_array_free
     :unconverted-entry-name "g_ptr_array_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPtrArray" "*") ("gboolean"))
     :c-arg-names (array free_seg)
     :arguments ((* GPtrArray) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1716 <349> 
;; void g_ptr_array_set_size( GPtrArray* array, gint length);
(ff:bind-c-function g_ptr_array_set_size
     :unconverted-entry-name "g_ptr_array_set_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPtrArray" "*") ("gint"))
     :c-arg-names (array length)
     :arguments ((* GPtrArray) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1718 <350> 
;; gpointer g_ptr_array_remove_index( GPtrArray* array, guint index);
(ff:bind-c-function g_ptr_array_remove_index
     :unconverted-entry-name "g_ptr_array_remove_index"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GPtrArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GPtrArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1720 <351> 
;; gpointer g_ptr_array_remove_index_fast( GPtrArray* array, guint index);
(ff:bind-c-function g_ptr_array_remove_index_fast
     :unconverted-entry-name "g_ptr_array_remove_index_fast"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GPtrArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GPtrArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1722 <352> 
;; gboolean g_ptr_array_remove( GPtrArray* array, gpointer data);
(ff:bind-c-function g_ptr_array_remove
     :unconverted-entry-name "g_ptr_array_remove"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GPtrArray" "*") ("gpointer"))
     :c-arg-names (array data)
     :arguments ((* GPtrArray) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1724 <353> 
;; gboolean g_ptr_array_remove_fast( GPtrArray* array, gpointer data);
(ff:bind-c-function g_ptr_array_remove_fast
     :unconverted-entry-name "g_ptr_array_remove_fast"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GPtrArray" "*") ("gpointer"))
     :c-arg-names (array data)
     :arguments ((* GPtrArray) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1726 <354> 
;; void g_ptr_array_add( GPtrArray* array, gpointer data);
(ff:bind-c-function g_ptr_array_add
     :unconverted-entry-name "g_ptr_array_add"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPtrArray" "*") ("gpointer"))
     :c-arg-names (array data)
     :arguments ((* GPtrArray) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1733 <355> 
;; GByteArray* g_byte_array_new( void);
(ff:bind-c-function g_byte_array_new
     :unconverted-entry-name "g_byte_array_new"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1734 <356> 
;; void g_byte_array_free( GByteArray* array, gboolean free_segment);
(ff:bind-c-function g_byte_array_free
     :unconverted-entry-name "g_byte_array_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GByteArray" "*") ("gboolean"))
     :c-arg-names (array free_segment)
     :arguments ((* GByteArray) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1736 <357> 
;; GByteArray* g_byte_array_append( GByteArray* array, const guint8* data,
;;              guint len);
(ff:bind-c-function g_byte_array_append
     :unconverted-entry-name "g_byte_array_append"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("const" "guint8" "*") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GByteArray) (* guint8) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1739 <358> 
;; GByteArray* g_byte_array_prepend( GByteArray* array, const guint8* data,
;;              guint len);
(ff:bind-c-function g_byte_array_prepend
     :unconverted-entry-name "g_byte_array_prepend"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("const" "guint8" "*") ("guint"))
     :c-arg-names (array data len)
     :arguments ((* GByteArray) (* guint8) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1742 <359> 
;; GByteArray* g_byte_array_set_size( GByteArray* array, guint length);
(ff:bind-c-function g_byte_array_set_size
     :unconverted-entry-name "g_byte_array_set_size"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("guint"))
     :c-arg-names (array length)
     :arguments ((* GByteArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1744 <360> 
;; GByteArray* g_byte_array_remove_index( GByteArray* array, guint index);
(ff:bind-c-function g_byte_array_remove_index
     :unconverted-entry-name "g_byte_array_remove_index"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GByteArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1746 <361> 
;; GByteArray* g_byte_array_remove_index_fast( GByteArray* array, guint
;;   index
;;   );
(ff:bind-c-function g_byte_array_remove_index_fast
     :unconverted-entry-name "g_byte_array_remove_index_fast"
     :c-return-type ("GByteArray" "*")
     :return-type (* GByteArray)
     :c-arg-types (("GByteArray" "*") ("guint"))
     :c-arg-names (array index)
     :arguments ((* GByteArray) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1752 <362> 
;; gint g_str_equal( gconstpointer v, gconstpointer v2);
(ff:bind-c-function g_str_equal
     :unconverted-entry-name "g_str_equal"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gconstpointer") ("gconstpointer"))
     :c-arg-names (v v2)
     :arguments (gconstpointer gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1754 <363> 
;; guint g_str_hash( gconstpointer v);
(ff:bind-c-function g_str_hash
     :unconverted-entry-name "g_str_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gconstpointer"))
     :c-arg-names (v)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1756 <364> 
;; gint g_int_equal( gconstpointer v, gconstpointer v2);
(ff:bind-c-function g_int_equal
     :unconverted-entry-name "g_int_equal"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gconstpointer") ("gconstpointer"))
     :c-arg-names (v v2)
     :arguments (gconstpointer gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1758 <365> 
;; guint g_int_hash( gconstpointer v);
(ff:bind-c-function g_int_hash
     :unconverted-entry-name "g_int_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gconstpointer"))
     :c-arg-names (v)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1766 <366> 
;; guint g_direct_hash( gconstpointer v);
(ff:bind-c-function g_direct_hash
     :unconverted-entry-name "g_direct_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gconstpointer"))
     :c-arg-names (v)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1767 <367> 
;; gint g_direct_equal( gconstpointer v, gconstpointer v2);
(ff:bind-c-function g_direct_equal
     :unconverted-entry-name "g_direct_equal"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gconstpointer") ("gconstpointer"))
     :c-arg-names (v v2)
     :arguments (gconstpointer gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1773 <368> 
;; GQuark g_quark_try_string( const gchar* string);
(ff:bind-c-function g_quark_try_string
     :all-names ((g_quark_try_string . "g_quark_try_string")
                 (gtk_object_data_try_key . "gtk_object_data_try_key"))
     :unconverted-entry-name "g_quark_try_string"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1774 <369> 
;; GQuark g_quark_from_static_string( const gchar* string);
(ff:bind-c-function g_quark_from_static_string
     :unconverted-entry-name "g_quark_from_static_string"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1775 <370> 
;; GQuark g_quark_from_string( const gchar* string);
(ff:bind-c-function g_quark_from_string
     :all-names ((g_quark_from_string . "g_quark_from_string")
                 (gtk_object_data_force_id . "gtk_object_data_force_id"))
     :unconverted-entry-name "g_quark_from_string"
     :c-return-type ("GQuark")
     :return-type GQuark
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1776 <371> 
;; gchar* g_quark_to_string( GQuark quark);
(ff:bind-c-function g_quark_to_string
     :unconverted-entry-name "g_quark_to_string"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GQuark"))
     :c-arg-names (quark)
     :arguments (GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1782 <372> 
;; void g_datalist_init( GData** datalist);
(ff:bind-c-function g_datalist_init
     :unconverted-entry-name "g_datalist_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*"))
     :c-arg-names (datalist)
     :arguments ((* (* GData)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1783 <373> 
;; void g_datalist_clear( GData** datalist);
(ff:bind-c-function g_datalist_clear
     :unconverted-entry-name "g_datalist_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*"))
     :c-arg-names (datalist)
     :arguments ((* (* GData)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1784 <374> 
;; gpointer g_datalist_id_get_data( GData** datalist, GQuark key_id);
(ff:bind-c-function g_datalist_id_get_data
     :unconverted-entry-name "g_datalist_id_get_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GData" "*" "*") ("GQuark"))
     :c-arg-names (datalist key_id)
     :arguments ((* (* GData)) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1786 <375> 
;; void g_datalist_id_set_data_full( GData** datalist, GQuark key_id,
;;   gpointer
;;    data, GDestroyNotify destroy_func);
(ff:bind-c-function g_datalist_id_set_data_full
     :unconverted-entry-name "g_datalist_id_set_data_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*") ("GQuark") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (datalist key_id data destroy_func)
     :arguments ((* (* GData)) GQuark gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1790 <376> 
;; void g_datalist_id_remove_no_notify( GData** datalist, GQuark key_id);
(ff:bind-c-function g_datalist_id_remove_no_notify
     :unconverted-entry-name "g_datalist_id_remove_no_notify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*") ("GQuark"))
     :c-arg-names (datalist key_id)
     :arguments ((* (* GData)) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1792 <377> 
;; void g_datalist_foreach( GData** datalist, GDataForeachFunc func,
;;   gpointer
;;    user_data);
(ff:bind-c-function g_datalist_foreach
     :unconverted-entry-name "g_datalist_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GData" "*" "*") ("GDataForeachFunc") ("gpointer"))
     :c-arg-names (datalist func user_data)
     :arguments ((* (* GData)) GDataForeachFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1814 <378> 
;; void g_dataset_destroy( gconstpointer dataset_location);
(ff:bind-c-function g_dataset_destroy
     :unconverted-entry-name "g_dataset_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer"))
     :c-arg-names (dataset_location)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1815 <379> 
;; gpointer g_dataset_id_get_data( gconstpointer dataset_location, GQuark
;;    key_id);
(ff:bind-c-function g_dataset_id_get_data
     :unconverted-entry-name "g_dataset_id_get_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("gconstpointer") ("GQuark"))
     :c-arg-names (dataset_location key_id)
     :arguments (gconstpointer GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1817 <380> 
;; void g_dataset_id_set_data_full( gconstpointer dataset_location, GQuark
;;    key_id, gpointer data, GDestroyNotify destroy_func);
(ff:bind-c-function g_dataset_id_set_data_full
     :unconverted-entry-name "g_dataset_id_set_data_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer") ("GQuark") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (dataset_location key_id data destroy_func)
     :arguments (gconstpointer GQuark gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1821 <381> 
;; void g_dataset_id_remove_no_notify( gconstpointer dataset_location,
;;   GQuark
;;    key_id);
(ff:bind-c-function g_dataset_id_remove_no_notify
     :unconverted-entry-name "g_dataset_id_remove_no_notify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer") ("GQuark"))
     :c-arg-names (dataset_location key_id)
     :arguments (gconstpointer GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1823 <382> 
;; void g_dataset_foreach( gconstpointer dataset_location, GDataForeachFunc
;;    func, gpointer user_data);
(ff:bind-c-function g_dataset_foreach
     :unconverted-entry-name "g_dataset_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gconstpointer") ("GDataForeachFunc") ("gpointer"))
     :c-arg-names (dataset_location func user_data)
     :arguments (gconstpointer GDataForeachFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1858 <383> 
;; typedef enum {
;;         G_ERR_UNKNOWN, G_ERR_UNEXP_EOF, G_ERR_UNEXP_EOF_IN_STRING,
;;   G_ERR_UNEXP_EOF_IN_COMMENT,
;;              G_ERR_NON_DIGIT_IN_CONST, G_ERR_DIGIT_RADIX,
;;   G_ERR_FLOAT_RADIX, G_ERR_FLOAT_MALFORMED
;;    } GErrorType;
(ff:bind-c-constant G_ERR_UNKNOWN 0) ;;  G_ERR_UNKNOWN 
(ff:bind-c-constant G_ERR_UNEXP_EOF 1) ;;  G_ERR_UNEXP_EOF 
(ff:bind-c-constant G_ERR_UNEXP_EOF_IN_STRING 2) ;;
;;   G_ERR_UNEXP_EOF_IN_STRING 
(ff:bind-c-constant G_ERR_UNEXP_EOF_IN_COMMENT
                    3) ;;
;;   G_ERR_UNEXP_EOF_IN_COMMENT 
(ff:bind-c-constant G_ERR_NON_DIGIT_IN_CONST 4) ;;
;;   G_ERR_NON_DIGIT_IN_CONST 
(ff:bind-c-constant G_ERR_DIGIT_RADIX 5) ;;  G_ERR_DIGIT_RADIX 
(ff:bind-c-constant G_ERR_FLOAT_RADIX 6) ;;  G_ERR_FLOAT_RADIX 
(ff:bind-c-constant G_ERR_FLOAT_MALFORMED 7) ;;  G_ERR_FLOAT_MALFORMED 
(ff:bind-c-type GErrorType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1871 <384> 
;; typedef enum {
;;         G_TOKEN_EOF =  0x000000000, G_TOKEN_LEFT_PAREN =  0x000000028,
;;   G_TOKEN_RIGHT_PAREN
;;    =  0x000000029, G_TOKEN_LEFT_CURLY =  0x00000007b,
;;   G_TOKEN_RIGHT_CURLY
;;    =  0x00000007d, G_TOKEN_LEFT_BRACE =  0x00000005b,
;;   G_TOKEN_RIGHT_BRACE
;;    =  0x00000005d, G_TOKEN_EQUAL_SIGN =  0x00000003d, G_TOKEN_COMMA =
;;   0x00000002c,
;;              G_TOKEN_NONE =  0x000000100, G_TOKEN_ERROR, G_TOKEN_CHAR,
;;   G_TOKEN_BINARY,
;;              G_TOKEN_OCTAL, G_TOKEN_INT, G_TOKEN_HEX, G_TOKEN_FLOAT,
;;   G_TOKEN_STRING,
;;              G_TOKEN_SYMBOL, G_TOKEN_IDENTIFIER,
;;   G_TOKEN_IDENTIFIER_NULL, G_TOKEN_COMMENT_SINGLE,
;;              G_TOKEN_COMMENT_MULTI, G_TOKEN_LAST } GTokenType;
(ff:bind-c-constant G_TOKEN_EOF 0) ;;  G_TOKEN_EOF =  0x000000000 
(ff:bind-c-constant G_TOKEN_LEFT_PAREN
                    40) ;;
;;   G_TOKEN_LEFT_PAREN =  0x000000028 
(ff:bind-c-constant G_TOKEN_RIGHT_PAREN
                    41) ;;
;;   G_TOKEN_RIGHT_PAREN =  0x000000029 
(ff:bind-c-constant G_TOKEN_LEFT_CURLY
                    123) ;;
;;   G_TOKEN_LEFT_CURLY =  0x00000007b 
(ff:bind-c-constant G_TOKEN_RIGHT_CURLY
                    125) ;;
;;   G_TOKEN_RIGHT_CURLY =  0x00000007d 
(ff:bind-c-constant G_TOKEN_LEFT_BRACE
                    91) ;;
;;   G_TOKEN_LEFT_BRACE =  0x00000005b 
(ff:bind-c-constant G_TOKEN_RIGHT_BRACE
                    93) ;;
;;   G_TOKEN_RIGHT_BRACE =  0x00000005d 
(ff:bind-c-constant G_TOKEN_EQUAL_SIGN
                    61) ;;
;;   G_TOKEN_EQUAL_SIGN =  0x00000003d 
(ff:bind-c-constant G_TOKEN_COMMA 44) ;;  G_TOKEN_COMMA =  0x00000002c 
(ff:bind-c-constant G_TOKEN_NONE 256) ;;  G_TOKEN_NONE =  0x000000100 
(ff:bind-c-constant G_TOKEN_ERROR 0) ;;  G_TOKEN_ERROR 
(ff:bind-c-constant G_TOKEN_CHAR 1) ;;  G_TOKEN_CHAR 
(ff:bind-c-constant G_TOKEN_BINARY 2) ;;  G_TOKEN_BINARY 
(ff:bind-c-constant G_TOKEN_OCTAL 3) ;;  G_TOKEN_OCTAL 
(ff:bind-c-constant G_TOKEN_INT 4) ;;  G_TOKEN_INT 
(ff:bind-c-constant G_TOKEN_HEX 5) ;;  G_TOKEN_HEX 
(ff:bind-c-constant G_TOKEN_FLOAT 6) ;;  G_TOKEN_FLOAT 
(ff:bind-c-constant G_TOKEN_STRING 7) ;;  G_TOKEN_STRING 
(ff:bind-c-constant G_TOKEN_SYMBOL 8) ;;  G_TOKEN_SYMBOL 
(ff:bind-c-constant G_TOKEN_IDENTIFIER 9) ;;  G_TOKEN_IDENTIFIER 
(ff:bind-c-constant G_TOKEN_IDENTIFIER_NULL 10) ;;
;;   G_TOKEN_IDENTIFIER_NULL 
(ff:bind-c-constant G_TOKEN_COMMENT_SINGLE 11) ;;  G_TOKEN_COMMENT_SINGLE 
(ff:bind-c-constant G_TOKEN_COMMENT_MULTI 12) ;;  G_TOKEN_COMMENT_MULTI 
(ff:bind-c-constant G_TOKEN_LAST 13) ;;  G_TOKEN_LAST 
(ff:bind-c-type GTokenType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1905 <385> 
;; union _GTokenValue {
;;         gpointer v_symbol; gchar* v_identifier; gulong v_binary; gulong
;;   v_octal;
;;              gulong v_int; gdouble v_float; gulong v_hex; gchar*
;;   v_string; gchar* v_comment;
;;              guchar v_char; guint v_error; };
(ff:bind-c-type _GTokenValue (:union
  (v_symbol gpointer)   ;; gpointer v_symbol
  (v_identifier (* gchar))   ;; gchar* v_identifier
  (v_binary gulong)   ;; gulong v_binary
  (v_octal gulong)   ;; gulong v_octal
  (v_int gulong)   ;; gulong v_int
  (v_float gdouble)   ;; gdouble v_float
  (v_hex gulong)   ;; gulong v_hex
  (v_string (* gchar))   ;; gchar* v_string
  (v_comment (* gchar))   ;; gchar* v_comment
  (v_char guchar)   ;; guchar v_char
  (v_error guint)   ;; guint v_error
  ))   ;; bind-c-type _GTokenValue

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1920 <386> 
;; struct _GScannerConfig {
;;         gchar* cset_skip_characters; gchar* cset_identifier_first;
;;   gchar* cset_identifier_nth;
;;              gchar* cpair_comment_single; guint case_sensitive:
;;   0x000000001; guint
;;    skip_comment_multi:  0x000000001; guint skip_comment_single:
;;   0x000000001;
;;              guint scan_comment_multi:  0x000000001; guint
;;   scan_identifier:  0x000000001;
;;              guint scan_identifier_1char:  0x000000001; guint
;;   scan_identifier_NULL
;;   :  0x000000001; guint scan_symbols:  0x000000001; guint scan_binary:
;;   0x000000001;
;;              guint scan_octal:  0x000000001; guint scan_float:
;;   0x000000001; guint
;;    scan_hex:  0x000000001; guint scan_hex_dollar:  0x000000001; guint
;;   scan_string_sq
;;   :  0x000000001; guint scan_string_dq:  0x000000001; guint
;;   numbers_2_int
;;   :  0x000000001; guint int_2_float:  0x000000001; guint
;;   identifier_2_string
;;   :  0x000000001; guint char_2_token:  0x000000001; guint symbol_2_token
;;   :  0x000000001; guint scope_0_fallback:  0x000000001; };

;;WARNING: Strange bitfield case_sensitive type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield skip_comment_multi type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield skip_comment_single type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_comment_multi type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_identifier type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_identifier_1char type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_identifier_NULL type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_symbols type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_binary type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_octal type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_float type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_hex type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_hex_dollar type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_string_sq type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scan_string_dq type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield numbers_2_int type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield int_2_float type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield identifier_2_string type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield char_2_token type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield symbol_2_token type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scope_0_fallback type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GScannerConfig (:struct
  (cset_skip_characters (* gchar))   ;; gchar* cset_skip_characters
  (cset_identifier_first (* gchar))   ;; gchar* cset_identifier_first
  (cset_identifier_nth (* gchar))   ;; gchar* cset_identifier_nth
  (cpair_comment_single (* gchar))   ;; gchar* cpair_comment_single
  (case_sensitive (:bit 1))   ;; guint case_sensitive:  0x000000001
  (skip_comment_multi (:bit 1))   ;; guint skip_comment_multi:  0x000000001
  (skip_comment_single (:bit 1))   ;;
  ;;  guint skip_comment_single:  0x000000001
  (scan_comment_multi (:bit 1))   ;; guint scan_comment_multi:  0x000000001
  (scan_identifier (:bit 1))   ;; guint scan_identifier:  0x000000001
  (scan_identifier_1char (:bit
                          1))   ;;
  ;;  guint scan_identifier_1char:  0x000000001
  (scan_identifier_NULL (:bit 1))   ;;
  ;;  guint scan_identifier_NULL:  0x000000001
  (scan_symbols (:bit 1))   ;; guint scan_symbols:  0x000000001
  (scan_binary (:bit 1))   ;; guint scan_binary:  0x000000001
  (scan_octal (:bit 1))   ;; guint scan_octal:  0x000000001
  (scan_float (:bit 1))   ;; guint scan_float:  0x000000001
  (scan_hex (:bit 1))   ;; guint scan_hex:  0x000000001
  (scan_hex_dollar (:bit 1))   ;; guint scan_hex_dollar:  0x000000001
  (scan_string_sq (:bit 1))   ;; guint scan_string_sq:  0x000000001
  (scan_string_dq (:bit 1))   ;; guint scan_string_dq:  0x000000001
  (numbers_2_int (:bit 1))   ;; guint numbers_2_int:  0x000000001
  (int_2_float (:bit 1))   ;; guint int_2_float:  0x000000001
  (identifier_2_string (:bit 1))   ;;
  ;;  guint identifier_2_string:  0x000000001
  (char_2_token (:bit 1))   ;; guint char_2_token:  0x000000001
  (symbol_2_token (:bit 1))   ;; guint symbol_2_token:  0x000000001
  (scope_0_fallback (:bit 1))   ;; guint scope_0_fallback:  0x000000001
  ))   ;; bind-c-type _GScannerConfig

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:1958 <387> 
;; struct _GScanner {
;;         gpointer user_data; guint max_parse_errors; guint parse_errors;
;;   const
;;    gchar* input_name; gpointer derived_data; GScannerConfig* config;
;;   GTokenType
;;    token; GTokenValue value; guint line; guint position; GTokenType
;;   next_token;
;;              GTokenValue next_value; guint next_line; guint
;;   next_position; GHashTable
;;   * symbol_table; gint input_fd; const gchar* text; const gchar*
;;   text_end;
;;              gchar* buffer; guint scope_id; GScannerMsgFunc msg_handler;
;;   };
(ff:bind-c-type _GScanner (:struct
  (user_data gpointer)   ;; gpointer user_data
  (max_parse_errors guint)   ;; guint max_parse_errors
  (parse_errors guint)   ;; guint parse_errors
  (input_name (* gchar))   ;; const gchar* input_name
  (derived_data gpointer)   ;; gpointer derived_data
  (config (* GScannerConfig))   ;; GScannerConfig* config
  (token GTokenType)   ;; GTokenType token
  (value GTokenValue)   ;; GTokenValue value
  (line guint)   ;; guint line
  (position guint)   ;; guint position
  (next_token GTokenType)   ;; GTokenType next_token
  (next_value GTokenValue)   ;; GTokenValue next_value
  (next_line guint)   ;; guint next_line
  (next_position guint)   ;; guint next_position
  (symbol_table (* GHashTable))   ;; GHashTable* symbol_table
  (input_fd gint)   ;; gint input_fd
  (text (* gchar))   ;; const gchar* text
  (text_end (* gchar))   ;; const gchar* text_end
  (buffer (* gchar))   ;; gchar* buffer
  (scope_id guint)   ;; guint scope_id
  (msg_handler GScannerMsgFunc)   ;; GScannerMsgFunc msg_handler
  ))   ;; bind-c-type _GScanner

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2000 <388> 
;; GScanner* g_scanner_new( GScannerConfig* config_templ);
(ff:bind-c-function g_scanner_new
     :unconverted-entry-name "g_scanner_new"
     :c-return-type ("GScanner" "*")
     :return-type (* GScanner)
     :c-arg-types (("GScannerConfig" "*"))
     :c-arg-names (config_templ)
     :arguments ((* GScannerConfig))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2001 <389> 
;; void g_scanner_destroy( GScanner* scanner);
(ff:bind-c-function g_scanner_destroy
     :unconverted-entry-name "g_scanner_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2002 <390> 
;; void g_scanner_input_file( GScanner* scanner, gint input_fd);
(ff:bind-c-function g_scanner_input_file
     :unconverted-entry-name "g_scanner_input_file"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("gint"))
     :c-arg-names (scanner input_fd)
     :arguments ((* GScanner) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2004 <391> 
;; void g_scanner_sync_file_offset( GScanner* scanner);
(ff:bind-c-function g_scanner_sync_file_offset
     :unconverted-entry-name "g_scanner_sync_file_offset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2005 <392> 
;; void g_scanner_input_text( GScanner* scanner, const gchar* text, guint
;;    text_len);
(ff:bind-c-function g_scanner_input_text
     :unconverted-entry-name "g_scanner_input_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*") ("guint"))
     :c-arg-names (scanner text text_len)
     :arguments ((* GScanner) (* gchar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2008 <393> 
;; GTokenType g_scanner_get_next_token( GScanner* scanner);
(ff:bind-c-function g_scanner_get_next_token
     :unconverted-entry-name "g_scanner_get_next_token"
     :c-return-type ("GTokenType")
     :return-type GTokenType
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2009 <394> 
;; GTokenType g_scanner_peek_next_token( GScanner* scanner);
(ff:bind-c-function g_scanner_peek_next_token
     :unconverted-entry-name "g_scanner_peek_next_token"
     :c-return-type ("GTokenType")
     :return-type GTokenType
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2010 <395> 
;; GTokenType g_scanner_cur_token( GScanner* scanner);
(ff:bind-c-function g_scanner_cur_token
     :unconverted-entry-name "g_scanner_cur_token"
     :c-return-type ("GTokenType")
     :return-type GTokenType
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2011 <396> 
;; GTokenValue g_scanner_cur_value( GScanner* scanner);

;;NOTE: C wrapper needed to return structure or union type
;;   GTokenValue.
(ff:bind-c-function g_scanner_cur_value
     :unconverted-entry-name "ACL_g_scanner_cur_value"
     :c-return-type ("GTokenValue" "*")
     :return-type (* GTokenValue)
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2012 <397> 
;; guint g_scanner_cur_line( GScanner* scanner);
(ff:bind-c-function g_scanner_cur_line
     :unconverted-entry-name "g_scanner_cur_line"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2013 <398> 
;; guint g_scanner_cur_position( GScanner* scanner);
(ff:bind-c-function g_scanner_cur_position
     :unconverted-entry-name "g_scanner_cur_position"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2014 <399> 
;; gboolean g_scanner_eof( GScanner* scanner);
(ff:bind-c-function g_scanner_eof
     :unconverted-entry-name "g_scanner_eof"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2015 <400> 
;; guint g_scanner_set_scope( GScanner* scanner, guint scope_id);
(ff:bind-c-function g_scanner_set_scope
     :unconverted-entry-name "g_scanner_set_scope"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GScanner" "*") ("guint"))
     :c-arg-names (scanner scope_id)
     :arguments ((* GScanner) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2017 <401> 
;; void g_scanner_scope_add_symbol( GScanner* scanner, guint scope_id,
;;   const
;;    gchar* symbol, gpointer value);
(ff:bind-c-function g_scanner_scope_add_symbol
     :unconverted-entry-name "g_scanner_scope_add_symbol"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("guint") ("const" "gchar" "*")
                   ("gpointer"))
     :c-arg-names (scanner scope_id symbol value)
     :arguments ((* GScanner) guint (* gchar) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2021 <402> 
;; void g_scanner_scope_remove_symbol( GScanner* scanner, guint scope_id,
;;              const gchar* symbol);
(ff:bind-c-function g_scanner_scope_remove_symbol
     :unconverted-entry-name "g_scanner_scope_remove_symbol"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("guint") ("const" "gchar" "*"))
     :c-arg-names (scanner scope_id symbol)
     :arguments ((* GScanner) guint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2024 <403> 
;; gpointer g_scanner_scope_lookup_symbol( GScanner* scanner, guint
;;   scope_id,
;;              const gchar* symbol);
(ff:bind-c-function g_scanner_scope_lookup_symbol
     :unconverted-entry-name "g_scanner_scope_lookup_symbol"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GScanner" "*") ("guint") ("const" "gchar" "*"))
     :c-arg-names (scanner scope_id symbol)
     :arguments ((* GScanner) guint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2027 <404> 
;; void g_scanner_scope_foreach_symbol( GScanner* scanner, guint scope_id,
;;              GHFunc func, gpointer user_data);
(ff:bind-c-function g_scanner_scope_foreach_symbol
     :unconverted-entry-name "g_scanner_scope_foreach_symbol"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("guint") ("GHFunc") ("gpointer"))
     :c-arg-names (scanner scope_id func user_data)
     :arguments ((* GScanner) guint GHFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2031 <405> 
;; gpointer g_scanner_lookup_symbol( GScanner* scanner, const gchar* symbol
;;   );
(ff:bind-c-function g_scanner_lookup_symbol
     :unconverted-entry-name "g_scanner_lookup_symbol"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*"))
     :c-arg-names (scanner symbol)
     :arguments ((* GScanner) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2033 <406> 
;; void g_scanner_freeze_symbol_table( GScanner* scanner);
(ff:bind-c-function g_scanner_freeze_symbol_table
     :unconverted-entry-name "g_scanner_freeze_symbol_table"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2034 <407> 
;; void g_scanner_thaw_symbol_table( GScanner* scanner);
(ff:bind-c-function g_scanner_thaw_symbol_table
     :unconverted-entry-name "g_scanner_thaw_symbol_table"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2035 <408> 
;; void g_scanner_unexp_token( GScanner* scanner, GTokenType
;;   expected_token,
;;              const gchar* identifier_spec, const gchar* symbol_spec,
;;   const gchar* symbol_name,
;;              const gchar* message, gint is_error);
(ff:bind-c-function g_scanner_unexp_token
     :unconverted-entry-name "g_scanner_unexp_token"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("GTokenType") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*") ("gint"))
     :c-arg-names (scanner expected_token identifier_spec symbol_spec
                   symbol_name message is_error)
     :arguments ((* GScanner) GTokenType (* gchar) (* gchar) (* gchar)
                 (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2042 <409> 
;; void g_scanner_error( GScanner* scanner, const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_scanner_error
     :unconverted-entry-name "g_scanner_error"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*") "...")
     :c-arg-names (scanner format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2045 <410> 
;; void g_scanner_warn( GScanner* scanner, const gchar* format, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_scanner_warn
     :unconverted-entry-name "g_scanner_warn"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GScanner" "*") ("const" "gchar" "*") "...")
     :c-arg-names (scanner format)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2048 <411> 
;; gint g_scanner_stat_mode( const gchar* filename);
(ff:bind-c-function g_scanner_stat_mode
     :unconverted-entry-name "g_scanner_stat_mode"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (filename)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2064 <412> 
;; struct _GCompletion {
;;         GList* items; GCompletionFunc func; gchar* prefix; GList* cache;
;;   };
(ff:bind-c-type _GCompletion (:struct
  (items (* GList))   ;; GList* items
  (func GCompletionFunc)   ;; GCompletionFunc func
  (prefix (* gchar))   ;; gchar* prefix
  (cache (* GList))   ;; GList* cache
  ))   ;; bind-c-type _GCompletion

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2073 <413> 
;; GCompletion* g_completion_new( GCompletionFunc func);
(ff:bind-c-function g_completion_new
     :unconverted-entry-name "g_completion_new"
     :c-return-type ("GCompletion" "*")
     :return-type (* GCompletion)
     :c-arg-types (("GCompletionFunc"))
     :c-arg-names (func)
     :arguments (GCompletionFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2074 <414> 
;; void g_completion_add_items( GCompletion* cmp, GList* items);
(ff:bind-c-function g_completion_add_items
     :unconverted-entry-name "g_completion_add_items"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*") ("GList" "*"))
     :c-arg-names (cmp items)
     :arguments ((* GCompletion) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2076 <415> 
;; void g_completion_remove_items( GCompletion* cmp, GList* items);
(ff:bind-c-function g_completion_remove_items
     :unconverted-entry-name "g_completion_remove_items"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*") ("GList" "*"))
     :c-arg-names (cmp items)
     :arguments ((* GCompletion) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2078 <416> 
;; void g_completion_clear_items( GCompletion* cmp);
(ff:bind-c-function g_completion_clear_items
     :unconverted-entry-name "g_completion_clear_items"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*"))
     :c-arg-names (cmp)
     :arguments ((* GCompletion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2079 <417> 
;; GList* g_completion_complete( GCompletion* cmp, gchar* prefix, gchar*
;;   * new_prefix);
(ff:bind-c-function g_completion_complete
     :unconverted-entry-name "g_completion_complete"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GCompletion" "*") ("gchar" "*") ("gchar" "*" "*"))
     :c-arg-names (cmp prefix new_prefix)
     :arguments ((* GCompletion) (* gchar) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2082 <418> 
;; void g_completion_free( GCompletion* cmp);
(ff:bind-c-function g_completion_free
     :unconverted-entry-name "g_completion_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GCompletion" "*"))
     :c-arg-names (cmp)
     :arguments ((* GCompletion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2094 <419> 
;; typedef guint16 GDateYear;
(ff:bind-c-type GDateYear guint16)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2095 <420> 
;; typedef guint8 GDateDay;
(ff:bind-c-type GDateDay guint8)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2096 <421> 
;; typedef struct _GDate GDate;
(ff:bind-c-typedef _GDate ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GDate _GDate)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2098 <422> 
;; struct tm;
(ff:bind-c-typedef tm ff:dummy-forward-struct) ;;  forward declaration 

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2101 <423> 
;; typedef enum {
;;         G_DATE_DAY =  0x000000000, G_DATE_MONTH =  0x000000001,
;;   G_DATE_YEAR =
;;     0x000000002 } GDateDMY;
(ff:bind-c-constant G_DATE_DAY 0) ;;  G_DATE_DAY =  0x000000000 
(ff:bind-c-constant G_DATE_MONTH 1) ;;  G_DATE_MONTH =  0x000000001 
(ff:bind-c-constant G_DATE_YEAR 2) ;;  G_DATE_YEAR =  0x000000002 
(ff:bind-c-type GDateDMY :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2109 <424> 
;; typedef enum {
;;         G_DATE_BAD_WEEKDAY =  0x000000000, G_DATE_MONDAY =  0x000000001,
;;   G_DATE_TUESDAY
;;    =  0x000000002, G_DATE_WEDNESDAY =  0x000000003, G_DATE_THURSDAY =
;;   0x000000004,
;;              G_DATE_FRIDAY =  0x000000005, G_DATE_SATURDAY =
;;   0x000000006, G_DATE_SUNDAY
;;    =  0x000000007 } GDateWeekday;
(ff:bind-c-constant G_DATE_BAD_WEEKDAY
                    0) ;;
;;   G_DATE_BAD_WEEKDAY =  0x000000000 
(ff:bind-c-constant G_DATE_MONDAY 1) ;;  G_DATE_MONDAY =  0x000000001 
(ff:bind-c-constant G_DATE_TUESDAY 2) ;;  G_DATE_TUESDAY =  0x000000002 
(ff:bind-c-constant G_DATE_WEDNESDAY 3) ;;
;;   G_DATE_WEDNESDAY =  0x000000003 
(ff:bind-c-constant G_DATE_THURSDAY 4) ;;  G_DATE_THURSDAY =  0x000000004 
(ff:bind-c-constant G_DATE_FRIDAY 5) ;;  G_DATE_FRIDAY =  0x000000005 
(ff:bind-c-constant G_DATE_SATURDAY 6) ;;  G_DATE_SATURDAY =  0x000000006 
(ff:bind-c-constant G_DATE_SUNDAY 7) ;;  G_DATE_SUNDAY =  0x000000007 
(ff:bind-c-type GDateWeekday :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2120 <425> 
;; typedef enum {
;;         G_DATE_BAD_MONTH =  0x000000000, G_DATE_JANUARY =  0x000000001,
;;   G_DATE_FEBRUARY
;;    =  0x000000002, G_DATE_MARCH =  0x000000003, G_DATE_APRIL =
;;   0x000000004,
;;              G_DATE_MAY =  0x000000005, G_DATE_JUNE =  0x000000006,
;;   G_DATE_JULY =  0x000000007,
;;              G_DATE_AUGUST =  0x000000008, G_DATE_SEPTEMBER =
;;   0x000000009, G_DATE_OCTOBER
;;    =  0x00000000a, G_DATE_NOVEMBER =  0x00000000b, G_DATE_DECEMBER =
;;   0x00000000c
;;    } GDateMonth;
(ff:bind-c-constant G_DATE_BAD_MONTH 0) ;;
;;   G_DATE_BAD_MONTH =  0x000000000 
(ff:bind-c-constant G_DATE_JANUARY 1) ;;  G_DATE_JANUARY =  0x000000001 
(ff:bind-c-constant G_DATE_FEBRUARY 2) ;;  G_DATE_FEBRUARY =  0x000000002 
(ff:bind-c-constant G_DATE_MARCH 3) ;;  G_DATE_MARCH =  0x000000003 
(ff:bind-c-constant G_DATE_APRIL 4) ;;  G_DATE_APRIL =  0x000000004 
(ff:bind-c-constant G_DATE_MAY 5) ;;  G_DATE_MAY =  0x000000005 
(ff:bind-c-constant G_DATE_JUNE 6) ;;  G_DATE_JUNE =  0x000000006 
(ff:bind-c-constant G_DATE_JULY 7) ;;  G_DATE_JULY =  0x000000007 
(ff:bind-c-constant G_DATE_AUGUST 8) ;;  G_DATE_AUGUST =  0x000000008 
(ff:bind-c-constant G_DATE_SEPTEMBER 9) ;;
;;   G_DATE_SEPTEMBER =  0x000000009 
(ff:bind-c-constant G_DATE_OCTOBER 10) ;;  G_DATE_OCTOBER =  0x00000000a 
(ff:bind-c-constant G_DATE_NOVEMBER 11) ;;  G_DATE_NOVEMBER =  0x00000000b 
(ff:bind-c-constant G_DATE_DECEMBER 12) ;;  G_DATE_DECEMBER =  0x00000000c 
(ff:bind-c-type GDateMonth :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2146 <426> 
;; struct _GDate {
;;         guint julian_days:  0x000000020; guint julian:  0x000000001;
;;   guint dmy
;;   :  0x000000001; guint day:  0x000000006; guint month:  0x000000004;
;;   guint
;;    year:  0x000000010; };

;;WARNING: Strange bitfield julian_days type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield julian type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield dmy type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield day type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield month type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield year type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GDate (:struct
  (julian_days (:bit 32))   ;; guint julian_days:  0x000000020
  (julian (:bit 1))   ;; guint julian:  0x000000001
  (dmy (:bit 1))   ;; guint dmy:  0x000000001
  (day (:bit 6))   ;; guint day:  0x000000006
  (month (:bit 4))   ;; guint month:  0x000000004
  (year (:bit 16))   ;; guint year:  0x000000010
  ))   ;; bind-c-type _GDate

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2167 <427> 
;; GDate* g_date_new( void);
(ff:bind-c-function g_date_new
     :unconverted-entry-name "g_date_new"
     :c-return-type ("GDate" "*")
     :return-type (* GDate)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2168 <428> 
;; GDate* g_date_new_dmy( GDateDay day, GDateMonth month, GDateYear year);
(ff:bind-c-function g_date_new_dmy
     :unconverted-entry-name "g_date_new_dmy"
     :c-return-type ("GDate" "*")
     :return-type (* GDate)
     :c-arg-types (("GDateDay") ("GDateMonth") ("GDateYear"))
     :c-arg-names (day month year)
     :arguments (GDateDay GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2171 <429> 
;; GDate* g_date_new_julian( guint32 julian_day);
(ff:bind-c-function g_date_new_julian
     :unconverted-entry-name "g_date_new_julian"
     :c-return-type ("GDate" "*")
     :return-type (* GDate)
     :c-arg-types (("guint32"))
     :c-arg-names (julian_day)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2172 <430> 
;; void g_date_free( GDate* date);
(ff:bind-c-function g_date_free
     :unconverted-entry-name "g_date_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2179 <431> 
;; gboolean g_date_valid( GDate* date);
(ff:bind-c-function g_date_valid
     :unconverted-entry-name "g_date_valid"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2180 <432> 
;; gboolean g_date_valid_day( GDateDay day);
(ff:bind-c-function g_date_valid_day
     :unconverted-entry-name "g_date_valid_day"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateDay"))
     :c-arg-names (day)
     :arguments (GDateDay)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2181 <433> 
;; gboolean g_date_valid_month( GDateMonth month);
(ff:bind-c-function g_date_valid_month
     :unconverted-entry-name "g_date_valid_month"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateMonth"))
     :c-arg-names (month)
     :arguments (GDateMonth)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2182 <434> 
;; gboolean g_date_valid_year( GDateYear year);
(ff:bind-c-function g_date_valid_year
     :unconverted-entry-name "g_date_valid_year"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2183 <435> 
;; gboolean g_date_valid_weekday( GDateWeekday weekday);
(ff:bind-c-function g_date_valid_weekday
     :unconverted-entry-name "g_date_valid_weekday"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateWeekday"))
     :c-arg-names (weekday)
     :arguments (GDateWeekday)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2184 <436> 
;; gboolean g_date_valid_julian( guint32 julian_date);
(ff:bind-c-function g_date_valid_julian
     :unconverted-entry-name "g_date_valid_julian"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint32"))
     :c-arg-names (julian_date)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2185 <437> 
;; gboolean g_date_valid_dmy( GDateDay day, GDateMonth month, GDateYear
;;   year
;;   );
(ff:bind-c-function g_date_valid_dmy
     :unconverted-entry-name "g_date_valid_dmy"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateDay") ("GDateMonth") ("GDateYear"))
     :c-arg-names (day month year)
     :arguments (GDateDay GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2189 <438> 
;; GDateWeekday g_date_weekday( GDate* date);
(ff:bind-c-function g_date_weekday
     :unconverted-entry-name "g_date_weekday"
     :c-return-type ("GDateWeekday")
     :return-type GDateWeekday
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2190 <439> 
;; GDateMonth g_date_month( GDate* date);
(ff:bind-c-function g_date_month
     :unconverted-entry-name "g_date_month"
     :c-return-type ("GDateMonth")
     :return-type GDateMonth
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2191 <440> 
;; GDateYear g_date_year( GDate* date);
(ff:bind-c-function g_date_year
     :unconverted-entry-name "g_date_year"
     :c-return-type ("GDateYear")
     :return-type GDateYear
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2192 <441> 
;; GDateDay g_date_day( GDate* date);
(ff:bind-c-function g_date_day
     :unconverted-entry-name "g_date_day"
     :c-return-type ("GDateDay")
     :return-type GDateDay
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2193 <442> 
;; guint32 g_date_julian( GDate* date);
(ff:bind-c-function g_date_julian
     :unconverted-entry-name "g_date_julian"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2194 <443> 
;; guint g_date_day_of_year( GDate* date);
(ff:bind-c-function g_date_day_of_year
     :unconverted-entry-name "g_date_day_of_year"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2202 <444> 
;; guint g_date_monday_week_of_year( GDate* date);
(ff:bind-c-function g_date_monday_week_of_year
     :unconverted-entry-name "g_date_monday_week_of_year"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2203 <445> 
;; guint g_date_sunday_week_of_year( GDate* date);
(ff:bind-c-function g_date_sunday_week_of_year
     :unconverted-entry-name "g_date_sunday_week_of_year"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2209 <446> 
;; void g_date_clear( GDate* date, guint n_dates);
(ff:bind-c-function g_date_clear
     :unconverted-entry-name "g_date_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_dates)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2216 <447> 
;; void g_date_set_parse( GDate* date, const gchar* str);
(ff:bind-c-function g_date_set_parse
     :unconverted-entry-name "g_date_set_parse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("const" "gchar" "*"))
     :c-arg-names (date str)
     :arguments ((* GDate) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2218 <448> 
;; void g_date_set_time( GDate* date, GTime time);
(ff:bind-c-function g_date_set_time
     :unconverted-entry-name "g_date_set_time"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GTime"))
     :c-arg-names (date time)
     :arguments ((* GDate) GTime)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2220 <449> 
;; void g_date_set_month( GDate* date, GDateMonth month);
(ff:bind-c-function g_date_set_month
     :unconverted-entry-name "g_date_set_month"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateMonth"))
     :c-arg-names (date month)
     :arguments ((* GDate) GDateMonth)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2222 <450> 
;; void g_date_set_day( GDate* date, GDateDay day);
(ff:bind-c-function g_date_set_day
     :unconverted-entry-name "g_date_set_day"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateDay"))
     :c-arg-names (date day)
     :arguments ((* GDate) GDateDay)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2224 <451> 
;; void g_date_set_year( GDate* date, GDateYear year);
(ff:bind-c-function g_date_set_year
     :unconverted-entry-name "g_date_set_year"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateYear"))
     :c-arg-names (date year)
     :arguments ((* GDate) GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2226 <452> 
;; void g_date_set_dmy( GDate* date, GDateDay day, GDateMonth month,
;;   GDateYear
;;    y);
(ff:bind-c-function g_date_set_dmy
     :unconverted-entry-name "g_date_set_dmy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("GDateDay") ("GDateMonth") ("GDateYear"))
     :c-arg-names (date day month y)
     :arguments ((* GDate) GDateDay GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2230 <453> 
;; void g_date_set_julian( GDate* date, guint32 julian_date);
(ff:bind-c-function g_date_set_julian
     :unconverted-entry-name "g_date_set_julian"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint32"))
     :c-arg-names (date julian_date)
     :arguments ((* GDate) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2232 <454> 
;; gboolean g_date_is_first_of_month( GDate* date);
(ff:bind-c-function g_date_is_first_of_month
     :unconverted-entry-name "g_date_is_first_of_month"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2233 <455> 
;; gboolean g_date_is_last_of_month( GDate* date);
(ff:bind-c-function g_date_is_last_of_month
     :unconverted-entry-name "g_date_is_last_of_month"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDate" "*"))
     :c-arg-names (date)
     :arguments ((* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2236 <456> 
;; void g_date_add_days( GDate* date, guint n_days);
(ff:bind-c-function g_date_add_days
     :unconverted-entry-name "g_date_add_days"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_days)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2238 <457> 
;; void g_date_subtract_days( GDate* date, guint n_days);
(ff:bind-c-function g_date_subtract_days
     :unconverted-entry-name "g_date_subtract_days"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_days)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2242 <458> 
;; void g_date_add_months( GDate* date, guint n_months);
(ff:bind-c-function g_date_add_months
     :unconverted-entry-name "g_date_add_months"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_months)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2244 <459> 
;; void g_date_subtract_months( GDate* date, guint n_months);
(ff:bind-c-function g_date_subtract_months
     :unconverted-entry-name "g_date_subtract_months"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_months)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2248 <460> 
;; void g_date_add_years( GDate* date, guint n_years);
(ff:bind-c-function g_date_add_years
     :unconverted-entry-name "g_date_add_years"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_years)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2250 <461> 
;; void g_date_subtract_years( GDate* date, guint n_years);
(ff:bind-c-function g_date_subtract_years
     :unconverted-entry-name "g_date_subtract_years"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("guint"))
     :c-arg-names (date n_years)
     :arguments ((* GDate) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2252 <462> 
;; gboolean g_date_is_leap_year( GDateYear year);
(ff:bind-c-function g_date_is_leap_year
     :unconverted-entry-name "g_date_is_leap_year"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2253 <463> 
;; guint8 g_date_days_in_month( GDateMonth month, GDateYear year);
(ff:bind-c-function g_date_days_in_month
     :unconverted-entry-name "g_date_days_in_month"
     :c-return-type ("guint8")
     :return-type guint8
     :c-arg-types (("GDateMonth") ("GDateYear"))
     :c-arg-names (month year)
     :arguments (GDateMonth GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2255 <464> 
;; guint8 g_date_monday_weeks_in_year( GDateYear year);
(ff:bind-c-function g_date_monday_weeks_in_year
     :unconverted-entry-name "g_date_monday_weeks_in_year"
     :c-return-type ("guint8")
     :return-type guint8
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2256 <465> 
;; guint8 g_date_sunday_weeks_in_year( GDateYear year);
(ff:bind-c-function g_date_sunday_weeks_in_year
     :unconverted-entry-name "g_date_sunday_weeks_in_year"
     :c-return-type ("guint8")
     :return-type guint8
     :c-arg-types (("GDateYear"))
     :c-arg-names (year)
     :arguments (GDateYear)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2259 <466> 
;; gint g_date_compare( GDate* lhs, GDate* rhs);
(ff:bind-c-function g_date_compare
     :unconverted-entry-name "g_date_compare"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GDate" "*") ("GDate" "*"))
     :c-arg-names (lhs rhs)
     :arguments ((* GDate) (* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2261 <467> 
;; void g_date_to_struct_tm( GDate* date, struct tm* tm);
(ff:bind-c-function g_date_to_struct_tm
     :unconverted-entry-name "g_date_to_struct_tm"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GDate" "*") ("struct" "*"))
     :c-arg-names (date tm)
     :arguments ((* GDate) (* tm))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2267 <468> 
;; gsize g_date_strftime( gchar* s, gsize slen, const gchar* format, GDate
;;   * date);
(ff:bind-c-function g_date_strftime
     :unconverted-entry-name "g_date_strftime"
     :c-return-type ("gsize")
     :return-type gsize
     :c-arg-types (("gchar" "*") ("gsize") ("const" "gchar" "*") ("GDate" "*"))
     :c-arg-names (s slen format date)
     :arguments ((* gchar) gsize (* gchar) (* GDate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2296 <469> 
;; GRelation* g_relation_new( gint fields);
(ff:bind-c-function g_relation_new
     :unconverted-entry-name "g_relation_new"
     :c-return-type ("GRelation" "*")
     :return-type (* GRelation)
     :c-arg-types (("gint"))
     :c-arg-names (fields)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2297 <470> 
;; void g_relation_destroy( GRelation* relation);
(ff:bind-c-function g_relation_destroy
     :unconverted-entry-name "g_relation_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*"))
     :c-arg-names (relation)
     :arguments ((* GRelation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2298 <471> 
;; void g_relation_index( GRelation* relation, gint field, GHashFunc
;;   hash_func,
;;              GCompareFunc key_compare_func);
(ff:bind-c-function g_relation_index
     :unconverted-entry-name "g_relation_index"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*") ("gint") ("GHashFunc") ("GCompareFunc"))
     :c-arg-names (relation field hash_func key_compare_func)
     :arguments ((* GRelation) gint GHashFunc GCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2302 <472> 
;; void g_relation_insert( GRelation* relation, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_relation_insert
     :unconverted-entry-name "g_relation_insert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*") "...")
     :c-arg-names (relation)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2304 <473> 
;; gint g_relation_delete( GRelation* relation, gconstpointer key, gint
;;   field
;;   );
(ff:bind-c-function g_relation_delete
     :unconverted-entry-name "g_relation_delete"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GRelation" "*") ("gconstpointer") ("gint"))
     :c-arg-names (relation key field)
     :arguments ((* GRelation) gconstpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2307 <474> 
;; GTuples* g_relation_select( GRelation* relation, gconstpointer key, gint
;;    field);
(ff:bind-c-function g_relation_select
     :unconverted-entry-name "g_relation_select"
     :c-return-type ("GTuples" "*")
     :return-type (* GTuples)
     :c-arg-types (("GRelation" "*") ("gconstpointer") ("gint"))
     :c-arg-names (relation key field)
     :arguments ((* GRelation) gconstpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2310 <475> 
;; gint g_relation_count( GRelation* relation, gconstpointer key, gint
;;   field
;;   );
(ff:bind-c-function g_relation_count
     :unconverted-entry-name "g_relation_count"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GRelation" "*") ("gconstpointer") ("gint"))
     :c-arg-names (relation key field)
     :arguments ((* GRelation) gconstpointer gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2313 <476> 
;; gboolean g_relation_exists( GRelation* relation, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function g_relation_exists
     :unconverted-entry-name "g_relation_exists"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GRelation" "*") "...")
     :c-arg-names (relation)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2315 <477> 
;; void g_relation_print( GRelation* relation);
(ff:bind-c-function g_relation_print
     :unconverted-entry-name "g_relation_print"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GRelation" "*"))
     :c-arg-names (relation)
     :arguments ((* GRelation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2317 <478> 
;; void g_tuples_destroy( GTuples* tuples);
(ff:bind-c-function g_tuples_destroy
     :unconverted-entry-name "g_tuples_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTuples" "*"))
     :c-arg-names (tuples)
     :arguments ((* GTuples))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2318 <479> 
;; gpointer g_tuples_index( GTuples* tuples, gint index, gint field);
(ff:bind-c-function g_tuples_index
     :unconverted-entry-name "g_tuples_index"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GTuples" "*") ("gint") ("gint"))
     :c-arg-names (tuples index field)
     :arguments ((* GTuples) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2332 <480> 
;; guint g_spaced_primes_closest( guint num);
(ff:bind-c-function g_spaced_primes_closest
     :unconverted-entry-name "g_spaced_primes_closest"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint"))
     :c-arg-names (num)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2338 <481> 
;; typedef struct _GIOFuncs GIOFuncs;
(ff:bind-c-typedef _GIOFuncs ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GIOFuncs _GIOFuncs)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2339 <482> 
;; typedef enum {
;;         G_IO_ERROR_NONE, G_IO_ERROR_AGAIN, G_IO_ERROR_INVAL,
;;   G_IO_ERROR_UNKNOWN
;;    } GIOError;
(ff:bind-c-constant G_IO_ERROR_NONE 0) ;;  G_IO_ERROR_NONE 
(ff:bind-c-constant G_IO_ERROR_AGAIN 1) ;;  G_IO_ERROR_AGAIN 
(ff:bind-c-constant G_IO_ERROR_INVAL 2) ;;  G_IO_ERROR_INVAL 
(ff:bind-c-constant G_IO_ERROR_UNKNOWN 3) ;;  G_IO_ERROR_UNKNOWN 
(ff:bind-c-type GIOError :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2346 <483> 
;; typedef enum { G_SEEK_CUR, G_SEEK_SET, G_SEEK_END } GSeekType;
(ff:bind-c-constant G_SEEK_CUR 0) ;;  G_SEEK_CUR 
(ff:bind-c-constant G_SEEK_SET 1) ;;  G_SEEK_SET 
(ff:bind-c-constant G_SEEK_END 2) ;;  G_SEEK_END 
(ff:bind-c-type GSeekType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2352 <484> 
;; typedef enum {
;;         G_IO_IN =  0x000000001, G_IO_OUT =  0x000000004, G_IO_PRI =
;;   0x000000002,
;;              G_IO_ERR =  0x000000008, G_IO_HUP =  0x000000010, G_IO_NVAL
;;   =  0x000000020
;;    } GIOCondition;
(ff:bind-c-constant G_IO_IN 1) ;;  G_IO_IN =  0x000000001 
(ff:bind-c-constant G_IO_OUT 4) ;;  G_IO_OUT =  0x000000004 
(ff:bind-c-constant G_IO_PRI 2) ;;  G_IO_PRI =  0x000000002 
(ff:bind-c-constant G_IO_ERR 8) ;;  G_IO_ERR =  0x000000008 
(ff:bind-c-constant G_IO_HUP 16) ;;  G_IO_HUP =  0x000000010 
(ff:bind-c-constant G_IO_NVAL 32) ;;  G_IO_NVAL =  0x000000020 
(ff:bind-c-type GIOCondition :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2362 <485> 
;; struct _GIOChannel {
;;         guint channel_flags; guint ref_count; GIOFuncs* funcs; };
(ff:bind-c-type _GIOChannel (:struct
  (channel_flags guint)   ;; guint channel_flags
  (ref_count guint)   ;; guint ref_count
  (funcs (* GIOFuncs))   ;; GIOFuncs* funcs
  ))   ;; bind-c-type _GIOChannel

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2369 <486> 
;; typedef gboolean(* GIOFunc)( GIOChannel* source, GIOCondition condition,
;;              gpointer data);
(ff:bind-c-type GIOFunc (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2372 <487> 
;; struct _GIOFuncs {
;;         GIOError(* io_read)( GIOChannel* channel, gchar* buf, guint
;;   count, guint
;;   * bytes_read); GIOError(* io_write)( GIOChannel* channel, gchar* buf,
;;   guint
;;    count, guint* bytes_written); GIOError(* io_seek)( GIOChannel*
;;   channel,
;;              gint offset, GSeekType type); void(* io_close)( GIOChannel*
;;   channel);
;;              guint(* io_add_watch)( GIOChannel* channel, gint priority,
;;   GIOCondition
;;    condition, GIOFunc func, gpointer user_data, GDestroyNotify notify);
;;   void
;;   (* io_free)( GIOChannel* channel); };
(ff:bind-c-type _GIOFuncs (:struct
  (io_read ff:function-pointer)   ;;
  ;;  GIOError(* io_read)( GIOChannel* channel, gchar* buf, guint count, guint* bytes_read
  ;; )
  (io_write ff:function-pointer)   ;;
  ;;  GIOError(* io_write)( GIOChannel* channel, gchar* buf, guint count, guint* bytes_written
  ;; )
  (io_seek ff:function-pointer)   ;;
  ;;  GIOError(* io_seek)( GIOChannel* channel, gint offset, GSeekType type)
  (io_close ff:function-pointer)   ;;
  ;;  void(* io_close)( GIOChannel* channel)
  (io_add_watch ff:function-pointer)   ;;
  ;;  guint(* io_add_watch)( GIOChannel* channel, gint priority, GIOCondition condition,
  ;;            GIOFunc func, gpointer user_data, GDestroyNotify notify)
  (io_free ff:function-pointer)   ;; void(* io_free)( GIOChannel* channel)
  ))   ;; bind-c-type _GIOFuncs

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2395 <488> 
;; void g_io_channel_init( GIOChannel* channel);
(ff:bind-c-function g_io_channel_init
     :unconverted-entry-name "g_io_channel_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2396 <489> 
;; void g_io_channel_ref( GIOChannel* channel);
(ff:bind-c-function g_io_channel_ref
     :unconverted-entry-name "g_io_channel_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2397 <490> 
;; void g_io_channel_unref( GIOChannel* channel);
(ff:bind-c-function g_io_channel_unref
     :unconverted-entry-name "g_io_channel_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2398 <491> 
;; GIOError g_io_channel_read( GIOChannel* channel, gchar* buf, guint
;;   count,
;;              guint* bytes_read);
(ff:bind-c-function g_io_channel_read
     :unconverted-entry-name "g_io_channel_read"
     :c-return-type ("GIOError")
     :return-type GIOError
     :c-arg-types (("GIOChannel" "*") ("gchar" "*") ("guint") ("guint" "*"))
     :c-arg-names (channel buf count bytes_read)
     :arguments ((* GIOChannel) (* gchar) guint (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2402 <492> 
;; GIOError g_io_channel_write( GIOChannel* channel, gchar* buf, guint
;;   count,
;;              guint* bytes_written);
(ff:bind-c-function g_io_channel_write
     :unconverted-entry-name "g_io_channel_write"
     :c-return-type ("GIOError")
     :return-type GIOError
     :c-arg-types (("GIOChannel" "*") ("gchar" "*") ("guint") ("guint" "*"))
     :c-arg-names (channel buf count bytes_written)
     :arguments ((* GIOChannel) (* gchar) guint (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2406 <493> 
;; GIOError g_io_channel_seek( GIOChannel* channel, gint offset, GSeekType
;;    type);
(ff:bind-c-function g_io_channel_seek
     :unconverted-entry-name "g_io_channel_seek"
     :c-return-type ("GIOError")
     :return-type GIOError
     :c-arg-types (("GIOChannel" "*") ("gint") ("GSeekType"))
     :c-arg-names (channel offset type)
     :arguments ((* GIOChannel) gint GSeekType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2409 <494> 
;; void g_io_channel_close( GIOChannel* channel);
(ff:bind-c-function g_io_channel_close
     :unconverted-entry-name "g_io_channel_close"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2410 <495> 
;; guint g_io_add_watch_full( GIOChannel* channel, gint priority,
;;   GIOCondition
;;    condition, GIOFunc func, gpointer user_data, GDestroyNotify notify);
(ff:bind-c-function g_io_add_watch_full
     :unconverted-entry-name "g_io_add_watch_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GIOChannel" "*") ("gint") ("GIOCondition") ("GIOFunc")
                   ("gpointer") ("GDestroyNotify"))
     :c-arg-names (channel priority condition func user_data notify)
     :arguments ((* GIOChannel) gint GIOCondition GIOFunc gpointer
                 GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2416 <496> 
;; guint g_io_add_watch( GIOChannel* channel, GIOCondition condition,
;;   GIOFunc
;;    func, gpointer user_data);
(ff:bind-c-function g_io_add_watch
     :unconverted-entry-name "g_io_add_watch"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GIOChannel" "*") ("GIOCondition") ("GIOFunc")
                   ("gpointer"))
     :c-arg-names (channel condition func user_data)
     :arguments ((* GIOChannel) GIOCondition GIOFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2424 <497> 
;; typedef struct _GTimeVal GTimeVal;
(ff:bind-c-typedef _GTimeVal ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GTimeVal _GTimeVal)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2425 <498> 
;; typedef struct _GSourceFuncs GSourceFuncs;
(ff:bind-c-typedef _GSourceFuncs
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GSourceFuncs _GSourceFuncs)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2426 <499> 
;; typedef struct _GMainLoop GMainLoop;
(ff:bind-c-typedef _GMainLoop ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMainLoop _GMainLoop)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2428 <500> 
;; struct _GTimeVal { glong tv_sec; glong tv_usec; };
(ff:bind-c-type _GTimeVal (:struct
  (tv_sec glong)   ;; glong tv_sec
  (tv_usec glong)   ;; glong tv_usec
  ))   ;; bind-c-type _GTimeVal

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2433 <501> 
;; struct _GSourceFuncs {
;;         gboolean(* prepare)( gpointer source_data, GTimeVal*
;;   current_time, gint
;;   * timeout, gpointer user_data); gboolean(* check)( gpointer
;;   source_data,
;;              GTimeVal* current_time, gpointer user_data); gboolean(*
;;   dispatch)( gpointer
;;    source_data, GTimeVal* dispatch_time, gpointer user_data);
;;   GDestroyNotify
;;    destroy; };
(ff:bind-c-type _GSourceFuncs (:struct
  (prepare ff:function-pointer)   ;;
  ;;  gboolean(* prepare)( gpointer source_data, GTimeVal* current_time, gint* timeout,
  ;;            gpointer user_data)
  (check ff:function-pointer)   ;;
  ;;  gboolean(* check)( gpointer source_data, GTimeVal* current_time, gpointer user_data
  ;; )
  (dispatch ff:function-pointer)   ;;
  ;;  gboolean(* dispatch)( gpointer source_data, GTimeVal* dispatch_time, gpointer user_data
  ;; )
  (destroy GDestroyNotify)   ;; GDestroyNotify destroy
  ))   ;; bind-c-type _GSourceFuncs

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2456 <502> 
;; typedef gboolean(* GSourceFunc)( gpointer data);
(ff:bind-c-type GSourceFunc (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2459 <503> 
;; guint g_source_add( gint priority, gboolean can_recurse, GSourceFuncs
;;   * funcs, gpointer source_data, gpointer user_data, GDestroyNotify
;;   notify
;;   );
(ff:bind-c-function g_source_add
     :unconverted-entry-name "g_source_add"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gint") ("gboolean") ("GSourceFuncs" "*") ("gpointer")
                   ("gpointer") ("GDestroyNotify"))
     :c-arg-names (priority can_recurse funcs source_data user_data notify)
     :arguments (gint gboolean (* GSourceFuncs) gpointer gpointer
                 GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2465 <504> 
;; gboolean g_source_remove( guint tag);
(ff:bind-c-function g_source_remove
     :unconverted-entry-name "g_source_remove"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint"))
     :c-arg-names (tag)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2466 <505> 
;; gboolean g_source_remove_by_user_data( gpointer user_data);
(ff:bind-c-function g_source_remove_by_user_data
     :unconverted-entry-name "g_source_remove_by_user_data"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gpointer"))
     :c-arg-names (user_data)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2467 <506> 
;; gboolean g_source_remove_by_source_data( gpointer source_data);
(ff:bind-c-function g_source_remove_by_source_data
     :unconverted-entry-name "g_source_remove_by_source_data"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gpointer"))
     :c-arg-names (source_data)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2468 <507> 
;; gboolean g_source_remove_by_funcs_user_data( GSourceFuncs* funcs,
;;   gpointer
;;    user_data);
(ff:bind-c-function g_source_remove_by_funcs_user_data
     :unconverted-entry-name "g_source_remove_by_funcs_user_data"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GSourceFuncs" "*") ("gpointer"))
     :c-arg-names (funcs user_data)
     :arguments ((* GSourceFuncs) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2471 <508> 
;; void g_get_current_time( GTimeVal* result);
(ff:bind-c-function g_get_current_time
     :unconverted-entry-name "g_get_current_time"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GTimeVal" "*"))
     :c-arg-names (result)
     :arguments ((* GTimeVal))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2474 <509> 
;; GMainLoop* g_main_new( gboolean is_running);
(ff:bind-c-function g_main_new
     :unconverted-entry-name "g_main_new"
     :c-return-type ("GMainLoop" "*")
     :return-type (* GMainLoop)
     :c-arg-types (("gboolean"))
     :c-arg-names (is_running)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2475 <510> 
;; void g_main_run( GMainLoop* loop);
(ff:bind-c-function g_main_run
     :unconverted-entry-name "g_main_run"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2476 <511> 
;; void g_main_quit( GMainLoop* loop);
(ff:bind-c-function g_main_quit
     :unconverted-entry-name "g_main_quit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2477 <512> 
;; void g_main_destroy( GMainLoop* loop);
(ff:bind-c-function g_main_destroy
     :unconverted-entry-name "g_main_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2478 <513> 
;; gboolean g_main_is_running( GMainLoop* loop);
(ff:bind-c-function g_main_is_running
     :unconverted-entry-name "g_main_is_running"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GMainLoop" "*"))
     :c-arg-names (loop)
     :arguments ((* GMainLoop))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2483 <514> 
;; gboolean g_main_iteration( gboolean may_block);
(ff:bind-c-function g_main_iteration
     :unconverted-entry-name "g_main_iteration"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gboolean"))
     :c-arg-names (may_block)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2486 <515> 
;; gboolean g_main_pending( void);
(ff:bind-c-function g_main_pending
     :unconverted-entry-name "g_main_pending"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2489 <516> 
;; guint g_timeout_add_full( gint priority, guint interval, GSourceFunc
;;   function,
;;              gpointer data, GDestroyNotify notify);
(ff:bind-c-function g_timeout_add_full
     :unconverted-entry-name "g_timeout_add_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gint") ("guint") ("GSourceFunc") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (priority interval function data notify)
     :arguments (gint guint GSourceFunc gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2494 <517> 
;; guint g_timeout_add( guint interval, GSourceFunc function, gpointer data
;;   );
(ff:bind-c-function g_timeout_add
     :unconverted-entry-name "g_timeout_add"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint") ("GSourceFunc") ("gpointer"))
     :c-arg-names (interval function data)
     :arguments (guint GSourceFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2497 <518> 
;; guint g_idle_add( GSourceFunc function, gpointer data);
(ff:bind-c-function g_idle_add
     :unconverted-entry-name "g_idle_add"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GSourceFunc") ("gpointer"))
     :c-arg-names #'data
     :arguments (GSourceFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2499 <519> 
;; guint g_idle_add_full( gint priority, GSourceFunc function, gpointer
;;   data,
;;              GDestroyNotify destroy);
(ff:bind-c-function g_idle_add_full
     :unconverted-entry-name "g_idle_add_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gint") ("GSourceFunc") ("gpointer") ("GDestroyNotify"))
     :c-arg-names (priority function data destroy)
     :arguments (gint GSourceFunc gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2503 <520> 
;; gboolean g_idle_remove_by_data( gpointer data);
(ff:bind-c-function g_idle_remove_by_data
     :unconverted-entry-name "g_idle_remove_by_data"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gpointer"))
     :c-arg-names (data)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2529 <521> 
;; typedef struct _GPollFD GPollFD;
(ff:bind-c-typedef _GPollFD ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GPollFD _GPollFD)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2530 <522> 
;; typedef gint(* GPollFunc)( GPollFD* ufds, guint nfsd, gint timeout);
(ff:bind-c-type GPollFunc (* gint))  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2533 <523> 
;; struct _GPollFD { gint fd; gushort events; gushort revents; };
(ff:bind-c-type _GPollFD (:struct
  (fd gint)   ;; gint fd
  (events gushort)   ;; gushort events
  (revents gushort)   ;; gushort revents
  ))   ;; bind-c-type _GPollFD

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2540 <524> 
;; void g_main_add_poll( GPollFD* fd, gint priority);
(ff:bind-c-function g_main_add_poll
     :unconverted-entry-name "g_main_add_poll"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPollFD" "*") ("gint"))
     :c-arg-names (fd priority)
     :arguments ((* GPollFD) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2542 <525> 
;; void g_main_remove_poll( GPollFD* fd);
(ff:bind-c-function g_main_remove_poll
     :unconverted-entry-name "g_main_remove_poll"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPollFD" "*"))
     :c-arg-names (fd)
     :arguments ((* GPollFD))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2543 <526> 
;; void g_main_set_poll_func( GPollFunc func);
(ff:bind-c-function g_main_set_poll_func
     :unconverted-entry-name "g_main_set_poll_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GPollFunc"))
     :c-arg-names (func)
     :arguments (GPollFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2556 <527> 
;; GIOChannel* g_io_channel_unix_new( int fd);
(ff:bind-c-function g_io_channel_unix_new
     :unconverted-entry-name "g_io_channel_unix_new"
     :c-return-type ("GIOChannel" "*")
     :return-type (* GIOChannel)
     :c-arg-types (("int"))
     :c-arg-names (fd)
     :arguments (:int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2557 <528> 
;; gint g_io_channel_unix_get_fd( GIOChannel* channel);
(ff:bind-c-function g_io_channel_unix_get_fd
     :unconverted-entry-name "g_io_channel_unix_get_fd"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GIOChannel" "*"))
     :c-arg-names (channel)
     :arguments ((* GIOChannel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2677 <529> 
;; typedef struct _GMutex GMutex;
(ff:bind-c-typedef _GMutex ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GMutex _GMutex)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2678 <530> 
;; typedef struct _GCond GCond;
(ff:bind-c-typedef _GCond ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GCond _GCond)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2679 <531> 
;; typedef struct _GPrivate GPrivate;
(ff:bind-c-typedef _GPrivate ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GPrivate _GPrivate)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2680 <532> 
;; typedef struct _GStaticPrivate GStaticPrivate;
(ff:bind-c-typedef _GStaticPrivate
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GStaticPrivate _GStaticPrivate)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2681 <533> 
;; typedef struct _GThreadFunctions GThreadFunctions;
(ff:bind-c-typedef _GThreadFunctions
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GThreadFunctions _GThreadFunctions)  

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2682 <534> 
;; struct _GThreadFunctions {
;;         GMutex*(* mutex_new)( void); void(* mutex_lock)( GMutex* mutex);
;;   gboolean
;;   (* mutex_trylock)( GMutex* mutex); void(* mutex_unlock)( GMutex* mutex
;;   ); void(* mutex_free)( GMutex* mutex); GCond*(* cond_new)( void); void
;;   (* cond_signal)( GCond* cond); void(* cond_broadcast)( GCond* cond);
;;   void
;;   (* cond_wait)( GCond* cond, GMutex* mutex); gboolean(* cond_timed_wait
;;   )( GCond* cond, GMutex* mutex, GTimeVal* end_time); void(* cond_free)(
;;    GCond* cond); GPrivate*(* private_new)( GDestroyNotify destructor);
;;   gpointer
;;   (* private_get)( GPrivate* private_key); void(* private_set)( GPrivate
;;   * private_key, gpointer data); };
(ff:bind-c-type _GThreadFunctions (:struct
  (mutex_new ff:function-pointer)   ;; GMutex*(* mutex_new)( void)
  (mutex_lock ff:function-pointer)   ;; void(* mutex_lock)( GMutex* mutex)
  (mutex_trylock ff:function-pointer)   ;;
  ;;  gboolean(* mutex_trylock)( GMutex* mutex)
  (mutex_unlock ff:function-pointer)   ;;
  ;;  void(* mutex_unlock)( GMutex* mutex)
  (mutex_free ff:function-pointer)   ;; void(* mutex_free)( GMutex* mutex)
  (cond_new ff:function-pointer)   ;; GCond*(* cond_new)( void)
  (cond_signal ff:function-pointer)   ;; void(* cond_signal)( GCond* cond)
  (cond_broadcast ff:function-pointer)   ;;
  ;;  void(* cond_broadcast)( GCond* cond)
  (cond_wait ff:function-pointer)   ;;
  ;;  void(* cond_wait)( GCond* cond, GMutex* mutex)
  (cond_timed_wait ff:function-pointer)   ;;
  ;;  gboolean(* cond_timed_wait)( GCond* cond, GMutex* mutex, GTimeVal* end_time)
  (cond_free ff:function-pointer)   ;; void(* cond_free)( GCond* cond)
  (private_new ff:function-pointer)   ;;
  ;;  GPrivate*(* private_new)( GDestroyNotify destructor)
  (private_get ff:function-pointer)   ;;
  ;;  gpointer(* private_get)( GPrivate* private_key)
  (private_set ff:function-pointer)   ;;
  ;;  void(* private_set)( GPrivate* private_key, gpointer data)
  ))   ;; bind-c-type _GThreadFunctions

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2704 <535> 
;; extern GThreadFunctions g_thread_functions_for_glib_use;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_thread_functions_for_glib_use"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2705 <536> 
;; extern gboolean g_thread_use_default_impl;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_thread_use_default_impl"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2706 <537> 
;; extern gboolean g_threads_got_initialized;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "g_threads_got_initialized"))

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2712 <538> 
;; void g_thread_init( GThreadFunctions* vtable);
(ff:bind-c-function g_thread_init
     :unconverted-entry-name "g_thread_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GThreadFunctions" "*"))
     :c-arg-names (vtable)
     :arguments ((* GThreadFunctions))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2715 <539> 
;; GMutex* g_static_mutex_get_mutex_impl( GMutex** mutex);
(ff:bind-c-function g_static_mutex_get_mutex_impl
     :unconverted-entry-name "g_static_mutex_get_mutex_impl"
     :c-return-type ("GMutex" "*")
     :return-type (* GMutex)
     :c-arg-types (("GMutex" "*" "*"))
     :c-arg-names (mutex)
     :arguments ((* (* GMutex)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2760 <540> 
;; struct _GStaticPrivate { guint index; };
(ff:bind-c-type _GStaticPrivate (:struct
  (index guint)   ;; guint index
  ))   ;; bind-c-type _GStaticPrivate

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2765 <541> 
;; gpointer g_static_private_get( GStaticPrivate* private_key);
(ff:bind-c-function g_static_private_get
     :unconverted-entry-name "g_static_private_get"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GStaticPrivate" "*"))
     :c-arg-names (private_key)
     :arguments ((* GStaticPrivate))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2766 <542> 
;; void g_static_private_set( GStaticPrivate* private_key, gpointer data,
;;              GDestroyNotify notify);
(ff:bind-c-function g_static_private_set
     :unconverted-entry-name "g_static_private_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GStaticPrivate" "*") ("gpointer") ("GDestroyNotify"))
     :c-arg-names (private_key data notify)
     :arguments ((* GStaticPrivate) gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/glib-1.2/glib.h:2779 <543> 
;; extern void glib_dummy_decl( void);
(ff:bind-c-function glib_dummy_decl
     :unconverted-entry-name "glib_dummy_decl"
     :c-modifiers ("extern")
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:52 <544> 
;; typedef gulong GdkAtom;
(ff:bind-c-type GdkAtom gulong)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:53 <545> 
;; typedef struct _GdkColor GdkColor;
(ff:bind-c-typedef _GdkColor ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkColor _GdkColor)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:54 <546> 
;; typedef struct _GdkColormap GdkColormap;
(ff:bind-c-typedef _GdkColormap
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkColormap _GdkColormap)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:55 <547> 
;; typedef struct _GdkVisual GdkVisual;
(ff:bind-c-typedef _GdkVisual ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkVisual _GdkVisual)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:56 <548> 
;; typedef struct _GdkWindowAttr GdkWindowAttr;
(ff:bind-c-typedef _GdkWindowAttr
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkWindowAttr _GdkWindowAttr)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:57 <549> 
;; typedef struct _GdkWindow GdkWindow;
(ff:bind-c-typedef _GdkWindow ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkWindow _GdkWindow)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:58 <550> 
;; typedef struct _GdkWindow GdkPixmap;
(ff:bind-c-type GdkPixmap _GdkWindow)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:59 <551> 
;; typedef struct _GdkWindow GdkBitmap;
(ff:bind-c-type GdkBitmap _GdkWindow)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:60 <552> 
;; typedef struct _GdkWindow GdkDrawable;
(ff:bind-c-type GdkDrawable _GdkWindow)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:61 <553> 
;; typedef struct _GdkGeometry GdkGeometry;
(ff:bind-c-typedef _GdkGeometry
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkGeometry _GdkGeometry)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:62 <554> 
;; typedef struct _GdkImage GdkImage;
(ff:bind-c-typedef _GdkImage ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkImage _GdkImage)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:63 <555> 
;; typedef struct _GdkGCValues GdkGCValues;
(ff:bind-c-typedef _GdkGCValues
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkGCValues _GdkGCValues)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:64 <556> 
;; typedef struct _GdkGC GdkGC;
(ff:bind-c-typedef _GdkGC ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GdkGC _GdkGC)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:65 <557> 
;; typedef struct _GdkPoint GdkPoint;
(ff:bind-c-typedef _GdkPoint ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkPoint _GdkPoint)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:66 <558> 
;; typedef struct _GdkRectangle GdkRectangle;
(ff:bind-c-typedef _GdkRectangle
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkRectangle _GdkRectangle)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:67 <559> 
;; typedef struct _GdkSegment GdkSegment;
(ff:bind-c-typedef _GdkSegment
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkSegment _GdkSegment)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:68 <560> 
;; typedef struct _GdkFont GdkFont;
(ff:bind-c-typedef _GdkFont ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkFont _GdkFont)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:69 <561> 
;; typedef struct _GdkCursor GdkCursor;
(ff:bind-c-typedef _GdkCursor ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkCursor _GdkCursor)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:70 <562> 
;; typedef struct _GdkColorContextDither GdkColorContextDither;
(ff:bind-c-typedef _GdkColorContextDither
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkColorContextDither _GdkColorContextDither)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:71 <563> 
;; typedef struct _GdkColorContext GdkColorContext;
(ff:bind-c-typedef _GdkColorContext
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkColorContext _GdkColorContext)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:72 <564> 
;; typedef struct _GdkDragContext GdkDragContext;
(ff:bind-c-typedef _GdkDragContext
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkDragContext _GdkDragContext)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:74 <565> 
;; typedef struct _GdkEventAny GdkEventAny;
(ff:bind-c-typedef _GdkEventAny
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventAny _GdkEventAny)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:75 <566> 
;; typedef struct _GdkEventExpose GdkEventExpose;
(ff:bind-c-typedef _GdkEventExpose
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventExpose _GdkEventExpose)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:76 <567> 
;; typedef struct _GdkEventNoExpose GdkEventNoExpose;
(ff:bind-c-typedef _GdkEventNoExpose
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventNoExpose _GdkEventNoExpose)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:77 <568> 
;; typedef struct _GdkEventVisibility GdkEventVisibility;
(ff:bind-c-typedef _GdkEventVisibility
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventVisibility _GdkEventVisibility)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:78 <569> 
;; typedef struct _GdkEventMotion GdkEventMotion;
(ff:bind-c-typedef _GdkEventMotion
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventMotion _GdkEventMotion)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:79 <570> 
;; typedef struct _GdkEventButton GdkEventButton;
(ff:bind-c-typedef _GdkEventButton
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventButton _GdkEventButton)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:80 <571> 
;; typedef struct _GdkEventKey GdkEventKey;
(ff:bind-c-typedef _GdkEventKey
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventKey _GdkEventKey)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:81 <572> 
;; typedef struct _GdkEventFocus GdkEventFocus;
(ff:bind-c-typedef _GdkEventFocus
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventFocus _GdkEventFocus)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:82 <573> 
;; typedef struct _GdkEventCrossing GdkEventCrossing;
(ff:bind-c-typedef _GdkEventCrossing
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventCrossing _GdkEventCrossing)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:83 <574> 
;; typedef struct _GdkEventConfigure GdkEventConfigure;
(ff:bind-c-typedef _GdkEventConfigure
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventConfigure _GdkEventConfigure)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:84 <575> 
;; typedef struct _GdkEventProperty GdkEventProperty;
(ff:bind-c-typedef _GdkEventProperty
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventProperty _GdkEventProperty)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:85 <576> 
;; typedef struct _GdkEventSelection GdkEventSelection;
(ff:bind-c-typedef _GdkEventSelection
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventSelection _GdkEventSelection)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:86 <577> 
;; typedef struct _GdkEventProximity GdkEventProximity;
(ff:bind-c-typedef _GdkEventProximity
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventProximity _GdkEventProximity)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:87 <578> 
;; typedef struct _GdkEventClient GdkEventClient;
(ff:bind-c-typedef _GdkEventClient
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventClient _GdkEventClient)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:89 <579> 
;; typedef struct _GdkEventDND GdkEventDND;
(ff:bind-c-typedef _GdkEventDND
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEventDND _GdkEventDND)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:91 <580> 
;; typedef union _GdkEvent GdkEvent;
(ff:bind-c-typedef _GdkEvent ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkEvent _GdkEvent)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:93 <581> 
;; typedef struct _GdkDeviceKey GdkDeviceKey;
(ff:bind-c-typedef _GdkDeviceKey
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkDeviceKey _GdkDeviceKey)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:94 <582> 
;; typedef struct _GdkDeviceInfo GdkDeviceInfo;
(ff:bind-c-typedef _GdkDeviceInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkDeviceInfo _GdkDeviceInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:95 <583> 
;; typedef struct _GdkTimeCoord GdkTimeCoord;
(ff:bind-c-typedef _GdkTimeCoord
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkTimeCoord _GdkTimeCoord)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:96 <584> 
;; typedef struct _GdkRegion GdkRegion;
(ff:bind-c-typedef _GdkRegion ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkRegion _GdkRegion)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:97 <585> 
;; typedef void(* GdkEventFunc)( GdkEvent* event, gpointer data);
(ff:bind-c-type GdkEventFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:100 <586> 
;; typedef struct _GdkIC GdkIC;
(ff:bind-c-typedef _GdkIC ff:dummy-forward-struct) ;;  forward declaration 
(ff:bind-c-type GdkIC _GdkIC)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:101 <587> 
;; typedef struct _GdkICAttr GdkICAttr;
(ff:bind-c-typedef _GdkICAttr ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkICAttr _GdkICAttr)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:103 <588> 
;; typedef guint32 GdkWChar;
(ff:bind-c-type GdkWChar guint32)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:126 <589> 
;; typedef enum {
;;         GDK_WINDOW_ROOT, GDK_WINDOW_TOPLEVEL, GDK_WINDOW_CHILD,
;;   GDK_WINDOW_DIALOG,
;;              GDK_WINDOW_TEMP, GDK_WINDOW_PIXMAP, GDK_WINDOW_FOREIGN }
;;   GdkWindowType
;;   ;
(ff:bind-c-constant GDK_WINDOW_ROOT 0) ;;  GDK_WINDOW_ROOT 
(ff:bind-c-constant GDK_WINDOW_TOPLEVEL 1) ;;  GDK_WINDOW_TOPLEVEL 
(ff:bind-c-constant GDK_WINDOW_CHILD 2) ;;  GDK_WINDOW_CHILD 
(ff:bind-c-constant GDK_WINDOW_DIALOG 3) ;;  GDK_WINDOW_DIALOG 
(ff:bind-c-constant GDK_WINDOW_TEMP 4) ;;  GDK_WINDOW_TEMP 
(ff:bind-c-constant GDK_WINDOW_PIXMAP 5) ;;  GDK_WINDOW_PIXMAP 
(ff:bind-c-constant GDK_WINDOW_FOREIGN 6) ;;  GDK_WINDOW_FOREIGN 
(ff:bind-c-type GdkWindowType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:146 <590> 
;; typedef enum { GDK_INPUT_OUTPUT, GDK_INPUT_ONLY } GdkWindowClass;
(ff:bind-c-constant GDK_INPUT_OUTPUT 0) ;;  GDK_INPUT_OUTPUT 
(ff:bind-c-constant GDK_INPUT_ONLY 1) ;;  GDK_INPUT_ONLY 
(ff:bind-c-type GdkWindowClass :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:162 <591> 
;; typedef enum {
;;         GDK_IMAGE_NORMAL, GDK_IMAGE_SHARED, GDK_IMAGE_FASTEST }
;;   GdkImageType;
(ff:bind-c-constant GDK_IMAGE_NORMAL 0) ;;  GDK_IMAGE_NORMAL 
(ff:bind-c-constant GDK_IMAGE_SHARED 1) ;;  GDK_IMAGE_SHARED 
(ff:bind-c-constant GDK_IMAGE_FASTEST 2) ;;  GDK_IMAGE_FASTEST 
(ff:bind-c-type GdkImageType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:177 <592> 
;; typedef enum {
;;         GDK_VISUAL_STATIC_GRAY, GDK_VISUAL_GRAYSCALE,
;;   GDK_VISUAL_STATIC_COLOR,
;;              GDK_VISUAL_PSEUDO_COLOR, GDK_VISUAL_TRUE_COLOR,
;;   GDK_VISUAL_DIRECT_COLOR
;;    } GdkVisualType;
(ff:bind-c-constant GDK_VISUAL_STATIC_GRAY 0) ;;  GDK_VISUAL_STATIC_GRAY 
(ff:bind-c-constant GDK_VISUAL_GRAYSCALE 1) ;;  GDK_VISUAL_GRAYSCALE 
(ff:bind-c-constant GDK_VISUAL_STATIC_COLOR 2) ;;  GDK_VISUAL_STATIC_COLOR 
(ff:bind-c-constant GDK_VISUAL_PSEUDO_COLOR 3) ;;  GDK_VISUAL_PSEUDO_COLOR 
(ff:bind-c-constant GDK_VISUAL_TRUE_COLOR 4) ;;  GDK_VISUAL_TRUE_COLOR 
(ff:bind-c-constant GDK_VISUAL_DIRECT_COLOR 5) ;;  GDK_VISUAL_DIRECT_COLOR 
(ff:bind-c-type GdkVisualType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:191 <593> 
;; typedef enum { GDK_FONT_FONT, GDK_FONT_FONTSET } GdkFontType;
(ff:bind-c-constant GDK_FONT_FONT 0) ;;  GDK_FONT_FONT 
(ff:bind-c-constant GDK_FONT_FONTSET 1) ;;  GDK_FONT_FONTSET 
(ff:bind-c-type GdkFontType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:205 <594> 
;; typedef enum {
;;         GDK_WA_TITLE =  0x000000001 LSHIFT  0x000000001, GDK_WA_X =
;;   0x000000001
;;    LSHIFT  0x000000002, GDK_WA_Y =  0x000000001 LSHIFT  0x000000003,
;;   GDK_WA_CURSOR
;;    =  0x000000001 LSHIFT  0x000000004, GDK_WA_COLORMAP =  0x000000001
;;   LSHIFT
;;     0x000000005, GDK_WA_VISUAL =  0x000000001 LSHIFT  0x000000006,
;;   GDK_WA_WMCLASS
;;    =  0x000000001 LSHIFT  0x000000007, GDK_WA_NOREDIR =  0x000000001
;;   LSHIFT
;;     0x000000008 } GdkWindowAttributesType;
(ff:bind-c-constant GDK_WA_TITLE
                    2) ;;
;;   GDK_WA_TITLE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_WA_X
                    4) ;;
;;   GDK_WA_X =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_WA_Y
                    8) ;;
;;   GDK_WA_Y =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_WA_CURSOR
                    16) ;;
;;   GDK_WA_CURSOR =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_WA_COLORMAP
                    32) ;;
;;   GDK_WA_COLORMAP =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_WA_VISUAL
                    64) ;;
;;   GDK_WA_VISUAL =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GDK_WA_WMCLASS
                    128) ;;
;;   GDK_WA_WMCLASS =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GDK_WA_NOREDIR
                    256) ;;
;;   GDK_WA_NOREDIR =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-type GdkWindowAttributesType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:219 <595> 
;; typedef enum {
;;         GDK_HINT_POS =  0x000000001 LSHIFT  0x000000000,
;;   GDK_HINT_MIN_SIZE =  0x000000001
;;    LSHIFT  0x000000001, GDK_HINT_MAX_SIZE =  0x000000001 LSHIFT
;;   0x000000002,
;;              GDK_HINT_BASE_SIZE =  0x000000001 LSHIFT  0x000000003,
;;   GDK_HINT_ASPECT
;;    =  0x000000001 LSHIFT  0x000000004, GDK_HINT_RESIZE_INC =
;;   0x000000001
;;    LSHIFT  0x000000005 } GdkWindowHints;
(ff:bind-c-constant GDK_HINT_POS
                    1) ;;
;;   GDK_HINT_POS =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_HINT_MIN_SIZE
                    2) ;;
;;   GDK_HINT_MIN_SIZE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_HINT_MAX_SIZE
                    4) ;;
;;   GDK_HINT_MAX_SIZE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_HINT_BASE_SIZE
                    8) ;;
;;   GDK_HINT_BASE_SIZE =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_HINT_ASPECT
                    16) ;;
;;   GDK_HINT_ASPECT =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_HINT_RESIZE_INC
                    32) ;;
;;   GDK_HINT_RESIZE_INC =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-type GdkWindowHints :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:247 <596> 
;; typedef enum {
;;         GDK_COPY, GDK_INVERT, GDK_XOR, GDK_CLEAR, GDK_AND,
;;   GDK_AND_REVERSE, GDK_AND_INVERT,
;;              GDK_NOOP, GDK_OR, GDK_EQUIV, GDK_OR_REVERSE,
;;   GDK_COPY_INVERT, GDK_OR_INVERT,
;;              GDK_NAND, GDK_SET } GdkFunction;
(ff:bind-c-constant GDK_COPY 0) ;;  GDK_COPY 
(ff:bind-c-constant GDK_INVERT 1) ;;  GDK_INVERT 
(ff:bind-c-constant GDK_XOR 2) ;;  GDK_XOR 
(ff:bind-c-constant GDK_CLEAR 3) ;;  GDK_CLEAR 
(ff:bind-c-constant GDK_AND 4) ;;  GDK_AND 
(ff:bind-c-constant GDK_AND_REVERSE 5) ;;  GDK_AND_REVERSE 
(ff:bind-c-constant GDK_AND_INVERT 6) ;;  GDK_AND_INVERT 
(ff:bind-c-constant GDK_NOOP 7) ;;  GDK_NOOP 
(ff:bind-c-constant GDK_OR 8) ;;  GDK_OR 
(ff:bind-c-constant GDK_EQUIV 9) ;;  GDK_EQUIV 
(ff:bind-c-constant GDK_OR_REVERSE 10) ;;  GDK_OR_REVERSE 
(ff:bind-c-constant GDK_COPY_INVERT 11) ;;  GDK_COPY_INVERT 
(ff:bind-c-constant GDK_OR_INVERT 12) ;;  GDK_OR_INVERT 
(ff:bind-c-constant GDK_NAND 13) ;;  GDK_NAND 
(ff:bind-c-constant GDK_SET 14) ;;  GDK_SET 
(ff:bind-c-type GdkFunction :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:272 <597> 
;; typedef enum {
;;         GDK_SOLID, GDK_TILED, GDK_STIPPLED, GDK_OPAQUE_STIPPLED }
;;   GdkFill;
(ff:bind-c-constant GDK_SOLID 0) ;;  GDK_SOLID 
(ff:bind-c-constant GDK_TILED 1) ;;  GDK_TILED 
(ff:bind-c-constant GDK_STIPPLED 2) ;;  GDK_STIPPLED 
(ff:bind-c-constant GDK_OPAQUE_STIPPLED 3) ;;  GDK_OPAQUE_STIPPLED 
(ff:bind-c-type GdkFill :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:284 <598> 
;; typedef enum { GDK_EVEN_ODD_RULE, GDK_WINDING_RULE } GdkFillRule;
(ff:bind-c-constant GDK_EVEN_ODD_RULE 0) ;;  GDK_EVEN_ODD_RULE 
(ff:bind-c-constant GDK_WINDING_RULE 1) ;;  GDK_WINDING_RULE 
(ff:bind-c-type GdkFillRule :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:295 <599> 
;; typedef enum {
;;         GDK_LINE_SOLID, GDK_LINE_ON_OFF_DASH, GDK_LINE_DOUBLE_DASH }
;;   GdkLineStyle
;;   ;
(ff:bind-c-constant GDK_LINE_SOLID 0) ;;  GDK_LINE_SOLID 
(ff:bind-c-constant GDK_LINE_ON_OFF_DASH 1) ;;  GDK_LINE_ON_OFF_DASH 
(ff:bind-c-constant GDK_LINE_DOUBLE_DASH 2) ;;  GDK_LINE_DOUBLE_DASH 
(ff:bind-c-type GdkLineStyle :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:308 <600> 
;; typedef enum {
;;         GDK_CAP_NOT_LAST, GDK_CAP_BUTT, GDK_CAP_ROUND,
;;   GDK_CAP_PROJECTING } GdkCapStyle
;;   ;
(ff:bind-c-constant GDK_CAP_NOT_LAST 0) ;;  GDK_CAP_NOT_LAST 
(ff:bind-c-constant GDK_CAP_BUTT 1) ;;  GDK_CAP_BUTT 
(ff:bind-c-constant GDK_CAP_ROUND 2) ;;  GDK_CAP_ROUND 
(ff:bind-c-constant GDK_CAP_PROJECTING 3) ;;  GDK_CAP_PROJECTING 
(ff:bind-c-type GdkCapStyle :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:321 <601> 
;; typedef enum {
;;         GDK_JOIN_MITER, GDK_JOIN_ROUND, GDK_JOIN_BEVEL } GdkJoinStyle;
(ff:bind-c-constant GDK_JOIN_MITER 0) ;;  GDK_JOIN_MITER 
(ff:bind-c-constant GDK_JOIN_ROUND 1) ;;  GDK_JOIN_ROUND 
(ff:bind-c-constant GDK_JOIN_BEVEL 2) ;;  GDK_JOIN_BEVEL 
(ff:bind-c-type GdkJoinStyle :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:330 <602> 
;; typedef enum {
;;         GDK_NUM_GLYPHS =  0x00000009a, GDK_X_CURSOR =  0x000000000,
;;   GDK_ARROW
;;    =  0x000000002, GDK_BASED_ARROW_DOWN =  0x000000004,
;;   GDK_BASED_ARROW_UP
;;    =  0x000000006, GDK_BOAT =  0x000000008, GDK_BOGOSITY =  0x00000000a,
;;              GDK_BOTTOM_LEFT_CORNER =  0x00000000c,
;;   GDK_BOTTOM_RIGHT_CORNER =  0x00000000e,
;;              GDK_BOTTOM_SIDE =  0x000000010, GDK_BOTTOM_TEE =
;;   0x000000012, GDK_BOX_SPIRAL
;;    =  0x000000014, GDK_CENTER_PTR =  0x000000016, GDK_CIRCLE =
;;   0x000000018,
;;              GDK_CLOCK =  0x00000001a, GDK_COFFEE_MUG =  0x00000001c,
;;   GDK_CROSS =  0x00000001e,
;;              GDK_CROSS_REVERSE =  0x000000020, GDK_CROSSHAIR =
;;   0x000000022, GDK_DIAMOND_CROSS
;;    =  0x000000024, GDK_DOT =  0x000000026, GDK_DOTBOX =  0x000000028,
;;   GDK_DOUBLE_ARROW
;;    =  0x00000002a, GDK_DRAFT_LARGE =  0x00000002c, GDK_DRAFT_SMALL =
;;   0x00000002e,
;;              GDK_DRAPED_BOX =  0x000000030, GDK_EXCHANGE =  0x000000032,
;;   GDK_FLEUR
;;    =  0x000000034, GDK_GOBBLER =  0x000000036, GDK_GUMBY =  0x000000038,
;;              GDK_HAND1 =  0x00000003a, GDK_HAND2 =  0x00000003c,
;;   GDK_HEART =  0x00000003e,
;;              GDK_ICON =  0x000000040, GDK_IRON_CROSS =  0x000000042,
;;   GDK_LEFT_PTR =
;;     0x000000044, GDK_LEFT_SIDE =  0x000000046, GDK_LEFT_TEE =
;;   0x000000048,
;;              GDK_LEFTBUTTON =  0x00000004a, GDK_LL_ANGLE =  0x00000004c,
;;   GDK_LR_ANGLE
;;    =  0x00000004e, GDK_MAN =  0x000000050, GDK_MIDDLEBUTTON =
;;   0x000000052,
;;              GDK_MOUSE =  0x000000054, GDK_PENCIL =  0x000000056,
;;   GDK_PIRATE =  0x000000058,
;;              GDK_PLUS =  0x00000005a, GDK_QUESTION_ARROW =  0x00000005c,
;;   GDK_RIGHT_PTR
;;    =  0x00000005e, GDK_RIGHT_SIDE =  0x000000060, GDK_RIGHT_TEE =
;;   0x000000062,
;;              GDK_RIGHTBUTTON =  0x000000064, GDK_RTL_LOGO =
;;   0x000000066, GDK_SAILBOAT
;;    =  0x000000068, GDK_SB_DOWN_ARROW =  0x00000006a,
;;   GDK_SB_H_DOUBLE_ARROW
;;    =  0x00000006c, GDK_SB_LEFT_ARROW =  0x00000006e, GDK_SB_RIGHT_ARROW
;;   =
;;     0x000000070, GDK_SB_UP_ARROW =  0x000000072, GDK_SB_V_DOUBLE_ARROW =
;;     0x000000074, GDK_SHUTTLE =  0x000000076, GDK_SIZING =  0x000000078,
;;   GDK_SPIDER
;;    =  0x00000007a, GDK_SPRAYCAN =  0x00000007c, GDK_STAR =  0x00000007e,
;;              GDK_TARGET =  0x000000080, GDK_TCROSS =  0x000000082,
;;   GDK_TOP_LEFT_ARROW
;;    =  0x000000084, GDK_TOP_LEFT_CORNER =  0x000000086,
;;   GDK_TOP_RIGHT_CORNER
;;    =  0x000000088, GDK_TOP_SIDE =  0x00000008a, GDK_TOP_TEE =
;;   0x00000008c,
;;              GDK_TREK =  0x00000008e, GDK_UL_ANGLE =  0x000000090,
;;   GDK_UMBRELLA =  0x000000092,
;;              GDK_UR_ANGLE =  0x000000094, GDK_WATCH =  0x000000096,
;;   GDK_XTERM =  0x000000098,
;;              GDK_LAST_CURSOR, GDK_CURSOR_IS_PIXMAP = -  0x000000001 }
;;   GdkCursorType
;;   ;
(ff:bind-c-constant GDK_NUM_GLYPHS 154) ;;  GDK_NUM_GLYPHS =  0x00000009a 
(ff:bind-c-constant GDK_X_CURSOR 0) ;;  GDK_X_CURSOR =  0x000000000 
(ff:bind-c-constant GDK_ARROW 2) ;;  GDK_ARROW =  0x000000002 
(ff:bind-c-constant GDK_BASED_ARROW_DOWN
                    4) ;;
;;   GDK_BASED_ARROW_DOWN =  0x000000004 
(ff:bind-c-constant GDK_BASED_ARROW_UP
                    6) ;;
;;   GDK_BASED_ARROW_UP =  0x000000006 
(ff:bind-c-constant GDK_BOAT 8) ;;  GDK_BOAT =  0x000000008 
(ff:bind-c-constant GDK_BOGOSITY 10) ;;  GDK_BOGOSITY =  0x00000000a 
(ff:bind-c-constant GDK_BOTTOM_LEFT_CORNER
                    12) ;;
;;   GDK_BOTTOM_LEFT_CORNER =  0x00000000c 
(ff:bind-c-constant GDK_BOTTOM_RIGHT_CORNER
                    14) ;;
;;   GDK_BOTTOM_RIGHT_CORNER =  0x00000000e 
(ff:bind-c-constant GDK_BOTTOM_SIDE 16) ;;  GDK_BOTTOM_SIDE =  0x000000010 
(ff:bind-c-constant GDK_BOTTOM_TEE 18) ;;  GDK_BOTTOM_TEE =  0x000000012 
(ff:bind-c-constant GDK_BOX_SPIRAL 20) ;;  GDK_BOX_SPIRAL =  0x000000014 
(ff:bind-c-constant GDK_CENTER_PTR 22) ;;  GDK_CENTER_PTR =  0x000000016 
(ff:bind-c-constant GDK_CIRCLE 24) ;;  GDK_CIRCLE =  0x000000018 
(ff:bind-c-constant GDK_CLOCK 26) ;;  GDK_CLOCK =  0x00000001a 
(ff:bind-c-constant GDK_COFFEE_MUG 28) ;;  GDK_COFFEE_MUG =  0x00000001c 
(ff:bind-c-constant GDK_CROSS 30) ;;  GDK_CROSS =  0x00000001e 
(ff:bind-c-constant GDK_CROSS_REVERSE 32) ;;
;;   GDK_CROSS_REVERSE =  0x000000020 
(ff:bind-c-constant GDK_CROSSHAIR 34) ;;  GDK_CROSSHAIR =  0x000000022 
(ff:bind-c-constant GDK_DIAMOND_CROSS 36) ;;
;;   GDK_DIAMOND_CROSS =  0x000000024 
(ff:bind-c-constant GDK_DOT 38) ;;  GDK_DOT =  0x000000026 
(ff:bind-c-constant GDK_DOTBOX 40) ;;  GDK_DOTBOX =  0x000000028 
(ff:bind-c-constant GDK_DOUBLE_ARROW 42) ;;
;;   GDK_DOUBLE_ARROW =  0x00000002a 
(ff:bind-c-constant GDK_DRAFT_LARGE 44) ;;  GDK_DRAFT_LARGE =  0x00000002c 
(ff:bind-c-constant GDK_DRAFT_SMALL 46) ;;  GDK_DRAFT_SMALL =  0x00000002e 
(ff:bind-c-constant GDK_DRAPED_BOX 48) ;;  GDK_DRAPED_BOX =  0x000000030 
(ff:bind-c-constant GDK_EXCHANGE 50) ;;  GDK_EXCHANGE =  0x000000032 
(ff:bind-c-constant GDK_FLEUR 52) ;;  GDK_FLEUR =  0x000000034 
(ff:bind-c-constant GDK_GOBBLER 54) ;;  GDK_GOBBLER =  0x000000036 
(ff:bind-c-constant GDK_GUMBY 56) ;;  GDK_GUMBY =  0x000000038 
(ff:bind-c-constant GDK_HAND1 58) ;;  GDK_HAND1 =  0x00000003a 
(ff:bind-c-constant GDK_HAND2 60) ;;  GDK_HAND2 =  0x00000003c 
(ff:bind-c-constant GDK_HEART 62) ;;  GDK_HEART =  0x00000003e 
(ff:bind-c-constant GDK_ICON 64) ;;  GDK_ICON =  0x000000040 
(ff:bind-c-constant GDK_IRON_CROSS 66) ;;  GDK_IRON_CROSS =  0x000000042 
(ff:bind-c-constant GDK_LEFT_PTR 68) ;;  GDK_LEFT_PTR =  0x000000044 
(ff:bind-c-constant GDK_LEFT_SIDE 70) ;;  GDK_LEFT_SIDE =  0x000000046 
(ff:bind-c-constant GDK_LEFT_TEE 72) ;;  GDK_LEFT_TEE =  0x000000048 
(ff:bind-c-constant GDK_LEFTBUTTON 74) ;;  GDK_LEFTBUTTON =  0x00000004a 
(ff:bind-c-constant GDK_LL_ANGLE 76) ;;  GDK_LL_ANGLE =  0x00000004c 
(ff:bind-c-constant GDK_LR_ANGLE 78) ;;  GDK_LR_ANGLE =  0x00000004e 
(ff:bind-c-constant GDK_MAN 80) ;;  GDK_MAN =  0x000000050 
(ff:bind-c-constant GDK_MIDDLEBUTTON 82) ;;
;;   GDK_MIDDLEBUTTON =  0x000000052 
(ff:bind-c-constant GDK_MOUSE 84) ;;  GDK_MOUSE =  0x000000054 
(ff:bind-c-constant GDK_PENCIL 86) ;;  GDK_PENCIL =  0x000000056 
(ff:bind-c-constant GDK_PIRATE 88) ;;  GDK_PIRATE =  0x000000058 
(ff:bind-c-constant GDK_PLUS 90) ;;  GDK_PLUS =  0x00000005a 
(ff:bind-c-constant GDK_QUESTION_ARROW
                    92) ;;
;;   GDK_QUESTION_ARROW =  0x00000005c 
(ff:bind-c-constant GDK_RIGHT_PTR 94) ;;  GDK_RIGHT_PTR =  0x00000005e 
(ff:bind-c-constant GDK_RIGHT_SIDE 96) ;;  GDK_RIGHT_SIDE =  0x000000060 
(ff:bind-c-constant GDK_RIGHT_TEE 98) ;;  GDK_RIGHT_TEE =  0x000000062 
(ff:bind-c-constant GDK_RIGHTBUTTON 100) ;;
;;   GDK_RIGHTBUTTON =  0x000000064 
(ff:bind-c-constant GDK_RTL_LOGO 102) ;;  GDK_RTL_LOGO =  0x000000066 
(ff:bind-c-constant GDK_SAILBOAT 104) ;;  GDK_SAILBOAT =  0x000000068 
(ff:bind-c-constant GDK_SB_DOWN_ARROW
                    106) ;;
;;   GDK_SB_DOWN_ARROW =  0x00000006a 
(ff:bind-c-constant GDK_SB_H_DOUBLE_ARROW
                    108) ;;
;;   GDK_SB_H_DOUBLE_ARROW =  0x00000006c 
(ff:bind-c-constant GDK_SB_LEFT_ARROW
                    110) ;;
;;   GDK_SB_LEFT_ARROW =  0x00000006e 
(ff:bind-c-constant GDK_SB_RIGHT_ARROW
                    112) ;;
;;   GDK_SB_RIGHT_ARROW =  0x000000070 
(ff:bind-c-constant GDK_SB_UP_ARROW 114) ;;
;;   GDK_SB_UP_ARROW =  0x000000072 
(ff:bind-c-constant GDK_SB_V_DOUBLE_ARROW
                    116) ;;
;;   GDK_SB_V_DOUBLE_ARROW =  0x000000074 
(ff:bind-c-constant GDK_SHUTTLE 118) ;;  GDK_SHUTTLE =  0x000000076 
(ff:bind-c-constant GDK_SIZING 120) ;;  GDK_SIZING =  0x000000078 
(ff:bind-c-constant GDK_SPIDER 122) ;;  GDK_SPIDER =  0x00000007a 
(ff:bind-c-constant GDK_SPRAYCAN 124) ;;  GDK_SPRAYCAN =  0x00000007c 
(ff:bind-c-constant GDK_STAR 126) ;;  GDK_STAR =  0x00000007e 
(ff:bind-c-constant GDK_TARGET 128) ;;  GDK_TARGET =  0x000000080 
(ff:bind-c-constant GDK_TCROSS 130) ;;  GDK_TCROSS =  0x000000082 
(ff:bind-c-constant GDK_TOP_LEFT_ARROW
                    132) ;;
;;   GDK_TOP_LEFT_ARROW =  0x000000084 
(ff:bind-c-constant GDK_TOP_LEFT_CORNER
                    134) ;;
;;   GDK_TOP_LEFT_CORNER =  0x000000086 
(ff:bind-c-constant GDK_TOP_RIGHT_CORNER
                    136) ;;
;;   GDK_TOP_RIGHT_CORNER =  0x000000088 
(ff:bind-c-constant GDK_TOP_SIDE 138) ;;  GDK_TOP_SIDE =  0x00000008a 
(ff:bind-c-constant GDK_TOP_TEE 140) ;;  GDK_TOP_TEE =  0x00000008c 
(ff:bind-c-constant GDK_TREK 142) ;;  GDK_TREK =  0x00000008e 
(ff:bind-c-constant GDK_UL_ANGLE 144) ;;  GDK_UL_ANGLE =  0x000000090 
(ff:bind-c-constant GDK_UMBRELLA 146) ;;  GDK_UMBRELLA =  0x000000092 
(ff:bind-c-constant GDK_UR_ANGLE 148) ;;  GDK_UR_ANGLE =  0x000000094 
(ff:bind-c-constant GDK_WATCH 150) ;;  GDK_WATCH =  0x000000096 
(ff:bind-c-constant GDK_XTERM 152) ;;  GDK_XTERM =  0x000000098 
(ff:bind-c-constant GDK_LAST_CURSOR 0) ;;  GDK_LAST_CURSOR 
(ff:bind-c-constant GDK_CURSOR_IS_PIXMAP
                    -1) ;;
;;   GDK_CURSOR_IS_PIXMAP = -  0x000000001 
(ff:bind-c-type GdkCursorType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:337 <603> 
;; typedef enum {
;;         GDK_FILTER_CONTINUE, GDK_FILTER_TRANSLATE, GDK_FILTER_REMOVE }
;;   GdkFilterReturn
;;   ;
(ff:bind-c-constant GDK_FILTER_CONTINUE 0) ;;  GDK_FILTER_CONTINUE 
(ff:bind-c-constant GDK_FILTER_TRANSLATE 1) ;;  GDK_FILTER_TRANSLATE 
(ff:bind-c-constant GDK_FILTER_REMOVE 2) ;;  GDK_FILTER_REMOVE 
(ff:bind-c-type GdkFilterReturn :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:343 <604> 
;; typedef enum {
;;         GDK_VISIBILITY_UNOBSCURED, GDK_VISIBILITY_PARTIAL,
;;   GDK_VISIBILITY_FULLY_OBSCURED
;;    } GdkVisibilityState;
(ff:bind-c-constant GDK_VISIBILITY_UNOBSCURED 0) ;;
;;   GDK_VISIBILITY_UNOBSCURED 
(ff:bind-c-constant GDK_VISIBILITY_PARTIAL 1) ;;  GDK_VISIBILITY_PARTIAL 
(ff:bind-c-constant GDK_VISIBILITY_FULLY_OBSCURED
                    2) ;;
;;   GDK_VISIBILITY_FULLY_OBSCURED 
(ff:bind-c-type GdkVisibilityState :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:371 <605> 
;; typedef enum {
;;         GDK_NOTHING = -  0x000000001, GDK_DELETE =  0x000000000,
;;   GDK_DESTROY =
;;     0x000000001, GDK_EXPOSE =  0x000000002, GDK_MOTION_NOTIFY =
;;   0x000000003,
;;              GDK_BUTTON_PRESS =  0x000000004, GDK_2BUTTON_PRESS =
;;   0x000000005, GDK_3BUTTON_PRESS
;;    =  0x000000006, GDK_BUTTON_RELEASE =  0x000000007, GDK_KEY_PRESS =
;;   0x000000008,
;;              GDK_KEY_RELEASE =  0x000000009, GDK_ENTER_NOTIFY =
;;   0x00000000a, GDK_LEAVE_NOTIFY
;;    =  0x00000000b, GDK_FOCUS_CHANGE =  0x00000000c, GDK_CONFIGURE =
;;   0x00000000d,
;;              GDK_MAP =  0x00000000e, GDK_UNMAP =  0x00000000f,
;;   GDK_PROPERTY_NOTIFY
;;    =  0x000000010, GDK_SELECTION_CLEAR =  0x000000011,
;;   GDK_SELECTION_REQUEST
;;    =  0x000000012, GDK_SELECTION_NOTIFY =  0x000000013, GDK_PROXIMITY_IN
;;    =  0x000000014, GDK_PROXIMITY_OUT =  0x000000015, GDK_DRAG_ENTER =
;;   0x000000016,
;;              GDK_DRAG_LEAVE =  0x000000017, GDK_DRAG_MOTION =
;;   0x000000018, GDK_DRAG_STATUS
;;    =  0x000000019, GDK_DROP_START =  0x00000001a, GDK_DROP_FINISHED =
;;   0x00000001b,
;;              GDK_CLIENT_EVENT =  0x00000001c, GDK_VISIBILITY_NOTIFY =
;;   0x00000001d,
;;              GDK_NO_EXPOSE =  0x00000001e } GdkEventType;
(ff:bind-c-constant GDK_NOTHING -1) ;;  GDK_NOTHING = -  0x000000001 
(ff:bind-c-constant GDK_DELETE 0) ;;  GDK_DELETE =  0x000000000 
(ff:bind-c-constant GDK_DESTROY 1) ;;  GDK_DESTROY =  0x000000001 
(ff:bind-c-constant GDK_EXPOSE 2) ;;  GDK_EXPOSE =  0x000000002 
(ff:bind-c-constant GDK_MOTION_NOTIFY 3) ;;
;;   GDK_MOTION_NOTIFY =  0x000000003 
(ff:bind-c-constant GDK_BUTTON_PRESS 4) ;;
;;   GDK_BUTTON_PRESS =  0x000000004 
(ff:bind-c-constant GDK_2BUTTON_PRESS 5) ;;
;;   GDK_2BUTTON_PRESS =  0x000000005 
(ff:bind-c-constant GDK_3BUTTON_PRESS 6) ;;
;;   GDK_3BUTTON_PRESS =  0x000000006 
(ff:bind-c-constant GDK_BUTTON_RELEASE
                    7) ;;
;;   GDK_BUTTON_RELEASE =  0x000000007 
(ff:bind-c-constant GDK_KEY_PRESS 8) ;;  GDK_KEY_PRESS =  0x000000008 
(ff:bind-c-constant GDK_KEY_RELEASE 9) ;;  GDK_KEY_RELEASE =  0x000000009 
(ff:bind-c-constant GDK_ENTER_NOTIFY 10) ;;
;;   GDK_ENTER_NOTIFY =  0x00000000a 
(ff:bind-c-constant GDK_LEAVE_NOTIFY 11) ;;
;;   GDK_LEAVE_NOTIFY =  0x00000000b 
(ff:bind-c-constant GDK_FOCUS_CHANGE 12) ;;
;;   GDK_FOCUS_CHANGE =  0x00000000c 
(ff:bind-c-constant GDK_CONFIGURE 13) ;;  GDK_CONFIGURE =  0x00000000d 
(ff:bind-c-constant GDK_MAP 14) ;;  GDK_MAP =  0x00000000e 
(ff:bind-c-constant GDK_UNMAP 15) ;;  GDK_UNMAP =  0x00000000f 
(ff:bind-c-constant GDK_PROPERTY_NOTIFY
                    16) ;;
;;   GDK_PROPERTY_NOTIFY =  0x000000010 
(ff:bind-c-constant GDK_SELECTION_CLEAR
                    17) ;;
;;   GDK_SELECTION_CLEAR =  0x000000011 
(ff:bind-c-constant GDK_SELECTION_REQUEST
                    18) ;;
;;   GDK_SELECTION_REQUEST =  0x000000012 
(ff:bind-c-constant GDK_SELECTION_NOTIFY
                    19) ;;
;;   GDK_SELECTION_NOTIFY =  0x000000013 
(ff:bind-c-constant GDK_PROXIMITY_IN 20) ;;
;;   GDK_PROXIMITY_IN =  0x000000014 
(ff:bind-c-constant GDK_PROXIMITY_OUT 21) ;;
;;   GDK_PROXIMITY_OUT =  0x000000015 
(ff:bind-c-constant GDK_DRAG_ENTER 22) ;;  GDK_DRAG_ENTER =  0x000000016 
(ff:bind-c-constant GDK_DRAG_LEAVE 23) ;;  GDK_DRAG_LEAVE =  0x000000017 
(ff:bind-c-constant GDK_DRAG_MOTION 24) ;;  GDK_DRAG_MOTION =  0x000000018 
(ff:bind-c-constant GDK_DRAG_STATUS 25) ;;  GDK_DRAG_STATUS =  0x000000019 
(ff:bind-c-constant GDK_DROP_START 26) ;;  GDK_DROP_START =  0x00000001a 
(ff:bind-c-constant GDK_DROP_FINISHED 27) ;;
;;   GDK_DROP_FINISHED =  0x00000001b 
(ff:bind-c-constant GDK_CLIENT_EVENT 28) ;;
;;   GDK_CLIENT_EVENT =  0x00000001c 
(ff:bind-c-constant GDK_VISIBILITY_NOTIFY
                    29) ;;
;;   GDK_VISIBILITY_NOTIFY =  0x00000001d 
(ff:bind-c-constant GDK_NO_EXPOSE 30) ;;  GDK_NO_EXPOSE =  0x00000001e 
(ff:bind-c-type GdkEventType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:410 <606> 
;; typedef enum {
;;         GDK_EXPOSURE_MASK =  0x000000001 LSHIFT  0x000000001,
;;   GDK_POINTER_MOTION_MASK
;;    =  0x000000001 LSHIFT  0x000000002, GDK_POINTER_MOTION_HINT_MASK =
;;   0x000000001
;;    LSHIFT  0x000000003, GDK_BUTTON_MOTION_MASK =  0x000000001 LSHIFT
;;   0x000000004,
;;              GDK_BUTTON1_MOTION_MASK =  0x000000001 LSHIFT  0x000000005,
;;   GDK_BUTTON2_MOTION_MASK
;;    =  0x000000001 LSHIFT  0x000000006, GDK_BUTTON3_MOTION_MASK =
;;   0x000000001
;;    LSHIFT  0x000000007, GDK_BUTTON_PRESS_MASK =  0x000000001 LSHIFT
;;   0x000000008,
;;              GDK_BUTTON_RELEASE_MASK =  0x000000001 LSHIFT  0x000000009,
;;   GDK_KEY_PRESS_MASK
;;    =  0x000000001 LSHIFT  0x00000000a, GDK_KEY_RELEASE_MASK =
;;   0x000000001
;;    LSHIFT  0x00000000b, GDK_ENTER_NOTIFY_MASK =  0x000000001 LSHIFT
;;   0x00000000c,
;;              GDK_LEAVE_NOTIFY_MASK =  0x000000001 LSHIFT  0x00000000d,
;;   GDK_FOCUS_CHANGE_MASK
;;    =  0x000000001 LSHIFT  0x00000000e, GDK_STRUCTURE_MASK =  0x000000001
;;    LSHIFT  0x00000000f, GDK_PROPERTY_CHANGE_MASK =  0x000000001 LSHIFT
;;   0x000000010,
;;              GDK_VISIBILITY_NOTIFY_MASK =  0x000000001 LSHIFT
;;   0x000000011, GDK_PROXIMITY_IN_MASK
;;    =  0x000000001 LSHIFT  0x000000012, GDK_PROXIMITY_OUT_MASK =
;;   0x000000001
;;    LSHIFT  0x000000013, GDK_SUBSTRUCTURE_MASK =  0x000000001 LSHIFT
;;   0x000000014,
;;              GDK_ALL_EVENTS_MASK =  0x0000fffff } GdkEventMask;
(ff:bind-c-constant GDK_EXPOSURE_MASK
                    2) ;;
;;   GDK_EXPOSURE_MASK =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_POINTER_MOTION_MASK
                    4) ;;
;;   GDK_POINTER_MOTION_MASK =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_POINTER_MOTION_HINT_MASK
                    8) ;;
;;   GDK_POINTER_MOTION_HINT_MASK =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_BUTTON_MOTION_MASK
                    16) ;;
;;   GDK_BUTTON_MOTION_MASK =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_BUTTON1_MOTION_MASK
                    32) ;;
;;   GDK_BUTTON1_MOTION_MASK =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_BUTTON2_MOTION_MASK
                    64) ;;
;;   GDK_BUTTON2_MOTION_MASK =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GDK_BUTTON3_MOTION_MASK
                    128) ;;
;;   GDK_BUTTON3_MOTION_MASK =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GDK_BUTTON_PRESS_MASK
                    256) ;;
;;   GDK_BUTTON_PRESS_MASK =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant GDK_BUTTON_RELEASE_MASK
                    512) ;;
;;   GDK_BUTTON_RELEASE_MASK =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant GDK_KEY_PRESS_MASK
                    1024) ;;
;;   GDK_KEY_PRESS_MASK =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-constant GDK_KEY_RELEASE_MASK
                    2048) ;;
;;   GDK_KEY_RELEASE_MASK =  0x000000001 LSHIFT  0x00000000b 
(ff:bind-c-constant GDK_ENTER_NOTIFY_MASK
                    4096) ;;
;;   GDK_ENTER_NOTIFY_MASK =  0x000000001 LSHIFT  0x00000000c 
(ff:bind-c-constant GDK_LEAVE_NOTIFY_MASK
                    8192) ;;
;;   GDK_LEAVE_NOTIFY_MASK =  0x000000001 LSHIFT  0x00000000d 
(ff:bind-c-constant GDK_FOCUS_CHANGE_MASK
                    16384) ;;
;;   GDK_FOCUS_CHANGE_MASK =  0x000000001 LSHIFT  0x00000000e 
(ff:bind-c-constant GDK_STRUCTURE_MASK
                    32768) ;;
;;   GDK_STRUCTURE_MASK =  0x000000001 LSHIFT  0x00000000f 
(ff:bind-c-constant GDK_PROPERTY_CHANGE_MASK
                    65536) ;;
;;   GDK_PROPERTY_CHANGE_MASK =  0x000000001 LSHIFT  0x000000010 
(ff:bind-c-constant GDK_VISIBILITY_NOTIFY_MASK
                    131072) ;;
;;   GDK_VISIBILITY_NOTIFY_MASK =  0x000000001 LSHIFT  0x000000011 
(ff:bind-c-constant GDK_PROXIMITY_IN_MASK
                    262144) ;;
;;   GDK_PROXIMITY_IN_MASK =  0x000000001 LSHIFT  0x000000012 
(ff:bind-c-constant GDK_PROXIMITY_OUT_MASK
                    524288) ;;
;;   GDK_PROXIMITY_OUT_MASK =  0x000000001 LSHIFT  0x000000013 
(ff:bind-c-constant GDK_SUBSTRUCTURE_MASK
                    1048576) ;;
;;   GDK_SUBSTRUCTURE_MASK =  0x000000001 LSHIFT  0x000000014 
(ff:bind-c-constant GDK_ALL_EVENTS_MASK
                    1048575) ;;
;;   GDK_ALL_EVENTS_MASK =  0x0000fffff 
(ff:bind-c-type GdkEventMask :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:443 <607> 
;; typedef enum {
;;         GDK_NOTIFY_ANCESTOR =  0x000000000, GDK_NOTIFY_VIRTUAL =
;;   0x000000001,
;;              GDK_NOTIFY_INFERIOR =  0x000000002, GDK_NOTIFY_NONLINEAR =
;;   0x000000003,
;;              GDK_NOTIFY_NONLINEAR_VIRTUAL =  0x000000004,
;;   GDK_NOTIFY_UNKNOWN =  0x000000005
;;    } GdkNotifyType;
(ff:bind-c-constant GDK_NOTIFY_ANCESTOR
                    0) ;;
;;   GDK_NOTIFY_ANCESTOR =  0x000000000 
(ff:bind-c-constant GDK_NOTIFY_VIRTUAL
                    1) ;;
;;   GDK_NOTIFY_VIRTUAL =  0x000000001 
(ff:bind-c-constant GDK_NOTIFY_INFERIOR
                    2) ;;
;;   GDK_NOTIFY_INFERIOR =  0x000000002 
(ff:bind-c-constant GDK_NOTIFY_NONLINEAR
                    3) ;;
;;   GDK_NOTIFY_NONLINEAR =  0x000000003 
(ff:bind-c-constant GDK_NOTIFY_NONLINEAR_VIRTUAL
                    4) ;;
;;   GDK_NOTIFY_NONLINEAR_VIRTUAL =  0x000000004 
(ff:bind-c-constant GDK_NOTIFY_UNKNOWN
                    5) ;;
;;   GDK_NOTIFY_UNKNOWN =  0x000000005 
(ff:bind-c-type GdkNotifyType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:458 <608> 
;; typedef enum {
;;         GDK_CROSSING_NORMAL, GDK_CROSSING_GRAB, GDK_CROSSING_UNGRAB }
;;   GdkCrossingMode
;;   ;
(ff:bind-c-constant GDK_CROSSING_NORMAL 0) ;;  GDK_CROSSING_NORMAL 
(ff:bind-c-constant GDK_CROSSING_GRAB 1) ;;  GDK_CROSSING_GRAB 
(ff:bind-c-constant GDK_CROSSING_UNGRAB 2) ;;  GDK_CROSSING_UNGRAB 
(ff:bind-c-type GdkCrossingMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:467 <609> 
;; typedef enum {
;;         GDK_SHIFT_MASK =  0x000000001 LSHIFT  0x000000000, GDK_LOCK_MASK
;;   =  0x000000001
;;    LSHIFT  0x000000001, GDK_CONTROL_MASK =  0x000000001 LSHIFT
;;   0x000000002,
;;              GDK_MOD1_MASK =  0x000000001 LSHIFT  0x000000003,
;;   GDK_MOD2_MASK =  0x000000001
;;    LSHIFT  0x000000004, GDK_MOD3_MASK =  0x000000001 LSHIFT
;;   0x000000005,
;;              GDK_MOD4_MASK =  0x000000001 LSHIFT  0x000000006,
;;   GDK_MOD5_MASK =  0x000000001
;;    LSHIFT  0x000000007, GDK_BUTTON1_MASK =  0x000000001 LSHIFT
;;   0x000000008,
;;              GDK_BUTTON2_MASK =  0x000000001 LSHIFT  0x000000009,
;;   GDK_BUTTON3_MASK
;;    =  0x000000001 LSHIFT  0x00000000a, GDK_BUTTON4_MASK =  0x000000001
;;   LSHIFT
;;     0x00000000b, GDK_BUTTON5_MASK =  0x000000001 LSHIFT  0x00000000c,
;;   GDK_RELEASE_MASK
;;    =  0x000000001 LSHIFT  0x00000000d, GDK_MODIFIER_MASK =  0x000003fff
;;   }
;;    GdkModifierType;
(ff:bind-c-constant GDK_SHIFT_MASK
                    1) ;;
;;   GDK_SHIFT_MASK =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_LOCK_MASK
                    2) ;;
;;   GDK_LOCK_MASK =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_CONTROL_MASK
                    4) ;;
;;   GDK_CONTROL_MASK =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_MOD1_MASK
                    8) ;;
;;   GDK_MOD1_MASK =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_MOD2_MASK
                    16) ;;
;;   GDK_MOD2_MASK =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_MOD3_MASK
                    32) ;;
;;   GDK_MOD3_MASK =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_MOD4_MASK
                    64) ;;
;;   GDK_MOD4_MASK =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GDK_MOD5_MASK
                    128) ;;
;;   GDK_MOD5_MASK =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GDK_BUTTON1_MASK
                    256) ;;
;;   GDK_BUTTON1_MASK =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant GDK_BUTTON2_MASK
                    512) ;;
;;   GDK_BUTTON2_MASK =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant GDK_BUTTON3_MASK
                    1024) ;;
;;   GDK_BUTTON3_MASK =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-constant GDK_BUTTON4_MASK
                    2048) ;;
;;   GDK_BUTTON4_MASK =  0x000000001 LSHIFT  0x00000000b 
(ff:bind-c-constant GDK_BUTTON5_MASK
                    4096) ;;
;;   GDK_BUTTON5_MASK =  0x000000001 LSHIFT  0x00000000c 
(ff:bind-c-constant GDK_RELEASE_MASK
                    8192) ;;
;;   GDK_RELEASE_MASK =  0x000000001 LSHIFT  0x00000000d 
(ff:bind-c-constant GDK_MODIFIER_MASK
                    16383) ;;
;;   GDK_MODIFIER_MASK =  0x000003fff 
(ff:bind-c-type GdkModifierType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:486 <610> 
;; typedef enum {
;;         GDK_CLIP_BY_CHILDREN =  0x000000000, GDK_INCLUDE_INFERIORS =
;;   0x000000001
;;    } GdkSubwindowMode;
(ff:bind-c-constant GDK_CLIP_BY_CHILDREN
                    0) ;;
;;   GDK_CLIP_BY_CHILDREN =  0x000000000 
(ff:bind-c-constant GDK_INCLUDE_INFERIORS
                    1) ;;
;;   GDK_INCLUDE_INFERIORS =  0x000000001 
(ff:bind-c-type GdkSubwindowMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:492 <611> 
;; typedef enum {
;;         GDK_INPUT_READ =  0x000000001 LSHIFT  0x000000000,
;;   GDK_INPUT_WRITE =  0x000000001
;;    LSHIFT  0x000000001, GDK_INPUT_EXCEPTION =  0x000000001 LSHIFT
;;   0x000000002
;;    } GdkInputCondition;
(ff:bind-c-constant GDK_INPUT_READ
                    1) ;;
;;   GDK_INPUT_READ =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_INPUT_WRITE
                    2) ;;
;;   GDK_INPUT_WRITE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_INPUT_EXCEPTION
                    4) ;;
;;   GDK_INPUT_EXCEPTION =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-type GdkInputCondition :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:499 <612> 
;; typedef enum {
;;         GDK_OK =  0x000000000, GDK_ERROR = -  0x000000001,
;;   GDK_ERROR_PARAM = -
;;     0x000000002, GDK_ERROR_FILE = -  0x000000003, GDK_ERROR_MEM = -
;;   0x000000004
;;    } GdkStatus;
(ff:bind-c-constant GDK_OK 0) ;;  GDK_OK =  0x000000000 
(ff:bind-c-constant GDK_ERROR -1) ;;  GDK_ERROR = -  0x000000001 
(ff:bind-c-constant GDK_ERROR_PARAM -2) ;;
;;   GDK_ERROR_PARAM = -  0x000000002 
(ff:bind-c-constant GDK_ERROR_FILE -3) ;;  GDK_ERROR_FILE = -  0x000000003 
(ff:bind-c-constant GDK_ERROR_MEM -4) ;;  GDK_ERROR_MEM = -  0x000000004 
(ff:bind-c-type GdkStatus :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:508 <613> 
;; typedef enum { GDK_LSB_FIRST, GDK_MSB_FIRST } GdkByteOrder;
(ff:bind-c-constant GDK_LSB_FIRST 0) ;;  GDK_LSB_FIRST 
(ff:bind-c-constant GDK_MSB_FIRST 1) ;;  GDK_MSB_FIRST 
(ff:bind-c-type GdkByteOrder :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:514 <614> 
;; typedef enum {
;;         GDK_GC_FOREGROUND =  0x000000001 LSHIFT  0x000000000,
;;   GDK_GC_BACKGROUND
;;    =  0x000000001 LSHIFT  0x000000001, GDK_GC_FONT =  0x000000001 LSHIFT
;;     0x000000002, GDK_GC_FUNCTION =  0x000000001 LSHIFT  0x000000003,
;;   GDK_GC_FILL
;;    =  0x000000001 LSHIFT  0x000000004, GDK_GC_TILE =  0x000000001 LSHIFT
;;     0x000000005, GDK_GC_STIPPLE =  0x000000001 LSHIFT  0x000000006,
;;   GDK_GC_CLIP_MASK
;;    =  0x000000001 LSHIFT  0x000000007, GDK_GC_SUBWINDOW =  0x000000001
;;   LSHIFT
;;     0x000000008, GDK_GC_TS_X_ORIGIN =  0x000000001 LSHIFT  0x000000009,
;;   GDK_GC_TS_Y_ORIGIN
;;    =  0x000000001 LSHIFT  0x00000000a, GDK_GC_CLIP_X_ORIGIN =
;;   0x000000001
;;    LSHIFT  0x00000000b, GDK_GC_CLIP_Y_ORIGIN =  0x000000001 LSHIFT
;;   0x00000000c,
;;              GDK_GC_EXPOSURES =  0x000000001 LSHIFT  0x00000000d,
;;   GDK_GC_LINE_WIDTH
;;    =  0x000000001 LSHIFT  0x00000000e, GDK_GC_LINE_STYLE =  0x000000001
;;   LSHIFT
;;     0x00000000f, GDK_GC_CAP_STYLE =  0x000000001 LSHIFT  0x000000010,
;;   GDK_GC_JOIN_STYLE
;;    =  0x000000001 LSHIFT  0x000000011 } GdkGCValuesMask;
(ff:bind-c-constant GDK_GC_FOREGROUND
                    1) ;;
;;   GDK_GC_FOREGROUND =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_GC_BACKGROUND
                    2) ;;
;;   GDK_GC_BACKGROUND =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_GC_FONT
                    4) ;;
;;   GDK_GC_FONT =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_GC_FUNCTION
                    8) ;;
;;   GDK_GC_FUNCTION =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_GC_FILL
                    16) ;;
;;   GDK_GC_FILL =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_GC_TILE
                    32) ;;
;;   GDK_GC_TILE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_GC_STIPPLE
                    64) ;;
;;   GDK_GC_STIPPLE =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GDK_GC_CLIP_MASK
                    128) ;;
;;   GDK_GC_CLIP_MASK =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GDK_GC_SUBWINDOW
                    256) ;;
;;   GDK_GC_SUBWINDOW =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant GDK_GC_TS_X_ORIGIN
                    512) ;;
;;   GDK_GC_TS_X_ORIGIN =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant GDK_GC_TS_Y_ORIGIN
                    1024) ;;
;;   GDK_GC_TS_Y_ORIGIN =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-constant GDK_GC_CLIP_X_ORIGIN
                    2048) ;;
;;   GDK_GC_CLIP_X_ORIGIN =  0x000000001 LSHIFT  0x00000000b 
(ff:bind-c-constant GDK_GC_CLIP_Y_ORIGIN
                    4096) ;;
;;   GDK_GC_CLIP_Y_ORIGIN =  0x000000001 LSHIFT  0x00000000c 
(ff:bind-c-constant GDK_GC_EXPOSURES
                    8192) ;;
;;   GDK_GC_EXPOSURES =  0x000000001 LSHIFT  0x00000000d 
(ff:bind-c-constant GDK_GC_LINE_WIDTH
                    16384) ;;
;;   GDK_GC_LINE_WIDTH =  0x000000001 LSHIFT  0x00000000e 
(ff:bind-c-constant GDK_GC_LINE_STYLE
                    32768) ;;
;;   GDK_GC_LINE_STYLE =  0x000000001 LSHIFT  0x00000000f 
(ff:bind-c-constant GDK_GC_CAP_STYLE
                    65536) ;;
;;   GDK_GC_CAP_STYLE =  0x000000001 LSHIFT  0x000000010 
(ff:bind-c-constant GDK_GC_JOIN_STYLE
                    131072) ;;
;;   GDK_GC_JOIN_STYLE =  0x000000001 LSHIFT  0x000000011 
(ff:bind-c-type GdkGCValuesMask :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:536 <615> 
;; typedef enum {
;;         GDK_SELECTION_PRIMARY =  0x000000001, GDK_SELECTION_SECONDARY =
;;   0x000000002
;;    } GdkSelection;
(ff:bind-c-constant GDK_SELECTION_PRIMARY
                    1) ;;
;;   GDK_SELECTION_PRIMARY =  0x000000001 
(ff:bind-c-constant GDK_SELECTION_SECONDARY
                    2) ;;
;;   GDK_SELECTION_SECONDARY =  0x000000002 
(ff:bind-c-type GdkSelection :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:542 <616> 
;; typedef enum {
;;         GDK_PROPERTY_NEW_VALUE, GDK_PROPERTY_DELETE } GdkPropertyState;
(ff:bind-c-constant GDK_PROPERTY_NEW_VALUE 0) ;;  GDK_PROPERTY_NEW_VALUE 
(ff:bind-c-constant GDK_PROPERTY_DELETE 1) ;;  GDK_PROPERTY_DELETE 
(ff:bind-c-type GdkPropertyState :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:548 <617> 
;; typedef enum {
;;         GDK_PROP_MODE_REPLACE, GDK_PROP_MODE_PREPEND,
;;   GDK_PROP_MODE_APPEND } GdkPropMode
;;   ;
(ff:bind-c-constant GDK_PROP_MODE_REPLACE 0) ;;  GDK_PROP_MODE_REPLACE 
(ff:bind-c-constant GDK_PROP_MODE_PREPEND 1) ;;  GDK_PROP_MODE_PREPEND 
(ff:bind-c-constant GDK_PROP_MODE_APPEND 2) ;;  GDK_PROP_MODE_APPEND 
(ff:bind-c-type GdkPropMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:557 <618> 
;; typedef enum {
;;         GDK_SOURCE_MOUSE, GDK_SOURCE_PEN, GDK_SOURCE_ERASER,
;;   GDK_SOURCE_CURSOR
;;    } GdkInputSource;
(ff:bind-c-constant GDK_SOURCE_MOUSE 0) ;;  GDK_SOURCE_MOUSE 
(ff:bind-c-constant GDK_SOURCE_PEN 1) ;;  GDK_SOURCE_PEN 
(ff:bind-c-constant GDK_SOURCE_ERASER 2) ;;  GDK_SOURCE_ERASER 
(ff:bind-c-constant GDK_SOURCE_CURSOR 3) ;;  GDK_SOURCE_CURSOR 
(ff:bind-c-type GdkInputSource :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:565 <619> 
;; typedef enum {
;;         GDK_MODE_DISABLED, GDK_MODE_SCREEN, GDK_MODE_WINDOW }
;;   GdkInputMode;
(ff:bind-c-constant GDK_MODE_DISABLED 0) ;;  GDK_MODE_DISABLED 
(ff:bind-c-constant GDK_MODE_SCREEN 1) ;;  GDK_MODE_SCREEN 
(ff:bind-c-constant GDK_MODE_WINDOW 2) ;;  GDK_MODE_WINDOW 
(ff:bind-c-type GdkInputMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:572 <620> 
;; typedef enum {
;;         GDK_AXIS_IGNORE, GDK_AXIS_X, GDK_AXIS_Y, GDK_AXIS_PRESSURE,
;;   GDK_AXIS_XTILT,
;;              GDK_AXIS_YTILT, GDK_AXIS_LAST } GdkAxisUse;
(ff:bind-c-constant GDK_AXIS_IGNORE 0) ;;  GDK_AXIS_IGNORE 
(ff:bind-c-constant GDK_AXIS_X 1) ;;  GDK_AXIS_X 
(ff:bind-c-constant GDK_AXIS_Y 2) ;;  GDK_AXIS_Y 
(ff:bind-c-constant GDK_AXIS_PRESSURE 3) ;;  GDK_AXIS_PRESSURE 
(ff:bind-c-constant GDK_AXIS_XTILT 4) ;;  GDK_AXIS_XTILT 
(ff:bind-c-constant GDK_AXIS_YTILT 5) ;;  GDK_AXIS_YTILT 
(ff:bind-c-constant GDK_AXIS_LAST 6) ;;  GDK_AXIS_LAST 
(ff:bind-c-type GdkAxisUse :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:586 <621> 
;; typedef enum {
;;         GDK_TARGET_BITMAP =  0x000000005, GDK_TARGET_COLORMAP =
;;   0x000000007,
;;              GDK_TARGET_DRAWABLE =  0x000000011, GDK_TARGET_PIXMAP =
;;   0x000000014,
;;              GDK_TARGET_STRING =  0x00000001f } GdkTarget;
(ff:bind-c-constant GDK_TARGET_BITMAP 5) ;;
;;   GDK_TARGET_BITMAP =  0x000000005 
(ff:bind-c-constant GDK_TARGET_COLORMAP
                    7) ;;
;;   GDK_TARGET_COLORMAP =  0x000000007 
(ff:bind-c-constant GDK_TARGET_DRAWABLE
                    17) ;;
;;   GDK_TARGET_DRAWABLE =  0x000000011 
(ff:bind-c-constant GDK_TARGET_PIXMAP 20) ;;
;;   GDK_TARGET_PIXMAP =  0x000000014 
(ff:bind-c-constant GDK_TARGET_STRING 31) ;;
;;   GDK_TARGET_STRING =  0x00000001f 
(ff:bind-c-type GdkTarget :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:595 <622> 
;; typedef enum {
;;         GDK_SELECTION_TYPE_ATOM =  0x000000004,
;;   GDK_SELECTION_TYPE_BITMAP =  0x000000005,
;;              GDK_SELECTION_TYPE_COLORMAP =  0x000000007,
;;   GDK_SELECTION_TYPE_DRAWABLE
;;    =  0x000000011, GDK_SELECTION_TYPE_INTEGER =  0x000000013,
;;   GDK_SELECTION_TYPE_PIXMAP
;;    =  0x000000014, GDK_SELECTION_TYPE_WINDOW =  0x000000021,
;;   GDK_SELECTION_TYPE_STRING
;;    =  0x00000001f } GdkSelectionType;
(ff:bind-c-constant GDK_SELECTION_TYPE_ATOM
                    4) ;;
;;   GDK_SELECTION_TYPE_ATOM =  0x000000004 
(ff:bind-c-constant GDK_SELECTION_TYPE_BITMAP
                    5) ;;
;;   GDK_SELECTION_TYPE_BITMAP =  0x000000005 
(ff:bind-c-constant GDK_SELECTION_TYPE_COLORMAP
                    7) ;;
;;   GDK_SELECTION_TYPE_COLORMAP =  0x000000007 
(ff:bind-c-constant GDK_SELECTION_TYPE_DRAWABLE
                    17) ;;
;;   GDK_SELECTION_TYPE_DRAWABLE =  0x000000011 
(ff:bind-c-constant GDK_SELECTION_TYPE_INTEGER
                    19) ;;
;;   GDK_SELECTION_TYPE_INTEGER =  0x000000013 
(ff:bind-c-constant GDK_SELECTION_TYPE_PIXMAP
                    20) ;;
;;   GDK_SELECTION_TYPE_PIXMAP =  0x000000014 
(ff:bind-c-constant GDK_SELECTION_TYPE_WINDOW
                    33) ;;
;;   GDK_SELECTION_TYPE_WINDOW =  0x000000021 
(ff:bind-c-constant GDK_SELECTION_TYPE_STRING
                    31) ;;
;;   GDK_SELECTION_TYPE_STRING =  0x00000001f 
(ff:bind-c-type GdkSelectionType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:607 <623> 
;; typedef enum {
;;         GDK_EXTENSION_EVENTS_NONE, GDK_EXTENSION_EVENTS_ALL,
;;   GDK_EXTENSION_EVENTS_CURSOR
;;    } GdkExtensionMode;
(ff:bind-c-constant GDK_EXTENSION_EVENTS_NONE 0) ;;
;;   GDK_EXTENSION_EVENTS_NONE 
(ff:bind-c-constant GDK_EXTENSION_EVENTS_ALL 1) ;;
;;   GDK_EXTENSION_EVENTS_ALL 
(ff:bind-c-constant GDK_EXTENSION_EVENTS_CURSOR
                    2) ;;
;;   GDK_EXTENSION_EVENTS_CURSOR 
(ff:bind-c-type GdkExtensionMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:614 <624> 
;; typedef enum {
;;         GDK_IM_PREEDIT_AREA =  0x000000001, GDK_IM_PREEDIT_CALLBACKS =
;;   0x000000002,
;;              GDK_IM_PREEDIT_POSITION =  0x000000004,
;;   GDK_IM_PREEDIT_NOTHING =  0x000000008,
;;              GDK_IM_PREEDIT_NONE =  0x000000010, GDK_IM_PREEDIT_MASK =
;;   0x00000001f,
;;              GDK_IM_STATUS_AREA =  0x000000100, GDK_IM_STATUS_CALLBACKS
;;   =  0x000000200,
;;              GDK_IM_STATUS_NOTHING =  0x000000400, GDK_IM_STATUS_NONE =
;;   0x000000800,
;;              GDK_IM_STATUS_MASK =  0x000000f00 } GdkIMStyle;
(ff:bind-c-constant GDK_IM_PREEDIT_AREA
                    1) ;;
;;   GDK_IM_PREEDIT_AREA =  0x000000001 
(ff:bind-c-constant GDK_IM_PREEDIT_CALLBACKS
                    2) ;;
;;   GDK_IM_PREEDIT_CALLBACKS =  0x000000002 
(ff:bind-c-constant GDK_IM_PREEDIT_POSITION
                    4) ;;
;;   GDK_IM_PREEDIT_POSITION =  0x000000004 
(ff:bind-c-constant GDK_IM_PREEDIT_NOTHING
                    8) ;;
;;   GDK_IM_PREEDIT_NOTHING =  0x000000008 
(ff:bind-c-constant GDK_IM_PREEDIT_NONE
                    16) ;;
;;   GDK_IM_PREEDIT_NONE =  0x000000010 
(ff:bind-c-constant GDK_IM_PREEDIT_MASK
                    31) ;;
;;   GDK_IM_PREEDIT_MASK =  0x00000001f 
(ff:bind-c-constant GDK_IM_STATUS_AREA
                    256) ;;
;;   GDK_IM_STATUS_AREA =  0x000000100 
(ff:bind-c-constant GDK_IM_STATUS_CALLBACKS
                    512) ;;
;;   GDK_IM_STATUS_CALLBACKS =  0x000000200 
(ff:bind-c-constant GDK_IM_STATUS_NOTHING
                    1024) ;;
;;   GDK_IM_STATUS_NOTHING =  0x000000400 
(ff:bind-c-constant GDK_IM_STATUS_NONE
                    2048) ;;
;;   GDK_IM_STATUS_NONE =  0x000000800 
(ff:bind-c-constant GDK_IM_STATUS_MASK
                    3840) ;;
;;   GDK_IM_STATUS_MASK =  0x000000f00 
(ff:bind-c-type GdkIMStyle :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:630 <625> 
;; typedef enum {
;;         GDK_IC_STYLE =  0x000000001 LSHIFT  0x000000000,
;;   GDK_IC_CLIENT_WINDOW
;;    =  0x000000001 LSHIFT  0x000000001, GDK_IC_FOCUS_WINDOW =
;;   0x000000001
;;    LSHIFT  0x000000002, GDK_IC_FILTER_EVENTS =  0x000000001 LSHIFT
;;   0x000000003,
;;              GDK_IC_SPOT_LOCATION =  0x000000001 LSHIFT  0x000000004,
;;   GDK_IC_LINE_SPACING
;;    =  0x000000001 LSHIFT  0x000000005, GDK_IC_CURSOR =  0x000000001
;;   LSHIFT
;;     0x000000006, GDK_IC_PREEDIT_FONTSET =  0x000000001 LSHIFT
;;   0x00000000a,
;;              GDK_IC_PREEDIT_AREA =  0x000000001 LSHIFT  0x00000000b,
;;   GDK_IC_PREEDIT_AREA_NEEDED
;;    =  0x000000001 LSHIFT  0x00000000c, GDK_IC_PREEDIT_FOREGROUND =
;;   0x000000001
;;    LSHIFT  0x00000000d, GDK_IC_PREEDIT_BACKGROUND =  0x000000001 LSHIFT
;;   0x00000000e,
;;              GDK_IC_PREEDIT_PIXMAP =  0x000000001 LSHIFT  0x00000000f,
;;   GDK_IC_PREEDIT_COLORMAP
;;    =  0x000000001 LSHIFT  0x000000010, GDK_IC_STATUS_FONTSET =
;;   0x000000001
;;    LSHIFT  0x000000015, GDK_IC_STATUS_AREA =  0x000000001 LSHIFT
;;   0x000000016,
;;              GDK_IC_STATUS_AREA_NEEDED =  0x000000001 LSHIFT
;;   0x000000017, GDK_IC_STATUS_FOREGROUND
;;    =  0x000000001 LSHIFT  0x000000018, GDK_IC_STATUS_BACKGROUND =
;;   0x000000001
;;    LSHIFT  0x000000019, GDK_IC_STATUS_PIXMAP =  0x000000001 LSHIFT
;;   0x00000001a,
;;              GDK_IC_STATUS_COLORMAP =  0x000000001 LSHIFT  0x00000001b,
;;   GDK_IC_ALL_REQ
;;    = GDK_IC_STYLE | GDK_IC_CLIENT_WINDOW, GDK_IC_PREEDIT_AREA_REQ =
;;   GDK_IC_PREEDIT_AREA
;;    | GDK_IC_PREEDIT_FONTSET, GDK_IC_PREEDIT_POSITION_REQ =
;;   GDK_IC_PREEDIT_AREA
;;    | GDK_IC_SPOT_LOCATION | GDK_IC_PREEDIT_FONTSET,
;;   GDK_IC_STATUS_AREA_REQ
;;    = GDK_IC_STATUS_AREA | GDK_IC_STATUS_FONTSET } GdkICAttributesType;
(ff:bind-c-constant GDK_IC_STYLE
                    1) ;;
;;   GDK_IC_STYLE =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_IC_CLIENT_WINDOW
                    2) ;;
;;   GDK_IC_CLIENT_WINDOW =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_IC_FOCUS_WINDOW
                    4) ;;
;;   GDK_IC_FOCUS_WINDOW =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_IC_FILTER_EVENTS
                    8) ;;
;;   GDK_IC_FILTER_EVENTS =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_IC_SPOT_LOCATION
                    16) ;;
;;   GDK_IC_SPOT_LOCATION =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_IC_LINE_SPACING
                    32) ;;
;;   GDK_IC_LINE_SPACING =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_IC_CURSOR
                    64) ;;
;;   GDK_IC_CURSOR =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GDK_IC_PREEDIT_FONTSET
                    1024) ;;
;;   GDK_IC_PREEDIT_FONTSET =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-constant GDK_IC_PREEDIT_AREA
                    2048) ;;
;;   GDK_IC_PREEDIT_AREA =  0x000000001 LSHIFT  0x00000000b 
(ff:bind-c-constant GDK_IC_PREEDIT_AREA_NEEDED
                    4096) ;;
;;   GDK_IC_PREEDIT_AREA_NEEDED =  0x000000001 LSHIFT  0x00000000c 
(ff:bind-c-constant GDK_IC_PREEDIT_FOREGROUND
                    8192) ;;
;;   GDK_IC_PREEDIT_FOREGROUND =  0x000000001 LSHIFT  0x00000000d 
(ff:bind-c-constant GDK_IC_PREEDIT_BACKGROUND
                    16384) ;;
;;   GDK_IC_PREEDIT_BACKGROUND =  0x000000001 LSHIFT  0x00000000e 
(ff:bind-c-constant GDK_IC_PREEDIT_PIXMAP
                    32768) ;;
;;   GDK_IC_PREEDIT_PIXMAP =  0x000000001 LSHIFT  0x00000000f 
(ff:bind-c-constant GDK_IC_PREEDIT_COLORMAP
                    65536) ;;
;;   GDK_IC_PREEDIT_COLORMAP =  0x000000001 LSHIFT  0x000000010 
(ff:bind-c-constant GDK_IC_STATUS_FONTSET
                    2097152) ;;
;;   GDK_IC_STATUS_FONTSET =  0x000000001 LSHIFT  0x000000015 
(ff:bind-c-constant GDK_IC_STATUS_AREA
                    4194304) ;;
;;   GDK_IC_STATUS_AREA =  0x000000001 LSHIFT  0x000000016 
(ff:bind-c-constant GDK_IC_STATUS_AREA_NEEDED
                    8388608) ;;
;;   GDK_IC_STATUS_AREA_NEEDED =  0x000000001 LSHIFT  0x000000017 
(ff:bind-c-constant GDK_IC_STATUS_FOREGROUND
                    16777216) ;;
;;   GDK_IC_STATUS_FOREGROUND =  0x000000001 LSHIFT  0x000000018 
(ff:bind-c-constant GDK_IC_STATUS_BACKGROUND
                    33554432) ;;
;;   GDK_IC_STATUS_BACKGROUND =  0x000000001 LSHIFT  0x000000019 
(ff:bind-c-constant GDK_IC_STATUS_PIXMAP
                    67108864) ;;
;;   GDK_IC_STATUS_PIXMAP =  0x000000001 LSHIFT  0x00000001a 
(ff:bind-c-constant GDK_IC_STATUS_COLORMAP
                    134217728) ;;
;;   GDK_IC_STATUS_COLORMAP =  0x000000001 LSHIFT  0x00000001b 

(ff:bind-c-constant GDK_IC_ALL_REQ
                    (logior GDK_IC_STYLE  GDK_IC_CLIENT_WINDOW))
;;   GDK_IC_ALL_REQ = GDK_IC_STYLE | GDK_IC_CLIENT_WINDOW 

(ff:bind-c-constant GDK_IC_PREEDIT_AREA_REQ
                    (logior GDK_IC_PREEDIT_AREA GDK_IC_PREEDIT_FONTSET))
;;   GDK_IC_PREEDIT_AREA_REQ = GDK_IC_PREEDIT_AREA | GDK_IC_PREEDIT_FONTSET 

(ff:bind-c-constant GDK_IC_PREEDIT_POSITION_REQ
                    (logior GDK_IC_PREEDIT_AREA GDK_IC_SPOT_LOCATION
			    GDK_IC_PREEDIT_FONTSET))
;;   GDK_IC_PREEDIT_POSITION_REQ = GDK_IC_PREEDIT_AREA | GDK_IC_SPOT_LOCATION
;;  | GDK_IC_PREEDIT_FONTSET 

(ff:bind-c-constant GDK_IC_STATUS_AREA_REQ
                    (logior GDK_IC_STATUS_AREA  GDK_IC_STATUS_FONTSET))
;;   GDK_IC_STATUS_AREA_REQ = GDK_IC_STATUS_AREA | GDK_IC_STATUS_FONTSET 
(ff:bind-c-type GdkICAttributesType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:673 <626> 
;; typedef enum {
;;         GDK_DECOR_ALL =  0x000000001 LSHIFT  0x000000000,
;;   GDK_DECOR_BORDER =  0x000000001
;;    LSHIFT  0x000000001, GDK_DECOR_RESIZEH =  0x000000001 LSHIFT
;;   0x000000002,
;;              GDK_DECOR_TITLE =  0x000000001 LSHIFT  0x000000003,
;;   GDK_DECOR_MENU =  0x000000001
;;    LSHIFT  0x000000004, GDK_DECOR_MINIMIZE =  0x000000001 LSHIFT
;;   0x000000005,
;;              GDK_DECOR_MAXIMIZE =  0x000000001 LSHIFT  0x000000006 }
;;   GdkWMDecoration
;;   ;
(ff:bind-c-constant GDK_DECOR_ALL
                    1) ;;
;;   GDK_DECOR_ALL =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_DECOR_BORDER
                    2) ;;
;;   GDK_DECOR_BORDER =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_DECOR_RESIZEH
                    4) ;;
;;   GDK_DECOR_RESIZEH =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_DECOR_TITLE
                    8) ;;
;;   GDK_DECOR_TITLE =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_DECOR_MENU
                    16) ;;
;;   GDK_DECOR_MENU =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_DECOR_MINIMIZE
                    32) ;;
;;   GDK_DECOR_MINIMIZE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GDK_DECOR_MAXIMIZE
                    64) ;;
;;   GDK_DECOR_MAXIMIZE =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-type GdkWMDecoration :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:684 <627> 
;; typedef enum {
;;         GDK_FUNC_ALL =  0x000000001 LSHIFT  0x000000000, GDK_FUNC_RESIZE
;;   =  0x000000001
;;    LSHIFT  0x000000001, GDK_FUNC_MOVE =  0x000000001 LSHIFT
;;   0x000000002,
;;              GDK_FUNC_MINIMIZE =  0x000000001 LSHIFT  0x000000003,
;;   GDK_FUNC_MAXIMIZE
;;    =  0x000000001 LSHIFT  0x000000004, GDK_FUNC_CLOSE =  0x000000001
;;   LSHIFT
;;     0x000000005 } GdkWMFunction;
(ff:bind-c-constant GDK_FUNC_ALL
                    1) ;;
;;   GDK_FUNC_ALL =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_FUNC_RESIZE
                    2) ;;
;;   GDK_FUNC_RESIZE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_FUNC_MOVE
                    4) ;;
;;   GDK_FUNC_MOVE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_FUNC_MINIMIZE
                    8) ;;
;;   GDK_FUNC_MINIMIZE =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_FUNC_MAXIMIZE
                    16) ;;
;;   GDK_FUNC_MAXIMIZE =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_FUNC_CLOSE
                    32) ;;
;;   GDK_FUNC_CLOSE =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-type GdkWMFunction :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:694 <628> 
;; typedef void(* GdkInputFunction)( gpointer data, gint source,
;;   GdkInputCondition
;;    condition);
(ff:bind-c-type GdkInputFunction (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:698 <629> 
;; typedef void(* GdkDestroyNotify)( gpointer data);
(ff:bind-c-type GdkDestroyNotify (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:710 <630> 
;; typedef enum {
;;         GDK_CC_MODE_UNDEFINED, GDK_CC_MODE_BW, GDK_CC_MODE_STD_CMAP,
;;   GDK_CC_MODE_TRUE,
;;              GDK_CC_MODE_MY_GRAY, GDK_CC_MODE_PALETTE }
;;   GdkColorContextMode;
(ff:bind-c-constant GDK_CC_MODE_UNDEFINED 0) ;;  GDK_CC_MODE_UNDEFINED 
(ff:bind-c-constant GDK_CC_MODE_BW 1) ;;  GDK_CC_MODE_BW 
(ff:bind-c-constant GDK_CC_MODE_STD_CMAP 2) ;;  GDK_CC_MODE_STD_CMAP 
(ff:bind-c-constant GDK_CC_MODE_TRUE 3) ;;  GDK_CC_MODE_TRUE 
(ff:bind-c-constant GDK_CC_MODE_MY_GRAY 4) ;;  GDK_CC_MODE_MY_GRAY 
(ff:bind-c-constant GDK_CC_MODE_PALETTE 5) ;;  GDK_CC_MODE_PALETTE 
(ff:bind-c-type GdkColorContextMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:726 <631> 
;; typedef enum {
;;         GDK_OVERLAP_RECTANGLE_IN, GDK_OVERLAP_RECTANGLE_OUT,
;;   GDK_OVERLAP_RECTANGLE_PART
;;    } GdkOverlapType;
(ff:bind-c-constant GDK_OVERLAP_RECTANGLE_IN 0) ;;
;;   GDK_OVERLAP_RECTANGLE_IN 
(ff:bind-c-constant GDK_OVERLAP_RECTANGLE_OUT 1) ;;
;;   GDK_OVERLAP_RECTANGLE_OUT 
(ff:bind-c-constant GDK_OVERLAP_RECTANGLE_PART
                    2) ;;
;;   GDK_OVERLAP_RECTANGLE_PART 
(ff:bind-c-type GdkOverlapType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:733 <632> 
;; typedef enum {
;;         GDK_ACTION_DEFAULT =  0x000000001 LSHIFT  0x000000000,
;;   GDK_ACTION_COPY
;;    =  0x000000001 LSHIFT  0x000000001, GDK_ACTION_MOVE =  0x000000001
;;   LSHIFT
;;     0x000000002, GDK_ACTION_LINK =  0x000000001 LSHIFT  0x000000003,
;;   GDK_ACTION_PRIVATE
;;    =  0x000000001 LSHIFT  0x000000004, GDK_ACTION_ASK =  0x000000001
;;   LSHIFT
;;     0x000000005 } GdkDragAction;
(ff:bind-c-constant GDK_ACTION_DEFAULT
                    1) ;;
;;   GDK_ACTION_DEFAULT =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GDK_ACTION_COPY
                    2) ;;
;;   GDK_ACTION_COPY =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GDK_ACTION_MOVE
                    4) ;;
;;   GDK_ACTION_MOVE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GDK_ACTION_LINK
                    8) ;;
;;   GDK_ACTION_LINK =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GDK_ACTION_PRIVATE
                    16) ;;
;;   GDK_ACTION_PRIVATE =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GDK_ACTION_ASK
                    32) ;;
;;   GDK_ACTION_ASK =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-type GdkDragAction :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:742 <633> 
;; typedef enum {
;;         GDK_DRAG_PROTO_MOTIF, GDK_DRAG_PROTO_XDND,
;;   GDK_DRAG_PROTO_ROOTWIN, GDK_DRAG_PROTO_NONE
;;    } GdkDragProtocol;
(ff:bind-c-constant GDK_DRAG_PROTO_MOTIF 0) ;;  GDK_DRAG_PROTO_MOTIF 
(ff:bind-c-constant GDK_DRAG_PROTO_XDND 1) ;;  GDK_DRAG_PROTO_XDND 
(ff:bind-c-constant GDK_DRAG_PROTO_ROOTWIN 2) ;;  GDK_DRAG_PROTO_ROOTWIN 
(ff:bind-c-constant GDK_DRAG_PROTO_NONE 3) ;;  GDK_DRAG_PROTO_NONE 
(ff:bind-c-type GdkDragProtocol :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:757 <634> 
;; struct _GdkColor {
;;         gulong pixel; gushort red; gushort green; gushort blue; };
(ff:bind-c-type _GdkColor (:struct
  (pixel gulong)   ;; gulong pixel
  (red gushort)   ;; gushort red
  (green gushort)   ;; gushort green
  (blue gushort)   ;; gushort blue
  ))   ;; bind-c-type _GdkColor

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:768 <635> 
;; struct _GdkColormap { gint size; GdkColor* colors; };
(ff:bind-c-type _GdkColormap (:struct
  (size gint)   ;; gint size
  (colors (* GdkColor))   ;; GdkColor* colors
  ))   ;; bind-c-type _GdkColormap

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:786 <636> 
;; struct _GdkVisual {
;;         GdkVisualType type; gint depth; GdkByteOrder byte_order; gint
;;   colormap_size;
;;              gint bits_per_rgb; guint32 red_mask; gint red_shift; gint
;;   red_prec; guint32
;;    green_mask; gint green_shift; gint green_prec; guint32 blue_mask;
;;   gint
;;    blue_shift; gint blue_prec; };
(ff:bind-c-type _GdkVisual (:struct
  (type GdkVisualType)   ;; GdkVisualType type
  (depth gint)   ;; gint depth
  (byte_order GdkByteOrder)   ;; GdkByteOrder byte_order
  (colormap_size gint)   ;; gint colormap_size
  (bits_per_rgb gint)   ;; gint bits_per_rgb
  (red_mask guint32)   ;; guint32 red_mask
  (red_shift gint)   ;; gint red_shift
  (red_prec gint)   ;; gint red_prec
  (green_mask guint32)   ;; guint32 green_mask
  (green_shift gint)   ;; gint green_shift
  (green_prec gint)   ;; gint green_prec
  (blue_mask guint32)   ;; guint32 blue_mask
  (blue_shift gint)   ;; gint blue_shift
  (blue_prec gint)   ;; gint blue_prec
  ))   ;; bind-c-type _GdkVisual

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:807 <637> 
;; struct _GdkWindowAttr {
;;         gchar* title; gint event_mask; gint16 x, y; gint16 width; gint16
;;   height;
;;              GdkWindowClass wclass; GdkVisual* visual; GdkColormap*
;;   colormap; GdkWindowType
;;    window_type; GdkCursor* cursor; gchar* wmclass_name; gchar*
;;   wmclass_class;
;;              gboolean override_redirect; };
(ff:bind-c-type _GdkWindowAttr (:struct
  (title (* gchar))   ;; gchar* title
  (event_mask gint)   ;; gint event_mask
  (x gint16)   ;; gint16 x
  (y gint16)   ;; gint16 y
  (width gint16)   ;; gint16 width
  (height gint16)   ;; gint16 height
  (wclass GdkWindowClass)   ;; GdkWindowClass wclass
  (visual (* GdkVisual))   ;; GdkVisual* visual
  (colormap (* GdkColormap))   ;; GdkColormap* colormap
  (window_type GdkWindowType)   ;; GdkWindowType window_type
  (cursor (* GdkCursor))   ;; GdkCursor* cursor
  (wmclass_name (* gchar))   ;; gchar* wmclass_name
  (wmclass_class (* gchar))   ;; gchar* wmclass_class
  (override_redirect gboolean)   ;; gboolean override_redirect
  ))   ;; bind-c-type _GdkWindowAttr

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:824 <638> 
;; struct _GdkWindow { gpointer user_data; };
(ff:bind-c-type _GdkWindow (:struct
  (user_data gpointer)   ;; gpointer user_data
  ))   ;; bind-c-type _GdkWindow

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:829 <639> 
;; struct _GdkGeometry {
;;         gint min_width; gint min_height; gint max_width; gint
;;   max_height; gint
;;    base_width; gint base_height; gint width_inc; gint height_inc;
;;   gdouble
;;    min_aspect; gdouble max_aspect; };
(ff:bind-c-type _GdkGeometry (:struct
  (min_width gint)   ;; gint min_width
  (min_height gint)   ;; gint min_height
  (max_width gint)   ;; gint max_width
  (max_height gint)   ;; gint max_height
  (base_width gint)   ;; gint base_width
  (base_height gint)   ;; gint base_height
  (width_inc gint)   ;; gint width_inc
  (height_inc gint)   ;; gint height_inc
  (min_aspect gdouble)   ;; gdouble min_aspect
  (max_aspect gdouble)   ;; gdouble max_aspect
  ))   ;; bind-c-type _GdkGeometry

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:843 <640> 
;; struct _GdkImage {
;;         GdkImageType type; GdkVisual* visual; GdkByteOrder byte_order;
;;   guint16
;;    width; guint16 height; guint16 depth; guint16 bpp; guint16 bpl;
;;   gpointer
;;    mem; };
(ff:bind-c-type _GdkImage (:struct
  (type GdkImageType)   ;; GdkImageType type
  (visual (* GdkVisual))   ;; GdkVisual* visual
  (byte_order GdkByteOrder)   ;; GdkByteOrder byte_order
  (width guint16)   ;; guint16 width
  (height guint16)   ;; guint16 height
  (depth guint16)   ;; guint16 depth
  (bpp guint16)   ;; guint16 bpp
  (bpl guint16)   ;; guint16 bpl
  (mem gpointer)   ;; gpointer mem
  ))   ;; bind-c-type _GdkImage

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:856 <641> 
;; struct _GdkGCValues {
;;         GdkColor foreground; GdkColor background; GdkFont* font;
;;   GdkFunction function;
;;              GdkFill fill; GdkPixmap* tile; GdkPixmap* stipple;
;;   GdkPixmap* clip_mask;
;;              GdkSubwindowMode subwindow_mode; gint ts_x_origin; gint
;;   ts_y_origin; gint
;;    clip_x_origin; gint clip_y_origin; gint graphics_exposures; gint
;;   line_width;
;;              GdkLineStyle line_style; GdkCapStyle cap_style;
;;   GdkJoinStyle join_style;
;;    };
(ff:bind-c-type _GdkGCValues (:struct
  (foreground GdkColor)   ;; GdkColor foreground
  (background GdkColor)   ;; GdkColor background
  (font (* GdkFont))   ;; GdkFont* font
  (function GdkFunction)   ;; GdkFunction function
  (fill GdkFill)   ;; GdkFill fill
  (tile (* GdkPixmap))   ;; GdkPixmap* tile
  (stipple (* GdkPixmap))   ;; GdkPixmap* stipple
  (clip_mask (* GdkPixmap))   ;; GdkPixmap* clip_mask
  (subwindow_mode GdkSubwindowMode)   ;; GdkSubwindowMode subwindow_mode
  (ts_x_origin gint)   ;; gint ts_x_origin
  (ts_y_origin gint)   ;; gint ts_y_origin
  (clip_x_origin gint)   ;; gint clip_x_origin
  (clip_y_origin gint)   ;; gint clip_y_origin
  (graphics_exposures gint)   ;; gint graphics_exposures
  (line_width gint)   ;; gint line_width
  (line_style GdkLineStyle)   ;; GdkLineStyle line_style
  (cap_style GdkCapStyle)   ;; GdkCapStyle cap_style
  (join_style GdkJoinStyle)   ;; GdkJoinStyle join_style
  ))   ;; bind-c-type _GdkGCValues

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:878 <642> 
;; struct _GdkGC { gint dummy_var; };
(ff:bind-c-type _GdkGC (:struct
  (dummy_var gint)   ;; gint dummy_var
  ))   ;; bind-c-type _GdkGC

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:883 <643> 
;; struct _GdkPoint { gint16 x; gint16 y; };
(ff:bind-c-type _GdkPoint (:struct
  (x gint16)   ;; gint16 x
  (y gint16)   ;; gint16 y
  ))   ;; bind-c-type _GdkPoint

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:889 <644> 
;; struct _GdkRectangle {
;;         gint16 x; gint16 y; guint16 width; guint16 height; };
(ff:bind-c-type _GdkRectangle (:struct
  (x gint16)   ;; gint16 x
  (y gint16)   ;; gint16 y
  (width guint16)   ;; guint16 width
  (height guint16)   ;; guint16 height
  ))   ;; bind-c-type _GdkRectangle

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:897 <645> 
;; struct _GdkSegment { gint16 x1; gint16 y1; gint16 x2; gint16 y2; };
(ff:bind-c-type _GdkSegment (:struct
  (x1 gint16)   ;; gint16 x1
  (y1 gint16)   ;; gint16 y1
  (x2 gint16)   ;; gint16 x2
  (y2 gint16)   ;; gint16 y2
  ))   ;; bind-c-type _GdkSegment

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:905 <646> 
;; struct _GdkFont { GdkFontType type; gint ascent; gint descent; };
(ff:bind-c-type _GdkFont (:struct
  (type GdkFontType)   ;; GdkFontType type
  (ascent gint)   ;; gint ascent
  (descent gint)   ;; gint descent
  ))   ;; bind-c-type _GdkFont

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:912 <647> 
;; struct _GdkCursor { GdkCursorType type; };
(ff:bind-c-type _GdkCursor (:struct
  (type GdkCursorType)   ;; GdkCursorType type
  ))   ;; bind-c-type _GdkCursor

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:918 <648> 
;; struct _GdkColorContextDither {
;;         gint fast_rgb[  0x000000020][  0x000000020][  0x000000020]; gint
;;   fast_err
;;   [  0x000000020][  0x000000020][  0x000000020]; gint fast_erg[
;;   0x000000020
;;   ][  0x000000020][  0x000000020]; gint fast_erb[  0x000000020][
;;   0x000000020
;;   ][  0x000000020]; };
(ff:bind-c-type _GdkColorContextDither (:struct
  (fast_rgb (:array gint 32 32
             32))   ;;
  ;;  gint fast_rgb[  0x000000020][  0x000000020][  0x000000020]
  (fast_err (:array gint 32 32
             32))   ;;
  ;;  gint fast_err[  0x000000020][  0x000000020][  0x000000020]
  (fast_erg (:array gint 32 32
             32))   ;;
  ;;  gint fast_erg[  0x000000020][  0x000000020][  0x000000020]
  (fast_erb (:array gint 32 32
             32))   ;;
  ;;  gint fast_erb[  0x000000020][  0x000000020][  0x000000020]
  ))   ;; bind-c-type _GdkColorContextDither

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:926 <649> 
;; struct _GdkColorContext {
;;         GdkVisual* visual; GdkColormap* colormap; gint num_colors; gint
;;   max_colors;
;;              gint num_allocated; GdkColorContextMode mode; gint
;;   need_to_free_colormap;
;;              GdkAtom std_cmap_atom; gulong* clut; GdkColor* cmap;
;;   GHashTable* color_hash;
;;              GdkColor* palette; gint num_palette; GdkColorContextDither*
;;   fast_dither;
;;              struct {
;;         gint red; gint green; gint blue; } shifts; struct {
;;         gulong red; gulong green; gulong blue; } masks; struct {
;;         gint red; gint green; gint blue; } bits; gulong max_entry;
;;   gulong black_pixel;
;;              gulong white_pixel; };
(ff:bind-c-type _GdkColorContext (:struct
  (visual (* GdkVisual))   ;; GdkVisual* visual
  (colormap (* GdkColormap))   ;; GdkColormap* colormap
  (num_colors gint)   ;; gint num_colors
  (max_colors gint)   ;; gint max_colors
  (num_allocated gint)   ;; gint num_allocated
  (mode GdkColorContextMode)   ;; GdkColorContextMode mode
  (need_to_free_colormap gint)   ;; gint need_to_free_colormap
  (std_cmap_atom GdkAtom)   ;; GdkAtom std_cmap_atom
  (clut (* gulong))   ;; gulong* clut
  (cmap (* GdkColor))   ;; GdkColor* cmap
  (color_hash (* GHashTable))   ;; GHashTable* color_hash
  (palette (* GdkColor))   ;; GdkColor* palette
  (num_palette gint)   ;; gint num_palette
  (fast_dither (* GdkColorContextDither))   ;;
  ;;  GdkColorContextDither* fast_dither
  (shifts (:struct   ;; struct{} shifts
    (red gint)   ;; gint red
    (green gint)   ;; gint green
    (blue gint)   ;; gint blue
    ))  ;; slot shifts
  (masks (:struct   ;; struct{} masks
    (red gulong)   ;; gulong red
    (green gulong)   ;; gulong green
    (blue gulong)   ;; gulong blue
    ))  ;; slot masks
  (bits (:struct   ;; struct{} bits
    (red gint)   ;; gint red
    (green gint)   ;; gint green
    (blue gint)   ;; gint blue
    ))  ;; slot bits
  (max_entry gulong)   ;; gulong max_entry
  (black_pixel gulong)   ;; gulong black_pixel
  (white_pixel gulong)   ;; gulong white_pixel
  ))   ;; bind-c-type _GdkColorContext

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:977 <650> 
;; struct _GdkDeviceKey { guint keyval; GdkModifierType modifiers; };
(ff:bind-c-type _GdkDeviceKey (:struct
  (keyval guint)   ;; guint keyval
  (modifiers GdkModifierType)   ;; GdkModifierType modifiers
  ))   ;; bind-c-type _GdkDeviceKey

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:983 <651> 
;; struct _GdkDeviceInfo {
;;         guint32 deviceid; gchar* name; GdkInputSource source;
;;   GdkInputMode mode;
;;              gint has_cursor; gint num_axes; GdkAxisUse* axes; gint
;;   num_keys; GdkDeviceKey
;;   * keys; };
(ff:bind-c-type _GdkDeviceInfo (:struct
  (deviceid guint32)   ;; guint32 deviceid
  (name (* gchar))   ;; gchar* name
  (source GdkInputSource)   ;; GdkInputSource source
  (mode GdkInputMode)   ;; GdkInputMode mode
  (has_cursor gint)   ;; gint has_cursor
  (num_axes gint)   ;; gint num_axes
  (axes (* GdkAxisUse))   ;; GdkAxisUse* axes
  (num_keys gint)   ;; gint num_keys
  (keys (* GdkDeviceKey))   ;; GdkDeviceKey* keys
  ))   ;; bind-c-type _GdkDeviceInfo

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:996 <652> 
;; struct _GdkTimeCoord {
;;         guint32 time; gdouble x; gdouble y; gdouble pressure; gdouble
;;   xtilt; gdouble
;;    ytilt; };
(ff:bind-c-type _GdkTimeCoord (:struct
  (time guint32)   ;; guint32 time
  (x gdouble)   ;; gdouble x
  (y gdouble)   ;; gdouble y
  (pressure gdouble)   ;; gdouble pressure
  (xtilt gdouble)   ;; gdouble xtilt
  (ytilt gdouble)   ;; gdouble ytilt
  ))   ;; bind-c-type _GdkTimeCoord

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1009 <653> 
;; struct _GdkDragContext {
;;         GdkDragProtocol protocol; gboolean is_source; GdkWindow*
;;   source_window;
;;              GdkWindow* dest_window; GList* targets; GdkDragAction
;;   actions; GdkDragAction
;;    suggested_action; GdkDragAction action; guint32 start_time; };
(ff:bind-c-type _GdkDragContext (:struct
  (protocol GdkDragProtocol)   ;; GdkDragProtocol protocol
  (is_source gboolean)   ;; gboolean is_source
  (source_window (* GdkWindow))   ;; GdkWindow* source_window
  (dest_window (* GdkWindow))   ;; GdkWindow* dest_window
  (targets (* GList))   ;; GList* targets
  (actions GdkDragAction)   ;; GdkDragAction actions
  (suggested_action GdkDragAction)   ;; GdkDragAction suggested_action
  (action GdkDragAction)   ;; GdkDragAction action
  (start_time guint32)   ;; guint32 start_time
  ))   ;; bind-c-type _GdkDragContext

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1027 <654> 
;; typedef void GdkXEvent;
(ff:bind-c-type GdkXEvent :void)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1029 <655> 
;; typedef GdkFilterReturn(* GdkFilterFunc)( GdkXEvent* xevent, GdkEvent
;;   * event, gpointer data);
(ff:bind-c-type GdkFilterFunc (* GdkFilterReturn))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1033 <656> 
;; struct _GdkEventAny {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; };
(ff:bind-c-type _GdkEventAny (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  ))   ;; bind-c-type _GdkEventAny

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1040 <657> 
;; struct _GdkEventExpose {
;;         GdkEventType type; GdkWindow* window; gint8 send_event;
;;   GdkRectangle area;
;;              gint count; };
(ff:bind-c-type _GdkEventExpose (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (area GdkRectangle)   ;; GdkRectangle area
  (count gint)   ;; gint count
  ))   ;; bind-c-type _GdkEventExpose

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1049 <658> 
;; struct _GdkEventNoExpose {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; };
(ff:bind-c-type _GdkEventNoExpose (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  ))   ;; bind-c-type _GdkEventNoExpose

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1057 <659> 
;; struct _GdkEventVisibility {
;;         GdkEventType type; GdkWindow* window; gint8 send_event;
;;   GdkVisibilityState
;;    state; };
(ff:bind-c-type _GdkEventVisibility (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (state GdkVisibilityState)   ;; GdkVisibilityState state
  ))   ;; bind-c-type _GdkEventVisibility

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1065 <660> 
;; struct _GdkEventMotion {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; guint32
;;   time;
;;              gdouble x; gdouble y; gdouble pressure; gdouble xtilt;
;;   gdouble ytilt;
;;              guint state; gint16 is_hint; GdkInputSource source; guint32
;;   deviceid;
;;              gdouble x_root, y_root; };
(ff:bind-c-type _GdkEventMotion (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (time guint32)   ;; guint32 time
  (x gdouble)   ;; gdouble x
  (y gdouble)   ;; gdouble y
  (pressure gdouble)   ;; gdouble pressure
  (xtilt gdouble)   ;; gdouble xtilt
  (ytilt gdouble)   ;; gdouble ytilt
  (state guint)   ;; guint state
  (is_hint gint16)   ;; gint16 is_hint
  (source GdkInputSource)   ;; GdkInputSource source
  (deviceid guint32)   ;; guint32 deviceid
  (x_root gdouble)   ;; gdouble x_root
  (y_root gdouble)   ;; gdouble y_root
  ))   ;; bind-c-type _GdkEventMotion

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1083 <661> 
;; struct _GdkEventButton {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; guint32
;;   time;
;;              gdouble x; gdouble y; gdouble pressure; gdouble xtilt;
;;   gdouble ytilt;
;;              guint state; guint button; GdkInputSource source; guint32
;;   deviceid; gdouble
;;    x_root, y_root; };
(ff:bind-c-type _GdkEventButton (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (time guint32)   ;; guint32 time
  (x gdouble)   ;; gdouble x
  (y gdouble)   ;; gdouble y
  (pressure gdouble)   ;; gdouble pressure
  (xtilt gdouble)   ;; gdouble xtilt
  (ytilt gdouble)   ;; gdouble ytilt
  (state guint)   ;; guint state
  (button guint)   ;; guint button
  (source GdkInputSource)   ;; GdkInputSource source
  (deviceid guint32)   ;; guint32 deviceid
  (x_root gdouble)   ;; gdouble x_root
  (y_root gdouble)   ;; gdouble y_root
  ))   ;; bind-c-type _GdkEventButton

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1101 <662> 
;; struct _GdkEventKey {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; guint32
;;   time;
;;              guint state; guint keyval; gint length; gchar* string; };
(ff:bind-c-type _GdkEventKey (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (time guint32)   ;; guint32 time
  (state guint)   ;; guint state
  (keyval guint)   ;; guint keyval
  (length gint)   ;; gint length
  (string (* gchar))   ;; gchar* string
  ))   ;; bind-c-type _GdkEventKey

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1113 <663> 
;; struct _GdkEventCrossing {
;;         GdkEventType type; GdkWindow* window; gint8 send_event;
;;   GdkWindow* subwindow;
;;              guint32 time; gdouble x; gdouble y; gdouble x_root; gdouble
;;   y_root; GdkCrossingMode
;;    mode; GdkNotifyType detail; gboolean focus; guint state; };
(ff:bind-c-type _GdkEventCrossing (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (subwindow (* GdkWindow))   ;; GdkWindow* subwindow
  (time guint32)   ;; guint32 time
  (x gdouble)   ;; gdouble x
  (y gdouble)   ;; gdouble y
  (x_root gdouble)   ;; gdouble x_root
  (y_root gdouble)   ;; gdouble y_root
  (mode GdkCrossingMode)   ;; GdkCrossingMode mode
  (detail GdkNotifyType)   ;; GdkNotifyType detail
  (focus gboolean)   ;; gboolean focus
  (state guint)   ;; guint state
  ))   ;; bind-c-type _GdkEventCrossing

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1130 <664> 
;; struct _GdkEventFocus {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; gint16
;;   in; };
(ff:bind-c-type _GdkEventFocus (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (in gint16)   ;; gint16 in
  ))   ;; bind-c-type _GdkEventFocus

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1138 <665> 
;; struct _GdkEventConfigure {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; gint16
;;   x, y; gint16
;;    width; gint16 height; };
(ff:bind-c-type _GdkEventConfigure (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (x gint16)   ;; gint16 x
  (y gint16)   ;; gint16 y
  (width gint16)   ;; gint16 width
  (height gint16)   ;; gint16 height
  ))   ;; bind-c-type _GdkEventConfigure

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1148 <666> 
;; struct _GdkEventProperty {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; GdkAtom
;;   atom;
;;              guint32 time; guint state; };
(ff:bind-c-type _GdkEventProperty (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (atom GdkAtom)   ;; GdkAtom atom
  (time guint32)   ;; guint32 time
  (state guint)   ;; guint state
  ))   ;; bind-c-type _GdkEventProperty

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1158 <667> 
;; struct _GdkEventSelection {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; GdkAtom
;;   selection;
;;              GdkAtom target; GdkAtom property; guint32 requestor;
;;   guint32 time; };
(ff:bind-c-type _GdkEventSelection (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (selection GdkAtom)   ;; GdkAtom selection
  (target GdkAtom)   ;; GdkAtom target
  (property GdkAtom)   ;; GdkAtom property
  (requestor guint32)   ;; guint32 requestor
  (time guint32)   ;; guint32 time
  ))   ;; bind-c-type _GdkEventSelection

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1173 <668> 
;; struct _GdkEventProximity {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; guint32
;;   time;
;;              GdkInputSource source; guint32 deviceid; };
(ff:bind-c-type _GdkEventProximity (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (time guint32)   ;; guint32 time
  (source GdkInputSource)   ;; GdkInputSource source
  (deviceid guint32)   ;; guint32 deviceid
  ))   ;; bind-c-type _GdkEventProximity

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1183 <669> 
;; struct _GdkEventClient {
;;         GdkEventType type; GdkWindow* window; gint8 send_event; GdkAtom
;;   message_type;
;;              gushort data_format; union {
;;         char b[  0x000000014]; short s[  0x00000000a]; long l[
;;   0x000000005];
;;    } data; };
(ff:bind-c-type _GdkEventClient (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (message_type GdkAtom)   ;; GdkAtom message_type
  (data_format gushort)   ;; gushort data_format
  (data (:union   ;; union{} data
    (b (:array :char 20))   ;; char b[  0x000000014]
    (s (:array :short 10))   ;; short s[  0x00000000a]
    (l (:array :long 5))   ;; long l[  0x000000005]
    ))  ;; slot data
  ))   ;; bind-c-type _GdkEventClient

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1199 <670> 
;; struct _GdkEventDND {
;;         GdkEventType type; GdkWindow* window; gint8 send_event;
;;   GdkDragContext
;;   * context; guint32 time; gshort x_root, y_root; };
(ff:bind-c-type _GdkEventDND (:struct
  (type GdkEventType)   ;; GdkEventType type
  (window (* GdkWindow))   ;; GdkWindow* window
  (send_event gint8)   ;; gint8 send_event
  (context (* GdkDragContext))   ;; GdkDragContext* context
  (time guint32)   ;; guint32 time
  (x_root gshort)   ;; gshort x_root
  (y_root gshort)   ;; gshort y_root
  ))   ;; bind-c-type _GdkEventDND

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1209 <671> 
;; union _GdkEvent {
;;         GdkEventType type; GdkEventAny any; GdkEventExpose expose;
;;   GdkEventNoExpose
;;    no_expose; GdkEventVisibility visibility; GdkEventMotion motion;
;;   GdkEventButton
;;    button; GdkEventKey key; GdkEventCrossing crossing; GdkEventFocus
;;   focus_change;
;;              GdkEventConfigure configure; GdkEventProperty property;
;;   GdkEventSelection
;;    selection; GdkEventProximity proximity; GdkEventClient client;
;;   GdkEventDND
;;    dnd; };
(ff:bind-c-type _GdkEvent (:union
  (type GdkEventType)   ;; GdkEventType type
  (any GdkEventAny)   ;; GdkEventAny any
  (expose GdkEventExpose)   ;; GdkEventExpose expose
  (no_expose GdkEventNoExpose)   ;; GdkEventNoExpose no_expose
  (visibility GdkEventVisibility)   ;; GdkEventVisibility visibility
  (motion GdkEventMotion)   ;; GdkEventMotion motion
  (button GdkEventButton)   ;; GdkEventButton button
  (key GdkEventKey)   ;; GdkEventKey key
  (crossing GdkEventCrossing)   ;; GdkEventCrossing crossing
  (focus_change GdkEventFocus)   ;; GdkEventFocus focus_change
  (configure GdkEventConfigure)   ;; GdkEventConfigure configure
  (property GdkEventProperty)   ;; GdkEventProperty property
  (selection GdkEventSelection)   ;; GdkEventSelection selection
  (proximity GdkEventProximity)   ;; GdkEventProximity proximity
  (client GdkEventClient)   ;; GdkEventClient client
  (dnd GdkEventDND)   ;; GdkEventDND dnd
  ))   ;; bind-c-type _GdkEvent

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1229 <672> 
;; struct _GdkRegion { gpointer user_data; };
(ff:bind-c-type _GdkRegion (:struct
  (user_data gpointer)   ;; gpointer user_data
  ))   ;; bind-c-type _GdkRegion

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdktypes.h:1234 <673> 
;; struct _GdkICAttr {
;;         GdkIMStyle style; GdkWindow* client_window; GdkWindow*
;;   focus_window; GdkEventMask
;;    filter_events; GdkPoint spot_location; gint line_spacing; GdkCursor*
;;   cursor;
;;              GdkFont* preedit_fontset; GdkRectangle preedit_area;
;;   GdkRectangle preedit_area_needed;
;;              GdkColor preedit_foreground; GdkColor preedit_background;
;;   GdkPixmap* preedit_pixmap;
;;              GdkColormap* preedit_colormap; GdkFont* status_fontset;
;;   GdkRectangle status_area;
;;              GdkRectangle status_area_needed; GdkColor
;;   status_foreground; GdkColor
;;    status_background; GdkPixmap* status_pixmap; GdkColormap*
;;   status_colormap;
;;    };
(ff:bind-c-type _GdkICAttr (:struct
  (style GdkIMStyle)   ;; GdkIMStyle style
  (client_window (* GdkWindow))   ;; GdkWindow* client_window
  (focus_window (* GdkWindow))   ;; GdkWindow* focus_window
  (filter_events GdkEventMask)   ;; GdkEventMask filter_events
  (spot_location GdkPoint)   ;; GdkPoint spot_location
  (line_spacing gint)   ;; gint line_spacing
  (cursor (* GdkCursor))   ;; GdkCursor* cursor
  (preedit_fontset (* GdkFont))   ;; GdkFont* preedit_fontset
  (preedit_area GdkRectangle)   ;; GdkRectangle preedit_area
  (preedit_area_needed GdkRectangle)   ;; GdkRectangle preedit_area_needed
  (preedit_foreground GdkColor)   ;; GdkColor preedit_foreground
  (preedit_background GdkColor)   ;; GdkColor preedit_background
  (preedit_pixmap (* GdkPixmap))   ;; GdkPixmap* preedit_pixmap
  (preedit_colormap (* GdkColormap))   ;; GdkColormap* preedit_colormap
  (status_fontset (* GdkFont))   ;; GdkFont* status_fontset
  (status_area GdkRectangle)   ;; GdkRectangle status_area
  (status_area_needed GdkRectangle)   ;; GdkRectangle status_area_needed
  (status_foreground GdkColor)   ;; GdkColor status_foreground
  (status_background GdkColor)   ;; GdkColor status_background
  (status_pixmap (* GdkPixmap))   ;; GdkPixmap* status_pixmap
  (status_colormap (* GdkColormap))   ;; GdkColormap* status_colormap
  ))   ;; bind-c-type _GdkICAttr

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:41 <674> 
;; void gdk_init( gint* argc, gchar*** argv);
(ff:bind-c-function gdk_init
     :unconverted-entry-name "gdk_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint" "*") ("gchar" "*" "*" "*"))
     :c-arg-names (argc argv)
     :arguments ((* gint) (* (* (* gchar))))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:43 <675> 
;; gboolean gdk_init_check( gint* argc, gchar*** argv);
(ff:bind-c-function gdk_init_check
     :unconverted-entry-name "gdk_init_check"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("gint" "*") ("gchar" "*" "*" "*"))
     :c-arg-names (argc argv)
     :arguments ((* gint) (* (* (* gchar))))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:45 <676> 
;; void gdk_exit( gint error_code);
(ff:bind-c-function gdk_exit
     :unconverted-entry-name "gdk_exit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint"))
     :c-arg-names (error_code)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:46 <677> 
;; gchar* gdk_set_locale( void);
(ff:bind-c-function gdk_set_locale
     :unconverted-entry-name "gdk_set_locale"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:50 <678> 
;; void gdk_error_trap_push( void);
(ff:bind-c-function gdk_error_trap_push
     :unconverted-entry-name "gdk_error_trap_push"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:51 <679> 
;; gint gdk_error_trap_pop( void);
(ff:bind-c-function gdk_error_trap_pop
     :unconverted-entry-name "gdk_error_trap_pop"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:54 <680> 
;; gboolean gdk_events_pending( void);
(ff:bind-c-function gdk_events_pending
     :unconverted-entry-name "gdk_events_pending"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:55 <681> 
;; GdkEvent* gdk_event_get( void);
(ff:bind-c-function gdk_event_get
     :unconverted-entry-name "gdk_event_get"
     :c-return-type ("GdkEvent" "*")
     :return-type (* GdkEvent)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:57 <682> 
;; GdkEvent* gdk_event_peek( void);
(ff:bind-c-function gdk_event_peek
     :unconverted-entry-name "gdk_event_peek"
     :c-return-type ("GdkEvent" "*")
     :return-type (* GdkEvent)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:58 <683> 
;; GdkEvent* gdk_event_get_graphics_expose( GdkWindow* window);
(ff:bind-c-function gdk_event_get_graphics_expose
     :unconverted-entry-name "gdk_event_get_graphics_expose"
     :c-return-type ("GdkEvent" "*")
     :return-type (* GdkEvent)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:59 <684> 
;; void gdk_event_put( GdkEvent* event);
(ff:bind-c-function gdk_event_put
     :unconverted-entry-name "gdk_event_put"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkEvent" "*"))
     :c-arg-names (event)
     :arguments ((* GdkEvent))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:61 <685> 
;; GdkEvent* gdk_event_copy( GdkEvent* event);
(ff:bind-c-function gdk_event_copy
     :unconverted-entry-name "gdk_event_copy"
     :c-return-type ("GdkEvent" "*")
     :return-type (* GdkEvent)
     :c-arg-types (("GdkEvent" "*"))
     :c-arg-names (event)
     :arguments ((* GdkEvent))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:62 <686> 
;; void gdk_event_free( GdkEvent* event);
(ff:bind-c-function gdk_event_free
     :unconverted-entry-name "gdk_event_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkEvent" "*"))
     :c-arg-names (event)
     :arguments ((* GdkEvent))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:63 <687> 
;; guint32 gdk_event_get_time( GdkEvent* event);
(ff:bind-c-function gdk_event_get_time
     :unconverted-entry-name "gdk_event_get_time"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types (("GdkEvent" "*"))
     :c-arg-names (event)
     :arguments ((* GdkEvent))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:65 <688> 
;; void gdk_event_handler_set( GdkEventFunc func, gpointer data,
;;   GDestroyNotify
;;    notify);
(ff:bind-c-function gdk_event_handler_set
     :unconverted-entry-name "gdk_event_handler_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkEventFunc") ("gpointer") ("GDestroyNotify"))
     :c-arg-names (func data notify)
     :arguments (GdkEventFunc gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:69 <689> 
;; void gdk_set_show_events( gboolean show_events);
(ff:bind-c-function gdk_set_show_events
     :unconverted-entry-name "gdk_set_show_events"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gboolean"))
     :c-arg-names (show_events)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:70 <690> 
;; void gdk_set_use_xshm( gboolean use_xshm);
(ff:bind-c-function gdk_set_use_xshm
     :unconverted-entry-name "gdk_set_use_xshm"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gboolean"))
     :c-arg-names (use_xshm)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:72 <691> 
;; gboolean gdk_get_show_events( void);
(ff:bind-c-function gdk_get_show_events
     :unconverted-entry-name "gdk_get_show_events"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:73 <692> 
;; gboolean gdk_get_use_xshm( void);
(ff:bind-c-function gdk_get_use_xshm
     :unconverted-entry-name "gdk_get_use_xshm"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:74 <693> 
;; gchar* gdk_get_display( void);
(ff:bind-c-function gdk_get_display
     :unconverted-entry-name "gdk_get_display"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:76 <694> 
;; guint32 gdk_time_get( void);
(ff:bind-c-function gdk_time_get
     :unconverted-entry-name "gdk_time_get"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:77 <695> 
;; guint32 gdk_timer_get( void);
(ff:bind-c-function gdk_timer_get
     :unconverted-entry-name "gdk_timer_get"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:78 <696> 
;; void gdk_timer_set( guint32 milliseconds);
(ff:bind-c-function gdk_timer_set
     :unconverted-entry-name "gdk_timer_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32"))
     :c-arg-names (milliseconds)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:79 <697> 
;; void gdk_timer_enable( void);
(ff:bind-c-function gdk_timer_enable
     :unconverted-entry-name "gdk_timer_enable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:80 <698> 
;; void gdk_timer_disable( void);
(ff:bind-c-function gdk_timer_disable
     :unconverted-entry-name "gdk_timer_disable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:82 <699> 
;; gint gdk_input_add_full( gint source, GdkInputCondition condition,
;;   GdkInputFunction
;;    function, gpointer data, GdkDestroyNotify destroy);
(ff:bind-c-function gdk_input_add_full
     :unconverted-entry-name "gdk_input_add_full"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gint") ("GdkInputCondition") ("GdkInputFunction")
                   ("gpointer") ("GdkDestroyNotify"))
     :c-arg-names (source condition function data destroy)
     :arguments (gint GdkInputCondition GdkInputFunction gpointer
                 GdkDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:87 <700> 
;; gint gdk_input_add( gint source, GdkInputCondition condition,
;;   GdkInputFunction
;;    function, gpointer data);
(ff:bind-c-function gdk_input_add
     :unconverted-entry-name "gdk_input_add"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gint") ("GdkInputCondition") ("GdkInputFunction")
                   ("gpointer"))
     :c-arg-names (source condition function data)
     :arguments (gint GdkInputCondition GdkInputFunction gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:91 <701> 
;; void gdk_input_remove( gint tag);
(ff:bind-c-function gdk_input_remove
     :unconverted-entry-name "gdk_input_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint"))
     :c-arg-names (tag)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:93 <702> 
;; gint gdk_pointer_grab( GdkWindow* window, gint owner_events,
;;   GdkEventMask
;;    event_mask, GdkWindow* confine_to, GdkCursor* cursor, guint32 time);
(ff:bind-c-function gdk_pointer_grab
     :unconverted-entry-name "gdk_pointer_grab"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkWindow" "*") ("gint") ("GdkEventMask")
                   ("GdkWindow" "*") ("GdkCursor" "*") ("guint32"))
     :c-arg-names (window owner_events event_mask confine_to cursor time)
     :arguments ((* GdkWindow) gint GdkEventMask (* GdkWindow) (* GdkCursor)
                 guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:99 <703> 
;; void gdk_pointer_ungrab( guint32 time);
(ff:bind-c-function gdk_pointer_ungrab
     :unconverted-entry-name "gdk_pointer_ungrab"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32"))
     :c-arg-names (time)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:100 <704> 
;; gint gdk_keyboard_grab( GdkWindow* window, gboolean owner_events,
;;   guint32
;;    time);
(ff:bind-c-function gdk_keyboard_grab
     :unconverted-entry-name "gdk_keyboard_grab"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkWindow" "*") ("gboolean") ("guint32"))
     :c-arg-names (window owner_events time)
     :arguments ((* GdkWindow) gboolean guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:103 <705> 
;; void gdk_keyboard_ungrab( guint32 time);
(ff:bind-c-function gdk_keyboard_ungrab
     :unconverted-entry-name "gdk_keyboard_ungrab"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32"))
     :c-arg-names (time)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:104 <706> 
;; gboolean gdk_pointer_is_grabbed( void);
(ff:bind-c-function gdk_pointer_is_grabbed
     :unconverted-entry-name "gdk_pointer_is_grabbed"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:107 <707> 
;; gint gdk_screen_width( void);
(ff:bind-c-function gdk_screen_width
     :unconverted-entry-name "gdk_screen_width"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:108 <708> 
;; gint gdk_screen_height( void);
(ff:bind-c-function gdk_screen_height
     :unconverted-entry-name "gdk_screen_height"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:110 <709> 
;; gint gdk_screen_width_mm( void);
(ff:bind-c-function gdk_screen_width_mm
     :unconverted-entry-name "gdk_screen_width_mm"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:111 <710> 
;; gint gdk_screen_height_mm( void);
(ff:bind-c-function gdk_screen_height_mm
     :unconverted-entry-name "gdk_screen_height_mm"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:113 <711> 
;; void gdk_flush( void);
(ff:bind-c-function gdk_flush
     :unconverted-entry-name "gdk_flush"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:114 <712> 
;; void gdk_beep( void);
(ff:bind-c-function gdk_beep
     :unconverted-entry-name "gdk_beep"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:116 <713> 
;; void gdk_key_repeat_disable( void);
(ff:bind-c-function gdk_key_repeat_disable
     :unconverted-entry-name "gdk_key_repeat_disable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:117 <714> 
;; void gdk_key_repeat_restore( void);
(ff:bind-c-function gdk_key_repeat_restore
     :unconverted-entry-name "gdk_key_repeat_restore"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:122 <715> 
;; gint gdk_visual_get_best_depth( void);
(ff:bind-c-function gdk_visual_get_best_depth
     :unconverted-entry-name "gdk_visual_get_best_depth"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:123 <716> 
;; GdkVisualType gdk_visual_get_best_type( void);
(ff:bind-c-function gdk_visual_get_best_type
     :unconverted-entry-name "gdk_visual_get_best_type"
     :c-return-type ("GdkVisualType")
     :return-type GdkVisualType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:124 <717> 
;; GdkVisual* gdk_visual_get_system( void);
(ff:bind-c-function gdk_visual_get_system
     :unconverted-entry-name "gdk_visual_get_system"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:125 <718> 
;; GdkVisual* gdk_visual_get_best( void);
(ff:bind-c-function gdk_visual_get_best
     :unconverted-entry-name "gdk_visual_get_best"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:126 <719> 
;; GdkVisual* gdk_visual_get_best_with_depth( gint depth);
(ff:bind-c-function gdk_visual_get_best_with_depth
     :unconverted-entry-name "gdk_visual_get_best_with_depth"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("gint"))
     :c-arg-names (depth)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:127 <720> 
;; GdkVisual* gdk_visual_get_best_with_type( GdkVisualType visual_type);
(ff:bind-c-function gdk_visual_get_best_with_type
     :unconverted-entry-name "gdk_visual_get_best_with_type"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("GdkVisualType"))
     :c-arg-names (visual_type)
     :arguments (GdkVisualType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:128 <721> 
;; GdkVisual* gdk_visual_get_best_with_both( gint depth, GdkVisualType
;;   visual_type
;;   );
(ff:bind-c-function gdk_visual_get_best_with_both
     :unconverted-entry-name "gdk_visual_get_best_with_both"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("gint") ("GdkVisualType"))
     :c-arg-names (depth visual_type)
     :arguments (gint GdkVisualType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:132 <722> 
;; GdkVisual* gdk_visual_ref( GdkVisual* visual);
(ff:bind-c-function gdk_visual_ref
     :unconverted-entry-name "gdk_visual_ref"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("GdkVisual" "*"))
     :c-arg-names (visual)
     :arguments ((* GdkVisual))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:133 <723> 
;; void gdk_visual_unref( GdkVisual* visual);
(ff:bind-c-function gdk_visual_unref
     :unconverted-entry-name "gdk_visual_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkVisual" "*"))
     :c-arg-names (visual)
     :arguments ((* GdkVisual))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:135 <724> 
;; void gdk_query_depths( gint** depths, gint* count);
(ff:bind-c-function gdk_query_depths
     :unconverted-entry-name "gdk_query_depths"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint" "*" "*") ("gint" "*"))
     :c-arg-names (depths count)
     :arguments ((* (* gint)) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:137 <725> 
;; void gdk_query_visual_types( GdkVisualType** visual_types, gint* count);
(ff:bind-c-function gdk_query_visual_types
     :unconverted-entry-name "gdk_query_visual_types"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkVisualType" "*" "*") ("gint" "*"))
     :c-arg-names (visual_types count)
     :arguments ((* (* GdkVisualType)) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:140 <726> 
;; GList* gdk_list_visuals( void);
(ff:bind-c-function gdk_list_visuals
     :unconverted-entry-name "gdk_list_visuals"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:145 <727> 
;; GdkWindow* gdk_window_new( GdkWindow* parent, GdkWindowAttr* attributes,
;;              gint attributes_mask);
(ff:bind-c-function gdk_window_new
     :unconverted-entry-name "gdk_window_new"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("GdkWindow" "*") ("GdkWindowAttr" "*") ("gint"))
     :c-arg-names (parent attributes attributes_mask)
     :arguments ((* GdkWindow) (* GdkWindowAttr) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:149 <728> 
;; void gdk_window_destroy( GdkWindow* window);
(ff:bind-c-function gdk_window_destroy
     :unconverted-entry-name "gdk_window_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:150 <729> 
;; GdkWindow* gdk_window_ref( GdkWindow* window);
(ff:bind-c-function gdk_window_ref
     :unconverted-entry-name "gdk_window_ref"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:151 <730> 
;; void gdk_window_unref( GdkWindow* window);
(ff:bind-c-function gdk_window_unref
     :unconverted-entry-name "gdk_window_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:153 <731> 
;; GdkWindow* gdk_window_at_pointer( gint* win_x, gint* win_y);
(ff:bind-c-function gdk_window_at_pointer
     :unconverted-entry-name "gdk_window_at_pointer"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("gint" "*") ("gint" "*"))
     :c-arg-names (win_x win_y)
     :arguments ((* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:155 <732> 
;; void gdk_window_show( GdkWindow* window);
(ff:bind-c-function gdk_window_show
     :unconverted-entry-name "gdk_window_show"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:156 <733> 
;; void gdk_window_hide( GdkWindow* window);
(ff:bind-c-function gdk_window_hide
     :unconverted-entry-name "gdk_window_hide"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:157 <734> 
;; void gdk_window_withdraw( GdkWindow* window);
(ff:bind-c-function gdk_window_withdraw
     :unconverted-entry-name "gdk_window_withdraw"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:158 <735> 
;; void gdk_window_move( GdkWindow* window, gint x, gint y);
(ff:bind-c-function gdk_window_move
     :unconverted-entry-name "gdk_window_move"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint"))
     :c-arg-names (window x y)
     :arguments ((* GdkWindow) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:161 <736> 
;; void gdk_window_resize( GdkWindow* window, gint width, gint height);
(ff:bind-c-function gdk_window_resize
     :unconverted-entry-name "gdk_window_resize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint"))
     :c-arg-names (window width height)
     :arguments ((* GdkWindow) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:164 <737> 
;; void gdk_window_move_resize( GdkWindow* window, gint x, gint y, gint
;;   width,
;;              gint height);
(ff:bind-c-function gdk_window_move_resize
     :unconverted-entry-name "gdk_window_move_resize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (window x y width height)
     :arguments ((* GdkWindow) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:169 <738> 
;; void gdk_window_reparent( GdkWindow* window, GdkWindow* new_parent, gint
;;    x, gint y);
(ff:bind-c-function gdk_window_reparent
     :unconverted-entry-name "gdk_window_reparent"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkWindow" "*") ("gint") ("gint"))
     :c-arg-names (window new_parent x y)
     :arguments ((* GdkWindow) (* GdkWindow) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:173 <739> 
;; void gdk_window_clear( GdkWindow* window);
(ff:bind-c-function gdk_window_clear
     :unconverted-entry-name "gdk_window_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:174 <740> 
;; void gdk_window_clear_area( GdkWindow* window, gint x, gint y, gint
;;   width,
;;              gint height);
(ff:bind-c-function gdk_window_clear_area
     :unconverted-entry-name "gdk_window_clear_area"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (window x y width height)
     :arguments ((* GdkWindow) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:179 <741> 
;; void gdk_window_clear_area_e( GdkWindow* window, gint x, gint y, gint
;;    width, gint height);
(ff:bind-c-function gdk_window_clear_area_e
     :unconverted-entry-name "gdk_window_clear_area_e"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (window x y width height)
     :arguments ((* GdkWindow) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:184 <742> 
;; void gdk_window_copy_area( GdkWindow* window, GdkGC* gc, gint x, gint
;;    y, GdkWindow* source_window, gint source_x, gint source_y, gint
;;   width,
;;              gint height);
(ff:bind-c-function gdk_window_copy_area
     :unconverted-entry-name "gdk_window_copy_area"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("GdkWindow" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (window gc x y source_window source_x source_y width height)
     :arguments ((* GdkWindow) (* GdkGC) gint gint (* GdkWindow) gint gint
                 gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:193 <743> 
;; void gdk_window_raise( GdkWindow* window);
(ff:bind-c-function gdk_window_raise
     :unconverted-entry-name "gdk_window_raise"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:194 <744> 
;; void gdk_window_lower( GdkWindow* window);
(ff:bind-c-function gdk_window_lower
     :unconverted-entry-name "gdk_window_lower"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:196 <745> 
;; void gdk_window_set_user_data( GdkWindow* window, gpointer user_data);
(ff:bind-c-function gdk_window_set_user_data
     :unconverted-entry-name "gdk_window_set_user_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gpointer"))
     :c-arg-names (window user_data)
     :arguments ((* GdkWindow) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:198 <746> 
;; void gdk_window_set_override_redirect( GdkWindow* window, gboolean
;;   override_redirect
;;   );
(ff:bind-c-function gdk_window_set_override_redirect
     :unconverted-entry-name "gdk_window_set_override_redirect"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gboolean"))
     :c-arg-names (window override_redirect)
     :arguments ((* GdkWindow) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:201 <747> 
;; void gdk_window_add_filter( GdkWindow* window, GdkFilterFunc function,
;;              gpointer data);
(ff:bind-c-function gdk_window_add_filter
     :unconverted-entry-name "gdk_window_add_filter"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkFilterFunc") ("gpointer"))
     :c-arg-names (window function data)
     :arguments ((* GdkWindow) GdkFilterFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:204 <748> 
;; void gdk_window_remove_filter( GdkWindow* window, GdkFilterFunc
;;   function,
;;              gpointer data);
(ff:bind-c-function gdk_window_remove_filter
     :unconverted-entry-name "gdk_window_remove_filter"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkFilterFunc") ("gpointer"))
     :c-arg-names (window function data)
     :arguments ((* GdkWindow) GdkFilterFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:214 <749> 
;; void gdk_window_shape_combine_mask( GdkWindow* window, GdkBitmap*
;;   shape_mask,
;;              gint offset_x, gint offset_y);
(ff:bind-c-function gdk_window_shape_combine_mask
     :unconverted-entry-name "gdk_window_shape_combine_mask"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkBitmap" "*") ("gint") ("gint"))
     :c-arg-names (window shape_mask offset_x offset_y)
     :arguments ((* GdkWindow) (* GdkBitmap) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:225 <750> 
;; void gdk_window_set_child_shapes( GdkWindow* window);
(ff:bind-c-function gdk_window_set_child_shapes
     :unconverted-entry-name "gdk_window_set_child_shapes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:234 <751> 
;; void gdk_window_merge_child_shapes( GdkWindow* window);
(ff:bind-c-function gdk_window_merge_child_shapes
     :unconverted-entry-name "gdk_window_merge_child_shapes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:242 <752> 
;; gboolean gdk_window_is_visible( GdkWindow* window);
(ff:bind-c-function gdk_window_is_visible
     :unconverted-entry-name "gdk_window_is_visible"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:243 <753> 
;; gboolean gdk_window_is_viewable( GdkWindow* window);
(ff:bind-c-function gdk_window_is_viewable
     :unconverted-entry-name "gdk_window_is_viewable"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:248 <754> 
;; gboolean gdk_window_set_static_gravities( GdkWindow* window, gboolean
;;    use_static);
(ff:bind-c-function gdk_window_set_static_gravities
     :unconverted-entry-name "gdk_window_set_static_gravities"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkWindow" "*") ("gboolean"))
     :c-arg-names (window use_static)
     :arguments ((* GdkWindow) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:254 <755> 
;; void gdk_add_client_message_filter( GdkAtom message_type, GdkFilterFunc
;;    func, gpointer data);
(ff:bind-c-function gdk_add_client_message_filter
     :unconverted-entry-name "gdk_add_client_message_filter"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkAtom") ("GdkFilterFunc") ("gpointer"))
     :c-arg-names (message_type func data)
     :arguments (GdkAtom GdkFilterFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:260 <756> 
;; GdkDragContext* gdk_drag_context_new( void);
(ff:bind-c-function gdk_drag_context_new
     :unconverted-entry-name "gdk_drag_context_new"
     :c-return-type ("GdkDragContext" "*")
     :return-type (* GdkDragContext)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:261 <757> 
;; void gdk_drag_context_ref( GdkDragContext* context);
(ff:bind-c-function gdk_drag_context_ref
     :unconverted-entry-name "gdk_drag_context_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*"))
     :c-arg-names (context)
     :arguments ((* GdkDragContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:262 <758> 
;; void gdk_drag_context_unref( GdkDragContext* context);
(ff:bind-c-function gdk_drag_context_unref
     :unconverted-entry-name "gdk_drag_context_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*"))
     :c-arg-names (context)
     :arguments ((* GdkDragContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:266 <759> 
;; void gdk_drag_status( GdkDragContext* context, GdkDragAction action,
;;   guint32
;;    time);
(ff:bind-c-function gdk_drag_status
     :unconverted-entry-name "gdk_drag_status"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("GdkDragAction") ("guint32"))
     :c-arg-names (context action time)
     :arguments ((* GdkDragContext) GdkDragAction guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:269 <760> 
;; void gdk_drop_reply( GdkDragContext* context, gboolean ok, guint32
;;   time);
(ff:bind-c-function gdk_drop_reply
     :unconverted-entry-name "gdk_drop_reply"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("gboolean") ("guint32"))
     :c-arg-names (context ok time)
     :arguments ((* GdkDragContext) gboolean guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:272 <761> 
;; void gdk_drop_finish( GdkDragContext* context, gboolean success, guint32
;;    time);
(ff:bind-c-function gdk_drop_finish
     :unconverted-entry-name "gdk_drop_finish"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("gboolean") ("guint32"))
     :c-arg-names (context success time)
     :arguments ((* GdkDragContext) gboolean guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:275 <762> 
;; GdkAtom gdk_drag_get_selection( GdkDragContext* context);
(ff:bind-c-function gdk_drag_get_selection
     :unconverted-entry-name "gdk_drag_get_selection"
     :c-return-type ("GdkAtom")
     :return-type GdkAtom
     :c-arg-types (("GdkDragContext" "*"))
     :c-arg-names (context)
     :arguments ((* GdkDragContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:279 <763> 
;; GdkDragContext* gdk_drag_begin( GdkWindow* window, GList* targets);
(ff:bind-c-function gdk_drag_begin
     :unconverted-entry-name "gdk_drag_begin"
     :c-return-type ("GdkDragContext" "*")
     :return-type (* GdkDragContext)
     :c-arg-types (("GdkWindow" "*") ("GList" "*"))
     :c-arg-names (window targets)
     :arguments ((* GdkWindow) (* GList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:281 <764> 
;; guint32 gdk_drag_get_protocol( guint32 xid, GdkDragProtocol* protocol);
(ff:bind-c-function gdk_drag_get_protocol
     :unconverted-entry-name "gdk_drag_get_protocol"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types (("guint32") ("GdkDragProtocol" "*"))
     :c-arg-names (xid protocol)
     :arguments (guint32 (* GdkDragProtocol))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:283 <765> 
;; void gdk_drag_find_window( GdkDragContext* context, GdkWindow*
;;   drag_window,
;;              gint x_root, gint y_root, GdkWindow** dest_window,
;;   GdkDragProtocol* protocol
;;   );
(ff:bind-c-function gdk_drag_find_window
     :unconverted-entry-name "gdk_drag_find_window"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("GdkWindow" "*") ("gint") ("gint")
                   ("GdkWindow" "*" "*") ("GdkDragProtocol" "*"))
     :c-arg-names (context drag_window x_root y_root dest_window protocol)
     :arguments ((* GdkDragContext) (* GdkWindow) gint gint (* (* GdkWindow))
                 (* GdkDragProtocol))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:289 <766> 
;; gboolean gdk_drag_motion( GdkDragContext* context, GdkWindow*
;;   dest_window,
;;              GdkDragProtocol protocol, gint x_root, gint y_root,
;;   GdkDragAction suggested_action,
;;              GdkDragAction possible_actions, guint32 time);
(ff:bind-c-function gdk_drag_motion
     :unconverted-entry-name "gdk_drag_motion"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkDragContext" "*") ("GdkWindow" "*")
                   ("GdkDragProtocol") ("gint") ("gint") ("GdkDragAction")
                   ("GdkDragAction") ("guint32"))
     :c-arg-names (context dest_window protocol x_root y_root suggested_action
                   possible_actions time)
     :arguments ((* GdkDragContext) (* GdkWindow) GdkDragProtocol gint gint
                 GdkDragAction GdkDragAction guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:297 <767> 
;; void gdk_drag_drop( GdkDragContext* context, guint32 time);
(ff:bind-c-function gdk_drag_drop
     :unconverted-entry-name "gdk_drag_drop"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("guint32"))
     :c-arg-names (context time)
     :arguments ((* GdkDragContext) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:299 <768> 
;; void gdk_drag_abort( GdkDragContext* context, guint32 time);
(ff:bind-c-function gdk_drag_abort
     :unconverted-entry-name "gdk_drag_abort"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDragContext" "*") ("guint32"))
     :c-arg-names (context time)
     :arguments ((* GdkDragContext) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:304 <769> 
;; void gdk_window_set_hints( GdkWindow* window, gint x, gint y, gint
;;   min_width,
;;              gint min_height, gint max_width, gint max_height, gint
;;   flags);
(ff:bind-c-function gdk_window_set_hints
     :unconverted-entry-name "gdk_window_set_hints"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint") ("gint") ("gint")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (window x y min_width min_height max_width max_height flags)
     :arguments ((* GdkWindow) gint gint gint gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:312 <770> 
;; void gdk_window_set_geometry_hints( GdkWindow* window, GdkGeometry*
;;   geometry,
;;              GdkWindowHints flags);
(ff:bind-c-function gdk_window_set_geometry_hints
     :unconverted-entry-name "gdk_window_set_geometry_hints"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkGeometry" "*") ("GdkWindowHints"))
     :c-arg-names (window geometry flags)
     :arguments ((* GdkWindow) (* GdkGeometry) GdkWindowHints)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:315 <771> 
;; void gdk_set_sm_client_id( const gchar* sm_client_id);
(ff:bind-c-function gdk_set_sm_client_id
     :unconverted-entry-name "gdk_set_sm_client_id"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (sm_client_id)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:318 <772> 
;; void gdk_window_set_title( GdkWindow* window, const gchar* title);
(ff:bind-c-function gdk_window_set_title
     :unconverted-entry-name "gdk_window_set_title"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("const" "gchar" "*"))
     :c-arg-names (window title)
     :arguments ((* GdkWindow) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:320 <773> 
;; void gdk_window_set_role( GdkWindow* window, const gchar* role);
(ff:bind-c-function gdk_window_set_role
     :unconverted-entry-name "gdk_window_set_role"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("const" "gchar" "*"))
     :c-arg-names (window role)
     :arguments ((* GdkWindow) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:322 <774> 
;; void gdk_window_set_transient_for( GdkWindow* window, GdkWindow*
;;   leader);
(ff:bind-c-function gdk_window_set_transient_for
     :unconverted-entry-name "gdk_window_set_transient_for"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkWindow" "*"))
     :c-arg-names (window leader)
     :arguments ((* GdkWindow) (* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:324 <775> 
;; void gdk_window_set_background( GdkWindow* window, GdkColor* color);
(ff:bind-c-function gdk_window_set_background
     :unconverted-entry-name "gdk_window_set_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkColor" "*"))
     :c-arg-names (window color)
     :arguments ((* GdkWindow) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:326 <776> 
;; void gdk_window_set_back_pixmap( GdkWindow* window, GdkPixmap* pixmap,
;;              gboolean parent_relative);
(ff:bind-c-function gdk_window_set_back_pixmap
     :unconverted-entry-name "gdk_window_set_back_pixmap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkPixmap" "*") ("gboolean"))
     :c-arg-names (window pixmap parent_relative)
     :arguments ((* GdkWindow) (* GdkPixmap) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:329 <777> 
;; void gdk_window_set_cursor( GdkWindow* window, GdkCursor* cursor);
(ff:bind-c-function gdk_window_set_cursor
     :unconverted-entry-name "gdk_window_set_cursor"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkCursor" "*"))
     :c-arg-names (window cursor)
     :arguments ((* GdkWindow) (* GdkCursor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:331 <778> 
;; void gdk_window_set_colormap( GdkWindow* window, GdkColormap* colormap);
(ff:bind-c-function gdk_window_set_colormap
     :unconverted-entry-name "gdk_window_set_colormap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkColormap" "*"))
     :c-arg-names (window colormap)
     :arguments ((* GdkWindow) (* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:333 <779> 
;; void gdk_window_get_user_data( GdkWindow* window, gpointer* data);
(ff:bind-c-function gdk_window_get_user_data
     :unconverted-entry-name "gdk_window_get_user_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gpointer" "*"))
     :c-arg-names (window data)
     :arguments ((* GdkWindow) (* gpointer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:335 <780> 
;; void gdk_window_get_geometry( GdkWindow* window, gint* x, gint* y, gint
;;   * width, gint* height, gint* depth);
(ff:bind-c-function gdk_window_get_geometry
     :unconverted-entry-name "gdk_window_get_geometry"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint" "*") ("gint" "*") ("gint" "*")
                   ("gint" "*") ("gint" "*"))
     :c-arg-names (window x y width height depth)
     :arguments ((* GdkWindow) (* gint) (* gint) (* gint) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:341 <781> 
;; void gdk_window_get_position( GdkWindow* window, gint* x, gint* y);
(ff:bind-c-function gdk_window_get_position
     :unconverted-entry-name "gdk_window_get_position"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (window x y)
     :arguments ((* GdkWindow) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:344 <782> 
;; void gdk_window_get_size( GdkWindow* window, gint* width, gint* height);
(ff:bind-c-function gdk_window_get_size
     :unconverted-entry-name "gdk_window_get_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (window width height)
     :arguments ((* GdkWindow) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:347 <783> 
;; GdkVisual* gdk_window_get_visual( GdkWindow* window);
(ff:bind-c-function gdk_window_get_visual
     :unconverted-entry-name "gdk_window_get_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:348 <784> 
;; GdkColormap* gdk_window_get_colormap( GdkWindow* window);
(ff:bind-c-function gdk_window_get_colormap
     :unconverted-entry-name "gdk_window_get_colormap"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:349 <785> 
;; GdkWindowType gdk_window_get_type( GdkWindow* window);
(ff:bind-c-function gdk_window_get_type
     :unconverted-entry-name "gdk_window_get_type"
     :c-return-type ("GdkWindowType")
     :return-type GdkWindowType
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:350 <786> 
;; gint gdk_window_get_origin( GdkWindow* window, gint* x, gint* y);
(ff:bind-c-function gdk_window_get_origin
     :unconverted-entry-name "gdk_window_get_origin"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkWindow" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (window x y)
     :arguments ((* GdkWindow) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:353 <787> 
;; gboolean gdk_window_get_deskrelative_origin( GdkWindow* window, gint*
;;    x, gint* y);
(ff:bind-c-function gdk_window_get_deskrelative_origin
     :unconverted-entry-name "gdk_window_get_deskrelative_origin"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkWindow" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (window x y)
     :arguments ((* GdkWindow) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:356 <788> 
;; void gdk_window_get_root_origin( GdkWindow* window, gint* x, gint* y);
(ff:bind-c-function gdk_window_get_root_origin
     :unconverted-entry-name "gdk_window_get_root_origin"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (window x y)
     :arguments ((* GdkWindow) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:359 <789> 
;; GdkWindow* gdk_window_get_pointer( GdkWindow* window, gint* x, gint* y,
;;              GdkModifierType* mask);
(ff:bind-c-function gdk_window_get_pointer
     :unconverted-entry-name "gdk_window_get_pointer"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("GdkWindow" "*") ("gint" "*") ("gint" "*")
                   ("GdkModifierType" "*"))
     :c-arg-names (window x y mask)
     :arguments ((* GdkWindow) (* gint) (* gint) (* GdkModifierType))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:363 <790> 
;; GdkWindow* gdk_window_get_parent( GdkWindow* window);
(ff:bind-c-function gdk_window_get_parent
     :unconverted-entry-name "gdk_window_get_parent"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:364 <791> 
;; GdkWindow* gdk_window_get_toplevel( GdkWindow* window);
(ff:bind-c-function gdk_window_get_toplevel
     :unconverted-entry-name "gdk_window_get_toplevel"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:365 <792> 
;; GList* gdk_window_get_children( GdkWindow* window);
(ff:bind-c-function gdk_window_get_children
     :unconverted-entry-name "gdk_window_get_children"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:366 <793> 
;; GdkEventMask gdk_window_get_events( GdkWindow* window);
(ff:bind-c-function gdk_window_get_events
     :unconverted-entry-name "gdk_window_get_events"
     :c-return-type ("GdkEventMask")
     :return-type GdkEventMask
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:367 <794> 
;; void gdk_window_set_events( GdkWindow* window, GdkEventMask event_mask);
(ff:bind-c-function gdk_window_set_events
     :unconverted-entry-name "gdk_window_set_events"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkEventMask"))
     :c-arg-names (window event_mask)
     :arguments ((* GdkWindow) GdkEventMask)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:370 <795> 
;; void gdk_window_set_icon( GdkWindow* window, GdkWindow* icon_window,
;;   GdkPixmap
;;   * pixmap, GdkBitmap* mask);
(ff:bind-c-function gdk_window_set_icon
     :unconverted-entry-name "gdk_window_set_icon"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkWindow" "*") ("GdkPixmap" "*")
                   ("GdkBitmap" "*"))
     :c-arg-names (window icon_window pixmap mask)
     :arguments ((* GdkWindow) (* GdkWindow) (* GdkPixmap) (* GdkBitmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:374 <796> 
;; void gdk_window_set_icon_name( GdkWindow* window, const gchar* name);
(ff:bind-c-function gdk_window_set_icon_name
     :unconverted-entry-name "gdk_window_set_icon_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("const" "gchar" "*"))
     :c-arg-names (window name)
     :arguments ((* GdkWindow) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:376 <797> 
;; void gdk_window_set_group( GdkWindow* window, GdkWindow* leader);
(ff:bind-c-function gdk_window_set_group
     :unconverted-entry-name "gdk_window_set_group"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkWindow" "*"))
     :c-arg-names (window leader)
     :arguments ((* GdkWindow) (* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:378 <798> 
;; void gdk_window_set_decorations( GdkWindow* window, GdkWMDecoration
;;   decorations
;;   );
(ff:bind-c-function gdk_window_set_decorations
     :unconverted-entry-name "gdk_window_set_decorations"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkWMDecoration"))
     :c-arg-names (window decorations)
     :arguments ((* GdkWindow) GdkWMDecoration)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:380 <799> 
;; void gdk_window_set_functions( GdkWindow* window, GdkWMFunction
;;   functions
;;   );
(ff:bind-c-function gdk_window_set_functions
     :unconverted-entry-name "gdk_window_set_functions"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkWMFunction"))
     :c-arg-names (window functions)
     :arguments ((* GdkWindow) GdkWMFunction)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:382 <800> 
;; GList* gdk_window_get_toplevels( void);
(ff:bind-c-function gdk_window_get_toplevels
     :unconverted-entry-name "gdk_window_get_toplevels"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:384 <801> 
;; void gdk_window_register_dnd( GdkWindow* window);
(ff:bind-c-function gdk_window_register_dnd
     :unconverted-entry-name "gdk_window_register_dnd"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:386 <802> 
;; void gdk_drawable_set_data( GdkDrawable* drawable, const gchar* key,
;;   gpointer
;;    data, GDestroyNotify destroy_func);
(ff:bind-c-function gdk_drawable_set_data
     :unconverted-entry-name "gdk_drawable_set_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("const" "gchar" "*") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (drawable key data destroy_func)
     :arguments ((* GdkDrawable) (* gchar) gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:394 <803> 
;; GdkCursor* gdk_cursor_new( GdkCursorType cursor_type);
(ff:bind-c-function gdk_cursor_new
     :unconverted-entry-name "gdk_cursor_new"
     :c-return-type ("GdkCursor" "*")
     :return-type (* GdkCursor)
     :c-arg-types (("GdkCursorType"))
     :c-arg-names (cursor_type)
     :arguments (GdkCursorType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:395 <804> 
;; GdkCursor* gdk_cursor_new_from_pixmap( GdkPixmap* source, GdkPixmap*
;;   mask,
;;              GdkColor* fg, GdkColor* bg, gint x, gint y);
(ff:bind-c-function gdk_cursor_new_from_pixmap
     :unconverted-entry-name "gdk_cursor_new_from_pixmap"
     :c-return-type ("GdkCursor" "*")
     :return-type (* GdkCursor)
     :c-arg-types (("GdkPixmap" "*") ("GdkPixmap" "*") ("GdkColor" "*")
                   ("GdkColor" "*") ("gint") ("gint"))
     :c-arg-names (source mask fg bg x y)
     :arguments ((* GdkPixmap) (* GdkPixmap) (* GdkColor) (* GdkColor) gint
                 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:401 <805> 
;; void gdk_cursor_destroy( GdkCursor* cursor);
(ff:bind-c-function gdk_cursor_destroy
     :unconverted-entry-name "gdk_cursor_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkCursor" "*"))
     :c-arg-names (cursor)
     :arguments ((* GdkCursor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:406 <806> 
;; GdkGC* gdk_gc_new( GdkWindow* window);
(ff:bind-c-function gdk_gc_new
     :unconverted-entry-name "gdk_gc_new"
     :c-return-type ("GdkGC" "*")
     :return-type (* GdkGC)
     :c-arg-types (("GdkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:407 <807> 
;; GdkGC* gdk_gc_new_with_values( GdkWindow* window, GdkGCValues* values,
;;              GdkGCValuesMask values_mask);
(ff:bind-c-function gdk_gc_new_with_values
     :unconverted-entry-name "gdk_gc_new_with_values"
     :c-return-type ("GdkGC" "*")
     :return-type (* GdkGC)
     :c-arg-types (("GdkWindow" "*") ("GdkGCValues" "*") ("GdkGCValuesMask"))
     :c-arg-names (window values values_mask)
     :arguments ((* GdkWindow) (* GdkGCValues) GdkGCValuesMask)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:410 <808> 
;; GdkGC* gdk_gc_ref( GdkGC* gc);
(ff:bind-c-function gdk_gc_ref
     :unconverted-entry-name "gdk_gc_ref"
     :c-return-type ("GdkGC" "*")
     :return-type (* GdkGC)
     :c-arg-types (("GdkGC" "*"))
     :c-arg-names (gc)
     :arguments ((* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:411 <809> 
;; void gdk_gc_unref( GdkGC* gc);
(ff:bind-c-function gdk_gc_unref
     :unconverted-entry-name "gdk_gc_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*"))
     :c-arg-names (gc)
     :arguments ((* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:412 <810> 
;; void gdk_gc_destroy( GdkGC* gc);
(ff:bind-c-function gdk_gc_destroy
     :unconverted-entry-name "gdk_gc_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*"))
     :c-arg-names (gc)
     :arguments ((* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:413 <811> 
;; void gdk_gc_get_values( GdkGC* gc, GdkGCValues* values);
(ff:bind-c-function gdk_gc_get_values
     :unconverted-entry-name "gdk_gc_get_values"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkGCValues" "*"))
     :c-arg-names (gc values)
     :arguments ((* GdkGC) (* GdkGCValues))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:415 <812> 
;; void gdk_gc_set_foreground( GdkGC* gc, GdkColor* color);
(ff:bind-c-function gdk_gc_set_foreground
     :unconverted-entry-name "gdk_gc_set_foreground"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkColor" "*"))
     :c-arg-names (gc color)
     :arguments ((* GdkGC) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:417 <813> 
;; void gdk_gc_set_background( GdkGC* gc, GdkColor* color);
(ff:bind-c-function gdk_gc_set_background
     :unconverted-entry-name "gdk_gc_set_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkColor" "*"))
     :c-arg-names (gc color)
     :arguments ((* GdkGC) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:419 <814> 
;; void gdk_gc_set_font( GdkGC* gc, GdkFont* font);
(ff:bind-c-function gdk_gc_set_font
     :unconverted-entry-name "gdk_gc_set_font"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkFont" "*"))
     :c-arg-names (gc font)
     :arguments ((* GdkGC) (* GdkFont))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:421 <815> 
;; void gdk_gc_set_function( GdkGC* gc, GdkFunction function);
(ff:bind-c-function gdk_gc_set_function
     :unconverted-entry-name "gdk_gc_set_function"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkFunction"))
     :c-arg-names (gc function)
     :arguments ((* GdkGC) GdkFunction)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:423 <816> 
;; void gdk_gc_set_fill( GdkGC* gc, GdkFill fill);
(ff:bind-c-function gdk_gc_set_fill
     :unconverted-entry-name "gdk_gc_set_fill"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkFill"))
     :c-arg-names (gc fill)
     :arguments ((* GdkGC) GdkFill)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:425 <817> 
;; void gdk_gc_set_tile( GdkGC* gc, GdkPixmap* tile);
(ff:bind-c-function gdk_gc_set_tile
     :unconverted-entry-name "gdk_gc_set_tile"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkPixmap" "*"))
     :c-arg-names (gc tile)
     :arguments ((* GdkGC) (* GdkPixmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:427 <818> 
;; void gdk_gc_set_stipple( GdkGC* gc, GdkPixmap* stipple);
(ff:bind-c-function gdk_gc_set_stipple
     :unconverted-entry-name "gdk_gc_set_stipple"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkPixmap" "*"))
     :c-arg-names (gc stipple)
     :arguments ((* GdkGC) (* GdkPixmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:429 <819> 
;; void gdk_gc_set_ts_origin( GdkGC* gc, gint x, gint y);
(ff:bind-c-function gdk_gc_set_ts_origin
     :unconverted-entry-name "gdk_gc_set_ts_origin"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("gint"))
     :c-arg-names (gc x y)
     :arguments ((* GdkGC) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:432 <820> 
;; void gdk_gc_set_clip_origin( GdkGC* gc, gint x, gint y);
(ff:bind-c-function gdk_gc_set_clip_origin
     :unconverted-entry-name "gdk_gc_set_clip_origin"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("gint"))
     :c-arg-names (gc x y)
     :arguments ((* GdkGC) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:435 <821> 
;; void gdk_gc_set_clip_mask( GdkGC* gc, GdkBitmap* mask);
(ff:bind-c-function gdk_gc_set_clip_mask
     :unconverted-entry-name "gdk_gc_set_clip_mask"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkBitmap" "*"))
     :c-arg-names (gc mask)
     :arguments ((* GdkGC) (* GdkBitmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:437 <822> 
;; void gdk_gc_set_clip_rectangle( GdkGC* gc, GdkRectangle* rectangle);
(ff:bind-c-function gdk_gc_set_clip_rectangle
     :unconverted-entry-name "gdk_gc_set_clip_rectangle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkRectangle" "*"))
     :c-arg-names (gc rectangle)
     :arguments ((* GdkGC) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:439 <823> 
;; void gdk_gc_set_clip_region( GdkGC* gc, GdkRegion* region);
(ff:bind-c-function gdk_gc_set_clip_region
     :unconverted-entry-name "gdk_gc_set_clip_region"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkRegion" "*"))
     :c-arg-names (gc region)
     :arguments ((* GdkGC) (* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:441 <824> 
;; void gdk_gc_set_subwindow( GdkGC* gc, GdkSubwindowMode mode);
(ff:bind-c-function gdk_gc_set_subwindow
     :unconverted-entry-name "gdk_gc_set_subwindow"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkSubwindowMode"))
     :c-arg-names (gc mode)
     :arguments ((* GdkGC) GdkSubwindowMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:443 <825> 
;; void gdk_gc_set_exposures( GdkGC* gc, gboolean exposures);
(ff:bind-c-function gdk_gc_set_exposures
     :unconverted-entry-name "gdk_gc_set_exposures"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gboolean"))
     :c-arg-names (gc exposures)
     :arguments ((* GdkGC) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:445 <826> 
;; void gdk_gc_set_line_attributes( GdkGC* gc, gint line_width,
;;   GdkLineStyle
;;    line_style, GdkCapStyle cap_style, GdkJoinStyle join_style);
(ff:bind-c-function gdk_gc_set_line_attributes
     :unconverted-entry-name "gdk_gc_set_line_attributes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("GdkLineStyle") ("GdkCapStyle")
                   ("GdkJoinStyle"))
     :c-arg-names (gc line_width line_style cap_style join_style)
     :arguments ((* GdkGC) gint GdkLineStyle GdkCapStyle GdkJoinStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:450 <827> 
;; void gdk_gc_set_dashes( GdkGC* gc, gint dash_offset, gint8 dash_list[
;;   ], gint n);
(ff:bind-c-function gdk_gc_set_dashes
     :unconverted-entry-name "gdk_gc_set_dashes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("gint") ("gint8" "[" "]") ("gint"))
     :c-arg-names (gc dash_offset dash_list n)
     :arguments ((* GdkGC) gint (* gint8) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:454 <828> 
;; void gdk_gc_copy( GdkGC* dst_gc, GdkGC* src_gc);
(ff:bind-c-function gdk_gc_copy
     :unconverted-entry-name "gdk_gc_copy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("GdkGC" "*"))
     :c-arg-names (dst_gc src_gc)
     :arguments ((* GdkGC) (* GdkGC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:460 <829> 
;; GdkPixmap* gdk_pixmap_new( GdkWindow* window, gint width, gint height,
;;              gint depth);
(ff:bind-c-function gdk_pixmap_new
     :unconverted-entry-name "gdk_pixmap_new"
     :c-return-type ("GdkPixmap" "*")
     :return-type (* GdkPixmap)
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint") ("gint"))
     :c-arg-names (window width height depth)
     :arguments ((* GdkWindow) gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:464 <830> 
;; GdkBitmap* gdk_bitmap_create_from_data( GdkWindow* window, const gchar
;;   * data, gint width, gint height);
(ff:bind-c-function gdk_bitmap_create_from_data
     :unconverted-entry-name "gdk_bitmap_create_from_data"
     :c-return-type ("GdkBitmap" "*")
     :return-type (* GdkBitmap)
     :c-arg-types (("GdkWindow" "*") ("const" "gchar" "*") ("gint") ("gint"))
     :c-arg-names (window data width height)
     :arguments ((* GdkWindow) (* gchar) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:468 <831> 
;; GdkPixmap* gdk_pixmap_create_from_data( GdkWindow* window, const gchar
;;   * data, gint width, gint height, gint depth, GdkColor* fg, GdkColor*
;;   bg
;;   );
(ff:bind-c-function gdk_pixmap_create_from_data
     :unconverted-entry-name "gdk_pixmap_create_from_data"
     :c-return-type ("GdkPixmap" "*")
     :return-type (* GdkPixmap)
     :c-arg-types (("GdkWindow" "*") ("const" "gchar" "*") ("gint") ("gint")
                   ("gint") ("GdkColor" "*") ("GdkColor" "*"))
     :c-arg-names (window data width height depth fg bg)
     :arguments ((* GdkWindow) (* gchar) gint gint gint (* GdkColor)
                 (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:475 <832> 
;; GdkPixmap* gdk_pixmap_create_from_xpm( GdkWindow* window, GdkBitmap**
;;    mask, GdkColor* transparent_color, const gchar* filename);
(ff:bind-c-function gdk_pixmap_create_from_xpm
     :unconverted-entry-name "gdk_pixmap_create_from_xpm"
     :c-return-type ("GdkPixmap" "*")
     :return-type (* GdkPixmap)
     :c-arg-types (("GdkWindow" "*") ("GdkBitmap" "*" "*") ("GdkColor" "*")
                   ("const" "gchar" "*"))
     :c-arg-names (window mask transparent_color filename)
     :arguments ((* GdkWindow) (* (* GdkBitmap)) (* GdkColor) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:479 <833> 
;; GdkPixmap* gdk_pixmap_colormap_create_from_xpm( GdkWindow* window,
;;   GdkColormap
;;   * colormap, GdkBitmap** mask, GdkColor* transparent_color, const gchar
;;   * filename);
(ff:bind-c-function gdk_pixmap_colormap_create_from_xpm
     :unconverted-entry-name "gdk_pixmap_colormap_create_from_xpm"
     :c-return-type ("GdkPixmap" "*")
     :return-type (* GdkPixmap)
     :c-arg-types (("GdkWindow" "*") ("GdkColormap" "*") ("GdkBitmap" "*" "*")
                   ("GdkColor" "*") ("const" "gchar" "*"))
     :c-arg-names (window colormap mask transparent_color filename)
     :arguments ((* GdkWindow) (* GdkColormap) (* (* GdkBitmap)) (* GdkColor)
                 (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:485 <834> 
;; GdkPixmap* gdk_pixmap_create_from_xpm_d( GdkWindow* window, GdkBitmap
;;   ** mask, GdkColor* transparent_color, gchar** data);
(ff:bind-c-function gdk_pixmap_create_from_xpm_d
     :unconverted-entry-name "gdk_pixmap_create_from_xpm_d"
     :c-return-type ("GdkPixmap" "*")
     :return-type (* GdkPixmap)
     :c-arg-types (("GdkWindow" "*") ("GdkBitmap" "*" "*") ("GdkColor" "*")
                   ("gchar" "*" "*"))
     :c-arg-names (window mask transparent_color data)
     :arguments ((* GdkWindow) (* (* GdkBitmap)) (* GdkColor) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:489 <835> 
;; GdkPixmap* gdk_pixmap_colormap_create_from_xpm_d( GdkWindow* window,
;;   GdkColormap
;;   * colormap, GdkBitmap** mask, GdkColor* transparent_color, gchar**
;;   data
;;   );
(ff:bind-c-function gdk_pixmap_colormap_create_from_xpm_d
     :unconverted-entry-name "gdk_pixmap_colormap_create_from_xpm_d"
     :c-return-type ("GdkPixmap" "*")
     :return-type (* GdkPixmap)
     :c-arg-types (("GdkWindow" "*") ("GdkColormap" "*") ("GdkBitmap" "*" "*")
                   ("GdkColor" "*") ("gchar" "*" "*"))
     :c-arg-names (window colormap mask transparent_color data)
     :arguments ((* GdkWindow) (* GdkColormap) (* (* GdkBitmap)) (* GdkColor)
                 (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:495 <836> 
;; GdkPixmap* gdk_pixmap_ref( GdkPixmap* pixmap);
(ff:bind-c-function gdk_pixmap_ref
     :unconverted-entry-name "gdk_pixmap_ref"
     :c-return-type ("GdkPixmap" "*")
     :return-type (* GdkPixmap)
     :c-arg-types (("GdkPixmap" "*"))
     :c-arg-names (pixmap)
     :arguments ((* GdkPixmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:496 <837> 
;; void gdk_pixmap_unref( GdkPixmap* pixmap);
(ff:bind-c-function gdk_pixmap_unref
     :unconverted-entry-name "gdk_pixmap_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkPixmap" "*"))
     :c-arg-names (pixmap)
     :arguments ((* GdkPixmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:498 <838> 
;; GdkBitmap* gdk_bitmap_ref( GdkBitmap* pixmap);
(ff:bind-c-function gdk_bitmap_ref
     :unconverted-entry-name "gdk_bitmap_ref"
     :c-return-type ("GdkBitmap" "*")
     :return-type (* GdkBitmap)
     :c-arg-types (("GdkBitmap" "*"))
     :c-arg-names (pixmap)
     :arguments ((* GdkBitmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:499 <839> 
;; void gdk_bitmap_unref( GdkBitmap* pixmap);
(ff:bind-c-function gdk_bitmap_unref
     :unconverted-entry-name "gdk_bitmap_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkBitmap" "*"))
     :c-arg-names (pixmap)
     :arguments ((* GdkBitmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:504 <840> 
;; GdkImage* gdk_image_new_bitmap( GdkVisual* visual, gpointer data, gint
;;    width, gint height);
(ff:bind-c-function gdk_image_new_bitmap
     :unconverted-entry-name "gdk_image_new_bitmap"
     :c-return-type ("GdkImage" "*")
     :return-type (* GdkImage)
     :c-arg-types (("GdkVisual" "*") ("gpointer") ("gint") ("gint"))
     :c-arg-names (visual data width height)
     :arguments ((* GdkVisual) gpointer gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:508 <841> 
;; GdkImage* gdk_image_new( GdkImageType type, GdkVisual* visual, gint
;;   width,
;;              gint height);
(ff:bind-c-function gdk_image_new
     :unconverted-entry-name "gdk_image_new"
     :c-return-type ("GdkImage" "*")
     :return-type (* GdkImage)
     :c-arg-types (("GdkImageType") ("GdkVisual" "*") ("gint") ("gint"))
     :c-arg-names (type visual width height)
     :arguments (GdkImageType (* GdkVisual) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:512 <842> 
;; GdkImage* gdk_image_get( GdkWindow* window, gint x, gint y, gint width,
;;              gint height);
(ff:bind-c-function gdk_image_get
     :unconverted-entry-name "gdk_image_get"
     :c-return-type ("GdkImage" "*")
     :return-type (* GdkImage)
     :c-arg-types (("GdkWindow" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (window x y width height)
     :arguments ((* GdkWindow) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:517 <843> 
;; void gdk_image_put_pixel( GdkImage* image, gint x, gint y, guint32 pixel
;;   );
(ff:bind-c-function gdk_image_put_pixel
     :unconverted-entry-name "gdk_image_put_pixel"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkImage" "*") ("gint") ("gint") ("guint32"))
     :c-arg-names (image x y pixel)
     :arguments ((* GdkImage) gint gint guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:521 <844> 
;; guint32 gdk_image_get_pixel( GdkImage* image, gint x, gint y);
(ff:bind-c-function gdk_image_get_pixel
     :unconverted-entry-name "gdk_image_get_pixel"
     :c-return-type ("guint32")
     :return-type guint32
     :c-arg-types (("GdkImage" "*") ("gint") ("gint"))
     :c-arg-names (image x y)
     :arguments ((* GdkImage) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:524 <845> 
;; void gdk_image_destroy( GdkImage* image);
(ff:bind-c-function gdk_image_destroy
     :unconverted-entry-name "gdk_image_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkImage" "*"))
     :c-arg-names (image)
     :arguments ((* GdkImage))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:529 <846> 
;; GdkColormap* gdk_colormap_new( GdkVisual* visual, gboolean allocate);
(ff:bind-c-function gdk_colormap_new
     :unconverted-entry-name "gdk_colormap_new"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GdkVisual" "*") ("gboolean"))
     :c-arg-names (visual allocate)
     :arguments ((* GdkVisual) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:531 <847> 
;; GdkColormap* gdk_colormap_ref( GdkColormap* cmap);
(ff:bind-c-function gdk_colormap_ref
     :unconverted-entry-name "gdk_colormap_ref"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (cmap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:532 <848> 
;; void gdk_colormap_unref( GdkColormap* cmap);
(ff:bind-c-function gdk_colormap_unref
     :unconverted-entry-name "gdk_colormap_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (cmap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:534 <849> 
;; GdkColormap* gdk_colormap_get_system( void);
(ff:bind-c-function gdk_colormap_get_system
     :unconverted-entry-name "gdk_colormap_get_system"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:535 <850> 
;; gint gdk_colormap_get_system_size( void);
(ff:bind-c-function gdk_colormap_get_system_size
     :unconverted-entry-name "gdk_colormap_get_system_size"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:537 <851> 
;; void gdk_colormap_change( GdkColormap* colormap, gint ncolors);
(ff:bind-c-function gdk_colormap_change
     :unconverted-entry-name "gdk_colormap_change"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("gint"))
     :c-arg-names (colormap ncolors)
     :arguments ((* GdkColormap) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:540 <852> 
;; void gdk_colormap_sync( GdkColormap* colormap, gboolean force);
(ff:bind-c-function gdk_colormap_sync
     :unconverted-entry-name "gdk_colormap_sync"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("gboolean"))
     :c-arg-names (colormap force)
     :arguments ((* GdkColormap) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:542 <853> 
;; gint gdk_colormap_alloc_colors( GdkColormap* colormap, GdkColor* colors,
;;              gint ncolors, gboolean writeable, gboolean best_match,
;;   gboolean* success
;;   );
(ff:bind-c-function gdk_colormap_alloc_colors
     :unconverted-entry-name "gdk_colormap_alloc_colors"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gint") ("gboolean")
                   ("gboolean") ("gboolean" "*"))
     :c-arg-names (colormap colors ncolors writeable best_match success)
     :arguments ((* GdkColormap) (* GdkColor) gint gboolean gboolean
                 (* gboolean))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:548 <854> 
;; gboolean gdk_colormap_alloc_color( GdkColormap* colormap, GdkColor*
;;   color,
;;              gboolean writeable, gboolean best_match);
(ff:bind-c-function gdk_colormap_alloc_color
     :unconverted-entry-name "gdk_colormap_alloc_color"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gboolean")
                   ("gboolean"))
     :c-arg-names (colormap color writeable best_match)
     :arguments ((* GdkColormap) (* GdkColor) gboolean gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:552 <855> 
;; void gdk_colormap_free_colors( GdkColormap* colormap, GdkColor* colors,
;;              gint ncolors);
(ff:bind-c-function gdk_colormap_free_colors
     :unconverted-entry-name "gdk_colormap_free_colors"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gint"))
     :c-arg-names (colormap colors ncolors)
     :arguments ((* GdkColormap) (* GdkColor) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:556 <856> 
;; GdkVisual* gdk_colormap_get_visual( GdkColormap* colormap);
(ff:bind-c-function gdk_colormap_get_visual
     :unconverted-entry-name "gdk_colormap_get_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (colormap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:558 <857> 
;; GdkColor* gdk_color_copy( const GdkColor* color);
(ff:bind-c-function gdk_color_copy
     :unconverted-entry-name "gdk_color_copy"
     :c-return-type ("GdkColor" "*")
     :return-type (* GdkColor)
     :c-arg-types (("const" "GdkColor" "*"))
     :c-arg-names (color)
     :arguments ((* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:559 <858> 
;; void gdk_color_free( GdkColor* color);
(ff:bind-c-function gdk_color_free
     :unconverted-entry-name "gdk_color_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColor" "*"))
     :c-arg-names (color)
     :arguments ((* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:561 <859> 
;; gboolean gdk_color_parse( const gchar* spec, GdkColor* color);
(ff:bind-c-function gdk_color_parse
     :unconverted-entry-name "gdk_color_parse"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("GdkColor" "*"))
     :c-arg-names (spec color)
     :arguments ((* gchar) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:563 <860> 
;; guint gdk_color_hash( const GdkColor* colora, const GdkColor* colorb);
(ff:bind-c-function gdk_color_hash
     :unconverted-entry-name "gdk_color_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "GdkColor" "*") ("const" "GdkColor" "*"))
     :c-arg-names (colora colorb)
     :arguments ((* GdkColor) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:565 <861> 
;; gboolean gdk_color_equal( const GdkColor* colora, const GdkColor* colorb
;;   );
(ff:bind-c-function gdk_color_equal
     :unconverted-entry-name "gdk_color_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GdkColor" "*") ("const" "GdkColor" "*"))
     :c-arg-names (colora colorb)
     :arguments ((* GdkColor) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:570 <862> 
;; void gdk_colors_store( GdkColormap* colormap, GdkColor* colors, gint
;;   ncolors
;;   );
(ff:bind-c-function gdk_colors_store
     :unconverted-entry-name "gdk_colors_store"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*") ("gint"))
     :c-arg-names (colormap colors ncolors)
     :arguments ((* GdkColormap) (* GdkColor) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:573 <863> 
;; gboolean gdk_colors_alloc( GdkColormap* colormap, gboolean contiguous,
;;              gulong* planes, gint nplanes, gulong* pixels, gint
;;   npixels);
(ff:bind-c-function gdk_colors_alloc
     :unconverted-entry-name "gdk_colors_alloc"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkColormap" "*") ("gboolean") ("gulong" "*") ("gint")
                   ("gulong" "*") ("gint"))
     :c-arg-names (colormap contiguous planes nplanes pixels npixels)
     :arguments ((* GdkColormap) gboolean (* gulong) gint (* gulong) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:579 <864> 
;; void gdk_colors_free( GdkColormap* colormap, gulong* pixels, gint
;;   npixels,
;;              gulong planes);
(ff:bind-c-function gdk_colors_free
     :unconverted-entry-name "gdk_colors_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*") ("gulong" "*") ("gint") ("gulong"))
     :c-arg-names (colormap pixels npixels planes)
     :arguments ((* GdkColormap) (* gulong) gint gulong)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:583 <865> 
;; gboolean gdk_color_white( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_white
     :unconverted-entry-name "gdk_color_white"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:585 <866> 
;; gboolean gdk_color_black( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_black
     :unconverted-entry-name "gdk_color_black"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:587 <867> 
;; gboolean gdk_color_alloc( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_alloc
     :unconverted-entry-name "gdk_color_alloc"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:589 <868> 
;; gboolean gdk_color_change( GdkColormap* colormap, GdkColor* color);
(ff:bind-c-function gdk_color_change
     :unconverted-entry-name "gdk_color_change"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkColormap" "*") ("GdkColor" "*"))
     :c-arg-names (colormap color)
     :arguments ((* GdkColormap) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:595 <869> 
;; GdkFont* gdk_font_load( const gchar* font_name);
(ff:bind-c-function gdk_font_load
     :unconverted-entry-name "gdk_font_load"
     :c-return-type ("GdkFont" "*")
     :return-type (* GdkFont)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (font_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:596 <870> 
;; GdkFont* gdk_fontset_load( const gchar* fontset_name);
(ff:bind-c-function gdk_fontset_load
     :unconverted-entry-name "gdk_fontset_load"
     :c-return-type ("GdkFont" "*")
     :return-type (* GdkFont)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (fontset_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:597 <871> 
;; GdkFont* gdk_font_ref( GdkFont* font);
(ff:bind-c-function gdk_font_ref
     :unconverted-entry-name "gdk_font_ref"
     :c-return-type ("GdkFont" "*")
     :return-type (* GdkFont)
     :c-arg-types (("GdkFont" "*"))
     :c-arg-names (font)
     :arguments ((* GdkFont))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:598 <872> 
;; void gdk_font_unref( GdkFont* font);
(ff:bind-c-function gdk_font_unref
     :unconverted-entry-name "gdk_font_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkFont" "*"))
     :c-arg-names (font)
     :arguments ((* GdkFont))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:599 <873> 
;; gint gdk_font_id( const GdkFont* font);
(ff:bind-c-function gdk_font_id
     :unconverted-entry-name "gdk_font_id"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "GdkFont" "*"))
     :c-arg-names (font)
     :arguments ((* GdkFont))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:600 <874> 
;; gboolean gdk_font_equal( const GdkFont* fonta, const GdkFont* fontb);
(ff:bind-c-function gdk_font_equal
     :unconverted-entry-name "gdk_font_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GdkFont" "*") ("const" "GdkFont" "*"))
     :c-arg-names (fonta fontb)
     :arguments ((* GdkFont) (* GdkFont))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:602 <875> 
;; gint gdk_string_width( GdkFont* font, const gchar* string);
(ff:bind-c-function gdk_string_width
     :unconverted-entry-name "gdk_string_width"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*"))
     :c-arg-names (font string)
     :arguments ((* GdkFont) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:604 <876> 
;; gint gdk_text_width( GdkFont* font, const gchar* text, gint
;;   text_length);
(ff:bind-c-function gdk_text_width
     :unconverted-entry-name "gdk_text_width"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (font text text_length)
     :arguments ((* GdkFont) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:607 <877> 
;; gint gdk_text_width_wc( GdkFont* font, const GdkWChar* text, gint
;;   text_length
;;   );
(ff:bind-c-function gdk_text_width_wc
     :unconverted-entry-name "gdk_text_width_wc"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("const" "GdkWChar" "*") ("gint"))
     :c-arg-names (font text text_length)
     :arguments ((* GdkFont) (* GdkWChar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:610 <878> 
;; gint gdk_char_width( GdkFont* font, gchar character);
(ff:bind-c-function gdk_char_width
     :unconverted-entry-name "gdk_char_width"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("gchar"))
     :c-arg-names (font character)
     :arguments ((* GdkFont) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:612 <879> 
;; gint gdk_char_width_wc( GdkFont* font, GdkWChar character);
(ff:bind-c-function gdk_char_width_wc
     :unconverted-entry-name "gdk_char_width_wc"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("GdkWChar"))
     :c-arg-names (font character)
     :arguments ((* GdkFont) GdkWChar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:614 <880> 
;; gint gdk_string_measure( GdkFont* font, const gchar* string);
(ff:bind-c-function gdk_string_measure
     :unconverted-entry-name "gdk_string_measure"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*"))
     :c-arg-names (font string)
     :arguments ((* GdkFont) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:616 <881> 
;; gint gdk_text_measure( GdkFont* font, const gchar* text, gint
;;   text_length
;;   );
(ff:bind-c-function gdk_text_measure
     :unconverted-entry-name "gdk_text_measure"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (font text text_length)
     :arguments ((* GdkFont) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:619 <882> 
;; gint gdk_char_measure( GdkFont* font, gchar character);
(ff:bind-c-function gdk_char_measure
     :unconverted-entry-name "gdk_char_measure"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("gchar"))
     :c-arg-names (font character)
     :arguments ((* GdkFont) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:621 <883> 
;; gint gdk_string_height( GdkFont* font, const gchar* string);
(ff:bind-c-function gdk_string_height
     :unconverted-entry-name "gdk_string_height"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*"))
     :c-arg-names (font string)
     :arguments ((* GdkFont) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:623 <884> 
;; gint gdk_text_height( GdkFont* font, const gchar* text, gint text_length
;;   );
(ff:bind-c-function gdk_text_height
     :unconverted-entry-name "gdk_text_height"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (font text text_length)
     :arguments ((* GdkFont) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:626 <885> 
;; gint gdk_char_height( GdkFont* font, gchar character);
(ff:bind-c-function gdk_char_height
     :unconverted-entry-name "gdk_char_height"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkFont" "*") ("gchar"))
     :c-arg-names (font character)
     :arguments ((* GdkFont) gchar)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:629 <886> 
;; void gdk_text_extents( GdkFont* font, const gchar* text, gint
;;   text_length,
;;              gint* lbearing, gint* rbearing, gint* width, gint* ascent,
;;   gint* descent
;;   );
(ff:bind-c-function gdk_text_extents
     :unconverted-entry-name "gdk_text_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*") ("gint") ("gint" "*")
                   ("gint" "*") ("gint" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (font text text_length lbearing rbearing width ascent
                   descent)
     :arguments ((* GdkFont) (* gchar) gint (* gint) (* gint) (* gint)
                 (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:637 <887> 
;; void gdk_text_extents_wc( GdkFont* font, const GdkWChar* text, gint
;;   text_length,
;;              gint* lbearing, gint* rbearing, gint* width, gint* ascent,
;;   gint* descent
;;   );
(ff:bind-c-function gdk_text_extents_wc
     :unconverted-entry-name "gdk_text_extents_wc"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkFont" "*") ("const" "GdkWChar" "*") ("gint")
                   ("gint" "*") ("gint" "*") ("gint" "*") ("gint" "*")
                   ("gint" "*"))
     :c-arg-names (font text text_length lbearing rbearing width ascent
                   descent)
     :arguments ((* GdkFont) (* GdkWChar) gint (* gint) (* gint) (* gint)
                 (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:645 <888> 
;; void gdk_string_extents( GdkFont* font, const gchar* string, gint*
;;   lbearing,
;;              gint* rbearing, gint* width, gint* ascent, gint* descent);
(ff:bind-c-function gdk_string_extents
     :unconverted-entry-name "gdk_string_extents"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkFont" "*") ("const" "gchar" "*") ("gint" "*")
                   ("gint" "*") ("gint" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (font string lbearing rbearing width ascent descent)
     :arguments ((* GdkFont) (* gchar) (* gint) (* gint) (* gint) (* gint)
                 (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:655 <889> 
;; void gdk_draw_point( GdkDrawable* drawable, GdkGC* gc, gint x, gint y);
(ff:bind-c-function gdk_draw_point
     :unconverted-entry-name "gdk_draw_point"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint"))
     :c-arg-names (drawable gc x y)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:659 <890> 
;; void gdk_draw_line( GdkDrawable* drawable, GdkGC* gc, gint x1, gint y1,
;;              gint x2, gint y2);
(ff:bind-c-function gdk_draw_line
     :unconverted-entry-name "gdk_draw_line"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint"))
     :c-arg-names (drawable gc x1 y1 x2 y2)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:665 <891> 
;; void gdk_draw_rectangle( GdkDrawable* drawable, GdkGC* gc, gint filled,
;;              gint x, gint y, gint width, gint height);
(ff:bind-c-function gdk_draw_rectangle
     :unconverted-entry-name "gdk_draw_rectangle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc filled x y width height)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:672 <892> 
;; void gdk_draw_arc( GdkDrawable* drawable, GdkGC* gc, gint filled, gint
;;    x, gint y, gint width, gint height, gint angle1, gint angle2);
(ff:bind-c-function gdk_draw_arc
     :unconverted-entry-name "gdk_draw_arc"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc filled x y width height angle1 angle2)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:681 <893> 
;; void gdk_draw_polygon( GdkDrawable* drawable, GdkGC* gc, gint filled,
;;              GdkPoint* points, gint npoints);
(ff:bind-c-function gdk_draw_polygon
     :unconverted-entry-name "gdk_draw_polygon"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("GdkPoint" "*")
                   ("gint"))
     :c-arg-names (drawable gc filled points npoints)
     :arguments ((* GdkDrawable) (* GdkGC) gint (* GdkPoint) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:686 <894> 
;; void gdk_draw_string( GdkDrawable* drawable, GdkFont* font, GdkGC* gc,
;;              gint x, gint y, const gchar* string);
(ff:bind-c-function gdk_draw_string
     :unconverted-entry-name "gdk_draw_string"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkFont" "*") ("GdkGC" "*") ("gint")
                   ("gint") ("const" "gchar" "*"))
     :c-arg-names (drawable font gc x y string)
     :arguments ((* GdkDrawable) (* GdkFont) (* GdkGC) gint gint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:692 <895> 
;; void gdk_draw_text( GdkDrawable* drawable, GdkFont* font, GdkGC* gc,
;;   gint
;;    x, gint y, const gchar* text, gint text_length);
(ff:bind-c-function gdk_draw_text
     :unconverted-entry-name "gdk_draw_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkFont" "*") ("GdkGC" "*") ("gint")
                   ("gint") ("const" "gchar" "*") ("gint"))
     :c-arg-names (drawable font gc x y text text_length)
     :arguments ((* GdkDrawable) (* GdkFont) (* GdkGC) gint gint (* gchar)
                 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:699 <896> 
;; void gdk_draw_text_wc( GdkDrawable* drawable, GdkFont* font, GdkGC* gc,
;;              gint x, gint y, const GdkWChar* text, gint text_length);
(ff:bind-c-function gdk_draw_text_wc
     :unconverted-entry-name "gdk_draw_text_wc"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkFont" "*") ("GdkGC" "*") ("gint")
                   ("gint") ("const" "GdkWChar" "*") ("gint"))
     :c-arg-names (drawable font gc x y text text_length)
     :arguments ((* GdkDrawable) (* GdkFont) (* GdkGC) gint gint (* GdkWChar)
                 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:706 <897> 
;; void gdk_draw_pixmap( GdkDrawable* drawable, GdkGC* gc, GdkDrawable*
;;   src,
;;              gint xsrc, gint ysrc, gint xdest, gint ydest, gint width,
;;   gint height
;;   );
(ff:bind-c-function gdk_draw_pixmap
     :unconverted-entry-name "gdk_draw_pixmap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("GdkDrawable" "*")
                   ("gint") ("gint") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc src xsrc ysrc xdest ydest width height)
     :arguments ((* GdkDrawable) (* GdkGC) (* GdkDrawable) gint gint gint gint
                 gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:715 <898> 
;; void gdk_draw_image( GdkDrawable* drawable, GdkGC* gc, GdkImage* image,
;;              gint xsrc, gint ysrc, gint xdest, gint ydest, gint width,
;;   gint height
;;   );
(ff:bind-c-function gdk_draw_image
     :unconverted-entry-name "gdk_draw_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("GdkImage" "*") ("gint")
                   ("gint") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (drawable gc image xsrc ysrc xdest ydest width height)
     :arguments ((* GdkDrawable) (* GdkGC) (* GdkImage) gint gint gint gint
                 gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:724 <899> 
;; void gdk_draw_points( GdkDrawable* drawable, GdkGC* gc, GdkPoint*
;;   points,
;;              gint npoints);
(ff:bind-c-function gdk_draw_points
     :unconverted-entry-name "gdk_draw_points"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("GdkPoint" "*") ("gint"))
     :c-arg-names (drawable gc points npoints)
     :arguments ((* GdkDrawable) (* GdkGC) (* GdkPoint) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:728 <900> 
;; void gdk_draw_segments( GdkDrawable* drawable, GdkGC* gc, GdkSegment*
;;    segs, gint nsegs);
(ff:bind-c-function gdk_draw_segments
     :unconverted-entry-name "gdk_draw_segments"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("GdkSegment" "*")
                   ("gint"))
     :c-arg-names (drawable gc segs nsegs)
     :arguments ((* GdkDrawable) (* GdkGC) (* GdkSegment) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:732 <901> 
;; void gdk_draw_lines( GdkDrawable* drawable, GdkGC* gc, GdkPoint* points,
;;              gint npoints);
(ff:bind-c-function gdk_draw_lines
     :unconverted-entry-name "gdk_draw_lines"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("GdkPoint" "*") ("gint"))
     :c-arg-names (drawable gc points npoints)
     :arguments ((* GdkDrawable) (* GdkGC) (* GdkPoint) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:742 <902> 
;; gboolean gdk_selection_owner_set( GdkWindow* owner, GdkAtom selection,
;;              guint32 time, gint send_event);
(ff:bind-c-function gdk_selection_owner_set
     :unconverted-entry-name "gdk_selection_owner_set"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkWindow" "*") ("GdkAtom") ("guint32") ("gint"))
     :c-arg-names (owner selection time send_event)
     :arguments ((* GdkWindow) GdkAtom guint32 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:746 <903> 
;; GdkWindow* gdk_selection_owner_get( GdkAtom selection);
(ff:bind-c-function gdk_selection_owner_get
     :unconverted-entry-name "gdk_selection_owner_get"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("GdkAtom"))
     :c-arg-names (selection)
     :arguments (GdkAtom)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:747 <904> 
;; void gdk_selection_convert( GdkWindow* requestor, GdkAtom selection,
;;   GdkAtom
;;    target, guint32 time);
(ff:bind-c-function gdk_selection_convert
     :unconverted-entry-name "gdk_selection_convert"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkAtom") ("GdkAtom") ("guint32"))
     :c-arg-names (requestor selection target time)
     :arguments ((* GdkWindow) GdkAtom GdkAtom guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:751 <905> 
;; gboolean gdk_selection_property_get( GdkWindow* requestor, guchar**
;;   data,
;;              GdkAtom* prop_type, gint* prop_format);
(ff:bind-c-function gdk_selection_property_get
     :unconverted-entry-name "gdk_selection_property_get"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkWindow" "*") ("guchar" "*" "*") ("GdkAtom" "*")
                   ("gint" "*"))
     :c-arg-names (requestor data prop_type prop_format)
     :arguments ((* GdkWindow) (* (* guchar)) (* GdkAtom) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:755 <906> 
;; void gdk_selection_send_notify( guint32 requestor, GdkAtom selection,
;;              GdkAtom target, GdkAtom property, guint32 time);
(ff:bind-c-function gdk_selection_send_notify
     :unconverted-entry-name "gdk_selection_send_notify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32") ("GdkAtom") ("GdkAtom") ("GdkAtom") ("guint32"))
     :c-arg-names (requestor selection target property time)
     :arguments (guint32 GdkAtom GdkAtom GdkAtom guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:761 <907> 
;; gint gdk_text_property_to_text_list( GdkAtom encoding, gint format,
;;   guchar
;;   * text, gint length, gchar*** list);
(ff:bind-c-function gdk_text_property_to_text_list
     :unconverted-entry-name "gdk_text_property_to_text_list"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkAtom") ("gint") ("guchar" "*") ("gint")
                   ("gchar" "*" "*" "*"))
     :c-arg-names (encoding format text length list)
     :arguments (GdkAtom gint (* guchar) gint (* (* (* gchar))))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:764 <908> 
;; void gdk_free_text_list( gchar** list);
(ff:bind-c-function gdk_free_text_list
     :unconverted-entry-name "gdk_free_text_list"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gchar" "*" "*"))
     :c-arg-names (list)
     :arguments ((* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:765 <909> 
;; gint gdk_string_to_compound_text( const gchar* str, GdkAtom* encoding,
;;              gint* format, guchar** ctext, gint* length);
(ff:bind-c-function gdk_string_to_compound_text
     :unconverted-entry-name "gdk_string_to_compound_text"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("const" "gchar" "*") ("GdkAtom" "*") ("gint" "*")
                   ("guchar" "*" "*") ("gint" "*"))
     :c-arg-names (str encoding format ctext length)
     :arguments ((* gchar) (* GdkAtom) (* gint) (* (* guchar)) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:768 <910> 
;; void gdk_free_compound_text( guchar* ctext);
(ff:bind-c-function gdk_free_compound_text
     :unconverted-entry-name "gdk_free_compound_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guchar" "*"))
     :c-arg-names (ctext)
     :arguments ((* guchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:772 <911> 
;; GdkAtom gdk_atom_intern( const gchar* atom_name, gint only_if_exists);
(ff:bind-c-function gdk_atom_intern
     :unconverted-entry-name "gdk_atom_intern"
     :c-return-type ("GdkAtom")
     :return-type GdkAtom
     :c-arg-types (("const" "gchar" "*") ("gint"))
     :c-arg-names (atom_name only_if_exists)
     :arguments ((* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:774 <912> 
;; gchar* gdk_atom_name( GdkAtom atom);
(ff:bind-c-function gdk_atom_name
     :unconverted-entry-name "gdk_atom_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GdkAtom"))
     :c-arg-names (atom)
     :arguments (GdkAtom)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:775 <913> 
;; gboolean gdk_property_get( GdkWindow* window, GdkAtom property, GdkAtom
;;    type, gulong offset, gulong length, gint pdelete, GdkAtom*
;;   actual_property_type,
;;              gint* actual_format, gint* actual_length, guchar** data);
(ff:bind-c-function gdk_property_get
     :unconverted-entry-name "gdk_property_get"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkWindow" "*") ("GdkAtom") ("GdkAtom") ("gulong")
                   ("gulong") ("gint") ("GdkAtom" "*") ("gint" "*")
                   ("gint" "*") ("guchar" "*" "*"))
     :c-arg-names (window property type offset length pdelete
                   actual_property_type actual_format actual_length data)
     :arguments ((* GdkWindow) GdkAtom GdkAtom gulong gulong gint (* GdkAtom)
                 (* gint) (* gint) (* (* guchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:785 <914> 
;; void gdk_property_change( GdkWindow* window, GdkAtom property, GdkAtom
;;    type, gint format, GdkPropMode mode, guchar* data, gint nelements);
(ff:bind-c-function gdk_property_change
     :unconverted-entry-name "gdk_property_change"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkAtom") ("GdkAtom") ("gint")
                   ("GdkPropMode") ("guchar" "*") ("gint"))
     :c-arg-names (window property type format mode data nelements)
     :arguments ((* GdkWindow) GdkAtom GdkAtom gint GdkPropMode (* guchar)
                 gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:792 <915> 
;; void gdk_property_delete( GdkWindow* window, GdkAtom property);
(ff:bind-c-function gdk_property_delete
     :unconverted-entry-name "gdk_property_delete"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("GdkAtom"))
     :c-arg-names (window property)
     :arguments ((* GdkWindow) GdkAtom)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:799 <916> 
;; gboolean gdk_rectangle_intersect( GdkRectangle* src1, GdkRectangle*
;;   src2,
;;              GdkRectangle* dest);
(ff:bind-c-function gdk_rectangle_intersect
     :unconverted-entry-name "gdk_rectangle_intersect"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkRectangle" "*") ("GdkRectangle" "*")
                   ("GdkRectangle" "*"))
     :c-arg-names (src1 src2 dest)
     :arguments ((* GdkRectangle) (* GdkRectangle) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:802 <917> 
;; void gdk_rectangle_union( GdkRectangle* src1, GdkRectangle* src2,
;;   GdkRectangle
;;   * dest);
(ff:bind-c-function gdk_rectangle_union
     :unconverted-entry-name "gdk_rectangle_union"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkRectangle" "*") ("GdkRectangle" "*")
                   ("GdkRectangle" "*"))
     :c-arg-names (src1 src2 dest)
     :arguments ((* GdkRectangle) (* GdkRectangle) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:808 <918> 
;; void gdk_input_init( void);
(ff:bind-c-function gdk_input_init
     :unconverted-entry-name "gdk_input_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:809 <919> 
;; void gdk_input_exit( void);
(ff:bind-c-function gdk_input_exit
     :unconverted-entry-name "gdk_input_exit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:810 <920> 
;; GList* gdk_input_list_devices( void);
(ff:bind-c-function gdk_input_list_devices
     :unconverted-entry-name "gdk_input_list_devices"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:811 <921> 
;; void gdk_input_set_extension_events( GdkWindow* window, gint mask,
;;   GdkExtensionMode
;;    mode);
(ff:bind-c-function gdk_input_set_extension_events
     :unconverted-entry-name "gdk_input_set_extension_events"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("gint") ("GdkExtensionMode"))
     :c-arg-names (window mask mode)
     :arguments ((* GdkWindow) gint GdkExtensionMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:814 <922> 
;; void gdk_input_set_source( guint32 deviceid, GdkInputSource source);
(ff:bind-c-function gdk_input_set_source
     :unconverted-entry-name "gdk_input_set_source"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32") ("GdkInputSource"))
     :c-arg-names (deviceid source)
     :arguments (guint32 GdkInputSource)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:816 <923> 
;; gboolean gdk_input_set_mode( guint32 deviceid, GdkInputMode mode);
(ff:bind-c-function gdk_input_set_mode
     :unconverted-entry-name "gdk_input_set_mode"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint32") ("GdkInputMode"))
     :c-arg-names (deviceid mode)
     :arguments (guint32 GdkInputMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:818 <924> 
;; void gdk_input_set_axes( guint32 deviceid, GdkAxisUse* axes);
(ff:bind-c-function gdk_input_set_axes
     :unconverted-entry-name "gdk_input_set_axes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32") ("GdkAxisUse" "*"))
     :c-arg-names (deviceid axes)
     :arguments (guint32 (* GdkAxisUse))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:820 <925> 
;; void gdk_input_set_key( guint32 deviceid, guint index, guint keyval,
;;   GdkModifierType
;;    modifiers);
(ff:bind-c-function gdk_input_set_key
     :unconverted-entry-name "gdk_input_set_key"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint32") ("guint") ("guint") ("GdkModifierType"))
     :c-arg-names (deviceid index keyval modifiers)
     :arguments (guint32 guint guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:824 <926> 
;; void gdk_input_window_get_pointer( GdkWindow* window, guint32 deviceid,
;;              gdouble* x, gdouble* y, gdouble* pressure, gdouble* xtilt,
;;   gdouble* ytilt,
;;              GdkModifierType* mask);
(ff:bind-c-function gdk_input_window_get_pointer
     :unconverted-entry-name "gdk_input_window_get_pointer"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkWindow" "*") ("guint32") ("gdouble" "*")
                   ("gdouble" "*") ("gdouble" "*") ("gdouble" "*")
                   ("gdouble" "*") ("GdkModifierType" "*"))
     :c-arg-names (window deviceid x y pressure xtilt ytilt mask)
     :arguments ((* GdkWindow) guint32 (* gdouble) (* gdouble) (* gdouble)
                 (* gdouble) (* gdouble) (* GdkModifierType))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:832 <927> 
;; GdkTimeCoord* gdk_input_motion_events( GdkWindow* window, guint32
;;   deviceid,
;;              guint32 start, guint32 stop, gint* nevents_return);
(ff:bind-c-function gdk_input_motion_events
     :unconverted-entry-name "gdk_input_motion_events"
     :c-return-type ("GdkTimeCoord" "*")
     :return-type (* GdkTimeCoord)
     :c-arg-types (("GdkWindow" "*") ("guint32") ("guint32") ("guint32")
                   ("gint" "*"))
     :c-arg-names (window deviceid start stop nevents_return)
     :arguments ((* GdkWindow) guint32 guint32 guint32 (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:841 <928> 
;; gboolean gdk_im_ready( void);
(ff:bind-c-function gdk_im_ready
     :unconverted-entry-name "gdk_im_ready"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:843 <929> 
;; void gdk_im_begin( GdkIC* ic, GdkWindow* window);
(ff:bind-c-function gdk_im_begin
     :unconverted-entry-name "gdk_im_begin"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkIC" "*") ("GdkWindow" "*"))
     :c-arg-names (ic window)
     :arguments ((* GdkIC) (* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:845 <930> 
;; void gdk_im_end( void);
(ff:bind-c-function gdk_im_end
     :unconverted-entry-name "gdk_im_end"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:846 <931> 
;; GdkIMStyle gdk_im_decide_style( GdkIMStyle supported_style);
(ff:bind-c-function gdk_im_decide_style
     :unconverted-entry-name "gdk_im_decide_style"
     :c-return-type ("GdkIMStyle")
     :return-type GdkIMStyle
     :c-arg-types (("GdkIMStyle"))
     :c-arg-names (supported_style)
     :arguments (GdkIMStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:847 <932> 
;; GdkIMStyle gdk_im_set_best_style( GdkIMStyle best_allowed_style);
(ff:bind-c-function gdk_im_set_best_style
     :unconverted-entry-name "gdk_im_set_best_style"
     :c-return-type ("GdkIMStyle")
     :return-type GdkIMStyle
     :c-arg-types (("GdkIMStyle"))
     :c-arg-names (best_allowed_style)
     :arguments (GdkIMStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:849 <933> 
;; GdkIC* gdk_ic_new( GdkICAttr* attr, GdkICAttributesType mask);
(ff:bind-c-function gdk_ic_new
     :unconverted-entry-name "gdk_ic_new"
     :c-return-type ("GdkIC" "*")
     :return-type (* GdkIC)
     :c-arg-types (("GdkICAttr" "*") ("GdkICAttributesType"))
     :c-arg-names (attr mask)
     :arguments ((* GdkICAttr) GdkICAttributesType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:851 <934> 
;; void gdk_ic_destroy( GdkIC* ic);
(ff:bind-c-function gdk_ic_destroy
     :unconverted-entry-name "gdk_ic_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkIC" "*"))
     :c-arg-names (ic)
     :arguments ((* GdkIC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:852 <935> 
;; GdkIMStyle gdk_ic_get_style( GdkIC* ic);
(ff:bind-c-function gdk_ic_get_style
     :unconverted-entry-name "gdk_ic_get_style"
     :c-return-type ("GdkIMStyle")
     :return-type GdkIMStyle
     :c-arg-types (("GdkIC" "*"))
     :c-arg-names (ic)
     :arguments ((* GdkIC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:853 <936> 
;; GdkEventMask gdk_ic_get_events( GdkIC* ic);
(ff:bind-c-function gdk_ic_get_events
     :unconverted-entry-name "gdk_ic_get_events"
     :c-return-type ("GdkEventMask")
     :return-type GdkEventMask
     :c-arg-types (("GdkIC" "*"))
     :c-arg-names (ic)
     :arguments ((* GdkIC))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:855 <937> 
;; GdkICAttr* gdk_ic_attr_new( void);
(ff:bind-c-function gdk_ic_attr_new
     :unconverted-entry-name "gdk_ic_attr_new"
     :c-return-type ("GdkICAttr" "*")
     :return-type (* GdkICAttr)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:856 <938> 
;; void gdk_ic_attr_destroy( GdkICAttr* attr);
(ff:bind-c-function gdk_ic_attr_destroy
     :unconverted-entry-name "gdk_ic_attr_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkICAttr" "*"))
     :c-arg-names (attr)
     :arguments ((* GdkICAttr))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:858 <939> 
;; GdkICAttributesType gdk_ic_set_attr( GdkIC* ic, GdkICAttr* attr,
;;   GdkICAttributesType
;;    mask);
(ff:bind-c-function gdk_ic_set_attr
     :unconverted-entry-name "gdk_ic_set_attr"
     :c-return-type ("GdkICAttributesType")
     :return-type GdkICAttributesType
     :c-arg-types (("GdkIC" "*") ("GdkICAttr" "*") ("GdkICAttributesType"))
     :c-arg-names (ic attr mask)
     :arguments ((* GdkIC) (* GdkICAttr) GdkICAttributesType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:861 <940> 
;; GdkICAttributesType gdk_ic_get_attr( GdkIC* ic, GdkICAttr* attr,
;;   GdkICAttributesType
;;    mask);
(ff:bind-c-function gdk_ic_get_attr
     :unconverted-entry-name "gdk_ic_get_attr"
     :c-return-type ("GdkICAttributesType")
     :return-type GdkICAttributesType
     :c-arg-types (("GdkIC" "*") ("GdkICAttr" "*") ("GdkICAttributesType"))
     :c-arg-names (ic attr mask)
     :arguments ((* GdkIC) (* GdkICAttr) GdkICAttributesType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:867 <941> 
;; gchar* gdk_wcstombs( const GdkWChar* src);
(ff:bind-c-function gdk_wcstombs
     :unconverted-entry-name "gdk_wcstombs"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "GdkWChar" "*"))
     :c-arg-names (src)
     :arguments ((* GdkWChar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:868 <942> 
;; gint gdk_mbstowcs( GdkWChar* dest, const gchar* src, gint dest_max);
(ff:bind-c-function gdk_mbstowcs
     :unconverted-entry-name "gdk_mbstowcs"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkWChar" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (dest src dest_max)
     :arguments ((* GdkWChar) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:875 <943> 
;; GdkColorContext* gdk_color_context_new( GdkVisual* visual, GdkColormap
;;   * colormap);
(ff:bind-c-function gdk_color_context_new
     :unconverted-entry-name "gdk_color_context_new"
     :c-return-type ("GdkColorContext" "*")
     :return-type (* GdkColorContext)
     :c-arg-types (("GdkVisual" "*") ("GdkColormap" "*"))
     :c-arg-names (visual colormap)
     :arguments ((* GdkVisual) (* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:878 <944> 
;; GdkColorContext* gdk_color_context_new_mono( GdkVisual* visual,
;;   GdkColormap
;;   * colormap);
(ff:bind-c-function gdk_color_context_new_mono
     :unconverted-entry-name "gdk_color_context_new_mono"
     :c-return-type ("GdkColorContext" "*")
     :return-type (* GdkColorContext)
     :c-arg-types (("GdkVisual" "*") ("GdkColormap" "*"))
     :c-arg-names (visual colormap)
     :arguments ((* GdkVisual) (* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:881 <945> 
;; void gdk_color_context_free( GdkColorContext* cc);
(ff:bind-c-function gdk_color_context_free
     :unconverted-entry-name "gdk_color_context_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColorContext" "*"))
     :c-arg-names (cc)
     :arguments ((* GdkColorContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:883 <946> 
;; gulong gdk_color_context_get_pixel( GdkColorContext* cc, gushort red,
;;              gushort green, gushort blue, gint* failed);
(ff:bind-c-function gdk_color_context_get_pixel
     :unconverted-entry-name "gdk_color_context_get_pixel"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("GdkColorContext" "*") ("gushort") ("gushort") ("gushort")
                   ("gint" "*"))
     :c-arg-names (cc red green blue failed)
     :arguments ((* GdkColorContext) gushort gushort gushort (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:888 <947> 
;; void gdk_color_context_get_pixels( GdkColorContext* cc, gushort* reds,
;;              gushort* greens, gushort* blues, gint ncolors, gulong*
;;   colors, gint* nallocated
;;   );
(ff:bind-c-function gdk_color_context_get_pixels
     :unconverted-entry-name "gdk_color_context_get_pixels"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColorContext" "*") ("gushort" "*") ("gushort" "*")
                   ("gushort" "*") ("gint") ("gulong" "*") ("gint" "*"))
     :c-arg-names (cc reds greens blues ncolors colors nallocated)
     :arguments ((* GdkColorContext) (* gushort) (* gushort) (* gushort) gint
                 (* gulong) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:895 <948> 
;; void gdk_color_context_get_pixels_incremental( GdkColorContext* cc,
;;   gushort
;;   * reds, gushort* greens, gushort* blues, gint ncolors, gint* used,
;;   gulong
;;   * colors, gint* nallocated);
(ff:bind-c-function gdk_color_context_get_pixels_incremental
     :unconverted-entry-name "gdk_color_context_get_pixels_incremental"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColorContext" "*") ("gushort" "*") ("gushort" "*")
                   ("gushort" "*") ("gint") ("gint" "*") ("gulong" "*")
                   ("gint" "*"))
     :c-arg-names (cc reds greens blues ncolors used colors nallocated)
     :arguments ((* GdkColorContext) (* gushort) (* gushort) (* gushort) gint
                 (* gint) (* gulong) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:904 <949> 
;; gint gdk_color_context_query_color( GdkColorContext* cc, GdkColor* color
;;   );
(ff:bind-c-function gdk_color_context_query_color
     :unconverted-entry-name "gdk_color_context_query_color"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColorContext" "*") ("GdkColor" "*"))
     :c-arg-names (cc color)
     :arguments ((* GdkColorContext) (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:906 <950> 
;; gint gdk_color_context_query_colors( GdkColorContext* cc, GdkColor*
;;   colors,
;;              gint num_colors);
(ff:bind-c-function gdk_color_context_query_colors
     :unconverted-entry-name "gdk_color_context_query_colors"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColorContext" "*") ("GdkColor" "*") ("gint"))
     :c-arg-names (cc colors num_colors)
     :arguments ((* GdkColorContext) (* GdkColor) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:910 <951> 
;; gint gdk_color_context_add_palette( GdkColorContext* cc, GdkColor*
;;   palette,
;;              gint num_palette);
(ff:bind-c-function gdk_color_context_add_palette
     :unconverted-entry-name "gdk_color_context_add_palette"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GdkColorContext" "*") ("GdkColor" "*") ("gint"))
     :c-arg-names (cc palette num_palette)
     :arguments ((* GdkColorContext) (* GdkColor) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:914 <952> 
;; void gdk_color_context_init_dither( GdkColorContext* cc);
(ff:bind-c-function gdk_color_context_init_dither
     :unconverted-entry-name "gdk_color_context_init_dither"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColorContext" "*"))
     :c-arg-names (cc)
     :arguments ((* GdkColorContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:915 <953> 
;; void gdk_color_context_free_dither( GdkColorContext* cc);
(ff:bind-c-function gdk_color_context_free_dither
     :unconverted-entry-name "gdk_color_context_free_dither"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColorContext" "*"))
     :c-arg-names (cc)
     :arguments ((* GdkColorContext))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:917 <954> 
;; gulong gdk_color_context_get_pixel_from_palette( GdkColorContext* cc,
;;              gushort* red, gushort* green, gushort* blue, gint* failed);
(ff:bind-c-function gdk_color_context_get_pixel_from_palette
     :unconverted-entry-name "gdk_color_context_get_pixel_from_palette"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("GdkColorContext" "*") ("gushort" "*") ("gushort" "*")
                   ("gushort" "*") ("gint" "*"))
     :c-arg-names (cc red green blue failed)
     :arguments ((* GdkColorContext) (* gushort) (* gushort) (* gushort)
                 (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:922 <955> 
;; guchar gdk_color_context_get_index_from_palette( GdkColorContext* cc,
;;              gint* red, gint* green, gint* blue, gint* failed);
(ff:bind-c-function gdk_color_context_get_index_from_palette
     :unconverted-entry-name "gdk_color_context_get_index_from_palette"
     :c-return-type ("guchar")
     :return-type guchar
     :c-arg-types (("GdkColorContext" "*") ("gint" "*") ("gint" "*")
                   ("gint" "*") ("gint" "*"))
     :c-arg-names (cc red green blue failed)
     :arguments ((* GdkColorContext) (* gint) (* gint) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:930 <956> 
;; GdkRegion* gdk_region_new( void);
(ff:bind-c-function gdk_region_new
     :unconverted-entry-name "gdk_region_new"
     :c-return-type ("GdkRegion" "*")
     :return-type (* GdkRegion)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:931 <957> 
;; void gdk_region_destroy( GdkRegion* region);
(ff:bind-c-function gdk_region_destroy
     :unconverted-entry-name "gdk_region_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkRegion" "*"))
     :c-arg-names (region)
     :arguments ((* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:933 <958> 
;; void gdk_region_get_clipbox( GdkRegion* region, GdkRectangle*
;;   rectangle);
(ff:bind-c-function gdk_region_get_clipbox
     :unconverted-entry-name "gdk_region_get_clipbox"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkRegion" "*") ("GdkRectangle" "*"))
     :c-arg-names (region rectangle)
     :arguments ((* GdkRegion) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:936 <959> 
;; gboolean gdk_region_empty( GdkRegion* region);
(ff:bind-c-function gdk_region_empty
     :unconverted-entry-name "gdk_region_empty"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkRegion" "*"))
     :c-arg-names (region)
     :arguments ((* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:937 <960> 
;; gboolean gdk_region_equal( GdkRegion* region1, GdkRegion* region2);
(ff:bind-c-function gdk_region_equal
     :unconverted-entry-name "gdk_region_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkRegion" "*") ("GdkRegion" "*"))
     :c-arg-names (region1 region2)
     :arguments ((* GdkRegion) (* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:939 <961> 
;; gboolean gdk_region_point_in( GdkRegion* region, int x, int y);
(ff:bind-c-function gdk_region_point_in
     :unconverted-entry-name "gdk_region_point_in"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkRegion" "*") ("int") ("int"))
     :c-arg-names (region x y)
     :arguments ((* GdkRegion) :int :int)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:942 <962> 
;; GdkOverlapType gdk_region_rect_in( GdkRegion* region, GdkRectangle* rect
;;   );
(ff:bind-c-function gdk_region_rect_in
     :unconverted-entry-name "gdk_region_rect_in"
     :c-return-type ("GdkOverlapType")
     :return-type GdkOverlapType
     :c-arg-types (("GdkRegion" "*") ("GdkRectangle" "*"))
     :c-arg-names (region rect)
     :arguments ((* GdkRegion) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:945 <963> 
;; GdkRegion* gdk_region_polygon( GdkPoint* points, gint npoints,
;;   GdkFillRule
;;    fill_rule);
(ff:bind-c-function gdk_region_polygon
     :unconverted-entry-name "gdk_region_polygon"
     :c-return-type ("GdkRegion" "*")
     :return-type (* GdkRegion)
     :c-arg-types (("GdkPoint" "*") ("gint") ("GdkFillRule"))
     :c-arg-names (points npoints fill_rule)
     :arguments ((* GdkPoint) gint GdkFillRule)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:949 <964> 
;; void gdk_region_offset( GdkRegion* region, gint dx, gint dy);
(ff:bind-c-function gdk_region_offset
     :unconverted-entry-name "gdk_region_offset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkRegion" "*") ("gint") ("gint"))
     :c-arg-names (region dx dy)
     :arguments ((* GdkRegion) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:952 <965> 
;; void gdk_region_shrink( GdkRegion* region, gint dx, gint dy);
(ff:bind-c-function gdk_region_shrink
     :unconverted-entry-name "gdk_region_shrink"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkRegion" "*") ("gint") ("gint"))
     :c-arg-names (region dx dy)
     :arguments ((* GdkRegion) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:956 <966> 
;; GdkRegion* gdk_region_union_with_rect( GdkRegion* region, GdkRectangle
;;   * rect);
(ff:bind-c-function gdk_region_union_with_rect
     :unconverted-entry-name "gdk_region_union_with_rect"
     :c-return-type ("GdkRegion" "*")
     :return-type (* GdkRegion)
     :c-arg-types (("GdkRegion" "*") ("GdkRectangle" "*"))
     :c-arg-names (region rect)
     :arguments ((* GdkRegion) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:958 <967> 
;; GdkRegion* gdk_regions_intersect( GdkRegion* source1, GdkRegion* source2
;;   );
(ff:bind-c-function gdk_regions_intersect
     :unconverted-entry-name "gdk_regions_intersect"
     :c-return-type ("GdkRegion" "*")
     :return-type (* GdkRegion)
     :c-arg-types (("GdkRegion" "*") ("GdkRegion" "*"))
     :c-arg-names (source1 source2)
     :arguments ((* GdkRegion) (* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:960 <968> 
;; GdkRegion* gdk_regions_union( GdkRegion* source1, GdkRegion* source2);
(ff:bind-c-function gdk_regions_union
     :unconverted-entry-name "gdk_regions_union"
     :c-return-type ("GdkRegion" "*")
     :return-type (* GdkRegion)
     :c-arg-types (("GdkRegion" "*") ("GdkRegion" "*"))
     :c-arg-names (source1 source2)
     :arguments ((* GdkRegion) (* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:962 <969> 
;; GdkRegion* gdk_regions_subtract( GdkRegion* source1, GdkRegion*
;;   source2);
(ff:bind-c-function gdk_regions_subtract
     :unconverted-entry-name "gdk_regions_subtract"
     :c-return-type ("GdkRegion" "*")
     :return-type (* GdkRegion)
     :c-arg-types (("GdkRegion" "*") ("GdkRegion" "*"))
     :c-arg-names (source1 source2)
     :arguments ((* GdkRegion) (* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:964 <970> 
;; GdkRegion* gdk_regions_xor( GdkRegion* source1, GdkRegion* source2);
(ff:bind-c-function gdk_regions_xor
     :unconverted-entry-name "gdk_regions_xor"
     :c-return-type ("GdkRegion" "*")
     :return-type (* GdkRegion)
     :c-arg-types (("GdkRegion" "*") ("GdkRegion" "*"))
     :c-arg-names (source1 source2)
     :arguments ((* GdkRegion) (* GdkRegion))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:968 <971> 
;; void gdk_event_send_clientmessage_toall( GdkEvent* event);
(ff:bind-c-function gdk_event_send_clientmessage_toall
     :unconverted-entry-name "gdk_event_send_clientmessage_toall"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkEvent" "*"))
     :c-arg-names (event)
     :arguments ((* GdkEvent))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:969 <972> 
;; gboolean gdk_event_send_client_message( GdkEvent* event, guint32 xid);
(ff:bind-c-function gdk_event_send_client_message
     :unconverted-entry-name "gdk_event_send_client_message"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GdkEvent" "*") ("guint32"))
     :c-arg-names (event xid)
     :arguments ((* GdkEvent) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:974 <973> 
;; gchar* gdk_keyval_name( guint keyval);
(ff:bind-c-function gdk_keyval_name
     :unconverted-entry-name "gdk_keyval_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("guint"))
     :c-arg-names (keyval)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:975 <974> 
;; guint gdk_keyval_from_name( const gchar* keyval_name);
(ff:bind-c-function gdk_keyval_from_name
     :unconverted-entry-name "gdk_keyval_from_name"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (keyval_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:976 <975> 
;; guint gdk_keyval_to_upper( guint keyval);
(ff:bind-c-function gdk_keyval_to_upper
     :unconverted-entry-name "gdk_keyval_to_upper"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint"))
     :c-arg-names (keyval)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:977 <976> 
;; guint gdk_keyval_to_lower( guint keyval);
(ff:bind-c-function gdk_keyval_to_lower
     :unconverted-entry-name "gdk_keyval_to_lower"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint"))
     :c-arg-names (keyval)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:978 <977> 
;; gboolean gdk_keyval_is_upper( guint keyval);
(ff:bind-c-function gdk_keyval_is_upper
     :unconverted-entry-name "gdk_keyval_is_upper"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint"))
     :c-arg-names (keyval)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:979 <978> 
;; gboolean gdk_keyval_is_lower( guint keyval);
(ff:bind-c-function gdk_keyval_is_lower
     :unconverted-entry-name "gdk_keyval_is_lower"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint"))
     :c-arg-names (keyval)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:984 <979> 
;; extern GMutex* gdk_threads_mutex;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "gdk_threads_mutex"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:986 <980> 
;; void gdk_threads_enter( void);
(ff:bind-c-function gdk_threads_enter
     :unconverted-entry-name "gdk_threads_enter"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdk.h:987 <981> 
;; void gdk_threads_leave( void);
(ff:bind-c-function gdk_threads_leave
     :unconverted-entry-name "gdk_threads_leave"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:34 <982> 
;; typedef struct _GdkRgbCmap GdkRgbCmap;
(ff:bind-c-typedef _GdkRgbCmap
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GdkRgbCmap _GdkRgbCmap)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:36 <983> 
;; struct _GdkRgbCmap {
;;         guint32 colors[  0x000000100]; guchar lut[  0x000000100]; };
(ff:bind-c-type _GdkRgbCmap (:struct
  (colors (:array guint32 256))   ;; guint32 colors[  0x000000100]
  (lut (:array guchar 256))   ;; guchar lut[  0x000000100]
  ))   ;; bind-c-type _GdkRgbCmap

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:41 <984> 
;; void gdk_rgb_init( void);
(ff:bind-c-function gdk_rgb_init
     :unconverted-entry-name "gdk_rgb_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:44 <985> 
;; gulong gdk_rgb_xpixel_from_rgb( guint32 rgb);
(ff:bind-c-function gdk_rgb_xpixel_from_rgb
     :unconverted-entry-name "gdk_rgb_xpixel_from_rgb"
     :c-return-type ("gulong")
     :return-type gulong
     :c-arg-types (("guint32"))
     :c-arg-names (rgb)
     :arguments (guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:47 <986> 
;; void gdk_rgb_gc_set_foreground( GdkGC* gc, guint32 rgb);
(ff:bind-c-function gdk_rgb_gc_set_foreground
     :unconverted-entry-name "gdk_rgb_gc_set_foreground"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("guint32"))
     :c-arg-names (gc rgb)
     :arguments ((* GdkGC) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:50 <987> 
;; void gdk_rgb_gc_set_background( GdkGC* gc, guint32 rgb);
(ff:bind-c-function gdk_rgb_gc_set_background
     :unconverted-entry-name "gdk_rgb_gc_set_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkGC" "*") ("guint32"))
     :c-arg-names (gc rgb)
     :arguments ((* GdkGC) guint32)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:53 <988> 
;; typedef enum {
;;         GDK_RGB_DITHER_NONE, GDK_RGB_DITHER_NORMAL, GDK_RGB_DITHER_MAX }
;;   GdkRgbDither
;;   ;
(ff:bind-c-constant GDK_RGB_DITHER_NONE 0) ;;  GDK_RGB_DITHER_NONE 
(ff:bind-c-constant GDK_RGB_DITHER_NORMAL 1) ;;  GDK_RGB_DITHER_NORMAL 
(ff:bind-c-constant GDK_RGB_DITHER_MAX 2) ;;  GDK_RGB_DITHER_MAX 
(ff:bind-c-type GdkRgbDither :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:60 <989> 
;; void gdk_draw_rgb_image( GdkDrawable* drawable, GdkGC* gc, gint x, gint
;;    y, gint width, gint height, GdkRgbDither dith, guchar* rgb_buf, gint
;;   rowstride
;;   );
(ff:bind-c-function gdk_draw_rgb_image
     :unconverted-entry-name "gdk_draw_rgb_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*") ("gint"))
     :c-arg-names (drawable gc x y width height dith rgb_buf rowstride)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint GdkRgbDither
                 (* guchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:71 <990> 
;; void gdk_draw_rgb_image_dithalign( GdkDrawable* drawable, GdkGC* gc,
;;   gint
;;    x, gint y, gint width, gint height, GdkRgbDither dith, guchar*
;;   rgb_buf,
;;              gint rowstride, gint xdith, gint ydith);
(ff:bind-c-function gdk_draw_rgb_image_dithalign
     :unconverted-entry-name "gdk_draw_rgb_image_dithalign"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*") ("gint")
                   ("gint") ("gint"))
     :c-arg-names (drawable gc x y width height dith rgb_buf rowstride xdith
                   ydith)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint GdkRgbDither
                 (* guchar) gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:84 <991> 
;; void gdk_draw_rgb_32_image( GdkDrawable* drawable, GdkGC* gc, gint x,
;;              gint y, gint width, gint height, GdkRgbDither dith, guchar*
;;   buf, gint
;;    rowstride);
(ff:bind-c-function gdk_draw_rgb_32_image
     :unconverted-entry-name "gdk_draw_rgb_32_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*") ("gint"))
     :c-arg-names (drawable gc x y width height dith buf rowstride)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint GdkRgbDither
                 (* guchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:95 <992> 
;; void gdk_draw_gray_image( GdkDrawable* drawable, GdkGC* gc, gint x, gint
;;    y, gint width, gint height, GdkRgbDither dith, guchar* buf, gint
;;   rowstride
;;   );
(ff:bind-c-function gdk_draw_gray_image
     :unconverted-entry-name "gdk_draw_gray_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*") ("gint"))
     :c-arg-names (drawable gc x y width height dith buf rowstride)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint GdkRgbDither
                 (* guchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:106 <993> 
;; GdkRgbCmap* gdk_rgb_cmap_new( guint32* colors, gint n_colors);
(ff:bind-c-function gdk_rgb_cmap_new
     :unconverted-entry-name "gdk_rgb_cmap_new"
     :c-return-type ("GdkRgbCmap" "*")
     :return-type (* GdkRgbCmap)
     :c-arg-types (("guint32" "*") ("gint"))
     :c-arg-names (colors n_colors)
     :arguments ((* guint32) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:109 <994> 
;; void gdk_rgb_cmap_free( GdkRgbCmap* cmap);
(ff:bind-c-function gdk_rgb_cmap_free
     :unconverted-entry-name "gdk_rgb_cmap_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkRgbCmap" "*"))
     :c-arg-names (cmap)
     :arguments ((* GdkRgbCmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:112 <995> 
;; void gdk_draw_indexed_image( GdkDrawable* drawable, GdkGC* gc, gint x,
;;              gint y, gint width, gint height, GdkRgbDither dith, guchar*
;;   buf, gint
;;    rowstride, GdkRgbCmap* cmap);
(ff:bind-c-function gdk_draw_indexed_image
     :unconverted-entry-name "gdk_draw_indexed_image"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkDrawable" "*") ("GdkGC" "*") ("gint") ("gint")
                   ("gint") ("gint") ("GdkRgbDither") ("guchar" "*") ("gint")
                   ("GdkRgbCmap" "*"))
     :c-arg-names (drawable gc x y width height dith buf rowstride cmap)
     :arguments ((* GdkDrawable) (* GdkGC) gint gint gint gint GdkRgbDither
                 (* guchar) gint (* GdkRgbCmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:127 <996> 
;; gboolean gdk_rgb_ditherable( void);
(ff:bind-c-function gdk_rgb_ditherable
     :unconverted-entry-name "gdk_rgb_ditherable"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:130 <997> 
;; void gdk_rgb_set_verbose( gboolean verbose);
(ff:bind-c-function gdk_rgb_set_verbose
     :unconverted-entry-name "gdk_rgb_set_verbose"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gboolean"))
     :c-arg-names (verbose)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:134 <998> 
;; void gdk_rgb_set_install( gboolean install);
(ff:bind-c-function gdk_rgb_set_install
     :unconverted-entry-name "gdk_rgb_set_install"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gboolean"))
     :c-arg-names (install)
     :arguments (gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:137 <999> 
;; void gdk_rgb_set_min_colors( gint min_colors);
(ff:bind-c-function gdk_rgb_set_min_colors
     :unconverted-entry-name "gdk_rgb_set_min_colors"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint"))
     :c-arg-names (min_colors)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:140 <1000> 
;; GdkColormap* gdk_rgb_get_cmap( void);
(ff:bind-c-function gdk_rgb_get_cmap
     :unconverted-entry-name "gdk_rgb_get_cmap"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gdk/gdkrgb.h:143 <1001> 
;; GdkVisual* gdk_rgb_get_visual( void);
(ff:bind-c-function gdk_rgb_get_visual
     :unconverted-entry-name "gdk_rgb_get_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:41 <1002> 
;; typedef enum {
;;         GTK_TYPE_INVALID, GTK_TYPE_NONE, GTK_TYPE_CHAR, GTK_TYPE_UCHAR,
;;   GTK_TYPE_BOOL,
;;              GTK_TYPE_INT, GTK_TYPE_UINT, GTK_TYPE_LONG, GTK_TYPE_ULONG,
;;   GTK_TYPE_FLOAT,
;;              GTK_TYPE_DOUBLE, GTK_TYPE_STRING, GTK_TYPE_ENUM,
;;   GTK_TYPE_FLAGS, GTK_TYPE_BOXED,
;;              GTK_TYPE_POINTER, GTK_TYPE_SIGNAL, GTK_TYPE_ARGS,
;;   GTK_TYPE_CALLBACK, GTK_TYPE_C_CALLBACK,
;;              GTK_TYPE_FOREIGN, GTK_TYPE_OBJECT } GtkFundamentalType;
(ff:bind-c-constant GTK_TYPE_INVALID 0) ;;  GTK_TYPE_INVALID 
(ff:bind-c-constant GTK_TYPE_NONE 1) ;;  GTK_TYPE_NONE 
(ff:bind-c-constant GTK_TYPE_CHAR 2) ;;  GTK_TYPE_CHAR 
(ff:bind-c-constant GTK_TYPE_UCHAR 3) ;;  GTK_TYPE_UCHAR 
(ff:bind-c-constant GTK_TYPE_BOOL 4) ;;  GTK_TYPE_BOOL 
(ff:bind-c-constant GTK_TYPE_INT 5) ;;  GTK_TYPE_INT 
(ff:bind-c-constant GTK_TYPE_UINT 6) ;;  GTK_TYPE_UINT 
(ff:bind-c-constant GTK_TYPE_LONG 7) ;;  GTK_TYPE_LONG 
(ff:bind-c-constant GTK_TYPE_ULONG 8) ;;  GTK_TYPE_ULONG 
(ff:bind-c-constant GTK_TYPE_FLOAT 9) ;;  GTK_TYPE_FLOAT 
(ff:bind-c-constant GTK_TYPE_DOUBLE 10) ;;  GTK_TYPE_DOUBLE 
(ff:bind-c-constant GTK_TYPE_STRING 11) ;;  GTK_TYPE_STRING 
(ff:bind-c-constant GTK_TYPE_ENUM 12) ;;  GTK_TYPE_ENUM 
(ff:bind-c-constant GTK_TYPE_FLAGS 13) ;;  GTK_TYPE_FLAGS 
(ff:bind-c-constant GTK_TYPE_BOXED 14) ;;  GTK_TYPE_BOXED 
(ff:bind-c-constant GTK_TYPE_POINTER 15) ;;  GTK_TYPE_POINTER 
(ff:bind-c-constant GTK_TYPE_SIGNAL 16) ;;  GTK_TYPE_SIGNAL 
(ff:bind-c-constant GTK_TYPE_ARGS 17) ;;  GTK_TYPE_ARGS 
(ff:bind-c-constant GTK_TYPE_CALLBACK 18) ;;  GTK_TYPE_CALLBACK 
(ff:bind-c-constant GTK_TYPE_C_CALLBACK 19) ;;  GTK_TYPE_C_CALLBACK 
(ff:bind-c-constant GTK_TYPE_FOREIGN 20) ;;  GTK_TYPE_FOREIGN 
(ff:bind-c-constant GTK_TYPE_OBJECT 21) ;;  GTK_TYPE_OBJECT 
(ff:bind-c-type GtkFundamentalType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:123 <1003> 
;; typedef guint GtkType;
(ff:bind-c-type GtkType guint)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:125 <1004> 
;; typedef struct _GtkTypeObject GtkTypeObject;
(ff:bind-c-typedef _GtkTypeObject
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkTypeObject _GtkTypeObject)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:126 <1005> 
;; typedef struct _GtkTypeClass GtkTypeClass;
(ff:bind-c-typedef _GtkTypeClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkTypeClass _GtkTypeClass)  

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:3 <1006> 
;; extern GtkType GTK_TYPE_ACCEL_FLAGS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_ACCEL_FLAGS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:4 <1007> 
;; extern GtkType GTK_TYPE_CALENDAR_DISPLAY_OPTIONS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CALENDAR_DISPLAY_OPTIONS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:5 <1008> 
;; extern GtkType GTK_TYPE_CELL_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CELL_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:6 <1009> 
;; extern GtkType GTK_TYPE_CLIST_DRAG_POS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CLIST_DRAG_POS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:7 <1010> 
;; extern GtkType GTK_TYPE_BUTTON_ACTION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_BUTTON_ACTION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:8 <1011> 
;; extern GtkType GTK_TYPE_CTREE_POS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CTREE_POS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:9 <1012> 
;; extern GtkType GTK_TYPE_CTREE_LINE_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CTREE_LINE_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:10 <1013> 
;; extern GtkType GTK_TYPE_CTREE_EXPANDER_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CTREE_EXPANDER_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:11 <1014> 
;; extern GtkType GTK_TYPE_CTREE_EXPANSION_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CTREE_EXPANSION_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:12 <1015> 
;; extern GtkType GTK_TYPE_DEBUG_FLAG;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_DEBUG_FLAG"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:13 <1016> 
;; extern GtkType GTK_TYPE_DEST_DEFAULTS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_DEST_DEFAULTS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:14 <1017> 
;; extern GtkType GTK_TYPE_TARGET_FLAGS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_TARGET_FLAGS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:15 <1018> 
;; extern GtkType GTK_TYPE_ARROW_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_ARROW_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:16 <1019> 
;; extern GtkType GTK_TYPE_ATTACH_OPTIONS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_ATTACH_OPTIONS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:17 <1020> 
;; extern GtkType GTK_TYPE_BUTTON_BOX_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_BUTTON_BOX_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:18 <1021> 
;; extern GtkType GTK_TYPE_CURVE_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CURVE_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:19 <1022> 
;; extern GtkType GTK_TYPE_DIRECTION_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_DIRECTION_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:20 <1023> 
;; extern GtkType GTK_TYPE_JUSTIFICATION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_JUSTIFICATION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:21 <1024> 
;; extern GtkType GTK_TYPE_MATCH_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_MATCH_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:22 <1025> 
;; extern GtkType GTK_TYPE_MENU_DIRECTION_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_MENU_DIRECTION_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:23 <1026> 
;; extern GtkType GTK_TYPE_MENU_FACTORY_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_MENU_FACTORY_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:24 <1027> 
;; extern GtkType GTK_TYPE_METRIC_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_METRIC_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:25 <1028> 
;; extern GtkType GTK_TYPE_ORIENTATION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_ORIENTATION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:26 <1029> 
;; extern GtkType GTK_TYPE_CORNER_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CORNER_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:27 <1030> 
;; extern GtkType GTK_TYPE_PACK_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PACK_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:28 <1031> 
;; extern GtkType GTK_TYPE_PATH_PRIORITY_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PATH_PRIORITY_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:29 <1032> 
;; extern GtkType GTK_TYPE_PATH_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PATH_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:30 <1033> 
;; extern GtkType GTK_TYPE_POLICY_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_POLICY_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:31 <1034> 
;; extern GtkType GTK_TYPE_POSITION_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_POSITION_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:32 <1035> 
;; extern GtkType GTK_TYPE_PREVIEW_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PREVIEW_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:33 <1036> 
;; extern GtkType GTK_TYPE_RELIEF_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_RELIEF_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:34 <1037> 
;; extern GtkType GTK_TYPE_RESIZE_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_RESIZE_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:35 <1038> 
;; extern GtkType GTK_TYPE_SIGNAL_RUN_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SIGNAL_RUN_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:36 <1039> 
;; extern GtkType GTK_TYPE_SCROLL_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SCROLL_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:37 <1040> 
;; extern GtkType GTK_TYPE_SELECTION_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SELECTION_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:38 <1041> 
;; extern GtkType GTK_TYPE_SHADOW_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SHADOW_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:39 <1042> 
;; extern GtkType GTK_TYPE_STATE_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_STATE_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:40 <1043> 
;; extern GtkType GTK_TYPE_SUBMENU_DIRECTION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SUBMENU_DIRECTION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:41 <1044> 
;; extern GtkType GTK_TYPE_SUBMENU_PLACEMENT;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SUBMENU_PLACEMENT"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:42 <1045> 
;; extern GtkType GTK_TYPE_TOOLBAR_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_TOOLBAR_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:43 <1046> 
;; extern GtkType GTK_TYPE_TROUGH_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_TROUGH_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:44 <1047> 
;; extern GtkType GTK_TYPE_UPDATE_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_UPDATE_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:45 <1048> 
;; extern GtkType GTK_TYPE_VISIBILITY;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_VISIBILITY"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:46 <1049> 
;; extern GtkType GTK_TYPE_WINDOW_POSITION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_WINDOW_POSITION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:47 <1050> 
;; extern GtkType GTK_TYPE_WINDOW_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_WINDOW_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:48 <1051> 
;; extern GtkType GTK_TYPE_SORT_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SORT_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:49 <1052> 
;; extern GtkType GTK_TYPE_FONT_METRIC_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_FONT_METRIC_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:50 <1053> 
;; extern GtkType GTK_TYPE_FONT_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_FONT_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:51 <1054> 
;; extern GtkType GTK_TYPE_FONT_FILTER_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_FONT_FILTER_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:52 <1055> 
;; extern GtkType GTK_TYPE_OBJECT_FLAGS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_OBJECT_FLAGS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:53 <1056> 
;; extern GtkType GTK_TYPE_ARG_FLAGS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_ARG_FLAGS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:54 <1057> 
;; extern GtkType GTK_TYPE_PACKER_OPTIONS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PACKER_OPTIONS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:55 <1058> 
;; extern GtkType GTK_TYPE_SIDE_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SIDE_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:56 <1059> 
;; extern GtkType GTK_TYPE_ANCHOR_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_ANCHOR_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:57 <1060> 
;; extern GtkType GTK_TYPE_PRIVATE_FLAGS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PRIVATE_FLAGS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:58 <1061> 
;; extern GtkType GTK_TYPE_PROGRESS_BAR_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PROGRESS_BAR_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:59 <1062> 
;; extern GtkType GTK_TYPE_PROGRESS_BAR_ORIENTATION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_PROGRESS_BAR_ORIENTATION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:60 <1063> 
;; extern GtkType GTK_TYPE_RC_FLAGS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_RC_FLAGS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:61 <1064> 
;; extern GtkType GTK_TYPE_RC_TOKEN_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_RC_TOKEN_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:62 <1065> 
;; extern GtkType GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SPIN_BUTTON_UPDATE_POLICY"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:63 <1066> 
;; extern GtkType GTK_TYPE_SPIN_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SPIN_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:64 <1067> 
;; extern GtkType GTK_TYPE_TOOLBAR_CHILD_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_TOOLBAR_CHILD_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:65 <1068> 
;; extern GtkType GTK_TYPE_TOOLBAR_SPACE_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_TOOLBAR_SPACE_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:66 <1069> 
;; extern GtkType GTK_TYPE_TREE_VIEW_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_TREE_VIEW_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:67 <1070> 
;; extern GtkType GTK_TYPE_FUNDAMENTAL_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_FUNDAMENTAL_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:68 <1071> 
;; extern GtkType GTK_TYPE_WIDGET_FLAGS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_WIDGET_FLAGS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:69 <1072> 
;; extern GtkType GTK_TYPE_GDK_WINDOW_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_WINDOW_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:70 <1073> 
;; extern GtkType GTK_TYPE_GDK_WINDOW_CLASS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_WINDOW_CLASS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:71 <1074> 
;; extern GtkType GTK_TYPE_GDK_IMAGE_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_IMAGE_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:72 <1075> 
;; extern GtkType GTK_TYPE_GDK_VISUAL_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_VISUAL_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:73 <1076> 
;; extern GtkType GTK_TYPE_GDK_FONT_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_FONT_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:74 <1077> 
;; extern GtkType GTK_TYPE_GDK_WINDOW_ATTRIBUTES_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_WINDOW_ATTRIBUTES_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:75 <1078> 
;; extern GtkType GTK_TYPE_GDK_WINDOW_HINTS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_WINDOW_HINTS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:76 <1079> 
;; extern GtkType GTK_TYPE_GDK_FUNCTION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_FUNCTION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:77 <1080> 
;; extern GtkType GTK_TYPE_GDK_FILL;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_FILL"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:78 <1081> 
;; extern GtkType GTK_TYPE_GDK_FILL_RULE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_FILL_RULE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:79 <1082> 
;; extern GtkType GTK_TYPE_GDK_LINE_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_LINE_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:80 <1083> 
;; extern GtkType GTK_TYPE_GDK_CAP_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_CAP_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:81 <1084> 
;; extern GtkType GTK_TYPE_GDK_JOIN_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_JOIN_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:82 <1085> 
;; extern GtkType GTK_TYPE_GDK_CURSOR_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_CURSOR_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:83 <1086> 
;; extern GtkType GTK_TYPE_GDK_FILTER_RETURN;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_FILTER_RETURN"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:84 <1087> 
;; extern GtkType GTK_TYPE_GDK_VISIBILITY_STATE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_VISIBILITY_STATE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:85 <1088> 
;; extern GtkType GTK_TYPE_GDK_EVENT_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_EVENT_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:86 <1089> 
;; extern GtkType GTK_TYPE_GDK_EVENT_MASK;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_EVENT_MASK"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:87 <1090> 
;; extern GtkType GTK_TYPE_GDK_NOTIFY_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_NOTIFY_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:88 <1091> 
;; extern GtkType GTK_TYPE_GDK_CROSSING_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_CROSSING_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:89 <1092> 
;; extern GtkType GTK_TYPE_GDK_MODIFIER_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_MODIFIER_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:90 <1093> 
;; extern GtkType GTK_TYPE_GDK_SUBWINDOW_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_SUBWINDOW_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:91 <1094> 
;; extern GtkType GTK_TYPE_GDK_INPUT_CONDITION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_INPUT_CONDITION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:92 <1095> 
;; extern GtkType GTK_TYPE_GDK_STATUS;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_STATUS"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:93 <1096> 
;; extern GtkType GTK_TYPE_GDK_BYTE_ORDER;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_BYTE_ORDER"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:94 <1097> 
;; extern GtkType GTK_TYPE_GDK_GC_VALUES_MASK;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_GC_VALUES_MASK"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:95 <1098> 
;; extern GtkType GTK_TYPE_GDK_SELECTION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_SELECTION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:96 <1099> 
;; extern GtkType GTK_TYPE_GDK_PROPERTY_STATE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_PROPERTY_STATE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:97 <1100> 
;; extern GtkType GTK_TYPE_GDK_PROP_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_PROP_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:98 <1101> 
;; extern GtkType GTK_TYPE_GDK_INPUT_SOURCE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_INPUT_SOURCE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:99 <1102> 
;; extern GtkType GTK_TYPE_GDK_INPUT_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_INPUT_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:100 <1103> 
;; extern GtkType GTK_TYPE_GDK_AXIS_USE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_AXIS_USE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:101 <1104> 
;; extern GtkType GTK_TYPE_GDK_TARGET;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_TARGET"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:102 <1105> 
;; extern GtkType GTK_TYPE_GDK_SELECTION_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_SELECTION_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:103 <1106> 
;; extern GtkType GTK_TYPE_GDK_EXTENSION_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_EXTENSION_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:104 <1107> 
;; extern GtkType GTK_TYPE_GDK_IM_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_IM_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:105 <1108> 
;; extern GtkType GTK_TYPE_GDK_IC_ATTRIBUTES_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_IC_ATTRIBUTES_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:106 <1109> 
;; extern GtkType GTK_TYPE_GDK_WM_DECORATION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_WM_DECORATION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:107 <1110> 
;; extern GtkType GTK_TYPE_GDK_WM_FUNCTION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_WM_FUNCTION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:108 <1111> 
;; extern GtkType GTK_TYPE_GDK_COLOR_CONTEXT_MODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_COLOR_CONTEXT_MODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:109 <1112> 
;; extern GtkType GTK_TYPE_GDK_OVERLAP_TYPE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_OVERLAP_TYPE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:110 <1113> 
;; extern GtkType GTK_TYPE_GDK_DRAG_ACTION;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_DRAG_ACTION"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:111 <1114> 
;; extern GtkType GTK_TYPE_GDK_DRAG_PROTOCOL;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_DRAG_PROTOCOL"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:112 <1115> 
;; extern GtkType GTK_TYPE_GDK_RGB_DITHER;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_RGB_DITHER"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:113 <1116> 
;; extern GtkType GTK_TYPE_ACCEL_GROUP;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_ACCEL_GROUP"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:114 <1117> 
;; extern GtkType GTK_TYPE_SELECTION_DATA;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_SELECTION_DATA"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:115 <1118> 
;; extern GtkType GTK_TYPE_STYLE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_STYLE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:116 <1119> 
;; extern GtkType GTK_TYPE_CTREE_NODE;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_CTREE_NODE"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:117 <1120> 
;; extern GtkType GTK_TYPE_GDK_COLORMAP;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_COLORMAP"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:118 <1121> 
;; extern GtkType GTK_TYPE_GDK_VISUAL;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_VISUAL"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:119 <1122> 
;; extern GtkType GTK_TYPE_GDK_FONT;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_FONT"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:120 <1123> 
;; extern GtkType GTK_TYPE_GDK_WINDOW;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_WINDOW"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:121 <1124> 
;; extern GtkType GTK_TYPE_GDK_DRAG_CONTEXT;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_DRAG_CONTEXT"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:122 <1125> 
;; extern GtkType GTK_TYPE_GDK_EVENT;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_EVENT"))

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypebuiltins.h:123 <1126> 
;; extern GtkType GTK_TYPE_GDK_COLOR;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "GTK_TYPE_GDK_COLOR"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:142 <1127> 
;; GtkType gtk_identifier_get_type( void);
(ff:bind-c-function gtk_identifier_get_type
     :unconverted-entry-name "gtk_identifier_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:150 <1128> 
;; typedef struct _GtkArg GtkArg;
(ff:bind-c-typedef _GtkArg ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkArg _GtkArg)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:151 <1129> 
;; typedef struct _GtkObject GtkObject;
(ff:bind-c-typedef _GtkObject ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkObject _GtkObject)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:152 <1130> 
;; typedef struct _GtkTypeInfo GtkTypeInfo;
(ff:bind-c-typedef _GtkTypeInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkTypeInfo _GtkTypeInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:153 <1131> 
;; typedef struct _GtkTypeQuery GtkTypeQuery;
(ff:bind-c-typedef _GtkTypeQuery
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkTypeQuery _GtkTypeQuery)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:154 <1132> 
;; typedef struct _GtkEnumValue GtkEnumValue;
(ff:bind-c-typedef _GtkEnumValue
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkEnumValue _GtkEnumValue)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:155 <1133> 
;; typedef struct _GtkEnumValue GtkFlagValue;
(ff:bind-c-type GtkFlagValue _GtkEnumValue)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:160 <1134> 
;; typedef void(* GtkClassInitFunc)( gpointer klass);
(ff:bind-c-type GtkClassInitFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:161 <1135> 
;; typedef void(* GtkObjectInitFunc)( gpointer object, gpointer klass);
(ff:bind-c-type GtkObjectInitFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:163 <1136> 
;; typedef void(* GtkSignalFunc)();
(ff:bind-c-type GtkSignalFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:164 <1137> 
;; typedef gint(* GtkFunction)( gpointer data);
(ff:bind-c-type GtkFunction (* gint))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:165 <1138> 
;; typedef void(* GtkDestroyNotify)( gpointer data);
(ff:bind-c-type GtkDestroyNotify (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:166 <1139> 
;; typedef void(* GtkCallbackMarshal)( GtkObject* object, gpointer data,
;;              guint n_args, GtkArg* args);
(ff:bind-c-type GtkCallbackMarshal (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:170 <1140> 
;; typedef void(* GtkSignalMarshaller)( GtkObject* object, GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-type GtkSignalMarshaller (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:176 <1141> 
;; typedef void(* GtkArgGetFunc)( GtkObject*, GtkArg*, guint);
(ff:bind-c-type GtkArgGetFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:177 <1142> 
;; typedef void(* GtkArgSetFunc)( GtkObject*, GtkArg*, guint);
(ff:bind-c-type GtkArgSetFunc (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:185 <1143> 
;; struct _GtkTypeObject { GtkTypeClass* klass; };
(ff:bind-c-type _GtkTypeObject (:struct
  (klass (* GtkTypeClass))   ;; GtkTypeClass* klass
  ))   ;; bind-c-type _GtkTypeObject

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:200 <1144> 
;; struct _GtkTypeClass { GtkType type; };
(ff:bind-c-type _GtkTypeClass (:struct
  (type GtkType)   ;; GtkType type
  ))   ;; bind-c-type _GtkTypeClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:209 <1145> 
;; struct _GtkArg {
;;         GtkType type; gchar* name; union {
;;         gchar char_data; guchar uchar_data; gboolean bool_data; gint
;;   int_data;
;;              guint uint_data; glong long_data; gulong ulong_data; gfloat
;;   float_data;
;;              gdouble double_data; gchar* string_data; gpointer
;;   pointer_data; GtkObject
;;   * object_data; struct {
;;         GtkSignalFunc f; gpointer d; } signal_data; struct {
;;         gint n_args; GtkArg* args; } args_data; struct {
;;         GtkCallbackMarshal marshal; gpointer data; GtkDestroyNotify
;;   notify; }
;;    callback_data; struct {
;;         GtkFunction func; gpointer func_data; } c_callback_data; struct
;;   {
;;         gpointer data; GtkDestroyNotify notify; } foreign_data; } d; };
(ff:bind-c-type _GtkArg (:struct
  (type GtkType)   ;; GtkType type
  (name (* gchar))   ;; gchar* name
  (d (:union   ;; union{} d
    (char_data gchar)   ;; gchar char_data
    (uchar_data guchar)   ;; guchar uchar_data
    (bool_data gboolean)   ;; gboolean bool_data
    (int_data gint)   ;; gint int_data
    (uint_data guint)   ;; guint uint_data
    (long_data glong)   ;; glong long_data
    (ulong_data gulong)   ;; gulong ulong_data
    (float_data gfloat)   ;; gfloat float_data
    (double_data gdouble)   ;; gdouble double_data
    (string_data (* gchar))   ;; gchar* string_data
    (pointer_data gpointer)   ;; gpointer pointer_data
    (object_data (* GtkObject))   ;; GtkObject* object_data
    (signal_data (:struct   ;; struct{} signal_data
      (f GtkSignalFunc)   ;; GtkSignalFunc f
      (d gpointer)   ;; gpointer d
      ))  ;; slot signal_data
    (args_data (:struct   ;; struct{} args_data
      (n_args gint)   ;; gint n_args
      (args (* GtkArg))   ;; GtkArg* args
      ))  ;; slot args_data
    (callback_data (:struct   ;; struct{} callback_data
      (marshal GtkCallbackMarshal)   ;; GtkCallbackMarshal marshal
      (data gpointer)   ;; gpointer data
      (notify GtkDestroyNotify)   ;; GtkDestroyNotify notify
      ))  ;; slot callback_data
    (c_callback_data (:struct   ;; struct{} c_callback_data
      (func GtkFunction)   ;; GtkFunction func
      (func_data gpointer)   ;; gpointer func_data
      ))  ;; slot c_callback_data
    (foreign_data (:struct   ;; struct{} foreign_data
      (data gpointer)   ;; gpointer data
      (notify GtkDestroyNotify)   ;; GtkDestroyNotify notify
      ))  ;; slot foreign_data
    ))  ;; slot d
  ))   ;; bind-c-type _GtkArg

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:311 <1146> 
;; struct _GtkTypeInfo {
;;         gchar* type_name; guint object_size; guint class_size;
;;   GtkClassInitFunc
;;    class_init_func; GtkObjectInitFunc object_init_func; gpointer
;;   reserved_1;
;;              gpointer reserved_2; GtkClassInitFunc base_class_init_func;
;;   };
(ff:bind-c-type _GtkTypeInfo (:struct
  (type_name (* gchar))   ;; gchar* type_name
  (object_size guint)   ;; guint object_size
  (class_size guint)   ;; guint class_size
  (class_init_func GtkClassInitFunc)   ;; GtkClassInitFunc class_init_func
  (object_init_func GtkObjectInitFunc)   ;;
  ;;  GtkObjectInitFunc object_init_func
  (reserved_1 gpointer)   ;; gpointer reserved_1
  (reserved_2 gpointer)   ;; gpointer reserved_2
  (base_class_init_func GtkClassInitFunc)   ;;
  ;;  GtkClassInitFunc base_class_init_func
  ))   ;; bind-c-type _GtkTypeInfo

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:323 <1147> 
;; struct _GtkTypeQuery {
;;         GtkType type; const gchar* type_name; guint object_size; guint
;;   class_size;
;;    };
(ff:bind-c-type _GtkTypeQuery (:struct
  (type GtkType)   ;; GtkType type
  (type_name (* gchar))   ;; const gchar* type_name
  (object_size guint)   ;; guint object_size
  (class_size guint)   ;; guint class_size
  ))   ;; bind-c-type _GtkTypeQuery

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:331 <1148> 
;; struct _GtkEnumValue {
;;         guint value; gchar* value_name; gchar* value_nick; };
(ff:bind-c-type _GtkEnumValue (:struct
  (value guint)   ;; guint value
  (value_name (* gchar))   ;; gchar* value_name
  (value_nick (* gchar))   ;; gchar* value_nick
  ))   ;; bind-c-type _GtkEnumValue

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:339 <1149> 
;; void gtk_type_init( void);
(ff:bind-c-function gtk_type_init
     :unconverted-entry-name "gtk_type_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:340 <1150> 
;; GtkType gtk_type_unique( GtkType parent_type, const GtkTypeInfo*
;;   type_info
;;   );
(ff:bind-c-function gtk_type_unique
     :unconverted-entry-name "gtk_type_unique"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types (("GtkType") ("const" "GtkTypeInfo" "*"))
     :c-arg-names (parent_type type_info)
     :arguments (GtkType (* GtkTypeInfo))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:342 <1151> 
;; void gtk_type_set_chunk_alloc( GtkType type, guint n_chunks);
(ff:bind-c-function gtk_type_set_chunk_alloc
     :unconverted-entry-name "gtk_type_set_chunk_alloc"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkType") ("guint"))
     :c-arg-names (type n_chunks)
     :arguments (GtkType guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:344 <1152> 
;; gchar* gtk_type_name( guint type);
(ff:bind-c-function gtk_type_name
     :unconverted-entry-name "gtk_type_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("guint"))
     :c-arg-names (type)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:345 <1153> 
;; GtkType gtk_type_from_name( const gchar* name);
(ff:bind-c-function gtk_type_from_name
     :unconverted-entry-name "gtk_type_from_name"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:346 <1154> 
;; GtkType gtk_type_parent( GtkType type);
(ff:bind-c-function gtk_type_parent
     :unconverted-entry-name "gtk_type_parent"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types (("GtkType"))
     :c-arg-names (type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:347 <1155> 
;; gpointer gtk_type_class( GtkType type);
(ff:bind-c-function gtk_type_class
     :unconverted-entry-name "gtk_type_class"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GtkType"))
     :c-arg-names (type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:348 <1156> 
;; gpointer gtk_type_parent_class( GtkType type);
(ff:bind-c-function gtk_type_parent_class
     :unconverted-entry-name "gtk_type_parent_class"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GtkType"))
     :c-arg-names (type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:349 <1157> 
;; GList* gtk_type_children_types( GtkType type);
(ff:bind-c-function gtk_type_children_types
     :unconverted-entry-name "gtk_type_children_types"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GtkType"))
     :c-arg-names (type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:350 <1158> 
;; gpointer gtk_type_new( GtkType type);
(ff:bind-c-function gtk_type_new
     :unconverted-entry-name "gtk_type_new"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GtkType"))
     :c-arg-names (type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:351 <1159> 
;; void gtk_type_free( GtkType type, gpointer mem);
(ff:bind-c-function gtk_type_free
     :unconverted-entry-name "gtk_type_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkType") ("gpointer"))
     :c-arg-names (type mem)
     :arguments (GtkType gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:353 <1160> 
;; void gtk_type_describe_heritage( GtkType type);
(ff:bind-c-function gtk_type_describe_heritage
     :unconverted-entry-name "gtk_type_describe_heritage"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkType"))
     :c-arg-names (type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:354 <1161> 
;; void gtk_type_describe_tree( GtkType type, gboolean show_size);
(ff:bind-c-function gtk_type_describe_tree
     :unconverted-entry-name "gtk_type_describe_tree"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkType") ("gboolean"))
     :c-arg-names (type show_size)
     :arguments (GtkType gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:356 <1162> 
;; gboolean gtk_type_is_a( GtkType type, GtkType is_a_type);
(ff:bind-c-function gtk_type_is_a
     :unconverted-entry-name "gtk_type_is_a"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkType") ("GtkType"))
     :c-arg-names (type is_a_type)
     :arguments (GtkType GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:358 <1163> 
;; GtkTypeObject* gtk_type_check_object_cast( GtkTypeObject* type_object,
;;              GtkType cast_type);
(ff:bind-c-function gtk_type_check_object_cast
     :unconverted-entry-name "gtk_type_check_object_cast"
     :c-return-type ("GtkTypeObject" "*")
     :return-type (* GtkTypeObject)
     :c-arg-types (("GtkTypeObject" "*") ("GtkType"))
     :c-arg-names (type_object cast_type)
     :arguments ((* GtkTypeObject) GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:360 <1164> 
;; GtkTypeClass* gtk_type_check_class_cast( GtkTypeClass* klass, GtkType
;;    cast_type);
(ff:bind-c-function gtk_type_check_class_cast
     :unconverted-entry-name "gtk_type_check_class_cast"
     :c-return-type ("GtkTypeClass" "*")
     :return-type (* GtkTypeClass)
     :c-arg-types (("GtkTypeClass" "*") ("GtkType"))
     :c-arg-names (klass cast_type)
     :arguments ((* GtkTypeClass) GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:362 <1165> 
;; GtkType gtk_type_register_enum( const gchar* type_name, GtkEnumValue*
;;    values);
(ff:bind-c-function gtk_type_register_enum
     :unconverted-entry-name "gtk_type_register_enum"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types (("const" "gchar" "*") ("GtkEnumValue" "*"))
     :c-arg-names (type_name values)
     :arguments ((* gchar) (* GtkEnumValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:364 <1166> 
;; GtkType gtk_type_register_flags( const gchar* type_name, GtkFlagValue
;;   * values);
(ff:bind-c-function gtk_type_register_flags
     :unconverted-entry-name "gtk_type_register_flags"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types (("const" "gchar" "*") ("GtkFlagValue" "*"))
     :c-arg-names (type_name values)
     :arguments ((* gchar) (* GtkFlagValue))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:366 <1167> 
;; GtkEnumValue* gtk_type_enum_get_values( GtkType enum_type);
(ff:bind-c-function gtk_type_enum_get_values
     :unconverted-entry-name "gtk_type_enum_get_values"
     :c-return-type ("GtkEnumValue" "*")
     :return-type (* GtkEnumValue)
     :c-arg-types (("GtkType"))
     :c-arg-names (enum_type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:367 <1168> 
;; GtkFlagValue* gtk_type_flags_get_values( GtkType flags_type);
(ff:bind-c-function gtk_type_flags_get_values
     :unconverted-entry-name "gtk_type_flags_get_values"
     :c-return-type ("GtkFlagValue" "*")
     :return-type (* GtkFlagValue)
     :c-arg-types (("GtkType"))
     :c-arg-names (flags_type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:368 <1169> 
;; GtkEnumValue* gtk_type_enum_find_value( GtkType enum_type, const gchar
;;   * value_name);
(ff:bind-c-function gtk_type_enum_find_value
     :unconverted-entry-name "gtk_type_enum_find_value"
     :c-return-type ("GtkEnumValue" "*")
     :return-type (* GtkEnumValue)
     :c-arg-types (("GtkType") ("const" "gchar" "*"))
     :c-arg-names (enum_type value_name)
     :arguments (GtkType (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:370 <1170> 
;; GtkFlagValue* gtk_type_flags_find_value( GtkType flag_type, const gchar
;;   * value_name);
(ff:bind-c-function gtk_type_flags_find_value
     :unconverted-entry-name "gtk_type_flags_find_value"
     :c-return-type ("GtkFlagValue" "*")
     :return-type (* GtkFlagValue)
     :c-arg-types (("GtkType") ("const" "gchar" "*"))
     :c-arg-names (flag_type value_name)
     :arguments (GtkType (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:373 <1171> 
;; void gtk_type_set_varargs_type( GtkType foreign_type, GtkType
;;   varargs_type
;;   );
(ff:bind-c-function gtk_type_set_varargs_type
     :unconverted-entry-name "gtk_type_set_varargs_type"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkType") ("GtkType"))
     :c-arg-names (foreign_type varargs_type)
     :arguments (GtkType GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:375 <1172> 
;; GtkType gtk_type_get_varargs_type( GtkType foreign_type);
(ff:bind-c-function gtk_type_get_varargs_type
     :unconverted-entry-name "gtk_type_get_varargs_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types (("GtkType"))
     :c-arg-names (foreign_type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktypeutils.h:380 <1173> 
;; GtkTypeQuery* gtk_type_query( GtkType type);
(ff:bind-c-function gtk_type_query
     :unconverted-entry-name "gtk_type_query"
     :c-return-type ("GtkTypeQuery" "*")
     :return-type (* GtkTypeQuery)
     :c-arg-types (("GtkType"))
     :c-arg-names (type)
     :arguments (GtkType)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:41 <1174> 
;; typedef struct _GtkArgInfo GtkArgInfo;
(ff:bind-c-typedef _GtkArgInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkArgInfo _GtkArgInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:43 <1175> 
;; struct _GtkArgInfo {
;;         GtkType class_type; gchar* name; GtkType type; guint arg_flags;
;;   gchar
;;   * full_name; guint arg_id; guint seq_id; };
(ff:bind-c-type _GtkArgInfo (:struct
  (class_type GtkType)   ;; GtkType class_type
  (name (* gchar))   ;; gchar* name
  (type GtkType)   ;; GtkType type
  (arg_flags guint)   ;; guint arg_flags
  (full_name (* gchar))   ;; gchar* full_name
  (arg_id guint)   ;; guint arg_id
  (seq_id guint)   ;; guint seq_id
  ))   ;; bind-c-type _GtkArgInfo

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:61 <1176> 
;; GtkArg* gtk_arg_new( GtkType arg_type);
(ff:bind-c-function gtk_arg_new
     :unconverted-entry-name "gtk_arg_new"
     :c-return-type ("GtkArg" "*")
     :return-type (* GtkArg)
     :c-arg-types (("GtkType"))
     :c-arg-names (arg_type)
     :arguments (GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:62 <1177> 
;; GtkArg* gtk_arg_copy( GtkArg* src_arg, GtkArg* dest_arg);
(ff:bind-c-function gtk_arg_copy
     :unconverted-entry-name "gtk_arg_copy"
     :c-return-type ("GtkArg" "*")
     :return-type (* GtkArg)
     :c-arg-types (("GtkArg" "*") ("GtkArg" "*"))
     :c-arg-names (src_arg dest_arg)
     :arguments ((* GtkArg) (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:64 <1178> 
;; void gtk_arg_free( GtkArg* arg, gboolean free_contents);
(ff:bind-c-function gtk_arg_free
     :unconverted-entry-name "gtk_arg_free"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkArg" "*") ("gboolean"))
     :c-arg-names (arg free_contents)
     :arguments ((* GtkArg) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:66 <1179> 
;; void gtk_arg_reset( GtkArg* arg);
(ff:bind-c-function gtk_arg_reset
     :unconverted-entry-name "gtk_arg_reset"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkArg" "*"))
     :c-arg-names (arg)
     :arguments ((* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:67 <1180> 
;; gboolean gtk_arg_values_equal( const GtkArg* arg1, const GtkArg* arg2);
(ff:bind-c-function gtk_arg_values_equal
     :unconverted-entry-name "gtk_arg_values_equal"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "GtkArg" "*") ("const" "GtkArg" "*"))
     :c-arg-names (arg1 arg2)
     :arguments ((* GtkArg) (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:69 <1181> 
;; gchar* gtk_args_collect( GtkType object_type, GHashTable*
;;   arg_info_hash_table,
;;              GSList** arg_list_p, GSList** info_list_p, const gchar*
;;   first_arg_name,
;;              va_list var_args);
(ff:bind-c-function gtk_args_collect
     :unconverted-entry-name "gtk_args_collect"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkType") ("GHashTable" "*") ("GSList" "*" "*")
                   ("GSList" "*" "*") ("const" "gchar" "*") ("va_list"))
     :c-arg-names (object_type arg_info_hash_table arg_list_p info_list_p
                   first_arg_name var_args)
     :arguments (GtkType (* GHashTable) (* (* GSList)) (* (* GSList))
                 (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:75 <1182> 
;; void gtk_args_collect_cleanup( GSList* arg_list, GSList* info_list);
(ff:bind-c-function gtk_args_collect_cleanup
     :unconverted-entry-name "gtk_args_collect_cleanup"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GSList" "*") ("GSList" "*"))
     :c-arg-names (arg_list info_list)
     :arguments ((* GSList) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:77 <1183> 
;; gchar* gtk_arg_get_info( GtkType object_type, GHashTable*
;;   arg_info_hash_table,
;;              const gchar* arg_name, GtkArgInfo** info_p);
(ff:bind-c-function gtk_arg_get_info
     :unconverted-entry-name "gtk_arg_get_info"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkType") ("GHashTable" "*") ("const" "gchar" "*")
                   ("GtkArgInfo" "*" "*"))
     :c-arg-names (object_type arg_info_hash_table arg_name info_p)
     :arguments (GtkType (* GHashTable) (* gchar) (* (* GtkArgInfo)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:81 <1184> 
;; GtkArgInfo* gtk_arg_type_new_static( GtkType base_class_type, const
;;   gchar
;;   * arg_name, guint class_n_args_offset, GHashTable*
;;   arg_info_hash_table,
;;              GtkType arg_type, guint arg_flags, guint arg_id);
(ff:bind-c-function gtk_arg_type_new_static
     :unconverted-entry-name "gtk_arg_type_new_static"
     :c-return-type ("GtkArgInfo" "*")
     :return-type (* GtkArgInfo)
     :c-arg-types (("GtkType") ("const" "gchar" "*") ("guint")
                   ("GHashTable" "*") ("GtkType") ("guint") ("guint"))
     :c-arg-names (base_class_type arg_name class_n_args_offset
                   arg_info_hash_table arg_type arg_flags arg_id)
     :arguments (GtkType (* gchar) guint (* GHashTable) GtkType guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:88 <1185> 
;; GtkArg* gtk_args_query( GtkType class_type, GHashTable*
;;   arg_info_hash_table,
;;              guint32** arg_flags, guint* n_args_p);
(ff:bind-c-function gtk_args_query
     :unconverted-entry-name "gtk_args_query"
     :c-return-type ("GtkArg" "*")
     :return-type (* GtkArg)
     :c-arg-types (("GtkType") ("GHashTable" "*") ("guint32" "*" "*")
                   ("guint" "*"))
     :c-arg-names (class_type arg_info_hash_table arg_flags n_args_p)
     :arguments (GtkType (* GHashTable) (* (* guint32)) (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:92 <1186> 
;; gchar* gtk_arg_name_strip_type( const gchar* arg_name);
(ff:bind-c-function gtk_arg_name_strip_type
     :unconverted-entry-name "gtk_arg_name_strip_type"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (arg_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:93 <1187> 
;; gint gtk_arg_info_equal( gconstpointer arg_info_1, gconstpointer
;;   arg_info_2
;;   );
(ff:bind-c-function gtk_arg_info_equal
     :unconverted-entry-name "gtk_arg_info_equal"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("gconstpointer") ("gconstpointer"))
     :c-arg-names (arg_info_1 arg_info_2)
     :arguments (gconstpointer gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:95 <1188> 
;; guint gtk_arg_info_hash( gconstpointer arg_info);
(ff:bind-c-function gtk_arg_info_hash
     :unconverted-entry-name "gtk_arg_info_hash"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("gconstpointer"))
     :c-arg-names (arg_info)
     :arguments (gconstpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarg.h:96 <1189> 
;; void gtk_arg_to_valueloc( GtkArg* arg, gpointer value_pointer);
(ff:bind-c-function gtk_arg_to_valueloc
     :unconverted-entry-name "gtk_arg_to_valueloc"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkArg" "*") ("gpointer"))
     :c-arg-names (arg value_pointer)
     :arguments ((* GtkArg) gpointer)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:35 <1190> 
;; typedef enum {
;;         GTK_ARROW_UP, GTK_ARROW_DOWN, GTK_ARROW_LEFT, GTK_ARROW_RIGHT }
;;   GtkArrowType
;;   ;
(ff:bind-c-constant GTK_ARROW_UP 0) ;;  GTK_ARROW_UP 
(ff:bind-c-constant GTK_ARROW_DOWN 1) ;;  GTK_ARROW_DOWN 
(ff:bind-c-constant GTK_ARROW_LEFT 2) ;;  GTK_ARROW_LEFT 
(ff:bind-c-constant GTK_ARROW_RIGHT 3) ;;  GTK_ARROW_RIGHT 
(ff:bind-c-type GtkArrowType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:44 <1191> 
;; typedef enum {
;;         GTK_EXPAND =  0x000000001 LSHIFT  0x000000000, GTK_SHRINK =
;;   0x000000001
;;    LSHIFT  0x000000001, GTK_FILL =  0x000000001 LSHIFT  0x000000002 }
;;   GtkAttachOptions
;;   ;
(ff:bind-c-constant GTK_EXPAND
                    1) ;;
;;   GTK_EXPAND =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_SHRINK
                    2) ;;
;;   GTK_SHRINK =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_FILL
                    4) ;;
;;   GTK_FILL =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-type GtkAttachOptions :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:52 <1192> 
;; typedef enum {
;;         GTK_BUTTONBOX_DEFAULT_STYLE, GTK_BUTTONBOX_SPREAD,
;;   GTK_BUTTONBOX_EDGE,
;;              GTK_BUTTONBOX_START, GTK_BUTTONBOX_END } GtkButtonBoxStyle;
(ff:bind-c-constant GTK_BUTTONBOX_DEFAULT_STYLE
                    0) ;;
;;   GTK_BUTTONBOX_DEFAULT_STYLE 
(ff:bind-c-constant GTK_BUTTONBOX_SPREAD 1) ;;  GTK_BUTTONBOX_SPREAD 
(ff:bind-c-constant GTK_BUTTONBOX_EDGE 2) ;;  GTK_BUTTONBOX_EDGE 
(ff:bind-c-constant GTK_BUTTONBOX_START 3) ;;  GTK_BUTTONBOX_START 
(ff:bind-c-constant GTK_BUTTONBOX_END 4) ;;  GTK_BUTTONBOX_END 
(ff:bind-c-type GtkButtonBoxStyle :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:62 <1193> 
;; typedef enum {
;;         GTK_CURVE_TYPE_LINEAR, GTK_CURVE_TYPE_SPLINE,
;;   GTK_CURVE_TYPE_FREE } GtkCurveType
;;   ;
(ff:bind-c-constant GTK_CURVE_TYPE_LINEAR 0) ;;  GTK_CURVE_TYPE_LINEAR 
(ff:bind-c-constant GTK_CURVE_TYPE_SPLINE 1) ;;  GTK_CURVE_TYPE_SPLINE 
(ff:bind-c-constant GTK_CURVE_TYPE_FREE 2) ;;  GTK_CURVE_TYPE_FREE 
(ff:bind-c-type GtkCurveType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:70 <1194> 
;; typedef enum {
;;         GTK_DIR_TAB_FORWARD, GTK_DIR_TAB_BACKWARD, GTK_DIR_UP,
;;   GTK_DIR_DOWN, GTK_DIR_LEFT,
;;              GTK_DIR_RIGHT } GtkDirectionType;
(ff:bind-c-constant GTK_DIR_TAB_FORWARD 0) ;;  GTK_DIR_TAB_FORWARD 
(ff:bind-c-constant GTK_DIR_TAB_BACKWARD 1) ;;  GTK_DIR_TAB_BACKWARD 
(ff:bind-c-constant GTK_DIR_UP 2) ;;  GTK_DIR_UP 
(ff:bind-c-constant GTK_DIR_DOWN 3) ;;  GTK_DIR_DOWN 
(ff:bind-c-constant GTK_DIR_LEFT 4) ;;  GTK_DIR_LEFT 
(ff:bind-c-constant GTK_DIR_RIGHT 5) ;;  GTK_DIR_RIGHT 
(ff:bind-c-type GtkDirectionType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:81 <1195> 
;; typedef enum {
;;         GTK_JUSTIFY_LEFT, GTK_JUSTIFY_RIGHT, GTK_JUSTIFY_CENTER,
;;   GTK_JUSTIFY_FILL
;;    } GtkJustification;
(ff:bind-c-constant GTK_JUSTIFY_LEFT 0) ;;  GTK_JUSTIFY_LEFT 
(ff:bind-c-constant GTK_JUSTIFY_RIGHT 1) ;;  GTK_JUSTIFY_RIGHT 
(ff:bind-c-constant GTK_JUSTIFY_CENTER 2) ;;  GTK_JUSTIFY_CENTER 
(ff:bind-c-constant GTK_JUSTIFY_FILL 3) ;;  GTK_JUSTIFY_FILL 
(ff:bind-c-type GtkJustification :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:90 <1196> 
;; typedef enum {
;;         GTK_MATCH_ALL, GTK_MATCH_ALL_TAIL, GTK_MATCH_HEAD,
;;   GTK_MATCH_TAIL, GTK_MATCH_EXACT,
;;              GTK_MATCH_LAST } GtkMatchType;
(ff:bind-c-constant GTK_MATCH_ALL 0) ;;  GTK_MATCH_ALL 
(ff:bind-c-constant GTK_MATCH_ALL_TAIL 1) ;;  GTK_MATCH_ALL_TAIL 
(ff:bind-c-constant GTK_MATCH_HEAD 2) ;;  GTK_MATCH_HEAD 
(ff:bind-c-constant GTK_MATCH_TAIL 3) ;;  GTK_MATCH_TAIL 
(ff:bind-c-constant GTK_MATCH_EXACT 4) ;;  GTK_MATCH_EXACT 
(ff:bind-c-constant GTK_MATCH_LAST 5) ;;  GTK_MATCH_LAST 
(ff:bind-c-type GtkMatchType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:101 <1197> 
;; typedef enum {
;;         GTK_MENU_DIR_PARENT, GTK_MENU_DIR_CHILD, GTK_MENU_DIR_NEXT,
;;   GTK_MENU_DIR_PREV
;;    } GtkMenuDirectionType;
(ff:bind-c-constant GTK_MENU_DIR_PARENT 0) ;;  GTK_MENU_DIR_PARENT 
(ff:bind-c-constant GTK_MENU_DIR_CHILD 1) ;;  GTK_MENU_DIR_CHILD 
(ff:bind-c-constant GTK_MENU_DIR_NEXT 2) ;;  GTK_MENU_DIR_NEXT 
(ff:bind-c-constant GTK_MENU_DIR_PREV 3) ;;  GTK_MENU_DIR_PREV 
(ff:bind-c-type GtkMenuDirectionType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:109 <1198> 
;; typedef enum {
;;         GTK_MENU_FACTORY_MENU, GTK_MENU_FACTORY_MENU_BAR,
;;   GTK_MENU_FACTORY_OPTION_MENU
;;    } GtkMenuFactoryType;
(ff:bind-c-constant GTK_MENU_FACTORY_MENU 0) ;;  GTK_MENU_FACTORY_MENU 
(ff:bind-c-constant GTK_MENU_FACTORY_MENU_BAR 1) ;;
;;   GTK_MENU_FACTORY_MENU_BAR 
(ff:bind-c-constant GTK_MENU_FACTORY_OPTION_MENU
                    2) ;;
;;   GTK_MENU_FACTORY_OPTION_MENU 
(ff:bind-c-type GtkMenuFactoryType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:116 <1199> 
;; typedef enum { GTK_PIXELS, GTK_INCHES, GTK_CENTIMETERS } GtkMetricType;
(ff:bind-c-constant GTK_PIXELS 0) ;;  GTK_PIXELS 
(ff:bind-c-constant GTK_INCHES 1) ;;  GTK_INCHES 
(ff:bind-c-constant GTK_CENTIMETERS 2) ;;  GTK_CENTIMETERS 
(ff:bind-c-type GtkMetricType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:124 <1200> 
;; typedef enum {
;;         GTK_ORIENTATION_HORIZONTAL, GTK_ORIENTATION_VERTICAL }
;;   GtkOrientation
;;   ;
(ff:bind-c-constant GTK_ORIENTATION_HORIZONTAL
                    0) ;;
;;   GTK_ORIENTATION_HORIZONTAL 
(ff:bind-c-constant GTK_ORIENTATION_VERTICAL 1) ;;
;;   GTK_ORIENTATION_VERTICAL 
(ff:bind-c-type GtkOrientation :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:131 <1201> 
;; typedef enum {
;;         GTK_CORNER_TOP_LEFT, GTK_CORNER_BOTTOM_LEFT,
;;   GTK_CORNER_TOP_RIGHT, GTK_CORNER_BOTTOM_RIGHT
;;    } GtkCornerType;
(ff:bind-c-constant GTK_CORNER_TOP_LEFT 0) ;;  GTK_CORNER_TOP_LEFT 
(ff:bind-c-constant GTK_CORNER_BOTTOM_LEFT 1) ;;  GTK_CORNER_BOTTOM_LEFT 
(ff:bind-c-constant GTK_CORNER_TOP_RIGHT 2) ;;  GTK_CORNER_TOP_RIGHT 
(ff:bind-c-constant GTK_CORNER_BOTTOM_RIGHT 3) ;;  GTK_CORNER_BOTTOM_RIGHT 
(ff:bind-c-type GtkCornerType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:140 <1202> 
;; typedef enum { GTK_PACK_START, GTK_PACK_END } GtkPackType;
(ff:bind-c-constant GTK_PACK_START 0) ;;  GTK_PACK_START 
(ff:bind-c-constant GTK_PACK_END 1) ;;  GTK_PACK_END 
(ff:bind-c-type GtkPackType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:147 <1203> 
;; typedef enum {
;;         GTK_PATH_PRIO_LOWEST =  0x000000000, GTK_PATH_PRIO_GTK =
;;   0x000000004,
;;              GTK_PATH_PRIO_APPLICATION =  0x000000008, GTK_PATH_PRIO_RC
;;   =  0x00000000c,
;;              GTK_PATH_PRIO_HIGHEST =  0x00000000f, GTK_PATH_PRIO_MASK =
;;   0x00000000f
;;    } GtkPathPriorityType;
(ff:bind-c-constant GTK_PATH_PRIO_LOWEST
                    0) ;;
;;   GTK_PATH_PRIO_LOWEST =  0x000000000 
(ff:bind-c-constant GTK_PATH_PRIO_GTK 4) ;;
;;   GTK_PATH_PRIO_GTK =  0x000000004 
(ff:bind-c-constant GTK_PATH_PRIO_APPLICATION
                    8) ;;
;;   GTK_PATH_PRIO_APPLICATION =  0x000000008 
(ff:bind-c-constant GTK_PATH_PRIO_RC 12) ;;
;;   GTK_PATH_PRIO_RC =  0x00000000c 
(ff:bind-c-constant GTK_PATH_PRIO_HIGHEST
                    15) ;;
;;   GTK_PATH_PRIO_HIGHEST =  0x00000000f 
(ff:bind-c-constant GTK_PATH_PRIO_MASK
                    15) ;;
;;   GTK_PATH_PRIO_MASK =  0x00000000f 
(ff:bind-c-type GtkPathPriorityType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:158 <1204> 
;; typedef enum {
;;         GTK_PATH_WIDGET, GTK_PATH_WIDGET_CLASS, GTK_PATH_CLASS }
;;   GtkPathType;
(ff:bind-c-constant GTK_PATH_WIDGET 0) ;;  GTK_PATH_WIDGET 
(ff:bind-c-constant GTK_PATH_WIDGET_CLASS 1) ;;  GTK_PATH_WIDGET_CLASS 
(ff:bind-c-constant GTK_PATH_CLASS 2) ;;  GTK_PATH_CLASS 
(ff:bind-c-type GtkPathType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:166 <1205> 
;; typedef enum {
;;         GTK_POLICY_ALWAYS, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER }
;;   GtkPolicyType
;;   ;
(ff:bind-c-constant GTK_POLICY_ALWAYS 0) ;;  GTK_POLICY_ALWAYS 
(ff:bind-c-constant GTK_POLICY_AUTOMATIC 1) ;;  GTK_POLICY_AUTOMATIC 
(ff:bind-c-constant GTK_POLICY_NEVER 2) ;;  GTK_POLICY_NEVER 
(ff:bind-c-type GtkPolicyType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:173 <1206> 
;; typedef enum {
;;         GTK_POS_LEFT, GTK_POS_RIGHT, GTK_POS_TOP, GTK_POS_BOTTOM }
;;   GtkPositionType
;;   ;
(ff:bind-c-constant GTK_POS_LEFT 0) ;;  GTK_POS_LEFT 
(ff:bind-c-constant GTK_POS_RIGHT 1) ;;  GTK_POS_RIGHT 
(ff:bind-c-constant GTK_POS_TOP 2) ;;  GTK_POS_TOP 
(ff:bind-c-constant GTK_POS_BOTTOM 3) ;;  GTK_POS_BOTTOM 
(ff:bind-c-type GtkPositionType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:181 <1207> 
;; typedef enum { GTK_PREVIEW_COLOR, GTK_PREVIEW_GRAYSCALE }
;;   GtkPreviewType;
(ff:bind-c-constant GTK_PREVIEW_COLOR 0) ;;  GTK_PREVIEW_COLOR 
(ff:bind-c-constant GTK_PREVIEW_GRAYSCALE 1) ;;  GTK_PREVIEW_GRAYSCALE 
(ff:bind-c-type GtkPreviewType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:188 <1208> 
;; typedef enum {
;;         GTK_RELIEF_NORMAL, GTK_RELIEF_HALF, GTK_RELIEF_NONE }
;;   GtkReliefStyle;
(ff:bind-c-constant GTK_RELIEF_NORMAL 0) ;;  GTK_RELIEF_NORMAL 
(ff:bind-c-constant GTK_RELIEF_HALF 1) ;;  GTK_RELIEF_HALF 
(ff:bind-c-constant GTK_RELIEF_NONE 2) ;;  GTK_RELIEF_NONE 
(ff:bind-c-type GtkReliefStyle :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:196 <1209> 
;; typedef enum {
;;         GTK_RESIZE_PARENT, GTK_RESIZE_QUEUE, GTK_RESIZE_IMMEDIATE }
;;   GtkResizeMode
;;   ;
(ff:bind-c-constant GTK_RESIZE_PARENT 0) ;;  GTK_RESIZE_PARENT 
(ff:bind-c-constant GTK_RESIZE_QUEUE 1) ;;  GTK_RESIZE_QUEUE 
(ff:bind-c-constant GTK_RESIZE_IMMEDIATE 2) ;;  GTK_RESIZE_IMMEDIATE 
(ff:bind-c-type GtkResizeMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:204 <1210> 
;; typedef enum {
;;         GTK_RUN_FIRST =  0x000000001 LSHIFT  0x000000000, GTK_RUN_LAST =
;;   0x000000001
;;    LSHIFT  0x000000001, GTK_RUN_BOTH =( GTK_RUN_FIRST | GTK_RUN_LAST),
;;   GTK_RUN_NO_RECURSE
;;    =  0x000000001 LSHIFT  0x000000002, GTK_RUN_ACTION =  0x000000001
;;   LSHIFT
;;     0x000000003, GTK_RUN_NO_HOOKS =  0x000000001 LSHIFT  0x000000004 }
;;   GtkSignalRunType
;;   ;
(ff:bind-c-constant GTK_RUN_FIRST
                    1) ;;
;;   GTK_RUN_FIRST =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_RUN_LAST
                    2) ;;
;;   GTK_RUN_LAST =  0x000000001 LSHIFT  0x000000001 

(ff:bind-c-constant GTK_RUN_BOTH
                    (logior GTK_RUN_FIRST GTK_RUN_LAST))
;;   GTK_RUN_BOTH =( GTK_RUN_FIRST | GTK_RUN_LAST) 
(ff:bind-c-constant GTK_RUN_NO_RECURSE
                    4) ;;
;;   GTK_RUN_NO_RECURSE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GTK_RUN_ACTION
                    8) ;;
;;   GTK_RUN_ACTION =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GTK_RUN_NO_HOOKS
                    16) ;;
;;   GTK_RUN_NO_HOOKS =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-type GtkSignalRunType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:215 <1211> 
;; typedef enum {
;;         GTK_SCROLL_NONE, GTK_SCROLL_STEP_BACKWARD,
;;   GTK_SCROLL_STEP_FORWARD, GTK_SCROLL_PAGE_BACKWARD,
;;              GTK_SCROLL_PAGE_FORWARD, GTK_SCROLL_JUMP } GtkScrollType;
(ff:bind-c-constant GTK_SCROLL_NONE 0) ;;  GTK_SCROLL_NONE 
(ff:bind-c-constant GTK_SCROLL_STEP_BACKWARD 1) ;;
;;   GTK_SCROLL_STEP_BACKWARD 
(ff:bind-c-constant GTK_SCROLL_STEP_FORWARD 2) ;;  GTK_SCROLL_STEP_FORWARD 
(ff:bind-c-constant GTK_SCROLL_PAGE_BACKWARD 3) ;;
;;   GTK_SCROLL_PAGE_BACKWARD 
(ff:bind-c-constant GTK_SCROLL_PAGE_FORWARD 4) ;;  GTK_SCROLL_PAGE_FORWARD 
(ff:bind-c-constant GTK_SCROLL_JUMP 5) ;;  GTK_SCROLL_JUMP 
(ff:bind-c-type GtkScrollType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:226 <1212> 
;; typedef enum {
;;         GTK_SELECTION_SINGLE, GTK_SELECTION_BROWSE,
;;   GTK_SELECTION_MULTIPLE, GTK_SELECTION_EXTENDED
;;    } GtkSelectionMode;
(ff:bind-c-constant GTK_SELECTION_SINGLE 0) ;;  GTK_SELECTION_SINGLE 
(ff:bind-c-constant GTK_SELECTION_BROWSE 1) ;;  GTK_SELECTION_BROWSE 
(ff:bind-c-constant GTK_SELECTION_MULTIPLE 2) ;;  GTK_SELECTION_MULTIPLE 
(ff:bind-c-constant GTK_SELECTION_EXTENDED 3) ;;  GTK_SELECTION_EXTENDED 
(ff:bind-c-type GtkSelectionMode :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:235 <1213> 
;; typedef enum {
;;         GTK_SHADOW_NONE, GTK_SHADOW_IN, GTK_SHADOW_OUT,
;;   GTK_SHADOW_ETCHED_IN,
;;              GTK_SHADOW_ETCHED_OUT } GtkShadowType;
(ff:bind-c-constant GTK_SHADOW_NONE 0) ;;  GTK_SHADOW_NONE 
(ff:bind-c-constant GTK_SHADOW_IN 1) ;;  GTK_SHADOW_IN 
(ff:bind-c-constant GTK_SHADOW_OUT 2) ;;  GTK_SHADOW_OUT 
(ff:bind-c-constant GTK_SHADOW_ETCHED_IN 3) ;;  GTK_SHADOW_ETCHED_IN 
(ff:bind-c-constant GTK_SHADOW_ETCHED_OUT 4) ;;  GTK_SHADOW_ETCHED_OUT 
(ff:bind-c-type GtkShadowType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:245 <1214> 
;; typedef enum {
;;         GTK_STATE_NORMAL, GTK_STATE_ACTIVE, GTK_STATE_PRELIGHT,
;;   GTK_STATE_SELECTED,
;;              GTK_STATE_INSENSITIVE } GtkStateType;
(ff:bind-c-constant GTK_STATE_NORMAL 0) ;;  GTK_STATE_NORMAL 
(ff:bind-c-constant GTK_STATE_ACTIVE 1) ;;  GTK_STATE_ACTIVE 
(ff:bind-c-constant GTK_STATE_PRELIGHT 2) ;;  GTK_STATE_PRELIGHT 
(ff:bind-c-constant GTK_STATE_SELECTED 3) ;;  GTK_STATE_SELECTED 
(ff:bind-c-constant GTK_STATE_INSENSITIVE 4) ;;  GTK_STATE_INSENSITIVE 
(ff:bind-c-type GtkStateType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:255 <1215> 
;; typedef enum {
;;         GTK_DIRECTION_LEFT, GTK_DIRECTION_RIGHT } GtkSubmenuDirection;
(ff:bind-c-constant GTK_DIRECTION_LEFT 0) ;;  GTK_DIRECTION_LEFT 
(ff:bind-c-constant GTK_DIRECTION_RIGHT 1) ;;  GTK_DIRECTION_RIGHT 
(ff:bind-c-type GtkSubmenuDirection :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:262 <1216> 
;; typedef enum { GTK_TOP_BOTTOM, GTK_LEFT_RIGHT } GtkSubmenuPlacement;
(ff:bind-c-constant GTK_TOP_BOTTOM 0) ;;  GTK_TOP_BOTTOM 
(ff:bind-c-constant GTK_LEFT_RIGHT 1) ;;  GTK_LEFT_RIGHT 
(ff:bind-c-type GtkSubmenuPlacement :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:269 <1217> 
;; typedef enum {
;;         GTK_TOOLBAR_ICONS, GTK_TOOLBAR_TEXT, GTK_TOOLBAR_BOTH }
;;   GtkToolbarStyle
;;   ;
(ff:bind-c-constant GTK_TOOLBAR_ICONS 0) ;;  GTK_TOOLBAR_ICONS 
(ff:bind-c-constant GTK_TOOLBAR_TEXT 1) ;;  GTK_TOOLBAR_TEXT 
(ff:bind-c-constant GTK_TOOLBAR_BOTH 2) ;;  GTK_TOOLBAR_BOTH 
(ff:bind-c-type GtkToolbarStyle :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:277 <1218> 
;; typedef enum {
;;         GTK_TROUGH_NONE, GTK_TROUGH_START, GTK_TROUGH_END,
;;   GTK_TROUGH_JUMP } GtkTroughType
;;   ;
(ff:bind-c-constant GTK_TROUGH_NONE 0) ;;  GTK_TROUGH_NONE 
(ff:bind-c-constant GTK_TROUGH_START 1) ;;  GTK_TROUGH_START 
(ff:bind-c-constant GTK_TROUGH_END 2) ;;  GTK_TROUGH_END 
(ff:bind-c-constant GTK_TROUGH_JUMP 3) ;;  GTK_TROUGH_JUMP 
(ff:bind-c-type GtkTroughType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:286 <1219> 
;; typedef enum {
;;         GTK_UPDATE_CONTINUOUS, GTK_UPDATE_DISCONTINUOUS,
;;   GTK_UPDATE_DELAYED }
;;    GtkUpdateType;
(ff:bind-c-constant GTK_UPDATE_CONTINUOUS 0) ;;  GTK_UPDATE_CONTINUOUS 
(ff:bind-c-constant GTK_UPDATE_DISCONTINUOUS 1) ;;
;;   GTK_UPDATE_DISCONTINUOUS 
(ff:bind-c-constant GTK_UPDATE_DELAYED 2) ;;  GTK_UPDATE_DELAYED 
(ff:bind-c-type GtkUpdateType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:294 <1220> 
;; typedef enum {
;;         GTK_VISIBILITY_NONE, GTK_VISIBILITY_PARTIAL, GTK_VISIBILITY_FULL
;;   } GtkVisibility
;;   ;
(ff:bind-c-constant GTK_VISIBILITY_NONE 0) ;;  GTK_VISIBILITY_NONE 
(ff:bind-c-constant GTK_VISIBILITY_PARTIAL 1) ;;  GTK_VISIBILITY_PARTIAL 
(ff:bind-c-constant GTK_VISIBILITY_FULL 2) ;;  GTK_VISIBILITY_FULL 
(ff:bind-c-type GtkVisibility :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:302 <1221> 
;; typedef enum {
;;         GTK_WIN_POS_NONE, GTK_WIN_POS_CENTER, GTK_WIN_POS_MOUSE,
;;   GTK_WIN_POS_CENTER_ALWAYS
;;    } GtkWindowPosition;
(ff:bind-c-constant GTK_WIN_POS_NONE 0) ;;  GTK_WIN_POS_NONE 
(ff:bind-c-constant GTK_WIN_POS_CENTER 1) ;;  GTK_WIN_POS_CENTER 
(ff:bind-c-constant GTK_WIN_POS_MOUSE 2) ;;  GTK_WIN_POS_MOUSE 
(ff:bind-c-constant GTK_WIN_POS_CENTER_ALWAYS 3) ;;
;;   GTK_WIN_POS_CENTER_ALWAYS 
(ff:bind-c-type GtkWindowPosition :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:311 <1222> 
;; typedef enum {
;;         GTK_WINDOW_TOPLEVEL, GTK_WINDOW_DIALOG, GTK_WINDOW_POPUP }
;;   GtkWindowType
;;   ;
(ff:bind-c-constant GTK_WINDOW_TOPLEVEL 0) ;;  GTK_WINDOW_TOPLEVEL 
(ff:bind-c-constant GTK_WINDOW_DIALOG 1) ;;  GTK_WINDOW_DIALOG 
(ff:bind-c-constant GTK_WINDOW_POPUP 2) ;;  GTK_WINDOW_POPUP 
(ff:bind-c-type GtkWindowType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkenums.h:319 <1223> 
;; typedef enum { GTK_SORT_ASCENDING, GTK_SORT_DESCENDING } GtkSortType;
(ff:bind-c-constant GTK_SORT_ASCENDING 0) ;;  GTK_SORT_ASCENDING 
(ff:bind-c-constant GTK_SORT_DESCENDING 1) ;;  GTK_SORT_DESCENDING 
(ff:bind-c-type GtkSortType :long #+old :int)  

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkdebug.h:34 <1224> 
;; typedef enum {
;;         GTK_DEBUG_OBJECTS =  0x000000001 LSHIFT  0x000000000,
;;   GTK_DEBUG_MISC =
;;     0x000000001 LSHIFT  0x000000001, GTK_DEBUG_SIGNALS =  0x000000001
;;   LSHIFT
;;     0x000000002, GTK_DEBUG_DND =  0x000000001 LSHIFT  0x000000003,
;;   GTK_DEBUG_PLUGSOCKET
;;    =  0x000000001 LSHIFT  0x000000004 } GtkDebugFlag;
(ff:bind-c-constant GTK_DEBUG_OBJECTS
                    1) ;;
;;   GTK_DEBUG_OBJECTS =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_DEBUG_MISC
                    2) ;;
;;   GTK_DEBUG_MISC =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_DEBUG_SIGNALS
                    4) ;;
;;   GTK_DEBUG_SIGNALS =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GTK_DEBUG_DND
                    8) ;;
;;   GTK_DEBUG_DND =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GTK_DEBUG_PLUGSOCKET
                    16) ;;
;;   GTK_DEBUG_PLUGSOCKET =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-type GtkDebugFlag :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkdebug.h:54 <1225> 
;; extern guint gtk_debug_flags;
;; The following form will return a pointer to the above variable
;; (ff:get-extern-data-address (ff:convert-to-lang "gtk_debug_flags"))

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:80 <1226> 
;; typedef enum {
;;         GTK_DESTROYED =  0x000000001 LSHIFT  0x000000000, GTK_FLOATING =
;;   0x000000001
;;    LSHIFT  0x000000001, GTK_CONNECTED =  0x000000001 LSHIFT
;;   0x000000002,
;;              GTK_CONSTRUCTED =  0x000000001 LSHIFT  0x000000003 }
;;   GtkObjectFlags;
(ff:bind-c-constant GTK_DESTROYED
                    1) ;;
;;   GTK_DESTROYED =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_FLOATING
                    2) ;;
;;   GTK_FLOATING =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_CONNECTED
                    4) ;;
;;   GTK_CONNECTED =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GTK_CONSTRUCTED
                    8) ;;
;;   GTK_CONSTRUCTED =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-type GtkObjectFlags :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:103 <1227> 
;; typedef enum {
;;         GTK_ARG_READABLE =  0x000000001 LSHIFT  0x000000000,
;;   GTK_ARG_WRITABLE
;;    =  0x000000001 LSHIFT  0x000000001, GTK_ARG_CONSTRUCT =  0x000000001
;;   LSHIFT
;;     0x000000002, GTK_ARG_CONSTRUCT_ONLY =  0x000000001 LSHIFT
;;   0x000000003,
;;              GTK_ARG_CHILD_ARG =  0x000000001 LSHIFT  0x000000004,
;;   GTK_ARG_MASK =  0x00000001f,
;;              GTK_ARG_READWRITE = GTK_ARG_READABLE | GTK_ARG_WRITABLE }
;;   GtkArgFlags
;;   ;
(ff:bind-c-constant GTK_ARG_READABLE
                    1) ;;
;;   GTK_ARG_READABLE =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_ARG_WRITABLE
                    2) ;;
;;   GTK_ARG_WRITABLE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_ARG_CONSTRUCT
                    4) ;;
;;   GTK_ARG_CONSTRUCT =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GTK_ARG_CONSTRUCT_ONLY
                    8) ;;
;;   GTK_ARG_CONSTRUCT_ONLY =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GTK_ARG_CHILD_ARG
                    16) ;;
;;   GTK_ARG_CHILD_ARG =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GTK_ARG_MASK 31) ;;  GTK_ARG_MASK =  0x00000001f 

(ff:bind-c-constant GTK_ARG_READWRITE
                    (logior GTK_ARG_READABLE GTK_ARG_WRITABLE))
;;   GTK_ARG_READWRITE = GTK_ARG_READABLE | GTK_ARG_WRITABLE 
(ff:bind-c-type GtkArgFlags :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:117 <1228> 
;; typedef struct _GtkObjectClass GtkObjectClass;
(ff:bind-c-typedef _GtkObjectClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkObjectClass _GtkObjectClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:125 <1229> 
;; struct _GtkObject {
;;         GtkObjectClass* klass; guint32 flags; guint ref_count; GData*
;;   object_data;
;;    };
(ff:bind-c-type _GtkObject (:struct
  (klass (* GtkObjectClass))   ;; GtkObjectClass* klass
  (flags guint32)   ;; guint32 flags
  (ref_count guint)   ;; guint ref_count
  (object_data (* GData))   ;; GData* object_data
  ))   ;; bind-c-type _GtkObject

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:156 <1230> 
;; struct _GtkObjectClass {
;;         GtkType type; guint* signals; guint nsignals; guint n_args;
;;   GSList* construct_args;
;;              void(* set_arg)( GtkObject* object, GtkArg* arg, guint
;;   arg_id); void(
;;   * get_arg)( GtkObject* object, GtkArg* arg, guint arg_id); void(*
;;   shutdown
;;   )( GtkObject* object); void(* destroy)( GtkObject* object); void(*
;;   finalize
;;   )( GtkObject* object); };
(ff:bind-c-type _GtkObjectClass (:struct
  (type GtkType)   ;; GtkType type
  (signals (* guint))   ;; guint* signals
  (nsignals guint)   ;; guint nsignals
  (n_args guint)   ;; guint n_args
  (construct_args (* GSList))   ;; GSList* construct_args
  (set_arg ff:function-pointer)   ;;
  ;;  void(* set_arg)( GtkObject* object, GtkArg* arg, guint arg_id)
  (get_arg ff:function-pointer)   ;;
  ;;  void(* get_arg)( GtkObject* object, GtkArg* arg, guint arg_id)
  (shutdown ff:function-pointer)   ;; void(* shutdown)( GtkObject* object)
  (destroy ff:function-pointer)   ;; void(* destroy)( GtkObject* object)
  (finalize ff:function-pointer)   ;; void(* finalize)( GtkObject* object)
  ))   ;; bind-c-type _GtkObjectClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:202 <1231> 
;; GtkType gtk_object_get_type( void);
(ff:bind-c-function gtk_object_get_type
     :unconverted-entry-name "gtk_object_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:205 <1232> 
;; guint gtk_object_class_user_signal_new( GtkObjectClass* klass, const
;;   gchar
;;   * name, GtkSignalRunType signal_flags, GtkSignalMarshaller marshaller,
;;              GtkType return_val, guint nparams, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_object_class_user_signal_new
     :unconverted-entry-name "gtk_object_class_user_signal_new"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObjectClass" "*") ("const" "gchar" "*")
                   ("GtkSignalRunType") ("GtkSignalMarshaller") ("GtkType")
                   ("guint") "...")
     :c-arg-names (klass name signal_flags marshaller return_val nparams)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:212 <1233> 
;; guint gtk_object_class_user_signal_newv( GtkObjectClass* klass, const
;;    gchar* name, GtkSignalRunType signal_flags, GtkSignalMarshaller
;;   marshaller,
;;              GtkType return_val, guint nparams, GtkType* params);
(ff:bind-c-function gtk_object_class_user_signal_newv
     :unconverted-entry-name "gtk_object_class_user_signal_newv"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObjectClass" "*") ("const" "gchar" "*")
                   ("GtkSignalRunType") ("GtkSignalMarshaller") ("GtkType")
                   ("guint") ("GtkType" "*"))
     :c-arg-names (klass name signal_flags marshaller return_val nparams
                   params)
     :arguments ((* GtkObjectClass) (* gchar) GtkSignalRunType
                 GtkSignalMarshaller GtkType guint (* GtkType))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:219 <1234> 
;; GtkObject* gtk_object_new( GtkType type, const gchar* first_arg_name,
;;    ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_object_new
     :unconverted-entry-name "gtk_object_new"
     :c-return-type ("GtkObject" "*")
     :return-type (* GtkObject)
     :c-arg-types (("GtkType") ("const" "gchar" "*") "...")
     :c-arg-names (type first_arg_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:222 <1235> 
;; GtkObject* gtk_object_newv( GtkType object_type, guint n_args, GtkArg
;;   * args);
(ff:bind-c-function gtk_object_newv
     :unconverted-entry-name "gtk_object_newv"
     :c-return-type ("GtkObject" "*")
     :return-type (* GtkObject)
     :c-arg-types (("GtkType") ("guint") ("GtkArg" "*"))
     :c-arg-names (object_type n_args args)
     :arguments (GtkType guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:225 <1236> 
;; void gtk_object_default_construct( GtkObject* object);
(ff:bind-c-function gtk_object_default_construct
     :unconverted-entry-name "gtk_object_default_construct"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:226 <1237> 
;; void gtk_object_constructed( GtkObject* object);
(ff:bind-c-function gtk_object_constructed
     :unconverted-entry-name "gtk_object_constructed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:227 <1238> 
;; void gtk_object_sink( GtkObject* object);
(ff:bind-c-function gtk_object_sink
     :unconverted-entry-name "gtk_object_sink"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:228 <1239> 
;; void gtk_object_ref( GtkObject* object);
(ff:bind-c-function gtk_object_ref
     :unconverted-entry-name "gtk_object_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:229 <1240> 
;; void gtk_object_unref( GtkObject* object);
(ff:bind-c-function gtk_object_unref
     :unconverted-entry-name "gtk_object_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:230 <1241> 
;; void gtk_object_weakref( GtkObject* object, GtkDestroyNotify notify,
;;   gpointer
;;    data);
(ff:bind-c-function gtk_object_weakref
     :unconverted-entry-name "gtk_object_weakref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkDestroyNotify") ("gpointer"))
     :c-arg-names (object notify data)
     :arguments ((* GtkObject) GtkDestroyNotify gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:233 <1242> 
;; void gtk_object_weakunref( GtkObject* object, GtkDestroyNotify notify,
;;              gpointer data);
(ff:bind-c-function gtk_object_weakunref
     :unconverted-entry-name "gtk_object_weakunref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkDestroyNotify") ("gpointer"))
     :c-arg-names (object notify data)
     :arguments ((* GtkObject) GtkDestroyNotify gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:236 <1243> 
;; void gtk_object_destroy( GtkObject* object);
(ff:bind-c-function gtk_object_destroy
     :unconverted-entry-name "gtk_object_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:243 <1244> 
;; void gtk_object_getv( GtkObject* object, guint n_args, GtkArg* args);
(ff:bind-c-function gtk_object_getv
     :unconverted-entry-name "gtk_object_getv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint") ("GtkArg" "*"))
     :c-arg-names (object n_args args)
     :arguments ((* GtkObject) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:251 <1245> 
;; void gtk_object_get( GtkObject* object, const gchar* first_arg_name,
;;   ELLIPSIS
;;   );

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_object_get
     :unconverted-entry-name "gtk_object_get"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") "...")
     :c-arg-names (object first_arg_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:260 <1246> 
;; void gtk_object_set( GtkObject* object, const gchar* first_arg_name,
;;   ELLIPSIS
;;   );

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_object_set
     :unconverted-entry-name "gtk_object_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") "...")
     :c-arg-names (object first_arg_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:263 <1247> 
;; void gtk_object_setv( GtkObject* object, guint n_args, GtkArg* args);
(ff:bind-c-function gtk_object_setv
     :unconverted-entry-name "gtk_object_setv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint") ("GtkArg" "*"))
     :c-arg-names (object n_args args)
     :arguments ((* GtkObject) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:275 <1248> 
;; GtkArg* gtk_object_query_args( GtkType class_type, guint32** arg_flags,
;;              guint* n_args);
(ff:bind-c-function gtk_object_query_args
     :unconverted-entry-name "gtk_object_query_args"
     :c-return-type ("GtkArg" "*")
     :return-type (* GtkArg)
     :c-arg-types (("GtkType") ("guint32" "*" "*") ("guint" "*"))
     :c-arg-names (class_type arg_flags n_args)
     :arguments (GtkType (* (* guint32)) (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:291 <1249> 
;; void gtk_object_set_data( GtkObject* object, const gchar* key, gpointer
;;    data);
(ff:bind-c-function gtk_object_set_data
     :unconverted-entry-name "gtk_object_set_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("gpointer"))
     :c-arg-names (object key data)
     :arguments ((* GtkObject) (* gchar) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:294 <1250> 
;; void gtk_object_set_data_full( GtkObject* object, const gchar* key,
;;   gpointer
;;    data, GtkDestroyNotify destroy);
(ff:bind-c-function gtk_object_set_data_full
     :unconverted-entry-name "gtk_object_set_data_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("gpointer")
                   ("GtkDestroyNotify"))
     :c-arg-names (object key data destroy)
     :arguments ((* GtkObject) (* gchar) gpointer GtkDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:298 <1251> 
;; void gtk_object_remove_data( GtkObject* object, const gchar* key);
(ff:bind-c-function gtk_object_remove_data
     :unconverted-entry-name "gtk_object_remove_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object key)
     :arguments ((* GtkObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:300 <1252> 
;; gpointer gtk_object_get_data( GtkObject* object, const gchar* key);
(ff:bind-c-function gtk_object_get_data
     :unconverted-entry-name "gtk_object_get_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object key)
     :arguments ((* GtkObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:302 <1253> 
;; void gtk_object_remove_no_notify( GtkObject* object, const gchar* key);
(ff:bind-c-function gtk_object_remove_no_notify
     :unconverted-entry-name "gtk_object_remove_no_notify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object key)
     :arguments ((* GtkObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:310 <1254> 
;; void gtk_object_set_user_data( GtkObject* object, gpointer data);
(ff:bind-c-function gtk_object_set_user_data
     :unconverted-entry-name "gtk_object_set_user_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("gpointer"))
     :c-arg-names (object data)
     :arguments ((* GtkObject) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:312 <1255> 
;; gpointer gtk_object_get_user_data( GtkObject* object);
(ff:bind-c-function gtk_object_get_user_data
     :unconverted-entry-name "gtk_object_get_user_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:318 <1256> 
;; void gtk_object_class_add_signals( GtkObjectClass* klass, guint*
;;   signals,
;;              guint nsignals);
(ff:bind-c-function gtk_object_class_add_signals
     :unconverted-entry-name "gtk_object_class_add_signals"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObjectClass" "*") ("guint" "*") ("guint"))
     :c-arg-names (klass signals nsignals)
     :arguments ((* GtkObjectClass) (* guint) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:322 <1257> 
;; void gtk_object_add_arg_type( const gchar* arg_name, GtkType arg_type,
;;              guint arg_flags, guint arg_id);
(ff:bind-c-function gtk_object_add_arg_type
     :unconverted-entry-name "gtk_object_add_arg_type"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GtkType") ("guint") ("guint"))
     :c-arg-names (arg_name arg_type arg_flags arg_id)
     :arguments ((* gchar) GtkType guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:328 <1258> 
;; void gtk_object_set_data_by_id( GtkObject* object, GQuark data_id,
;;   gpointer
;;    data);
(ff:bind-c-function gtk_object_set_data_by_id
     :unconverted-entry-name "gtk_object_set_data_by_id"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GQuark") ("gpointer"))
     :c-arg-names (object data_id data)
     :arguments ((* GtkObject) GQuark gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:331 <1259> 
;; void gtk_object_set_data_by_id_full( GtkObject* object, GQuark data_id,
;;              gpointer data, GtkDestroyNotify destroy);
(ff:bind-c-function gtk_object_set_data_by_id_full
     :unconverted-entry-name "gtk_object_set_data_by_id_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GQuark") ("gpointer")
                   ("GtkDestroyNotify"))
     :c-arg-names (object data_id data destroy)
     :arguments ((* GtkObject) GQuark gpointer GtkDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:335 <1260> 
;; gpointer gtk_object_get_data_by_id( GtkObject* object, GQuark data_id);
(ff:bind-c-function gtk_object_get_data_by_id
     :unconverted-entry-name "gtk_object_get_data_by_id"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GtkObject" "*") ("GQuark"))
     :c-arg-names (object data_id)
     :arguments ((* GtkObject) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:337 <1261> 
;; void gtk_object_remove_data_by_id( GtkObject* object, GQuark data_id);
(ff:bind-c-function gtk_object_remove_data_by_id
     :unconverted-entry-name "gtk_object_remove_data_by_id"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GQuark"))
     :c-arg-names (object data_id)
     :arguments ((* GtkObject) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:339 <1262> 
;; void gtk_object_remove_no_notify_by_id( GtkObject* object, GQuark key_id
;;   );
(ff:bind-c-function gtk_object_remove_no_notify_by_id
     :unconverted-entry-name "gtk_object_remove_no_notify_by_id"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GQuark"))
     :c-arg-names (object key_id)
     :arguments ((* GtkObject) GQuark)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:347 <1263> 
;; void gtk_object_arg_set( GtkObject* object, GtkArg* arg, GtkArgInfo*
;;   info
;;   );
(ff:bind-c-function gtk_object_arg_set
     :unconverted-entry-name "gtk_object_arg_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkArg" "*") ("GtkArgInfo" "*"))
     :c-arg-names (object arg info)
     :arguments ((* GtkObject) (* GtkArg) (* GtkArgInfo))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:350 <1264> 
;; void gtk_object_arg_get( GtkObject* object, GtkArg* arg, GtkArgInfo*
;;   info
;;   );
(ff:bind-c-function gtk_object_arg_get
     :unconverted-entry-name "gtk_object_arg_get"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkArg" "*") ("GtkArgInfo" "*"))
     :c-arg-names (object arg info)
     :arguments ((* GtkObject) (* GtkArg) (* GtkArgInfo))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:353 <1265> 
;; gchar* gtk_object_args_collect( GtkType object_type, GSList**
;;   arg_list_p,
;;              GSList** info_list_p, const gchar* first_arg_name, va_list
;;   var_args);
(ff:bind-c-function gtk_object_args_collect
     :unconverted-entry-name "gtk_object_args_collect"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkType") ("GSList" "*" "*") ("GSList" "*" "*")
                   ("const" "gchar" "*") ("va_list"))
     :c-arg-names (object_type arg_list_p info_list_p first_arg_name var_args)
     :arguments (GtkType (* (* GSList)) (* (* GSList)) (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:358 <1266> 
;; gchar* gtk_object_arg_get_info( GtkType object_type, const gchar*
;;   arg_name,
;;              GtkArgInfo** info_p);
(ff:bind-c-function gtk_object_arg_get_info
     :unconverted-entry-name "gtk_object_arg_get_info"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkType") ("const" "gchar" "*") ("GtkArgInfo" "*" "*"))
     :c-arg-names (object_type arg_name info_p)
     :arguments (GtkType (* gchar) (* (* GtkArgInfo)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkobject.h:361 <1267> 
;; void gtk_trace_referencing( GtkObject* object, const gchar* func, guint
;;    dummy, guint line, gboolean do_ref);
(ff:bind-c-function gtk_trace_referencing
     :unconverted-entry-name "gtk_trace_referencing"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("guint") ("guint")
                   ("gboolean"))
     :c-arg-names (object func dummy line do_ref)
     :arguments ((* GtkObject) (* gchar) guint guint gboolean)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:44 <1268> 
;; typedef struct _GtkAccelGroup GtkAccelGroup;
(ff:bind-c-typedef _GtkAccelGroup
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAccelGroup _GtkAccelGroup)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:45 <1269> 
;; typedef struct _GtkAccelEntry GtkAccelEntry;
(ff:bind-c-typedef _GtkAccelEntry
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAccelEntry _GtkAccelEntry)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:47 <1270> 
;; typedef enum {
;;         GTK_ACCEL_VISIBLE =  0x000000001 LSHIFT  0x000000000,
;;   GTK_ACCEL_SIGNAL_VISIBLE
;;    =  0x000000001 LSHIFT  0x000000001, GTK_ACCEL_LOCKED =  0x000000001
;;   LSHIFT
;;     0x000000002, GTK_ACCEL_MASK =  0x000000007 } GtkAccelFlags;
(ff:bind-c-constant GTK_ACCEL_VISIBLE
                    1) ;;
;;   GTK_ACCEL_VISIBLE =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_ACCEL_SIGNAL_VISIBLE
                    2) ;;
;;   GTK_ACCEL_SIGNAL_VISIBLE =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_ACCEL_LOCKED
                    4) ;;
;;   GTK_ACCEL_LOCKED =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GTK_ACCEL_MASK 7) ;;  GTK_ACCEL_MASK =  0x000000007 
(ff:bind-c-type GtkAccelFlags :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:64 <1271> 
;; struct _GtkAccelGroup {
;;         guint ref_count; guint lock_count; GdkModifierType
;;   modifier_mask; GSList
;;   * attach_objects; };
(ff:bind-c-type _GtkAccelGroup (:struct
  (ref_count guint)   ;; guint ref_count
  (lock_count guint)   ;; guint lock_count
  (modifier_mask GdkModifierType)   ;; GdkModifierType modifier_mask
  (attach_objects (* GSList))   ;; GSList* attach_objects
  ))   ;; bind-c-type _GtkAccelGroup

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:72 <1272> 
;; struct _GtkAccelEntry {
;;         GtkAccelGroup* accel_group; guint accelerator_key;
;;   GdkModifierType accelerator_mods;
;;              GtkAccelFlags accel_flags; GtkObject* object; guint
;;   signal_id; };
(ff:bind-c-type _GtkAccelEntry (:struct
  (accel_group (* GtkAccelGroup))   ;; GtkAccelGroup* accel_group
  (accelerator_key guint)   ;; guint accelerator_key
  (accelerator_mods GdkModifierType)   ;; GdkModifierType accelerator_mods
  (accel_flags GtkAccelFlags)   ;; GtkAccelFlags accel_flags
  (object (* GtkObject))   ;; GtkObject* object
  (signal_id guint)   ;; guint signal_id
  ))   ;; bind-c-type _GtkAccelEntry

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:88 <1273> 
;; gboolean gtk_accelerator_valid( guint keyval, GdkModifierType
;;   modifiers);
(ff:bind-c-function gtk_accelerator_valid
     :unconverted-entry-name "gtk_accelerator_valid"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("guint") ("GdkModifierType"))
     :c-arg-names (keyval modifiers)
     :arguments (guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:90 <1274> 
;; void gtk_accelerator_parse( const gchar* accelerator, guint*
;;   accelerator_key,
;;              GdkModifierType* accelerator_mods);
(ff:bind-c-function gtk_accelerator_parse
     :unconverted-entry-name "gtk_accelerator_parse"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("guint" "*") ("GdkModifierType" "*"))
     :c-arg-names (accelerator accelerator_key accelerator_mods)
     :arguments ((* gchar) (* guint) (* GdkModifierType))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:93 <1275> 
;; gchar* gtk_accelerator_name( guint accelerator_key, GdkModifierType
;;   accelerator_mods
;;   );
(ff:bind-c-function gtk_accelerator_name
     :unconverted-entry-name "gtk_accelerator_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("guint") ("GdkModifierType"))
     :c-arg-names (accelerator_key accelerator_mods)
     :arguments (guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:95 <1276> 
;; void gtk_accelerator_set_default_mod_mask( GdkModifierType
;;   default_mod_mask
;;   );
(ff:bind-c-function gtk_accelerator_set_default_mod_mask
     :unconverted-entry-name "gtk_accelerator_set_default_mod_mask"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkModifierType"))
     :c-arg-names (default_mod_mask)
     :arguments (GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:96 <1277> 
;; guint gtk_accelerator_get_default_mod_mask( void);
(ff:bind-c-function gtk_accelerator_get_default_mod_mask
     :unconverted-entry-name "gtk_accelerator_get_default_mod_mask"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:101 <1278> 
;; GtkAccelGroup* gtk_accel_group_new( void);
(ff:bind-c-function gtk_accel_group_new
     :unconverted-entry-name "gtk_accel_group_new"
     :c-return-type ("GtkAccelGroup" "*")
     :return-type (* GtkAccelGroup)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:102 <1279> 
;; GtkAccelGroup* gtk_accel_group_get_default( void);
(ff:bind-c-function gtk_accel_group_get_default
     :unconverted-entry-name "gtk_accel_group_get_default"
     :c-return-type ("GtkAccelGroup" "*")
     :return-type (* GtkAccelGroup)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:103 <1280> 
;; GtkAccelGroup* gtk_accel_group_ref( GtkAccelGroup* accel_group);
(ff:bind-c-function gtk_accel_group_ref
     :unconverted-entry-name "gtk_accel_group_ref"
     :c-return-type ("GtkAccelGroup" "*")
     :return-type (* GtkAccelGroup)
     :c-arg-types (("GtkAccelGroup" "*"))
     :c-arg-names (accel_group)
     :arguments ((* GtkAccelGroup))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:104 <1281> 
;; void gtk_accel_group_unref( GtkAccelGroup* accel_group);
(ff:bind-c-function gtk_accel_group_unref
     :unconverted-entry-name "gtk_accel_group_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*"))
     :c-arg-names (accel_group)
     :arguments ((* GtkAccelGroup))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:105 <1282> 
;; void gtk_accel_group_lock( GtkAccelGroup* accel_group);
(ff:bind-c-function gtk_accel_group_lock
     :unconverted-entry-name "gtk_accel_group_lock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*"))
     :c-arg-names (accel_group)
     :arguments ((* GtkAccelGroup))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:106 <1283> 
;; void gtk_accel_group_unlock( GtkAccelGroup* accel_group);
(ff:bind-c-function gtk_accel_group_unlock
     :unconverted-entry-name "gtk_accel_group_unlock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*"))
     :c-arg-names (accel_group)
     :arguments ((* GtkAccelGroup))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:107 <1284> 
;; gboolean gtk_accel_groups_activate( GtkObject* object, guint accel_key,
;;              GdkModifierType accel_mods);
(ff:bind-c-function gtk_accel_groups_activate
     :unconverted-entry-name "gtk_accel_groups_activate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkObject" "*") ("guint") ("GdkModifierType"))
     :c-arg-names (object accel_key accel_mods)
     :arguments ((* GtkObject) guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:113 <1285> 
;; gboolean gtk_accel_group_activate( GtkAccelGroup* accel_group, guint
;;   accel_key,
;;              GdkModifierType accel_mods);
(ff:bind-c-function gtk_accel_group_activate
     :unconverted-entry-name "gtk_accel_group_activate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkAccelGroup" "*") ("guint") ("GdkModifierType"))
     :c-arg-names (accel_group accel_key accel_mods)
     :arguments ((* GtkAccelGroup) guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:116 <1286> 
;; void gtk_accel_group_attach( GtkAccelGroup* accel_group, GtkObject*
;;   object
;;   );
(ff:bind-c-function gtk_accel_group_attach
     :unconverted-entry-name "gtk_accel_group_attach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*") ("GtkObject" "*"))
     :c-arg-names (accel_group object)
     :arguments ((* GtkAccelGroup) (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:118 <1287> 
;; void gtk_accel_group_detach( GtkAccelGroup* accel_group, GtkObject*
;;   object
;;   );
(ff:bind-c-function gtk_accel_group_detach
     :unconverted-entry-name "gtk_accel_group_detach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*") ("GtkObject" "*"))
     :c-arg-names (accel_group object)
     :arguments ((* GtkAccelGroup) (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:123 <1288> 
;; GtkAccelEntry* gtk_accel_group_get_entry( GtkAccelGroup* accel_group,
;;              guint accel_key, GdkModifierType accel_mods);
(ff:bind-c-function gtk_accel_group_get_entry
     :unconverted-entry-name "gtk_accel_group_get_entry"
     :c-return-type ("GtkAccelEntry" "*")
     :return-type (* GtkAccelEntry)
     :c-arg-types (("GtkAccelGroup" "*") ("guint") ("GdkModifierType"))
     :c-arg-names (accel_group accel_key accel_mods)
     :arguments ((* GtkAccelGroup) guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:126 <1289> 
;; void gtk_accel_group_lock_entry( GtkAccelGroup* accel_group, guint
;;   accel_key,
;;              GdkModifierType accel_mods);
(ff:bind-c-function gtk_accel_group_lock_entry
     :unconverted-entry-name "gtk_accel_group_lock_entry"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*") ("guint") ("GdkModifierType"))
     :c-arg-names (accel_group accel_key accel_mods)
     :arguments ((* GtkAccelGroup) guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:129 <1290> 
;; void gtk_accel_group_unlock_entry( GtkAccelGroup* accel_group, guint
;;   accel_key,
;;              GdkModifierType accel_mods);
(ff:bind-c-function gtk_accel_group_unlock_entry
     :unconverted-entry-name "gtk_accel_group_unlock_entry"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*") ("guint") ("GdkModifierType"))
     :c-arg-names (accel_group accel_key accel_mods)
     :arguments ((* GtkAccelGroup) guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:132 <1291> 
;; void gtk_accel_group_add( GtkAccelGroup* accel_group, guint accel_key,
;;              GdkModifierType accel_mods, GtkAccelFlags accel_flags,
;;   GtkObject* object,
;;              const gchar* accel_signal);
(ff:bind-c-function gtk_accel_group_add
     :unconverted-entry-name "gtk_accel_group_add"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*") ("guint") ("GdkModifierType")
                   ("GtkAccelFlags") ("GtkObject" "*") ("const" "gchar" "*"))
     :c-arg-names (accel_group accel_key accel_mods accel_flags object
                   accel_signal)
     :arguments ((* GtkAccelGroup) guint GdkModifierType GtkAccelFlags
                 (* GtkObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:138 <1292> 
;; void gtk_accel_group_remove( GtkAccelGroup* accel_group, guint
;;   accel_key,
;;              GdkModifierType accel_mods, GtkObject* object);
(ff:bind-c-function gtk_accel_group_remove
     :unconverted-entry-name "gtk_accel_group_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelGroup" "*") ("guint") ("GdkModifierType")
                   ("GtkObject" "*"))
     :c-arg-names (accel_group accel_key accel_mods object)
     :arguments ((* GtkAccelGroup) guint GdkModifierType (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:145 <1293> 
;; void gtk_accel_group_handle_add( GtkObject* object, guint
;;   accel_signal_id,
;;              GtkAccelGroup* accel_group, guint accel_key,
;;   GdkModifierType accel_mods,
;;              GtkAccelFlags accel_flags);
(ff:bind-c-function gtk_accel_group_handle_add
     :unconverted-entry-name "gtk_accel_group_handle_add"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint") ("GtkAccelGroup" "*") ("guint")
                   ("GdkModifierType") ("GtkAccelFlags"))
     :c-arg-names (object accel_signal_id accel_group accel_key accel_mods
                   accel_flags)
     :arguments ((* GtkObject) guint (* GtkAccelGroup) guint GdkModifierType
                 GtkAccelFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:151 <1294> 
;; void gtk_accel_group_handle_remove( GtkObject* object, GtkAccelGroup*
;;    accel_group, guint accel_key, GdkModifierType accel_mods);
(ff:bind-c-function gtk_accel_group_handle_remove
     :unconverted-entry-name "gtk_accel_group_handle_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkAccelGroup" "*") ("guint")
                   ("GdkModifierType"))
     :c-arg-names (object accel_group accel_key accel_mods)
     :arguments ((* GtkObject) (* GtkAccelGroup) guint GdkModifierType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:155 <1295> 
;; guint gtk_accel_group_create_add( GtkType class_type, GtkSignalRunType
;;    signal_flags, guint handler_offset);
(ff:bind-c-function gtk_accel_group_create_add
     :unconverted-entry-name "gtk_accel_group_create_add"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkType") ("GtkSignalRunType") ("guint"))
     :c-arg-names (class_type signal_flags handler_offset)
     :arguments (GtkType GtkSignalRunType guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:158 <1296> 
;; guint gtk_accel_group_create_remove( GtkType class_type,
;;   GtkSignalRunType
;;    signal_flags, guint handler_offset);
(ff:bind-c-function gtk_accel_group_create_remove
     :unconverted-entry-name "gtk_accel_group_create_remove"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkType") ("GtkSignalRunType") ("guint"))
     :c-arg-names (class_type signal_flags handler_offset)
     :arguments (GtkType GtkSignalRunType guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:164 <1297> 
;; GSList* gtk_accel_groups_from_object( GtkObject* object);
(ff:bind-c-function gtk_accel_groups_from_object
     :unconverted-entry-name "gtk_accel_groups_from_object"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccelgroup.h:165 <1298> 
;; GSList* gtk_accel_group_entries_from_object( GtkObject* object);
(ff:bind-c-function gtk_accel_group_entries_from_object
     :unconverted-entry-name "gtk_accel_group_entries_from_object"
     :c-return-type ("GSList" "*")
     :return-type (* GSList)
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkdata.h:48 <1299> 
;; typedef struct _GtkData GtkData;
(ff:bind-c-typedef _GtkData ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkData _GtkData)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkdata.h:49 <1300> 
;; typedef struct _GtkDataClass GtkDataClass;
(ff:bind-c-typedef _GtkDataClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkDataClass _GtkDataClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkdata.h:51 <1301> 
;; struct _GtkData { GtkObject object; };
(ff:bind-c-type _GtkData (:struct
  (object GtkObject)   ;; GtkObject object
  ))   ;; bind-c-type _GtkData

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkdata.h:56 <1302> 
;; struct _GtkDataClass {
;;         GtkObjectClass parent_class; void(* disconnect)( GtkData* data);
;;   };
(ff:bind-c-type _GtkDataClass (:struct
  (parent_class GtkObjectClass)   ;; GtkObjectClass parent_class
  (disconnect ff:function-pointer)   ;; void(* disconnect)( GtkData* data)
  ))   ;; bind-c-type _GtkDataClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkdata.h:64 <1303> 
;; GtkType gtk_data_get_type( void);
(ff:bind-c-function gtk_data_get_type
     :unconverted-entry-name "gtk_data_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:47 <1304> 
;; typedef struct _GtkAdjustment GtkAdjustment;
(ff:bind-c-typedef _GtkAdjustment
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAdjustment _GtkAdjustment)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:48 <1305> 
;; typedef struct _GtkAdjustmentClass GtkAdjustmentClass;
(ff:bind-c-typedef _GtkAdjustmentClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAdjustmentClass _GtkAdjustmentClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:50 <1306> 
;; struct _GtkAdjustment {
;;         GtkData data; gfloat lower; gfloat upper; gfloat value; gfloat
;;   step_increment;
;;              gfloat page_increment; gfloat page_size; };
(ff:bind-c-type _GtkAdjustment (:struct
  (data GtkData)   ;; GtkData data
  (lower gfloat)   ;; gfloat lower
  (upper gfloat)   ;; gfloat upper
  (value gfloat)   ;; gfloat value
  (step_increment gfloat)   ;; gfloat step_increment
  (page_increment gfloat)   ;; gfloat page_increment
  (page_size gfloat)   ;; gfloat page_size
  ))   ;; bind-c-type _GtkAdjustment

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:62 <1307> 
;; struct _GtkAdjustmentClass {
;;         GtkDataClass parent_class; void(* changed)( GtkAdjustment*
;;   adjustment
;;   ); void(* value_changed)( GtkAdjustment* adjustment); };
(ff:bind-c-type _GtkAdjustmentClass (:struct
  (parent_class GtkDataClass)   ;; GtkDataClass parent_class
  (changed ff:function-pointer)   ;;
  ;;  void(* changed)( GtkAdjustment* adjustment)
  (value_changed ff:function-pointer)   ;;
  ;;  void(* value_changed)( GtkAdjustment* adjustment)
  ))   ;; bind-c-type _GtkAdjustmentClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:71 <1308> 
;; GtkType gtk_adjustment_get_type( void);
(ff:bind-c-function gtk_adjustment_get_type
     :unconverted-entry-name "gtk_adjustment_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:72 <1309> 
;; GtkObject* gtk_adjustment_new( gfloat value, gfloat lower, gfloat upper,
;;              gfloat step_increment, gfloat page_increment, gfloat
;;   page_size);
(ff:bind-c-function gtk_adjustment_new
     :unconverted-entry-name "gtk_adjustment_new"
     :c-return-type ("GtkObject" "*")
     :return-type (* GtkObject)
     :c-arg-types (("gfloat") ("gfloat") ("gfloat") ("gfloat") ("gfloat")
                   ("gfloat"))
     :c-arg-names (value lower upper step_increment page_increment page_size)
     :arguments (gfloat gfloat gfloat gfloat gfloat gfloat)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:78 <1310> 
;; void gtk_adjustment_changed( GtkAdjustment* adjustment);
(ff:bind-c-function gtk_adjustment_changed
     :unconverted-entry-name "gtk_adjustment_changed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAdjustment" "*"))
     :c-arg-names (adjustment)
     :arguments ((* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:79 <1311> 
;; void gtk_adjustment_value_changed( GtkAdjustment* adjustment);
(ff:bind-c-function gtk_adjustment_value_changed
     :unconverted-entry-name "gtk_adjustment_value_changed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAdjustment" "*"))
     :c-arg-names (adjustment)
     :arguments ((* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:80 <1312> 
;; void gtk_adjustment_clamp_page( GtkAdjustment* adjustment, gfloat lower,
;;              gfloat upper);
(ff:bind-c-function gtk_adjustment_clamp_page
     :unconverted-entry-name "gtk_adjustment_clamp_page"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAdjustment" "*") ("gfloat") ("gfloat"))
     :c-arg-names (adjustment lower upper)
     :arguments ((* GtkAdjustment) gfloat gfloat)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkadjustment.h:83 <1313> 
;; void gtk_adjustment_set_value( GtkAdjustment* adjustment, gfloat value);
(ff:bind-c-function gtk_adjustment_set_value
     :unconverted-entry-name "gtk_adjustment_set_value"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAdjustment" "*") ("gfloat"))
     :c-arg-names (adjustment value)
     :arguments ((* GtkAdjustment) gfloat)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:38 <1314> 
;; typedef struct _GtkStyle GtkStyle;
(ff:bind-c-typedef _GtkStyle ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkStyle _GtkStyle)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:39 <1315> 
;; typedef struct _GtkStyleClass GtkStyleClass;
(ff:bind-c-typedef _GtkStyleClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkStyleClass _GtkStyleClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:44 <1316> 
;; typedef struct _GtkThemeEngine GtkThemeEngine;
(ff:bind-c-typedef _GtkThemeEngine
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkThemeEngine _GtkThemeEngine)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:45 <1317> 
;; typedef struct _GtkRcStyle GtkRcStyle;
(ff:bind-c-typedef _GtkRcStyle
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkRcStyle _GtkRcStyle)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:51 <1318> 
;; typedef struct _GtkWidget GtkWidget;
(ff:bind-c-typedef _GtkWidget ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkWidget _GtkWidget)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:60 <1319> 
;; struct _GtkStyle {
;;         GtkStyleClass* klass; GdkColor fg[  0x000000005]; GdkColor bg[
;;   0x000000005
;;   ]; GdkColor light[  0x000000005]; GdkColor dark[  0x000000005];
;;   GdkColor
;;    mid[  0x000000005]; GdkColor text[  0x000000005]; GdkColor base[
;;   0x000000005
;;   ]; GdkColor black; GdkColor white; GdkFont* font; GdkGC* fg_gc[
;;   0x000000005
;;   ]; GdkGC* bg_gc[  0x000000005]; GdkGC* light_gc[  0x000000005]; GdkGC*
;;    dark_gc[  0x000000005]; GdkGC* mid_gc[  0x000000005]; GdkGC* text_gc[
;;     0x000000005]; GdkGC* base_gc[  0x000000005]; GdkGC* black_gc; GdkGC*
;;    white_gc; GdkPixmap* bg_pixmap[  0x000000005]; gint ref_count; gint
;;   attach_count;
;;              gint depth; GdkColormap* colormap; GtkThemeEngine* engine;
;;   gpointer engine_data;
;;              GtkRcStyle* rc_style; GSList* styles; };
(ff:bind-c-type _GtkStyle (:struct
  (klass (* GtkStyleClass))   ;; GtkStyleClass* klass
  (fg (:array GdkColor 5))   ;; GdkColor fg[  0x000000005]
  (bg (:array GdkColor 5))   ;; GdkColor bg[  0x000000005]
  (light (:array GdkColor 5))   ;; GdkColor light[  0x000000005]
  (dark (:array GdkColor 5))   ;; GdkColor dark[  0x000000005]
  (mid (:array GdkColor 5))   ;; GdkColor mid[  0x000000005]
  (text (:array GdkColor 5))   ;; GdkColor text[  0x000000005]
  (base (:array GdkColor 5))   ;; GdkColor base[  0x000000005]
  (black GdkColor)   ;; GdkColor black
  (white GdkColor)   ;; GdkColor white
  (font (* GdkFont))   ;; GdkFont* font
  (fg_gc (:array (* GdkGC) 5))   ;; GdkGC* fg_gc[  0x000000005]
  (bg_gc (:array (* GdkGC) 5))   ;; GdkGC* bg_gc[  0x000000005]
  (light_gc (:array (* GdkGC) 5))   ;; GdkGC* light_gc[  0x000000005]
  (dark_gc (:array (* GdkGC) 5))   ;; GdkGC* dark_gc[  0x000000005]
  (mid_gc (:array (* GdkGC) 5))   ;; GdkGC* mid_gc[  0x000000005]
  (text_gc (:array (* GdkGC) 5))   ;; GdkGC* text_gc[  0x000000005]
  (base_gc (:array (* GdkGC) 5))   ;; GdkGC* base_gc[  0x000000005]
  (black_gc (* GdkGC))   ;; GdkGC* black_gc
  (white_gc (* GdkGC))   ;; GdkGC* white_gc
  (bg_pixmap (:array (* GdkPixmap) 5))   ;;
  ;;  GdkPixmap* bg_pixmap[  0x000000005]
  (ref_count gint)   ;; gint ref_count
  (attach_count gint)   ;; gint attach_count
  (depth gint)   ;; gint depth
  (colormap (* GdkColormap))   ;; GdkColormap* colormap
  (engine (* GtkThemeEngine))   ;; GtkThemeEngine* engine
  (engine_data gpointer)   ;; gpointer engine_data
  (rc_style (* GtkRcStyle))   ;; GtkRcStyle* rc_style
  (styles (* GSList))   ;; GSList* styles
  ))   ;; bind-c-type _GtkStyle

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:106 <1320> 
;; struct _GtkStyleClass {
;;         gint xthickness; gint ythickness; void(* draw_hline)( GtkStyle*
;;   style,
;;              GdkWindow* window, GtkStateType state_type, GdkRectangle*
;;   area, GtkWidget
;;   * widget, gchar* detail, gint x1, gint x2, gint y); void(* draw_vline)
;;   ( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
;;   GdkRectangle
;;   * area, GtkWidget* widget, gchar* detail, gint y1, gint y2, gint x);
;;   void
;;   (* draw_shadow)( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;   widget, gchar
;;   * detail, gint x, gint y, gint width, gint height); void(*
;;   draw_polygon
;;   )( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
;;   GtkShadowType
;;    shadow_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   GdkPoint
;;   * point, gint npoints, gboolean fill); void(* draw_arrow)( GtkStyle*
;;   style,
;;              GdkWindow* window, GtkStateType state_type, GtkShadowType
;;   shadow_type,
;;              GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   GtkArrowType arrow_type,
;;              gboolean fill, gint x, gint y, gint width, gint height);
;;   void(* draw_diamond
;;   )( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
;;   GtkShadowType
;;    shadow_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   gint
;;    x, gint y, gint width, gint height); void(* draw_oval)( GtkStyle*
;;   style,
;;              GdkWindow* window, GtkStateType state_type, GtkShadowType
;;   shadow_type,
;;              GdkRectangle* area, GtkWidget* widget, gchar* detail, gint
;;   x, gint y,
;;              gint width, gint height); void(* draw_string)( GtkStyle*
;;   style, GdkWindow
;;   * window, GtkStateType state_type, GdkRectangle* area, GtkWidget*
;;   widget,
;;              gchar* detail, gint x, gint y, const gchar* string); void(*
;;   draw_box)
;;   ( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
;;   GtkShadowType
;;    shadow_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   gint
;;    x, gint y, gint width, gint height); void(* draw_flat_box)( GtkStyle*
;;    style, GdkWindow* window, GtkStateType state_type, GtkShadowType
;;   shadow_type,
;;              GdkRectangle* area, GtkWidget* widget, gchar* detail, gint
;;   x, gint y,
;;              gint width, gint height); void(* draw_check)( GtkStyle*
;;   style, GdkWindow
;;   * window, GtkStateType state_type, GtkShadowType shadow_type,
;;   GdkRectangle
;;   * area, GtkWidget* widget, gchar* detail, gint x, gint y, gint width,
;;   gint
;;    height); void(* draw_option)( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height); void
;;   (* draw_cross)( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;   widget, gchar
;;   * detail, gint x, gint y, gint width, gint height); void(* draw_ramp)(
;;    GtkStyle* style, GdkWindow* window, GtkStateType state_type,
;;   GtkShadowType
;;    shadow_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   GtkArrowType
;;    arrow_type, gint x, gint y, gint width, gint height); void(* draw_tab
;;   )( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
;;   GtkShadowType
;;    shadow_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   gint
;;    x, gint y, gint width, gint height); void(* draw_shadow_gap)(
;;   GtkStyle
;;   * style, GdkWindow* window, GtkStateType state_type, GtkShadowType
;;   shadow_type,
;;              GdkRectangle* area, GtkWidget* widget, gchar* detail, gint
;;   x, gint y,
;;              gint width, gint height, GtkPositionType gap_side, gint
;;   gap_x, gint gap_width
;;   ); void(* draw_box_gap)( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height,
;;   GtkPositionType
;;    gap_side, gint gap_x, gint gap_width); void(* draw_extension)(
;;   GtkStyle
;;   * style, GdkWindow* window, GtkStateType state_type, GtkShadowType
;;   shadow_type,
;;              GdkRectangle* area, GtkWidget* widget, gchar* detail, gint
;;   x, gint y,
;;              gint width, gint height, GtkPositionType gap_side); void(*
;;   draw_focus
;;   )( GtkStyle* style, GdkWindow* window, GdkRectangle* area, GtkWidget*
;;   widget,
;;              gchar* detail, gint x, gint y, gint width, gint height);
;;   void(* draw_slider
;;   )( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
;;   GtkShadowType
;;    shadow_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   gint
;;    x, gint y, gint width, gint height, GtkOrientation orientation); void
;;   (* draw_handle)( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;   widget, gchar
;;   * detail, gint x, gint y, gint width, gint height, GtkOrientation
;;   orientation
;;   ); };
(ff:bind-c-type _GtkStyleClass (:struct
  (xthickness gint)   ;; gint xthickness
  (ythickness gint)   ;; gint ythickness
  (draw_hline ff:function-pointer)   ;;
  ;;  void(* draw_hline)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GdkRectangle* area, GtkWidget* widget, gchar* detail, gint x1, gint x2,
  ;;            gint y)
  (draw_vline ff:function-pointer)   ;;
  ;;  void(* draw_vline)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GdkRectangle* area, GtkWidget* widget, gchar* detail, gint y1, gint y2,
  ;;            gint x)
  (draw_shadow ff:function-pointer)   ;;
  ;;  void(* draw_shadow)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_polygon ff:function-pointer)   ;;
  ;;  void(* draw_polygon)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, GdkPoint* point, gint npoints, gboolean fill)
  (draw_arrow ff:function-pointer)   ;;
  ;;  void(* draw_arrow)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, GtkArrowType arrow_type, gboolean fill, gint x, gint y, gint
  ;;  width, gint height)
  (draw_diamond ff:function-pointer)   ;;
  ;;  void(* draw_diamond)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_oval ff:function-pointer)   ;;
  ;;  void(* draw_oval)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_string ff:function-pointer)   ;;
  ;;  void(* draw_string)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GdkRectangle* area, GtkWidget* widget, gchar* detail, gint x, gint y,
  ;;            const gchar* string)
  (draw_box ff:function-pointer)   ;;
  ;;  void(* draw_box)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_flat_box ff:function-pointer)   ;;
  ;;  void(* draw_flat_box)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_check ff:function-pointer)   ;;
  ;;  void(* draw_check)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_option ff:function-pointer)   ;;
  ;;  void(* draw_option)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_cross ff:function-pointer)   ;;
  ;;  void(* draw_cross)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_ramp ff:function-pointer)   ;;
  ;;  void(* draw_ramp)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, GtkArrowType arrow_type, gint x, gint y, gint width, gint height
  ;; )
  (draw_tab ff:function-pointer)   ;;
  ;;  void(* draw_tab)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height)
  (draw_shadow_gap ff:function-pointer)   ;;
  ;;  void(* draw_shadow_gap)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height, GtkPositionType gap_side,
  ;;            gint gap_x, gint gap_width)
  (draw_box_gap ff:function-pointer)   ;;
  ;;  void(* draw_box_gap)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height, GtkPositionType gap_side,
  ;;            gint gap_x, gint gap_width)
  (draw_extension ff:function-pointer)   ;;
  ;;  void(* draw_extension)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height, GtkPositionType gap_side
  ;; )
  (draw_focus ff:function-pointer)   ;;
  ;;  void(* draw_focus)( GtkStyle* style, GdkWindow* window, GdkRectangle* area,
  ;;            GtkWidget* widget, gchar* detail, gint x, gint y, gint width, gint height
  ;; )
  (draw_slider ff:function-pointer)   ;;
  ;;  void(* draw_slider)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height, GtkOrientation orientation
  ;; )
  (draw_handle ff:function-pointer)   ;;
  ;;  void(* draw_handle)( GtkStyle* style, GdkWindow* window, GtkStateType state_type,
  ;;            GtkShadowType shadow_type, GdkRectangle* area, GtkWidget* widget, gchar
  ;; * detail, gint x, gint y, gint width, gint height, GtkOrientation orientation
  ;; )
  ))   ;; bind-c-type _GtkStyleClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:347 <1321> 
;; GtkStyle* gtk_style_new( void);
(ff:bind-c-function gtk_style_new
     :unconverted-entry-name "gtk_style_new"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:348 <1322> 
;; GtkStyle* gtk_style_copy( GtkStyle* style);
(ff:bind-c-function gtk_style_copy
     :unconverted-entry-name "gtk_style_copy"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types (("GtkStyle" "*"))
     :c-arg-names (style)
     :arguments ((* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:349 <1323> 
;; GtkStyle* gtk_style_attach( GtkStyle* style, GdkWindow* window);
(ff:bind-c-function gtk_style_attach
     :unconverted-entry-name "gtk_style_attach"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*"))
     :c-arg-names (style window)
     :arguments ((* GtkStyle) (* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:351 <1324> 
;; void gtk_style_detach( GtkStyle* style);
(ff:bind-c-function gtk_style_detach
     :unconverted-entry-name "gtk_style_detach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*"))
     :c-arg-names (style)
     :arguments ((* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:352 <1325> 
;; GtkStyle* gtk_style_ref( GtkStyle* style);
(ff:bind-c-function gtk_style_ref
     :unconverted-entry-name "gtk_style_ref"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types (("GtkStyle" "*"))
     :c-arg-names (style)
     :arguments ((* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:353 <1326> 
;; void gtk_style_unref( GtkStyle* style);
(ff:bind-c-function gtk_style_unref
     :unconverted-entry-name "gtk_style_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*"))
     :c-arg-names (style)
     :arguments ((* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:354 <1327> 
;; void gtk_style_set_background( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type);
(ff:bind-c-function gtk_style_set_background
     :unconverted-entry-name "gtk_style_set_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType"))
     :c-arg-names (style window state_type)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:357 <1328> 
;; void gtk_style_apply_default_background( GtkStyle* style, GdkWindow*
;;   window,
;;              gboolean set_bg, GtkStateType state_type, GdkRectangle*
;;   area, gint x,
;;              gint y, gint width, gint height);
(ff:bind-c-function gtk_style_apply_default_background
     :unconverted-entry-name "gtk_style_apply_default_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("gboolean")
                   ("GtkStateType") ("GdkRectangle" "*") ("gint") ("gint")
                   ("gint") ("gint"))
     :c-arg-names (style window set_bg state_type area x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) gboolean GtkStateType
                 (* GdkRectangle) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:367 <1329> 
;; void gtk_draw_hline( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, gint x1, gint x2, gint y);
(ff:bind-c-function gtk_draw_hline
     :unconverted-entry-name "gtk_draw_hline"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type x1 x2 y)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:373 <1330> 
;; void gtk_draw_vline( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, gint y1, gint y2, gint x);
(ff:bind-c-function gtk_draw_vline
     :unconverted-entry-name "gtk_draw_vline"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type y1 y2 x)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:379 <1331> 
;; void gtk_draw_shadow( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height);
(ff:bind-c-function gtk_draw_shadow
     :unconverted-entry-name "gtk_draw_shadow"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:387 <1332> 
;; void gtk_draw_polygon( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkPoint* points, gint
;;   npoints,
;;              gboolean fill);
(ff:bind-c-function gtk_draw_polygon
     :unconverted-entry-name "gtk_draw_polygon"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkPoint" "*") ("gint") ("gboolean"))
     :c-arg-names (style window state_type shadow_type points npoints fill)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkPoint) gint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:394 <1333> 
;; void gtk_draw_arrow( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GtkArrowType arrow_type,
;;   gboolean
;;    fill, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_draw_arrow
     :unconverted-entry-name "gtk_draw_arrow"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GtkArrowType") ("gboolean") ("gint")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type arrow_type fill x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 GtkArrowType gboolean gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:404 <1334> 
;; void gtk_draw_diamond( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height);
(ff:bind-c-function gtk_draw_diamond
     :unconverted-entry-name "gtk_draw_diamond"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:412 <1335> 
;; void gtk_draw_oval( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, gint x, gint y, gint width, gint
;;   height);
(ff:bind-c-function gtk_draw_oval
     :unconverted-entry-name "gtk_draw_oval"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:420 <1336> 
;; void gtk_draw_string( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, gint x, gint y, const gchar* string);
(ff:bind-c-function gtk_draw_string
     :unconverted-entry-name "gtk_draw_string"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("gint") ("gint") ("const" "gchar" "*"))
     :c-arg-names (style window state_type x y string)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType gint gint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:426 <1337> 
;; void gtk_draw_box( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, gint x, gint y, gint width, gint
;;   height);
(ff:bind-c-function gtk_draw_box
     :unconverted-entry-name "gtk_draw_box"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:434 <1338> 
;; void gtk_draw_flat_box( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height);
(ff:bind-c-function gtk_draw_flat_box
     :unconverted-entry-name "gtk_draw_flat_box"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:442 <1339> 
;; void gtk_draw_check( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height);
(ff:bind-c-function gtk_draw_check
     :unconverted-entry-name "gtk_draw_check"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:450 <1340> 
;; void gtk_draw_option( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height);
(ff:bind-c-function gtk_draw_option
     :unconverted-entry-name "gtk_draw_option"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:458 <1341> 
;; void gtk_draw_cross( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height);
(ff:bind-c-function gtk_draw_cross
     :unconverted-entry-name "gtk_draw_cross"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:466 <1342> 
;; void gtk_draw_ramp( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, GtkArrowType arrow_type, gint x,
;;   gint y, gint
;;    width, gint height);
(ff:bind-c-function gtk_draw_ramp
     :unconverted-entry-name "gtk_draw_ramp"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GtkArrowType") ("gint") ("gint")
                   ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type arrow_type x y width
                   height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 GtkArrowType gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:475 <1343> 
;; void gtk_draw_tab( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, gint x, gint y, gint width, gint
;;   height);
(ff:bind-c-function gtk_draw_tab
     :unconverted-entry-name "gtk_draw_tab"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:483 <1344> 
;; void gtk_draw_shadow_gap( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height, GtkPositionType gap_side, gint gap_x, gint gap_width);
(ff:bind-c-function gtk_draw_shadow_gap
     :unconverted-entry-name "gtk_draw_shadow_gap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint")
                   ("GtkPositionType") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height
                   gap_side gap_x gap_width)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint GtkPositionType gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:494 <1345> 
;; void gtk_draw_box_gap( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height, GtkPositionType gap_side, gint gap_x, gint gap_width);
(ff:bind-c-function gtk_draw_box_gap
     :unconverted-entry-name "gtk_draw_box_gap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint")
                   ("GtkPositionType") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type x y width height
                   gap_side gap_x gap_width)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint GtkPositionType gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:505 <1346> 
;; void gtk_draw_extension( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height, GtkPositionType gap_side);
(ff:bind-c-function gtk_draw_extension
     :unconverted-entry-name "gtk_draw_extension"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint")
                   ("GtkPositionType"))
     :c-arg-names (style window state_type shadow_type x y width height
                   gap_side)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint GtkPositionType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:514 <1347> 
;; void gtk_draw_focus( GtkStyle* style, GdkWindow* window, gint x, gint
;;    y, gint width, gint height);
(ff:bind-c-function gtk_draw_focus
     :unconverted-entry-name "gtk_draw_focus"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("gint") ("gint")
                   ("gint") ("gint"))
     :c-arg-names (style window x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:520 <1348> 
;; void gtk_draw_slider( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height, GtkOrientation orientation);
(ff:bind-c-function gtk_draw_slider
     :unconverted-entry-name "gtk_draw_slider"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint")
                   ("GtkOrientation"))
     :c-arg-names (style window state_type shadow_type x y width height
                   orientation)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint GtkOrientation)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:529 <1349> 
;; void gtk_draw_handle( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, gint x, gint y, gint width,
;;   gint
;;    height, GtkOrientation orientation);
(ff:bind-c-function gtk_draw_handle
     :unconverted-entry-name "gtk_draw_handle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("gint") ("gint") ("gint") ("gint")
                   ("GtkOrientation"))
     :c-arg-names (style window state_type shadow_type x y width height
                   orientation)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType gint
                 gint gint gint GtkOrientation)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:539 <1350> 
;; void gtk_paint_hline( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   gint
;;    x1, gint x2, gint y);
(ff:bind-c-function gtk_paint_hline
     :unconverted-entry-name "gtk_paint_hline"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GdkRectangle" "*") ("GtkWidget" "*") ("gchar" "*")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type area widget detail x1 x2 y)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType (* GdkRectangle)
                 (* GtkWidget) (* gchar) gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:548 <1351> 
;; void gtk_paint_vline( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   gint
;;    y1, gint y2, gint x);
(ff:bind-c-function gtk_paint_vline
     :unconverted-entry-name "gtk_paint_vline"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GdkRectangle" "*") ("GtkWidget" "*") ("gchar" "*")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type area widget detail y1 y2 x)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType (* GdkRectangle)
                 (* GtkWidget) (* gchar) gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:557 <1352> 
;; void gtk_paint_shadow( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_shadow
     :unconverted-entry-name "gtk_paint_shadow"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:568 <1353> 
;; void gtk_paint_polygon( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, GdkPoint* points, gint npoints, gboolean fill)
;;   ;
(ff:bind-c-function gtk_paint_polygon
     :unconverted-entry-name "gtk_paint_polygon"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("GdkPoint" "*") ("gint") ("gboolean"))
     :c-arg-names (style window state_type shadow_type area widget detail
                   points npoints fill)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) (* GdkPoint) gint
                 gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:578 <1354> 
;; void gtk_paint_arrow( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, GtkArrowType arrow_type, gboolean fill, gint
;;   x,
;;              gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_arrow
     :unconverted-entry-name "gtk_paint_arrow"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("GtkArrowType") ("gboolean") ("gint")
                   ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail
                   arrow_type fill x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) GtkArrowType
                 gboolean gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:591 <1355> 
;; void gtk_paint_diamond( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_diamond
     :unconverted-entry-name "gtk_paint_diamond"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:602 <1356> 
;; void gtk_paint_oval( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_oval
     :unconverted-entry-name "gtk_paint_oval"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:613 <1357> 
;; void gtk_paint_string( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GdkRectangle* area, GtkWidget* widget, gchar* detail,
;;   gint
;;    x, gint y, const gchar* string);
(ff:bind-c-function gtk_paint_string
     :unconverted-entry-name "gtk_paint_string"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GdkRectangle" "*") ("GtkWidget" "*") ("gchar" "*")
                   ("gint") ("gint") ("const" "gchar" "*"))
     :c-arg-names (style window state_type area widget detail x y string)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType (* GdkRectangle)
                 (* GtkWidget) (* gchar) gint gint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:622 <1358> 
;; void gtk_paint_box( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;   widget, gchar
;;   * detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_box
     :unconverted-entry-name "gtk_paint_box"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:633 <1359> 
;; void gtk_paint_flat_box( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_flat_box
     :unconverted-entry-name "gtk_paint_flat_box"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:644 <1360> 
;; void gtk_paint_check( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_check
     :unconverted-entry-name "gtk_paint_check"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:655 <1361> 
;; void gtk_paint_option( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_option
     :unconverted-entry-name "gtk_paint_option"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:666 <1362> 
;; void gtk_paint_cross( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_cross
     :unconverted-entry-name "gtk_paint_cross"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:677 <1363> 
;; void gtk_paint_ramp( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, GtkArrowType arrow_type, gint x, gint y, gint
;;   width,
;;              gint height);
(ff:bind-c-function gtk_paint_ramp
     :unconverted-entry-name "gtk_paint_ramp"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("GtkArrowType") ("gint") ("gint") ("gint")
                   ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail
                   arrow_type x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) GtkArrowType gint
                 gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:689 <1364> 
;; void gtk_paint_tab( GtkStyle* style, GdkWindow* window, GtkStateType
;;   state_type,
;;              GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;   widget, gchar
;;   * detail, gint x, gint y, gint width, gint height);
(ff:bind-c-function gtk_paint_tab
     :unconverted-entry-name "gtk_paint_tab"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:700 <1365> 
;; void gtk_paint_shadow_gap( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height,
;;   GtkPositionType
;;    gap_side, gint gap_x, gint gap_width);
(ff:bind-c-function gtk_paint_shadow_gap
     :unconverted-entry-name "gtk_paint_shadow_gap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint")
                   ("GtkPositionType") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height gap_side gap_x gap_width)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint
                 GtkPositionType gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:714 <1366> 
;; void gtk_paint_box_gap( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height,
;;   GtkPositionType
;;    gap_side, gint gap_x, gint gap_width);
(ff:bind-c-function gtk_paint_box_gap
     :unconverted-entry-name "gtk_paint_box_gap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint")
                   ("GtkPositionType") ("gint") ("gint"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height gap_side gap_x gap_width)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint
                 GtkPositionType gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:728 <1367> 
;; void gtk_paint_extension( GtkStyle* style, GdkWindow* window,
;;   GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height,
;;   GtkPositionType
;;    gap_side);
(ff:bind-c-function gtk_paint_extension
     :unconverted-entry-name "gtk_paint_extension"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint")
                   ("GtkPositionType"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height gap_side)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint
                 GtkPositionType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:740 <1368> 
;; void gtk_paint_focus( GtkStyle* style, GdkWindow* window, GdkRectangle
;;   * area, GtkWidget* widget, gchar* detail, gint x, gint y, gint width,
;;   gint
;;    height);
(ff:bind-c-function gtk_paint_focus
     :unconverted-entry-name "gtk_paint_focus"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GdkRectangle" "*")
                   ("GtkWidget" "*") ("gchar" "*") ("gint") ("gint") ("gint")
                   ("gint"))
     :c-arg-names (style window area widget detail x y width height)
     :arguments ((* GtkStyle) (* GdkWindow) (* GdkRectangle) (* GtkWidget)
                 (* gchar) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:749 <1369> 
;; void gtk_paint_slider( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height,
;;   GtkOrientation
;;    orientation);
(ff:bind-c-function gtk_paint_slider
     :unconverted-entry-name "gtk_paint_slider"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint")
                   ("GtkOrientation"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height orientation)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint
                 GtkOrientation)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:761 <1370> 
;; void gtk_paint_handle( GtkStyle* style, GdkWindow* window, GtkStateType
;;    state_type, GtkShadowType shadow_type, GdkRectangle* area, GtkWidget*
;;    widget, gchar* detail, gint x, gint y, gint width, gint height,
;;   GtkOrientation
;;    orientation);
(ff:bind-c-function gtk_paint_handle
     :unconverted-entry-name "gtk_paint_handle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("GdkWindow" "*") ("GtkStateType")
                   ("GtkShadowType") ("GdkRectangle" "*") ("GtkWidget" "*")
                   ("gchar" "*") ("gint") ("gint") ("gint") ("gint")
                   ("GtkOrientation"))
     :c-arg-names (style window state_type shadow_type area widget detail x y
                   width height orientation)
     :arguments ((* GtkStyle) (* GdkWindow) GtkStateType GtkShadowType
                 (* GdkRectangle) (* GtkWidget) (* gchar) gint gint gint gint
                 GtkOrientation)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:778 <1371> 
;; void gtk_style_set_prop_experimental( GtkStyle* style, const gchar*
;;   name,
;;              gint value);
(ff:bind-c-function gtk_style_set_prop_experimental
     :unconverted-entry-name "gtk_style_set_prop_experimental"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (style name value)
     :arguments ((* GtkStyle) (* gchar) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkstyle.h:781 <1372> 
;; gint gtk_style_get_prop_experimental( GtkStyle* style, const gchar*
;;   name,
;;              gint default_value);
(ff:bind-c-function gtk_style_get_prop_experimental
     :unconverted-entry-name "gtk_style_get_prop_experimental"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkStyle" "*") ("const" "gchar" "*") ("gint"))
     :c-arg-names (style name default_value)
     :arguments ((* GtkStyle) (* gchar) gint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:45 <1373> 
;; typedef enum {
;;         GTK_TOPLEVEL =  0x000000001 LSHIFT  0x000000004, GTK_NO_WINDOW =
;;   0x000000001
;;    LSHIFT  0x000000005, GTK_REALIZED =  0x000000001 LSHIFT  0x000000006,
;;              GTK_MAPPED =  0x000000001 LSHIFT  0x000000007, GTK_VISIBLE
;;   =  0x000000001
;;    LSHIFT  0x000000008, GTK_SENSITIVE =  0x000000001 LSHIFT
;;   0x000000009,
;;              GTK_PARENT_SENSITIVE =  0x000000001 LSHIFT  0x00000000a,
;;   GTK_CAN_FOCUS
;;    =  0x000000001 LSHIFT  0x00000000b, GTK_HAS_FOCUS =  0x000000001
;;   LSHIFT
;;     0x00000000c, GTK_CAN_DEFAULT =  0x000000001 LSHIFT  0x00000000d,
;;   GTK_HAS_DEFAULT
;;    =  0x000000001 LSHIFT  0x00000000e, GTK_HAS_GRAB =  0x000000001
;;   LSHIFT
;;     0x00000000f, GTK_RC_STYLE =  0x000000001 LSHIFT  0x000000010,
;;   GTK_COMPOSITE_CHILD
;;    =  0x000000001 LSHIFT  0x000000011, GTK_NO_REPARENT =  0x000000001
;;   LSHIFT
;;     0x000000012, GTK_APP_PAINTABLE =  0x000000001 LSHIFT  0x000000013,
;;   GTK_RECEIVES_DEFAULT
;;    =  0x000000001 LSHIFT  0x000000014 } GtkWidgetFlags;
(ff:bind-c-constant GTK_TOPLEVEL
                    16) ;;
;;   GTK_TOPLEVEL =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GTK_NO_WINDOW
                    32) ;;
;;   GTK_NO_WINDOW =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GTK_REALIZED
                    64) ;;
;;   GTK_REALIZED =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GTK_MAPPED
                    128) ;;
;;   GTK_MAPPED =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GTK_VISIBLE
                    256) ;;
;;   GTK_VISIBLE =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant GTK_SENSITIVE
                    512) ;;
;;   GTK_SENSITIVE =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant GTK_PARENT_SENSITIVE
                    1024) ;;
;;   GTK_PARENT_SENSITIVE =  0x000000001 LSHIFT  0x00000000a 
(ff:bind-c-constant GTK_CAN_FOCUS
                    2048) ;;
;;   GTK_CAN_FOCUS =  0x000000001 LSHIFT  0x00000000b 
(ff:bind-c-constant GTK_HAS_FOCUS
                    4096) ;;
;;   GTK_HAS_FOCUS =  0x000000001 LSHIFT  0x00000000c 
(ff:bind-c-constant GTK_CAN_DEFAULT
                    8192) ;;
;;   GTK_CAN_DEFAULT =  0x000000001 LSHIFT  0x00000000d 
(ff:bind-c-constant GTK_HAS_DEFAULT
                    16384) ;;
;;   GTK_HAS_DEFAULT =  0x000000001 LSHIFT  0x00000000e 
(ff:bind-c-constant GTK_HAS_GRAB
                    32768) ;;
;;   GTK_HAS_GRAB =  0x000000001 LSHIFT  0x00000000f 
(ff:bind-c-constant GTK_RC_STYLE
                    65536) ;;
;;   GTK_RC_STYLE =  0x000000001 LSHIFT  0x000000010 
(ff:bind-c-constant GTK_COMPOSITE_CHILD
                    131072) ;;
;;   GTK_COMPOSITE_CHILD =  0x000000001 LSHIFT  0x000000011 
(ff:bind-c-constant GTK_NO_REPARENT
                    262144) ;;
;;   GTK_NO_REPARENT =  0x000000001 LSHIFT  0x000000012 
(ff:bind-c-constant GTK_APP_PAINTABLE
                    524288) ;;
;;   GTK_APP_PAINTABLE =  0x000000001 LSHIFT  0x000000013 
(ff:bind-c-constant GTK_RECEIVES_DEFAULT
                    1048576) ;;
;;   GTK_RECEIVES_DEFAULT =  0x000000001 LSHIFT  0x000000014 
(ff:bind-c-type GtkWidgetFlags :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:121 <1374> 
;; typedef struct _GtkRequisition GtkRequisition;
(ff:bind-c-typedef _GtkRequisition
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkRequisition _GtkRequisition)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:122 <1375> 
;; typedef struct _GtkAllocation GtkAllocation;
(ff:bind-c-typedef _GtkAllocation
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAllocation _GtkAllocation)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:123 <1376> 
;; typedef struct _GtkSelectionData GtkSelectionData;
(ff:bind-c-typedef _GtkSelectionData
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkSelectionData _GtkSelectionData)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:124 <1377> 
;; typedef struct _GtkWidgetClass GtkWidgetClass;
(ff:bind-c-typedef _GtkWidgetClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkWidgetClass _GtkWidgetClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:125 <1378> 
;; typedef struct _GtkWidgetAuxInfo GtkWidgetAuxInfo;
(ff:bind-c-typedef _GtkWidgetAuxInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkWidgetAuxInfo _GtkWidgetAuxInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:126 <1379> 
;; typedef struct _GtkWidgetShapeInfo GtkWidgetShapeInfo;
(ff:bind-c-typedef _GtkWidgetShapeInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkWidgetShapeInfo _GtkWidgetShapeInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:128 <1380> 
;; typedef void(* GtkCallback)( GtkWidget* widget, gpointer data);
(ff:bind-c-type GtkCallback (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:134 <1381> 
;; struct _GtkRequisition { gint16 width; gint16 height; };
(ff:bind-c-type _GtkRequisition (:struct
  (width gint16)   ;; gint16 width
  (height gint16)   ;; gint16 height
  ))   ;; bind-c-type _GtkRequisition

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:144 <1382> 
;; struct _GtkAllocation {
;;         gint16 x; gint16 y; guint16 width; guint16 height; };
(ff:bind-c-type _GtkAllocation (:struct
  (x gint16)   ;; gint16 x
  (y gint16)   ;; gint16 y
  (width guint16)   ;; guint16 width
  (height guint16)   ;; guint16 height
  ))   ;; bind-c-type _GtkAllocation

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:161 <1383> 
;; struct _GtkSelectionData {
;;         GdkAtom selection; GdkAtom target; GdkAtom type; gint format;
;;   guchar*
;;    data; gint length; };
(ff:bind-c-type _GtkSelectionData (:struct
  (selection GdkAtom)   ;; GdkAtom selection
  (target GdkAtom)   ;; GdkAtom target
  (type GdkAtom)   ;; GdkAtom type
  (format gint)   ;; gint format
  (data (* guchar))   ;; guchar* data
  (length gint)   ;; gint length
  ))   ;; bind-c-type _GtkSelectionData

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:176 <1384> 
;; struct _GtkWidget {
;;         GtkObject object; guint16 private_flags; guint8 state; guint8
;;   saved_state;
;;              gchar* name; GtkStyle* style; GtkRequisition requisition;
;;   GtkAllocation
;;    allocation; GdkWindow* window; GtkWidget* parent; };
(ff:bind-c-type _GtkWidget (:struct
  (object GtkObject)   ;; GtkObject object
  (private_flags guint16)   ;; guint16 private_flags
  (state guint8)   ;; guint8 state
  (saved_state guint8)   ;; guint8 saved_state
  (name (* gchar))   ;; gchar* name
  (style (* GtkStyle))   ;; GtkStyle* style
  (requisition GtkRequisition)   ;; GtkRequisition requisition
  (allocation GtkAllocation)   ;; GtkAllocation allocation
  (window (* GdkWindow))   ;; GdkWindow* window
  (parent (* GtkWidget))   ;; GtkWidget* parent
  ))   ;; bind-c-type _GtkWidget

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:240 <1385> 
;; struct _GtkWidgetClass {
;;         GtkObjectClass parent_class; guint activate_signal; guint
;;   set_scroll_adjustments_signal;
;;              void(* show)( GtkWidget* widget); void(* show_all)(
;;   GtkWidget* widget
;;   ); void(* hide)( GtkWidget* widget); void(* hide_all)( GtkWidget*
;;   widget
;;   ); void(* map)( GtkWidget* widget); void(* unmap)( GtkWidget* widget);
;;              void(* realize)( GtkWidget* widget); void(* unrealize)(
;;   GtkWidget* widget
;;   ); void(* draw)( GtkWidget* widget, GdkRectangle* area); void(*
;;   draw_focus
;;   )( GtkWidget* widget); void(* draw_default)( GtkWidget* widget); void(
;;   * size_request)( GtkWidget* widget, GtkRequisition* requisition); void
;;   (* size_allocate)( GtkWidget* widget, GtkAllocation* allocation); void
;;   (* state_changed)( GtkWidget* widget, GtkStateType previous_state);
;;   void
;;   (* parent_set)( GtkWidget* widget, GtkWidget* previous_parent); void(*
;;    style_set)( GtkWidget* widget, GtkStyle* previous_style); gint(*
;;   add_accelerator
;;   )( GtkWidget* widget, guint accel_signal_id, GtkAccelGroup*
;;   accel_group,
;;              guint accel_key, GdkModifierType accel_mods, GtkAccelFlags
;;   accel_flags
;;   ); void(* remove_accelerator)( GtkWidget* widget, GtkAccelGroup*
;;   accel_group,
;;              guint accel_key, GdkModifierType accel_mods); void(*
;;   grab_focus)( GtkWidget
;;   * widget); gint(* event)( GtkWidget* widget, GdkEvent* event); gint(*
;;   button_press_event
;;   )( GtkWidget* widget, GdkEventButton* event); gint(*
;;   button_release_event
;;   )( GtkWidget* widget, GdkEventButton* event); gint(*
;;   motion_notify_event
;;   )( GtkWidget* widget, GdkEventMotion* event); gint(* delete_event)(
;;   GtkWidget
;;   * widget, GdkEventAny* event); gint(* destroy_event)( GtkWidget*
;;   widget,
;;              GdkEventAny* event); gint(* expose_event)( GtkWidget*
;;   widget, GdkEventExpose
;;   * event); gint(* key_press_event)( GtkWidget* widget, GdkEventKey*
;;   event
;;   ); gint(* key_release_event)( GtkWidget* widget, GdkEventKey* event);
;;   gint
;;   (* enter_notify_event)( GtkWidget* widget, GdkEventCrossing* event);
;;   gint
;;   (* leave_notify_event)( GtkWidget* widget, GdkEventCrossing* event);
;;   gint
;;   (* configure_event)( GtkWidget* widget, GdkEventConfigure* event);
;;   gint
;;   (* focus_in_event)( GtkWidget* widget, GdkEventFocus* event); gint(*
;;   focus_out_event
;;   )( GtkWidget* widget, GdkEventFocus* event); gint(* map_event)(
;;   GtkWidget
;;   * widget, GdkEventAny* event); gint(* unmap_event)( GtkWidget* widget,
;;              GdkEventAny* event); gint(* property_notify_event)(
;;   GtkWidget* widget,
;;              GdkEventProperty* event); gint(* selection_clear_event)(
;;   GtkWidget* widget,
;;              GdkEventSelection* event); gint(* selection_request_event)(
;;   GtkWidget
;;   * widget, GdkEventSelection* event); gint(* selection_notify_event)(
;;   GtkWidget
;;   * widget, GdkEventSelection* event); gint(* proximity_in_event)(
;;   GtkWidget
;;   * widget, GdkEventProximity* event); gint(* proximity_out_event)(
;;   GtkWidget
;;   * widget, GdkEventProximity* event); gint(* visibility_notify_event)(
;;   GtkWidget
;;   * widget, GdkEventVisibility* event); gint(* client_event)( GtkWidget*
;;    widget, GdkEventClient* event); gint(* no_expose_event)( GtkWidget*
;;   widget,
;;              GdkEventAny* event); void(* selection_get)( GtkWidget*
;;   widget, GtkSelectionData
;;   * selection_data, guint info, guint time); void(* selection_received)(
;;    GtkWidget* widget, GtkSelectionData* selection_data, guint time);
;;   void
;;   (* drag_begin)( GtkWidget* widget, GdkDragContext* context); void(*
;;   drag_end
;;   )( GtkWidget* widget, GdkDragContext* context); void(* drag_data_get)(
;;    GtkWidget* widget, GdkDragContext* context, GtkSelectionData*
;;   selection_data,
;;              guint info, guint time); void(* drag_data_delete)(
;;   GtkWidget* widget,
;;              GdkDragContext* context); void(* drag_leave)( GtkWidget*
;;   widget, GdkDragContext
;;   * context, guint time); gboolean(* drag_motion)( GtkWidget* widget,
;;   GdkDragContext
;;   * context, gint x, gint y, guint time); gboolean(* drag_drop)(
;;   GtkWidget
;;   * widget, GdkDragContext* context, gint x, gint y, guint time); void(*
;;    drag_data_received)( GtkWidget* widget, GdkDragContext* context, gint
;;    x, gint y, GtkSelectionData* selection_data, guint info, guint time);
;;              void(* debug_msg)( GtkWidget* widget, const gchar* string);
;;   GtkFunction
;;    pad1; GtkFunction pad2; GtkFunction pad3; GtkFunction pad4; };
(ff:bind-c-type _GtkWidgetClass (:struct
  (parent_class GtkObjectClass)   ;; GtkObjectClass parent_class
  (activate_signal guint)   ;; guint activate_signal
  (set_scroll_adjustments_signal guint)   ;;
  ;;  guint set_scroll_adjustments_signal
  (show ff:function-pointer)   ;; void(* show)( GtkWidget* widget)
  (show_all ff:function-pointer)   ;; void(* show_all)( GtkWidget* widget)
  (hide ff:function-pointer)   ;; void(* hide)( GtkWidget* widget)
  (hide_all ff:function-pointer)   ;; void(* hide_all)( GtkWidget* widget)
  (map ff:function-pointer)   ;; void(* map)( GtkWidget* widget)
  (unmap ff:function-pointer)   ;; void(* unmap)( GtkWidget* widget)
  (realize ff:function-pointer)   ;; void(* realize)( GtkWidget* widget)
  (unrealize ff:function-pointer)   ;;
  ;;  void(* unrealize)( GtkWidget* widget)
  (draw ff:function-pointer)   ;;
  ;;  void(* draw)( GtkWidget* widget, GdkRectangle* area)
  (draw_focus ff:function-pointer)   ;;
  ;;  void(* draw_focus)( GtkWidget* widget)
  (draw_default ff:function-pointer)   ;;
  ;;  void(* draw_default)( GtkWidget* widget)
  (size_request ff:function-pointer)   ;;
  ;;  void(* size_request)( GtkWidget* widget, GtkRequisition* requisition)
  (size_allocate ff:function-pointer)   ;;
  ;;  void(* size_allocate)( GtkWidget* widget, GtkAllocation* allocation)
  (state_changed ff:function-pointer)   ;;
  ;;  void(* state_changed)( GtkWidget* widget, GtkStateType previous_state)
  (parent_set ff:function-pointer)   ;;
  ;;  void(* parent_set)( GtkWidget* widget, GtkWidget* previous_parent)
  (style_set ff:function-pointer)   ;;
  ;;  void(* style_set)( GtkWidget* widget, GtkStyle* previous_style)
  (add_accelerator ff:function-pointer)   ;;
  ;;  gint(* add_accelerator)( GtkWidget* widget, guint accel_signal_id, GtkAccelGroup
  ;; * accel_group, guint accel_key, GdkModifierType accel_mods, GtkAccelFlags
  ;;  accel_flags)
  (remove_accelerator ff:function-pointer)   ;;
  ;;  void(* remove_accelerator)( GtkWidget* widget, GtkAccelGroup* accel_group,
  ;;            guint accel_key, GdkModifierType accel_mods)
  (grab_focus ff:function-pointer)   ;;
  ;;  void(* grab_focus)( GtkWidget* widget)
  (event ff:function-pointer)   ;;
  ;;  gint(* event)( GtkWidget* widget, GdkEvent* event)
  (button_press_event ff:function-pointer)   ;;
  ;;  gint(* button_press_event)( GtkWidget* widget, GdkEventButton* event)
  (button_release_event ff:function-pointer)   ;;
  ;;  gint(* button_release_event)( GtkWidget* widget, GdkEventButton* event)
  (motion_notify_event ff:function-pointer)   ;;
  ;;  gint(* motion_notify_event)( GtkWidget* widget, GdkEventMotion* event)
  (delete_event ff:function-pointer)   ;;
  ;;  gint(* delete_event)( GtkWidget* widget, GdkEventAny* event)
  (destroy_event ff:function-pointer)   ;;
  ;;  gint(* destroy_event)( GtkWidget* widget, GdkEventAny* event)
  (expose_event ff:function-pointer)   ;;
  ;;  gint(* expose_event)( GtkWidget* widget, GdkEventExpose* event)
  (key_press_event ff:function-pointer)   ;;
  ;;  gint(* key_press_event)( GtkWidget* widget, GdkEventKey* event)
  (key_release_event ff:function-pointer)   ;;
  ;;  gint(* key_release_event)( GtkWidget* widget, GdkEventKey* event)
  (enter_notify_event ff:function-pointer)   ;;
  ;;  gint(* enter_notify_event)( GtkWidget* widget, GdkEventCrossing* event)
  (leave_notify_event ff:function-pointer)   ;;
  ;;  gint(* leave_notify_event)( GtkWidget* widget, GdkEventCrossing* event)
  (configure_event ff:function-pointer)   ;;
  ;;  gint(* configure_event)( GtkWidget* widget, GdkEventConfigure* event)
  (focus_in_event ff:function-pointer)   ;;
  ;;  gint(* focus_in_event)( GtkWidget* widget, GdkEventFocus* event)
  (focus_out_event ff:function-pointer)   ;;
  ;;  gint(* focus_out_event)( GtkWidget* widget, GdkEventFocus* event)
  (map_event ff:function-pointer)   ;;
  ;;  gint(* map_event)( GtkWidget* widget, GdkEventAny* event)
  (unmap_event ff:function-pointer)   ;;
  ;;  gint(* unmap_event)( GtkWidget* widget, GdkEventAny* event)
  (property_notify_event ff:function-pointer)   ;;
  ;;  gint(* property_notify_event)( GtkWidget* widget, GdkEventProperty* event)
  (selection_clear_event ff:function-pointer)   ;;
  ;;  gint(* selection_clear_event)( GtkWidget* widget, GdkEventSelection* event
  ;; )
  (selection_request_event ff:function-pointer)   ;;
  ;;  gint(* selection_request_event)( GtkWidget* widget, GdkEventSelection* event
  ;; )
  (selection_notify_event ff:function-pointer)   ;;
  ;;  gint(* selection_notify_event)( GtkWidget* widget, GdkEventSelection* event
  ;; )
  (proximity_in_event ff:function-pointer)   ;;
  ;;  gint(* proximity_in_event)( GtkWidget* widget, GdkEventProximity* event)
  (proximity_out_event ff:function-pointer)   ;;
  ;;  gint(* proximity_out_event)( GtkWidget* widget, GdkEventProximity* event)
  (visibility_notify_event ff:function-pointer)   ;;
  ;;  gint(* visibility_notify_event)( GtkWidget* widget, GdkEventVisibility* event
  ;; )
  (client_event ff:function-pointer)   ;;
  ;;  gint(* client_event)( GtkWidget* widget, GdkEventClient* event)
  (no_expose_event ff:function-pointer)   ;;
  ;;  gint(* no_expose_event)( GtkWidget* widget, GdkEventAny* event)
  (selection_get ff:function-pointer)   ;;
  ;;  void(* selection_get)( GtkWidget* widget, GtkSelectionData* selection_data,
  ;;            guint info, guint time)
  (selection_received ff:function-pointer)   ;;
  ;;  void(* selection_received)( GtkWidget* widget, GtkSelectionData* selection_data,
  ;;            guint time)
  (drag_begin ff:function-pointer)   ;;
  ;;  void(* drag_begin)( GtkWidget* widget, GdkDragContext* context)
  (drag_end ff:function-pointer)   ;;
  ;;  void(* drag_end)( GtkWidget* widget, GdkDragContext* context)
  (drag_data_get ff:function-pointer)   ;;
  ;;  void(* drag_data_get)( GtkWidget* widget, GdkDragContext* context, GtkSelectionData
  ;; * selection_data, guint info, guint time)
  (drag_data_delete ff:function-pointer)   ;;
  ;;  void(* drag_data_delete)( GtkWidget* widget, GdkDragContext* context)
  (drag_leave ff:function-pointer)   ;;
  ;;  void(* drag_leave)( GtkWidget* widget, GdkDragContext* context, guint time
  ;; )
  (drag_motion ff:function-pointer)   ;;
  ;;  gboolean(* drag_motion)( GtkWidget* widget, GdkDragContext* context, gint x, gint
  ;;  y, guint time)
  (drag_drop ff:function-pointer)   ;;
  ;;  gboolean(* drag_drop)( GtkWidget* widget, GdkDragContext* context, gint x, gint
  ;;  y, guint time)
  (drag_data_received ff:function-pointer)   ;;
  ;;  void(* drag_data_received)( GtkWidget* widget, GdkDragContext* context, gint
  ;;  x, gint y, GtkSelectionData* selection_data, guint info, guint time)
  (debug_msg ff:function-pointer)   ;;
  ;;  void(* debug_msg)( GtkWidget* widget, const gchar* string)
  (pad1 GtkFunction)   ;; GtkFunction pad1
  (pad2 GtkFunction)   ;; GtkFunction pad2
  (pad3 GtkFunction)   ;; GtkFunction pad3
  (pad4 GtkFunction)   ;; GtkFunction pad4
  ))   ;; bind-c-type _GtkWidgetClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:409 <1386> 
;; struct _GtkWidgetAuxInfo {
;;         gint16 x; gint16 y; gint16 width; gint16 height; };
(ff:bind-c-type _GtkWidgetAuxInfo (:struct
  (x gint16)   ;; gint16 x
  (y gint16)   ;; gint16 y
  (width gint16)   ;; gint16 width
  (height gint16)   ;; gint16 height
  ))   ;; bind-c-type _GtkWidgetAuxInfo

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:417 <1387> 
;; struct _GtkWidgetShapeInfo {
;;         gint16 offset_x; gint16 offset_y; GdkBitmap* shape_mask; };
(ff:bind-c-type _GtkWidgetShapeInfo (:struct
  (offset_x gint16)   ;; gint16 offset_x
  (offset_y gint16)   ;; gint16 offset_y
  (shape_mask (* GdkBitmap))   ;; GdkBitmap* shape_mask
  ))   ;; bind-c-type _GtkWidgetShapeInfo

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:425 <1388> 
;; GtkType gtk_widget_get_type( void);
(ff:bind-c-function gtk_widget_get_type
     :unconverted-entry-name "gtk_widget_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:426 <1389> 
;; GtkWidget* gtk_widget_new( GtkType type, const gchar* first_arg_name,
;;    ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_widget_new
     :unconverted-entry-name "gtk_widget_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkType") ("const" "gchar" "*") "...")
     :c-arg-names (type first_arg_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:429 <1390> 
;; GtkWidget* gtk_widget_newv( GtkType type, guint nargs, GtkArg* args);
(ff:bind-c-function gtk_widget_newv
     :unconverted-entry-name "gtk_widget_newv"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkType") ("guint") ("GtkArg" "*"))
     :c-arg-names (type nargs args)
     :arguments (GtkType guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:432 <1391> 
;; void gtk_widget_ref( GtkWidget* widget);
(ff:bind-c-function gtk_widget_ref
     :unconverted-entry-name "gtk_widget_ref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:433 <1392> 
;; void gtk_widget_unref( GtkWidget* widget);
(ff:bind-c-function gtk_widget_unref
     :unconverted-entry-name "gtk_widget_unref"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:434 <1393> 
;; void gtk_widget_destroy( GtkWidget* widget);
(ff:bind-c-function gtk_widget_destroy
     :unconverted-entry-name "gtk_widget_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:435 <1394> 
;; void gtk_widget_destroyed( GtkWidget* widget, GtkWidget** widget_pointer
;;   );
(ff:bind-c-function gtk_widget_destroyed
     :unconverted-entry-name "gtk_widget_destroyed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkWidget" "*" "*"))
     :c-arg-names (widget widget_pointer)
     :arguments ((* GtkWidget) (* (* GtkWidget)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:437 <1395> 
;; void gtk_widget_get( GtkWidget* widget, GtkArg* arg);
(ff:bind-c-function gtk_widget_get
     :unconverted-entry-name "gtk_widget_get"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkArg" "*"))
     :c-arg-names (widget arg)
     :arguments ((* GtkWidget) (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:439 <1396> 
;; void gtk_widget_getv( GtkWidget* widget, guint nargs, GtkArg* args);
(ff:bind-c-function gtk_widget_getv
     :unconverted-entry-name "gtk_widget_getv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("guint") ("GtkArg" "*"))
     :c-arg-names (widget nargs args)
     :arguments ((* GtkWidget) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:442 <1397> 
;; void gtk_widget_set( GtkWidget* widget, const gchar* first_arg_name,
;;   ELLIPSIS
;;   );

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_widget_set
     :unconverted-entry-name "gtk_widget_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("const" "gchar" "*") "...")
     :c-arg-names (widget first_arg_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:445 <1398> 
;; void gtk_widget_setv( GtkWidget* widget, guint nargs, GtkArg* args);
(ff:bind-c-function gtk_widget_setv
     :unconverted-entry-name "gtk_widget_setv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("guint") ("GtkArg" "*"))
     :c-arg-names (widget nargs args)
     :arguments ((* GtkWidget) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:448 <1399> 
;; void gtk_widget_unparent( GtkWidget* widget);
(ff:bind-c-function gtk_widget_unparent
     :unconverted-entry-name "gtk_widget_unparent"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:449 <1400> 
;; void gtk_widget_show( GtkWidget* widget);
(ff:bind-c-function gtk_widget_show
     :unconverted-entry-name "gtk_widget_show"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:450 <1401> 
;; void gtk_widget_show_now( GtkWidget* widget);
(ff:bind-c-function gtk_widget_show_now
     :unconverted-entry-name "gtk_widget_show_now"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:451 <1402> 
;; void gtk_widget_hide( GtkWidget* widget);
(ff:bind-c-function gtk_widget_hide
     :unconverted-entry-name "gtk_widget_hide"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:452 <1403> 
;; void gtk_widget_show_all( GtkWidget* widget);
(ff:bind-c-function gtk_widget_show_all
     :unconverted-entry-name "gtk_widget_show_all"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:453 <1404> 
;; void gtk_widget_hide_all( GtkWidget* widget);
(ff:bind-c-function gtk_widget_hide_all
     :unconverted-entry-name "gtk_widget_hide_all"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:454 <1405> 
;; void gtk_widget_map( GtkWidget* widget);
(ff:bind-c-function gtk_widget_map
     :unconverted-entry-name "gtk_widget_map"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:455 <1406> 
;; void gtk_widget_unmap( GtkWidget* widget);
(ff:bind-c-function gtk_widget_unmap
     :unconverted-entry-name "gtk_widget_unmap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:456 <1407> 
;; void gtk_widget_realize( GtkWidget* widget);
(ff:bind-c-function gtk_widget_realize
     :unconverted-entry-name "gtk_widget_realize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:457 <1408> 
;; void gtk_widget_unrealize( GtkWidget* widget);
(ff:bind-c-function gtk_widget_unrealize
     :unconverted-entry-name "gtk_widget_unrealize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:460 <1409> 
;; void gtk_widget_queue_draw( GtkWidget* widget);
(ff:bind-c-function gtk_widget_queue_draw
     :unconverted-entry-name "gtk_widget_queue_draw"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:461 <1410> 
;; void gtk_widget_queue_draw_area( GtkWidget* widget, gint x, gint y, gint
;;    width, gint height);
(ff:bind-c-function gtk_widget_queue_draw_area
     :unconverted-entry-name "gtk_widget_queue_draw_area"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (widget x y width height)
     :arguments ((* GtkWidget) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:466 <1411> 
;; void gtk_widget_queue_clear( GtkWidget* widget);
(ff:bind-c-function gtk_widget_queue_clear
     :unconverted-entry-name "gtk_widget_queue_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:467 <1412> 
;; void gtk_widget_queue_clear_area( GtkWidget* widget, gint x, gint y,
;;   gint
;;    width, gint height);
(ff:bind-c-function gtk_widget_queue_clear_area
     :unconverted-entry-name "gtk_widget_queue_clear_area"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (widget x y width height)
     :arguments ((* GtkWidget) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:474 <1413> 
;; void gtk_widget_queue_resize( GtkWidget* widget);
(ff:bind-c-function gtk_widget_queue_resize
     :unconverted-entry-name "gtk_widget_queue_resize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:475 <1414> 
;; void gtk_widget_draw( GtkWidget* widget, GdkRectangle* area);
(ff:bind-c-function gtk_widget_draw
     :unconverted-entry-name "gtk_widget_draw"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GdkRectangle" "*"))
     :c-arg-names (widget area)
     :arguments ((* GtkWidget) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:477 <1415> 
;; void gtk_widget_draw_focus( GtkWidget* widget);
(ff:bind-c-function gtk_widget_draw_focus
     :unconverted-entry-name "gtk_widget_draw_focus"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:478 <1416> 
;; void gtk_widget_draw_default( GtkWidget* widget);
(ff:bind-c-function gtk_widget_draw_default
     :unconverted-entry-name "gtk_widget_draw_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:479 <1417> 
;; void gtk_widget_size_request( GtkWidget* widget, GtkRequisition*
;;   requisition
;;   );
(ff:bind-c-function gtk_widget_size_request
     :unconverted-entry-name "gtk_widget_size_request"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkRequisition" "*"))
     :c-arg-names (widget requisition)
     :arguments ((* GtkWidget) (* GtkRequisition))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:481 <1418> 
;; void gtk_widget_size_allocate( GtkWidget* widget, GtkAllocation*
;;   allocation
;;   );
(ff:bind-c-function gtk_widget_size_allocate
     :unconverted-entry-name "gtk_widget_size_allocate"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkAllocation" "*"))
     :c-arg-names (widget allocation)
     :arguments ((* GtkWidget) (* GtkAllocation))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:483 <1419> 
;; void gtk_widget_get_child_requisition( GtkWidget* widget, GtkRequisition
;;   * requisition);
(ff:bind-c-function gtk_widget_get_child_requisition
     :unconverted-entry-name "gtk_widget_get_child_requisition"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkRequisition" "*"))
     :c-arg-names (widget requisition)
     :arguments ((* GtkWidget) (* GtkRequisition))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:485 <1420> 
;; void gtk_widget_add_accelerator( GtkWidget* widget, const gchar*
;;   accel_signal,
;;              GtkAccelGroup* accel_group, guint accel_key, guint
;;   accel_mods, GtkAccelFlags
;;    accel_flags);
(ff:bind-c-function gtk_widget_add_accelerator
     :unconverted-entry-name "gtk_widget_add_accelerator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("const" "gchar" "*")
                   ("GtkAccelGroup" "*") ("guint") ("guint") ("GtkAccelFlags"))
     :c-arg-names (widget accel_signal accel_group accel_key accel_mods
                   accel_flags)
     :arguments ((* GtkWidget) (* gchar) (* GtkAccelGroup) guint guint
                 GtkAccelFlags)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:491 <1421> 
;; void gtk_widget_remove_accelerator( GtkWidget* widget, GtkAccelGroup*
;;    accel_group, guint accel_key, guint accel_mods);
(ff:bind-c-function gtk_widget_remove_accelerator
     :unconverted-entry-name "gtk_widget_remove_accelerator"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkAccelGroup" "*") ("guint") ("guint"))
     :c-arg-names (widget accel_group accel_key accel_mods)
     :arguments ((* GtkWidget) (* GtkAccelGroup) guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:495 <1422> 
;; void gtk_widget_remove_accelerators( GtkWidget* widget, const gchar*
;;   accel_signal,
;;              gboolean visible_only);
(ff:bind-c-function gtk_widget_remove_accelerators
     :unconverted-entry-name "gtk_widget_remove_accelerators"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("const" "gchar" "*") ("gboolean"))
     :c-arg-names (widget accel_signal visible_only)
     :arguments ((* GtkWidget) (* gchar) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:498 <1423> 
;; guint gtk_widget_accelerator_signal( GtkWidget* widget, GtkAccelGroup
;;   * accel_group, guint accel_key, guint accel_mods);
(ff:bind-c-function gtk_widget_accelerator_signal
     :unconverted-entry-name "gtk_widget_accelerator_signal"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkWidget" "*") ("GtkAccelGroup" "*") ("guint") ("guint"))
     :c-arg-names (widget accel_group accel_key accel_mods)
     :arguments ((* GtkWidget) (* GtkAccelGroup) guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:502 <1424> 
;; void gtk_widget_lock_accelerators( GtkWidget* widget);
(ff:bind-c-function gtk_widget_lock_accelerators
     :unconverted-entry-name "gtk_widget_lock_accelerators"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:503 <1425> 
;; void gtk_widget_unlock_accelerators( GtkWidget* widget);
(ff:bind-c-function gtk_widget_unlock_accelerators
     :unconverted-entry-name "gtk_widget_unlock_accelerators"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:504 <1426> 
;; gboolean gtk_widget_accelerators_locked( GtkWidget* widget);
(ff:bind-c-function gtk_widget_accelerators_locked
     :unconverted-entry-name "gtk_widget_accelerators_locked"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:505 <1427> 
;; gint gtk_widget_event( GtkWidget* widget, GdkEvent* event);
(ff:bind-c-function gtk_widget_event
     :unconverted-entry-name "gtk_widget_event"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkWidget" "*") ("GdkEvent" "*"))
     :c-arg-names (widget event)
     :arguments ((* GtkWidget) (* GdkEvent))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:508 <1428> 
;; gboolean gtk_widget_activate( GtkWidget* widget);
(ff:bind-c-function gtk_widget_activate
     :unconverted-entry-name "gtk_widget_activate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:509 <1429> 
;; gboolean gtk_widget_set_scroll_adjustments( GtkWidget* widget,
;;   GtkAdjustment
;;   * hadjustment, GtkAdjustment* vadjustment);
(ff:bind-c-function gtk_widget_set_scroll_adjustments
     :unconverted-entry-name "gtk_widget_set_scroll_adjustments"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkWidget" "*") ("GtkAdjustment" "*")
                   ("GtkAdjustment" "*"))
     :c-arg-names (widget hadjustment vadjustment)
     :arguments ((* GtkWidget) (* GtkAdjustment) (* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:513 <1430> 
;; void gtk_widget_reparent( GtkWidget* widget, GtkWidget* new_parent);
(ff:bind-c-function gtk_widget_reparent
     :unconverted-entry-name "gtk_widget_reparent"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkWidget" "*"))
     :c-arg-names (widget new_parent)
     :arguments ((* GtkWidget) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:515 <1431> 
;; void gtk_widget_popup( GtkWidget* widget, gint x, gint y);
(ff:bind-c-function gtk_widget_popup
     :unconverted-entry-name "gtk_widget_popup"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint") ("gint"))
     :c-arg-names (widget x y)
     :arguments ((* GtkWidget) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:518 <1432> 
;; gint gtk_widget_intersect( GtkWidget* widget, GdkRectangle* area,
;;   GdkRectangle
;;   * intersection);
(ff:bind-c-function gtk_widget_intersect
     :unconverted-entry-name "gtk_widget_intersect"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkWidget" "*") ("GdkRectangle" "*") ("GdkRectangle" "*"))
     :c-arg-names (widget area intersection)
     :arguments ((* GtkWidget) (* GdkRectangle) (* GdkRectangle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:522 <1433> 
;; void gtk_widget_grab_focus( GtkWidget* widget);
(ff:bind-c-function gtk_widget_grab_focus
     :unconverted-entry-name "gtk_widget_grab_focus"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:523 <1434> 
;; void gtk_widget_grab_default( GtkWidget* widget);
(ff:bind-c-function gtk_widget_grab_default
     :unconverted-entry-name "gtk_widget_grab_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:525 <1435> 
;; void gtk_widget_set_name( GtkWidget* widget, const gchar* name);
(ff:bind-c-function gtk_widget_set_name
     :unconverted-entry-name "gtk_widget_set_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("const" "gchar" "*"))
     :c-arg-names (widget name)
     :arguments ((* GtkWidget) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:527 <1436> 
;; gchar* gtk_widget_get_name( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_name
     :unconverted-entry-name "gtk_widget_get_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:528 <1437> 
;; void gtk_widget_set_state( GtkWidget* widget, GtkStateType state);
(ff:bind-c-function gtk_widget_set_state
     :unconverted-entry-name "gtk_widget_set_state"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkStateType"))
     :c-arg-names (widget state)
     :arguments ((* GtkWidget) GtkStateType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:530 <1438> 
;; void gtk_widget_set_sensitive( GtkWidget* widget, gboolean sensitive);
(ff:bind-c-function gtk_widget_set_sensitive
     :unconverted-entry-name "gtk_widget_set_sensitive"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gboolean"))
     :c-arg-names (widget sensitive)
     :arguments ((* GtkWidget) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:532 <1439> 
;; void gtk_widget_set_app_paintable( GtkWidget* widget, gboolean
;;   app_paintable
;;   );
(ff:bind-c-function gtk_widget_set_app_paintable
     :unconverted-entry-name "gtk_widget_set_app_paintable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gboolean"))
     :c-arg-names (widget app_paintable)
     :arguments ((* GtkWidget) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:534 <1440> 
;; void gtk_widget_set_parent( GtkWidget* widget, GtkWidget* parent);
(ff:bind-c-function gtk_widget_set_parent
     :unconverted-entry-name "gtk_widget_set_parent"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkWidget" "*"))
     :c-arg-names (widget parent)
     :arguments ((* GtkWidget) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:536 <1441> 
;; void gtk_widget_set_parent_window( GtkWidget* widget, GdkWindow*
;;   parent_window
;;   );
(ff:bind-c-function gtk_widget_set_parent_window
     :unconverted-entry-name "gtk_widget_set_parent_window"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GdkWindow" "*"))
     :c-arg-names (widget parent_window)
     :arguments ((* GtkWidget) (* GdkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:538 <1442> 
;; GdkWindow* gtk_widget_get_parent_window( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_parent_window
     :unconverted-entry-name "gtk_widget_get_parent_window"
     :c-return-type ("GdkWindow" "*")
     :return-type (* GdkWindow)
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:539 <1443> 
;; void gtk_widget_set_uposition( GtkWidget* widget, gint x, gint y);
(ff:bind-c-function gtk_widget_set_uposition
     :unconverted-entry-name "gtk_widget_set_uposition"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint") ("gint"))
     :c-arg-names (widget x y)
     :arguments ((* GtkWidget) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:542 <1444> 
;; void gtk_widget_set_usize( GtkWidget* widget, gint width, gint height);
(ff:bind-c-function gtk_widget_set_usize
     :unconverted-entry-name "gtk_widget_set_usize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint") ("gint"))
     :c-arg-names (widget width height)
     :arguments ((* GtkWidget) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:545 <1445> 
;; void gtk_widget_set_events( GtkWidget* widget, gint events);
(ff:bind-c-function gtk_widget_set_events
     :unconverted-entry-name "gtk_widget_set_events"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint"))
     :c-arg-names (widget events)
     :arguments ((* GtkWidget) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:547 <1446> 
;; void gtk_widget_add_events( GtkWidget* widget, gint events);
(ff:bind-c-function gtk_widget_add_events
     :unconverted-entry-name "gtk_widget_add_events"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint"))
     :c-arg-names (widget events)
     :arguments ((* GtkWidget) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:549 <1447> 
;; void gtk_widget_set_extension_events( GtkWidget* widget,
;;   GdkExtensionMode
;;    mode);
(ff:bind-c-function gtk_widget_set_extension_events
     :unconverted-entry-name "gtk_widget_set_extension_events"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GdkExtensionMode"))
     :c-arg-names (widget mode)
     :arguments ((* GtkWidget) GdkExtensionMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:552 <1448> 
;; GdkExtensionMode gtk_widget_get_extension_events( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_extension_events
     :unconverted-entry-name "gtk_widget_get_extension_events"
     :c-return-type ("GdkExtensionMode")
     :return-type GdkExtensionMode
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:553 <1449> 
;; GtkWidget* gtk_widget_get_toplevel( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_toplevel
     :unconverted-entry-name "gtk_widget_get_toplevel"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:554 <1450> 
;; GtkWidget* gtk_widget_get_ancestor( GtkWidget* widget, GtkType
;;   widget_type
;;   );
(ff:bind-c-function gtk_widget_get_ancestor
     :unconverted-entry-name "gtk_widget_get_ancestor"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkWidget" "*") ("GtkType"))
     :c-arg-names (widget widget_type)
     :arguments ((* GtkWidget) GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:556 <1451> 
;; GdkColormap* gtk_widget_get_colormap( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_colormap
     :unconverted-entry-name "gtk_widget_get_colormap"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:557 <1452> 
;; GdkVisual* gtk_widget_get_visual( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_visual
     :unconverted-entry-name "gtk_widget_get_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:565 <1453> 
;; void gtk_widget_set_colormap( GtkWidget* widget, GdkColormap* colormap);
(ff:bind-c-function gtk_widget_set_colormap
     :unconverted-entry-name "gtk_widget_set_colormap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GdkColormap" "*"))
     :c-arg-names (widget colormap)
     :arguments ((* GtkWidget) (* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:567 <1454> 
;; void gtk_widget_set_visual( GtkWidget* widget, GdkVisual* visual);
(ff:bind-c-function gtk_widget_set_visual
     :unconverted-entry-name "gtk_widget_set_visual"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GdkVisual" "*"))
     :c-arg-names (widget visual)
     :arguments ((* GtkWidget) (* GdkVisual))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:571 <1455> 
;; gint gtk_widget_get_events( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_events
     :unconverted-entry-name "gtk_widget_get_events"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:572 <1456> 
;; void gtk_widget_get_pointer( GtkWidget* widget, gint* x, gint* y);
(ff:bind-c-function gtk_widget_get_pointer
     :unconverted-entry-name "gtk_widget_get_pointer"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (widget x y)
     :arguments ((* GtkWidget) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:576 <1457> 
;; gboolean gtk_widget_is_ancestor( GtkWidget* widget, GtkWidget*
;;   ancestor);
(ff:bind-c-function gtk_widget_is_ancestor
     :unconverted-entry-name "gtk_widget_is_ancestor"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkWidget" "*") ("GtkWidget" "*"))
     :c-arg-names (widget ancestor)
     :arguments ((* GtkWidget) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:581 <1458> 
;; gint gtk_widget_hide_on_delete( GtkWidget* widget);
(ff:bind-c-function gtk_widget_hide_on_delete
     :unconverted-entry-name "gtk_widget_hide_on_delete"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:585 <1459> 
;; void gtk_widget_set_style( GtkWidget* widget, GtkStyle* style);
(ff:bind-c-function gtk_widget_set_style
     :unconverted-entry-name "gtk_widget_set_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkStyle" "*"))
     :c-arg-names (widget style)
     :arguments ((* GtkWidget) (* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:587 <1460> 
;; void gtk_widget_set_rc_style( GtkWidget* widget);
(ff:bind-c-function gtk_widget_set_rc_style
     :unconverted-entry-name "gtk_widget_set_rc_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:588 <1461> 
;; void gtk_widget_ensure_style( GtkWidget* widget);
(ff:bind-c-function gtk_widget_ensure_style
     :unconverted-entry-name "gtk_widget_ensure_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:589 <1462> 
;; GtkStyle* gtk_widget_get_style( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_style
     :unconverted-entry-name "gtk_widget_get_style"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:590 <1463> 
;; void gtk_widget_restore_default_style( GtkWidget* widget);
(ff:bind-c-function gtk_widget_restore_default_style
     :unconverted-entry-name "gtk_widget_restore_default_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:592 <1464> 
;; void gtk_widget_modify_style( GtkWidget* widget, GtkRcStyle* style);
(ff:bind-c-function gtk_widget_modify_style
     :unconverted-entry-name "gtk_widget_modify_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GtkRcStyle" "*"))
     :c-arg-names (widget style)
     :arguments ((* GtkWidget) (* GtkRcStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:598 <1465> 
;; void gtk_widget_set_composite_name( GtkWidget* widget, const gchar* name
;;   );
(ff:bind-c-function gtk_widget_set_composite_name
     :unconverted-entry-name "gtk_widget_set_composite_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("const" "gchar" "*"))
     :c-arg-names (widget name)
     :arguments ((* GtkWidget) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:600 <1466> 
;; gchar* gtk_widget_get_composite_name( GtkWidget* widget);
(ff:bind-c-function gtk_widget_get_composite_name
     :unconverted-entry-name "gtk_widget_get_composite_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:603 <1467> 
;; void gtk_widget_reset_rc_styles( GtkWidget* widget);
(ff:bind-c-function gtk_widget_reset_rc_styles
     :unconverted-entry-name "gtk_widget_reset_rc_styles"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:609 <1468> 
;; void gtk_widget_push_style( GtkStyle* style);
(ff:bind-c-function gtk_widget_push_style
     :unconverted-entry-name "gtk_widget_push_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*"))
     :c-arg-names (style)
     :arguments ((* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:610 <1469> 
;; void gtk_widget_push_colormap( GdkColormap* cmap);
(ff:bind-c-function gtk_widget_push_colormap
     :unconverted-entry-name "gtk_widget_push_colormap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (cmap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:611 <1470> 
;; void gtk_widget_push_visual( GdkVisual* visual);
(ff:bind-c-function gtk_widget_push_visual
     :unconverted-entry-name "gtk_widget_push_visual"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkVisual" "*"))
     :c-arg-names (visual)
     :arguments ((* GdkVisual))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:612 <1471> 
;; void gtk_widget_push_composite_child( void);
(ff:bind-c-function gtk_widget_push_composite_child
     :unconverted-entry-name "gtk_widget_push_composite_child"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:613 <1472> 
;; void gtk_widget_pop_composite_child( void);
(ff:bind-c-function gtk_widget_pop_composite_child
     :unconverted-entry-name "gtk_widget_pop_composite_child"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:614 <1473> 
;; void gtk_widget_pop_style( void);
(ff:bind-c-function gtk_widget_pop_style
     :unconverted-entry-name "gtk_widget_pop_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:615 <1474> 
;; void gtk_widget_pop_colormap( void);
(ff:bind-c-function gtk_widget_pop_colormap
     :unconverted-entry-name "gtk_widget_pop_colormap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:616 <1475> 
;; void gtk_widget_pop_visual( void);
(ff:bind-c-function gtk_widget_pop_visual
     :unconverted-entry-name "gtk_widget_pop_visual"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:620 <1476> 
;; void gtk_widget_set_default_style( GtkStyle* style);
(ff:bind-c-function gtk_widget_set_default_style
     :unconverted-entry-name "gtk_widget_set_default_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkStyle" "*"))
     :c-arg-names (style)
     :arguments ((* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:621 <1477> 
;; void gtk_widget_set_default_colormap( GdkColormap* colormap);
(ff:bind-c-function gtk_widget_set_default_colormap
     :unconverted-entry-name "gtk_widget_set_default_colormap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkColormap" "*"))
     :c-arg-names (colormap)
     :arguments ((* GdkColormap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:622 <1478> 
;; void gtk_widget_set_default_visual( GdkVisual* visual);
(ff:bind-c-function gtk_widget_set_default_visual
     :unconverted-entry-name "gtk_widget_set_default_visual"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GdkVisual" "*"))
     :c-arg-names (visual)
     :arguments ((* GdkVisual))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:623 <1479> 
;; GtkStyle* gtk_widget_get_default_style( void);
(ff:bind-c-function gtk_widget_get_default_style
     :unconverted-entry-name "gtk_widget_get_default_style"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:624 <1480> 
;; GdkColormap* gtk_widget_get_default_colormap( void);
(ff:bind-c-function gtk_widget_get_default_colormap
     :unconverted-entry-name "gtk_widget_get_default_colormap"
     :c-return-type ("GdkColormap" "*")
     :return-type (* GdkColormap)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:625 <1481> 
;; GdkVisual* gtk_widget_get_default_visual( void);
(ff:bind-c-function gtk_widget_get_default_visual
     :unconverted-entry-name "gtk_widget_get_default_visual"
     :c-return-type ("GdkVisual" "*")
     :return-type (* GdkVisual)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:629 <1482> 
;; void gtk_widget_shape_combine_mask( GtkWidget* widget, GdkBitmap*
;;   shape_mask,
;;              gint offset_x, gint offset_y);
(ff:bind-c-function gtk_widget_shape_combine_mask
     :unconverted-entry-name "gtk_widget_shape_combine_mask"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("GdkBitmap" "*") ("gint") ("gint"))
     :c-arg-names (widget shape_mask offset_x offset_y)
     :arguments ((* GtkWidget) (* GdkBitmap) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:635 <1483> 
;; void gtk_widget_reset_shapes( GtkWidget* widget);
(ff:bind-c-function gtk_widget_reset_shapes
     :unconverted-entry-name "gtk_widget_reset_shapes"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:640 <1484> 
;; void gtk_widget_path( GtkWidget* widget, guint* path_length, gchar**
;;   path,
;;              gchar** path_reversed);
(ff:bind-c-function gtk_widget_path
     :unconverted-entry-name "gtk_widget_path"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("guint" "*") ("gchar" "*" "*")
                   ("gchar" "*" "*"))
     :c-arg-names (widget path_length path path_reversed)
     :arguments ((* GtkWidget) (* guint) (* (* gchar)) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwidget.h:644 <1485> 
;; void gtk_widget_class_path( GtkWidget* widget, guint* path_length, gchar
;;   ** path, gchar** path_reversed);
(ff:bind-c-function gtk_widget_class_path
     :unconverted-entry-name "gtk_widget_class_path"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("guint" "*") ("gchar" "*" "*")
                   ("gchar" "*" "*"))
     :c-arg-names (widget path_length path path_reversed)
     :arguments ((* GtkWidget) (* guint) (* (* gchar)) (* (* gchar)))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmisc.h:47 <1486> 
;; typedef struct _GtkMisc GtkMisc;
(ff:bind-c-typedef _GtkMisc ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkMisc _GtkMisc)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmisc.h:48 <1487> 
;; typedef struct _GtkMiscClass GtkMiscClass;
(ff:bind-c-typedef _GtkMiscClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkMiscClass _GtkMiscClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmisc.h:50 <1488> 
;; struct _GtkMisc {
;;         GtkWidget widget; gfloat xalign; gfloat yalign; guint16 xpad;
;;   guint16
;;    ypad; };
(ff:bind-c-type _GtkMisc (:struct
  (widget GtkWidget)   ;; GtkWidget widget
  (xalign gfloat)   ;; gfloat xalign
  (yalign gfloat)   ;; gfloat yalign
  (xpad guint16)   ;; guint16 xpad
  (ypad guint16)   ;; guint16 ypad
  ))   ;; bind-c-type _GtkMisc

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmisc.h:61 <1489> 
;; struct _GtkMiscClass { GtkWidgetClass parent_class; };
(ff:bind-c-type _GtkMiscClass (:struct
  (parent_class GtkWidgetClass)   ;; GtkWidgetClass parent_class
  ))   ;; bind-c-type _GtkMiscClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmisc.h:67 <1490> 
;; GtkType gtk_misc_get_type( void);
(ff:bind-c-function gtk_misc_get_type
     :unconverted-entry-name "gtk_misc_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmisc.h:68 <1491> 
;; void gtk_misc_set_alignment( GtkMisc* misc, gfloat xalign, gfloat yalign
;;   );
(ff:bind-c-function gtk_misc_set_alignment
     :unconverted-entry-name "gtk_misc_set_alignment"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMisc" "*") ("gfloat") ("gfloat"))
     :c-arg-names (misc xalign yalign)
     :arguments ((* GtkMisc) gfloat gfloat)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmisc.h:71 <1492> 
;; void gtk_misc_set_padding( GtkMisc* misc, gint xpad, gint ypad);
(ff:bind-c-function gtk_misc_set_padding
     :unconverted-entry-name "gtk_misc_set_padding"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMisc" "*") ("gint") ("gint"))
     :c-arg-names (misc xpad ypad)
     :arguments ((* GtkMisc) gint gint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:46 <1493> 
;; typedef struct _GtkLabel GtkLabel;
(ff:bind-c-typedef _GtkLabel ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkLabel _GtkLabel)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:47 <1494> 
;; typedef struct _GtkLabelClass GtkLabelClass;
(ff:bind-c-typedef _GtkLabelClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkLabelClass _GtkLabelClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:49 <1495> 
;; typedef struct _GtkLabelWord GtkLabelWord;
(ff:bind-c-typedef _GtkLabelWord
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkLabelWord _GtkLabelWord)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:51 <1496> 
;; struct _GtkLabel {
;;         GtkMisc misc; gchar* label; GdkWChar* label_wc; gchar* pattern;
;;   GtkLabelWord
;;   * words; guint max_width:  0x000000010; guint jtype:  0x000000002;
;;   gboolean
;;    wrap; };

;;WARNING: Strange bitfield max_width type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield jtype type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkLabel (:struct
  (misc GtkMisc)   ;; GtkMisc misc
  (label (* gchar))   ;; gchar* label
  (label_wc (* GdkWChar))   ;; GdkWChar* label_wc
  (pattern (* gchar))   ;; gchar* pattern
  (words (* GtkLabelWord))   ;; GtkLabelWord* words
  (max_width (:bit 16))   ;; guint max_width:  0x000000010
  (jtype (:bit 2))   ;; guint jtype:  0x000000002
  (wrap gboolean)   ;; gboolean wrap
  ))   ;; bind-c-type _GtkLabel

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:66 <1497> 
;; struct _GtkLabelClass { GtkMiscClass parent_class; };
(ff:bind-c-type _GtkLabelClass (:struct
  (parent_class GtkMiscClass)   ;; GtkMiscClass parent_class
  ))   ;; bind-c-type _GtkLabelClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:72 <1498> 
;; GtkType gtk_label_get_type( void);
(ff:bind-c-function gtk_label_get_type
     :unconverted-entry-name "gtk_label_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:73 <1499> 
;; GtkWidget* gtk_label_new( const gchar* str);
(ff:bind-c-function gtk_label_new
     :unconverted-entry-name "gtk_label_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (str)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:74 <1500> 
;; void gtk_label_set_text( GtkLabel* label, const gchar* str);
(ff:bind-c-function gtk_label_set_text
     :all-names ((gtk_label_set . "gtk_label_set")
                 (gtk_label_set_text . "gtk_label_set_text"))
     :unconverted-entry-name "gtk_label_set_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkLabel" "*") ("const" "gchar" "*"))
     :c-arg-names (label str)
     :arguments ((* GtkLabel) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:76 <1501> 
;; void gtk_label_set_justify( GtkLabel* label, GtkJustification jtype);
(ff:bind-c-function gtk_label_set_justify
     :unconverted-entry-name "gtk_label_set_justify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkLabel" "*") ("GtkJustification"))
     :c-arg-names (label jtype)
     :arguments ((* GtkLabel) GtkJustification)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:78 <1502> 
;; void gtk_label_set_pattern( GtkLabel* label, const gchar* pattern);
(ff:bind-c-function gtk_label_set_pattern
     :unconverted-entry-name "gtk_label_set_pattern"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkLabel" "*") ("const" "gchar" "*"))
     :c-arg-names (label pattern)
     :arguments ((* GtkLabel) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:80 <1503> 
;; void gtk_label_set_line_wrap( GtkLabel* label, gboolean wrap);
(ff:bind-c-function gtk_label_set_line_wrap
     :unconverted-entry-name "gtk_label_set_line_wrap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkLabel" "*") ("gboolean"))
     :c-arg-names (label wrap)
     :arguments ((* GtkLabel) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:82 <1504> 
;; void gtk_label_get( GtkLabel* label, gchar** str);
(ff:bind-c-function gtk_label_get
     :unconverted-entry-name "gtk_label_get"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkLabel" "*") ("gchar" "*" "*"))
     :c-arg-names (label str)
     :arguments ((* GtkLabel) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtklabel.h:89 <1505> 
;; guint gtk_label_parse_uline( GtkLabel* label, const gchar* string);
(ff:bind-c-function gtk_label_parse_uline
     :unconverted-entry-name "gtk_label_parse_uline"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkLabel" "*") ("const" "gchar" "*"))
     :c-arg-names (label string)
     :arguments ((* GtkLabel) (* gchar))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:49 <1506> 
;; typedef struct _GtkAccelLabel GtkAccelLabel;
(ff:bind-c-typedef _GtkAccelLabel
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAccelLabel _GtkAccelLabel)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:50 <1507> 
;; typedef struct _GtkAccelLabelClass GtkAccelLabelClass;
(ff:bind-c-typedef _GtkAccelLabelClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAccelLabelClass _GtkAccelLabelClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:52 <1508> 
;; struct _GtkAccelLabel {
;;         GtkLabel label; guint queue_id; guint accel_padding; GtkWidget*
;;   accel_widget;
;;              gchar* accel_string; guint16 accel_string_width; };
(ff:bind-c-type _GtkAccelLabel (:struct
  (label GtkLabel)   ;; GtkLabel label
  (queue_id guint)   ;; guint queue_id
  (accel_padding guint)   ;; guint accel_padding
  (accel_widget (* GtkWidget))   ;; GtkWidget* accel_widget
  (accel_string (* gchar))   ;; gchar* accel_string
  (accel_string_width guint16)   ;; guint16 accel_string_width
  ))   ;; bind-c-type _GtkAccelLabel

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:63 <1509> 
;; struct _GtkAccelLabelClass {
;;         GtkLabelClass parent_class; gchar* signal_quote1; gchar*
;;   signal_quote2;
;;              gchar* mod_name_shift; gchar* mod_name_control; gchar*
;;   mod_name_alt; gchar
;;   * mod_separator; gchar* accel_seperator; guint latin1_to_char:
;;   0x000000001;
;;    };

;;WARNING: Strange bitfield latin1_to_char type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkAccelLabelClass (:struct
  (parent_class GtkLabelClass)   ;; GtkLabelClass parent_class
  (signal_quote1 (* gchar))   ;; gchar* signal_quote1
  (signal_quote2 (* gchar))   ;; gchar* signal_quote2
  (mod_name_shift (* gchar))   ;; gchar* mod_name_shift
  (mod_name_control (* gchar))   ;; gchar* mod_name_control
  (mod_name_alt (* gchar))   ;; gchar* mod_name_alt
  (mod_separator (* gchar))   ;; gchar* mod_separator
  (accel_seperator (* gchar))   ;; gchar* accel_seperator
  (latin1_to_char (:bit 1))   ;; guint latin1_to_char:  0x000000001
  ))   ;; bind-c-type _GtkAccelLabelClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:78 <1510> 
;; GtkType gtk_accel_label_get_type( void);
(ff:bind-c-function gtk_accel_label_get_type
     :unconverted-entry-name "gtk_accel_label_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:79 <1511> 
;; GtkWidget* gtk_accel_label_new( const gchar* string);
(ff:bind-c-function gtk_accel_label_new
     :unconverted-entry-name "gtk_accel_label_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (string)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:80 <1512> 
;; guint gtk_accel_label_get_accel_width( GtkAccelLabel* accel_label);
(ff:bind-c-function gtk_accel_label_get_accel_width
     :all-names ((gtk_accel_label_get_accel_width
                  . "gtk_accel_label_get_accel_width")
                 (gtk_accel_label_accelerator_width
                  . "gtk_accel_label_accelerator_width"))
     :unconverted-entry-name "gtk_accel_label_get_accel_width"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkAccelLabel" "*"))
     :c-arg-names (accel_label)
     :arguments ((* GtkAccelLabel))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:81 <1513> 
;; void gtk_accel_label_set_accel_widget( GtkAccelLabel* accel_label,
;;   GtkWidget
;;   * accel_widget);
(ff:bind-c-function gtk_accel_label_set_accel_widget
     :unconverted-entry-name "gtk_accel_label_set_accel_widget"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAccelLabel" "*") ("GtkWidget" "*"))
     :c-arg-names (accel_label accel_widget)
     :arguments ((* GtkAccelLabel) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaccellabel.h:83 <1514> 
;; gboolean gtk_accel_label_refetch( GtkAccelLabel* accel_label);
(ff:bind-c-function gtk_accel_label_refetch
     :unconverted-entry-name "gtk_accel_label_refetch"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkAccelLabel" "*"))
     :c-arg-names (accel_label)
     :arguments ((* GtkAccelLabel))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:51 <1515> 
;; typedef struct _GtkContainer GtkContainer;
(ff:bind-c-typedef _GtkContainer
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkContainer _GtkContainer)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:52 <1516> 
;; typedef struct _GtkContainerClass GtkContainerClass;
(ff:bind-c-typedef _GtkContainerClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkContainerClass _GtkContainerClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:54 <1517> 
;; struct _GtkContainer {
;;         GtkWidget widget; GtkWidget* focus_child; guint border_width:
;;   0x000000010;
;;              guint need_resize:  0x000000001; guint resize_mode:
;;   0x000000002; guint
;;    reallocate_redraws:  0x000000001; GSList* resize_widgets; };

;;WARNING: Strange bitfield border_width type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield need_resize type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield resize_mode type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield reallocate_redraws type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkContainer (:struct
  (widget GtkWidget)   ;; GtkWidget widget
  (focus_child (* GtkWidget))   ;; GtkWidget* focus_child
  (border_width (:bit 16))   ;; guint border_width:  0x000000010
  (need_resize (:bit 1))   ;; guint need_resize:  0x000000001
  (resize_mode (:bit 2))   ;; guint resize_mode:  0x000000002
  (reallocate_redraws (:bit 1))   ;; guint reallocate_redraws:  0x000000001
  (resize_widgets (* GSList))   ;; GSList* resize_widgets
  ))   ;; bind-c-type _GtkContainer

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:70 <1518> 
;; struct _GtkContainerClass {
;;         GtkWidgetClass parent_class; guint n_child_args; void(* add)(
;;   GtkContainer
;;   * container, GtkWidget* widget); void(* remove)( GtkContainer*
;;   container,
;;              GtkWidget* widget); void(* check_resize)( GtkContainer*
;;   container); void
;;   (* forall)( GtkContainer* container, gboolean include_internals,
;;   GtkCallback
;;    callback, gpointer callbabck_data); gint(* focus)( GtkContainer*
;;   container,
;;              GtkDirectionType direction); void(* set_focus_child)(
;;   GtkContainer* container,
;;              GtkWidget* widget); GtkType(* child_type)( GtkContainer*
;;   container); void
;;   (* set_child_arg)( GtkContainer* container, GtkWidget* child, GtkArg*
;;   arg,
;;              guint arg_id); void(* get_child_arg)( GtkContainer*
;;   container, GtkWidget
;;   * child, GtkArg* arg, guint arg_id); gchar*(* composite_name)(
;;   GtkContainer
;;   * container, GtkWidget* child); GtkFunction pad1; GtkFunction pad2; };
(ff:bind-c-type _GtkContainerClass (:struct
  (parent_class GtkWidgetClass)   ;; GtkWidgetClass parent_class
  (n_child_args guint)   ;; guint n_child_args
  (add ff:function-pointer)   ;;
  ;;  void(* add)( GtkContainer* container, GtkWidget* widget)
  (remove ff:function-pointer)   ;;
  ;;  void(* remove)( GtkContainer* container, GtkWidget* widget)
  (check_resize ff:function-pointer)   ;;
  ;;  void(* check_resize)( GtkContainer* container)
  (forall ff:function-pointer)   ;;
  ;;  void(* forall)( GtkContainer* container, gboolean include_internals, GtkCallback
  ;;  callback, gpointer callbabck_data)
  (focus ff:function-pointer)   ;;
  ;;  gint(* focus)( GtkContainer* container, GtkDirectionType direction)
  (set_focus_child ff:function-pointer)   ;;
  ;;  void(* set_focus_child)( GtkContainer* container, GtkWidget* widget)
  (child_type ff:function-pointer)   ;;
  ;;  GtkType(* child_type)( GtkContainer* container)
  (set_child_arg ff:function-pointer)   ;;
  ;;  void(* set_child_arg)( GtkContainer* container, GtkWidget* child, GtkArg* arg,
  ;;            guint arg_id)
  (get_child_arg ff:function-pointer)   ;;
  ;;  void(* get_child_arg)( GtkContainer* container, GtkWidget* child, GtkArg* arg,
  ;;            guint arg_id)
  (composite_name ff:function-pointer)   ;;
  ;;  gchar*(* composite_name)( GtkContainer* container, GtkWidget* child)
  (pad1 GtkFunction)   ;; GtkFunction pad1
  (pad2 GtkFunction)   ;; GtkFunction pad2
  ))   ;; bind-c-type _GtkContainerClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:108 <1519> 
;; GtkType gtk_container_get_type( void);
(ff:bind-c-function gtk_container_get_type
     :unconverted-entry-name "gtk_container_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:109 <1520> 
;; void gtk_container_set_border_width( GtkContainer* container, guint
;;   border_width
;;   );
(ff:bind-c-function gtk_container_set_border_width
     :all-names ((gtk_container_border_width . "gtk_container_border_width")
                 (gtk_container_set_border_width
                  . "gtk_container_set_border_width"))
     :unconverted-entry-name "gtk_container_set_border_width"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("guint"))
     :c-arg-names (container border_width)
     :arguments ((* GtkContainer) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:111 <1521> 
;; void gtk_container_add( GtkContainer* container, GtkWidget* widget);
(ff:bind-c-function gtk_container_add
     :unconverted-entry-name "gtk_container_add"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*"))
     :c-arg-names (container widget)
     :arguments ((* GtkContainer) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:113 <1522> 
;; void gtk_container_remove( GtkContainer* container, GtkWidget* widget);
(ff:bind-c-function gtk_container_remove
     :unconverted-entry-name "gtk_container_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*"))
     :c-arg-names (container widget)
     :arguments ((* GtkContainer) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:116 <1523> 
;; void gtk_container_set_resize_mode( GtkContainer* container,
;;   GtkResizeMode
;;    resize_mode);
(ff:bind-c-function gtk_container_set_resize_mode
     :unconverted-entry-name "gtk_container_set_resize_mode"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkResizeMode"))
     :c-arg-names (container resize_mode)
     :arguments ((* GtkContainer) GtkResizeMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:119 <1524> 
;; void gtk_container_check_resize( GtkContainer* container);
(ff:bind-c-function gtk_container_check_resize
     :unconverted-entry-name "gtk_container_check_resize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:121 <1525> 
;; void gtk_container_foreach( GtkContainer* container, GtkCallback
;;   callback,
;;              gpointer callback_data);
(ff:bind-c-function gtk_container_foreach
     :unconverted-entry-name "gtk_container_foreach"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkCallback") ("gpointer"))
     :c-arg-names (container callback callback_data)
     :arguments ((* GtkContainer) GtkCallback gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:124 <1526> 
;; void gtk_container_foreach_full( GtkContainer* container, GtkCallback
;;    callback, GtkCallbackMarshal marshal, gpointer callback_data,
;;   GtkDestroyNotify
;;    notify);
(ff:bind-c-function gtk_container_foreach_full
     :unconverted-entry-name "gtk_container_foreach_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkCallback") ("GtkCallbackMarshal")
                   ("gpointer") ("GtkDestroyNotify"))
     :c-arg-names (container callback marshal callback_data notify)
     :arguments ((* GtkContainer) GtkCallback GtkCallbackMarshal gpointer
                 GtkDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:129 <1527> 
;; GList* gtk_container_children( GtkContainer* container);
(ff:bind-c-function gtk_container_children
     :unconverted-entry-name "gtk_container_children"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:130 <1528> 
;; gint gtk_container_focus( GtkContainer* container, GtkDirectionType
;;   direction
;;   );
(ff:bind-c-function gtk_container_focus
     :unconverted-entry-name "gtk_container_focus"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkContainer" "*") ("GtkDirectionType"))
     :c-arg-names (container direction)
     :arguments ((* GtkContainer) GtkDirectionType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:135 <1529> 
;; void gtk_container_set_reallocate_redraws( GtkContainer* container,
;;   gboolean
;;    needs_redraws);
(ff:bind-c-function gtk_container_set_reallocate_redraws
     :unconverted-entry-name "gtk_container_set_reallocate_redraws"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("gboolean"))
     :c-arg-names (container needs_redraws)
     :arguments ((* GtkContainer) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:137 <1530> 
;; void gtk_container_set_focus_child( GtkContainer* container, GtkWidget
;;   * child);
(ff:bind-c-function gtk_container_set_focus_child
     :unconverted-entry-name "gtk_container_set_focus_child"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*"))
     :c-arg-names (container child)
     :arguments ((* GtkContainer) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:139 <1531> 
;; void gtk_container_set_focus_vadjustment( GtkContainer* container,
;;   GtkAdjustment
;;   * adjustment);
(ff:bind-c-function gtk_container_set_focus_vadjustment
     :unconverted-entry-name "gtk_container_set_focus_vadjustment"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkAdjustment" "*"))
     :c-arg-names (container adjustment)
     :arguments ((* GtkContainer) (* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:141 <1532> 
;; void gtk_container_set_focus_hadjustment( GtkContainer* container,
;;   GtkAdjustment
;;   * adjustment);
(ff:bind-c-function gtk_container_set_focus_hadjustment
     :unconverted-entry-name "gtk_container_set_focus_hadjustment"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkAdjustment" "*"))
     :c-arg-names (container adjustment)
     :arguments ((* GtkContainer) (* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:143 <1533> 
;; void gtk_container_register_toplevel( GtkContainer* container);
(ff:bind-c-function gtk_container_register_toplevel
     :unconverted-entry-name "gtk_container_register_toplevel"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:144 <1534> 
;; void gtk_container_unregister_toplevel( GtkContainer* container);
(ff:bind-c-function gtk_container_unregister_toplevel
     :unconverted-entry-name "gtk_container_unregister_toplevel"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:145 <1535> 
;; GList* gtk_container_get_toplevels( void);
(ff:bind-c-function gtk_container_get_toplevels
     :unconverted-entry-name "gtk_container_get_toplevels"
     :c-return-type ("GList" "*")
     :return-type (* GList)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:147 <1536> 
;; void gtk_container_resize_children( GtkContainer* container);
(ff:bind-c-function gtk_container_resize_children
     :unconverted-entry-name "gtk_container_resize_children"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:149 <1537> 
;; GtkType gtk_container_child_type( GtkContainer* container);
(ff:bind-c-function gtk_container_child_type
     :unconverted-entry-name "gtk_container_child_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:152 <1538> 
;; void gtk_container_add_child_arg_type( const gchar* arg_name, GtkType
;;    arg_type, guint arg_flags, guint arg_id);
(ff:bind-c-function gtk_container_add_child_arg_type
     :unconverted-entry-name "gtk_container_add_child_arg_type"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("const" "gchar" "*") ("GtkType") ("guint") ("guint"))
     :c-arg-names (arg_name arg_type arg_flags arg_id)
     :arguments ((* gchar) GtkType guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:166 <1539> 
;; GtkArg* gtk_container_query_child_args( GtkType class_type, guint32**
;;    arg_flags, guint* nargs);
(ff:bind-c-function gtk_container_query_child_args
     :unconverted-entry-name "gtk_container_query_child_args"
     :c-return-type ("GtkArg" "*")
     :return-type (* GtkArg)
     :c-arg-types (("GtkType") ("guint32" "*" "*") ("guint" "*"))
     :c-arg-names (class_type arg_flags nargs)
     :arguments (GtkType (* (* guint32)) (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:175 <1540> 
;; void gtk_container_child_getv( GtkContainer* container, GtkWidget*
;;   child,
;;              guint n_args, GtkArg* args);
(ff:bind-c-function gtk_container_child_getv
     :unconverted-entry-name "gtk_container_child_getv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*") ("guint")
                   ("GtkArg" "*"))
     :c-arg-names (container child n_args args)
     :arguments ((* GtkContainer) (* GtkWidget) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:179 <1541> 
;; void gtk_container_child_setv( GtkContainer* container, GtkWidget*
;;   child,
;;              guint n_args, GtkArg* args);
(ff:bind-c-function gtk_container_child_setv
     :unconverted-entry-name "gtk_container_child_setv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*") ("guint")
                   ("GtkArg" "*"))
     :c-arg-names (container child n_args args)
     :arguments ((* GtkContainer) (* GtkWidget) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:189 <1542> 
;; void gtk_container_add_with_args( GtkContainer* container, GtkWidget*
;;    widget, const gchar* first_arg_name, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_container_add_with_args
     :unconverted-entry-name "gtk_container_add_with_args"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*")
                   ("const" "gchar" "*") "...")
     :c-arg-names (container widget first_arg_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:193 <1543> 
;; void gtk_container_addv( GtkContainer* container, GtkWidget* widget,
;;   guint
;;    n_args, GtkArg* args);
(ff:bind-c-function gtk_container_addv
     :unconverted-entry-name "gtk_container_addv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*") ("guint")
                   ("GtkArg" "*"))
     :c-arg-names (container widget n_args args)
     :arguments ((* GtkContainer) (* GtkWidget) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:197 <1544> 
;; void gtk_container_child_set( GtkContainer* container, GtkWidget* child,
;;              const gchar* first_arg_name, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_container_child_set
     :unconverted-entry-name "gtk_container_child_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*")
                   ("const" "gchar" "*") "...")
     :c-arg-names (container child first_arg_name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:205 <1545> 
;; void gtk_container_queue_resize( GtkContainer* container);
(ff:bind-c-function gtk_container_queue_resize
     :unconverted-entry-name "gtk_container_queue_resize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:206 <1546> 
;; void gtk_container_clear_resize_widgets( GtkContainer* container);
(ff:bind-c-function gtk_container_clear_resize_widgets
     :unconverted-entry-name "gtk_container_clear_resize_widgets"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:207 <1547> 
;; void gtk_container_arg_set( GtkContainer* container, GtkWidget* child,
;;              GtkArg* arg, GtkArgInfo* info);
(ff:bind-c-function gtk_container_arg_set
     :unconverted-entry-name "gtk_container_arg_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*") ("GtkArg" "*")
                   ("GtkArgInfo" "*"))
     :c-arg-names (container child arg info)
     :arguments ((* GtkContainer) (* GtkWidget) (* GtkArg) (* GtkArgInfo))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:211 <1548> 
;; void gtk_container_arg_get( GtkContainer* container, GtkWidget* child,
;;              GtkArg* arg, GtkArgInfo* info);
(ff:bind-c-function gtk_container_arg_get
     :unconverted-entry-name "gtk_container_arg_get"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*") ("GtkArg" "*")
                   ("GtkArgInfo" "*"))
     :c-arg-names (container child arg info)
     :arguments ((* GtkContainer) (* GtkWidget) (* GtkArg) (* GtkArgInfo))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:215 <1549> 
;; gchar* gtk_container_child_args_collect( GtkType object_type, GSList*
;;   * arg_list_p, GSList** info_list_p, const gchar* first_arg_name,
;;   va_list
;;    args);
(ff:bind-c-function gtk_container_child_args_collect
     :unconverted-entry-name "gtk_container_child_args_collect"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkType") ("GSList" "*" "*") ("GSList" "*" "*")
                   ("const" "gchar" "*") ("va_list"))
     :c-arg-names (object_type arg_list_p info_list_p first_arg_name args)
     :arguments (GtkType (* (* GSList)) (* (* GSList)) (* gchar) va_list)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:220 <1550> 
;; gchar* gtk_container_child_arg_get_info( GtkType object_type, const
;;   gchar
;;   * arg_name, GtkArgInfo** info_p);
(ff:bind-c-function gtk_container_child_arg_get_info
     :unconverted-entry-name "gtk_container_child_arg_get_info"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkType") ("const" "gchar" "*") ("GtkArgInfo" "*" "*"))
     :c-arg-names (object_type arg_name info_p)
     :arguments (GtkType (* gchar) (* (* GtkArgInfo)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:223 <1551> 
;; void gtk_container_forall( GtkContainer* container, GtkCallback
;;   callback,
;;              gpointer callback_data);
(ff:bind-c-function gtk_container_forall
     :unconverted-entry-name "gtk_container_forall"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*") ("GtkCallback") ("gpointer"))
     :c-arg-names (container callback callback_data)
     :arguments ((* GtkContainer) GtkCallback gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:226 <1552> 
;; gchar* gtk_container_child_composite_name( GtkContainer* container,
;;   GtkWidget
;;   * child);
(ff:bind-c-function gtk_container_child_composite_name
     :unconverted-entry-name "gtk_container_child_composite_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkContainer" "*") ("GtkWidget" "*"))
     :c-arg-names (container child)
     :arguments ((* GtkContainer) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcontainer.h:228 <1553> 
;; void gtk_container_dequeue_resize_handler( GtkContainer* container);
(ff:bind-c-function gtk_container_dequeue_resize_handler
     :unconverted-entry-name "gtk_container_dequeue_resize_handler"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkContainer" "*"))
     :c-arg-names (container)
     :arguments ((* GtkContainer))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbin.h:47 <1554> 
;; typedef struct _GtkBin GtkBin;
(ff:bind-c-typedef _GtkBin ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBin _GtkBin)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbin.h:48 <1555> 
;; typedef struct _GtkBinClass GtkBinClass;
(ff:bind-c-typedef _GtkBinClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBinClass _GtkBinClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbin.h:50 <1556> 
;; struct _GtkBin { GtkContainer container; GtkWidget* child; };
(ff:bind-c-type _GtkBin (:struct
  (container GtkContainer)   ;; GtkContainer container
  (child (* GtkWidget))   ;; GtkWidget* child
  ))   ;; bind-c-type _GtkBin

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbin.h:57 <1557> 
;; struct _GtkBinClass { GtkContainerClass parent_class; };
(ff:bind-c-type _GtkBinClass (:struct
  (parent_class GtkContainerClass)   ;; GtkContainerClass parent_class
  ))   ;; bind-c-type _GtkBinClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbin.h:63 <1558> 
;; GtkType gtk_bin_get_type( void);
(ff:bind-c-function gtk_bin_get_type
     :unconverted-entry-name "gtk_bin_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkalignment.h:47 <1559> 
;; typedef struct _GtkAlignment GtkAlignment;
(ff:bind-c-typedef _GtkAlignment
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAlignment _GtkAlignment)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkalignment.h:48 <1560> 
;; typedef struct _GtkAlignmentClass GtkAlignmentClass;
(ff:bind-c-typedef _GtkAlignmentClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAlignmentClass _GtkAlignmentClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkalignment.h:50 <1561> 
;; struct _GtkAlignment {
;;         GtkBin bin; gfloat xalign; gfloat yalign; gfloat xscale; gfloat
;;   yscale;
;;    };
(ff:bind-c-type _GtkAlignment (:struct
  (bin GtkBin)   ;; GtkBin bin
  (xalign gfloat)   ;; gfloat xalign
  (yalign gfloat)   ;; gfloat yalign
  (xscale gfloat)   ;; gfloat xscale
  (yscale gfloat)   ;; gfloat yscale
  ))   ;; bind-c-type _GtkAlignment

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkalignment.h:60 <1562> 
;; struct _GtkAlignmentClass { GtkBinClass parent_class; };
(ff:bind-c-type _GtkAlignmentClass (:struct
  (parent_class GtkBinClass)   ;; GtkBinClass parent_class
  ))   ;; bind-c-type _GtkAlignmentClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkalignment.h:66 <1563> 
;; GtkType gtk_alignment_get_type( void);
(ff:bind-c-function gtk_alignment_get_type
     :unconverted-entry-name "gtk_alignment_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkalignment.h:67 <1564> 
;; GtkWidget* gtk_alignment_new( gfloat xalign, gfloat yalign, gfloat
;;   xscale,
;;              gfloat yscale);
(ff:bind-c-function gtk_alignment_new
     :unconverted-entry-name "gtk_alignment_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("gfloat") ("gfloat") ("gfloat") ("gfloat"))
     :c-arg-names (xalign yalign xscale yscale)
     :arguments (gfloat gfloat gfloat gfloat)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkalignment.h:71 <1565> 
;; void gtk_alignment_set( GtkAlignment* alignment, gfloat xalign, gfloat
;;    yalign, gfloat xscale, gfloat yscale);
(ff:bind-c-function gtk_alignment_set
     :unconverted-entry-name "gtk_alignment_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAlignment" "*") ("gfloat") ("gfloat") ("gfloat")
                   ("gfloat"))
     :c-arg-names (alignment xalign yalign xscale yscale)
     :arguments ((* GtkAlignment) gfloat gfloat gfloat gfloat)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:47 <1566> 
;; typedef struct _GtkFrame GtkFrame;
(ff:bind-c-typedef _GtkFrame ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkFrame _GtkFrame)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:48 <1567> 
;; typedef struct _GtkFrameClass GtkFrameClass;
(ff:bind-c-typedef _GtkFrameClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkFrameClass _GtkFrameClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:50 <1568> 
;; struct _GtkFrame {
;;         GtkBin bin; gchar* label; gint16 shadow_type; gint16
;;   label_width; gint16
;;    label_height; gfloat label_xalign; gfloat label_yalign; };
(ff:bind-c-type _GtkFrame (:struct
  (bin GtkBin)   ;; GtkBin bin
  (label (* gchar))   ;; gchar* label
  (shadow_type gint16)   ;; gint16 shadow_type
  (label_width gint16)   ;; gint16 label_width
  (label_height gint16)   ;; gint16 label_height
  (label_xalign gfloat)   ;; gfloat label_xalign
  (label_yalign gfloat)   ;; gfloat label_yalign
  ))   ;; bind-c-type _GtkFrame

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:62 <1569> 
;; struct _GtkFrameClass { GtkBinClass parent_class; };
(ff:bind-c-type _GtkFrameClass (:struct
  (parent_class GtkBinClass)   ;; GtkBinClass parent_class
  ))   ;; bind-c-type _GtkFrameClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:68 <1570> 
;; GtkType gtk_frame_get_type( void);
(ff:bind-c-function gtk_frame_get_type
     :unconverted-entry-name "gtk_frame_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:69 <1571> 
;; GtkWidget* gtk_frame_new( const gchar* label);
(ff:bind-c-function gtk_frame_new
     :unconverted-entry-name "gtk_frame_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (label)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:70 <1572> 
;; void gtk_frame_set_label( GtkFrame* frame, const gchar* label);
(ff:bind-c-function gtk_frame_set_label
     :unconverted-entry-name "gtk_frame_set_label"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkFrame" "*") ("const" "gchar" "*"))
     :c-arg-names (frame label)
     :arguments ((* GtkFrame) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:72 <1573> 
;; void gtk_frame_set_label_align( GtkFrame* frame, gfloat xalign, gfloat
;;    yalign);
(ff:bind-c-function gtk_frame_set_label_align
     :unconverted-entry-name "gtk_frame_set_label_align"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkFrame" "*") ("gfloat") ("gfloat"))
     :c-arg-names (frame xalign yalign)
     :arguments ((* GtkFrame) gfloat gfloat)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkframe.h:75 <1574> 
;; void gtk_frame_set_shadow_type( GtkFrame* frame, GtkShadowType type);
(ff:bind-c-function gtk_frame_set_shadow_type
     :unconverted-entry-name "gtk_frame_set_shadow_type"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkFrame" "*") ("GtkShadowType"))
     :c-arg-names (frame type)
     :arguments ((* GtkFrame) GtkShadowType)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaspectframe.h:48 <1575> 
;; typedef struct _GtkAspectFrame GtkAspectFrame;
(ff:bind-c-typedef _GtkAspectFrame
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAspectFrame _GtkAspectFrame)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaspectframe.h:49 <1576> 
;; typedef struct _GtkAspectFrameClass GtkAspectFrameClass;
(ff:bind-c-typedef _GtkAspectFrameClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkAspectFrameClass _GtkAspectFrameClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaspectframe.h:51 <1577> 
;; struct _GtkAspectFrame {
;;         GtkFrame frame; gfloat xalign; gfloat yalign; gfloat ratio;
;;   gboolean obey_child;
;;              GtkAllocation center_allocation; };
(ff:bind-c-type _GtkAspectFrame (:struct
  (frame GtkFrame)   ;; GtkFrame frame
  (xalign gfloat)   ;; gfloat xalign
  (yalign gfloat)   ;; gfloat yalign
  (ratio gfloat)   ;; gfloat ratio
  (obey_child gboolean)   ;; gboolean obey_child
  (center_allocation GtkAllocation)   ;; GtkAllocation center_allocation
  ))   ;; bind-c-type _GtkAspectFrame

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaspectframe.h:63 <1578> 
;; struct _GtkAspectFrameClass { GtkBinClass parent_class; };
(ff:bind-c-type _GtkAspectFrameClass (:struct
  (parent_class GtkBinClass)   ;; GtkBinClass parent_class
  ))   ;; bind-c-type _GtkAspectFrameClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaspectframe.h:69 <1579> 
;; GtkType gtk_aspect_frame_get_type( void);
(ff:bind-c-function gtk_aspect_frame_get_type
     :unconverted-entry-name "gtk_aspect_frame_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaspectframe.h:70 <1580> 
;; GtkWidget* gtk_aspect_frame_new( const gchar* label, gfloat xalign,
;;   gfloat
;;    yalign, gfloat ratio, gboolean obey_child);
(ff:bind-c-function gtk_aspect_frame_new
     :unconverted-entry-name "gtk_aspect_frame_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*") ("gfloat") ("gfloat") ("gfloat")
                   ("gboolean"))
     :c-arg-names (label xalign yalign ratio obey_child)
     :arguments ((* gchar) gfloat gfloat gfloat gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkaspectframe.h:75 <1581> 
;; void gtk_aspect_frame_set( GtkAspectFrame* aspect_frame, gfloat xalign,
;;              gfloat yalign, gfloat ratio, gboolean obey_child);
(ff:bind-c-function gtk_aspect_frame_set
     :unconverted-entry-name "gtk_aspect_frame_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkAspectFrame" "*") ("gfloat") ("gfloat") ("gfloat")
                   ("gboolean"))
     :c-arg-names (aspect_frame xalign yalign ratio obey_child)
     :arguments ((* GtkAspectFrame) gfloat gfloat gfloat gboolean)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarrow.h:47 <1582> 
;; typedef struct _GtkArrow GtkArrow;
(ff:bind-c-typedef _GtkArrow ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkArrow _GtkArrow)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarrow.h:48 <1583> 
;; typedef struct _GtkArrowClass GtkArrowClass;
(ff:bind-c-typedef _GtkArrowClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkArrowClass _GtkArrowClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarrow.h:50 <1584> 
;; struct _GtkArrow {
;;         GtkMisc misc; gint16 arrow_type; gint16 shadow_type; };
(ff:bind-c-type _GtkArrow (:struct
  (misc GtkMisc)   ;; GtkMisc misc
  (arrow_type gint16)   ;; gint16 arrow_type
  (shadow_type gint16)   ;; gint16 shadow_type
  ))   ;; bind-c-type _GtkArrow

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarrow.h:58 <1585> 
;; struct _GtkArrowClass { GtkMiscClass parent_class; };
(ff:bind-c-type _GtkArrowClass (:struct
  (parent_class GtkMiscClass)   ;; GtkMiscClass parent_class
  ))   ;; bind-c-type _GtkArrowClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarrow.h:64 <1586> 
;; GtkType gtk_arrow_get_type( void);
(ff:bind-c-function gtk_arrow_get_type
     :unconverted-entry-name "gtk_arrow_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarrow.h:65 <1587> 
;; GtkWidget* gtk_arrow_new( GtkArrowType arrow_type, GtkShadowType
;;   shadow_type
;;   );
(ff:bind-c-function gtk_arrow_new
     :unconverted-entry-name "gtk_arrow_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkArrowType") ("GtkShadowType"))
     :c-arg-names (arrow_type shadow_type)
     :arguments (GtkArrowType GtkShadowType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkarrow.h:67 <1588> 
;; void gtk_arrow_set( GtkArrow* arrow, GtkArrowType arrow_type,
;;   GtkShadowType
;;    shadow_type);
(ff:bind-c-function gtk_arrow_set
     :unconverted-entry-name "gtk_arrow_set"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkArrow" "*") ("GtkArrowType") ("GtkShadowType"))
     :c-arg-names (arrow arrow_type shadow_type)
     :arguments ((* GtkArrow) GtkArrowType GtkShadowType)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:46 <1589> 
;; typedef struct _GtkPatternSpec GtkPatternSpec;
(ff:bind-c-typedef _GtkPatternSpec
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkPatternSpec _GtkPatternSpec)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:48 <1590> 
;; struct _GtkPatternSpec {
;;         GtkMatchType match_type; guint pattern_length; gchar* pattern;
;;   gchar*
;;    pattern_reversed; gpointer user_data; guint seq_id; };
(ff:bind-c-type _GtkPatternSpec (:struct
  (match_type GtkMatchType)   ;; GtkMatchType match_type
  (pattern_length guint)   ;; guint pattern_length
  (pattern (* gchar))   ;; gchar* pattern
  (pattern_reversed (* gchar))   ;; gchar* pattern_reversed
  (user_data gpointer)   ;; gpointer user_data
  (seq_id guint)   ;; guint seq_id
  ))   ;; bind-c-type _GtkPatternSpec

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:58 <1591> 
;; void gtk_pattern_spec_init( GtkPatternSpec* pspec, const gchar*
;;   pattern);
(ff:bind-c-function gtk_pattern_spec_init
     :unconverted-entry-name "gtk_pattern_spec_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkPatternSpec" "*") ("const" "gchar" "*"))
     :c-arg-names (pspec pattern)
     :arguments ((* GtkPatternSpec) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:60 <1592> 
;; void gtk_pattern_spec_free_segs( GtkPatternSpec* pspec);
(ff:bind-c-function gtk_pattern_spec_free_segs
     :unconverted-entry-name "gtk_pattern_spec_free_segs"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkPatternSpec" "*"))
     :c-arg-names (pspec)
     :arguments ((* GtkPatternSpec))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:61 <1593> 
;; gboolean gtk_pattern_match( GtkPatternSpec* pspec, guint string_length,
;;              const gchar* string, const gchar* string_reversed);
(ff:bind-c-function gtk_pattern_match
     :unconverted-entry-name "gtk_pattern_match"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkPatternSpec" "*") ("guint") ("const" "gchar" "*")
                   ("const" "gchar" "*"))
     :c-arg-names (pspec string_length string string_reversed)
     :arguments ((* GtkPatternSpec) guint (* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:65 <1594> 
;; gboolean gtk_pattern_match_string( GtkPatternSpec* pspec, const gchar
;;   * string);
(ff:bind-c-function gtk_pattern_match_string
     :unconverted-entry-name "gtk_pattern_match_string"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkPatternSpec" "*") ("const" "gchar" "*"))
     :c-arg-names (pspec string)
     :arguments ((* GtkPatternSpec) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:67 <1595> 
;; gboolean gtk_pattern_match_simple( const gchar* pattern, const gchar*
;;    string);
(ff:bind-c-function gtk_pattern_match_simple
     :unconverted-entry-name "gtk_pattern_match_simple"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("const" "gchar" "*") ("const" "gchar" "*"))
     :c-arg-names (pattern string)
     :arguments ((* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:74 <1596> 
;; typedef struct _GtkBindingSet GtkBindingSet;
(ff:bind-c-typedef _GtkBindingSet
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBindingSet _GtkBindingSet)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:75 <1597> 
;; typedef struct _GtkBindingEntry GtkBindingEntry;
(ff:bind-c-typedef _GtkBindingEntry
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBindingEntry _GtkBindingEntry)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:76 <1598> 
;; typedef struct _GtkBindingSignal GtkBindingSignal;
(ff:bind-c-typedef _GtkBindingSignal
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBindingSignal _GtkBindingSignal)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:77 <1599> 
;; typedef struct _GtkBindingArg GtkBindingArg;
(ff:bind-c-typedef _GtkBindingArg
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBindingArg _GtkBindingArg)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:79 <1600> 
;; struct _GtkBindingSet {
;;         gchar* set_name; gint priority; GSList* widget_path_pspecs;
;;   GSList* widget_class_pspecs;
;;              GSList* class_branch_pspecs; GtkBindingEntry* entries;
;;   GtkBindingEntry
;;   * current; };
(ff:bind-c-type _GtkBindingSet (:struct
  (set_name (* gchar))   ;; gchar* set_name
  (priority gint)   ;; gint priority
  (widget_path_pspecs (* GSList))   ;; GSList* widget_path_pspecs
  (widget_class_pspecs (* GSList))   ;; GSList* widget_class_pspecs
  (class_branch_pspecs (* GSList))   ;; GSList* class_branch_pspecs
  (entries (* GtkBindingEntry))   ;; GtkBindingEntry* entries
  (current (* GtkBindingEntry))   ;; GtkBindingEntry* current
  ))   ;; bind-c-type _GtkBindingSet

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:90 <1601> 
;; struct _GtkBindingEntry {
;;         guint keyval; guint modifiers; GtkBindingSet* binding_set; guint
;;   destroyed
;;   :  0x000000001; guint in_emission:  0x000000001; GtkBindingEntry*
;;   set_next;
;;              GtkBindingEntry* hash_next; GtkBindingSignal* signals; };

;;WARNING: Strange bitfield destroyed type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield in_emission type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkBindingEntry (:struct
  (keyval guint)   ;; guint keyval
  (modifiers guint)   ;; guint modifiers
  (binding_set (* GtkBindingSet))   ;; GtkBindingSet* binding_set
  (destroyed (:bit 1))   ;; guint destroyed:  0x000000001
  (in_emission (:bit 1))   ;; guint in_emission:  0x000000001
  (set_next (* GtkBindingEntry))   ;; GtkBindingEntry* set_next
  (hash_next (* GtkBindingEntry))   ;; GtkBindingEntry* hash_next
  (signals (* GtkBindingSignal))   ;; GtkBindingSignal* signals
  ))   ;; bind-c-type _GtkBindingEntry

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:105 <1602> 
;; struct _GtkBindingSignal {
;;         GtkBindingSignal* next; gchar* signal_name; guint n_args;
;;   GtkBindingArg
;;   * args; };
(ff:bind-c-type _GtkBindingSignal (:struct
  (next (* GtkBindingSignal))   ;; GtkBindingSignal* next
  (signal_name (* gchar))   ;; gchar* signal_name
  (n_args guint)   ;; guint n_args
  (args (* GtkBindingArg))   ;; GtkBindingArg* args
  ))   ;; bind-c-type _GtkBindingSignal

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:113 <1603> 
;; struct _GtkBindingArg {
;;         GtkType arg_type; union {
;;         glong long_data; gdouble double_data; gchar* string_data; } d;
;;   };
(ff:bind-c-type _GtkBindingArg (:struct
  (arg_type GtkType)   ;; GtkType arg_type
  (d (:union   ;; union{} d
    (long_data glong)   ;; glong long_data
    (double_data gdouble)   ;; gdouble double_data
    (string_data (* gchar))   ;; gchar* string_data
    ))  ;; slot d
  ))   ;; bind-c-type _GtkBindingArg

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:126 <1604> 
;; GtkBindingSet* gtk_binding_set_new( const gchar* set_name);
(ff:bind-c-function gtk_binding_set_new
     :unconverted-entry-name "gtk_binding_set_new"
     :c-return-type ("GtkBindingSet" "*")
     :return-type (* GtkBindingSet)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (set_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:127 <1605> 
;; GtkBindingSet* gtk_binding_set_by_class( gpointer object_class);
(ff:bind-c-function gtk_binding_set_by_class
     :unconverted-entry-name "gtk_binding_set_by_class"
     :c-return-type ("GtkBindingSet" "*")
     :return-type (* GtkBindingSet)
     :c-arg-types (("gpointer"))
     :c-arg-names (object_class)
     :arguments (gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:128 <1606> 
;; GtkBindingSet* gtk_binding_set_find( const gchar* set_name);
(ff:bind-c-function gtk_binding_set_find
     :unconverted-entry-name "gtk_binding_set_find"
     :c-return-type ("GtkBindingSet" "*")
     :return-type (* GtkBindingSet)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (set_name)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:129 <1607> 
;; gboolean gtk_bindings_activate( GtkObject* object, guint keyval, guint
;;    modifiers);
(ff:bind-c-function gtk_bindings_activate
     :unconverted-entry-name "gtk_bindings_activate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkObject" "*") ("guint") ("guint"))
     :c-arg-names (object keyval modifiers)
     :arguments ((* GtkObject) guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:132 <1608> 
;; gboolean gtk_binding_set_activate( GtkBindingSet* binding_set, guint
;;   keyval,
;;              guint modifiers, GtkObject* object);
(ff:bind-c-function gtk_binding_set_activate
     :unconverted-entry-name "gtk_binding_set_activate"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkBindingSet" "*") ("guint") ("guint") ("GtkObject" "*"))
     :c-arg-names (binding_set keyval modifiers object)
     :arguments ((* GtkBindingSet) guint guint (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:137 <1609> 
;; void gtk_binding_entry_clear( GtkBindingSet* binding_set, guint keyval,
;;              guint modifiers);
(ff:bind-c-function gtk_binding_entry_clear
     :all-names ((gtk_binding_entry_add . "gtk_binding_entry_add")
                 (gtk_binding_entry_clear . "gtk_binding_entry_clear"))
     :unconverted-entry-name "gtk_binding_entry_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBindingSet" "*") ("guint") ("guint"))
     :c-arg-names (binding_set keyval modifiers)
     :arguments ((* GtkBindingSet) guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:140 <1610> 
;; void gtk_binding_entry_add_signal( GtkBindingSet* binding_set, guint
;;   keyval,
;;              guint modifiers, const gchar* signal_name, guint n_args,
;;   ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_binding_entry_add_signal
     :unconverted-entry-name "gtk_binding_entry_add_signal"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBindingSet" "*") ("guint") ("guint")
                   ("const" "gchar" "*") ("guint") "...")
     :c-arg-names (binding_set keyval modifiers signal_name n_args)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:146 <1611> 
;; void gtk_binding_set_add_path( GtkBindingSet* binding_set, GtkPathType
;;    path_type, const gchar* path_pattern, GtkPathPriorityType priority);
(ff:bind-c-function gtk_binding_set_add_path
     :unconverted-entry-name "gtk_binding_set_add_path"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBindingSet" "*") ("GtkPathType") ("const" "gchar" "*")
                   ("GtkPathPriorityType"))
     :c-arg-names (binding_set path_type path_pattern priority)
     :arguments ((* GtkBindingSet) GtkPathType (* gchar) GtkPathPriorityType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:154 <1612> 
;; void gtk_binding_entry_remove( GtkBindingSet* binding_set, guint keyval,
;;              guint modifiers);
(ff:bind-c-function gtk_binding_entry_remove
     :unconverted-entry-name "gtk_binding_entry_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBindingSet" "*") ("guint") ("guint"))
     :c-arg-names (binding_set keyval modifiers)
     :arguments ((* GtkBindingSet) guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:157 <1613> 
;; void gtk_binding_entry_add_signall( GtkBindingSet* binding_set, guint
;;    keyval, guint modifiers, const gchar* signal_name, GSList*
;;   binding_args
;;   );
(ff:bind-c-function gtk_binding_entry_add_signall
     :unconverted-entry-name "gtk_binding_entry_add_signall"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBindingSet" "*") ("guint") ("guint")
                   ("const" "gchar" "*") ("GSList" "*"))
     :c-arg-names (binding_set keyval modifiers signal_name binding_args)
     :arguments ((* GtkBindingSet) guint guint (* gchar) (* GSList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbindings.h:162 <1614> 
;; guint gtk_binding_parse_binding( GScanner* scanner);
(ff:bind-c-function gtk_binding_parse_binding
     :unconverted-entry-name "gtk_binding_parse_binding"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GScanner" "*"))
     :c-arg-names (scanner)
     :arguments ((* GScanner))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:47 <1615> 
;; typedef struct _GtkBox GtkBox;
(ff:bind-c-typedef _GtkBox ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBox _GtkBox)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:48 <1616> 
;; typedef struct _GtkBoxClass GtkBoxClass;
(ff:bind-c-typedef _GtkBoxClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBoxClass _GtkBoxClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:49 <1617> 
;; typedef struct _GtkBoxChild GtkBoxChild;
(ff:bind-c-typedef _GtkBoxChild
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkBoxChild _GtkBoxChild)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:51 <1618> 
;; struct _GtkBox {
;;         GtkContainer container; GList* children; gint16 spacing; guint
;;   homogeneous
;;   :  0x000000001; };

;;WARNING: Strange bitfield homogeneous type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkBox (:struct
  (container GtkContainer)   ;; GtkContainer container
  (children (* GList))   ;; GList* children
  (spacing gint16)   ;; gint16 spacing
  (homogeneous (:bit 1))   ;; guint homogeneous:  0x000000001
  ))   ;; bind-c-type _GtkBox

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:60 <1619> 
;; struct _GtkBoxClass { GtkContainerClass parent_class; };
(ff:bind-c-type _GtkBoxClass (:struct
  (parent_class GtkContainerClass)   ;; GtkContainerClass parent_class
  ))   ;; bind-c-type _GtkBoxClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:65 <1620> 
;; struct _GtkBoxChild {
;;         GtkWidget* widget; guint16 padding; guint expand:  0x000000001;
;;   guint
;;    fill:  0x000000001; guint pack:  0x000000001; };

;;WARNING: Strange bitfield expand type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield fill type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield pack type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkBoxChild (:struct
  (widget (* GtkWidget))   ;; GtkWidget* widget
  (padding guint16)   ;; guint16 padding
  (expand (:bit 1))   ;; guint expand:  0x000000001
  (fill (:bit 1))   ;; guint fill:  0x000000001
  (pack (:bit 1))   ;; guint pack:  0x000000001
  ))   ;; bind-c-type _GtkBoxChild

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:75 <1621> 
;; GtkType gtk_box_get_type( void);
(ff:bind-c-function gtk_box_get_type
     :unconverted-entry-name "gtk_box_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:76 <1622> 
;; void gtk_box_pack_start( GtkBox* box, GtkWidget* child, gboolean expand,
;;              gboolean fill, guint padding);
(ff:bind-c-function gtk_box_pack_start
     :unconverted-entry-name "gtk_box_pack_start"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("GtkWidget" "*") ("gboolean") ("gboolean")
                   ("guint"))
     :c-arg-names (box child expand fill padding)
     :arguments ((* GtkBox) (* GtkWidget) gboolean gboolean guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:81 <1623> 
;; void gtk_box_pack_end( GtkBox* box, GtkWidget* child, gboolean expand,
;;              gboolean fill, guint padding);
(ff:bind-c-function gtk_box_pack_end
     :unconverted-entry-name "gtk_box_pack_end"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("GtkWidget" "*") ("gboolean") ("gboolean")
                   ("guint"))
     :c-arg-names (box child expand fill padding)
     :arguments ((* GtkBox) (* GtkWidget) gboolean gboolean guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:86 <1624> 
;; void gtk_box_pack_start_defaults( GtkBox* box, GtkWidget* widget);
(ff:bind-c-function gtk_box_pack_start_defaults
     :unconverted-entry-name "gtk_box_pack_start_defaults"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("GtkWidget" "*"))
     :c-arg-names (box widget)
     :arguments ((* GtkBox) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:88 <1625> 
;; void gtk_box_pack_end_defaults( GtkBox* box, GtkWidget* widget);
(ff:bind-c-function gtk_box_pack_end_defaults
     :unconverted-entry-name "gtk_box_pack_end_defaults"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("GtkWidget" "*"))
     :c-arg-names (box widget)
     :arguments ((* GtkBox) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:90 <1626> 
;; void gtk_box_set_homogeneous( GtkBox* box, gboolean homogeneous);
(ff:bind-c-function gtk_box_set_homogeneous
     :unconverted-entry-name "gtk_box_set_homogeneous"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("gboolean"))
     :c-arg-names (box homogeneous)
     :arguments ((* GtkBox) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:92 <1627> 
;; void gtk_box_set_spacing( GtkBox* box, gint spacing);
(ff:bind-c-function gtk_box_set_spacing
     :unconverted-entry-name "gtk_box_set_spacing"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("gint"))
     :c-arg-names (box spacing)
     :arguments ((* GtkBox) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:94 <1628> 
;; void gtk_box_reorder_child( GtkBox* box, GtkWidget* child, gint position
;;   );
(ff:bind-c-function gtk_box_reorder_child
     :unconverted-entry-name "gtk_box_reorder_child"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("GtkWidget" "*") ("gint"))
     :c-arg-names (box child position)
     :arguments ((* GtkBox) (* GtkWidget) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:97 <1629> 
;; void gtk_box_query_child_packing( GtkBox* box, GtkWidget* child,
;;   gboolean
;;   * expand, gboolean* fill, guint* padding, GtkPackType* pack_type);
(ff:bind-c-function gtk_box_query_child_packing
     :unconverted-entry-name "gtk_box_query_child_packing"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("GtkWidget" "*") ("gboolean" "*")
                   ("gboolean" "*") ("guint" "*") ("GtkPackType" "*"))
     :c-arg-names (box child expand fill padding pack_type)
     :arguments ((* GtkBox) (* GtkWidget) (* gboolean) (* gboolean) (* guint)
                 (* GtkPackType))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbox.h:103 <1630> 
;; void gtk_box_set_child_packing( GtkBox* box, GtkWidget* child, gboolean
;;    expand, gboolean fill, guint padding, GtkPackType pack_type);
(ff:bind-c-function gtk_box_set_child_packing
     :unconverted-entry-name "gtk_box_set_child_packing"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkBox" "*") ("GtkWidget" "*") ("gboolean") ("gboolean")
                   ("guint") ("GtkPackType"))
     :c-arg-names (box child expand fill padding pack_type)
     :arguments ((* GtkBox) (* GtkWidget) gboolean gboolean guint GtkPackType)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:47 <1631> 
;; typedef struct _GtkButtonBox GtkButtonBox;
(ff:bind-c-typedef _GtkButtonBox
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkButtonBox _GtkButtonBox)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:48 <1632> 
;; typedef struct _GtkButtonBoxClass GtkButtonBoxClass;
(ff:bind-c-typedef _GtkButtonBoxClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkButtonBoxClass _GtkButtonBoxClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:50 <1633> 
;; struct _GtkButtonBox {
;;         GtkBox box; gint spacing; gint child_min_width; gint
;;   child_min_height;
;;              gint child_ipad_x; gint child_ipad_y; GtkButtonBoxStyle
;;   layout_style;
;;    };
(ff:bind-c-type _GtkButtonBox (:struct
  (box GtkBox)   ;; GtkBox box
  (spacing gint)   ;; gint spacing
  (child_min_width gint)   ;; gint child_min_width
  (child_min_height gint)   ;; gint child_min_height
  (child_ipad_x gint)   ;; gint child_ipad_x
  (child_ipad_y gint)   ;; gint child_ipad_y
  (layout_style GtkButtonBoxStyle)   ;; GtkButtonBoxStyle layout_style
  ))   ;; bind-c-type _GtkButtonBox

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:61 <1634> 
;; struct _GtkButtonBoxClass { GtkBoxClass parent_class; };
(ff:bind-c-type _GtkButtonBoxClass (:struct
  (parent_class GtkBoxClass)   ;; GtkBoxClass parent_class
  ))   ;; bind-c-type _GtkButtonBoxClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:67 <1635> 
;; GtkType gtk_button_box_get_type( void);
(ff:bind-c-function gtk_button_box_get_type
     :unconverted-entry-name "gtk_button_box_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:69 <1636> 
;; void gtk_button_box_get_child_size_default( gint* min_width, gint*
;;   min_height
;;   );
(ff:bind-c-function gtk_button_box_get_child_size_default
     :unconverted-entry-name "gtk_button_box_get_child_size_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint" "*") ("gint" "*"))
     :c-arg-names (min_width min_height)
     :arguments ((* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:70 <1637> 
;; void gtk_button_box_get_child_ipadding_default( gint* ipad_x, gint*
;;   ipad_y
;;   );
(ff:bind-c-function gtk_button_box_get_child_ipadding_default
     :unconverted-entry-name "gtk_button_box_get_child_ipadding_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint" "*") ("gint" "*"))
     :c-arg-names (ipad_x ipad_y)
     :arguments ((* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:72 <1638> 
;; void gtk_button_box_set_child_size_default( gint min_width, gint
;;   min_height
;;   );
(ff:bind-c-function gtk_button_box_set_child_size_default
     :unconverted-entry-name "gtk_button_box_set_child_size_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint") ("gint"))
     :c-arg-names (min_width min_height)
     :arguments (gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:73 <1639> 
;; void gtk_button_box_set_child_ipadding_default( gint ipad_x, gint ipad_y
;;   );
(ff:bind-c-function gtk_button_box_set_child_ipadding_default
     :unconverted-entry-name "gtk_button_box_set_child_ipadding_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("gint") ("gint"))
     :c-arg-names (ipad_x ipad_y)
     :arguments (gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:75 <1640> 
;; gint gtk_button_box_get_spacing( GtkButtonBox* widget);
(ff:bind-c-function gtk_button_box_get_spacing
     :unconverted-entry-name "gtk_button_box_get_spacing"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkButtonBox" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkButtonBox))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:76 <1641> 
;; GtkButtonBoxStyle gtk_button_box_get_layout( GtkButtonBox* widget);
(ff:bind-c-function gtk_button_box_get_layout
     :unconverted-entry-name "gtk_button_box_get_layout"
     :c-return-type ("GtkButtonBoxStyle")
     :return-type GtkButtonBoxStyle
     :c-arg-types (("GtkButtonBox" "*"))
     :c-arg-names (widget)
     :arguments ((* GtkButtonBox))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:77 <1642> 
;; void gtk_button_box_get_child_size( GtkButtonBox* widget, gint*
;;   min_width,
;;              gint* min_height);
(ff:bind-c-function gtk_button_box_get_child_size
     :unconverted-entry-name "gtk_button_box_get_child_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButtonBox" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (widget min_width min_height)
     :arguments ((* GtkButtonBox) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:79 <1643> 
;; void gtk_button_box_get_child_ipadding( GtkButtonBox* widget, gint*
;;   ipad_x,
;;              gint* ipad_y);
(ff:bind-c-function gtk_button_box_get_child_ipadding
     :unconverted-entry-name "gtk_button_box_get_child_ipadding"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButtonBox" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (widget ipad_x ipad_y)
     :arguments ((* GtkButtonBox) (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:81 <1644> 
;; void gtk_button_box_set_spacing( GtkButtonBox* widget, gint spacing);
(ff:bind-c-function gtk_button_box_set_spacing
     :unconverted-entry-name "gtk_button_box_set_spacing"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButtonBox" "*") ("gint"))
     :c-arg-names (widget spacing)
     :arguments ((* GtkButtonBox) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:82 <1645> 
;; void gtk_button_box_set_layout( GtkButtonBox* widget, GtkButtonBoxStyle
;;    layout_style);
(ff:bind-c-function gtk_button_box_set_layout
     :unconverted-entry-name "gtk_button_box_set_layout"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButtonBox" "*") ("GtkButtonBoxStyle"))
     :c-arg-names (widget layout_style)
     :arguments ((* GtkButtonBox) GtkButtonBoxStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:84 <1646> 
;; void gtk_button_box_set_child_size( GtkButtonBox* widget, gint
;;   min_width,
;;              gint min_height);
(ff:bind-c-function gtk_button_box_set_child_size
     :unconverted-entry-name "gtk_button_box_set_child_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButtonBox" "*") ("gint") ("gint"))
     :c-arg-names (widget min_width min_height)
     :arguments ((* GtkButtonBox) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:86 <1647> 
;; void gtk_button_box_set_child_ipadding( GtkButtonBox* widget, gint
;;   ipad_x,
;;              gint ipad_y);
(ff:bind-c-function gtk_button_box_set_child_ipadding
     :unconverted-entry-name "gtk_button_box_set_child_ipadding"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButtonBox" "*") ("gint") ("gint"))
     :c-arg-names (widget ipad_x ipad_y)
     :arguments ((* GtkButtonBox) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbbox.h:90 <1648> 
;; void gtk_button_box_child_requisition( GtkWidget* widget, int*
;;   nvis_children,
;;              int* width, int* height);
(ff:bind-c-function gtk_button_box_child_requisition
     :unconverted-entry-name "gtk_button_box_child_requisition"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWidget" "*") ("int" "*") ("int" "*") ("int" "*"))
     :c-arg-names (widget nvis_children width height)
     :arguments ((* GtkWidget) (* :int) (* :int) (* :int))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:47 <1649> 
;; typedef struct _GtkButton GtkButton;
(ff:bind-c-typedef _GtkButton ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkButton _GtkButton)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:48 <1650> 
;; typedef struct _GtkButtonClass GtkButtonClass;
(ff:bind-c-typedef _GtkButtonClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkButtonClass _GtkButtonClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:50 <1651> 
;; struct _GtkButton {
;;         GtkBin bin; GtkWidget* child; guint in_button:  0x000000001;
;;   guint button_down
;;   :  0x000000001; guint relief:  0x000000002; };

;;WARNING: Strange bitfield in_button type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield button_down type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield relief type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkButton (:struct
  (bin GtkBin)   ;; GtkBin bin
  (child (* GtkWidget))   ;; GtkWidget* child
  (in_button (:bit 1))   ;; guint in_button:  0x000000001
  (button_down (:bit 1))   ;; guint button_down:  0x000000001
  (relief (:bit 2))   ;; guint relief:  0x000000002
  ))   ;; bind-c-type _GtkButton

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:63 <1652> 
;; struct _GtkButtonClass {
;;         GtkBinClass parent_class; void(* pressed)( GtkButton* button);
;;   void(*
;;    released)( GtkButton* button); void(* clicked)( GtkButton* button);
;;   void
;;   (* enter)( GtkButton* button); void(* leave)( GtkButton* button); };
(ff:bind-c-type _GtkButtonClass (:struct
  (parent_class GtkBinClass)   ;; GtkBinClass parent_class
  (pressed ff:function-pointer)   ;; void(* pressed)( GtkButton* button)
  (released ff:function-pointer)   ;; void(* released)( GtkButton* button)
  (clicked ff:function-pointer)   ;; void(* clicked)( GtkButton* button)
  (enter ff:function-pointer)   ;; void(* enter)( GtkButton* button)
  (leave ff:function-pointer)   ;; void(* leave)( GtkButton* button)
  ))   ;; bind-c-type _GtkButtonClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:75 <1653> 
;; GtkType gtk_button_get_type( void);
(ff:bind-c-function gtk_button_get_type
     :unconverted-entry-name "gtk_button_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:76 <1654> 
;; GtkWidget* gtk_button_new( void);
(ff:bind-c-function gtk_button_new
     :unconverted-entry-name "gtk_button_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:77 <1655> 
;; GtkWidget* gtk_button_new_with_label( const gchar* label);
(ff:bind-c-function gtk_button_new_with_label
     :unconverted-entry-name "gtk_button_new_with_label"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (label)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:78 <1656> 
;; void gtk_button_pressed( GtkButton* button);
(ff:bind-c-function gtk_button_pressed
     :unconverted-entry-name "gtk_button_pressed"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButton" "*"))
     :c-arg-names (button)
     :arguments ((* GtkButton))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:79 <1657> 
;; void gtk_button_released( GtkButton* button);
(ff:bind-c-function gtk_button_released
     :unconverted-entry-name "gtk_button_released"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButton" "*"))
     :c-arg-names (button)
     :arguments ((* GtkButton))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:80 <1658> 
;; void gtk_button_clicked( GtkButton* button);
(ff:bind-c-function gtk_button_clicked
     :unconverted-entry-name "gtk_button_clicked"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButton" "*"))
     :c-arg-names (button)
     :arguments ((* GtkButton))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:81 <1659> 
;; void gtk_button_enter( GtkButton* button);
(ff:bind-c-function gtk_button_enter
     :unconverted-entry-name "gtk_button_enter"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButton" "*"))
     :c-arg-names (button)
     :arguments ((* GtkButton))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:82 <1660> 
;; void gtk_button_leave( GtkButton* button);
(ff:bind-c-function gtk_button_leave
     :unconverted-entry-name "gtk_button_leave"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButton" "*"))
     :c-arg-names (button)
     :arguments ((* GtkButton))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:83 <1661> 
;; void gtk_button_set_relief( GtkButton* button, GtkReliefStyle newstyle);
(ff:bind-c-function gtk_button_set_relief
     :unconverted-entry-name "gtk_button_set_relief"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkButton" "*") ("GtkReliefStyle"))
     :c-arg-names (button newstyle)
     :arguments ((* GtkButton) GtkReliefStyle)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkbutton.h:85 <1662> 
;; GtkReliefStyle gtk_button_get_relief( GtkButton* button);
(ff:bind-c-function gtk_button_get_relief
     :unconverted-entry-name "gtk_button_get_relief"
     :c-return-type ("GtkReliefStyle")
     :return-type GtkReliefStyle
     :c-arg-types (("GtkButton" "*"))
     :c-arg-names (button)
     :arguments ((* GtkButton))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:14 <1663> 
;; void gtk_marshal_BOOL__NONE( GtkObject* object, GtkSignalFunc func,
;;   gpointer
;;    func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_BOOL__NONE
     :unconverted-entry-name "gtk_marshal_BOOL__NONE"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:18 <1664> 
;; void gtk_marshal_BOOL__POINTER( GtkObject* object, GtkSignalFunc func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_BOOL__POINTER
     :unconverted-entry-name "gtk_marshal_BOOL__POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:22 <1665> 
;; void gtk_marshal_BOOL__POINTER_POINTER_INT_INT( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_BOOL__POINTER_POINTER_INT_INT
     :unconverted-entry-name "gtk_marshal_BOOL__POINTER_POINTER_INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:27 <1666> 
;; void gtk_marshal_BOOL__POINTER_INT_INT( GtkObject* object, GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_BOOL__POINTER_INT_INT
     :unconverted-entry-name "gtk_marshal_BOOL__POINTER_INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:33 <1667> 
;; void gtk_marshal_BOOL__POINTER_INT_INT_INT( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_BOOL__POINTER_INT_INT_INT
     :all-names ((gtk_marshal_BOOL__POINTER_INT_INT_INT
                  . "gtk_marshal_BOOL__POINTER_INT_INT_INT")
                 (gtk_marshal_BOOL__POINTER_INT_INT_UINT
                  . "gtk_marshal_BOOL__POINTER_INT_INT_UINT"))
     :unconverted-entry-name "gtk_marshal_BOOL__POINTER_INT_INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:40 <1668> 
;; void gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER( GtkObject*
;;   object,
;;              GtkSignalFunc func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER
     :all-names ((gtk_marshal_BOOL__POINTER_STRING_STRING_POINTER
                  . "gtk_marshal_BOOL__POINTER_STRING_STRING_POINTER")
                 (gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER
                  . "gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER"))
     :unconverted-entry-name "gtk_marshal_BOOL__POINTER_POINTER_POINTER_POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:47 <1669> 
;; void gtk_marshal_INT__INT( GtkObject* object, GtkSignalFunc func,
;;   gpointer
;;    func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_INT__INT
     :all-names ((gtk_marshal_INT__INT . "gtk_marshal_INT__INT")
                 (gtk_marshal_ENUM__ENUM . "gtk_marshal_ENUM__ENUM"))
     :unconverted-entry-name "gtk_marshal_INT__INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:51 <1670> 
;; void gtk_marshal_INT__POINTER( GtkObject* object, GtkSignalFunc func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_INT__POINTER
     :unconverted-entry-name "gtk_marshal_INT__POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:55 <1671> 
;; void gtk_marshal_INT__POINTER_CHAR_CHAR( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_INT__POINTER_CHAR_CHAR
     :unconverted-entry-name "gtk_marshal_INT__POINTER_CHAR_CHAR"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:59 <1672> 
;; void gtk_marshal_NONE__BOOL( GtkObject* object, GtkSignalFunc func,
;;   gpointer
;;    func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__BOOL
     :unconverted-entry-name "gtk_marshal_NONE__BOOL"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:65 <1673> 
;; void gtk_marshal_NONE__POINTER( GtkObject* object, GtkSignalFunc func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER
     :all-names ((gtk_marshal_NONE__BOXED . "gtk_marshal_NONE__BOXED")
                 (gtk_marshal_NONE__OBJECT . "gtk_marshal_NONE__OBJECT")
                 (gtk_marshal_NONE__STRING . "gtk_marshal_NONE__STRING")
                 (gtk_marshal_NONE__POINTER . "gtk_marshal_NONE__POINTER"))
     :unconverted-entry-name "gtk_marshal_NONE__POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:69 <1674> 
;; void gtk_marshal_NONE__C_CALLBACK( GtkObject* object, GtkSignalFunc
;;   func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__C_CALLBACK
     :unconverted-entry-name "gtk_marshal_NONE__C_CALLBACK"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:73 <1675> 
;; void gtk_marshal_NONE__C_CALLBACK_C_CALLBACK( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__C_CALLBACK_C_CALLBACK
     :unconverted-entry-name "gtk_marshal_NONE__C_CALLBACK_C_CALLBACK"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:80 <1676> 
;; void gtk_marshal_NONE__INT( GtkObject* object, GtkSignalFunc func,
;;   gpointer
;;    func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT
     :all-names ((gtk_marshal_NONE__INT . "gtk_marshal_NONE__INT")
                 (gtk_marshal_NONE__UINT . "gtk_marshal_NONE__UINT")
                 (gtk_marshal_NONE__ENUM . "gtk_marshal_NONE__ENUM"))
     :unconverted-entry-name "gtk_marshal_NONE__INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:86 <1677> 
;; void gtk_marshal_NONE__INT_FLOAT( GtkObject* object, GtkSignalFunc func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT_FLOAT
     :all-names ((gtk_marshal_NONE__INT_FLOAT . "gtk_marshal_NONE__INT_FLOAT")
                 (gtk_marshal_NONE__ENUM_FLOAT
                  . "gtk_marshal_NONE__ENUM_FLOAT"))
     :unconverted-entry-name "gtk_marshal_NONE__INT_FLOAT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:92 <1678> 
;; void gtk_marshal_NONE__INT_FLOAT_BOOL( GtkObject* object, GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT_FLOAT_BOOL
     :all-names ((gtk_marshal_NONE__INT_FLOAT_BOOL
                  . "gtk_marshal_NONE__INT_FLOAT_BOOL")
                 (gtk_marshal_NONE__ENUM_FLOAT_BOOL
                  . "gtk_marshal_NONE__ENUM_FLOAT_BOOL"))
     :unconverted-entry-name "gtk_marshal_NONE__INT_FLOAT_BOOL"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:96 <1679> 
;; void gtk_marshal_NONE__INT_INT( GtkObject* object, GtkSignalFunc func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT_INT
     :unconverted-entry-name "gtk_marshal_NONE__INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:100 <1680> 
;; void gtk_marshal_NONE__INT_INT_POINTER( GtkObject* object, GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT_INT_POINTER
     :unconverted-entry-name "gtk_marshal_NONE__INT_INT_POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:104 <1681> 
;; void gtk_marshal_NONE__NONE( GtkObject* object, GtkSignalFunc func,
;;   gpointer
;;    func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__NONE
     :all-names ((gtk_marshal_NONE__NONE . "gtk_marshal_NONE__NONE")
                 (gtk_signal_default_marshaller
                  . "gtk_signal_default_marshaller"))
     :unconverted-entry-name "gtk_marshal_NONE__NONE"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:110 <1682> 
;; void gtk_marshal_NONE__POINTER_INT( GtkObject* object, GtkSignalFunc
;;   func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER_INT
     :all-names ((gtk_marshal_NONE__POINTER_INT
                  . "gtk_marshal_NONE__POINTER_INT")
                 (gtk_marshal_NONE__POINTER_UINT
                  . "gtk_marshal_NONE__POINTER_UINT"))
     :unconverted-entry-name "gtk_marshal_NONE__POINTER_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:114 <1683> 
;; void gtk_marshal_NONE__POINTER_POINTER( GtkObject* object, GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER_POINTER
     :unconverted-entry-name "gtk_marshal_NONE__POINTER_POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:118 <1684> 
;; void gtk_marshal_NONE__POINTER_POINTER_POINTER( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER_POINTER_POINTER
     :all-names ((gtk_marshal_NONE__POINTER_STRING_STRING
                  . "gtk_marshal_NONE__POINTER_STRING_STRING")
                 (gtk_marshal_NONE__POINTER_POINTER_POINTER
                  . "gtk_marshal_NONE__POINTER_POINTER_POINTER"))
     :unconverted-entry-name "gtk_marshal_NONE__POINTER_POINTER_POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:129 <1685> 
;; void gtk_marshal_NONE__POINTER_INT_INT( GtkObject* object, GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER_INT_INT
     :all-names ((gtk_marshal_NONE__POINTER_INT_INT
                  . "gtk_marshal_NONE__POINTER_INT_INT")
                 (gtk_marshal_NONE__POINTER_UINT_UINT
                  . "gtk_marshal_NONE__POINTER_UINT_UINT")
                 (gtk_marshal_NONE__POINTER_UINT_ENUM
                  . "gtk_marshal_NONE__POINTER_UINT_ENUM"))
     :unconverted-entry-name "gtk_marshal_NONE__POINTER_INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:135 <1686> 
;; void gtk_marshal_NONE__POINTER_POINTER_INT_INT( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER_POINTER_INT_INT
     :all-names ((gtk_marshal_NONE__POINTER_POINTER_INT_INT
                  . "gtk_marshal_NONE__POINTER_POINTER_INT_INT")
                 (gtk_marshal_NONE__POINTER_POINTER_UINT_UINT
                  . "gtk_marshal_NONE__POINTER_POINTER_UINT_UINT"))
     :unconverted-entry-name "gtk_marshal_NONE__POINTER_POINTER_INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:142 <1687> 
;; void gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT( GtkObject*
;;   object,
;;              GtkSignalFunc func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT
     :all-names ((gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT
                  . "gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT")
                 (gtk_marshal_NONE__POINTER_INT_INT_POINTER_UINT_UINT
                  . "gtk_marshal_NONE__POINTER_INT_INT_POINTER_UINT_UINT"))
     :unconverted-entry-name "gtk_marshal_NONE__POINTER_INT_INT_POINTER_INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:153 <1688> 
;; void gtk_marshal_NONE__POINTER_INT_POINTER( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__POINTER_INT_POINTER
     :all-names ((gtk_marshal_NONE__STRING_INT_POINTER
                  . "gtk_marshal_NONE__STRING_INT_POINTER")
                 (gtk_marshal_NONE__POINTER_INT_POINTER
                  . "gtk_marshal_NONE__POINTER_INT_POINTER"))
     :unconverted-entry-name "gtk_marshal_NONE__POINTER_INT_POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:162 <1689> 
;; void gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER( GtkObject*
;;   object,
;;              GtkSignalFunc func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER
     :all-names ((gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER
                  . "gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER")
                 (gtk_marshal_NONE__UINT_POINTER_UINT_ENUM_ENUM_POINTER
                  . "gtk_marshal_NONE__UINT_POINTER_UINT_ENUM_ENUM_POINTER"))
     :unconverted-entry-name "gtk_marshal_NONE__INT_POINTER_INT_INT_INT_POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:169 <1690> 
;; void gtk_marshal_NONE__INT_POINTER_INT_INT_INT( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT_POINTER_INT_INT_INT
     :all-names ((gtk_marshal_NONE__INT_POINTER_INT_INT_INT
                  . "gtk_marshal_NONE__INT_POINTER_INT_INT_INT")
                 (gtk_marshal_NONE__UINT_POINTER_UINT_UINT_ENUM
                  . "gtk_marshal_NONE__UINT_POINTER_UINT_UINT_ENUM"))
     :unconverted-entry-name "gtk_marshal_NONE__INT_POINTER_INT_INT_INT"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmarshal.h:176 <1691> 
;; void gtk_marshal_NONE__INT_POINTER( GtkObject* object, GtkSignalFunc
;;   func,
;;              gpointer func_data, GtkArg* args);
(ff:bind-c-function gtk_marshal_NONE__INT_POINTER
     :all-names ((gtk_marshal_NONE__UINT_STRING
                  . "gtk_marshal_NONE__UINT_STRING")
                 (gtk_marshal_NONE__INT_POINTER
                  . "gtk_marshal_NONE__INT_POINTER"))
     :unconverted-entry-name "gtk_marshal_NONE__INT_POINTER"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer")
                   ("GtkArg" "*"))
     :c-arg-names (object func func_data args)
     :arguments ((* GtkObject) GtkSignalFunc gpointer (* GtkArg))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:44 <1692> 
;; typedef void(* GtkSignalMarshal)( GtkObject* object, gpointer data,
;;   guint
;;    nparams, GtkArg* args, GtkType* arg_types, GtkType return_type);
(ff:bind-c-type GtkSignalMarshal (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:50 <1693> 
;; typedef void(* GtkSignalDestroy)( gpointer data);
(ff:bind-c-type GtkSignalDestroy (* :void))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:51 <1694> 
;; typedef gboolean(* GtkEmissionHook)( GtkObject* object, guint signal_id,
;;              guint n_params, GtkArg* params, gpointer data);
(ff:bind-c-type GtkEmissionHook (* gboolean))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:57 <1695> 
;; typedef struct _GtkSignalQuery GtkSignalQuery;
(ff:bind-c-typedef _GtkSignalQuery
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkSignalQuery _GtkSignalQuery)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:59 <1696> 
;; struct _GtkSignalQuery {
;;         GtkType object_type; guint signal_id; const gchar* signal_name;
;;   guint
;;    is_user_signal:  0x000000001; GtkSignalRunType signal_flags; GtkType
;;   return_val;
;;              guint nparams; const GtkType* params; };

;;WARNING: Strange bitfield is_user_signal type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkSignalQuery (:struct
  (object_type GtkType)   ;; GtkType object_type
  (signal_id guint)   ;; guint signal_id
  (signal_name (* gchar))   ;; const gchar* signal_name
  (is_user_signal (:bit 1))   ;; guint is_user_signal:  0x000000001
  (signal_flags GtkSignalRunType)   ;; GtkSignalRunType signal_flags
  (return_val GtkType)   ;; GtkType return_val
  (nparams guint)   ;; guint nparams
  (params (* GtkType))   ;; const GtkType* params
  ))   ;; bind-c-type _GtkSignalQuery

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:73 <1697> 
;; guint gtk_signal_lookup( const gchar* name, GtkType object_type);
(ff:bind-c-function gtk_signal_lookup
     :unconverted-entry-name "gtk_signal_lookup"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GtkType"))
     :c-arg-names (name object_type)
     :arguments ((* gchar) GtkType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:75 <1698> 
;; gchar* gtk_signal_name( guint signal_id);
(ff:bind-c-function gtk_signal_name
     :unconverted-entry-name "gtk_signal_name"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("guint"))
     :c-arg-names (signal_id)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:76 <1699> 
;; guint gtk_signal_n_emissions( GtkObject* object, guint signal_id);
(ff:bind-c-function gtk_signal_n_emissions
     :unconverted-entry-name "gtk_signal_n_emissions"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("guint"))
     :c-arg-names (object signal_id)
     :arguments ((* GtkObject) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:78 <1700> 
;; guint gtk_signal_n_emissions_by_name( GtkObject* object, const gchar*
;;    name);
(ff:bind-c-function gtk_signal_n_emissions_by_name
     :unconverted-entry-name "gtk_signal_n_emissions_by_name"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object name)
     :arguments ((* GtkObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:80 <1701> 
;; void gtk_signal_emit_stop( GtkObject* object, guint signal_id);
(ff:bind-c-function gtk_signal_emit_stop
     :unconverted-entry-name "gtk_signal_emit_stop"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint"))
     :c-arg-names (object signal_id)
     :arguments ((* GtkObject) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:82 <1702> 
;; void gtk_signal_emit_stop_by_name( GtkObject* object, const gchar*
;;   name);
(ff:bind-c-function gtk_signal_emit_stop_by_name
     :unconverted-entry-name "gtk_signal_emit_stop_by_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*"))
     :c-arg-names (object name)
     :arguments ((* GtkObject) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:84 <1703> 
;; guint gtk_signal_connect( GtkObject* object, const gchar* name,
;;   GtkSignalFunc
;;    func, gpointer func_data);
(ff:bind-c-function gtk_signal_connect
     :unconverted-entry-name "gtk_signal_connect"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkSignalFunc")
                   ("gpointer"))
     :c-arg-names (object name func func_data)
     :arguments ((* GtkObject) (* gchar) GtkSignalFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:88 <1704> 
;; guint gtk_signal_connect_after( GtkObject* object, const gchar* name,
;;              GtkSignalFunc func, gpointer func_data);
(ff:bind-c-function gtk_signal_connect_after
     :unconverted-entry-name "gtk_signal_connect_after"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkSignalFunc")
                   ("gpointer"))
     :c-arg-names (object name func func_data)
     :arguments ((* GtkObject) (* gchar) GtkSignalFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:92 <1705> 
;; guint gtk_signal_connect_object( GtkObject* object, const gchar* name,
;;              GtkSignalFunc func, GtkObject* slot_object);
(ff:bind-c-function gtk_signal_connect_object
     :unconverted-entry-name "gtk_signal_connect_object"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkSignalFunc")
                   ("GtkObject" "*"))
     :c-arg-names (object name func slot_object)
     :arguments ((* GtkObject) (* gchar) GtkSignalFunc (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:96 <1706> 
;; guint gtk_signal_connect_object_after( GtkObject* object, const gchar
;;   * name, GtkSignalFunc func, GtkObject* slot_object);
(ff:bind-c-function gtk_signal_connect_object_after
     :unconverted-entry-name "gtk_signal_connect_object_after"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkSignalFunc")
                   ("GtkObject" "*"))
     :c-arg-names (object name func slot_object)
     :arguments ((* GtkObject) (* gchar) GtkSignalFunc (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:100 <1707> 
;; guint gtk_signal_connect_full( GtkObject* object, const gchar* name,
;;   GtkSignalFunc
;;    func, GtkCallbackMarshal marshal, gpointer data, GtkDestroyNotify
;;   destroy_func,
;;              gint object_signal, gint after);
(ff:bind-c-function gtk_signal_connect_full
     :unconverted-entry-name "gtk_signal_connect_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkSignalFunc")
                   ("GtkCallbackMarshal") ("gpointer") ("GtkDestroyNotify")
                   ("gint") ("gint"))
     :c-arg-names (object name func marshal data destroy_func object_signal
                   after)
     :arguments ((* GtkObject) (* gchar) GtkSignalFunc GtkCallbackMarshal
                 gpointer GtkDestroyNotify gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:109 <1708> 
;; void gtk_signal_connect_object_while_alive( GtkObject* object, const
;;   gchar
;;   * signal, GtkSignalFunc func, GtkObject* alive_object);
(ff:bind-c-function gtk_signal_connect_object_while_alive
     :unconverted-entry-name "gtk_signal_connect_object_while_alive"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkSignalFunc")
                   ("GtkObject" "*"))
     :c-arg-names (object signal func alive_object)
     :arguments ((* GtkObject) (* gchar) GtkSignalFunc (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:113 <1709> 
;; void gtk_signal_connect_while_alive( GtkObject* object, const gchar*
;;   signal,
;;              GtkSignalFunc func, gpointer func_data, GtkObject*
;;   alive_object);
(ff:bind-c-function gtk_signal_connect_while_alive
     :unconverted-entry-name "gtk_signal_connect_while_alive"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkSignalFunc")
                   ("gpointer") ("GtkObject" "*"))
     :c-arg-names (object signal func func_data alive_object)
     :arguments ((* GtkObject) (* gchar) GtkSignalFunc gpointer (* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:119 <1710> 
;; void gtk_signal_disconnect( GtkObject* object, guint handler_id);
(ff:bind-c-function gtk_signal_disconnect
     :unconverted-entry-name "gtk_signal_disconnect"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint"))
     :c-arg-names (object handler_id)
     :arguments ((* GtkObject) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:121 <1711> 
;; void gtk_signal_disconnect_by_func( GtkObject* object, GtkSignalFunc
;;   func,
;;              gpointer data);
(ff:bind-c-function gtk_signal_disconnect_by_func
     :unconverted-entry-name "gtk_signal_disconnect_by_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer"))
     :c-arg-names (object func data)
     :arguments ((* GtkObject) GtkSignalFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:124 <1712> 
;; void gtk_signal_disconnect_by_data( GtkObject* object, gpointer data);
(ff:bind-c-function gtk_signal_disconnect_by_data
     :unconverted-entry-name "gtk_signal_disconnect_by_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("gpointer"))
     :c-arg-names (object data)
     :arguments ((* GtkObject) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:126 <1713> 
;; void gtk_signal_handler_block( GtkObject* object, guint handler_id);
(ff:bind-c-function gtk_signal_handler_block
     :unconverted-entry-name "gtk_signal_handler_block"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint"))
     :c-arg-names (object handler_id)
     :arguments ((* GtkObject) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:128 <1714> 
;; void gtk_signal_handler_block_by_func( GtkObject* object, GtkSignalFunc
;;    func, gpointer data);
(ff:bind-c-function gtk_signal_handler_block_by_func
     :unconverted-entry-name "gtk_signal_handler_block_by_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer"))
     :c-arg-names (object func data)
     :arguments ((* GtkObject) GtkSignalFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:131 <1715> 
;; void gtk_signal_handler_block_by_data( GtkObject* object, gpointer
;;   data);
(ff:bind-c-function gtk_signal_handler_block_by_data
     :unconverted-entry-name "gtk_signal_handler_block_by_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("gpointer"))
     :c-arg-names (object data)
     :arguments ((* GtkObject) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:133 <1716> 
;; void gtk_signal_handler_unblock( GtkObject* object, guint handler_id);
(ff:bind-c-function gtk_signal_handler_unblock
     :unconverted-entry-name "gtk_signal_handler_unblock"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint"))
     :c-arg-names (object handler_id)
     :arguments ((* GtkObject) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:135 <1717> 
;; void gtk_signal_handler_unblock_by_func( GtkObject* object,
;;   GtkSignalFunc
;;    func, gpointer data);
(ff:bind-c-function gtk_signal_handler_unblock_by_func
     :unconverted-entry-name "gtk_signal_handler_unblock_by_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("GtkSignalFunc") ("gpointer"))
     :c-arg-names (object func data)
     :arguments ((* GtkObject) GtkSignalFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:138 <1718> 
;; void gtk_signal_handler_unblock_by_data( GtkObject* object, gpointer
;;   data
;;   );
(ff:bind-c-function gtk_signal_handler_unblock_by_data
     :unconverted-entry-name "gtk_signal_handler_unblock_by_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("gpointer"))
     :c-arg-names (object data)
     :arguments ((* GtkObject) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:140 <1719> 
;; guint gtk_signal_handler_pending( GtkObject* object, guint signal_id,
;;              gboolean may_be_blocked);
(ff:bind-c-function gtk_signal_handler_pending
     :unconverted-entry-name "gtk_signal_handler_pending"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("guint") ("gboolean"))
     :c-arg-names (object signal_id may_be_blocked)
     :arguments ((* GtkObject) guint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:143 <1720> 
;; guint gtk_signal_handler_pending_by_func( GtkObject* object, guint
;;   signal_id,
;;              gboolean may_be_blocked, GtkSignalFunc func, gpointer
;;   data);
(ff:bind-c-function gtk_signal_handler_pending_by_func
     :unconverted-entry-name "gtk_signal_handler_pending_by_func"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("GtkObject" "*") ("guint") ("gboolean") ("GtkSignalFunc")
                   ("gpointer"))
     :c-arg-names (object signal_id may_be_blocked func data)
     :arguments ((* GtkObject) guint gboolean GtkSignalFunc gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:148 <1721> 
;; gint gtk_signal_handler_pending_by_id( GtkObject* object, guint
;;   handler_id,
;;              gboolean may_be_blocked);
(ff:bind-c-function gtk_signal_handler_pending_by_id
     :unconverted-entry-name "gtk_signal_handler_pending_by_id"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkObject" "*") ("guint") ("gboolean"))
     :c-arg-names (object handler_id may_be_blocked)
     :arguments ((* GtkObject) guint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:151 <1722> 
;; guint gtk_signal_add_emission_hook( guint signal_id, GtkEmissionHook
;;   hook_func,
;;              gpointer data);
(ff:bind-c-function gtk_signal_add_emission_hook
     :unconverted-entry-name "gtk_signal_add_emission_hook"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint") ("GtkEmissionHook") ("gpointer"))
     :c-arg-names (signal_id hook_func data)
     :arguments (guint GtkEmissionHook gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:154 <1723> 
;; guint gtk_signal_add_emission_hook_full( guint signal_id,
;;   GtkEmissionHook
;;    hook_func, gpointer data, GDestroyNotify destroy);
(ff:bind-c-function gtk_signal_add_emission_hook_full
     :unconverted-entry-name "gtk_signal_add_emission_hook_full"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("guint") ("GtkEmissionHook") ("gpointer")
                   ("GDestroyNotify"))
     :c-arg-names (signal_id hook_func data destroy)
     :arguments (guint GtkEmissionHook gpointer GDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:158 <1724> 
;; void gtk_signal_remove_emission_hook( guint signal_id, guint hook_id);
(ff:bind-c-function gtk_signal_remove_emission_hook
     :unconverted-entry-name "gtk_signal_remove_emission_hook"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("guint") ("guint"))
     :c-arg-names (signal_id hook_id)
     :arguments (guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:165 <1725> 
;; GtkSignalQuery* gtk_signal_query( guint signal_id);
(ff:bind-c-function gtk_signal_query
     :unconverted-entry-name "gtk_signal_query"
     :c-return-type ("GtkSignalQuery" "*")
     :return-type (* GtkSignalQuery)
     :c-arg-types (("guint"))
     :c-arg-names (signal_id)
     :arguments (guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:169 <1726> 
;; void gtk_signal_init( void);
(ff:bind-c-function gtk_signal_init
     :unconverted-entry-name "gtk_signal_init"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:170 <1727> 
;; guint gtk_signal_new( const gchar* name, GtkSignalRunType signal_flags,
;;              GtkType object_type, guint function_offset,
;;   GtkSignalMarshaller marshaller,
;;              GtkType return_val, guint nparams, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_signal_new
     :unconverted-entry-name "gtk_signal_new"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GtkSignalRunType") ("GtkType")
                   ("guint") ("GtkSignalMarshaller") ("GtkType") ("guint")
                   "...")
     :c-arg-names (name signal_flags object_type function_offset marshaller
                   return_val nparams)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:178 <1728> 
;; guint gtk_signal_newv( const gchar* name, GtkSignalRunType signal_flags,
;;              GtkType object_type, guint function_offset,
;;   GtkSignalMarshaller marshaller,
;;              GtkType return_val, guint nparams, GtkType* params);
(ff:bind-c-function gtk_signal_newv
     :unconverted-entry-name "gtk_signal_newv"
     :c-return-type ("guint")
     :return-type guint
     :c-arg-types (("const" "gchar" "*") ("GtkSignalRunType") ("GtkType")
                   ("guint") ("GtkSignalMarshaller") ("GtkType") ("guint")
                   ("GtkType" "*"))
     :c-arg-names (name signal_flags object_type function_offset marshaller
                   return_val nparams params)
     :arguments ((* gchar) GtkSignalRunType GtkType guint GtkSignalMarshaller
                 GtkType guint (* GtkType))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:186 <1729> 
;; void gtk_signal_emit( GtkObject* object, guint signal_id, ELLIPSIS);

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_signal_emit
     :unconverted-entry-name "gtk_signal_emit"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint") "...")
     :c-arg-names (object signal_id)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:189 <1730> 
;; void gtk_signal_emit_by_name( GtkObject* object, const gchar* name,
;;   ELLIPSIS
;;   );

;;NOTE: Lisp args to this function will get default conversions only.
(ff:bind-c-function gtk_signal_emit_by_name
     :unconverted-entry-name "gtk_signal_emit_by_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") "...")
     :c-arg-names (object name)
     :arguments nil
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:192 <1731> 
;; void gtk_signal_emitv( GtkObject* object, guint signal_id, GtkArg*
;;   params
;;   );
(ff:bind-c-function gtk_signal_emitv
     :unconverted-entry-name "gtk_signal_emitv"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("guint") ("GtkArg" "*"))
     :c-arg-names (object signal_id params)
     :arguments ((* GtkObject) guint (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:195 <1732> 
;; void gtk_signal_emitv_by_name( GtkObject* object, const gchar* name,
;;   GtkArg
;;   * params);
(ff:bind-c-function gtk_signal_emitv_by_name
     :unconverted-entry-name "gtk_signal_emitv_by_name"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*") ("const" "gchar" "*") ("GtkArg" "*"))
     :c-arg-names (object name params)
     :arguments ((* GtkObject) (* gchar) (* GtkArg))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:199 <1733> 
;; void gtk_signal_handlers_destroy( GtkObject* object);
(ff:bind-c-function gtk_signal_handlers_destroy
     :unconverted-entry-name "gtk_signal_handlers_destroy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkObject" "*"))
     :c-arg-names (object)
     :arguments ((* GtkObject))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtksignal.h:200 <1734> 
;; void gtk_signal_set_funcs( GtkSignalMarshal marshal_func,
;;   GtkSignalDestroy
;;    destroy_func);
(ff:bind-c-function gtk_signal_set_funcs
     :unconverted-entry-name "gtk_signal_set_funcs"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkSignalMarshal") ("GtkSignalDestroy"))
     :c-arg-names (marshal_func destroy_func)
     :arguments (GtkSignalMarshal GtkSignalDestroy)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:49 <1735> 
;; typedef struct _GtkCalendar GtkCalendar;
(ff:bind-c-typedef _GtkCalendar
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCalendar _GtkCalendar)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:50 <1736> 
;; typedef struct _GtkCalendarClass GtkCalendarClass;
(ff:bind-c-typedef _GtkCalendarClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCalendarClass _GtkCalendarClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:52 <1737> 
;; typedef enum {
;;         GTK_CALENDAR_SHOW_HEADING =  0x000000001 LSHIFT  0x000000000,
;;   GTK_CALENDAR_SHOW_DAY_NAMES
;;    =  0x000000001 LSHIFT  0x000000001, GTK_CALENDAR_NO_MONTH_CHANGE =
;;   0x000000001
;;    LSHIFT  0x000000002, GTK_CALENDAR_SHOW_WEEK_NUMBERS =  0x000000001
;;   LSHIFT
;;     0x000000003, GTK_CALENDAR_WEEK_START_MONDAY =  0x000000001 LSHIFT
;;   0x000000004
;;    } GtkCalendarDisplayOptions;
(ff:bind-c-constant GTK_CALENDAR_SHOW_HEADING
                    1) ;;
;;   GTK_CALENDAR_SHOW_HEADING =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_CALENDAR_SHOW_DAY_NAMES
                    2) ;;
;;   GTK_CALENDAR_SHOW_DAY_NAMES =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_CALENDAR_NO_MONTH_CHANGE
                    4) ;;
;;   GTK_CALENDAR_NO_MONTH_CHANGE =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GTK_CALENDAR_SHOW_WEEK_NUMBERS
                    8) ;;
;;   GTK_CALENDAR_SHOW_WEEK_NUMBERS =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GTK_CALENDAR_WEEK_START_MONDAY
                    16) ;;
;;   GTK_CALENDAR_WEEK_START_MONDAY =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-type GtkCalendarDisplayOptions :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:61 <1738> 
;; struct _GtkCalendar {
;;         GtkWidget widget; GtkStyle* header_style; GtkStyle* label_style;
;;   gint
;;    month; gint year; gint selected_day; gint day_month[  0x000000006][
;;   0x000000007
;;   ]; gint day[  0x000000006][  0x000000007]; gint num_marked_dates; gint
;;    marked_date[  0x00000001f]; GtkCalendarDisplayOptions display_flags;
;;   GdkColor
;;    marked_date_color[  0x00000001f]; GdkGC* gc; GdkGC* xor_gc; gint
;;   focus_row;
;;              gint focus_col; gint highlight_row; gint highlight_col;
;;   gpointer private_data;
;;              gchar grow_space[  0x000000020]; };
(ff:bind-c-type _GtkCalendar (:struct
  (widget GtkWidget)   ;; GtkWidget widget
  (header_style (* GtkStyle))   ;; GtkStyle* header_style
  (label_style (* GtkStyle))   ;; GtkStyle* label_style
  (month gint)   ;; gint month
  (year gint)   ;; gint year
  (selected_day gint)   ;; gint selected_day
  (day_month (:array gint 7
              6))   ;;
  ;;  gint day_month[  0x000000006][  0x000000007]
  (day (:array gint 7 6))   ;; gint day[  0x000000006][  0x000000007]
  (num_marked_dates gint)   ;; gint num_marked_dates
  (marked_date (:array gint 31))   ;; gint marked_date[  0x00000001f]
  (display_flags GtkCalendarDisplayOptions)   ;;
  ;;  GtkCalendarDisplayOptions display_flags
  (marked_date_color (:array GdkColor
                      31))   ;;
  ;;  GdkColor marked_date_color[  0x00000001f]
  (gc (* GdkGC))   ;; GdkGC* gc
  (xor_gc (* GdkGC))   ;; GdkGC* xor_gc
  (focus_row gint)   ;; gint focus_row
  (focus_col gint)   ;; gint focus_col
  (highlight_row gint)   ;; gint highlight_row
  (highlight_col gint)   ;; gint highlight_col
  (private_data gpointer)   ;; gpointer private_data
  (grow_space (:array gchar 32))   ;; gchar grow_space[  0x000000020]
  ))   ;; bind-c-type _GtkCalendar

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:93 <1739> 
;; struct _GtkCalendarClass {
;;         GtkWidgetClass parent_class; void(* month_changed)( GtkCalendar*
;;   calendar
;;   ); void(* day_selected)( GtkCalendar* calendar); void(*
;;   day_selected_double_click
;;   )( GtkCalendar* calendar); void(* prev_month)( GtkCalendar* calendar);
;;              void(* next_month)( GtkCalendar* calendar); void(*
;;   prev_year)( GtkCalendar
;;   * calendar); void(* next_year)( GtkCalendar* calendar); };
(ff:bind-c-type _GtkCalendarClass (:struct
  (parent_class GtkWidgetClass)   ;; GtkWidgetClass parent_class
  (month_changed ff:function-pointer)   ;;
  ;;  void(* month_changed)( GtkCalendar* calendar)
  (day_selected ff:function-pointer)   ;;
  ;;  void(* day_selected)( GtkCalendar* calendar)
  (day_selected_double_click ff:function-pointer)   ;;
  ;;  void(* day_selected_double_click)( GtkCalendar* calendar)
  (prev_month ff:function-pointer)   ;;
  ;;  void(* prev_month)( GtkCalendar* calendar)
  (next_month ff:function-pointer)   ;;
  ;;  void(* next_month)( GtkCalendar* calendar)
  (prev_year ff:function-pointer)   ;;
  ;;  void(* prev_year)( GtkCalendar* calendar)
  (next_year ff:function-pointer)   ;;
  ;;  void(* next_year)( GtkCalendar* calendar)
  ))   ;; bind-c-type _GtkCalendarClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:109 <1740> 
;; GtkType gtk_calendar_get_type( void);
(ff:bind-c-function gtk_calendar_get_type
     :unconverted-entry-name "gtk_calendar_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:110 <1741> 
;; GtkWidget* gtk_calendar_new( void);
(ff:bind-c-function gtk_calendar_new
     :unconverted-entry-name "gtk_calendar_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:112 <1742> 
;; gint gtk_calendar_select_month( GtkCalendar* calendar, guint month,
;;   guint
;;    year);
(ff:bind-c-function gtk_calendar_select_month
     :unconverted-entry-name "gtk_calendar_select_month"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCalendar" "*") ("guint") ("guint"))
     :c-arg-names (calendar month year)
     :arguments ((* GtkCalendar) guint guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:115 <1743> 
;; void gtk_calendar_select_day( GtkCalendar* calendar, guint day);
(ff:bind-c-function gtk_calendar_select_day
     :unconverted-entry-name "gtk_calendar_select_day"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCalendar" "*") ("guint"))
     :c-arg-names (calendar day)
     :arguments ((* GtkCalendar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:118 <1744> 
;; gint gtk_calendar_mark_day( GtkCalendar* calendar, guint day);
(ff:bind-c-function gtk_calendar_mark_day
     :unconverted-entry-name "gtk_calendar_mark_day"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCalendar" "*") ("guint"))
     :c-arg-names (calendar day)
     :arguments ((* GtkCalendar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:120 <1745> 
;; gint gtk_calendar_unmark_day( GtkCalendar* calendar, guint day);
(ff:bind-c-function gtk_calendar_unmark_day
     :unconverted-entry-name "gtk_calendar_unmark_day"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCalendar" "*") ("guint"))
     :c-arg-names (calendar day)
     :arguments ((* GtkCalendar) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:122 <1746> 
;; void gtk_calendar_clear_marks( GtkCalendar* calendar);
(ff:bind-c-function gtk_calendar_clear_marks
     :unconverted-entry-name "gtk_calendar_clear_marks"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCalendar" "*"))
     :c-arg-names (calendar)
     :arguments ((* GtkCalendar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:125 <1747> 
;; void gtk_calendar_display_options( GtkCalendar* calendar,
;;   GtkCalendarDisplayOptions
;;    flags);
(ff:bind-c-function gtk_calendar_display_options
     :unconverted-entry-name "gtk_calendar_display_options"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCalendar" "*") ("GtkCalendarDisplayOptions"))
     :c-arg-names (calendar flags)
     :arguments ((* GtkCalendar) GtkCalendarDisplayOptions)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:128 <1748> 
;; void gtk_calendar_get_date( GtkCalendar* calendar, guint* year, guint
;;   * month, guint* day);
(ff:bind-c-function gtk_calendar_get_date
     :unconverted-entry-name "gtk_calendar_get_date"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCalendar" "*") ("guint" "*") ("guint" "*")
                   ("guint" "*"))
     :c-arg-names (calendar year month day)
     :arguments ((* GtkCalendar) (* guint) (* guint) (* guint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:132 <1749> 
;; void gtk_calendar_freeze( GtkCalendar* calendar);
(ff:bind-c-function gtk_calendar_freeze
     :unconverted-entry-name "gtk_calendar_freeze"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCalendar" "*"))
     :c-arg-names (calendar)
     :arguments ((* GtkCalendar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcalendar.h:133 <1750> 
;; void gtk_calendar_thaw( GtkCalendar* calendar);
(ff:bind-c-function gtk_calendar_thaw
     :unconverted-entry-name "gtk_calendar_thaw"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCalendar" "*"))
     :c-arg-names (calendar)
     :arguments ((* GtkCalendar))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:47 <1751> 
;; typedef struct _GtkToggleButton GtkToggleButton;
(ff:bind-c-typedef _GtkToggleButton
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkToggleButton _GtkToggleButton)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:48 <1752> 
;; typedef struct _GtkToggleButtonClass GtkToggleButtonClass;
(ff:bind-c-typedef _GtkToggleButtonClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkToggleButtonClass _GtkToggleButtonClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:50 <1753> 
;; struct _GtkToggleButton {
;;         GtkButton button; guint active:  0x000000001; guint
;;   draw_indicator:  0x000000001;
;;              GdkWindow* event_window; };

;;WARNING: Strange bitfield active type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield draw_indicator type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkToggleButton (:struct
  (button GtkButton)   ;; GtkButton button
  (active (:bit 1))   ;; guint active:  0x000000001
  (draw_indicator (:bit 1))   ;; guint draw_indicator:  0x000000001
  (event_window (* GdkWindow))   ;; GdkWindow* event_window
  ))   ;; bind-c-type _GtkToggleButton

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:60 <1754> 
;; struct _GtkToggleButtonClass {
;;         GtkButtonClass parent_class; void(* toggled)( GtkToggleButton*
;;   toggle_button
;;   ); };
(ff:bind-c-type _GtkToggleButtonClass (:struct
  (parent_class GtkButtonClass)   ;; GtkButtonClass parent_class
  (toggled ff:function-pointer)   ;;
  ;;  void(* toggled)( GtkToggleButton* toggle_button)
  ))   ;; bind-c-type _GtkToggleButtonClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:68 <1755> 
;; GtkType gtk_toggle_button_get_type( void);
(ff:bind-c-function gtk_toggle_button_get_type
     :unconverted-entry-name "gtk_toggle_button_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:69 <1756> 
;; GtkWidget* gtk_toggle_button_new( void);
(ff:bind-c-function gtk_toggle_button_new
     :unconverted-entry-name "gtk_toggle_button_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:70 <1757> 
;; GtkWidget* gtk_toggle_button_new_with_label( const gchar* label);
(ff:bind-c-function gtk_toggle_button_new_with_label
     :unconverted-entry-name "gtk_toggle_button_new_with_label"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (label)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:71 <1758> 
;; void gtk_toggle_button_set_mode( GtkToggleButton* toggle_button,
;;   gboolean
;;    draw_indicator);
(ff:bind-c-function gtk_toggle_button_set_mode
     :unconverted-entry-name "gtk_toggle_button_set_mode"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkToggleButton" "*") ("gboolean"))
     :c-arg-names (toggle_button draw_indicator)
     :arguments ((* GtkToggleButton) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:73 <1759> 
;; void gtk_toggle_button_set_active( GtkToggleButton* toggle_button,
;;   gboolean
;;    is_active);
(ff:bind-c-function gtk_toggle_button_set_active
     :all-names ((gtk_toggle_button_set_state . "gtk_toggle_button_set_state")
                 (gtk_toggle_button_set_active
                  . "gtk_toggle_button_set_active"))
     :unconverted-entry-name "gtk_toggle_button_set_active"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkToggleButton" "*") ("gboolean"))
     :c-arg-names (toggle_button is_active)
     :arguments ((* GtkToggleButton) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:75 <1760> 
;; gboolean gtk_toggle_button_get_active( GtkToggleButton* toggle_button);
(ff:bind-c-function gtk_toggle_button_get_active
     :unconverted-entry-name "gtk_toggle_button_get_active"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkToggleButton" "*"))
     :c-arg-names (toggle_button)
     :arguments ((* GtkToggleButton))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtktogglebutton.h:76 <1761> 
;; void gtk_toggle_button_toggled( GtkToggleButton* toggle_button);
(ff:bind-c-function gtk_toggle_button_toggled
     :unconverted-entry-name "gtk_toggle_button_toggled"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkToggleButton" "*"))
     :c-arg-names (toggle_button)
     :arguments ((* GtkToggleButton))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:47 <1762> 
;; typedef struct _GtkCheckButton GtkCheckButton;
(ff:bind-c-typedef _GtkCheckButton
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCheckButton _GtkCheckButton)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:48 <1763> 
;; typedef struct _GtkCheckButtonClass GtkCheckButtonClass;
(ff:bind-c-typedef _GtkCheckButtonClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCheckButtonClass _GtkCheckButtonClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:50 <1764> 
;; struct _GtkCheckButton { GtkToggleButton toggle_button; };
(ff:bind-c-type _GtkCheckButton (:struct
  (toggle_button GtkToggleButton)   ;; GtkToggleButton toggle_button
  ))   ;; bind-c-type _GtkCheckButton

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:55 <1765> 
;; struct _GtkCheckButtonClass {
;;         GtkToggleButtonClass parent_class; guint16 indicator_size;
;;   guint16 indicator_spacing;
;;              void(* draw_indicator)( GtkCheckButton* check_button,
;;   GdkRectangle* area
;;   ); };
(ff:bind-c-type _GtkCheckButtonClass (:struct
  (parent_class GtkToggleButtonClass)   ;;
  ;;  GtkToggleButtonClass parent_class
  (indicator_size guint16)   ;; guint16 indicator_size
  (indicator_spacing guint16)   ;; guint16 indicator_spacing
  (draw_indicator ff:function-pointer)   ;;
  ;;  void(* draw_indicator)( GtkCheckButton* check_button, GdkRectangle* area)
  ))   ;; bind-c-type _GtkCheckButtonClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:67 <1766> 
;; GtkType gtk_check_button_get_type( void);
(ff:bind-c-function gtk_check_button_get_type
     :unconverted-entry-name "gtk_check_button_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:68 <1767> 
;; GtkWidget* gtk_check_button_new( void);
(ff:bind-c-function gtk_check_button_new
     :unconverted-entry-name "gtk_check_button_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:69 <1768> 
;; GtkWidget* gtk_check_button_new_with_label( const gchar* label);
(ff:bind-c-function gtk_check_button_new_with_label
     :unconverted-entry-name "gtk_check_button_new_with_label"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (label)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckbutton.h:71 <1769> 
;; void _gtk_check_button_get_props( GtkCheckButton* check_button, gint*
;;    indicator_size, gint* indicator_spacing);
(ff:bind-c-function _gtk_check_button_get_props
     :unconverted-entry-name "_gtk_check_button_get_props"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCheckButton" "*") ("gint" "*") ("gint" "*"))
     :c-arg-names (check_button indicator_size indicator_spacing)
     :arguments ((* GtkCheckButton) (* gint) (* gint))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:47 <1770> 
;; typedef struct _GtkItem GtkItem;
(ff:bind-c-typedef _GtkItem ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkItem _GtkItem)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:48 <1771> 
;; typedef struct _GtkItemClass GtkItemClass;
(ff:bind-c-typedef _GtkItemClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkItemClass _GtkItemClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:50 <1772> 
;; struct _GtkItem { GtkBin bin; };
(ff:bind-c-type _GtkItem (:struct
  (bin GtkBin)   ;; GtkBin bin
  ))   ;; bind-c-type _GtkItem

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:55 <1773> 
;; struct _GtkItemClass {
;;         GtkBinClass parent_class; void(* select)( GtkItem* item); void(*
;;   deselect
;;   )( GtkItem* item); void(* toggle)( GtkItem* item); };
(ff:bind-c-type _GtkItemClass (:struct
  (parent_class GtkBinClass)   ;; GtkBinClass parent_class
  (select ff:function-pointer)   ;; void(* select)( GtkItem* item)
  (deselect ff:function-pointer)   ;; void(* deselect)( GtkItem* item)
  (toggle ff:function-pointer)   ;; void(* toggle)( GtkItem* item)
  ))   ;; bind-c-type _GtkItemClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:65 <1774> 
;; GtkType gtk_item_get_type( void);
(ff:bind-c-function gtk_item_get_type
     :unconverted-entry-name "gtk_item_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:66 <1775> 
;; void gtk_item_select( GtkItem* item);
(ff:bind-c-function gtk_item_select
     :unconverted-entry-name "gtk_item_select"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkItem" "*"))
     :c-arg-names (item)
     :arguments ((* GtkItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:67 <1776> 
;; void gtk_item_deselect( GtkItem* item);
(ff:bind-c-function gtk_item_deselect
     :unconverted-entry-name "gtk_item_deselect"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkItem" "*"))
     :c-arg-names (item)
     :arguments ((* GtkItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkitem.h:68 <1777> 
;; void gtk_item_toggle( GtkItem* item);
(ff:bind-c-function gtk_item_toggle
     :unconverted-entry-name "gtk_item_toggle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkItem" "*"))
     :c-arg-names (item)
     :arguments ((* GtkItem))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:47 <1778> 
;; typedef struct _GtkMenuItem GtkMenuItem;
(ff:bind-c-typedef _GtkMenuItem
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkMenuItem _GtkMenuItem)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:48 <1779> 
;; typedef struct _GtkMenuItemClass GtkMenuItemClass;
(ff:bind-c-typedef _GtkMenuItemClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkMenuItemClass _GtkMenuItemClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:50 <1780> 
;; struct _GtkMenuItem {
;;         GtkItem item; GtkWidget* submenu; guint accelerator_signal;
;;   guint16 toggle_size;
;;              guint16 accelerator_width; guint show_toggle_indicator:
;;   0x000000001;
;;              guint show_submenu_indicator:  0x000000001; guint
;;   submenu_placement:  0x000000001;
;;              guint submenu_direction:  0x000000001; guint right_justify:
;;   0x000000001;
;;              guint timer; };

;;WARNING: Strange bitfield show_toggle_indicator type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield show_submenu_indicator type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield submenu_placement type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield submenu_direction type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield right_justify type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkMenuItem (:struct
  (item GtkItem)   ;; GtkItem item
  (submenu (* GtkWidget))   ;; GtkWidget* submenu
  (accelerator_signal guint)   ;; guint accelerator_signal
  (toggle_size guint16)   ;; guint16 toggle_size
  (accelerator_width guint16)   ;; guint16 accelerator_width
  (show_toggle_indicator (:bit
                          1))   ;;
  ;;  guint show_toggle_indicator:  0x000000001
  (show_submenu_indicator (:bit
                           1))   ;;
  ;;  guint show_submenu_indicator:  0x000000001
  (submenu_placement (:bit 1))   ;; guint submenu_placement:  0x000000001
  (submenu_direction (:bit 1))   ;; guint submenu_direction:  0x000000001
  (right_justify (:bit 1))   ;; guint right_justify:  0x000000001
  (timer guint)   ;; guint timer
  ))   ;; bind-c-type _GtkMenuItem

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:68 <1781> 
;; struct _GtkMenuItemClass {
;;         GtkItemClass parent_class; guint toggle_size; guint
;;   hide_on_activate:
;;     0x000000001; void(* activate)( GtkMenuItem* menu_item); void(*
;;   activate_item
;;   )( GtkMenuItem* menu_item); };

;;WARNING: Strange bitfield hide_on_activate type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkMenuItemClass (:struct
  (parent_class GtkItemClass)   ;; GtkItemClass parent_class
  (toggle_size guint)   ;; guint toggle_size
  (hide_on_activate (:bit 1))   ;; guint hide_on_activate:  0x000000001
  (activate ff:function-pointer)   ;;
  ;;  void(* activate)( GtkMenuItem* menu_item)
  (activate_item ff:function-pointer)   ;;
  ;;  void(* activate_item)( GtkMenuItem* menu_item)
  ))   ;; bind-c-type _GtkMenuItemClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:86 <1782> 
;; GtkType gtk_menu_item_get_type( void);
(ff:bind-c-function gtk_menu_item_get_type
     :unconverted-entry-name "gtk_menu_item_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:87 <1783> 
;; GtkWidget* gtk_menu_item_new( void);
(ff:bind-c-function gtk_menu_item_new
     :unconverted-entry-name "gtk_menu_item_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:88 <1784> 
;; GtkWidget* gtk_menu_item_new_with_label( const gchar* label);
(ff:bind-c-function gtk_menu_item_new_with_label
     :unconverted-entry-name "gtk_menu_item_new_with_label"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (label)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:89 <1785> 
;; void gtk_menu_item_set_submenu( GtkMenuItem* menu_item, GtkWidget*
;;   submenu
;;   );
(ff:bind-c-function gtk_menu_item_set_submenu
     :unconverted-entry-name "gtk_menu_item_set_submenu"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*") ("GtkWidget" "*"))
     :c-arg-names (menu_item submenu)
     :arguments ((* GtkMenuItem) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:91 <1786> 
;; void gtk_menu_item_remove_submenu( GtkMenuItem* menu_item);
(ff:bind-c-function gtk_menu_item_remove_submenu
     :unconverted-entry-name "gtk_menu_item_remove_submenu"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*"))
     :c-arg-names (menu_item)
     :arguments ((* GtkMenuItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:92 <1787> 
;; void gtk_menu_item_set_placement( GtkMenuItem* menu_item,
;;   GtkSubmenuPlacement
;;    placement);
(ff:bind-c-function gtk_menu_item_set_placement
     :unconverted-entry-name "gtk_menu_item_set_placement"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*") ("GtkSubmenuPlacement"))
     :c-arg-names (menu_item placement)
     :arguments ((* GtkMenuItem) GtkSubmenuPlacement)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:94 <1788> 
;; void gtk_menu_item_configure( GtkMenuItem* menu_item, gint
;;   show_toggle_indicator,
;;              gint show_submenu_indicator);
(ff:bind-c-function gtk_menu_item_configure
     :unconverted-entry-name "gtk_menu_item_configure"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*") ("gint") ("gint"))
     :c-arg-names (menu_item show_toggle_indicator show_submenu_indicator)
     :arguments ((* GtkMenuItem) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:97 <1789> 
;; void gtk_menu_item_select( GtkMenuItem* menu_item);
(ff:bind-c-function gtk_menu_item_select
     :unconverted-entry-name "gtk_menu_item_select"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*"))
     :c-arg-names (menu_item)
     :arguments ((* GtkMenuItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:98 <1790> 
;; void gtk_menu_item_deselect( GtkMenuItem* menu_item);
(ff:bind-c-function gtk_menu_item_deselect
     :unconverted-entry-name "gtk_menu_item_deselect"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*"))
     :c-arg-names (menu_item)
     :arguments ((* GtkMenuItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:99 <1791> 
;; void gtk_menu_item_activate( GtkMenuItem* menu_item);
(ff:bind-c-function gtk_menu_item_activate
     :unconverted-entry-name "gtk_menu_item_activate"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*"))
     :c-arg-names (menu_item)
     :arguments ((* GtkMenuItem))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkmenuitem.h:100 <1792> 
;; void gtk_menu_item_right_justify( GtkMenuItem* menu_item);
(ff:bind-c-function gtk_menu_item_right_justify
     :unconverted-entry-name "gtk_menu_item_right_justify"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkMenuItem" "*"))
     :c-arg-names (menu_item)
     :arguments ((* GtkMenuItem))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:47 <1793> 
;; typedef struct _GtkCheckMenuItem GtkCheckMenuItem;
(ff:bind-c-typedef _GtkCheckMenuItem
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCheckMenuItem _GtkCheckMenuItem)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:48 <1794> 
;; typedef struct _GtkCheckMenuItemClass GtkCheckMenuItemClass;
(ff:bind-c-typedef _GtkCheckMenuItemClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCheckMenuItemClass _GtkCheckMenuItemClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:50 <1795> 
;; struct _GtkCheckMenuItem {
;;         GtkMenuItem menu_item; guint active:  0x000000001; guint
;;   always_show_toggle
;;   :  0x000000001; };

;;WARNING: Strange bitfield active type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield always_show_toggle type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkCheckMenuItem (:struct
  (menu_item GtkMenuItem)   ;; GtkMenuItem menu_item
  (active (:bit 1))   ;; guint active:  0x000000001
  (always_show_toggle (:bit 1))   ;; guint always_show_toggle:  0x000000001
  ))   ;; bind-c-type _GtkCheckMenuItem

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:58 <1796> 
;; struct _GtkCheckMenuItemClass {
;;         GtkMenuItemClass parent_class; void(* toggled)(
;;   GtkCheckMenuItem* check_menu_item
;;   ); void(* draw_indicator)( GtkCheckMenuItem* check_menu_item,
;;   GdkRectangle
;;   * area); };
(ff:bind-c-type _GtkCheckMenuItemClass (:struct
  (parent_class GtkMenuItemClass)   ;; GtkMenuItemClass parent_class
  (toggled ff:function-pointer)   ;;
  ;;  void(* toggled)( GtkCheckMenuItem* check_menu_item)
  (draw_indicator ff:function-pointer)   ;;
  ;;  void(* draw_indicator)( GtkCheckMenuItem* check_menu_item, GdkRectangle* area
  ;; )
  ))   ;; bind-c-type _GtkCheckMenuItemClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:68 <1797> 
;; GtkType gtk_check_menu_item_get_type( void);
(ff:bind-c-function gtk_check_menu_item_get_type
     :unconverted-entry-name "gtk_check_menu_item_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:69 <1798> 
;; GtkWidget* gtk_check_menu_item_new( void);
(ff:bind-c-function gtk_check_menu_item_new
     :unconverted-entry-name "gtk_check_menu_item_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:70 <1799> 
;; GtkWidget* gtk_check_menu_item_new_with_label( const gchar* label);
(ff:bind-c-function gtk_check_menu_item_new_with_label
     :unconverted-entry-name "gtk_check_menu_item_new_with_label"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("const" "gchar" "*"))
     :c-arg-names (label)
     :arguments ((* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:71 <1800> 
;; void gtk_check_menu_item_set_active( GtkCheckMenuItem* check_menu_item,
;;              gboolean is_active);
(ff:bind-c-function gtk_check_menu_item_set_active
     :all-names ((gtk_check_menu_item_set_state
                  . "gtk_check_menu_item_set_state")
                 (gtk_check_menu_item_set_active
                  . "gtk_check_menu_item_set_active"))
     :unconverted-entry-name "gtk_check_menu_item_set_active"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCheckMenuItem" "*") ("gboolean"))
     :c-arg-names (check_menu_item is_active)
     :arguments ((* GtkCheckMenuItem) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:73 <1801> 
;; void gtk_check_menu_item_set_show_toggle( GtkCheckMenuItem* menu_item,
;;              gboolean always);
(ff:bind-c-function gtk_check_menu_item_set_show_toggle
     :unconverted-entry-name "gtk_check_menu_item_set_show_toggle"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCheckMenuItem" "*") ("gboolean"))
     :c-arg-names (menu_item always)
     :arguments ((* GtkCheckMenuItem) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkcheckmenuitem.h:75 <1802> 
;; void gtk_check_menu_item_toggled( GtkCheckMenuItem* check_menu_item);
(ff:bind-c-function gtk_check_menu_item_toggled
     :unconverted-entry-name "gtk_check_menu_item_toggled"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCheckMenuItem" "*"))
     :c-arg-names (check_menu_item)
     :arguments ((* GtkCheckMenuItem))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:48 <1803> 
;; typedef struct _GtkRange GtkRange;
(ff:bind-c-typedef _GtkRange ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkRange _GtkRange)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:49 <1804> 
;; typedef struct _GtkRangeClass GtkRangeClass;
(ff:bind-c-typedef _GtkRangeClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkRangeClass _GtkRangeClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:51 <1805> 
;; struct _GtkRange {
;;         GtkWidget widget; GdkWindow* trough; GdkWindow* slider;
;;   GdkWindow* step_forw;
;;              GdkWindow* step_back; gint16 x_click_point; gint16
;;   y_click_point; guint8
;;    button; gint8 digits; guint policy:  0x000000002; guint scroll_type:
;;   0x000000003;
;;              guint in_child:  0x000000003; guint click_child:
;;   0x000000003; guint need_timer
;;   :  0x000000001; guint32 timer; gfloat old_value; gfloat old_lower;
;;   gfloat
;;    old_upper; gfloat old_page_size; GtkAdjustment* adjustment; };

;;WARNING: Strange bitfield policy type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield scroll_type type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield in_child type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield click_child type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield need_timer type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkRange (:struct
  (widget GtkWidget)   ;; GtkWidget widget
  (trough (* GdkWindow))   ;; GdkWindow* trough
  (slider (* GdkWindow))   ;; GdkWindow* slider
  (step_forw (* GdkWindow))   ;; GdkWindow* step_forw
  (step_back (* GdkWindow))   ;; GdkWindow* step_back
  (x_click_point gint16)   ;; gint16 x_click_point
  (y_click_point gint16)   ;; gint16 y_click_point
  (button guint8)   ;; guint8 button
  (digits gint8)   ;; gint8 digits
  (policy (:bit 2))   ;; guint policy:  0x000000002
  (scroll_type (:bit 3))   ;; guint scroll_type:  0x000000003
  (in_child (:bit 3))   ;; guint in_child:  0x000000003
  (click_child (:bit 3))   ;; guint click_child:  0x000000003
  (need_timer (:bit 1))   ;; guint need_timer:  0x000000001
  (timer guint32)   ;; guint32 timer
  (old_value gfloat)   ;; gfloat old_value
  (old_lower gfloat)   ;; gfloat old_lower
  (old_upper gfloat)   ;; gfloat old_upper
  (old_page_size gfloat)   ;; gfloat old_page_size
  (adjustment (* GtkAdjustment))   ;; GtkAdjustment* adjustment
  ))   ;; bind-c-type _GtkRange

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:81 <1806> 
;; struct _GtkRangeClass {
;;         GtkWidgetClass parent_class; gint slider_width; gint
;;   stepper_size; gint
;;    stepper_slider_spacing; gint min_slider_size; guint8 trough; guint8
;;   slider;
;;              guint8 step_forw; guint8 step_back; void(*
;;   draw_background)( GtkRange
;;   * range); void(* clear_background)( GtkRange* range); void(*
;;   draw_trough
;;   )( GtkRange* range); void(* draw_slider)( GtkRange* range); void(*
;;   draw_step_forw
;;   )( GtkRange* range); void(* draw_step_back)( GtkRange* range); void(*
;;   slider_update
;;   )( GtkRange* range); gint(* trough_click)( GtkRange* range, gint x,
;;   gint
;;    y, gfloat* jump_perc); gint(* trough_keys)( GtkRange* range,
;;   GdkEventKey
;;   * key, GtkScrollType* scroll, GtkTroughType* trough); void(* motion)(
;;   GtkRange
;;   * range, gint xdelta, gint ydelta); gint(* timer)( GtkRange* range); }
;;   ;
(ff:bind-c-type _GtkRangeClass (:struct
  (parent_class GtkWidgetClass)   ;; GtkWidgetClass parent_class
  (slider_width gint)   ;; gint slider_width
  (stepper_size gint)   ;; gint stepper_size
  (stepper_slider_spacing gint)   ;; gint stepper_slider_spacing
  (min_slider_size gint)   ;; gint min_slider_size
  (trough guint8)   ;; guint8 trough
  (slider guint8)   ;; guint8 slider
  (step_forw guint8)   ;; guint8 step_forw
  (step_back guint8)   ;; guint8 step_back
  (draw_background ff:function-pointer)   ;;
  ;;  void(* draw_background)( GtkRange* range)
  (clear_background ff:function-pointer)   ;;
  ;;  void(* clear_background)( GtkRange* range)
  (draw_trough ff:function-pointer)   ;;
  ;;  void(* draw_trough)( GtkRange* range)
  (draw_slider ff:function-pointer)   ;;
  ;;  void(* draw_slider)( GtkRange* range)
  (draw_step_forw ff:function-pointer)   ;;
  ;;  void(* draw_step_forw)( GtkRange* range)
  (draw_step_back ff:function-pointer)   ;;
  ;;  void(* draw_step_back)( GtkRange* range)
  (slider_update ff:function-pointer)   ;;
  ;;  void(* slider_update)( GtkRange* range)
  (trough_click ff:function-pointer)   ;;
  ;;  gint(* trough_click)( GtkRange* range, gint x, gint y, gfloat* jump_perc)
  (trough_keys ff:function-pointer)   ;;
  ;;  gint(* trough_keys)( GtkRange* range, GdkEventKey* key, GtkScrollType* scroll,
  ;;            GtkTroughType* trough)
  (motion ff:function-pointer)   ;;
  ;;  void(* motion)( GtkRange* range, gint xdelta, gint ydelta)
  (timer ff:function-pointer)   ;; gint(* timer)( GtkRange* range)
  ))   ;; bind-c-type _GtkRangeClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:117 <1807> 
;; GtkType gtk_range_get_type( void);
(ff:bind-c-function gtk_range_get_type
     :unconverted-entry-name "gtk_range_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:118 <1808> 
;; GtkAdjustment* gtk_range_get_adjustment( GtkRange* range);
(ff:bind-c-function gtk_range_get_adjustment
     :unconverted-entry-name "gtk_range_get_adjustment"
     :c-return-type ("GtkAdjustment" "*")
     :return-type (* GtkAdjustment)
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:119 <1809> 
;; void gtk_range_set_update_policy( GtkRange* range, GtkUpdateType
;;   policy);
(ff:bind-c-function gtk_range_set_update_policy
     :unconverted-entry-name "gtk_range_set_update_policy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*") ("GtkUpdateType"))
     :c-arg-names (range policy)
     :arguments ((* GtkRange) GtkUpdateType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:121 <1810> 
;; void gtk_range_set_adjustment( GtkRange* range, GtkAdjustment*
;;   adjustment
;;   );
(ff:bind-c-function gtk_range_set_adjustment
     :unconverted-entry-name "gtk_range_set_adjustment"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*") ("GtkAdjustment" "*"))
     :c-arg-names (range adjustment)
     :arguments ((* GtkRange) (* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:124 <1811> 
;; void gtk_range_draw_background( GtkRange* range);
(ff:bind-c-function gtk_range_draw_background
     :unconverted-entry-name "gtk_range_draw_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:125 <1812> 
;; void gtk_range_clear_background( GtkRange* range);
(ff:bind-c-function gtk_range_clear_background
     :unconverted-entry-name "gtk_range_clear_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:126 <1813> 
;; void gtk_range_draw_trough( GtkRange* range);
(ff:bind-c-function gtk_range_draw_trough
     :unconverted-entry-name "gtk_range_draw_trough"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:127 <1814> 
;; void gtk_range_draw_slider( GtkRange* range);
(ff:bind-c-function gtk_range_draw_slider
     :unconverted-entry-name "gtk_range_draw_slider"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:128 <1815> 
;; void gtk_range_draw_step_forw( GtkRange* range);
(ff:bind-c-function gtk_range_draw_step_forw
     :unconverted-entry-name "gtk_range_draw_step_forw"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:129 <1816> 
;; void gtk_range_draw_step_back( GtkRange* range);
(ff:bind-c-function gtk_range_draw_step_back
     :unconverted-entry-name "gtk_range_draw_step_back"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:130 <1817> 
;; void gtk_range_slider_update( GtkRange* range);
(ff:bind-c-function gtk_range_slider_update
     :unconverted-entry-name "gtk_range_slider_update"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:131 <1818> 
;; gint gtk_range_trough_click( GtkRange* range, gint x, gint y, gfloat*
;;    jump_perc);
(ff:bind-c-function gtk_range_trough_click
     :unconverted-entry-name "gtk_range_trough_click"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkRange" "*") ("gint") ("gint") ("gfloat" "*"))
     :c-arg-names (range x y jump_perc)
     :arguments ((* GtkRange) gint gint (* gfloat))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:136 <1819> 
;; void gtk_range_default_hslider_update( GtkRange* range);
(ff:bind-c-function gtk_range_default_hslider_update
     :unconverted-entry-name "gtk_range_default_hslider_update"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:137 <1820> 
;; void gtk_range_default_vslider_update( GtkRange* range);
(ff:bind-c-function gtk_range_default_vslider_update
     :unconverted-entry-name "gtk_range_default_vslider_update"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*"))
     :c-arg-names (range)
     :arguments ((* GtkRange))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:138 <1821> 
;; gint gtk_range_default_htrough_click( GtkRange* range, gint x, gint y,
;;              gfloat* jump_perc);
(ff:bind-c-function gtk_range_default_htrough_click
     :unconverted-entry-name "gtk_range_default_htrough_click"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkRange" "*") ("gint") ("gint") ("gfloat" "*"))
     :c-arg-names (range x y jump_perc)
     :arguments ((* GtkRange) gint gint (* gfloat))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:142 <1822> 
;; gint gtk_range_default_vtrough_click( GtkRange* range, gint x, gint y,
;;              gfloat* jump_perc);
(ff:bind-c-function gtk_range_default_vtrough_click
     :unconverted-entry-name "gtk_range_default_vtrough_click"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkRange" "*") ("gint") ("gint") ("gfloat" "*"))
     :c-arg-names (range x y jump_perc)
     :arguments ((* GtkRange) gint gint (* gfloat))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:146 <1823> 
;; void gtk_range_default_hmotion( GtkRange* range, gint xdelta, gint
;;   ydelta
;;   );
(ff:bind-c-function gtk_range_default_hmotion
     :unconverted-entry-name "gtk_range_default_hmotion"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*") ("gint") ("gint"))
     :c-arg-names (range xdelta ydelta)
     :arguments ((* GtkRange) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:149 <1824> 
;; void gtk_range_default_vmotion( GtkRange* range, gint xdelta, gint
;;   ydelta
;;   );
(ff:bind-c-function gtk_range_default_vmotion
     :unconverted-entry-name "gtk_range_default_vmotion"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*") ("gint") ("gint"))
     :c-arg-names (range xdelta ydelta)
     :arguments ((* GtkRange) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkrange.h:153 <1825> 
;; void _gtk_range_get_props( GtkRange* range, gint* slider_width, gint*
;;    trough_border, gint* stepper_size, gint* stepper_spacing);
(ff:bind-c-function _gtk_range_get_props
     :unconverted-entry-name "_gtk_range_get_props"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkRange" "*") ("gint" "*") ("gint" "*") ("gint" "*")
                   ("gint" "*"))
     :c-arg-names (range slider_width trough_border stepper_size
                   stepper_spacing)
     :arguments ((* GtkRange) (* gint) (* gint) (* gint) (* gint))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkscrollbar.h:47 <1826> 
;; typedef struct _GtkScrollbar GtkScrollbar;
(ff:bind-c-typedef _GtkScrollbar
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkScrollbar _GtkScrollbar)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkscrollbar.h:48 <1827> 
;; typedef struct _GtkScrollbarClass GtkScrollbarClass;
(ff:bind-c-typedef _GtkScrollbarClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkScrollbarClass _GtkScrollbarClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkscrollbar.h:50 <1828> 
;; struct _GtkScrollbar { GtkRange range; };
(ff:bind-c-type _GtkScrollbar (:struct
  (range GtkRange)   ;; GtkRange range
  ))   ;; bind-c-type _GtkScrollbar

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkscrollbar.h:55 <1829> 
;; struct _GtkScrollbarClass { GtkRangeClass parent_class; };
(ff:bind-c-type _GtkScrollbarClass (:struct
  (parent_class GtkRangeClass)   ;; GtkRangeClass parent_class
  ))   ;; bind-c-type _GtkScrollbarClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkscrollbar.h:61 <1830> 
;; GtkType gtk_scrollbar_get_type( void);
(ff:bind-c-function gtk_scrollbar_get_type
     :unconverted-entry-name "gtk_scrollbar_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkhscrollbar.h:47 <1831> 
;; typedef struct _GtkHScrollbar GtkHScrollbar;
(ff:bind-c-typedef _GtkHScrollbar
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkHScrollbar _GtkHScrollbar)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkhscrollbar.h:48 <1832> 
;; typedef struct _GtkHScrollbarClass GtkHScrollbarClass;
(ff:bind-c-typedef _GtkHScrollbarClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkHScrollbarClass _GtkHScrollbarClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkhscrollbar.h:50 <1833> 
;; struct _GtkHScrollbar { GtkScrollbar scrollbar; };
(ff:bind-c-type _GtkHScrollbar (:struct
  (scrollbar GtkScrollbar)   ;; GtkScrollbar scrollbar
  ))   ;; bind-c-type _GtkHScrollbar

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkhscrollbar.h:55 <1834> 
;; struct _GtkHScrollbarClass { GtkScrollbarClass parent_class; };
(ff:bind-c-type _GtkHScrollbarClass (:struct
  (parent_class GtkScrollbarClass)   ;; GtkScrollbarClass parent_class
  ))   ;; bind-c-type _GtkHScrollbarClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkhscrollbar.h:61 <1835> 
;; GtkType gtk_hscrollbar_get_type( void);
(ff:bind-c-function gtk_hscrollbar_get_type
     :unconverted-entry-name "gtk_hscrollbar_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkhscrollbar.h:62 <1836> 
;; GtkWidget* gtk_hscrollbar_new( GtkAdjustment* adjustment);
(ff:bind-c-function gtk_hscrollbar_new
     :unconverted-entry-name "gtk_hscrollbar_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkAdjustment" "*"))
     :c-arg-names (adjustment)
     :arguments ((* GtkAdjustment))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvscrollbar.h:42 <1837> 
;; typedef struct _GtkVScrollbar GtkVScrollbar;
(ff:bind-c-typedef _GtkVScrollbar
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkVScrollbar _GtkVScrollbar)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvscrollbar.h:43 <1838> 
;; typedef struct _GtkVScrollbarClass GtkVScrollbarClass;
(ff:bind-c-typedef _GtkVScrollbarClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkVScrollbarClass _GtkVScrollbarClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvscrollbar.h:45 <1839> 
;; struct _GtkVScrollbar { GtkScrollbar scrollbar; };
(ff:bind-c-type _GtkVScrollbar (:struct
  (scrollbar GtkScrollbar)   ;; GtkScrollbar scrollbar
  ))   ;; bind-c-type _GtkVScrollbar

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvscrollbar.h:50 <1840> 
;; struct _GtkVScrollbarClass { GtkScrollbarClass parent_class; };
(ff:bind-c-type _GtkVScrollbarClass (:struct
  (parent_class GtkScrollbarClass)   ;; GtkScrollbarClass parent_class
  ))   ;; bind-c-type _GtkVScrollbarClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvscrollbar.h:61 <1841> 
;; GtkType gtk_vscrollbar_get_type( void);
(ff:bind-c-function gtk_vscrollbar_get_type
     :unconverted-entry-name "gtk_vscrollbar_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvscrollbar.h:62 <1842> 
;; GtkWidget* gtk_vscrollbar_new( GtkAdjustment* adjustment);
(ff:bind-c-function gtk_vscrollbar_new
     :unconverted-entry-name "gtk_vscrollbar_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkAdjustment" "*"))
     :c-arg-names (adjustment)
     :arguments ((* GtkAdjustment))
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:45 <1843> 
;; enum {
;;         GTK_CLIST_IN_DRAG =  0x000000001 LSHIFT  0x000000000,
;;   GTK_CLIST_ROW_HEIGHT_SET
;;    =  0x000000001 LSHIFT  0x000000001, GTK_CLIST_SHOW_TITLES =
;;   0x000000001
;;    LSHIFT  0x000000002, GTK_CLIST_CHILD_HAS_FOCUS =  0x000000001 LSHIFT
;;   0x000000003,
;;              GTK_CLIST_ADD_MODE =  0x000000001 LSHIFT  0x000000004,
;;   GTK_CLIST_AUTO_SORT
;;    =  0x000000001 LSHIFT  0x000000005, GTK_CLIST_AUTO_RESIZE_BLOCKED =
;;   0x000000001
;;    LSHIFT  0x000000006, GTK_CLIST_REORDERABLE =  0x000000001 LSHIFT
;;   0x000000007,
;;              GTK_CLIST_USE_DRAG_ICONS =  0x000000001 LSHIFT
;;   0x000000008, GTK_CLIST_DRAW_DRAG_LINE
;;    =  0x000000001 LSHIFT  0x000000009, GTK_CLIST_DRAW_DRAG_RECT =
;;   0x000000001
;;    LSHIFT  0x00000000a };
(ff:bind-c-constant GTK_CLIST_IN_DRAG
                    1) ;;
;;   GTK_CLIST_IN_DRAG =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_CLIST_ROW_HEIGHT_SET
                    2) ;;
;;   GTK_CLIST_ROW_HEIGHT_SET =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_CLIST_SHOW_TITLES
                    4) ;;
;;   GTK_CLIST_SHOW_TITLES =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-constant GTK_CLIST_CHILD_HAS_FOCUS
                    8) ;;
;;   GTK_CLIST_CHILD_HAS_FOCUS =  0x000000001 LSHIFT  0x000000003 
(ff:bind-c-constant GTK_CLIST_ADD_MODE
                    16) ;;
;;   GTK_CLIST_ADD_MODE =  0x000000001 LSHIFT  0x000000004 
(ff:bind-c-constant GTK_CLIST_AUTO_SORT
                    32) ;;
;;   GTK_CLIST_AUTO_SORT =  0x000000001 LSHIFT  0x000000005 
(ff:bind-c-constant GTK_CLIST_AUTO_RESIZE_BLOCKED
                    64) ;;
;;   GTK_CLIST_AUTO_RESIZE_BLOCKED =  0x000000001 LSHIFT  0x000000006 
(ff:bind-c-constant GTK_CLIST_REORDERABLE
                    128) ;;
;;   GTK_CLIST_REORDERABLE =  0x000000001 LSHIFT  0x000000007 
(ff:bind-c-constant GTK_CLIST_USE_DRAG_ICONS
                    256) ;;
;;   GTK_CLIST_USE_DRAG_ICONS =  0x000000001 LSHIFT  0x000000008 
(ff:bind-c-constant GTK_CLIST_DRAW_DRAG_LINE
                    512) ;;
;;   GTK_CLIST_DRAW_DRAG_LINE =  0x000000001 LSHIFT  0x000000009 
(ff:bind-c-constant GTK_CLIST_DRAW_DRAG_RECT
                    1024) ;;
;;   GTK_CLIST_DRAW_DRAG_RECT =  0x000000001 LSHIFT  0x00000000a 

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:60 <1844> 
;; typedef enum {
;;         GTK_CELL_EMPTY, GTK_CELL_TEXT, GTK_CELL_PIXMAP,
;;   GTK_CELL_PIXTEXT, GTK_CELL_WIDGET
;;    } GtkCellType;
(ff:bind-c-constant GTK_CELL_EMPTY 0) ;;  GTK_CELL_EMPTY 
(ff:bind-c-constant GTK_CELL_TEXT 1) ;;  GTK_CELL_TEXT 
(ff:bind-c-constant GTK_CELL_PIXMAP 2) ;;  GTK_CELL_PIXMAP 
(ff:bind-c-constant GTK_CELL_PIXTEXT 3) ;;  GTK_CELL_PIXTEXT 
(ff:bind-c-constant GTK_CELL_WIDGET 4) ;;  GTK_CELL_WIDGET 
(ff:bind-c-type GtkCellType :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:69 <1845> 
;; typedef enum {
;;         GTK_CLIST_DRAG_NONE, GTK_CLIST_DRAG_BEFORE, GTK_CLIST_DRAG_INTO,
;;   GTK_CLIST_DRAG_AFTER
;;    } GtkCListDragPos;
(ff:bind-c-constant GTK_CLIST_DRAG_NONE 0) ;;  GTK_CLIST_DRAG_NONE 
(ff:bind-c-constant GTK_CLIST_DRAG_BEFORE 1) ;;  GTK_CLIST_DRAG_BEFORE 
(ff:bind-c-constant GTK_CLIST_DRAG_INTO 2) ;;  GTK_CLIST_DRAG_INTO 
(ff:bind-c-constant GTK_CLIST_DRAG_AFTER 3) ;;  GTK_CLIST_DRAG_AFTER 
(ff:bind-c-type GtkCListDragPos :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:77 <1846> 
;; typedef enum {
;;         GTK_BUTTON_IGNORED =  0x000000000, GTK_BUTTON_SELECTS =
;;   0x000000001 LSHIFT
;;     0x000000000, GTK_BUTTON_DRAGS =  0x000000001 LSHIFT  0x000000001,
;;   GTK_BUTTON_EXPANDS
;;    =  0x000000001 LSHIFT  0x000000002 } GtkButtonAction;
(ff:bind-c-constant GTK_BUTTON_IGNORED
                    0) ;;
;;   GTK_BUTTON_IGNORED =  0x000000000 
(ff:bind-c-constant GTK_BUTTON_SELECTS
                    1) ;;
;;   GTK_BUTTON_SELECTS =  0x000000001 LSHIFT  0x000000000 
(ff:bind-c-constant GTK_BUTTON_DRAGS
                    2) ;;
;;   GTK_BUTTON_DRAGS =  0x000000001 LSHIFT  0x000000001 
(ff:bind-c-constant GTK_BUTTON_EXPANDS
                    4) ;;
;;   GTK_BUTTON_EXPANDS =  0x000000001 LSHIFT  0x000000002 
(ff:bind-c-type GtkButtonAction :long #+old :int)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:115 <1847> 
;; typedef struct _GtkCList GtkCList;
(ff:bind-c-typedef _GtkCList ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCList _GtkCList)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:116 <1848> 
;; typedef struct _GtkCListClass GtkCListClass;
(ff:bind-c-typedef _GtkCListClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCListClass _GtkCListClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:117 <1849> 
;; typedef struct _GtkCListColumn GtkCListColumn;
(ff:bind-c-typedef _GtkCListColumn
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCListColumn _GtkCListColumn)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:118 <1850> 
;; typedef struct _GtkCListRow GtkCListRow;
(ff:bind-c-typedef _GtkCListRow
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCListRow _GtkCListRow)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:120 <1851> 
;; typedef struct _GtkCell GtkCell;
(ff:bind-c-typedef _GtkCell ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCell _GtkCell)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:121 <1852> 
;; typedef struct _GtkCellText GtkCellText;
(ff:bind-c-typedef _GtkCellText
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCellText _GtkCellText)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:122 <1853> 
;; typedef struct _GtkCellPixmap GtkCellPixmap;
(ff:bind-c-typedef _GtkCellPixmap
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCellPixmap _GtkCellPixmap)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:123 <1854> 
;; typedef struct _GtkCellPixText GtkCellPixText;
(ff:bind-c-typedef _GtkCellPixText
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCellPixText _GtkCellPixText)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:124 <1855> 
;; typedef struct _GtkCellWidget GtkCellWidget;
(ff:bind-c-typedef _GtkCellWidget
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCellWidget _GtkCellWidget)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:126 <1856> 
;; typedef gint(* GtkCListCompareFunc)( GtkCList* clist, gconstpointer
;;   ptr1,
;;              gconstpointer ptr2);
(ff:bind-c-type GtkCListCompareFunc (* gint))  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:130 <1857> 
;; typedef struct _GtkCListCellInfo GtkCListCellInfo;
(ff:bind-c-typedef _GtkCListCellInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCListCellInfo _GtkCListCellInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:131 <1858> 
;; typedef struct _GtkCListDestInfo GtkCListDestInfo;
(ff:bind-c-typedef _GtkCListDestInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkCListDestInfo _GtkCListDestInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:133 <1859> 
;; struct _GtkCListCellInfo { gint row; gint column; };
(ff:bind-c-type _GtkCListCellInfo (:struct
  (row gint)   ;; gint row
  (column gint)   ;; gint column
  ))   ;; bind-c-type _GtkCListCellInfo

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:139 <1860> 
;; struct _GtkCListDestInfo {
;;         GtkCListCellInfo cell; GtkCListDragPos insert_pos; };
(ff:bind-c-type _GtkCListDestInfo (:struct
  (cell GtkCListCellInfo)   ;; GtkCListCellInfo cell
  (insert_pos GtkCListDragPos)   ;; GtkCListDragPos insert_pos
  ))   ;; bind-c-type _GtkCListDestInfo

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:145 <1861> 
;; struct _GtkCList {
;;         GtkContainer container; guint16 flags; GMemChunk* row_mem_chunk;
;;   GMemChunk
;;   * cell_mem_chunk; guint freeze_count; GdkRectangle
;;   internal_allocation;
;;              gint rows; gint row_center_offset; gint row_height; GList*
;;   row_list; GList
;;   * row_list_end; gint columns; GdkRectangle column_title_area;
;;   GdkWindow
;;   * title_window; GtkCListColumn* column; GdkWindow* clist_window; gint
;;   clist_window_width;
;;              gint clist_window_height; gint hoffset; gint voffset;
;;   GtkShadowType shadow_type;
;;              GtkSelectionMode selection_mode; GList* selection; GList*
;;   selection_end;
;;              GList* undo_selection; GList* undo_unselection; gint
;;   undo_anchor; guint8
;;    button_actions[  0x000000005]; guint8 drag_button; GtkCListCellInfo
;;   click_cell;
;;              GtkAdjustment* hadjustment; GtkAdjustment* vadjustment;
;;   GdkGC* xor_gc;
;;              GdkGC* fg_gc; GdkGC* bg_gc; GdkCursor* cursor_drag; gint
;;   x_drag; gint
;;    focus_row; gint anchor; GtkStateType anchor_state; gint drag_pos;
;;   gint
;;    htimer; gint vtimer; GtkSortType sort_type; GtkCListCompareFunc
;;   compare;
;;              gint sort_column; };
(ff:bind-c-type _GtkCList (:struct
  (container GtkContainer)   ;; GtkContainer container
  (flags guint16)   ;; guint16 flags
  (row_mem_chunk (* GMemChunk))   ;; GMemChunk* row_mem_chunk
  (cell_mem_chunk (* GMemChunk))   ;; GMemChunk* cell_mem_chunk
  (freeze_count guint)   ;; guint freeze_count
  (internal_allocation GdkRectangle)   ;; GdkRectangle internal_allocation
  (rows gint)   ;; gint rows
  (row_center_offset gint)   ;; gint row_center_offset
  (row_height gint)   ;; gint row_height
  (row_list (* GList))   ;; GList* row_list
  (row_list_end (* GList))   ;; GList* row_list_end
  (columns gint)   ;; gint columns
  (column_title_area GdkRectangle)   ;; GdkRectangle column_title_area
  (title_window (* GdkWindow))   ;; GdkWindow* title_window
  (column (* GtkCListColumn))   ;; GtkCListColumn* column
  (clist_window (* GdkWindow))   ;; GdkWindow* clist_window
  (clist_window_width gint)   ;; gint clist_window_width
  (clist_window_height gint)   ;; gint clist_window_height
  (hoffset gint)   ;; gint hoffset
  (voffset gint)   ;; gint voffset
  (shadow_type GtkShadowType)   ;; GtkShadowType shadow_type
  (selection_mode GtkSelectionMode)   ;; GtkSelectionMode selection_mode
  (selection (* GList))   ;; GList* selection
  (selection_end (* GList))   ;; GList* selection_end
  (undo_selection (* GList))   ;; GList* undo_selection
  (undo_unselection (* GList))   ;; GList* undo_unselection
  (undo_anchor gint)   ;; gint undo_anchor
  (button_actions (:array guint8 5))   ;;
  ;;  guint8 button_actions[  0x000000005]
  (drag_button guint8)   ;; guint8 drag_button
  (click_cell GtkCListCellInfo)   ;; GtkCListCellInfo click_cell
  (hadjustment (* GtkAdjustment))   ;; GtkAdjustment* hadjustment
  (vadjustment (* GtkAdjustment))   ;; GtkAdjustment* vadjustment
  (xor_gc (* GdkGC))   ;; GdkGC* xor_gc
  (fg_gc (* GdkGC))   ;; GdkGC* fg_gc
  (bg_gc (* GdkGC))   ;; GdkGC* bg_gc
  (cursor_drag (* GdkCursor))   ;; GdkCursor* cursor_drag
  (x_drag gint)   ;; gint x_drag
  (focus_row gint)   ;; gint focus_row
  (anchor gint)   ;; gint anchor
  (anchor_state GtkStateType)   ;; GtkStateType anchor_state
  (drag_pos gint)   ;; gint drag_pos
  (htimer gint)   ;; gint htimer
  (vtimer gint)   ;; gint vtimer
  (sort_type GtkSortType)   ;; GtkSortType sort_type
  (compare GtkCListCompareFunc)   ;; GtkCListCompareFunc compare
  (sort_column gint)   ;; gint sort_column
  ))   ;; bind-c-type _GtkCList

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:240 <1862> 
;; struct _GtkCListClass {
;;         GtkContainerClass parent_class; void(* set_scroll_adjustments)(
;;   GtkCList
;;   * clist, GtkAdjustment* hadjustment, GtkAdjustment* vadjustment); void
;;   (* refresh)( GtkCList* clist); void(* select_row)( GtkCList* clist,
;;   gint
;;    row, gint column, GdkEvent* event); void(* unselect_row)( GtkCList*
;;   clist,
;;              gint row, gint column, GdkEvent* event); void(* row_move)(
;;   GtkCList* clist,
;;              gint source_row, gint dest_row); void(* click_column)(
;;   GtkCList* clist,
;;              gint column); void(* resize_column)( GtkCList* clist, gint
;;   column, gint
;;    width); void(* toggle_focus_row)( GtkCList* clist); void(* select_all
;;   )( GtkCList* clist); void(* unselect_all)( GtkCList* clist); void(*
;;   undo_selection
;;   )( GtkCList* clist); void(* start_selection)( GtkCList* clist); void(*
;;    end_selection)( GtkCList* clist); void(* extend_selection)( GtkCList*
;;    clist, GtkScrollType scroll_type, gfloat position, gboolean
;;   auto_start_selection
;;   ); void(* scroll_horizontal)( GtkCList* clist, GtkScrollType
;;   scroll_type,
;;              gfloat position); void(* scroll_vertical)( GtkCList* clist,
;;   GtkScrollType
;;    scroll_type, gfloat position); void(* toggle_add_mode)( GtkCList*
;;   clist
;;   ); void(* abort_column_resize)( GtkCList* clist); void(*
;;   resync_selection
;;   )( GtkCList* clist, GdkEvent* event); GList*(* selection_find)(
;;   GtkCList
;;   * clist, gint row_number, GList* row_list_element); void(* draw_row)(
;;   GtkCList
;;   * clist, GdkRectangle* area, gint row, GtkCListRow* clist_row); void(*
;;    draw_drag_highlight)( GtkCList* clist, GtkCListRow* target_row, gint
;;   target_row_number,
;;              GtkCListDragPos drag_pos); void(* clear)( GtkCList* clist);
;;   void(* fake_unselect_all
;;   )( GtkCList* clist, gint row); void(* sort_list)( GtkCList* clist);
;;   gint
;;   (* insert_row)( GtkCList* clist, gint row, gchar* text[]); void(*
;;   remove_row
;;   )( GtkCList* clist, gint row); void(* set_cell_contents)( GtkCList*
;;   clist,
;;              GtkCListRow* clist_row, gint column, GtkCellType type,
;;   const gchar* text,
;;              guint8 spacing, GdkPixmap* pixmap, GdkBitmap* mask); void(*
;;   cell_size_request
;;   )( GtkCList* clist, GtkCListRow* clist_row, gint column,
;;   GtkRequisition
;;   * requisition); };
(ff:bind-c-type _GtkCListClass (:struct
  (parent_class GtkContainerClass)   ;; GtkContainerClass parent_class
  (set_scroll_adjustments ff:function-pointer)   ;;
  ;;  void(* set_scroll_adjustments)( GtkCList* clist, GtkAdjustment* hadjustment,
  ;;            GtkAdjustment* vadjustment)
  (refresh ff:function-pointer)   ;; void(* refresh)( GtkCList* clist)
  (select_row ff:function-pointer)   ;;
  ;;  void(* select_row)( GtkCList* clist, gint row, gint column, GdkEvent* event
  ;; )
  (unselect_row ff:function-pointer)   ;;
  ;;  void(* unselect_row)( GtkCList* clist, gint row, gint column, GdkEvent* event
  ;; )
  (row_move ff:function-pointer)   ;;
  ;;  void(* row_move)( GtkCList* clist, gint source_row, gint dest_row)
  (click_column ff:function-pointer)   ;;
  ;;  void(* click_column)( GtkCList* clist, gint column)
  (resize_column ff:function-pointer)   ;;
  ;;  void(* resize_column)( GtkCList* clist, gint column, gint width)
  (toggle_focus_row ff:function-pointer)   ;;
  ;;  void(* toggle_focus_row)( GtkCList* clist)
  (select_all ff:function-pointer)   ;;
  ;;  void(* select_all)( GtkCList* clist)
  (unselect_all ff:function-pointer)   ;;
  ;;  void(* unselect_all)( GtkCList* clist)
  (undo_selection ff:function-pointer)   ;;
  ;;  void(* undo_selection)( GtkCList* clist)
  (start_selection ff:function-pointer)   ;;
  ;;  void(* start_selection)( GtkCList* clist)
  (end_selection ff:function-pointer)   ;;
  ;;  void(* end_selection)( GtkCList* clist)
  (extend_selection ff:function-pointer)   ;;
  ;;  void(* extend_selection)( GtkCList* clist, GtkScrollType scroll_type, gfloat
  ;;  position, gboolean auto_start_selection)
  (scroll_horizontal ff:function-pointer)   ;;
  ;;  void(* scroll_horizontal)( GtkCList* clist, GtkScrollType scroll_type, gfloat
  ;;  position)
  (scroll_vertical ff:function-pointer)   ;;
  ;;  void(* scroll_vertical)( GtkCList* clist, GtkScrollType scroll_type, gfloat
  ;;  position)
  (toggle_add_mode ff:function-pointer)   ;;
  ;;  void(* toggle_add_mode)( GtkCList* clist)
  (abort_column_resize ff:function-pointer)   ;;
  ;;  void(* abort_column_resize)( GtkCList* clist)
  (resync_selection ff:function-pointer)   ;;
  ;;  void(* resync_selection)( GtkCList* clist, GdkEvent* event)
  (selection_find ff:function-pointer)   ;;
  ;;  GList*(* selection_find)( GtkCList* clist, gint row_number, GList* row_list_element
  ;; )
  (draw_row ff:function-pointer)   ;;
  ;;  void(* draw_row)( GtkCList* clist, GdkRectangle* area, gint row, GtkCListRow
  ;; * clist_row)
  (draw_drag_highlight ff:function-pointer)   ;;
  ;;  void(* draw_drag_highlight)( GtkCList* clist, GtkCListRow* target_row, gint
  ;;  target_row_number, GtkCListDragPos drag_pos)
  (clear ff:function-pointer)   ;; void(* clear)( GtkCList* clist)
  (fake_unselect_all ff:function-pointer)   ;;
  ;;  void(* fake_unselect_all)( GtkCList* clist, gint row)
  (sort_list ff:function-pointer)   ;; void(* sort_list)( GtkCList* clist)
  (insert_row ff:function-pointer)   ;;
  ;;  gint(* insert_row)( GtkCList* clist, gint row, gchar* text[])
  (remove_row ff:function-pointer)   ;;
  ;;  void(* remove_row)( GtkCList* clist, gint row)
  (set_cell_contents ff:function-pointer)   ;;
  ;;  void(* set_cell_contents)( GtkCList* clist, GtkCListRow* clist_row, gint column,
  ;;            GtkCellType type, const gchar* text, guint8 spacing, GdkPixmap* pixmap,
  ;;            GdkBitmap* mask)
  (cell_size_request ff:function-pointer)   ;;
  ;;  void(* cell_size_request)( GtkCList* clist, GtkCListRow* clist_row, gint column,
  ;;            GtkRequisition* requisition)
  ))   ;; bind-c-type _GtkCListClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:319 <1863> 
;; struct _GtkCListColumn {
;;         gchar* title; GdkRectangle area; GtkWidget* button; GdkWindow*
;;   window;
;;              gint width; gint min_width; gint max_width;
;;   GtkJustification justification;
;;              guint visible:  0x000000001; guint width_set:  0x000000001;
;;   guint resizeable
;;   :  0x000000001; guint auto_resize:  0x000000001; guint button_passive:
;;     0x000000001; };

;;WARNING: Strange bitfield visible type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield width_set type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield resizeable type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield auto_resize type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield button_passive type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkCListColumn (:struct
  (title (* gchar))   ;; gchar* title
  (area GdkRectangle)   ;; GdkRectangle area
  (button (* GtkWidget))   ;; GtkWidget* button
  (window (* GdkWindow))   ;; GdkWindow* window
  (width gint)   ;; gint width
  (min_width gint)   ;; gint min_width
  (max_width gint)   ;; gint max_width
  (justification GtkJustification)   ;; GtkJustification justification
  (visible (:bit 1))   ;; guint visible:  0x000000001
  (width_set (:bit 1))   ;; guint width_set:  0x000000001
  (resizeable (:bit 1))   ;; guint resizeable:  0x000000001
  (auto_resize (:bit 1))   ;; guint auto_resize:  0x000000001
  (button_passive (:bit 1))   ;; guint button_passive:  0x000000001
  ))   ;; bind-c-type _GtkCListColumn

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:339 <1864> 
;; struct _GtkCListRow {
;;         GtkCell* cell; GtkStateType state; GdkColor foreground; GdkColor
;;   background;
;;              GtkStyle* style; gpointer data; GtkDestroyNotify destroy;
;;   guint fg_set
;;   :  0x000000001; guint bg_set:  0x000000001; guint selectable:
;;   0x000000001;
;;    };

;;WARNING: Strange bitfield fg_set type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield bg_set type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield selectable type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkCListRow (:struct
  (cell (* GtkCell))   ;; GtkCell* cell
  (state GtkStateType)   ;; GtkStateType state
  (foreground GdkColor)   ;; GdkColor foreground
  (background GdkColor)   ;; GdkColor background
  (style (* GtkStyle))   ;; GtkStyle* style
  (data gpointer)   ;; gpointer data
  (destroy GtkDestroyNotify)   ;; GtkDestroyNotify destroy
  (fg_set (:bit 1))   ;; guint fg_set:  0x000000001
  (bg_set (:bit 1))   ;; guint bg_set:  0x000000001
  (selectable (:bit 1))   ;; guint selectable:  0x000000001
  ))   ;; bind-c-type _GtkCListRow

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:358 <1865> 
;; struct _GtkCellText {
;;         GtkCellType type; gint16 vertical; gint16 horizontal; GtkStyle*
;;   style;
;;              gchar* text; };
(ff:bind-c-type _GtkCellText (:struct
  (type GtkCellType)   ;; GtkCellType type
  (vertical gint16)   ;; gint16 vertical
  (horizontal gint16)   ;; gint16 horizontal
  (style (* GtkStyle))   ;; GtkStyle* style
  (text (* gchar))   ;; gchar* text
  ))   ;; bind-c-type _GtkCellText

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:370 <1866> 
;; struct _GtkCellPixmap {
;;         GtkCellType type; gint16 vertical; gint16 horizontal; GtkStyle*
;;   style;
;;              GdkPixmap* pixmap; GdkBitmap* mask; };
(ff:bind-c-type _GtkCellPixmap (:struct
  (type GtkCellType)   ;; GtkCellType type
  (vertical gint16)   ;; gint16 vertical
  (horizontal gint16)   ;; gint16 horizontal
  (style (* GtkStyle))   ;; GtkStyle* style
  (pixmap (* GdkPixmap))   ;; GdkPixmap* pixmap
  (mask (* GdkBitmap))   ;; GdkBitmap* mask
  ))   ;; bind-c-type _GtkCellPixmap

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:383 <1867> 
;; struct _GtkCellPixText {
;;         GtkCellType type; gint16 vertical; gint16 horizontal; GtkStyle*
;;   style;
;;              gchar* text; guint8 spacing; GdkPixmap* pixmap; GdkBitmap*
;;   mask; };
(ff:bind-c-type _GtkCellPixText (:struct
  (type GtkCellType)   ;; GtkCellType type
  (vertical gint16)   ;; gint16 vertical
  (horizontal gint16)   ;; gint16 horizontal
  (style (* GtkStyle))   ;; GtkStyle* style
  (text (* gchar))   ;; gchar* text
  (spacing guint8)   ;; guint8 spacing
  (pixmap (* GdkPixmap))   ;; GdkPixmap* pixmap
  (mask (* GdkBitmap))   ;; GdkBitmap* mask
  ))   ;; bind-c-type _GtkCellPixText

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:398 <1868> 
;; struct _GtkCellWidget {
;;         GtkCellType type; gint16 vertical; gint16 horizontal; GtkStyle*
;;   style;
;;              GtkWidget* widget; };
(ff:bind-c-type _GtkCellWidget (:struct
  (type GtkCellType)   ;; GtkCellType type
  (vertical gint16)   ;; gint16 vertical
  (horizontal gint16)   ;; gint16 horizontal
  (style (* GtkStyle))   ;; GtkStyle* style
  (widget (* GtkWidget))   ;; GtkWidget* widget
  ))   ;; bind-c-type _GtkCellWidget

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:410 <1869> 
;; struct _GtkCell {
;;         GtkCellType type; gint16 vertical; gint16 horizontal; GtkStyle*
;;   style;
;;              union {
;;         gchar* text; struct {
;;         GdkPixmap* pixmap; GdkBitmap* mask; } pm; struct {
;;         gchar* text; guint8 spacing; GdkPixmap* pixmap; GdkBitmap* mask;
;;   } pt;
;;              GtkWidget* widget; } u; };
(ff:bind-c-type _GtkCell (:struct
  (type GtkCellType)   ;; GtkCellType type
  (vertical gint16)   ;; gint16 vertical
  (horizontal gint16)   ;; gint16 horizontal
  (style (* GtkStyle))   ;; GtkStyle* style
  (u (:union   ;; union{} u
    (text (* gchar))   ;; gchar* text
    (pm (:struct   ;; struct{} pm
      (pixmap (* GdkPixmap))   ;; GdkPixmap* pixmap
      (mask (* GdkBitmap))   ;; GdkBitmap* mask
      ))  ;; slot pm
    (pt (:struct   ;; struct{} pt
      (text (* gchar))   ;; gchar* text
      (spacing guint8)   ;; guint8 spacing
      (pixmap (* GdkPixmap))   ;; GdkPixmap* pixmap
      (mask (* GdkBitmap))   ;; GdkBitmap* mask
      ))  ;; slot pt
    (widget (* GtkWidget))   ;; GtkWidget* widget
    ))  ;; slot u
  ))   ;; bind-c-type _GtkCell

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:438 <1870> 
;; GtkType gtk_clist_get_type( void);
(ff:bind-c-function gtk_clist_get_type
     :unconverted-entry-name "gtk_clist_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:441 <1871> 
;; void gtk_clist_construct( GtkCList* clist, gint columns, gchar* titles
;;   []);
(ff:bind-c-function gtk_clist_construct
     :unconverted-entry-name "gtk_clist_construct"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gchar" "*" "[" "]"))
     :c-arg-names (clist columns titles)
     :arguments ((* GtkCList) gint (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:446 <1872> 
;; GtkWidget* gtk_clist_new( gint columns);
(ff:bind-c-function gtk_clist_new
     :unconverted-entry-name "gtk_clist_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("gint"))
     :c-arg-names (columns)
     :arguments (gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:447 <1873> 
;; GtkWidget* gtk_clist_new_with_titles( gint columns, gchar* titles[]);
(ff:bind-c-function gtk_clist_new_with_titles
     :unconverted-entry-name "gtk_clist_new_with_titles"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("gint") ("gchar" "*" "[" "]"))
     :c-arg-names (columns titles)
     :arguments (gint (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:451 <1874> 
;; void gtk_clist_set_hadjustment( GtkCList* clist, GtkAdjustment*
;;   adjustment
;;   );
(ff:bind-c-function gtk_clist_set_hadjustment
     :unconverted-entry-name "gtk_clist_set_hadjustment"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("GtkAdjustment" "*"))
     :c-arg-names (clist adjustment)
     :arguments ((* GtkCList) (* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:453 <1875> 
;; void gtk_clist_set_vadjustment( GtkCList* clist, GtkAdjustment*
;;   adjustment
;;   );
(ff:bind-c-function gtk_clist_set_vadjustment
     :unconverted-entry-name "gtk_clist_set_vadjustment"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("GtkAdjustment" "*"))
     :c-arg-names (clist adjustment)
     :arguments ((* GtkCList) (* GtkAdjustment))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:457 <1876> 
;; GtkAdjustment* gtk_clist_get_hadjustment( GtkCList* clist);
(ff:bind-c-function gtk_clist_get_hadjustment
     :unconverted-entry-name "gtk_clist_get_hadjustment"
     :c-return-type ("GtkAdjustment" "*")
     :return-type (* GtkAdjustment)
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:458 <1877> 
;; GtkAdjustment* gtk_clist_get_vadjustment( GtkCList* clist);
(ff:bind-c-function gtk_clist_get_vadjustment
     :unconverted-entry-name "gtk_clist_get_vadjustment"
     :c-return-type ("GtkAdjustment" "*")
     :return-type (* GtkAdjustment)
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:461 <1878> 
;; void gtk_clist_set_shadow_type( GtkCList* clist, GtkShadowType type);
(ff:bind-c-function gtk_clist_set_shadow_type
     :unconverted-entry-name "gtk_clist_set_shadow_type"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("GtkShadowType"))
     :c-arg-names (clist type)
     :arguments ((* GtkCList) GtkShadowType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:465 <1879> 
;; void gtk_clist_set_selection_mode( GtkCList* clist, GtkSelectionMode
;;   mode
;;   );
(ff:bind-c-function gtk_clist_set_selection_mode
     :unconverted-entry-name "gtk_clist_set_selection_mode"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("GtkSelectionMode"))
     :c-arg-names (clist mode)
     :arguments ((* GtkCList) GtkSelectionMode)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:469 <1880> 
;; void gtk_clist_set_reorderable( GtkCList* clist, gboolean reorderable);
(ff:bind-c-function gtk_clist_set_reorderable
     :unconverted-entry-name "gtk_clist_set_reorderable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gboolean"))
     :c-arg-names (clist reorderable)
     :arguments ((* GtkCList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:471 <1881> 
;; void gtk_clist_set_use_drag_icons( GtkCList* clist, gboolean use_icons);
(ff:bind-c-function gtk_clist_set_use_drag_icons
     :unconverted-entry-name "gtk_clist_set_use_drag_icons"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gboolean"))
     :c-arg-names (clist use_icons)
     :arguments ((* GtkCList) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:473 <1882> 
;; void gtk_clist_set_button_actions( GtkCList* clist, guint button, guint8
;;    button_actions);
(ff:bind-c-function gtk_clist_set_button_actions
     :unconverted-entry-name "gtk_clist_set_button_actions"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("guint") ("guint8"))
     :c-arg-names (clist button button_actions)
     :arguments ((* GtkCList) guint guint8)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:481 <1883> 
;; void gtk_clist_freeze( GtkCList* clist);
(ff:bind-c-function gtk_clist_freeze
     :unconverted-entry-name "gtk_clist_freeze"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:482 <1884> 
;; void gtk_clist_thaw( GtkCList* clist);
(ff:bind-c-function gtk_clist_thaw
     :unconverted-entry-name "gtk_clist_thaw"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:485 <1885> 
;; void gtk_clist_column_titles_show( GtkCList* clist);
(ff:bind-c-function gtk_clist_column_titles_show
     :unconverted-entry-name "gtk_clist_column_titles_show"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:486 <1886> 
;; void gtk_clist_column_titles_hide( GtkCList* clist);
(ff:bind-c-function gtk_clist_column_titles_hide
     :unconverted-entry-name "gtk_clist_column_titles_hide"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:492 <1887> 
;; void gtk_clist_column_title_active( GtkCList* clist, gint column);
(ff:bind-c-function gtk_clist_column_title_active
     :unconverted-entry-name "gtk_clist_column_title_active"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist column)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:494 <1888> 
;; void gtk_clist_column_title_passive( GtkCList* clist, gint column);
(ff:bind-c-function gtk_clist_column_title_passive
     :unconverted-entry-name "gtk_clist_column_title_passive"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist column)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:496 <1889> 
;; void gtk_clist_column_titles_active( GtkCList* clist);
(ff:bind-c-function gtk_clist_column_titles_active
     :unconverted-entry-name "gtk_clist_column_titles_active"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:497 <1890> 
;; void gtk_clist_column_titles_passive( GtkCList* clist);
(ff:bind-c-function gtk_clist_column_titles_passive
     :unconverted-entry-name "gtk_clist_column_titles_passive"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:500 <1891> 
;; void gtk_clist_set_column_title( GtkCList* clist, gint column, const
;;   gchar
;;   * title);
(ff:bind-c-function gtk_clist_set_column_title
     :unconverted-entry-name "gtk_clist_set_column_title"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("const" "gchar" "*"))
     :c-arg-names (clist column title)
     :arguments ((* GtkCList) gint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:505 <1892> 
;; gchar* gtk_clist_get_column_title( GtkCList* clist, gint column);
(ff:bind-c-function gtk_clist_get_column_title
     :unconverted-entry-name "gtk_clist_get_column_title"
     :c-return-type ("gchar" "*")
     :return-type (* gchar)
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist column)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:509 <1893> 
;; void gtk_clist_set_column_widget( GtkCList* clist, gint column,
;;   GtkWidget
;;   * widget);
(ff:bind-c-function gtk_clist_set_column_widget
     :unconverted-entry-name "gtk_clist_set_column_widget"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("GtkWidget" "*"))
     :c-arg-names (clist column widget)
     :arguments ((* GtkCList) gint (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:514 <1894> 
;; GtkWidget* gtk_clist_get_column_widget( GtkCList* clist, gint column);
(ff:bind-c-function gtk_clist_get_column_widget
     :unconverted-entry-name "gtk_clist_get_column_widget"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist column)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:518 <1895> 
;; void gtk_clist_set_column_justification( GtkCList* clist, gint column,
;;              GtkJustification justification);
(ff:bind-c-function gtk_clist_set_column_justification
     :unconverted-entry-name "gtk_clist_set_column_justification"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("GtkJustification"))
     :c-arg-names (clist column justification)
     :arguments ((* GtkCList) gint GtkJustification)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:523 <1896> 
;; void gtk_clist_set_column_visibility( GtkCList* clist, gint column,
;;   gboolean
;;    visible);
(ff:bind-c-function gtk_clist_set_column_visibility
     :unconverted-entry-name "gtk_clist_set_column_visibility"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gboolean"))
     :c-arg-names (clist column visible)
     :arguments ((* GtkCList) gint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:528 <1897> 
;; void gtk_clist_set_column_resizeable( GtkCList* clist, gint column,
;;   gboolean
;;    resizeable);
(ff:bind-c-function gtk_clist_set_column_resizeable
     :unconverted-entry-name "gtk_clist_set_column_resizeable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gboolean"))
     :c-arg-names (clist column resizeable)
     :arguments ((* GtkCList) gint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:533 <1898> 
;; void gtk_clist_set_column_auto_resize( GtkCList* clist, gint column,
;;   gboolean
;;    auto_resize);
(ff:bind-c-function gtk_clist_set_column_auto_resize
     :unconverted-entry-name "gtk_clist_set_column_auto_resize"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gboolean"))
     :c-arg-names (clist column auto_resize)
     :arguments ((* GtkCList) gint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:537 <1899> 
;; gint gtk_clist_columns_autosize( GtkCList* clist);
(ff:bind-c-function gtk_clist_columns_autosize
     :unconverted-entry-name "gtk_clist_columns_autosize"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:540 <1900> 
;; gint gtk_clist_optimal_column_width( GtkCList* clist, gint column);
(ff:bind-c-function gtk_clist_optimal_column_width
     :unconverted-entry-name "gtk_clist_optimal_column_width"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist column)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:547 <1901> 
;; void gtk_clist_set_column_width( GtkCList* clist, gint column, gint
;;   width
;;   );
(ff:bind-c-function gtk_clist_set_column_width
     :unconverted-entry-name "gtk_clist_set_column_width"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist column width)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:552 <1902> 
;; void gtk_clist_set_column_min_width( GtkCList* clist, gint column, gint
;;    min_width);
(ff:bind-c-function gtk_clist_set_column_min_width
     :unconverted-entry-name "gtk_clist_set_column_min_width"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist column min_width)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:555 <1903> 
;; void gtk_clist_set_column_max_width( GtkCList* clist, gint column, gint
;;    max_width);
(ff:bind-c-function gtk_clist_set_column_max_width
     :unconverted-entry-name "gtk_clist_set_column_max_width"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist column max_width)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:562 <1904> 
;; void gtk_clist_set_row_height( GtkCList* clist, guint height);
(ff:bind-c-function gtk_clist_set_row_height
     :unconverted-entry-name "gtk_clist_set_row_height"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("guint"))
     :c-arg-names (clist height)
     :arguments ((* GtkCList) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:570 <1905> 
;; void gtk_clist_moveto( GtkCList* clist, gint row, gint column, gfloat
;;    row_align, gfloat col_align);
(ff:bind-c-function gtk_clist_moveto
     :unconverted-entry-name "gtk_clist_moveto"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("gfloat") ("gfloat"))
     :c-arg-names (clist row column row_align col_align)
     :arguments ((* GtkCList) gint gint gfloat gfloat)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:577 <1906> 
;; GtkVisibility gtk_clist_row_is_visible( GtkCList* clist, gint row);
(ff:bind-c-function gtk_clist_row_is_visible
     :unconverted-entry-name "gtk_clist_row_is_visible"
     :c-return-type ("GtkVisibility")
     :return-type GtkVisibility
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist row)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:581 <1907> 
;; GtkCellType gtk_clist_get_cell_type( GtkCList* clist, gint row, gint
;;   column
;;   );
(ff:bind-c-function gtk_clist_get_cell_type
     :unconverted-entry-name "gtk_clist_get_cell_type"
     :c-return-type ("GtkCellType")
     :return-type GtkCellType
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist row column)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:586 <1908> 
;; void gtk_clist_set_text( GtkCList* clist, gint row, gint column, const
;;    gchar* text);
(ff:bind-c-function gtk_clist_set_text
     :unconverted-entry-name "gtk_clist_set_text"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("const" "gchar" "*"))
     :c-arg-names (clist row column text)
     :arguments ((* GtkCList) gint gint (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:594 <1909> 
;; gint gtk_clist_get_text( GtkCList* clist, gint row, gint column, gchar
;;   ** text);
(ff:bind-c-function gtk_clist_get_text
     :unconverted-entry-name "gtk_clist_get_text"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("gchar" "*" "*"))
     :c-arg-names (clist row column text)
     :arguments ((* GtkCList) gint gint (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:600 <1910> 
;; void gtk_clist_set_pixmap( GtkCList* clist, gint row, gint column,
;;   GdkPixmap
;;   * pixmap, GdkBitmap* mask);
(ff:bind-c-function gtk_clist_set_pixmap
     :unconverted-entry-name "gtk_clist_set_pixmap"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("GdkPixmap" "*")
                   ("GdkBitmap" "*"))
     :c-arg-names (clist row column pixmap mask)
     :arguments ((* GtkCList) gint gint (* GdkPixmap) (* GdkBitmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:606 <1911> 
;; gint gtk_clist_get_pixmap( GtkCList* clist, gint row, gint column,
;;   GdkPixmap
;;   ** pixmap, GdkBitmap** mask);
(ff:bind-c-function gtk_clist_get_pixmap
     :unconverted-entry-name "gtk_clist_get_pixmap"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("GdkPixmap" "*" "*")
                   ("GdkBitmap" "*" "*"))
     :c-arg-names (clist row column pixmap mask)
     :arguments ((* GtkCList) gint gint (* (* GdkPixmap)) (* (* GdkBitmap)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:613 <1912> 
;; void gtk_clist_set_pixtext( GtkCList* clist, gint row, gint column,
;;   const
;;    gchar* text, guint8 spacing, GdkPixmap* pixmap, GdkBitmap* mask);
(ff:bind-c-function gtk_clist_set_pixtext
     :unconverted-entry-name "gtk_clist_set_pixtext"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("const" "gchar" "*")
                   ("guint8") ("GdkPixmap" "*") ("GdkBitmap" "*"))
     :c-arg-names (clist row column text spacing pixmap mask)
     :arguments ((* GtkCList) gint gint (* gchar) guint8 (* GdkPixmap)
                 (* GdkBitmap))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:621 <1913> 
;; gint gtk_clist_get_pixtext( GtkCList* clist, gint row, gint column,
;;   gchar
;;   ** text, guint8* spacing, GdkPixmap** pixmap, GdkBitmap** mask);
(ff:bind-c-function gtk_clist_get_pixtext
     :unconverted-entry-name "gtk_clist_get_pixtext"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("gchar" "*" "*")
                   ("guint8" "*") ("GdkPixmap" "*" "*") ("GdkBitmap" "*" "*"))
     :c-arg-names (clist row column text spacing pixmap mask)
     :arguments ((* GtkCList) gint gint (* (* gchar)) (* guint8)
                 (* (* GdkPixmap)) (* (* GdkBitmap)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:632 <1914> 
;; void gtk_clist_set_foreground( GtkCList* clist, gint row, GdkColor*
;;   color
;;   );
(ff:bind-c-function gtk_clist_set_foreground
     :unconverted-entry-name "gtk_clist_set_foreground"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("GdkColor" "*"))
     :c-arg-names (clist row color)
     :arguments ((* GtkCList) gint (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:639 <1915> 
;; void gtk_clist_set_background( GtkCList* clist, gint row, GdkColor*
;;   color
;;   );
(ff:bind-c-function gtk_clist_set_background
     :unconverted-entry-name "gtk_clist_set_background"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("GdkColor" "*"))
     :c-arg-names (clist row color)
     :arguments ((* GtkCList) gint (* GdkColor))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:644 <1916> 
;; void gtk_clist_set_cell_style( GtkCList* clist, gint row, gint column,
;;              GtkStyle* style);
(ff:bind-c-function gtk_clist_set_cell_style
     :unconverted-entry-name "gtk_clist_set_cell_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("GtkStyle" "*"))
     :c-arg-names (clist row column style)
     :arguments ((* GtkCList) gint gint (* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:649 <1917> 
;; GtkStyle* gtk_clist_get_cell_style( GtkCList* clist, gint row, gint
;;   column
;;   );
(ff:bind-c-function gtk_clist_get_cell_style
     :unconverted-entry-name "gtk_clist_get_cell_style"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist row column)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:653 <1918> 
;; void gtk_clist_set_row_style( GtkCList* clist, gint row, GtkStyle* style
;;   );
(ff:bind-c-function gtk_clist_set_row_style
     :unconverted-entry-name "gtk_clist_set_row_style"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("GtkStyle" "*"))
     :c-arg-names (clist row style)
     :arguments ((* GtkCList) gint (* GtkStyle))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:657 <1919> 
;; GtkStyle* gtk_clist_get_row_style( GtkCList* clist, gint row);
(ff:bind-c-function gtk_clist_get_row_style
     :unconverted-entry-name "gtk_clist_get_row_style"
     :c-return-type ("GtkStyle" "*")
     :return-type (* GtkStyle)
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist row)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:664 <1920> 
;; void gtk_clist_set_shift( GtkCList* clist, gint row, gint column, gint
;;    vertical, gint horizontal);
(ff:bind-c-function gtk_clist_set_shift
     :unconverted-entry-name "gtk_clist_set_shift"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("gint") ("gint"))
     :c-arg-names (clist row column vertical horizontal)
     :arguments ((* GtkCList) gint gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:671 <1921> 
;; void gtk_clist_set_selectable( GtkCList* clist, gint row, gboolean
;;   selectable
;;   );
(ff:bind-c-function gtk_clist_set_selectable
     :unconverted-entry-name "gtk_clist_set_selectable"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gboolean"))
     :c-arg-names (clist row selectable)
     :arguments ((* GtkCList) gint gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:674 <1922> 
;; gboolean gtk_clist_get_selectable( GtkCList* clist, gint row);
(ff:bind-c-function gtk_clist_get_selectable
     :unconverted-entry-name "gtk_clist_get_selectable"
     :c-return-type ("gboolean")
     :return-type gboolean
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist row)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:680 <1923> 
;; gint gtk_clist_prepend( GtkCList* clist, gchar* text[]);
(ff:bind-c-function gtk_clist_prepend
     :unconverted-entry-name "gtk_clist_prepend"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gchar" "*" "[" "]"))
     :c-arg-names (clist text)
     :arguments ((* GtkCList) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:682 <1924> 
;; gint gtk_clist_append( GtkCList* clist, gchar* text[]);
(ff:bind-c-function gtk_clist_append
     :unconverted-entry-name "gtk_clist_append"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gchar" "*" "[" "]"))
     :c-arg-names (clist text)
     :arguments ((* GtkCList) (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:688 <1925> 
;; gint gtk_clist_insert( GtkCList* clist, gint row, gchar* text[]);
(ff:bind-c-function gtk_clist_insert
     :unconverted-entry-name "gtk_clist_insert"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gint") ("gchar" "*" "[" "]"))
     :c-arg-names (clist row text)
     :arguments ((* GtkCList) gint (* (* gchar)))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:693 <1926> 
;; void gtk_clist_remove( GtkCList* clist, gint row);
(ff:bind-c-function gtk_clist_remove
     :unconverted-entry-name "gtk_clist_remove"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist row)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:697 <1927> 
;; void gtk_clist_set_row_data( GtkCList* clist, gint row, gpointer data);
(ff:bind-c-function gtk_clist_set_row_data
     :unconverted-entry-name "gtk_clist_set_row_data"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gpointer"))
     :c-arg-names (clist row data)
     :arguments ((* GtkCList) gint gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:702 <1928> 
;; void gtk_clist_set_row_data_full( GtkCList* clist, gint row, gpointer
;;    data, GtkDestroyNotify destroy);
(ff:bind-c-function gtk_clist_set_row_data_full
     :unconverted-entry-name "gtk_clist_set_row_data_full"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gpointer") ("GtkDestroyNotify"))
     :c-arg-names (clist row data destroy)
     :arguments ((* GtkCList) gint gpointer GtkDestroyNotify)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:708 <1929> 
;; gpointer gtk_clist_get_row_data( GtkCList* clist, gint row);
(ff:bind-c-function gtk_clist_get_row_data
     :unconverted-entry-name "gtk_clist_get_row_data"
     :c-return-type ("gpointer")
     :return-type gpointer
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist row)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:714 <1930> 
;; gint gtk_clist_find_row_from_data( GtkCList* clist, gpointer data);
(ff:bind-c-function gtk_clist_find_row_from_data
     :unconverted-entry-name "gtk_clist_find_row_from_data"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gpointer"))
     :c-arg-names (clist data)
     :arguments ((* GtkCList) gpointer)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:718 <1931> 
;; void gtk_clist_select_row( GtkCList* clist, gint row, gint column);
(ff:bind-c-function gtk_clist_select_row
     :unconverted-entry-name "gtk_clist_select_row"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist row column)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:723 <1932> 
;; void gtk_clist_unselect_row( GtkCList* clist, gint row, gint column);
(ff:bind-c-function gtk_clist_unselect_row
     :unconverted-entry-name "gtk_clist_unselect_row"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist row column)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:728 <1933> 
;; void gtk_clist_undo_selection( GtkCList* clist);
(ff:bind-c-function gtk_clist_undo_selection
     :unconverted-entry-name "gtk_clist_undo_selection"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:733 <1934> 
;; void gtk_clist_clear( GtkCList* clist);
(ff:bind-c-function gtk_clist_clear
     :unconverted-entry-name "gtk_clist_clear"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:739 <1935> 
;; gint gtk_clist_get_selection_info( GtkCList* clist, gint x, gint y, gint
;;   * row, gint* column);
(ff:bind-c-function gtk_clist_get_selection_info
     :unconverted-entry-name "gtk_clist_get_selection_info"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkCList" "*") ("gint") ("gint") ("gint" "*")
                   ("gint" "*"))
     :c-arg-names (clist x y row column)
     :arguments ((* GtkCList) gint gint (* gint) (* gint))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:746 <1936> 
;; void gtk_clist_select_all( GtkCList* clist);
(ff:bind-c-function gtk_clist_select_all
     :unconverted-entry-name "gtk_clist_select_all"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:749 <1937> 
;; void gtk_clist_unselect_all( GtkCList* clist);
(ff:bind-c-function gtk_clist_unselect_all
     :unconverted-entry-name "gtk_clist_unselect_all"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:752 <1938> 
;; void gtk_clist_swap_rows( GtkCList* clist, gint row1, gint row2);
(ff:bind-c-function gtk_clist_swap_rows
     :unconverted-entry-name "gtk_clist_swap_rows"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist row1 row2)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:757 <1939> 
;; void gtk_clist_row_move( GtkCList* clist, gint source_row, gint dest_row
;;   );
(ff:bind-c-function gtk_clist_row_move
     :unconverted-entry-name "gtk_clist_row_move"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint") ("gint"))
     :c-arg-names (clist source_row dest_row)
     :arguments ((* GtkCList) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:762 <1940> 
;; void gtk_clist_set_compare_func( GtkCList* clist, GtkCListCompareFunc
;;    cmp_func);
(ff:bind-c-function gtk_clist_set_compare_func
     :unconverted-entry-name "gtk_clist_set_compare_func"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("GtkCListCompareFunc"))
     :c-arg-names (clist cmp_func)
     :arguments ((* GtkCList) GtkCListCompareFunc)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:766 <1941> 
;; void gtk_clist_set_sort_column( GtkCList* clist, gint column);
(ff:bind-c-function gtk_clist_set_sort_column
     :unconverted-entry-name "gtk_clist_set_sort_column"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gint"))
     :c-arg-names (clist column)
     :arguments ((* GtkCList) gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:770 <1942> 
;; void gtk_clist_set_sort_type( GtkCList* clist, GtkSortType sort_type);
(ff:bind-c-function gtk_clist_set_sort_type
     :unconverted-entry-name "gtk_clist_set_sort_type"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("GtkSortType"))
     :c-arg-names (clist sort_type)
     :arguments ((* GtkCList) GtkSortType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:774 <1943> 
;; void gtk_clist_sort( GtkCList* clist);
(ff:bind-c-function gtk_clist_sort
     :unconverted-entry-name "gtk_clist_sort"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*"))
     :c-arg-names (clist)
     :arguments ((* GtkCList))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkclist.h:777 <1944> 
;; void gtk_clist_set_auto_sort( GtkCList* clist, gboolean auto_sort);
(ff:bind-c-function gtk_clist_set_auto_sort
     :unconverted-entry-name "gtk_clist_set_auto_sort"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkCList" "*") ("gboolean"))
     :c-arg-names (clist auto_sort)
     :arguments ((* GtkCList) gboolean)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:49 <1945> 
;; typedef struct _GtkWindow GtkWindow;
(ff:bind-c-typedef _GtkWindow ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkWindow _GtkWindow)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:50 <1946> 
;; typedef struct _GtkWindowClass GtkWindowClass;
(ff:bind-c-typedef _GtkWindowClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkWindowClass _GtkWindowClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:52 <1947> 
;; struct _GtkWindow {
;;         GtkBin bin; gchar* title; gchar* wmclass_name; gchar*
;;   wmclass_class; GtkWindowType
;;    type; GtkWidget* focus_widget; GtkWidget* default_widget; GtkWindow*
;;   transient_parent;
;;              gushort resize_count; guint allow_shrink:  0x000000001;
;;   guint allow_grow
;;   :  0x000000001; guint auto_shrink:  0x000000001; guint handling_resize
;;   :  0x000000001; guint position:  0x000000002; guint use_uposition:
;;   0x000000001;
;;              guint modal:  0x000000001; guint window_has_focus:
;;   0x000000001; guint
;;    window_has_pointer_focus:  0x000000001; };

;;WARNING: Strange bitfield allow_shrink type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield allow_grow type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield auto_shrink type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield handling_resize type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield position type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield use_uposition type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield modal type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield window_has_focus type (guint) will be retrieved as an unsigned integer.

;;WARNING: Strange bitfield window_has_pointer_focus type (guint) will be retrieved as an unsigned integer.
(ff:bind-c-type _GtkWindow (:struct
  (bin GtkBin)   ;; GtkBin bin
  (title (* gchar))   ;; gchar* title
  (wmclass_name (* gchar))   ;; gchar* wmclass_name
  (wmclass_class (* gchar))   ;; gchar* wmclass_class
  (type GtkWindowType)   ;; GtkWindowType type
  (focus_widget (* GtkWidget))   ;; GtkWidget* focus_widget
  (default_widget (* GtkWidget))   ;; GtkWidget* default_widget
  (transient_parent (* GtkWindow))   ;; GtkWindow* transient_parent
  (resize_count gushort)   ;; gushort resize_count
  (allow_shrink (:bit 1))   ;; guint allow_shrink:  0x000000001
  (allow_grow (:bit 1))   ;; guint allow_grow:  0x000000001
  (auto_shrink (:bit 1))   ;; guint auto_shrink:  0x000000001
  (handling_resize (:bit 1))   ;; guint handling_resize:  0x000000001
  (position (:bit 2))   ;; guint position:  0x000000002
  (use_uposition (:bit 1))   ;; guint use_uposition:  0x000000001
  (modal (:bit 1))   ;; guint modal:  0x000000001
  (window_has_focus (:bit 1))   ;; guint window_has_focus:  0x000000001
  (window_has_pointer_focus (:bit
                             1))   ;;
  ;;  guint window_has_pointer_focus:  0x000000001
  ))   ;; bind-c-type _GtkWindow

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:92 <1948> 
;; struct _GtkWindowClass {
;;         GtkBinClass parent_class; void(* set_focus)( GtkWindow* window,
;;   GtkWidget
;;   * focus); };
(ff:bind-c-type _GtkWindowClass (:struct
  (parent_class GtkBinClass)   ;; GtkBinClass parent_class
  (set_focus ff:function-pointer)   ;;
  ;;  void(* set_focus)( GtkWindow* window, GtkWidget* focus)
  ))   ;; bind-c-type _GtkWindowClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:101 <1949> 
;; GtkType gtk_window_get_type( void);
(ff:bind-c-function gtk_window_get_type
     :unconverted-entry-name "gtk_window_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:102 <1950> 
;; GtkWidget* gtk_window_new( GtkWindowType type);
(ff:bind-c-function gtk_window_new
     :unconverted-entry-name "gtk_window_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("GtkWindowType"))
     :c-arg-names (type)
     :arguments (GtkWindowType)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:103 <1951> 
;; void gtk_window_set_title( GtkWindow* window, const gchar* title);
(ff:bind-c-function gtk_window_set_title
     :unconverted-entry-name "gtk_window_set_title"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("const" "gchar" "*"))
     :c-arg-names (window title)
     :arguments ((* GtkWindow) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:105 <1952> 
;; void gtk_window_set_wmclass( GtkWindow* window, const gchar*
;;   wmclass_name,
;;              const gchar* wmclass_class);
(ff:bind-c-function gtk_window_set_wmclass
     :unconverted-entry-name "gtk_window_set_wmclass"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("const" "gchar" "*")
                   ("const" "gchar" "*"))
     :c-arg-names (window wmclass_name wmclass_class)
     :arguments ((* GtkWindow) (* gchar) (* gchar))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:108 <1953> 
;; void gtk_window_set_policy( GtkWindow* window, gint allow_shrink, gint
;;    allow_grow, gint auto_shrink);
(ff:bind-c-function gtk_window_set_policy
     :unconverted-entry-name "gtk_window_set_policy"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("gint") ("gint") ("gint"))
     :c-arg-names (window allow_shrink allow_grow auto_shrink)
     :arguments ((* GtkWindow) gint gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:112 <1954> 
;; void gtk_window_add_accel_group( GtkWindow* window, GtkAccelGroup*
;;   accel_group
;;   );
(ff:bind-c-function gtk_window_add_accel_group
     :unconverted-entry-name "gtk_window_add_accel_group"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("GtkAccelGroup" "*"))
     :c-arg-names (window accel_group)
     :arguments ((* GtkWindow) (* GtkAccelGroup))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:114 <1955> 
;; void gtk_window_remove_accel_group( GtkWindow* window, GtkAccelGroup*
;;    accel_group);
(ff:bind-c-function gtk_window_remove_accel_group
     :unconverted-entry-name "gtk_window_remove_accel_group"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("GtkAccelGroup" "*"))
     :c-arg-names (window accel_group)
     :arguments ((* GtkWindow) (* GtkAccelGroup))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:116 <1956> 
;; void gtk_window_set_position( GtkWindow* window, GtkWindowPosition
;;   position
;;   );
(ff:bind-c-function gtk_window_set_position
     :all-names ((gtk_window_position . "gtk_window_position")
                 (gtk_window_set_position . "gtk_window_set_position"))
     :unconverted-entry-name "gtk_window_set_position"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("GtkWindowPosition"))
     :c-arg-names (window position)
     :arguments ((* GtkWindow) GtkWindowPosition)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:118 <1957> 
;; gint gtk_window_activate_focus( GtkWindow* window);
(ff:bind-c-function gtk_window_activate_focus
     :unconverted-entry-name "gtk_window_activate_focus"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GtkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:119 <1958> 
;; gint gtk_window_activate_default( GtkWindow* window);
(ff:bind-c-function gtk_window_activate_default
     :unconverted-entry-name "gtk_window_activate_default"
     :c-return-type ("gint")
     :return-type gint
     :c-arg-types (("GtkWindow" "*"))
     :c-arg-names (window)
     :arguments ((* GtkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:121 <1959> 
;; void gtk_window_set_transient_for( GtkWindow* window, GtkWindow*
;;   parent);
(ff:bind-c-function gtk_window_set_transient_for
     :unconverted-entry-name "gtk_window_set_transient_for"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("GtkWindow" "*"))
     :c-arg-names (window parent)
     :arguments ((* GtkWindow) (* GtkWindow))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:123 <1960> 
;; void gtk_window_set_geometry_hints( GtkWindow* window, GtkWidget*
;;   geometry_widget,
;;              GdkGeometry* geometry, GdkWindowHints geom_mask);
(ff:bind-c-function gtk_window_set_geometry_hints
     :unconverted-entry-name "gtk_window_set_geometry_hints"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("GtkWidget" "*") ("GdkGeometry" "*")
                   ("GdkWindowHints"))
     :c-arg-names (window geometry_widget geometry geom_mask)
     :arguments ((* GtkWindow) (* GtkWidget) (* GdkGeometry) GdkWindowHints)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:131 <1961> 
;; void gtk_window_set_default_size( GtkWindow* window, gint width, gint
;;    height);
(ff:bind-c-function gtk_window_set_default_size
     :unconverted-entry-name "gtk_window_set_default_size"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("gint") ("gint"))
     :c-arg-names (window width height)
     :arguments ((* GtkWindow) gint gint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:136 <1962> 
;; void gtk_window_set_modal( GtkWindow* window, gboolean modal);
(ff:bind-c-function gtk_window_set_modal
     :unconverted-entry-name "gtk_window_set_modal"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("gboolean"))
     :c-arg-names (window modal)
     :arguments ((* GtkWindow) gboolean)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:140 <1963> 
;; void gtk_window_set_focus( GtkWindow* window, GtkWidget* focus);
(ff:bind-c-function gtk_window_set_focus
     :unconverted-entry-name "gtk_window_set_focus"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("GtkWidget" "*"))
     :c-arg-names (window focus)
     :arguments ((* GtkWindow) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:142 <1964> 
;; void gtk_window_set_default( GtkWindow* window, GtkWidget* defaultw);
(ff:bind-c-function gtk_window_set_default
     :unconverted-entry-name "gtk_window_set_default"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("GtkWidget" "*"))
     :c-arg-names (window defaultw)
     :arguments ((* GtkWindow) (* GtkWidget))
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:144 <1965> 
;; void gtk_window_remove_embedded_xid( GtkWindow* window, guint xid);
(ff:bind-c-function gtk_window_remove_embedded_xid
     :unconverted-entry-name "gtk_window_remove_embedded_xid"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("guint"))
     :c-arg-names (window xid)
     :arguments ((* GtkWindow) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:146 <1966> 
;; void gtk_window_add_embedded_xid( GtkWindow* window, guint xid);
(ff:bind-c-function gtk_window_add_embedded_xid
     :unconverted-entry-name "gtk_window_add_embedded_xid"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("guint"))
     :c-arg-names (window xid)
     :arguments ((* GtkWindow) guint)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkwindow.h:148 <1967> 
;; void gtk_window_reposition( GtkWindow* window, gint x, gint y);
(ff:bind-c-function gtk_window_reposition
     :unconverted-entry-name "gtk_window_reposition"
     :c-return-type ("void")
     :return-type :void
     :c-arg-types (("GtkWindow" "*") ("gint") ("gint"))
     :c-arg-names (window x y)
     :arguments ((* GtkWindow) gint gint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvbox.h:47 <1968> 
;; typedef struct _GtkVBox GtkVBox;
(ff:bind-c-typedef _GtkVBox ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkVBox _GtkVBox)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvbox.h:48 <1969> 
;; typedef struct _GtkVBoxClass GtkVBoxClass;
(ff:bind-c-typedef _GtkVBoxClass
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkVBoxClass _GtkVBoxClass)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvbox.h:50 <1970> 
;; struct _GtkVBox { GtkBox box; };
(ff:bind-c-type _GtkVBox (:struct
  (box GtkBox)   ;; GtkBox box
  ))   ;; bind-c-type _GtkVBox

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvbox.h:55 <1971> 
;; struct _GtkVBoxClass { GtkBoxClass parent_class; };
(ff:bind-c-type _GtkVBoxClass (:struct
  (parent_class GtkBoxClass)   ;; GtkBoxClass parent_class
  ))   ;; bind-c-type _GtkVBoxClass

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvbox.h:61 <1972> 
;; GtkType gtk_vbox_get_type( void);
(ff:bind-c-function gtk_vbox_get_type
     :unconverted-entry-name "gtk_vbox_get_type"
     :c-return-type ("GtkType")
     :return-type GtkType
     :c-arg-types nil
     :c-arg-names nil
     :arguments (:void)
     :strings-convert t
     )

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkvbox.h:62 <1973> 
;; GtkWidget* gtk_vbox_new( gboolean homogeneous, gint spacing);
(ff:bind-c-function gtk_vbox_new
     :unconverted-entry-name "gtk_vbox_new"
     :c-return-type ("GtkWidget" "*")
     :return-type (* GtkWidget)
     :c-arg-types (("gboolean") ("gint"))
     :c-arg-names (homogeneous spacing)
     :arguments (gboolean gint)
     :strings-convert t
     )

;; ---------------------------------------------------

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkpreview.h:46 <1974> 
;; typedef struct _GtkPreview GtkPreview;
(ff:bind-c-typedef _GtkPreview
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkPreview _GtkPreview)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkpreview.h:47 <1975> 
;; typedef struct _GtkPreviewInfo GtkPreviewInfo;
(ff:bind-c-typedef _GtkPreviewInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkPreviewInfo _GtkPreviewInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkpreview.h:48 <1976> 
;; typedef union _GtkDitherInfo GtkDitherInfo;
(ff:bind-c-typedef _GtkDitherInfo
                   ff:dummy-forward-struct) ;;
;;   forward declaration 
(ff:bind-c-type GtkDitherInfo _GtkDitherInfo)  

;; /net/fritter/home/cox/gtk/spot/i/include/gtk-1.2/gtk/gtkpreview.h:49 <1977> 
;; typedef struct _GtkPreviewClass GtkPreviewClass;
(ff:bind-c-typ