;; $Id: test.cl,v 1.4 2003/11/11 05:32:00 layer Exp $

(in-package :user)

(defvar *version* "$Revision: 1.4 $")

(defvar *usage*
    "~
Usage: test [-D] [-V] [-a] [-b] [-c] [-d number | -e file]

One (and only one) of the following must be given:
  -d number :: frob number
  -e file   :: frob file

The following are optional:
  -D :: debug mode
  -V :: print version number and exit
  -a :: a frob
  -b :: b frob
  -c :: c frob
")

(defvar *debug-testapp* nil) ;; set in `makefile'
(defvar *verbose* nil)

(defvar *testapp-error* nil)

(defvar *cleanup-forms* nil)

(define-condition testapp-debug () ())

(defun main ()
  ;; The following makes run-shell-command interruptable on Linux.  I
  ;; dunno, it appears to be a linux bug, but we're not sure.
  #+linux (setf (sys:getenv "SHELL") "/bin/csh")
  (flet ((doit ()
	   (system:with-command-line-arguments
	       ("DVabcd:e:"
		debug print-version aflag bflag cflag number file)
	       (rest)
	     ;; (continue) will continue executions, but first giving the
	     ;; person running the app a chance to poke around.
	     (when debug (error 'testapp-debug))

	     (if* print-version
		then (testapp-note "testapp: ~a" *version*)
		else ;; argument checking:
		     (when rest (testapp-error *usage*))
		     (when (not (or number file)) (testapp-error *usage*))
		     (when (and file (not (probe-file file)))
		       (testapp-error "File ~a does not exist." file))
		     
		     (testapp-guts number file aflag bflag cflag))

	     (exit 0)))
	 (handle-error (c)
	   (dolist (form *cleanup-forms*) (funcall form c))
	   (let ((msg (format nil "~1@<~a~:@>~%" c)))
	     ;; don't put up the message box twice:
	     (when (null *testapp-error*) (testapp-note msg))
	     (exit 1 :no-unwind t))))
    (if* *debug-testapp*
       then (doit)
       else (handler-case (doit)
	      (testapp-debug () (break "debug me!"))
	      (excl::asynchronous-operating-system-signal (c) (handle-error c))
	      (error (c) (handle-error c))))))

(defun testapp-guts (number file aflag bflag cflag)
  (let ((cleanup-form
	 #'(lambda (&optional condition)
	     (testapp-note "~&Cleaning up~@[ for error: ~a~]~%" condition)
	     ;; ...insert other cleanup code here...
	     )))
    (push cleanup-form *cleanup-forms*)
    (add-signal-handler
     2
     #'(lambda (sig cont)
	 (when *verbose* (testapp-note "In SIGINT cleanup handler...~%"))
	 (dolist (form *cleanup-forms*) (funcall form))
	 (excl::sig-handler-exit sig cont))))
  
  (if* number
     then (testapp-note
	   "number is ~d~@[~*, -a~]~@[~*, -b~]~@[~*, -c~]"
	   number aflag bflag cflag)
     else (testapp-note
	   "file is ~s~@[~*, -a~]~@[~*, -b~]~@[~*, -c~]"
	   file aflag bflag cflag))
  
  (values))

(defun testapp-error (format-string &rest format-args)
  #+(or (not mswindows) testapp-windows-console-app)
  (apply #'error format-string format-args)
  #+(and mswindows (not testapp-windows-console-app))
  (let ((msg (apply #'format nil format-string format-args)))
    (excl::internal-message-box msg "testapp")
    (setq *testapp-error* t)
    (error msg)))

(defun testapp-note (format-string &rest format-args)
  #+(or (not mswindows) testapp-windows-console-app)
  (progn
    (format t "~&")
    (apply #'format t format-string format-args)
    (format t "~&")
    (force-output))
  #+(and mswindows (not testapp-windows-console-app))
  (let ((msg (apply #'format nil format-string format-args)))
    (excl::internal-message-box msg "testapp")))
