;; $Id: custom.cl,v 1.16 2002/07/09 20:52:49 layer Exp $
;;
;; Add to this file any forms you wish to be evaluated before the Allegro
;; CL image is saved.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Compatibility with previous versions of Allegro CL.
;;
;; The #+ignore'd items in this section are here to illustrate changes in
;; the newest version of Allegro CL.  In some case, you can recover
;; previous Allegro CL behavior by instantiating individual forms below.
;; In other cases, the forms are here to document new behavior of Allegro
;; CL.

;; Starting in release 6.0, require is more restrictive in where it looks.
;; The following will restore the 5.0.1 behavior of require.  Note that
;; many customers experienced problems with 5.0.1, due to incorrect files
;; being loaded by require.  For example, if you have a file build.cl in
;; the current directory and you do (require :genapp), it will do a
;; (require :build) which will find your build.cl or build.fasl instead of
;; the one in the ACL `code' directory.
#+ignore
(setq sys:*require-search-list*
  (list #p""
	#p(:type "fasl")
	#p(:type "cl")
	#p(:type "lisp")
	'(:first
	  #p"sys:;code;.fasl"
	  #p"sys:;private;.fasl"
	  #p"sys:;clos;.fasl"
	  #p"sys:;sys;.fasl"
	  #+mswindows #p"sys:;winapi;.fasl"
	  #+mswindows #p"sys:;ole;.fasl"
	  (:lib-bundle #p"sys:;code;.fasl")
	  (:lib-bundle #p"sys:;private;.fasl")
	  (:lib-bundle #p"sys:;clos;.fasl")
	  (:lib-bundle #p"sys:;sys;.fasl")
	  #+mswindows (:lib-bundle #p"sys:;winapi;.fasl"))
	#p"sys:;code;.cl"
	#p"sys:;private;.cl"
	#p"sys:;clos;.cl"
	#p"sys:;sys;.cl"))

;; End of compatibility section.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#|
;; the following are examples of how to customize the actions of custom.cl

(let ((acl-foo (sys:getenv "ACL_FOO")))
  (when acl-foo
    ;; load FOO
    (load acl-foo)))

;; a second sytle of customization:

(let ((acl-foo (sys:getenv "ACL_BAR")))
  (when acl-foo
    (push :do-bar *features*)))

#+do-bar
(setq excl:*logical-pathname-translations-database* "/foo/bar/myhosts.lisp")
|#
