
(in-package :cg-user) 
(((:header
   "Common Graphics   (a high-level API for writing windowized Graphical User Interfaces)")
  ((:header "Initializing Common Graphics") ((:sym initialize-cg))
   ((:sym *cg-is-initialized*)) ((:sym in-cg-process)) ((:sym exit-cg))
   ((:sym *gtk-compatibility-warning-action* "(used on GTK only)")))
  ((:header "Coordinates")
   ((:header "Positions")
    ((:header "Making Positions")
     ((:doc "position   (class; instantiate with make-position)"
       "cgide.htm#position-class-1"))
     ((:sym positionp)) ((:sym make-position)) ((:sym nmake-position))
     ((:sym copy-position)) ((:sym ncopy-position))
     ((:sym with-positions "(allocates temporary utility positions)"))
     ((:sym with-positions-and-boxes)))
    ((:header "Accessing Positions")
     ((:header "Individual Coordinates of Positions")
      ((:sym position-x)) ((:sym position-y)))
     ((:sym position-length)))
    ((:header "Testing Positions")
     ((:sym position=
       "(returns whether two positions have equal coordinates)"))
     ((:sym inside-box-p)) ((:sym on-line-segment-p))
     ((:sym on-line-segment-x-y-p)) ((:sym inside-circle-p))
     ((:sym inside-polygon-p)) ((:sym line-segment-intersection))
     ((:sym line-segment-intersection-x-y))
     ((:sym line-segment-intersects-box-p))
     ((:sym line-segment-intersects-box-x-y-p)) ((:sym line-x-at-y))
     ((:sym line-x-at-y-x-y)) ((:sym line-y-at-x))
     ((:sym line-y-at-x-x-y)) ((:sym radial-line-box-intersection))
     ((:sym radial-line-box-intersection-x-y))
     ((:sym radial-line-circle-intersection))
     ((:sym radial-line-circle-intersection-x-y)))
    ((:header "Manipulating Positions") ((:sym position+))
     ((:sym nposition+)) ((:sym position-)) ((:sym nposition-))
     ((:sym position*)) ((:sym nposition*)) ((:sym position-rotate))
     ((:sym nposition-rotate)) ((:sym position-transform))
     ((:sym nposition-transform))))
   ((:header "Boxes")
    ((:header "Creating Boxes")
     ((:sym box "(class; instantiate with make-box)")) ((:sym boxp))
     ((:sym make-box)) ((:sym nmake-box)) ((:sym copy-box))
     ((:sym ncopy-box))
     ((:sym with-boxes "(allocates temporary utility boxes)"))
     ((:sym with-positions-and-boxes))
     ((:header "Creating Boxes From Positions")
      ((:sym make-box-from-corners)) ((:sym nmake-box-from-corners))
      ((:sym make-box-relative)) ((:sym nmake-box-relative))
      ((:sym make-box-relative-from-corner))
      ((:sym nmake-box-relative-from-corner)))
     ((:header "Creating Centered Boxes") ((:sym center-box-on-window))
      ((:sym center-box-on-screen)) ((:sym center-box-on-page))))
    ((:header "Accessing Boxes")
     ((:header "Individual Coordinates of Boxes") ((:sym box-left))
      ((:sym box-top)) ((:sym box-right)) ((:sym box-bottom))
      ((:sym box-width)) ((:sym box-height)))
     ((:header "Positions within Boxes")
      ((:header "Corners") ((:sym box-top-left)) ((:sym box-top-right))
       ((:sym box-bottom-left)) ((:sym box-bottom-right)))
      ((:header "Centers of Sides") ((:sym box-left-center))
       ((:sym box-top-center)) ((:sym box-right-center))
       ((:sym box-bottom-center)))
      ((:header "The Center of the Box") ((:sym box-center))
       ((:sym box-center-x)) ((:sym box-center-y)))))
    ((:header "Testing Boxes")
     ((:sym box= "(returns whether two boxes have equal coordinates)"))
     ((:sym box-intersect-p "(whether two boxes overlap)"))
     ((:sym sub-box-p "(whether a box is inside another box)"))
     ((:sym inside-box-p "(whether a position is inside a box)")))
    ((:header "Manipulating Boxes") ((:sym box-move))
     ((:sym nbox-move)) ((:sym box-union)) ((:sym box-intersect))
     ((:sym inflate-box))))
   ((:header "Translating Between Alternate Coordinate Systems")
    ((:doc "Coordinate System Overview" "cg/cg-coordinates.htm"))
    ((:header "Alternate Points of Reference")
     ((:header
       "Between a Physical Window or other \"Device\" and Its Stream for Drawing")
      ((:sym device-to-stream-units)) ((:sym stream-to-device-units))
      ((:header "Deprecated")
       ((:sym window-to-stream-units
         "(renamed device-to-stream-units)"))
       ((:sym stream-to-window-units
         "(renamed stream-to-device-units)"))))
     ((:header "Between a Physical Window and the Screen")
      ((:sym window-to-screen-units)) ((:sym screen-to-window-units)))
     ((:header "Between Any Two Windows or Their Streams")
      ((:sym window-to-window-units)) ((:sym stream-to-stream-units))))
    ((:header "Alternate Units of Distance or Size")
     ((:header "Between Scaled Units and Pixels")
      ((:sym device-to-scaling-units)) ((:sym scaling-to-device-units))
      ((:nav "Navigator Example for a Scaled Printer-Stream"
        :printer-resolution-example)))
     ((:header "Between Dialog Units and Pixels")
      ((:sym dialog-to-device-units)) ((:sym device-to-dialog-units))
      ((:sym dialog-units-p))
      ((:header "Deprecated")
       ((:sym dialog-to-screen-units
         "(renamed dialog-to-device-units)"))
       ((:sym screen-to-dialog-units
         "(renamed device-to-dialog-units)"))))))
   ((:header "Between Pixels and Points") ((:sym pixels-to-points))
    ((:sym points-to-pixels))))
  ((:header "Interface Objects")
   ((:header "Windows")
    ((:nav "Navigator Example for Windowing" :window-methods-example))
    ((:header "Window Classes")
     ((:header
       "Instantiable Window Classes   (use make-window to instantiate)")
      ((:header
        "basic-pane   \"(superclass of all windows; also instantiable)\"")
       ((:sym basic-pane)) ((:sym windowp)))
      ((:header
        "frame-window   (a general window for arbitrary graphics)")
       ((:sym frame-window "(class)")) ((:sym frame-window-p))
       ((:sym frame-window-of-window)))
      ((:header
        "non-refreshing-window   (a frame-with-single-child window for arbitrary graphics)")
       ((:sym non-refreshing-window "(class)"))
       ((:sym non-refreshing-pane "(class)")))
      ((:header
        "dialog   (a window in which the user can tab to various controls)")
       ((:sym dialog "(class)"))
       ((:header "Functions Applicable to Any Dialog") ((:sym dialogp))
        ((:sym dialog-items)) ((:sym update-dialog))
        ((:header "Accessing Values of Multiple Controls")
         ((:sym dialog-field)) ((:sym dialog-fields))
         ((:sym set-dialog-field)) ((:sym set-dialog-fields)))
        ((:sym tab-to-next)) ((:sym set-default-button)))
       ((:header
         "Modal Dialogs   (dialogs that appear momentarily and demand attention)")
        ((:sym pop-up-modal-dialog)) ((:sym flag-modal-completion))
        ((:sym exit-dialog)) ((:sym is-modal)) ((:sym pop-up))
        ((:sym topmost)) ((:sym modal-window))
        ((:sym allow-during-modality "(menu-item property)"))
        ((:sym *modal-dialogs-disable-owner*))
        ((:header "Default Buttons and Cancel Buttons")
         ((:sym default-button "(control class)"))
         ((:sym cancel-button "(control class)"))
         ((:sym return-t-from-pop-up-dialog))
         ((:sym return-nil-from-pop-up-dialog))))
       ((:header
         "Built-In Utility Dialogs   (useful for certain standard operations)")
        ((:header
          "Common Dialogs   (supplied by the operating system)")
         ((:header "ask-user-for-existing-pathname")
          ((:sym ask-user-for-existing-pathname))
          ((:sym file-selection-buffer-size))
          ((:sym ide.base:source-file-types))
          ((:sym ide.base:file-dialog-source-types
            "(no longer used)")))
         ((:header "ask-user-for-new-pathname")
          ((:sym ask-user-for-new-pathname))
          ((:sym ide.base:source-file-types))
          ((:sym ide.base:file-dialog-source-types
            "(no longer used)")))
         ((:sym ask-user-for-new-or-existing-directory))
         ((:sym ask-user-for-directory)) ((:sym ask-user-for-font))
         ((:sym ask-user-for-color))
         ((:sym pop-up-printer-job-dialog
           "(normally called only internally when a printer stream is opened)"))
         ((:sym pop-up-printer-setup-dialog
           "(the Page Setup dialog)")))
        ((:header
          "Lisp Utility Dialogs   (supplied by Common Graphics)")
         ((:header "Displaying a Message")
          ((:sym pop-up-message-dialog))
          ((:sym *pop-up-message-max-width-factor*))
          ((:sym *pop-up-message-max-height-factor*))
          ((:sym message-box)))
         ((:header "Choice Selection") ((:sym ask-user-for-choice))
          ((:sym ask-user-for-choice-from-list))
          ((:sym yes-no-or-cancel-list)) ((:sym y-or-n-dialog))
          ((:sym ask-save-changes)))
         ((:header "Prompting for a String")
          ((:sym ask-user-for-string)) ((:sym pop-up-string-dialog))
          ((:sym pop-up-strings-dialog)))
         ((:header "String Search and Replace")
          ((:sym pop-up-find-dialog)) ((:sym pop-up-replace-dialog)))
         ((:header "Older Deprecated Utility Dialog Functions")
          ((:sym choose-default-printer
            "(use pop-up-printer-setup-dialog or use the print job dialog)"))
          ((:sym pop-up-color-dialog "(use ask-user-for-color)"))))
        ((:header "Options for the Utility Dialogs")
         ((:sym center-all-modal-dialogs-on-screen
           "(configuration option)"))
         ((:sym modal-dialog-margin "(configuration option)"))
         ((:sym position-utility-dialog
           "(overridable generic function)"))
         ((:sym center-modal-children
           "(overridable generic function)")))
        ((:doc "Menus and Dialogs in the IDE"
          "cgide.htm#menus-dialogs-1"))))
      ((:header
        "bitmap-window   (a window that uses a memory bitmap to remember its contents)")
       ((:sym bitmap-window "(class)")) ((:sym bitmap-pane "(class)"))
       ((:header
         "Controlling the Size of the Backing-Store Memory Bitmap")
        ((:sym set-page-size)) ((:sym page-width)) ((:sym page-height))
        ((:sym default-page-width)) ((:sym default-page-height)))
       ((:header
         "Changing a Picture Instantaneously   (with no erasure \"flash\")")
        ((:info
          "Use (with-delayed-redraw (my-bitmap-pane :invalidate t) <draw stuff>))"))
        ((:sym with-delayed-redraw)))
       ((:nav "Navigator Bouncing Boxes Example"
         :bouncing-box-example))
       ((:header
         "Bitmap-Streams   (like a bitmap-window's backing-store without the window)")
        ((:sym bitmap-stream
          "(class; use open-stream to instantiate)"))
        ((:sym open-stream
          "(instantiates a bitmap-stream or printer class)"))
        ((:doc "Drawing on bitmap-streams"
          "cg/cg-drawing.htm#on-bitmap-streams-2"))
        ((:nav "Navigator Bitmap-Stream Example"
          :bitmap-stream-example))
        ((:nav "Navigator Custom Mouse Cursor Example"
          :mouse-cursor-example))))
      ((:header
        "text-edit-window   (a window that uses a text-editing control)")
       ((:header "Classes") ((:sym text-edit-window))
        ((:sym text-edit-pane)))
       ((:header "Functions")
        ((:header "Accessing the Text")
         ((:info
           "Use standard CL stream output functions like FORMAT to add text to a text-edit-pane."))
         ((:sym text-range
           "(returns an arbitrary substring of the text)"))
         ((:sym text-line "(returns one complete line of the text)"))
         ((:sym selected-object "(returns the selected text)"))
         ((:sym get-text "(returns all of the text)"))
         ((:sym set-text "(sets all of the text)"))
         ((:sym copy-selection "(returns the selected text)"))
         ((:sym cut-selection
           "(deletes and returns the selected text)"))
         ((:sym paste-selection
           "(inserts text, replacing any selection)"))
         ((:sym undo-command)) ((:sym redo-command))
         ((:sym copy-command)) ((:sym cut-command))
         ((:sym paste-command)) ((:sym delete-command))
         ((:sym file-length "(returns the length of all the text)"))
         ((:sym clear-page
           "(for a text-edit-pane, removes all text)")))
        ((:header
          "The Currently Selected Text or Text Cursor Position")
         ((:sym get-selection
           "(returns the selection range or the text cursor position)"))
         ((:sym set-selection
           "(sets the selection range or the text cursor position)"))
         ((:sym file-position
           "(returns or sets the text cursor position)"))
         ((:sym selection-changed "(overridable generic function)"))
         ((:sym scroll-text-cursor-into-view)))
        ((:header "Character and Line Indices")
         ((:sym number-of-text-lines)) ((:sym current-line-number))
         ((:sym current-text-column)) ((:sym first-visible-line))
         ((:sym set-first-visible-line)) ((:sym line-number-from-char))
         ((:sym char-from-line-number)))
        ((:header "Pixel Positions of Characters")
         ((:sym character-index-at-position))
         ((:sym position-of-character-index)))
        ((:header "Bookmarks") ((:sym make-mark))
         ((:sym mark-position))
         ((:header "IDE Menu Commands for Marks")
          ((:info "Edit | Set Mark")) ((:info "Edit | Swap with Mark"))
          ((:info "Edit | Select to Mark"))
          ((:info "Edit | Display Selection"))
          ((:doc "The Edit Menu"
            "ide-menus-and-dialogs/edit-menu.htm"))))
        ((:header "Searching a Text Control") ((:sym string-search))
         ((:sym string-replace)))
        ((:header "Other Text-Edit-Pane/Window Functions")
         ((:sym file "(returns the file being edited)"))
         ((:sym stream-package))
         ((:sym modified
           "(returns whether there are changes that need to be saved)"))
         ((:sym text-edit-margins)) ((:sym restore-right-margin))
         ((:sym with-motionless-text-control))))
       ((:header "Special Properties for Text-Edit-Panes")
        ((:sym font)) ((:sym tabs)) ((:sym read-only))
        ((:sym save-selection-when-unfocused))
        ((:sym show-selection-when-unfocused))
        ((:sym notify-when-selection-changed))
        ((:sym automatic-font-changing))
        ((:sym dual-fonts-for-languages))
        ((:sym external-format-for-save))
        ((:sym external-format-for-saved-files
          "(configuration option)"))
        ((:sym load-utf8-if-no-bom "(configuration option)"))
        ((:sym write-bom-to-utf8-files "(configuration option)")))
       ((:header
         "Functions Used by the IDE Editor   (may be applicable to applications)")
        ((:sym load-file)) ((:sym save-file))
        ((:sym ide.base:source-file-types))
        ((:sym ide.base:file-dialog-source-types "(no longer used)"))))
      ((:header "lisp-edit-window   (for editing lisp expressions)")
       ((:header "Classes") ((:sym lisp-edit-window))
        ((:sym lisp-edit-pane)))
       ((:header "Parenthesis Matching and Lisp Indentation")
        ((:header "Parenthesis Matching") ((:sym parentheses-matched))
         ((:sym parenthesis-matching-color))
         ((:sym parenthesis-matching-style))
         ((:sym without-parenthesis-matching))
         ((:sym *show-parenthesis-matches-as-pop-up-window*))
         ((:sym *parenthesis-match-pop-up-milliseconds*)))
        ((:header "Lisp Indentation") ((:sym reindent-region))
         ((:sym reindent-single-line)) ((:sym conserve-indentation)))
        ((:header "Lisp Code Colorization")
         ((:header "Colorizing On Demand")
          ((:sym colorize-source-code)))
         ((:header "Colorizing Automatically")
          ((:sym colorize-on-load-file)) ((:sym colorize-on-typing)))
         ((:header "The Colors to Use") ((:sym color-for-comments))
          ((:sym color-for-strings)) ((:sym color-for-characters))
          ((:sym color-for-global-variables))
          ((:sym color-for-external-cl-symbols))
          ((:sym color-for-external-allegro-symbols))
          ((:sym color-for-external-cg-symbols))
          ((:sym color-for-user-functions))))))
      ((:header
        "rich-edit-pane   (a window that uses a rich text editing control)")
       ((:doc "Rich Edit Overview" "cg/cg-rich-text.htm"))
       ((:doc "Adding Comprehensive Help to an Application"
         "cg/cg-application-help.htm#comprehensive-help-2"))
       ((:header "Rich-Edit Classes") ((:sym rich-edit-pane))
        ((:sym rich-edit
          "(a control that uses a rich-edit-pane as its window)"))
        ((:sym rich-edit-dialog))
        ((:header "Rich-Edit \"Helper\" Controls")
         ((:sym rich-edit-multipic)) ((:sym multi-picture-button-pane))
         ((:sym rich-edit-ruler)) ((:sym rich-edit-ruler-pane))
         ((:sym rich-edit-combo-box)) ((:sym font-face-combo-box))
         ((:sym font-size-combo-box)))
        ((:sym character-format
          "(an object that specifies a set of formatting paramters)")))
       ((:header "Rich-Edit-Pane Functions")
        ((:header "Retrieving or Modifying Rich-Edit-Pane Text")
         ((:header "Functions that Handle Multiple Format Parameters")
          ((:header "Character Formatting")
           ((:sym get-character-format)) ((:sym set-character-format))
           ((:header "Character Format Objects")
            ((:sym character-format "(instantiable class)"))
            ((:header "Character Format Accessor Functions")
             ((:sym face)) ((:sym color)) ((:sym point-size))
             ((:sym bold)) ((:sym italic)) ((:sym underline))
             ((:sym same-face)) ((:sym same-color))
             ((:sym same-point-size)) ((:sym same-bold))
             ((:sym same-italic)) ((:sym same-underline)))
            ((:header "Copying and Pasting Character Formats")
             ((:sym copy-character-format))
             ((:sym paste-character-format))
             ((:sym *copied-character-format*)))
            ((:header "Prompting the User for Format Attributes")
             ((:sym rich-edit-get-color))
             ((:sym rich-edit-get-font)))))
          ((:header "Paragraph Formatting")
           ((:sym get-paragraph-format))
           ((:sym set-paragraph-format))))
         ((:header
           "Functions that Handle Individual Format Parameters")
          ((:header "Character Formatting") ((:sym face))
           ((:sym color)) ((:sym point-size)) ((:sym bold))
           ((:sym italic)) ((:sym underline)) ((:sym toggle-bold))
           ((:sym toggle-bullets)) ((:sym toggle-italic)))
          ((:header "Paragraph Formatting") ((:sym justification))
           ((:sym numbering-style)) ((:sym body-left-indentation))
           ((:sym top-left-indentation)) ((:sym right-indentation))
           ((:sym tabs)) ((:sym left-justify)) ((:sym center-justify))
           ((:sym right-justify)) ((:sym toggle-underline)))))
        ((:header "Manipulating Raw Rich Text")
         ((:sym concatenate-rich-text)) ((:sym rich-to-plain-text))
         ((:sym plain-to-rich-text)) ((:sym *empty-rtf-string*)))
        ((:header "Accessing Rich Text Strings")
         ((:sym rich-edit-range)) ((:sym rich-edit-selected-range))
         ((:sym rich-text)))
        ((:header "Event-Handlers for the Rich-Edit Control")
         ((:sym on-format-change)))
        ((:header "Reading and Writing Rich Text Files")
         ((:sym rich-edit-new)) ((:sym rich-edit-open))
         ((:sym rich-edit-save)) ((:sym rich-edit-save-as))
         ((:sym save-text)) ((:sym read-text)))
        ((:header "Printing Rich Text") ((:sym rich-edit-print))
         ((:sym print-rich-text)))
        ((:header "Finding Associated Rich-Edit-Panes")
         ((:sym find-rich-edit-pane)) ((:sym find-text-edit-pane))
         ((:sym rich-edit
           "(the function returns the rich-edit of a ruler)"))
         ((:sym ruler "(returns the ruler of a rich-edit)"))
         ((:sym funcall-menu-item-with-rich-edit)))
        ((:header "Hypertext Links in a Rich-Edit-Pane")
         ((:header
           "Finding Strings of a Certain Color   (to make into links)")
          ((:sym color-string-at-index))
          ((:sym color-string-at-cursor)) ((:sym find-links))
          ((:sym links)))
         ((:header "Recognizing Existing Links")
          ((:sym link-at-position)) ((:sym link-at-mouse-cursor))
          ((:sym link-at-text-cursor)) ((:sym link-at-index)))
         ((:header "Jumping to Links") ((:sym jump-to-link))
          ((:sym pathname-for-link)))
         ((:header "Storing Links for Quick Retrieval Later")
          ((:sym save-links-file)) ((:sym read-links-file)))
         ((:header "Link Options") ((:sym link-color))
          ((:sym save-links)) ((:sym jump-to-links))))
        ((:header "Adding a Standard Rich-Edit Menu-Bar")
         ((:sym rich-edit-menubar)))))
      ((:header
        "object-editor   (a high-level facility for editing class instances)")
       ((:header "Object-Editor Classes") ((:sym object-editor))
        ((:sym layout-spacing)))
       ((:header "Object-Editor Properties") ((:sym edited-class))
        ((:sym edited-slots)) ((:sym edited-instances))
        ((:sym command-buttons)) ((:sym current-instance))
        ((:sym include-table-of-all-instances))
        ((:sym save-on-clear-focus)) ((:sym save-on-new-widget-value)))
       ((:header "Properties for Dialog-Items on Object-Editors")
        ((:sym edited-type)) ((:sym edited-slot)))
       ((:header "Object-Editor Functions")
        ((:header "Object-Editor Command Functions")
         ((:sym display-instance)) ((:sym display-special-instance))
         ((:sym object-editor-delete)) ((:sym object-editor-new))
         ((:sym object-editor-pane)) ((:sym object-editor-revert))
         ((:sym object-editor-save)) ((:sym object-editor-search))
         ((:sym object-editor-select)) ((:sym cg-commit))
         ((:sym cg-rollback)))
        ((:header "Other Object-Editor Functions")
         ((:sym primary-name-slot)) ((:sym secondary-name-slot))
         ((:sym require-cg-acache))
         ((:sym uncache-instances-with-pretty-names))
         ((:sym update-all-class-interface-widgets))
         ((:sym class-info
           "(exported only because it's in .bil files)"))
         ((:sym object-editor-widget-on-change
           "(exported only because it's in .bil files)"))))
       ((:header "Layout-Spacing Properties            ")
        ((:sym layout-all-instances-table-height))
        ((:sym layout-button-group-spacing))
        ((:sym layout-button-height)) ((:sym layout-button-spacing))
        ((:sym layout-button-width)) ((:sym layout-column-spacing))
        ((:sym layout-label-spacing))
        ((:sym layout-multi-line-widget-height))
        ((:sym layout-outer-margin))
        ((:sym layout-single-line-widget-height))
        ((:sym layout-table-height)) ((:sym layout-widget-spacing))
        ((:sym layout-widget-width)))
       ((:header "Object-Editor Variables")
        ((:sym *object-editor-command-buttons*)))))
     ((:header "Non-Instantiable Window Classes of Interest")
      ((:sym graphical-stream
        "(superclass of all streams that can be drawn on)"))
      ((:sym screen-stream
        "(streams that display on the screen, namely windows and the screen itself)"))
      ((:sym dialog-mixin "(adds tabbing-to-widgets functionality)"))
      ((:header
        "frame-with-single-child   (automatically instantiates a child pane)")
       ((:sym frame-with-single-child)) ((:sym default-pane-class))
       ((:sym frame-child)) ((:sym frame-child-p)))
      ((:header
        "node-pane-mixin   (displays graphs of nodes and links as objects)")
       ((:header "Node and Link Classes")
        ((:header
          "node-pane-mixin   (allows a window to display a nodes-and-links graph)")
         ((:sym node-pane-mixin
           "(mix-in class for displaying graphs)"))
         ((:header "node-pane-mixin Properties")
          ((:header "Node Pane Properties for Node Pictures")
           ((:header "Node Pane Properties for Node Labels")
            ((:sym fit-nodes-to-labels)) ((:sym label-margin))
            ((:sym node-font)) ((:sym use-multi-line-labels)))
           ((:sym node-border-color)) ((:sym rounded-corner-radius)))
          ((:header "Node Pane Properties for Link Lines")
           ((:header "Node Pane Properties for Link Labels")
            ((:sym draw-link-labels))
            ((:sym draw-link-labels-horizontally))
            ((:sym link-label-color))
            ((:sym use-line-color-for-link-labels)))
           ((:sym link-font)) ((:sym link-line-mousing-margin)))
          ((:header "Node Pane Flashing Properties") ((:sym flashing))
           ((:sym flashing-interval))
           ((:sym flashing-node-color-difference))
           ((:sym times-to-flash)))
          ((:header "Node Pane Antialiasing Properties")
           ((:sym antialias-lines)) ((:sym antialias-text))
           ((:sym suppress-antialiasing-during-animation)))
          ((:header "Node Pane Color Gradient Properties")
           ((:sym color-gradient-intensity))
           ((:sym show-node-color-gradients))
           ((:sym suppress-color-gradients-during-animation)))
          ((:header "Node Pane Background Properties")
           ((:header "Node Pane Background Pixmap Properties")
            ((:sym background-pixmap))
            ((:sym background-pixmap-source))
            ((:sym show-background-pixmap))
            ((:sym stretch-background-pixmap)))
           ((:sym color-for-window-background)))
          ((:header "Other Node Pane Properties")
           ((:sym network-of-nodes)) ((:sym drag-scroll-zoom-factor))
           ((:sym node-or-link-under-mouse)) ((:sym show-subset)))))
        ((:sym node-pane
          "(an instantiable window class using node-pane-mixin)"))
        ((:header
          "network-of-nodes   (the logical object that manages a set of nodes and links)")
         ((:sym network-of-nodes "(instantiable class)"))
         ((:header "Network-of-Nodes Properties")
          ((:header "Principal Network-of-Nodes Properties")
           ((:sym name)) ((:sym node-pictures)) ((:sym link-lines))
           ((:sym node-panes)))
          ((:header "Network-of-Nodes Selection Properties")
           ((:sym selected-node-picture)) ((:sym selected-node-color))
           ((:sym selected-node-style)) ((:sym selected-link-line))
           ((:sym selected-link-color)))
          ((:header "Network-of-Nodes Arrowhead Defaults")
           ((:sym default-arrowhead-length))
           ((:sym default-arrowhead-width)))))
        ((:header "node-picture")
         ((:sym node-picture "(instantiable class)"))
         ((:header "Node Picture Properties")
          ((:header "Principal Node Picture Properties")
           ((:sym link-lines)) ((:sym name)) ((:sym network-of-nodes))
           ((:sym node-box)) ((:sym node-picture-label))
           ((:sym represented-object)))
          ((:header "Stylistic Node Picture Properties") ((:sym color))
           ((:sym flashing)) ((:sym label-margin))
           ((:sym node-border-color)) ((:sym node-font))
           ((:sym node-highlight-color)) ((:sym node-is-highlighted))
           ((:sym picture-type)) ((:sym pixmap)))
          ((:header "Other Node Picture Properties")
           ((:sym node-is-pinned)) ((:sym node-shifter))
           ((:sym real-center-x)) ((:sym real-center-y)))))
        ((:header "link-line")
         ((:sym link-line "(instantiable class)"))
         ((:header "Link Line Properties")
          ((:header "Principal Link Line Properties")
           ((:sym link-line-label)) ((:sym name))
           ((:sym network-of-nodes)) ((:sym node-picture-one))
           ((:sym node-picture-two)) ((:sym represented-object)))
          ((:header "Stylistic Link Line Properties")
           ((:header "Link Line Arrowhead Properties")
            ((:sym draw-arrowhead-one)) ((:sym draw-arrowhead-two))
            ((:sym arrowhead-one-length)) ((:sym arrowhead-one-width))
            ((:sym arrowhead-two-length)) ((:sym arrowhead-two-width)))
           ((:sym color)) ((:sym flashing)) ((:sym link-font))
           ((:sym link-line-dashing)) ((:sym link-line-width))
           ((:sym link-highlight-color))
           ((:sym link-is-highlighted))))))
       ((:header "Node and Link Functions")
        ((:header "Node and Link Event-Handling Generic Functions")
         ((:header "Node Picture Event-Handling Generic Functions")
          ((:sym node-mouse-in)) ((:sym node-mouse-out))
          ((:sym node-mouse-left-down)) ((:sym node-mouse-left-up))
          ((:sym node-mouse-middle-down)) ((:sym node-mouse-middle-up))
          ((:sym node-mouse-right-down)) ((:sym node-mouse-right-up))
          ((:sym node-mouse-double-click)) ((:sym draw-node-picture))
          ((:sym size-for-node-picture)))
         ((:header "Link Line Event-Handling Generic Functions")
          ((:sym link-mouse-in)) ((:sym link-mouse-out))
          ((:sym link-mouse-left-down)) ((:sym link-mouse-left-up))
          ((:sym link-mouse-middle-down)) ((:sym link-mouse-middle-up))
          ((:sym link-mouse-right-down)) ((:sym link-mouse-right-up))
          ((:sym link-mouse-double-click)))
         ((:header "Node Pane Event-Handling Generic Functions")
          ((:sym node-pane-mouse-left-down))
          ((:sym node-pane-mouse-left-up))
          ((:sym node-pane-mouse-middle-down))
          ((:sym node-pane-mouse-middle-up))
          ((:sym node-pane-mouse-right-down))
          ((:sym node-pane-mouse-right-up))
          ((:sym node-pane-mouse-double-click))
          ((:sym draw-over-background))))
        ((:header "Building a Network of Nodes and Links")
         ((:sym new-network-of-nodes)) ((:sym add-node-picture))
         ((:sym add-link-line)) ((:sym delete-link-line))
         ((:sym delete-node-picture)) ((:sym connect-to-node-picture))
         ((:sym display-network-of-nodes))
         ((:sym dimensions-for-squarified-text)))
        ((:header "Saving a Network of Nodes to File")
         ((:sym open-network-of-nodes)) ((:sym save-network-of-nodes))
         ((:sym save-network-of-nodes-as)))
        ((:header "Animation with Nodes and Links")
         ((:sym invalidate-object)) ((:sym set-node-box))
         ((:sym move-node-picture)) ((:sym shift-node))
         ((:sym center-to-box)) ((:sym center-to-box-x-y))
         ((:sym real-center-to-box)) ((:sym center-all-nodes))
         ((:sym scroll-node-into-view))
         ((:sym scroll-selected-node-into-view))
         ((:sym update-node-picture-node-box))
         ((:sym thing-at-position)) ((:sym node-picture-center-x))
         ((:sym node-picture-center-y)) ((:sym node-picture-height))
         ((:sym node-picture-width))
         ((:sym node-pane-redisplay-function)) ((:sym other-node))
         ((:sym animate-nodes)) ((:sym draw-nodes-and-links)))
        ((:header "Editing Nodes and Links Interactively")
         ((:sym edit-node-label)) ((:sym resize-node-picture))
         ((:sym drag-link-line)) ((:sym drag-node-picture))
         ((:sym nodes-drag-scroll)) ((:sym ensure-selected-node))
         ((:sym ensure-selected-link)))
        ((:header "Traversing a Network of Nodes and Links")
         ((:sym rotate-to-next-link-line))
         ((:sym rotate-to-next-link-line-clockwise))
         ((:sym rotate-to-next-link-line-counterclockwise))
         ((:sym leap-across-selected-link-line)))))
      ((:header
        "scaling-stream   (allows using a unit of measurement other than pixels)")
       ((:sym scaling-stream "(mix-in class for window classes)"))
       ((:sym stream-units-per-inch)) ((:sym device-to-scaling-units))
       ((:sym scaling-to-device-units))
       ((:nav "Navigator Example for a Scaled Printer-Stream"
         :printer-resolution-example)))
      ((:header
        "form   (instantiated by the IDE for building windows interactively)")
       ((:sym form "(class)")) ((:sym transparent-pane "(class)"))
       ((:sym ide.form:form-pane "(class)")) ((:sym form-p))
       ((:sym ide.form:form-package-name)))
      ((:sym cg-stream
        "(superclass of all windows and other CG streams)")))
     ((:header "Specialized Child Windows")
      ((:header "toolbar   (holds controls along the top of a window)")
       ((:sym toolbar "(instantiable class and window property)"))
       ((:sym toolbar-p)) ((:sym toolbars)) ((:sym has-toolbar))
       ((:sym add-toolbar)) ((:sym remove-toolbar))
       ((:sym removed-toolbars))
       ((:header "Default Toolbar Spacing")
        ((:sym *toolbar-button-spacing*))
        ((:sym *toolbar-icon-height*)) ((:sym *toolbar-margin*)))
       ((:header "Adding to the IDE Component Toolbar")
        ((:sym ide.base:add-to-component-toolbar))
        ((:sym ide.base:remove-from-component-toolbar))))
      ((:header
        "common-status-bar   (may be partitioned horizontally)")
       ((:sym common-status-bar "(class)"))
       ((:sym common-status-bar-p))
       ((:sym status-bar "(window property)"))
       ((:header "Creating Common Status-Bars")
        ((:sym add-common-status-bar)) ((:sym remove-status-bar)))
       ((:header "Showing Status-Bar Messages")
        ((:sym status-bar-message)) ((:sym window-message))
        ((:sym window-warning)) ((:sym get-part-text))
        ((:doc "Adding Quick Help to an Application"
          "cg/cg-application-help.htm#quick-help-2"))
        ((:header "In the IDE Status-Bar")
         ((:sym ide.base:lisp-message)) ((:sym ide.base:lisp-warning))
         ((:sym lisp-message-print-level))
         ((:sym lisp-message-print-length))))
       ((:header "Modifying a Common Status-Bar") ((:sym parts))
        ((:sym simple-mode)) ((:sym status-bar-font))
        ((:sym custom-status-bar-font "(configuration property)"))))
      ((:header "status-bar   (may be more than one line tall)")
       ((:sym status-bar "(class and window property)"))
       ((:sym status-bar-p))
       ((:header "Creating Status-Bars") ((:sym add-status-bar))
        ((:sym remove-status-bar)) ((:sym removed-status-bars)))
       ((:header "Showing Status-Bar Messages")
        ((:sym status-bar-message)) ((:sym window-message))
        ((:sym window-warning)))
       ((:header "Modifying a Common Status-Bar")
        ((:sym status-bar-font))
        ((:sym custom-status-bar-font "(configuration property)"))
        ((:sym status-bar-number-of-lines))
        ((:sym *status-bar-horizontal-margin*))
        ((:sym *status-bar-number-of-lines*))
        ((:sym *status-bar-vertical-margin*))))))
    ((:header "Creating and Destroying Windows")
     ((:sym make-window "(instantiates a basic-pane class)"))
     ((:sym close "(extendable generic function)"))
     ((:sym user-close "(overridable generic function)"))
     ((:sym windowp)) ((:sym creation-process))
     ((:header
       "Extendable (but not application-callable) Generic Functions")
      ((:sym device-open
        "(called to create the physical window for a CG window)"))
      ((:sym device-close "(called to close a CG window)")))
     ((:header
       "Subclassing Window Classes that Instantiate a Child Pane")
      ((:sym frame-with-single-child "(superclass)"))
      ((:sym default-pane-class "(overridable generic function)"))
      ((:nav "Navigator Example for Windowing"
        :window-methods-example)))
     ((:header
       "Q: How can I exclude a top-level window from the system taskbar?")
      ((:info)) ((:info "OR make its border property be :palette."))
      ((:info "On GTK, see frameless-topmost-p."))))
    ((:header "Properties Common to Many Windows")
     ((:info
       "The corresponding keyword initargs such as :name may be passed to make-window."))
     ((:sym name)) ((:sym title)) ((:sym help-string))
     ((:header "Appearance Properties of Windows") ((:sym state))
      ((:sym border)) ((:sym background-color)) ((:sym font)))
     ((:header "Frame-Window Properties") ((:sym resizable))
      ((:sym title-bar)) ((:sym close-button)) ((:sym maximize-button))
      ((:sym minimize-button)) ((:sym help-button))
      ((:sym system-menu))
      ((:sym icon
        "(the image on the system-menu button at the left end of the title-bar)"))
      ((:sym pop-up (intended to be used as a modal window)))
      ((:header
        "Q:  How can I override the 120-pixel OS minimum width of a window that has a frame?")
       ((:info
         "Pass \":resizable nil\" to make-window, or \":border :palette\""))))
     ((:header "Relationship Properties of Windows") ((:sym owner))
      ((:sym parent)) ((:sym child-p)) ((:sym siblings))
      ((:sym windows)) ((:sym dialog-items))
      ((:sym overlapped "(deprecated; use (not child-p))"))
      ((:sym pop-up)) ((:sym topmost)) ((:sym frameless-topmost-p))
      ((:sym toolbar)) ((:sym status-bar)))
     ((:header "Position and Size Properties of Windows")
      ((:sym left "(the setf moves the window horizontally)"))
      ((:sym top "(the setf moves the window vertically)"))
      ((:sym right)) ((:sym bottom))
      ((:sym width "(the setf resizes the window horizontally)"))
      ((:sym height "(the setf resizes the window vertically)")))
     ((:header "Scrolling Properties of Windows") ((:sym scrollbars))
      ((:sym page-width)) ((:sym page-height))
      ((:sym handle-scrolling-keys)) ((:sym retain-scrollbars)))
     ((:header
       "Attachment Properties of Windows  \"(follows resizing of the parent)\"")
      ((:sym left-attachment)) ((:sym top-attachment))
      ((:sym right-attachment)) ((:sym bottom-attachment)))
     ((:header "Mouse Cursor Properties of Windows") ((:sym cursor))
      ((:sym cursor-name))))
    ((:header "Finding Windows")
     ((:sym find-window
       "(finds a window from its name and its parent window)"))
     ((:sym find-named-object
       "(finds a window from its name and an ancestor window)"))
     ((:sym find-sibling
       "(finds a window from its name and a sibling window)"))
     ((:sym which-window "(the window under some arbitrary position)"))
     ((:sym window-under-mouse))
     ((:header
       "Caching Windows   (to find them later from their names only)")
      ((:sym add-application-window))
      ((:sym remove-application-window))
      ((:sym find-or-make-application-window))
      ((:sym find-or-make-pop-up-window))
      ((:sym find-application-window))
      ((:sym default-application-window-subkey))))
    ((:header "Window States (iconized, maximized, normal, shrunk)")
     ((:sym state)) ((:sym shrink-window)) ((:sym expand-window))
     ((:sym zoom-window))
     ((:sym track-limits "(constrains the maximized size)"))
     ((:sym select-window))
     ((:sym show-window "(deprecated; call (setf state))"))
     ((:sym normal-exterior)))
    ((:header "Relationships Between Windows")
     ((:header "Window Hierarchies   (child and owned windows)")
      ((:doc "Child Windows vs. Owned Windows"
        "cgide.htm#child-parent-overlapped-etc-1"))
      ((:header "Ancestor Windows") ((:sym parent))
       ((:sym owner "(return value has changed somewhat since 5.0.1)"))
       ((:sym parent-or-owner "(deprecated; use owner)"))
       ((:sym window-ancestor-p)) ((:sym frame-window-of-window))
       ((:sym top-level-window)))
      ((:header "Descendent Windows")
       ((:header "Lists of Child or Owned Windows") ((:sym windows))
        ((:sym windows-scratch-list)))
       ((:header "Finding a Particular Child or Owned Window")
        ((:sym find-window)) ((:sym front-window)) ((:sym nth-window)))
       ((:sym do-windows
         "(loops over the children without consing a list of them)"))
       ((:sym dialog-items "(returns the controls on a window)"))
       ((:sym is-child-allowed)))
      ((:header "Sibling Windows") ((:sym siblings))
       ((:sym find-sibling)) ((:sym next-window)))
      ((:header "Windows that Instantiate a Child Pane Automatically")
       ((:sym frame-with-single-child "(superclass)"))
       ((:sym frame-child
         "(returns the automatically-instantiated child pane)")))
      ((:header
        "Make-Window Initargs for Creating Child and Owned Windows")
       ((:sym owner
         "(the owner is also the parent when child-p is true)"))
       ((:sym child-p
         "(specifies that the owner is also a parent for clipping and moving)"))
       ((:sym pop-up
         "(for modal dialogs; coerces certain other properties)"))
       ((:sym parent))
       ((:sym overlapped "(deprecated; use (not child-p))")))
      ((:header "Child / Owned Status") ((:sym child-p))
       ((:sym owner "(either an owner window or the screen)"))
       ((:sym is-child-allowed))
       ((:sym pop-up "(the window is intended for modal usage)"))
       ((:sym ide.grapher:graph-child-windows))
       ((:sym top-level "(deprecated; use (not child-p))"))
       ((:sym overlapped "(deprecated; use (not child-p))"))))
     ((:header
       "Occlusion Order   (which windows are in front of which)")
      ((:header "Checking the Current Order") ((:sym front-window))
       ((:sym next-window)) ((:sym nth-window))
       ((:sym windows
         "(returns child windows in front-to-back order)"))
       ((:sym foreground-window)))
      ((:header "Changing the Order") ((:sym bury-window))
       ((:sym bring-window-to-front)) ((:sym move-window-behind))
       ((:sym select-window)) ((:sym set-foreground-window))))
     ((:header
       "Attachment   (how a child window moves or resizes when its parent is resized)")
      ((:sym attachment)) ((:sym set-attachment))
      ((:sym left-attachment)) ((:sym top-attachment))
      ((:sym right-attachment)) ((:sym bottom-attachment))))
    ((:header
      "Window Geometry   (Position & Size, Moving, Scrolling ...)")
     ((:header "Window Position and Size")
      ((:header "Exterior   (including the non-client frame area)")
       ((:header "Default Values")
        ((:sym default-top-left "(overridable generic function)"))
        ((:sym default-width
          "(overridable generic function and configuration option)"))
        ((:sym default-height
          "(overridable generic function and configuration option)"))
        ((:sym default-width-factor "(configuration option)"))
        ((:sym default-height-factor "(configuration option)")))
       ((:sym exterior)) ((:sym nexterior)) ((:sym exterior-width))
       ((:sym exterior-height)) ((:sym exterior-top-left))
       ((:sym nexterior-top-left)) ((:sym normal-exterior)))
      ((:header "Interior   (client area)") ((:sym interior))
       ((:sym ninterior)) ((:sym interior-width))
       ((:sym interior-height)) ((:sym interior-top-left))
       ((:sym ninterior-top-left)) ((:sym usable-left))
       ((:sym usable-top)) ((:sym usable-width))
       ((:sym usable-height)))
      ((:header "Specifying Initial Window Position and Size")
       ((:info
         "When calling make-window, pass one or more keyword initargs"))
       ((:info "whose names correspond to the following functions."))
       ((:sym left)) ((:sym top)) ((:sym width)) ((:sym height))
       ((:sym exterior-top-left)) ((:sym exterior)) ((:sym interior))))
     ((:header "Moving and Resizing Windows")
      ((:header "Moving") ((:sym move-window))
       ((:sym move-window-relative))
       ((:sym exterior "(the setf moves and/or resizes a window)"))
       ((:sym move-window-into-parent)))
      ((:header "Resizing") ((:sym resize-window))
       ((:sym exterior "(the setf moves and/or resizes a window)"))
       ((:sym width "(the setf resizes a window)"))
       ((:sym height "(the setf resizes a window)"))
       ((:header "Constraining Interactive Resizing")
        ((:sym track-limits)) ((:sym minimum-width))
        ((:sym minimum-height))))
      ((:header "Centering") ((:sym centered "(window property)"))
       ((:sym center-window)) ((:sym center-box-on-window))
       ((:sym center-box-on-screen)) ((:sym center-box-on-page))))
     ((:header "Scrolling")
      ((:header
        "Page Size   (size of the \"canvas\" that may be scrolled into the window)")
       ((:sym page-width)) ((:sym page-height)) ((:sym set-page-size))
       ((:sym default-page-width)) ((:sym default-page-height))
       ((:sym explicit-page-width)) ((:sym explicit-page-height))
       ((:sym page-box)) ((:sym npage-box)))
      ((:header "Scroll Bars")
       ((:sym scrollbars "(a property of windows and controls)"))
       ((:sym scroll-range
         "(overridable and callable generic function)"))
       ((:sym set-scroll-range
         "(use set-page-size instead, except in a custom scrolling scheme)"))
       ((:sym retain-scrollbars)))
      ((:header "The Scroll Action")
       ((:sym scroll "(callable function)"))
       ((:sym scroll-to "(callable and overridable generic function)"))
       ((:sym scroll-increment "(overridable generic function)"))
       ((:sym user-scroll "(overridable generic function)"))
       ((:sym scroll-window-to-middle))
       ((:sym scroll-window-into-parent))
       ((:sym handle-scrolling-keys))
       ((:sym update-scroll-bars-for-new-window-size
         "(overridable generic function)"))
       ((:sym scroll-box "(not true scrolling)")))
      ((:header "The Area Currently Scrolled Into View")
       ((:sym visible-box)) ((:sym nvisible-box))
       ((:sym visible-box-width)) ((:sym visible-box-height))
       ((:sym visible-box-top-left)) ((:sym nvisible-box-top-left))
       ((:sym scroll-position))
       ((:sym nscroll-position
         "(overridable and callable generic function)"))
       ((:sym interior-width)) ((:sym interior-height)))
      ((:nav
        "Navigator example for implementing a custom scrolling scheme"
        :custom-scrolling-example)))
     ((:header "The Movable Stream Origin") ((:sym stream-origin))
      ((:sym nstream-origin)) ((:sym move-stream-origin)))
     ((:header "Margins") ((:sym left-margin)) ((:sym top-margin))
      ((:sym right-margin)) ((:sym bottom-margin))
      ((:sym text-edit-margins)))
     ((:header "Standard Sizes of Certain Window Parts")
      ((:sym title-bar-height)) ((:sym horizontal-scrollbar-thickness))
      ((:sym vertical-scrollbar-thickness)))
     ((:header
       "IDE Window Configurations   (saved in the prefs.cl file)")
      ((:sym window-configurations))
      ((:sym ide.base:find-window-configuration))
      ((:sym ide.base:restore-window-configuration))
      ((:sym ide.base:ide-exterior)))))
   ((:header "Controls   (also known as widgets or dialog-items)")
    ((:nav "Navigator Example for Controls" :color-demo-example))
    ((:header "Control Classes")
     ((:header "Instantiable Control Classes")
      ((:header "Buttons")
       ((:header "button")
        ((:sym button "(instantiable dialog-item class)"))
        ((:sym button-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:sym toggle-button)))
       ((:header
         "default-button   (on-change may be invoked by pressing ENTER)")
        ((:sym default-button "(instantiable dialog-item class)"))
        ((:sym button-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:sym set-default-button
          "(sets the logical default-button of a dialog)"))
        ((:sym return-t-from-pop-up-dialog
          "(default on-change handler)")))
       ((:header
         "cancel-button   (on-change may be invoked by pressing ESCAPE)")
        ((:sym cancel-button "(instantiable dialog-item class)"))
        ((:sym button-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:sym return-nil-from-pop-up-dialog
          "(default on-change handler)")))
       ((:header "radio-button")
        ((:sym radio-button "(instantiable dialog-item class)"))
        ((:sym radio-button-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Radio-Buttons")
         ((:sym value "(non-nil while the button is checked)"))
         ((:sym cluster)) ((:sym click-off)) ((:sym wrapping))))
       ((:header "check-box")
        ((:sym check-box "(instantiable dialog-item class)"))
        ((:sym check-box-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Check-Boxes")
         ((:sym value "(non-nil while the button is checked)"))
         ((:sym three-state)) ((:sym wrapping))))
       ((:header "picture-button")
        ((:sym picture-button "(instantiable dialog-item class)"))
        ((:sym picture-button-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Picture-Buttons")
         ((:header "For the Displayed Pixmap") ((:sym pixmap))
          ((:sym pixmap-name)) ((:sym pixmap-source))
          ((:sym pixmap-icon)) ((:sym pixmap-use-handle))
          ((:sym stretching)) ((:sym pressed-color-mapper))
          ((:sym unavailable-color-mapper)))
         ((:sym value "(non-nil while the button is pressed)"))
         ((:sym cluster)) ((:sym click-off)) ((:sym draw-focus))))
       ((:header "multi-picture-button")
        ((:sym multi-picture-button
          "(instantiable dialog-item class)"))
        ((:sym multi-picture-button-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Multi-Picture-Buttons")
         ((:header "Button Arrangement") ((:sym unavailable-buttons))
          ((:sym hidden-buttons)) ((:sym fill-order)) ((:sym spacing))
          ((:sym padding)) ((:sym gap-size)))
         ((:header "Button STyle") ((:sym button-3d-border))
          ((:sym button-black-border)) ((:sym recessed))
          ((:sym retain-scroll-arrows-always)) ((:sym draw-focus)))
         ((:header "For the Displayed Pixmaps")
          ((:sym pressed-color-mapper))
          ((:sym unavailable-color-mapper)))
         ((:sym value "(a list of the names of the pressed buttons)"))
         ((:sym range "(the list of button-info objects)"))
         ((:sym cluster)) ((:sym click-off))
         ((:sym multiple-selections)) ((:sym unpress-automatically))
         ((:sym use-default-tooltips)))
        ((:header "Functions") ((:sym multi-picture-button-scroll))
         ((:sym multi-picture-button-scroll-interval
           "(configuration option)"))
         ((:sym update-multi-picture-button)))
        ((:header
          "Individual Buttons in a Multi-Picture-Button's Range")
         ((:sym button-info "(instantiable class)"))
         ((:sym button-info-p))
         ((:header "Special Properties for Button-Infos")
          ((:header "Event-Handlers") ((:sym multipic-button-mouse-in))
           ((:sym multipic-button-mouse-out)))
          ((:header "For the Displayed Pixmap") ((:sym pixmap))
           ((:sym pixmap-name)) ((:sym pixmap-source))
           ((:sym pixmap-icon)) ((:sym pixmap-use-handle))
           ((:sym stretching)))))))
      ((:header "Text Controls")
       ((:header "static-text")
        ((:sym static-text "(instantiable dialog-item class)"))
        ((:sym static-text-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Static-Texts")
         ((:sym value "(contains the displayed string)"))
         ((:sym justification))))
       ((:header "scrolling-static-text")
        ((:sym scrolling-static-text))
        ((:sym scrolling-static-text-pane))
        ((:header "Special Properties for Scrolling-Static-Texts")
         ((:sym margin-around-text)) ((:sym horizontal-justification))
         ((:sym vertical-justification)) ((:sym border))
         ((:sym border-color)) ((:sym draw-focus)) ((:sym value))))
       ((:header "editable-text")
        ((:sym editable-text "(instantiable class)"))
        ((:sym editable-text-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Editable-Texts")
         ((:sym value "(contains the displayed string)"))
         ((:sym delayed)) ((:sym template-string)) ((:sym password)))
        ((:header "Functions")
         ((:header
           "Template Strings   (for restricting the form of typed input)")
          ((:sym template-string)) ((:sym clear-template))
          ((:sym *template-chars*)) ((:sym digit-char-or-space-p)))
         ((:sym get-selection
           "(returns the selection range or the text cursor position)"))
         ((:sym set-selection
           "(sets the selection range or the text cursor position)"))
         ((:sym file-position
           "(returns or sets the text cursor position)"))
         ((:sym text-edit-margins))))
       ((:header "multi-line-editable-text")
        ((:sym multi-line-editable-text
          "(instantiable dialog-item class)"))
        ((:sym text-edit-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Multi-Line-Editable-Texts")
         ((:sym value "(contains the entire text as a single string)"))
         ((:sym delayed)) ((:sym font)) ((:sym tabs))
         ((:sym read-only)) ((:sym justification))
         ((:sym notify-when-selection-changed))
         ((:sym save-selection-when-unfocused))
         ((:sym show-selection-when-unfocused)))
        ((:header "Functions")
         ((:header "Accessing the Text")
          ((:info
            "Use CL stream output functions like FORMAT to add text to the window of the widget."))
          ((:sym value "(returns or sets all of the text)"))
          ((:sym text-range
            "(returns an arbitrary substring of the text)"))
          ((:sym text-line "(returns one complete line of the text)"))
          ((:sym file-length "(returns the length of all the text)")))
         ((:header
           "The Currently Selected Text or Text Cursor Position")
          ((:sym get-selection
            "(returns the selection range or the text cursor position)"))
          ((:sym set-selection
            "(sets the selection range or the text cursor position)"))
          ((:sym file-position
            "(returns or sets the text cursor position)"))
          ((:sym selection-changed "(overridable generic function)")))
         ((:header "Character and Line Indices")
          ((:sym number-of-text-lines)) ((:sym current-line-number))
          ((:sym current-text-column)) ((:sym first-visible-line))
          ((:sym set-first-visible-line))
          ((:sym line-number-from-char))
          ((:sym char-from-line-number)))
         ((:header "Searching a Text Control") ((:sym string-search))
          ((:sym string-replace)))))
       ((:header
         "lisp-text   (an editable-text whose value is any lisp object)")
        ((:sym lisp-text "(instantiable dialog-item class)"))
        ((:sym lisp-text-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Lisp-Texts")
         ((:info
           "Inherits the properties of editable-text, except for template-string and password."))
         ((:sym on-print))))
       ((:header
         "multi-line-lisp-text   (a multi-line-editable-text whose value is any lisp object)")
        ((:sym multi-line-lisp-text
          "(instantiable dialog-item class)"))
        ((:sym lisp-edit-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Multi-Line-Lisp-Texts")
         ((:info
           "Inherits the properties of multi-line-editable-text."))
         ((:sym on-print))))
       ((:header "rich-edit   (handles formatted text)")
        ((:doc "Rich Text Overview" "cg/cg-rich-text.htm"))
        ((:sym rich-edit-pane
          "(the associated auto-instantiated widget-window class)"))))
      ((:header "List Controls")
       ((:header "Item Lists")
        ((:header "single-item-list")
         ((:sym single-item-list "(instantiable dialog-item class)"))
         ((:sym single-item-list-pane
           "(the associated auto-instantiated widget-window class)"))
         ((:header "Special Properties for Single-Item-Lists")
          ((:sym value "(the currently-selected choice)"))))
        ((:header "multi-item-list")
         ((:sym multi-item-list "(instantiable dialog-item class)"))
         ((:sym multi-item-list-pane
           "(the associated auto-instantiated widget-window class)"))
         ((:header "Special Properties for Multi-Item-Lists")
          ((:sym value "(a list of the currently-selected choices)"))
          ((:sym simple-click-toggle))))
        ((:header "Special Properties for All Item-Lists")
         ((:sym range "(the list of choices)"))
         ((:header "Multiple Columns") ((:sym multi-column-p))
          ((:sym column-width)) ((:sym tabs))
          ((:sym select-on-multiple-characters))
          ((:sym select-on-multiple-characters-time-limit))))
        ((:header "Manipulating Items") ((:sym list-widget-add-item))
         ((:sym list-widget-remove-item))
         ((:sym list-widget-replace-item))
         ((:sym list-widget-move-item)))
        ((:header "Accessing Items by Index")
         ((:sym list-widget-get-index)) ((:sym list-widget-set-index))
         ((:sym first-visible-line)) ((:sym set-first-visible-line))))
       ((:header "combo-box")
        ((:sym combo-box "(instantiable dialog-item class)"))
        ((:sym combo-box-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Combo-Boxes")
         ((:sym value "(the currently-selected choice)"))
         ((:sym range "(the list of choices)")) ((:sym typable))
         ((:sym delayed)))
        ((:sym drop-combo-box)) ((:sym undrop-combo-box))
        ((:sym dropping
          "(non-dropping combo-boxes are not supported due to redisplay glitch)")))
       ((:header "outline")
        ((:nav "Navigator Outline Example" :disk-usage-example))
        ((:sym outline "(instantiable dialog-item class)"))
        ((:sym outline-top-pane
          "(the top pane of a non-dropping outline)"))
        ((:sym outline-pane "(the pane that draws the outline image)"))
        ((:sym outline-widget-pane "(any pane of an outline widget)"))
        ((:sym dropping-outline "(instantiable dialog-item class)"))
        ((:sym outline-display-pane
          "(the top pane of a dropping-outline)"))
        ((:sym outline-dropping-pane
          "(the pane of a dropping-outline that drops)"))
        ((:header "Special Properties for Outlines")
         ((:sym range
           "(for an outline, a list of outline-item objects)"))
         ((:sym value
           "(for an outline, the value of the selected outline-item)"))
         ((:sym multiple-selections)) ((:sym simple-click-toggle))
         ((:sym indentation)) ((:sym select-on-open))
         ((:sym editable-in-place)) ((:sym close-subtrees-on-close))
         ((:sym select-on-right-click))
         ((:sym top-level-dropper "(for dropping-outline only)"))
         ((:sym highlight-ancestors))
         ((:sym ancestor-background-color))
         ((:sym handle-above-parent))
         ((:header "Using Tabs for Outline Columns") ((:sym tabs))
          ((:sym tabs-clip)) ((:sym right-justification-width))
          ((:doc
            "The Runtime Analyzer Results Dialog   (uses tabs in an outline)"
            "ide-menus-and-dialogs/runtime-analyzer-results-dialog.htm")))
         ((:header "Selecting Items by Typing Multiple Characters")
          ((:sym select-on-multiple-characters))
          ((:sym select-on-multiple-characters-time-limit))
          ((:sym select-on-multiple-characters-callback))
          ((:sym select-on-multiple-characters-item-test)))
         ((:header "Which Outline Ornaments to Draw")
          ((:sym draw-icons)) ((:sym draw-plus-minus))
          ((:sym draw-lines)))
         ((:header "Default Pixmap Images for the Outline Items")
          ((:sym opened-pixmap)) ((:sym opened-pixmap-name))
          ((:sym opened-pixmap-source)) ((:sym closed-pixmap))
          ((:sym closed-pixmap-name)) ((:sym closed-pixmap-source))
          ((:sym leaf-pixmap)) ((:sym leaf-pixmap-name))
          ((:sym leaf-pixmap-source))))
        ((:header "Outline Items   (for each row of an outline)")
         ((:sym outline-item "(instantiable class)"))
         ((:header "Special Properties for Outline-Items")
          ((:sym state "(either :closed or :open or :partially-open)"))
          ((:sym range "(a list of subitem outline-items)"))
          ((:sym available "(whether this item may be selected)"))
          ((:sym outline "(the outline that this item is on)"))
          ((:sym kind
            "(an arbitrary place for application information)"))
          ((:sym has-range-on-open)) ((:sym above-parent))
          ((:header "Pixmap Images for an Individual Outline Item")
           ((:sym opened-pixmap)) ((:sym opened-pixmap-name))
           ((:sym opened-pixmap-source)) ((:sym closed-pixmap))
           ((:sym closed-pixmap-name)) ((:sym closed-pixmap-source))
           ((:sym leaf-pixmap)) ((:sym leaf-pixmap-name))
           ((:sym leaf-pixmap-source)) ((:sym pixmap-use-handle))))
         ((:header "Adding and Removing Individual Outline-Items")
          ((:sym add-outline-item)) ((:sym add-outline-item-value))
          ((:sym remove-outline-item-value)))
         ((:header
           "Accessing Outline Items   (from their name and outline)")
          ((:sym find-outline-item)) ((:sym focused-outline-item))
          ((:sym outline-item-parent)) ((:sym outline-item-children))
          ((:sym outline-item-level)) ((:sym outline-item-from-index))
          ((:sym index-from-outline-item))
          ((:sym index-from-outline-item-value))
          ((:header "Pixmaps") ((:sym outline-item-closed-pixmap))
           ((:sym outline-item-opened-pixmap))
           ((:sym outline-item-leaf-pixmap))))
         ((:header "Manipulating Outline Items")
          ((:sym select-outline-item)) ((:sym selected-outline-item))
          ((:sym add-outline-item)) ((:sym add-outline-item-value))
          ((:sym remove-outline-item-value))
          ((:sym open-outline-item-value))
          ((:sym close-outline-item-value))
          ((:sym state
            "(call (setf state) on an outline-item to open or close it)"))
          ((:sym replace-outline-item-value))
          ((:sym move-outline-item-value))
          ((:sym change-outline-item-value-availability))
          ((:sym change-outline-item-availability
            "(deprecated; call (setf available) on the outline-item)"))
          ((:sym invalidate "(redraws an individual item)")))
         ((:header
           "Specifying Child Items Lazily   (when the parent item is opened)")
          ((:sym range-on-open)) ((:sym range-on-close))
          ((:sym has-range-on-open)))
         ((:header "Outline Item Color") ((:sym background-color))
          ((:sym foreground-color))
          ((:sym outline-item-selected-background-color))
          ((:sym outline-item-selected-foreground-color))))
        ((:header "Default Pixmap Images")
         ((:sym default-opened-pixmap)) ((:sym default-closed-pixmap))
         ((:sym default-leaf-pixmap)))
        ((:header "Customizing the Drawing of Outlines")
         ((:sym redisplay-outline-item-value
           "(overridable generic function)")))
        ((:header "Other Outline Functions") ((:sym focus-index))
         ((:sym scroll-current-index-into-view))
         ((:sym draw-on-printer))))
       ((:header "list-view")
        ((:sym list-view "(instantiable dialog-item class)"))
        ((:sym list-view-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for List-Views")
         ((:sym value "(holds the value of the selected row item)"))
         ((:sym range "(holds the list of row items)"))
         ((:sym columns "(hold the list of columns)"))
         ((:sym layout-style)) ((:sym multiple-selections))
         ((:sym sort-column)) ((:sym sort-reverse)) ((:sym headers)))
        ((:header "List-View Items (Rows)")
         ((:sym list-view-item "(instantiable class)"))
         ((:header "Special Properties for List-View-Items")
          ((:sym value-plist))
          ((:header
            "Properties for Checked List-View-Items (Windows only)")
           ((:sym show-check-boxes)) ((:sym checked))
           ((:sym on-check)))
          ((:header "Other Windows-Only List-View-Item Properties")
           ((:sym icon-index)) ((:sym state-icon-index))
           ((:sym show-grid-lines)) ((:sym draggable-headers))
           ((:sym full-row-select))))
         ((:header "Functions") ((:sym add-item)) ((:sym remove-item))
          ((:sym find-item)) ((:sym value-from-item)) ((:sym selected))
          ((:sym parent
            "(returns the list-view of the list-view-item)"))
          ((:sym index)) ((:sym list-view-item-position))))
        ((:header "List-View Columns")
         ((:sym list-view-column "(instantiable class)"))
         ((:header "Special Properties for List-View-Columns")
          ((:sym name)) ((:sym title)) ((:sym justification))
          ((:sym width)) ((:sym on-sort-predicate))
          ((:sym on-sort-key)) ((:sym on-print)))
         ((:header "Functions") ((:sym add-column))
          ((:sym remove-column)) ((:sym find-column))
          ((:sym column-click))
          ((:sym list-view "(returns the list-view of this column)"))
          ((:sym index))))
        ((:header "Using Icons in List-Views") ((:sym image-list))
         ((:sym large-image-list)) ((:sym small-image-list))
         ((:sym state-image-list)) ((:sym icon-index))
         ((:sym state-icon-index)) ((:sym alignment))
         ((:sym auto-arrange)) ((:sym arrange-icons))
         ((:sym share-image-lists)) ((:sym open-image-list))
         ((:sym close-image-list)) ((:sym image-list-open-p)))
        ((:header "Other List-View Functions")
         ((:sym list-view-cell-value)) ((:sym list-view-cell-box))
         ((:sym list-view-sort)) ((:sym auto-size))
         ((:sym scroll-current-index-into-view)))))
      ((:header "Scrollers and Gauges")
       ((:header "Scroll-Bars")
        ((:nav "Navigator Scroll-Bar Example" :car-demo-example))
        ((:sym vertical-scroll-bar "(instantiable dialog-item class)"))
        ((:sym vertical-scroll-bar-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:sym horizontal-scroll-bar
          "(instantiable dialog-item class)"))
        ((:sym horizontal-scroll-bar-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for All Scroll-Bars")
         ((:sym range
           "(a list of the minimum and maximum allowed values)"))
         ((:sym increment)) ((:sym page-increment))
         ((:sym direction-of-increase))
         ((:sym delayed
           "(whether the on-change is called during dragging)"))
         ((:sym thumb-length))
         ((:sym visible-portion "(deprecated; use thumb-length)"))))
       ((:header "trackbar")
        ((:sym trackbar "(instantiable dialog-item class)"))
        ((:sym trackbar-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Trackbars")
         ((:sym range
           "(a list of the minimum and maximum allowed values)"))
         ((:sym increment)) ((:sym page-increment))
         ((:sym direction-of-increase)) ((:sym orientation))
         ((:sym tick-side)) ((:sym tick-frequency))
         ((:sym select-range)) ((:sym visible-range))
         ((:sym no-pointer))
         ((:sym delayed
           "(whether the on-change is called during dragging)")))
        ((:header "Functions") ((:sym tick-position))))
       ((:header "up-down-control")
        ((:sym up-down-control "(instantiable dialog-item class)"))
        ((:sym up-down-control-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Up-Down Controls")
         ((:sym range
           "(a list of the minimum and maximum allowed values)"))
         ((:sym orientation)) ((:sym wrapping))
         ((:sym direction-of-increase))
         ((:header "Pairing with an Editable-Text Control")
          ((:sym buddy-widget)) ((:sym buddy-side)))))
       ((:header "progress-indicator")
        ((:sym progress-indicator "(instantiable dialog-item class)"))
        ((:sym progress-indicator-pane
          "(the associated auto-instantiated widget-window class)"))))
      ((:header "Other Controls")
       ((:header "group-box")
        ((:sym group-box "(instantiable dialog-item class)"))
        ((:sym group-box-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "Special Properties for Group-Boxes")
         ((:sym border "(there are unique choices for group-boxes)"))
         ((:sym 3d-style
           "(same as border; for backward compatibility only)")))
        ((:header "Deprecated Group-Box Classes")
         ((:sym lisp-group-box "(use group-box)"))))
       ((:header "tab-control")
        ((:sym tab-control "(instantiable dialog-item class)"))
        ((:sym tab-control-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:sym tab-info
          "(instantiable class for each tab of a tab-control)"))
        ((:sym tab-info-p))
        ((:header "Special Properties for Tab-Controls")
         ((:sym value "(the name of the currently selected tab)"))
         ((:sym range
           "(the list of tab-info objects for the set of tabs)"))
         ((:sym tab-height)) ((:sym tab-width)) ((:sym fixed-width))
         ((:sym single-line)) ((:sym ragged-right))
         ((:sym button-style)) ((:sym focus-on-click))
         ((:sym tabs-are-draggable)) ((:sym tab-side)))
        ((:header "Functions")
         ((:header "Selecting Tabs Programmatically")
          ((:sym value "(use (setf value) to select a tab)"))
          ((:sym select-adjacent-tab)) ((:sym select-recent-tab)))
         ((:header "Adding and Removing Tabs") ((:sym add-tab))
          ((:sym remove-tab)) ((:sym restore-tab)))
         ((:header "Adding Controls to Tabs")
          ((:sym add-component-to-tab)) ((:sym remove-component))
          ((:sym remove-component-from-tab)))
         ((:header "Special Properties for Tab-Infos") ((:sym name))
          ((:sym title))
          ((:header "Deprecated Properties for Tab-Infos")
           ((:sym id "(use name)")) ((:sym label "(use title)"))))
         ((:header "Tab-Info Geometry") ((:sym tab-at-position))
          ((:sym tab-box)) ((:sym tab-size)) ((:sym set-tab-size))
          ((:sym row-count)) ((:sym rows-height)))
         ((:header "Configuration Options for Tab-Infos")
          ((:sym default-tab-height)) ((:sym default-tab-width)))
         ((:header "Other Tab-Info Functions") ((:sym find-tab))
          ((:sym highlight-tab)) ((:sym tab-control-widget))
          ((:sym tab-label)) ((:sym index)))
         ((:sym selected-tab-color))))
       ((:header "static-picture")
        ((:sym static-picture "(instantiable dialog-item class)"))
        ((:sym static-picture-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:header "For the Displayed Pixmap") ((:sym pixmap))
         ((:sym pixmap-name)) ((:sym pixmap-source))
         ((:sym pixmap-icon)) ((:sym pixmap-use-handle))
         ((:sym stretching)) ((:sym unavailable-color-mapper))
         ((:header "Cycling Through Multiple Pixmaps")
          ((:sym pixmap-alist)) ((:sym pixmap-value-test))
          ((:sym user-modifiable)) ((:sym draw-focus)))))
       ((:header "split-bar   (for resizing panes or sets of widgets)")
        ((:sym split-bar "(instantiable dialog-itemm class)"))
        ((:sym split-bar-pane))
        ((:header "Split-Bar Properties") ((:sym orientation))
         ((:sym bar-thickness)) ((:sym dragging-thickness))
         ((:sym draw-at-dragging-thickness)) ((:sym min-space-before))
         ((:sym min-space-after)) ((:sym end1-position))
         ((:sym end2-position)) ((:sym color-when-idle))
         ((:sym color-under-mouse)) ((:sym color-when-dragging))
         ((:sym widgets-to-resize)) ((:sym widgets-to-move))
         ((:sym delayed)) ((:sym on-drag)) ((:sym on-redisplay))
         ((:sym now-dragging)) ((:sym now-under-mouse))))
       ((:header "lamp   (an LED widget that can blink)")
        ((:header "Lamp Classes")
         ((:sym lamp "(instantiable dialog-item class)"))
         ((:sym lamp-pane)))
        ((:header "Lamp Properties") ((:sym blink-on-milliseconds))
         ((:sym blink-off-milliseconds))
         ((:sym inner-horizontal-margin))
         ((:sym inner-vertical-margin)) ((:sym lamp-height))
         ((:sym lamp-shape)) ((:sym lamp-width)) ((:sym off-color))
         ((:sym off-color-factor)) ((:sym on-color))
         ((:sym outer-horizontal-margin))
         ((:sym outer-vertical-margin)) ((:sym title-off-color))
         ((:sym title-on-color)) ((:sym title-side)) ((:sym wrapping)))
        ((:header "Using Arrays of LEDs in a Single Lamp Widget")
         ((:sym row-labels)) ((:sym column-labels))
         ((:sym row-label-side)) ((:sym column-label-side))
         ((:sym row-label-margin)) ((:sym column-label-margin))
         ((:sym row-label-offset)) ((:sym column-label-offset))
         ((:sym column-label-orientation)) ((:sym center-all))
         ((:sym update-lamp))))
       ((:header
         "chart-widget   (draws 2D line graphs and bar charts)")
        ((:header "Chart-Widget Classes")
         ((:sym chart-widget "(instantiable dialog-item class)"))
         ((:sym chart-widget-pane)) ((:sym chart-or-plot))
         ((:sym chart-or-plot-pane))
         ((:sym chart-axis "(superclass of item-axis and value-axis)"))
         ((:sym item-axis "(an instantiable chart subobject)"))
         ((:sym value-axis "(an instantiable chart subobject)"))
         ((:sym chart-or-plot-view
           "(superclass of chart-view and plot-view)"))
         ((:sym icon-drawing-view
           "(superclass of line-graph-view and plot-view)"))
         ((:sym line-drawing-view
           "(superclass of line-graph-view and plot-view)"))
         ((:sym chart-view
           "(superclass of bar-chart-view and line-graph-view)"))
         ((:sym bar-chart-view "(an instantiable chart subobject)"))
         ((:sym line-graph-view "(an instantiable chart subobject)"))
         ((:sym chart-legend "(an instantiable chart subobject)")))
        ((:header "Chart-Widget Properties")
         ((:header "Properties on Chart-Widget Itself")
          ((:header "Some Main Chart-Widget Properties")
           ((:sym chart-orientation)) ((:sym chart-value-returner))
           ((:sym chart-view)) ((:sym draw-legend))
           ((:sym value-types)) ((:sym warn-on-insufficient-data)))
          ((:header "Chart-Widget Pointers to Chart Sub-Objects")
           ((:header "Pointers to Chart Axes") ((:sym item-axis))
            ((:sym value-axis)) ((:sym value-axis-2)))
           ((:header "Pointers to Other Chart Sub-Objects")
            ((:sym bar-chart-view)) ((:sym chart-legend))
            ((:sym line-graph-view))))
          ((:header "Chart-Widget Properties for Chart Items")
           ((:sym chart-item-id-equality-test)) ((:sym chart-items))
           ((:sym chart-items-length)) ((:sym chart-items-limit))
           ((:sym chart-items-max-index))
           ((:sym chart-items-min-index))
           ((:sym chart-items-pushed-off)) ((:sym fit-chart-items)))
          ((:header "Chart-Widget Properties for Chart Objects")
           ((:sym chart-object-id-equality-test))
           ((:sym chart-objects)))
          ((:header "Chart-Widget Properties for Scrolling")
           ((:sym scroll-line-items)) ((:sym scroll-on-drag))
           ((:sym scroll-on-drag-factor)) ((:sym scroll-page-portion))
           ((:sym scroll-position)) ((:sym scrolled-to-end))
           ((:sym scrolled-to-end-maintained)))
          ((:header "Chart Titles and Footnotes") ((:sym footnote))
           ((:sym footnote-color)) ((:sym footnote-font))
           ((:sym subtitle)) ((:sym subtitle-color))
           ((:sym subtitle-font)) ((:sym title)) ((:sym title-color))
           ((:sym title-font)))
          ((:header "Stylistic Properties of the Whole Chart")
           ((:header "Spacing Between Chart Parts")
            ((:sym margin-above-legend)) ((:sym margin-above-footnote))
            ((:sym margin-below-subtitle)) ((:sym margin-below-title))
            ((:sym margin-outer-bottom)) ((:sym margin-outer-left))
            ((:sym margin-outer-right)) ((:sym margin-outer-top)))
           ((:header "The Chart Body") ((:sym body-background-color))
            ((:sym body-border-color)) ((:sym body-border-width))
            ((:sym extend-data-to-middle-of-border))
            ((:sym outer-border-color)) ((:sym outer-border-width)))
           ((:header "Color Gradients") ((:sym body-gradient-filling))
            ((:sym body-gradient-direction))
            ((:sym body-gradient-intensity))
            ((:sym body-gradient-blend)) ((:sym icon-gradient-filling))
            ((:sym icon-gradient-direction))
            ((:sym icon-gradient-intensity))
            ((:sym icon-gradient-blend)))))
         ((:header "Chart-Axis Properties")
          ((:header
            "Properties of All Chart Axes (both item-axis and value-axis)")
           ((:header "Some Main Chart Axis Properties")
            ((:sym axis-label)) ((:sym invert-axis))
            ((:sym minor-tics-per-major-tic)) ((:sym marker-lines)))
           ((:header "Whether to Draw Particular Axis Parts")
            ((:sym draw-major-grid-lines)) ((:sym draw-major-labels))
            ((:sym draw-major-tics)) ((:sym draw-minor-grid-lines))
            ((:sym draw-minor-labels)) ((:sym draw-minor-tics)))
           ((:header "How Frequently to Draw Tic Mark Labels")
            ((:sym major-label-frequency))
            ((:sym major-label-frequency-offset))
            ((:sym minor-label-frequency))
            ((:sym minor-label-frequency-offset)))
           ((:header "Formatting Values to Tic Label Strings")
            ((:sym on-print-major-label))
            ((:sym on-print-minor-label)))
           ((:header "Chart Axis Drawing Style Properties")
            ((:header "Drawing Style of the Axis Itself")
             ((:sym axis-color)) ((:sym axis-label-color))
             ((:sym axis-label-font)) ((:sym axis-width))
             ((:sym margin-inside-axis-label)))
            ((:header
              "Drawing Style of the Major Tic Marks, Labels and Grid Lines")
             ((:sym major-grid-line-color))
             ((:sym major-grid-line-dashing))
             ((:sym major-grid-line-width)) ((:sym major-label-color))
             ((:sym major-label-font)) ((:sym major-label-angle))
             ((:sym major-tic-length)) ((:sym major-tic-width))
             ((:sym margin-inside-major-labels)))
            ((:header
              "Drawing Style of the Minor Tic Marks, Labels and Grid Lines")
             ((:sym margin-inside-minor-labels))
             ((:sym minor-grid-line-color))
             ((:sym minor-grid-line-dashing))
             ((:sym minor-grid-line-width)) ((:sym minor-label-color))
             ((:sym minor-label-font)) ((:sym minor-label-angle))
             ((:sym minor-tic-length)) ((:sym minor-tic-width))
             ((:sym overlap-major-and-minor-labels)))))
          ((:header "Other Item-Axis Properties") ((:sym end-margin))
           ((:sym major-label-min-spacing))
           ((:sym major-label-wrapping))
           ((:sym minor-label-min-spacing))
           ((:sym minor-label-wrapping)) ((:sym minor-tic-increment)))
          ((:header "Other Value-Axis Properties")
           ((:sym major-tic-increment)) ((:sym range-bottom))
           ((:sym range-top))))
         ((:header "Chart View Properties")
          ((:header "Properties for All Chart Views")
           ((:sym values-are-stacked)) ((:sym draw-high-low-values))
           ((:sym high-low-value-style)) ((:sym high-low-fill-colors))
           ((:sym high-low-tee-colors)))
          ((:header "Bar-Chart-View Properties")
           ((:sym bar-border-colors)) ((:sym bar-colors))
           ((:sym bar-fill-textures)) ((:sym bar-width))
           ((:sym bar-spacing)) ((:sym base-line-color))
           ((:sym base-line-drawn)) ((:sym base-line-width))
           ((:sym base-value))
           ((:header "Color Gradients for Bars")
            ((:sym bar-gradient-filling))
            ((:sym bar-gradient-direction))
            ((:sym bar-gradient-intensity))
            ((:sym bar-gradient-blend))))
          ((:header "Line-Graph-View Properties") ((:sym draw-lines))
           ((:sym draw-icons)) ((:sym icon-line-widths))
           ((:sym icon-sizes)) ((:sym icon-images))
           ((:sym icon-fill-colors)) ((:sym icons-filled))
           ((:sym line-colors)) ((:sym line-dashings))
           ((:sym line-widths)) ((:sym span-missing-items))
           ((:sym value-spacing))))
         ((:header "Chart-Legend Properties")
          ((:sym draw-legend-border)) ((:sym border-color))
          ((:sym legend-font)) ((:sym icon-size)) ((:sym icon-spacing))
          ((:sym interior-horizontal-margin))
          ((:sym interior-vertical-margin)) ((:sym layout-orientation))
          ((:sym horizontal-spacing)) ((:sym icon-line-length))
          ((:sym on-print-chart-object)) ((:sym vertical-spacing))
          ((:sym click-to-toggle-inclusion))))
        ((:header "Chart-Widget Functions") ((:sym chart-value))
         ((:sym set-chart-value)) ((:sym update-chart-widget))))
       ((:header "plot-widget   (draws 2D scatter plots)")
        ((:header "Plot-Widget Classes")
         ((:sym plot-widget "(instantiable dialog-item class)"))
         ((:sym plot-widget-pane)) ((:sym plot-view))
         ((:sym plot-value-axis)))
        ((:header
          "Plot-Widget Properties (others are listed under chart-widget)")
         ((:sym plot-value-returner)) ((:sym plot-values))
         ((:sym plot-values-max-index)) ((:sym plot-values-min-index))
         ((:sym plot-view)) ((:sym x-axis)) ((:sym y-axis))
         ((:sym x-axis-2)) ((:sym y-axis-2)))
        ((:header "Plot-View Properties")
         ((:sym draw-regression-lines)) ((:sym regression-line-colors))
         ((:sym regression-line-dashings))
         ((:sym regression-line-widths)))
        ((:header "Plot-Widget Functions") ((:sym plot-value))
         ((:sym set-plot-value))))
       ((:header "grid-widget")
        ((:nav "The Simple Navigator Grid-Widget Example"
          :color-grid-example))
        ((:nav "A Spreadsheet Grid-Widget Example" :grid-edit-example))
        ((:nav "The Sophisticated Navigator Grid-Widget Example"
          :grid-test-example))
        ((:nav "Built-In Widgets in Arbitrary Grid Cells"
          :cell-widgets-example))
        ((:header "Grid Classes")
         ((:header "The Grid-Widget Itself")
          ((:sym grid-widget "(instantiable dialog-item class)"))
          ((:sym grid-top-pane
            "(the associated auto-instantiated widget-window class)"))
          ((:header "Special Properties for Grid-Widgets")
           ((:sym column-sections)) ((:sym row-sections))
           ((:sym focus-column-section)) ((:sym focus-row-section))
           ((:sym delay-write-cell-value))
           ((:header "Showing the Keyboard Focus") ((:sym show-focus))
            ((:sym deselect-sections-when-lose-focus))
            ((:sym deselect-sections-when-move-focus))
            ((:sym keep-focus-in-view)))
           ((:header "Borders") ((:sym border-width))
            ((:sym border-color)) ((:sym default-cell-3d-border))
            ((:sym default-cell-border-color))
            ((:sym default-cell-border-width))
            ((:sym default-section-border-color))
            ((:sym default-section-border-width)))
           ((:sym minimum-size))
           ((:sym scroll-parent-section-while-dragging))
           ((:sym scroll-parent-section-distance)) ((:sym sort-column))
           ((:sym sort-reverse))))
         ((:header "Grid Sections   (individually scrollable areas)")
          ((:header "Grid Main Sections")
           ((:sym grid-section "(superclass)"))
           ((:header "Special Properties for All Main Grid Sections")
            ((:sym subsections)) ((:sym focus-subsection))
            ((:sym scrollbars)) ((:sym uniform-resizing))
            ((:sym empty-color)) ((:sym default-cell-3d-border))
            ((:sym default-cell-border-color))
            ((:sym default-cell-border-width)))
           ((:header "Functions for All Main Grid Sections")
            ((:sym scrollbar-area-box))
            ((:sym stretch-section "(extendable generic function)")))
           ((:header "grid-column-section")
            ((:sym grid-column-section "(instantiable class)")))
           ((:header "grid-row-section")
            ((:sym grid-row-section "(instantiable class)"))
            ((:sym row-section-with-sort-gadget-mixin
              "(mixin class)"))))
          ((:header "Grid Subsections   (rows and columns)")
           ((:sym grid-subsection "(superclass)"))
           ((:header "Special Properties for All Grid Subsections")
            ((:sym section-count)) ((:sym movable)) ((:sym deletable))
            ((:sym selectable)) ((:sym selected)) ((:sym available)))
           ((:header "Functions for All Grid Subsections")
            ((:sym move-subsection))
            ((:sym slide-subsection "(extendable generic function)"))
            ((:sym stretch-subsection "(extendable generic function)"))
            ((:sym confirm-grid-subsection-deletion
              "(overridable generic function)"))
            ((:sym subsection-sequence-changed
              "(extendable generic function)")))
           ((:header "Grid Columns")
            ((:sym grid-column "(instantiable class)"))
            ((:sym add-column)) ((:sym delete-column))
            ((:header "Special Properties for Grid-Columns")
             ((:sym horizontal-justification))
             ((:sym vertical-justification))
             ((:sym horizontal-padding)) ((:sym vertical-padding))
             ((:sym single-line)) ((:sym on-print)) ((:sym data-slot))
             ((:sym data-reader)) ((:sym data-writer))
             ((:sym data-read-converter)) ((:sym data-write-converter))
             ((:sym range-reader)) ((:sym font-reader))
             ((:sym selected-reader)) ((:sym available-reader))
             ((:sym sortable)) ((:sym on-sort-predicate)))
            ((:header "Mixin Classes")
             ((:header "Column Classes with Built-In Controls")
              ((:sym widget-column-mixin "(general superclass)"))
              ((:sym static-text-column-mixin "(mixin class)"))
              ((:header "static-text-and-button-column-mixin")
               ((:sym static-text-and-button-column-mixin
                 "(mixin class)"))
               ((:sym button-function)) ((:sym button-fills-cell)))
              ((:header "editable-text-column-mixin")
               ((:sym editable-text-column-mixin "(mixin class)"))
               ((:sym edit-start-trigger)) ((:sym edit-end-trigger))
               ((:sym template-string)) ((:sym template-allows-sign))
               ((:sym scrollbars)))
              ((:header "check-box-column-mixin")
               ((:sym check-box-column-mixin "(mixin class)"))
               ((:sym title-reader)) ((:sym click-must-be-on-gadget)))
              ((:header "combo-box-column-mixin")
               ((:sym combo-box-column-mixin "(mixin class)"))
               ((:sym menu-items-for-combo-box-range)) ((:sym typable))
               ((:sym on-print)) ((:sym click-must-be-on-gadget))
               ((:sym use-real-combo-box)) ((:sym template-string))
               ((:sym template-allows-sign)))
              ((:header "pixmap-column-mixin")
               ((:sym pixmap-column-mixin "(mixin class)"))
               ((:sym pixmap-alist)) ((:sym pixmap-value-test))
               ((:sym stretching)) ((:sym user-modifiable)))
              ((:header "lamp-column-mixin")
               ((:sym lamp-column-mixin "(mixin class)"))
               ((:sym lamp-widget)) ((:sym title-reader))))
             ((:sym row-selecting-column-mixin "(mixin class)"))
             ((:sym row-sizing-column-mixin "(mixin class)"))))
           ((:header "Grid Rows")
            ((:sym grid-row "(instantiable class)")) ((:sym add-row))
            ((:sym delete-row))
            ((:header "Mixin Classes") ((:sym widget-row-mixin))
             ((:sym column-selecting-row-mixin))
             ((:sym column-sizing-row-mixin)))
            ((:header "Special Properties for Grid-Rows")
             ((:sym data-object))))
           ((:header "Header Subsections") ((:sym row-header-column))
            ((:sym column-header-row))))
          ((:header
            "Special Properties for All Grid Sections & Subsections")
           ((:sym grid "(the grid-widget that the section is in)"))
           ((:sym section-size "(breadth of the section)"))
           ((:sym resizable)) ((:sym proportional))
           ((:sym minimum-size)) ((:sym border-width))
           ((:sym border-dashing)) ((:sym border-color))
           ((:sym effective-border-width (read-only)))
           ((:sym effective-border-color (read-only)))
           ((:sym edge-position (read-only))))
          ((:header "Functions for All Grid Sections & Subsections")
           ((:sym section-box)) ((:sym cross-section-box))
           ((:sym invalidate-whole-section))))
         ((:header
           "Cell Methods   (specializing on a particular grid-row and grid-column)")
          ((:header "Cell Value") ((:sym read-cell-value))
           ((:sym write-cell-value)))
          ((:header "Cell Mouse and Keyboard Events")
           ((:sym cell-click)) ((:sym cell-mouse-in))
           ((:sym cell-mouse-out)) ((:sym cell-key-down)))
          ((:header "Caching Cell Values for Efficiency")
           ((:sym cache-cell-values)) ((:sym cache-all-cell-values))
           ((:sym clear-cached-cell-values))
           ((:sym clear-cached-cell-value)))
          ((:header "Delaying Modified Cell Values")
           ((:sym delay-write-cell-value))
           ((:sym write-delayed-cell-values))
           ((:sym clear-delayed-cell-values))
           ((:sym clear-delayed-cell-value)))
          ((:header "Using a Built-In Cell Widget")
           ((:sym cell-widget)))
          ((:header "Cell Availability") ((:sym cell-available))
           ((:sym cell-and-sections-available))
           ((:sym cell-unavailable-foreground-color)))
          ((:header "Cell Appearance") ((:sym draw-cell))
           ((:sym draw-cell-focus))
           ((:header "Color") ((:sym cell-background-color))
            ((:sym cell-foreground-color))
            ((:sym cell-selected-background-color))
            ((:sym cell-selected-foreground-color))
            ((:sym cell-horizontal-border-color))
            ((:sym cell-vertical-border-color))
            ((:sym cell-unavailable-foreground-color)))
           ((:sym cell-font)) ((:sym cell-3d-border))
           ((:sym cell-horizontal-padding))
           ((:sym cell-vertical-padding))
           ((:sym cell-horizontal-justification))
           ((:sym cell-vertical-justification))
           ((:sym cell-wrapped-p)))
          ((:header "Other Cell Methods") ((:sym cell-box))
           ((:sym invalidate-cell)) ((:sym invalidate-section))
           ((:sym cell-draggable-p)) ((:sym cell-selected)))))
        ((:header "Drawing a Grid-Widget")
         ((:header "Redisplaying") ((:sym draw-grid))
          ((:sym clear-grid-section)) ((:sym draw-grid-section))
          ((:sym draw-cell)) ((:sym draw-cell-focus))
          ((:sym draw-scrollbar-area)) ((:sym grid-draw-string))
          ((:sym invalidate-cell)) ((:sym invalidate-section)))
         ((:header "Color") ((:sym border-color))
          ((:sym default-cell-border-color))
          ((:sym cell-background-color)) ((:sym cell-foreground-color))
          ((:sym cell-unavailable-foreground-color))
          ((:sym empty-color))))
        ((:header "Scrolling a Grid-Widget") ((:sym scroll-section))
         ((:sym scroll-to-subsection))
         ((:sym scroll-subsection-into-view))
         ((:sym section-scrolled "(overridable generic function)"))
         ((:sym scroll-parent-section-while-dragging))
         ((:sym scroll-parent-section-distance)))
        ((:header "Sorting a Grid-Widget")
         ((:header "Programmatic Grid-Sorting") ((:sym sort-grid))
          ((:sym sort-column)) ((:sym sort-reverse)) ((:sym sortable))
          ((:sym on-sort-predicate)))
         ((:header "Interactive Grid-Sorting")
          ((:sym row-section-with-sort-gadget-mixin "(mixin class)"))
          ((:sym sort-on-click))))
        ((:header "Navigating a Grid-Widget")
         ((:header "Finding Grid Parts")
          ((:header "From Related Parts") ((:sym next-section))
           ((:sym previous-section)) ((:sym next-subsection))
           ((:sym previous-subsection)) ((:sym parent))
           ((:sym siblings)) ((:sym section-grid)))
          ((:header "From their Names") ((:sym column-section))
           ((:sym row-section)) ((:sym subsection))
           ((:sym find-sibling)))
          ((:header "By Position") ((:sym grid-part-under-point))))
         ((:sym scroll-position)) ((:sym cell-draggable-p)))
        ((:header "The Keyboard Focus Within a Grid-Widget")
         ((:header "Managing Which Cell Has the Focus")
          ((:sym focus-cell)) ((:sym set-focus-cell))
          ((:sym grid-shift-focus)) ((:sym tab-along-grid))
          ((:sym draw-cell-focus)))
         ((:header "Grid-Widget Focus Style") ((:sym show-focus))
          ((:sym keep-focus-in-view))
          ((:sym deselect-sections-when-lose-focus))
          ((:sym deselect-sections-when-move-focus))))
        ((:header
          "Overridable Event-Handling Generic Functions for Grid-Widgets")
         ((:header "Mouse Clicks") ((:sym grid-click))
          ((:sym cell-click)) ((:sym scrollbar-area-click))
          ((:sym grid-bottom-right-click))
          ((:sym *grid-border-mouse-slack*)))
         ((:header "Mouse Movement") ((:sym cell-mouse-in))
          ((:sym cell-mouse-out))))
        ((:header "Other Grid-Widget Functions")
         ((:sym select-subsection)) ((:sym deselect-subsection))
         ((:sym deselect-all-subsections))
         ((:sym delete-selected-subsections))
         ((:sym grid-drawing-pane))
         ((:sym grid-drawing-pane-class-for-grid))
         ((:sym grid-part-cursor)) ((:sym draw-on-printer))))
       ((:header
         "Class-Grid   (a high-level widget for editing class instances)")
        ((:header
          "Class-Grid Classes   (needed only for possible method specialization)")
         ((:sym class-grid)) ((:sym class-grid-top-pane))
         ((:sym class-grid-drawing-pane))
         ((:sym class-grid-body-column))
         ((:sym class-grid-body-column-section))
         ((:sym class-grid-body-row))
         ((:sym class-grid-body-row-section))
         ((:sym class-grid-check-box-column))
         ((:sym class-grid-column))
         ((:sym class-grid-column-header-row))
         ((:sym class-grid-column-header-row-section))
         ((:sym class-grid-column-section))
         ((:sym class-grid-combo-box-column))
         ((:sym class-grid-editable-text-column))
         ((:sym class-grid-lisp-text-column))
         ((:sym class-grid-numeric-editable-text-column))
         ((:sym class-grid-pixmap-column)) ((:sym class-grid-row))
         ((:sym class-grid-row-header-column-section))
         ((:sym class-grid-row-header-column))
         ((:sym class-grid-row-section))
         ((:sym class-grid-static-text-column)))
        ((:header "Class-Grid Properties") ((:sym edited-class))
         ((:sym edited-slots)) ((:sym body-row-height))
         ((:sym default-column-width)) ((:sym column-header-font))
         ((:sym column-header-height)) ((:sym horizontally-scrollable))
         ((:sym row-header-font)) ((:sym row-header-width))
         ((:sym row-header-justification))
         ((:sym row-header-value-type)) ((:sym rows-are-selectable))
         ((:sym rows-are-movable)) ((:sym rows-are-resizable)))
        ((:header "Class-Grid Functions") ((:sym add-class-grid-row))
         ((:sym delete-class-grid-row)))
        ((:header "Class-Grids on Object-Editor Dialogs")
         ((:sym slot-editing-class-grid
           "(used automatically by an object-editor)"))
         ((:header "Slot-Editing-Class-Grid Functions")
          ((:sym db-grid-create-button-on-change))
          ((:sym db-grid-delete-button-on-change))
          ((:sym db-grid-add-button-on-change))
          ((:sym db-grid-remove-button-on-change)))))
       ((:header "drawable")
        ((:sym drawable "(instantiable dialog-item class)"))
        ((:sym drawable-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:nav "Navigator Drawable Example"
          :animated-drawable-example))
        ((:header "Special Properties for Drawables")
         ((:sym on-redisplay "(event-handler)"))
         ((:sym update-on-resize)) ((:sym use-bitmap-stream))
         ((:sym bitmap-stream)) ((:sym page-width))
         ((:sym page-height)))
        ((:header "Other Drawable Functions")
         ((:sym redisplay-event "(overridable generic function)"))
         ((:sym drawable-stream)) ((:sym update-drawable))))
       ((:header "header-control")
        ((:sym header-control "(instantiable dialog-item class)"))
        ((:sym header-control-pane
          "(the associated auto-instantiated widget-window class)"))
        ((:sym header-info "(instantiable class for each header)"))
        ((:sym header-info-p))
        ((:header "Special Properties for Header-Controls")
         ((:sym value
           "(the name of the most recently clicked header, or t for a slide)"))
         ((:sym range
           "(the list of header-info objects for the set of headers)"))
         ((:sym button-style)) ((:sym default-header-width))
         ((:sym default-header-justification)))
        ((:header "Special Properties for Header-Infos")
         ((:sym justification)) ((:sym width)) ((:sym fill-space))
         ((:sym name)) ((:sym title))
         ((:header "Deprecated Properties for Header-Infos")
          ((:sym id "(use name)")) ((:sym label "(use title)"))))
        ((:header "Creating Individual Headers") ((:sym add-header))
         ((:sym remove-header))
         ((:header "Special Properties for Header-Info")
          ((:header "Deprecated Properties for Header-Info")
           ((:sym label "(use title)")))))
        ((:header
          "Accessing a Header from its Name and Header-Control")
         ((:sym header "(finds the header)")) ((:sym header-label))
         ((:sym header-justification)) ((:sym header-width))
         ((:sym header-box)) ((:sym header-fill-space)))
        ((:header "Other Header Functions") ((:sym header-at-position))
         ((:sym index)))
        ((:header "Default Header Values")
         ((:sym *default-header-width*))
         ((:sym *default-header-justification*))))
       ((:header "HTML-Widget and HTML-Browser")
        ((:header "HTML-Widget Classes") ((:sym html-widget))
         ((:sym html-widget-pane)) ((:sym html-browser))
         ((:sym html-widget-for-browser))
         ((:sym html-widget-pane-for-browser)))
        ((:header "HTML-Widget Callable Functions")
         ((:sym display-html)) ((:sym html-widget-go-back))
         ((:sym html-widget-go-forward)) ((:sym html-widget-reload))
         ((:sym html-widget-stop-load))
         ((:sym html-widget-copy (Windows only)))
         ((:sym html-widget-save (Windows only)))
         ((:sym html-widget-print (Windows only)))
         ((:sym html-widget-can-go-back (not working)))
         ((:sym html-widget-can-go-forward (not working))))
        ((:header "HTML-Widget Callback Generic Functions")
         ((:sym html-widget-progress)) ((:sym html-widget-over-link))
         ((:sym html-widget-new-document))
         ((:sym html-widget-new-window))
         ((:sym html-widget-command-change)))
        ((:header "HTML-Widget Event-Handlers") ((:sym on-progress))
         ((:sym on-link-message)) ((:sym on-new-document))
         ((:sym on-new-window)) ((:sym on-command-change)))
        ((:header "HTML-Browser Functions") ((:sym display-html))
         ((:sym html-history)) ((:sym html-history-length))
         ((:sym initial-html-history))))))
     ((:header "Non-Instantiable Control Classes of Interest")
      ((:sym dialog-item "(superclass of all controls)"))
      ((:sym os-widget
        "(superclass of all controls supplied by the underlying window system)"))
      ((:sym lisp-widget
        "(superclass of all controls written in Lisp)"))
      ((:sym ocx-widget
        "(superclass of all OCX widgets on Windows only)"))
      ((:sym widget-window "(superclass of all windows for controls)"))
      ((:sym os-widget-window
        "(superclass of the widget-windows for OS controls)"))
      ((:sym lisp-widget-window
        "(superclass of the widget-windows for Lisp controls)"))
      ((:sym ocx-widget-window
        "(superclass of all OCX widget-windows on Windows only)"))
      ((:header "Classes that Categorize Widgets by Functionality")
       ((:sym toggling-widget
         "(widgets that have a true-or-nil value)"))
       ((:sym toggling-widget-pane))
       ((:sym text-widget
         "(widgets that display or edit standalone text)"))
       ((:sym text-widget-pane)) ((:sym item-list))
       ((:sym item-list-pane)) ((:sym picture-widget))
       ((:sym picture-widget-pane)) ((:sym scroll-bar-mixin))
       ((:sym scroll-bar-pane-mixin)) ((:sym scroll-bar))
       ((:sym scroll-bar-pane)))))
    ((:header "Creating Controls")
     ((:info "Use make-instance on the desired dialog-item subclass."))
     ((:doc "Getting Sample Code for Creating Controls"
       "cgide.htm#code-creating-controls-1"))
     ((:sym add-component)) ((:sym dialog-item-p)))
    ((:header "Finding Controls")
     ((:sym find-component
       "(finds a control from its name and its parent window)"))
     ((:sym find-sibling
       "(finds a control from its name and a sibling control)"))
     ((:sym widget-under-mouse
       "(returns the control currently under the mouse cursor)")))
    ((:header "Properties Common to Many Controls (Widgets)")
     ((:header "Regular (Non-Event-Handler) Widget Properties")
      ((:sym name)) ((:sym title)) ((:sym value)) ((:sym range))
      ((:sym available)) ((:sym state))
      ((:header "Appearance Properties of Widgets") ((:sym border))
       ((:sym background-color)) ((:sym foreground-color))
       ((:sym antialias-lines)) ((:sym antialias-text)))
      ((:header "Position and Size Properties of Widgets")
       ((:sym left "(the setf moves the control horizontally)"))
       ((:sym top "(the setf moves the control vertically)"))
       ((:sym right)) ((:sym bottom))
       ((:sym width "(the setf resizes the control horizontally)"))
       ((:sym height "(the setf resizes the control vertically)"))
       ((:sym box "(the setf resizes and/or moves the control)")))
      ((:header
        "Attachment Properties of Widgets   \"(follows parent resizing)\"")
       ((:sym left-attachment)) ((:sym top-attachment))
       ((:sym right-attachment)) ((:sym bottom-attachment)))
      ((:header "Help String Properties of Widgets")
       ((:sym help-string)) ((:sym tooltip))
       ((:sym show-help-string-under-mouse))
       ((:nav "Navigator Example for Menus and Help Options"
         :menus-and-help-example))
       ((:doc "Adding Quick Help to an Application"
         "cg/cg-application-help.htm#quick-help-2")))
      ((:header "Tabbing to the Control and Front-to-Back Order")
       ((:sym tabstop)) ((:sym tab-position)))
      ((:header "Relationship Properties of Widgets") ((:sym parent))
       ((:sym siblings)))
      ((:header "Mouse Cursor Properties of Widgets") ((:sym cursor))
       ((:sym cursor-name))))
     ((:header "Event-Handler Properties of Widgets")
      ((:header "on-change") ((:sym on-change))
       ((:header "Suppressing the Running of the On-Change Handler")
        ((:sym initialize-value)) ((:sym without-on-change))))
      ((:header "on-change-test") ((:sym on-change-test))
       ((:sym widget-value-equal)))
      ((:sym on-click))
      ((:header "on-double-click") ((:sym on-double-click))
       ((:sym double-click-as-default-button))
       ((:sym double-click-time)))
      ((:sym on-set-focus)) ((:sym on-kill-focus)) ((:sym on-mouse-in))
      ((:sym on-mouse-out)) ((:sym on-print))))
    ((:header "Relationships of Controls")
     ((:sym parent "(returns the window that a control is on)"))
     ((:sym window "(returns the window that implements the control)"))
     ((:sym siblings))
     ((:sym dialog-item
       "(returns the control that a window implements if any, or NIL)"))
     ((:sym component
       "(returns the control implemented by a window if any, or the window itself)"))
     ((:sym tab-control-widget
       "(returns the tab-control that a control is on, if any)"))
     ((:header
       "Tabbing and Occlusion (Front-to-Back) Order   (these are always the same)")
      ((:sym bury-component)) ((:sym expose-component))
      ((:sym tab-to-next)))
     ((:header "Which Control has the Keyboard Focus")
      ((:sym focus-component)) ((:sym set-focus-component))))
    ((:header "Customizing Controls")
     ((:header
       "Subclassing Existing Controls   (use defclass as usual)")
      ((:sym widget-device)) ((:sym defcomponent "to add properties")))
     ((:header "Microsoft Visual Styles")
      ((:sym a-visual-style-is-active)) ((:sym selected-tab-color))
      ((:sym ide.project:include-manifest-file-for-visual-styles)))
     ((:header "Authoring New Controls in Lisp")
      ((:nav "Simple Navigator Example" :circle-widget-example))
      ((:nav "Complex Navigator Example" :vertical-gauge-example))
      ((:sym lisp-widget)) ((:sym lisp-widget-window))
      ((:sym lisp-widget-top-window)) ((:sym open-lisp-widget-window))
      ((:sym lisp-widget-clear-focus)) ((:sym lisp-widget-draw-focus)))
     ((:header "Using OCX (OLE) Controls") ((:sym def-cg-ocx-control))
      ((:sym ocx-widget)) ((:sym ocx-widget-window))
      ((:sym use-native-size)) ((:sym ocx-control))
      ((:sym handle-ocx-shortcut)) ((:sym *ocx-classes-for-focus*))
      ((:sym *suppressed-ocx-properties*)))
     ((:header
       "Microsoft-Style \"Subclassing\"   (to receive low-level window events)")
      ((:sym subclass-widget)) ((:sym unsubclass-widget))
      ((:sym widget-subclassed-p)))
     ((:header "Adding New Controls to the Component Toolbar")
      ((:sym ide.base:add-to-component-toolbar))
      ((:sym ide.base:remove-from-component-toolbar))))
    ((:header "Deprecated Functions for Controls")
     ((:sym double-click-as-default-button
       "(use a custom on-double-click handler)"))
     ((:sym button-return "(use a custom on-change handler)"))
     ((:sym 3d-border-width
       "(effectively a constant in the Windows OS)"))
     ((:sym plain-border-width
       "(effectively a constant in the Windows OS)"))))
   ((:header "The Screen   (also known as the desktop)")
    ((:sym screen
      "(the screen object and class; a *system* accessor)"))
    ((:sym screenp))
    ((:doc "Drawing on the screen"
      "cg/cg-drawing.htm#on-the-screen-2"))
    ((:header
      "Resolution in which the Windows OS is Running (as specified in Control Panel)")
     ((:sym exterior-width "(includes the taskbar)"))
     ((:sym exterior-height "(includes the taskbar)"))
     ((:sym interior-width "(excludes the taskbar)"))
     ((:sym interior-height "(excludes the taskbar)"))
     ((:sym bits-per-pixel
       "(called on the screen, returns the screen depth)"))
     ((:sym stream-units-per-inch)) ((:sym stream-units-per-mm)))
    ((:header "The Screen Size for Multiple Desktops")
     ((:sym virtual-exterior)) ((:sym nvirtual-exterior))
     ((:sym virtual-screen-width)) ((:sym virtual-screen-height))
     ((:sym virtual-screen-left)) ((:sym virtual-screen-top))
     ((:sym usable-left)) ((:sym usable-top))
     ((:sym screen-resolution-changed)))
    ((:sym windows
      "(called on the screen, returns all top-level windows)")))
   ((:header "Menus")
    ((:doc "Menus Overview / Using the Interactive Menu Editor"
      "cg/ide-ug/ide_user_guide_7.htm"))
    ((:nav "Navigator Example for Menus and Help Options"
      :menus-and-help-example))
    ((:header "Menu Classes")
     ((:header
       "Instantiable Menu Classes   (use open-menu to instantiate)")
      ((:sym pop-up-menu)) ((:sym pull-down-menu)) ((:sym menu-bar)))
     ((:header "Non-Instantiable Menu Classes of Interest")
      ((:sym menu (superclass of all menu classes)))))
    ((:header "Menu Functions")
     ((:header "Creating Menus")
      ((:sym open-menu "(instantiates a menu class)"))
      ((:sym add-to-menu)) ((:sym remove-from-menu))
      ((:sym update-menu))
      ((:sym menu
        "(function to return or set the menu-bar of a window)"))
      ((:doc "Menu Editor"
        "ide-menus-and-dialogs/menu-editor-dialog.htm")))
     ((:header "Invoking Menus")
      ((:header "Pop-Up Menus")
       ((:info
         "The application invokes a pop-up-menu programmatically."))
       ((:sym pop-up-menu)) ((:sym pop-up-lettered-menu))
       ((:sym pop-up-shortcut-menu))
       ((:sym pop-up-menus-for-many-sorted-choices)))
      ((:header "Menu-Bar Pull-Down Menus")
       ((:info "The user invokes a pull-down-menu interactively."))
       ((:nav
         "Navigator Clipboard Example   (includes a simple menu-bar)"
         :clipboard-example))
       ((:header "Q:  Why isn't Alt-F invoking my File menu?")
        ((:info "A:  Several Possibilities:"))
        ((:header
          "The window is an instance of dialog-mixin and there are no controls in the window.")
         ((:info
           "Use a non-dialog window or add one or more controls to it.")))
        ((:header
          "You are using Run Form and the IDE is grabbing the keystroke.")
         ((:info
           "Try Run Project instead, so that the window is independent of the IDE.")))
        ((:header
          "The focus is in a text control which is a grandchild of the menu-bar window.")
         ((:info "This is a special case that does not work.")))
        ((:header "A global accelerator is grabbing the keystroke.")
         ((:info
           "Use a different key binding for the global accelerator."))
         ((:sym add-global-keyboard-accelerator))))))
     ((:header "Menu Properties") ((:sym name)) ((:sym title))
      ((:sym menu-items)) ((:sym on-click))
      ((:sym show-help-strings-as-tooltips))
      ((:sym override-native-shortcuts)))
     ((:header "Menu Events")
      ((:header "Overridable Event Handling Generic Functions")
       ((:sym about-to-show-menu)) ((:sym menu-item-highlighted))
       ((:sym menu-item-help)) ((:sym handle-menu-selection))
       ((:sym proxy-menu-bar-window)))
      ((:header "The On-Click Event Handler") ((:sym on-click))
       ((:header "Built-In Menu On-Click Functions")
        ((:sym default-menu-on-click)) ((:sym funcall-menu-item))
        ((:sym eval-menu-item)) ((:sym funcall-menu-item-with-window))
        ((:sym funcall-menu-item-with-rich-edit)))))
     ((:header "Menu Predicates") ((:sym menup)) ((:sym menu-bar-p)))
     ((:header "Other Menu Functions")
      ((:sym delay-pop-up-menus-until-mouse-buttons-up))
      ((:sym menu-font)) ((:sym shortcut-menu-class))
      ((:sym system-menu)) ((:sym menu-tooltip-delay))
      ((:sym menu-bar-height))))
    ((:header "Menu-Items") ((:sym menu-item "(instantiable class)"))
     ((:sym menu-item-p)) ((:sym menu-separator))
     ((:sym find-named-object)) ((:sym copy-menu-item))
     ((:header "Menu-Item Properties") ((:sym name)) ((:sym title))
      ((:sym value))
      ((:sym event-synonym
        "(the keyboard shortcut for the menu-item)"))
      ((:sym help-string)) ((:sym available)) ((:sym cluster))
      ((:sym selected
        "(whether a check mark appears on the menu-item)"))
      ((:sym allow-during-modality))
      ((:sym menu "(returns the menu that the menu-item is on)"))
      ((:sym checkable "(needed on GTK only)")))
     ((:header "Menu-Item Keyboard Shortcuts")
      ((:sym event-synonym "(menu-item property)"))
      ((:sym override-native-shortcuts))
      ((:sym ide.keyshort:comtab-report))
      ((:cod
        "Show the IDE Shortcut Keys Dialog   (Help | Shortcut Keys)"
        (ide.keyshort:comtab-report :stream nil)))
      ((:sym menu-item-help))))
    ((:header "Shortcut Menus")
     ((:sym shortcut-menu "(instantiable class)"))
     ((:sym shortcut-commands)) ((:sym pop-up-shortcut-menu))
     ((:sym shortcut-menu-class)))
    ((:doc "Menus and Dialogs in the IDE"
      "cgide.htm#menus-dialogs-1")))
   ((:header "Tooltips")
    ((:header "Tooltip-Oriented Properties of Controls")
     ((:sym tooltip)))
    ((:header "Tooltip-Oriented Properties of Menus")
     ((:sym show-help-strings-as-tooltips)))
    ((:header "Overridable Generic Functions")
     ((:sym tooltip-horizontal-center)) ((:sym tooltip-top)))
    ((:header "Extendable Generic Functions") ((:sym show-tooltip))
     ((:sym hide-tooltip)))
    ((:header "Configuration Options for Tooltips")
     ((:sym show-tooltips)) ((:sym custom-tooltip-font))
     ((:sym tooltip-delay)) ((:sym menu-tooltip-delay))
     ((:sym tooltip-vertical-offset)))
    ((:sym tooltip-font "(returns the system-wide status font)"))
    ((:doc "Adding Quick Help to an Application"
      "cg/cg-application-help.htm#quick-help-2")))
   ((:header "The Mouse Cursor")
    ((:doc "Pixmaps and Mouse Cursors Overview"
      "cg/cg-pixmaps.htm#mouse-cursors-1"))
    ((:nav "Navigator Custom Mouse Cursor Example"
      :mouse-cursor-example))
    ((:header "Mouse Cursor Position") ((:sym cursor-position))
     ((:sym ncursor-position)))
    ((:header "Assigning a Mouse Cursor to a Window or Control")
     ((:sym cursor "(the setf sets the cursor to use over a window)")))
    ((:header "Temporary Global Mouse Cursors") ((:sym with-cursor))
     ((:sym without-cursor)) ((:sym *with-cursor*))
     ((:sym with-hourglass)))
    ((:header "Creating Custom Mouse Cursors")
     ((:nav "Navigator Custom Mouse Cursor Example"
       :mouse-cursor-example))
     ((:sym cursor "(instantiable class)")) ((:sym cursor-size))
     ((:header "Mouse Cursor Properties") ((:sym texture))
      ((:sym mask)) ((:sym click-position)) ((:sym cursor-handle))))
    ((:header "Built-In Mouse Cursors")
     ((:header "Supplied by the Operating System")
      ((:sym arrow-cursor))
      ((:sym cross-cursor "(for specifying a position)"))
      ((:sym line-cursor "(for text editing)"))
      ((:sym waiting-cursor "(an hourglass for busy states)"))
      ((:sym vertical-arrow-cursor)) ((:sym app-starting-cursor))
      ((:sym hand-cursor "(an OS cursor handle on GTK only)"))
      ((:sym help-cursor))
      ((:sym no-drop-cursor "(used by drag-and-drop)"))
      ((:sym sizing-cursor)) ((:sym sizing-north-south-cursor))
      ((:sym sizing-west-east-cursor))
      ((:sym sizing-northeast-southwest-cursor))
      ((:sym sizing-northwest-southeast-cursor))
      ((:sym sizing-northeast-cursor)) ((:sym sizing-northwest-cursor))
      ((:sym sizing-southeast-cursor))
      ((:sym sizing-southwest-cursor)))
     ((:header
       "Supplied by Common Graphics   (retrieve with find-cursor)")
      ((:cod "hand-cursor" (inspect (find-cursor :hand-cursor))))
      ((:cod "default-drop-cursor"
        (inspect (find-cursor :default-drop-cursor))))
      ((:cod "horizontal-splitbar-cursor"
        (inspect (find-cursor :horizontal-splitbar-cursor))))
      ((:cod "vertical-splitbar-cursor"
        (inspect (find-cursor :vertical-splitbar-cursor))))))
    ((:header "Caching and Looking Up Mouse Cursors")
     ((:sym cache-cursor)) ((:sym find-cursor)) ((:sym uncache-cursor))
     ((:cod "Inspect All Cached Cursors"
       (inspect cg.base:*cached-cursors*))))
    ((:header "Things Currently Under the Mouse")
     ((:sym window-under-mouse)) ((:sym widget-under-mouse))
     ((:sym hotspot-under-mouse)))
    ((:header "Capturing Mouse Events in a Particular Window")
     ((:sym with-mouse-captured)) ((:sym capture-mouse))
     ((:sym release-mouse)) ((:sym mouse-captured-p)))
    ((:header "Confining the Mouse Cursor to a Particular Window")
     ((:sym with-mouse-confined))))
   ((:header "Icons in the System Tray")
    ((:sym tray-item "(instantiable class)")) ((:sym tray-item-icon))
    ((:sym tray-item-tooltip)) ((:sym add-tray-item))
    ((:sym remove-tray-item)) ((:sym in-tray-p))
    ((:sym tray-item-message "(overridable generic function)")))
   ((:header "The Currently Selected Thing")
    ((:header "The Selected Window") ((:sym select-window))
     ((:sym selected-window)) ((:sym selected-window-or-screen))
     ((:sym get-focus)) ((:sym set-focus))
     ((:sym context-sensitive-help))
     ((:doc "Providing Help on the Selected Window"
       "cg/cg-application-help.htm#selected-window-help-2")))
    ((:header
      "The Selected Data Object   (within the selected window)")
     ((:sym selected-object))
     ((:sym ide.base:*selected-object* (in the IDE)))
     ((:sym selected-symbol)) ((:sym selected-string))
     ((:sym selected-class)) ((:sym selected-form))
     ((:doc "Providing Help on the Selected Object"
       "cg/cg-application-help.htm#selected-object-help-2"))
     ((:header "Converting from an Arbitrary Selected Data Object")
      ((:sym object-symbol)) ((:sym object-string))
      ((:sym object-class)) ((:sym object-form)))
     ((:header "Retrieving or Replacing the Selected Object")
      ((:sym cut-selection)) ((:sym copy-selection))
      ((:sym paste-selection)) ((:sym delete-selection))
      ((:sym insert-selection)) ((:sym cuttable)) ((:sym pastable))
      ((:header "Using the Clipboard with the Selected Object")
       ((:doc "About the Clipboard" "cg/cg-clipboard.htm"))
       ((:sym copy-command)) ((:sym cut-command))
       ((:sym delete-command)) ((:sym paste-command))
       ((:sym insert-command))
       ((:sym clipboard-format-from-object))))))
   ((:header "Hotspots")
    ((:nav "Navigator Hotspots Example" :hotspots-example))
    ((:header "Hotspot Classes")
     ((:sym hotspot "(instantiable class)"))
     ((:sym hotspot-mixin
       "(a mixin for any window that is to have hotspots)")))
    ((:header "Hotspot Attributes") ((:sym name))
     ((:sym hotspot-region))
     ((:sym parent "(returns the window the hotspot is in)"))
     ((:sym highlight-style)) ((:sym color)) ((:sym available))
     ((:sym plist)))
    ((:header "Other Hotspot Functions") ((:sym add-hotspot))
     ((:sym remove-hotspot)) ((:sym hotspots)) ((:sym current-hotspot))
     ((:sym hotspot-under-mouse))
     ((:sym highlight-hotspot "(overridable generic function)"))
     ((:sym hotspot-region)) ((:sym region-box))
     ((:sym invalidate "(redraws just the region of a hotspot)"))))
   ((:header
     "The Caret   (a flashing cursor in the selected window, such as a text cursor)")
    ((:nav "Navigator Carets Example" :carets-example))
    ((:sym caret-mixin
      "(a mixin for windows that need to have a caret)"))
    ((:sym caret
      "(a caret-mixin property that specifies the caret of a window)"))
    ((:sym show-caret)) ((:sym hide-caret)) ((:sym caret-position))
    ((:sym ncaret-position)) ((:sym caret-width)) ((:sym caret-height))
    ((:sym caret-blink-time))))
  ((:header "Event Handling")
   ((:header "Events on Regular Windows")
    ((:doc "An Overview of Window Events" "cg/cg-events.htm"))
    ((:nav "Navigator Basic Window Event Handling Example"
      :window-methods-example))
    ((:header "Keyboard Events")
     ((:header
       "Overridable Event-Handling Generic Functions for Keyboard Events")
      ((:sym virtual-key-down)) ((:sym virtual-key-up))
      ((:sym character-message)))
     ((:header
       "The Keyboard Focus   (the window or control to which all keyboard events are directed)")
      ((:header "The Focused Window") ((:sym get-focus))
       ((:sym set-focus)) ((:sym clear-focus)))
      ((:header "The Focused Control") ((:sym focus-component))
       ((:sym set-focus-component))
       ((:header "Event Handlers") ((:sym on-set-focus))
        ((:sym on-kill-focus)))
       ((:header
         "Extendable Event-Handling Generic Functions for Control Focus")
        ((:sym set-focus-event)) ((:sym kill-focus-event))))
      ((:header "The Focus Within Particular Controls")
       ((:sym focus-cell "(for grid-widgets)"))
       ((:sym show-focus "(grid-widget property)"))
       ((:sym keep-focus-in-view "(grid-widget property)"))
       ((:sym focus-index "(for grid-widget and outline controls)"))
       ((:sym focus-on-click "(tab-control property)"))
       ((:sym save-selection-when-unfocused "(text-edit-pane)"))
       ((:sym show-selection-when-unfocused "(text-edit-pane)"))))
     ((:header
       "Keyboard Shortcuts   (mapping keyboard keys to various commands)")
      ((:cod "Show the Shortcut Keys Dialog   (Help | Shortcut Keys)"
        (ide.keyshort:comtab-report :stream nil)))
      ((:sym ide.keyshort:comtab-report))
      ((:header "Menu Command Shortcuts")
       ((:sym event-synonym "(menu-item property)"))
       ((:sym override-native-shortcuts)))
      ((:header "Comtabs   (Command Tables)")
       ((:sym comtab "(instantiable class and window accessor)"))
       ((:sym comtab-mixin
         "(mixin for windows that are to have comtabs)"))
       ((:sym event-function)) ((:sym set-event-function))
       ((:sym cg-host-comtab)) ((:sym cg-emacs-comtab))
       ((:sym override-menu-bars)))
      ((:header "Global Keyboard Shortcuts")
       ((:sym add-global-keyboard-accelerator))
       ((:sym remove-global-keyboard-accelerator))
       ((:sym handle-f10 "(needed on GTK only)")))
      ((:sym context-sensitive-help)) ((:sym menu-item-help))
      ((:header "The IDE Editor's Comtab")
       ((:sym ide.base:*text-edit-comtab*))))
     ((:header "Finding the Currently-Pressed Keys")
      ((:sym key-is-down-p)) ((:sym key-was-down-p)) ((:sym down-keys))
      ((:sym down-key-names)) ((:sym wait-for-keys-up)))
     ((:header "Key Name Constants")
      ((:header "Button-State Bit Flags")
       ((:header "Functions Using Button-State Bit Flags")
        ((:header "Event Handlers with a Button-State Parameter")
         ((:sym virtual-key-down)) ((:sym virtual-key-up))
         ((:sym mouse-left-down
           "(and the other mouse click handlers)")))
        ((:sym button-match)) ((:sym mouse-button-state))
        ((:sym wait-for-mouse-buttons-up)) ((:sym wait-for-keys-up))
        ((:sym key-is-down-p)) ((:sym key-was-down-p)))
       ((:header "Keyboard Shift Keys") ((:sym shift-key))
        ((:sym control-key)) ((:sym alt-key))
        ((:sym meta-key "(same as alt-key)")) ((:sym extended-key))
        ((:sym reserve-righthand-alt-key)))
       ((:header "Mouse Buttons as Shift Keys")
        ((:sym left-mouse-button)) ((:sym middle-mouse-button))
        ((:sym right-mouse-button)) ((:sym first-x-button))
        ((:sym second-x-button)) ((:sym *ignore-mouse-x-buttons*))))
      ((:header "Main Key Identifiers")
       ((:header "Finding Key Names") ((:sym key-name))
        ((:sym key-names)) ((:sym char-to-key-name)))
       ((:header "Functions Using Main Key Identifiers")
        ((:sym virtual-key-down (passed as the "data" argument)))
        ((:sym virtual-key-up (passed as the "data" argument)))
        ((:sym key-is-down-p)) ((:sym key-was-down-p)))
       ((:header "The List of \"vk-...\" Key Names")
        ((:header "Keys on the Main Keyboard")
         ((:header
           "Graphical Keys   (for other graphical keys, use the lisp character object)")
          ((:sym vk-backquote)) ((:sym vk-backslash))
          ((:sym vk-close-square-bracket)) ((:sym vk-comma))
          ((:sym vk-minus)) ((:sym vk-open-square-bracket))
          ((:sym vk-period)) ((:sym vk-plus)) ((:sym vk-quote))
          ((:sym vk-semicolon)) ((:sym vk-slash)) ((:sym vk-space)))
         ((:header "Shift Keys") ((:sym vk-shift)) ((:sym vk-control))
          ((:sym vk-alt)) ((:sym vk-meta)) ((:sym vk-applications))
          ((:header "Lefthand- and Righthand-Specific Shift Keys")
           ((:sym vk-left-shift)) ((:sym vk-right-shift))
           ((:sym vk-left-control)) ((:sym vk-right-control))
           ((:sym vk-left-alt)) ((:sym vk-right-alt))
           ((:sym vk-left-windows)) ((:sym vk-right-windows))))
         ((:header "Function Keys") ((:sym vk-f1)) ((:sym vk-f2))
          ((:sym vk-f3)) ((:sym vk-f4)) ((:sym vk-f5)) ((:sym vk-f6))
          ((:sym vk-f7)) ((:sym vk-f8)) ((:sym vk-f9)) ((:sym vk-f10))
          ((:sym vk-f11)) ((:sym vk-f12)) ((:sym vk-f13))
          ((:sym vk-f14)) ((:sym vk-f15)) ((:sym vk-f16)))
         ((:header "Movement Keys") ((:sym vk-down)) ((:sym vk-end))
          ((:sym vk-home)) ((:sym vk-left)) ((:sym vk-pagedown))
          ((:sym vk-pageup)) ((:sym vk-right)) ((:sym vk-up)))
         ((:header "Toggling Keys") ((:sym vk-capslock))
          ((:sym vk-numlock)) ((:sym vk-scrllock)))
         ((:header "Other Non-Graphical Keys") ((:sym vk-backspace))
          ((:sym vk-backtab)) ((:sym vk-cancel)) ((:sym vk-delete))
          ((:sym vk-enter)) ((:sym vk-escape)) ((:sym vk-insert))
          ((:sym vk-pause)) ((:sym vk-printscrn)) ((:sym vk-return))
          ((:sym vk-sysrq)) ((:sym vk-tab))))
        ((:header "Keys on the Numeric Keypad") ((:sym vk-add))
         ((:sym vk-subtract)) ((:sym vk-multiply)) ((:sym vk-divide))
         ((:sym vk-decimal)) ((:sym vk-separator))
         ((:header "Numeric Keypad Number Keys") ((:sym vk-numpad0))
          ((:sym vk-numpad1)) ((:sym vk-numpad2)) ((:sym vk-numpad3))
          ((:sym vk-numpad4)) ((:sym vk-numpad5)) ((:sym vk-numpad6))
          ((:sym vk-numpad7)) ((:sym vk-numpad8)) ((:sym vk-numpad9))))
        ((:header "Mouse Buttons as Keys") ((:sym vk-lbutton))
         ((:sym vk-mbutton)) ((:sym vk-rbutton)) ((:sym vk-xbutton1))
         ((:sym vk-xbutton2)) ((:sym *ignore-mouse-x-buttons*))))))
     ((:sym reserve-righthand-alt-key)))
    ((:header "Mouse Events")
     ((:header
       "Overridable Event-Handling Generic Functions for Mouse Events")
      ((:header "Client Area (Interior) Mouse Events")
       ((:header "Mouse Movement") ((:sym mouse-moved))
        ((:sym mouse-in)) ((:sym mouse-out))
        ((:doc "Triggering Application Help Automatically"
          "cg/cg-application-help.htm#automatic-triggering-2"))
        ((:sym ignore-redundant-mouse-moves)))
       ((:header "Mouse Clicks")
        ((:header "Left Mouse Button") ((:sym mouse-left-down))
         ((:sym mouse-left-up)) ((:sym mouse-double-click))
         ((:sym map-control-left-click-to-right-click)))
        ((:header "Middle Mouse Button") ((:sym mouse-middle-down))
         ((:sym mouse-middle-up)) ((:sym mouse-middle-double-click)))
        ((:header "Right Mouse Button") ((:sym mouse-right-down))
         ((:sym mouse-right-up)) ((:sym mouse-right-double-click)))
        ((:header "Back and Forward Mouse Buttons")
         ((:sym mouse-back-down)) ((:sym mouse-back-up))
         ((:sym mouse-forward-down)) ((:sym mouse-forward-up))))
       ((:header "Mouse Wheel Movement") ((:sym mouse-wheel))
        ((:sym mouse-wheel-present))
        ((:sym mouse-wheel-scroll-lines))))
      ((:header "Non-Client Area (Frame) Mouse Events")
       ((:sym nc-mouse-moved)) ((:sym nc-mouse-left-down))
       ((:sym nc-mouse-left-up)) ((:sym nc-mouse-double-click))
       ((:sym nc-mouse-middle-down)) ((:sym nc-mouse-middle-up))
       ((:sym nc-mouse-middle-double-click))
       ((:sym nc-mouse-right-down)) ((:sym nc-mouse-right-up))
       ((:sym nc-mouse-right-double-click))
       ((:header "Window Frame Buttons")
        ((:header "Close Button") ((:sym close-button))
         ((:sym user-close)))
        ((:header "Minimize/Maximize Buttons") ((:sym minimize-button))
         ((:sym maximize-button)) ((:sym state)) ((:sym shrink-window))
         ((:sym expand-window)) ((:sym zoom-window)))
        ((:header "Help Button") ((:sym help-button))
         ((:sym help-button-pressed))
         ((:sym context-sensitive-help)))))
      ((:sym mouse-event-p)))
     ((:header "Current State of the Mouse Buttons")
      ((:sym mouse-button-state)) ((:sym wait-for-mouse-buttons-up))
      ((:sym button-match))))
    ((:header "Other Overridable Message-Handling Generic Functions")
     ((:sym redisplay-window)) ((:sym user-scroll)) ((:sym user-close))
     ((:sym os-exit-request))
     ((:header "Deprecated")
      ((:sym event
        "(use generic functions such as mouse-left-down and virtual-key-down instead)"))
      ((:sym nc-event
        "(use generic functions like nc-mouse-moved instead)"))
      ((:header
        "Redundant Event Constants   (which are not also event-handler functions)")
       ((:sym mouse-down)) ((:sym nc-mouse-down)) ((:sym mouse-up))
       ((:sym nc-mouse-up)) ((:sym mouse-left-double-click))
       ((:sym nc-mouse-left-double-click)))))
    ((:header "Other Extendable Message-Handling Generic Functions")
     ((:sym move-window)) ((:sym resize-window)) ((:sym set-focus)))
    ((:header "Disabling Events") ((:sym with-events-disabled))
     ((:sym with-events-enabled)) ((:sym enable-events))
     ((:sym events-enabled)) ((:sym discard-pending-events))))
   ((:header "Events on Controls")
    ((:doc "A Tutorial" "cg/ide-ug/ide_user_guide_8.htm"))
    ((:header "Event-Handler Properties of Controls")
     ((:sym on-change)) ((:sym on-change-test)) ((:sym on-click))
     ((:sym on-double-click)) ((:sym on-print)) ((:sym on-set-focus))
     ((:sym on-kill-focus)) ((:sym on-mouse-in)) ((:sym on-mouse-out))
     ((:sym on-sort-key)) ((:sym on-sort-predicate))
     ((:sym on-range-change "(marginally useful)"))
     ((:sym range-equality-test "(marginally useful)")))
    ((:header
      "Extendable Event-Handling Generic Functions for Controls")
     ((:sym widget-set-value)) ((:sym widget-set-range))
     ((:sym set-focus-event)) ((:sym kill-focus-event)))
    ((:header
      "Overridable Event-Handling Generic Functions for Controls")
     ((:sym click-event)) ((:sym double-click-event)))
    ((:header "Receiving Low-Level Window Events for OS Controls")
     ((:sym subclass-widget)) ((:sym unsubclass-widget))
     ((:sym widget-subclassed-p))))
   ((:header "Events on Menus") ((:sym on-click))
    ((:sym about-to-show-menu)) ((:sym menu-item-highlighted))
    ((:sym handle-menu-selection)) ((:sym proxy-menu-bar-window))
    ((:doc "Triggering Application Help"
      "cg/cg-application-help.htm#triggering-help-1")))
   ((:header "Timers") ((:doc "About Timers" "cg/cg-timers.htm"))
    ((:nav "Navigator Bouncing Boxes Example" :bouncing-box-example))
    ((:nav "Navigator Drawable Example" :animated-drawable-example))
    ((:sym timer "(instantiable class)")) ((:sym find-timer))
    ((:sym start-timer)) ((:sym stop-timer))
    ((:sym on-timer "(event-handler)"))
    ((:sym *cg-timer-resolution* (used on Linux/Unix only)))
    ((:header "Timer Properties") ((:sym interval)) ((:sym active))
     ((:sym timer-count)) ((:sym timer-info))
     ((:sym timer-universal-time)) ((:sym timer-process)) ((:sym id)))
    ((:header
      "The Built-In CG-Timer   (always passed to the currently-selected window)")
     ((:sym cg-timer)) ((:sym handle-cg-timer))
     ((:sym cg-timer-interval "(configuration option)"))
     ((:sym use-cg-timer "(configuration option)")))
    ((:header "Timer Interval Configuration Options")
     ((:sym tooltip-delay)) ((:sym menu-tooltip-delay))
     ((:sym multi-picture-button-scroll-interval))))
   ((:header "Event-Handling Loops and Cooperative Multitasking")
    ((:sym event-loop)) ((:sym process-single-event))
    ((:sym process-pending-events))
    ((:sym process-pending-events-if-event-handler))
    ((:sym discard-pending-events))
    ((:sym post-funcall-in-cg-process
      "(tells a CG thread to run some code when it gets to it)"))
    ((:sym *event-loop-processes*))
    ((:sym *use-single-cg-event-handling-process*))
    ((:sym *single-cg-event-handling-process*))
    ((:sym cg-process-wait)))
   ((:header "Prompting the User for Input")
    ((:header "Prompting for Mouse Input")
     ((:header "Rubber-Banding")
      ((:nav "Navigator Example for Rubber-Banding"
        :rubber-banding-example))
      ((:header
        ":nav \"Navigator Example for Manipulatable Graphic Objects\" :nodes-example")
       ((:header "Standard Drawing   \"(stretchy lines and boxes)\"")
        ((:sym get-position)) ((:sym nget-position)) ((:sym get-line))
        ((:sym nget-line)) ((:sym get-box)) ((:sym nget-box))
        ((:sym get-fixed-box)) ((:sym nget-fixed-box)))
       ((:header
         "Custom Drawing   \"(using your own drawing function)\"")
        ((:sym get-shape-line)) ((:sym nget-shape-line))
        ((:sym get-shape-box)) ((:sym nget-shape-box))
        ((:sym get-shape-fixed-box)) ((:sym nget-shape-fixed-box)))))
     ((:header "Drag and Drop") ((:sym drag-and-drop))
      ((:sym drop-get)) ((:sym drop-put)) ((:sym good-drop))
      ((:sym bad-drop)) ((:sym box-to-drag))
      ((:sym drag-and-drop-mouse-moved))
      ((:header "Allowing Drag and Drop") ((:sym draggable-p))
       ((:sym droppable-p)) ((:sym droppable-onto-self))
       ((:sym cell-draggable-p "(for grid-widgets)")))
      ((:header "Waiting for an Initial Drag") ((:sym wait-for-drag))
       ((:sym *start-drag-slack*)))
      ((:header "Mouse Cursors Used by Drag and Drop")
       ((:sym drag-cursor)) ((:sym drop-cursor))
       ((:sym no-drop-cursor)))
      ((:sym drag-images "(configuration option)"))
      ((:sym fetch-control-value))))
    ((:header "Prompting for Keyboard Input")
     ((:header "Edit In Place") ((:sym edit-in-place))
      ((:sym editable-in-place "(for outline controls)")))
     ((:header "Waiting for a Keypress in a Loop")
      ((:sym key-is-down-p)) ((:sym key-was-down-p))))
    ((:header "Modal Dialogs")
     ((:info "see Interface Components-->Windows-->Window Classes-->"))
     ((:info "    Instantiable Window Classes-->dialog")))
    ((:header "Telling the User to Wait") ((:sym with-hourglass))
     ((:sym with-message-window)) ((:sym make-message-window))
     ((:sym message-window "(class)")) ((:sym progress-indicator))))
   ((:header "Emulating Mouse Clicks and Keypresses Programmatically")
    ((:sym do-click)) ((:sym do-keypress)) ((:sym do-keypresses))))
  ((:header "Multithreading")
   ((:header "Multiple Windowing Threads in a CG Application")
    ((:doc "Multiple Windowing Threads in a CG Application"
      "cgide.htm#cg-multithreading-1"))
    ((:sym *default-cg-bindings*)) ((:sym with-cg-bindings))
    ((:sym event-loop)) ((:sym inside-event-loop))
    ((:sym exit-event-loop))
    ((:sym in-cg-process "(runs code in a new CG process)"))
    ((:sym foreground-window
      "(returns the selected top-level window in ANY thread)"))
    ((:sym set-foreground-window
      "(brings a thread's windows to the front)"))
    ((:sym ide.base:eval-in-listener-thread
      "(calls eval in another thread if needed)"))
    ((:sym post-funcall-in-cg-process
      "(tells a CG thread to run some code when it gets to it)"))
    ((:sym *event-loop-processes*))
    ((:sym *use-single-cg-event-handling-process*))
    ((:sym *single-cg-event-handling-process*))
    ((:header
      "Avoiding Box and Positions Constants (unsafe with multiple CG threads)")
     ((:sym with-positions)) ((:sym with-boxes))
     ((:sym with-positions-and-boxes)))
    ((:sym *default-cg-message-timeout*)))
   ((:header "Debugging Multiple Threads in the IDE")
    ((:doc "Debugging Multiple Threads in the IDE"
      "cgide.htm#ide-multithreaded-debugging-2"))
    ((:doc "Processes Table"
      "ide-menus-and-dialogs/process-dialog.htm"))
    ((:sym ide.base:ide-evaluator-listener))))
  ((:header "Graphics") ((:doc "Drawing graphics" "cg/cg-drawing.htm"))
   ((:header "Redisplaying Windows")
    ((:sym redisplay-window "(overridable generic function)"))
    ((:header "Double Buffering   (to reduce flashing)")
     ((:sym double-buffered)) ((:sym with-double-buffering))
     ((:sym memory-bitmap-not-created)))
    ((:header "Controlling When Redisplay is Invoked")
     ((:header "Queueing a Redisplay") ((:sym invalidate))
      ((:header "Deprecated Variants   (use invalidate instead)")
       ((:sym invalidate-window)) ((:sym invalidate-window-nc))
       ((:sym invalidate-component)) ((:sym invalidate-component-nc)))
      ((:sym invalidate-window-on-resize)))
     ((:header "Cancelling a Queued Redisplay")
      ((:sym validate-window)))
     ((:header "Forcing a Queued Redisplay to Happen Now")
      ((:sym update-window)) ((:sym process-pending-events))
      ((:sym process-pending-events-if-event-handler))))
    ((:header "Suppressing Redisplay") ((:sym with-delayed-redraw))
     ((:sym delay-redraw)) ((:sym resume-redraw))
     ((:sym redraw-delayed)) ((:sym with-motionless-text-control))))
   ((:header "Line Drawing and Area Filling")
    ((:header "The Current Drawing Style")
     ((:doc "Drawing Style Overview"
       "cg/cg-drawing.htm#drawing-style-2"))
     ((:header "Antialiasing and Color Gradient Filling")
      ((:sym *antialiasing*)) ((:sym *color-gradient-filling*))
      ((:sym *color-gradient-intensity*))
      ((:sym *color-gradient-direction*))
      ((:sym *color-gradient-blend*))
      ((:sym antialias-lines "(widget property)"))
      ((:sym antialias-text "(widget property)")))
     ((:header "Line Width") ((:sym line-width))
      ((:sym with-line-width)))
     ((:header "Dashing") ((:sym line-dashing))
      ((:sym with-line-dashing)))
     ((:header "Color") ((:sym foreground-color))
      ((:sym background-color)) ((:sym with-foreground-color))
      ((:sym with-background-color)))
     ((:header "Font") ((:sym font)) ((:sym with-font)))
     ((:header "Paint Operations")
      ((:cgx "Paint-Operation Example" "paintops.cl"))
      ((:sym paint-operation)) ((:sym with-paint-operation))
      ((:header "Common Paint Operations") ((:sym po-replace))
       ((:sym po-paint)) ((:sym po-invert)) ((:sym po-xor))
       ((:sym po-erase)) ((:sym po-fill)) ((:sym po-and)))
      ((:header "Other Built-In Paint Operations") ((:sym po-dst))
       ((:sym po-ds~t)) ((:sym po-d~st)) ((:sym po-d~s~t))
       ((:sym po-~dst)) ((:sym po-~ds~t)) ((:sym po-~d~st))
       ((:sym po-~d~s~t))))
     ((:header "Clipping Boxes") ((:sym with-clipping-box))
      ((:sym clipping-box)) ((:sym nclipping-box)))
     ((:header "Textures") ((:sym background-texture))
      ((:sym fill-texture)) ((:sym line-texture))
      ((:sym with-background-texture)) ((:sym with-fill-texture))
      ((:sym with-line-texture)))
     ((:header
       "Line Endpoint Styles   (requires drawing-paths in win95/98)")
      ((:sym line-end)) ((:sym line-join)) ((:sym with-line-end))
      ((:sym with-line-join)))
     ((:header "Graphics Contexts") ((:sym make-graphics-context))
      ((:sym graphics-context-p)) ((:sym copy-graphics-context))
      ((:sym set-graphics-context))
      ((:sym restoring-graphics-context))))
    ((:header "The Current Drawing Position") ((:sym current-position))
     ((:sym ncurrent-position)) ((:sym current-position-x))
     ((:sym current-position-y)) ((:sym move-to)) ((:sym move-to-x-y))
     ((:sym move-by)) ((:sym move-by-x-y)))
    ((:header "Doing the Actual Drawing")
     ((:doc "Drawing functions"
       "cg/cg-drawing.htm#drawing-functions-1"))
     ((:header "Straight Things")
      ((:header "Lines") ((:sym draw-line)) ((:sym draw-line-x-y))
       ((:sym erase-line)) ((:sym erase-line-x-y)) ((:sym draw-to))
       ((:sym draw-to-x-y)) ((:sym draw-by)) ((:sym draw-by-x-y))
       ((:sym erase-to)) ((:sym erase-to-x-y)) ((:sym erase-by))
       ((:sym erase-by-x-y)) ((:sym on-line-segment-p)))
      ((:header "Rectangles") ((:sym draw-box)) ((:sym draw-box-x-y))
       ((:sym erase-box)) ((:sym erase-box-x-y)) ((:sym fill-box))
       ((:sym fill-box-x-y)) ((:sym erase-contents-box))
       ((:sym erase-contents-box-x-y)) ((:sym invert-box))
       ((:sym invert-box-x-y)) ((:sym inside-box-p))
       ((:sym sub-box-p)))
      ((:header "Polylines") ((:sym draw-polyline))
       ((:sym erase-polyline)))
      ((:header "Polygons") ((:sym draw-polygon))
       ((:sym erase-polygon)) ((:sym fill-polygon))
       ((:sym erase-contents-polygon)) ((:sym inside-polygon-p)))
      ((:header "Arrowheads") ((:sym draw-arrowhead))))
     ((:header "Round Things")
      ((:header "Circlular Things")
       ((:header "Whole Circles") ((:sym draw-circle))
        ((:sym erase-circle)) ((:sym fill-circle))
        ((:sym erase-contents-circle)) ((:sym inside-circle-p)))
       ((:header "Circle Arcs") ((:sym draw-circle-arc))
        ((:sym erase-circle-arc)))
       ((:header "Circle Sectors") ((:sym draw-circle-sector))
        ((:sym erase-circle-sector)) ((:sym fill-circle-sector))
        ((:sym erase-contents-circle-sector))))
      ((:header "Elliptical Things")
       ((:header "Whole Ellipses") ((:sym draw-ellipse))
        ((:sym erase-ellipse)) ((:sym fill-ellipse))
        ((:sym erase-contents-ellipse)))
       ((:header "Ellipse Arcs") ((:sym draw-ellipse-arc))
        ((:sym erase-ellipse-arc)) ((:sym ellipse-start-and-end)))
       ((:header "Ellipse Sectors") ((:sym draw-ellipse-sector))
        ((:sym erase-ellipse-sector)) ((:sym fill-ellipse-sector))
        ((:sym erase-contents-ellipse-sector))))
      ((:header "Bezier Curves") ((:sym draw-bezier-curve)))
      ((:header "Rectangles with Rounded Corners")
       ((:sym draw-rounded-box)) ((:sym erase-rounded-box))
       ((:sym fill-rounded-box)) ((:sym erase-contents-rounded-box))))
     ((:header "Single Pixels") ((:sym pixel)) ((:sym pixel-x-y)))
     ((:header "Flood Filling") ((:sym flood-fill)))
     ((:header "Erasing a Whole Stream") ((:sym clear-page)))
     ((:header "Using \"Drawing Paths\"") ((:sym with-drawing-path))
      ((:sym begin-drawing-path)) ((:sym end-drawing-path)))
     ((:info
       "The \"Drawing Using Objects\" facility is now REMOVED from Common Graphics"))))
   ((:header "Text and Fonts")
    ((:doc "Text and fonts overview"
      "cg/cg-drawing.htm#text-and-fonts-2"))
    ((:header "Drawing Text")
     ((:header "Text Geometry") ((:sym line-height))
      ((:sym stream-string-width)) ((:sym stream-char-width))
      ((:sym space-width))
      ((:sym stream-string-size
        "(deprecated; use stream-string-width)"))
      ((:sym nstream-string-size
        "(deprecated; use stream-string-width)"))
      ((:sym stream-string-corners
        "(deprecated; use stream-string-width and line-height)"))
      ((:sym nstream-string-corners
        "(deprecated; use stream-string-width and line-height)")))
     ((:header "Doing the Drawing")
      ((:header
        "Drawing Text at the Current Position in a Graphical Window")
       ((:info
         "Functions like FORMAT or PRINC will draw at the current-position"))
       ((:sym move-to "(sets the current-position)"))
       ((:sym current-position)) ((:sym current-position-x))
       ((:sym current-position-y)))
      ((:sym draw-string-in-box)) ((:sym draw-wrapped-string))
      ((:sym draw-text-file)))
     ((:header "The Current Font and Text Background Mode")
      ((:sym font)) ((:sym with-font))
      ((:sym transparent-character-background)) ((:sym object-locale))
      ((:sym with-object-locale))))
    ((:header "Fonts")
     ((:nav "Navigator Fonts Example" :fonts-example))
     ((:header "Font Classes") ((:sym font)) ((:sym fontmetrics)))
     ((:header "Finding Available Fonts") ((:sym font-faces))
      ((:sym font-sizes)))
     ((:header "Creating Fonts") ((:sym make-font-ex))
      ((:sym make-font)) ((:sym ask-user-for-font)))
     ((:header "Using Fonts")
      ((:header "Assigning a Font to a Window (or other object)")
       ((:sym font "(property)")) ((:sym with-font))
       ((:sym font-handle)))
      ((:header "Measuring String Size in a Font")
       ((:sym font-string-width)) ((:sym font-line-height)))
      ((:sym fontp)) ((:sym vary-font)) ((:sym exact-font))
      ((:sym font-equal)))
     ((:header
       "The Fontmetrics Object   (holds attributes of the current font of a window)")
      ((:sym make-fontmetrics)) ((:sym fontmetrics))
      ((:sym nfontmetrics)) ((:sym smash-fontmetrics)))
     ((:header "Font Attributes")
      ((:header "On the Font Itself") ((:sym font-family))
       ((:sym font-face)) ((:sym font-size)) ((:sym font-style))
       ((:sym font-style-word)) ((:sym font-size-is-char-height))
       ((:sym font-angle)) ((:sym font-pixel-height)))
      ((:header "On the Associated Fontmetrics") ((:sym font-height))
       ((:sym font-ascent)) ((:sym font-descent)) ((:sym font-leading))
       ((:sym font-external-leading)) ((:sym font-internal-leading))
       ((:sym font-fixed-width-p)) ((:sym font-average-char-width))
       ((:sym font-max-char-width)) ((:sym font-vector-p))
       ((:sym font-truetype-p)) ((:sym font-device-p))
       ((:sym font-direction))))
     ((:header "Special System Fonts") ((:sym system-font))
      ((:sym system-fixed-font)) ((:sym ansi-var-font))
      ((:sym ansi-fixed-font)) ((:sym message-font)) ((:sym menu-font))
      ((:sym tooltip-font)) ((:sym status-bar-font)))
     ((:header "IDE Font Options") ((:sym fixed-font))
      ((:sym proportional-font)) ((:sym editor-font))
      ((:sym debug-font)) ((:sym class-graph-font))
      ((:sym inspector-name-font)) ((:sym inspector-value-font))
      ((:sym printer-font)) ((:sym cg-tree-font)))
     ((:header "Grid-Widget Font Functions") ((:sym cell-font))
      ((:sym font-reader)))))
   ((:header
     "Pixmaps   (also known as Bitmaps, Pixel Maps, Raster Images, BitBlting)")
    ((:doc "Pixmaps and Mouse Cursors Overview" "cg/cg-pixmaps.htm"))
    ((:nav "Navigator Pixmap Example" :array-blit-example))
    ((:nav "A Pixmap Viewer and Manager" :viewer-example))
    ((:header "Creating and Saving Pixmaps")
     ((:sym pixmap "(instantiable class)"))
     ((:header "Using Standard .BMP Bitmap Files") ((:sym load-pixmap))
      ((:sym save-pixmap)))
     ((:header "Saving Pixmaps as Lisp Source Code")
      ((:sym load-lisp-pixmap)) ((:sym save-lisp-pixmap))
      ((:sym import-pixmaps)))
     ((:header "Copying a Screen Image into a Pixmap")
      ((:nav "Navigator Pixmap-Grabbing Example"
        :get-screen-pixmap-example))
      ((:sym get-pixmap)) ((:sym get-texture-info))
      ((:sym get-screen-pixmap)) ((:sym get-screen-box))
      ((:sym get-pixels "(deprecated; use get-pixmap)")))
     ((:header "Passing Pixmaps on the Operating System Clipboard")
      ((:doc "About the Clipboard" "cg/cg-clipboard.htm"))
      ((:nav "Navigator Clipboard Example" :clipboard-example))
      ((:sym clipboard-object))
      ((:sym clipboard-pixmap "(deprecated; use clipboard-object)"))
      ((:info
        "Also, the PRINTSCREEN key copies the screen to the clipboard."))
      ((:info
        "And Alt-PRINTSCREEN copies the selected top-level window there.")))
     ((:header "Built-In Color Vectors")
      ((:sym default-pixmap-color-vector))
      ((:sym default-gray-pixmap-color-vector))
      ((:sym initial-pixmap-color-vector))
      ((:sym default-256-color-palette-vector))
      ((:header "Deprecated") ((:sym default-palette-vector))
       ((:sym default-gray-palette-vector))
       ((:sym initial-palette-vector)))))
    ((:header "Drawing Pixmaps")
     ((:info
       "The \"stream\" may be a window, the screen, a bitmap-stream, or a printer stream."))
     ((:sym copy-to-stream "(pixmap to stream)"))
     ((:sym replicate-pixmap))
     ((:sym copy-stream-area "(stream to stream)"))
     ((:sym copy-pixels-to-stream-from-file "(file to stream)"))
     ((:sym stretch-mode))
     ((:header "Using Masks for Non-Rectangular Images")
      ((:navigator "Navigator Octafun Example" :octagons-example))
      ((:sym generate-mask))))
    ((:header "Pixmap Properties") ((:sym bits-per-pixel))
     ((:sym colors)) ((:sym contents)) ((:sym width)) ((:sym height))
     ((:sym invert-p)) ((:sym mask)) ((:sym mask-contents))
     ((:sym source)) ((:sym pixmap-handle)) ((:sym mask-handle))
     ((:header "Redundant Older Equivalents") ((:sym texture))
      ((:sym texture-info))))
    ((:header "Accessing Individual Pixels") ((:sym contents))
     ((:sym contents-ref))
     ((:sym contents-set "(deprecated; use (setf contents-ref))"))
     ((:sym mask-contents)) ((:sym mask-contents-ref))
     ((:sym mask-contents-set
       "(deprecated; use (setf mask-contents-ref))")))
    ((:header
      "Using Faster \"Device-Dependent\" Pixmaps   (Pixmap Handles)")
     ((:sym open-pixmap-handle)) ((:sym close-pixmap-handle))
     ((:sym pixmap-use-handle "(control property)"))
     ((:sym use-pixmap-handles "(configuration option)")))
    ((:header
      "Caching Pixmaps   (for looking them up later from their names)")
     ((:sym cache-pixmap)) ((:sym find-pixmap)) ((:sym uncache-pixmap))
     ((:sym restore-pixmaps))
     ((:cod
       "Inspect All Cached Pixmaps   (including many built-in button pixmaps)"
       (inspect cg.pixmap:*cached-pixmaps*))))
    ((:header "Other Pixmap Functions") ((:sym rotate-pixmap)))
    ((:header
      "Lower-Level Pixmap Objects   (which are parts of a pixmap object)")
     ((:info
       "It may never be necessary to use these older sub-pixmap objects."))
     ((:header "Textures")
      ((:header "Creating Textures")
       ((:sym texture "(instantiable class)")) ((:sym texture-p))
       ((:sym make-texture-contents)) ((:sym load-texture))
       ((:sym save-texture)) ((:sym get-texture)))
      ((:header "Drawing Textures") ((:sym copy-pixels-to-stream))
       ((:sym copy-pixels-with-mask-to-stream)))
      ((:header "Texture Properties") ((:sym texture-array))
       ((:sym texture-array-height)) ((:sym texture-array-width)))
      ((:header "Accessing Individual Pixels") ((:sym contents))
       ((:sym contents-ref))
       ((:sym contents-set "(deprecated; use (setf contents-ref))")))
      ((:header "Rotating and Flipping Textures")
       ((:sym rotate-texture)) ((:sym reflect-pixmap-in-x))
       ((:sym reflect-pixmap-in-y)))
      ((:header "Window Attributes that Use Textures")
       ((:header "fill-texture") ((:sym fill-texture))
        ((:sym fill-texture-origin)) ((:sym nfill-texture-origin))
        ((:sym fill-texture-size)))
       ((:sym background-texture)))
      ((:header "Built-In Textures") ((:sym black-texture))
       ((:sym white-texture)) ((:sym gray-texture))
       ((:sym dark-gray-texture)) ((:sym light-gray-texture))))
     ((:header "Texture-Infos")
      ((:sym texture-info "(structure class)"))
      ((:sym make-texture-info "(instantiates a texture-info)"))
      ((:sym load-texture-info)) ((:sym *default-texture-info*))
      ((:sym *default-inverted-texture-info*))
      ((:header "Texture-Info Accessors")
       ((:sym texture-info-bits-per-pixel))
       ((:sym texture-info-colors)) ((:sym texture-info-width))
       ((:sym texture-info-height)) ((:sym texture-info-invert-p))
       ((:sym texture-info-x-device-units-per-m "(not needed)"))
       ((:sym texture-info-y-device-units-per-m "(not needed)")))
      ((:header "Deprecated") ((:sym default-texture-info))
       ((:sym default-inverted-texture-info))))
     ((:header "Pixmap Handles   (used by themselves)")
      ((:sym create-pixmap-handle)) ((:sym destroy-pixmap-handle))))
    ((:header "Using Pixmaps on Controls")
     ((:header "Classes of Controls that Use Pixmaps")
      ((:sym static-picture)) ((:sym picture-button))
      ((:sym multi-picture-button)) ((:sym outline)))
     ((:header "Pixmap-Oriented Properties of Controls")
      ((:sym pixmap)) ((:sym pixmap-name)) ((:sym pixmap-source))
      ((:sym pixmap-icon)) ((:sym pixmap-use-handle))
      ((:header "Outline Properties Related to Pixmaps")
       ((:sym draw-icons "(whether to draw the pixmaps at all)"))
       ((:sym leaf-pixmap)) ((:sym leaf-pixmap-name))
       ((:sym leaf-pixmap-source)) ((:sym opened-pixmap))
       ((:sym opened-pixmap-name)) ((:sym opened-pixmap-source))
       ((:sym closed-pixmap)) ((:sym closed-pixmap-name))
       ((:sym closed-pixmap-source))))
     ((:header "Updating Controls to their .BMP Pixmap Files")
      ((:sym sync-widget-to-image-file))
      ((:sym update-widgets-of-image-file))))
    ((:header "Enhancing the Inspector with Pixmap Markers")
     ((:sym pixmap "(method)"))))
   ((:header
     "Icons   (like a standard-size pixmap with a built-in mask)")
    ((:doc "About Icons" "cg/cg-icons.htm"))
    ((:header "Creating and Drawing Icons")
     ((:sym extract-icon-from-file)) ((:sym count-icons-in-file))
     ((:sym create-icon-handle)) ((:sym destroy-icon-handle))
     ((:sym draw-icon)))
    ((:header "Assigning Icons to Objects")
     ((:sym icon "(window property)"))
     ((:sym pixmap-icon "(control property)"))
     ((:sym ide.project:icon-file "(project property)")))
    ((:header
      "Built-In Icon Handles   (supplied by the operating system)")
     ((:sym information-icon)) ((:sym question-icon))
     ((:sym warning-icon)) ((:sym error-icon))
     ((:sym application-icon))))
   ((:header "Color")
    ((:header "Color Objects")
     ((:header "RGB Objects")
      ((:sym rgb "(class; instantiate-with make-rgb)"))
      ((:sym make-rgb)) ((:sym with-rgb)) ((:sym rgb-red))
      ((:sym rgb-green)) ((:sym rgb-blue)) ((:sym rgb-p))
      ((:sym rgb-equal)))
     ((:header "HLS Objects")
      ((:sym hls "(class; instantiate with make-hls)"))
      ((:sym make-hls)) ((:sym hls-hue)) ((:sym hls-lightness))
      ((:sym hls-saturation)) ((:sym hls-p)))
     ((:header "Converting") ((:sym rgb-to-hls)) ((:sym hls-to-rgb))))
    ((:header "Current Drawing Color") ((:sym background-color))
     ((:sym foreground-color)) ((:sym effective-background-color))
     ((:sym effective-foreground-color)) ((:sym with-background-color))
     ((:sym with-foreground-color)) ((:sym default-background-color))
     ((:sym default-foreground-color)) ((:sym line-texture)))
    ((:header
      "Special Drawing Colors   (reflecting the user's Control Panel preferences)")
     ((:sym system-foreground-color)) ((:sym system-background-color))
     ((:sym system-dialog-background-color))
     ((:sym system-app-workspace-color))
     ((:sym system-highlight-foreground-color))
     ((:sym system-highlight-background-color))
     ((:sym system-edge-highlight-color))
     ((:sym system-edge-shadow-color)) ((:sym system-disabled-color)))
    ((:header
      "Named Colors   (RGB constants for the standard VGA colors)")
     ((:header "Black, White, and Grays") ((:sym black)) ((:sym white))
      ((:sym gray)) ((:sym light-gray)) ((:sym dark-gray)))
     ((:header "Medium Darkness") ((:sym red)) ((:sym green))
      ((:sym blue)) ((:sym yellow)) ((:sym cyan)) ((:sym magenta)))
     ((:header "High Darkness") ((:sym dark-red)) ((:sym dark-green))
      ((:sym dark-blue)) ((:sym dark-yellow)) ((:sym dark-cyan))
      ((:sym dark-magenta)))
     ((:header "Low Darkness") ((:sym light-red)) ((:sym light-green))
      ((:sym light-blue)) ((:sym light-yellow)) ((:sym light-cyan))
      ((:sym light-magenta))))
    ((:header "Other Color Functions")
     ((:sym color "(hotspot and button-info property)"))
     ((:sym colors "(pixmap property)"))
     ((:sym ask-user-for-color "(common dialog)"))
     ((:header "Color-Oriented Properties of Windows and Controls")
      ((:sym foreground-color)) ((:sym background-color))
      ((:sym unavailable-color-mapper)) ((:sym pressed-color-mapper))
      ((:header "Grid-Widget Color Properties") ((:sym border-color))
       ((:sym default-cell-border-color))
       ((:sym cell-background-color)) ((:sym cell-foreground-color))
       ((:sym cell-unavailable-foreground-color)))
      ((:nav "Navigator Colorful Control Example"
        :color-demo-example)))
     ((:sym screen-colors))
     ((:sym texture-info-colors "(texture-info property)" ]))
     ((:sym color-number)) ((:sym colorize)))
    ((:header
      "Palettes   (needed for custom colors when Windows is not in true-color mode)")
     ((:doc "Color Palettes Overview" "cg/cg-color-palettes.htm"))
     ((:nav "Navigator Palette Example" :palettes-example))
     ((:nav "Navigator Pixmap Example" :array-blit-example))
     ((:sym palette "(returns or sets the palette of a window)"))
     ((:sym open-palette)) ((:sym close-palette))
     ((:sym realize-palette)) ((:sym palette-size))
     ((:sym screen-colors)) ((:sym animate-color-number))))
   ((:header "Printing Hardcopy")
    ((:nav "Navigator Basic Printing Example" :basic-printing-example))
    ((:nav "Navigator Scaled Printing Example"
      :printer-resolution-example))
    ((:doc "Drawing on a printer" "cg/cg-drawing.htm#on-printers-2"))
    ((:header "Creating Printer Streams")
     ((:sym printer "(class; instantiate with (open-stream 'printer)"))
     ((:sym open-stream
       "(instantiates a bitmap-stream or printer class)"))
     ((:sym printer-names "(returns the available printers)")))
    ((:header "Using Printer Streams")
     ((:info
       "Draw on a printer-stream just as you would on a window."))
     ((:sym with-output-to-printer))
     ((:sym with-printer
       "(for querying or setting up a printer only)"))
     ((:sym new-page)) ((:sym draw-on-printer))
     ((:sym print-text-file))
     ((:sym stream-units-per-inch "(for scaling printed output)"))
     ((:sym print-abort-proc)))
    ((:header "Printer Stream Properties")
     ((:header
       "Read / Write   (may be specifed as initargs to open-stream)")
      ((:sym orientation "(:portrait or :landscape)"))
      ((:sym print-quality "(:high, :medium, :low, or :draft)"))
      ((:sym paper-source)) ((:sym double-sided))
      ((:sym scale
        "(scaling factor for the printer driver; default is 1.0)"))
      ((:header "Number of Copies   (initarg is :copies)")
       ((:sym driver-copies
         "(copies that the driver will print automatically)"))
       ((:sym user-copies
         "(copies that the application must explicitly print)")))
      ((:header "Whether to Collate   (initarg is :collate-p)")
       ((:sym driver-collate-p
         "(whether the driver will collate automatically)"))
       ((:sym user-collate-p
         "(whether the application must collate explicitly)")))
      ((:header "Whether to Print to a File Instead of a Printer")
       ((:sym filename "(initarg is :print-to-file-p)")))
      ((:header "Range of Pages to Print")
       ((:sym start-page "(initarg is :start)"))
       ((:sym end-page "(initarg is :end)")))
      ((:header
        "Margins   (these may be setf'ed in the middle of a print job)")
       ((:sym left-margin)) ((:sym top-margin)) ((:sym right-margin))
       ((:sym bottom-margin)))
      ((:sym multicolor
        "(whether a color printer is in multicolor mode)")))
     ((:header
       "Read-Only   (these are filled in when a printer stream is opened)")
      ((:header "Page Size   (the size of the printable area)")
       ((:header
         "Outside the Margins   (still inside the \"hardware\" margins)")
        ((:sym page-width)) ((:sym page-height)))
       ((:header "Inside the Margins") ((:sym page-length))
        ((:sym line-length)) ((:sym interior-width))
        ((:sym interior-height)) ((:sym page-box)) ((:sym npage-box))))
      ((:header "Paper Size   (the size of the physical paper)")
       ((:header "Symbolic")
        ((:sym paper-size "(:letter, :legal, :a4, etc.)")))
       ((:header "In Inches or Millimeters")
        ((:sym paper-size-unit "(:inch or :mm)")) ((:sym paper-width))
        ((:sym paper-length)))
       ((:header "In Stream Units   (pixels by default)")
        ((:sym printer-physical-offset
          "(size of the \"hardware\" margin)"))
        ((:sym printer-physical-size
          "(size of the physically printable area)"))))
      ((:sym page-number)) ((:sym selected-pages-p))
      ((:sym printer-name)) ((:sym printer-port-name))
      ((:sym driver-name)) ((:sym driver-version))
      ((:sym spec-version))))
    ((:header "Printer Dialogs")
     ((:sym pop-up-printer-job-dialog
       "(pass its arguments through open-stream)"))
     ((:sym pop-up-printer-setup-dialog "(the Page Setup dialog)"))
     ((:sym choose-default-printer
       "(deprecated; call pop-up-printer-setup-dialog or use the print job dialog)")))
    ((:header "Default Printer Margins   (Global Variables)")
     ((:sym *default-printer-left-margin*))
     ((:sym *default-printer-top-margin*))
     ((:sym *default-printer-right-margin*))
     ((:sym *default-printer-bottom-margin*))))
   ((:header "Automatic Graph Layout for Cyclic Graphs")
    ((:sym graph-layout)) ((:sym graph-boundaries))
    ((:sym center-all-nodes)) ((:sym other-node)))
   ((:header "The IDE's Tree Grapher (not exported for applications)")
    ((:nav "Navigator Grapher Example" :grapher-example))
    ((:sym class-graph-font "(configuration option)"))
    ((:sym class-graph-initial-depth "(configuration option)"))
    ((:sym ide.grapher:graph-child-windows))
    ((:info "Tools | Graph Subclasses   (menu command)"))
    ((:info "Tools | Graph Superclasses   (menu command)"))))
  ((:header "Common Graphics Configuration Options")
   ((:header "Modifying Configuration Options Interactively")
    ((:doc "The Options Dialog"
      "ide-menus-and-dialogs/options-dialog.htm"))
    ((:doc "The Configuration"
      "cg/ide-ug/ide_user_guide_1.htm#sec-1-5"))
    ((:cod "Show the Options Dialog   (Tools | Options)"
      (ide.base:show-options-dialog)))
    ((:cod
      "Inspect All CG Configuration Options   (Tools | Inspect System Data | Configuration Options)"
      (inspect (configuration *system*)))))
   ((:header "Modifying Configuration Options Programmatically")
    ((:info
      "Example:  disable tooltips with (setf (show-tooltips (configuration *system*)) nil)"))
    ((:sym configuration "(class and *system* accessor)"))
    ((:sym cg-configuration)) ((:sym *system*))
    ((:sym ide.base:options-path)))
   ((:header "All CG Options")
    ((:header "Default Window Size and Position")
     ((:sym default-width-factor)) ((:sym default-height-factor))
     ((:sym offset-from-selected-window))
     ((:sym center-all-modal-dialogs-on-screen))
     ((:sym modal-dialog-margin)))
    ((:header "Default Fonts") ((:sym fixed-font))
     ((:sym proportional-font)))
    ((:header "Tab-Control Defaults") ((:sym default-tab-height))
     ((:sym default-tab-width)))
    ((:header "Timers") ((:sym tooltip-delay))
     ((:sym menu-tooltip-delay))
     ((:sym multi-picture-button-scroll-interval))
     ((:sym use-cg-timer)) ((:sym cg-timer-interval)))
    ((:header "Tooltips") ((:sym show-tooltips))
     ((:sym tooltip-vertical-offset)) ((:sym tooltip-delay))
     ((:sym custom-tooltip-font)))
    ((:header "Lisp Source Code Options")
     ((:header "Lisp Source Indentation and Parenthesis Matching")
      ((:sym conserve-indentation)) ((:sym parenthesis-matching-color))
      ((:sym parenthesis-matching-style)))
     ((:header "Lisp Source Code Colorization")
      ((:header "Colorizing Automatically")
       ((:sym colorize-on-load-file)) ((:sym colorize-on-typing)))
      ((:header "The Colors to Use") ((:sym color-for-comments))
       ((:sym color-for-strings)) ((:sym color-for-characters))
       ((:sym color-for-global-variables))
       ((:sym color-for-external-cl-symbols))
       ((:sym color-for-external-allegro-symbols))
       ((:sym color-for-external-cg-symbols))
       ((:sym color-for-user-functions)))))
    ((:header "Other Common Graphics Options")
     ((:sym clipboard-history-limit)) ((:sym custom-status-bar-font))
     ((:sym use-pixmap-handles))
     ((:sym drag-images "(fancy drag-and-drop)"))
     ((:sym delay-pop-up-menus-until-mouse-buttons-up))
     ((:sym map-control-left-click-to-right-click)))))
  ((:header "Auxilliary CG Functionality")
   ((:header "Multimedia Control Interface   (MCI)")
    ((:doc "MCI Support" "cg/cg-mci.htm"))
    ((:nav "Navigator Wave File Demo" :play-wave-example))
    ((:header "MCI Devices   (instantiable classes)")
     ((:sym mci-wave-audio
       "(plays and records .wav digital audio files)"))
     ((:sym mci-sequencer "(plays and records .mid MIDI files)"))
     ((:sym mci-animation "(plays .avi animation files)"))
     ((:sym mci-cd-audio "(plays audio compact discs)"))
     ((:sym mci-device
       "(non-instantiable superclass for all MCI devices)"))
     ((:header "Untested Devices") ((:sym mci-dat))
      ((:sym mci-overlay)) ((:sym mci-scanner))
      ((:sym mci-video-disc))))
    ((:header "Basic MCI Operations") ((:sym mci-open))
     ((:sym mci-close)) ((:sym mci-play)) ((:sym mci-stop))
     ((:sym mci-record)) ((:sym mci-save)) ((:sym mci-step))
     ((:sym mci-pause)) ((:sym mci-resume)) ((:sym mci-seek))
     ((:sym mci-delete)) ((:sym mci-set-window))
     ((:sym mci-set-wave-options)) ((:sym mci-send-string)))
    ((:header "MCI Device Attributes") ((:sym mci-device-file))
     ((:sym mci-sysinfo)) ((:sym mci-device-name))
     ((:sym mci-device-number)) ((:sym mci-device-id))
     ((:sym mci-device-error-function))
     ((:header "Device Type") ((:sym mci-device-type))
      ((:sym mci-device-type-constant))
      ((:sym mci-device-type-string))))
    ((:header "MCI Notification Callbacks") ((:sym mci-notify)))
    ((:header "MCI Capability Inquiries") ((:sym mci-device-type))
     ((:sym mci-device-inputs)) ((:sym mci-device-outputs))
     ((:sym mci-device-uses-files-p)) ((:sym mci-device-max-windows))
     ((:sym mci-device-palettes-p)) ((:sym mci-compound-device-p))
     ((:header "\"Can\" Functions") ((:sym mci-device-can-eject-p))
      ((:sym mci-device-can-play-p)) ((:sym mci-device-can-record-p))
      ((:sym mci-device-can-save-p)) ((:sym mci-device-can-freeze-p))
      ((:sym mci-device-can-reverse-p))
      ((:sym mci-device-can-stretch-p)))
     ((:header "\"Has\" Functions") ((:sym mci-device-has-audio-p))
      ((:sym mci-device-has-video-p)))
     ((:header "Rate") ((:sym mci-device-fast-rate))
      ((:sym mci-device-normal-rate)) ((:sym mci-device-slow-rate))))
    ((:header "MCI Status Inquiries") ((:sym mci-device-mode))
     ((:sym mci-device-side)) ((:sym mci-device-level))
     ((:sym mci-device-speed)) ((:sym mci-device-input))
     ((:sym mci-device-output)) ((:sym mci-device-number-of-tracks))
     ((:sym mci-device-current-track)) ((:sym mci-device-track-length))
     ((:sym mci-device-track-position)) ((:sym mci-device-length))
     ((:sym mci-device-position)) ((:sym mci-device-start-position))
     ((:sym mci-device-ready-p)) ((:sym mci-device-time-format))
     ((:sym mci-device-forward-p)) ((:sym mci-device-stretch-p))
     ((:sym mci-device-media-present-p)) ((:sym mci-device-hpal))
     ((:sym mci-device-hwnd)) ((:sym mci-device-disc-size))
     ((:sym mci-device-media-type))
     ((:sym mci-device-average-bytes-per-second))
     ((:sym mci-device-bits-per-sample))
     ((:sym mci-device-samples-per-second))
     ((:sym mci-device-block-alignment)) ((:sym mci-device-channels))
     ((:sym mci-device-format-tag)))
    ((:header "Setting MCI Device Status")
     ((:sym mci-device-set-audio-on)) ((:sym mci-device-set-audio-off))
     ((:sym mci-device-set-video-on)) ((:sym mci-device-set-video-off))
     ((:sym mci-device-set-door-open))
     ((:sym mci-device-set-door-closed))
     ((:sym mci-device-set-time-format)))
    ((:header "Time Format Conversion") ((:sym tmsf-to-integer))
     ((:sym integer-to-tmsf))))
   ((:header "Miscellaneous Non-Graphical Utility Functions")
    ((:header "Web-Browsing Utilities") ((:sym invoke-html-browser))
     ((:sym invoke-private-html-browser))
     ((:sym private-html-browser-handle))
     ((:sym use-private-html-browser))
     ((:sym ide.base:use-cg-html-browser))
     ((:sym invoke-web-browsers-with-keystrokes))
     ((:sym invoke-html-browser-using-dde))
     ((:sym find-mozilla-gtk-path "(possibly needed on GTK)"))
     ((:doc "Adding Comprehensive Help to an Application"
       "cg/cg-application-help.htm#comprehensive-help-2")))
    ((:header "String Manipulation") ((:sym read-safely))
     ((:sym read-from-string-safely)) ((:sym list-to-delimited-string))
     ((:sym delimited-string-to-list))
     ((:sym symbol-string-and-package-from-string))
     ((:sym crlf
       "(a string constant for a carriage return / line feed pair)")))
    ((:header "Pretty Print Names") ((:sym name-string))
     ((:header "Changing String Case") ((:sym lowercase-object))
      ((:sym uppercase-object)) ((:sym capitalize-object))
      ((:sym capitalize-symbol)) ((:sym capitalize-if-symbol))
      ((:sym change-case-like-reader))))
    ((:header "Handling Streams") ((:sym get-stream-prop))
     ((:sym set-stream-prop)))
    ((:sym value-constants)) ((:sym with-slot-value))
    ((:sym recreation-code)) ((:sym gensym-sequential-name))
    ((:sym beep)) ((:sym ide.base:in-break))
    ((:sym common-graphics-implementation-version))
    ((:sym ide.base:ide-implementation-version)))
   ((:header "The Clipboard")
    ((:nav "Navigator Clipboard Example" :clipboard-example))
    ((:doc "About the Clipboard" "cg/cg-clipboard.htm"))
    ((:doc "The Clipboard Dialog"
      "ide-menus-and-dialogs/clipboard-dialog.htm"))
    ((:header
      "The Operating System Clipboard   (holds a single value available system-wide)")
     ((:sym clipboard-object)) ((:sym available-clipboard-formats))
     ((:sym clipboard-format-from-object))
     ((:sym clipboard-string "(deprecated; use clipboard-object)"))
     ((:sym clipboard-pixmap "(deprecated; use clipboard-object)"))
     ((:sym can-paste "(deprecated; deemed not useful)")))
    ((:header
      "The Lisp Clipboard   (holds a stack of values available within Lisp)")
     ((:info
       "(The top value on the lisp clipboard is also placed onto the OS Clipboard,"))
     ((:info
       "and a new OS clipboard value is also placed onto the Lisp Clipboard.)"))
     ((:sym push-lisp-clipboard)) ((:sym pop-lisp-clipboard))
     ((:sym clipboard-changed "(extendable generic function)"))
     ((:sym clipboard-history-limit "(configuration option)"))
     ((:header "Recent Lisp Clipboard Values   (global variables)")
      ((:sym =)) ((:sym ==)) ((:sym ===)))
     ((:sym *clipboard* "(the stack of values on lisp clipboard)"))
     ((:sym top-clipboard-value-of-type))
     ((:sym convert-clipboard-from-lisp
       "(deprecated; use (setf clipboard-object))"))
     ((:sym convert-clipboard-to-lisp
       "(deprecated; use clipboard-object)"))
     ((:sym ensure-lisp-clipboard "(deprecated; not needed)")))
    ((:header "Copy / Cut / Delete / Paste / Insert")
     ((:sym copy-command)) ((:sym cut-command)) ((:sym delete-command))
     ((:sym paste-command)) ((:sym insert-command))
     ((:sym copy-selection)) ((:sym cut-selection))
     ((:sym delete-selection)) ((:sym paste-selection))
     ((:sym insert-selection)) ((:sym cuttable)) ((:sym pastable))
     ((:sym default-clipboard-format))))
   ((:header "Semi-Internal Things")
    ((:header "Programming at the Microsoft Windows API Level")
     ((:info
       "Use the FFI to call into Windows DLLs as with any other DLL."))
     ((:cod
       "Microsoft's MSDN On-Line   (see Platform SDK in their outline)"
       (invoke-html-browser "http://msdn.microsoft.com/library/default.asp")))
     ((:doc "The Foreign Function Interface" "foreign-functions.htm"))
     ((:doc "Foreign Types" "ftype.htm"))
     ((:header "Using Raw WINAPI Functions on Common Graphics Windows")
      ((:sym handle "(returns the handle of a CG window)"))
      ((:sym window-from-handle
        "(returns the CG window for a handle)"))
      ((:sym device-context
        "(returns the device-context of a window)"))
      ((:sym with-device-context
        "(provides a device-context for drawing on an OS control)"))
      ((:sym hinst "(returns the handle to the running executable)")))
     ((:header "Receiving Low-Level Window Events for OS Controls")
      ((:sym subclass-widget)) ((:sym unsubclass-widget))
      ((:sym widget-subclassed-p))))
    ((:header
      "The System Object   (where internal global information is stored)")
     ((:doc "The *system* Object" "cg/cg-system.htm"))
     ((:sym system "(class with a single built-in instance)"))
     ((:sym *system* "(bound to the single instance)"))
     ((:cod
       "Inspect the *system* Object   (Tools | Inspect System Data | Internal System Parameters)"
       (inspect *system*)))))
   ((:header "Miscellaneous Deprecated Symbols")
    ((:sym open-dialog "(use make-window)"))
    ((:sym groupstart "(no longer used in modern interfaces)"))
    ((:sym flip-monochrome-bytes
      "(should no longer be needed with pixmap objects)"))
    ((:header "Modifying Positions and Boxes")
     ((:sym set-position-x "(use (setf position-x))"))
     ((:sym set-position-y "(use (setf position-y))"))
     ((:sym set-box-left "(use (setf box-left))"))
     ((:sym set-box-top "(use (setf box-top))"))
     ((:sym set-box-right "(use (setf box-right))"))
     ((:sym set-box-bottom "(use (setf box-bottom))")))
    ((:header "Recently Unexported")
     ((:info "dirty-p   (checked whether there is anything to erase)"))
     ((:info
       "closed-stream   (a window was changed to this class when it is closed)"))
     ((:info "reinitialize-system   (not useful for applications)"))
     ((:info
       "read-only-p   (internal to the inspector; read-only is used elsewhere)"))
     ((:info "user-close-primary-window   (use user-close)"))
     ((:info "texture-array-ref   (use contents-ref)"))
     ((:info "texture-array-set   (use (setf contents-ref))"))
     ((:info "widget-tab-control   (use tab-control-widget)"))
     ((:info "*lsp-extensions*   (was never documented)"))
     ((:info "hiword   (took the upper 16 bits of a 32-bit value)"))
     ((:info "code-file")) ((:info "event-handling-processes"))
     ((:info "main-event-handler")) ((:info "primary-window"))
     ((:info "project-window")) ((:info "main-project-window"))
     ((:info "ide-project-window"))))))
 ((:header
   "Integrated Development Environment   (the IDE: a set of graphical tools for developing lisp applications)")
  ((:header
    "Starting Up and Exiting the IDE   (or a standalone application)")
   ((:header "Starting Up the IDE")
    ((:doc "Starting Up the IDE" "cgide.htm#startup-1"))
    ((:doc "Starting Up the Base Lisp" "startup.htm"))
    ((:header
      "The startup.cl file   (to customize the IDE at startup)")
     ((:info
       "If you create a startup.cl file in the main Allegro directory,"))
     ((:info
       "it will be loaded once the IDE has finished starting up."))
     ((:info
       "The clinit.cl file is loaded after startup up the base lisp.")))
    ((:sym ide.base:*ide-startup-hook*))
    ((:sym ide.base:start-ide
      "(starts up the IDE from a running base lisp)"))
    ((:sym ide.base:*starting-ide* "(deprecated)"))
    ((:sym ide.base:*ide-is-running*))
    ((:sym start-in-allegro-directory
      "(affects the initial file dialog default directory)"))
    ((:header
      "The Command Line   (the command string that started the lisp or app)")
     ((:info
       "Use the \"-project\" command line option to specify the path of a project to open initially."))
     ((:sym system:command-line-arguments))
     ((:sym system:command-line-argument)) ((:sym command-line))
     ((:doc "Setting Built-In Command-Line Arguments"
       "delivery.htm#resources-2")))
    ((:header "The Directory of the Running Executable   (IDE or app)")
     ((:info
       "(translate-logical-pathname \"sys:\") returns the directory pathname"))
     ((:sym path
       "(path (app *system*)) returns the path namestring of the executable file"))))
   ((:header "Exiting the IDE") ((:sym ide.base:exit-tests))
    ((:sym query-exit)) ((:sym os-exit-request))
    ((:sym ide.base:query-os-exit))))
  ((:header "The IDE Windows")
   ((:doc "Menus and Dialogs in the IDE" "cgide.htm#menus-dialogs-1"))
   ((:header "The IDE Menu Bar")
    ((:doc "The File Menu" "ide-menus-and-dialogs/file-menu.htm"))
    ((:doc "The Edit Menu" "ide-menus-and-dialogs/edit-menu.htm"))
    ((:doc "The Search Menu" "ide-menus-and-dialogs/search-menu.htm"))
    ((:doc "The View Menu" "ide-menus-and-dialogs/view-menu.htm"))
    ((:doc "The Windows Menu"
      "ide-menus-and-dialogs/windows-menu.htm"))
    ((:doc "The Tools Menu" "ide-menus-and-dialogs/tools-menu.htm"))
    ((:doc "The Run Menu" "ide-menus-and-dialogs/run-menu.htm"))
    ((:doc "The Form Menu" "ide-menus-and-dialogs/form-menu.htm"))
    ((:doc "The Recent Menu" "ide-menus-and-dialogs/recent-menu.htm"))
    ((:doc "The Help Menu" "ide-menus-and-dialogs/help-menu.htm")))
   ((:header "Main IDE Windows")
    ((:header "The Debug Window   (A Lisp Listener with Debug Panes)")
     ((:doc "The Debug Window"
       "ide-menus-and-dialogs/debug-window.htm"))
     ((:header "Configuration Options for the Debug Window")
      ((:sym close-inactive-listeners)) ((:sym debug-font))
      ((:sym initial-package)) ((:sym debug-history-limit))
      ((:sym ide.base:ide-prompt)))
     ((:header "IDE Listener Functions")
      ((:sym ide.base:selected-listener-pane))
      ((:sym ide.base:with-output-to-ide-listener))
      ((:sym ide.base:format-debug)))
     ((:doc "Top-Level Listener Commands" "top-level.htm"))
     ((:header
       "The Backtrace Pane   (appears when selecting Debug from the Restarts Dialog)")
      ((:info
        "Each line is a frame on the stack.  Click its blue arrow to open its arguments and local values."))
      ((:header "Using the Inspector with a Backtrace")
       ((:info
         "To see arguments in the Inspector, double-click a frame line or use Tools | Inspect."))
       ((:info
         "To see a single argument in the Inspector, double-click an argument line.")))
      ((:header "Submitting a Bug Report")
       ((:info
         "Use File | Save in a backtrace pane to save a bug report to a file."))
       ((:doc "Submitting a Bug Report from a Break in the IDE"
         "cgide.htm#bug-reports-1"))
       ((:doc "Reporting Bugs and Asking Questions"
         "cg/ide-ug/ide_user_guide_1.htm#sec-1-6")))
      ((:header
        "Controlling the Print Size of Values in the Backtrace")
       ((:sym backtrace-print-level)) ((:sym backtrace-print-length))
       ((:sym backtrace-print-circle))))
     ((:doc "Debugging with Top-Level Listener Commands"
       "debugging.htm")))
    ((:header "The Source Code Editor")
     ((:doc "The IDE Editor"
       "ide-menus-and-dialogs/editor-workbook.htm"))
     ((:header "Editor Keystrokes")
      ((:doc "The Shortcut Keys Dialog"
        "ide-menus-and-dialogs/shortcut-keys-dialog.htm"))
      ((:cod "Show the Shortcut Keys Dialog   (Help | Shortcut Keys)"
        (ide.keyshort:comtab-report :stream nil)))
      ((:sym ide.base:*text-edit-comtab*)))
     ((:header "Controlling How Individual Operators Will Indent")
      ((:sym text-edit-indentation)))
     ((:header "Configuraton Properties for the Editor")
      ((:sym editor-mode)) ((:sym editor-font))
      ((:header "Controlling Indentation")
       ((:sym conserve-indentation "(global configuration property)"))
       ((:sym comment-indent
         "(to where inline comments will indent)")))
      ((:header "Parenthesis Matching")
       ((:sym parenthesis-matching-color))
       ((:sym parenthesis-matching-style)))
      ((:header "Default Directories")
       ((:sym start-in-allegro-directory))
       ((:sym context-sensitive-default-path)))
      ((:sym ide.base:highlight-selected-editor-tab))
      ((:sym incremental-search)) ((:sym find-again-after-replace))
      ((:sym ide.base:editor-string-search-lines-of-padding))
      ((:sym ide.base:handle-multiple-packages-in-buffer))
      ((:sym pretty-printer))
      ((:sym warn-on-no-action-taken
        "(turn off to disable string-not-found dialogs)"))
      ((:sym external-format-for-saved-files "(configuration option)"))
      ((:sym load-utf8-if-no-bom "(configuration option)"))
      ((:sym write-bom-to-utf8-files "(configuration option)"))
      ((:sym ide.base:ide-auto-font-changing "(configuration option)"))
      ((:sym ide.base:ide-dual-fonts-for-languages
        "(configuration option)")))
     ((:header "Using GNU Emacs Instead of the IDE Editor")
      ((:doc "Editor Options"
        "cg/ide-ug/ide_user_guide_1.htm#sec-1-3"))
      ((:doc "The Emacs-Lisp Interface" "eli.htm"))
      ((:sym open-files-in-gnu-emacs))))
    ((:header "The Inspector")
     ((:doc "The IDE Inspector"
       "ide-menus-and-dialogs/inspect-dialog.htm"))
     ((:header "Configuration Options for the IDE Inspector")
      ((:sym inspector-name-font)) ((:sym inspector-value-font))
      ((:sym inspector-style)))
     ((:doc "Inspecting with Top-Level Listener Commands"
       "inspector.htm"))
     ((:sym ide.inspector:ide-inspect))
     ((:sym ide.inspector:ide-inspect-standalone)))
    ((:header "The IDE's Main Owner or Parent Window")
     ((:sym ide.base:main-ide-window))
     ((:sym ide.base:ide-owner-window))
     ((:sym ide.base:ide-parent-window))
     ((:sym ide.base:ide-child-window))
     ((:sym ide.base:top-ide-window))
     ((:sym ide.base:use-ide-parent-window))
     ((:sym ide.base:maximize-ide)) ((:sym ide.base:ide-page-size))
     ((:sym development-main-window
       "(deprecated; use main-ide-window)")))
    ((:header "The Console Window   (a non-CG window outside the IDE)")
     ((:info "View | Console   (menu command)"))
     ((:sym console-control "(A base lisp function)"))
     ((:sym display-console "(IDE configuration option)"))
     ((:sym *initial-terminal-io*
       "(bound to the Console window in a development lisp)"))
     ((:sym show-console)) ((:sym hide-console))
     ((:sym console-is-visible)) ((:sym console-title))
     ((:sym console-tray-icon)) ((:sym console-tray-tooltip))
     ((:sym console-handle))
     ((:sym *show-console-on-standalone-error*))))
   ((:header "IDE Tool Dialogs")
    ((:header "Searching for Things")
     ((:header "Finding Source Code Definitions")
      ((:doc "The Find Definitions Dialog   (finds source code)"
        "ide-menus-and-dialogs/definitions-dialog.htm"))
      ((:info "Search | Find Definition   (menu command)"))
      ((:info "Search | Quick Find Definition   (menu command)"))
      ((:sym ide.find-definitions:defdefiner))
      ((:doc "Source File Recording" "source-file-recording.htm"))
      ((:sym ide.base:load-cg-source-file-info)))
     ((:header "Finding Strings in Files")
      ((:doc "The Find In Files Dialog   (finds strings in files)"
        "ide-menus-and-dialogs/find-in-files-dialog.htm"))
      ((:sym initial-search-directories "(configuration option)"))
      ((:sym ide.base:initial-search-filters "(configuration option)"))
      ((:sym ide.base:find-in-files-show-html-files-in-browser
        "(configuration option)"))
      ((:sym ide.base:find-in-files-file-list-portion
        "(configuration option)")))
     ((:header "Finding Strings in Text Windows and Controls")
      ((:doc "The Find Dialog"
        "ide-menus-and-dialogs/find-dialog.htm"))
      ((:doc "The Replace Dialog"
        "ide-menus-and-dialogs/replace-dialog.htm")))
     ((:doc "The Apropos Dialog   (finds symbols)"
       "ide-menus-and-dialogs/apropos-dialog.htm")))
    ((:header "Trace Dialog")
     ((:doc "The Trace Dialog"
       "ide-menus-and-dialogs/trace-dialog.htm"))
     ((:sym ide.trace:trace-format))
     ((:sym ide.base:process-trace-color))
     ((:sym ide.base:with-trace-color))
     ((:sym inhibit-trace-for-object))
     ((:sym scroll-while-tracing "(configuration option)"))
     ((:sym ide.trace:use-trace-dialog-in-this-process))
     ((:nav "Navigator Trace Example" :trace-example)))
    ((:header "Runtime Analyzer Dialogs")
     ((:doc "The Runtime Analyzer Control Dialog"
       "ide-menus-and-dialogs/runtime-analyzer-control-dialog.htm"))
     ((:doc "The Runtime Analyzer Results Dialog"
       "ide-menus-and-dialogs/runtime-analyzer-results-dialog.htm"))
     ((:nav "Navigator Runtime Analyzer Example" :profile-example))
     ((:doc "Runtime Analyzer Functions" "runtime-analyzer.htm"))
     ((:sym profiler-included-node-types)))
    ((:doc "Class Browser"
      "ide-menus-and-dialogs/class-browser-dialog.htm"))
    ((:doc "Project Manager dialog"
      "ide-menus-and-dialogs/project-manager-dialog.htm"))
    ((:doc "Options Dialog"
      "ide-menus-and-dialogs/options-dialog.htm"))
    ((:doc "Shortcut Keys"
      "ide-menus-and-dialogs/shortcut-keys-dialog.htm"))
    ((:doc "Menu Editor"
      "ide-menus-and-dialogs/menu-editor-dialog.htm"))
    ((:doc "Window List"
      "ide-menus-and-dialogs/window-list-dialog.htm"))
    ((:doc "Package List"
      "ide-menus-and-dialogs/package-list-dialog.htm"))
    ((:doc "Navigator" "ide-menus-and-dialogs/navigator-dialog.htm"))
    ((:doc "Processes Table"
      "ide-menus-and-dialogs/process-dialog.htm"))
    ((:doc "Clipboard Dialog"
      "ide-menus-and-dialogs/clipboard-dialog.htm")))
   ((:sym ide.base:find-ide-window))
   ((:sym ide.base:move-ide-windows-on-screen-resize)))
  ((:header "Managing an Application")
   ((:header "Using Projects")
    ((:doc "Introduction to Projects"
      "cg/ide-ug/ide_user_guide_4.htm"))
    ((:doc "The Project Manager dialog"
      "ide-menus-and-dialogs/project-manager-dialog.htm"))
    ((:header "Project Properties")
     ((:header "Event Handlers of a Project")
      ((:sym ide.project:on-initialization))
      ((:header "Typically Not Used") ((:sym ide.project:on-restart))
       ((:sym do-default-restart))
       ((:sym do-default-debugable-restart))))
     ((:header "Parts of a Project")
      ((:header "Classes") ((:sym project)) ((:sym module))
       ((:sym module-p)) ((:sym build-module)) ((:sym form-module))
       ((:sym library-module)) ((:sym project-module)))
      ((:header "Finding the Parts of a Project")
       ((:sym ide.base:current-project))
       ((:sym ide.project:find-project))
       ((:sym ide.project:main-module)) ((:sym ide.project:main-form))
       ((:sym modules)) ((:sym projects)) ((:sym libraries))
       ((:sym ide.project:distributed-files))
       ((:sym ide.project:editable-files))
       ((:sym ide.project:internally-loaded-files)) ((:sym file))
       ((:sym files)) ((:sym ide.project:all-projects))
       ((:sym ide.project:all-files))
       ((:sym ide.project:runtime-modules))
       ((:sym ide.project:all-runtime-modules))
       ((:sym ide.project:form-file))))
     ((:header
       "Options for Generating a Standalone Deliverable Application")
      ((:header "Application Icons and Splash Pixmaps")
       ((:sym ide.project:icon-file)) ((:sym ide.project:splash-file))
       ((:sym kill-splash-screen-when-ready)))
      ((:header "Default Error Handling in a Standalonen Aplication")
       ((:sym default-error-handler-for-delivery))
       ((:sym report-unexpected-error-and-exit))
       ((:sym *show-console-on-standalone-error*)))
      ((:sym ide.project:build-flags)) ((:sym build-number))
      ((:sym ide.project:include-flags))
      ((:sym ide.project:project-file-version-info))
      ((:sym run-with-console))
      ((:sym ide.project:additional-build-lisp-image-arguments))
      ((:sym ide.project:default-command-line-arguments))
      ((:sym ide.project:runtime-build-option
        "(currently only :standard is allowed, for a standard .EXE)"))
      ((:sym
        ide.project:full-recompile-for-runtime-conditionalizations))
      ((:sym ide.project:include-manifest-file-for-visual-styles))
      ((:sym ide.project:autoload-warning))
      ((:sym ide.project:find-required-modules)))
     ((:header "Garbage Collection in the Standalone Application")
      ((:sym ide.project:old-space-size))
      ((:sym ide.project:new-space-size)))
     ((:header "Miscellaneous Project Properties")
      ((:sym ide.project:project-file))
      ((:sym ide.project:project-package))
      ((:sym ide.project:project-package-name))
      ((:sym ide.form:form-package-name))
      ((:sym ide.project:compilation-unit))
      ((:sym ide.project:concatenate-project-fasls))
      ((:sym ide.project:before-functions))
      ((:sym ide.project:after-functions)) ((:sym modified))
      ((:sym loaded)) ((:sym verbose))))
    ((:header "Project Functions") ((:sym ide.project:open-project))
     ((:sym open-project-action)) ((:sym ide.project:load-project))
     ((:sym ide.project:build-project)) ((:sym define-project))
     ((:sym ide.project:compile-project))
     ((:sym ide.project:full-compile-project))
     ((:sym ide.project:close-current-project)))
    ((:header "How a Standalone Application Starts Up")
     ((:header "The On-Initialization Function")
      ((:sym ide.project:on-initialization "(project property)"))
      ((:sym default-init-function)))
     ((:sym main-window-maker)) ((:sym kill-splash-screen))
     ((:sym kill-splash-screen-when-ready))
     ((:sym command-line
       "(the command string that started up the application)")))
    ((:header
      "The \"App\" Application Object   (for information on the exectuable that's running)")
     ((:sym app "(class with a single built-in instance)"))
     ((:header "Properties of the App Object")
      ((:sym command-line
        "(the command string that started the current lisp)"))
      ((:sym path "(the path namestring of the executable file)"))
      ((:sym standalone-application
        "(true if a generated app is running rather than the IDE)"))))
    ((:header "Project-Related IDE Configuration Options")
     ((:sym ide.base:project-parent-directory))
     ((:sym new-project-show-editor)) ((:sym new-project-show-form))
     ((:sym new-project-show-project-manager))
     ((:sym run-project-action)) ((:sym open-project-action))
     ((:sym ide.base:open-project-show-project-manager))
     ((:sym ide.base:open-project-show-files-in-editor))
     ((:sym ide.base:close-project-close-editor-buffers))
     ((:sym ide.base:distribution-directories))))
   ((:header
     "Building Dialogs and other Windows Interactively as Forms")
    ((:doc "A Simple Forms Example" "cg/ide-ug/ide_user_guide_3.htm"))
    ((:doc "Adding Components to Forms"
      "cg/ide-ug/ide_user_guide_5.htm"))
    ((:doc "Designing a User Interface"
      "cg/ide-ug/ide_user_guide_6.htm"))
    ((:cod "Run the \"Doodler\" Interface Builder Tutorial"
      (ide.base:start-tutorial-command nil)))
    ((:doc "The Run Project and Run Form commands"
      "ide-menus-and-dialogs/run-menu.htm"))
    ((:header "Special Properties for Forms")
     ((:sym device
       "(specifies the class to instantiate when running the form)")))
    ((:header
      "Programmatically Running a Dialog that Has Been Built Interactively as a Form")
     ((:sym ide.project:finder-function))
     ((:sym ide.project:maker-function))
     ((:sym ide.project:running-window))
     ((:sym ide.project:running-form)) ((:sym ide.project:main-form)))
    ((:header "Configuration Options for Forms")
     ((:header "Background Placement Grid of a Form Window")
      ((:sym display-form-grid)) ((:sym snap-to-grid))
      ((:sym grid-x-spacing)) ((:sym grid-y-spacing)))
     ((:header "Automatic Alignment of Controls on a Form")
      ((:sym snap-to-grid)) ((:sym snap-to-components)))
     ((:header "Overlapping and Spacing of Controls on a Form")
      ((:sym allow-component-overlap))
      ((:sym min-pixels-between-widgets)))
     ((:header "Generating Recreation Source Code")
      ((:sym pprint-plist-definers))
      ((:sym pprint-plist-pairs-on-separate-lines))
      ((:sym code-file-pretty-print-columns)))
     ((:sym ide.base:show-widget-palette-when-click-form))
     ((:sym ide.form:sample-initargs)))
    ((:header "Default Menu-Bar Commands")
     ((:info
       "These are on the initial menu-bar supplied by the Menu Editor Dialog."))
     ((:header "Default File Menu") ((:sym new-text-editor))
      ((:sym open-text-file)) ((:sym save-text-file))
      ((:sym save-as-text-file)))
     ((:header "Default Edit Menu") ((:sym undo-command))
      ((:sym copy-command)) ((:sym cut-command)) ((:sym paste-command))
      ((:sym delete-command))))
    ((:header "Not Useful")
     ((:sym *loaded-but-uncreated-windows*
       "(deprecated but still exported for importing 3.0.2-generated dialog code)"))))
   ((:header "Creating a Standalone Executable")
    ((:header "Interactively, Using the Current Project")
     ((:info "File | Build Project EXE   (menu command)"))
     ((:info "File | Build Project Distribution   (menu command)")))
    ((:header "Programmatically, Independent of Projects")
     ((:doc "Delivering Applications" "delivery.htm"))
     ((:doc "Runtime Licensing Options" "runtime.htm"))
     ((:sym generate-application))
     ((:doc "Adding an Application Icon to a Standalone App"
       "delivery.htm#resources-2"))
     ((:doc "Setting Built-In Command-Line Arguments"
       "delivery.htm#resources-2"))
     ((:sym ide.project:find-required-modules)))))
  ((:header "Customizing the IDE")
   ((:header
     "Configuration Options   (user preferences stored in prefs.cl)")
    ((:header "Modifying Configuration Options Interactively")
     ((:doc "The Options Dialog"
       "ide-menus-and-dialogs/options-dialog.htm"))
     ((:doc "The Configuration"
       "cg/ide-ug/ide_user_guide_1.htm#sec-1-5"))
     ((:cod "Show the Options Dialog   (Tools | Options)"
       (ide.base:show-options-dialog)))
     ((:cod
       "Inspect All IDE Configuration Options   (Tools | Inspect System Data | Configuration Options)"
       (inspect (configuration ide.base:*ide-system*)))))
    ((:header "Modifying Configuration Options Programmatically")
     ((:info
       "Example:  Turn on scroll-while-tracing with (setf (scroll-while-tracing (configuration ide:*ide-system*)) t)"))
     ((:sym configuration "(class and *ide-system* accessor)"))
     ((:sym ide.base:ide-configuration)) ((:sym ide.base:*ide-system*))
     ((:sym ide.base:options-path)))
    ((:header
      "All IDE Options   (includes some options not found on the Options Dialog)")
     ((:header "IDE Windows")
      ((:header "Which IDE Windows to Show at Startup")
       ((:sym ide.base:ask-for-action-at-ide-startup))
       ((:sym ide.base:move-ide-windows-on-screen-resize))
       ((:sym ide.base:shift-windows-onto-screen-at-startup))
       ((:sym display-status-bar)) ((:sym display-toolbars))
       ((:sym display-extended-toolbar))
       ((:sym new-project-show-editor))
       ((:sym ide.base:new-project-create-form))
       ((:sym new-project-show-project-manager))
       ((:sym ide.base:patch-reminder-interval))
       ((:sym ide.base:patch-reminder-previous-time))
       ((:sym display-console)) ((:sym ide.base:use-ide-parent-window))
       ((:sym use-ide-background-window))
       ((:sym maximize-ide-background-window))
       ((:sym ide.base:ide-exterior)))
      ((:header "The Debug Window") ((:sym close-inactive-listeners))
       ((:sym debug-font)) ((:sym debug-history-limit))
       ((:sym ide.base:ide-prompt)))
      ((:header "The Source Code Editor") ((:sym editor-font))
       ((:sym editor-mode))
       ((:sym ide.base:editor-string-search-lines-of-padding))
       ((:sym find-again-after-replace))
       ((:sym ide.base:editor-string-search-lines-of-padding))
       ((:sym ide.base:handle-multiple-packages-in-buffer))
       ((:sym comment-indent)) ((:sym start-in-allegro-directory))
       ((:sym context-sensitive-default-path))
       ((:sym incremental-search))
       ((:sym warn-on-no-action-taken
         "(turn off to disable string-not-found dialogs)"))
       ((:sym open-files-in-gnu-emacs)))
      ((:header "The Inspector") ((:sym inspector-name-font))
       ((:sym inspector-style)) ((:sym inspector-value-font)))
      ((:header "The \"Recent\" Menu") ((:sym recent))
       ((:sym recent-limit)))
      ((:header "The Class Grapher") ((:sym class-graph-font))
       ((:sym class-graph-initial-depth))
       ((:sym ide.base:use-color-gradients-in-tree-graphs))
       ((:sym ide.base:use-antialiased-text-in-tree-graphs)))
      ((:header "Tracing") ((:sym scroll-while-tracing)))
      ((:header "The Runtime Analyzer")
       ((:sym profiler-included-node-types))))
     ((:header "Fonts") ((:sym editor-font)) ((:sym debug-font))
      ((:sym class-graph-font)) ((:sym inspector-name-font))
      ((:sym inspector-value-font)) ((:sym printer-font)))
     ((:header "Prompting the User") ((:sym warn-on-no-action-taken))
      ((:sym show-dialog-on-compiler-warnings))
      ((:sym ask-before-auto-saving))
      ((:sym ide.base:ask-before-assuming-package)) ((:sym query-exit))
      ((:sym ide.base:query-os-exit))
      ((:sym ide.base:directory-dialog-avoids-network))
      ((:sym ide.base:ask-for-action-at-ide-startup))
      ((:sym ide.base:patch-reminder-interval))
      ((:sym ide.base:patch-reminder-previous-time))
      ((:sym ide.base:directory-dialog-searches-network-globally)))
     ((:header "Projects") ((:sym ide.base:project-parent-directory))
      ((:sym new-project-show-editor)) ((:sym new-project-show-form))
      ((:sym new-project-show-project-manager))
      ((:sym run-project-action)) ((:sym open-project-action))
      ((:sym ide.base:open-project-show-project-manager))
      ((:sym ide.base:open-project-show-files-in-editor))
      ((:sym ide.base:close-project-close-editor-buffers))
      ((:sym ide.base:distribution-directories)))
     ((:header "Building Forms")
      ((:header "Background Placement Grid of Form Windows")
       ((:sym display-form-grid)) ((:sym snap-to-grid))
       ((:sym grid-x-spacing)) ((:sym grid-y-spacing)))
      ((:header "Automatic Alignment of Controls on a Form")
       ((:sym snap-to-grid)) ((:sym snap-to-components)))
      ((:header "Overlapping and Spacing of Controls on a Form")
       ((:sym allow-component-overlap))
       ((:sym min-pixels-between-widgets)))
      ((:header "Generating Recreation Source Code")
       ((:sym pprint-plist-definers))
       ((:sym pprint-plist-pairs-on-separate-lines))
       ((:sym code-file-pretty-print-columns)))
      ((:sym ide.form:sample-initargs)))
     ((:header "Symbol Completion")
      ((:sym maximum-symbol-completion-choices))
      ((:sym symbol-completion-searches-all-packages)))
     ((:header "Other IDE Preferences") ((:sym ide.base:ide-priority))
      ((:sym initial-search-directories
        "(for the Find in Files dialog)"))
      ((:sym ide.base:initial-search-filters
        "(for the Find in Files dialog)"))
      ((:sym ide.base:find-in-files-show-html-files-in-browser
        "(for the Find in Files dialog)"))
      ((:sym ide.base:find-in-files-file-list-portion))
      ((:sym standard-toolbar-icons))
      ((:sym window-configurations "(read-only)"))
      ((:sym use-private-html-browser))
      ((:sym ide.base:use-cg-html-browser))
      ((:sym invoke-web-browsers-with-keystrokes))
      ((:sym ide.base:ide-html-history))
      ((:sym ide.base:default-http-proxy)))
     ((:header "Lisp Printer Variables")
      ((:header "In a Backtrace Pane") ((:sym backtrace-print-circle))
       ((:sym backtrace-print-level)) ((:sym backtrace-print-length)))
      ((:header "In the IDE Status Bar")
       ((:sym lisp-message-print-length))
       ((:sym lisp-message-print-level)))))
    ((:header "Saving All Configuration Options to the PREFS.CL File")
     ((:sym ide.base:options-path))
     ((:sym save-options-on-exit "(configuration option)"))
     ((:sym save-options-to-user-specific-file
       "(configuration option)"))
     ((:sym ide.base:keep-configuration
       "(returns whether a particular window's location is saved)"))
     ((:info "Tools | Save Options Now   (menu command)"))
     ((:info "Tools | Save Options On Exit   (menu command)"))))
   ((:header "Quick IDE Alternatives")
    ((:header "Switching Between IDE Windows Quickly")
     ((:header "Switching Between Top-Level Windows")
      ((:info
        "Use the shortcuts for View | Manage | Show Second / Third / Fourth"))
      ((:info
        "For example, control-alt-K cycles between three windows.")))
     ((:header "Switching Between Child Panes and Tab-Control Tabs")
      ((:info
        "The following keystrokes apply to some but not all paned or tabbed IDE windows."))
      ((:info
        "They do apply to editor tabs and to listener & backtrace panes."))
      ((:info "Control-shift-J cycles between two panes or tabs."))
      ((:info "Control-shift-K cycles between three panes or tabs."))
      ((:info
        "Control-shift-L toggles the focus between a listener pane and its backtrace pane."))
      ((:info "Control-shift-< selects the tab to the left."))
      ((:info "Control-shift-> selects the tab to the right."))))
    ((:header "Finding Source Code Quickly")
     ((:info "Tools | Quick Find Definition   (menu command)"))
     ((:header "Event-Handler Source Code for Controls")
      ((:header "Controls on Forms")
       ((:info
         "Select an existing event-handler on the control's right-button shortcut menu.")))
      ((:header "Controls Not on Forms")
       ((:info
         "Control-Alt-Right Click any control to edit its on-change function.")))))
    ((:header "Suppressing Certain Modal Dialogs")
     ((:header "Warning that a Requested Action Cannot Be Done")
      ((:sym warn-on-no-action-taken
        "(turn off this configuration option)"))
      ((:info
        "Also found on the Workspace tab of the Options dialog.")))
     ((:header "Asking Whether to Save Files")
      ((:sym ask-before-auto-saving
        "(turn off this configuration option)"))
      ((:info
        "Also found on the Project tab of the Options dialog."))))
    ((:header "Keyboard Shortcuts")
     ((:doc "The Shortcut Keys Dialog"
       "ide-menus-and-dialogs/shortcut-keys-dialog.htm"))
     ((:cod "Show the Shortcut Keys Dialog   (Help | Shortcut Keys)"
       (ide.keyshort:comtab-report :stream nil)))
     ((:sym set-event-function
       "(add your own shortcuts to *text-edit-comtab*)"))
     ((:sym add-global-keyboard-accelerator
       "(add your own global shortcuts)"))
     ((:sym ide.keyshort:comtab-report))
     ((:sym ide.base:*text-edit-comtab*)))
    ((:header "Adding a Lisp Source Code File to the Current Project")
     ((:info
       "If you are editing the source code file in the IDE editor,"))
     ((:info
       "then simply right-click the editor pane and select Add File to Project.")))
    ((:header "Creating Fewer Windows when the IDE Starts Up")
     ((:info
       "Uncheck \"Show Editor\" and \"Show Form & Inspector\" on the Project tab"))
     ((:info
       "of the Tools | Options dialog, and no editor, form, or inspector will be"))
     ((:info "created when the IDE starts up with a new project."))
     ((:sym new-project-show-editor)) ((:sym new-project-show-form))
     ((:sym new-project-show-project-manager)))
    ((:header
      "Specifying a Different Search Directory in the Find In Files Dialog")
     ((:info
       "Typing Alt-O moves the focus to the Search Directory combo-box."))
     ((:info
       "There you can type a new path or use the up and down arrows to re-use a path."))
     ((:info
       "And backspacing can be done, as usual, with control-H."))))
   ((:header
     "Using Properties   (also available in a standalone application)")
    ((:sym property "(class)"))
    ((:header "Defining Properties") ((:sym define-property))
     ((:sym defproperties)) ((:sym defcomponent)))
    ((:header "Accessing Properties") ((:sym properties))
     ((:sym event-handlers)) ((:sym non-event-properties))
     ((:sym find-property)))
    ((:header "Property Attributes")
     ((:header "Given an Object and a Property Name")
      ((:sym property-value "(formerly called \"property\")"))
      ((:sym property-reader)) ((:sym property-writer))
      ((:sym property-choices)) ((:sym property-default-value))
      ((:sym property-default-value-p)) ((:sym property-editor-type))
      ((:sym property-help-string)) ((:sym property-read-only))
      ((:sym property-hidden)) ((:sym property-remake))
      ((:sym ide.form:property-starter-code)) ((:sym property-type)))
     ((:header "Given a Property Object") ((:sym initarg))
      ((:sym remake)) ((:sym editor-mode)) ((:sym read-only))
      ((:sym help-string)))))
   ((:header "Displaying Messages in the IDE Status-Bar")
    ((:sym ide.base:lisp-message)) ((:sym ide.base:lisp-warning))
    ((:sym ide.base:*lisp-message-window*))
    ((:sym lisp-message-print-level))
    ((:sym lisp-message-print-length)))
   ((:header "Using Subclassed or Custom Controls on Forms")
    ((:header "Adding Control Classes to the IDE Toolbar")
     ((:sym ide.base:add-to-component-toolbar))
     ((:sym ide.base:remove-from-component-toolbar)))
    ((:header "Relationships between Controls on Forms ")
     ((:sym followers)) ((:sym ide.form:fanatical-followers))
     ((:sym partners)) ((:sym ide.form:partner-types))
     ((:sym ide.form:subobjects-with-partners)))
    ((:sym recreation-code)))
   ((:header "Other IDE Customization") ((:sym ide.base:display-help))
    ((:sym selected-object
      "(could be specialized for an application's window classes)")))))
 ((:header
   "Connectivity   (facilities for communicating with other applications)")
  ((:header
    "The Foreign Function Interface   (for calling into shared libraries (DLLs in MS-Windows))")
   ((:doc "Foreign Functions" "foreign-functions.htm"))
   ((:doc "Foreign Types" "ftype.htm"))
   ((:header "Automatically translating C header files to Lisp")
    ((:doc "Introduction to CBind and CPLBind" "cbind-intro.htm"))
    ((:doc "CBind" "cbind.htm"))
    ((:doc "CPLBind   (for C++)" "cplbind.htm"))))
  ((:header "Network Communication")
   ((:header "Sockets")
    ((:doc "The Allegro CL Socket Library" "socket.htm"))
    ((:doc "The Domain Naming System (DNS)" "dns.htm"))
    ((:doc "Universal Resource Indicator (URI) suppport" "uri.htm"))
    ((:exm "Telnet Server Example" "examples/tserver.cl")))
   ((:header
     "AllegroServe   (adds web server functionality to any lisp application)")
    ((:doc "AllegroServe Overview" "aserve/aserve.html"))
    ((:doc "AllegroServe Tutorial" "aserve/tutorial.html"))
    ((:header "AllegroServe Example Code")
     ((:exm "tutorial.cl" "examples/aserve/tutorial.cl"))
     ((:exm "examples.cl" "examples/aserve/examples.cl"))
     ((:exm "puzzle.cl" "examples/aserve/puzzle.cl"))
     ((:exm "chat.cl" "examples/aserve/chat.cl"))
     ((:exm "urian.cl   (a web page non-ascii character analyzer)"
       "examples/aserve/urian.cl")))
    ((:header "Webactions")
     ((:doc "Using Allegro Webactions" "using-webactions.html"))
     ((:doc "Webactions Reference" "webactions.html"))))
   ((:header "Other HTML/XML Tools")
    ((:doc
      "SOAP support   (an XML-based protocol for remote procedure calls)"
      "soap.htm"))
    ((:doc "HTML Generator" "aserve/htmlgen.html"))
    ((:doc "HTML Parser   (turns HTML text into a lisp tree)"
      "phtml.htm"))
    ((:doc "XML Parser   (turns XML into a lisp tree)" "pxml.htm"))
    ((:doc "Sax XML Parser" "sax.htm"))
    ((:doc "Document Object Model (DOM) Support" "dom.htm")))
   ((:doc "File Transfer Protocol (FTP)" "ftp.htm"))
   ((:doc "imap and pop  (for email servers)" "imap.htm")))
  ((:header "Java Tools")
   ((:doc
     "JLinker   (dynamic access to Java objects and methods from Lisp)"
     "jlinker.htm"))
   ((:doc
     "Jil   (lets you write code with Lisp syntax that runs on a Java Virtual Machine)"
     "jil.htm")))
  ((:header "Database Tools")
   ((:header
     "AllegroCache   (a distributed object-oriented database facility)")
    ((:htm "AllegroCache Tutorial" "acache/doc/acachetutorial.pdf"))
    ((:htm "AllegroCache Reference" "acache/doc/acache.pdf")))
   ((:doc "AODBC  (connecting to databases via ODBC)" "aodbc.htm"))
   ((:doc "MySQL Direct Connect Library" "mysql.htm"))
   ((:doc "Allegro Oracle Direct Connect   (an Oracle Interface)"
     "oracle-interface.htm")))
  ((:header "Other Connectivity Tools")
   ((:doc
     "Remote Procedure Call (RPC)   (one lisp communicating with another)"
     "rpc.htm"))
   ((:doc "XML-RPC in Allegro CL" "xml-rpc.htm"))
   ((:htm "Orblink   (the Corba orb for ACL)" "orblink/doc/index.htm"))
   ((:doc "Creating Shared Libraries on Windows (DLL's) in Lisp"
     "dll.htm"))
   ((:doc "Creating Shared Libraries on Unix"
     "unix-shared-library.htm")))
  ((:header "Microsoft-Specific Connectivity")
   ((:header "OLE / COM   (Windows-specific connectivity)")
    ((:doc "OLE / COM Overview" "ole.htm"))
    ((:doc "OLE Reference" "ole_reference.htm"))
    ((:header "Sample01:  A simple automation client")
     ((:exm "readme.txt" "ole/samples/sample01/readme.txt"))
     ((:exm "calendar.cl" "ole/samples/sample01/calendar.cl")))
    ((:header "Sample02:  A slightly more complex automation client")
     ((:exm "readme.txt" "ole/samples/sample02/readme.txt"))
     ((:exm "iexplorer.cl" "ole/samples/sample02/iexplorer.cl")))
    ((:header "Sample03:  An automation server and its client")
     ((:exm "readme.txt" "ole/samples/sample03/readme.txt"))
     ((:exm "client.cl" "ole/samples/sample03/client.cl"))
     ((:exm "server.cl" "ole/samples/sample03/server.cl")))
    ((:header
      "Sample04:  A self-registering automation server and a Visual Basic client")
     ((:exm "readme.txt" "ole/samples/sample04/readme.txt"))
     ((:exm "server.cl" "ole/samples/sample04/server.cl"))
     ((:exm "client.frm" "ole/samples/sample04/client.frm"))
     ((:exm "deliver.cl" "ole/samples/sample04/deliver.cl")))
    ((:header
      "Sample05:  An inproc lisp automation server being used by a Visual C++ client")
     ((:exm "readme.txt" "ole/samples/sample05/readme.txt"))
     ((:exm "server.cl" "ole/samples/sample05/server.cl"))
     ((:exm "unreg.cl" "ole/samples/sample05/unreg.cl"))
     ((:exm "deliver.cl" "ole/samples/sample05/deliver.cl"))
     ((:exm "main.h" "ole/samples/sample05/main.h"))
     ((:exm "resource.h" "ole/samples/sample05/resource.h"))
     ((:exm "winmain.cpp" "ole/samples/sample05/winmain.cpp"))
     ((:exm "mainwind.cpp" "ole/samples/sample05/mainwind.cpp"))
     ((:exm "vcaclclient.rc" "ole/samples/sample05/vcaclclient.rc")))
    ((:header
      "Sample06:  An inproc lisp automation server being used by a Visual Basic client")
     ((:exm "readme.txt" "ole/samples/sample06/readme.txt"))
     ((:exm "server.cl" "ole/samples/sample06/server.cl"))
     ((:exm "deliver.cl" "ole/samples/sample06/deliver.cl"))
     ((:exm "client.frm" "ole/samples/sample06/client.frm"))
     ((:exm "dllreg.cpp" "ole/samples/sample06/dllreg.cpp"))
     ((:exm "dllreg.mak" "ole/samples/sample06/dllreg.mak")))
    ((:header "Sample08:  A CLOS interface to Excel")
     ((:exm "readme.txt" "ole/samples/sample08/readme.txt"))
     ((:exm "client.cl" "ole/samples/sample08/client.cl"))
     ((:exm "excel.cl" "ole/samples/sample08/excel.cl"))))
   ((:header
     "Dynamic Data Exchange (DDE)   (a simple Windows-specific technique for passing data)")
    ((:doc "About DDE Support" "dde.htm"))
    ((:cgx "DDE Examples" "dde-examples.cl"))
    ((:header "Acting as a DDE Client")
     ((:header "Setting Up Ports and Shutting Down")
      ((:sym client-port "(instantiable class)"))
      ((:header "Port Accessors") ((:sym port-name))
       ((:sym port-application)) ((:sym port-topic)))
      ((:sym open-port)) ((:sym port-open-p)) ((:sym close-port))
      ((:sym close-dde)))
     ((:header "Interaction with Server Applications")
      ((:sym send-request)) ((:sym send-command)) ((:sym send-value))
      ((:sym receive-advice))
      ((:header "Converting Values Returned by a DDE Server")
       ((:sym convert-returned-dde-string))
       ((:sym convert-returned-dde-buffer))
       ((:sym string-from-dde-buffer))
       ((:sym dword-list-from-dde-buffer)))))
    ((:header "Acting as a DDE Server")
     ((:header "Setting Up the Server and Shutting Down")
      ((:sym open-server)) ((:sym close-server)) ((:sym close-dde)))
     ((:header "Interaction with Client Applications")
      ((:sym answer-request)) ((:sym execute-command))
      ((:sym receive-value)) ((:sym post-advice))))
    ((:header "DDE Warnings and Other Messages") ((:sym dde-message))
     ((:sym *generate-dde-messages*)))
    ((:header "DDE Global Variables & the dde-info object")
     ((:sym *case-sensitive-dde*)) ((:sym dde-info))
     ((:sym case-sensitive-dde (dde-info accessor)))
     ((:header "Client-Specific")
      ((:sym active-client-ports (dde-info accessor))))
     ((:header "Server-Specific") ((:sym *service-name*))
      ((:sym service-name (dde-info accessor)))
      ((:sym *service-topics*))
      ((:sym service-topics (dde-info accessor))) ((:sym *sysitems*))
      ((:sym sysitems (dde-info accessor)))
      ((:sym server-active-p (dde-info accessor)))
      ((:sym active-server-ports (dde-info accessor)))))
    ((:header "Freeing DDE Strings when Many Item Names are Used")
     ((:sym free-item))))))
 ((:header
   "The Base Lisp   (the language and non-graphical environment, which are usable without the IDE and CG)")
  ((:header "The Common Lisp Language")
   ((:htm "The ANSI Common Lisp Specification" "ansicl/ansicl.htm"))
   ((:doc
     "Basic Lisp Techniques   (a tutorial by David J. Cooper, Jr., in PDF format)"
     "basic-lisp-techniques.pdf"))
   ((:doc "The Meta-Object Protocol (MOP)" "mop/contents.html")))
  ((:header "Allegro's Particular Implementation of Common Lisp")
   ((:doc "Implementation-Dependent Aspects of Common Lisp"
     "implementation.htm"))
   ((:doc "Packages" "packages.htm"))
   ((:doc "Pathnames" "pathnames.htm"))
   ((:header "Streams") ((:doc "Simple Streams" "streams.htm"))
    ((:doc "Gray Streams" "gray-streams.htm")))
   ((:doc "Garbage Collection   (automatic memory management)"
     "gc.htm"))
   ((:doc "Environments" "environments.htm")))
  ((:header
    "Language Extensions   (general language features that are not part of standard Common Lisp)")
   ((:header "Operating System Interface")
    ((:doc "Operating System Interface Overview" "os-interface.htm"))
    ((:header "Starting Up Other Applications from Lisp")
     ((:sym run-shell-command))
     ((:sym windows-command-for-document-type)))
    ((:header "The File System")
     ((:header "Files") ((:sym system:copy-file))
      ((:sym file-length
        "(can now take a pathname or namestring OR (as usual) a stream)"))
      ((:header
        "File Attribute Flags   (currently implemented for the Windows OS only)")
       ((:sym file-directory-p)) ((:sym file-attributes))
       ((:sym file-read-only-p)) ((:sym file-hidden-p))
       ((:sym file-system-p)) ((:sym file-normal-p))
       ((:sym file-temporary-p))))
     ((:header "Directories") ((:sym make-directory))
      ((:sym copy-directory)) ((:sym delete-directory))
      ((:sym delete-directory-and-files)) ((:sym directory-size))
      ((:header "The Directory of the Running Executable")
       ((:info
         "(translate-logical-pathname \"sys:\") returns the directory pathname"))
       ((:sym system:command-line-argument)))
      ((:header "Current or Default Directories and Pathnames")
       ((:sym current-directory "(returns the current OS directory)"))
       ((:sym chdir "(sets the current OS directory)"))
       ((:sym *default-pathname-defaults*
         "(the default pathname for merge-pathname etc.)"))
       ((:sym context-sensitive-default-path
         "(how the file selection dialog initializes its directory)"))))
     ((:header "Temporary Directories and Files")
      ((:sym system:temporary-directory))
      ((:sym system:make-temp-file-name))))
    ((:header
      "The Command Line   (the command string that started up lisp)")
     ((:sym system:command-line-arguments))
     ((:sym system:command-line-argument))
     ((:sym system:command-line-argument-count)))
    ((:header "Environment Variables") ((:sym system:getenv)))
    ((:doc "Operating System Constants" "osi-constants.htm")))
   ((:doc "International (Wide) Character Support" "iacl.htm"))
   ((:doc "Multiprocessing" "multiprocessing.htm"))
   ((:doc "String Case Sensitivity" "case.htm"))
   ((:doc
     "Fwrappers and Advice   (techniques for wrapping non-generic function calls)"
     "fwrappers-and-advice.htm"))
   ((:doc "Regular Expressions   (for pattern matching)" "regexp.htm"))
   ((:doc "Shell Module   (Unix-like shell commands within Lisp)"
     "shell-module.htm"))
   ((:doc "Encryption Support" "miscellaneous.htm#encrypt-1"))
   ((:doc "ISO 8601 Date and Time Support" "date-time.htm"))
   ((:doc "NDBM Support   (not available on Windows)" "ndbm.htm"))
   ((:doc "Allegro Prolog" "prolog.html"))
   ((:doc "Defsystem   (for managing the files of an application)"
     "defsystem.htm"))
   ((:doc "Flavors   (a pre-CLOS object system)" "flavors.htm"))
   ((:doc "Miscellaneous Extensions" "miscellaneous.htm")))
  ((:header "The Base Lisp Programming Environment")
   ((:doc "Starting Up the Base Lisp" "startup.htm"))
   ((:doc
     "Top-Level Listener Commands   (also available in the IDE's Debug Window)"
     "top-level.htm"))
   ((:header "Compiling and Loading")
    ((:doc "Overview of Compiling" "compiling.htm"))
    ((:header "Suppressing Certain Compiler Warnings")
     ((:header "Compiling a Definition in a Locked Package")
      ((:doc "*enable-package-locked-errors*"
        "variables/excl/s_enable-package-locked-errors_s.htm"))
      ((:doc "without-package-locks"
        "operators/excl/without-package-locks.htm")))
     ((:header "Compiling a Definition in a Different Place")
      ((:doc "*redefinition-warnings*"
        "variables/excl/s_redefinition-warnings_s.htm"))
      ((:sym without-redefinition-warnings))))
    ((:doc "Source File Recording" "source-file-recording.htm"))
    ((:doc "Loading Files" "loading.htm"))
    ((:doc "Compiler Explanations" "compiler-explanations.htm")))
   ((:header "Debugging Tools in the Base Lisp")
    ((:doc "Debugging" "debugging.htm"))
    ((:doc "The Debugger API" "debugger-api.htm"))
    ((:doc
      "Inspecting   (browsing the internal components of data objects)"
      "inspector.htm"))
    ((:doc "Runtime Analysis   (to find where most runtime is spent)"
      "runtime-analyzer.htm"))
    ((:doc "Cross-Referencing" "cross-reference.htm"))
    ((:doc "The Test Harness" "test-harness.htm")))
   ((:header "The Emacs-Lisp Interface (ELI)")
    ((:doc "ELI Documentation" "eli.htm"))
    ((:exm "Sample Emacs Lisp code for starting up Allegro"
      "eli/examples/emacs.el")))
   ((:doc "Common Errors" "errors.htm")))
  ((:header "Building Custom Development Images")
   ((:header "Saving the Currently Running Environment   ")
    ((:doc "Dumplisp Overview" "dumplisp.htm")) ((:sym dumplisp)))
   ((:header "Creating an Image with Customized Options")
    ((:doc "Building Images" "building-images.htm"))
    ((:sym build-lisp-image))))
  ((:header "Delivering a Standalone Application")
   ((:doc "Delivering Applications" "delivery.htm"))
   ((:doc "Runtime Licensing Options" "runtime.htm"))
   ((:sym generate-application))))
 ((:header "Other Graphical User Interface API's")
  ((:header "GTK Interface") ((:exm "readme.txt" "gtk/readme.txt"))
   ((:exm "gtk20.cl   (A LARGE single source code file)"
     "gtk/gtk20.cl"))
   ((:exm "loadgtk20.cl" "gtk/loadgtk20.cl")))
  ((:header
    "CLIM   (an alternate, cross-platform, higher-level API for developing graphical user interfaces)")
   ((:doc "CLIM User Guide   (Manual in PDF format)" "clim-ug.pdf"))))
 ((:header "Other Help Resources")
  ((:doc "Release Notes" "release-notes.htm"))
  ((:doc "Frequently Asked Questions (FAQ)" "faq/index.htm"))
  ((:doc "Installing Allegro CL" "installation.htm"))
  ((:doc "A Guide to Allegro Code Examples" "examples.htm"))
  ((:doc "Glossary" "glossary.htm"))
  ((:doc "Index to Exported Symbols   (excluding ANSI CL symbols)"
    "index.htm"))
  ((:doc
    "Permuted Index   (look up a symbol by any \"word\" in the name)"
    "permuted-index.htm"))
  ((:cod "Connect to the Franz Inc. Web Site"
    (invoke-html-browser "http://www.franz.com")))
  ((:header "Downloading Patches")
   ((:doc "The Download Patches Dialog"
     "ide-menus-and-dialogs/download-dialog.htm"))
   ((:doc "The Patch Reminder Dialog"
     "ide-menus-and-dialogs/check-for-new-patches-dialog.htm"))
   ((:sym ide.base:patch-reminder-interval))
   ((:sym ide.base:patch-reminder-previous-time))
   ((:sym system:update-allegro))
   ((:sym ide.base:default-http-proxy))))
 ((:header "Using this Help Outline")
  ((:doc "The Tree of Knowledge"
    "ide-menus-and-dialogs/common-graphics-tree-of-knowledge.htm"))
  ((:header "Jumping to the Help Pages for Each Topic")
   ((:info "Open the outline to a leaf item of interest."))
   ((:info
     "Either double-click the leaf item or select it and press the spacebar (or F1 or Enter).")))
  ((:header "Searching the Entire Outline")
   ((:info
     "Move the keyboard focus into this CG Tree dialog (anywhere in the outline)."))
   ((:info
     "Invoke the Search | Find menu-item (or its shortcut) and enter a string to find."))
   ((:info
     "The outline will open only as far as needed to reveal all matches."))
   ((:info
     "The matches will have a cyan background, and the first will be selected."))
   ((:info
     "Use Search | Find Again (or its shortcut) to move to successive matches.")))
  ((:header "Types of Help Entries")
   ((:info
     "  Every leaf node in this outline is of one of these types:"))
   ((:info
     "Hollow Arrow Icon & Black Text --- An in-place comment that does nothing."))
   ((:info
     "Sheet of Paper Icon & Dark Blue Text --- Shows a help page for a symbol."))
   ((:info
     "Sheet of Paper Icon & Dark Green Text --- Shows a help page for a general topic."))
   ((:info
     "Round Dot Icon & Dark Red Text --- Presents a source code example."))
   ((:info
     "Round Dot Icon & Dark Cyan Text --- Performs some special action.")))
  ((:header "Meanings of Special Phrases")
   ((:header "Classes")
    ((:info
      "(instantiable class) --- create instances using make-instance."))
    ((:info
      "(class; instantiate with FOO) --- create instances using a special function."))
    ((:info "(mix-in class) --- combine with an instantiable class."))
    ((:info
      "(class) --- instantiate only if this ability is mentioned elsewhere.")))
   ((:header "Generic Functions")
    ((:info
      "overridable generic function --- an application may add methods"))
    ((:info "    that may override the default method."))
    ((:info
      "extendable generic function --- an application may add methods"))
    ((:info "    that do not override the default method."))
    ((:info
      "    (Other generic functions are likely extendable as well.)")))
   ((:header "Properties")
    ((:info "If FOO is said to be a property of THING, then:"))
    ((:info "  The value can be retrieved with (foo thing)."))
    ((:info
      "  The value can be replaced with (setf (foo thing) value)."))
    ((:info "  The value may be initialized when THING is created."))
    ((:info
      "      by passing a :foo initarg to the instantiation function."))
    ((:info "(The latter two do not apply to read-only properties.)")))
   ((:header "Menu Commands")
    ((:info
      "File | Foo --- refers to the Foo command on the File pull-down menu of the IDE.")))
   ((:header "\"Deprecated\"")
    ((:info
      "A deprecated symbol is one that is no longer recommended for use."))
    ((:info
      "Typically it has been replaced by some more standard equivalent."))
    ((:info
      "The symbol may still be exported for backward compatibility,"))
    ((:info
      "    but may be unexported at some point in the future."))))
  ((:header "Opening a Whole Sub-Tree")
   ((:info
     "As with any outline control, hold down the Control key and then"))
   ((:info
     "    either left-click an outline-item icon or press the right-arrow key.")))
  ((:header "Changing The Font for This Outline")
   ((:sym cg-tree-font "(configuration option)"))
   ((:cod "Change the Font of this Outline"
     (ide.base::ask-user-for-cg-tree-font))))))