;
;#include <gtk/gtk.h>
;
;/* I'm going to be lazy and use some global variables to
; * store the position of the widget within the fixed
; * container */
;gint x = 50;
;gint y = 50;
;
;/* This callback function moves the button to a new position
; * in the Fixed container. */
;void move_button( GtkWidget *widget,
;		   GtkWidget *fixed )
;{
;  x = (x + 30) % 300;
;  y = (y + 50) % 300;
;  gtk_fixed_move (GTK_FIXED (fixed), widget, x, y); 
;}
;
;int main( int   argc,
;	   char *argv[] )
;{
;  /* GtkWidget is the storage type for widgets */
;  GtkWidget *window;
;  GtkWidget *fixed;
;  GtkWidget *button;
;  gint i;
;
;  /* Initialise GTK */
;  gtk_init (&argc, &argv);
;    
;  /* Create a new window */
;  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
;  gtk_window_set_title (GTK_WINDOW (window), "Fixed Container");
;
;  /* Here we connect the "destroy" event to a signal handler */ 
;  g_signal_connect (G_OBJECT (window), "destroy",
;		     G_CALLBACK (gtk_main_quit), NULL);
; 
;  /* Sets the border width of the window. */
;  gtk_container_set_border_width (GTK_CONTAINER (window), 10);
;
;  /* Create a Fixed Container */
;  fixed = gtk_fixed_new ();
;  gtk_container_add (GTK_CONTAINER (window), fixed);
;  gtk_widget_show (fixed);
;  
;  for (i = 1 ; i <= 3 ; i++) {
;    /* Creates a new button with the label "Press me" */
;    button = gtk_button_new_with_label ("Press me");
;  
;    /* When the button receives the "clicked" signal, it will call the
;     * function move_button() passing it the Fixed Container as its
;     * argument. */
;    g_signal_connect (G_OBJECT (button), "clicked",
;		       G_CALLBACK (move_button), fixed);
;  
;    /* This packs the button into the fixed containers window. */
;    gtk_fixed_put (GTK_FIXED (fixed), button, i*50, i*50);
;  
;    /* The final step is to display this newly created widget. */
;    gtk_widget_show (button);
;  }
;
;  /* Display the window */
;  gtk_widget_show (window);
;    
;  /* Enter the event loop */
;  gtk_main ();
;    
;  return 0;
;}

(defpackage "10.03-fixed" (:use :excl :common-lisp))
(in-package "10.03-fixed")

(defparameter x 50)
(defparameter y 50)

(ff:defun-foreign-callable move-button ((widget (* gtk:GtkWidget))
					(fixed (* gtk:GtkWidget)))
  (setq x (mod (+ x 30) 300))
  (setq y (mod (+ y 50) 300))
  (gtk:gtk_fixed_move (gtk:GTK_FIXED fixed) widget x y))

(ff:defun-foreign-callable cb-gtk-main-quit ()
  (gtk:gtk-main-quit))

(defun fixed ()
  (let ((window nil)
	(fixed nil)
	(button nil))

    (gtk:gtk_init 0 0)

    (setq window (gtk:gtk_window_new gtk:GTK_WINDOW_TOPLEVEL))
    (gtk:gtk_window_set_title (gtk:GTK_WINDOW window) "Fixed Container")

    (gtk:g_signal_connect (gtk:G_OBJECT window)  "destroy" 
			  (gtk:G_CALLBACK
			   #+original (ff:get-entry-point "gtk_main_quit")
			   #-original (ff:register-foreign-callable
				       'cb-gtk-main-quit))
			  gtk:NULL)

    (gtk:gtk_container_set_border_width (gtk:GTK_CONTAINER window) 10)

    (setq fixed (gtk:gtk_fixed_new))
    (gtk:gtk_container_add (gtk:GTK_CONTAINER window) fixed)
    (gtk:gtk_widget_show fixed)

    (dotimes (i 3)
      (let ((i (1+ i)))
	(setq button (gtk:gtk_button_new_with_label "Press me"))

	(gtk:g_signal_connect (gtk:G_OBJECT button) "clicked" 
			      (gtk:G_CALLBACK
			       (ff:register-foreign-callable 'move-button))
			      fixed)

	(gtk:gtk_fixed_put (gtk:GTK_FIXED fixed) button (* i 50) (* i 50))

	(gtk:gtk_widget_show button)))

    (gtk:gtk_widget_show window)

    #+original (gtk:gtk_main)
    #-original (gtk:gtk-main)))

(flet ((run-example (name function)
	 ;; workaround for bogus (imo) redef. warnings generated by defvar
	 (declare (special gtk::*run-example*))
	 (unless (boundp 'gtk::*run-example*)
	   (setq gtk::*run-example* t))
	 (when gtk::*run-example*
	   (mp:process-run-function
	    (format nil "GTK+ Example: ~a" name)
	    function))))
  (run-example "10.03-fixed" #'fixed))
