(in-package :user)
(defparameter test-implementation nil)
(defparameter a-implementation nil)
(defparameter b-implementation nil)
(defparameter c-implementation nil)
(defparameter d-implementation nil)

(defvar test-proxy)
(defvar a-proxy)
(defvar b-proxy)
(defvar c-proxy)
(defvar d-proxy)




(defparameter repository nil)
(setq repository (orblink:idl (namestring (merge-pathnames "test.idl" *load-truename*))))
(load (merge-pathnames "test-implementation.cl" *load-truename*))

(defun test-server(&optional directory)
  (unless directory (setq directory *load-truename*))
  (corba:orb_init)
  (setq test-implementation (make-instance 'test-implementation))
  (setq
      a-implementation (make-instance 'a-implementation)
      b-implementation (make-instance 'b-implementation)
      c-implementation (make-instance 'c-implementation)
      d-implementation (make-instance 'd-implementation)
      locfor-implementation (make-instance 'locfor-implementation :id 1)
      any-implementation (make-instance 'anytest-implementation)
      )
  (orblink:write-ior-to-file test-implementation (merge-pathnames "test.ior" directory))
  (orblink:write-ior-to-file a-implementation (merge-pathnames "a.ior" directory))
  (orblink:write-ior-to-file b-implementation (merge-pathnames "b.ior" directory))
  (orblink:write-ior-to-file c-implementation (merge-pathnames "c.ior" directory))
  (orblink:write-ior-to-file d-implementation (merge-pathnames "d.ior" directory))
  (orblink:write-ior-to-file any-implementation (merge-pathnames "any.ior" directory))
  test-implementation)

(defun test-client(&optional directory &key test-tcp )
  (unless directory (setq directory *load-truename*))
  (setq test-proxy (orblink:read-ior-from-file (merge-pathnames "test.ior" directory)))
  (setq
      a-proxy (orblink:read-ior-from-file (merge-pathnames "a.ior" directory))
      b-proxy (orblink:read-ior-from-file (merge-pathnames "b.ior" directory))
      c-proxy (orblink:read-ior-from-file (merge-pathnames "c.ior" directory))
      d-proxy (orblink:read-ior-from-file (merge-pathnames "d.ior" directory))
      any-proxy (orblink:read-ior-from-file (merge-pathnames "any.ior" directory))
      )
  (list
   (op:testunsignedshort test-proxy 34)
   (op:testunsignedshort test-proxy 65535)
   (op:testshort test-proxy -344)
   (op:testenum test-proxy :hello)
   (op:testlong test-proxy 100000)
   (op:testlonglong test-proxy 20000000000000)
   (op:testunsignedlonglong test-proxy 40000000000000)
   (op:teststructexample test-proxy (idltest:structexample :foo 33 :seq '(1 2)))
   (op:teststring test-proxy "Hi there")
   (length (op:teststring test-proxy (make-string 1000 :initial-element #\a)))
   (when test-tcp
     (length (op:teststring test-proxy (make-string 10000 :initial-element #\a))))
   (when test-tcp
     (length (op:teststring test-proxy (make-string 100000 :initial-element #\a))))
   (op:testchar test-proxy #\c)
   (op:testobject test-proxy test-proxy)
   (op:testoctet test-proxy 1)
   (op:testoctet test-proxy 255)
   (op:testboolean test-proxy t)
   (op:testboolean test-proxy nil)
   (op:testsequence test-proxy '(1 3 5 7))
   (op:testsequence test-proxy #(1 3 5 7))
   (op:testsequence test-proxy nil)
   (op:testsequence test-proxy #())
   (op:testfloat test-proxy 1.3888)
   (op:testfloat test-proxy 1.3888888888d0)
   (op:testdouble test-proxy 1.3888)
   (op:testdouble test-proxy 1.3888888888888d0)
   (op:testarray2 test-proxy
		  (loop
		      with a = (make-array '(2 5))
		      for i0 below (nth 0 (array-dimensions a))
		      do (loop
			     for i1 below (nth 1 (array-dimensions a))
			     do (setf (aref a i0 i1) (format nil "[~s.~s]" i0 i1))
				)
		      finally (return a)))

   (op:testarray3 test-proxy
		  (loop
		      with a = (make-array '(2 3 4))
		      for i0 below (nth 0 (array-dimensions a))
		      do (loop
			     for i1 below (nth 1 (array-dimensions a))
			     do (loop
				    for i2 below (nth 2 (array-dimensions a))
				    do (setf (aref a i0 i1 i2) (format nil "[~s.~s.~s]" i0 i1 i2))
				       ))
		      finally (return a)))

   (op:testunionenumexample test-proxy (idltest:unionenumexample :shortmember -3))
   (op:testunionenumexample test-proxy (idltest:unionenumexample :stringmember "ho"))
   (op:testunionexample test-proxy (idltest:unionexample :union-discriminator 1 :union-value "foo"))
   (op:testunionexample test-proxy (idltest:unionexample :union-discriminator 3 :union-value :hello))
   (op:testunionexample test-proxy (idltest:unionexample :longlongmember 20000000000000))
   (op:testunionexample test-proxy (idltest:unionexample :unsignedlonglongmember 40000000000000))
   (op:testunionexample test-proxy (idltest:unionexample :enummember :hello))
   (op:testunionexample test-proxy (idltest:unionexample :booleanmember nil))
   (let ((union (idltest:unionexample :booleanmember nil)))
     (list
      (op:booleanmember union)
      (setf (op:booleanmember union) t)
      (op:booleanmember union)
      (op:union-discriminator union)
      (op:union-value union)))
   (op:testunionexample test-proxy (idltest:unionexample :union-discriminator 800 :union-value -1.3))
   (op:testvoid test-proxy 3 4)
   (op:testout1 test-proxy)
   (op:testout2 test-proxy)
   (op:testout3 test-proxy nil )
   (op:testout4 test-proxy t)
   (op:testout5 test-proxy -4.3)
   (op:testout6 test-proxy "a" "c" "d" "e" "f")
   (op:testveryvoid test-proxy)
   (setf(op:testattribute test-proxy) 5)
   (op:testattribute test-proxy)
   (op:op_for_a a-proxy "Calling a-proxy")
   (op:op_for_b b-proxy )
   (op:op_for_c c-proxy )
   (op:op_for_a d-proxy "Calling d-proxy on simple value")
   (op:op_for_a d-proxy "stop")
   (op:testany any-proxy 0)
   (op:testany any-proxy 1)
   (op:testany any-proxy 255)
   (op:testany any-proxy 256)
   (op:testany any-proxy 256)
   (op:testany any-proxy 65535)
   (op:testany any-proxy 65536)
   (op:testany any-proxy 100000000)
   (op:testany any-proxy -1)
   (op:testany any-proxy -65535)
   (op:testany any-proxy -65536)
   (op:testany any-proxy -100000000)
   (op:testany any-proxy t)
   (op:testany any-proxy nil)
   (op:testany any-proxy "string")
   (op:testany any-proxy 1.343)
   (op:testany any-proxy -34598.343)
   (op:testany any-proxy #\z)
   (op:testany any-proxy '(2 3))
   (op:testany any-proxy #(2 3))
   (op:testany any-proxy
	       (corba:any :any-typecode
			  (op:create_sequence_tc corba:orb 0 corba:tc_long)
			  :any-value '(1 -3 3)))
   (op:testany any-proxy (idltest:structexample :foo 33 :seq '(1 2)))
   (op:testany any-proxy (idltest:recursivestruct :membera "A recursive struct"
						  :memberb (list (idltest:recursivestruct :membera "inner recursive struct"
											  :memberb nil))))

  ))

(defun test-client-oneway ()
  (op:onewaytestvoid test-proxy 3))

