;; -=Begin Copyright Notice=-
;; copyright (c) 1986-2012 Franz Inc, Oakland, CA  All rights reserved.
;;
;; All rights reserved.
;;
;; Permission is granted only to any individual or institution which has
;; current Allegro CL license(s) to use, copy, or modify this software,
;; provided any reproduction or distribution of binary versions of this
;; software are compiled with a licensed Allegro CL, and provided
;; that this complete copyright and permission notice is maintained, intact,
;; in all copies and supporting documentation. 
;;
;; Franz Incorporated provides this software "as is" without
;; express or implied warranty.
;;
;; Restricted Rights Legend
;; ------------------------
;; Use, duplication, and disclosure of the software, data and information
;; contained herein by any agency, department or entity of the U.S.
;; Government are subject to restrictions of Restricted Rights for
;; Commercial Software developed at private expense as specified in FAR
;; 52.227-19 or DOD FAR Supplement 252.227-7013 (c) (1) (ii), as
;; applicable.
;; -=End Copyright Notice=-
;; Define the dialog Color-Demo
;; (This file was generated by the Interface Builder)

;;; This file contains the code for creating the dialog and
;;; its widgets.  It was automatically generated from a
;;; form window whose widgets were layed out interactively.
;;; (This was originally a .bil file in a project.)

(in-package :cg-user)
 
;; Return the window, creating it the first time or when it's closed.
;; Use only this function if you need only one instance.
(defun color-demo ()
   (find-or-make-application-window :color-demo
    'make-color-demo))
 
;; Create an instance of the window.
;; Use this if you need more than one instance.
(defun make-color-demo ()
  (let ((window-0 (make-window :color-demo
                    :class 'color-demo
                    :owner (screen *system*)
                    :title "Trivial Dialog Demo" 
                    :state :shrunk 
                    :border nil 
                    :interior (make-box-relative 400 200 265 212)
                    :left-attachment nil 
                    :top-attachment nil 
                    :right-attachment nil 
                    :bottom-attachment nil 
                    :title-bar t 
                    :resizable t 
                    :minimize-button t 
                    :scrollbars nil 
                    :widgets                     
                    (list 
                     (make-instance 'static-text 
                       :name :box 
                       :value (symbol-name 'red)
                       :left 165 :top 105 :width 94 :height 36 
                       :justification :center
                       :wrapping nil
                       :font (make-font-ex nil "Arial" 14 '(:bold))
                       :background-color 
                       (make-rgb :red 255 :green 0 :blue 0) 
                       :right-attachment :right 
                       :bottom-attachment :bottom 
                       :help-string "")
                     (make-instance 'single-item-list 
                       :name :color-list 
                       :value 'red 
                       :left 9 :top 8 :width 85 :height 133 
                       :3d-border t 
                       :bottom-attachment :bottom 
                       :help-string "" 
                       :on-change 'color-list-function 
                       :key 'capitalize-object 
                       :range '(red yellow green cyan blue magenta))
                     (make-instance 'radio-button 
                       :name :other 
                       :title "Other" 
                       :value t 
                       :left 165 :top 48 :width 69 :height 20 
                       :3d-border t 
                       :groupstart nil 
                       :help-string "" 
                       :cluster 'colors)
                     (make-instance 'radio-button 
                       :name 'blue 
                       :title "Blue" 
                       :left 165 :top 28 :width 69 :height 20 
                       :3d-border t 
                       :groupstart nil 
                       :help-string "" 
                       :on-change 'change-blue-fn 
                       :cluster 'colors)
                     (make-instance 'radio-button 
                       :name 'red 
                       :title "Red" 
                       :left 165 :top 8 :width 69 :height 20 
                       :3d-border t 
                       :groupstart nil 
                       :help-string "" 
                       :on-change 'change-red-fn 
                       :cluster 'colors)
                     (make-instance 'editable-text 
                       :name :message 
                       :value "Now there's a sexy color." 
                       :left 9 :top 147 :width 250 :height 29 
                       :3d-border t 
                       :foreground-color 
                       (make-rgb :red 128 :green 0 :blue 0) 
                       :top-attachment :bottom 
                       :right-attachment :right 
                       :bottom-attachment :bottom 
                       :help-string "")
                     (make-instance 'vertical-scroll-bar 
                       :name :color-scroller 
                       :value 0 
                       :left 104 :top 8 :width 25 :height 133
                       :delayed nil
                       :3d-border t 
                       :bottom-attachment :bottom 
                       :help-string "" 
                       :on-change 'scroll-bar-function 
                       :direction :down 
                       :page-increment 2 
                       :range '(0 5))
                     (make-instance 'button 
                       :name :go-button4 
                       :title "~Go" 
                       :left 165 :top 70 :width 94 :height 28 
                       :3d-border t 
                       :groupstart nil 
                       :right-attachment :right 
                       :help-string "" 
                       :on-change 'go-button-function)))))
    (progn
      (setf (menu window-0)
        (let ((menu-bar (open-stream 'menu-bar (screen *system*) :io)))
          (add-to-menu menu-bar 
            (make-instance 'menu-item 
              :title "~Colors" 
              :value 
              (open-menu 
               (list 
                (make-instance 'menu-item 
                  :title "~Primary" 
                  :value 
                  (open-menu 
                   (list 
                    (make-instance 'menu-item 
                      :title "~Red" 
                      :value 'red 
                      :event-synonym 
                      '(control-key #\R))
                    (make-instance 'menu-item 
                      :title "~Green" 
                      :value 'green 
                      :event-synonym 
                      '(control-key #\G))
                    (make-instance 'menu-item 
                      :title "~Blue" 
                      :value 'blue 
                      :event-synonym 
                      '(control-key #\B)))
                   'pop-up-menu (screen *system*) 
                   :selection-function 
                   'change-menu-item-color))
                (make-instance 'menu-item 
                  :title "~Secondary" 
                  :value 
                  (open-menu 
                   (list 
                    (make-instance 'menu-item 
                      :title "~Yellow" 
                      :value 'yellow 
                      :event-synonym 
                      '(control-key #\Y))
                    (make-instance 'menu-item 
                      :title "~Cyan" 
                      :value 'cyan 
                      :event-synonym 
                      '(control-key #\C))
                    (make-instance 'menu-item 
                      :title "~Magenta" 
                      :value 'magenta 
                      :event-synonym 
                      '(control-key #\M)))
                   'pop-up-menu (screen *system*) 
                   :selection-function 
                   'change-menu-item-color)))
               'pop-up-menu (screen *system*) 
               :selection-function 'null)))
          (add-to-menu menu-bar 
            (make-instance 'menu-item 
              :title "S~peed" 
              :value 
              (open-menu 
               (list 
                (make-instance 'menu-item 
                  :title "~Fast" 
                  :value :fast 
                  :checkable t
                  :event-synonym '(control-key #\J))
                (make-instance 'menu-item 
                  :title "~Medium" 
                  :value :medium 
                  :checkable t
                  :event-synonym '(control-key #\K))
                (make-instance 'menu-item 
                  :title "~Slow" 
                  :value :slow 
                  :selected t 
                  :checkable t
                  :event-synonym '(control-key #\L)))
               'pop-up-menu (screen *system*) 
               :selection-function 'change-menu-item-speed)))
          (add-to-menu menu-bar 
            (make-instance 'menu-item 
              :title "~Edit Scrollbar" 
              :value 
              (open-menu 
               (list 
                (make-instance 'menu-item 
                  :title "~Fatter" 
                  :value 5 
                  :event-synonym '(control-key #\F))
                (make-instance 'menu-item 
                  :title "~Skinnier" 
                  :value -5 
                  :event-synonym '(control-key #\S)))
               'pop-up-menu (screen *system*) 
               :selection-function 
               'change-menu-item-scrollbar)))
          menu-bar)))
    window-0))
