;; copyright (c) 2002-2012 Franz Inc, Oakland, CA - All rights reserved.
;;
;; The software, data and information contained herein are proprietary
;; to, and comprise valuable trade secrets of, Franz, Inc.  They are
;; given in confidence by Franz, Inc. pursuant to a written license
;; agreement, and may be stored and used only in accordance with the terms
;; of such license.
;;
;; Restricted Rights Legend
;; ------------------------
;; Use, duplication, and disclosure of the software, data and information
;; contained herein by any agency, department or entity of the U.S.
;; Government are subject to restrictions of Restricted Rights for
;; Commercial Software developed at private expense as specified in
;; DOD FAR Supplement 52.227-7013 (c) (1) (ii), as applicable.
;;
;; $Id: euc.cl,v 2.7 2007/04/17 21:27:38 layer Exp $

(eval-when (compile load eval)
  (provide :euc))

(in-package :excl)

;; [rfe6329]
#+process-autoloads
(autoload-from "code/ics.cl"
	       string-to-euc euc-to-string process-code)

#+removed				; rfe4801: in sys/startup.cl
(eval-when (compile load eval)
  (export '(ascii
	    codeset-0
	    codeset-1
	    codeset-2
	    codeset-3
	    euc-to-string
	    gaiji
	    half-size-kana
	    half-size-katakana
	    half-sized-kana
	    half-sized-katakana
	    kanji
	    set-8-bit-input
	    string-to-euc)))

#|
;;
;; data from ftp://ftp.unicode.org/Public/MAPPINGS/EASTASIA/JIS/JIS0208.TXT
;;
(defparameter jis-to-unicode-list
    '((#x2121 . #x3000)
      (#x2122 . #x3001)
      (#x2123 . #x3002)
      (#x2124 . #xFF0C)
      (#x2125 . #xFF0E)
      (#x2126 . #x30FB)
      (#x2127 . #xFF1A)
      (#x2128 . #xFF1B)
      (#x2129 . #xFF1F)
      (#x212A . #xFF01)
      (#x212B . #x309B)
      (#x212C . #x309C)
      (#x212D . #x00B4)
      (#x212E . #xFF40)
      (#x212F . #x00A8)
      (#x2130 . #xFF3E)
      (#x2131 . #xFFE3)
      (#x2132 . #xFF3F)
      (#x2133 . #x30FD)
      (#x2134 . #x30FE)
      (#x2135 . #x309D)
      (#x2136 . #x309E)
      (#x2137 . #x3003)
      (#x2138 . #x4EDD)
      (#x2139 . #x3005)
      (#x213A . #x3006)
      (#x213B . #x3007)
      (#x213C . #x30FC)
      (#x213D . #x2015)
      (#x213E . #x2010)
      (#x213F . #xFF0F)
      (#x2140 . #x005C)
      (#x2141 . #x301C)
      (#x2142 . #x2016)
      (#x2143 . #xFF5C)
      (#x2144 . #x2026)
      (#x2145 . #x2025)
      (#x2146 . #x2018)
      (#x2147 . #x2019)
      (#x2148 . #x201C)
      (#x2149 . #x201D)
      (#x214A . #xFF08)
      (#x214B . #xFF09)
      (#x214C . #x3014)
      (#x214D . #x3015)
      (#x214E . #xFF3B)
      (#x214F . #xFF3D)
      (#x2150 . #xFF5B)
      (#x2151 . #xFF5D)
      (#x2152 . #x3008)
      (#x2153 . #x3009)
      (#x2154 . #x300A)
      (#x2155 . #x300B)
      (#x2156 . #x300C)
      (#x2157 . #x300D)
      (#x2158 . #x300E)
      (#x2159 . #x300F)
      (#x215A . #x3010)
      (#x215B . #x3011)
      (#x215C . #xFF0B)
      (#x215D . #x2212)
      (#x215E . #x00B1)
      (#x215F . #x00D7)
      (#x2160 . #x00F7)
      (#x2161 . #xFF1D)
      (#x2162 . #x2260)
      (#x2163 . #xFF1C)
      (#x2164 . #xFF1E)
      (#x2165 . #x2266)
      (#x2166 . #x2267)
      (#x2167 . #x221E)
      (#x2168 . #x2234)
      (#x2169 . #x2642)
      (#x216A . #x2640)
      (#x216B . #x00B0)
      (#x216C . #x2032)
      (#x216D . #x2033)
      (#x216E . #x2103)
      (#x216F . #xFFE5)
      (#x2170 . #xFF04)
      (#x2171 . #x00A2)
      (#x2172 . #x00A3)
      (#x2173 . #xFF05)
      (#x2174 . #xFF03)
      (#x2175 . #xFF06)
      (#x2176 . #xFF0A)
      (#x2177 . #xFF20)
      (#x2178 . #x00A7)
      (#x2179 . #x2606)
      (#x217A . #x2605)
      (#x217B . #x25CB)
      (#x217C . #x25CF)
      (#x217D . #x25CE)
      (#x217E . #x25C7)
      (#x2221 . #x25C6)
      (#x2222 . #x25A1)
      (#x2223 . #x25A0)
      (#x2224 . #x25B3)
      (#x2225 . #x25B2)
      (#x2226 . #x25BD)
      (#x2227 . #x25BC)
      (#x2228 . #x203B)
      (#x2229 . #x3012)
      (#x222A . #x2192)
      (#x222B . #x2190)
      (#x222C . #x2191)
      (#x222D . #x2193)
      (#x222E . #x3013)
      (#x223A . #x2208)
      (#x223B . #x220B)
      (#x223C . #x2286)
      (#x223D . #x2287)
      (#x223E . #x2282)
      (#x223F . #x2283)
      (#x2240 . #x222A)
      (#x2241 . #x2229)
      (#x224A . #x2227)
      (#x224B . #x2228)
      (#x224C . #x00AC)
      (#x224D . #x21D2)
      (#x224E . #x21D4)
      (#x224F . #x2200)
      (#x2250 . #x2203)
      (#x225C . #x2220)
      (#x225D . #x22A5)
      (#x225E . #x2312)
      (#x225F . #x2202)
      (#x2260 . #x2207)
      (#x2261 . #x2261)
      (#x2262 . #x2252)
      (#x2263 . #x226A)
      (#x2264 . #x226B)
      (#x2265 . #x221A)
      (#x2266 . #x223D)
      (#x2267 . #x221D)
      (#x2268 . #x2235)
      (#x2269 . #x222B)
      (#x226A . #x222C)
      (#x2272 . #x212B)
      (#x2273 . #x2030)
      (#x2274 . #x266F)
      (#x2275 . #x266D)
      (#x2276 . #x266A)
      (#x2277 . #x2020)
      (#x2278 . #x2021)
      (#x2279 . #x00B6)
      (#x227E . #x25EF)
      (#x2330 . #xFF10)
      (#x2331 . #xFF11)
      (#x2332 . #xFF12)
      (#x2333 . #xFF13)
      (#x2334 . #xFF14)
      (#x2335 . #xFF15)
      (#x2336 . #xFF16)
      (#x2337 . #xFF17)
      (#x2338 . #xFF18)
      (#x2339 . #xFF19)
      (#x2341 . #xFF21)
      (#x2342 . #xFF22)
      (#x2343 . #xFF23)
      (#x2344 . #xFF24)
      (#x2345 . #xFF25)
      (#x2346 . #xFF26)
      (#x2347 . #xFF27)
      (#x2348 . #xFF28)
      (#x2349 . #xFF29)
      (#x234A . #xFF2A)
      (#x234B . #xFF2B)
      (#x234C . #xFF2C)
      (#x234D . #xFF2D)
      (#x234E . #xFF2E)
      (#x234F . #xFF2F)
      (#x2350 . #xFF30)
      (#x2351 . #xFF31)
      (#x2352 . #xFF32)
      (#x2353 . #xFF33)
      (#x2354 . #xFF34)
      (#x2355 . #xFF35)
      (#x2356 . #xFF36)
      (#x2357 . #xFF37)
      (#x2358 . #xFF38)
      (#x2359 . #xFF39)
      (#x235A . #xFF3A)
      (#x2361 . #xFF41)
      (#x2362 . #xFF42)
      (#x2363 . #xFF43)
      (#x2364 . #xFF44)
      (#x2365 . #xFF45)
      (#x2366 . #xFF46)
      (#x2367 . #xFF47)
      (#x2368 . #xFF48)
      (#x2369 . #xFF49)
      (#x236A . #xFF4A)
      (#x236B . #xFF4B)
      (#x236C . #xFF4C)
      (#x236D . #xFF4D)
      (#x236E . #xFF4E)
      (#x236F . #xFF4F)
      (#x2370 . #xFF50)
      (#x2371 . #xFF51)
      (#x2372 . #xFF52)
      (#x2373 . #xFF53)
      (#x2374 . #xFF54)
      (#x2375 . #xFF55)
      (#x2376 . #xFF56)
      (#x2377 . #xFF57)
      (#x2378 . #xFF58)
      (#x2379 . #xFF59)
      (#x237A . #xFF5A)
      (#x2421 . #x3041)
      (#x2422 . #x3042)
      (#x2423 . #x3043)
      (#x2424 . #x3044)
      (#x2425 . #x3045)
      (#x2426 . #x3046)
      (#x2427 . #x3047)
      (#x2428 . #x3048)
      (#x2429 . #x3049)
      (#x242A . #x304A)
      (#x242B . #x304B)
      (#x242C . #x304C)
      (#x242D . #x304D)
      (#x242E . #x304E)
      (#x242F . #x304F)
      (#x2430 . #x3050)
      (#x2431 . #x3051)
      (#x2432 . #x3052)
      (#x2433 . #x3053)
      (#x2434 . #x3054)
      (#x2435 . #x3055)
      (#x2436 . #x3056)
      (#x2437 . #x3057)
      (#x2438 . #x3058)
      (#x2439 . #x3059)
      (#x243A . #x305A)
      (#x243B . #x305B)
      (#x243C . #x305C)
      (#x243D . #x305D)
      (#x243E . #x305E)
      (#x243F . #x305F)
      (#x2440 . #x3060)
      (#x2441 . #x3061)
      (#x2442 . #x3062)
      (#x2443 . #x3063)
      (#x2444 . #x3064)
      (#x2445 . #x3065)
      (#x2446 . #x3066)
      (#x2447 . #x3067)
      (#x2448 . #x3068)
      (#x2449 . #x3069)
      (#x244A . #x306A)
      (#x244B . #x306B)
      (#x244C . #x306C)
      (#x244D . #x306D)
      (#x244E . #x306E)
      (#x244F . #x306F)
      (#x2450 . #x3070)
      (#x2451 . #x3071)
      (#x2452 . #x3072)
      (#x2453 . #x3073)
      (#x2454 . #x3074)
      (#x2455 . #x3075)
      (#x2456 . #x3076)
      (#x2457 . #x3077)
      (#x2458 . #x3078)
      (#x2459 . #x3079)
      (#x245A . #x307A)
      (#x245B . #x307B)
      (#x245C . #x307C)
      (#x245D . #x307D)
      (#x245E . #x307E)
      (#x245F . #x307F)
      (#x2460 . #x3080)
      (#x2461 . #x3081)
      (#x2462 . #x3082)
      (#x2463 . #x3083)
      (#x2464 . #x3084)
      (#x2465 . #x3085)
      (#x2466 . #x3086)
      (#x2467 . #x3087)
      (#x2468 . #x3088)
      (#x2469 . #x3089)
      (#x246A . #x308A)
      (#x246B . #x308B)
      (#x246C . #x308C)
      (#x246D . #x308D)
      (#x246E . #x308E)
      (#x246F . #x308F)
      (#x2470 . #x3090)
      (#x2471 . #x3091)
      (#x2472 . #x3092)
      (#x2473 . #x3093)
      (#x2521 . #x30A1)
      (#x2522 . #x30A2)
      (#x2523 . #x30A3)
      (#x2524 . #x30A4)
      (#x2525 . #x30A5)
      (#x2526 . #x30A6)
      (#x2527 . #x30A7)
      (#x2528 . #x30A8)
      (#x2529 . #x30A9)
      (#x252A . #x30AA)
      (#x252B . #x30AB)
      (#x252C . #x30AC)
      (#x252D . #x30AD)
      (#x252E . #x30AE)
      (#x252F . #x30AF)
      (#x2530 . #x30B0)
      (#x2531 . #x30B1)
      (#x2532 . #x30B2)
      (#x2533 . #x30B3)
      (#x2534 . #x30B4)
      (#x2535 . #x30B5)
      (#x2536 . #x30B6)
      (#x2537 . #x30B7)
      (#x2538 . #x30B8)
      (#x2539 . #x30B9)
      (#x253A . #x30BA)
      (#x253B . #x30BB)
      (#x253C . #x30BC)
      (#x253D . #x30BD)
      (#x253E . #x30BE)
      (#x253F . #x30BF)
      (#x2540 . #x30C0)
      (#x2541 . #x30C1)
      (#x2542 . #x30C2)
      (#x2543 . #x30C3)
      (#x2544 . #x30C4)
      (#x2545 . #x30C5)
      (#x2546 . #x30C6)
      (#x2547 . #x30C7)
      (#x2548 . #x30C8)
      (#x2549 . #x30C9)
      (#x254A . #x30CA)
      (#x254B . #x30CB)
      (#x254C . #x30CC)
      (#x254D . #x30CD)
      (#x254E . #x30CE)
      (#x254F . #x30CF)
      (#x2550 . #x30D0)
      (#x2551 . #x30D1)
      (#x2552 . #x30D2)
      (#x2553 . #x30D3)
      (#x2554 . #x30D4)
      (#x2555 . #x30D5)
      (#x2556 . #x30D6)
      (#x2557 . #x30D7)
      (#x2558 . #x30D8)
      (#x2559 . #x30D9)
      (#x255A . #x30DA)
      (#x255B . #x30DB)
      (#x255C . #x30DC)
      (#x255D . #x30DD)
      (#x255E . #x30DE)
      (#x255F . #x30DF)
      (#x2560 . #x30E0)
      (#x2561 . #x30E1)
      (#x2562 . #x30E2)
      (#x2563 . #x30E3)
      (#x2564 . #x30E4)
      (#x2565 . #x30E5)
      (#x2566 . #x30E6)
      (#x2567 . #x30E7)
      (#x2568 . #x30E8)
      (#x2569 . #x30E9)
      (#x256A . #x30EA)
      (#x256B . #x30EB)
      (#x256C . #x30EC)
      (#x256D . #x30ED)
      (#x256E . #x30EE)
      (#x256F . #x30EF)
      (#x2570 . #x30F0)
      (#x2571 . #x30F1)
      (#x2572 . #x30F2)
      (#x2573 . #x30F3)
      (#x2574 . #x30F4)
      (#x2575 . #x30F5)
      (#x2576 . #x30F6)
      (#x2621 . #x0391)
      (#x2622 . #x0392)
      (#x2623 . #x0393)
      (#x2624 . #x0394)
      (#x2625 . #x0395)
      (#x2626 . #x0396)
      (#x2627 . #x0397)
      (#x2628 . #x0398)
      (#x2629 . #x0399)
      (#x262A . #x039A)
      (#x262B . #x039B)
      (#x262C . #x039C)
      (#x262D . #x039D)
      (#x262E . #x039E)
      (#x262F . #x039F)
      (#x2630 . #x03A0)
      (#x2631 . #x03A1)
      (#x2632 . #x03A3)
      (#x2633 . #x03A4)
      (#x2634 . #x03A5)
      (#x2635 . #x03A6)
      (#x2636 . #x03A7)
      (#x2637 . #x03A8)
      (#x2638 . #x03A9)
      (#x2641 . #x03B1)
      (#x2642 . #x03B2)
      (#x2643 . #x03B3)
      (#x2644 . #x03B4)
      (#x2645 . #x03B5)
      (#x2646 . #x03B6)
      (#x2647 . #x03B7)
      (#x2648 . #x03B8)
      (#x2649 . #x03B9)
      (#x264A . #x03BA)
      (#x264B . #x03BB)
      (#x264C . #x03BC)
      (#x264D . #x03BD)
      (#x264E . #x03BE)
      (#x264F . #x03BF)
      (#x2650 . #x03C0)
      (#x2651 . #x03C1)
      (#x2652 . #x03C3)
      (#x2653 . #x03C4)
      (#x2654 . #x03C5)
      (#x2655 . #x03C6)
      (#x2656 . #x03C7)
      (#x2657 . #x03C8)
      (#x2658 . #x03C9)
      (#x2721 . #x0410)
      (#x2722 . #x0411)
      (#x2723 . #x0412)
      (#x2724 . #x0413)
      (#x2725 . #x0414)
      (#x2726 . #x0415)
      (#x2727 . #x0401)
      (#x2728 . #x0416)
      (#x2729 . #x0417)
      (#x272A . #x0418)
      (#x272B . #x0419)
      (#x272C . #x041A)
      (#x272D . #x041B)
      (#x272E . #x041C)
      (#x272F . #x041D)
      (#x2730 . #x041E)
      (#x2731 . #x041F)
      (#x2732 . #x0420)
      (#x2733 . #x0421)
      (#x2734 . #x0422)
      (#x2735 . #x0423)
      (#x2736 . #x0424)
      (#x2737 . #x0425)
      (#x2738 . #x0426)
      (#x2739 . #x0427)
      (#x273A . #x0428)
      (#x273B . #x0429)
      (#x273C . #x042A)
      (#x273D . #x042B)
      (#x273E . #x042C)
      (#x273F . #x042D)
      (#x2740 . #x042E)
      (#x2741 . #x042F)
      (#x2751 . #x0430)
      (#x2752 . #x0431)
      (#x2753 . #x0432)
      (#x2754 . #x0433)
      (#x2755 . #x0434)
      (#x2756 . #x0435)
      (#x2757 . #x0451)
      (#x2758 . #x0436)
      (#x2759 . #x0437)
      (#x275A . #x0438)
      (#x275B . #x0439)
      (#x275C . #x043A)
      (#x275D . #x043B)
      (#x275E . #x043C)
      (#x275F . #x043D)
      (#x2760 . #x043E)
      (#x2761 . #x043F)
      (#x2762 . #x0440)
      (#x2763 . #x0441)
      (#x2764 . #x0442)
      (#x2765 . #x0443)
      (#x2766 . #x0444)
      (#x2767 . #x0445)
      (#x2768 . #x0446)
      (#x2769 . #x0447)
      (#x276A . #x0448)
      (#x276B . #x0449)
      (#x276C . #x044A)
      (#x276D . #x044B)
      (#x276E . #x044C)
      (#x276F . #x044D)
      (#x2770 . #x044E)
      (#x2771 . #x044F)
      (#x2821 . #x2500)
      (#x2822 . #x2502)
      (#x2823 . #x250C)
      (#x2824 . #x2510)
      (#x2825 . #x2518)
      (#x2826 . #x2514)
      (#x2827 . #x251C)
      (#x2828 . #x252C)
      (#x2829 . #x2524)
      (#x282A . #x2534)
      (#x282B . #x253C)
      (#x282C . #x2501)
      (#x282D . #x2503)
      (#x282E . #x250F)
      (#x282F . #x2513)
      (#x2830 . #x251B)
      (#x2831 . #x2517)
      (#x2832 . #x2523)
      (#x2833 . #x2533)
      (#x2834 . #x252B)
      (#x2835 . #x253B)
      (#x2836 . #x254B)
      (#x2837 . #x2520)
      (#x2838 . #x252F)
      (#x2839 . #x2528)
      (#x283A . #x2537)
      (#x283B . #x253F)
      (#x283C . #x251D)
      (#x283D . #x2530)
      (#x283E . #x2525)
      (#x283F . #x2538)
      (#x2840 . #x2542)
      (#x3021 . #x4E9C)
      (#x3022 . #x5516)
      (#x3023 . #x5A03)
      (#x3024 . #x963F)
      (#x3025 . #x54C0)
      (#x3026 . #x611B)
      (#x3027 . #x6328)
      (#x3028 . #x59F6)
      (#x3029 . #x9022)
      (#x302A . #x8475)
      (#x302B . #x831C)
      (#x302C . #x7A50)
      (#x302D . #x60AA)
      (#x302E . #x63E1)
      (#x302F . #x6E25)
      (#x3030 . #x65ED)
      (#x3031 . #x8466)
      (#x3032 . #x82A6)
      (#x3033 . #x9BF5)
      (#x3034 . #x6893)
      (#x3035 . #x5727)
      (#x3036 . #x65A1)
      (#x3037 . #x6271)
      (#x3038 . #x5B9B)
      (#x3039 . #x59D0)
      (#x303A . #x867B)
      (#x303B . #x98F4)
      (#x303C . #x7D62)
      (#x303D . #x7DBE)
      (#x303E . #x9B8E)
      (#x303F . #x6216)
      (#x3040 . #x7C9F)
      (#x3041 . #x88B7)
      (#x3042 . #x5B89)
      (#x3043 . #x5EB5)
      (#x3044 . #x6309)
      (#x3045 . #x6697)
      (#x3046 . #x6848)
      (#x3047 . #x95C7)
      (#x3048 . #x978D)
      (#x3049 . #x674F)
      (#x304A . #x4EE5)
      (#x304B . #x4F0A)
      (#x304C . #x4F4D)
      (#x304D . #x4F9D)
      (#x304E . #x5049)
      (#x304F . #x56F2)
      (#x3050 . #x5937)
      (#x3051 . #x59D4)
      (#x3052 . #x5A01)
      (#x3053 . #x5C09)
      (#x3054 . #x60DF)
      (#x3055 . #x610F)
      (#x3056 . #x6170)
      (#x3057 . #x6613)
      (#x3058 . #x6905)
      (#x3059 . #x70BA)
      (#x305A . #x754F)
      (#x305B . #x7570)
      (#x305C . #x79FB)
      (#x305D . #x7DAD)
      (#x305E . #x7DEF)
      (#x305F . #x80C3)
      (#x3060 . #x840E)
      (#x3061 . #x8863)
      (#x3062 . #x8B02)
      (#x3063 . #x9055)
      (#x3064 . #x907A)
      (#x3065 . #x533B)
      (#x3066 . #x4E95)
      (#x3067 . #x4EA5)
      (#x3068 . #x57DF)
      (#x3069 . #x80B2)
      (#x306A . #x90C1)
      (#x306B . #x78EF)
      (#x306C . #x4E00)
      (#x306D . #x58F1)
      (#x306E . #x6EA2)
      (#x306F . #x9038)
      (#x3070 . #x7A32)
      (#x3071 . #x8328)
      (#x3072 . #x828B)
      (#x3073 . #x9C2F)
      (#x3074 . #x5141)
      (#x3075 . #x5370)
      (#x3076 . #x54BD)
      (#x3077 . #x54E1)
      (#x3078 . #x56E0)
      (#x3079 . #x59FB)
      (#x307A . #x5F15)
      (#x307B . #x98F2)
      (#x307C . #x6DEB)
      (#x307D . #x80E4)
      (#x307E . #x852D)
      (#x3121 . #x9662)
      (#x3122 . #x9670)
      (#x3123 . #x96A0)
      (#x3124 . #x97FB)
      (#x3125 . #x540B)
      (#x3126 . #x53F3)
      (#x3127 . #x5B87)
      (#x3128 . #x70CF)
      (#x3129 . #x7FBD)
      (#x312A . #x8FC2)
      (#x312B . #x96E8)
      (#x312C . #x536F)
      (#x312D . #x9D5C)
      (#x312E . #x7ABA)
      (#x312F . #x4E11)
      (#x3130 . #x7893)
      (#x3131 . #x81FC)
      (#x3132 . #x6E26)
      (#x3133 . #x5618)
      (#x3134 . #x5504)
      (#x3135 . #x6B1D)
      (#x3136 . #x851A)
      (#x3137 . #x9C3B)
      (#x3138 . #x59E5)
      (#x3139 . #x53A9)
      (#x313A . #x6D66)
      (#x313B . #x74DC)
      (#x313C . #x958F)
      (#x313D . #x5642)
      (#x313E . #x4E91)
      (#x313F . #x904B)
      (#x3140 . #x96F2)
      (#x3141 . #x834F)
      (#x3142 . #x990C)
      (#x3143 . #x53E1)
      (#x3144 . #x55B6)
      (#x3145 . #x5B30)
      (#x3146 . #x5F71)
      (#x3147 . #x6620)
      (#x3148 . #x66F3)
      (#x3149 . #x6804)
      (#x314A . #x6C38)
      (#x314B . #x6CF3)
      (#x314C . #x6D29)
      (#x314D . #x745B)
      (#x314E . #x76C8)
      (#x314F . #x7A4E)
      (#x3150 . #x9834)
      (#x3151 . #x82F1)
      (#x3152 . #x885B)
      (#x3153 . #x8A60)
      (#x3154 . #x92ED)
      (#x3155 . #x6DB2)
      (#x3156 . #x75AB)
      (#x3157 . #x76CA)
      (#x3158 . #x99C5)
      (#x3159 . #x60A6)
      (#x315A . #x8B01)
      (#x315B . #x8D8A)
      (#x315C . #x95B2)
      (#x315D . #x698E)
      (#x315E . #x53AD)
      (#x315F . #x5186)
      (#x3160 . #x5712)
      (#x3161 . #x5830)
      (#x3162 . #x5944)
      (#x3163 . #x5BB4)
      (#x3164 . #x5EF6)
      (#x3165 . #x6028)
      (#x3166 . #x63A9)
      (#x3167 . #x63F4)
      (#x3168 . #x6CBF)
      (#x3169 . #x6F14)
      (#x316A . #x708E)
      (#x316B . #x7114)
      (#x316C . #x7159)
      (#x316D . #x71D5)
      (#x316E . #x733F)
      (#x316F . #x7E01)
      (#x3170 . #x8276)
      (#x3171 . #x82D1)
      (#x3172 . #x8597)
      (#x3173 . #x9060)
      (#x3174 . #x925B)
      (#x3175 . #x9D1B)
      (#x3176 . #x5869)
      (#x3177 . #x65BC)
      (#x3178 . #x6C5A)
      (#x3179 . #x7525)
      (#x317A . #x51F9)
      (#x317B . #x592E)
      (#x317C . #x5965)
      (#x317D . #x5F80)
      (#x317E . #x5FDC)
      (#x3221 . #x62BC)
      (#x3222 . #x65FA)
      (#x3223 . #x6A2A)
      (#x3224 . #x6B27)
      (#x3225 . #x6BB4)
      (#x3226 . #x738B)
      (#x3227 . #x7FC1)
      (#x3228 . #x8956)
      (#x3229 . #x9D2C)
      (#x322A . #x9D0E)
      (#x322B . #x9EC4)
      (#x322C . #x5CA1)
      (#x322D . #x6C96)
      (#x322E . #x837B)
      (#x322F . #x5104)
      (#x3230 . #x5C4B)
      (#x3231 . #x61B6)
      (#x3232 . #x81C6)
      (#x3233 . #x6876)
      (#x3234 . #x7261)
      (#x3235 . #x4E59)
      (#x3236 . #x4FFA)
      (#x3237 . #x5378)
      (#x3238 . #x6069)
      (#x3239 . #x6E29)
      (#x323A . #x7A4F)
      (#x323B . #x97F3)
      (#x323C . #x4E0B)
      (#x323D . #x5316)
      (#x323E . #x4EEE)
      (#x323F . #x4F55)
      (#x3240 . #x4F3D)
      (#x3241 . #x4FA1)
      (#x3242 . #x4F73)
      (#x3243 . #x52A0)
      (#x3244 . #x53EF)
      (#x3245 . #x5609)
      (#x3246 . #x590F)
      (#x3247 . #x5AC1)
      (#x3248 . #x5BB6)
      (#x3249 . #x5BE1)
      (#x324A . #x79D1)
      (#x324B . #x6687)
      (#x324C . #x679C)
      (#x324D . #x67B6)
      (#x324E . #x6B4C)
      (#x324F . #x6CB3)
      (#x3250 . #x706B)
      (#x3251 . #x73C2)
      (#x3252 . #x798D)
      (#x3253 . #x79BE)
      (#x3254 . #x7A3C)
      (#x3255 . #x7B87)
      (#x3256 . #x82B1)
      (#x3257 . #x82DB)
      (#x3258 . #x8304)
      (#x3259 . #x8377)
      (#x325A . #x83EF)
      (#x325B . #x83D3)
      (#x325C . #x8766)
      (#x325D . #x8AB2)
      (#x325E . #x5629)
      (#x325F . #x8CA8)
      (#x3260 . #x8FE6)
      (#x3261 . #x904E)
      (#x3262 . #x971E)
      (#x3263 . #x868A)
      (#x3264 . #x4FC4)
      (#x3265 . #x5CE8)
      (#x3266 . #x6211)
      (#x3267 . #x7259)
      (#x3268 . #x753B)
      (#x3269 . #x81E5)
      (#x326A . #x82BD)
      (#x326B . #x86FE)
      (#x326C . #x8CC0)
      (#x326D . #x96C5)
      (#x326E . #x9913)
      (#x326F . #x99D5)
      (#x3270 . #x4ECB)
      (#x3271 . #x4F1A)
      (#x3272 . #x89E3)
      (#x3273 . #x56DE)
      (#x3274 . #x584A)
      (#x3275 . #x58CA)
      (#x3276 . #x5EFB)
      (#x3277 . #x5FEB)
      (#x3278 . #x602A)
      (#x3279 . #x6094)
      (#x327A . #x6062)
      (#x327B . #x61D0)
      (#x327C . #x6212)
      (#x327D . #x62D0)
      (#x327E . #x6539)
      (#x3321 . #x9B41)
      (#x3322 . #x6666)
      (#x3323 . #x68B0)
      (#x3324 . #x6D77)
      (#x3325 . #x7070)
      (#x3326 . #x754C)
      (#x3327 . #x7686)
      (#x3328 . #x7D75)
      (#x3329 . #x82A5)
      (#x332A . #x87F9)
      (#x332B . #x958B)
      (#x332C . #x968E)
      (#x332D . #x8C9D)
      (#x332E . #x51F1)
      (#x332F . #x52BE)
      (#x3330 . #x5916)
      (#x3331 . #x54B3)
      (#x3332 . #x5BB3)
      (#x3333 . #x5D16)
      (#x3334 . #x6168)
      (#x3335 . #x6982)
      (#x3336 . #x6DAF)
      (#x3337 . #x788D)
      (#x3338 . #x84CB)
      (#x3339 . #x8857)
      (#x333A . #x8A72)
      (#x333B . #x93A7)
      (#x333C . #x9AB8)
      (#x333D . #x6D6C)
      (#x333E . #x99A8)
      (#x333F . #x86D9)
      (#x3340 . #x57A3)
      (#x3341 . #x67FF)
      (#x3342 . #x86CE)
      (#x3343 . #x920E)
      (#x3344 . #x5283)
      (#x3345 . #x5687)
      (#x3346 . #x5404)
      (#x3347 . #x5ED3)
      (#x3348 . #x62E1)
      (#x3349 . #x64B9)
      (#x334A . #x683C)
      (#x334B . #x6838)
      (#x334C . #x6BBB)
      (#x334D . #x7372)
      (#x334E . #x78BA)
      (#x334F . #x7A6B)
      (#x3350 . #x899A)
      (#x3351 . #x89D2)
      (#x3352 . #x8D6B)
      (#x3353 . #x8F03)
      (#x3354 . #x90ED)
      (#x3355 . #x95A3)
      (#x3356 . #x9694)
      (#x3357 . #x9769)
      (#x3358 . #x5B66)
      (#x3359 . #x5CB3)
      (#x335A . #x697D)
      (#x335B . #x984D)
      (#x335C . #x984E)
      (#x335D . #x639B)
      (#x335E . #x7B20)
      (#x335F . #x6A2B)
      (#x3360 . #x6A7F)
      (#x3361 . #x68B6)
      (#x3362 . #x9C0D)
      (#x3363 . #x6F5F)
      (#x3364 . #x5272)
      (#x3365 . #x559D)
      (#x3366 . #x6070)
      (#x3367 . #x62EC)
      (#x3368 . #x6D3B)
      (#x3369 . #x6E07)
      (#x336A . #x6ED1)
      (#x336B . #x845B)
      (#x336C . #x8910)
      (#x336D . #x8F44)
      (#x336E . #x4E14)
      (#x336F . #x9C39)
      (#x3370 . #x53F6)
      (#x3371 . #x691B)
      (#x3372 . #x6A3A)
      (#x3373 . #x9784)
      (#x3374 . #x682A)
      (#x3375 . #x515C)
      (#x3376 . #x7AC3)
      (#x3377 . #x84B2)
      (#x3378 . #x91DC)
      (#x3379 . #x938C)
      (#x337A . #x565B)
      (#x337B . #x9D28)
      (#x337C . #x6822)
      (#x337D . #x8305)
      (#x337E . #x8431)
      (#x3421 . #x7CA5)
      (#x3422 . #x5208)
      (#x3423 . #x82C5)
      (#x3424 . #x74E6)
      (#x3425 . #x4E7E)
      (#x3426 . #x4F83)
      (#x3427 . #x51A0)
      (#x3428 . #x5BD2)
      (#x3429 . #x520A)
      (#x342A . #x52D8)
      (#x342B . #x52E7)
      (#x342C . #x5DFB)
      (#x342D . #x559A)
      (#x342E . #x582A)
      (#x342F . #x59E6)
      (#x3430 . #x5B8C)
      (#x3431 . #x5B98)
      (#x3432 . #x5BDB)
      (#x3433 . #x5E72)
      (#x3434 . #x5E79)
      (#x3435 . #x60A3)
      (#x3436 . #x611F)
      (#x3437 . #x6163)
      (#x3438 . #x61BE)
      (#x3439 . #x63DB)
      (#x343A . #x6562)
      (#x343B . #x67D1)
      (#x343C . #x6853)
      (#x343D . #x68FA)
      (#x343E . #x6B3E)
      (#x343F . #x6B53)
      (#x3440 . #x6C57)
      (#x3441 . #x6F22)
      (#x3442 . #x6F97)
      (#x3443 . #x6F45)
      (#x3444 . #x74B0)
      (#x3445 . #x7518)
      (#x3446 . #x76E3)
      (#x3447 . #x770B)
      (#x3448 . #x7AFF)
      (#x3449 . #x7BA1)
      (#x344A . #x7C21)
      (#x344B . #x7DE9)
      (#x344C . #x7F36)
      (#x344D . #x7FF0)
      (#x344E . #x809D)
      (#x344F . #x8266)
      (#x3450 . #x839E)
      (#x3451 . #x89B3)
      (#x3452 . #x8ACC)
      (#x3453 . #x8CAB)
      (#x3454 . #x9084)
      (#x3455 . #x9451)
      (#x3456 . #x9593)
      (#x3457 . #x9591)
      (#x3458 . #x95A2)
      (#x3459 . #x9665)
      (#x345A . #x97D3)
      (#x345B . #x9928)
      (#x345C . #x8218)
      (#x345D . #x4E38)
      (#x345E . #x542B)
      (#x345F . #x5CB8)
      (#x3460 . #x5DCC)
      (#x3461 . #x73A9)
      (#x3462 . #x764C)
      (#x3463 . #x773C)
      (#x3464 . #x5CA9)
      (#x3465 . #x7FEB)
      (#x3466 . #x8D0B)
      (#x3467 . #x96C1)
      (#x3468 . #x9811)
      (#x3469 . #x9854)
      (#x346A . #x9858)
      (#x346B . #x4F01)
      (#x346C . #x4F0E)
      (#x346D . #x5371)
      (#x346E . #x559C)
      (#x346F . #x5668)
      (#x3470 . #x57FA)
      (#x3471 . #x5947)
      (#x3472 . #x5B09)
      (#x3473 . #x5BC4)
      (#x3474 . #x5C90)
      (#x3475 . #x5E0C)
      (#x3476 . #x5E7E)
      (#x3477 . #x5FCC)
      (#x3478 . #x63EE)
      (#x3479 . #x673A)
      (#x347A . #x65D7)
      (#x347B . #x65E2)
      (#x347C . #x671F)
      (#x347D . #x68CB)
      (#x347E . #x68C4)
      (#x3521 . #x6A5F)
      (#x3522 . #x5E30)
      (#x3523 . #x6BC5)
      (#x3524 . #x6C17)
      (#x3525 . #x6C7D)
      (#x3526 . #x757F)
      (#x3527 . #x7948)
      (#x3528 . #x5B63)
      (#x3529 . #x7A00)
      (#x352A . #x7D00)
      (#x352B . #x5FBD)
      (#x352C . #x898F)
      (#x352D . #x8A18)
      (#x352E . #x8CB4)
      (#x352F . #x8D77)
      (#x3530 . #x8ECC)
      (#x3531 . #x8F1D)
      (#x3532 . #x98E2)
      (#x3533 . #x9A0E)
      (#x3534 . #x9B3C)
      (#x3535 . #x4E80)
      (#x3536 . #x507D)
      (#x3537 . #x5100)
      (#x3538 . #x5993)
      (#x3539 . #x5B9C)
      (#x353A . #x622F)
      (#x353B . #x6280)
      (#x353C . #x64EC)
      (#x353D . #x6B3A)
      (#x353E . #x72A0)
      (#x353F . #x7591)
      (#x3540 . #x7947)
      (#x3541 . #x7FA9)
      (#x3542 . #x87FB)
      (#x3543 . #x8ABC)
      (#x3544 . #x8B70)
      (#x3545 . #x63AC)
      (#x3546 . #x83CA)
      (#x3547 . #x97A0)
      (#x3548 . #x5409)
      (#x3549 . #x5403)
      (#x354A . #x55AB)
      (#x354B . #x6854)
      (#x354C . #x6A58)
      (#x354D . #x8A70)
      (#x354E . #x7827)
      (#x354F . #x6775)
      (#x3550 . #x9ECD)
      (#x3551 . #x5374)
      (#x3552 . #x5BA2)
      (#x3553 . #x811A)
      (#x3554 . #x8650)
      (#x3555 . #x9006)
      (#x3556 . #x4E18)
      (#x3557 . #x4E45)
      (#x3558 . #x4EC7)
      (#x3559 . #x4F11)
      (#x355A . #x53CA)
      (#x355B . #x5438)
      (#x355C . #x5BAE)
      (#x355D . #x5F13)
      (#x355E . #x6025)
      (#x355F . #x6551)
      (#x3560 . #x673D)
      (#x3561 . #x6C42)
      (#x3562 . #x6C72)
      (#x3563 . #x6CE3)
      (#x3564 . #x7078)
      (#x3565 . #x7403)
      (#x3566 . #x7A76)
      (#x3567 . #x7AAE)
      (#x3568 . #x7B08)
      (#x3569 . #x7D1A)
      (#x356A . #x7CFE)
      (#x356B . #x7D66)
      (#x356C . #x65E7)
      (#x356D . #x725B)
      (#x356E . #x53BB)
      (#x356F . #x5C45)
      (#x3570 . #x5DE8)
      (#x3571 . #x62D2)
      (#x3572 . #x62E0)
      (#x3573 . #x6319)
      (#x3574 . #x6E20)
      (#x3575 . #x865A)
      (#x3576 . #x8A31)
      (#x3577 . #x8DDD)
      (#x3578 . #x92F8)
      (#x3579 . #x6F01)
      (#x357A . #x79A6)
      (#x357B . #x9B5A)
      (#x357C . #x4EA8)
      (#x357D . #x4EAB)
      (#x357E . #x4EAC)
      (#x3621 . #x4F9B)
      (#x3622 . #x4FA0)
      (#x3623 . #x50D1)
      (#x3624 . #x5147)
      (#x3625 . #x7AF6)
      (#x3626 . #x5171)
      (#x3627 . #x51F6)
      (#x3628 . #x5354)
      (#x3629 . #x5321)
      (#x362A . #x537F)
      (#x362B . #x53EB)
      (#x362C . #x55AC)
      (#x362D . #x5883)
      (#x362E . #x5CE1)
      (#x362F . #x5F37)
      (#x3630 . #x5F4A)
      (#x3631 . #x602F)
      (#x3632 . #x6050)
      (#x3633 . #x606D)
      (#x3634 . #x631F)
      (#x3635 . #x6559)
      (#x3636 . #x6A4B)
      (#x3637 . #x6CC1)
      (#x3638 . #x72C2)
      (#x3639 . #x72ED)
      (#x363A . #x77EF)
      (#x363B . #x80F8)
      (#x363C . #x8105)
      (#x363D . #x8208)
      (#x363E . #x854E)
      (#x363F . #x90F7)
      (#x3640 . #x93E1)
      (#x3641 . #x97FF)
      (#x3642 . #x9957)
      (#x3643 . #x9A5A)
      (#x3644 . #x4EF0)
      (#x3645 . #x51DD)
      (#x3646 . #x5C2D)
      (#x3647 . #x6681)
      (#x3648 . #x696D)
      (#x3649 . #x5C40)
      (#x364A . #x66F2)
      (#x364B . #x6975)
      (#x364C . #x7389)
      (#x364D . #x6850)
      (#x364E . #x7C81)
      (#x364F . #x50C5)
      (#x3650 . #x52E4)
      (#x3651 . #x5747)
      (#x3652 . #x5DFE)
      (#x3653 . #x9326)
      (#x3654 . #x65A4)
      (#x3655 . #x6B23)
      (#x3656 . #x6B3D)
      (#x3657 . #x7434)
      (#x3658 . #x7981)
      (#x3659 . #x79BD)
      (#x365A . #x7B4B)
      (#x365B . #x7DCA)
      (#x365C . #x82B9)
      (#x365D . #x83CC)
      (#x365E . #x887F)
      (#x365F . #x895F)
      (#x3660 . #x8B39)
      (#x3661 . #x8FD1)
      (#x3662 . #x91D1)
      (#x3663 . #x541F)
      (#x3664 . #x9280)
      (#x3665 . #x4E5D)
      (#x3666 . #x5036)
      (#x3667 . #x53E5)
      (#x3668 . #x533A)
      (#x3669 . #x72D7)
      (#x366A . #x7396)
      (#x366B . #x77E9)
      (#x366C . #x82E6)
      (#x366D . #x8EAF)
      (#x366E . #x99C6)
      (#x366F . #x99C8)
      (#x3670 . #x99D2)
      (#x3671 . #x5177)
      (#x3672 . #x611A)
      (#x3673 . #x865E)
      (#x3674 . #x55B0)
      (#x3675 . #x7A7A)
      (#x3676 . #x5076)
      (#x3677 . #x5BD3)
      (#x3678 . #x9047)
      (#x3679 . #x9685)
      (#x367A . #x4E32)
      (#x367B . #x6ADB)
      (#x367C . #x91E7)
      (#x367D . #x5C51)
      (#x367E . #x5C48)
      (#x3721 . #x6398)
      (#x3722 . #x7A9F)
      (#x3723 . #x6C93)
      (#x3724 . #x9774)
      (#x3725 . #x8F61)
      (#x3726 . #x7AAA)
      (#x3727 . #x718A)
      (#x3728 . #x9688)
      (#x3729 . #x7C82)
      (#x372A . #x6817)
      (#x372B . #x7E70)
      (#x372C . #x6851)
      (#x372D . #x936C)
      (#x372E . #x52F2)
      (#x372F . #x541B)
      (#x3730 . #x85AB)
      (#x3731 . #x8A13)
      (#x3732 . #x7FA4)
      (#x3733 . #x8ECD)
      (#x3734 . #x90E1)
      (#x3735 . #x5366)
      (#x3736 . #x8888)
      (#x3737 . #x7941)
      (#x3738 . #x4FC2)
      (#x3739 . #x50BE)
      (#x373A . #x5211)
      (#x373B . #x5144)
      (#x373C . #x5553)
      (#x373D . #x572D)
      (#x373E . #x73EA)
      (#x373F . #x578B)
      (#x3740 . #x5951)
      (#x3741 . #x5F62)
      (#x3742 . #x5F84)
      (#x3743 . #x6075)
      (#x3744 . #x6176)
      (#x3745 . #x6167)
      (#x3746 . #x61A9)
      (#x3747 . #x63B2)
      (#x3748 . #x643A)
      (#x3749 . #x656C)
      (#x374A . #x666F)
      (#x374B . #x6842)
      (#x374C . #x6E13)
      (#x374D . #x7566)
      (#x374E . #x7A3D)
      (#x374F . #x7CFB)
      (#x3750 . #x7D4C)
      (#x3751 . #x7D99)
      (#x3752 . #x7E4B)
      (#x3753 . #x7F6B)
      (#x3754 . #x830E)
      (#x3755 . #x834A)
      (#x3756 . #x86CD)
      (#x3757 . #x8A08)
      (#x3758 . #x8A63)
      (#x3759 . #x8B66)
      (#x375A . #x8EFD)
      (#x375B . #x981A)
      (#x375C . #x9D8F)
      (#x375D . #x82B8)
      (#x375E . #x8FCE)
      (#x375F . #x9BE8)
      (#x3760 . #x5287)
      (#x3761 . #x621F)
      (#x3762 . #x6483)
      (#x3763 . #x6FC0)
      (#x3764 . #x9699)
      (#x3765 . #x6841)
      (#x3766 . #x5091)
      (#x3767 . #x6B20)
      (#x3768 . #x6C7A)
      (#x3769 . #x6F54)
      (#x376A . #x7A74)
      (#x376B . #x7D50)
      (#x376C . #x8840)
      (#x376D . #x8A23)
      (#x376E . #x6708)
      (#x376F . #x4EF6)
      (#x3770 . #x5039)
      (#x3771 . #x5026)
      (#x3772 . #x5065)
      (#x3773 . #x517C)
      (#x3774 . #x5238)
      (#x3775 . #x5263)
      (#x3776 . #x55A7)
      (#x3777 . #x570F)
      (#x3778 . #x5805)
      (#x3779 . #x5ACC)
      (#x377A . #x5EFA)
      (#x377B . #x61B2)
      (#x377C . #x61F8)
      (#x377D . #x62F3)
      (#x377E . #x6372)
      (#x3821 . #x691C)
      (#x3822 . #x6A29)
      (#x3823 . #x727D)
      (#x3824 . #x72AC)
      (#x3825 . #x732E)
      (#x3826 . #x7814)
      (#x3827 . #x786F)
      (#x3828 . #x7D79)
      (#x3829 . #x770C)
      (#x382A . #x80A9)
      (#x382B . #x898B)
      (#x382C . #x8B19)
      (#x382D . #x8CE2)
      (#x382E . #x8ED2)
      (#x382F . #x9063)
      (#x3830 . #x9375)
      (#x3831 . #x967A)
      (#x3832 . #x9855)
      (#x3833 . #x9A13)
      (#x3834 . #x9E78)
      (#x3835 . #x5143)
      (#x3836 . #x539F)
      (#x3837 . #x53B3)
      (#x3838 . #x5E7B)
      (#x3839 . #x5F26)
      (#x383A . #x6E1B)
      (#x383B . #x6E90)
      (#x383C . #x7384)
      (#x383D . #x73FE)
      (#x383E . #x7D43)
      (#x383F . #x8237)
      (#x3840 . #x8A00)
      (#x3841 . #x8AFA)
      (#x3842 . #x9650)
      (#x3843 . #x4E4E)
      (#x3844 . #x500B)
      (#x3845 . #x53E4)
      (#x3846 . #x547C)
      (#x3847 . #x56FA)
      (#x3848 . #x59D1)
      (#x3849 . #x5B64)
      (#x384A . #x5DF1)
      (#x384B . #x5EAB)
      (#x384C . #x5F27)
      (#x384D . #x6238)
      (#x384E . #x6545)
      (#x384F . #x67AF)
      (#x3850 . #x6E56)
      (#x3851 . #x72D0)
      (#x3852 . #x7CCA)
      (#x3853 . #x88B4)
      (#x3854 . #x80A1)
      (#x3855 . #x80E1)
      (#x3856 . #x83F0)
      (#x3857 . #x864E)
      (#x3858 . #x8A87)
      (#x3859 . #x8DE8)
      (#x385A . #x9237)
      (#x385B . #x96C7)
      (#x385C . #x9867)
      (#x385D . #x9F13)
      (#x385E . #x4E94)
      (#x385F . #x4E92)
      (#x3860 . #x4F0D)
      (#x3861 . #x5348)
      (#x3862 . #x5449)
      (#x3863 . #x543E)
      (#x3864 . #x5A2F)
      (#x3865 . #x5F8C)
      (#x3866 . #x5FA1)
      (#x3867 . #x609F)
      (#x3868 . #x68A7)
      (#x3869 . #x6A8E)
      (#x386A . #x745A)
      (#x386B . #x7881)
      (#x386C . #x8A9E)
      (#x386D . #x8AA4)
      (#x386E . #x8B77)
      (#x386F . #x9190)
      (#x3870 . #x4E5E)
      (#x3871 . #x9BC9)
      (#x3872 . #x4EA4)
      (#x3873 . #x4F7C)
      (#x3874 . #x4FAF)
      (#x3875 . #x5019)
      (#x3876 . #x5016)
      (#x3877 . #x5149)
      (#x3878 . #x516C)
      (#x3879 . #x529F)
      (#x387A . #x52B9)
      (#x387B . #x52FE)
      (#x387C . #x539A)
      (#x387D . #x53E3)
      (#x387E . #x5411)
      (#x3921 . #x540E)
      (#x3922 . #x5589)
      (#x3923 . #x5751)
      (#x3924 . #x57A2)
      (#x3925 . #x597D)
      (#x3926 . #x5B54)
      (#x3927 . #x5B5D)
      (#x3928 . #x5B8F)
      (#x3929 . #x5DE5)
      (#x392A . #x5DE7)
      (#x392B . #x5DF7)
      (#x392C . #x5E78)
      (#x392D . #x5E83)
      (#x392E . #x5E9A)
      (#x392F . #x5EB7)
      (#x3930 . #x5F18)
      (#x3931 . #x6052)
      (#x3932 . #x614C)
      (#x3933 . #x6297)
      (#x3934 . #x62D8)
      (#x3935 . #x63A7)
      (#x3936 . #x653B)
      (#x3937 . #x6602)
      (#x3938 . #x6643)
      (#x3939 . #x66F4)
      (#x393A . #x676D)
      (#x393B . #x6821)
      (#x393C . #x6897)
      (#x393D . #x69CB)
      (#x393E . #x6C5F)
      (#x393F . #x6D2A)
      (#x3940 . #x6D69)
      (#x3941 . #x6E2F)
      (#x3942 . #x6E9D)
      (#x3943 . #x7532)
      (#x3944 . #x7687)
      (#x3945 . #x786C)
      (#x3946 . #x7A3F)
      (#x3947 . #x7CE0)
      (#x3948 . #x7D05)
      (#x3949 . #x7D18)
      (#x394A . #x7D5E)
      (#x394B . #x7DB1)
      (#x394C . #x8015)
      (#x394D . #x8003)
      (#x394E . #x80AF)
      (#x394F . #x80B1)
      (#x3950 . #x8154)
      (#x3951 . #x818F)
      (#x3952 . #x822A)
      (#x3953 . #x8352)
      (#x3954 . #x884C)
      (#x3955 . #x8861)
      (#x3956 . #x8B1B)
      (#x3957 . #x8CA2)
      (#x3958 . #x8CFC)
      (#x3959 . #x90CA)
      (#x395A . #x9175)
      (#x395B . #x9271)
      (#x395C . #x783F)
      (#x395D . #x92FC)
      (#x395E . #x95A4)
      (#x395F . #x964D)
      (#x3960 . #x9805)
      (#x3961 . #x9999)
      (#x3962 . #x9AD8)
      (#x3963 . #x9D3B)
      (#x3964 . #x525B)
      (#x3965 . #x52AB)
      (#x3966 . #x53F7)
      (#x3967 . #x5408)
      (#x3968 . #x58D5)
      (#x3969 . #x62F7)
      (#x396A . #x6FE0)
      (#x396B . #x8C6A)
      (#x396C . #x8F5F)
      (#x396D . #x9EB9)
      (#x396E . #x514B)
      (#x396F . #x523B)
      (#x3970 . #x544A)
      (#x3971 . #x56FD)
      (#x3972 . #x7A40)
      (#x3973 . #x9177)
      (#x3974 . #x9D60)
      (#x3975 . #x9ED2)
      (#x3976 . #x7344)
      (#x3977 . #x6F09)
      (#x3978 . #x8170)
      (#x3979 . #x7511)
      (#x397A . #x5FFD)
      (#x397B . #x60DA)
      (#x397C . #x9AA8)
      (#x397D . #x72DB)
      (#x397E . #x8FBC)
      (#x3A21 . #x6B64)
      (#x3A22 . #x9803)
      (#x3A23 . #x4ECA)
      (#x3A24 . #x56F0)
      (#x3A25 . #x5764)
      (#x3A26 . #x58BE)
      (#x3A27 . #x5A5A)
      (#x3A28 . #x6068)
      (#x3A29 . #x61C7)
      (#x3A2A . #x660F)
      (#x3A2B . #x6606)
      (#x3A2C . #x6839)
      (#x3A2D . #x68B1)
      (#x3A2E . #x6DF7)
      (#x3A2F . #x75D5)
      (#x3A30 . #x7D3A)
      (#x3A31 . #x826E)
      (#x3A32 . #x9B42)
      (#x3A33 . #x4E9B)
      (#x3A34 . #x4F50)
      (#x3A35 . #x53C9)
      (#x3A36 . #x5506)
      (#x3A37 . #x5D6F)
      (#x3A38 . #x5DE6)
      (#x3A39 . #x5DEE)
      (#x3A3A . #x67FB)
      (#x3A3B . #x6C99)
      (#x3A3C . #x7473)
      (#x3A3D . #x7802)
      (#x3A3E . #x8A50)
      (#x3A3F . #x9396)
      (#x3A40 . #x88DF)
      (#x3A41 . #x5750)
      (#x3A42 . #x5EA7)
      (#x3A43 . #x632B)
      (#x3A44 . #x50B5)
      (#x3A45 . #x50AC)
      (#x3A46 . #x518D)
      (#x3A47 . #x6700)
      (#x3A48 . #x54C9)
      (#x3A49 . #x585E)
      (#x3A4A . #x59BB)
      (#x3A4B . #x5BB0)
      (#x3A4C . #x5F69)
      (#x3A4D . #x624D)
      (#x3A4E . #x63A1)
      (#x3A4F . #x683D)
      (#x3A50 . #x6B73)
      (#x3A51 . #x6E08)
      (#x3A52 . #x707D)
      (#x3A53 . #x91C7)
      (#x3A54 . #x7280)
      (#x3A55 . #x7815)
      (#x3A56 . #x7826)
      (#x3A57 . #x796D)
      (#x3A58 . #x658E)
      (#x3A59 . #x7D30)
      (#x3A5A . #x83DC)
      (#x3A5B . #x88C1)
      (#x3A5C . #x8F09)
      (#x3A5D . #x969B)
      (#x3A5E . #x5264)
      (#x3A5F . #x5728)
      (#x3A60 . #x6750)
      (#x3A61 . #x7F6A)
      (#x3A62 . #x8CA1)
      (#x3A63 . #x51B4)
      (#x3A64 . #x5742)
      (#x3A65 . #x962A)
      (#x3A66 . #x583A)
      (#x3A67 . #x698A)
      (#x3A68 . #x80B4)
      (#x3A69 . #x54B2)
      (#x3A6A . #x5D0E)
      (#x3A6B . #x57FC)
      (#x3A6C . #x7895)
      (#x3A6D . #x9DFA)
      (#x3A6E . #x4F5C)
      (#x3A6F . #x524A)
      (#x3A70 . #x548B)
      (#x3A71 . #x643E)
      (#x3A72 . #x6628)
      (#x3A73 . #x6714)
      (#x3A74 . #x67F5)
      (#x3A75 . #x7A84)
      (#x3A76 . #x7B56)
      (#x3A77 . #x7D22)
      (#x3A78 . #x932F)
      (#x3A79 . #x685C)
      (#x3A7A . #x9BAD)
      (#x3A7B . #x7B39)
      (#x3A7C . #x5319)
      (#x3A7D . #x518A)
      (#x3A7E . #x5237)
      (#x3B21 . #x5BDF)
      (#x3B22 . #x62F6)
      (#x3B23 . #x64AE)
      (#x3B24 . #x64E6)
      (#x3B25 . #x672D)
      (#x3B26 . #x6BBA)
      (#x3B27 . #x85A9)
      (#x3B28 . #x96D1)
      (#x3B29 . #x7690)
      (#x3B2A . #x9BD6)
      (#x3B2B . #x634C)
      (#x3B2C . #x9306)
      (#x3B2D . #x9BAB)
      (#x3B2E . #x76BF)
      (#x3B2F . #x6652)
      (#x3B30 . #x4E09)
      (#x3B31 . #x5098)
      (#x3B32 . #x53C2)
      (#x3B33 . #x5C71)
      (#x3B34 . #x60E8)
      (#x3B35 . #x6492)
      (#x3B36 . #x6563)
      (#x3B37 . #x685F)
      (#x3B38 . #x71E6)
      (#x3B39 . #x73CA)
      (#x3B3A . #x7523)
      (#x3B3B . #x7B97)
      (#x3B3C . #x7E82)
      (#x3B3D . #x8695)
      (#x3B3E . #x8B83)
      (#x3B3F . #x8CDB)
      (#x3B40 . #x9178)
      (#x3B41 . #x9910)
      (#x3B42 . #x65AC)
      (#x3B43 . #x66AB)
      (#x3B44 . #x6B8B)
      (#x3B45 . #x4ED5)
      (#x3B46 . #x4ED4)
      (#x3B47 . #x4F3A)
      (#x3B48 . #x4F7F)
      (#x3B49 . #x523A)
      (#x3B4A . #x53F8)
      (#x3B4B . #x53F2)
      (#x3B4C . #x55E3)
      (#x3B4D . #x56DB)
      (#x3B4E . #x58EB)
      (#x3B4F . #x59CB)
      (#x3B50 . #x59C9)
      (#x3B51 . #x59FF)
      (#x3B52 . #x5B50)
      (#x3B53 . #x5C4D)
      (#x3B54 . #x5E02)
      (#x3B55 . #x5E2B)
      (#x3B56 . #x5FD7)
      (#x3B57 . #x601D)
      (#x3B58 . #x6307)
      (#x3B59 . #x652F)
      (#x3B5A . #x5B5C)
      (#x3B5B . #x65AF)
      (#x3B5C . #x65BD)
      (#x3B5D . #x65E8)
      (#x3B5E . #x679D)
      (#x3B5F . #x6B62)
      (#x3B60 . #x6B7B)
      (#x3B61 . #x6C0F)
      (#x3B62 . #x7345)
      (#x3B63 . #x7949)
      (#x3B64 . #x79C1)
      (#x3B65 . #x7CF8)
      (#x3B66 . #x7D19)
      (#x3B67 . #x7D2B)
      (#x3B68 . #x80A2)
      (#x3B69 . #x8102)
      (#x3B6A . #x81F3)
      (#x3B6B . #x8996)
      (#x3B6C . #x8A5E)
      (#x3B6D . #x8A69)
      (#x3B6E . #x8A66)
      (#x3B6F . #x8A8C)
      (#x3B70 . #x8AEE)
      (#x3B71 . #x8CC7)
      (#x3B72 . #x8CDC)
      (#x3B73 . #x96CC)
      (#x3B74 . #x98FC)
      (#x3B75 . #x6B6F)
      (#x3B76 . #x4E8B)
      (#x3B77 . #x4F3C)
      (#x3B78 . #x4F8D)
      (#x3B79 . #x5150)
      (#x3B7A . #x5B57)
      (#x3B7B . #x5BFA)
      (#x3B7C . #x6148)
      (#x3B7D . #x6301)
      (#x3B7E . #x6642)
      (#x3C21 . #x6B21)
      (#x3C22 . #x6ECB)
      (#x3C23 . #x6CBB)
      (#x3C24 . #x723E)
      (#x3C25 . #x74BD)
      (#x3C26 . #x75D4)
      (#x3C27 . #x78C1)
      (#x3C28 . #x793A)
      (#x3C29 . #x800C)
      (#x3C2A . #x8033)
      (#x3C2B . #x81EA)
      (#x3C2C . #x8494)
      (#x3C2D . #x8F9E)
      (#x3C2E . #x6C50)
      (#x3C2F . #x9E7F)
      (#x3C30 . #x5F0F)
      (#x3C31 . #x8B58)
      (#x3C32 . #x9D2B)
      (#x3C33 . #x7AFA)
      (#x3C34 . #x8EF8)
      (#x3C35 . #x5B8D)
      (#x3C36 . #x96EB)
      (#x3C37 . #x4E03)
      (#x3C38 . #x53F1)
      (#x3C39 . #x57F7)
      (#x3C3A . #x5931)
      (#x3C3B . #x5AC9)
      (#x3C3C . #x5BA4)
      (#x3C3D . #x6089)
      (#x3C3E . #x6E7F)
      (#x3C3F . #x6F06)
      (#x3C40 . #x75BE)
      (#x3C41 . #x8CEA)
      (#x3C42 . #x5B9F)
      (#x3C43 . #x8500)
      (#x3C44 . #x7BE0)
      (#x3C45 . #x5072)
      (#x3C46 . #x67F4)
      (#x3C47 . #x829D)
      (#x3C48 . #x5C61)
      (#x3C49 . #x854A)
      (#x3C4A . #x7E1E)
      (#x3C4B . #x820E)
      (#x3C4C . #x5199)
      (#x3C4D . #x5C04)
      (#x3C4E . #x6368)
      (#x3C4F . #x8D66)
      (#x3C50 . #x659C)
      (#x3C51 . #x716E)
      (#x3C52 . #x793E)
      (#x3C53 . #x7D17)
      (#x3C54 . #x8005)
      (#x3C55 . #x8B1D)
      (#x3C56 . #x8ECA)
      (#x3C57 . #x906E)
      (#x3C58 . #x86C7)
      (#x3C59 . #x90AA)
      (#x3C5A . #x501F)
      (#x3C5B . #x52FA)
      (#x3C5C . #x5C3A)
      (#x3C5D . #x6753)
      (#x3C5E . #x707C)
      (#x3C5F . #x7235)
      (#x3C60 . #x914C)
      (#x3C61 . #x91C8)
      (#x3C62 . #x932B)
      (#x3C63 . #x82E5)
      (#x3C64 . #x5BC2)
      (#x3C65 . #x5F31)
      (#x3C66 . #x60F9)
      (#x3C67 . #x4E3B)
      (#x3C68 . #x53D6)
      (#x3C69 . #x5B88)
      (#x3C6A . #x624B)
      (#x3C6B . #x6731)
      (#x3C6C . #x6B8A)
      (#x3C6D . #x72E9)
      (#x3C6E . #x73E0)
      (#x3C6F . #x7A2E)
      (#x3C70 . #x816B)
      (#x3C71 . #x8DA3)
      (#x3C72 . #x9152)
      (#x3C73 . #x9996)
      (#x3C74 . #x5112)
      (#x3C75 . #x53D7)
      (#x3C76 . #x546A)
      (#x3C77 . #x5BFF)
      (#x3C78 . #x6388)
      (#x3C79 . #x6A39)
      (#x3C7A . #x7DAC)
      (#x3C7B . #x9700)
      (#x3C7C . #x56DA)
      (#x3C7D . #x53CE)
      (#x3C7E . #x5468)
      (#x3D21 . #x5B97)
      (#x3D22 . #x5C31)
      (#x3D23 . #x5DDE)
      (#x3D24 . #x4FEE)
      (#x3D25 . #x6101)
      (#x3D26 . #x62FE)
      (#x3D27 . #x6D32)
      (#x3D28 . #x79C0)
      (#x3D29 . #x79CB)
      (#x3D2A . #x7D42)
      (#x3D2B . #x7E4D)
      (#x3D2C . #x7FD2)
      (#x3D2D . #x81ED)
      (#x3D2E . #x821F)
      (#x3D2F . #x8490)
      (#x3D30 . #x8846)
      (#x3D31 . #x8972)
      (#x3D32 . #x8B90)
      (#x3D33 . #x8E74)
      (#x3D34 . #x8F2F)
      (#x3D35 . #x9031)
      (#x3D36 . #x914B)
      (#x3D37 . #x916C)
      (#x3D38 . #x96C6)
      (#x3D39 . #x919C)
      (#x3D3A . #x4EC0)
      (#x3D3B . #x4F4F)
      (#x3D3C . #x5145)
      (#x3D3D . #x5341)
      (#x3D3E . #x5F93)
      (#x3D3F . #x620E)
      (#x3D40 . #x67D4)
      (#x3D41 . #x6C41)
      (#x3D42 . #x6E0B)
      (#x3D43 . #x7363)
      (#x3D44 . #x7E26)
      (#x3D45 . #x91CD)
      (#x3D46 . #x9283)
      (#x3D47 . #x53D4)
      (#x3D48 . #x5919)
      (#x3D49 . #x5BBF)
      (#x3D4A . #x6DD1)
      (#x3D4B . #x795D)
      (#x3D4C . #x7E2E)
      (#x3D4D . #x7C9B)
      (#x3D4E . #x587E)
      (#x3D4F . #x719F)
      (#x3D50 . #x51FA)
      (#x3D51 . #x8853)
      (#x3D52 . #x8FF0)
      (#x3D53 . #x4FCA)
      (#x3D54 . #x5CFB)
      (#x3D55 . #x6625)
      (#x3D56 . #x77AC)
      (#x3D57 . #x7AE3)
      (#x3D58 . #x821C)
      (#x3D59 . #x99FF)
      (#x3D5A . #x51C6)
      (#x3D5B . #x5FAA)
      (#x3D5C . #x65EC)
      (#x3D5D . #x696F)
      (#x3D5E . #x6B89)
      (#x3D5F . #x6DF3)
      (#x3D60 . #x6E96)
      (#x3D61 . #x6F64)
      (#x3D62 . #x76FE)
      (#x3D63 . #x7D14)
      (#x3D64 . #x5DE1)
      (#x3D65 . #x9075)
      (#x3D66 . #x9187)
      (#x3D67 . #x9806)
      (#x3D68 . #x51E6)
      (#x3D69 . #x521D)
      (#x3D6A . #x6240)
      (#x3D6B . #x6691)
      (#x3D6C . #x66D9)
      (#x3D6D . #x6E1A)
      (#x3D6E . #x5EB6)
      (#x3D6F . #x7DD2)
      (#x3D70 . #x7F72)
      (#x3D71 . #x66F8)
      (#x3D72 . #x85AF)
      (#x3D73 . #x85F7)
      (#x3D74 . #x8AF8)
      (#x3D75 . #x52A9)
      (#x3D76 . #x53D9)
      (#x3D77 . #x5973)
      (#x3D78 . #x5E8F)
      (#x3D79 . #x5F90)
      (#x3D7A . #x6055)
      (#x3D7B . #x92E4)
      (#x3D7C . #x9664)
      (#x3D7D . #x50B7)
      (#x3D7E . #x511F)
      (#x3E21 . #x52DD)
      (#x3E22 . #x5320)
      (#x3E23 . #x5347)
      (#x3E24 . #x53EC)
      (#x3E25 . #x54E8)
      (#x3E26 . #x5546)
      (#x3E27 . #x5531)
      (#x3E28 . #x5617)
      (#x3E29 . #x5968)
      (#x3E2A . #x59BE)
      (#x3E2B . #x5A3C)
      (#x3E2C . #x5BB5)
      (#x3E2D . #x5C06)
      (#x3E2E . #x5C0F)
      (#x3E2F . #x5C11)
      (#x3E30 . #x5C1A)
      (#x3E31 . #x5E84)
      (#x3E32 . #x5E8A)
      (#x3E33 . #x5EE0)
      (#x3E34 . #x5F70)
      (#x3E35 . #x627F)
      (#x3E36 . #x6284)
      (#x3E37 . #x62DB)
      (#x3E38 . #x638C)
      (#x3E39 . #x6377)
      (#x3E3A . #x6607)
      (#x3E3B . #x660C)
      (#x3E3C . #x662D)
      (#x3E3D . #x6676)
      (#x3E3E . #x677E)
      (#x3E3F . #x68A2)
      (#x3E40 . #x6A1F)
      (#x3E41 . #x6A35)
      (#x3E42 . #x6CBC)
      (#x3E43 . #x6D88)
      (#x3E44 . #x6E09)
      (#x3E45 . #x6E58)
      (#x3E46 . #x713C)
      (#x3E47 . #x7126)
      (#x3E48 . #x7167)
      (#x3E49 . #x75C7)
      (#x3E4A . #x7701)
      (#x3E4B . #x785D)
      (#x3E4C . #x7901)
      (#x3E4D . #x7965)
      (#x3E4E . #x79F0)
      (#x3E4F . #x7AE0)
      (#x3E50 . #x7B11)
      (#x3E51 . #x7CA7)
      (#x3E52 . #x7D39)
      (#x3E53 . #x8096)
      (#x3E54 . #x83D6)
      (#x3E55 . #x848B)
      (#x3E56 . #x8549)
      (#x3E57 . #x885D)
      (#x3E58 . #x88F3)
      (#x3E59 . #x8A1F)
      (#x3E5A . #x8A3C)
      (#x3E5B . #x8A54)
      (#x3E5C . #x8A73)
      (#x3E5D . #x8C61)
      (#x3E5E . #x8CDE)
      (#x3E5F . #x91A4)
      (#x3E60 . #x9266)
      (#x3E61 . #x937E)
      (#x3E62 . #x9418)
      (#x3E63 . #x969C)
      (#x3E64 . #x9798)
      (#x3E65 . #x4E0A)
      (#x3E66 . #x4E08)
      (#x3E67 . #x4E1E)
      (#x3E68 . #x4E57)
      (#x3E69 . #x5197)
      (#x3E6A . #x5270)
      (#x3E6B . #x57CE)
      (#x3E6C . #x5834)
      (#x3E6D . #x58CC)
      (#x3E6E . #x5B22)
      (#x3E6F . #x5E38)
      (#x3E70 . #x60C5)
      (#x3E71 . #x64FE)
      (#x3E72 . #x6761)
      (#x3E73 . #x6756)
      (#x3E74 . #x6D44)
      (#x3E75 . #x72B6)
      (#x3E76 . #x7573)
      (#x3E77 . #x7A63)
      (#x3E78 . #x84B8)
      (#x3E79 . #x8B72)
      (#x3E7A . #x91B8)
      (#x3E7B . #x9320)
      (#x3E7C . #x5631)
      (#x3E7D . #x57F4)
      (#x3E7E . #x98FE)
      (#x3F21 . #x62ED)
      (#x3F22 . #x690D)
      (#x3F23 . #x6B96)
      (#x3F24 . #x71ED)
      (#x3F25 . #x7E54)
      (#x3F26 . #x8077)
      (#x3F27 . #x8272)
      (#x3F28 . #x89E6)
      (#x3F29 . #x98DF)
      (#x3F2A . #x8755)
      (#x3F2B . #x8FB1)
      (#x3F2C . #x5C3B)
      (#x3F2D . #x4F38)
      (#x3F2E . #x4FE1)
      (#x3F2F . #x4FB5)
      (#x3F30 . #x5507)
      (#x3F31 . #x5A20)
      (#x3F32 . #x5BDD)
      (#x3F33 . #x5BE9)
      (#x3F34 . #x5FC3)
      (#x3F35 . #x614E)
      (#x3F36 . #x632F)
      (#x3F37 . #x65B0)
      (#x3F38 . #x664B)
      (#x3F39 . #x68EE)
      (#x3F3A . #x699B)
      (#x3F3B . #x6D78)
      (#x3F3C . #x6DF1)
      (#x3F3D . #x7533)
      (#x3F3E . #x75B9)
      (#x3F3F . #x771F)
      (#x3F40 . #x795E)
      (#x3F41 . #x79E6)
      (#x3F42 . #x7D33)
      (#x3F43 . #x81E3)
      (#x3F44 . #x82AF)
      (#x3F45 . #x85AA)
      (#x3F46 . #x89AA)
      (#x3F47 . #x8A3A)
      (#x3F48 . #x8EAB)
      (#x3F49 . #x8F9B)
      (#x3F4A . #x9032)
      (#x3F4B . #x91DD)
      (#x3F4C . #x9707)
      (#x3F4D . #x4EBA)
      (#x3F4E . #x4EC1)
      (#x3F4F . #x5203)
      (#x3F50 . #x5875)
      (#x3F51 . #x58EC)
      (#x3F52 . #x5C0B)
      (#x3F53 . #x751A)
      (#x3F54 . #x5C3D)
      (#x3F55 . #x814E)
      (#x3F56 . #x8A0A)
      (#x3F57 . #x8FC5)
      (#x3F58 . #x9663)
      (#x3F59 . #x976D)
      (#x3F5A . #x7B25)
      (#x3F5B . #x8ACF)
      (#x3F5C . #x9808)
      (#x3F5D . #x9162)
      (#x3F5E . #x56F3)
      (#x3F5F . #x53A8)
      (#x3F60 . #x9017)
      (#x3F61 . #x5439)
      (#x3F62 . #x5782)
      (#x3F63 . #x5E25)
      (#x3F64 . #x63A8)
      (#x3F65 . #x6C34)
      (#x3F66 . #x708A)
      (#x3F67 . #x7761)
      (#x3F68 . #x7C8B)
      (#x3F69 . #x7FE0)
      (#x3F6A . #x8870)
      (#x3F6B . #x9042)
      (#x3F6C . #x9154)
      (#x3F6D . #x9310)
      (#x3F6E . #x9318)
      (#x3F6F . #x968F)
      (#x3F70 . #x745E)
      (#x3F71 . #x9AC4)
      (#x3F72 . #x5D07)
      (#x3F73 . #x5D69)
      (#x3F74 . #x6570)
      (#x3F75 . #x67A2)
      (#x3F76 . #x8DA8)
      (#x3F77 . #x96DB)
      (#x3F78 . #x636E)
      (#x3F79 . #x6749)
      (#x3F7A . #x6919)
      (#x3F7B . #x83C5)
      (#x3F7C . #x9817)
      (#x3F7D . #x96C0)
      (#x3F7E . #x88FE)
      (#x4021 . #x6F84)
      (#x4022 . #x647A)
      (#x4023 . #x5BF8)
      (#x4024 . #x4E16)
      (#x4025 . #x702C)
      (#x4026 . #x755D)
      (#x4027 . #x662F)
      (#x4028 . #x51C4)
      (#x4029 . #x5236)
      (#x402A . #x52E2)
      (#x402B . #x59D3)
      (#x402C . #x5F81)
      (#x402D . #x6027)
      (#x402E . #x6210)
      (#x402F . #x653F)
      (#x4030 . #x6574)
      (#x4031 . #x661F)
      (#x4032 . #x6674)
      (#x4033 . #x68F2)
      (#x4034 . #x6816)
      (#x4035 . #x6B63)
      (#x4036 . #x6E05)
      (#x4037 . #x7272)
      (#x4038 . #x751F)
      (#x4039 . #x76DB)
      (#x403A . #x7CBE)
      (#x403B . #x8056)
      (#x403C . #x58F0)
      (#x403D . #x88FD)
      (#x403E . #x897F)
      (#x403F . #x8AA0)
      (#x4040 . #x8A93)
      (#x4041 . #x8ACB)
      (#x4042 . #x901D)
      (#x4043 . #x9192)
      (#x4044 . #x9752)
      (#x4045 . #x9759)
      (#x4046 . #x6589)
      (#x4047 . #x7A0E)
      (#x4048 . #x8106)
      (#x4049 . #x96BB)
      (#x404A . #x5E2D)
      (#x404B . #x60DC)
      (#x404C . #x621A)
      (#x404D . #x65A5)
      (#x404E . #x6614)
      (#x404F . #x6790)
      (#x4050 . #x77F3)
      (#x4051 . #x7A4D)
      (#x4052 . #x7C4D)
      (#x4053 . #x7E3E)
      (#x4054 . #x810A)
      (#x4055 . #x8CAC)
      (#x4056 . #x8D64)
      (#x4057 . #x8DE1)
      (#x4058 . #x8E5F)
      (#x4059 . #x78A9)
      (#x405A . #x5207)
      (#x405B . #x62D9)
      (#x405C . #x63A5)
      (#x405D . #x6442)
      (#x405E . #x6298)
      (#x405F . #x8A2D)
      (#x4060 . #x7A83)
      (#x4061 . #x7BC0)
      (#x4062 . #x8AAC)
      (#x4063 . #x96EA)
      (#x4064 . #x7D76)
      (#x4065 . #x820C)
      (#x4066 . #x8749)
      (#x4067 . #x4ED9)
      (#x4068 . #x5148)
      (#x4069 . #x5343)
      (#x406A . #x5360)
      (#x406B . #x5BA3)
      (#x406C . #x5C02)
      (#x406D . #x5C16)
      (#x406E . #x5DDD)
      (#x406F . #x6226)
      (#x4070 . #x6247)
      (#x4071 . #x64B0)
      (#x4072 . #x6813)
      (#x4073 . #x6834)
      (#x4074 . #x6CC9)
      (#x4075 . #x6D45)
      (#x4076 . #x6D17)
      (#x4077 . #x67D3)
      (#x4078 . #x6F5C)
      (#x4079 . #x714E)
      (#x407A . #x717D)
      (#x407B . #x65CB)
      (#x407C . #x7A7F)
      (#x407D . #x7BAD)
      (#x407E . #x7DDA)
      (#x4121 . #x7E4A)
      (#x4122 . #x7FA8)
      (#x4123 . #x817A)
      (#x4124 . #x821B)
      (#x4125 . #x8239)
      (#x4126 . #x85A6)
      (#x4127 . #x8A6E)
      (#x4128 . #x8CCE)
      (#x4129 . #x8DF5)
      (#x412A . #x9078)
      (#x412B . #x9077)
      (#x412C . #x92AD)
      (#x412D . #x9291)
      (#x412E . #x9583)
      (#x412F . #x9BAE)
      (#x4130 . #x524D)
      (#x4131 . #x5584)
      (#x4132 . #x6F38)
      (#x4133 . #x7136)
      (#x4134 . #x5168)
      (#x4135 . #x7985)
      (#x4136 . #x7E55)
      (#x4137 . #x81B3)
      (#x4138 . #x7CCE)
      (#x4139 . #x564C)
      (#x413A . #x5851)
      (#x413B . #x5CA8)
      (#x413C . #x63AA)
      (#x413D . #x66FE)
      (#x413E . #x66FD)
      (#x413F . #x695A)
      (#x4140 . #x72D9)
      (#x4141 . #x758F)
      (#x4142 . #x758E)
      (#x4143 . #x790E)
      (#x4144 . #x7956)
      (#x4145 . #x79DF)
      (#x4146 . #x7C97)
      (#x4147 . #x7D20)
      (#x4148 . #x7D44)
      (#x4149 . #x8607)
      (#x414A . #x8A34)
      (#x414B . #x963B)
      (#x414C . #x9061)
      (#x414D . #x9F20)
      (#x414E . #x50E7)
      (#x414F . #x5275)
      (#x4150 . #x53CC)
      (#x4151 . #x53E2)
      (#x4152 . #x5009)
      (#x4153 . #x55AA)
      (#x4154 . #x58EE)
      (#x4155 . #x594F)
      (#x4156 . #x723D)
      (#x4157 . #x5B8B)
      (#x4158 . #x5C64)
      (#x4159 . #x531D)
      (#x415A . #x60E3)
      (#x415B . #x60F3)
      (#x415C . #x635C)
      (#x415D . #x6383)
      (#x415E . #x633F)
      (#x415F . #x63BB)
      (#x4160 . #x64CD)
      (#x4161 . #x65E9)
      (#x4162 . #x66F9)
      (#x4163 . #x5DE3)
      (#x4164 . #x69CD)
      (#x4165 . #x69FD)
      (#x4166 . #x6F15)
      (#x4167 . #x71E5)
      (#x4168 . #x4E89)
      (#x4169 . #x75E9)
      (#x416A . #x76F8)
      (#x416B . #x7A93)
      (#x416C . #x7CDF)
      (#x416D . #x7DCF)
      (#x416E . #x7D9C)
      (#x416F . #x8061)
      (#x4170 . #x8349)
      (#x4171 . #x8358)
      (#x4172 . #x846C)
      (#x4173 . #x84BC)
      (#x4174 . #x85FB)
      (#x4175 . #x88C5)
      (#x4176 . #x8D70)
      (#x4177 . #x9001)
      (#x4178 . #x906D)
      (#x4179 . #x9397)
      (#x417A . #x971C)
      (#x417B . #x9A12)
      (#x417C . #x50CF)
      (#x417D . #x5897)
      (#x417E . #x618E)
      (#x4221 . #x81D3)
      (#x4222 . #x8535)
      (#x4223 . #x8D08)
      (#x4224 . #x9020)
      (#x4225 . #x4FC3)
      (#x4226 . #x5074)
      (#x4227 . #x5247)
      (#x4228 . #x5373)
      (#x4229 . #x606F)
      (#x422A . #x6349)
      (#x422B . #x675F)
      (#x422C . #x6E2C)
      (#x422D . #x8DB3)
      (#x422E . #x901F)
      (#x422F . #x4FD7)
      (#x4230 . #x5C5E)
      (#x4231 . #x8CCA)
      (#x4232 . #x65CF)
      (#x4233 . #x7D9A)
      (#x4234 . #x5352)
      (#x4235 . #x8896)
      (#x4236 . #x5176)
      (#x4237 . #x63C3)
      (#x4238 . #x5B58)
      (#x4239 . #x5B6B)
      (#x423A . #x5C0A)
      (#x423B . #x640D)
      (#x423C . #x6751)
      (#x423D . #x905C)
      (#x423E . #x4ED6)
      (#x423F . #x591A)
      (#x4240 . #x592A)
      (#x4241 . #x6C70)
      (#x4242 . #x8A51)
      (#x4243 . #x553E)
      (#x4244 . #x5815)
      (#x4245 . #x59A5)
      (#x4246 . #x60F0)
      (#x4247 . #x6253)
      (#x4248 . #x67C1)
      (#x4249 . #x8235)
      (#x424A . #x6955)
      (#x424B . #x9640)
      (#x424C . #x99C4)
      (#x424D . #x9A28)
      (#x424E . #x4F53)
      (#x424F . #x5806)
      (#x4250 . #x5BFE)
      (#x4251 . #x8010)
      (#x4252 . #x5CB1)
      (#x4253 . #x5E2F)
      (#x4254 . #x5F85)
      (#x4255 . #x6020)
      (#x4256 . #x614B)
      (#x4257 . #x6234)
      (#x4258 . #x66FF)
      (#x4259 . #x6CF0)
      (#x425A . #x6EDE)
      (#x425B . #x80CE)
      (#x425C . #x817F)
      (#x425D . #x82D4)
      (#x425E . #x888B)
      (#x425F . #x8CB8)
      (#x4260 . #x9000)
      (#x4261 . #x902E)
      (#x4262 . #x968A)
      (#x4263 . #x9EDB)
      (#x4264 . #x9BDB)
      (#x4265 . #x4EE3)
      (#x4266 . #x53F0)
      (#x4267 . #x5927)
      (#x4268 . #x7B2C)
      (#x4269 . #x918D)
      (#x426A . #x984C)
      (#x426B . #x9DF9)
      (#x426C . #x6EDD)
      (#x426D . #x7027)
      (#x426E . #x5353)
      (#x426F . #x5544)
      (#x4270 . #x5B85)
      (#x4271 . #x6258)
      (#x4272 . #x629E)
      (#x4273 . #x62D3)
      (#x4274 . #x6CA2)
      (#x4275 . #x6FEF)
      (#x4276 . #x7422)
      (#x4277 . #x8A17)
      (#x4278 . #x9438)
      (#x4279 . #x6FC1)
      (#x427A . #x8AFE)
      (#x427B . #x8338)
      (#x427C . #x51E7)
      (#x427D . #x86F8)
      (#x427E . #x53EA)
      (#x4321 . #x53E9)
      (#x4322 . #x4F46)
      (#x4323 . #x9054)
      (#x4324 . #x8FB0)
      (#x4325 . #x596A)
      (#x4326 . #x8131)
      (#x4327 . #x5DFD)
      (#x4328 . #x7AEA)
      (#x4329 . #x8FBF)
      (#x432A . #x68DA)
      (#x432B . #x8C37)
      (#x432C . #x72F8)
      (#x432D . #x9C48)
      (#x432E . #x6A3D)
      (#x432F . #x8AB0)
      (#x4330 . #x4E39)
      (#x4331 . #x5358)
      (#x4332 . #x5606)
      (#x4333 . #x5766)
      (#x4334 . #x62C5)
      (#x4335 . #x63A2)
      (#x4336 . #x65E6)
      (#x4337 . #x6B4E)
      (#x4338 . #x6DE1)
      (#x4339 . #x6E5B)
      (#x433A . #x70AD)
      (#x433B . #x77ED)
      (#x433C . #x7AEF)
      (#x433D . #x7BAA)
      (#x433E . #x7DBB)
      (#x433F . #x803D)
      (#x4340 . #x80C6)
      (#x4341 . #x86CB)
      (#x4342 . #x8A95)
      (#x4343 . #x935B)
      (#x4344 . #x56E3)
      (#x4345 . #x58C7)
      (#x4346 . #x5F3E)
      (#x4347 . #x65AD)
      (#x4348 . #x6696)
      (#x4349 . #x6A80)
      (#x434A . #x6BB5)
      (#x434B . #x7537)
      (#x434C . #x8AC7)
      (#x434D . #x5024)
      (#x434E . #x77E5)
      (#x434F . #x5730)
      (#x4350 . #x5F1B)
      (#x4351 . #x6065)
      (#x4352 . #x667A)
      (#x4353 . #x6C60)
      (#x4354 . #x75F4)
      (#x4355 . #x7A1A)
      (#x4356 . #x7F6E)
      (#x4357 . #x81F4)
      (#x4358 . #x8718)
      (#x4359 . #x9045)
      (#x435A . #x99B3)
      (#x435B . #x7BC9)
      (#x435C . #x755C)
      (#x435D . #x7AF9)
      (#x435E . #x7B51)
      (#x435F . #x84C4)
      (#x4360 . #x9010)
      (#x4361 . #x79E9)
      (#x4362 . #x7A92)
      (#x4363 . #x8336)
      (#x4364 . #x5AE1)
      (#x4365 . #x7740)
      (#x4366 . #x4E2D)
      (#x4367 . #x4EF2)
      (#x4368 . #x5B99)
      (#x4369 . #x5FE0)
      (#x436A . #x62BD)
      (#x436B . #x663C)
      (#x436C . #x67F1)
      (#x436D . #x6CE8)
      (#x436E . #x866B)
      (#x436F . #x8877)
      (#x4370 . #x8A3B)
      (#x4371 . #x914E)
      (#x4372 . #x92F3)
      (#x4373 . #x99D0)
      (#x4374 . #x6A17)
      (#x4375 . #x7026)
      (#x4376 . #x732A)
      (#x4377 . #x82E7)
      (#x4378 . #x8457)
      (#x4379 . #x8CAF)
      (#x437A . #x4E01)
      (#x437B . #x5146)
      (#x437C . #x51CB)
      (#x437D . #x558B)
      (#x437E . #x5BF5)
      (#x4421 . #x5E16)
      (#x4422 . #x5E33)
      (#x4423 . #x5E81)
      (#x4424 . #x5F14)
      (#x4425 . #x5F35)
      (#x4426 . #x5F6B)
      (#x4427 . #x5FB4)
      (#x4428 . #x61F2)
      (#x4429 . #x6311)
      (#x442A . #x66A2)
      (#x442B . #x671D)
      (#x442C . #x6F6E)
      (#x442D . #x7252)
      (#x442E . #x753A)
      (#x442F . #x773A)
      (#x4430 . #x8074)
      (#x4431 . #x8139)
      (#x4432 . #x8178)
      (#x4433 . #x8776)
      (#x4434 . #x8ABF)
      (#x4435 . #x8ADC)
      (#x4436 . #x8D85)
      (#x4437 . #x8DF3)
      (#x4438 . #x929A)
      (#x4439 . #x9577)
      (#x443A . #x9802)
      (#x443B . #x9CE5)
      (#x443C . #x52C5)
      (#x443D . #x6357)
      (#x443E . #x76F4)
      (#x443F . #x6715)
      (#x4440 . #x6C88)
      (#x4441 . #x73CD)
      (#x4442 . #x8CC3)
      (#x4443 . #x93AE)
      (#x4444 . #x9673)
      (#x4445 . #x6D25)
      (#x4446 . #x589C)
      (#x4447 . #x690E)
      (#x4448 . #x69CC)
      (#x4449 . #x8FFD)
      (#x444A . #x939A)
      (#x444B . #x75DB)
      (#x444C . #x901A)
      (#x444D . #x585A)
      (#x444E . #x6802)
      (#x444F . #x63B4)
      (#x4450 . #x69FB)
      (#x4451 . #x4F43)
      (#x4452 . #x6F2C)
      (#x4453 . #x67D8)
      (#x4454 . #x8FBB)
      (#x4455 . #x8526)
      (#x4456 . #x7DB4)
      (#x4457 . #x9354)
      (#x4458 . #x693F)
      (#x4459 . #x6F70)
      (#x445A . #x576A)
      (#x445B . #x58F7)
      (#x445C . #x5B2C)
      (#x445D . #x7D2C)
      (#x445E . #x722A)
      (#x445F . #x540A)
      (#x4460 . #x91E3)
      (#x4461 . #x9DB4)
      (#x4462 . #x4EAD)
      (#x4463 . #x4F4E)
      (#x4464 . #x505C)
      (#x4465 . #x5075)
      (#x4466 . #x5243)
      (#x4467 . #x8C9E)
      (#x4468 . #x5448)
      (#x4469 . #x5824)
      (#x446A . #x5B9A)
      (#x446B . #x5E1D)
      (#x446C . #x5E95)
      (#x446D . #x5EAD)
      (#x446E . #x5EF7)
      (#x446F . #x5F1F)
      (#x4470 . #x608C)
      (#x4471 . #x62B5)
      (#x4472 . #x633A)
      (#x4473 . #x63D0)
      (#x4474 . #x68AF)
      (#x4475 . #x6C40)
      (#x4476 . #x7887)
      (#x4477 . #x798E)
      (#x4478 . #x7A0B)
      (#x4479 . #x7DE0)
      (#x447A . #x8247)
      (#x447B . #x8A02)
      (#x447C . #x8AE6)
      (#x447D . #x8E44)
      (#x447E . #x9013)
      (#x4521 . #x90B8)
      (#x4522 . #x912D)
      (#x4523 . #x91D8)
      (#x4524 . #x9F0E)
      (#x4525 . #x6CE5)
      (#x4526 . #x6458)
      (#x4527 . #x64E2)
      (#x4528 . #x6575)
      (#x4529 . #x6EF4)
      (#x452A . #x7684)
      (#x452B . #x7B1B)
      (#x452C . #x9069)
      (#x452D . #x93D1)
      (#x452E . #x6EBA)
      (#x452F . #x54F2)
      (#x4530 . #x5FB9)
      (#x4531 . #x64A4)
      (#x4532 . #x8F4D)
      (#x4533 . #x8FED)
      (#x4534 . #x9244)
      (#x4535 . #x5178)
      (#x4536 . #x586B)
      (#x4537 . #x5929)
      (#x4538 . #x5C55)
      (#x4539 . #x5E97)
      (#x453A . #x6DFB)
      (#x453B . #x7E8F)
      (#x453C . #x751C)
      (#x453D . #x8CBC)
      (#x453E . #x8EE2)
      (#x453F . #x985B)
      (#x4540 . #x70B9)
      (#x4541 . #x4F1D)
      (#x4542 . #x6BBF)
      (#x4543 . #x6FB1)
      (#x4544 . #x7530)
      (#x4545 . #x96FB)
      (#x4546 . #x514E)
      (#x4547 . #x5410)
      (#x4548 . #x5835)
      (#x4549 . #x5857)
      (#x454A . #x59AC)
      (#x454B . #x5C60)
      (#x454C . #x5F92)
      (#x454D . #x6597)
      (#x454E . #x675C)
      (#x454F . #x6E21)
      (#x4550 . #x767B)
      (#x4551 . #x83DF)
      (#x4552 . #x8CED)
      (#x4553 . #x9014)
      (#x4554 . #x90FD)
      (#x4555 . #x934D)
      (#x4556 . #x7825)
      (#x4557 . #x783A)
      (#x4558 . #x52AA)
      (#x4559 . #x5EA6)
      (#x455A . #x571F)
      (#x455B . #x5974)
      (#x455C . #x6012)
      (#x455D . #x5012)
      (#x455E . #x515A)
      (#x455F . #x51AC)
      (#x4560 . #x51CD)
      (#x4561 . #x5200)
      (#x4562 . #x5510)
      (#x4563 . #x5854)
      (#x4564 . #x5858)
      (#x4565 . #x5957)
      (#x4566 . #x5B95)
      (#x4567 . #x5CF6)
      (#x4568 . #x5D8B)
      (#x4569 . #x60BC)
      (#x456A . #x6295)
      (#x456B . #x642D)
      (#x456C . #x6771)
      (#x456D . #x6843)
      (#x456E . #x68BC)
      (#x456F . #x68DF)
      (#x4570 . #x76D7)
      (#x4571 . #x6DD8)
      (#x4572 . #x6E6F)
      (#x4573 . #x6D9B)
      (#x4574 . #x706F)
      (#x4575 . #x71C8)
      (#x4576 . #x5F53)
      (#x4577 . #x75D8)
      (#x4578 . #x7977)
      (#x4579 . #x7B49)
      (#x457A . #x7B54)
      (#x457B . #x7B52)
      (#x457C . #x7CD6)
      (#x457D . #x7D71)
      (#x457E . #x5230)
      (#x4621 . #x8463)
      (#x4622 . #x8569)
      (#x4623 . #x85E4)
      (#x4624 . #x8A0E)
      (#x4625 . #x8B04)
      (#x4626 . #x8C46)
      (#x4627 . #x8E0F)
      (#x4628 . #x9003)
      (#x4629 . #x900F)
      (#x462A . #x9419)
      (#x462B . #x9676)
      (#x462C . #x982D)
      (#x462D . #x9A30)
      (#x462E . #x95D8)
      (#x462F . #x50CD)
      (#x4630 . #x52D5)
      (#x4631 . #x540C)
      (#x4632 . #x5802)
      (#x4633 . #x5C0E)
      (#x4634 . #x61A7)
      (#x4635 . #x649E)
      (#x4636 . #x6D1E)
      (#x4637 . #x77B3)
      (#x4638 . #x7AE5)
      (#x4639 . #x80F4)
      (#x463A . #x8404)
      (#x463B . #x9053)
      (#x463C . #x9285)
      (#x463D . #x5CE0)
      (#x463E . #x9D07)
      (#x463F . #x533F)
      (#x4640 . #x5F97)
      (#x4641 . #x5FB3)
      (#x4642 . #x6D9C)
      (#x4643 . #x7279)
      (#x4644 . #x7763)
      (#x4645 . #x79BF)
      (#x4646 . #x7BE4)
      (#x4647 . #x6BD2)
      (#x4648 . #x72EC)
      (#x4649 . #x8AAD)
      (#x464A . #x6803)
      (#x464B . #x6A61)
      (#x464C . #x51F8)
      (#x464D . #x7A81)
      (#x464E . #x6934)
      (#x464F . #x5C4A)
      (#x4650 . #x9CF6)
      (#x4651 . #x82EB)
      (#x4652 . #x5BC5)
      (#x4653 . #x9149)
      (#x4654 . #x701E)
      (#x4655 . #x5678)
      (#x4656 . #x5C6F)
      (#x4657 . #x60C7)
      (#x4658 . #x6566)
      (#x4659 . #x6C8C)
      (#x465A . #x8C5A)
      (#x465B . #x9041)
      (#x465C . #x9813)
      (#x465D . #x5451)
      (#x465E . #x66C7)
      (#x465F . #x920D)
      (#x4660 . #x5948)
      (#x4661 . #x90A3)
      (#x4662 . #x5185)
      (#x4663 . #x4E4D)
      (#x4664 . #x51EA)
      (#x4665 . #x8599)
      (#x4666 . #x8B0E)
      (#x4667 . #x7058)
      (#x4668 . #x637A)
      (#x4669 . #x934B)
      (#x466A . #x6962)
      (#x466B . #x99B4)
      (#x466C . #x7E04)
      (#x466D . #x7577)
      (#x466E . #x5357)
      (#x466F . #x6960)
      (#x4670 . #x8EDF)
      (#x4671 . #x96E3)
      (#x4672 . #x6C5D)
      (#x4673 . #x4E8C)
      (#x4674 . #x5C3C)
      (#x4675 . #x5F10)
      (#x4676 . #x8FE9)
      (#x4677 . #x5302)
      (#x4678 . #x8CD1)
      (#x4679 . #x8089)
      (#x467A . #x8679)
      (#x467B . #x5EFF)
      (#x467C . #x65E5)
      (#x467D . #x4E73)
      (#x467E . #x5165)
      (#x4721 . #x5982)
      (#x4722 . #x5C3F)
      (#x4723 . #x97EE)
      (#x4724 . #x4EFB)
      (#x4725 . #x598A)
      (#x4726 . #x5FCD)
      (#x4727 . #x8A8D)
      (#x4728 . #x6FE1)
      (#x4729 . #x79B0)
      (#x472A . #x7962)
      (#x472B . #x5BE7)
      (#x472C . #x8471)
      (#x472D . #x732B)
      (#x472E . #x71B1)
      (#x472F . #x5E74)
      (#x4730 . #x5FF5)
      (#x4731 . #x637B)
      (#x4732 . #x649A)
      (#x4733 . #x71C3)
      (#x4734 . #x7C98)
      (#x4735 . #x4E43)
      (#x4736 . #x5EFC)
      (#x4737 . #x4E4B)
      (#x4738 . #x57DC)
      (#x4739 . #x56A2)
      (#x473A . #x60A9)
      (#x473B . #x6FC3)
      (#x473C . #x7D0D)
      (#x473D . #x80FD)
      (#x473E . #x8133)
      (#x473F . #x81BF)
      (#x4740 . #x8FB2)
      (#x4741 . #x8997)
      (#x4742 . #x86A4)
      (#x4743 . #x5DF4)
      (#x4744 . #x628A)
      (#x4745 . #x64AD)
      (#x4746 . #x8987)
      (#x4747 . #x6777)
      (#x4748 . #x6CE2)
      (#x4749 . #x6D3E)
      (#x474A . #x7436)
      (#x474B . #x7834)
      (#x474C . #x5A46)
      (#x474D . #x7F75)
      (#x474E . #x82AD)
      (#x474F . #x99AC)
      (#x4750 . #x4FF3)
      (#x4751 . #x5EC3)
      (#x4752 . #x62DD)
      (#x4753 . #x6392)
      (#x4754 . #x6557)
      (#x4755 . #x676F)
      (#x4756 . #x76C3)
      (#x4757 . #x724C)
      (#x4758 . #x80CC)
      (#x4759 . #x80BA)
      (#x475A . #x8F29)
      (#x475B . #x914D)
      (#x475C . #x500D)
      (#x475D . #x57F9)
      (#x475E . #x5A92)
      (#x475F . #x6885)
      (#x4760 . #x6973)
      (#x4761 . #x7164)
      (#x4762 . #x72FD)
      (#x4763 . #x8CB7)
      (#x4764 . #x58F2)
      (#x4765 . #x8CE0)
      (#x4766 . #x966A)
      (#x4767 . #x9019)
      (#x4768 . #x877F)
      (#x4769 . #x79E4)
      (#x476A . #x77E7)
      (#x476B . #x8429)
      (#x476C . #x4F2F)
      (#x476D . #x5265)
      (#x476E . #x535A)
      (#x476F . #x62CD)
      (#x4770 . #x67CF)
      (#x4771 . #x6CCA)
      (#x4772 . #x767D)
      (#x4773 . #x7B94)
      (#x4774 . #x7C95)
      (#x4775 . #x8236)
      (#x4776 . #x8584)
      (#x4777 . #x8FEB)
      (#x4778 . #x66DD)
      (#x4779 . #x6F20)
      (#x477A . #x7206)
      (#x477B . #x7E1B)
      (#x477C . #x83AB)
      (#x477D . #x99C1)
      (#x477E . #x9EA6)
      (#x4821 . #x51FD)
      (#x4822 . #x7BB1)
      (#x4823 . #x7872)
      (#x4824 . #x7BB8)
      (#x4825 . #x8087)
      (#x4826 . #x7B48)
      (#x4827 . #x6AE8)
      (#x4828 . #x5E61)
      (#x4829 . #x808C)
      (#x482A . #x7551)
      (#x482B . #x7560)
      (#x482C . #x516B)
      (#x482D . #x9262)
      (#x482E . #x6E8C)
      (#x482F . #x767A)
      (#x4830 . #x9197)
      (#x4831 . #x9AEA)
      (#x4832 . #x4F10)
      (#x4833 . #x7F70)
      (#x4834 . #x629C)
      (#x4835 . #x7B4F)
      (#x4836 . #x95A5)
      (#x4837 . #x9CE9)
      (#x4838 . #x567A)
      (#x4839 . #x5859)
      (#x483A . #x86E4)
      (#x483B . #x96BC)
      (#x483C . #x4F34)
      (#x483D . #x5224)
      (#x483E . #x534A)
      (#x483F . #x53CD)
      (#x4840 . #x53DB)
      (#x4841 . #x5E06)
      (#x4842 . #x642C)
      (#x4843 . #x6591)
      (#x4844 . #x677F)
      (#x4845 . #x6C3E)
      (#x4846 . #x6C4E)
      (#x4847 . #x7248)
      (#x4848 . #x72AF)
      (#x4849 . #x73ED)
      (#x484A . #x7554)
      (#x484B . #x7E41)
      (#x484C . #x822C)
      (#x484D . #x85E9)
      (#x484E . #x8CA9)
      (#x484F . #x7BC4)
      (#x4850 . #x91C6)
      (#x4851 . #x7169)
      (#x4852 . #x9812)
      (#x4853 . #x98EF)
      (#x4854 . #x633D)
      (#x4855 . #x6669)
      (#x4856 . #x756A)
      (#x4857 . #x76E4)
      (#x4858 . #x78D0)
      (#x4859 . #x8543)
      (#x485A . #x86EE)
      (#x485B . #x532A)
      (#x485C . #x5351)
      (#x485D . #x5426)
      (#x485E . #x5983)
      (#x485F . #x5E87)
      (#x4860 . #x5F7C)
      (#x4861 . #x60B2)
      (#x4862 . #x6249)
      (#x4863 . #x6279)
      (#x4864 . #x62AB)
      (#x4865 . #x6590)
      (#x4866 . #x6BD4)
      (#x4867 . #x6CCC)
      (#x4868 . #x75B2)
      (#x4869 . #x76AE)
      (#x486A . #x7891)
      (#x486B . #x79D8)
      (#x486C . #x7DCB)
      (#x486D . #x7F77)
      (#x486E . #x80A5)
      (#x486F . #x88AB)
      (#x4870 . #x8AB9)
      (#x4871 . #x8CBB)
      (#x4872 . #x907F)
      (#x4873 . #x975E)
      (#x4874 . #x98DB)
      (#x4875 . #x6A0B)
      (#x4876 . #x7C38)
      (#x4877 . #x5099)
      (#x4878 . #x5C3E)
      (#x4879 . #x5FAE)
      (#x487A . #x6787)
      (#x487B . #x6BD8)
      (#x487C . #x7435)
      (#x487D . #x7709)
      (#x487E . #x7F8E)
      (#x4921 . #x9F3B)
      (#x4922 . #x67CA)
      (#x4923 . #x7A17)
      (#x4924 . #x5339)
      (#x4925 . #x758B)
      (#x4926 . #x9AED)
      (#x4927 . #x5F66)
      (#x4928 . #x819D)
      (#x4929 . #x83F1)
      (#x492A . #x8098)
      (#x492B . #x5F3C)
      (#x492C . #x5FC5)
      (#x492D . #x7562)
      (#x492E . #x7B46)
      (#x492F . #x903C)
      (#x4930 . #x6867)
      (#x4931 . #x59EB)
      (#x4932 . #x5A9B)
      (#x4933 . #x7D10)
      (#x4934 . #x767E)
      (#x4935 . #x8B2C)
      (#x4936 . #x4FF5)
      (#x4937 . #x5F6A)
      (#x4938 . #x6A19)
      (#x4939 . #x6C37)
      (#x493A . #x6F02)
      (#x493B . #x74E2)
      (#x493C . #x7968)
      (#x493D . #x8868)
      (#x493E . #x8A55)
      (#x493F . #x8C79)
      (#x4940 . #x5EDF)
      (#x4941 . #x63CF)
      (#x4942 . #x75C5)
      (#x4943 . #x79D2)
      (#x4944 . #x82D7)
      (#x4945 . #x9328)
      (#x4946 . #x92F2)
      (#x4947 . #x849C)
      (#x4948 . #x86ED)
      (#x4949 . #x9C2D)
      (#x494A . #x54C1)
      (#x494B . #x5F6C)
      (#x494C . #x658C)
      (#x494D . #x6D5C)
      (#x494E . #x7015)
      (#x494F . #x8CA7)
      (#x4950 . #x8CD3)
      (#x4951 . #x983B)
      (#x4952 . #x654F)
      (#x4953 . #x74F6)
      (#x4954 . #x4E0D)
      (#x4955 . #x4ED8)
      (#x4956 . #x57E0)
      (#x4957 . #x592B)
      (#x4958 . #x5A66)
      (#x4959 . #x5BCC)
      (#x495A . #x51A8)
      (#x495B . #x5E03)
      (#x495C . #x5E9C)
      (#x495D . #x6016)
      (#x495E . #x6276)
      (#x495F . #x6577)
      (#x4960 . #x65A7)
      (#x4961 . #x666E)
      (#x4962 . #x6D6E)
      (#x4963 . #x7236)
      (#x4964 . #x7B26)
      (#x4965 . #x8150)
      (#x4966 . #x819A)
      (#x4967 . #x8299)
      (#x4968 . #x8B5C)
      (#x4969 . #x8CA0)
      (#x496A . #x8CE6)
      (#x496B . #x8D74)
      (#x496C . #x961C)
      (#x496D . #x9644)
      (#x496E . #x4FAE)
      (#x496F . #x64AB)
      (#x4970 . #x6B66)
      (#x4971 . #x821E)
      (#x4972 . #x8461)
      (#x4973 . #x856A)
      (#x4974 . #x90E8)
      (#x4975 . #x5C01)
      (#x4976 . #x6953)
      (#x4977 . #x98A8)
      (#x4978 . #x847A)
      (#x4979 . #x8557)
      (#x497A . #x4F0F)
      (#x497B . #x526F)
      (#x497C . #x5FA9)
      (#x497D . #x5E45)
      (#x497E . #x670D)
      (#x4A21 . #x798F)
      (#x4A22 . #x8179)
      (#x4A23 . #x8907)
      (#x4A24 . #x8986)
      (#x4A25 . #x6DF5)
      (#x4A26 . #x5F17)
      (#x4A27 . #x6255)
      (#x4A28 . #x6CB8)
      (#x4A29 . #x4ECF)
      (#x4A2A . #x7269)
      (#x4A2B . #x9B92)
      (#x4A2C . #x5206)
      (#x4A2D . #x543B)
      (#x4A2E . #x5674)
      (#x4A2F . #x58B3)
      (#x4A30 . #x61A4)
      (#x4A31 . #x626E)
      (#x4A32 . #x711A)
      (#x4A33 . #x596E)
      (#x4A34 . #x7C89)
      (#x4A35 . #x7CDE)
      (#x4A36 . #x7D1B)
      (#x4A37 . #x96F0)
      (#x4A38 . #x6587)
      (#x4A39 . #x805E)
      (#x4A3A . #x4E19)
      (#x4A3B . #x4F75)
      (#x4A3C . #x5175)
      (#x4A3D . #x5840)
      (#x4A3E . #x5E63)
      (#x4A3F . #x5E73)
      (#x4A40 . #x5F0A)
      (#x4A41 . #x67C4)
      (#x4A42 . #x4E26)
      (#x4A43 . #x853D)
      (#x4A44 . #x9589)
      (#x4A45 . #x965B)
      (#x4A46 . #x7C73)
      (#x4A47 . #x9801)
      (#x4A48 . #x50FB)
      (#x4A49 . #x58C1)
      (#x4A4A . #x7656)
      (#x4A4B . #x78A7)
      (#x4A4C . #x5225)
      (#x4A4D . #x77A5)
      (#x4A4E . #x8511)
      (#x4A4F . #x7B86)
      (#x4A50 . #x504F)
      (#x4A51 . #x5909)
      (#x4A52 . #x7247)
      (#x4A53 . #x7BC7)
      (#x4A54 . #x7DE8)
      (#x4A55 . #x8FBA)
      (#x4A56 . #x8FD4)
      (#x4A57 . #x904D)
      (#x4A58 . #x4FBF)
      (#x4A59 . #x52C9)
      (#x4A5A . #x5A29)
      (#x4A5B . #x5F01)
      (#x4A5C . #x97AD)
      (#x4A5D . #x4FDD)
      (#x4A5E . #x8217)
      (#x4A5F . #x92EA)
      (#x4A60 . #x5703)
      (#x4A61 . #x6355)
      (#x4A62 . #x6B69)
      (#x4A63 . #x752B)
      (#x4A64 . #x88DC)
      (#x4A65 . #x8F14)
      (#x4A66 . #x7A42)
      (#x4A67 . #x52DF)
      (#x4A68 . #x5893)
      (#x4A69 . #x6155)
      (#x4A6A . #x620A)
      (#x4A6B . #x66AE)
      (#x4A6C . #x6BCD)
      (#x4A6D . #x7C3F)
      (#x4A6E . #x83E9)
      (#x4A6F . #x5023)
      (#x4A70 . #x4FF8)
      (#x4A71 . #x5305)
      (#x4A72 . #x5446)
      (#x4A73 . #x5831)
      (#x4A74 . #x5949)
      (#x4A75 . #x5B9D)
      (#x4A76 . #x5CF0)
      (#x4A77 . #x5CEF)
      (#x4A78 . #x5D29)
      (#x4A79 . #x5E96)
      (#x4A7A . #x62B1)
      (#x4A7B . #x6367)
      (#x4A7C . #x653E)
      (#x4A7D . #x65B9)
      (#x4A7E . #x670B)
      (#x4B21 . #x6CD5)
      (#x4B22 . #x6CE1)
      (#x4B23 . #x70F9)
      (#x4B24 . #x7832)
      (#x4B25 . #x7E2B)
      (#x4B26 . #x80DE)
      (#x4B27 . #x82B3)
      (#x4B28 . #x840C)
      (#x4B29 . #x84EC)
      (#x4B2A . #x8702)
      (#x4B2B . #x8912)
      (#x4B2C . #x8A2A)
      (#x4B2D . #x8C4A)
      (#x4B2E . #x90A6)
      (#x4B2F . #x92D2)
      (#x4B30 . #x98FD)
      (#x4B31 . #x9CF3)
      (#x4B32 . #x9D6C)
      (#x4B33 . #x4E4F)
      (#x4B34 . #x4EA1)
      (#x4B35 . #x508D)
      (#x4B36 . #x5256)
      (#x4B37 . #x574A)
      (#x4B38 . #x59A8)
      (#x4B39 . #x5E3D)
      (#x4B3A . #x5FD8)
      (#x4B3B . #x5FD9)
      (#x4B3C . #x623F)
      (#x4B3D . #x66B4)
      (#x4B3E . #x671B)
      (#x4B3F . #x67D0)
      (#x4B40 . #x68D2)
      (#x4B41 . #x5192)
      (#x4B42 . #x7D21)
      (#x4B43 . #x80AA)
      (#x4B44 . #x81A8)
      (#x4B45 . #x8B00)
      (#x4B46 . #x8C8C)
      (#x4B47 . #x8CBF)
      (#x4B48 . #x927E)
      (#x4B49 . #x9632)
      (#x4B4A . #x5420)
      (#x4B4B . #x982C)
      (#x4B4C . #x5317)
      (#x4B4D . #x50D5)
      (#x4B4E . #x535C)
      (#x4B4F . #x58A8)
      (#x4B50 . #x64B2)
      (#x4B51 . #x6734)
      (#x4B52 . #x7267)
      (#x4B53 . #x7766)
      (#x4B54 . #x7A46)
      (#x4B55 . #x91E6)
      (#x4B56 . #x52C3)
      (#x4B57 . #x6CA1)
      (#x4B58 . #x6B86)
      (#x4B59 . #x5800)
      (#x4B5A . #x5E4C)
      (#x4B5B . #x5954)
      (#x4B5C . #x672C)
      (#x4B5D . #x7FFB)
      (#x4B5E . #x51E1)
      (#x4B5F . #x76C6)
      (#x4B60 . #x6469)
      (#x4B61 . #x78E8)
      (#x4B62 . #x9B54)
      (#x4B63 . #x9EBB)
      (#x4B64 . #x57CB)
      (#x4B65 . #x59B9)
      (#x4B66 . #x6627)
      (#x4B67 . #x679A)
      (#x4B68 . #x6BCE)
      (#x4B69 . #x54E9)
      (#x4B6A . #x69D9)
      (#x4B6B . #x5E55)
      (#x4B6C . #x819C)
      (#x4B6D . #x6795)
      (#x4B6E . #x9BAA)
      (#x4B6F . #x67FE)
      (#x4B70 . #x9C52)
      (#x4B71 . #x685D)
      (#x4B72 . #x4EA6)
      (#x4B73 . #x4FE3)
      (#x4B74 . #x53C8)
      (#x4B75 . #x62B9)
      (#x4B76 . #x672B)
      (#x4B77 . #x6CAB)
      (#x4B78 . #x8FC4)
      (#x4B79 . #x4FAD)
      (#x4B7A . #x7E6D)
      (#x4B7B . #x9EBF)
      (#x4B7C . #x4E07)
      (#x4B7D . #x6162)
      (#x4B7E . #x6E80)
      (#x4C21 . #x6F2B)
      (#x4C22 . #x8513)
      (#x4C23 . #x5473)
      (#x4C24 . #x672A)
      (#x4C25 . #x9B45)
      (#x4C26 . #x5DF3)
      (#x4C27 . #x7B95)
      (#x4C28 . #x5CAC)
      (#x4C29 . #x5BC6)
      (#x4C2A . #x871C)
      (#x4C2B . #x6E4A)
      (#x4C2C . #x84D1)
      (#x4C2D . #x7A14)
      (#x4C2E . #x8108)
      (#x4C2F . #x5999)
      (#x4C30 . #x7C8D)
      (#x4C31 . #x6C11)
      (#x4C32 . #x7720)
      (#x4C33 . #x52D9)
      (#x4C34 . #x5922)
      (#x4C35 . #x7121)
      (#x4C36 . #x725F)
      (#x4C37 . #x77DB)
      (#x4C38 . #x9727)
      (#x4C39 . #x9D61)
      (#x4C3A . #x690B)
      (#x4C3B . #x5A7F)
      (#x4C3C . #x5A18)
      (#x4C3D . #x51A5)
      (#x4C3E . #x540D)
      (#x4C3F . #x547D)
      (#x4C40 . #x660E)
      (#x4C41 . #x76DF)
      (#x4C42 . #x8FF7)
      (#x4C43 . #x9298)
      (#x4C44 . #x9CF4)
      (#x4C45 . #x59EA)
      (#x4C46 . #x725D)
      (#x4C47 . #x6EC5)
      (#x4C48 . #x514D)
      (#x4C49 . #x68C9)
      (#x4C4A . #x7DBF)
      (#x4C4B . #x7DEC)
      (#x4C4C . #x9762)
      (#x4C4D . #x9EBA)
      (#x4C4E . #x6478)
      (#x4C4F . #x6A21)
      (#x4C50 . #x8302)
      (#x4C51 . #x5984)
      (#x4C52 . #x5B5F)
      (#x4C53 . #x6BDB)
      (#x4C54 . #x731B)
      (#x4C55 . #x76F2)
      (#x4C56 . #x7DB2)
      (#x4C57 . #x8017)
      (#x4C58 . #x8499)
      (#x4C59 . #x5132)
      (#x4C5A . #x6728)
      (#x4C5B . #x9ED9)
      (#x4C5C . #x76EE)
      (#x4C5D . #x6762)
      (#x4C5E . #x52FF)
      (#x4C5F . #x9905)
      (#x4C60 . #x5C24)
      (#x4C61 . #x623B)
      (#x4C62 . #x7C7E)
      (#x4C63 . #x8CB0)
      (#x4C64 . #x554F)
      (#x4C65 . #x60B6)
      (#x4C66 . #x7D0B)
      (#x4C67 . #x9580)
      (#x4C68 . #x5301)
      (#x4C69 . #x4E5F)
      (#x4C6A . #x51B6)
      (#x4C6B . #x591C)
      (#x4C6C . #x723A)
      (#x4C6D . #x8036)
      (#x4C6E . #x91CE)
      (#x4C6F . #x5F25)
      (#x4C70 . #x77E2)
      (#x4C71 . #x5384)
      (#x4C72 . #x5F79)
      (#x4C73 . #x7D04)
      (#x4C74 . #x85AC)
      (#x4C75 . #x8A33)
      (#x4C76 . #x8E8D)
      (#x4C77 . #x9756)
      (#x4C78 . #x67F3)
      (#x4C79 . #x85AE)
      (#x4C7A . #x9453)
      (#x4C7B . #x6109)
      (#x4C7C . #x6108)
      (#x4C7D . #x6CB9)
      (#x4C7E . #x7652)
      (#x4D21 . #x8AED)
      (#x4D22 . #x8F38)
      (#x4D23 . #x552F)
      (#x4D24 . #x4F51)
      (#x4D25 . #x512A)
      (#x4D26 . #x52C7)
      (#x4D27 . #x53CB)
      (#x4D28 . #x5BA5)
      (#x4D29 . #x5E7D)
      (#x4D2A . #x60A0)
      (#x4D2B . #x6182)
      (#x4D2C . #x63D6)
      (#x4D2D . #x6709)
      (#x4D2E . #x67DA)
      (#x4D2F . #x6E67)
      (#x4D30 . #x6D8C)
      (#x4D31 . #x7336)
      (#x4D32 . #x7337)
      (#x4D33 . #x7531)
      (#x4D34 . #x7950)
      (#x4D35 . #x88D5)
      (#x4D36 . #x8A98)
      (#x4D37 . #x904A)
      (#x4D38 . #x9091)
      (#x4D39 . #x90F5)
      (#x4D3A . #x96C4)
      (#x4D3B . #x878D)
      (#x4D3C . #x5915)
      (#x4D3D . #x4E88)
      (#x4D3E . #x4F59)
      (#x4D3F . #x4E0E)
      (#x4D40 . #x8A89)
      (#x4D41 . #x8F3F)
      (#x4D42 . #x9810)
      (#x4D43 . #x50AD)
      (#x4D44 . #x5E7C)
      (#x4D45 . #x5996)
      (#x4D46 . #x5BB9)
      (#x4D47 . #x5EB8)
      (#x4D48 . #x63DA)
      (#x4D49 . #x63FA)
      (#x4D4A . #x64C1)
      (#x4D4B . #x66DC)
      (#x4D4C . #x694A)
      (#x4D4D . #x69D8)
      (#x4D4E . #x6D0B)
      (#x4D4F . #x6EB6)
      (#x4D50 . #x7194)
      (#x4D51 . #x7528)
      (#x4D52 . #x7AAF)
      (#x4D53 . #x7F8A)
      (#x4D54 . #x8000)
      (#x4D55 . #x8449)
      (#x4D56 . #x84C9)
      (#x4D57 . #x8981)
      (#x4D58 . #x8B21)
      (#x4D59 . #x8E0A)
      (#x4D5A . #x9065)
      (#x4D5B . #x967D)
      (#x4D5C . #x990A)
      (#x4D5D . #x617E)
      (#x4D5E . #x6291)
      (#x4D5F . #x6B32)
      (#x4D60 . #x6C83)
      (#x4D61 . #x6D74)
      (#x4D62 . #x7FCC)
      (#x4D63 . #x7FFC)
      (#x4D64 . #x6DC0)
      (#x4D65 . #x7F85)
      (#x4D66 . #x87BA)
      (#x4D67 . #x88F8)
      (#x4D68 . #x6765)
      (#x4D69 . #x83B1)
      (#x4D6A . #x983C)
      (#x4D6B . #x96F7)
      (#x4D6C . #x6D1B)
      (#x4D6D . #x7D61)
      (#x4D6E . #x843D)
      (#x4D6F . #x916A)
      (#x4D70 . #x4E71)
      (#x4D71 . #x5375)
      (#x4D72 . #x5D50)
      (#x4D73 . #x6B04)
      (#x4D74 . #x6FEB)
      (#x4D75 . #x85CD)
      (#x4D76 . #x862D)
      (#x4D77 . #x89A7)
      (#x4D78 . #x5229)
      (#x4D79 . #x540F)
      (#x4D7A . #x5C65)
      (#x4D7B . #x674E)
      (#x4D7C . #x68A8)
      (#x4D7D . #x7406)
      (#x4D7E . #x7483)
      (#x4E21 . #x75E2)
      (#x4E22 . #x88CF)
      (#x4E23 . #x88E1)
      (#x4E24 . #x91CC)
      (#x4E25 . #x96E2)
      (#x4E26 . #x9678)
      (#x4E27 . #x5F8B)
      (#x4E28 . #x7387)
      (#x4E29 . #x7ACB)
      (#x4E2A . #x844E)
      (#x4E2B . #x63A0)
      (#x4E2C . #x7565)
      (#x4E2D . #x5289)
      (#x4E2E . #x6D41)
      (#x4E2F . #x6E9C)
      (#x4E30 . #x7409)
      (#x4E31 . #x7559)
      (#x4E32 . #x786B)
      (#x4E33 . #x7C92)
      (#x4E34 . #x9686)
      (#x4E35 . #x7ADC)
      (#x4E36 . #x9F8D)
      (#x4E37 . #x4FB6)
      (#x4E38 . #x616E)
      (#x4E39 . #x65C5)
      (#x4E3A . #x865C)
      (#x4E3B . #x4E86)
      (#x4E3C . #x4EAE)
      (#x4E3D . #x50DA)
      (#x4E3E . #x4E21)
      (#x4E3F . #x51CC)
      (#x4E40 . #x5BEE)
      (#x4E41 . #x6599)
      (#x4E42 . #x6881)
      (#x4E43 . #x6DBC)
      (#x4E44 . #x731F)
      (#x4E45 . #x7642)
      (#x4E46 . #x77AD)
      (#x4E47 . #x7A1C)
      (#x4E48 . #x7CE7)
      (#x4E49 . #x826F)
      (#x4E4A . #x8AD2)
      (#x4E4B . #x907C)
      (#x4E4C . #x91CF)
      (#x4E4D . #x9675)
      (#x4E4E . #x9818)
      (#x4E4F . #x529B)
      (#x4E50 . #x7DD1)
      (#x4E51 . #x502B)
      (#x4E52 . #x5398)
      (#x4E53 . #x6797)
      (#x4E54 . #x6DCB)
      (#x4E55 . #x71D0)
      (#x4E56 . #x7433)
      (#x4E57 . #x81E8)
      (#x4E58 . #x8F2A)
      (#x4E59 . #x96A3)
      (#x4E5A . #x9C57)
      (#x4E5B . #x9E9F)
      (#x4E5C . #x7460)
      (#x4E5D . #x5841)
      (#x4E5E . #x6D99)
      (#x4E5F . #x7D2F)
      (#x4E60 . #x985E)
      (#x4E61 . #x4EE4)
      (#x4E62 . #x4F36)
      (#x4E63 . #x4F8B)
      (#x4E64 . #x51B7)
      (#x4E65 . #x52B1)
      (#x4E66 . #x5DBA)
      (#x4E67 . #x601C)
      (#x4E68 . #x73B2)
      (#x4E69 . #x793C)
      (#x4E6A . #x82D3)
      (#x4E6B . #x9234)
      (#x4E6C . #x96B7)
      (#x4E6D . #x96F6)
      (#x4E6E . #x970A)
      (#x4E6F . #x9E97)
      (#x4E70 . #x9F62)
      (#x4E71 . #x66A6)
      (#x4E72 . #x6B74)
      (#x4E73 . #x5217)
      (#x4E74 . #x52A3)
      (#x4E75 . #x70C8)
      (#x4E76 . #x88C2)
      (#x4E77 . #x5EC9)
      (#x4E78 . #x604B)
      (#x4E79 . #x6190)
      (#x4E7A . #x6F23)
      (#x4E7B . #x7149)
      (#x4E7C . #x7C3E)
      (#x4E7D . #x7DF4)
      (#x4E7E . #x806F)
      (#x4F21 . #x84EE)
      (#x4F22 . #x9023)
      (#x4F23 . #x932C)
      (#x4F24 . #x5442)
      (#x4F25 . #x9B6F)
      (#x4F26 . #x6AD3)
      (#x4F27 . #x7089)
      (#x4F28 . #x8CC2)
      (#x4F29 . #x8DEF)
      (#x4F2A . #x9732)
      (#x4F2B . #x52B4)
      (#x4F2C . #x5A41)
      (#x4F2D . #x5ECA)
      (#x4F2E . #x5F04)
      (#x4F2F . #x6717)
      (#x4F30 . #x697C)
      (#x4F31 . #x6994)
      (#x4F32 . #x6D6A)
      (#x4F33 . #x6F0F)
      (#x4F34 . #x7262)
      (#x4F35 . #x72FC)
      (#x4F36 . #x7BED)
      (#x4F37 . #x8001)
      (#x4F38 . #x807E)
      (#x4F39 . #x874B)
      (#x4F3A . #x90CE)
      (#x4F3B . #x516D)
      (#x4F3C . #x9E93)
      (#x4F3D . #x7984)
      (#x4F3E . #x808B)
      (#x4F3F . #x9332)
      (#x4F40 . #x8AD6)
      (#x4F41 . #x502D)
      (#x4F42 . #x548C)
      (#x4F43 . #x8A71)
      (#x4F44 . #x6B6A)
      (#x4F45 . #x8CC4)
      (#x4F46 . #x8107)
      (#x4F47 . #x60D1)
      (#x4F48 . #x67A0)
      (#x4F49 . #x9DF2)
      (#x4F4A . #x4E99)
      (#x4F4B . #x4E98)
      (#x4F4C . #x9C10)
      (#x4F4D . #x8A6B)
      (#x4F4E . #x85C1)
      (#x4F4F . #x8568)
      (#x4F50 . #x6900)
      (#x4F51 . #x6E7E)
      (#x4F52 . #x7897)
      (#x4F53 . #x8155)
      (#x5021 . #x5F0C)
      (#x5022 . #x4E10)
      (#x5023 . #x4E15)
      (#x5024 . #x4E2A)
      (#x5025 . #x4E31)
      (#x5026 . #x4E36)
      (#x5027 . #x4E3C)
      (#x5028 . #x4E3F)
      (#x5029 . #x4E42)
      (#x502A . #x4E56)
      (#x502B . #x4E58)
      (#x502C . #x4E82)
      (#x502D . #x4E85)
      (#x502E . #x8C6B)
      (#x502F . #x4E8A)
      (#x5030 . #x8212)
      (#x5031 . #x5F0D)
      (#x5032 . #x4E8E)
      (#x5033 . #x4E9E)
      (#x5034 . #x4E9F)
      (#x5035 . #x4EA0)
      (#x5036 . #x4EA2)
      (#x5037 . #x4EB0)
      (#x5038 . #x4EB3)
      (#x5039 . #x4EB6)
      (#x503A . #x4ECE)
      (#x503B . #x4ECD)
      (#x503C . #x4EC4)
      (#x503D . #x4EC6)
      (#x503E . #x4EC2)
      (#x503F . #x4ED7)
      (#x5040 . #x4EDE)
      (#x5041 . #x4EED)
      (#x5042 . #x4EDF)
      (#x5043 . #x4EF7)
      (#x5044 . #x4F09)
      (#x5045 . #x4F5A)
      (#x5046 . #x4F30)
      (#x5047 . #x4F5B)
      (#x5048 . #x4F5D)
      (#x5049 . #x4F57)
      (#x504A . #x4F47)
      (#x504B . #x4F76)
      (#x504C . #x4F88)
      (#x504D . #x4F8F)
      (#x504E . #x4F98)
      (#x504F . #x4F7B)
      (#x5050 . #x4F69)
      (#x5051 . #x4F70)
      (#x5052 . #x4F91)
      (#x5053 . #x4F6F)
      (#x5054 . #x4F86)
      (#x5055 . #x4F96)
      (#x5056 . #x5118)
      (#x5057 . #x4FD4)
      (#x5058 . #x4FDF)
      (#x5059 . #x4FCE)
      (#x505A . #x4FD8)
      (#x505B . #x4FDB)
      (#x505C . #x4FD1)
      (#x505D . #x4FDA)
      (#x505E . #x4FD0)
      (#x505F . #x4FE4)
      (#x5060 . #x4FE5)
      (#x5061 . #x501A)
      (#x5062 . #x5028)
      (#x5063 . #x5014)
      (#x5064 . #x502A)
      (#x5065 . #x5025)
      (#x5066 . #x5005)
      (#x5067 . #x4F1C)
      (#x5068 . #x4FF6)
      (#x5069 . #x5021)
      (#x506A . #x5029)
      (#x506B . #x502C)
      (#x506C . #x4FFE)
      (#x506D . #x4FEF)
      (#x506E . #x5011)
      (#x506F . #x5006)
      (#x5070 . #x5043)
      (#x5071 . #x5047)
      (#x5072 . #x6703)
      (#x5073 . #x5055)
      (#x5074 . #x5050)
      (#x5075 . #x5048)
      (#x5076 . #x505A)
      (#x5077 . #x5056)
      (#x5078 . #x506C)
      (#x5079 . #x5078)
      (#x507A . #x5080)
      (#x507B . #x509A)
      (#x507C . #x5085)
      (#x507D . #x50B4)
      (#x507E . #x50B2)
      (#x5121 . #x50C9)
      (#x5122 . #x50CA)
      (#x5123 . #x50B3)
      (#x5124 . #x50C2)
      (#x5125 . #x50D6)
      (#x5126 . #x50DE)
      (#x5127 . #x50E5)
      (#x5128 . #x50ED)
      (#x5129 . #x50E3)
      (#x512A . #x50EE)
      (#x512B . #x50F9)
      (#x512C . #x50F5)
      (#x512D . #x5109)
      (#x512E . #x5101)
      (#x512F . #x5102)
      (#x5130 . #x5116)
      (#x5131 . #x5115)
      (#x5132 . #x5114)
      (#x5133 . #x511A)
      (#x5134 . #x5121)
      (#x5135 . #x513A)
      (#x5136 . #x5137)
      (#x5137 . #x513C)
      (#x5138 . #x513B)
      (#x5139 . #x513F)
      (#x513A . #x5140)
      (#x513B . #x5152)
      (#x513C . #x514C)
      (#x513D . #x5154)
      (#x513E . #x5162)
      (#x513F . #x7AF8)
      (#x5140 . #x5169)
      (#x5141 . #x516A)
      (#x5142 . #x516E)
      (#x5143 . #x5180)
      (#x5144 . #x5182)
      (#x5145 . #x56D8)
      (#x5146 . #x518C)
      (#x5147 . #x5189)
      (#x5148 . #x518F)
      (#x5149 . #x5191)
      (#x514A . #x5193)
      (#x514B . #x5195)
      (#x514C . #x5196)
      (#x514D . #x51A4)
      (#x514E . #x51A6)
      (#x514F . #x51A2)
      (#x5150 . #x51A9)
      (#x5151 . #x51AA)
      (#x5152 . #x51AB)
      (#x5153 . #x51B3)
      (#x5154 . #x51B1)
      (#x5155 . #x51B2)
      (#x5156 . #x51B0)
      (#x5157 . #x51B5)
      (#x5158 . #x51BD)
      (#x5159 . #x51C5)
      (#x515A . #x51C9)
      (#x515B . #x51DB)
      (#x515C . #x51E0)
      (#x515D . #x8655)
      (#x515E . #x51E9)
      (#x515F . #x51ED)
      (#x5160 . #x51F0)
      (#x5161 . #x51F5)
      (#x5162 . #x51FE)
      (#x5163 . #x5204)
      (#x5164 . #x520B)
      (#x5165 . #x5214)
      (#x5166 . #x520E)
      (#x5167 . #x5227)
      (#x5168 . #x522A)
      (#x5169 . #x522E)
      (#x516A . #x5233)
      (#x516B . #x5239)
      (#x516C . #x524F)
      (#x516D . #x5244)
      (#x516E . #x524B)
      (#x516F . #x524C)
      (#x5170 . #x525E)
      (#x5171 . #x5254)
      (#x5172 . #x526A)
      (#x5173 . #x5274)
      (#x5174 . #x5269)
      (#x5175 . #x5273)
      (#x5176 . #x527F)
      (#x5177 . #x527D)
      (#x5178 . #x528D)
      (#x5179 . #x5294)
      (#x517A . #x5292)
      (#x517B . #x5271)
      (#x517C . #x5288)
      (#x517D . #x5291)
      (#x517E . #x8FA8)
      (#x5221 . #x8FA7)
      (#x5222 . #x52AC)
      (#x5223 . #x52AD)
      (#x5224 . #x52BC)
      (#x5225 . #x52B5)
      (#x5226 . #x52C1)
      (#x5227 . #x52CD)
      (#x5228 . #x52D7)
      (#x5229 . #x52DE)
      (#x522A . #x52E3)
      (#x522B . #x52E6)
      (#x522C . #x98ED)
      (#x522D . #x52E0)
      (#x522E . #x52F3)
      (#x522F . #x52F5)
      (#x5230 . #x52F8)
      (#x5231 . #x52F9)
      (#x5232 . #x5306)
      (#x5233 . #x5308)
      (#x5234 . #x7538)
      (#x5235 . #x530D)
      (#x5236 . #x5310)
      (#x5237 . #x530F)
      (#x5238 . #x5315)
      (#x5239 . #x531A)
      (#x523A . #x5323)
      (#x523B . #x532F)
      (#x523C . #x5331)
      (#x523D . #x5333)
      (#x523E . #x5338)
      (#x523F . #x5340)
      (#x5240 . #x5346)
      (#x5241 . #x5345)
      (#x5242 . #x4E17)
      (#x5243 . #x5349)
      (#x5244 . #x534D)
      (#x5245 . #x51D6)
      (#x5246 . #x535E)
      (#x5247 . #x5369)
      (#x5248 . #x536E)
      (#x5249 . #x5918)
      (#x524A . #x537B)
      (#x524B . #x5377)
      (#x524C . #x5382)
      (#x524D . #x5396)
      (#x524E . #x53A0)
      (#x524F . #x53A6)
      (#x5250 . #x53A5)
      (#x5251 . #x53AE)
      (#x5252 . #x53B0)
      (#x5253 . #x53B6)
      (#x5254 . #x53C3)
      (#x5255 . #x7C12)
      (#x5256 . #x96D9)
      (#x5257 . #x53DF)
      (#x5258 . #x66FC)
      (#x5259 . #x71EE)
      (#x525A . #x53EE)
      (#x525B . #x53E8)
      (#x525C . #x53ED)
      (#x525D . #x53FA)
      (#x525E . #x5401)
      (#x525F . #x543D)
      (#x5260 . #x5440)
      (#x5261 . #x542C)
      (#x5262 . #x542D)
      (#x5263 . #x543C)
      (#x5264 . #x542E)
      (#x5265 . #x5436)
      (#x5266 . #x5429)
      (#x5267 . #x541D)
      (#x5268 . #x544E)
      (#x5269 . #x548F)
      (#x526A . #x5475)
      (#x526B . #x548E)
      (#x526C . #x545F)
      (#x526D . #x5471)
      (#x526E . #x5477)
      (#x526F . #x5470)
      (#x5270 . #x5492)
      (#x5271 . #x547B)
      (#x5272 . #x5480)
      (#x5273 . #x5476)
      (#x5274 . #x5484)
      (#x5275 . #x5490)
      (#x5276 . #x5486)
      (#x5277 . #x54C7)
      (#x5278 . #x54A2)
      (#x5279 . #x54B8)
      (#x527A . #x54A5)
      (#x527B . #x54AC)
      (#x527C . #x54C4)
      (#x527D . #x54C8)
      (#x527E . #x54A8)
      (#x5321 . #x54AB)
      (#x5322 . #x54C2)
      (#x5323 . #x54A4)
      (#x5324 . #x54BE)
      (#x5325 . #x54BC)
      (#x5326 . #x54D8)
      (#x5327 . #x54E5)
      (#x5328 . #x54E6)
      (#x5329 . #x550F)
      (#x532A . #x5514)
      (#x532B . #x54FD)
      (#x532C . #x54EE)
      (#x532D . #x54ED)
      (#x532E . #x54FA)
      (#x532F . #x54E2)
      (#x5330 . #x5539)
      (#x5331 . #x5540)
      (#x5332 . #x5563)
      (#x5333 . #x554C)
      (#x5334 . #x552E)
      (#x5335 . #x555C)
      (#x5336 . #x5545)
      (#x5337 . #x5556)
      (#x5338 . #x5557)
      (#x5339 . #x5538)
      (#x533A . #x5533)
      (#x533B . #x555D)
      (#x533C . #x5599)
      (#x533D . #x5580)
      (#x533E . #x54AF)
      (#x533F . #x558A)
      (#x5340 . #x559F)
      (#x5341 . #x557B)
      (#x5342 . #x557E)
      (#x5343 . #x5598)
      (#x5344 . #x559E)
      (#x5345 . #x55AE)
      (#x5346 . #x557C)
      (#x5347 . #x5583)
      (#x5348 . #x55A9)
      (#x5349 . #x5587)
      (#x534A . #x55A8)
      (#x534B . #x55DA)
      (#x534C . #x55C5)
      (#x534D . #x55DF)
      (#x534E . #x55C4)
      (#x534F . #x55DC)
      (#x5350 . #x55E4)
      (#x5351 . #x55D4)
      (#x5352 . #x5614)
      (#x5353 . #x55F7)
      (#x5354 . #x5616)
      (#x5355 . #x55FE)
      (#x5356 . #x55FD)
      (#x5357 . #x561B)
      (#x5358 . #x55F9)
      (#x5359 . #x564E)
      (#x535A . #x5650)
      (#x535B . #x71DF)
      (#x535C . #x5634)
      (#x535D . #x5636)
      (#x535E . #x5632)
      (#x535F . #x5638)
      (#x5360 . #x566B)
      (#x5361 . #x5664)
      (#x5362 . #x562F)
      (#x5363 . #x566C)
      (#x5364 . #x566A)
      (#x5365 . #x5686)
      (#x5366 . #x5680)
      (#x5367 . #x568A)
      (#x5368 . #x56A0)
      (#x5369 . #x5694)
      (#x536A . #x568F)
      (#x536B . #x56A5)
      (#x536C . #x56AE)
      (#x536D . #x56B6)
      (#x536E . #x56B4)
      (#x536F . #x56C2)
      (#x5370 . #x56BC)
      (#x5371 . #x56C1)
      (#x5372 . #x56C3)
      (#x5373 . #x56C0)
      (#x5374 . #x56C8)
      (#x5375 . #x56CE)
      (#x5376 . #x56D1)
      (#x5377 . #x56D3)
      (#x5378 . #x56D7)
      (#x5379 . #x56EE)
      (#x537A . #x56F9)
      (#x537B . #x5700)
      (#x537C . #x56FF)
      (#x537D . #x5704)
      (#x537E . #x5709)
      (#x5421 . #x5708)
      (#x5422 . #x570B)
      (#x5423 . #x570D)
      (#x5424 . #x5713)
      (#x5425 . #x5718)
      (#x5426 . #x5716)
      (#x5427 . #x55C7)
      (#x5428 . #x571C)
      (#x5429 . #x5726)
      (#x542A . #x5737)
      (#x542B . #x5738)
      (#x542C . #x574E)
      (#x542D . #x573B)
      (#x542E . #x5740)
      (#x542F . #x574F)
      (#x5430 . #x5769)
      (#x5431 . #x57C0)
      (#x5432 . #x5788)
      (#x5433 . #x5761)
      (#x5434 . #x577F)
      (#x5435 . #x5789)
      (#x5436 . #x5793)
      (#x5437 . #x57A0)
      (#x5438 . #x57B3)
      (#x5439 . #x57A4)
      (#x543A . #x57AA)
      (#x543B . #x57B0)
      (#x543C . #x57C3)
      (#x543D . #x57C6)
      (#x543E . #x57D4)
      (#x543F . #x57D2)
      (#x5440 . #x57D3)
      (#x5441 . #x580A)
      (#x5442 . #x57D6)
      (#x5443 . #x57E3)
      (#x5444 . #x580B)
      (#x5445 . #x5819)
      (#x5446 . #x581D)
      (#x5447 . #x5872)
      (#x5448 . #x5821)
      (#x5449 . #x5862)
      (#x544A . #x584B)
      (#x544B . #x5870)
      (#x544C . #x6BC0)
      (#x544D . #x5852)
      (#x544E . #x583D)
      (#x544F . #x5879)
      (#x5450 . #x5885)
      (#x5451 . #x58B9)
      (#x5452 . #x589F)
      (#x5453 . #x58AB)
      (#x5454 . #x58BA)
      (#x5455 . #x58DE)
      (#x5456 . #x58BB)
      (#x5457 . #x58B8)
      (#x5458 . #x58AE)
      (#x5459 . #x58C5)
      (#x545A . #x58D3)
      (#x545B . #x58D1)
      (#x545C . #x58D7)
      (#x545D . #x58D9)
      (#x545E . #x58D8)
      (#x545F . #x58E5)
      (#x5460 . #x58DC)
      (#x5461 . #x58E4)
      (#x5462 . #x58DF)
      (#x5463 . #x58EF)
      (#x5464 . #x58FA)
      (#x5465 . #x58F9)
      (#x5466 . #x58FB)
      (#x5467 . #x58FC)
      (#x5468 . #x58FD)
      (#x5469 . #x5902)
      (#x546A . #x590A)
      (#x546B . #x5910)
      (#x546C . #x591B)
      (#x546D . #x68A6)
      (#x546E . #x5925)
      (#x546F . #x592C)
      (#x5470 . #x592D)
      (#x5471 . #x5932)
      (#x5472 . #x5938)
      (#x5473 . #x593E)
      (#x5474 . #x7AD2)
      (#x5475 . #x5955)
      (#x5476 . #x5950)
      (#x5477 . #x594E)
      (#x5478 . #x595A)
      (#x5479 . #x5958)
      (#x547A . #x5962)
      (#x547B . #x5960)
      (#x547C . #x5967)
      (#x547D . #x596C)
      (#x547E . #x5969)
      (#x5521 . #x5978)
      (#x5522 . #x5981)
      (#x5523 . #x599D)
      (#x5524 . #x4F5E)
      (#x5525 . #x4FAB)
      (#x5526 . #x59A3)
      (#x5527 . #x59B2)
      (#x5528 . #x59C6)
      (#x5529 . #x59E8)
      (#x552A . #x59DC)
      (#x552B . #x598D)
      (#x552C . #x59D9)
      (#x552D . #x59DA)
      (#x552E . #x5A25)
      (#x552F . #x5A1F)
      (#x5530 . #x5A11)
      (#x5531 . #x5A1C)
      (#x5532 . #x5A09)
      (#x5533 . #x5A1A)
      (#x5534 . #x5A40)
      (#x5535 . #x5A6C)
      (#x5536 . #x5A49)
      (#x5537 . #x5A35)
      (#x5538 . #x5A36)
      (#x5539 . #x5A62)
      (#x553A . #x5A6A)
      (#x553B . #x5A9A)
      (#x553C . #x5ABC)
      (#x553D . #x5ABE)
      (#x553E . #x5ACB)
      (#x553F . #x5AC2)
      (#x5540 . #x5ABD)
      (#x5541 . #x5AE3)
      (#x5542 . #x5AD7)
      (#x5543 . #x5AE6)
      (#x5544 . #x5AE9)
      (#x5545 . #x5AD6)
      (#x5546 . #x5AFA)
      (#x5547 . #x5AFB)
      (#x5548 . #x5B0C)
      (#x5549 . #x5B0B)
      (#x554A . #x5B16)
      (#x554B . #x5B32)
      (#x554C . #x5AD0)
      (#x554D . #x5B2A)
      (#x554E . #x5B36)
      (#x554F . #x5B3E)
      (#x5550 . #x5B43)
      (#x5551 . #x5B45)
      (#x5552 . #x5B40)
      (#x5553 . #x5B51)
      (#x5554 . #x5B55)
      (#x5555 . #x5B5A)
      (#x5556 . #x5B5B)
      (#x5557 . #x5B65)
      (#x5558 . #x5B69)
      (#x5559 . #x5B70)
      (#x555A . #x5B73)
      (#x555B . #x5B75)
      (#x555C . #x5B78)
      (#x555D . #x6588)
      (#x555E . #x5B7A)
      (#x555F . #x5B80)
      (#x5560 . #x5B83)
      (#x5561 . #x5BA6)
      (#x5562 . #x5BB8)
      (#x5563 . #x5BC3)
      (#x5564 . #x5BC7)
      (#x5565 . #x5BC9)
      (#x5566 . #x5BD4)
      (#x5567 . #x5BD0)
      (#x5568 . #x5BE4)
      (#x5569 . #x5BE6)
      (#x556A . #x5BE2)
      (#x556B . #x5BDE)
      (#x556C . #x5BE5)
      (#x556D . #x5BEB)
      (#x556E . #x5BF0)
      (#x556F . #x5BF6)
      (#x5570 . #x5BF3)
      (#x5571 . #x5C05)
      (#x5572 . #x5C07)
      (#x5573 . #x5C08)
      (#x5574 . #x5C0D)
      (#x5575 . #x5C13)
      (#x5576 . #x5C20)
      (#x5577 . #x5C22)
      (#x5578 . #x5C28)
      (#x5579 . #x5C38)
      (#x557A . #x5C39)
      (#x557B . #x5C41)
      (#x557C . #x5C46)
      (#x557D . #x5C4E)
      (#x557E . #x5C53)
      (#x5621 . #x5C50)
      (#x5622 . #x5C4F)
      (#x5623 . #x5B71)
      (#x5624 . #x5C6C)
      (#x5625 . #x5C6E)
      (#x5626 . #x4E62)
      (#x5627 . #x5C76)
      (#x5628 . #x5C79)
      (#x5629 . #x5C8C)
      (#x562A . #x5C91)
      (#x562B . #x5C94)
      (#x562C . #x599B)
      (#x562D . #x5CAB)
      (#x562E . #x5CBB)
      (#x562F . #x5CB6)
      (#x5630 . #x5CBC)
      (#x5631 . #x5CB7)
      (#x5632 . #x5CC5)
      (#x5633 . #x5CBE)
      (#x5634 . #x5CC7)
      (#x5635 . #x5CD9)
      (#x5636 . #x5CE9)
      (#x5637 . #x5CFD)
      (#x5638 . #x5CFA)
      (#x5639 . #x5CED)
      (#x563A . #x5D8C)
      (#x563B . #x5CEA)
      (#x563C . #x5D0B)
      (#x563D . #x5D15)
      (#x563E . #x5D17)
      (#x563F . #x5D5C)
      (#x5640 . #x5D1F)
      (#x5641 . #x5D1B)
      (#x5642 . #x5D11)
      (#x5643 . #x5D14)
      (#x5644 . #x5D22)
      (#x5645 . #x5D1A)
      (#x5646 . #x5D19)
      (#x5647 . #x5D18)
      (#x5648 . #x5D4C)
      (#x5649 . #x5D52)
      (#x564A . #x5D4E)
      (#x564B . #x5D4B)
      (#x564C . #x5D6C)
      (#x564D . #x5D73)
      (#x564E . #x5D76)
      (#x564F . #x5D87)
      (#x5650 . #x5D84)
      (#x5651 . #x5D82)
      (#x5652 . #x5DA2)
      (#x5653 . #x5D9D)
      (#x5654 . #x5DAC)
      (#x5655 . #x5DAE)
      (#x5656 . #x5DBD)
      (#x5657 . #x5D90)
      (#x5658 . #x5DB7)
      (#x5659 . #x5DBC)
      (#x565A . #x5DC9)
      (#x565B . #x5DCD)
      (#x565C . #x5DD3)
      (#x565D . #x5DD2)
      (#x565E . #x5DD6)
      (#x565F . #x5DDB)
      (#x5660 . #x5DEB)
      (#x5661 . #x5DF2)
      (#x5662 . #x5DF5)
      (#x5663 . #x5E0B)
      (#x5664 . #x5E1A)
      (#x5665 . #x5E19)
      (#x5666 . #x5E11)
      (#x5667 . #x5E1B)
      (#x5668 . #x5E36)
      (#x5669 . #x5E37)
      (#x566A . #x5E44)
      (#x566B . #x5E43)
      (#x566C . #x5E40)
      (#x566D . #x5E4E)
      (#x566E . #x5E57)
      (#x566F . #x5E54)
      (#x5670 . #x5E5F)
      (#x5671 . #x5E62)
      (#x5672 . #x5E64)
      (#x5673 . #x5E47)
      (#x5674 . #x5E75)
      (#x5675 . #x5E76)
      (#x5676 . #x5E7A)
      (#x5677 . #x9EBC)
      (#x5678 . #x5E7F)
      (#x5679 . #x5EA0)
      (#x567A . #x5EC1)
      (#x567B . #x5EC2)
      (#x567C . #x5EC8)
      (#x567D . #x5ED0)
      (#x567E . #x5ECF)
      (#x5721 . #x5ED6)
      (#x5722 . #x5EE3)
      (#x5723 . #x5EDD)
      (#x5724 . #x5EDA)
      (#x5725 . #x5EDB)
      (#x5726 . #x5EE2)
      (#x5727 . #x5EE1)
      (#x5728 . #x5EE8)
      (#x5729 . #x5EE9)
      (#x572A . #x5EEC)
      (#x572B . #x5EF1)
      (#x572C . #x5EF3)
      (#x572D . #x5EF0)
      (#x572E . #x5EF4)
      (#x572F . #x5EF8)
      (#x5730 . #x5EFE)
      (#x5731 . #x5F03)
      (#x5732 . #x5F09)
      (#x5733 . #x5F5D)
      (#x5734 . #x5F5C)
      (#x5735 . #x5F0B)
      (#x5736 . #x5F11)
      (#x5737 . #x5F16)
      (#x5738 . #x5F29)
      (#x5739 . #x5F2D)
      (#x573A . #x5F38)
      (#x573B . #x5F41)
      (#x573C . #x5F48)
      (#x573D . #x5F4C)
      (#x573E . #x5F4E)
      (#x573F . #x5F2F)
      (#x5740 . #x5F51)
      (#x5741 . #x5F56)
      (#x5742 . #x5F57)
      (#x5743 . #x5F59)
      (#x5744 . #x5F61)
      (#x5745 . #x5F6D)
      (#x5746 . #x5F73)
      (#x5747 . #x5F77)
      (#x5748 . #x5F83)
      (#x5749 . #x5F82)
      (#x574A . #x5F7F)
      (#x574B . #x5F8A)
      (#x574C . #x5F88)
      (#x574D . #x5F91)
      (#x574E . #x5F87)
      (#x574F . #x5F9E)
      (#x5750 . #x5F99)
      (#x5751 . #x5F98)
      (#x5752 . #x5FA0)
      (#x5753 . #x5FA8)
      (#x5754 . #x5FAD)
      (#x5755 . #x5FBC)
      (#x5756 . #x5FD6)
      (#x5757 . #x5FFB)
      (#x5758 . #x5FE4)
      (#x5759 . #x5FF8)
      (#x575A . #x5FF1)
      (#x575B . #x5FDD)
      (#x575C . #x60B3)
      (#x575D . #x5FFF)
      (#x575E . #x6021)
      (#x575F . #x6060)
      (#x5760 . #x6019)
      (#x5761 . #x6010)
      (#x5762 . #x6029)
      (#x5763 . #x600E)
      (#x5764 . #x6031)
      (#x5765 . #x601B)
      (#x5766 . #x6015)
      (#x5767 . #x602B)
      (#x5768 . #x6026)
      (#x5769 . #x600F)
      (#x576A . #x603A)
      (#x576B . #x605A)
      (#x576C . #x6041)
      (#x576D . #x606A)
      (#x576E . #x6077)
      (#x576F . #x605F)
      (#x5770 . #x604A)
      (#x5771 . #x6046)
      (#x5772 . #x604D)
      (#x5773 . #x6063)
      (#x5774 . #x6043)
      (#x5775 . #x6064)
      (#x5776 . #x6042)
      (#x5777 . #x606C)
      (#x5778 . #x606B)
      (#x5779 . #x6059)
      (#x577A . #x6081)
      (#x577B . #x608D)
      (#x577C . #x60E7)
      (#x577D . #x6083)
      (#x577E . #x609A)
      (#x5821 . #x6084)
      (#x5822 . #x609B)
      (#x5823 . #x6096)
      (#x5824 . #x6097)
      (#x5825 . #x6092)
      (#x5826 . #x60A7)
      (#x5827 . #x608B)
      (#x5828 . #x60E1)
      (#x5829 . #x60B8)
      (#x582A . #x60E0)
      (#x582B . #x60D3)
      (#x582C . #x60B4)
      (#x582D . #x5FF0)
      (#x582E . #x60BD)
      (#x582F . #x60C6)
      (#x5830 . #x60B5)
      (#x5831 . #x60D8)
      (#x5832 . #x614D)
      (#x5833 . #x6115)
      (#x5834 . #x6106)
      (#x5835 . #x60F6)
      (#x5836 . #x60F7)
      (#x5837 . #x6100)
      (#x5838 . #x60F4)
      (#x5839 . #x60FA)
      (#x583A . #x6103)
      (#x583B . #x6121)
      (#x583C . #x60FB)
      (#x583D . #x60F1)
      (#x583E . #x610D)
      (#x583F . #x610E)
      (#x5840 . #x6147)
      (#x5841 . #x613E)
      (#x5842 . #x6128)
      (#x5843 . #x6127)
      (#x5844 . #x614A)
      (#x5845 . #x613F)
      (#x5846 . #x613C)
      (#x5847 . #x612C)
      (#x5848 . #x6134)
      (#x5849 . #x613D)
      (#x584A . #x6142)
      (#x584B . #x6144)
      (#x584C . #x6173)
      (#x584D . #x6177)
      (#x584E . #x6158)
      (#x584F . #x6159)
      (#x5850 . #x615A)
      (#x5851 . #x616B)
      (#x5852 . #x6174)
      (#x5853 . #x616F)
      (#x5854 . #x6165)
      (#x5855 . #x6171)
      (#x5856 . #x615F)
      (#x5857 . #x615D)
      (#x5858 . #x6153)
      (#x5859 . #x6175)
      (#x585A . #x6199)
      (#x585B . #x6196)
      (#x585C . #x6187)
      (#x585D . #x61AC)
      (#x585E . #x6194)
      (#x585F . #x619A)
      (#x5860 . #x618A)
      (#x5861 . #x6191)
      (#x5862 . #x61AB)
      (#x5863 . #x61AE)
      (#x5864 . #x61CC)
      (#x5865 . #x61CA)
      (#x5866 . #x61C9)
      (#x5867 . #x61F7)
      (#x5868 . #x61C8)
      (#x5869 . #x61C3)
      (#x586A . #x61C6)
      (#x586B . #x61BA)
      (#x586C . #x61CB)
      (#x586D . #x7F79)
      (#x586E . #x61CD)
      (#x586F . #x61E6)
      (#x5870 . #x61E3)
      (#x5871 . #x61F6)
      (#x5872 . #x61FA)
      (#x5873 . #x61F4)
      (#x5874 . #x61FF)
      (#x5875 . #x61FD)
      (#x5876 . #x61FC)
      (#x5877 . #x61FE)
      (#x5878 . #x6200)
      (#x5879 . #x6208)
      (#x587A . #x6209)
      (#x587B . #x620D)
      (#x587C . #x620C)
      (#x587D . #x6214)
      (#x587E . #x621B)
      (#x5921 . #x621E)
      (#x5922 . #x6221)
      (#x5923 . #x622A)
      (#x5924 . #x622E)
      (#x5925 . #x6230)
      (#x5926 . #x6232)
      (#x5927 . #x6233)
      (#x5928 . #x6241)
      (#x5929 . #x624E)
      (#x592A . #x625E)
      (#x592B . #x6263)
      (#x592C . #x625B)
      (#x592D . #x6260)
      (#x592E . #x6268)
      (#x592F . #x627C)
      (#x5930 . #x6282)
      (#x5931 . #x6289)
      (#x5932 . #x627E)
      (#x5933 . #x6292)
      (#x5934 . #x6293)
      (#x5935 . #x6296)
      (#x5936 . #x62D4)
      (#x5937 . #x6283)
      (#x5938 . #x6294)
      (#x5939 . #x62D7)
      (#x593A . #x62D1)
      (#x593B . #x62BB)
      (#x593C . #x62CF)
      (#x593D . #x62FF)
      (#x593E . #x62C6)
      (#x593F . #x64D4)
      (#x5940 . #x62C8)
      (#x5941 . #x62DC)
      (#x5942 . #x62CC)
      (#x5943 . #x62CA)
      (#x5944 . #x62C2)
      (#x5945 . #x62C7)
      (#x5946 . #x629B)
      (#x5947 . #x62C9)
      (#x5948 . #x630C)
      (#x5949 . #x62EE)
      (#x594A . #x62F1)
      (#x594B . #x6327)
      (#x594C . #x6302)
      (#x594D . #x6308)
      (#x594E . #x62EF)
      (#x594F . #x62F5)
      (#x5950 . #x6350)
      (#x5951 . #x633E)
      (#x5952 . #x634D)
      (#x5953 . #x641C)
      (#x5954 . #x634F)
      (#x5955 . #x6396)
      (#x5956 . #x638E)
      (#x5957 . #x6380)
      (#x5958 . #x63AB)
      (#x5959 . #x6376)
      (#x595A . #x63A3)
      (#x595B . #x638F)
      (#x595C . #x6389)
      (#x595D . #x639F)
      (#x595E . #x63B5)
      (#x595F . #x636B)
      (#x5960 . #x6369)
      (#x5961 . #x63BE)
      (#x5962 . #x63E9)
      (#x5963 . #x63C0)
      (#x5964 . #x63C6)
      (#x5965 . #x63E3)
      (#x5966 . #x63C9)
      (#x5967 . #x63D2)
      (#x5968 . #x63F6)
      (#x5969 . #x63C4)
      (#x596A . #x6416)
      (#x596B . #x6434)
      (#x596C . #x6406)
      (#x596D . #x6413)
      (#x596E . #x6426)
      (#x596F . #x6436)
      (#x5970 . #x651D)
      (#x5971 . #x6417)
      (#x5972 . #x6428)
      (#x5973 . #x640F)
      (#x5974 . #x6467)
      (#x5975 . #x646F)
      (#x5976 . #x6476)
      (#x5977 . #x644E)
      (#x5978 . #x652A)
      (#x5979 . #x6495)
      (#x597A . #x6493)
      (#x597B . #x64A5)
      (#x597C . #x64A9)
      (#x597D . #x6488)
      (#x597E . #x64BC)
      (#x5A21 . #x64DA)
      (#x5A22 . #x64D2)
      (#x5A23 . #x64C5)
      (#x5A24 . #x64C7)
      (#x5A25 . #x64BB)
      (#x5A26 . #x64D8)
      (#x5A27 . #x64C2)
      (#x5A28 . #x64F1)
      (#x5A29 . #x64E7)
      (#x5A2A . #x8209)
      (#x5A2B . #x64E0)
      (#x5A2C . #x64E1)
      (#x5A2D . #x62AC)
      (#x5A2E . #x64E3)
      (#x5A2F . #x64EF)
      (#x5A30 . #x652C)
      (#x5A31 . #x64F6)
      (#x5A32 . #x64F4)
      (#x5A33 . #x64F2)
      (#x5A34 . #x64FA)
      (#x5A35 . #x6500)
      (#x5A36 . #x64FD)
      (#x5A37 . #x6518)
      (#x5A38 . #x651C)
      (#x5A39 . #x6505)
      (#x5A3A . #x6524)
      (#x5A3B . #x6523)
      (#x5A3C . #x652B)
      (#x5A3D . #x6534)
      (#x5A3E . #x6535)
      (#x5A3F . #x6537)
      (#x5A40 . #x6536)
      (#x5A41 . #x6538)
      (#x5A42 . #x754B)
      (#x5A43 . #x6548)
      (#x5A44 . #x6556)
      (#x5A45 . #x6555)
      (#x5A46 . #x654D)
      (#x5A47 . #x6558)
      (#x5A48 . #x655E)
      (#x5A49 . #x655D)
      (#x5A4A . #x6572)
      (#x5A4B . #x6578)
      (#x5A4C . #x6582)
      (#x5A4D . #x6583)
      (#x5A4E . #x8B8A)
      (#x5A4F . #x659B)
      (#x5A50 . #x659F)
      (#x5A51 . #x65AB)
      (#x5A52 . #x65B7)
      (#x5A53 . #x65C3)
      (#x5A54 . #x65C6)
      (#x5A55 . #x65C1)
      (#x5A56 . #x65C4)
      (#x5A57 . #x65CC)
      (#x5A58 . #x65D2)
      (#x5A59 . #x65DB)
      (#x5A5A . #x65D9)
      (#x5A5B . #x65E0)
      (#x5A5C . #x65E1)
      (#x5A5D . #x65F1)
      (#x5A5E . #x6772)
      (#x5A5F . #x660A)
      (#x5A60 . #x6603)
      (#x5A61 . #x65FB)
      (#x5A62 . #x6773)
      (#x5A63 . #x6635)
      (#x5A64 . #x6636)
      (#x5A65 . #x6634)
      (#x5A66 . #x661C)
      (#x5A67 . #x664F)
      (#x5A68 . #x6644)
      (#x5A69 . #x6649)
      (#x5A6A . #x6641)
      (#x5A6B . #x665E)
      (#x5A6C . #x665D)
      (#x5A6D . #x6664)
      (#x5A6E . #x6667)
      (#x5A6F . #x6668)
      (#x5A70 . #x665F)
      (#x5A71 . #x6662)
      (#x5A72 . #x6670)
      (#x5A73 . #x6683)
      (#x5A74 . #x6688)
      (#x5A75 . #x668E)
      (#x5A76 . #x6689)
      (#x5A77 . #x6684)
      (#x5A78 . #x6698)
      (#x5A79 . #x669D)
      (#x5A7A . #x66C1)
      (#x5A7B . #x66B9)
      (#x5A7C . #x66C9)
      (#x5A7D . #x66BE)
      (#x5A7E . #x66BC)
      (#x5B21 . #x66C4)
      (#x5B22 . #x66B8)
      (#x5B23 . #x66D6)
      (#x5B24 . #x66DA)
      (#x5B25 . #x66E0)
      (#x5B26 . #x663F)
      (#x5B27 . #x66E6)
      (#x5B28 . #x66E9)
      (#x5B29 . #x66F0)
      (#x5B2A . #x66F5)
      (#x5B2B . #x66F7)
      (#x5B2C . #x670F)
      (#x5B2D . #x6716)
      (#x5B2E . #x671E)
      (#x5B2F . #x6726)
      (#x5B30 . #x6727)
      (#x5B31 . #x9738)
      (#x5B32 . #x672E)
      (#x5B33 . #x673F)
      (#x5B34 . #x6736)
      (#x5B35 . #x6741)
      (#x5B36 . #x6738)
      (#x5B37 . #x6737)
      (#x5B38 . #x6746)
      (#x5B39 . #x675E)
      (#x5B3A . #x6760)
      (#x5B3B . #x6759)
      (#x5B3C . #x6763)
      (#x5B3D . #x6764)
      (#x5B3E . #x6789)
      (#x5B3F . #x6770)
      (#x5B40 . #x67A9)
      (#x5B41 . #x677C)
      (#x5B42 . #x676A)
      (#x5B43 . #x678C)
      (#x5B44 . #x678B)
      (#x5B45 . #x67A6)
      (#x5B46 . #x67A1)
      (#x5B47 . #x6785)
      (#x5B48 . #x67B7)
      (#x5B49 . #x67EF)
      (#x5B4A . #x67B4)
      (#x5B4B . #x67EC)
      (#x5B4C . #x67B3)
      (#x5B4D . #x67E9)
      (#x5B4E . #x67B8)
      (#x5B4F . #x67E4)
      (#x5B50 . #x67DE)
      (#x5B51 . #x67DD)
      (#x5B52 . #x67E2)
      (#x5B53 . #x67EE)
      (#x5B54 . #x67B9)
      (#x5B55 . #x67CE)
      (#x5B56 . #x67C6)
      (#x5B57 . #x67E7)
      (#x5B58 . #x6A9C)
      (#x5B59 . #x681E)
      (#x5B5A . #x6846)
      (#x5B5B . #x6829)
      (#x5B5C . #x6840)
      (#x5B5D . #x684D)
      (#x5B5E . #x6832)
      (#x5B5F . #x684E)
      (#x5B60 . #x68B3)
      (#x5B61 . #x682B)
      (#x5B62 . #x6859)
      (#x5B63 . #x6863)
      (#x5B64 . #x6877)
      (#x5B65 . #x687F)
      (#x5B66 . #x689F)
      (#x5B67 . #x688F)
      (#x5B68 . #x68AD)
      (#x5B69 . #x6894)
      (#x5B6A . #x689D)
      (#x5B6B . #x689B)
      (#x5B6C . #x6883)
      (#x5B6D . #x6AAE)
      (#x5B6E . #x68B9)
      (#x5B6F . #x6874)
      (#x5B70 . #x68B5)
      (#x5B71 . #x68A0)
      (#x5B72 . #x68BA)
      (#x5B73 . #x690F)
      (#x5B74 . #x688D)
      (#x5B75 . #x687E)
      (#x5B76 . #x6901)
      (#x5B77 . #x68CA)
      (#x5B78 . #x6908)
      (#x5B79 . #x68D8)
      (#x5B7A . #x6922)
      (#x5B7B . #x6926)
      (#x5B7C . #x68E1)
      (#x5B7D . #x690C)
      (#x5B7E . #x68CD)
      (#x5C21 . #x68D4)
      (#x5C22 . #x68E7)
      (#x5C23 . #x68D5)
      (#x5C24 . #x6936)
      (#x5C25 . #x6912)
      (#x5C26 . #x6904)
      (#x5C27 . #x68D7)
      (#x5C28 . #x68E3)
      (#x5C29 . #x6925)
      (#x5C2A . #x68F9)
      (#x5C2B . #x68E0)
      (#x5C2C . #x68EF)
      (#x5C2D . #x6928)
      (#x5C2E . #x692A)
      (#x5C2F . #x691A)
      (#x5C30 . #x6923)
      (#x5C31 . #x6921)
      (#x5C32 . #x68C6)
      (#x5C33 . #x6979)
      (#x5C34 . #x6977)
      (#x5C35 . #x695C)
      (#x5C36 . #x6978)
      (#x5C37 . #x696B)
      (#x5C38 . #x6954)
      (#x5C39 . #x697E)
      (#x5C3A . #x696E)
      (#x5C3B . #x6939)
      (#x5C3C . #x6974)
      (#x5C3D . #x693D)
      (#x5C3E . #x6959)
      (#x5C3F . #x6930)
      (#x5C40 . #x6961)
      (#x5C41 . #x695E)
      (#x5C42 . #x695D)
      (#x5C43 . #x6981)
      (#x5C44 . #x696A)
      (#x5C45 . #x69B2)
      (#x5C46 . #x69AE)
      (#x5C47 . #x69D0)
      (#x5C48 . #x69BF)
      (#x5C49 . #x69C1)
      (#x5C4A . #x69D3)
      (#x5C4B . #x69BE)
      (#x5C4C . #x69CE)
      (#x5C4D . #x5BE8)
      (#x5C4E . #x69CA)
      (#x5C4F . #x69DD)
      (#x5C50 . #x69BB)
      (#x5C51 . #x69C3)
      (#x5C52 . #x69A7)
      (#x5C53 . #x6A2E)
      (#x5C54 . #x6991)
      (#x5C55 . #x69A0)
      (#x5C56 . #x699C)
      (#x5C57 . #x6995)
      (#x5C58 . #x69B4)
      (#x5C59 . #x69DE)
      (#x5C5A . #x69E8)
      (#x5C5B . #x6A02)
      (#x5C5C . #x6A1B)
      (#x5C5D . #x69FF)
      (#x5C5E . #x6B0A)
      (#x5C5F . #x69F9)
      (#x5C60 . #x69F2)
      (#x5C61 . #x69E7)
      (#x5C62 . #x6A05)
      (#x5C63 . #x69B1)
      (#x5C64 . #x6A1E)
      (#x5C65 . #x69ED)
      (#x5C66 . #x6A14)
      (#x5C67 . #x69EB)
      (#x5C68 . #x6A0A)
      (#x5C69 . #x6A12)
      (#x5C6A . #x6AC1)
      (#x5C6B . #x6A23)
      (#x5C6C . #x6A13)
      (#x5C6D . #x6A44)
      (#x5C6E . #x6A0C)
      (#x5C6F . #x6A72)
      (#x5C70 . #x6A36)
      (#x5C71 . #x6A78)
      (#x5C72 . #x6A47)
      (#x5C73 . #x6A62)
      (#x5C74 . #x6A59)
      (#x5C75 . #x6A66)
      (#x5C76 . #x6A48)
      (#x5C77 . #x6A38)
      (#x5C78 . #x6A22)
      (#x5C79 . #x6A90)
      (#x5C7A . #x6A8D)
      (#x5C7B . #x6AA0)
      (#x5C7C . #x6A84)
      (#x5C7D . #x6AA2)
      (#x5C7E . #x6AA3)
      (#x5D21 . #x6A97)
      (#x5D22 . #x8617)
      (#x5D23 . #x6ABB)
      (#x5D24 . #x6AC3)
      (#x5D25 . #x6AC2)
      (#x5D26 . #x6AB8)
      (#x5D27 . #x6AB3)
      (#x5D28 . #x6AAC)
      (#x5D29 . #x6ADE)
      (#x5D2A . #x6AD1)
      (#x5D2B . #x6ADF)
      (#x5D2C . #x6AAA)
      (#x5D2D . #x6ADA)
      (#x5D2E . #x6AEA)
      (#x5D2F . #x6AFB)
      (#x5D30 . #x6B05)
      (#x5D31 . #x8616)
      (#x5D32 . #x6AFA)
      (#x5D33 . #x6B12)
      (#x5D34 . #x6B16)
      (#x5D35 . #x9B31)
      (#x5D36 . #x6B1F)
      (#x5D37 . #x6B38)
      (#x5D38 . #x6B37)
      (#x5D39 . #x76DC)
      (#x5D3A . #x6B39)
      (#x5D3B . #x98EE)
      (#x5D3C . #x6B47)
      (#x5D3D . #x6B43)
      (#x5D3E . #x6B49)
      (#x5D3F . #x6B50)
      (#x5D40 . #x6B59)
      (#x5D41 . #x6B54)
      (#x5D42 . #x6B5B)
      (#x5D43 . #x6B5F)
      (#x5D44 . #x6B61)
      (#x5D45 . #x6B78)
      (#x5D46 . #x6B79)
      (#x5D47 . #x6B7F)
      (#x5D48 . #x6B80)
      (#x5D49 . #x6B84)
      (#x5D4A . #x6B83)
      (#x5D4B . #x6B8D)
      (#x5D4C . #x6B98)
      (#x5D4D . #x6B95)
      (#x5D4E . #x6B9E)
      (#x5D4F . #x6BA4)
      (#x5D50 . #x6BAA)
      (#x5D51 . #x6BAB)
      (#x5D52 . #x6BAF)
      (#x5D53 . #x6BB2)
      (#x5D54 . #x6BB1)
      (#x5D55 . #x6BB3)
      (#x5D56 . #x6BB7)
      (#x5D57 . #x6BBC)
      (#x5D58 . #x6BC6)
      (#x5D59 . #x6BCB)
      (#x5D5A . #x6BD3)
      (#x5D5B . #x6BDF)
      (#x5D5C . #x6BEC)
      (#x5D5D . #x6BEB)
      (#x5D5E . #x6BF3)
      (#x5D5F . #x6BEF)
      (#x5D60 . #x9EBE)
      (#x5D61 . #x6C08)
      (#x5D62 . #x6C13)
      (#x5D63 . #x6C14)
      (#x5D64 . #x6C1B)
      (#x5D65 . #x6C24)
      (#x5D66 . #x6C23)
      (#x5D67 . #x6C5E)
      (#x5D68 . #x6C55)
      (#x5D69 . #x6C62)
      (#x5D6A . #x6C6A)
      (#x5D6B . #x6C82)
      (#x5D6C . #x6C8D)
      (#x5D6D . #x6C9A)
      (#x5D6E . #x6C81)
      (#x5D6F . #x6C9B)
      (#x5D70 . #x6C7E)
      (#x5D71 . #x6C68)
      (#x5D72 . #x6C73)
      (#x5D73 . #x6C92)
      (#x5D74 . #x6C90)
      (#x5D75 . #x6CC4)
      (#x5D76 . #x6CF1)
      (#x5D77 . #x6CD3)
      (#x5D78 . #x6CBD)
      (#x5D79 . #x6CD7)
      (#x5D7A . #x6CC5)
      (#x5D7B . #x6CDD)
      (#x5D7C . #x6CAE)
      (#x5D7D . #x6CB1)
      (#x5D7E . #x6CBE)
      (#x5E21 . #x6CBA)
      (#x5E22 . #x6CDB)
      (#x5E23 . #x6CEF)
      (#x5E24 . #x6CD9)
      (#x5E25 . #x6CEA)
      (#x5E26 . #x6D1F)
      (#x5E27 . #x884D)
      (#x5E28 . #x6D36)
      (#x5E29 . #x6D2B)
      (#x5E2A . #x6D3D)
      (#x5E2B . #x6D38)
      (#x5E2C . #x6D19)
      (#x5E2D . #x6D35)
      (#x5E2E . #x6D33)
      (#x5E2F . #x6D12)
      (#x5E30 . #x6D0C)
      (#x5E31 . #x6D63)
      (#x5E32 . #x6D93)
      (#x5E33 . #x6D64)
      (#x5E34 . #x6D5A)
      (#x5E35 . #x6D79)
      (#x5E36 . #x6D59)
      (#x5E37 . #x6D8E)
      (#x5E38 . #x6D95)
      (#x5E39 . #x6FE4)
      (#x5E3A . #x6D85)
      (#x5E3B . #x6DF9)
      (#x5E3C . #x6E15)
      (#x5E3D . #x6E0A)
      (#x5E3E . #x6DB5)
      (#x5E3F . #x6DC7)
      (#x5E40 . #x6DE6)
      (#x5E41 . #x6DB8)
      (#x5E42 . #x6DC6)
      (#x5E43 . #x6DEC)
      (#x5E44 . #x6DDE)
      (#x5E45 . #x6DCC)
      (#x5E46 . #x6DE8)
      (#x5E47 . #x6DD2)
      (#x5E48 . #x6DC5)
      (#x5E49 . #x6DFA)
      (#x5E4A . #x6DD9)
      (#x5E4B . #x6DE4)
      (#x5E4C . #x6DD5)
      (#x5E4D . #x6DEA)
      (#x5E4E . #x6DEE)
      (#x5E4F . #x6E2D)
      (#x5E50 . #x6E6E)
      (#x5E51 . #x6E2E)
      (#x5E52 . #x6E19)
      (#x5E53 . #x6E72)
      (#x5E54 . #x6E5F)
      (#x5E55 . #x6E3E)
      (#x5E56 . #x6E23)
      (#x5E57 . #x6E6B)
      (#x5E58 . #x6E2B)
      (#x5E59 . #x6E76)
      (#x5E5A . #x6E4D)
      (#x5E5B . #x6E1F)
      (#x5E5C . #x6E43)
      (#x5E5D . #x6E3A)
      (#x5E5E . #x6E4E)
      (#x5E5F . #x6E24)
      (#x5E60 . #x6EFF)
      (#x5E61 . #x6E1D)
      (#x5E62 . #x6E38)
      (#x5E63 . #x6E82)
      (#x5E64 . #x6EAA)
      (#x5E65 . #x6E98)
      (#x5E66 . #x6EC9)
      (#x5E67 . #x6EB7)
      (#x5E68 . #x6ED3)
      (#x5E69 . #x6EBD)
      (#x5E6A . #x6EAF)
      (#x5E6B . #x6EC4)
      (#x5E6C . #x6EB2)
      (#x5E6D . #x6ED4)
      (#x5E6E . #x6ED5)
      (#x5E6F . #x6E8F)
      (#x5E70 . #x6EA5)
      (#x5E71 . #x6EC2)
      (#x5E72 . #x6E9F)
      (#x5E73 . #x6F41)
      (#x5E74 . #x6F11)
      (#x5E75 . #x704C)
      (#x5E76 . #x6EEC)
      (#x5E77 . #x6EF8)
      (#x5E78 . #x6EFE)
      (#x5E79 . #x6F3F)
      (#x5E7A . #x6EF2)
      (#x5E7B . #x6F31)
      (#x5E7C . #x6EEF)
      (#x5E7D . #x6F32)
      (#x5E7E . #x6ECC)
      (#x5F21 . #x6F3E)
      (#x5F22 . #x6F13)
      (#x5F23 . #x6EF7)
      (#x5F24 . #x6F86)
      (#x5F25 . #x6F7A)
      (#x5F26 . #x6F78)
      (#x5F27 . #x6F81)
      (#x5F28 . #x6F80)
      (#x5F29 . #x6F6F)
      (#x5F2A . #x6F5B)
      (#x5F2B . #x6FF3)
      (#x5F2C . #x6F6D)
      (#x5F2D . #x6F82)
      (#x5F2E . #x6F7C)
      (#x5F2F . #x6F58)
      (#x5F30 . #x6F8E)
      (#x5F31 . #x6F91)
      (#x5F32 . #x6FC2)
      (#x5F33 . #x6F66)
      (#x5F34 . #x6FB3)
      (#x5F35 . #x6FA3)
      (#x5F36 . #x6FA1)
      (#x5F37 . #x6FA4)
      (#x5F38 . #x6FB9)
      (#x5F39 . #x6FC6)
      (#x5F3A . #x6FAA)
      (#x5F3B . #x6FDF)
      (#x5F3C . #x6FD5)
      (#x5F3D . #x6FEC)
      (#x5F3E . #x6FD4)
      (#x5F3F . #x6FD8)
      (#x5F40 . #x6FF1)
      (#x5F41 . #x6FEE)
      (#x5F42 . #x6FDB)
      (#x5F43 . #x7009)
      (#x5F44 . #x700B)
      (#x5F45 . #x6FFA)
      (#x5F46 . #x7011)
      (#x5F47 . #x7001)
      (#x5F48 . #x700F)
      (#x5F49 . #x6FFE)
      (#x5F4A . #x701B)
      (#x5F4B . #x701A)
      (#x5F4C . #x6F74)
      (#x5F4D . #x701D)
      (#x5F4E . #x7018)
      (#x5F4F . #x701F)
      (#x5F50 . #x7030)
      (#x5F51 . #x703E)
      (#x5F52 . #x7032)
      (#x5F53 . #x7051)
      (#x5F54 . #x7063)
      (#x5F55 . #x7099)
      (#x5F56 . #x7092)
      (#x5F57 . #x70AF)
      (#x5F58 . #x70F1)
      (#x5F59 . #x70AC)
      (#x5F5A . #x70B8)
      (#x5F5B . #x70B3)
      (#x5F5C . #x70AE)
      (#x5F5D . #x70DF)
      (#x5F5E . #x70CB)
      (#x5F5F . #x70DD)
      (#x5F60 . #x70D9)
      (#x5F61 . #x7109)
      (#x5F62 . #x70FD)
      (#x5F63 . #x711C)
      (#x5F64 . #x7119)
      (#x5F65 . #x7165)
      (#x5F66 . #x7155)
      (#x5F67 . #x7188)
      (#x5F68 . #x7166)
      (#x5F69 . #x7162)
      (#x5F6A . #x714C)
      (#x5F6B . #x7156)
      (#x5F6C . #x716C)
      (#x5F6D . #x718F)
      (#x5F6E . #x71FB)
      (#x5F6F . #x7184)
      (#x5F70 . #x7195)
      (#x5F71 . #x71A8)
      (#x5F72 . #x71AC)
      (#x5F73 . #x71D7)
      (#x5F74 . #x71B9)
      (#x5F75 . #x71BE)
      (#x5F76 . #x71D2)
      (#x5F77 . #x71C9)
      (#x5F78 . #x71D4)
      (#x5F79 . #x71CE)
      (#x5F7A . #x71E0)
      (#x5F7B . #x71EC)
      (#x5F7C . #x71E7)
      (#x5F7D . #x71F5)
      (#x5F7E . #x71FC)
      (#x6021 . #x71F9)
      (#x6022 . #x71FF)
      (#x6023 . #x720D)
      (#x6024 . #x7210)
      (#x6025 . #x721B)
      (#x6026 . #x7228)
      (#x6027 . #x722D)
      (#x6028 . #x722C)
      (#x6029 . #x7230)
      (#x602A . #x7232)
      (#x602B . #x723B)
      (#x602C . #x723C)
      (#x602D . #x723F)
      (#x602E . #x7240)
      (#x602F . #x7246)
      (#x6030 . #x724B)
      (#x6031 . #x7258)
      (#x6032 . #x7274)
      (#x6033 . #x727E)
      (#x6034 . #x7282)
      (#x6035 . #x7281)
      (#x6036 . #x7287)
      (#x6037 . #x7292)
      (#x6038 . #x7296)
      (#x6039 . #x72A2)
      (#x603A . #x72A7)
      (#x603B . #x72B9)
      (#x603C . #x72B2)
      (#x603D . #x72C3)
      (#x603E . #x72C6)
      (#x603F . #x72C4)
      (#x6040 . #x72CE)
      (#x6041 . #x72D2)
      (#x6042 . #x72E2)
      (#x6043 . #x72E0)
      (#x6044 . #x72E1)
      (#x6045 . #x72F9)
      (#x6046 . #x72F7)
      (#x6047 . #x500F)
      (#x6048 . #x7317)
      (#x6049 . #x730A)
      (#x604A . #x731C)
      (#x604B . #x7316)
      (#x604C . #x731D)
      (#x604D . #x7334)
      (#x604E . #x732F)
      (#x604F . #x7329)
      (#x6050 . #x7325)
      (#x6051 . #x733E)
      (#x6052 . #x734E)
      (#x6053 . #x734F)
      (#x6054 . #x9ED8)
      (#x6055 . #x7357)
      (#x6056 . #x736A)
      (#x6057 . #x7368)
      (#x6058 . #x7370)
      (#x6059 . #x7378)
      (#x605A . #x7375)
      (#x605B . #x737B)
      (#x605C . #x737A)
      (#x605D . #x73C8)
      (#x605E . #x73B3)
      (#x605F . #x73CE)
      (#x6060 . #x73BB)
      (#x6061 . #x73C0)
      (#x6062 . #x73E5)
      (#x6063 . #x73EE)
      (#x6064 . #x73DE)
      (#x6065 . #x74A2)
      (#x6066 . #x7405)
      (#x6067 . #x746F)
      (#x6068 . #x7425)
      (#x6069 . #x73F8)
      (#x606A . #x7432)
      (#x606B . #x743A)
      (#x606C . #x7455)
      (#x606D . #x743F)
      (#x606E . #x745F)
      (#x606F . #x7459)
      (#x6070 . #x7441)
      (#x6071 . #x745C)
      (#x6072 . #x7469)
      (#x6073 . #x7470)
      (#x6074 . #x7463)
      (#x6075 . #x746A)
      (#x6076 . #x7476)
      (#x6077 . #x747E)
      (#x6078 . #x748B)
      (#x6079 . #x749E)
      (#x607A . #x74A7)
      (#x607B . #x74CA)
      (#x607C . #x74CF)
      (#x607D . #x74D4)
      (#x607E . #x73F1)
      (#x6121 . #x74E0)
      (#x6122 . #x74E3)
      (#x6123 . #x74E7)
      (#x6124 . #x74E9)
      (#x6125 . #x74EE)
      (#x6126 . #x74F2)
      (#x6127 . #x74F0)
      (#x6128 . #x74F1)
      (#x6129 . #x74F8)
      (#x612A . #x74F7)
      (#x612B . #x7504)
      (#x612C . #x7503)
      (#x612D . #x7505)
      (#x612E . #x750C)
      (#x612F . #x750E)
      (#x6130 . #x750D)
      (#x6131 . #x7515)
      (#x6132 . #x7513)
      (#x6133 . #x751E)
      (#x6134 . #x7526)
      (#x6135 . #x752C)
      (#x6136 . #x753C)
      (#x6137 . #x7544)
      (#x6138 . #x754D)
      (#x6139 . #x754A)
      (#x613A . #x7549)
      (#x613B . #x755B)
      (#x613C . #x7546)
      (#x613D . #x755A)
      (#x613E . #x7569)
      (#x613F . #x7564)
      (#x6140 . #x7567)
      (#x6141 . #x756B)
      (#x6142 . #x756D)
      (#x6143 . #x7578)
      (#x6144 . #x7576)
      (#x6145 . #x7586)
      (#x6146 . #x7587)
      (#x6147 . #x7574)
      (#x6148 . #x758A)
      (#x6149 . #x7589)
      (#x614A . #x7582)
      (#x614B . #x7594)
      (#x614C . #x759A)
      (#x614D . #x759D)
      (#x614E . #x75A5)
      (#x614F . #x75A3)
      (#x6150 . #x75C2)
      (#x6151 . #x75B3)
      (#x6152 . #x75C3)
      (#x6153 . #x75B5)
      (#x6154 . #x75BD)
      (#x6155 . #x75B8)
      (#x6156 . #x75BC)
      (#x6157 . #x75B1)
      (#x6158 . #x75CD)
      (#x6159 . #x75CA)
      (#x615A . #x75D2)
      (#x615B . #x75D9)
      (#x615C . #x75E3)
      (#x615D . #x75DE)
      (#x615E . #x75FE)
      (#x615F . #x75FF)
      (#x6160 . #x75FC)
      (#x6161 . #x7601)
      (#x6162 . #x75F0)
      (#x6163 . #x75FA)
      (#x6164 . #x75F2)
      (#x6165 . #x75F3)
      (#x6166 . #x760B)
      (#x6167 . #x760D)
      (#x6168 . #x7609)
      (#x6169 . #x761F)
      (#x616A . #x7627)
      (#x616B . #x7620)
      (#x616C . #x7621)
      (#x616D . #x7622)
      (#x616E . #x7624)
      (#x616F . #x7634)
      (#x6170 . #x7630)
      (#x6171 . #x763B)
      (#x6172 . #x7647)
      (#x6173 . #x7648)
      (#x6174 . #x7646)
      (#x6175 . #x765C)
      (#x6176 . #x7658)
      (#x6177 . #x7661)
      (#x6178 . #x7662)
      (#x6179 . #x7668)
      (#x617A . #x7669)
      (#x617B . #x766A)
      (#x617C . #x7667)
      (#x617D . #x766C)
      (#x617E . #x7670)
      (#x6221 . #x7672)
      (#x6222 . #x7676)
      (#x6223 . #x7678)
      (#x6224 . #x767C)
      (#x6225 . #x7680)
      (#x6226 . #x7683)
      (#x6227 . #x7688)
      (#x6228 . #x768B)
      (#x6229 . #x768E)
      (#x622A . #x7696)
      (#x622B . #x7693)
      (#x622C . #x7699)
      (#x622D . #x769A)
      (#x622E . #x76B0)
      (#x622F . #x76B4)
      (#x6230 . #x76B8)
      (#x6231 . #x76B9)
      (#x6232 . #x76BA)
      (#x6233 . #x76C2)
      (#x6234 . #x76CD)
      (#x6235 . #x76D6)
      (#x6236 . #x76D2)
      (#x6237 . #x76DE)
      (#x6238 . #x76E1)
      (#x6239 . #x76E5)
      (#x623A . #x76E7)
      (#x623B . #x76EA)
      (#x623C . #x862F)
      (#x623D . #x76FB)
      (#x623E . #x7708)
      (#x623F . #x7707)
      (#x6240 . #x7704)
      (#x6241 . #x7729)
      (#x6242 . #x7724)
      (#x6243 . #x771E)
      (#x6244 . #x7725)
      (#x6245 . #x7726)
      (#x6246 . #x771B)
      (#x6247 . #x7737)
      (#x6248 . #x7738)
      (#x6249 . #x7747)
      (#x624A . #x775A)
      (#x624B . #x7768)
      (#x624C . #x776B)
      (#x624D . #x775B)
      (#x624E . #x7765)
      (#x624F . #x777F)
      (#x6250 . #x777E)
      (#x6251 . #x7779)
      (#x6252 . #x778E)
      (#x6253 . #x778B)
      (#x6254 . #x7791)
      (#x6255 . #x77A0)
      (#x6256 . #x779E)
      (#x6257 . #x77B0)
      (#x6258 . #x77B6)
      (#x6259 . #x77B9)
      (#x625A . #x77BF)
      (#x625B . #x77BC)
      (#x625C . #x77BD)
      (#x625D . #x77BB)
      (#x625E . #x77C7)
      (#x625F . #x77CD)
      (#x6260 . #x77D7)
      (#x6261 . #x77DA)
      (#x6262 . #x77DC)
      (#x6263 . #x77E3)
      (#x6264 . #x77EE)
      (#x6265 . #x77FC)
      (#x6266 . #x780C)
      (#x6267 . #x7812)
      (#x6268 . #x7926)
      (#x6269 . #x7820)
      (#x626A . #x792A)
      (#x626B . #x7845)
      (#x626C . #x788E)
      (#x626D . #x7874)
      (#x626E . #x7886)
      (#x626F . #x787C)
      (#x6270 . #x789A)
      (#x6271 . #x788C)
      (#x6272 . #x78A3)
      (#x6273 . #x78B5)
      (#x6274 . #x78AA)
      (#x6275 . #x78AF)
      (#x6276 . #x78D1)
      (#x6277 . #x78C6)
      (#x6278 . #x78CB)
      (#x6279 . #x78D4)
      (#x627A . #x78BE)
      (#x627B . #x78BC)
      (#x627C . #x78C5)
      (#x627D . #x78CA)
      (#x627E . #x78EC)
      (#x6321 . #x78E7)
      (#x6322 . #x78DA)
      (#x6323 . #x78FD)
      (#x6324 . #x78F4)
      (#x6325 . #x7907)
      (#x6326 . #x7912)
      (#x6327 . #x7911)
      (#x6328 . #x7919)
      (#x6329 . #x792C)
      (#x632A . #x792B)
      (#x632B . #x7940)
      (#x632C . #x7960)
      (#x632D . #x7957)
      (#x632E . #x795F)
      (#x632F . #x795A)
      (#x6330 . #x7955)
      (#x6331 . #x7953)
      (#x6332 . #x797A)
      (#x6333 . #x797F)
      (#x6334 . #x798A)
      (#x6335 . #x799D)
      (#x6336 . #x79A7)
      (#x6337 . #x9F4B)
      (#x6338 . #x79AA)
      (#x6339 . #x79AE)
      (#x633A . #x79B3)
      (#x633B . #x79B9)
      (#x633C . #x79BA)
      (#x633D . #x79C9)
      (#x633E . #x79D5)
      (#x633F . #x79E7)
      (#x6340 . #x79EC)
      (#x6341 . #x79E1)
      (#x6342 . #x79E3)
      (#x6343 . #x7A08)
      (#x6344 . #x7A0D)
      (#x6345 . #x7A18)
      (#x6346 . #x7A19)
      (#x6347 . #x7A20)
      (#x6348 . #x7A1F)
      (#x6349 . #x7980)
      (#x634A . #x7A31)
      (#x634B . #x7A3B)
      (#x634C . #x7A3E)
      (#x634D . #x7A37)
      (#x634E . #x7A43)
      (#x634F . #x7A57)
      (#x6350 . #x7A49)
      (#x6351 . #x7A61)
      (#x6352 . #x7A62)
      (#x6353 . #x7A69)
      (#x6354 . #x9F9D)
      (#x6355 . #x7A70)
      (#x6356 . #x7A79)
      (#x6357 . #x7A7D)
      (#x6358 . #x7A88)
      (#x6359 . #x7A97)
      (#x635A . #x7A95)
      (#x635B . #x7A98)
      (#x635C . #x7A96)
      (#x635D . #x7AA9)
      (#x635E . #x7AC8)
      (#x635F . #x7AB0)
      (#x6360 . #x7AB6)
      (#x6361 . #x7AC5)
      (#x6362 . #x7AC4)
      (#x6363 . #x7ABF)
      (#x6364 . #x9083)
      (#x6365 . #x7AC7)
      (#x6366 . #x7ACA)
      (#x6367 . #x7ACD)
      (#x6368 . #x7ACF)
      (#x6369 . #x7AD5)
      (#x636A . #x7AD3)
      (#x636B . #x7AD9)
      (#x636C . #x7ADA)
      (#x636D . #x7ADD)
      (#x636E . #x7AE1)
      (#x636F . #x7AE2)
      (#x6370 . #x7AE6)
      (#x6371 . #x7AED)
      (#x6372 . #x7AF0)
      (#x6373 . #x7B02)
      (#x6374 . #x7B0F)
      (#x6375 . #x7B0A)
      (#x6376 . #x7B06)
      (#x6377 . #x7B33)
      (#x6378 . #x7B18)
      (#x6379 . #x7B19)
      (#x637A . #x7B1E)
      (#x637B . #x7B35)
      (#x637C . #x7B28)
      (#x637D . #x7B36)
      (#x637E . #x7B50)
      (#x6421 . #x7B7A)
      (#x6422 . #x7B04)
      (#x6423 . #x7B4D)
      (#x6424 . #x7B0B)
      (#x6425 . #x7B4C)
      (#x6426 . #x7B45)
      (#x6427 . #x7B75)
      (#x6428 . #x7B65)
      (#x6429 . #x7B74)
      (#x642A . #x7B67)
      (#x642B . #x7B70)
      (#x642C . #x7B71)
      (#x642D . #x7B6C)
      (#x642E . #x7B6E)
      (#x642F . #x7B9D)
      (#x6430 . #x7B98)
      (#x6431 . #x7B9F)
      (#x6432 . #x7B8D)
      (#x6433 . #x7B9C)
      (#x6434 . #x7B9A)
      (#x6435 . #x7B8B)
      (#x6436 . #x7B92)
      (#x6437 . #x7B8F)
      (#x6438 . #x7B5D)
      (#x6439 . #x7B99)
      (#x643A . #x7BCB)
      (#x643B . #x7BC1)
      (#x643C . #x7BCC)
      (#x643D . #x7BCF)
      (#x643E . #x7BB4)
      (#x643F . #x7BC6)
      (#x6440 . #x7BDD)
      (#x6441 . #x7BE9)
      (#x6442 . #x7C11)
      (#x6443 . #x7C14)
      (#x6444 . #x7BE6)
      (#x6445 . #x7BE5)
      (#x6446 . #x7C60)
      (#x6447 . #x7C00)
      (#x6448 . #x7C07)
      (#x6449 . #x7C13)
      (#x644A . #x7BF3)
      (#x644B . #x7BF7)
      (#x644C . #x7C17)
      (#x644D . #x7C0D)
      (#x644E . #x7BF6)
      (#x644F . #x7C23)
      (#x6450 . #x7C27)
      (#x6451 . #x7C2A)
      (#x6452 . #x7C1F)
      (#x6453 . #x7C37)
      (#x6454 . #x7C2B)
      (#x6455 . #x7C3D)
      (#x6456 . #x7C4C)
      (#x6457 . #x7C43)
      (#x6458 . #x7C54)
      (#x6459 . #x7C4F)
      (#x645A . #x7C40)
      (#x645B . #x7C50)
      (#x645C . #x7C58)
      (#x645D . #x7C5F)
      (#x645E . #x7C64)
      (#x645F . #x7C56)
      (#x6460 . #x7C65)
      (#x6461 . #x7C6C)
      (#x6462 . #x7C75)
      (#x6463 . #x7C83)
      (#x6464 . #x7C90)
      (#x6465 . #x7CA4)
      (#x6466 . #x7CAD)
      (#x6467 . #x7CA2)
      (#x6468 . #x7CAB)
      (#x6469 . #x7CA1)
      (#x646A . #x7CA8)
      (#x646B . #x7CB3)
      (#x646C . #x7CB2)
      (#x646D . #x7CB1)
      (#x646E . #x7CAE)
      (#x646F . #x7CB9)
      (#x6470 . #x7CBD)
      (#x6471 . #x7CC0)
      (#x6472 . #x7CC5)
      (#x6473 . #x7CC2)
      (#x6474 . #x7CD8)
      (#x6475 . #x7CD2)
      (#x6476 . #x7CDC)
      (#x6477 . #x7CE2)
      (#x6478 . #x9B3B)
      (#x6479 . #x7CEF)
      (#x647A . #x7CF2)
      (#x647B . #x7CF4)
      (#x647C . #x7CF6)
      (#x647D . #x7CFA)
      (#x647E . #x7D06)
      (#x6521 . #x7D02)
      (#x6522 . #x7D1C)
      (#x6523 . #x7D15)
      (#x6524 . #x7D0A)
      (#x6525 . #x7D45)
      (#x6526 . #x7D4B)
      (#x6527 . #x7D2E)
      (#x6528 . #x7D32)
      (#x6529 . #x7D3F)
      (#x652A . #x7D35)
      (#x652B . #x7D46)
      (#x652C . #x7D73)
      (#x652D . #x7D56)
      (#x652E . #x7D4E)
      (#x652F . #x7D72)
      (#x6530 . #x7D68)
      (#x6531 . #x7D6E)
      (#x6532 . #x7D4F)
      (#x6533 . #x7D63)
      (#x6534 . #x7D93)
      (#x6535 . #x7D89)
      (#x6536 . #x7D5B)
      (#x6537 . #x7D8F)
      (#x6538 . #x7D7D)
      (#x6539 . #x7D9B)
      (#x653A . #x7DBA)
      (#x653B . #x7DAE)
      (#x653C . #x7DA3)
      (#x653D . #x7DB5)
      (#x653E . #x7DC7)
      (#x653F . #x7DBD)
      (#x6540 . #x7DAB)
      (#x6541 . #x7E3D)
      (#x6542 . #x7DA2)
      (#x6543 . #x7DAF)
      (#x6544 . #x7DDC)
      (#x6545 . #x7DB8)
      (#x6546 . #x7D9F)
      (#x6547 . #x7DB0)
      (#x6548 . #x7DD8)
      (#x6549 . #x7DDD)
      (#x654A . #x7DE4)
      (#x654B . #x7DDE)
      (#x654C . #x7DFB)
      (#x654D . #x7DF2)
      (#x654E . #x7DE1)
      (#x654F . #x7E05)
      (#x6550 . #x7E0A)
      (#x6551 . #x7E23)
      (#x6552 . #x7E21)
      (#x6553 . #x7E12)
      (#x6554 . #x7E31)
      (#x6555 . #x7E1F)
      (#x6556 . #x7E09)
      (#x6557 . #x7E0B)
      (#x6558 . #x7E22)
      (#x6559 . #x7E46)
      (#x655A . #x7E66)
      (#x655B . #x7E3B)
      (#x655C . #x7E35)
      (#x655D . #x7E39)
      (#x655E . #x7E43)
      (#x655F . #x7E37)
      (#x6560 . #x7E32)
      (#x6561 . #x7E3A)
      (#x6562 . #x7E67)
      (#x6563 . #x7E5D)
      (#x6564 . #x7E56)
      (#x6565 . #x7E5E)
      (#x6566 . #x7E59)
      (#x6567 . #x7E5A)
      (#x6568 . #x7E79)
      (#x6569 . #x7E6A)
      (#x656A . #x7E69)
      (#x656B . #x7E7C)
      (#x656C . #x7E7B)
      (#x656D . #x7E83)
      (#x656E . #x7DD5)
      (#x656F . #x7E7D)
      (#x6570 . #x8FAE)
      (#x6571 . #x7E7F)
      (#x6572 . #x7E88)
      (#x6573 . #x7E89)
      (#x6574 . #x7E8C)
      (#x6575 . #x7E92)
      (#x6576 . #x7E90)
      (#x6577 . #x7E93)
      (#x6578 . #x7E94)
      (#x6579 . #x7E96)
      (#x657A . #x7E8E)
      (#x657B . #x7E9B)
      (#x657C . #x7E9C)
      (#x657D . #x7F38)
      (#x657E . #x7F3A)
      (#x6621 . #x7F45)
      (#x6622 . #x7F4C)
      (#x6623 . #x7F4D)
      (#x6624 . #x7F4E)
      (#x6625 . #x7F50)
      (#x6626 . #x7F51)
      (#x6627 . #x7F55)
      (#x6628 . #x7F54)
      (#x6629 . #x7F58)
      (#x662A . #x7F5F)
      (#x662B . #x7F60)
      (#x662C . #x7F68)
      (#x662D . #x7F69)
      (#x662E . #x7F67)
      (#x662F . #x7F78)
      (#x6630 . #x7F82)
      (#x6631 . #x7F86)
      (#x6632 . #x7F83)
      (#x6633 . #x7F88)
      (#x6634 . #x7F87)
      (#x6635 . #x7F8C)
      (#x6636 . #x7F94)
      (#x6637 . #x7F9E)
      (#x6638 . #x7F9D)
      (#x6639 . #x7F9A)
      (#x663A . #x7FA3)
      (#x663B . #x7FAF)
      (#x663C . #x7FB2)
      (#x663D . #x7FB9)
      (#x663E . #x7FAE)
      (#x663F . #x7FB6)
      (#x6640 . #x7FB8)
      (#x6641 . #x8B71)
      (#x6642 . #x7FC5)
      (#x6643 . #x7FC6)
      (#x6644 . #x7FCA)
      (#x6645 . #x7FD5)
      (#x6646 . #x7FD4)
      (#x6647 . #x7FE1)
      (#x6648 . #x7FE6)
      (#x6649 . #x7FE9)
      (#x664A . #x7FF3)
      (#x664B . #x7FF9)
      (#x664C . #x98DC)
      (#x664D . #x8006)
      (#x664E . #x8004)
      (#x664F . #x800B)
      (#x6650 . #x8012)
      (#x6651 . #x8018)
      (#x6652 . #x8019)
      (#x6653 . #x801C)
      (#x6654 . #x8021)
      (#x6655 . #x8028)
      (#x6656 . #x803F)
      (#x6657 . #x803B)
      (#x6658 . #x804A)
      (#x6659 . #x8046)
      (#x665A . #x8052)
      (#x665B . #x8058)
      (#x665C . #x805A)
      (#x665D . #x805F)
      (#x665E . #x8062)
      (#x665F . #x8068)
      (#x6660 . #x8073)
      (#x6661 . #x8072)
      (#x6662 . #x8070)
      (#x6663 . #x8076)
      (#x6664 . #x8079)
      (#x6665 . #x807D)
      (#x6666 . #x807F)
      (#x6667 . #x8084)
      (#x6668 . #x8086)
      (#x6669 . #x8085)
      (#x666A . #x809B)
      (#x666B . #x8093)
      (#x666C . #x809A)
      (#x666D . #x80AD)
      (#x666E . #x5190)
      (#x666F . #x80AC)
      (#x6670 . #x80DB)
      (#x6671 . #x80E5)
      (#x6672 . #x80D9)
      (#x6673 . #x80DD)
      (#x6674 . #x80C4)
      (#x6675 . #x80DA)
      (#x6676 . #x80D6)
      (#x6677 . #x8109)
      (#x6678 . #x80EF)
      (#x6679 . #x80F1)
      (#x667A . #x811B)
      (#x667B . #x8129)
      (#x667C . #x8123)
      (#x667D . #x812F)
      (#x667E . #x814B)
      (#x6721 . #x968B)
      (#x6722 . #x8146)
      (#x6723 . #x813E)
      (#x6724 . #x8153)
      (#x6725 . #x8151)
      (#x6726 . #x80FC)
      (#x6727 . #x8171)
      (#x6728 . #x816E)
      (#x6729 . #x8165)
      (#x672A . #x8166)
      (#x672B . #x8174)
      (#x672C . #x8183)
      (#x672D . #x8188)
      (#x672E . #x818A)
      (#x672F . #x8180)
      (#x6730 . #x8182)
      (#x6731 . #x81A0)
      (#x6732 . #x8195)
      (#x6733 . #x81A4)
      (#x6734 . #x81A3)
      (#x6735 . #x815F)
      (#x6736 . #x8193)
      (#x6737 . #x81A9)
      (#x6738 . #x81B0)
      (#x6739 . #x81B5)
      (#x673A . #x81BE)
      (#x673B . #x81B8)
      (#x673C . #x81BD)
      (#x673D . #x81C0)
      (#x673E . #x81C2)
      (#x673F . #x81BA)
      (#x6740 . #x81C9)
      (#x6741 . #x81CD)
      (#x6742 . #x81D1)
      (#x6743 . #x81D9)
      (#x6744 . #x81D8)
      (#x6745 . #x81C8)
      (#x6746 . #x81DA)
      (#x6747 . #x81DF)
      (#x6748 . #x81E0)
      (#x6749 . #x81E7)
      (#x674A . #x81FA)
      (#x674B . #x81FB)
      (#x674C . #x81FE)
      (#x674D . #x8201)
      (#x674E . #x8202)
      (#x674F . #x8205)
      (#x6750 . #x8207)
      (#x6751 . #x820A)
      (#x6752 . #x820D)
      (#x6753 . #x8210)
      (#x6754 . #x8216)
      (#x6755 . #x8229)
      (#x6756 . #x822B)
      (#x6757 . #x8238)
      (#x6758 . #x8233)
      (#x6759 . #x8240)
      (#x675A . #x8259)
      (#x675B . #x8258)
      (#x675C . #x825D)
      (#x675D . #x825A)
      (#x675E . #x825F)
      (#x675F . #x8264)
      (#x6760 . #x8262)
      (#x6761 . #x8268)
      (#x6762 . #x826A)
      (#x6763 . #x826B)
      (#x6764 . #x822E)
      (#x6765 . #x8271)
      (#x6766 . #x8277)
      (#x6767 . #x8278)
      (#x6768 . #x827E)
      (#x6769 . #x828D)
      (#x676A . #x8292)
      (#x676B . #x82AB)
      (#x676C . #x829F)
      (#x676D . #x82BB)
      (#x676E . #x82AC)
      (#x676F . #x82E1)
      (#x6770 . #x82E3)
      (#x6771 . #x82DF)
      (#x6772 . #x82D2)
      (#x6773 . #x82F4)
      (#x6774 . #x82F3)
      (#x6775 . #x82FA)
      (#x6776 . #x8393)
      (#x6777 . #x8303)
      (#x6778 . #x82FB)
      (#x6779 . #x82F9)
      (#x677A . #x82DE)
      (#x677B . #x8306)
      (#x677C . #x82DC)
      (#x677D . #x8309)
      (#x677E . #x82D9)
      (#x6821 . #x8335)
      (#x6822 . #x8334)
      (#x6823 . #x8316)
      (#x6824 . #x8332)
      (#x6825 . #x8331)
      (#x6826 . #x8340)
      (#x6827 . #x8339)
      (#x6828 . #x8350)
      (#x6829 . #x8345)
      (#x682A . #x832F)
      (#x682B . #x832B)
      (#x682C . #x8317)
      (#x682D . #x8318)
      (#x682E . #x8385)
      (#x682F . #x839A)
      (#x6830 . #x83AA)
      (#x6831 . #x839F)
      (#x6832 . #x83A2)
      (#x6833 . #x8396)
      (#x6834 . #x8323)
      (#x6835 . #x838E)
      (#x6836 . #x8387)
      (#x6837 . #x838A)
      (#x6838 . #x837C)
      (#x6839 . #x83B5)
      (#x683A . #x8373)
      (#x683B . #x8375)
      (#x683C . #x83A0)
      (#x683D . #x8389)
      (#x683E . #x83A8)
      (#x683F . #x83F4)
      (#x6840 . #x8413)
      (#x6841 . #x83EB)
      (#x6842 . #x83CE)
      (#x6843 . #x83FD)
      (#x6844 . #x8403)
      (#x6845 . #x83D8)
      (#x6846 . #x840B)
      (#x6847 . #x83C1)
      (#x6848 . #x83F7)
      (#x6849 . #x8407)
      (#x684A . #x83E0)
      (#x684B . #x83F2)
      (#x684C . #x840D)
      (#x684D . #x8422)
      (#x684E . #x8420)
      (#x684F . #x83BD)
      (#x6850 . #x8438)
      (#x6851 . #x8506)
      (#x6852 . #x83FB)
      (#x6853 . #x846D)
      (#x6854 . #x842A)
      (#x6855 . #x843C)
      (#x6856 . #x855A)
      (#x6857 . #x8484)
      (#x6858 . #x8477)
      (#x6859 . #x846B)
      (#x685A . #x84AD)
      (#x685B . #x846E)
      (#x685C . #x8482)
      (#x685D . #x8469)
      (#x685E . #x8446)
      (#x685F . #x842C)
      (#x6860 . #x846F)
      (#x6861 . #x8479)
      (#x6862 . #x8435)
      (#x6863 . #x84CA)
      (#x6864 . #x8462)
      (#x6865 . #x84B9)
      (#x6866 . #x84BF)
      (#x6867 . #x849F)
      (#x6868 . #x84D9)
      (#x6869 . #x84CD)
      (#x686A . #x84BB)
      (#x686B . #x84DA)
      (#x686C . #x84D0)
      (#x686D . #x84C1)
      (#x686E . #x84C6)
      (#x686F . #x84D6)
      (#x6870 . #x84A1)
      (#x6871 . #x8521)
      (#x6872 . #x84FF)
      (#x6873 . #x84F4)
      (#x6874 . #x8517)
      (#x6875 . #x8518)
      (#x6876 . #x852C)
      (#x6877 . #x851F)
      (#x6878 . #x8515)
      (#x6879 . #x8514)
      (#x687A . #x84FC)
      (#x687B . #x8540)
      (#x687C . #x8563)
      (#x687D . #x8558)
      (#x687E . #x8548)
      (#x6921 . #x8541)
      (#x6922 . #x8602)
      (#x6923 . #x854B)
      (#x6924 . #x8555)
      (#x6925 . #x8580)
      (#x6926 . #x85A4)
      (#x6927 . #x8588)
      (#x6928 . #x8591)
      (#x6929 . #x858A)
      (#x692A . #x85A8)
      (#x692B . #x856D)
      (#x692C . #x8594)
      (#x692D . #x859B)
      (#x692E . #x85EA)
      (#x692F . #x8587)
      (#x6930 . #x859C)
      (#x6931 . #x8577)
      (#x6932 . #x857E)
      (#x6933 . #x8590)
      (#x6934 . #x85C9)
      (#x6935 . #x85BA)
      (#x6936 . #x85CF)
      (#x6937 . #x85B9)
      (#x6938 . #x85D0)
      (#x6939 . #x85D5)
      (#x693A . #x85DD)
      (#x693B . #x85E5)
      (#x693C . #x85DC)
      (#x693D . #x85F9)
      (#x693E . #x860A)
      (#x693F . #x8613)
      (#x6940 . #x860B)
      (#x6941 . #x85FE)
      (#x6942 . #x85FA)
      (#x6943 . #x8606)
      (#x6944 . #x8622)
      (#x6945 . #x861A)
      (#x6946 . #x8630)
      (#x6947 . #x863F)
      (#x6948 . #x864D)
      (#x6949 . #x4E55)
      (#x694A . #x8654)
      (#x694B . #x865F)
      (#x694C . #x8667)
      (#x694D . #x8671)
      (#x694E . #x8693)
      (#x694F . #x86A3)
      (#x6950 . #x86A9)
      (#x6951 . #x86AA)
      (#x6952 . #x868B)
      (#x6953 . #x868C)
      (#x6954 . #x86B6)
      (#x6955 . #x86AF)
      (#x6956 . #x86C4)
      (#x6957 . #x86C6)
      (#x6958 . #x86B0)
      (#x6959 . #x86C9)
      (#x695A . #x8823)
      (#x695B . #x86AB)
      (#x695C . #x86D4)
      (#x695D . #x86DE)
      (#x695E . #x86E9)
      (#x695F . #x86EC)
      (#x6960 . #x86DF)
      (#x6961 . #x86DB)
      (#x6962 . #x86EF)
      (#x6963 . #x8712)
      (#x6964 . #x8706)
      (#x6965 . #x8708)
      (#x6966 . #x8700)
      (#x6967 . #x8703)
      (#x6968 . #x86FB)
      (#x6969 . #x8711)
      (#x696A . #x8709)
      (#x696B . #x870D)
      (#x696C . #x86F9)
      (#x696D . #x870A)
      (#x696E . #x8734)
      (#x696F . #x873F)
      (#x6970 . #x8737)
      (#x6971 . #x873B)
      (#x6972 . #x8725)
      (#x6973 . #x8729)
      (#x6974 . #x871A)
      (#x6975 . #x8760)
      (#x6976 . #x875F)
      (#x6977 . #x8778)
      (#x6978 . #x874C)
      (#x6979 . #x874E)
      (#x697A . #x8774)
      (#x697B . #x8757)
      (#x697C . #x8768)
      (#x697D . #x876E)
      (#x697E . #x8759)
      (#x6A21 . #x8753)
      (#x6A22 . #x8763)
      (#x6A23 . #x876A)
      (#x6A24 . #x8805)
      (#x6A25 . #x87A2)
      (#x6A26 . #x879F)
      (#x6A27 . #x8782)
      (#x6A28 . #x87AF)
      (#x6A29 . #x87CB)
      (#x6A2A . #x87BD)
      (#x6A2B . #x87C0)
      (#x6A2C . #x87D0)
      (#x6A2D . #x96D6)
      (#x6A2E . #x87AB)
      (#x6A2F . #x87C4)
      (#x6A30 . #x87B3)
      (#x6A31 . #x87C7)
      (#x6A32 . #x87C6)
      (#x6A33 . #x87BB)
      (#x6A34 . #x87EF)
      (#x6A35 . #x87F2)
      (#x6A36 . #x87E0)
      (#x6A37 . #x880F)
      (#x6A38 . #x880D)
      (#x6A39 . #x87FE)
      (#x6A3A . #x87F6)
      (#x6A3B . #x87F7)
      (#x6A3C . #x880E)
      (#x6A3D . #x87D2)
      (#x6A3E . #x8811)
      (#x6A3F . #x8816)
      (#x6A40 . #x8815)
      (#x6A41 . #x8822)
      (#x6A42 . #x8821)
      (#x6A43 . #x8831)
      (#x6A44 . #x8836)
      (#x6A45 . #x8839)
      (#x6A46 . #x8827)
      (#x6A47 . #x883B)
      (#x6A48 . #x8844)
      (#x6A49 . #x8842)
      (#x6A4A . #x8852)
      (#x6A4B . #x8859)
      (#x6A4C . #x885E)
      (#x6A4D . #x8862)
      (#x6A4E . #x886B)
      (#x6A4F . #x8881)
      (#x6A50 . #x887E)
      (#x6A51 . #x889E)
      (#x6A52 . #x8875)
      (#x6A53 . #x887D)
      (#x6A54 . #x88B5)
      (#x6A55 . #x8872)
      (#x6A56 . #x8882)
      (#x6A57 . #x8897)
      (#x6A58 . #x8892)
      (#x6A59 . #x88AE)
      (#x6A5A . #x8899)
      (#x6A5B . #x88A2)
      (#x6A5C . #x888D)
      (#x6A5D . #x88A4)
      (#x6A5E . #x88B0)
      (#x6A5F . #x88BF)
      (#x6A60 . #x88B1)
      (#x6A61 . #x88C3)
      (#x6A62 . #x88C4)
      (#x6A63 . #x88D4)
      (#x6A64 . #x88D8)
      (#x6A65 . #x88D9)
      (#x6A66 . #x88DD)
      (#x6A67 . #x88F9)
      (#x6A68 . #x8902)
      (#x6A69 . #x88FC)
      (#x6A6A . #x88F4)
      (#x6A6B . #x88E8)
      (#x6A6C . #x88F2)
      (#x6A6D . #x8904)
      (#x6A6E . #x890C)
      (#x6A6F . #x890A)
      (#x6A70 . #x8913)
      (#x6A71 . #x8943)
      (#x6A72 . #x891E)
      (#x6A73 . #x8925)
      (#x6A74 . #x892A)
      (#x6A75 . #x892B)
      (#x6A76 . #x8941)
      (#x6A77 . #x8944)
      (#x6A78 . #x893B)
      (#x6A79 . #x8936)
      (#x6A7A . #x8938)
      (#x6A7B . #x894C)
      (#x6A7C . #x891D)
      (#x6A7D . #x8960)
      (#x6A7E . #x895E)
      (#x6B21 . #x8966)
      (#x6B22 . #x8964)
      (#x6B23 . #x896D)
      (#x6B24 . #x896A)
      (#x6B25 . #x896F)
      (#x6B26 . #x8974)
      (#x6B27 . #x8977)
      (#x6B28 . #x897E)
      (#x6B29 . #x8983)
      (#x6B2A . #x8988)
      (#x6B2B . #x898A)
      (#x6B2C . #x8993)
      (#x6B2D . #x8998)
      (#x6B2E . #x89A1)
      (#x6B2F . #x89A9)
      (#x6B30 . #x89A6)
      (#x6B31 . #x89AC)
      (#x6B32 . #x89AF)
      (#x6B33 . #x89B2)
      (#x6B34 . #x89BA)
      (#x6B35 . #x89BD)
      (#x6B36 . #x89BF)
      (#x6B37 . #x89C0)
      (#x6B38 . #x89DA)
      (#x6B39 . #x89DC)
      (#x6B3A . #x89DD)
      (#x6B3B . #x89E7)
      (#x6B3C . #x89F4)
      (#x6B3D . #x89F8)
      (#x6B3E . #x8A03)
      (#x6B3F . #x8A16)
      (#x6B40 . #x8A10)
      (#x6B41 . #x8A0C)
      (#x6B42 . #x8A1B)
      (#x6B43 . #x8A1D)
      (#x6B44 . #x8A25)
      (#x6B45 . #x8A36)
      (#x6B46 . #x8A41)
      (#x6B47 . #x8A5B)
      (#x6B48 . #x8A52)
      (#x6B49 . #x8A46)
      (#x6B4A . #x8A48)
      (#x6B4B . #x8A7C)
      (#x6B4C . #x8A6D)
      (#x6B4D . #x8A6C)
      (#x6B4E . #x8A62)
      (#x6B4F . #x8A85)
      (#x6B50 . #x8A82)
      (#x6B51 . #x8A84)
      (#x6B52 . #x8AA8)
      (#x6B53 . #x8AA1)
      (#x6B54 . #x8A91)
      (#x6B55 . #x8AA5)
      (#x6B56 . #x8AA6)
      (#x6B57 . #x8A9A)
      (#x6B58 . #x8AA3)
      (#x6B59 . #x8AC4)
      (#x6B5A . #x8ACD)
      (#x6B5B . #x8AC2)
      (#x6B5C . #x8ADA)
      (#x6B5D . #x8AEB)
      (#x6B5E . #x8AF3)
      (#x6B5F . #x8AE7)
      (#x6B60 . #x8AE4)
      (#x6B61 . #x8AF1)
      (#x6B62 . #x8B14)
      (#x6B63 . #x8AE0)
      (#x6B64 . #x8AE2)
      (#x6B65 . #x8AF7)
      (#x6B66 . #x8ADE)
      (#x6B67 . #x8ADB)
      (#x6B68 . #x8B0C)
      (#x6B69 . #x8B07)
      (#x6B6A . #x8B1A)
      (#x6B6B . #x8AE1)
      (#x6B6C . #x8B16)
      (#x6B6D . #x8B10)
      (#x6B6E . #x8B17)
      (#x6B6F . #x8B20)
      (#x6B70 . #x8B33)
      (#x6B71 . #x97AB)
      (#x6B72 . #x8B26)
      (#x6B73 . #x8B2B)
      (#x6B74 . #x8B3E)
      (#x6B75 . #x8B28)
      (#x6B76 . #x8B41)
      (#x6B77 . #x8B4C)
      (#x6B78 . #x8B4F)
      (#x6B79 . #x8B4E)
      (#x6B7A . #x8B49)
      (#x6B7B . #x8B56)
      (#x6B7C . #x8B5B)
      (#x6B7D . #x8B5A)
      (#x6B7E . #x8B6B)
      (#x6C21 . #x8B5F)
      (#x6C22 . #x8B6C)
      (#x6C23 . #x8B6F)
      (#x6C24 . #x8B74)
      (#x6C25 . #x8B7D)
      (#x6C26 . #x8B80)
      (#x6C27 . #x8B8C)
      (#x6C28 . #x8B8E)
      (#x6C29 . #x8B92)
      (#x6C2A . #x8B93)
      (#x6C2B . #x8B96)
      (#x6C2C . #x8B99)
      (#x6C2D . #x8B9A)
      (#x6C2E . #x8C3A)
      (#x6C2F . #x8C41)
      (#x6C30 . #x8C3F)
      (#x6C31 . #x8C48)
      (#x6C32 . #x8C4C)
      (#x6C33 . #x8C4E)
      (#x6C34 . #x8C50)
      (#x6C35 . #x8C55)
      (#x6C36 . #x8C62)
      (#x6C37 . #x8C6C)
      (#x6C38 . #x8C78)
      (#x6C39 . #x8C7A)
      (#x6C3A . #x8C82)
      (#x6C3B . #x8C89)
      (#x6C3C . #x8C85)
      (#x6C3D . #x8C8A)
      (#x6C3E . #x8C8D)
      (#x6C3F . #x8C8E)
      (#x6C40 . #x8C94)
      (#x6C41 . #x8C7C)
      (#x6C42 . #x8C98)
      (#x6C43 . #x621D)
      (#x6C44 . #x8CAD)
      (#x6C45 . #x8CAA)
      (#x6C46 . #x8CBD)
      (#x6C47 . #x8CB2)
      (#x6C48 . #x8CB3)
      (#x6C49 . #x8CAE)
      (#x6C4A . #x8CB6)
      (#x6C4B . #x8CC8)
      (#x6C4C . #x8CC1)
      (#x6C4D . #x8CE4)
      (#x6C4E . #x8CE3)
      (#x6C4F . #x8CDA)
      (#x6C50 . #x8CFD)
      (#x6C51 . #x8CFA)
      (#x6C52 . #x8CFB)
      (#x6C53 . #x8D04)
      (#x6C54 . #x8D05)
      (#x6C55 . #x8D0A)
      (#x6C56 . #x8D07)
      (#x6C57 . #x8D0F)
      (#x6C58 . #x8D0D)
      (#x6C59 . #x8D10)
      (#x6C5A . #x9F4E)
      (#x6C5B . #x8D13)
      (#x6C5C . #x8CCD)
      (#x6C5D . #x8D14)
      (#x6C5E . #x8D16)
      (#x6C5F . #x8D67)
      (#x6C60 . #x8D6D)
      (#x6C61 . #x8D71)
      (#x6C62 . #x8D73)
      (#x6C63 . #x8D81)
      (#x6C64 . #x8D99)
      (#x6C65 . #x8DC2)
      (#x6C66 . #x8DBE)
      (#x6C67 . #x8DBA)
      (#x6C68 . #x8DCF)
      (#x6C69 . #x8DDA)
      (#x6C6A . #x8DD6)
      (#x6C6B . #x8DCC)
      (#x6C6C . #x8DDB)
      (#x6C6D . #x8DCB)
      (#x6C6E . #x8DEA)
      (#x6C6F . #x8DEB)
      (#x6C70 . #x8DDF)
      (#x6C71 . #x8DE3)
      (#x6C72 . #x8DFC)
      (#x6C73 . #x8E08)
      (#x6C74 . #x8E09)
      (#x6C75 . #x8DFF)
      (#x6C76 . #x8E1D)
      (#x6C77 . #x8E1E)
      (#x6C78 . #x8E10)
      (#x6C79 . #x8E1F)
      (#x6C7A . #x8E42)
      (#x6C7B . #x8E35)
      (#x6C7C . #x8E30)
      (#x6C7D . #x8E34)
      (#x6C7E . #x8E4A)
      (#x6D21 . #x8E47)
      (#x6D22 . #x8E49)
      (#x6D23 . #x8E4C)
      (#x6D24 . #x8E50)
      (#x6D25 . #x8E48)
      (#x6D26 . #x8E59)
      (#x6D27 . #x8E64)
      (#x6D28 . #x8E60)
      (#x6D29 . #x8E2A)
      (#x6D2A . #x8E63)
      (#x6D2B . #x8E55)
      (#x6D2C . #x8E76)
      (#x6D2D . #x8E72)
      (#x6D2E . #x8E7C)
      (#x6D2F . #x8E81)
      (#x6D30 . #x8E87)
      (#x6D31 . #x8E85)
      (#x6D32 . #x8E84)
      (#x6D33 . #x8E8B)
      (#x6D34 . #x8E8A)
      (#x6D35 . #x8E93)
      (#x6D36 . #x8E91)
      (#x6D37 . #x8E94)
      (#x6D38 . #x8E99)
      (#x6D39 . #x8EAA)
      (#x6D3A . #x8EA1)
      (#x6D3B . #x8EAC)
      (#x6D3C . #x8EB0)
      (#x6D3D . #x8EC6)
      (#x6D3E . #x8EB1)
      (#x6D3F . #x8EBE)
      (#x6D40 . #x8EC5)
      (#x6D41 . #x8EC8)
      (#x6D42 . #x8ECB)
      (#x6D43 . #x8EDB)
      (#x6D44 . #x8EE3)
      (#x6D45 . #x8EFC)
      (#x6D46 . #x8EFB)
      (#x6D47 . #x8EEB)
      (#x6D48 . #x8EFE)
      (#x6D49 . #x8F0A)
      (#x6D4A . #x8F05)
      (#x6D4B . #x8F15)
      (#x6D4C . #x8F12)
      (#x6D4D . #x8F19)
      (#x6D4E . #x8F13)
      (#x6D4F . #x8F1C)
      (#x6D50 . #x8F1F)
      (#x6D51 . #x8F1B)
      (#x6D52 . #x8F0C)
      (#x6D53 . #x8F26)
      (#x6D54 . #x8F33)
      (#x6D55 . #x8F3B)
      (#x6D56 . #x8F39)
      (#x6D57 . #x8F45)
      (#x6D58 . #x8F42)
      (#x6D59 . #x8F3E)
      (#x6D5A . #x8F4C)
      (#x6D5B . #x8F49)
      (#x6D5C . #x8F46)
      (#x6D5D . #x8F4E)
      (#x6D5E . #x8F57)
      (#x6D5F . #x8F5C)
      (#x6D60 . #x8F62)
      (#x6D61 . #x8F63)
      (#x6D62 . #x8F64)
      (#x6D63 . #x8F9C)
      (#x6D64 . #x8F9F)
      (#x6D65 . #x8FA3)
      (#x6D66 . #x8FAD)
      (#x6D67 . #x8FAF)
      (#x6D68 . #x8FB7)
      (#x6D69 . #x8FDA)
      (#x6D6A . #x8FE5)
      (#x6D6B . #x8FE2)
      (#x6D6C . #x8FEA)
      (#x6D6D . #x8FEF)
      (#x6D6E . #x9087)
      (#x6D6F . #x8FF4)
      (#x6D70 . #x9005)
      (#x6D71 . #x8FF9)
      (#x6D72 . #x8FFA)
      (#x6D73 . #x9011)
      (#x6D74 . #x9015)
      (#x6D75 . #x9021)
      (#x6D76 . #x900D)
      (#x6D77 . #x901E)
      (#x6D78 . #x9016)
      (#x6D79 . #x900B)
      (#x6D7A . #x9027)
      (#x6D7B . #x9036)
      (#x6D7C . #x9035)
      (#x6D7D . #x9039)
      (#x6D7E . #x8FF8)
      (#x6E21 . #x904F)
      (#x6E22 . #x9050)
      (#x6E23 . #x9051)
      (#x6E24 . #x9052)
      (#x6E25 . #x900E)
      (#x6E26 . #x9049)
      (#x6E27 . #x903E)
      (#x6E28 . #x9056)
      (#x6E29 . #x9058)
      (#x6E2A . #x905E)
      (#x6E2B . #x9068)
      (#x6E2C . #x906F)
      (#x6E2D . #x9076)
      (#x6E2E . #x96A8)
      (#x6E2F . #x9072)
      (#x6E30 . #x9082)
      (#x6E31 . #x907D)
      (#x6E32 . #x9081)
      (#x6E33 . #x9080)
      (#x6E34 . #x908A)
      (#x6E35 . #x9089)
      (#x6E36 . #x908F)
      (#x6E37 . #x90A8)
      (#x6E38 . #x90AF)
      (#x6E39 . #x90B1)
      (#x6E3A . #x90B5)
      (#x6E3B . #x90E2)
      (#x6E3C . #x90E4)
      (#x6E3D . #x6248)
      (#x6E3E . #x90DB)
      (#x6E3F . #x9102)
      (#x6E40 . #x9112)
      (#x6E41 . #x9119)
      (#x6E42 . #x9132)
      (#x6E43 . #x9130)
      (#x6E44 . #x914A)
      (#x6E45 . #x9156)
      (#x6E46 . #x9158)
      (#x6E47 . #x9163)
      (#x6E48 . #x9165)
      (#x6E49 . #x9169)
      (#x6E4A . #x9173)
      (#x6E4B . #x9172)
      (#x6E4C . #x918B)
      (#x6E4D . #x9189)
      (#x6E4E . #x9182)
      (#x6E4F . #x91A2)
      (#x6E50 . #x91AB)
      (#x6E51 . #x91AF)
      (#x6E52 . #x91AA)
      (#x6E53 . #x91B5)
      (#x6E54 . #x91B4)
      (#x6E55 . #x91BA)
      (#x6E56 . #x91C0)
      (#x6E57 . #x91C1)
      (#x6E58 . #x91C9)
      (#x6E59 . #x91CB)
      (#x6E5A . #x91D0)
      (#x6E5B . #x91D6)
      (#x6E5C . #x91DF)
      (#x6E5D . #x91E1)
      (#x6E5E . #x91DB)
      (#x6E5F . #x91FC)
      (#x6E60 . #x91F5)
      (#x6E61 . #x91F6)
      (#x6E62 . #x921E)
      (#x6E63 . #x91FF)
      (#x6E64 . #x9214)
      (#x6E65 . #x922C)
      (#x6E66 . #x9215)
      (#x6E67 . #x9211)
      (#x6E68 . #x925E)
      (#x6E69 . #x9257)
      (#x6E6A . #x9245)
      (#x6E6B . #x9249)
      (#x6E6C . #x9264)
      (#x6E6D . #x9248)
      (#x6E6E . #x9295)
      (#x6E6F . #x923F)
      (#x6E70 . #x924B)
      (#x6E71 . #x9250)
      (#x6E72 . #x929C)
      (#x6E73 . #x9296)
      (#x6E74 . #x9293)
      (#x6E75 . #x929B)
      (#x6E76 . #x925A)
      (#x6E77 . #x92CF)
      (#x6E78 . #x92B9)
      (#x6E79 . #x92B7)
      (#x6E7A . #x92E9)
      (#x6E7B . #x930F)
      (#x6E7C . #x92FA)
      (#x6E7D . #x9344)
      (#x6E7E . #x932E)
      (#x6F21 . #x9319)
      (#x6F22 . #x9322)
      (#x6F23 . #x931A)
      (#x6F24 . #x9323)
      (#x6F25 . #x933A)
      (#x6F26 . #x9335)
      (#x6F27 . #x933B)
      (#x6F28 . #x935C)
      (#x6F29 . #x9360)
      (#x6F2A . #x937C)
      (#x6F2B . #x936E)
      (#x6F2C . #x9356)
      (#x6F2D . #x93B0)
      (#x6F2E . #x93AC)
      (#x6F2F . #x93AD)
      (#x6F30 . #x9394)
      (#x6F31 . #x93B9)
      (#x6F32 . #x93D6)
      (#x6F33 . #x93D7)
      (#x6F34 . #x93E8)
      (#x6F35 . #x93E5)
      (#x6F36 . #x93D8)
      (#x6F37 . #x93C3)
      (#x6F38 . #x93DD)
      (#x6F39 . #x93D0)
      (#x6F3A . #x93C8)
      (#x6F3B . #x93E4)
      (#x6F3C . #x941A)
      (#x6F3D . #x9414)
      (#x6F3E . #x9413)
      (#x6F3F . #x9403)
      (#x6F40 . #x9407)
      (#x6F41 . #x9410)
      (#x6F42 . #x9436)
      (#x6F43 . #x942B)
      (#x6F44 . #x9435)
      (#x6F45 . #x9421)
      (#x6F46 . #x943A)
      (#x6F47 . #x9441)
      (#x6F48 . #x9452)
      (#x6F49 . #x9444)
      (#x6F4A . #x945B)
      (#x6F4B . #x9460)
      (#x6F4C . #x9462)
      (#x6F4D . #x945E)
      (#x6F4E . #x946A)
      (#x6F4F . #x9229)
      (#x6F50 . #x9470)
      (#x6F51 . #x9475)
      (#x6F52 . #x9477)
      (#x6F53 . #x947D)
      (#x6F54 . #x945A)
      (#x6F55 . #x947C)
      (#x6F56 . #x947E)
      (#x6F57 . #x9481)
      (#x6F58 . #x947F)
      (#x6F59 . #x9582)
      (#x6F5A . #x9587)
      (#x6F5B . #x958A)
      (#x6F5C . #x9594)
      (#x6F5D . #x9596)
      (#x6F5E . #x9598)
      (#x6F5F . #x9599)
      (#x6F60 . #x95A0)
      (#x6F61 . #x95A8)
      (#x6F62 . #x95A7)
      (#x6F63 . #x95AD)
      (#x6F64 . #x95BC)
      (#x6F65 . #x95BB)
      (#x6F66 . #x95B9)
      (#x6F67 . #x95BE)
      (#x6F68 . #x95CA)
      (#x6F69 . #x6FF6)
      (#x6F6A . #x95C3)
      (#x6F6B . #x95CD)
      (#x6F6C . #x95CC)
      (#x6F6D . #x95D5)
      (#x6F6E . #x95D4)
      (#x6F6F . #x95D6)
      (#x6F70 . #x95DC)
      (#x6F71 . #x95E1)
      (#x6F72 . #x95E5)
      (#x6F73 . #x95E2)
      (#x6F74 . #x9621)
      (#x6F75 . #x9628)
      (#x6F76 . #x962E)
      (#x6F77 . #x962F)
      (#x6F78 . #x9642)
      (#x6F79 . #x964C)
      (#x6F7A . #x964F)
      (#x6F7B . #x964B)
      (#x6F7C . #x9677)
      (#x6F7D . #x965C)
      (#x6F7E . #x965E)
      (#x7021 . #x965D)
      (#x7022 . #x965F)
      (#x7023 . #x9666)
      (#x7024 . #x9672)
      (#x7025 . #x966C)
      (#x7026 . #x968D)
      (#x7027 . #x9698)
      (#x7028 . #x9695)
      (#x7029 . #x9697)
      (#x702A . #x96AA)
      (#x702B . #x96A7)
      (#x702C . #x96B1)
      (#x702D . #x96B2)
      (#x702E . #x96B0)
      (#x702F . #x96B4)
      (#x7030 . #x96B6)
      (#x7031 . #x96B8)
      (#x7032 . #x96B9)
      (#x7033 . #x96CE)
      (#x7034 . #x96CB)
      (#x7035 . #x96C9)
      (#x7036 . #x96CD)
      (#x7037 . #x894D)
      (#x7038 . #x96DC)
      (#x7039 . #x970D)
      (#x703A . #x96D5)
      (#x703B . #x96F9)
      (#x703C . #x9704)
      (#x703D . #x9706)
      (#x703E . #x9708)
      (#x703F . #x9713)
      (#x7040 . #x970E)
      (#x7041 . #x9711)
      (#x7042 . #x970F)
      (#x7043 . #x9716)
      (#x7044 . #x9719)
      (#x7045 . #x9724)
      (#x7046 . #x972A)
      (#x7047 . #x9730)
      (#x7048 . #x9739)
      (#x7049 . #x973D)
      (#x704A . #x973E)
      (#x704B . #x9744)
      (#x704C . #x9746)
      (#x704D . #x9748)
      (#x704E . #x9742)
      (#x704F . #x9749)
      (#x7050 . #x975C)
      (#x7051 . #x9760)
      (#x7052 . #x9764)
      (#x7053 . #x9766)
      (#x7054 . #x9768)
      (#x7055 . #x52D2)
      (#x7056 . #x976B)
      (#x7057 . #x9771)
      (#x7058 . #x9779)
      (#x7059 . #x9785)
      (#x705A . #x977C)
      (#x705B . #x9781)
      (#x705C . #x977A)
      (#x705D . #x9786)
      (#x705E . #x978B)
      (#x705F . #x978F)
      (#x7060 . #x9790)
      (#x7061 . #x979C)
      (#x7062 . #x97A8)
      (#x7063 . #x97A6)
      (#x7064 . #x97A3)
      (#x7065 . #x97B3)
      (#x7066 . #x97B4)
      (#x7067 . #x97C3)
      (#x7068 . #x97C6)
      (#x7069 . #x97C8)
      (#x706A . #x97CB)
      (#x706B . #x97DC)
      (#x706C . #x97ED)
      (#x706D . #x9F4F)
      (#x706E . #x97F2)
      (#x706F . #x7ADF)
      (#x7070 . #x97F6)
      (#x7071 . #x97F5)
      (#x7072 . #x980F)
      (#x7073 . #x980C)
      (#x7074 . #x9838)
      (#x7075 . #x9824)
      (#x7076 . #x9821)
      (#x7077 . #x9837)
      (#x7078 . #x983D)
      (#x7079 . #x9846)
      (#x707A . #x984F)
      (#x707B . #x984B)
      (#x707C . #x986B)
      (#x707D . #x986F)
      (#x707E . #x9870)
      (#x7121 . #x9871)
      (#x7122 . #x9874)
      (#x7123 . #x9873)
      (#x7124 . #x98AA)
      (#x7125 . #x98AF)
      (#x7126 . #x98B1)
      (#x7127 . #x98B6)
      (#x7128 . #x98C4)
      (#x7129 . #x98C3)
      (#x712A . #x98C6)
      (#x712B . #x98E9)
      (#x712C . #x98EB)
      (#x712D . #x9903)
      (#x712E . #x9909)
      (#x712F . #x9912)
      (#x7130 . #x9914)
      (#x7131 . #x9918)
      (#x7132 . #x9921)
      (#x7133 . #x991D)
      (#x7134 . #x991E)
      (#x7135 . #x9924)
      (#x7136 . #x9920)
      (#x7137 . #x992C)
      (#x7138 . #x992E)
      (#x7139 . #x993D)
      (#x713A . #x993E)
      (#x713B . #x9942)
      (#x713C . #x9949)
      (#x713D . #x9945)
      (#x713E . #x9950)
      (#x713F . #x994B)
      (#x7140 . #x9951)
      (#x7141 . #x9952)
      (#x7142 . #x994C)
      (#x7143 . #x9955)
      (#x7144 . #x9997)
      (#x7145 . #x9998)
      (#x7146 . #x99A5)
      (#x7147 . #x99AD)
      (#x7148 . #x99AE)
      (#x7149 . #x99BC)
      (#x714A . #x99DF)
      (#x714B . #x99DB)
      (#x714C . #x99DD)
      (#x714D . #x99D8)
      (#x714E . #x99D1)
      (#x714F . #x99ED)
      (#x7150 . #x99EE)
      (#x7151 . #x99F1)
      (#x7152 . #x99F2)
      (#x7153 . #x99FB)
      (#x7154 . #x99F8)
      (#x7155 . #x9A01)
      (#x7156 . #x9A0F)
      (#x7157 . #x9A05)
      (#x7158 . #x99E2)
      (#x7159 . #x9A19)
      (#x715A . #x9A2B)
      (#x715B . #x9A37)
      (#x715C . #x9A45)
      (#x715D . #x9A42)
      (#x715E . #x9A40)
      (#x715F . #x9A43)
      (#x7160 . #x9A3E)
      (#x7161 . #x9A55)
      (#x7162 . #x9A4D)
      (#x7163 . #x9A5B)
      (#x7164 . #x9A57)
      (#x7165 . #x9A5F)
      (#x7166 . #x9A62)
      (#x7167 . #x9A65)
      (#x7168 . #x9A64)
      (#x7169 . #x9A69)
      (#x716A . #x9A6B)
      (#x716B . #x9A6A)
      (#x716C . #x9AAD)
      (#x716D . #x9AB0)
      (#x716E . #x9ABC)
      (#x716F . #x9AC0)
      (#x7170 . #x9ACF)
      (#x7171 . #x9AD1)
      (#x7172 . #x9AD3)
      (#x7173 . #x9AD4)
      (#x7174 . #x9ADE)
      (#x7175 . #x9ADF)
      (#x7176 . #x9AE2)
      (#x7177 . #x9AE3)
      (#x7178 . #x9AE6)
      (#x7179 . #x9AEF)
      (#x717A . #x9AEB)
      (#x717B . #x9AEE)
      (#x717C . #x9AF4)
      (#x717D . #x9AF1)
      (#x717E . #x9AF7)
      (#x7221 . #x9AFB)
      (#x7222 . #x9B06)
      (#x7223 . #x9B18)
      (#x7224 . #x9B1A)
      (#x7225 . #x9B1F)
      (#x7226 . #x9B22)
      (#x7227 . #x9B23)
      (#x7228 . #x9B25)
      (#x7229 . #x9B27)
      (#x722A . #x9B28)
      (#x722B . #x9B29)
      (#x722C . #x9B2A)
      (#x722D . #x9B2E)
      (#x722E . #x9B2F)
      (#x722F . #x9B32)
      (#x7230 . #x9B44)
      (#x7231 . #x9B43)
      (#x7232 . #x9B4F)
      (#x7233 . #x9B4D)
      (#x7234 . #x9B4E)
      (#x7235 . #x9B51)
      (#x7236 . #x9B58)
      (#x7237 . #x9B74)
      (#x7238 . #x9B93)
      (#x7239 . #x9B83)
      (#x723A . #x9B91)
      (#x723B . #x9B96)
      (#x723C . #x9B97)
      (#x723D . #x9B9F)
      (#x723E . #x9BA0)
      (#x723F . #x9BA8)
      (#x7240 . #x9BB4)
      (#x7241 . #x9BC0)
      (#x7242 . #x9BCA)
      (#x7243 . #x9BB9)
      (#x7244 . #x9BC6)
      (#x7245 . #x9BCF)
      (#x7246 . #x9BD1)
      (#x7247 . #x9BD2)
      (#x7248 . #x9BE3)
      (#x7249 . #x9BE2)
      (#x724A . #x9BE4)
      (#x724B . #x9BD4)
      (#x724C . #x9BE1)
      (#x724D . #x9C3A)
      (#x724E . #x9BF2)
      (#x724F . #x9BF1)
      (#x7250 . #x9BF0)
      (#x7251 . #x9C15)
      (#x7252 . #x9C14)
      (#x7253 . #x9C09)
      (#x7254 . #x9C13)
      (#x7255 . #x9C0C)
      (#x7256 . #x9C06)
      (#x7257 . #x9C08)
      (#x7258 . #x9C12)
      (#x7259 . #x9C0A)
      (#x725A . #x9C04)
      (#x725B . #x9C2E)
      (#x725C . #x9C1B)
      (#x725D . #x9C25)
      (#x725E . #x9C24)
      (#x725F . #x9C21)
      (#x7260 . #x9C30)
      (#x7261 . #x9C47)
      (#x7262 . #x9C32)
      (#x7263 . #x9C46)
      (#x7264 . #x9C3E)
      (#x7265 . #x9C5A)
      (#x7266 . #x9C60)
      (#x7267 . #x9C67)
      (#x7268 . #x9C76)
      (#x7269 . #x9C78)
      (#x726A . #x9CE7)
      (#x726B . #x9CEC)
      (#x726C . #x9CF0)
      (#x726D . #x9D09)
      (#x726E . #x9D08)
      (#x726F . #x9CEB)
      (#x7270 . #x9D03)
      (#x7271 . #x9D06)
      (#x7272 . #x9D2A)
      (#x7273 . #x9D26)
      (#x7274 . #x9DAF)
      (#x7275 . #x9D23)
      (#x7276 . #x9D1F)
      (#x7277 . #x9D44)
      (#x7278 . #x9D15)
      (#x7279 . #x9D12)
      (#x727A . #x9D41)
      (#x727B . #x9D3F)
      (#x727C . #x9D3E)
      (#x727D . #x9D46)
      (#x727E . #x9D48)
      (#x7321 . #x9D5D)
      (#x7322 . #x9D5E)
      (#x7323 . #x9D64)
      (#x7324 . #x9D51)
      (#x7325 . #x9D50)
      (#x7326 . #x9D59)
      (#x7327 . #x9D72)
      (#x7328 . #x9D89)
      (#x7329 . #x9D87)
      (#x732A . #x9DAB)
      (#x732B . #x9D6F)
      (#x732C . #x9D7A)
      (#x732D . #x9D9A)
      (#x732E . #x9DA4)
      (#x732F . #x9DA9)
      (#x7330 . #x9DB2)
      (#x7331 . #x9DC4)
      (#x7332 . #x9DC1)
      (#x7333 . #x9DBB)
      (#x7334 . #x9DB8)
      (#x7335 . #x9DBA)
      (#x7336 . #x9DC6)
      (#x7337 . #x9DCF)
      (#x7338 . #x9DC2)
      (#x7339 . #x9DD9)
      (#x733A . #x9DD3)
      (#x733B . #x9DF8)
      (#x733C . #x9DE6)
      (#x733D . #x9DED)
      (#x733E . #x9DEF)
      (#x733F . #x9DFD)
      (#x7340 . #x9E1A)
      (#x7341 . #x9E1B)
      (#x7342 . #x9E1E)
      (#x7343 . #x9E75)
      (#x7344 . #x9E79)
      (#x7345 . #x9E7D)
      (#x7346 . #x9E81)
      (#x7347 . #x9E88)
      (#x7348 . #x9E8B)
      (#x7349 . #x9E8C)
      (#x734A . #x9E92)
      (#x734B . #x9E95)
      (#x734C . #x9E91)
      (#x734D . #x9E9D)
      (#x734E . #x9EA5)
      (#x734F . #x9EA9)
      (#x7350 . #x9EB8)
      (#x7351 . #x9EAA)
      (#x7352 . #x9EAD)
      (#x7353 . #x9761)
      (#x7354 . #x9ECC)
      (#x7355 . #x9ECE)
      (#x7356 . #x9ECF)
      (#x7357 . #x9ED0)
      (#x7358 . #x9ED4)
      (#x7359 . #x9EDC)
      (#x735A . #x9EDE)
      (#x735B . #x9EDD)
      (#x735C . #x9EE0)
      (#x735D . #x9EE5)
      (#x735E . #x9EE8)
      (#x735F . #x9EEF)
      (#x7360 . #x9EF4)
      (#x7361 . #x9EF6)
      (#x7362 . #x9EF7)
      (#x7363 . #x9EF9)
      (#x7364 . #x9EFB)
      (#x7365 . #x9EFC)
      (#x7366 . #x9EFD)
      (#x7367 . #x9F07)
      (#x7368 . #x9F08)
      (#x7369 . #x76B7)
      (#x736A . #x9F15)
      (#x736B . #x9F21)
      (#x736C . #x9F2C)
      (#x736D . #x9F3E)
      (#x736E . #x9F4A)
      (#x736F . #x9F52)
      (#x7370 . #x9F54)
      (#x7371 . #x9F63)
      (#x7372 . #x9F5F)
      (#x7373 . #x9F60)
      (#x7374 . #x9F61)
      (#x7375 . #x9F66)
      (#x7376 . #x9F67)
      (#x7377 . #x9F6C)
      (#x7378 . #x9F6A)
      (#x7379 . #x9F77)
      (#x737A . #x9F72)
      (#x737B . #x9F76)
      (#x737C . #x9F95)
      (#x737D . #x9F9C)
      (#x737E . #x9FA0)
      (#x7421 . #x582F)
      (#x7422 . #x69C7)
      (#x7423 . #x9059)
      (#x7424 . #x7464)
      (#x7425 . #x51DC)
      (#x7426 . #x7199)))

(defvar *jis-to-unicode-trie* nil)

(defun build-tries ()
  (flet ((build-trie (index-key value-key)
	   (let ((trie (make-array #.(expt 2 8))))
	     (dotimes (i (length trie))
	       (setf (aref trie i)
		 (make-array #.(expt 2 8)
			     :element-type '(mod #.(expt 2 16))
			     :initial-element 0)))
	     (dolist (pair jis-to-unicode-list)
	       (let ((index-code (funcall index-key pair))
		     (value-code (funcall value-key pair)))
		 (setf (aref
			(aref trie (logand #.(1- (expt 2 8))
					   (ash index-code -8)))
			(logand #.(1- (expt 2 8)) index-code))
		   value-code)))

	     ;; optimize for space
	     (dotimes (i (length trie))
	       (do ((j (1+ i) (1+ j)))
		   ((>= j (length trie)))
		 (let ((arrayi (aref trie i))
		       (arrayj (aref trie j)))
		   
		   ;; don't compare if they're already eq
		   (unless (eq arrayi arrayj)
		     (when (equalp arrayi arrayj)
		       (format t "~&collapsing ~s to ~s~%" j i)
		       (setf (aref trie j) arrayi))))))
	     trie)))
    #+ignore (setq *jis-to-unicode-trie* (build-trie #'car #'cdr))
    (setq *unicode-to-jis-trie* (build-trie #'cdr #'car))))
|#

;; This is the trie built from the above (commented out table and code).
;;
(defvar *unicode-to-jis-trie*
    #(#(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8512 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8561 8562 0
	0 0 8568 8495 0 0 0 8780 0 0 0 8555 8542 0 0 8493 0 8825 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8543 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8544 0 0 0 0
	0 0 0 0)
      #1=#(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	   0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #1#
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 9761 9762 9763 9764 9765 9766 9767 9768 9769 9770
	9771 9772 9773 9774 9775 9776 9777 0 9778 9779 9780 9781 9782 9783
	9784 0 0 0 0 0 0 0 9793 9794 9795 9796 9797 9798 9799 9800 9801
	9802 9803 9804 9805 9806 9807 9808 9809 0 9810 9811 9812 9813 9814
	9815 9816 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #(0 10023 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10017 10018 10019 10020 10021
	10022 10024 10025 10026 10027 10028 10029 10030 10031 10032 10033
	10034 10035 10036 10037 10038 10039 10040 10041 10042 10043 10044
	10045 10046 10047 10048 10049 10065 10066 10067 10068 10069 10070
	10072 10073 10074 10075 10076 10077 10078 10079 10080 10081 10082
	10083 10084 10085 10086 10087 10088 10089 10090 10091 10092 10093
	10094 10095 10096 10097 0 10071 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8510 0 0 0 0 8509 8514 0 8518 8519
	0 0 8520 8521 0 0 8823 8824 0 0 0 8517 8516 0 0 0 0 0 0 0 0 0 8819
	0 8556 8557 0 0 0 0 0 0 0 8744 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0)
      #(0 0 0 8558 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 8818 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 8747 8748 8746 8749 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8781 0 8782 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #(8783 0 8799 8784 0 0 0 8800 8762 0 0 8763 0 0 0 0 0 0 8541 0 0 0 0
	0 0 0 8805 0 0 8807 8551 0 8796 0 0 0 0 0 0 8778 8779 8769 8768
	8809 8810 0 0 0 0 0 0 0 8552 8808 0 0 0 0 0 0 0 8806 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 8802 0 0 0 0 0 0 0 0 0 0 0 0 0 8546 8801
	0 0 0 0 8549 8550 0 0 8803 8804 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 8766 8767 0 0 8764 8765 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 8797 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8798 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #1#
      #(10273 10284 10274 10285 0 0 0 0 0 0 0 0 10275 0 0 10286 10276 0 0
	10287 10278 0 0 10289 10277 0 0 10288 10279 10300 0 0 10295 0 0
	10290 10281 10302 0 0 10297 0 0 10292 10280 0 0 10296 10301 0 0
	10291 10282 0 0 10298 10303 0 0 10293 10283 0 0 10299 0 0 10304 0 0
	0 0 0 0 0 0 10294 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8739 8738 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 8741 8740 0 0 0 0 0 0 0 0 8743 8742 0 0 0 0
	0 0 0 0 8737 8574 0 0 0 8571 0 0 8573 8572 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8830 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0)
      #(0 0 0 0 0 8570 8569 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	8554 0 8553 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 8822 0 0 8821 0 8820 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #(8481 8482 8483 8503 0 8505 8506 8507 8530 8531 8532 8533 8534 8535
	8536 8537 8538 8539 8745 8750 8524 8525 0 0 0 0 0 0 8513 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 9249
	9250 9251 9252 9253 9254 9255 9256 9257 9258 9259 9260 9261 9262
	9263 9264 9265 9266 9267 9268 9269 9270 9271 9272 9273 9274 9275
	9276 9277 9278 9279 9280 9281 9282 9283 9284 9285 9286 9287 9288
	9289 9290 9291 9292 9293 9294 9295 9296 9297 9298 9299 9300 9301
	9302 9303 9304 9305 9306 9307 9308 9309 9310 9311 9312 9313 9314
	9315 9316 9317 9318 9319 9320 9321 9322 9323 9324 9325 9326 9327
	9328 9329 9330 9331 0 0 0 0 0 0 0 8491 8492 8501 8502 0 0 9505 9506
	9507 9508 9509 9510 9511 9512 9513 9514 9515 9516 9517 9518 9519
	9520 9521 9522 9523 9524 9525 9526 9527 9528 9529 9530 9531 9532
	9533 9534 9535 9536 9537 9538 9539 9540 9541 9542 9543 9544 9545
	9546 9547 9548 9549 9550 9551 9552 9553 9554 9555 9556 9557 9558
	9559 9560 9561 9562 9563 9564 9565 9566 9567 9568 9569 9570 9571
	9572 9573 9574 9575 9576 9577 9578 9579 9580 9581 9582 9583 9584
	9585 9586 9587 9588 9589 9590 0 0 0 0 8486 8508 8499 8500 0)
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #(12396 17274 0 15415 0 0 0 19324 15974 15152 15973 12860 0 18772
	19775 0 20514 12591 0 0 13166 20515 16420 21058 13654 19002 0 0 0 0
	15975 0 0 20030 0 0 0 0 19010 0 0 0 20516 0 0 17254 0 0 0 20517
	13946 0 0 0 20518 0 13405 17200 0 15463 20519 0 0 20520 0 0 20521
	18229 0 13655 0 0 0 0 0 18231 0 18019 14403 19251 0 0 0 0 0 26953
	20522 15976 20523 12853 0 0 0 13925 14448 19561 0 0 22054 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 19824 0 18045 0 0 0 0 0 0 0 0 0 0 13349 0 13621 0
	20524 0 0 20525 20027 0 19773 16744 20527 15222 18035 0 20530 0 0
	12606 14431 0 14430 12390 0 0 20299 20298 0 14899 12321 0 20531
	20532 20533 19252 20534 0 14450 12391 19314 0 13692 0 0 13693 13694
	17506 20028 0 20535 0 0 20536 0 0 20537 0 0 0 16205 0 0 0 0 0 15674
	16206 20542 0 20540 0 20541 13656 0 0 14883 12912 0 20539 20538
	18985 0 0 0 0 15174 15173 16958 20543 18773 16487 0 0 0 8504 20544
	20546 0 0 0 16997 20065 12362 0 0 0 0 0 0 0 20545 12862 0 13892 0
	17255 0 0 0 14191 20547 0 0 0 18212 0 0 0 0)
      #(0 13419 0 0 0 0 0 0 0 20548 12363 0 0 14432 13420 18810 18482 13657
	0 0 0 0 0 0 0 0 12913 0 20583 17729 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 18284 20550 0 0 0 18492 0 20066 0 16173 0 15175 0 15223 12864 0 0
	0 0 0 17489 0 0 17186 20554 0 0 0 0 0 12364 17507 15675 14900 19748
	0 16974 0 12863 0 20553 0 19774 20549 20551 14958 20552 21796 0 0 0
	0 0 0 0 0 0 0 20560 0 0 0 0 0 20563 20561 0 0 12866 0 19003 20555 0
	0 0 0 20559 14451 0 0 15176 0 0 0 13350 0 0 20564 0 20556 0 0 20067
	0 15224 0 20557 0 20562 0 0 0 0 20565 0 20558 0 0 13857 0 12365 0 0
	13858 12865 0 0 0 0 0 0 0 0 0 21797 0 19321 18798 14452 0 0 0 0 0
	16175 20023 0 0 0 0 0 0 0 0 19032 0 0 14136 16933 12900 0 0 0 0 0
	15699 0 0 0 20569 0 20574 20572 0 0 20567 0 0 16943 20570 0 20573
	20571 0 19037 0 20568 0 16174 0 19315 20575 20576 0 0 0 0 0 0 0 0
	15652 20589 0 0 0 18256 0 18742 20584 0 19056 0 12854 0 0 0 20588
	0)
      #(0 0 0 0 0 20582 20591 0 0 16722 0 14404 0 18268 0 24647 0 20590
	17757 0 20579 0 14454 0 0 14453 20577 0 0 0 0 15450 0 20585 0 19055
	17229 20581 14193 0 20578 20586 20580 20049 20587 20289 0 0 0 0 0 0
	0 0 13926 0 0 14192 0 0 0 0 0 0 0 0 0 20592 0 0 0 20593 20597 12366
	0 0 0 0 0 19024 20596 0 0 0 0 20595 20599 0 0 0 20598 0 17508 0 0 0
	0 0 0 0 0 14194 0 0 0 0 0 0 20600 0 0 0 0 0 15429 0 16934 17509
	13942 0 20601 0 0 0 0 13622 0 0 20602 0 0 0 0 20604 0 0 0 0 0 0 0
	19253 0 0 0 14182 0 0 0 0 0 0 15153 18551 20603 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 14917 19779 0 0 0 0 20606 20771 20605 14916 0 15741 0
	0 0 0 0 0 14137 0 0 0 20772 0 0 13903 0 0 0 20769 20770 0 0 17967 0
	16764 0 13859 0 0 0 19277 20773 0 0 0 20029 0 0 0 20774 0 0 0 0
	20777 0 20775 0 16718 0 0 0 0 0 20776 20778 0 0 0 0 0 0 20780 0 0 0
	20779 0 19016 0 0 0 0)
      #(13623 20782 20783 0 12847 0 0 0 0 20781 0 0 0 0 0 0 0 0 15476 0
	20786 20785 20784 0 20566 0 20787 0 0 0 0 15742 0 20788 0 0 0 0 0 0
	0 0 19749 0 0 0 0 0 0 0 19545 0 0 0 0 20790 0 0 20789 20792 20791 0
	0 20793 20794 12404 0 14389 14139 15676 17275 13860 16488 14455 0
	14702 20796 19528 17734 0 15225 0 20795 0 20797 0 0 0 0 0 17758 0
	13173 0 0 0 0 0 20798 0 0 18046 0 0 16692 20800 20801 18476 14456
	20283 20802 0 0 13862 0 0 0 19004 16950 13937 17717 0 0 0 14195 0 0
	0 20803 0 20804 0 0 18018 12639 0 0 20807 14973 0 20806 14918 0
	20808 26222 20809 19265 20810 0 20811 20812 15977 0 15436 0 0 0 0 0
	0 13351 0 20815 0 20813 19517 20814 0 18778 20816 20817 20818 17759
	0 0 0 20822 20820 20821 20819 14947 20823 19562 20068 0 0 0 0 0
	20824 0 0 0 0 0 0 16424 20825 15706 0 0 20826 0 17276 20031 17760 0
	0 0 0 0 0 0 0 21061 0 0 0 0 20827 29733 13893 0 0 20828 19294 0 0 0
	0 15720 17020 0 20830 18020 0 0 20831 0 0 20832 13102 0 0 0 20833
	13863 0 17996 12666 15696 0 0 18465 20834 0)
      #(17761 0 0 16207 20835 0 18988 16474 13346 0 13353 20836 0 0 20838 0
	0 14138 0 0 20837 0 0 20083 0 0 0 0 0 15721 0 0 0 0 0 0 18493 19020
	0 20839 0 19832 20840 0 0 0 20841 0 17790 0 0 20842 0 0 16425 14974
	14196 20843 15177 14703 0 0 0 0 0 0 0 17510 20845 0 0 16935 0 0
	14959 20846 20847 16688 0 20844 0 0 0 0 20849 0 19254 0 0 0 0 14692
	0 0 20848 0 0 0 0 14197 14942 18285 0 0 0 20852 20850 0 0 0 0 18811
	15978 20859 13156 20853 20851 16719 0 0 0 0 0 0 0 20855 0 20854 0 0
	0 13124 0 0 0 14176 20860 20013 0 0 0 20856 0 0 0 20861 20858 0
	20857 0 0 0 0 0 0 20047 0 0 0 14457 12867 0 0 20084 0 0 0 0 0 15733
	17752 14693 21026 21027 0 0 0 20069 0 0 20267 21029 0 0 0 14458 0 0
	21028 0 13103 0 0 21030 0 19286 0 17468 0 19750 0 19033 0 0 0 21031
	0 0 0 0 28757 0 0 17968 0 21032 13354 19507 0 0 0 15905 21033 19047
	21037 0 16426 21034 13904 0 21035 13355 0 0 0 0 0 0 0 0 0 0 14126
	21038 0 21039 0 0 21040 21041 15451 0 0 0 14459 19550)
      #(0 19560 18039 0 0 19057 21042 0 21043 0 0 0 0 21045 0 21047 21046 0
	0 0 0 21048 12861 19276 0 14972 21049 0 0 16729 0 0 15906 13865 0
	21050 0 0 0 0 0 0 18523 0 0 0 0 21051 0 21052 0 21053 0 0 0 0 21054
	18724 13928 12389 0 0 0 17983 21055 15677 0 16489 0 21057 21056
	15907 14433 21059 18494 0 0 21060 0 0 0 18524 16948 17006 13864 0 0
	18030 17201 0 18286 0 19278 0 21062 0 16490 0 0 0 0 0 14133 0 0
	21063 0 0 0 0 21064 12588 12405 13421 0 16936 13649 19825 0 21067
	12855 0 0 21066 0 0 0 13866 0 0 21068 0 19569 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 21069 0 20050 0 14460 0 0 0 0 14390 21070 0 0 0 0 21072
	21071 0 16223 12601 0 0 0 12638 21073 0 21074 0 0 14391 0 0 21075 0
	0 0 0 13678 0 0 0 0 0 0 15154 21076 0 0 0 0 19316 14901 13658 19751
	16720 18495 15485 0 0 0 0 0 15687 0 15464 15477 0 15734 0 18496 0 0
	0 21079 0 12611 16721 14461 14405 13927 0 0 21083 17185 17022 13867
	15908 21084 21082 12868 16998 15416 15179 12582 0 0 13168 14694
	15178 0 21085 0 0 0 0 0)
      #(0 21086 0 13641 13126 0 0 0 14695 13640 17503 12581 17969 19518
	14625 19833 17735 14462 0 0 0 0 0 0 0 0 0 14127 0 21095 0 13923
	19274 0 0 0 0 0 18525 0 0 21094 0 13406 21089 21090 21092 0 0 0 0 0
	0 0 21093 0 13659 16225 0 18989 21091 21087 14435 0 21088 0 20260 0
	0 0 19058 0 17512 14434 14704 0 0 0 21096 0 0 18013 0 0 0 0 0 0 0 0
	0 0 0 0 0 21100 0 0 0 0 0 0 0 0 15486 0 15478 0 0 0 0 0 21103 21101
	0 19491 0 21098 21107 21102 0 0 0 21105 14406 19519 0 0 21106 0 0 0
	21108 0 21110 0 0 0 0 14960 20290 0 21099 21097 21109 0 21104 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 21112 0 21283 21114 0 0 21118 0 0 21281
	21115 0 0 21310 0 0 14953 13105 0 0 0 0 21113 0 0 0 21285 12406
	21284 0 12325 18762 21282 0 21116 0 0 21111 21117 14920 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 21286 0 0 0 0 0 0 0 0 12407 21295 0 0 21287 21288 0
	15909 19305 0 0 0 21293 21292 0 0 0 17711 0 0 0 0 0 0 0 21294 0 0
	21291 0 0)
      #(0 0 0 0 12596 0 14902 16176 0 0 0 0 0 0 0 21289 17762 0 0 0 21290 0
	12322 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 21300 19747 0
	15911 0 21306 0 0 0 0 21305 21296 0 0 0 0 16963 0 21297 0 0 0 17007
	21302 15910 0 0 0 0 0 21299 0 0 19556 0 0 0 14140 0 0 21303 21304 0
	0 0 0 21301 21307 0 0 0 0 0 21298 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 21313 21318 0 21314 0 21309 0 0 21319 16689 0 0 21321 0
	14626 21311 17277 0 0 0 0 0 0 0 0 0 0 0 0 21315 21308 13357 0 13422
	13157 21316 21312 0 0 0 0 0 0 0 14198 21322 21320 16723 13642 13868
	0 21317 0 13940 0 0 0 0 0 12612 0 0 0 0 0 0 0 0 0 0 0 0 0 21326
	21324 0 21543 0 0 0 0 0 0 0 0 0 0 0 0 21329 0 0 0 0 0 21323 0 21327
	0 0 21325 0 0 0 15180 21328 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	21331 0 21336 0 0 0 21334 21333 0)
      #(0 0 0 0 0 0 17202 0 0 12869 0 0 0 0 0 0 0 0 0 0 21330 0 21332 15912
	12595 0 0 21335 0 0 0 0 0 0 0 0 0 0 0 0 0 12894 0 0 0 0 0 21346 0
	15996 21342 0 21340 0 21341 0 21343 0 0 0 0 0 0 0 0 0 12605 0 0 0 0
	0 0 0 0 0 16697 0 21337 0 21338 0 0 0 0 0 0 0 0 0 0 13178 0 0 0 0 0
	0 0 0 21345 0 0 0 13423 0 21348 21344 21347 0 0 0 0 0 0 0 18990 0 0
	0 18005 0 18488 0 0 0 0 0 21350 0 0 0 0 0 21349 13125 0 0 21351 0 0
	0 0 21354 0 0 0 0 21353 0 0 0 0 0 0 0 0 0 0 0 21352 0 18233 0 0
	21355 0 0 0 0 0 0 0 0 21356 0 0 0 0 0 21358 0 21357 0 0 0 0 0 21360
	0 0 0 21363 21361 21359 21362 0 0 0 0 21364 0 0 0 0 0 21365 0 0
	21366 0 21367 0 0 0 21368 20805 0 15484 15181 0 0 12915 0 12408 0 0
	17220 0 0 0 0 0 0 0 0 0 0 21369 0 14884 0 12367 16222 0 0 0 0 0
	21370 14407 0 0 14705 0 21372)
      #(21371 0 0 19040 21373 0 0 0 21537 21374 0 21538 0 21539 0 14199 0 0
	12640 21540 0 0 21542 0 21541 0 0 0 21544 0 0 17754 0 0 0 0 0 0
	21545 12341 14943 0 0 0 0 14141 0 0 17231 0 0 0 0 0 0 21546 21547 0
	0 21549 0 0 0 0 21550 0 14948 0 0 0 0 13905 0 0 19255 0 0 0 21548
	21551 14913 14627 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 21555 0 0 14885 0
	17203 0 0 21552 17498 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 21556
	0 0 16226 0 0 0 0 0 21554 21557 0 14143 0 0 0 0 0 0 0 21558 0 0 0 0
	0 0 0 0 0 0 0 0 21559 0 14628 13120 21561 0 0 0 0 0 21562 0 0 0 0 0
	21563 0 0 21560 0 0 0 0 0 0 0 0 0 0 0 0 21553 0 0 21564 0 0 21565 0
	0 0 0 19300 0 0 15979 0 0 0 21567 21568 21566 0 21570 0 0 0 0 0
	18232 0 0 12392 18774 0 0 21571 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	15997 0 0 15417 0 18269 13424 0 14955 0 0 0)
      #(19289 0 17970 0 0 14200 16975 0 0 0 21569 21572 0 0 0 0 0 0 0 0 0
	16964 0 0 0 21573 0 0 0 21574 0 0 0 21576 0 0 17513 0 0 0 0 0 13358
	0 0 0 0 29729 12641 19059 0 0 15980 17736 0 0 0 0 14950 0 0 21582 0
	0 19005 20061 0 0 0 0 0 0 0 0 12916 21578 0 0 0 0 0 16698 21581 0
	17763 0 0 17737 17764 18489 17485 0 0 0 14921 0 0 0 21577 0 0 0 0 0
	0 12662 0 17718 0 0 0 0 21579 0 21575 0 0 16208 0 0 0 21583 0 0 0 0
	15694 0 0 0 0 13869 0 21584 0 0 0 0 0 0 0 0 0 0 0 0 0 19048 0 0 0
	16765 0 0 0 0 17478 0 0 21586 0 0 0 0 0 0 0 0 19279 0 0 21587 0 0
	21592 0 0 0 0 18991 0 0 0 0 21591 21585 21588 21590 0 0 14886 0 0
	19017 0 0 0 21593 0 17221 0 0 12917 0 15981 0 0 0 0 21595 0 21594 0
	14696 0 21596 21598 21597 0 0 21600 0 21589 21602 0 0 0 0 21601
	21599 0 0 0 0 0 15182 16209 0 16724 21603 16444 12397 18276 0 0 0 0
	17499 0 21605 21604 21606 21607 21608 0 0)
      #(0 0 21609 0 0 0 0 0 0 19025 21610 0 0 0 0 12870 21611 0 0 0 0 19772
	13104 0 21065 15688 16959 21612 19563 0 0 0 0 0 19508 0 0 21614 0
	16999 0 17719 16960 18775 21615 21616 12667 0 0 15418 21617 0 0 0 0
	12368 21618 0 0 0 0 0 21619 0 0 0 0 0 12642 0 0 13425 18016 19060 0
	0 0 0 21623 16725 21622 14144 0 0 19291 21621 0 17765 21625 0 21624
	0 0 0 0 0 21627 0 21626 0 0 12668 0 21628 15913 21630 17189 0 21629
	0 18995 0 0 0 0 15735 17755 0 0 0 21793 0 0 0 0 14629 0 0 0 21794
	18209 18526 19537 0 0 0 0 0 18213 0 0 21803 0 0 0 0 0 13624 0 0
	19781 0 0 19503 0 22060 0 21795 0 0 0 0 0 21798 0 16965 0 0 19256 0
	0 0 17738 0 0 0 0 0 21799 0 0 0 0 0 0 19301 0 14922 0 0 15914 0 0 0
	0 0 0 0 21800 0 0 15184 0 15183 0 0 0 0 12345 14408 0 16427 12369 0
	0 0 0 21804 21805 0 21802 0 0 0 0 0 0 0 0 12600 13359 0 21801 0
	19525 18737 0 0 0 0 0 0 0 0 0 0 12328 0 0 0 0 12409 0 0 0 15185)
      #(0 12370 0 12323 0 0 0 0 0 21810 0 0 0 0 0 0 0 21808 0 0 0 0 0 0
	19516 0 21811 0 21809 0 0 21807 16177 0 0 0 0 21806 0 0 0 19034 0 0
	0 0 0 14436 0 0 0 0 0 21815 21816 0 0 0 0 0 15915 0 0 0 21812 20268
	0 0 0 0 18252 0 0 21814 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14887 0 0 0
	0 0 0 0 21817 0 0 0 18776 0 0 0 21818 0 21813 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 19515 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18270 0 0 0
	0 0 0 0 21819 18738 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 21820 21824 21821 0 0 12871 21823 0 0 0 0 0 0 15419
	0 21822 14201 0 0 0 21836 0 0 0 0 0 21829 21826 0 0 0 0 0 0 0 0 0
	17252 0 21825 0 0 21827 0 0 21828 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	21830 21831 0 0 0 0)
      #(0 0 0 0 0 0 0 0 0 13426 0 21833 21832 0 0 0 0 0 0 0 0 0 21834 0 0 0
	0 0 0 0 0 0 0 0 15982 0 0 0 0 0 0 0 21837 0 17500 0 0 0 12613 0
	21835 0 0 0 21838 0 0 0 0 0 0 0 21839 0 21842 0 0 21840 0 21841 0 0
	0 0 0 0 0 0 0 0 15186 21843 0 0 14630 21844 0 15226 16952 0 21845
	21846 15194 14631 0 19538 0 0 0 13608 14409 21847 13144 0 0 21848 0
	16953 0 0 0 0 21849 22051 0 21850 0 21851 0 0 21852 0 21854 0 0 0 0
	0 21855 0 0 21856 0 17008 0 12583 15465 12354 0 16727 13360 15413 0
	14632 0 0 0 0 0 17766 0 15649 13361 17256 17514 12344 13625 19061 0
	15426 0 0 13650 16491 15420 19752 21857 0 0 0 0 0 0 0 13660 0 14923
	0 0 13106 12643 15916 12872 0 21858 19782 0 0 0 0 0 15689 0 0 15460
	21859 13427 18002 19497 21860 0 21861 0 0 18777 0 0 0 21863 0 13352
	13943 21862 0 0 0 0 0 0 13362 0 16178 21867 15137 0 12873 21866 0
	21864 21868 21865 18219 23629 16179 0 21869 0 0 20032 0 21870 0 0
	21872 0 17278 21871 0 16419 0 15227 0 0 0 16976 15479)
      #(0 18805 16492 0 15437 21873 15917 21874 21875 12371 16954 16210 0
	21876 17971 15918 0 15919 0 21877 0 0 16493 0 0 0 15920 0 0 0 0 0
	21878 0 21879 0 19552 0 0 0 21880 0 0 0 0 13894 0 0 0 15650 0 0 0 0
	0 0 21881 21882 15452 16172 18036 16212 18552 18210 13897 21883 0 0
	0 13679 21884 0 13950 0 17999 12848 0 15187 21885 22050 22049 13949
	0 21886 0 17720 0 0 0 0 0 0 0 0 16944 0 17739 15432 0 0 16728 19834
	0 0 0 0 0 0 22052 0 22053 18006 0 15155 0 0 0 0 22055 0 0 22056 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 22057 0 0 0 13428 22058 0 0 22059 0
	0 0 0 0 0 0 0 0 0 0 0 12844 0 0 0 0 0 0 16699 13412 0 22061 19496 0
	0 0 0 16978 0 13145 0 0 22063 22065 13407 0 0 22062 22064 0 22067 0
	0 0 0 0 0 22066 0 22068 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 22069 0 0
	0 0 0 0 17981 13870 0 0 0 0 0 0 12901 22070 22075 0 0 22073 0 19063
	19062 0 0 0 0 0 17767 0 0 0 22072 15700 0 22071 0 0)
      #(0 0 0 0 0 0 0 16242 0 0 0 22076 0 0 14954 0 0 22082 0 0 22083 22077
	13107 22078 22087 22086 22085 22081 0 0 0 22080 0 0 22084 0 0 0 0 0
	0 19064 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 22091 22088 0 22090 0 19826 0 22089 0 0 0 0 0 0 0 0 0 22079 0
	0 0 0 0 0 0 0 0 0 0 0 16243 0 0 22092 0 0 14903 0 0 0 22093 0 0
	22094 0 0 0 0 0 0 0 0 0 0 0 22097 0 22096 0 0 22095 0 0 0 17768
	22074 0 0 0 22103 0 0 0 0 0 0 0 0 0 0 0 0 22099 0 0 0 0 22098 0 0 0
	0 0 0 0 0 0 22100 0 22101 0 0 0 0 0 0 0 0 22104 0 0 20070 0 22105
	22102 0 0 0 0 0 0 0 0 0 0 0 22106 0 0 13408 22107 0 0 0 0 22109
	22108 0 0 22110 0 0 0 0 22111 0 16494 15651 0 0 15716 0 16739 0
	14633 14904 14634 13680 0 0 22112 0 0 14905 0 0 14410 22113 19494
	18243 22114 0 14635 0 0 0 13356 0 17191 13906 0)
      #(0 0 15188 18779 0 0 18497 0 0 0 0 22115 13429 0 0 0 0 22118 0 0 0 0
	17441 0 0 22117 22116 22119 0 17515 0 0 0 0 0 0 0 16227 0 0 0 0 0
	15189 0 16458 0 16979 13602 0 0 17442 0 0 22120 22121 15983 0 0 0 0
	19257 0 0 22124 0 0 22123 22122 18813 0 22131 0 0 0 0 19290 0 22125
	0 0 0 0 0 22127 19307 0 22126 0 0 0 0 0 0 0 22128 0 18472 22129
	19006 22130 0 0 0 0 0 0 0 0 0 0 0 0 0 13363 19007 18223 22132 22133
	0 14636 13364 22134 14392 19780 19753 13430 22136 0 17443 0 14637
	15921 0 0 18527 0 0 15922 0 0 0 0 15736 0 0 0 0 0 17516 19065 17721
	0 0 14638 0 18780 0 0 0 22137 0 0 0 0 0 17753 14914 0 0 0 14411 0
	17517 0 0 0 0 0 0 0 12355 15726 14639 19783 0 0 0 0 0 0 0 0 22138
	22139 18257 0 0 0 0 22140 20087 20269 0 0 0 0 22142 22141 0 0 13127
	0 0 22305 0 0 0 22308 22309 0 22307 0 18752 15923 22311 22310 22306
	0 0 0 0 22312 22313 0 0 22314 0 0 0 22317 22315 0 22316 22318 0
	12644 17518 22319 0 14202 12918 18230 0 22320 18043)
      #(0 19035 0 22321 20270 0 0 0 0 22322 19008 22325 20513 20529 0 15408
	18037 22326 0 13661 17444 12410 22327 18982 14640 0 0 17232 0 0 0
	17519 0 0 0 0 0 19567 14393 14412 0 22328 0 0 0 22329 0 22335 0
	15461 0 0 0 17445 0 13871 22330 0 0 0 18731 0 17222 0 0 22331 0 0 0
	0 0 0 22332 0 13872 0 22333 0 22334 0 0 22336 0 17782 0 0 22337
	22338 0 22339 0 0 22324 22323 0 0 0 22340 14145 0 0 0 18727 0 0
	14924 18743 17446 18763 22341 0 0 15924 12614 0 22342 0 0 0 22343 0
	19570 0 0 18528 0 0 22346 12669 16428 22345 22344 14146 16980 0
	22350 22348 0 22347 20007 14437 0 0 0 15737 22349 17740 15678 0 0 0
	17984 22353 22352 0 0 0 0 22351 0 22354 14438 0 0 0 0 0 0 22355
	18812 15707 0 0 22356 18553 0 0 0 0 17985 17447 0 0 0 0 17712 0 0
	22357 13611 0 0 0 0 0 16180 0 18732 0 0 0 0 0 0 13431 18214 0 0 0 0
	0 0 0 0 22358 15190 19258 19259 0 0 12670 22363 0 0 17257 0 0 0
	22360 0 0 0 0 0 0 12919 0 0 0 0 22573 22362 0 0 0 18224 0 0 22361 0
	0 22359 0 14714 0 22365)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 22371 22377 22369 0 17756 0 0 22374
	18781 0 0 22368 0 22373 20071 15191 0 0 16981 22366 0 0 0 13662
	22376 16429 12645 22370 12920 22375 0 0 0 13873 0 22372 0 0 0 0 0 0
	0 0 22378 0 0 0 0 0 0 22380 22390 22388 0 0 22385 0 0 0 22384 20088
	0 22386 0 0 13874 0 14641 0 0 15738 0 0 0 22393 22379 0 0 0 0 22383
	22367 0 12922 22387 22389 17233 0 0 14888 12856 22381 22392 22391
	13875 0 16937 13158 0 0 0 0 14147 0 22382 0 0 0 0 0 0 0 0 0 22394 0
	22397 22561 0 0 0 0 15421 0 22567 17520 22395 0 0 0 0 22565 0 12921
	0 22563 22564 0 0 22398 22562 0 0 0 14439 19754 0 0 13365 0 0 12633
	22566 0 18234 12333 0 0 0 0 0 0 0 18529 22364 22572 22576 19557 0
	22569 0 0 0 17769 22574 0 0 0 0 0 0 0 15984 22575 18007 0 0 0 0 0 0
	0 0 0 20295 0 22571 0 0 0 0 22577 0 14715 0 16459 0 0 12372 22570
	22568 0 16730 0 0 0 22396 15156 0 0 0 0 0 0 0 16966 22589 0 16731
	22584 0 22581 22582 0 15462 22585 22588 0 0 0 0)
      #(22583 15653 0 22586 0 0 22580 0 19580 19579 0 0 0 22590 22591 12373
	0 0 0 0 0 22579 0 0 0 0 13938 12326 0 0 0 13366 0 22587 0 0 0 0 0
	22595 22594 0 0 0 22599 0 0 0 0 0 0 0 22600 0 0 0 0 0 0 0 22598
	22601 22593 22597 0 0 22602 0 22603 0 0 22592 15228 0 22596 16982
	14642 22578 16181 0 0 0 0 22616 0 19049 0 0 22606 22607 22608 0 0
	22615 0 22614 0 0 19325 13367 0 22612 0 14149 13108 0 0 22609 0 0
	20024 22611 12374 22613 0 22604 22610 22617 14148 22605 0 0 0 0 0 0
	19805 0 0 0 19755 0 0 0 0 22620 0 0 22624 0 0 0 16766 0 20089 22625
	0 0 22622 0 22619 0 0 22618 22623 0 0 0 0 0 0 0 0 0 18992 0 0 17972
	0 14150 0 22626 22621 0 22627 0 0 0 14203 0 0 0 12849 0 0 0 22635 0
	0 0 13368 0 0 0 0 22633 0 0 22634 14889 22632 22630 22629 22636
	22628 22638 0 0 12923 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 22640 0 0
	22639 0 0 0 0 0 0 0 0 0 0 0 17448 0 22643 0 22641 22631 14204 0
	22642 0 22646 22645 22647 22644)
      #(22648 0 0 0 0 0 0 0 22649 22650 19050 0 22652 22651 15679 0 16430
	12902 12924 0 22653 0 12351 0 0 0 16460 22654 0 27715 22817 14177 0
	22818 0 0 0 0 16495 0 0 0 22819 0 0 0 22820 13626 22821 0 22822
	22823 16983 0 0 0 14413 0 0 19553 0 0 0 19260 15722 22824 0 0 0 0 0
	16496 28221 18530 0 15466 0 14925 22825 0 0 0 0 16967 0 18983 0 0
	17009 0 0 22828 0 0 22826 0 22829 0 0 22827 0 0 0 0 22830 0 0 0 0 0
	18993 0 0 12343 0 0 0 0 18782 0 0 18531 0 0 22831 0 22834 15925
	13627 0 22832 22839 15926 0 0 0 0 22833 18244 0 0 0 0 0 0 19806
	22835 22836 22840 17770 22837 14643 16478 0 0 22854 18484 0 17010 0
	0 0 0 0 0 0 0 0 0 0 0 18532 23085 0 0 0 0 19066 0 0 0 17521 0 0 0
	19317 0 22843 12833 17258 0 0 0 0 22852 0 0 17204 22846 22853 22848
	22855 22851 0 22850 18287 0 22844 12925 22842 13681 17011 22838 0 0
	22841 14644 16475 0 15927 22849 18258 0 0 13682 13128 0 0 0 0 0 0 0
	0 0 0 13159 16161 22857 22862 0 22858 0 14205 0 22863 15138 14697 0
	0 0 0 0 0 15654 22845)
      #(0 15229 22860 0 0 0 0 15192 22861 12356 0 0 22856 0 0 0 0 17449 0 0
	0 0 0 0 0 13683 0 0 0 0 0 13876 0 0 0 0 0 0 0 22859 12327 0 0 14915
	0 0 0 16182 0 0 0 0 0 0 0 0 0 0 17522 0 0 18516 22865 16734 0 0 0 0
	0 0 0 0 0 16938 0 0 15147 22866 0 22868 22864 0 0 0 0 19041 0 17469
	0 0 0 0 16732 0 0 0 0 0 0 0 0 0 0 19067 15438 22880 0 22879 0 0
	16248 0 0 0 14206 0 0 0 22873 15929 0 0 18024 18225 0 0 0 0 22871 0
	0 16733 0 0 0 0 15480 22876 0 0 15928 0 22870 22875 0 0 18259 0 0 0
	22869 0 14113 0 0 13149 0 0 0 22877 20011 14926 17205 22874 0 16476
	0 14645 16228 12646 16700 22872 13637 0 0 0 0 0 14151 0 17487 22878
	0 0 0 0 0 16735 0 0 22881 0 22883 0 0 16951 22889 0 22884 0 0 22886
	0 0 0 0 0 18753 17523 0 22887 0 0 0 19756 0 0 0 19784 13369 0 0 0 0
	0 12334 0 22885 0 0 0 0 0 22882 0 0 0 0 13432 0 0 0 0 0 12647 0
	22888 0 0 0 19785 0 0 0 0 0)
      #(0 0 0 0 0 0 22892 0 0 0 0 0 0 16955 0 22899 0 0 0 22893 0 0 22890
	22897 0 0 0 0 22867 0 0 0 0 0 0 0 0 0 22894 0 22898 0 0 0 18498
	17771 0 0 0 0 0 0 22891 0 22895 0 0 0 14152 0 0 0 14961 0 0 0 16477
	0 0 0 0 0 0 0 0 0 0 0 22903 0 0 0 0 0 0 0 0 0 17702 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 22900 0 19296 0 0 0 0 0 22901 0 0 0 0 0 0 22902 0 19534
	0 16418 0 0 0 0 0 0 0 0 14178 0 0 0 0 22909 0 0 0 0 0 0 0 0 0 15157
	22906 0 22905 0 0 0 0 18226 0 0 0 17973 0 0 0 0 0 17713 22907 0 0 0
	22908 0 18799 0 18245 15139 0 16497 0 19280 0 0 0 0 0 0 13129 0
	23077 22910 0 0 0 0 19786 23079 0 0 23075 0 23076 0 0 0 0 0 16736 0
	0 0 0 23074 0 22847 0 0 0 23078 0 23073 0 0 0 0 0 23083 23084 17703
	23086 0 0 15140 23081 0 0 0 0 13628 0 0 23087 0 23080 23091 0 23090
	0 23089 0 0 0 23092 0 0 23094 15985 0)
      #(23093 0 0 0 0 23097 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 23095 0 0 0
	23096 22896 0 0 0 0 0 23099 23098 0 0 0 0 0 22904 23100 23088 0 0
	15193 0 0 0 0 23101 23102 23104 23103 23105 12926 0 14646 0 0 19068
	16431 0 0 0 0 0 14414 0 0 23107 0 0 0 0 23110 0 18770 0 13663 0 0 0
	23109 23108 18260 23111 13877 0 0 0 23113 23112 0 0 0 13370 15158 0
	0 18008 0 0 0 0 0 14153 0 0 0 16244 0 23114 0 16432 17704 0 18783
	23115 0 0 0 0 0 0 0 0 0 23116 23117 0 0 0 19000 21853 16454 0 0
	18764 0 14936 0 18533 18499 0 0 0 0 0 17741 0 20033 0 23119 15440 0
	0 23120 0 12342 0 0 13908 16461 0 18784 0 0 0 23121 15170 17223 0
	15195 16183 0 0 0 0 0 0 23122 0 19069 0 0 12663 15196 0 0 0 23125 0
	23123 23126 20025 23124 0 0 0 0 16507 23127 0 0 16946 0 0 23128 0 0
	0 0 13434 0 23130 0 23129 0 0 0 0 23131 23132 13435 0 0 18044 17206
	13676 15197 16737 0 0 15708 12336 0 0 0 23133 0 0 0 0 0 0 0 0 12834
	23137 0 0 0 0)
      #(0 0 14647 23136 0 0 14891 15930 0 0 23135 0 15931 0 19520 14890 0 0
	0 12375 16462 0 0 0 0 0 0 0 23142 0 0 16433 12615 0 0 0 0 15701 0
	19302 14962 0 0 0 0 15932 0 16423 0 0 0 0 23141 23139 23140 0 0 0 0
	0 17259 0 0 23334 0 23146 15230 14648 23144 0 0 0 0 23145 0 16184 0
	0 0 23143 0 0 15151 0 0 0 0 0 0 0 0 0 0 23148 23147 23152 0 0 23153
	0 23149 0 13090 23150 23151 18517 0 0 0 0 18785 14154 23154 0 0 0
	16434 0 15933 0 0 0 17234 0 0 0 0 0 0 13895 0 23155 23159 0 0 12875
	23156 23158 0 0 0 0 23157 0 0 15723 0 0 0 0 17224 12357 23160 0 0 0
	0 23161 0 0 0 0 17450 0 0 0 20081 0 0 0 0 15171 0 0 19051 0 0 0 0 0
	19261 0 0 0 23330 23163 0 0 23166 0 23165 0 0 23162 0 0 23329 0 0
	18014 0 23164 0 0 0 0 0 0 0 0 0 0 0 0 23331 0 0 15724 23332 0 19787
	18296 0 0 23333 0 0 0 0 0 23335 0 0 23336 0 0 0 0 0 0 23337 0 13898
	12616 14649 23338 0 23339 15729 16738 0 0 21080 16702 16701 16984)
      #(14919 0 0 20594 0 0 0 0 14190 19757 0 19070 0 18814 0 23340 0 0 0 0
	14963 17471 23341 20271 0 0 0 19262 0 17451 23342 13436 0 0 0 0 0 0
	23343 23344 19546 0 19492 19318 19292 15141 23346 0 0 15467 0 0
	19281 0 23348 23351 23350 0 13433 0 0 13664 0 23347 0 23349 0 0 0 0
	23352 0 0 16249 0 0 0 0 19835 12361 14944 16956 0 15453 0 0 15987 0
	0 23355 0 0 17742 0 23353 16939 23354 15986 19549 23356 23357 19816
	0 0 0 0 23362 0 0 14650 0 18261 23359 17772 23134 23138 0 13647 0
	18247 0 0 0 0 23361 0 15934 18500 0 0 0 0 0 23367 0 18554 0 23358 0
	23364 23363 0 0 0 16463 0 0 0 0 19309 0 20051 0 0 19303 0 12876
	15198 0 0 20296 23366 16245 0 0 0 23365 0 0 23360 0 0 0 0 0 14415 0
	0 0 23372 23370 0 12877 23368 23374 23380 0 0 0 0 0 0 0 16968 0 0
	19009 0 23382 0 0 0 18722 0 0 0 23381 18288 19263 13371 0 16503
	15680 0 0 0 17491 0 19758 0 0 23377 23376 0 0 0 23378 0 23375 0 0
	23383 0 23373 0 0 23371 0 23379 23369 0 17260 0 19576 15430 14964 0
	0 0 0 0 14906 0 0 19311 13121)
      #(0 0 17486 17994 12617 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16498 0 0 16436
	14122 0 0 0 0 0 0 23385 0 0 14651 13180 0 0 0 0 0 0 23387 13172
	23393 0 0 0 0 0 0 23390 0 16499 0 0 0 13131 14892 0 0 13130 14927 0
	0 23388 14181 14155 17773 0 0 23386 0 12358 0 0 0 0 23389 23391 0
	13901 14124 0 13372 13643 0 0 0 0 23394 0 0 14969 19313 0 15159 0 0
	0 23395 0 0 0 18736 0 0 0 0 0 0 0 0 0 0 0 0 23407 0 12851 23396 0 0
	0 0 0 0 23413 23397 0 20034 0 23404 0 18271 0 0 0 0 0 0 0 23412 0
	23399 0 0 0 12340 23401 0 0 14652 0 0 0 23403 0 23402 0 23398 23409
	0 15935 0 0 0 21613 14440 19836 0 0 0 0 23400 0 17524 13091 14893 0
	23392 0 23408 13153 0 0 23406 23410 0 17774 0 0 0 0 0 0 0 13438 0
	23602 0 0 19529 23415 13437 0 23422 0 0 0 0 19264 0 23585 23587 0
	23591 23417 0 17194 0 0 0 0 17775 23595 23420 0 23592 0 0 0 23586 0
	0 0 0 0 0 16185 23596 0 0 16435 0 0 0 0 0 0 23594 13373 0 0 0 0 0)
      #(20304 23414 0 0 23590 12376 0 0 23416 0 0 19514 23421 16162 17479
	23411 0 0 23589 0 0 0 0 0 0 16250 23599 13169 14369 0 0 0 0 23601
	23418 23600 0 23593 23419 0 23597 0 23598 0 0 0 0 0 23615 0 0 0
	17998 0 23588 0 0 23611 0 0 0 23613 0 17496 0 0 0 0 0 0 0 0 0 0
	19788 0 0 0 0 0 0 0 0 18806 23608 16970 0 0 0 23614 16703 0 23605
	23618 23617 0 18031 23616 18026 0 0 0 0 0 0 0 23620 23607 0 13896
	23610 15709 0 0 0 18272 23612 13899 0 23604 23606 23603 0 0 20272
	13146 23609 0 0 23619 13109 0 0 0 0 0 0 0 14951 0 0 0 12637 0 0
	23636 0 0 20273 23639 0 0 0 0 0 16186 23638 0 0 0 23637 0 0 0 0 0 0
	23634 0 0 0 0 0 0 23622 0 0 23651 23621 0 23640 0 0 0 0 0 0 23632 0
	0 23627 23624 0 23625 0 23633 0 0 0 29730 0 0 23630 14653 17480
	16740 23628 0 23623 0 0 23626 0 0 0 0 19789 19306 0 0 0 23631 23641
	0 0 0 0 0 0 0 0 23649 23642 0 0 23655 0 23653 0 0 0 0 23648 0 0 0 0
	0 0 23647 0 17488 0 16741 0 23645)
      #(0 0 23643 0 0 23650 0 0 0 0 23656 18549 23662 0 0 0 0 0 23657 23660
	23654 0 0 17268 0 18744 0 23644 0 0 23652 15936 0 19535 23672 23659
	0 0 0 0 0 14370 12835 13151 0 0 23635 0 0 0 0 0 0 15937 23664 0
	23671 15481 13170 0 0 17198 0 0 0 0 0 0 23661 0 0 23666 23670 0 0
	13878 0 0 0 0 0 0 0 0 0 0 0 0 13644 23668 0 0 0 0 0 13601 0 17995
	23667 0 0 0 23669 0 0 0 0 0 0 0 0 0 0 0 23663 0 0 0 0 0 23665 0 0 0
	0 0 0 13152 17225 0 0 0 23676 0 0 0 0 0 0 0 0 23674 14441 0 23673 0
	0 0 0 0 0 23841 0 0 0 0 23384 0 0 0 23675 0 23677 23678 0 0 0 0 0 0
	23852 0 23848 0 23405 0 0 0 0 23847 0 0 0 0 23846 0 0 23843 0 0 0 0
	0 23658 23845 23844 0 0 0 0 0 0 0 0 0 0 0 0 0 23850 0 20262 0 0 0 0
	0 0 23853 13947 0 0 23849 23851 0 0 0 0 0 0 0 0 18471 0 23854 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 23858 23855 0 0 0 0)
      #(0 0 0 0 19827 23856 0 0 0 0 23646 0 0 0 0 0 0 0 23859 0 0 0 23860 0
	0 0 0 0 0 12597 0 23862 14183 15393 0 13909 0 0 0 12836 0 0 0 0 0 0
	0 0 0 0 19807 0 0 0 0 23864 23863 23866 13629 0 0 13910 13374 0 0 0
	0 23869 0 0 0 23868 0 23870 0 0 12878 0 17207 0 23871 0 0 13375
	23873 0 0 0 0 23872 0 23874 0 0 0 23875 0 23876 15199 16437 14881 0
	18800 0 0 19042 20292 0 0 0 0 15221 0 0 0 14928 20082 0 0 0 23877
	23878 0 15200 0 0 0 23879 23880 0 0 23882 23881 0 19288 0 0 15710
	15468 15172 0 23883 0 0 0 0 0 0 0 23885 16163 0 23884 0 0 0 0 0
	23886 0 0 0 0 0 23887 0 0 0 0 0 23888 23889 0 0 0 23890 0 23892
	23891 23893 12837 17226 0 23894 0 0 15142 13132 23895 0 0 17730
	21580 0 0 0 0 13603 23896 0 0 0 0 23897 0 19052 19304 0 0 0 17991
	23898 18534 0 0 0 18555 0 0 19539 0 0 0 23899 0 0 0 0 0 0 0 0 0 0 0
	23901 23900 0 0 23903 0 0 0 23902 0 0 0 0 0 0 0 0 0 0 0 0)
      #(0 0 0 0 0 0 0 0 23905 0 0 0 0 0 0 15201 0 19505 0 23906 23907 0 0
	13604 0 0 0 23908 0 0 0 0 0 0 0 23910 23909 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 16229 0 0 18745 12618 0 0 0 0 0 18501 0 17525 15681 13665 0 0
	0 0 0 0 0 0 0 0 0 18502 0 15406 0 0 0 0 23912 0 13376 0 0 12664 0 0
	18034 23911 14654 17235 0 23913 0 0 0 0 0 23921 0 23914 0 0 0 0 0
	16961 0 13666 23922 0 0 0 0 0 0 14184 0 0 13605 23920 0 0 23918
	23915 19808 0 0 0 0 17472 0 0 0 18009 23916 0 0 23924 0 23923 14115
	0 0 12845 0 0 14907 23917 23919 0 0 0 0 0 19287 17012 0 0 0 0 0 0 0
	0 19319 0 0 23932 0 0 23933 0 12879 0 0 0 0 18984 19581 24097 15395
	15938 23928 23934 12648 0 13879 0 0 23925 23930 0 0 0 16500 18289 0
	18535 0 0 0 0 0 0 23927 0 19233 0 23929 0 24100 0 24098 0 23931 0 0
	0 19234 18248 13667 0 17701 0 0 17261 0 24101 0 0 0 0 24099 16985
	23926 0 12619 0 0 0 0 0 0 0 0 0 0 0 0)
      #(0 0 0 0 0 0 0 0 0 0 0 19790 24112 0 0 0 0 0 24111 0 0 0 0 16502 0
	24108 0 19820 0 0 17974 24102 0 0 0 0 0 17477 0 0 0 12620 14655
	24105 0 0 0 0 0 0 15655 24110 0 24109 24104 0 24107 0 0 13160 0
	24106 18249 0 0 20014 0 0 15988 16501 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 24118 24116 0 18765 0 0 0 0 0 0 24113 24115 0 12602 0 0
	14656 20274 0 13117 0 18786 0 0 0 0 0 19809 0 0 13092 16187 24117 0
	0 0 0 0 0 0 0 0 0 0 24122 0 0 15939 0 0 0 19760 0 24119 0 0 0 0
	24114 0 24120 0 0 0 20062 0 17779 17986 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 13110 0 0 12629 0 0 24126 0 0 24129 0 0 0 20035 0 0 0 19812
	0 0 0 0 24136 24130 24127 0 0 0 20052 24133 0 0 0 0 15690 24135 0 0
	24140 0 0 17777 24138 0 0 0 0 24132 0 0 17208 0 0 24139 0 24128 0
	24134 0 24141 12412 24131 0 24142 0 0 16188 0 15711 0 18981 0 14894
	0 24123 24137 17722 0 0 0 0)
      #(0 0 0 0 0 16438 0 13161 14929 15940 24125 15682 0 0 0 0 0 0 0 14156
	0 24124 0 0 0 24146 15725 14394 0 24161 0 24155 13684 17743 0 24150
	24159 12335 12594 0 0 12857 0 24152 16940 24143 24145 14657 0 0 0 0
	0 0 0 0 24162 0 24157 0 0 0 24149 0 0 0 0 24156 0 0 0 0 0 0 19499 0
	0 24154 24158 0 0 0 0 0 0 0 14416 0 15941 0 0 17209 0 0 0 24148 0 0
	0 0 0 0 0 19759 0 0 0 24151 0 0 24144 17778 0 0 24147 0 0 0 24153 0
	0 0 0 0 0 0 20305 15422 19326 0 24163 0 0 0 0 0 0 0 0 0 18478 0 0
	24175 14395 0 0 0 0 0 15712 0 24165 0 0 0 20015 14658 0 24178 0 0
	12398 0 0 24176 0 0 0 0 24164 0 0 0 0 24170 0 0 24172 0 0 0 19791
	24167 0 0 17710 0 0 24169 0 0 0 0 24177 0 24171 19527 0 0 0 24166 0
	15394 24190 0 0 0 0 13162 0 24168 24173 24174 0 0 0 0 0 0 0 17004
	16986 0 0 0 0 0 0 0 0 0 0 0 0 0 24182 0 0 24188 0 0 24186 0 17705 0
	0 24355 24183 0 0 0 0 0 24184 24160)
      #(0 13689 18746 0 0 0 15423 0 0 14711 0 0 0 0 0 20275 0 24180 0 24354
	12649 16742 0 0 0 0 0 0 0 0 0 0 18297 0 13377 20090 0 0 0 0 0 0 0
	19489 17490 0 0 0 0 24187 24189 0 0 0 0 0 16690 0 0 0 0 0 24353
	24185 0 24179 0 0 0 13379 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14185 0 0 0
	24367 0 0 24362 16504 0 0 13155 0 0 0 0 15713 0 24371 0 0 0 0 0 0
	24364 17452 24361 17497 0 0 0 24396 0 0 0 24358 0 24357 0 24366 0 0
	0 24360 24359 24365 0 16417 0 24356 0 0 0 0 0 0 0 24368 0 0 24369 0
	0 0 0 0 13378 0 0 0 0 0 0 0 0 0 24374 0 24373 24375 0 0 0 0 0 24378
	0 0 0 0 0 0 17731 0 24372 0 0 0 0 0 24376 0 0 0 0 0 0 14179 17017
	24370 18235 0 0 24377 0 0 0 0 0 0 0 0 0 0 0 0 0 24382 24380 0 0
	24383 0 0 24386 0 0 0 24379 14698 18216 0 0 24121 0 0 0 0 0 0 19828
	24381 0 24385 17013 0 24384 0 24363 0 0 28521 0 0 0 24389 0 0 0
	24393 0)
      #(0 24391 0 0 0 0 0 0 0 24387 0 24388 0 0 0 24392 0 24390 0 0 0 18766
	0 0 24398 0 24395 24394 0 24397 18004 24399 0 0 0 0 0 0 17269 17005
	0 0 0 0 16421 0 0 0 24400 0 24402 0 0 0 0 0 0 0 0 0 0 0 24401 0 0 0
	0 0 0 0 0 0 0 0 0 0 24181 0 0 0 0 24403 0 0 0 0 0 0 18023 0 0 0 0 0
	0 0 0 0 0 24404 0 0 0 0 0 0 0 12880 0 0 0 17780 13093 0 0 0 0 0 0 0
	13668 0 0 0 15454 14930 0 0 0 0 0 0 0 0 0 0 0 20263 16230 0 0 0
	12650 0 0 0 24406 0 0 0 0 0 0 24405 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 24409 17210 24412 24407 0 0 0 24411 0 0 0 0 24410 17728 12377 0
	0 0 0 0 0 0 0 0 0 0 0 0 20085 0 0 24414 0 0 0 12584 0 0 0 0 0 0 0 0
	0 24416 0 0 0 24415 0 24413 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 24408
	0 0 0 0 0 0 0 19235 0 0 0 24418 0 0)
      #(0 0 0 0 0 0 0 0 0 24417 0 0 0 0 0 0 0 0 0 0 12651 0 0 0 0 24420
	18994 0 24419 0 0 0 0 19509 0 0 0 0 15943 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 16691 0 0 0 0 0 15942 0 0 0 0 0 0 0 0 0 0 0 0 20091 0 0 24426 0
	16505 0 0 0 0 0 0 24422 24427 0 0 12652 0 0 0 0 0 0 0 0 24425 0
	18273 24421 24424 15944 0 18513 0 0 24428 0 15441 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 16506 0 0 0 0 0 0 24431 0 0 0 24423 0 14119 0 0 0 0 24429
	0 0 0 0 19792 24432 0 0 0 29734 0 0 0 0 0 15695 0 0 0 0 0 0 0 0
	24433 0 0 0 24434 0 0 0 0 18222 0 0 0 0 0 0 0 24436 0 0 0 0 24437 0
	0 0 0 18227 0 0 0 0 17781 24439 0 0 0 0 24441 0 20053 0 24438 0
	24440 12653 0 24435 0 0 0 0 0 0 0 21339 24442 0 0 0 0 16743 15160
	24444 0 0 0 0 24443 16164 21081 0 0 0 0 0 0 24445 0 0 0 24609 0
	24430 24446 0 0 24610)
      #(0 0 0 0 0 0 18298 0 0 0 0 0 0 24611 0 0 24612 0 0 0 0 0 0 0 0 0 0
	24613 0 0 0 0 0 0 0 0 0 0 0 0 24614 0 17502 0 24616 24615 0 0 24617
	0 24618 0 0 15455 18787 0 0 0 19564 24619 24620 16726 15396 24621
	24622 0 0 0 0 0 24623 19026 18503 0 0 24624 18263 0 0 0 0 0 17453 0
	0 0 0 0 24625 12903 0 13677 0 19526 0 19510 0 12852 20276 0 0 0 0
	19282 0 18986 0 0 0 0 0 0 0 0 16439 0 24626 0 0 0 0 17987 0 0 0
	14371 24627 0 14932 24629 24628 0 0 0 0 24630 0 0 0 0 0 0 0 0 0 0
	24631 0 0 0 24632 0 0 0 0 0 0 0 0 0 13630 0 24633 0 0 0 0 24634 0 0
	0 0 14372 0 0 18504 0 0 24636 0 0 0 15989 0 0 24635 0 0 0 0 0 0 0 0
	13880 24637 24639 0 24638 0 0 0 0 0 0 0 24640 0 14417 0 24641 0 0 0
	0 13929 0 16704 0 14717 0 0 0 0 24643 24644 24642 0 0 0 0 0 0 15469
	0 0 17992 13881 0 0 0 0 0 0 0 0 0 24646 17196 24645 0 0 20277 18274
	0 0)
      #(0 0 0 0 0 0 0 0 0 0 24649 0 0 0 0 0 0 0 0 0 0 0 24651 24648 0 0 0
	19540 24650 24652 0 20036 0 0 0 0 0 24656 0 0 0 24655 17270 18221 0
	0 14373 24654 0 0 0 0 24653 0 19761 19762 0 0 0 0 0 0 24657 12654 0
	0 0 0 14710 15202 0 0 0 0 0 0 0 0 24658 24659 0 0 0 0 0 0 0 24661 0
	0 0 0 0 0 0 0 0 0 0 15683 0 0 0 0 24663 0 24662 0 0 0 0 0 24664 0
	13133 0 0 24666 0 0 24665 0 24668 24667 0 0 0 0 0 0 0 0 14396 0 0
	20008 0 13900 0 12838 0 0 0 0 0 0 0 0 0 0 13930 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 13409 0 0 0 0 0 0 0 0 20072 24670 0 0 0 0 0 0 0
	24672 0 0 0 0 24673 0 12881 0 0 0 0 0 24669 0 15161 0 0 17473 24671
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 24676 0 15470 0 0 0 0 24674 0 0 0 0
	14142 0 0 18505 24675 0 0 24702 0 0 0 0 0 0 24681 0 0 0 0 0 14397
	0)
      #(0 0 0 13669 0 24678 19837 0 0 20016 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 17014 0 0 24680 0 0 0 0 0 0 0 0 0 0 0 0 24682 20054
	13911 18556 18250 0 0 0 24683 0 0 0 0 24685 0 24688 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 24684 0 0 0 24687 14442 12621 24689 0 16240
	24686 20060 0 0 24692 29732 0 0 0 0 24690 24693 0 0 0 0 24679 24691
	0 0 14908 0 0 24694 0 0 0 0 0 0 0 24695 0 0 0 0 19838 0 0 0 0 0 0 0
	24696 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 24697 0 0 0 24677 0 0 0 0
	24698 0 0 0 0 0 0 0 0 13380 0 0 0 0 0 0 0 0 0 0 0 0 15397 0 0 0 0 0
	0 0 0 0 0 0 0 24699 0 0 0 0 24700 0 0 0 0 24701 0 0 0 0 0 0 0 12603
	0 0 0 24865 0 18747 24866 0 0 13348 24867 0 24868 0 0 0 0 24869 0
	24871 24872 24870 0 0 0 18771 24874 24873 0 0 0 0 0 0 0)
      #(0 0 0 24876 24875 24877 0 0 0 0 0 0 24878 24880 24879 0 0 14713 0
	24882 0 24881 0 0 13381 0 16211 0 17724 0 24883 16440 0 0 0 15162 0
	12665 24884 0 19793 0 0 19043 24885 0 0 0 17732 19763 14659 16189 0
	0 0 17227 21044 0 17454 12904 24886 0 0 0 0 0 0 0 24887 0 24892 0 0
	24890 24889 23106 13094 24888 0 12378 0 18474 0 0 18506 0 0 0 0
	20017 24893 24891 17244 16422 0 0 18475 0 18733 0 24895 20012 14157
	24896 0 24894 18518 24897 0 24898 0 0 12379 0 0 15990 24903 0 24900
	18029 24899 0 0 0 0 0 0 13606 0 0 24906 0 0 0 24901 24902 0 24905
	24904 18725 0 0 16706 16705 0 13631 0 0 24907 0 0 0 0 0 24908 0 0
	24909 0 0 0 0 0 24911 0 24910 0 0 0 0 0 12630 0 0 0 0 0 24919 18536
	24913 0 24915 0 0 24917 16190 0 0 24918 24916 15424 0 0 0 24912
	24914 0 18754 0 15945 0 0 24921 0 0 24920 0 0 0 0 24922 0 15398
	14895 0 0 17783 24923 0 17483 0 0 24925 0 0 0 20001 24924 0 0 0 0 0
	16745 0 0 0 0 0 0 24930 0 24932 24933 17236 0 0 0 0 0 24931 0 24928
	0 24926 24927)
      #(0 24929 0 0 0 0 0 0 0 24936 0 24934 0 24935 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 24937 24939 24940 24941 0 24942 0 0 24938 0 0 0 0 0 0 0 0
	24944 0 0 0 24943 0 0 0 0 0 0 24945 0 0 0 0 0 0 20037 0 0 0 24948
	24946 24947 0 0 0 13410 0 0 0 0 0 19582 0 0 0 19018 0 24950 0 0 0
	24949 0 0 0 0 24951 24952 0 0 0 0 24956 24953 24954 24955 0 24957 0
	0 0 24958 0 25121 0 0 0 25122 0 25123 0 18479 17744 25124 18290
	18740 0 25125 0 0 25126 17706 0 13095 14660 25127 0 0 25128 0 0
	25129 0 15145 0 0 25131 0 0 25130 0 0 25132 25133 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 18537 0 25134 0 0 0 25135 0 0 29545 25136 25137
	25138 0 0 0 0 15150 0 0 25139 18262 0 0 19295 0 12622 0 12631 0 0
	25140 0 0 0 0 25142 0 0 0 25141 17776 0 0 0 16441 23865 0 25143
	19521 0 25144 0 13382 18519 25145 0 25146 0 0 25147 0 0 0 19548 0 0
	0 19541 0 17470 0 0 0 16746 0 0 25149 0 0 15714 0)
      #(0 15946 0 0 25152 0 0 25151 25150 18557 0 13383 14377 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 25158 0 0 25155 16191 19506 0 0 0 25154 25156 25157 0
	0 25153 0 0 0 0 0 0 0 0 0 0 0 0 0 25159 25160 0 17455 0 13411 0 0 0
	17253 0 0 0 0 0 0 25161 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 25162
	25165 0 0 0 0 0 16231 0 17988 0 25166 19283 0 25163 0 0 25164 0 0 0
	0 0 0 0 0 0 0 0 0 0 25169 0 0 0 0 25168 25167 0 0 0 0 0 0 0 0 0 0 0
	25171 0 0 25170 0 0 25172 0 0 0 0 0 0 0 0 0 0 0 0 25174 0 25173 0 0
	0 0 19021 0 0 0 0 0 0 15702 20038 0 0 25175 0 0 17975 0 0 25176 0 0
	25177 0 25181 25179 25180 0 25178 0 0 0 0 0 0 0 25182 0 0 0 0 0
	25183 0 0 0 0 0 0 0 0 0 25184 0 0 25185 19511 25186 0 0 0 0 0 19568
	25187 0 17230 0 18282 0 13931 0 0 0 17211 25188 13882 0 0 0 16464 0
	0 0 0 0 0 0 0 25189 0 0 0)
      #(0 0 14909 0 0 0 0 0 0 0 0 0 25190 0 0 0 0 0 25191 0 14374 14933 0 0
	0 0 0 0 0 0 0 0 25193 0 0 0 0 17750 14934 13646 0 0 0 0 0 0 0 0 0 0
	19236 0 18251 0 0 0 0 0 17751 0 0 0 0 14684 0 0 0 0 0 25195 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15947 0 0 0 0 0 0 0 0 0 0 0 0
	0 20018 14661 0 0 14375 0 0 18467 0 25197 0 0 0 0 0 0 0 25199 0 0 0
	0 14443 0 0 0 0 25198 17526 0 0 0 0 25201 13111 25196 0 0 18538 0
	12592 0 14956 0 20306 0 0 25200 0 0 0 0 0 0 0 0 25202 0 0 0 19019 0
	16473 25204 0 0 0 0 25205 0 0 0 0 0 25203 0 0 0 0 13134 0 25211 0
	25210 0 0 15399 0 0 0 25212 25207 0 0 0 25213 25208 0 0 0 0 18520
	25206 0 0 25209 0 0 0 0 0 25378 0 0 0 0 0 0 0 0 0 0 0 0 25377 19297
	0 0 0 25214 0 0 12395 0 0 0 0 25380 0 0 0 0 0 0 0 0 25379 0 0)
      #(0 15948 0 0 0 0 0 25381 0 0 0 0 0 0 16707 0 0 25383 25382 0 0 0 0 0
	0 25384 0 0 0 0 0 0 0 0 0 0 0 0 25192 0 0 0 25194 25386 25385 0 0 0
	0 0 0 0 0 0 0 0 0 0 15400 0 20073 0 15442 0 25387 14135 0 0 0 0 0
	13632 13607 15203 0 0 0 0 0 0 19764 0 0 25393 0 25392 16708 25389 0
	0 25391 0 0 15691 16192 25390 25388 0 18218 0 0 15949 0 0 18748 0 0
	0 0 14935 0 0 0 0 0 0 0 0 0 17784 0 0 25394 0 0 0 0 25395 25417
	13912 0 0 20285 16693 0 0 0 0 25396 0 0 12882 17527 18977 0 0 0 0 0
	0 0 0 0 0 0 0 0 25397 0 0 0 0 0 0 0 0 13690 25398 0 0 25400 0 0 0
	25401 0 18217 0 0 25402 0 0 0 0 0 25403 25404 0 0 13913 12883 17989
	15656 15204 0 0 0 0 0 0 0 25405 0 15657 0 0 0 0 0 12874 18755 0 0
	25406 0 0 18539 0 0 0 0 0 0 16709 0 25409 0 25410 18281 0 16193
	25407 0 17249 0 0 25408 0 0 0 15950 0 0 0 0 0 0 0 0 0 0 12380 0 0 0
	0)
      #(13609 0 0 0 0 0 0 0 25411 0 0 17528 0 25412 16455 0 0 0 0 0 19501 0
	0 18723 25413 25414 17237 0 20039 0 0 25416 25415 0 0 0 0 0 0 0 0 0
	0 0 0 0 15471 0 0 25418 12400 0 0 0 0 25421 0 0 0 25419 12884 14158
	25420 14662 14706 0 19046 25422 0 0 19284 0 0 25424 0 0 0 16465
	12623 12858 12332 0 0 0 0 0 0 25423 0 0 0 0 0 0 0 0 0 25425 25426
	15991 0 0 0 0 0 25427 0 13135 0 0 0 0 25429 0 0 0 14186 0 13670 0 0
	25430 13941 0 0 25431 0 16508 0 17997 0 16480 14965 0 0 0 25432 0 0
	0 0 0 0 0 0 0 17250 16747 0 25434 25436 25433 25435 0 0 0 0 0 0
	14114 0 0 0 0 0 0 0 0 0 25437 14118 0 0 0 13671 19794 25439 0 0 0 0
	0 25440 0 0 0 12590 0 0 0 0 25443 0 0 0 13174 25442 25441 0 25445
	25438 0 25446 20009 0 25447 0 25448 0 0 21620 25450 0 25449 0 0 0
	25451 25452 0 20021 25453 0 28783 15951 25454 25455 15703 0 17976
	25456 0 0 0 17192 0 0 25457 0 17212 25458 0 0 0 0 0 13861 0 20799
	17245 15411 0 0 0 0 13384)
      #(0 0 25459 0 25634 0 25462 0 13672 0 25461 25636 0 0 0 25460 0 15952
	0 0 0 0 0 0 25464 25465 0 17707 0 0 25466 0 13150 0 0 0 0 16218
	18788 0 25468 0 0 0 17000 0 0 0 0 0 0 25463 0 25467 25469 0 0 14971
	0 0 0 0 0 0 0 0 0 0 0 25638 18734 0 18470 17785 0 13914 25637 25635
	0 18485 25470 17246 17787 0 17786 0 14966 0 0 0 0 0 0 25656 0 0 0 0
	0 0 0 25640 0 25642 0 0 0 0 25645 0 25646 0 25643 25644 0 0 25641
	25639 0 0 0 0 25633 0 0 0 0 0 0 0 0 0 0 0 19023 12885 0 0 0 25653 0
	25650 0 25655 0 0 25654 0 18291 19495 0 15163 25648 25657 25652 0
	25651 25647 0 25649 0 13385 0 0 0 0 0 0 0 0 17213 0 0 16509 0 0 0
	18466 0 0 25662 0 0 0 18468 0 0 0 0 0 0 0 16481 25659 0 0 18511 0
	25663 19027 0 17243 0 25658 25660 0 0 25661 0 0 0 0 0 0 0 0 0 0 0 0
	0 25664 0 0 15428 0 0 0 17990 25669 25668 0 0 25665 0 0 0 20278 0 0
	0 0 0 25674 0 0 25678 25675 0 0 0 0 0 0 0 0)
      #(25671 0 0 0 0 0 0 25672 0 0 0 0 0 25677 0 0 0 25666 21077 25673
	25667 0 0 25676 0 0 0 0 0 0 0 25682 0 13386 0 25679 0 0 0 25680 0 0
	25681 25684 0 0 0 0 0 0 0 0 0 0 0 25683 18550 0 0 0 0 25685 20092
	19053 25690 0 0 25687 0 0 0 0 0 0 0 0 25686 16466 0 25689 25691 0 0
	0 25688 0 25695 0 25692 0 0 0 0 0 0 25693 25670 0 0 0 25694 25696 0
	0 0 0 0 0 25697 0 0 0 0 0 0 19014 0 25698 0 0 0 0 0 0 0 0 19554 0 0
	13902 14121 25699 0 0 0 0 0 18996 0 16232 0 19504 0 0 25700 0 20019
	0 0 18292 0 16710 18228 0 0 15693 0 0 0 12352 0 25705 25703 0 25701
	13345 0 15953 25706 0 0 25704 0 25702 25710 0 0 25709 25708 25707 0
	0 0 0 0 25711 0 0 0 25712 16442 0 25713 0 25715 0 0 25714 0 0 0 0
	14418 0 0 0 16696 0 0 0 25717 0 0 0 17788 0 25716 0 0 0 25718 0
	18997 16748 14663 0 25719 0 0 0 0 20040 0 0 0 0 0 0 0 25721 0 0
	25722 0 25723 0 25724 0 15205 0 25725 14159 0 0 13674 0)
      #(13610 0 25889 0 19571 14664 25726 0 0 0 25892 19558 0 18236 0 0
	18739 0 0 0 15715 25891 0 15443 14665 15206 13673 18998 25890 0 0 0
	16711 19266 14967 0 0 0 0 0 0 0 0 15207 17501 0 25895 20063 14937 0
	25896 16194 0 25898 0 0 0 15954 14896 0 0 0 0 25897 0 0 15658 14398
	16712 25893 25899 0 0 0 0 25894 14160 0 25902 25906 14187 0 0 0 0 0
	25901 0 0 0 0 25910 0 0 14666 0 0 19821 12348 25907 0 0 13675 0
	25904 0 0 0 0 0 25905 0 0 17789 25903 25900 0 13096 16484 0 0 14376
	0 0 0 25912 0 0 0 0 0 0 0 0 0 0 0 25909 0 0 0 0 0 25911 0 0 0 25908
	0 0 0 0 0 14161 16947 25913 16750 0 0 25926 0 0 25922 25916 0 0 0 0
	0 0 0 25920 15482 12381 25915 25923 25927 14667 19542 0 17494 25917
	0 0 25925 0 25914 17214 0 25919 12349 19530 0 0 0 0 0 0 0 25918 0 0
	13915 18540 0 0 0 16749 0 20048 15727 0 0 25966 0 0 25928 0 16510 0
	25924 25929 25931 0 17529 25934 0 0 25930 0 0 0 19028 13387 0 0
	19531 0 0 12382 0 0 25933 0 20093 0 0 0 0 0 0 25932 0 0 0 0)
      #(0 12655 0 0 18028 25935 0 0 0 25942 25936 25943 0 0 0 0 0 0 25939 0
	0 0 0 0 0 0 0 18299 0 0 15434 25941 0 25938 25944 25937 0 0 15684 0
	0 0 0 19237 0 0 15692 0 0 25940 25952 0 0 25948 0 25951 0 25949
	25953 25947 0 25921 16467 0 0 18507 0 25950 0 0 25945 0 0 0 16673
	14162 0 15659 0 0 0 0 0 0 16165 16694 25956 0 0 25958 25959 0 0
	25955 25957 0 0 0 0 0 0 0 25946 25954 0 25962 25961 0 0 19322 0 0
	14123 0 0 0 0 0 0 0 0 25960 0 25964 25963 25967 0 25969 0 0 15164
	25965 0 0 0 0 25970 25971 0 0 25972 0 25978 17723 25974 0 25973
	25975 25976 0 25977 0 0 0 0 25979 25980 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13388 0 25981 0 25982 0 0 0
	0 0 0 0 0 0 0 26145 0 0 0 0 0 0 26146 26147 26148 0 26149 26150 0 0
	26152 26151 0 0 26153 0 0 0 0 0 0 26154 26155 0 0 0 0 0 0 26158
	26156 26157 14945 14163 0 0 17238 0 18483 0 15728 0 0 18253 0 18541
	26159 22637 0 0 0 0 0 0 0 0 26160 26162 0 19813 26161 26164 26163 0
	19795 0 26165 0 18558 0 0 0 0 0 26166 0 0 0 0 0 26169 0 0 26168
	26167 0 0 0 0 26170 14130 0 0 0 16674 13633 0 0 0 0 26174 26171 0 0
	26172 0 0 0 26175 0 26176 26173 0 0 0 12585 0 0 0 12839 0 0 0 26178
	26179 0 0 0 26180 0 19810 0 0 0 0 0 15660 0 26182 26181 0 0 0 0 0 0
	0 0 0 0 16233 26183 0 0 0 0 26184 0 0 26185 0 13413 0 0 0 0 13389 0
	0 26186 0 0 0 0 0 26187 0 19293 19811 0 0 0)
      #(19796 20279 0 14669 26190 15444 26189 0 0 0 0 26191 15401 0 0 0
	16977 0 26192 0 0 14668 0 19543 26193 26194 0 0 26195 0 0 0 0 26196
	0 0 0 0 0 0 26197 0 0 0 0 0 0 0 0 0 0 15402 0 0 19565 0 0 0 0 26199
	0 17215 0 26198 0 0 0 0 0 0 26201 0 0 0 26200 0 0 0 0 0 0 0 26202 0
	0 0 16443 0 26203 0 26204 0 0 0 19001 26205 0 16751 26206 0 0 0 0 0
	26207 0 0 0 0 0 0 20094 26210 0 26209 26208 17456 0 26211 16166 0
	26212 0 0 0 26213 20280 26214 0 0 0 0 26215 26217 26216 18469 0
	18041 0 20286 18473 0 0 0 0 0 0 26219 0 0 15955 0 18730 0 26220
	26218 0 13390 0 0 0 14420 15208 0 0 18542 0 0 0 14378 19267 0 26223
	26221 0 14670 0 14671 12393 0 14952 0 0 0 0 0 18265 0 0 0 0 0 0 0 0
	12383 26228 0 17216 0 0 0 0 0 18264 0 16987 0 0 0 0 0 0 0 26230 0 0
	26226 26229 26224 0 26227 19238 0 0 14421 0 0 12413 26225 0 0 0 0 0
	0 0 0 0 26232 0 26233 0 0 17977 0 0 0 13883 0 0 0 26406 18237 0 0)
      #(0 0 15209 0 0 13884 16456 20294 19502 26231 16468 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 13651 26234 0 0 0 0 0 0 0 26236 0 0 0 0 0 26235 0 0 0 0
	0 26237 0 17190 0 18238 0 0 0 0 0 17457 0 0 0 0 26403 0 0 0 0 0 0 0
	26402 0 0 0 0 26238 0 0 16213 0 18789 26405 0 26404 14672 20307 0 0
	0 0 0 0 0 0 0 26421 0 0 0 0 0 26409 26410 0 0 0 0 15472 0 0 26408 0
	14712 26407 0 0 26411 0 0 0 17458 18978 16675 0 0 0 0 16988 26415 0
	26416 26412 0 0 0 0 26413 0 26414 0 0 0 0 14673 0 0 0 26422 0 26418
	0 0 0 0 18790 0 19308 18728 0 0 26417 0 0 26420 26419 0 0 0 19268
	26423 0 0 0 0 0 0 26424 0 0 16695 0 26425 0 0 26427 0 26431 0 0
	26428 26426 18239 26429 0 26430 0 0 0 12850 0 26437 26432 0 0 0
	26433 0 0 0 26434 0 16929 0 0 0 0 26436 26435 26438 0 0 0 0 26439
	26440 0 0 16195 0 12905 0 26441 20055 0 15403 0 0 15661 0 0 0 0 0
	15210 17239 0 0 0 0 0 26442 26443 12593 0 26444 0)
      #(0 26445 26446 0 0 26447 0 26448 13885 23082 26449 0 16485 26450
	15435 0 26451 0 20528 0 0 0 26452 19038 13404 0 0 16676 15704 0
	18801 15662 0 0 0 0 0 0 0 0 0 26453 14674 26454 18508 0 26468 0 0 0
	0 26456 0 16969 18293 14399 26455 16677 0 0 0 0 0 0 26457 0 0 0 0 0
	0 17530 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26459 26458 26461 0 0 26460
	0 26462 0 0 26464 0 26463 0 13391 0 26465 0 26466 26467 0 0 14897
	20041 0 26469 16167 0 0 0 12656 26470 26471 0 0 0 0 0 26472 0 0 0 0
	0 0 0 0 0 0 0 0 12402 0 26473 0 0 0 0 26474 0 0 0 0 0 0 18791 0 0 0
	15431 0 26476 0 0 0 0 0 13097 12338 0 0 0 0 26475 26478 18254 0
	16196 0 12886 0 19239 0 0 0 0 14173 13916 0 26477 0 12906 0 0 0 0 0
	0 0 13347 0 0 0 0 0 0 0 0 0 0 0 12657 26482 20074 16989 0 0 18756 0
	26494 0 12887 26492 0 26490 26481 0 26479 0 26480 0 15459 13932
	17271 0 0 0 18001 0 0 0 0 0 12625 0 26484 26483 0 0 0 0 26489 26485
	26488 0 0 0 0)
      #(0 0 19536 26487 12888 13181 26491 0 0 26493 0 0 0 0 14164 0 0 0 0 0
	0 0 26659 26668 26669 0 0 0 12331 0 0 0 0 0 0 26676 0 0 0 0 12401 0
	0 26667 0 0 0 26666 0 26661 26660 0 26658 26657 17251 0 17019 26663
	0 0 0 0 0 0 26662 0 0 0 0 26665 0 0 0 16752 14165 0 0 0 0 12609
	26664 0 14675 0 0 0 0 0 16753 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 26682 0 26683 0 12889 0 0 0 12846 26680 0 0 0 0 0 0 0
	0 26670 0 26678 0 26685 26679 0 0 0 26677 0 0 0 0 26486 0 0 26675 0
	0 0 26671 0 0 0 13392 26673 26684 0 26674 0 0 0 0 0 26686 0 26672
	18300 0 0 0 0 0 19817 0 0 0 26681 0 0 0 0 0 0 0 26703 0 0 0 26695 0
	0 0 16251 0 0 0 0 13638 0 13917 0 26690 0 0 0 0 12891 0 0 15956 0
	26693 0 0 0 14938 0 0 17745 26698 0 0 0 0 0 0 0 0 19054 0 26689 0 0
	0 12890 14422 18729 26699 0 26687 0 0 26696 0 0 0 26706 0 26691 0
	0)
      #(0 0 0 26692 17978 0 0 26697 0 0 0 26694 19240 26700 12384 0 0 0 0
	26688 0 0 0 0 0 0 0 0 0 0 0 0 26702 0 26701 0 0 0 0 0 0 18283 26708
	0 26719 0 0 0 0 13182 0 0 0 26722 0 0 26704 0 0 0 26709 19822 0 0 0
	0 0 0 0 0 26718 0 0 19797 0 0 0 0 20010 0 0 0 0 0 0 0 0 17272 0 0 0
	13163 0 0 0 0 0 18802 26724 17953 0 0 12337 0 0 26717 0 26713 16754
	26707 26715 26720 0 18220 0 0 0 12330 0 26712 0 26721 18808 0 0 0 0
	0 0 0 26716 0 26711 0 0 0 0 0 0 15957 0 0 0 0 15663 0 0 0 15404 0 0
	0 0 19544 0 0 18759 0 0 26727 0 26736 0 0 0 0 0 0 0 0 0 0 0 26714 0
	0 0 0 13175 0 0 0 0 0 15992 26725 0 26730 16755 0 0 26726 0 26733 0
	0 17247 0 26734 0 0 19798 26723 13112 0 26729 0 0 26732 19500 0 0 0
	0 26735 0 0 26728 26731 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 19241 0
	20257 0 0 0 0 0 26739 0 0 0 0 0 0 0 26746 0 0 26738)
      #(15427 0 0 0 0 0 26705 0 0 0 0 0 0 0 0 0 0 19022 0 19490 26745 26744
	0 26740 26741 0 12598 0 0 0 0 26743 0 26737 0 0 0 0 17493 0 0 0 0 0
	26742 12414 0 0 0 0 0 0 0 16930 0 0 0 0 0 0 0 19011 0 0 26747 26913
	0 18521 0 0 0 0 26750 15958 15433 26915 0 0 13886 0 0 0 0 0 0 26916
	0 18809 26749 0 26710 0 0 0 0 0 0 0 0 26748 0 0 0 0 20303 17954
	18803 0 0 26923 0 0 0 0 0 0 0 0 0 26929 0 0 0 0 0 0 26930 0 26917 0
	0 0 18294 0 0 26927 26919 0 26921 0 0 0 0 0 26931 26920 0 0 26924 0
	0 12658 0 18021 0 26925 26928 0 0 0 0 0 0 0 26918 0 16678 0 26922
	15143 16197 14128 19572 0 19577 15730 0 0 0 0 0 0 0 0 0 26935 26933
	0 0 0 0 0 0 20302 0 0 0 0 0 0 0 26932 0 0 0 19829 0 26934 26936 0 0
	0 0 26937 0 0 0 0 0 0 26940 26938 0 0 0 0 0 0 17955 26939 0 0 0
	18509 26926 0 0 0 0 0 0 0 0 0 0 0 0 15731 0 26941 26946 16756 0 0
	26945 0)
      #(0 0 26914 0 0 0 26947 16713 0 0 26942 26944 0 0 0 0 0 0 0 26943 0 0
	23857 23842 0 0 26949 0 0 0 0 0 0 0 26948 0 0 0 0 0 0 0 0 0 0 19830
	0 25148 26950 0 0 0 0 0 0 0 0 0 0 0 0 0 0 26951 0 0 0 0 0 0 0 0 0 0
	0 0 0 26952 14423 0 13652 0 0 0 26954 20829 0 0 0 0 13685 0 20026 0
	13939 26955 0 0 0 0 0 0 0 26956 0 0 0 17262 0 0 0 0 0 26957 0 0 0 0
	0 0 0 18042 0 12346 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12899 26962 26963 0
	0 0 0 0 0 26958 0 15165 0 0 0 0 0 0 0 0 0 0 0 0 0 26959 18242 0 0 0
	0 26960 26961 26971 0 0 0 26965 26968 0 0 0 0 0 26964 0 0 0 0 0 0 0
	0 0 0 0 0 0 26966 0 26967 15448 0 26969 0 17217 0 14166 13122 0 0 0
	0 0 26972 0 0 0 0 13119 0 26977 0 0 26973 26976 0 0 0 0 18490 0 0 0
	0 26974 0 0 26975 18760 18522 26978 0 0 0 0 0 0 0 0 17021 26988 0
	26984 0 0 12907 0)
      #(26982 0 19242 26983 0 0 26980 0 26981 26986 26989 0 0 26987 0 0 0
	26985 26979 0 0 0 0 0 17240 0 26996 0 19498 0 0 0 0 0 0 0 0 26994 0
	0 0 26995 0 0 0 0 0 0 0 0 0 0 26990 0 0 26992 0 0 0 26993 0 0 0
	26991 0 0 0 0 0 0 0 0 0 16486 0 20281 27000 0 27001 0 0 0 0 27169 0
	16170 0 27003 0 27006 0 0 0 0 0 26998 26997 0 0 27170 0 0 12892 0
	27004 0 27171 0 0 0 27005 0 0 0 0 0 27002 0 17459 0 26999 0 0 0 0 0
	0 18280 0 0 27175 0 0 0 0 0 0 0 0 0 0 19771 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 27174 0 0 27173 0 0 0 0 0 0 0 0 27182 0 0 0 27176 0 0 0
	27184 0 0 0 0 0 0 19814 27187 0 27178 0 0 27179 0 0 0 27183 0 27186
	27185 0 0 0 27177 0 0 0 0 27180 0 27197 0 0 0 0 0 0 0 0 0 0 0 0 0
	27190 0 0 0 0 0 0 0 0 0 0 0 0 0 0 27188 0 0 27189 0 0 0 27194 27195
	0 13098 0 13634 0 0 27193 0)
      #(0 0 0 0 0 27172 0 0 0 0 0 0 0 27192 27196 27191 0 27198 0 0 0 27200
	27199 0 0 0 0 0 0 0 0 0 0 27202 27201 26970 0 0 0 27206 0 0 0 0 0 0
	0 0 0 27203 0 0 0 0 27204 0 0 27205 0 27207 0 0 0 0 14188 0 27209 0
	27208 0 15664 0 0 0 0 0 14676 24103 0 0 0 0 27210 15697 0 0 0 13113
	0 27211 0 12626 0 15959 27212 0 0 14677 27213 12385 0 0 0 0 18749 0
	0 27214 0 0 0 0 16234 0 27221 0 0 27218 0 17263 0 0 0 0 0 27219
	27216 13918 0 27215 27222 0 0 0 0 0 14134 0 0 16990 0 27228 0 0 0 0
	27224 0 0 0 16949 27223 0 27226 0 0 0 0 27217 0 0 0 27227 0 27229 0
	0 0 0 0 0 18543 0 0 27225 0 27230 27232 0 0 14419 27220 0 12353 0 0
	0 0 0 0 0 27231 0 14939 20086 27233 27234 16757 0 0 0 0 0 0 0 0 0
	20002 0 0 0 0 27235 19765 0 0 27236 27237 0 0 19044 27238 0 14912 0
	20003 0 0 0 0 0 0 27243 0 0 0 0 0 0 0 0 0 27244 15960 27242 0 0 0
	19815 27239 0 0 27241 16445 16254 0)
      #(0 0 27240 0 27245 0 0 18979 0 0 27247 0 27246 0 0 0 13164 0 19243
	27248 0 0 0 0 0 0 0 0 0 27260 27250 0 0 0 0 0 0 27251 0 0 0 0 27252
	27253 0 0 0 0 0 0 0 0 0 0 27257 0 27258 0 0 27256 0 0 0 0 0 27254 0
	27249 27255 0 0 0 0 0 0 0 27259 28727 0 0 0 0 0 0 0 0 12840 0 0 0 0
	0 0 0 27262 13919 27261 0 0 0 27426 0 27425 0 0 0 27428 0 0 27427 0
	27429 0 0 15665 0 27430 0 0 27431 0 0 0 0 0 0 27432 16446 0 19799 0
	27433 0 0 18980 18246 27434 0 27435 14379 0 0 0 13612 0 0 0 27436 0
	0 15211 18241 27437 0 13136 0 0 0 0 0 0 27438 0 0 0 0 27440 19831 0
	27439 16198 0 27441 0 0 27442 0 0 27443 13393 0 0 0 0 0 0 27444 0 0
	27445 0 27446 27447 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 13137 0 0 0 0
	0 0 0 27448 0 27449 27450 0 0 0 0 0 12914 0 0 16168 27451 0 0 0 0 0
	0 0 0 0 0 0 0 27452 0 0 0 27453 0 0 0 0 0 0 0)
      #(14400 0 17531 27454 0 0 0 0 14167 0 16214 0 27457 0 17956 0 27456 0
	0 14129 0 0 27455 17015 13613 0 0 27458 0 27459 0 15961 0 0 0 14189
	0 27460 0 0 0 0 19244 0 0 16479 0 0 0 13686 0 19573 16714 0 27461 0
	0 0 16199 17264 15962 0 0 0 0 27462 0 0 0 0 27465 0 27466 0 0 0 0 0
	0 0 14910 16962 27464 0 15963 18750 0 0 0 0 0 27463 0 0 15212 0
	12627 0 27470 14168 0 0 15214 0 0 15213 0 20301 27469 27468 16679 0
	13645 20291 13114 15964 0 0 0 0 0 0 0 0 27467 0 0 0 0 0 27472 0
	27473 27471 0 14424 0 19776 0 0 15215 18215 0 0 0 27476 0 16448 0
	17218 0 0 19766 0 27479 0 0 0 14444 0 16447 27475 0 27480 14445
	27477 27478 0 27474 0 0 0 16482 17993 0 0 17199 0 12893 0 0 0 0 0 0
	18544 0 0 13635 0 0 17460 0 0 27483 0 27481 0 0 17228 0 0 0 16449
	13394 27482 0 16219 0 0 20042 0 0 0 20288 0 0 0 27484 27495 17461 0
	27494 0 27491 27499 27492 0 27488 0 17532 27487 0 0 0 27485 0 19745
	15216 0 0 27489 0 27486 0 0 0 27493 15732 0 14401 0 0 0 17018 0)
      #(19269 12634 12386 0 17957 0 0 27497 0 0 0 0 27496 0 18022 0 27501 0
	0 0 27490 0 27500 27502 0 14380 27498 14678 0 15445 0 0 27503 19800
	0 0 0 0 27506 0 27509 0 0 27507 18741 0 0 0 0 0 0 27504 0 0 0 0 0
	13920 0 0 0 0 27508 0 0 27510 0 0 0 0 0 0 0 27514 0 0 27511 0 27513
	27512 0 0 0 0 0 0 27515 0 15409 0 27517 27516 18792 0 0 27681 0 0 0
	0 0 0 14169 0 0 0 0 27518 27682 0 0 27683 13636 26177 15993 0 27684
	0 0 14446 0 0 0 0 0 27685 0 0 27686 0 0 15166 0 0 0 0 0 0 23118 0
	27687 0 27688 0 15666 0 27689 27690 0 0 27691 0 0 27692 27693 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 17195 0 0 27694 0 0 0 0
	27696 0 27695 0 0 0 0 17958 0 27697 0 19245 0 27698 0 27699 0 27700
	0 0 0 0 27701 0 0 0 0 18010 0 0 0 0 0 0 15965 27702 0 0 0 0 0 0 0
	14699 20526 27703 0 0 0 0 0 0 0 0 0 0 0 27704 18751 27705 0 27713 0
	0 0 0 0 27706 0 0 27708 0 0 0 27707 27709 0 19270 27710 27711 0 0 0
	0 0 27712 0 0 0 27714 0 0 0 0 13101 17511 0 18793 14946 14679 0 0 0
	0 18767 12895 18510 27717 13395 16469 27716 27721 17273 19555 0
	27719 27720 13614 0 27722 18275 16991 0 0 18545 17725 27718 0 19271
	12908 27724 20264 17474 20293 0 0 15217 27723 0 16945 0 0 27740
	16680 0 0 18040 0 18768 0 0 0 0 0 0 27727 15167 15218 0 15966 0
	18277 0 14381 27726 27725 0 18794 0 0 0 15425 0 0 17746 0 0 0 0 0 0
	0 0 0 0 0 0 27729 27730 14680 27728 0 0)
      #(0 0 0 0 27731 27732 0 27734 16931 0 27733 13414 0 27736 0 27735
	27737 0 0 27739 27741 0 27742 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16470 0 15439 27743
	0 0 0 13138 0 27744 0 0 16758 27745 0 27746 18795 0 0 13615 0 0 0 0
	0 0 0 0 0 27747 0 0 0 17462 0 0 0 0 12635 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 27748 0 0 0 0 0 0 0 0 0 15473 0 0 0 0 16246 0 0 0 0 0 0 0 0 0 0
	16941 0 0 0 0 0 0 27751 0 0 0 27750 0 0 0 27749 0 0 0 0 0 0 0 0
	27757 27755 0 0 27752 0 0 0 0 0 0 27754 0 0 0 27753 27756 0 13687 0
	27760 0 16471 0 27761 0 0 0 0 14425 0 27758 27759 0 0 0 20265 0 0 0
	17463 0 16681 0 0 0 0 0 0 27762 0 0 27765)
      #(0 0 0 0 0 0 0 0 27763 27764 19801 0 0 0 0 17959 27768 0 0 0 0 0 0 0
	0 0 0 0 0 27766 27767 27769 0 0 0 0 0 0 0 0 0 0 27945 0 0 0 0 0
	27772 0 0 0 27773 27771 0 0 0 0 0 0 0 0 0 0 0 0 27770 0 17533 0 0
	27937 27941 27938 27774 0 27939 0 0 0 27940 0 0 0 0 27947 0 0 0
	27942 0 0 0 0 0 16472 27944 0 0 27946 27943 0 0 0 0 0 0 0 0 0 0 0 0
	0 27949 0 15667 0 27948 0 0 0 0 0 27950 0 0 0 0 27951 0 0 27954
	27953 0 27952 0 0 27956 27955 0 19574 0 0 0 27958 0 27957 27959 0 0
	0 0 27960 0 0 0 0 0 0 0 27962 0 0 0 0 0 0 0 0 27961 16200 27963 0 0
	13933 27964 27966 0 0 0 0 0 0 0 0 0 0 0 0 27967 0 0 0 0 0 0 27968
	27965 0 27969 0 15446 27970 13616 14131 0 0 0 0 14382 0 0 0 0 0 0 0
	0 27971 0 0 0 18032 0 0 17726 27972 0 0 0 0 0 0 0 27975 0 0 0 0 0 0
	0 0 0 0 0 0 15412 0 0 27974 27973 14170 27976 0)
      #(0 0 0 13139 0 27978 0 0 0 14940 27977 0 27986 0 0 0 0 0 27980 27982
	19045 27979 0 0 0 27981 0 27985 27983 13617 0 27984 0 0 0 0 0 0
	27987 0 0 18266 20056 0 0 0 0 15668 0 0 0 27988 0 0 0 0 19746 27990
	0 27989 0 0 27993 19777 0 0 27992 0 13165 27991 27996 0 0 27995 0 0
	27994 17714 27997 0 0 0 0 0 0 0 0 27998 0 0 0 0 27999 0 0 14700 0
	14117 28000 28001 28002 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	16201 28003 0 15405 28004 0 0 0 28005 0 0 0 21025 20862 0 0 0 0
	28006 25968 28007 17188 16171 18240 0 0 0 0 28008 0 0 19029 17492
	14718 0 0 17193 0 0 12586 0 19320 16215 0 0 0 0 0 0 0 0 14174 0 0
	13921 0 0 19030 0 0 0 0 0 28009 0 0 0 0 0 0 0 28011 0 0 28010 12896
	0 0 18038 28012 18295 0 17715 0 28013 15698 0 0 0 28015 0 0 19522
	28030 28017 28018 0 0 17481 0 0)
      #(16992 16759 0 17960 0 28016 13653 0 0 0 0 28025 0 28022 28197 17961
	17248 28019 0 17534 17747 28020 28024 16224 0 18279 17484 0 0 16450
	28023 16942 16932 28021 12329 20258 0 0 0 28026 0 0 0 0 0 0 16993 0
	0 15669 16202 0 0 28028 28027 0 12399 28029 0 0 18735 0 28199 0 0
	18011 16235 0 0 17241 0 13944 0 28198 19767 12607 0 19031 12897
	28193 28194 28195 28196 17979 17187 12387 28200 0 28201 29731 0 0
	16957 0 28202 0 12659 16716 0 14383 0 19802 0 0 28203 17708 0 0 0
	16760 15447 28204 0 0 28207 0 0 15717 28205 16683 16682 0 12388 0
	20043 28209 0 18546 28211 28210 28208 25444 13396 0 0 28014 0 28213
	28212 0 0 0 0 28214 0 19768 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18017
	0 0 19246 0 28215 0 15449 0 0 0 0 28216 0 28217 0 0 0 28218 0 0
	17697 0 0 0 0 0 0 0 0 12394 0 0 0 0 0 0 0 0 14681 0 0 0 20282 0 0 0
	0 0 0 0 0 0 0 0 0 28222 0 0 0 0 0 14132 28219 0 28220 0 0 0 18804 0
	0 0 0 13140 0 0 0 0 0 0 0 19769 0 13887 0 0 0 0 0 17748 0 0)
      #(0 0 28223 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 28224 0 0 0 0 0 0 28225 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 17698 0 0 28227 0 28226 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18003 28228 15670 15456 18267
	17265 0 0 0 15474 0 16236 0 28229 0 28230 0 0 0 0 0 0 0 0 0 16221
	28231 0 28232 0 0 0 28233 19823 0 15671 0 0 0 0 0 28235 28234 0
	14682 0 14707 15168 0 0 0 0 0 0 0 0 0 28238 0 0 0 0 15718 0 28237 0
	28236 0 17001 0 0 14447 0 16451 0 0 0 0 18480 0 0 0 0 15673 0 0 0 0
	0 28239 0 15967 0 0 0 0 0 28242 28240 0 0 0 28241 0 0 0 0 28244
	28243 0 0 15994 0 28245 0 0 0 0 0 28246 28247 0 0 0 0 18512 14931
	15457 28248 0 28249 20004 15685 19566 20044 28250 13922 0 0 0 0
	28251 0 17699 0 0 28254 13176 16203 0 28252 0 28253 0 17504 0 0
	19285 13948 0 0 0 0 0 0 0 0 0 0 0 0 0 28256 28257 0 0 0 0 0 28255 0
	0 28259)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 18015 13123 0 0 28263 0 0 28260 28262 0 0
	0 0 0 0 0 0 28258 0 0 0 0 0 0 0 0 0 0 28495 0 0 28261 0 0 0 0 0 0 0
	20075 0 0 14426 0 0 0 0 0 0 0 28271 0 0 0 0 17716 28266 0 0 28269
	28267 0 28272 0 0 0 0 28273 0 0 0 0 0 0 28265 0 0 28278 12660 0 0
	28264 0 0 0 18477 0 28268 0 15968 0 0 0 0 0 0 0 0 0 0 14683 0 0 0 0
	0 0 0 0 0 0 0 0 19272 0 13924 0 0 15686 0 17980 0 0 0 0 0 0 0 0 0 0
	0 16685 0 28276 0 28270 28275 0 19523 0 17464 28277 28274 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 16684 0 0 0 0 0 0 0 0 0 28281 0 28280 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 28279 0 0 19247 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 15739 0 0 0 0 28282 19039 0 0 12628 0 0 0 0 18758
	17266 0 0 0 0 13688 0 28284 0 14685 0 0 0)
      #(0 0 0 0 0 0 15148 0 0 0 0 0 0 0 0 28283 16237 0 0 0 0 0 0 0 16238
	28449 28451 0 0 0 0 0 15995 0 28450 28452 0 0 13907 0 18757 0 0
	15458 20259 0 28286 14968 0 0 20287 0 0 28454 0 0 0 0 28453 28455 0
	0 0 0 0 0 0 0 28285 0 0 0 0 0 0 18025 0 17749 0 0 0 0 0 0 17495 0
	28460 0 0 0 0 17219 28456 0 0 0 28457 0 0 0 0 0 0 0 0 0 0 0 14125 0
	28459 0 0 0 0 0 0 14384 0 0 0 0 0 0 28458 0 15969 0 0 0 0 0 0 0 0 0
	0 0 0 0 13177 0 0 0 0 0 0 0 28464 0 14911 16761 0 0 17482 0 0 0 0 0
	0 0 0 0 0 0 0 13115 0 0 0 0 28462 28463 17475 0 28461 0 0 0 0 0 0 0
	0 28465 0 0 0 0 0 0 0 0 0 28471 0 0 0 0 28474 0 0 0 0 0 0 0 28473
	17709 0 0 0 0 28466 28467 28470 0 0 0 0 28472 0 0 0 13888 0 0 28475
	28469 0 0 28468 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #(0 0 0 28479 0 0 0 28480 0 0 0 0 0 0 0 0 28481 0 0 28478 28477 0 0 0
	15970 17962 28476 0 0 0 0 0 0 28485 0 0 0 0 0 0 0 0 0 28483 0 0 0 0
	0 0 0 0 0 28484 28482 0 17016 0 28486 0 0 0 0 0 0 28487 0 0 28489 0
	0 0 0 0 0 0 0 0 0 0 0 13397 28488 19578 0 0 0 0 0 0 28500 28490 0 0
	28493 0 28491 0 28492 0 0 0 0 0 0 0 28494 0 0 0 0 0 28496 0 0 0 0
	28497 0 28498 0 0 0 0 28501 28499 28502 28504 0 28503 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 17465 0 0 0 0 0 0 0 0 19559 0
	28505 16686 0 0 0 28506 0 19012 28507 13099 0 0 0 12604 0 13399 0
	13398 28508 0 28509 0 28510 28511 0 0 0 0 0 0 28512 0 13400 13141
	14686 18486 0 28514 28513 0 0 0 0 28515 0 0 0 0 12636 0 0 0 0 0 0
	28518 0 28517 28516 0 28519 0 0 0 0 28522 0 0 0 12359 0 0 28520 0
	28524 28523 0 0 0 0 0 0 28526 28525 28527 0 17966 0 0 0 28528 0 0 0
	0 28529 28531 0 0 28530 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18796 0 0 0
	0 28532 0 0 0 0 0 0 28533 0 14949 0 0 0 28534 28535 0 0 19273 0 0 0
	0 0 0 0 0 16715 0 0 0 12324 16971 0 28536 0 18797 0 0 0 0 0 0 28539
	28537 14687 0 28538 14402 0 0 0 0 0 0 0 0 0 0 19013 28541 28705
	28542 28706 0 0 12577 16216 15740 13401 28707 0 0 0 18278 0 28709 0
	0 0 12578 0 28708 17476 0 20045 17963 28540 20006 0 14385 0 0 19803
	0 0 0 0 0 0 0 13945 20020 0 14120 0 16994 26401 0 28710 13100 16239
	0 0 0 0 13142 28712 0 28713 28711 14180 0 14941 15971 0 0 0 12579 0
	0 20057 0 0 0 28715 28206 0 28714 0 0 0 0 0 28718 28716 28717 0
	28719 0 28720 20076 28721 28722 0 16457 18491 0 0 0 16253 13415 0 0
	19770 12909 15672 14427 0 28725 0 28724 15219 28726 28723 0 0 15144
	0 0 0 28730 27181 0 0 21078 0 16247 28728 0 0 0 0 0 20005 18033 0 0
	0 0 12587 0 16483 15414 0 0 0 0 18999 0 12608 0 0 0 20077 19819 0
	28731 0 17733 0 0 0 0)
      #(15483 0 0 0 28732 0 28733 16204 28734 0 20078 0 0 28729 28736 28738
	0 28737 0 28735 0 0 28739 0 0 28740 0 0 16762 0 12898 0 0 0 0 0
	28741 0 0 19512 0 0 28742 0 0 0 0 0 28743 0 20266 0 0 0 0 0 23345
	28744 0 0 0 28745 28746 0 0 0 28750 0 28747 0 28748 0 28749 28751 0
	0 0 0 0 0 0 0 16452 0 0 0 19575 0 0 16453 0 0 28752 0 18547 0 28753
	29523 19532 0 28754 0 28755 0 28756 13143 0 28758 0 16217 0 0 0
	28759 0 0 14116 0 0 0 0 28760 28764 0 28762 0 0 0 0 28763 0 0 13171
	28761 28765 0 0 0 0 28766 0 12360 0 28767 28768 0 0 0 0 0 0 0 15972
	0 0 0 28769 0 0 0 13639 0 0 28772 0 0 28771 0 28770 0 0 27505 0
	19036 0 0 0 0 0 28773 28774 0 0 0 0 0 0 0 0 0 0 0 0 0 0 28775 0 0
	28776 0 28777 0 0 28778 0 0 0 0 0 0 0 13402 0 0 0 0 0 0 0 0 28779 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 28780 18211 0 0 0 28782 12859 0 28785
	28784 0 0 0 0 12580 0 0 0 13889)
      #(0 19015 17466 14882 0 14688 15719 0 16220 0 0 0 28787 0 0 28786
	19778 13416 18514 18012 0 0 0 16252 20046 0 14171 0 0 0 0 0 0 28790
	0 0 28789 0 0 0 0 0 0 0 19275 17964 0 0 0 0 0 0 12624 0 0 28791
	28788 0 0 18769 19818 28792 0 0 0 0 0 0 0 0 28793 0 0 0 0 28795
	17002 13147 13148 28794 0 0 0 0 13417 14386 0 0 13418 0 0 17727 0 0
	20064 0 0 0 0 0 0 0 0 14428 0 0 0 28796 0 0 0 28797 28798 28961 0
	28963 28962 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18807 0 28964 0 0 0 0
	28965 0 28966 0 0 0 0 28967 0 0 0 0 0 0 0 0 0 0 0 0 28969 28968 0
	28970 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18548 26188 0 0 16169
	0 0 13618 0 0 0 0 0 0 28971 0 28972 0 21036 23867 18515 0 0 12411 0
	12347 0 0 0 0 0 0 0 15220 19248 15998 0)
      #(0 0 0 28973 0 19551 0 0 0 28974 19804 0 12610 0 0 0 15169 0 28975
	12910 28976 0 0 0 28977 0 0 0 0 28979 28980 0 28982 28978 0 0 28981
	0 0 0 13403 0 0 0 28983 0 28984 0 0 0 0 0 0 0 0 0 0 0 0 0 0 28985
	28986 0 0 0 28987 0 0 28989 0 0 0 28988 0 28991 28994 0 0 0 28990
	28992 28993 0 0 28995 0 13890 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 15475 28996 28997 14689 0 0 0 0 0 0 0 0 0 0 0
	28998 0 0 13118 0 0 0 18255 28999 29000 0 0 0 0 17242 18027 0 0 0 0
	0 0 0 29001 0 0 0 0 18301 0 0 16972 12632 13934 0 13935 0 0 0 0 0 0
	0 17267 29006 13936 0 0 12911 0 0 29005 0 0 29003 0 29004 0 29002 0
	0 29016 0 0 0 0 0 0 0 0 0 0 29007 29008 0 0 29009 29010 0 0 0 0 0
	29012 0 0 29011 0 0 0 15705)
      #(0 29013 0 0 0 29015 0 0 0 0 0 0 0 0 13619 29014 0 0 16763 14387 0 0
	0 0 0 29017 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16973 0 0 29018 0 0 0 0
	17965 0 0 0 0 0 0 29019 0 0 0 0 0 0 29024 0 29022 0 29021 29023 0
	29020 0 0 0 0 0 0 0 29026 0 0 0 0 0 0 0 29025 0 29028 0 0 13891
	29027 0 0 0 29029 0 0 29030 0 29032 29031 0 0 0 29033 29035 29034 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14716 0 0 0 0
	29036 0 0 29037 0 0 0 0 0 0 0 13116 0 0 0 29038 0 0 0 29039 0 0 0
	16241 0 0 0 0 0 0 0 0 0 0 29040 0 29041 0 29042 29043 0 0 0 14690 0
	0 0 0 0 29044 29045 0 0 29046 29047 0 0 29048 0 0 0 18481 29050 0
	18726 29051 29049 0 29053 0 0 29052 0 0 29054 0 0 0 29217 0 0 0 0)
      #(0 0 0 0 0 0 29218 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29219 0 29220 0
	0 0 0 29221 0 0 29222 29223 0 29224 0 29225 29226 29227 29228 0 0 0
	29229 29230 0 23861 29231 0 0 0 0 0 0 0 0 25720 13620 0 0 0 0 13089
	14898 29233 29232 19493 0 0 0 0 0 0 0 29235 29236 29234 0 29237 0 0
	19298 0 0 0 29238 0 13691 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	20261 0 0 0 0 29239 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29241 0 0 0 0 0 0 0
	0 0 0 12350 0 0 29242 18987 29240 0 0 29243 29244 0 0 0 0 0 0 0
	29245 29246 0 0 0 0 0 0 0 29247 0 19310 15149 0 14970 16687 0 0 0 0
	0 29248 0 0 0 0 29251 0 0 0 0 0 0 29249 0 0 0 0 0 29252 0 0 14449
	29250 0 0 0 0 29253 0 29254 29255 0 29259 0 15146 0 0 0 0 16996 0 0
	0 0 0 29260 29257 29256 29258 0 0 0 14175 0 0 0 0 0 0 0 29264 29263
	29262 0 0 12339 0 0 0 0 0 0 0 0 0 0)
      #(0 0 0 0 29274 0 29270 0 29271 29267 29273 0 29269 13154 0 0 20300 0
	29272 29268 29266 29265 0 0 0 0 0 29276 0 0 0 0 0 29279 0 0 29278
	29277 0 0 0 0 0 0 0 18761 29275 12403 29280 0 29282 0 0 0 0 0 0
	13167 29261 12599 0 0 29284 0 0 0 0 0 0 0 29283 29281 17197 0 0 0 0
	0 0 0 0 0 19312 0 0 0 0 20058 0 0 29285 0 0 0 0 0 29286 0 0 0 0 0 0
	29287 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29288 0 29289 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 17467 0
	29290 0 18487 0 29295 29291 0 0 0 29292 0 0 19249 19524 0 18000 0 0
	0 0 0 0 0 0 0)
      #(0 0 0 29296 0 0 29297 17982 29294 29293 0 0 0 0 12842 0 0 0 29305 0
	0 29304 0 0 0 0 0 12661 0 0 0 29302 0 0 0 29301 0 0 29299 0 13179 0
	29298 15410 12841 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14691 0 0 29308 29307
	0 29306 0 0 29303 0 29309 0 29310 0 0 0 0 0 0 0 29477 29476 0 0 0 0
	0 0 0 29478 0 0 12589 29473 29474 0 14708 19513 0 0 29475 0 0 0 0 0
	0 0 19250 0 0 29483 0 0 29479 0 0 0 0 0 0 0 29484 0 0 0 0 0 0 0 0 0
	0 0 0 29481 0 29480 0 0 0 0 0 14172 0 0 0 0 0 0 0 0 0 0 29485 0 0 0
	0 0 0 0 0 0 29486 0 0 0 0 29487 0 29482 0 0 0 29300 0 0 29488 0
	17505 0 0 0 29492 0 29493 29491 0 0 0 0 0 29490 29496 0 29489 0
	29494 0 0 0 0 0 0 0 0 29495 0 0 0 29498 0 0 0 0 0 29497 0 0 0 0 0 0
	0 0 0 0 0 0 29500 0 0 0 0 0 0 29501 0 29502 0 0 20297 0 0 0 0 0
	29499 17003 14957 0 0 29503 0 0)
      #(0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29504 29505 0 0
	29506 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 29507 0 0 14388 29508 0 0
	0 29509 0 15407 0 29510 0 0 0 0 0 0 29511 0 0 29512 29513 0 0 0 0
	29516 29514 20284 0 29515 0 20079 0 0 0 0 0 29517 0 20059 0 0 0 0 0
	29518 18302 0 0 29519 29521 0 0 29522 0 0 0 0 0 0 0 0 0 0 29520
	14701 19533 19299 22135 0 23904 19323 0 0 0 0 12843 0 0 0 0 0 0 0
	29524 13648 29525 29526 29527 0 14709 0 29528 0 0 0 24660 19547 0
	16995 29529 29531 29530 0 29532 0 0 0 0 29533 0 0 29534 0 0 0 0 0 0
	29535 0 0 0 0 29536 0 29537 29538 0 29539 0 29540 29541 29542 0 0)
      #(0 0 0 0 0 0 0 29543 29544 0 0 0 0 0 17700 0 0 0 0 14429 0 29546 0 0
	0 0 0 0 0 0 0 0 16717 29547 0 0 0 0 0 0 0 0 0 0 29548 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 18721 0 0 29549 0 0 0 0 0 0 0 0 0 0 0 29550 25399 0 0
	27738 28781 0 0 29551 0 29552 0 0 0 0 0 0 0 0 0 0 29554 29555 29556
	20080 29553 0 0 29557 29558 0 0 29560 0 29559 0 0 0 0 0 29562 0 0 0
	29563 29561 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 20022 0 0 0 0
	0 0 0 29564 0 0 0 0 0 0 29565 25428 0 0 29566 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #1# #1# #1# #1# #1# #1# #1# #1# #1# #1#
      #(0 8490 0 8564 8560 8563 8565 0 8522 8523 8566 8540 8484 0 8485 8511
	9008 9009 9010 9011 9012 9013 9014 9015 9016 9017 8487 8488 8547
	8545 8548 8489 8567 9025 9026 9027 9028 9029 9030 9031 9032 9033
	9034 9035 9036 9037 9038 9039 9040 9041 9042 9043 9044 9045 9046
	9047 9048 9049 9050 8526 0 8527 8496 8498 8494 9057 9058 9059 9060
	9061 9062 9063 9064 9065 9066 9067 9068 9069 9070 9071 9072 9073
	9074 9075 9076 9077 9078 9079 9080 9081 9082 8528 8515 8529 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8497 0 8559 0
	0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))

(defun process-code (uchar)
  (let ((ucode (char-code uchar)))
    (if* (< ucode #x7f)
       then ;; codeset 0
	    ;; See note below regarding #x7e.
	    (return-from process-code uchar)
     elseif (<= #xff61 ucode #xff9f)
       then ;; codeset 2
	    ;; Note that there is a weird character, u+2038 overline, which
	    ;; the unicode mapping tables show to be the jisx0201 character,
	    ;; #x7e.  Since this character code is below #x80, the acl
	    ;; process-code routines treat this as codeset 0.  Rather than
	    ;; worry about this special case, we disregard it.
	    (return-from process-code (code-char (- ucode #xfec0)))
       else (let ((cs1-code
		   (aref
		    (aref *unicode-to-jis-trie*
			  (logand #.(1- (expt 2 8))
				  (ash ucode -8)))
		    (logand #.(1- (expt 2 8)) ucode))))
	      (if* (zerop cs1-code)
		 then ;; codeset 3
		      #+no (error "Codeset 3 characters not supported")
		      (return-from process-code #\?)
		 else ;; codeset 1
		      (return-from process-code
			(code-char (+ cs1-code #x8080))))))))

(defun string-to-euc (string &key (null-terminate t))
  (string-to-octets string :null-terminate null-terminate :external-format :euc))

(defun euc-to-string (eucvector &key (drop-last-null t))
  (octets-to-string eucvector :end (if* drop-last-null
				      then (position 0 eucvector)
				      else (length eucvector))
		    :external-format :euc))

