;; This is an automatically generated file.  Make changes in
;; the definition file, not here.

(defpackage :swig.opengl
  (:use :common-lisp :ff :excl)
  (:export #:*swig-identifier-converter* #:*swig-module-name*
           #:*void* #:*swig-expoert-list*))
(in-package :swig.opengl)

(eval-when (compile load eval)
  (defparameter *swig-identifier-converter* 'identifier-convert-null)
  (defparameter *swig-module-name* :opengl))

(defpackage :opengl
  (:use :common-lisp :swig.opengl :ff :excl))


;; $Id: opengl.cl,v 1.2 2007/05/04 18:12:29 mikel Exp $

(eval-when (compile load eval)

;;; You can define your own identifier converter if you want.
;;; Use the -identifier-converter command line argument to
;;; specify its name.

(eval-when (:compile-toplevel :load-toplevel :execute)
   (cl::defparameter *swig-export-list* nil))

(cl::defconstant *void* :..void..)

;; parsers to aid in finding SWIG definitions in files.
(cl::defun scm-p1 (form)
  (let* ((info (cl::second form))
	 (id (car info))
	 (id-args (if (eq (cl::car form) 'swig-dispatcher)
		      (cl::cdr info)
		      (cl::cddr info))))
    (cl::apply *swig-identifier-converter* id 
	   (cl::progn (cl::when (cl::eq (cl::car form) 'swig-dispatcher)
		    (cl::remf id-args :arities))
		  id-args))))

(cl::defmacro defswig1 (name (&rest args) &body body)
  `(cl::progn (cl::defmacro ,name ,args
	    ,@body)
	  (excl::define-simple-parser ,name scm-p1)) )

(cl::defmacro defswig2 (name (&rest args) &body body)
  `(cl::progn (cl::defmacro ,name ,args
	    ,@body)
	  (excl::define-simple-parser ,name second)))

(defun read-symbol-from-string (string)
  (cl::multiple-value-bind (result position)
      (cl::read-from-string string nil "eof" :preserve-whitespace t)
    (cl::if (cl::and (cl::symbolp result)
    	             (cl::eql position (cl::length string)))
        result
	(cl::multiple-value-bind (sym)
	    (cl::intern string)
	  sym))))

(cl::defun full-name (id type arity class)
  (cl::case type
    (:getter (cl::format nil "~@[~A_~]~A" class id))
    (:constructor (cl::format nil "new_~A~@[~A~]" id arity))
    (:destructor (cl::format nil "delete_~A" id))
    (:type (cl::format nil "ff_~A" id))
    (:slot id)
    (:ff-operator (cl::format nil "ffi_~A" id))
    (otherwise (cl::format nil "~@[~A_~]~A~@[~A~]"
                       class id arity))))
  
(cl::defun identifier-convert-null (id &key type class arity)
  (cl::if (cl::eq type :setter)
      `(cl::setf ,(identifier-convert-null
               id :type :getter :class class :arity arity))
      (read-symbol-from-string (full-name id type arity class))))

(cl::defun identifier-convert-lispify (cname &key type class arity)
  (cl::assert (cl::stringp cname))
  (cl::when (cl::eq type :setter)
    (cl::return-from identifier-convert-lispify
      `(cl::setf ,(identifier-convert-lispify
               cname :type :getter :class class :arity arity))))
  (cl::setq cname (full-name cname type arity class))
  (cl::if (cl::eq type :constant)
      (cl::setf cname (cl::format nil "*~A*" cname)))
  (cl::setf cname (excl::replace-regexp cname "_" "-"))
  (cl::let ((lastcase :other)
       	    newcase char res)
    (cl::dotimes (n (cl::length cname))
      (cl::setf char (cl::schar cname n))
      (excl::if* (cl::alpha-char-p char)
         then
              (cl::setf newcase (cl::if (cl::upper-case-p char) :upper :lower))

              (cl::when (cl::or (cl::and (cl::eq lastcase :upper)
	      				 (cl::eq newcase :lower))
                                (cl::and (cl::eq lastcase :lower)
					 (cl::eq newcase :upper)))
                ;; case change... add a dash
                (cl::push #\- res)
                (cl::setf newcase :other))

              (cl::push (cl::char-downcase char) res)

              (cl::setf lastcase newcase)

         else
              (cl::push char res)
              (cl::setf lastcase :other)))
    (read-symbol-from-string (cl::coerce (cl::nreverse res) 'string))))

(cl::defun id-convert-and-export (name &rest kwargs)
  (cl::multiple-value-bind (symbol package)
      (cl::apply *swig-identifier-converter* name kwargs)
    (cl::let ((args (cl::list (cl::if (cl::consp symbol)
    	     	    	         (cl::cadr symbol) symbol)
                      (cl::or package cl::*package*))))
      (cl::apply #'cl::export args)
      (cl::pushnew args *swig-export-list*))
    symbol))

(cl::defmacro swig-insert-id (name namespace &key (type :type) class)
  `(cl::let ((cl::*package* (cl::find-package ,(package-name-for-namespace namespace))))
    (id-convert-and-export ,name :type ,type :class ,class)))

(defswig2 swig-defconstant (string value)
  (cl::let ((symbol (id-convert-and-export string :type :constant)))
    `(cl::eval-when (compile load eval)
       (cl::defconstant ,symbol ,value))))

(cl::defun maybe-reorder-args (funcname arglist)
  ;; in the foreign setter function the new value will be the last argument
  ;; in Lisp it needs to be the first
  (cl::if (cl::consp funcname)
      (cl::append (cl::last arglist) (cl::butlast arglist))
      arglist))

(cl::defun maybe-return-value (funcname arglist)
  ;; setf functions should return the new value
  (cl::when (cl::consp funcname)
    `(,(cl::if (cl::consp (cl::car arglist))
           (cl::caar arglist)
           (cl::car arglist)))))

(cl::defun swig-anyvarargs-p (arglist)
  (cl::member :SWIG__varargs_ arglist))

(defswig1 swig-defun ((name &optional (mangled-name name)
                            &key (type :operator) class arity)
                      arglist kwargs
		      &body body)
  (cl::let* ((symbol (id-convert-and-export name :type type
                          :arity arity :class class))
             (mangle (excl::if* (cl::string-equal name mangled-name)
                      then (id-convert-and-export 
				    (cl::cond
					  ((cl::eq type :setter) (cl::format nil "~A-set" name))
					  ((cl::eq type :getter) (cl::format nil "~A-get" name))
					  (t name))
				    :type :ff-operator :arity arity :class class)
                      else (cl::intern mangled-name)))
         (defun-args (maybe-reorder-args
                      symbol
		      (cl::mapcar #'cl::car (cl::and (cl::not (cl::equal arglist '(:void)))
					 (cl::loop as i in arglist
					       when (cl::eq (cl::car i) :p+)
					       collect (cl::cdr i))))))
	 (ffargs (cl::if (cl::equal arglist '(:void))
	 	      arglist
		    (cl::mapcar #'cl::cdr arglist)))
	 )
    (cl::when (swig-anyvarargs-p ffargs)
      (cl::setq ffargs '()))
    `(cl::eval-when (compile load eval)
       (excl::compiler-let ((*record-xref-info* nil))
         (ff:def-foreign-call (,mangle ,mangled-name) ,ffargs ,@kwargs))
       (cl::macrolet ((swig-ff-call (&rest args)
                      (cl::cons ',mangle args)))
         (cl::defun ,symbol ,defun-args
           ,@body
           ,@(maybe-return-value symbol defun-args))))))

(defswig1 swig-defmethod ((name &optional (mangled-name name)
	  	                &key (type :operator) class arity)
                          ffargs kwargs
                          &body body)
  (cl::let* ((symbol (id-convert-and-export name :type type
                          :arity arity :class class))
         (mangle (cl::intern mangled-name))
         (defmethod-args (maybe-reorder-args
                          symbol
                          (cl::unless (cl::equal ffargs '(:void))
                            (cl::loop for (lisparg name dispatch) in ffargs
			    	  when (eq lisparg :p+)
                                  collect `(,name ,dispatch)))))
         (ffargs (cl::if (cl::equal ffargs '(:void))
                     ffargs
                     (cl::loop for (nil name nil . ffi) in ffargs
                           collect `(,name ,@ffi)))))
    `(cl::eval-when (compile load eval)
       (excl::compiler-let ((*record-xref-info* nil))
         (ff:def-foreign-call (,mangle ,mangled-name) ,ffargs ,@kwargs))
       (cl::macrolet ((swig-ff-call (&rest args)
                      (cl::cons ',mangle args)))
         (cl::defmethod ,symbol ,defmethod-args
           ,@body
           ,@(maybe-return-value symbol defmethod-args))))))

(defswig1 swig-dispatcher ((name &key (type :operator) class arities))
  (cl::let ((symbol (id-convert-and-export name
                         :type type :class class)))
    `(cl::eval-when (compile load eval)
       (cl::defun ,symbol (&rest args)
         (cl::case (cl::length args)
           ,@(cl::loop for arity in arities
                   for symbol-n = (id-convert-and-export name
                                           :type type :class class :arity arity)
                   collect `(,arity (cl::apply #',symbol-n args)))
	   (t (cl::error "No applicable wrapper-methods for foreign call ~a with args ~a of classes ~a" ',symbol args (cl::mapcar #'(cl::lambda (x) (cl::class-name (cl::class-of x))) args)))
	   )))))

(defswig2 swig-def-foreign-stub (name)
  (cl::let ((lsymbol (id-convert-and-export name :type :class))
	    (symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (compile load eval)
	(ff:def-foreign-type ,symbol (:class ))
	(cl::defclass ,lsymbol (ff:foreign-pointer) ()))))

(defswig2 swig-def-foreign-class (name supers &rest rest)
  (cl::let ((lsymbol (id-convert-and-export name :type :class))
	    (symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (compile load eval)
       (ff:def-foreign-type ,symbol ,@rest)
       (cl::defclass ,lsymbol ,supers
	 ((foreign-type :initform ',symbol :initarg :foreign-type
			:accessor foreign-pointer-type))))))

(defswig2 swig-def-foreign-type (name &rest rest)
  (cl::let ((symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (compile load eval)
       (ff:def-foreign-type ,symbol ,@rest))))

(defswig2 swig-def-synonym-type (synonym of ff-synonym)
  `(cl::eval-when (compile load eval)
     (cl::setf (cl::find-class ',synonym) (cl::find-class ',of))
     (ff:def-foreign-type ,ff-synonym (:struct ))))

(cl::defun package-name-for-namespace (namespace)
  (excl::list-to-delimited-string
   (cl::cons *swig-module-name*
         (cl::mapcar #'(cl::lambda (name)
                     (cl::string
                      (cl::funcall *swig-identifier-converter*
                               name
                               :type :namespace)))
                 namespace))
   "."))

(cl::defmacro swig-defpackage (namespace)
  (cl::let* ((parent-namespaces (cl::maplist #'cl::reverse (cl::cdr (cl::reverse namespace))))
             (parent-strings (cl::mapcar #'package-name-for-namespace
                                 parent-namespaces))
             (string (package-name-for-namespace namespace)))
    `(cl::eval-when (compile load eval)
      (cl::defpackage ,string
        (:use :swig :ff #+ignore '(:common-lisp :ff :excl)
              ,@parent-strings ,*swig-module-name*)
	(:import-from :cl :* :nil :t)))))

(cl::defmacro swig-in-package (namespace)
  `(cl::eval-when (compile load eval)
    (cl::in-package ,(package-name-for-namespace namespace))))

(defswig2 swig-defvar (name mangled-name &key type)
  (cl::let ((symbol (id-convert-and-export name :type type)))
    `(cl::eval-when (compile load eval)
      (ff:def-foreign-variable (,symbol ,mangled-name)))))

) ;; eval-when

(cl::eval-when (compile eval)
  (cl::flet ((starts-with-p (str prefix)
              (cl::and (cl::>= (cl::length str) (cl::length prefix))
                (cl::string= str prefix :end1 (cl::length prefix)))))
    (cl::export (cl::loop for sym being each present-symbol of cl::*package*
                  when (cl::or (starts-with-p (cl::symbol-name sym) (cl::symbol-name :swig-))
                           (starts-with-p (cl::symbol-name sym) (cl::symbol-name :identifier-convert-)))
                  collect sym))))



#+linux
(progn
  (load "libGL.so")
  (load "libGLU.so")
  (load "libXi.so")
  (load "libXmu.so"))
#+mswindows
(progn
  (load "opengl32.dll")
  (load "glu32.dll"))
#+macosx
(progn
  (load "/System/Library/Frameworks/OpenGL.framework/OpenGL" :foreign t)
  (load "/System/Library/Frameworks/GLUT.framework/GLUT" :foreign t)
 )


(in-package :opengl)
(swig-def-foreign-type "GLenum"
  :unsigned-long)
(swig-def-foreign-type "GLboolean"
  :unsigned-char)
(swig-def-foreign-type "GLbitfield"
  :unsigned-long)
(swig-def-foreign-type "GLbyte"
  :char)
(swig-def-foreign-type "GLshort"
  :short)
(swig-def-foreign-type "GLint"
  :long)
(swig-def-foreign-type "GLsizei"
  :long)
(swig-def-foreign-type "GLubyte"
  :unsigned-char)
(swig-def-foreign-type "GLushort"
  :unsigned-short)
(swig-def-foreign-type "GLuint"
  :unsigned-long)
(swig-def-foreign-type "GLfloat"
  :float)
(swig-def-foreign-type "GLclampf"
  :float)
(swig-def-foreign-type "GLdouble"
  :double)
(swig-def-foreign-type "GLclampd"
  :double)
(swig-def-foreign-type "GLvoid"
  :void)
(swig-def-foreign-type "GLintptr"
  :long)
(swig-def-foreign-type "GLsizeiptr"
  :long)
(swig-def-foreign-type "GLchar"
  :char)
(swig-def-foreign-type "GLUnurbs"
  (* :void))
(swig-def-foreign-type "GLUquadric"
  (* :void))
(swig-def-foreign-type "GLUtesselator"
  (* :void))
(swig-def-foreign-type "GLUnurbsObj"
  (* :void))
(swig-def-foreign-type "GLUquadricObj"
  (* :void))
(swig-def-foreign-type "GLUtesselatorObj"
  (* :void))
(swig-def-foreign-type "GLUtriangulatorObj"
  (* :void))

(swig-in-package ())

(swig-defconstant "GL_VERSION_1_1" 1)
(swig-defconstant "GL_VERSION_1_2" 1)
(swig-defconstant "GL_VERSION_1_3" 1)
(swig-defconstant "GL_VERSION_1_4" 1)
(swig-defconstant "GL_VERSION_1_5" 1)
(swig-defconstant "GL_VERSION_2_0" 1)
(swig-defconstant "GL_ACCUM" #x0100)
(swig-defconstant "GL_LOAD" #x0101)
(swig-defconstant "GL_RETURN" #x0102)
(swig-defconstant "GL_MULT" #x0103)
(swig-defconstant "GL_ADD" #x0104)
(swig-defconstant "GL_NEVER" #x0200)
(swig-defconstant "GL_LESS" #x0201)
(swig-defconstant "GL_EQUAL" #x0202)
(swig-defconstant "GL_LEQUAL" #x0203)
(swig-defconstant "GL_GREATER" #x0204)
(swig-defconstant "GL_NOTEQUAL" #x0205)
(swig-defconstant "GL_GEQUAL" #x0206)
(swig-defconstant "GL_ALWAYS" #x0207)
(swig-defconstant "GL_CURRENT_BIT" #x00000001)
(swig-defconstant "GL_POINT_BIT" #x00000002)
(swig-defconstant "GL_LINE_BIT" #x00000004)
(swig-defconstant "GL_POLYGON_BIT" #x00000008)
(swig-defconstant "GL_POLYGON_STIPPLE_BIT" #x00000010)
(swig-defconstant "GL_PIXEL_MODE_BIT" #x00000020)
(swig-defconstant "GL_LIGHTING_BIT" #x00000040)
(swig-defconstant "GL_FOG_BIT" #x00000080)
(swig-defconstant "GL_DEPTH_BUFFER_BIT" #x00000100)
(swig-defconstant "GL_ACCUM_BUFFER_BIT" #x00000200)
(swig-defconstant "GL_STENCIL_BUFFER_BIT" #x00000400)
(swig-defconstant "GL_VIEWPORT_BIT" #x00000800)
(swig-defconstant "GL_TRANSFORM_BIT" #x00001000)
(swig-defconstant "GL_ENABLE_BIT" #x00002000)
(swig-defconstant "GL_COLOR_BUFFER_BIT" #x00004000)
(swig-defconstant "GL_HINT_BIT" #x00008000)
(swig-defconstant "GL_EVAL_BIT" #x00010000)
(swig-defconstant "GL_LIST_BIT" #x00020000)
(swig-defconstant "GL_TEXTURE_BIT" #x00040000)
(swig-defconstant "GL_SCISSOR_BIT" #x00080000)
(swig-defconstant "GL_ALL_ATTRIB_BITS" #x000fffff)
(swig-defconstant "GL_POINTS" #x0000)
(swig-defconstant "GL_LINES" #x0001)
(swig-defconstant "GL_LINE_LOOP" #x0002)
(swig-defconstant "GL_LINE_STRIP" #x0003)
(swig-defconstant "GL_TRIANGLES" #x0004)
(swig-defconstant "GL_TRIANGLE_STRIP" #x0005)
(swig-defconstant "GL_TRIANGLE_FAN" #x0006)
(swig-defconstant "GL_QUADS" #x0007)
(swig-defconstant "GL_QUAD_STRIP" #x0008)
(swig-defconstant "GL_POLYGON" #x0009)
(swig-defconstant "GL_ZERO" 0)
(swig-defconstant "GL_ONE" 1)
(swig-defconstant "GL_SRC_COLOR" #x0300)
(swig-defconstant "GL_ONE_MINUS_SRC_COLOR" #x0301)
(swig-defconstant "GL_SRC_ALPHA" #x0302)
(swig-defconstant "GL_ONE_MINUS_SRC_ALPHA" #x0303)
(swig-defconstant "GL_DST_ALPHA" #x0304)
(swig-defconstant "GL_ONE_MINUS_DST_ALPHA" #x0305)
(swig-defconstant "GL_DST_COLOR" #x0306)
(swig-defconstant "GL_ONE_MINUS_DST_COLOR" #x0307)
(swig-defconstant "GL_SRC_ALPHA_SATURATE" #x0308)
(swig-defconstant "GL_TRUE" 1)
(swig-defconstant "GL_FALSE" 0)
(swig-defconstant "GL_CLIP_PLANE0" #x3000)
(swig-defconstant "GL_CLIP_PLANE1" #x3001)
(swig-defconstant "GL_CLIP_PLANE2" #x3002)
(swig-defconstant "GL_CLIP_PLANE3" #x3003)
(swig-defconstant "GL_CLIP_PLANE4" #x3004)
(swig-defconstant "GL_CLIP_PLANE5" #x3005)
(swig-defconstant "GL_BYTE" #x1400)
(swig-defconstant "GL_UNSIGNED_BYTE" #x1401)
(swig-defconstant "GL_SHORT" #x1402)
(swig-defconstant "GL_UNSIGNED_SHORT" #x1403)
(swig-defconstant "GL_INT" #x1404)
(swig-defconstant "GL_UNSIGNED_INT" #x1405)
(swig-defconstant "GL_FLOAT" #x1406)
(swig-defconstant "GL_2_BYTES" #x1407)
(swig-defconstant "GL_3_BYTES" #x1408)
(swig-defconstant "GL_4_BYTES" #x1409)
(swig-defconstant "GL_DOUBLE" #x140A)
(swig-defconstant "GL_NONE" 0)
(swig-defconstant "GL_FRONT_LEFT" #x0400)
(swig-defconstant "GL_FRONT_RIGHT" #x0401)
(swig-defconstant "GL_BACK_LEFT" #x0402)
(swig-defconstant "GL_BACK_RIGHT" #x0403)
(swig-defconstant "GL_FRONT" #x0404)
(swig-defconstant "GL_BACK" #x0405)
(swig-defconstant "GL_LEFT" #x0406)
(swig-defconstant "GL_RIGHT" #x0407)
(swig-defconstant "GL_FRONT_AND_BACK" #x0408)
(swig-defconstant "GL_AUX0" #x0409)
(swig-defconstant "GL_AUX1" #x040A)
(swig-defconstant "GL_AUX2" #x040B)
(swig-defconstant "GL_AUX3" #x040C)
(swig-defconstant "GL_NO_ERROR" 0)
(swig-defconstant "GL_INVALID_ENUM" #x0500)
(swig-defconstant "GL_INVALID_VALUE" #x0501)
(swig-defconstant "GL_INVALID_OPERATION" #x0502)
(swig-defconstant "GL_STACK_OVERFLOW" #x0503)
(swig-defconstant "GL_STACK_UNDERFLOW" #x0504)
(swig-defconstant "GL_OUT_OF_MEMORY" #x0505)
(swig-defconstant "GL_2D" #x0600)
(swig-defconstant "GL_3D" #x0601)
(swig-defconstant "GL_3D_COLOR" #x0602)
(swig-defconstant "GL_3D_COLOR_TEXTURE" #x0603)
(swig-defconstant "GL_4D_COLOR_TEXTURE" #x0604)
(swig-defconstant "GL_PASS_THROUGH_TOKEN" #x0700)
(swig-defconstant "GL_POINT_TOKEN" #x0701)
(swig-defconstant "GL_LINE_TOKEN" #x0702)
(swig-defconstant "GL_POLYGON_TOKEN" #x0703)
(swig-defconstant "GL_BITMAP_TOKEN" #x0704)
(swig-defconstant "GL_DRAW_PIXEL_TOKEN" #x0705)
(swig-defconstant "GL_COPY_PIXEL_TOKEN" #x0706)
(swig-defconstant "GL_LINE_RESET_TOKEN" #x0707)
(swig-defconstant "GL_EXP" #x0800)
(swig-defconstant "GL_EXP2" #x0801)
(swig-defconstant "GL_CW" #x0900)
(swig-defconstant "GL_CCW" #x0901)
(swig-defconstant "GL_COEFF" #x0A00)
(swig-defconstant "GL_ORDER" #x0A01)
(swig-defconstant "GL_DOMAIN" #x0A02)
(swig-defconstant "GL_CURRENT_COLOR" #x0B00)
(swig-defconstant "GL_CURRENT_INDEX" #x0B01)
(swig-defconstant "GL_CURRENT_NORMAL" #x0B02)
(swig-defconstant "GL_CURRENT_TEXTURE_COORDS" #x0B03)
(swig-defconstant "GL_CURRENT_RASTER_COLOR" #x0B04)
(swig-defconstant "GL_CURRENT_RASTER_INDEX" #x0B05)
(swig-defconstant "GL_CURRENT_RASTER_TEXTURE_COORDS" #x0B06)
(swig-defconstant "GL_CURRENT_RASTER_POSITION" #x0B07)
(swig-defconstant "GL_CURRENT_RASTER_POSITION_VALID" #x0B08)
(swig-defconstant "GL_CURRENT_RASTER_DISTANCE" #x0B09)
(swig-defconstant "GL_POINT_SMOOTH" #x0B10)
(swig-defconstant "GL_POINT_SIZE" #x0B11)
(swig-defconstant "GL_POINT_SIZE_RANGE" #x0B12)
(swig-defconstant "GL_POINT_SIZE_GRANULARITY" #x0B13)
(swig-defconstant "GL_LINE_SMOOTH" #x0B20)
(swig-defconstant "GL_LINE_WIDTH" #x0B21)
(swig-defconstant "GL_LINE_WIDTH_RANGE" #x0B22)
(swig-defconstant "GL_LINE_WIDTH_GRANULARITY" #x0B23)
(swig-defconstant "GL_LINE_STIPPLE" #x0B24)
(swig-defconstant "GL_LINE_STIPPLE_PATTERN" #x0B25)
(swig-defconstant "GL_LINE_STIPPLE_REPEAT" #x0B26)
(swig-defconstant "GL_LIST_MODE" #x0B30)
(swig-defconstant "GL_MAX_LIST_NESTING" #x0B31)
(swig-defconstant "GL_LIST_BASE" #x0B32)
(swig-defconstant "GL_LIST_INDEX" #x0B33)
(swig-defconstant "GL_POLYGON_MODE" #x0B40)
(swig-defconstant "GL_POLYGON_SMOOTH" #x0B41)
(swig-defconstant "GL_POLYGON_STIPPLE" #x0B42)
(swig-defconstant "GL_EDGE_FLAG" #x0B43)
(swig-defconstant "GL_CULL_FACE" #x0B44)
(swig-defconstant "GL_CULL_FACE_MODE" #x0B45)
(swig-defconstant "GL_FRONT_FACE" #x0B46)
(swig-defconstant "GL_LIGHTING" #x0B50)
(swig-defconstant "GL_LIGHT_MODEL_LOCAL_VIEWER" #x0B51)
(swig-defconstant "GL_LIGHT_MODEL_TWO_SIDE" #x0B52)
(swig-defconstant "GL_LIGHT_MODEL_AMBIENT" #x0B53)
(swig-defconstant "GL_SHADE_MODEL" #x0B54)
(swig-defconstant "GL_COLOR_MATERIAL_FACE" #x0B55)
(swig-defconstant "GL_COLOR_MATERIAL_PARAMETER" #x0B56)
(swig-defconstant "GL_COLOR_MATERIAL" #x0B57)
(swig-defconstant "GL_FOG" #x0B60)
(swig-defconstant "GL_FOG_INDEX" #x0B61)
(swig-defconstant "GL_FOG_DENSITY" #x0B62)
(swig-defconstant "GL_FOG_START" #x0B63)
(swig-defconstant "GL_FOG_END" #x0B64)
(swig-defconstant "GL_FOG_MODE" #x0B65)
(swig-defconstant "GL_FOG_COLOR" #x0B66)
(swig-defconstant "GL_DEPTH_RANGE" #x0B70)
(swig-defconstant "GL_DEPTH_TEST" #x0B71)
(swig-defconstant "GL_DEPTH_WRITEMASK" #x0B72)
(swig-defconstant "GL_DEPTH_CLEAR_VALUE" #x0B73)
(swig-defconstant "GL_DEPTH_FUNC" #x0B74)
(swig-defconstant "GL_ACCUM_CLEAR_VALUE" #x0B80)
(swig-defconstant "GL_STENCIL_TEST" #x0B90)
(swig-defconstant "GL_STENCIL_CLEAR_VALUE" #x0B91)
(swig-defconstant "GL_STENCIL_FUNC" #x0B92)
(swig-defconstant "GL_STENCIL_VALUE_MASK" #x0B93)
(swig-defconstant "GL_STENCIL_FAIL" #x0B94)
(swig-defconstant "GL_STENCIL_PASS_DEPTH_FAIL" #x0B95)
(swig-defconstant "GL_STENCIL_PASS_DEPTH_PASS" #x0B96)
(swig-defconstant "GL_STENCIL_REF" #x0B97)
(swig-defconstant "GL_STENCIL_WRITEMASK" #x0B98)
(swig-defconstant "GL_MATRIX_MODE" #x0BA0)
(swig-defconstant "GL_NORMALIZE" #x0BA1)
(swig-defconstant "GL_VIEWPORT" #x0BA2)
(swig-defconstant "GL_MODELVIEW_STACK_DEPTH" #x0BA3)
(swig-defconstant "GL_PROJECTION_STACK_DEPTH" #x0BA4)
(swig-defconstant "GL_TEXTURE_STACK_DEPTH" #x0BA5)
(swig-defconstant "GL_MODELVIEW_MATRIX" #x0BA6)
(swig-defconstant "GL_PROJECTION_MATRIX" #x0BA7)
(swig-defconstant "GL_TEXTURE_MATRIX" #x0BA8)
(swig-defconstant "GL_ATTRIB_STACK_DEPTH" #x0BB0)
(swig-defconstant "GL_CLIENT_ATTRIB_STACK_DEPTH" #x0BB1)
(swig-defconstant "GL_ALPHA_TEST" #x0BC0)
(swig-defconstant "GL_ALPHA_TEST_FUNC" #x0BC1)
(swig-defconstant "GL_ALPHA_TEST_REF" #x0BC2)
(swig-defconstant "GL_DITHER" #x0BD0)
(swig-defconstant "GL_BLEND_DST" #x0BE0)
(swig-defconstant "GL_BLEND_SRC" #x0BE1)
(swig-defconstant "GL_BLEND" #x0BE2)
(swig-defconstant "GL_LOGIC_OP_MODE" #x0BF0)
(swig-defconstant "GL_INDEX_LOGIC_OP" #x0BF1)
(swig-defconstant "GL_COLOR_LOGIC_OP" #x0BF2)
(swig-defconstant "GL_AUX_BUFFERS" #x0C00)
(swig-defconstant "GL_DRAW_BUFFER" #x0C01)
(swig-defconstant "GL_READ_BUFFER" #x0C02)
(swig-defconstant "GL_SCISSOR_BOX" #x0C10)
(swig-defconstant "GL_SCISSOR_TEST" #x0C11)
(swig-defconstant "GL_INDEX_CLEAR_VALUE" #x0C20)
(swig-defconstant "GL_INDEX_WRITEMASK" #x0C21)
(swig-defconstant "GL_COLOR_CLEAR_VALUE" #x0C22)
(swig-defconstant "GL_COLOR_WRITEMASK" #x0C23)
(swig-defconstant "GL_INDEX_MODE" #x0C30)
(swig-defconstant "GL_RGBA_MODE" #x0C31)
(swig-defconstant "GL_DOUBLEBUFFER" #x0C32)
(swig-defconstant "GL_STEREO" #x0C33)
(swig-defconstant "GL_RENDER_MODE" #x0C40)
(swig-defconstant "GL_PERSPECTIVE_CORRECTION_HINT" #x0C50)
(swig-defconstant "GL_POINT_SMOOTH_HINT" #x0C51)
(swig-defconstant "GL_LINE_SMOOTH_HINT" #x0C52)
(swig-defconstant "GL_POLYGON_SMOOTH_HINT" #x0C53)
(swig-defconstant "GL_FOG_HINT" #x0C54)
(swig-defconstant "GL_TEXTURE_GEN_S" #x0C60)
(swig-defconstant "GL_TEXTURE_GEN_T" #x0C61)
(swig-defconstant "GL_TEXTURE_GEN_R" #x0C62)
(swig-defconstant "GL_TEXTURE_GEN_Q" #x0C63)
(swig-defconstant "GL_PIXEL_MAP_I_TO_I" #x0C70)
(swig-defconstant "GL_PIXEL_MAP_S_TO_S" #x0C71)
(swig-defconstant "GL_PIXEL_MAP_I_TO_R" #x0C72)
(swig-defconstant "GL_PIXEL_MAP_I_TO_G" #x0C73)
(swig-defconstant "GL_PIXEL_MAP_I_TO_B" #x0C74)
(swig-defconstant "GL_PIXEL_MAP_I_TO_A" #x0C75)
(swig-defconstant "GL_PIXEL_MAP_R_TO_R" #x0C76)
(swig-defconstant "GL_PIXEL_MAP_G_TO_G" #x0C77)
(swig-defconstant "GL_PIXEL_MAP_B_TO_B" #x0C78)
(swig-defconstant "GL_PIXEL_MAP_A_TO_A" #x0C79)
(swig-defconstant "GL_PIXEL_MAP_I_TO_I_SIZE" #x0CB0)
(swig-defconstant "GL_PIXEL_MAP_S_TO_S_SIZE" #x0CB1)
(swig-defconstant "GL_PIXEL_MAP_I_TO_R_SIZE" #x0CB2)
(swig-defconstant "GL_PIXEL_MAP_I_TO_G_SIZE" #x0CB3)
(swig-defconstant "GL_PIXEL_MAP_I_TO_B_SIZE" #x0CB4)
(swig-defconstant "GL_PIXEL_MAP_I_TO_A_SIZE" #x0CB5)
(swig-defconstant "GL_PIXEL_MAP_R_TO_R_SIZE" #x0CB6)
(swig-defconstant "GL_PIXEL_MAP_G_TO_G_SIZE" #x0CB7)
(swig-defconstant "GL_PIXEL_MAP_B_TO_B_SIZE" #x0CB8)
(swig-defconstant "GL_PIXEL_MAP_A_TO_A_SIZE" #x0CB9)
(swig-defconstant "GL_UNPACK_SWAP_BYTES" #x0CF0)
(swig-defconstant "GL_UNPACK_LSB_FIRST" #x0CF1)
(swig-defconstant "GL_UNPACK_ROW_LENGTH" #x0CF2)
(swig-defconstant "GL_UNPACK_SKIP_ROWS" #x0CF3)
(swig-defconstant "GL_UNPACK_SKIP_PIXELS" #x0CF4)
(swig-defconstant "GL_UNPACK_ALIGNMENT" #x0CF5)
(swig-defconstant "GL_PACK_SWAP_BYTES" #x0D00)
(swig-defconstant "GL_PACK_LSB_FIRST" #x0D01)
(swig-defconstant "GL_PACK_ROW_LENGTH" #x0D02)
(swig-defconstant "GL_PACK_SKIP_ROWS" #x0D03)
(swig-defconstant "GL_PACK_SKIP_PIXELS" #x0D04)
(swig-defconstant "GL_PACK_ALIGNMENT" #x0D05)
(swig-defconstant "GL_MAP_COLOR" #x0D10)
(swig-defconstant "GL_MAP_STENCIL" #x0D11)
(swig-defconstant "GL_INDEX_SHIFT" #x0D12)
(swig-defconstant "GL_INDEX_OFFSET" #x0D13)
(swig-defconstant "GL_RED_SCALE" #x0D14)
(swig-defconstant "GL_RED_BIAS" #x0D15)
(swig-defconstant "GL_ZOOM_X" #x0D16)
(swig-defconstant "GL_ZOOM_Y" #x0D17)
(swig-defconstant "GL_GREEN_SCALE" #x0D18)
(swig-defconstant "GL_GREEN_BIAS" #x0D19)
(swig-defconstant "GL_BLUE_SCALE" #x0D1A)
(swig-defconstant "GL_BLUE_BIAS" #x0D1B)
(swig-defconstant "GL_ALPHA_SCALE" #x0D1C)
(swig-defconstant "GL_ALPHA_BIAS" #x0D1D)
(swig-defconstant "GL_DEPTH_SCALE" #x0D1E)
(swig-defconstant "GL_DEPTH_BIAS" #x0D1F)
(swig-defconstant "GL_MAX_EVAL_ORDER" #x0D30)
(swig-defconstant "GL_MAX_LIGHTS" #x0D31)
(swig-defconstant "GL_MAX_CLIP_PLANES" #x0D32)
(swig-defconstant "GL_MAX_TEXTURE_SIZE" #x0D33)
(swig-defconstant "GL_MAX_PIXEL_MAP_TABLE" #x0D34)
(swig-defconstant "GL_MAX_ATTRIB_STACK_DEPTH" #x0D35)
(swig-defconstant "GL_MAX_MODELVIEW_STACK_DEPTH" #x0D36)
(swig-defconstant "GL_MAX_NAME_STACK_DEPTH" #x0D37)
(swig-defconstant "GL_MAX_PROJECTION_STACK_DEPTH" #x0D38)
(swig-defconstant "GL_MAX_TEXTURE_STACK_DEPTH" #x0D39)
(swig-defconstant "GL_MAX_VIEWPORT_DIMS" #x0D3A)
(swig-defconstant "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH" #x0D3B)
(swig-defconstant "GL_SUBPIXEL_BITS" #x0D50)
(swig-defconstant "GL_INDEX_BITS" #x0D51)
(swig-defconstant "GL_RED_BITS" #x0D52)
(swig-defconstant "GL_GREEN_BITS" #x0D53)
(swig-defconstant "GL_BLUE_BITS" #x0D54)
(swig-defconstant "GL_ALPHA_BITS" #x0D55)
(swig-defconstant "GL_DEPTH_BITS" #x0D56)
(swig-defconstant "GL_STENCIL_BITS" #x0D57)
(swig-defconstant "GL_ACCUM_RED_BITS" #x0D58)
(swig-defconstant "GL_ACCUM_GREEN_BITS" #x0D59)
(swig-defconstant "GL_ACCUM_BLUE_BITS" #x0D5A)
(swig-defconstant "GL_ACCUM_ALPHA_BITS" #x0D5B)
(swig-defconstant "GL_NAME_STACK_DEPTH" #x0D70)
(swig-defconstant "GL_AUTO_NORMAL" #x0D80)
(swig-defconstant "GL_MAP1_COLOR_4" #x0D90)
(swig-defconstant "GL_MAP1_INDEX" #x0D91)
(swig-defconstant "GL_MAP1_NORMAL" #x0D92)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_1" #x0D93)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_2" #x0D94)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_3" #x0D95)
(swig-defconstant "GL_MAP1_TEXTURE_COORD_4" #x0D96)
(swig-defconstant "GL_MAP1_VERTEX_3" #x0D97)
(swig-defconstant "GL_MAP1_VERTEX_4" #x0D98)
(swig-defconstant "GL_MAP2_COLOR_4" #x0DB0)
(swig-defconstant "GL_MAP2_INDEX" #x0DB1)
(swig-defconstant "GL_MAP2_NORMAL" #x0DB2)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_1" #x0DB3)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_2" #x0DB4)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_3" #x0DB5)
(swig-defconstant "GL_MAP2_TEXTURE_COORD_4" #x0DB6)
(swig-defconstant "GL_MAP2_VERTEX_3" #x0DB7)
(swig-defconstant "GL_MAP2_VERTEX_4" #x0DB8)
(swig-defconstant "GL_MAP1_GRID_DOMAIN" #x0DD0)
(swig-defconstant "GL_MAP1_GRID_SEGMENTS" #x0DD1)
(swig-defconstant "GL_MAP2_GRID_DOMAIN" #x0DD2)
(swig-defconstant "GL_MAP2_GRID_SEGMENTS" #x0DD3)
(swig-defconstant "GL_TEXTURE_1D" #x0DE0)
(swig-defconstant "GL_TEXTURE_2D" #x0DE1)
(swig-defconstant "GL_FEEDBACK_BUFFER_POINTER" #x0DF0)
(swig-defconstant "GL_FEEDBACK_BUFFER_SIZE" #x0DF1)
(swig-defconstant "GL_FEEDBACK_BUFFER_TYPE" #x0DF2)
(swig-defconstant "GL_SELECTION_BUFFER_POINTER" #x0DF3)
(swig-defconstant "GL_SELECTION_BUFFER_SIZE" #x0DF4)
(swig-defconstant "GL_TEXTURE_WIDTH" #x1000)
(swig-defconstant "GL_TEXTURE_HEIGHT" #x1001)
(swig-defconstant "GL_TEXTURE_INTERNAL_FORMAT" #x1003)
(swig-defconstant "GL_TEXTURE_BORDER_COLOR" #x1004)
(swig-defconstant "GL_TEXTURE_BORDER" #x1005)
(swig-defconstant "GL_DONT_CARE" #x1100)
(swig-defconstant "GL_FASTEST" #x1101)
(swig-defconstant "GL_NICEST" #x1102)
(swig-defconstant "GL_LIGHT0" #x4000)
(swig-defconstant "GL_LIGHT1" #x4001)
(swig-defconstant "GL_LIGHT2" #x4002)
(swig-defconstant "GL_LIGHT3" #x4003)
(swig-defconstant "GL_LIGHT4" #x4004)
(swig-defconstant "GL_LIGHT5" #x4005)
(swig-defconstant "GL_LIGHT6" #x4006)
(swig-defconstant "GL_LIGHT7" #x4007)
(swig-defconstant "GL_AMBIENT" #x1200)
(swig-defconstant "GL_DIFFUSE" #x1201)
(swig-defconstant "GL_SPECULAR" #x1202)
(swig-defconstant "GL_POSITION" #x1203)
(swig-defconstant "GL_SPOT_DIRECTION" #x1204)
(swig-defconstant "GL_SPOT_EXPONENT" #x1205)
(swig-defconstant "GL_SPOT_CUTOFF" #x1206)
(swig-defconstant "GL_CONSTANT_ATTENUATION" #x1207)
(swig-defconstant "GL_LINEAR_ATTENUATION" #x1208)
(swig-defconstant "GL_QUADRATIC_ATTENUATION" #x1209)
(swig-defconstant "GL_COMPILE" #x1300)
(swig-defconstant "GL_COMPILE_AND_EXECUTE" #x1301)
(swig-defconstant "GL_CLEAR" #x1500)
(swig-defconstant "GL_AND" #x1501)
(swig-defconstant "GL_AND_REVERSE" #x1502)
(swig-defconstant "GL_COPY" #x1503)
(swig-defconstant "GL_AND_INVERTED" #x1504)
(swig-defconstant "GL_NOOP" #x1505)
(swig-defconstant "GL_XOR" #x1506)
(swig-defconstant "GL_OR" #x1507)
(swig-defconstant "GL_NOR" #x1508)
(swig-defconstant "GL_EQUIV" #x1509)
(swig-defconstant "GL_INVERT" #x150A)
(swig-defconstant "GL_OR_REVERSE" #x150B)
(swig-defconstant "GL_COPY_INVERTED" #x150C)
(swig-defconstant "GL_OR_INVERTED" #x150D)
(swig-defconstant "GL_NAND" #x150E)
(swig-defconstant "GL_SET" #x150F)
(swig-defconstant "GL_EMISSION" #x1600)
(swig-defconstant "GL_SHININESS" #x1601)
(swig-defconstant "GL_AMBIENT_AND_DIFFUSE" #x1602)
(swig-defconstant "GL_COLOR_INDEXES" #x1603)
(swig-defconstant "GL_MODELVIEW" #x1700)
(swig-defconstant "GL_PROJECTION" #x1701)
(swig-defconstant "GL_TEXTURE" #x1702)
(swig-defconstant "GL_COLOR" #x1800)
(swig-defconstant "GL_DEPTH" #x1801)
(swig-defconstant "GL_STENCIL" #x1802)
(swig-defconstant "GL_COLOR_INDEX" #x1900)
(swig-defconstant "GL_STENCIL_INDEX" #x1901)
(swig-defconstant "GL_DEPTH_COMPONENT" #x1902)
(swig-defconstant "GL_RED" #x1903)
(swig-defconstant "GL_GREEN" #x1904)
(swig-defconstant "GL_BLUE" #x1905)
(swig-defconstant "GL_ALPHA" #x1906)
(swig-defconstant "GL_RGB" #x1907)
(swig-defconstant "GL_RGBA" #x1908)
(swig-defconstant "GL_LUMINANCE" #x1909)
(swig-defconstant "GL_LUMINANCE_ALPHA" #x190A)
(swig-defconstant "GL_BITMAP" #x1A00)
(swig-defconstant "GL_POINT" #x1B00)
(swig-defconstant "GL_LINE" #x1B01)
(swig-defconstant "GL_FILL" #x1B02)
(swig-defconstant "GL_RENDER" #x1C00)
(swig-defconstant "GL_FEEDBACK" #x1C01)
(swig-defconstant "GL_SELECT" #x1C02)
(swig-defconstant "GL_FLAT" #x1D00)
(swig-defconstant "GL_SMOOTH" #x1D01)
(swig-defconstant "GL_KEEP" #x1E00)
(swig-defconstant "GL_REPLACE" #x1E01)
(swig-defconstant "GL_INCR" #x1E02)
(swig-defconstant "GL_DECR" #x1E03)
(swig-defconstant "GL_VENDOR" #x1F00)
(swig-defconstant "GL_RENDERER" #x1F01)
(swig-defconstant "GL_VERSION" #x1F02)
(swig-defconstant "GL_EXTENSIONS" #x1F03)
(swig-defconstant "GL_S" #x2000)
(swig-defconstant "GL_T" #x2001)
(swig-defconstant "GL_R" #x2002)
(swig-defconstant "GL_Q" #x2003)
(swig-defconstant "GL_MODULATE" #x2100)
(swig-defconstant "GL_DECAL" #x2101)
(swig-defconstant "GL_TEXTURE_ENV_MODE" #x2200)
(swig-defconstant "GL_TEXTURE_ENV_COLOR" #x2201)
(swig-defconstant "GL_TEXTURE_ENV" #x2300)
(swig-defconstant "GL_EYE_LINEAR" #x2400)
(swig-defconstant "GL_OBJECT_LINEAR" #x2401)
(swig-defconstant "GL_SPHERE_MAP" #x2402)
(swig-defconstant "GL_TEXTURE_GEN_MODE" #x2500)
(swig-defconstant "GL_OBJECT_PLANE" #x2501)
(swig-defconstant "GL_EYE_PLANE" #x2502)
(swig-defconstant "GL_NEAREST" #x2600)
(swig-defconstant "GL_LINEAR" #x2601)
(swig-defconstant "GL_NEAREST_MIPMAP_NEAREST" #x2700)
(swig-defconstant "GL_LINEAR_MIPMAP_NEAREST" #x2701)
(swig-defconstant "GL_NEAREST_MIPMAP_LINEAR" #x2702)
(swig-defconstant "GL_LINEAR_MIPMAP_LINEAR" #x2703)
(swig-defconstant "GL_TEXTURE_MAG_FILTER" #x2800)
(swig-defconstant "GL_TEXTURE_MIN_FILTER" #x2801)
(swig-defconstant "GL_TEXTURE_WRAP_S" #x2802)
(swig-defconstant "GL_TEXTURE_WRAP_T" #x2803)
(swig-defconstant "GL_CLAMP" #x2900)
(swig-defconstant "GL_REPEAT" #x2901)
(swig-defconstant "GL_CLIENT_PIXEL_STORE_BIT" #x00000001)
(swig-defconstant "GL_CLIENT_VERTEX_ARRAY_BIT" #x00000002)
(swig-defconstant "GL_CLIENT_ALL_ATTRIB_BITS" #xffffffff)
(swig-defconstant "GL_POLYGON_OFFSET_FACTOR" #x8038)
(swig-defconstant "GL_POLYGON_OFFSET_UNITS" #x2A00)
(swig-defconstant "GL_POLYGON_OFFSET_POINT" #x2A01)
(swig-defconstant "GL_POLYGON_OFFSET_LINE" #x2A02)
(swig-defconstant "GL_POLYGON_OFFSET_FILL" #x8037)
(swig-defconstant "GL_ALPHA4" #x803B)
(swig-defconstant "GL_ALPHA8" #x803C)
(swig-defconstant "GL_ALPHA12" #x803D)
(swig-defconstant "GL_ALPHA16" #x803E)
(swig-defconstant "GL_LUMINANCE4" #x803F)
(swig-defconstant "GL_LUMINANCE8" #x8040)
(swig-defconstant "GL_LUMINANCE12" #x8041)
(swig-defconstant "GL_LUMINANCE16" #x8042)
(swig-defconstant "GL_LUMINANCE4_ALPHA4" #x8043)
(swig-defconstant "GL_LUMINANCE6_ALPHA2" #x8044)
(swig-defconstant "GL_LUMINANCE8_ALPHA8" #x8045)
(swig-defconstant "GL_LUMINANCE12_ALPHA4" #x8046)
(swig-defconstant "GL_LUMINANCE12_ALPHA12" #x8047)
(swig-defconstant "GL_LUMINANCE16_ALPHA16" #x8048)
(swig-defconstant "GL_INTENSITY" #x8049)
(swig-defconstant "GL_INTENSITY4" #x804A)
(swig-defconstant "GL_INTENSITY8" #x804B)
(swig-defconstant "GL_INTENSITY12" #x804C)
(swig-defconstant "GL_INTENSITY16" #x804D)
(swig-defconstant "GL_R3_G3_B2" #x2A10)
(swig-defconstant "GL_RGB4" #x804F)
(swig-defconstant "GL_RGB5" #x8050)
(swig-defconstant "GL_RGB8" #x8051)
(swig-defconstant "GL_RGB10" #x8052)
(swig-defconstant "GL_RGB12" #x8053)
(swig-defconstant "GL_RGB16" #x8054)
(swig-defconstant "GL_RGBA2" #x8055)
(swig-defconstant "GL_RGBA4" #x8056)
(swig-defconstant "GL_RGB5_A1" #x8057)
(swig-defconstant "GL_RGBA8" #x8058)
(swig-defconstant "GL_RGB10_A2" #x8059)
(swig-defconstant "GL_RGBA12" #x805A)
(swig-defconstant "GL_RGBA16" #x805B)
(swig-defconstant "GL_TEXTURE_RED_SIZE" #x805C)
(swig-defconstant "GL_TEXTURE_GREEN_SIZE" #x805D)
(swig-defconstant "GL_TEXTURE_BLUE_SIZE" #x805E)
(swig-defconstant "GL_TEXTURE_ALPHA_SIZE" #x805F)
(swig-defconstant "GL_TEXTURE_LUMINANCE_SIZE" #x8060)
(swig-defconstant "GL_TEXTURE_INTENSITY_SIZE" #x8061)
(swig-defconstant "GL_PROXY_TEXTURE_1D" #x8063)
(swig-defconstant "GL_PROXY_TEXTURE_2D" #x8064)
(swig-defconstant "GL_TEXTURE_PRIORITY" #x8066)
(swig-defconstant "GL_TEXTURE_RESIDENT" #x8067)
(swig-defconstant "GL_TEXTURE_BINDING_1D" #x8068)
(swig-defconstant "GL_TEXTURE_BINDING_2D" #x8069)
(swig-defconstant "GL_TEXTURE_BINDING_3D" #x806A)
(swig-defconstant "GL_VERTEX_ARRAY" #x8074)
(swig-defconstant "GL_NORMAL_ARRAY" #x8075)
(swig-defconstant "GL_COLOR_ARRAY" #x8076)
(swig-defconstant "GL_INDEX_ARRAY" #x8077)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY" #x8078)
(swig-defconstant "GL_EDGE_FLAG_ARRAY" #x8079)
(swig-defconstant "GL_VERTEX_ARRAY_SIZE" #x807A)
(swig-defconstant "GL_VERTEX_ARRAY_TYPE" #x807B)
(swig-defconstant "GL_VERTEX_ARRAY_STRIDE" #x807C)
(swig-defconstant "GL_NORMAL_ARRAY_TYPE" #x807E)
(swig-defconstant "GL_NORMAL_ARRAY_STRIDE" #x807F)
(swig-defconstant "GL_COLOR_ARRAY_SIZE" #x8081)
(swig-defconstant "GL_COLOR_ARRAY_TYPE" #x8082)
(swig-defconstant "GL_COLOR_ARRAY_STRIDE" #x8083)
(swig-defconstant "GL_INDEX_ARRAY_TYPE" #x8085)
(swig-defconstant "GL_INDEX_ARRAY_STRIDE" #x8086)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_SIZE" #x8088)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_TYPE" #x8089)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_STRIDE" #x808A)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_STRIDE" #x808C)
(swig-defconstant "GL_VERTEX_ARRAY_POINTER" #x808E)
(swig-defconstant "GL_NORMAL_ARRAY_POINTER" #x808F)
(swig-defconstant "GL_COLOR_ARRAY_POINTER" #x8090)
(swig-defconstant "GL_INDEX_ARRAY_POINTER" #x8091)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_POINTER" #x8092)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_POINTER" #x8093)
(swig-defconstant "GL_V2F" #x2A20)
(swig-defconstant "GL_V3F" #x2A21)
(swig-defconstant "GL_C4UB_V2F" #x2A22)
(swig-defconstant "GL_C4UB_V3F" #x2A23)
(swig-defconstant "GL_C3F_V3F" #x2A24)
(swig-defconstant "GL_N3F_V3F" #x2A25)
(swig-defconstant "GL_C4F_N3F_V3F" #x2A26)
(swig-defconstant "GL_T2F_V3F" #x2A27)
(swig-defconstant "GL_T4F_V4F" #x2A28)
(swig-defconstant "GL_T2F_C4UB_V3F" #x2A29)
(swig-defconstant "GL_T2F_C3F_V3F" #x2A2A)
(swig-defconstant "GL_T2F_N3F_V3F" #x2A2B)
(swig-defconstant "GL_T2F_C4F_N3F_V3F" #x2A2C)
(swig-defconstant "GL_T4F_C4F_N3F_V4F" #x2A2D)
(swig-defconstant "GL_BGR" #x80E0)
(swig-defconstant "GL_BGRA" #x80E1)
(swig-defconstant "GL_CONSTANT_COLOR" #x8001)
(swig-defconstant "GL_ONE_MINUS_CONSTANT_COLOR" #x8002)
(swig-defconstant "GL_CONSTANT_ALPHA" #x8003)
(swig-defconstant "GL_ONE_MINUS_CONSTANT_ALPHA" #x8004)
(swig-defconstant "GL_BLEND_COLOR" #x8005)
(swig-defconstant "GL_FUNC_ADD" #x8006)
(swig-defconstant "GL_MIN" #x8007)
(swig-defconstant "GL_MAX" #x8008)
(swig-defconstant "GL_BLEND_EQUATION" #x8009)
(swig-defconstant "GL_BLEND_EQUATION_RGB" #x8009)
(swig-defconstant "GL_BLEND_EQUATION_ALPHA" #x883D)
(swig-defconstant "GL_FUNC_SUBTRACT" #x800A)
(swig-defconstant "GL_FUNC_REVERSE_SUBTRACT" #x800B)
(swig-defconstant "GL_COLOR_MATRIX" #x80B1)
(swig-defconstant "GL_COLOR_MATRIX_STACK_DEPTH" #x80B2)
(swig-defconstant "GL_MAX_COLOR_MATRIX_STACK_DEPTH" #x80B3)
(swig-defconstant "GL_POST_COLOR_MATRIX_RED_SCALE" #x80B4)
(swig-defconstant "GL_POST_COLOR_MATRIX_GREEN_SCALE" #x80B5)
(swig-defconstant "GL_POST_COLOR_MATRIX_BLUE_SCALE" #x80B6)
(swig-defconstant "GL_POST_COLOR_MATRIX_ALPHA_SCALE" #x80B7)
(swig-defconstant "GL_POST_COLOR_MATRIX_RED_BIAS" #x80B8)
(swig-defconstant "GL_POST_COLOR_MATRIX_GREEN_BIAS" #x80B9)
(swig-defconstant "GL_POST_COLOR_MATRIX_BLUE_BIAS" #x80BA)
(swig-defconstant "GL_POST_COLOR_MATRIX_ALPHA_BIAS" #x80BB)
(swig-defconstant "GL_COLOR_TABLE" #x80D0)
(swig-defconstant "GL_POST_CONVOLUTION_COLOR_TABLE" #x80D1)
(swig-defconstant "GL_POST_COLOR_MATRIX_COLOR_TABLE" #x80D2)
(swig-defconstant "GL_PROXY_COLOR_TABLE" #x80D3)
(swig-defconstant "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE" #x80D4)
(swig-defconstant "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE" #x80D5)
(swig-defconstant "GL_COLOR_TABLE_SCALE" #x80D6)
(swig-defconstant "GL_COLOR_TABLE_BIAS" #x80D7)
(swig-defconstant "GL_COLOR_TABLE_FORMAT" #x80D8)
(swig-defconstant "GL_COLOR_TABLE_WIDTH" #x80D9)
(swig-defconstant "GL_COLOR_TABLE_RED_SIZE" #x80DA)
(swig-defconstant "GL_COLOR_TABLE_GREEN_SIZE" #x80DB)
(swig-defconstant "GL_COLOR_TABLE_BLUE_SIZE" #x80DC)
(swig-defconstant "GL_COLOR_TABLE_ALPHA_SIZE" #x80DD)
(swig-defconstant "GL_COLOR_TABLE_LUMINANCE_SIZE" #x80DE)
(swig-defconstant "GL_COLOR_TABLE_INTENSITY_SIZE" #x80DF)
(swig-defconstant "GL_CONVOLUTION_1D" #x8010)
(swig-defconstant "GL_CONVOLUTION_2D" #x8011)
(swig-defconstant "GL_SEPARABLE_2D" #x8012)
(swig-defconstant "GL_CONVOLUTION_BORDER_MODE" #x8013)
(swig-defconstant "GL_CONVOLUTION_FILTER_SCALE" #x8014)
(swig-defconstant "GL_CONVOLUTION_FILTER_BIAS" #x8015)
(swig-defconstant "GL_REDUCE" #x8016)
(swig-defconstant "GL_CONVOLUTION_FORMAT" #x8017)
(swig-defconstant "GL_CONVOLUTION_WIDTH" #x8018)
(swig-defconstant "GL_CONVOLUTION_HEIGHT" #x8019)
(swig-defconstant "GL_MAX_CONVOLUTION_WIDTH" #x801A)
(swig-defconstant "GL_MAX_CONVOLUTION_HEIGHT" #x801B)
(swig-defconstant "GL_POST_CONVOLUTION_RED_SCALE" #x801C)
(swig-defconstant "GL_POST_CONVOLUTION_GREEN_SCALE" #x801D)
(swig-defconstant "GL_POST_CONVOLUTION_BLUE_SCALE" #x801E)
(swig-defconstant "GL_POST_CONVOLUTION_ALPHA_SCALE" #x801F)
(swig-defconstant "GL_POST_CONVOLUTION_RED_BIAS" #x8020)
(swig-defconstant "GL_POST_CONVOLUTION_GREEN_BIAS" #x8021)
(swig-defconstant "GL_POST_CONVOLUTION_BLUE_BIAS" #x8022)
(swig-defconstant "GL_POST_CONVOLUTION_ALPHA_BIAS" #x8023)
(swig-defconstant "GL_CONSTANT_BORDER" #x8151)
(swig-defconstant "GL_REPLICATE_BORDER" #x8153)
(swig-defconstant "GL_CONVOLUTION_BORDER_COLOR" #x8154)
(swig-defconstant "GL_MAX_ELEMENTS_VERTICES" #x80E8)
(swig-defconstant "GL_MAX_ELEMENTS_INDICES" #x80E9)
(swig-defconstant "GL_HISTOGRAM" #x8024)
(swig-defconstant "GL_PROXY_HISTOGRAM" #x8025)
(swig-defconstant "GL_HISTOGRAM_WIDTH" #x8026)
(swig-defconstant "GL_HISTOGRAM_FORMAT" #x8027)
(swig-defconstant "GL_HISTOGRAM_RED_SIZE" #x8028)
(swig-defconstant "GL_HISTOGRAM_GREEN_SIZE" #x8029)
(swig-defconstant "GL_HISTOGRAM_BLUE_SIZE" #x802A)
(swig-defconstant "GL_HISTOGRAM_ALPHA_SIZE" #x802B)
(swig-defconstant "GL_HISTOGRAM_LUMINANCE_SIZE" #x802C)
(swig-defconstant "GL_HISTOGRAM_SINK" #x802D)
(swig-defconstant "GL_MINMAX" #x802E)
(swig-defconstant "GL_MINMAX_FORMAT" #x802F)
(swig-defconstant "GL_MINMAX_SINK" #x8030)
(swig-defconstant "GL_TABLE_TOO_LARGE" #x8031)
(swig-defconstant "GL_UNSIGNED_BYTE_3_3_2" #x8032)
(swig-defconstant "GL_UNSIGNED_SHORT_4_4_4_4" #x8033)
(swig-defconstant "GL_UNSIGNED_SHORT_5_5_5_1" #x8034)
(swig-defconstant "GL_UNSIGNED_INT_8_8_8_8" #x8035)
(swig-defconstant "GL_UNSIGNED_INT_10_10_10_2" #x8036)
(swig-defconstant "GL_UNSIGNED_BYTE_2_3_3_REV" #x8362)
(swig-defconstant "GL_UNSIGNED_SHORT_5_6_5" #x8363)
(swig-defconstant "GL_UNSIGNED_SHORT_5_6_5_REV" #x8364)
(swig-defconstant "GL_UNSIGNED_SHORT_4_4_4_4_REV" #x8365)
(swig-defconstant "GL_UNSIGNED_SHORT_1_5_5_5_REV" #x8366)
(swig-defconstant "GL_UNSIGNED_INT_8_8_8_8_REV" #x8367)
(swig-defconstant "GL_UNSIGNED_INT_2_10_10_10_REV" #x8368)
(swig-defconstant "GL_RESCALE_NORMAL" #x803A)
(swig-defconstant "GL_LIGHT_MODEL_COLOR_CONTROL" #x81F8)
(swig-defconstant "GL_SINGLE_COLOR" #x81F9)
(swig-defconstant "GL_SEPARATE_SPECULAR_COLOR" #x81FA)
(swig-defconstant "GL_PACK_SKIP_IMAGES" #x806B)
(swig-defconstant "GL_PACK_IMAGE_HEIGHT" #x806C)
(swig-defconstant "GL_UNPACK_SKIP_IMAGES" #x806D)
(swig-defconstant "GL_UNPACK_IMAGE_HEIGHT" #x806E)
(swig-defconstant "GL_TEXTURE_3D" #x806F)
(swig-defconstant "GL_PROXY_TEXTURE_3D" #x8070)
(swig-defconstant "GL_TEXTURE_DEPTH" #x8071)
(swig-defconstant "GL_TEXTURE_WRAP_R" #x8072)
(swig-defconstant "GL_MAX_3D_TEXTURE_SIZE" #x8073)
(swig-defconstant "GL_CLAMP_TO_EDGE" #x812F)
(swig-defconstant "GL_CLAMP_TO_BORDER" #x812D)
(swig-defconstant "GL_TEXTURE_MIN_LOD" #x813A)
(swig-defconstant "GL_TEXTURE_MAX_LOD" #x813B)
(swig-defconstant "GL_TEXTURE_BASE_LEVEL" #x813C)
(swig-defconstant "GL_TEXTURE_MAX_LEVEL" #x813D)
(swig-defconstant "GL_SMOOTH_POINT_SIZE_RANGE" #x0B12)
(swig-defconstant "GL_SMOOTH_POINT_SIZE_GRANULARITY" #x0B13)
(swig-defconstant "GL_SMOOTH_LINE_WIDTH_RANGE" #x0B22)
(swig-defconstant "GL_SMOOTH_LINE_WIDTH_GRANULARITY" #x0B23)
(swig-defconstant "GL_ALIASED_POINT_SIZE_RANGE" #x846D)
(swig-defconstant "GL_ALIASED_LINE_WIDTH_RANGE" #x846E)
(swig-defconstant "GL_TEXTURE0" #x84C0)
(swig-defconstant "GL_TEXTURE1" #x84C1)
(swig-defconstant "GL_TEXTURE2" #x84C2)
(swig-defconstant "GL_TEXTURE3" #x84C3)
(swig-defconstant "GL_TEXTURE4" #x84C4)
(swig-defconstant "GL_TEXTURE5" #x84C5)
(swig-defconstant "GL_TEXTURE6" #x84C6)
(swig-defconstant "GL_TEXTURE7" #x84C7)
(swig-defconstant "GL_TEXTURE8" #x84C8)
(swig-defconstant "GL_TEXTURE9" #x84C9)
(swig-defconstant "GL_TEXTURE10" #x84CA)
(swig-defconstant "GL_TEXTURE11" #x84CB)
(swig-defconstant "GL_TEXTURE12" #x84CC)
(swig-defconstant "GL_TEXTURE13" #x84CD)
(swig-defconstant "GL_TEXTURE14" #x84CE)
(swig-defconstant "GL_TEXTURE15" #x84CF)
(swig-defconstant "GL_TEXTURE16" #x84D0)
(swig-defconstant "GL_TEXTURE17" #x84D1)
(swig-defconstant "GL_TEXTURE18" #x84D2)
(swig-defconstant "GL_TEXTURE19" #x84D3)
(swig-defconstant "GL_TEXTURE20" #x84D4)
(swig-defconstant "GL_TEXTURE21" #x84D5)
(swig-defconstant "GL_TEXTURE22" #x84D6)
(swig-defconstant "GL_TEXTURE23" #x84D7)
(swig-defconstant "GL_TEXTURE24" #x84D8)
(swig-defconstant "GL_TEXTURE25" #x84D9)
(swig-defconstant "GL_TEXTURE26" #x84DA)
(swig-defconstant "GL_TEXTURE27" #x84DB)
(swig-defconstant "GL_TEXTURE28" #x84DC)
(swig-defconstant "GL_TEXTURE29" #x84DD)
(swig-defconstant "GL_TEXTURE30" #x84DE)
(swig-defconstant "GL_TEXTURE31" #x84DF)
(swig-defconstant "GL_ACTIVE_TEXTURE" #x84E0)
(swig-defconstant "GL_CLIENT_ACTIVE_TEXTURE" #x84E1)
(swig-defconstant "GL_MAX_TEXTURE_UNITS" #x84E2)
(swig-defconstant "GL_COMBINE" #x8570)
(swig-defconstant "GL_COMBINE_RGB" #x8571)
(swig-defconstant "GL_COMBINE_ALPHA" #x8572)
(swig-defconstant "GL_RGB_SCALE" #x8573)
(swig-defconstant "GL_ADD_SIGNED" #x8574)
(swig-defconstant "GL_INTERPOLATE" #x8575)
(swig-defconstant "GL_CONSTANT" #x8576)
(swig-defconstant "GL_PRIMARY_COLOR" #x8577)
(swig-defconstant "GL_PREVIOUS" #x8578)
(swig-defconstant "GL_SUBTRACT" #x84E7)
(swig-defconstant "GL_SRC0_RGB" #x8580)
(swig-defconstant "GL_SRC1_RGB" #x8581)
(swig-defconstant "GL_SRC2_RGB" #x8582)
(swig-defconstant "GL_SRC3_RGB" #x8583)
(swig-defconstant "GL_SRC4_RGB" #x8584)
(swig-defconstant "GL_SRC5_RGB" #x8585)
(swig-defconstant "GL_SRC6_RGB" #x8586)
(swig-defconstant "GL_SRC7_RGB" #x8587)
(swig-defconstant "GL_SRC0_ALPHA" #x8588)
(swig-defconstant "GL_SRC1_ALPHA" #x8589)
(swig-defconstant "GL_SRC2_ALPHA" #x858A)
(swig-defconstant "GL_SRC3_ALPHA" #x858B)
(swig-defconstant "GL_SRC4_ALPHA" #x858C)
(swig-defconstant "GL_SRC5_ALPHA" #x858D)
(swig-defconstant "GL_SRC6_ALPHA" #x858E)
(swig-defconstant "GL_SRC7_ALPHA" #x858F)
(swig-defconstant "GL_SOURCE0_RGB" #x8580)
(swig-defconstant "GL_SOURCE1_RGB" #x8581)
(swig-defconstant "GL_SOURCE2_RGB" #x8582)
(swig-defconstant "GL_SOURCE3_RGB" #x8583)
(swig-defconstant "GL_SOURCE4_RGB" #x8584)
(swig-defconstant "GL_SOURCE5_RGB" #x8585)
(swig-defconstant "GL_SOURCE6_RGB" #x8586)
(swig-defconstant "GL_SOURCE7_RGB" #x8587)
(swig-defconstant "GL_SOURCE0_ALPHA" #x8588)
(swig-defconstant "GL_SOURCE1_ALPHA" #x8589)
(swig-defconstant "GL_SOURCE2_ALPHA" #x858A)
(swig-defconstant "GL_SOURCE3_ALPHA" #x858B)
(swig-defconstant "GL_SOURCE4_ALPHA" #x858C)
(swig-defconstant "GL_SOURCE5_ALPHA" #x858D)
(swig-defconstant "GL_SOURCE6_ALPHA" #x858E)
(swig-defconstant "GL_SOURCE7_ALPHA" #x858F)
(swig-defconstant "GL_OPERAND0_RGB" #x8590)
(swig-defconstant "GL_OPERAND1_RGB" #x8591)
(swig-defconstant "GL_OPERAND2_RGB" #x8592)
(swig-defconstant "GL_OPERAND3_RGB" #x8593)
(swig-defconstant "GL_OPERAND4_RGB" #x8594)
(swig-defconstant "GL_OPERAND5_RGB" #x8595)
(swig-defconstant "GL_OPERAND6_RGB" #x8596)
(swig-defconstant "GL_OPERAND7_RGB" #x8597)
(swig-defconstant "GL_OPERAND0_ALPHA" #x8598)
(swig-defconstant "GL_OPERAND1_ALPHA" #x8599)
(swig-defconstant "GL_OPERAND2_ALPHA" #x859A)
(swig-defconstant "GL_OPERAND3_ALPHA" #x859B)
(swig-defconstant "GL_OPERAND4_ALPHA" #x859C)
(swig-defconstant "GL_OPERAND5_ALPHA" #x859D)
(swig-defconstant "GL_OPERAND6_ALPHA" #x859E)
(swig-defconstant "GL_OPERAND7_ALPHA" #x859F)
(swig-defconstant "GL_DOT3_RGB" #x86AE)
(swig-defconstant "GL_DOT3_RGBA" #x86AF)
(swig-defconstant "GL_TRANSPOSE_MODELVIEW_MATRIX" #x84E3)
(swig-defconstant "GL_TRANSPOSE_PROJECTION_MATRIX" #x84E4)
(swig-defconstant "GL_TRANSPOSE_TEXTURE_MATRIX" #x84E5)
(swig-defconstant "GL_TRANSPOSE_COLOR_MATRIX" #x84E6)
(swig-defconstant "GL_NORMAL_MAP" #x8511)
(swig-defconstant "GL_REFLECTION_MAP" #x8512)
(swig-defconstant "GL_TEXTURE_CUBE_MAP" #x8513)
(swig-defconstant "GL_TEXTURE_BINDING_CUBE_MAP" #x8514)
(swig-defconstant "GL_TEXTURE_CUBE_MAP_POSITIVE_X" #x8515)
(swig-defconstant "GL_TEXTURE_CUBE_MAP_NEGATIVE_X" #x8516)
(swig-defconstant "GL_TEXTURE_CUBE_MAP_POSITIVE_Y" #x8517)
(swig-defconstant "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y" #x8518)
(swig-defconstant "GL_TEXTURE_CUBE_MAP_POSITIVE_Z" #x8519)
(swig-defconstant "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z" #x851A)
(swig-defconstant "GL_PROXY_TEXTURE_CUBE_MAP" #x851B)
(swig-defconstant "GL_MAX_CUBE_MAP_TEXTURE_SIZE" #x851C)
(swig-defconstant "GL_COMPRESSED_ALPHA" #x84E9)
(swig-defconstant "GL_COMPRESSED_LUMINANCE" #x84EA)
(swig-defconstant "GL_COMPRESSED_LUMINANCE_ALPHA" #x84EB)
(swig-defconstant "GL_COMPRESSED_INTENSITY" #x84EC)
(swig-defconstant "GL_COMPRESSED_RGB" #x84ED)
(swig-defconstant "GL_COMPRESSED_RGBA" #x84EE)
(swig-defconstant "GL_TEXTURE_COMPRESSION_HINT" #x84EF)
(swig-defconstant "GL_TEXTURE_COMPRESSED_IMAGE_SIZE" #x86A0)
(swig-defconstant "GL_TEXTURE_COMPRESSED" #x86A1)
(swig-defconstant "GL_NUM_COMPRESSED_TEXTURE_FORMATS" #x86A2)
(swig-defconstant "GL_COMPRESSED_TEXTURE_FORMATS" #x86A3)
(swig-defconstant "GL_MULTISAMPLE" #x809D)
(swig-defconstant "GL_SAMPLE_ALPHA_TO_COVERAGE" #x809E)
(swig-defconstant "GL_SAMPLE_ALPHA_TO_ONE" #x809F)
(swig-defconstant "GL_SAMPLE_COVERAGE" #x80A0)
(swig-defconstant "GL_SAMPLE_BUFFERS" #x80A8)
(swig-defconstant "GL_SAMPLES" #x80A9)
(swig-defconstant "GL_SAMPLE_COVERAGE_VALUE" #x80AA)
(swig-defconstant "GL_SAMPLE_COVERAGE_INVERT" #x80AB)
(swig-defconstant "GL_MULTISAMPLE_BIT" #x20000000)
(swig-defconstant "GL_DEPTH_COMPONENT16" #x81A5)
(swig-defconstant "GL_DEPTH_COMPONENT24" #x81A6)
(swig-defconstant "GL_DEPTH_COMPONENT32" #x81A7)
(swig-defconstant "GL_TEXTURE_DEPTH_SIZE" #x884A)
(swig-defconstant "GL_DEPTH_TEXTURE_MODE" #x884B)
(swig-defconstant "GL_TEXTURE_COMPARE_MODE" #x884C)
(swig-defconstant "GL_TEXTURE_COMPARE_FUNC" #x884D)
(swig-defconstant "GL_COMPARE_R_TO_TEXTURE" #x884E)
(swig-defconstant "GL_QUERY_COUNTER_BITS" #x8864)
(swig-defconstant "GL_CURRENT_QUERY" #x8865)
(swig-defconstant "GL_QUERY_RESULT" #x8866)
(swig-defconstant "GL_QUERY_RESULT_AVAILABLE" #x8867)
(swig-defconstant "GL_SAMPLES_PASSED" #x8914)
(swig-defconstant "GL_FOG_COORD_SRC" #x8450)
(swig-defconstant "GL_FOG_COORD" #x8451)
(swig-defconstant "GL_FRAGMENT_DEPTH" #x8452)
(swig-defconstant "GL_CURRENT_FOG_COORD" #x8453)
(swig-defconstant "GL_FOG_COORD_ARRAY_TYPE" #x8454)
(swig-defconstant "GL_FOG_COORD_ARRAY_STRIDE" #x8455)
(swig-defconstant "GL_FOG_COORD_ARRAY_POINTER" #x8456)
(swig-defconstant "GL_FOG_COORD_ARRAY" #x8457)
(swig-defconstant "GL_FOG_COORDINATE_SOURCE" #x8450)
(swig-defconstant "GL_FOG_COORDINATE" #x8451)
(swig-defconstant "GL_CURRENT_FOG_COORDINATE" #x8453)
(swig-defconstant "GL_FOG_COORDINATE_ARRAY_TYPE" #x8454)
(swig-defconstant "GL_FOG_COORDINATE_ARRAY_STRIDE" #x8455)
(swig-defconstant "GL_FOG_COORDINATE_ARRAY_POINTER" #x8456)
(swig-defconstant "GL_FOG_COORDINATE_ARRAY" #x8457)
(swig-defconstant "GL_COLOR_SUM" #x8458)
(swig-defconstant "GL_CURRENT_SECONDARY_COLOR" #x8459)
(swig-defconstant "GL_SECONDARY_COLOR_ARRAY_SIZE" #x845A)
(swig-defconstant "GL_SECONDARY_COLOR_ARRAY_TYPE" #x845B)
(swig-defconstant "GL_SECONDARY_COLOR_ARRAY_STRIDE" #x845C)
(swig-defconstant "GL_SECONDARY_COLOR_ARRAY_POINTER" #x845D)
(swig-defconstant "GL_SECONDARY_COLOR_ARRAY" #x845E)
(swig-defconstant "GL_POINT_SIZE_MIN" #x8126)
(swig-defconstant "GL_POINT_SIZE_MAX" #x8127)
(swig-defconstant "GL_POINT_FADE_THRESHOLD_SIZE" #x8128)
(swig-defconstant "GL_POINT_DISTANCE_ATTENUATION" #x8129)
(swig-defconstant "GL_BLEND_DST_RGB" #x80C8)
(swig-defconstant "GL_BLEND_SRC_RGB" #x80C9)
(swig-defconstant "GL_BLEND_DST_ALPHA" #x80CA)
(swig-defconstant "GL_BLEND_SRC_ALPHA" #x80CB)
(swig-defconstant "GL_GENERATE_MIPMAP" #x8191)
(swig-defconstant "GL_GENERATE_MIPMAP_HINT" #x8192)
(swig-defconstant "GL_INCR_WRAP" #x8507)
(swig-defconstant "GL_DECR_WRAP" #x8508)
(swig-defconstant "GL_MIRRORED_REPEAT" #x8370)
(swig-defconstant "GL_MAX_TEXTURE_LOD_BIAS" #x84FD)
(swig-defconstant "GL_TEXTURE_FILTER_CONTROL" #x8500)
(swig-defconstant "GL_TEXTURE_LOD_BIAS" #x8501)
(swig-defconstant "GL_ARRAY_BUFFER" #x8892)
(swig-defconstant "GL_ELEMENT_ARRAY_BUFFER" #x8893)
(swig-defconstant "GL_ARRAY_BUFFER_BINDING" #x8894)
(swig-defconstant "GL_ELEMENT_ARRAY_BUFFER_BINDING" #x8895)
(swig-defconstant "GL_VERTEX_ARRAY_BUFFER_BINDING" #x8896)
(swig-defconstant "GL_NORMAL_ARRAY_BUFFER_BINDING" #x8897)
(swig-defconstant "GL_COLOR_ARRAY_BUFFER_BINDING" #x8898)
(swig-defconstant "GL_INDEX_ARRAY_BUFFER_BINDING" #x8899)
(swig-defconstant "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING" #x889A)
(swig-defconstant "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING" #x889B)
(swig-defconstant "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING" #x889C)
(swig-defconstant "GL_FOG_COORD_ARRAY_BUFFER_BINDING" #x889D)
(swig-defconstant "GL_WEIGHT_ARRAY_BUFFER_BINDING" #x889E)
(swig-defconstant "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING" #x889F)
(swig-defconstant "GL_STREAM_DRAW" #x88E0)
(swig-defconstant "GL_STREAM_READ" #x88E1)
(swig-defconstant "GL_STREAM_COPY" #x88E2)
(swig-defconstant "GL_STATIC_DRAW" #x88E4)
(swig-defconstant "GL_STATIC_READ" #x88E5)
(swig-defconstant "GL_STATIC_COPY" #x88E6)
(swig-defconstant "GL_DYNAMIC_DRAW" #x88E8)
(swig-defconstant "GL_DYNAMIC_READ" #x88E9)
(swig-defconstant "GL_DYNAMIC_COPY" #x88EA)
(swig-defconstant "GL_READ_ONLY" #x88B8)
(swig-defconstant "GL_WRITE_ONLY" #x88B9)
(swig-defconstant "GL_READ_WRITE" #x88BA)
(swig-defconstant "GL_BUFFER_SIZE" #x8764)
(swig-defconstant "GL_BUFFER_USAGE" #x8765)
(swig-defconstant "GL_BUFFER_ACCESS" #x88BB)
(swig-defconstant "GL_BUFFER_MAPPED" #x88BC)
(swig-defconstant "GL_BUFFER_MAP_POINTER" #x88BD)
(swig-defconstant "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING" #x889D)
(swig-defconstant "GL_CURRENT_PROGRAM" #x8B8D)
(swig-defconstant "GL_SHADER_TYPE" #x8B4F)
(swig-defconstant "GL_DELETE_STATUS" #x8B80)
(swig-defconstant "GL_COMPILE_STATUS" #x8B81)
(swig-defconstant "GL_LINK_STATUS" #x8B82)
(swig-defconstant "GL_VALIDATE_STATUS" #x8B83)
(swig-defconstant "GL_INFO_LOG_LENGTH" #x8B84)
(swig-defconstant "GL_ATTACHED_SHADERS" #x8B85)
(swig-defconstant "GL_ACTIVE_UNIFORMS" #x8B86)
(swig-defconstant "GL_ACTIVE_UNIFORM_MAX_LENGTH" #x8B87)
(swig-defconstant "GL_SHADER_SOURCE_LENGTH" #x8B88)
(swig-defconstant "GL_FLOAT_VEC2" #x8B50)
(swig-defconstant "GL_FLOAT_VEC3" #x8B51)
(swig-defconstant "GL_FLOAT_VEC4" #x8B52)
(swig-defconstant "GL_INT_VEC2" #x8B53)
(swig-defconstant "GL_INT_VEC3" #x8B54)
(swig-defconstant "GL_INT_VEC4" #x8B55)
(swig-defconstant "GL_BOOL" #x8B56)
(swig-defconstant "GL_BOOL_VEC2" #x8B57)
(swig-defconstant "GL_BOOL_VEC3" #x8B58)
(swig-defconstant "GL_BOOL_VEC4" #x8B59)
(swig-defconstant "GL_FLOAT_MAT2" #x8B5A)
(swig-defconstant "GL_FLOAT_MAT3" #x8B5B)
(swig-defconstant "GL_FLOAT_MAT4" #x8B5C)
(swig-defconstant "GL_SAMPLER_1D" #x8B5D)
(swig-defconstant "GL_SAMPLER_2D" #x8B5E)
(swig-defconstant "GL_SAMPLER_3D" #x8B5F)
(swig-defconstant "GL_SAMPLER_CUBE" #x8B60)
(swig-defconstant "GL_SAMPLER_1D_SHADOW" #x8B61)
(swig-defconstant "GL_SAMPLER_2D_SHADOW" #x8B62)
(swig-defconstant "GL_SHADING_LANGUAGE_VERSION" #x8B8C)
(swig-defconstant "GL_VERTEX_SHADER" #x8B31)
(swig-defconstant "GL_MAX_VERTEX_UNIFORM_COMPONENTS" #x8B4A)
(swig-defconstant "GL_MAX_VARYING_FLOATS" #x8B4B)
(swig-defconstant "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS" #x8B4C)
(swig-defconstant "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS" #x8B4D)
(swig-defconstant "GL_ACTIVE_ATTRIBUTES" #x8B89)
(swig-defconstant "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH" #x8B8A)
(swig-defconstant "GL_FRAGMENT_SHADER" #x8B30)
(swig-defconstant "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS" #x8B49)
(swig-defconstant "GL_FRAGMENT_SHADER_DERIVATIVE_HINT" #x8B8B)
(swig-defconstant "GL_MAX_VERTEX_ATTRIBS" #x8869)
(swig-defconstant "GL_VERTEX_ATTRIB_ARRAY_ENABLED" #x8622)
(swig-defconstant "GL_VERTEX_ATTRIB_ARRAY_SIZE" #x8623)
(swig-defconstant "GL_VERTEX_ATTRIB_ARRAY_STRIDE" #x8624)
(swig-defconstant "GL_VERTEX_ATTRIB_ARRAY_TYPE" #x8625)
(swig-defconstant "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED" #x886A)
(swig-defconstant "GL_CURRENT_VERTEX_ATTRIB" #x8626)
(swig-defconstant "GL_VERTEX_ATTRIB_ARRAY_POINTER" #x8645)
(swig-defconstant "GL_VERTEX_PROGRAM_POINT_SIZE" #x8642)
(swig-defconstant "GL_VERTEX_PROGRAM_TWO_SIDE" #x8643)
(swig-defconstant "GL_MAX_TEXTURE_COORDS" #x8871)
(swig-defconstant "GL_MAX_TEXTURE_IMAGE_UNITS" #x8872)
(swig-defconstant "GL_MAX_DRAW_BUFFERS" #x8824)
(swig-defconstant "GL_DRAW_BUFFER0" #x8825)
(swig-defconstant "GL_DRAW_BUFFER1" #x8826)
(swig-defconstant "GL_DRAW_BUFFER2" #x8827)
(swig-defconstant "GL_DRAW_BUFFER3" #x8828)
(swig-defconstant "GL_DRAW_BUFFER4" #x8829)
(swig-defconstant "GL_DRAW_BUFFER5" #x882A)
(swig-defconstant "GL_DRAW_BUFFER6" #x882B)
(swig-defconstant "GL_DRAW_BUFFER7" #x882C)
(swig-defconstant "GL_DRAW_BUFFER8" #x882D)
(swig-defconstant "GL_DRAW_BUFFER9" #x882E)
(swig-defconstant "GL_DRAW_BUFFER10" #x882F)
(swig-defconstant "GL_DRAW_BUFFER11" #x8830)
(swig-defconstant "GL_DRAW_BUFFER12" #x8831)
(swig-defconstant "GL_DRAW_BUFFER13" #x8832)
(swig-defconstant "GL_DRAW_BUFFER14" #x8833)
(swig-defconstant "GL_DRAW_BUFFER15" #x8834)
(swig-defconstant "GL_POINT_SPRITE" #x8861)
(swig-defconstant "GL_COORD_REPLACE" #x8862)
(swig-defconstant "GL_POINT_SPRITE_COORD_ORIGIN" #x8CA0)
(swig-defconstant "GL_LOWER_LEFT" #x8CA1)
(swig-defconstant "GL_UPPER_LEFT" #x8CA2)
(swig-defconstant "GL_STENCIL_BACK_FUNC" #x8800)
(swig-defconstant "GL_STENCIL_BACK_VALUE_MASK" #x8CA4)
(swig-defconstant "GL_STENCIL_BACK_REF" #x8CA3)
(swig-defconstant "GL_STENCIL_BACK_FAIL" #x8801)
(swig-defconstant "GL_STENCIL_BACK_PASS_DEPTH_FAIL" #x8802)
(swig-defconstant "GL_STENCIL_BACK_PASS_DEPTH_PASS" #x8803)
(swig-defconstant "GL_STENCIL_BACK_WRITEMASK" #x8CA5)
(swig-defun ("glAccum" "glAccum")
  ((:p+ PARM0_op  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_value  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_op))
  (cl::let ((SWIG_arg1 PARM1_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glAlphaFunc" "glAlphaFunc")
  ((:p+ PARM0_func  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_ref  #.(swig-insert-id "GLclampf" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (cl::let ((SWIG_arg1 PARM1_ref))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glAreTexturesResident" "glAreTexturesResident")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) )
   (:p+ PARM2_residences  (* #.(swig-insert-id "GLboolean" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (cl::let ((SWIG_arg2 PARM2_residences))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glArrayElement" "glArrayElement")
  ((:p+ PARM0_i  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_i))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBegin" "glBegin")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBindTexture" "glBindTexture")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_texture  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_texture))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBitmap" "glBitmap")
  ((:p+ PARM0_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_xorig  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_yorig  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM4_xmove  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM5_ymove  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM6_bitmap  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (cl::let ((SWIG_arg1 PARM1_height))
  (cl::let ((SWIG_arg2 PARM2_xorig))
  (cl::let ((SWIG_arg3 PARM3_yorig))
  (cl::let ((SWIG_arg4 PARM4_xmove))
  (cl::let ((SWIG_arg5 PARM5_ymove))
  (cl::let ((SWIG_arg6 PARM6_bitmap))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBlendColor" "glBlendColor")
  ((:p+ PARM0_red  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLclampf" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBlendEquation" "glBlendEquation")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBlendEquationSeparate" "glBlendEquationSeparate")
  ((:p+ PARM0_modeRGB  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_modeAlpha  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_modeRGB))
  (cl::let ((SWIG_arg1 PARM1_modeAlpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBlendFunc" "glBlendFunc")
  ((:p+ PARM0_sfactor  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_dfactor  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_sfactor))
  (cl::let ((SWIG_arg1 PARM1_dfactor))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCallList" "glCallList")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCallLists" "glCallLists")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_lists  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_lists))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClear" "glClear")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLbitfield" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearAccum" "glClearAccum")
  ((:p+ PARM0_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearColor" "glClearColor")
  ((:p+ PARM0_red  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLclampf" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearDepth" "glClearDepth")
  ((:p+ PARM0_depth  #.(swig-insert-id "GLclampd" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_depth))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearIndex" "glClearIndex")
  ((:p+ PARM0_c  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClearStencil" "glClearStencil")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClipPlane" "glClipPlane")
  ((:p+ PARM0_plane  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_equation  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_plane))
  (cl::let ((SWIG_arg1 PARM1_equation))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3b" "glColor3b")
  ((:p+ PARM0_red  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLbyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3bv" "glColor3bv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3d" "glColor3d")
  ((:p+ PARM0_red  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3dv" "glColor3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3f" "glColor3f")
  ((:p+ PARM0_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3fv" "glColor3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3i" "glColor3i")
  ((:p+ PARM0_red  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3iv" "glColor3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3s" "glColor3s")
  ((:p+ PARM0_red  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3sv" "glColor3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3ub" "glColor3ub")
  ((:p+ PARM0_red  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3ubv" "glColor3ubv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3ui" "glColor3ui")
  ((:p+ PARM0_red  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3uiv" "glColor3uiv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3us" "glColor3us")
  ((:p+ PARM0_red  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLushort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor3usv" "glColor3usv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4b" "glColor4b")
  ((:p+ PARM0_red  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM3_alpha  #.(swig-insert-id "GLbyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4bv" "glColor4bv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4d" "glColor4d")
  ((:p+ PARM0_red  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4dv" "glColor4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4f" "glColor4f")
  ((:p+ PARM0_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4fv" "glColor4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4i" "glColor4i")
  ((:p+ PARM0_red  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4iv" "glColor4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4s" "glColor4s")
  ((:p+ PARM0_red  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4sv" "glColor4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4ub" "glColor4ub")
  ((:p+ PARM0_red  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM3_alpha  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4ubv" "glColor4ubv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4ui" "glColor4ui")
  ((:p+ PARM0_red  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4uiv" "glColor4uiv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4us" "glColor4us")
  ((:p+ PARM0_red  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM3_alpha  #.(swig-insert-id "GLushort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColor4usv" "glColor4usv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorMask" "glColorMask")
  ((:p+ PARM0_red  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM3_alpha  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (cl::let ((SWIG_arg3 PARM3_alpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorMaterial" "glColorMaterial")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorPointer" "glColorPointer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_stride))
  (cl::let ((SWIG_arg3 PARM3_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorSubTable" "glColorSubTable")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_start  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_start))
  (cl::let ((SWIG_arg2 PARM2_count))
  (cl::let ((SWIG_arg3 PARM3_format))
  (cl::let ((SWIG_arg4 PARM4_type))
  (cl::let ((SWIG_arg5 PARM5_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorTable" "glColorTable")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_table  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_format))
  (cl::let ((SWIG_arg4 PARM4_type))
  (cl::let ((SWIG_arg5 PARM5_table))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorTableParameterfv" "glColorTableParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glColorTableParameteriv" "glColorTableParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glConvolutionFilter1D" "glConvolutionFilter1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_image  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_format))
  (cl::let ((SWIG_arg4 PARM4_type))
  (cl::let ((SWIG_arg5 PARM5_image))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glConvolutionFilter2D" "glConvolutionFilter2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_image  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_image))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glConvolutionParameterf" "glConvolutionParameterf")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glConvolutionParameterfv" "glConvolutionParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glConvolutionParameteri" "glConvolutionParameteri")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glConvolutionParameteriv" "glConvolutionParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyColorSubTable" "glCopyColorSubTable")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_start  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_width  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_start))
  (cl::let ((SWIG_arg2 PARM2_x))
  (cl::let ((SWIG_arg3 PARM3_y))
  (cl::let ((SWIG_arg4 PARM4_width))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyColorTable" "glCopyColorTable")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_width  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_x))
  (cl::let ((SWIG_arg3 PARM3_y))
  (cl::let ((SWIG_arg4 PARM4_width))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyConvolutionFilter1D" "glCopyConvolutionFilter1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_width  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_x))
  (cl::let ((SWIG_arg3 PARM3_y))
  (cl::let ((SWIG_arg4 PARM4_width))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyConvolutionFilter2D" "glCopyConvolutionFilter2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_x))
  (cl::let ((SWIG_arg3 PARM3_y))
  (cl::let ((SWIG_arg4 PARM4_width))
  (cl::let ((SWIG_arg5 PARM5_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyPixels" "glCopyPixels")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexImage1D" "glCopyTexImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_border  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_x))
  (cl::let ((SWIG_arg4 PARM4_y))
  (cl::let ((SWIG_arg5 PARM5_width))
  (cl::let ((SWIG_arg6 PARM6_border))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexImage2D" "glCopyTexImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_border  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_x))
  (cl::let ((SWIG_arg4 PARM4_y))
  (cl::let ((SWIG_arg5 PARM5_width))
  (cl::let ((SWIG_arg6 PARM6_height))
  (cl::let ((SWIG_arg7 PARM7_border))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexSubImage1D" "glCopyTexSubImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_x))
  (cl::let ((SWIG_arg4 PARM4_y))
  (cl::let ((SWIG_arg5 PARM5_width))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexSubImage2D" "glCopyTexSubImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_x))
  (cl::let ((SWIG_arg5 PARM5_y))
  (cl::let ((SWIG_arg6 PARM6_width))
  (cl::let ((SWIG_arg7 PARM7_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCopyTexSubImage3D" "glCopyTexSubImage3D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_zoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM8_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_zoffset))
  (cl::let ((SWIG_arg5 PARM5_x))
  (cl::let ((SWIG_arg6 PARM6_y))
  (cl::let ((SWIG_arg7 PARM7_width))
  (cl::let ((SWIG_arg8 PARM8_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCullFace" "glCullFace")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteLists" "glDeleteLists")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_range  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (cl::let ((SWIG_arg1 PARM1_range))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteTextures" "glDeleteTextures")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDepthFunc" "glDepthFunc")
  ((:p+ PARM0_func  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDepthMask" "glDepthMask")
  ((:p+ PARM0_flag  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_flag))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDepthRange" "glDepthRange")
  ((:p+ PARM0_zNear  #.(swig-insert-id "GLclampd" () :type :type) )
   (:p+ PARM1_zFar  #.(swig-insert-id "GLclampd" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_zNear))
  (cl::let ((SWIG_arg1 PARM1_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDisable" "glDisable")
  ((:p+ PARM0_cap  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_cap))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDisableClientState" "glDisableClientState")
  ((:p+ PARM0_array  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_array))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawArrays" "glDrawArrays")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_first  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_count  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_first))
  (cl::let ((SWIG_arg2 PARM2_count))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawBuffer" "glDrawBuffer")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawElements" "glDrawElements")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_indices  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_type))
  (cl::let ((SWIG_arg3 PARM3_indices))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawPixels" "glDrawPixels")
  ((:p+ PARM0_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (cl::let ((SWIG_arg1 PARM1_height))
  (cl::let ((SWIG_arg2 PARM2_format))
  (cl::let ((SWIG_arg3 PARM3_type))
  (cl::let ((SWIG_arg4 PARM4_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawRangeElements" "glDrawRangeElements")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_start  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_end  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM3_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_indices  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_start))
  (cl::let ((SWIG_arg2 PARM2_end))
  (cl::let ((SWIG_arg3 PARM3_count))
  (cl::let ((SWIG_arg4 PARM4_type))
  (cl::let ((SWIG_arg5 PARM5_indices))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEdgeFlag" "glEdgeFlag")
  ((:p+ PARM0_flag  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_flag))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEdgeFlagPointer" "glEdgeFlagPointer")
  ((:p+ PARM0_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_stride))
  (cl::let ((SWIG_arg1 PARM1_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEdgeFlagv" "glEdgeFlagv")
  ((:p+ PARM0_flag  (* #.(swig-insert-id "GLboolean" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_flag))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEnable" "glEnable")
  ((:p+ PARM0_cap  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_cap))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEnableClientState" "glEnableClientState")
  ((:p+ PARM0_array  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_array))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEnd" "glEnd")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEndList" "glEndList")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1d" "glEvalCoord1d")
  ((:p+ PARM0_u  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1dv" "glEvalCoord1dv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1f" "glEvalCoord1f")
  ((:p+ PARM0_u  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord1fv" "glEvalCoord1fv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2d" "glEvalCoord2d")
  ((:p+ PARM0_u  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_v  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2dv" "glEvalCoord2dv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2f" "glEvalCoord2f")
  ((:p+ PARM0_u  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_v  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalCoord2fv" "glEvalCoord2fv")
  ((:p+ PARM0_u  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_u))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalMesh1" "glEvalMesh1")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_i1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_i2  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_i1))
  (cl::let ((SWIG_arg2 PARM2_i2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalMesh2" "glEvalMesh2")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_i1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_i2  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_j1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_j2  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_i1))
  (cl::let ((SWIG_arg2 PARM2_i2))
  (cl::let ((SWIG_arg3 PARM3_j1))
  (cl::let ((SWIG_arg4 PARM4_j2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalPoint1" "glEvalPoint1")
  ((:p+ PARM0_i  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_i))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEvalPoint2" "glEvalPoint2")
  ((:p+ PARM0_i  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_j  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_i))
  (cl::let ((SWIG_arg1 PARM1_j))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFeedbackBuffer" "glFeedbackBuffer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_buffer  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_buffer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFinish" "glFinish")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFlush" "glFlush")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogf" "glFogf")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogfv" "glFogfv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogi" "glFogi")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogiv" "glFogiv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFrontFace" "glFrontFace")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFrustum" "glFrustum")
  ((:p+ PARM0_left  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_right  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_bottom  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_top  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_zNear  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_zFar  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_left))
  (cl::let ((SWIG_arg1 PARM1_right))
  (cl::let ((SWIG_arg2 PARM2_bottom))
  (cl::let ((SWIG_arg3 PARM3_top))
  (cl::let ((SWIG_arg4 PARM4_zNear))
  (cl::let ((SWIG_arg5 PARM5_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGenLists" "glGenLists")
  ((:p+ PARM0_range  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (#.(swig-insert-id "GLuint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_range))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGenTextures" "glGenTextures")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetBooleanv" "glGetBooleanv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLboolean" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetClipPlane" "glGetClipPlane")
  ((:p+ PARM0_plane  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_equation  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_plane))
  (cl::let ((SWIG_arg1 PARM1_equation))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetColorTable" "glGetColorTable")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_table  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_format))
  (cl::let ((SWIG_arg2 PARM2_type))
  (cl::let ((SWIG_arg3 PARM3_table))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetColorTableParameterfv" "glGetColorTableParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetColorTableParameteriv" "glGetColorTableParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetConvolutionFilter" "glGetConvolutionFilter")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_image  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_format))
  (cl::let ((SWIG_arg2 PARM2_type))
  (cl::let ((SWIG_arg3 PARM3_image))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetConvolutionParameterfv" "glGetConvolutionParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetConvolutionParameteriv" "glGetConvolutionParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetDoublev" "glGetDoublev")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetError" "glGetError")
  (:void)
  (:returning (#.(swig-insert-id "GLenum" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::setq ACL_ffresult (swig-ff-call))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetFloatv" "glGetFloatv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetHistogram" "glGetHistogram")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_reset  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM2_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_values  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_reset))
  (cl::let ((SWIG_arg2 PARM2_format))
  (cl::let ((SWIG_arg3 PARM3_type))
  (cl::let ((SWIG_arg4 PARM4_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetHistogramParameterfv" "glGetHistogramParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetHistogramParameteriv" "glGetHistogramParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetIntegerv" "glGetIntegerv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetLightfv" "glGetLightfv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetLightiv" "glGetLightiv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMapdv" "glGetMapdv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_query  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_query))
  (cl::let ((SWIG_arg2 PARM2_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMapfv" "glGetMapfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_query  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_query))
  (cl::let ((SWIG_arg2 PARM2_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMapiv" "glGetMapiv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_query  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_query))
  (cl::let ((SWIG_arg2 PARM2_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMaterialfv" "glGetMaterialfv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMaterialiv" "glGetMaterialiv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMinmax" "glGetMinmax")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_reset  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM2_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_values  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_reset))
  (cl::let ((SWIG_arg2 PARM2_format))
  (cl::let ((SWIG_arg3 PARM3_type))
  (cl::let ((SWIG_arg4 PARM4_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMinmaxParameterfv" "glGetMinmaxParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetMinmaxParameteriv" "glGetMinmaxParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPixelMapfv" "glGetPixelMapfv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_values  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPixelMapuiv" "glGetPixelMapuiv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_values  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPixelMapusv" "glGetPixelMapusv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_values  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPointerv" "glGetPointerv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* (* #.(swig-insert-id "GLvoid" () :type :type))) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetPolygonStipple" "glGetPolygonStipple")
  ((:p+ PARM0_mask  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetSeparableFilter" "glGetSeparableFilter")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_row  (* #.(swig-insert-id "GLvoid" () :type :type)) )
   (:p+ PARM4_column  (* #.(swig-insert-id "GLvoid" () :type :type)) )
   (:p+ PARM5_span  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_format))
  (cl::let ((SWIG_arg2 PARM2_type))
  (cl::let ((SWIG_arg3 PARM3_row))
  (cl::let ((SWIG_arg4 PARM4_column))
  (cl::let ((SWIG_arg5 PARM5_span))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetString" "glGetString")
  ((:p+ PARM0_name  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* #.(swig-insert-id "GLubyte" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
    (cl:let* ((address (swig-ff-call SWIG_arg0)))
    (cl:setq ACL_ffresult (cl:if (cl:eq address 0) 0
      	     		  	 (excl:native-to-string address))))  )
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexEnvfv" "glGetTexEnvfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexEnviv" "glGetTexEnviv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexGendv" "glGetTexGendv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexGenfv" "glGetTexGenfv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexGeniv" "glGetTexGeniv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexImage" "glGetTexImage")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_format))
  (cl::let ((SWIG_arg3 PARM3_type))
  (cl::let ((SWIG_arg4 PARM4_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexLevelParameterfv" "glGetTexLevelParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_pname))
  (cl::let ((SWIG_arg3 PARM3_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexLevelParameteriv" "glGetTexLevelParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_pname))
  (cl::let ((SWIG_arg3 PARM3_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexParameterfv" "glGetTexParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetTexParameteriv" "glGetTexParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glHint" "glHint")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glHistogram" "glHistogram")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_sink  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_width))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_sink))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexMask" "glIndexMask")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexPointer" "glIndexPointer")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::let ((SWIG_arg1 PARM1_stride))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexd" "glIndexd")
  ((:p+ PARM0_c  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexdv" "glIndexdv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexf" "glIndexf")
  ((:p+ PARM0_c  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexfv" "glIndexfv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexi" "glIndexi")
  ((:p+ PARM0_c  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexiv" "glIndexiv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexs" "glIndexs")
  ((:p+ PARM0_c  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexsv" "glIndexsv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexub" "glIndexub")
  ((:p+ PARM0_c  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIndexubv" "glIndexubv")
  ((:p+ PARM0_c  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_c))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glInitNames" "glInitNames")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glInterleavedArrays" "glInterleavedArrays")
  ((:p+ PARM0_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_format))
  (cl::let ((SWIG_arg1 PARM1_stride))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsEnabled" "glIsEnabled")
  ((:p+ PARM0_cap  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_cap))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsList" "glIsList")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsTexture" "glIsTexture")
  ((:p+ PARM0_texture  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_texture))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModelf" "glLightModelf")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModelfv" "glLightModelfv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModeli" "glLightModeli")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightModeliv" "glLightModeliv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightf" "glLightf")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightfv" "glLightfv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLighti" "glLighti")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLightiv" "glLightiv")
  ((:p+ PARM0_light  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_light))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLineStipple" "glLineStipple")
  ((:p+ PARM0_factor  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_pattern  #.(swig-insert-id "GLushort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_factor))
  (cl::let ((SWIG_arg1 PARM1_pattern))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLineWidth" "glLineWidth")
  ((:p+ PARM0_width  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glListBase" "glListBase")
  ((:p+ PARM0_base  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_base))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadIdentity" "glLoadIdentity")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadMatrixd" "glLoadMatrixd")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadMatrixf" "glLoadMatrixf")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadName" "glLoadName")
  ((:p+ PARM0_name  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLogicOp" "glLogicOp")
  ((:p+ PARM0_opcode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_opcode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap1d" "glMap1d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_order  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_points  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_order))
  (cl::let ((SWIG_arg5 PARM5_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap1f" "glMap1f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_order  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_points  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_order))
  (cl::let ((SWIG_arg5 PARM5_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap2d" "glMap2d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_ustride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_uorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_v1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM6_v2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM7_vstride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM8_vorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_points  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_ustride))
  (cl::let ((SWIG_arg4 PARM4_uorder))
  (cl::let ((SWIG_arg5 PARM5_v1))
  (cl::let ((SWIG_arg6 PARM6_v2))
  (cl::let ((SWIG_arg7 PARM7_vstride))
  (cl::let ((SWIG_arg8 PARM8_vorder))
  (cl::let ((SWIG_arg9 PARM9_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMap2f" "glMap2f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_ustride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_uorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_v1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM6_v2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM7_vstride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM8_vorder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_points  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_ustride))
  (cl::let ((SWIG_arg4 PARM4_uorder))
  (cl::let ((SWIG_arg5 PARM5_v1))
  (cl::let ((SWIG_arg6 PARM6_v2))
  (cl::let ((SWIG_arg7 PARM7_vstride))
  (cl::let ((SWIG_arg8 PARM8_vorder))
  (cl::let ((SWIG_arg9 PARM9_points))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid1d" "glMapGrid1d")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid1f" "glMapGrid1f")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid2d" "glMapGrid2d")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_vn  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_v1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_v2  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_vn))
  (cl::let ((SWIG_arg4 PARM4_v1))
  (cl::let ((SWIG_arg5 PARM5_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapGrid2f" "glMapGrid2f")
  ((:p+ PARM0_un  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_u1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_u2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_vn  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_v1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM5_v2  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_un))
  (cl::let ((SWIG_arg1 PARM1_u1))
  (cl::let ((SWIG_arg2 PARM2_u2))
  (cl::let ((SWIG_arg3 PARM3_vn))
  (cl::let ((SWIG_arg4 PARM4_v1))
  (cl::let ((SWIG_arg5 PARM5_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMaterialf" "glMaterialf")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMaterialfv" "glMaterialfv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMateriali" "glMateriali")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMaterialiv" "glMaterialiv")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMatrixMode" "glMatrixMode")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMinmax" "glMinmax")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_sink  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_sink))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultMatrixd" "glMultMatrixd")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultMatrixf" "glMultMatrixf")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNewList" "glNewList")
  ((:p+ PARM0_list  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_list))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3b" "glNormal3b")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM1_ny  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM2_nz  #.(swig-insert-id "GLbyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3bv" "glNormal3bv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3d" "glNormal3d")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3dv" "glNormal3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3f" "glNormal3f")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3fv" "glNormal3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3i" "glNormal3i")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3iv" "glNormal3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3s" "glNormal3s")
  ((:p+ PARM0_nx  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_ny  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_nz  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nx))
  (cl::let ((SWIG_arg1 PARM1_ny))
  (cl::let ((SWIG_arg2 PARM2_nz))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormal3sv" "glNormal3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glNormalPointer" "glNormalPointer")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::let ((SWIG_arg1 PARM1_stride))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glOrtho" "glOrtho")
  ((:p+ PARM0_left  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_right  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_bottom  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_top  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_zNear  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_zFar  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_left))
  (cl::let ((SWIG_arg1 PARM1_right))
  (cl::let ((SWIG_arg2 PARM2_bottom))
  (cl::let ((SWIG_arg3 PARM3_top))
  (cl::let ((SWIG_arg4 PARM4_zNear))
  (cl::let ((SWIG_arg5 PARM5_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPassThrough" "glPassThrough")
  ((:p+ PARM0_token  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_token))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelMapfv" "glPixelMapfv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mapsize  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_values  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_mapsize))
  (cl::let ((SWIG_arg2 PARM2_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelMapuiv" "glPixelMapuiv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mapsize  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_values  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_mapsize))
  (cl::let ((SWIG_arg2 PARM2_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelMapusv" "glPixelMapusv")
  ((:p+ PARM0_map  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mapsize  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_values  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_map))
  (cl::let ((SWIG_arg1 PARM1_mapsize))
  (cl::let ((SWIG_arg2 PARM2_values))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelStoref" "glPixelStoref")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelStorei" "glPixelStorei")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelTransferf" "glPixelTransferf")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelTransferi" "glPixelTransferi")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPixelZoom" "glPixelZoom")
  ((:p+ PARM0_xfactor  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_yfactor  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_xfactor))
  (cl::let ((SWIG_arg1 PARM1_yfactor))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPointSize" "glPointSize")
  ((:p+ PARM0_size  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPolygonMode" "glPolygonMode")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_mode))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPolygonOffset" "glPolygonOffset")
  ((:p+ PARM0_factor  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_units  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_factor))
  (cl::let ((SWIG_arg1 PARM1_units))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPolygonStipple" "glPolygonStipple")
  ((:p+ PARM0_mask  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopAttrib" "glPopAttrib")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopClientAttrib" "glPopClientAttrib")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopMatrix" "glPopMatrix")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPopName" "glPopName")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPrioritizeTextures" "glPrioritizeTextures")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_textures  (* #.(swig-insert-id "GLuint" () :type :type)) )
   (:p+ PARM2_priorities  (* #.(swig-insert-id "GLclampf" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_textures))
  (cl::let ((SWIG_arg2 PARM2_priorities))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushAttrib" "glPushAttrib")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLbitfield" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushClientAttrib" "glPushClientAttrib")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLbitfield" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushMatrix" "glPushMatrix")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPushName" "glPushName")
  ((:p+ PARM0_name  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2d" "glRasterPos2d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2dv" "glRasterPos2dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2f" "glRasterPos2f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2fv" "glRasterPos2fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2i" "glRasterPos2i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2iv" "glRasterPos2iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2s" "glRasterPos2s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos2sv" "glRasterPos2sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3d" "glRasterPos3d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3dv" "glRasterPos3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3f" "glRasterPos3f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3fv" "glRasterPos3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3i" "glRasterPos3i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3iv" "glRasterPos3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3s" "glRasterPos3s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos3sv" "glRasterPos3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4d" "glRasterPos4d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4dv" "glRasterPos4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4f" "glRasterPos4f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4fv" "glRasterPos4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4i" "glRasterPos4i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4iv" "glRasterPos4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4s" "glRasterPos4s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRasterPos4sv" "glRasterPos4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glReadBuffer" "glReadBuffer")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glReadPixels" "glReadPixels")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectd" "glRectd")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectdv" "glRectdv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectf" "glRectf")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectfv" "glRectfv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRecti" "glRecti")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectiv" "glRectiv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRects" "glRects")
  ((:p+ PARM0_x1  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y1  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_x2  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_y2  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x1))
  (cl::let ((SWIG_arg1 PARM1_y1))
  (cl::let ((SWIG_arg2 PARM2_x2))
  (cl::let ((SWIG_arg3 PARM3_y2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRectsv" "glRectsv")
  ((:p+ PARM0_v1  (* #.(swig-insert-id "GLshort" () :type :type)) )
   (:p+ PARM1_v2  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v1))
  (cl::let ((SWIG_arg1 PARM1_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRenderMode" "glRenderMode")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glResetHistogram" "glResetHistogram")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glResetMinmax" "glResetMinmax")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRotated" "glRotated")
  ((:p+ PARM0_angle  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_angle))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glRotatef" "glRotatef")
  ((:p+ PARM0_angle  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_angle))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glScaled" "glScaled")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glScalef" "glScalef")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glScissor" "glScissor")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSelectBuffer" "glSelectBuffer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_buffer  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_buffer))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSeparableFilter2D" "glSeparableFilter2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_row  (* #.(swig-insert-id "GLvoid" () :type :type)) )
   (:p+ PARM7_column  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_row))
  (cl::let ((SWIG_arg7 PARM7_column))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glShadeModel" "glShadeModel")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilFunc" "glStencilFunc")
  ((:p+ PARM0_func  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_ref  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (cl::let ((SWIG_arg1 PARM1_ref))
  (cl::let ((SWIG_arg2 PARM2_mask))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilMask" "glStencilMask")
  ((:p+ PARM0_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mask))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilOp" "glStencilOp")
  ((:p+ PARM0_fail  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_zfail  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_zpass  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_fail))
  (cl::let ((SWIG_arg1 PARM1_zfail))
  (cl::let ((SWIG_arg2 PARM2_zpass))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1d" "glTexCoord1d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1dv" "glTexCoord1dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1f" "glTexCoord1f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1fv" "glTexCoord1fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1i" "glTexCoord1i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1iv" "glTexCoord1iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1s" "glTexCoord1s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord1sv" "glTexCoord1sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2d" "glTexCoord2d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2dv" "glTexCoord2dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2f" "glTexCoord2f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2fv" "glTexCoord2fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2i" "glTexCoord2i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2iv" "glTexCoord2iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2s" "glTexCoord2s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord2sv" "glTexCoord2sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3d" "glTexCoord3d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3dv" "glTexCoord3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3f" "glTexCoord3f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3fv" "glTexCoord3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3i" "glTexCoord3i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3iv" "glTexCoord3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3s" "glTexCoord3s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord3sv" "glTexCoord3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4d" "glTexCoord4d")
  ((:p+ PARM0_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4dv" "glTexCoord4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4f" "glTexCoord4f")
  ((:p+ PARM0_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4fv" "glTexCoord4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4i" "glTexCoord4i")
  ((:p+ PARM0_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4iv" "glTexCoord4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4s" "glTexCoord4s")
  ((:p+ PARM0_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_t  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_r  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_q  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_s))
  (cl::let ((SWIG_arg1 PARM1_t))
  (cl::let ((SWIG_arg2 PARM2_r))
  (cl::let ((SWIG_arg3 PARM3_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoord4sv" "glTexCoord4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexCoordPointer" "glTexCoordPointer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_stride))
  (cl::let ((SWIG_arg3 PARM3_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnvf" "glTexEnvf")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnvfv" "glTexEnvfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnvi" "glTexEnvi")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexEnviv" "glTexEnviv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGend" "glTexGend")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGendv" "glTexGendv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGenf" "glTexGenf")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGenfv" "glTexGenfv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGeni" "glTexGeni")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexGeniv" "glTexGeniv")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexImage1D" "glTexImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_border))
  (cl::let ((SWIG_arg5 PARM5_format))
  (cl::let ((SWIG_arg6 PARM6_type))
  (cl::let ((SWIG_arg7 PARM7_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexImage2D" "glTexImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM8_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_height))
  (cl::let ((SWIG_arg5 PARM5_border))
  (cl::let ((SWIG_arg6 PARM6_format))
  (cl::let ((SWIG_arg7 PARM7_type))
  (cl::let ((SWIG_arg8 PARM8_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexImage3D" "glTexImage3D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_depth  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM8_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM9_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_height))
  (cl::let ((SWIG_arg5 PARM5_depth))
  (cl::let ((SWIG_arg6 PARM6_border))
  (cl::let ((SWIG_arg7 PARM7_format))
  (cl::let ((SWIG_arg8 PARM8_type))
  (cl::let ((SWIG_arg9 PARM9_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameterf" "glTexParameterf")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameterfv" "glTexParameterfv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameteri" "glTexParameteri")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexParameteriv" "glTexParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexSubImage1D" "glTexSubImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexSubImage2D" "glTexSubImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM8_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_width))
  (cl::let ((SWIG_arg5 PARM5_height))
  (cl::let ((SWIG_arg6 PARM6_format))
  (cl::let ((SWIG_arg7 PARM7_type))
  (cl::let ((SWIG_arg8 PARM8_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTexSubImage3D" "glTexSubImage3D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_zoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_depth  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM8_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM9_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM10_pixels  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_zoffset))
  (cl::let ((SWIG_arg5 PARM5_width))
  (cl::let ((SWIG_arg6 PARM6_height))
  (cl::let ((SWIG_arg7 PARM7_depth))
  (cl::let ((SWIG_arg8 PARM8_format))
  (cl::let ((SWIG_arg9 PARM9_type))
  (cl::let ((SWIG_arg10 PARM10_pixels))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9 SWIG_arg10))))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTranslated" "glTranslated")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glTranslatef" "glTranslatef")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2d" "glVertex2d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2dv" "glVertex2dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2f" "glVertex2f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2fv" "glVertex2fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2i" "glVertex2i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2iv" "glVertex2iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2s" "glVertex2s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex2sv" "glVertex2sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3d" "glVertex3d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3dv" "glVertex3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3f" "glVertex3f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3fv" "glVertex3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3i" "glVertex3i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3iv" "glVertex3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3s" "glVertex3s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex3sv" "glVertex3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4d" "glVertex4d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4dv" "glVertex4dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4f" "glVertex4f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4fv" "glVertex4fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4i" "glVertex4i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4iv" "glVertex4iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4s" "glVertex4s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_w  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (cl::let ((SWIG_arg3 PARM3_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertex4sv" "glVertex4sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexPointer" "glVertexPointer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_stride))
  (cl::let ((SWIG_arg3 PARM3_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glViewport" "glViewport")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSampleCoverage" "glSampleCoverage")
  ((:p+ PARM0_value  #.(swig-insert-id "GLclampf" () :type :type) )
   (:p+ PARM1_invert  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_value))
  (cl::let ((SWIG_arg1 PARM1_invert))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSamplePass" "glSamplePass")
  ((:p+ PARM0_pass  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pass))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadTransposeMatrixf" "glLoadTransposeMatrixf")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLoadTransposeMatrixd" "glLoadTransposeMatrixd")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultTransposeMatrixf" "glMultTransposeMatrixf")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultTransposeMatrixd" "glMultTransposeMatrixd")
  ((:p+ PARM0_m  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_m))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCompressedTexImage3D" "glCompressedTexImage3D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_depth  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_imageSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM8_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_height))
  (cl::let ((SWIG_arg5 PARM5_depth))
  (cl::let ((SWIG_arg6 PARM6_border))
  (cl::let ((SWIG_arg7 PARM7_imageSize))
  (cl::let ((SWIG_arg8 PARM8_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCompressedTexImage2D" "glCompressedTexImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_imageSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_height))
  (cl::let ((SWIG_arg5 PARM5_border))
  (cl::let ((SWIG_arg6 PARM6_imageSize))
  (cl::let ((SWIG_arg7 PARM7_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCompressedTexImage1D" "glCompressedTexImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_border  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_imageSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_internalformat))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_border))
  (cl::let ((SWIG_arg5 PARM5_imageSize))
  (cl::let ((SWIG_arg6 PARM6_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCompressedTexSubImage3D" "glCompressedTexSubImage3D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_zoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_depth  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM8_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM9_imageSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM10_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_zoffset))
  (cl::let ((SWIG_arg5 PARM5_width))
  (cl::let ((SWIG_arg6 PARM6_height))
  (cl::let ((SWIG_arg7 PARM7_depth))
  (cl::let ((SWIG_arg8 PARM8_format))
  (cl::let ((SWIG_arg9 PARM9_imageSize))
  (cl::let ((SWIG_arg10 PARM10_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9 SWIG_arg10))))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCompressedTexSubImage2D" "glCompressedTexSubImage2D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_yoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_imageSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM8_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_yoffset))
  (cl::let ((SWIG_arg4 PARM4_width))
  (cl::let ((SWIG_arg5 PARM5_height))
  (cl::let ((SWIG_arg6 PARM6_format))
  (cl::let ((SWIG_arg7 PARM7_imageSize))
  (cl::let ((SWIG_arg8 PARM8_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCompressedTexSubImage1D" "glCompressedTexSubImage1D")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_xoffset  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_imageSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_level))
  (cl::let ((SWIG_arg2 PARM2_xoffset))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_imageSize))
  (cl::let ((SWIG_arg6 PARM6_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetCompressedTexImage" "glGetCompressedTexImage")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_lod  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_img  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_lod))
  (cl::let ((SWIG_arg2 PARM2_img))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glActiveTexture" "glActiveTexture")
  ((:p+ PARM0_texture  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_texture))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glClientActiveTexture" "glClientActiveTexture")
  ((:p+ PARM0_texture  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_texture))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1d" "glMultiTexCoord1d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1dv" "glMultiTexCoord1dv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1f" "glMultiTexCoord1f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1fv" "glMultiTexCoord1fv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1i" "glMultiTexCoord1i")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1iv" "glMultiTexCoord1iv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1s" "glMultiTexCoord1s")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord1sv" "glMultiTexCoord1sv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2d" "glMultiTexCoord2d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2dv" "glMultiTexCoord2dv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2f" "glMultiTexCoord2f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2fv" "glMultiTexCoord2fv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2i" "glMultiTexCoord2i")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2iv" "glMultiTexCoord2iv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2s" "glMultiTexCoord2s")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord2sv" "glMultiTexCoord2sv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3d" "glMultiTexCoord3d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_r  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (cl::let ((SWIG_arg3 PARM3_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3dv" "glMultiTexCoord3dv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3f" "glMultiTexCoord3f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_r  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (cl::let ((SWIG_arg3 PARM3_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3fv" "glMultiTexCoord3fv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3i" "glMultiTexCoord3i")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_r  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (cl::let ((SWIG_arg3 PARM3_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3iv" "glMultiTexCoord3iv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3s" "glMultiTexCoord3s")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_r  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (cl::let ((SWIG_arg3 PARM3_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord3sv" "glMultiTexCoord3sv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4d" "glMultiTexCoord4d")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_r  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_q  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (cl::let ((SWIG_arg3 PARM3_r))
  (cl::let ((SWIG_arg4 PARM4_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4dv" "glMultiTexCoord4dv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4f" "glMultiTexCoord4f")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_r  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM4_q  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (cl::let ((SWIG_arg3 PARM3_r))
  (cl::let ((SWIG_arg4 PARM4_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4fv" "glMultiTexCoord4fv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4i" "glMultiTexCoord4i")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_arg2  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_s  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_t  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_r  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_arg2))
  (cl::let ((SWIG_arg2 PARM2_s))
  (cl::let ((SWIG_arg3 PARM3_t))
  (cl::let ((SWIG_arg4 PARM4_r))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4iv" "glMultiTexCoord4iv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4s" "glMultiTexCoord4s")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_s  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_t  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_r  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM4_q  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_s))
  (cl::let ((SWIG_arg2 PARM2_t))
  (cl::let ((SWIG_arg3 PARM3_r))
  (cl::let ((SWIG_arg4 PARM4_q))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiTexCoord4sv" "glMultiTexCoord4sv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogCoordf" "glFogCoordf")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogCoordfv" "glFogCoordfv")
  ((:p+ PARM0_coord  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogCoordd" "glFogCoordd")
  ((:p+ PARM0_coord  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogCoorddv" "glFogCoorddv")
  ((:p+ PARM0_coord  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_coord))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glFogCoordPointer" "glFogCoordPointer")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::let ((SWIG_arg1 PARM1_stride))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3b" "glSecondaryColor3b")
  ((:p+ PARM0_red  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLbyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLbyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3bv" "glSecondaryColor3bv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3d" "glSecondaryColor3d")
  ((:p+ PARM0_red  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3dv" "glSecondaryColor3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3f" "glSecondaryColor3f")
  ((:p+ PARM0_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3fv" "glSecondaryColor3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3i" "glSecondaryColor3i")
  ((:p+ PARM0_red  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3iv" "glSecondaryColor3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3s" "glSecondaryColor3s")
  ((:p+ PARM0_red  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3sv" "glSecondaryColor3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3ub" "glSecondaryColor3ub")
  ((:p+ PARM0_red  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM1_green  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM2_blue  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3ubv" "glSecondaryColor3ubv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3ui" "glSecondaryColor3ui")
  ((:p+ PARM0_red  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3uiv" "glSecondaryColor3uiv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3us" "glSecondaryColor3us")
  ((:p+ PARM0_red  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM1_green  #.(swig-insert-id "GLushort" () :type :type) )
   (:p+ PARM2_blue  #.(swig-insert-id "GLushort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_red))
  (cl::let ((SWIG_arg1 PARM1_green))
  (cl::let ((SWIG_arg2 PARM2_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColor3usv" "glSecondaryColor3usv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glSecondaryColorPointer" "glSecondaryColorPointer")
  ((:p+ PARM0_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (cl::let ((SWIG_arg1 PARM1_type))
  (cl::let ((SWIG_arg2 PARM2_stride))
  (cl::let ((SWIG_arg3 PARM3_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPointParameterf" "glPointParameterf")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPointParameterfv" "glPointParameterfv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPointParameteri" "glPointParameteri")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_param  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_param))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glPointParameteriv" "glPointParameteriv")
  ((:p+ PARM0_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_pname))
  (cl::let ((SWIG_arg1 PARM1_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBlendFuncSeparate" "glBlendFuncSeparate")
  ((:p+ PARM0_srcRGB  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_dstRGB  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_srcAlpha  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_dstAlpha  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_srcRGB))
  (cl::let ((SWIG_arg1 PARM1_dstRGB))
  (cl::let ((SWIG_arg2 PARM2_srcAlpha))
  (cl::let ((SWIG_arg3 PARM3_dstAlpha))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiDrawArrays" "glMultiDrawArrays")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_first  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM2_count  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM3_primcount  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_first))
  (cl::let ((SWIG_arg2 PARM2_count))
  (cl::let ((SWIG_arg3 PARM3_primcount))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMultiDrawElements" "glMultiDrawElements")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_count  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM2_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_indices  (* (* #.(swig-insert-id "GLvoid" () :type :type))) )
   (:p+ PARM4_primcount  #.(swig-insert-id "GLsizei" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_type))
  (cl::let ((SWIG_arg3 PARM3_indices))
  (cl::let ((SWIG_arg4 PARM4_primcount))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2d" "glWindowPos2d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2dv" "glWindowPos2dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2f" "glWindowPos2f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2fv" "glWindowPos2fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2i" "glWindowPos2i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2iv" "glWindowPos2iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2s" "glWindowPos2s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos2sv" "glWindowPos2sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3d" "glWindowPos3d")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3dv" "glWindowPos3dv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3f" "glWindowPos3f")
  ((:p+ PARM0_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3fv" "glWindowPos3fv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3i" "glWindowPos3i")
  ((:p+ PARM0_x  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3iv" "glWindowPos3iv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3s" "glWindowPos3s")
  ((:p+ PARM0_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_z  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glWindowPos3sv" "glWindowPos3sv")
  ((:p+ PARM0_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_v))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGenQueries" "glGenQueries")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_ids  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_ids))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteQueries" "glDeleteQueries")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_ids  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_ids))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsQuery" "glIsQuery")
  ((:p+ PARM0_id  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_id))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBeginQuery" "glBeginQuery")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_id  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_id))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEndQuery" "glEndQuery")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetQueryiv" "glGetQueryiv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetQueryObjectiv" "glGetQueryObjectiv")
  ((:p+ PARM0_id  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_id))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetQueryObjectuiv" "glGetQueryObjectuiv")
  ((:p+ PARM0_id  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_id))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBindBuffer" "glBindBuffer")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_buffer  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_buffer))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteBuffers" "glDeleteBuffers")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_buffers  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_buffers))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGenBuffers" "glGenBuffers")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_buffers  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_buffers))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsBuffer" "glIsBuffer")
  ((:p+ PARM0_buffer  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_buffer))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBufferData" "glBufferData")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_size  #.(swig-insert-id "GLsizeiptr" () :type :type) )
   (:p+ PARM2_data  (* #.(swig-insert-id "GLvoid" () :type :type)) )
   (:p+ PARM3_usage  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_size))
  (cl::let ((SWIG_arg2 PARM2_data))
  (cl::let ((SWIG_arg3 PARM3_usage))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBufferSubData" "glBufferSubData")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_offset  #.(swig-insert-id "GLintptr" () :type :type) )
   (:p+ PARM2_size  #.(swig-insert-id "GLsizeiptr" () :type :type) )
   (:p+ PARM3_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_offset))
  (cl::let ((SWIG_arg2 PARM2_size))
  (cl::let ((SWIG_arg3 PARM3_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetBufferSubData" "glGetBufferSubData")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_offset  #.(swig-insert-id "GLintptr" () :type :type) )
   (:p+ PARM2_size  #.(swig-insert-id "GLsizeiptr" () :type :type) )
   (:p+ PARM3_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_offset))
  (cl::let ((SWIG_arg2 PARM2_size))
  (cl::let ((SWIG_arg3 PARM3_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glMapBuffer" "glMapBuffer")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_access  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* #.(swig-insert-id "GLvoid" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_access))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUnmapBuffer" "glUnmapBuffer")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetBufferParameteriv" "glGetBufferParameteriv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetBufferPointerv" "glGetBufferPointerv")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* (* #.(swig-insert-id "GLvoid" () :type :type))) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDrawBuffers" "glDrawBuffers")
  ((:p+ PARM0_n  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM1_bufs  (* #.(swig-insert-id "GLenum" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_n))
  (cl::let ((SWIG_arg1 PARM1_bufs))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib1d" "glVertexAttrib1d")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib1dv" "glVertexAttrib1dv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib1f" "glVertexAttrib1f")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib1fv" "glVertexAttrib1fv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib1s" "glVertexAttrib1s")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib1sv" "glVertexAttrib1sv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib2d" "glVertexAttrib2d")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib2dv" "glVertexAttrib2dv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib2f" "glVertexAttrib2f")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib2fv" "glVertexAttrib2fv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib2s" "glVertexAttrib2s")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib2sv" "glVertexAttrib2sv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib3d" "glVertexAttrib3d")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib3dv" "glVertexAttrib3dv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib3f" "glVertexAttrib3f")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib3fv" "glVertexAttrib3fv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib3s" "glVertexAttrib3s")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib3sv" "glVertexAttrib3sv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4Nbv" "glVertexAttrib4Nbv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4Niv" "glVertexAttrib4Niv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4Nsv" "glVertexAttrib4Nsv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4Nub" "glVertexAttrib4Nub")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM2_y  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM3_z  #.(swig-insert-id "GLubyte" () :type :type) cl:integer)
   (:p+ PARM4_w  #.(swig-insert-id "GLubyte" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (cl::let ((SWIG_arg4 PARM4_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4Nubv" "glVertexAttrib4Nubv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4Nuiv" "glVertexAttrib4Nuiv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4Nusv" "glVertexAttrib4Nusv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4bv" "glVertexAttrib4bv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLbyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4d" "glVertexAttrib4d")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_w  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (cl::let ((SWIG_arg4 PARM4_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4dv" "glVertexAttrib4dv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4f" "glVertexAttrib4f")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM4_w  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (cl::let ((SWIG_arg4 PARM4_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4fv" "glVertexAttrib4fv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4iv" "glVertexAttrib4iv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4s" "glVertexAttrib4s")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_x  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM2_y  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM3_z  #.(swig-insert-id "GLshort" () :type :type) )
   (:p+ PARM4_w  #.(swig-insert-id "GLshort" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_z))
  (cl::let ((SWIG_arg4 PARM4_w))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4sv" "glVertexAttrib4sv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLshort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4ubv" "glVertexAttrib4ubv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4uiv" "glVertexAttrib4uiv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttrib4usv" "glVertexAttrib4usv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_v  (* #.(swig-insert-id "GLushort" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_v))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glVertexAttribPointer" "glVertexAttribPointer")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_size  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_normalized  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM4_stride  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_pointer  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_size))
  (cl::let ((SWIG_arg2 PARM2_type))
  (cl::let ((SWIG_arg3 PARM3_normalized))
  (cl::let ((SWIG_arg4 PARM4_stride))
  (cl::let ((SWIG_arg5 PARM5_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glEnableVertexAttribArray" "glEnableVertexAttribArray")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDisableVertexAttribArray" "glDisableVertexAttribArray")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetVertexAttribdv" "glGetVertexAttribdv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetVertexAttribfv" "glGetVertexAttribfv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetVertexAttribiv" "glGetVertexAttribiv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetVertexAttribPointerv" "glGetVertexAttribPointerv")
  ((:p+ PARM0_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_pointer  (* (* #.(swig-insert-id "GLvoid" () :type :type))) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_index))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_pointer))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteShader" "glDeleteShader")
  ((:p+ PARM0_shader  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_shader))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDetachShader" "glDetachShader")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_shader  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_shader))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCreateShader" "glCreateShader")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (#.(swig-insert-id "GLuint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glShaderSource" "glShaderSource")
  ((:p+ PARM0_shader  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_string  (* (* #.(swig-insert-id "GLchar" () :type :type))) )
   (:p+ PARM3_length  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_shader))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_string))
  (cl::let ((SWIG_arg3 PARM3_length))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCompileShader" "glCompileShader")
  ((:p+ PARM0_shader  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_shader))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glCreateProgram" "glCreateProgram")
  (:void)
  (:returning (#.(swig-insert-id "GLuint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::setq ACL_ffresult (swig-ff-call))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glAttachShader" "glAttachShader")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_shader  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_shader))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glLinkProgram" "glLinkProgram")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUseProgram" "glUseProgram")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glDeleteProgram" "glDeleteProgram")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glValidateProgram" "glValidateProgram")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform1f" "glUniform1f")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform2f" "glUniform2f")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_v1  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (cl::let ((SWIG_arg2 PARM2_v1))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform3f" "glUniform3f")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_v1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_v2  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (cl::let ((SWIG_arg2 PARM2_v1))
  (cl::let ((SWIG_arg3 PARM3_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform4f" "glUniform4f")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_v1  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_v2  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM4_v3  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (cl::let ((SWIG_arg2 PARM2_v1))
  (cl::let ((SWIG_arg3 PARM3_v2))
  (cl::let ((SWIG_arg4 PARM4_v3))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform1i" "glUniform1i")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform2i" "glUniform2i")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_v1  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (cl::let ((SWIG_arg2 PARM2_v1))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform3i" "glUniform3i")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_v1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_v2  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (cl::let ((SWIG_arg2 PARM2_v1))
  (cl::let ((SWIG_arg3 PARM3_v2))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform4i" "glUniform4i")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_v0  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_v1  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_v2  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_v3  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_v0))
  (cl::let ((SWIG_arg2 PARM2_v1))
  (cl::let ((SWIG_arg3 PARM3_v2))
  (cl::let ((SWIG_arg4 PARM4_v3))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform1fv" "glUniform1fv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform2fv" "glUniform2fv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform3fv" "glUniform3fv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform4fv" "glUniform4fv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform1iv" "glUniform1iv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform2iv" "glUniform2iv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform3iv" "glUniform3iv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniform4iv" "glUniform4iv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_value  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniformMatrix2fv" "glUniformMatrix2fv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_transpose  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM3_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_transpose))
  (cl::let ((SWIG_arg3 PARM3_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniformMatrix3fv" "glUniformMatrix3fv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_transpose  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM3_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_transpose))
  (cl::let ((SWIG_arg3 PARM3_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glUniformMatrix4fv" "glUniformMatrix4fv")
  ((:p+ PARM0_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM1_count  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_transpose  #.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   (:p+ PARM3_value  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_location))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_transpose))
  (cl::let ((SWIG_arg3 PARM3_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsShader" "glIsShader")
  ((:p+ PARM0_shader  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_shader))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glIsProgram" "glIsProgram")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetShaderiv" "glGetShaderiv")
  ((:p+ PARM0_shader  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_shader))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetProgramiv" "glGetProgramiv")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_pname  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_pname))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetAttachedShaders" "glGetAttachedShaders")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_maxCount  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_count  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM3_shaders  (* #.(swig-insert-id "GLuint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_maxCount))
  (cl::let ((SWIG_arg2 PARM2_count))
  (cl::let ((SWIG_arg3 PARM3_shaders))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetShaderInfoLog" "glGetShaderInfoLog")
  ((:p+ PARM0_shader  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_bufSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_length  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM3_infoLog  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_shader))
  (cl::let ((SWIG_arg1 PARM1_bufSize))
  (cl::let ((SWIG_arg2 PARM2_length))
  (cl::let ((SWIG_arg3 PARM3_infoLog))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetProgramInfoLog" "glGetProgramInfoLog")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_bufSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_length  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM3_infoLog  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_bufSize))
  (cl::let ((SWIG_arg2 PARM2_length))
  (cl::let ((SWIG_arg3 PARM3_infoLog))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetUniformLocation" "glGetUniformLocation")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_name  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_name))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetActiveUniform" "glGetActiveUniform")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_bufSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_length  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM4_size  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM5_type  (* #.(swig-insert-id "GLenum" () :type :type)) )
   (:p+ PARM6_name  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_index))
  (cl::let ((SWIG_arg2 PARM2_bufSize))
  (cl::let ((SWIG_arg3 PARM3_length))
  (cl::let ((SWIG_arg4 PARM4_size))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_name))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetUniformfv" "glGetUniformfv")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_location))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetUniformiv" "glGetUniformiv")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_location  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_params  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_location))
  (cl::let ((SWIG_arg2 PARM2_params))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetShaderSource" "glGetShaderSource")
  ((:p+ PARM0_shader  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_bufSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_length  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM3_source  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_shader))
  (cl::let ((SWIG_arg1 PARM1_bufSize))
  (cl::let ((SWIG_arg2 PARM2_length))
  (cl::let ((SWIG_arg3 PARM3_source))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glBindAttribLocation" "glBindAttribLocation")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_name  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_index))
  (cl::let ((SWIG_arg2 PARM2_name))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetActiveAttrib" "glGetActiveAttrib")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_index  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM2_bufSize  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_length  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM4_size  (* #.(swig-insert-id "GLsizei" () :type :type)) )
   (:p+ PARM5_type  (* #.(swig-insert-id "GLenum" () :type :type)) )
   (:p+ PARM6_name  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_index))
  (cl::let ((SWIG_arg2 PARM2_bufSize))
  (cl::let ((SWIG_arg3 PARM3_length))
  (cl::let ((SWIG_arg4 PARM4_size))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_name))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glGetAttribLocation" "glGetAttribLocation")
  ((:p+ PARM0_program  #.(swig-insert-id "GLuint" () :type :type) )
   (:p+ PARM1_name  (* #.(swig-insert-id "GLchar" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_program))
  (cl::let ((SWIG_arg1 PARM1_name))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilFuncSeparate" "glStencilFuncSeparate")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_func  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_ref  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_func))
  (cl::let ((SWIG_arg2 PARM2_ref))
  (cl::let ((SWIG_arg3 PARM3_mask))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilOpSeparate" "glStencilOpSeparate")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_fail  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_zfail  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM3_zpass  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_fail))
  (cl::let ((SWIG_arg2 PARM2_zfail))
  (cl::let ((SWIG_arg3 PARM3_zpass))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glStencilMaskSeparate" "glStencilMaskSeparate")
  ((:p+ PARM0_face  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_mask  #.(swig-insert-id "GLuint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_face))
  (cl::let ((SWIG_arg1 PARM1_mask))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defconstant "GLU_EXT_object_space_tess" 1)
(swig-defconstant "GLU_EXT_nurbs_tessellator" 1)
(swig-defconstant "GLU_FALSE" 0)
(swig-defconstant "GLU_TRUE" 1)
(swig-defconstant "GLU_VERSION_1_1" 1)
(swig-defconstant "GLU_VERSION_1_2" 1)
(swig-defconstant "GLU_VERSION_1_3" 1)
(swig-defconstant "GLU_VERSION" 100800)
(swig-defconstant "GLU_EXTENSIONS" 100801)
(swig-defconstant "GLU_INVALID_ENUM" 100900)
(swig-defconstant "GLU_INVALID_VALUE" 100901)
(swig-defconstant "GLU_OUT_OF_MEMORY" 100902)
(swig-defconstant "GLU_INCOMPATIBLE_GL_VERSION" 100903)
(swig-defconstant "GLU_INVALID_OPERATION" 100904)
(swig-defconstant "GLU_OUTLINE_POLYGON" 100240)
(swig-defconstant "GLU_OUTLINE_PATCH" 100241)
(swig-defconstant "GLU_NURBS_ERROR" 100103)
(swig-defconstant "GLU_ERROR" 100103)
(swig-defconstant "GLU_NURBS_BEGIN" 100164)
(swig-defconstant "GLU_NURBS_BEGIN_EXT" 100164)
(swig-defconstant "GLU_NURBS_VERTEX" 100165)
(swig-defconstant "GLU_NURBS_VERTEX_EXT" 100165)
(swig-defconstant "GLU_NURBS_NORMAL" 100166)
(swig-defconstant "GLU_NURBS_NORMAL_EXT" 100166)
(swig-defconstant "GLU_NURBS_COLOR" 100167)
(swig-defconstant "GLU_NURBS_COLOR_EXT" 100167)
(swig-defconstant "GLU_NURBS_TEXTURE_COORD" 100168)
(swig-defconstant "GLU_NURBS_TEX_COORD_EXT" 100168)
(swig-defconstant "GLU_NURBS_END" 100169)
(swig-defconstant "GLU_NURBS_END_EXT" 100169)
(swig-defconstant "GLU_NURBS_BEGIN_DATA" 100170)
(swig-defconstant "GLU_NURBS_BEGIN_DATA_EXT" 100170)
(swig-defconstant "GLU_NURBS_VERTEX_DATA" 100171)
(swig-defconstant "GLU_NURBS_VERTEX_DATA_EXT" 100171)
(swig-defconstant "GLU_NURBS_NORMAL_DATA" 100172)
(swig-defconstant "GLU_NURBS_NORMAL_DATA_EXT" 100172)
(swig-defconstant "GLU_NURBS_COLOR_DATA" 100173)
(swig-defconstant "GLU_NURBS_COLOR_DATA_EXT" 100173)
(swig-defconstant "GLU_NURBS_TEXTURE_COORD_DATA" 100174)
(swig-defconstant "GLU_NURBS_TEX_COORD_DATA_EXT" 100174)
(swig-defconstant "GLU_NURBS_END_DATA" 100175)
(swig-defconstant "GLU_NURBS_END_DATA_EXT" 100175)
(swig-defconstant "GLU_NURBS_ERROR1" 100251)
(swig-defconstant "GLU_NURBS_ERROR2" 100252)
(swig-defconstant "GLU_NURBS_ERROR3" 100253)
(swig-defconstant "GLU_NURBS_ERROR4" 100254)
(swig-defconstant "GLU_NURBS_ERROR5" 100255)
(swig-defconstant "GLU_NURBS_ERROR6" 100256)
(swig-defconstant "GLU_NURBS_ERROR7" 100257)
(swig-defconstant "GLU_NURBS_ERROR8" 100258)
(swig-defconstant "GLU_NURBS_ERROR9" 100259)
(swig-defconstant "GLU_NURBS_ERROR10" 100260)
(swig-defconstant "GLU_NURBS_ERROR11" 100261)
(swig-defconstant "GLU_NURBS_ERROR12" 100262)
(swig-defconstant "GLU_NURBS_ERROR13" 100263)
(swig-defconstant "GLU_NURBS_ERROR14" 100264)
(swig-defconstant "GLU_NURBS_ERROR15" 100265)
(swig-defconstant "GLU_NURBS_ERROR16" 100266)
(swig-defconstant "GLU_NURBS_ERROR17" 100267)
(swig-defconstant "GLU_NURBS_ERROR18" 100268)
(swig-defconstant "GLU_NURBS_ERROR19" 100269)
(swig-defconstant "GLU_NURBS_ERROR20" 100270)
(swig-defconstant "GLU_NURBS_ERROR21" 100271)
(swig-defconstant "GLU_NURBS_ERROR22" 100272)
(swig-defconstant "GLU_NURBS_ERROR23" 100273)
(swig-defconstant "GLU_NURBS_ERROR24" 100274)
(swig-defconstant "GLU_NURBS_ERROR25" 100275)
(swig-defconstant "GLU_NURBS_ERROR26" 100276)
(swig-defconstant "GLU_NURBS_ERROR27" 100277)
(swig-defconstant "GLU_NURBS_ERROR28" 100278)
(swig-defconstant "GLU_NURBS_ERROR29" 100279)
(swig-defconstant "GLU_NURBS_ERROR30" 100280)
(swig-defconstant "GLU_NURBS_ERROR31" 100281)
(swig-defconstant "GLU_NURBS_ERROR32" 100282)
(swig-defconstant "GLU_NURBS_ERROR33" 100283)
(swig-defconstant "GLU_NURBS_ERROR34" 100284)
(swig-defconstant "GLU_NURBS_ERROR35" 100285)
(swig-defconstant "GLU_NURBS_ERROR36" 100286)
(swig-defconstant "GLU_NURBS_ERROR37" 100287)
(swig-defconstant "GLU_AUTO_LOAD_MATRIX" 100200)
(swig-defconstant "GLU_CULLING" 100201)
(swig-defconstant "GLU_SAMPLING_TOLERANCE" 100203)
(swig-defconstant "GLU_DISPLAY_MODE" 100204)
(swig-defconstant "GLU_PARAMETRIC_TOLERANCE" 100202)
(swig-defconstant "GLU_SAMPLING_METHOD" 100205)
(swig-defconstant "GLU_U_STEP" 100206)
(swig-defconstant "GLU_V_STEP" 100207)
(swig-defconstant "GLU_NURBS_MODE" 100160)
(swig-defconstant "GLU_NURBS_MODE_EXT" 100160)
(swig-defconstant "GLU_NURBS_TESSELLATOR" 100161)
(swig-defconstant "GLU_NURBS_TESSELLATOR_EXT" 100161)
(swig-defconstant "GLU_NURBS_RENDERER" 100162)
(swig-defconstant "GLU_NURBS_RENDERER_EXT" 100162)
(swig-defconstant "GLU_OBJECT_PARAMETRIC_ERROR" 100208)
(swig-defconstant "GLU_OBJECT_PARAMETRIC_ERROR_EXT" 100208)
(swig-defconstant "GLU_OBJECT_PATH_LENGTH" 100209)
(swig-defconstant "GLU_OBJECT_PATH_LENGTH_EXT" 100209)
(swig-defconstant "GLU_PATH_LENGTH" 100215)
(swig-defconstant "GLU_PARAMETRIC_ERROR" 100216)
(swig-defconstant "GLU_DOMAIN_DISTANCE" 100217)
(swig-defconstant "GLU_MAP1_TRIM_2" 100210)
(swig-defconstant "GLU_MAP1_TRIM_3" 100211)
(swig-defconstant "GLU_POINT" 100010)
(swig-defconstant "GLU_LINE" 100011)
(swig-defconstant "GLU_FILL" 100012)
(swig-defconstant "GLU_SILHOUETTE" 100013)
(swig-defconstant "GLU_SMOOTH" 100000)
(swig-defconstant "GLU_FLAT" 100001)
(swig-defconstant "GLU_NONE" 100002)
(swig-defconstant "GLU_OUTSIDE" 100020)
(swig-defconstant "GLU_INSIDE" 100021)
(swig-defconstant "GLU_TESS_BEGIN" 100100)
(swig-defconstant "GLU_BEGIN" 100100)
(swig-defconstant "GLU_TESS_VERTEX" 100101)
(swig-defconstant "GLU_VERTEX" 100101)
(swig-defconstant "GLU_TESS_END" 100102)
(swig-defconstant "GLU_END" 100102)
(swig-defconstant "GLU_TESS_ERROR" 100103)
(swig-defconstant "GLU_TESS_EDGE_FLAG" 100104)
(swig-defconstant "GLU_EDGE_FLAG" 100104)
(swig-defconstant "GLU_TESS_COMBINE" 100105)
(swig-defconstant "GLU_TESS_BEGIN_DATA" 100106)
(swig-defconstant "GLU_TESS_VERTEX_DATA" 100107)
(swig-defconstant "GLU_TESS_END_DATA" 100108)
(swig-defconstant "GLU_TESS_ERROR_DATA" 100109)
(swig-defconstant "GLU_TESS_EDGE_FLAG_DATA" 100110)
(swig-defconstant "GLU_TESS_COMBINE_DATA" 100111)
(swig-defconstant "GLU_CW" 100120)
(swig-defconstant "GLU_CCW" 100121)
(swig-defconstant "GLU_INTERIOR" 100122)
(swig-defconstant "GLU_EXTERIOR" 100123)
(swig-defconstant "GLU_UNKNOWN" 100124)
(swig-defconstant "GLU_TESS_WINDING_RULE" 100140)
(swig-defconstant "GLU_TESS_BOUNDARY_ONLY" 100141)
(swig-defconstant "GLU_TESS_TOLERANCE" 100142)
(swig-defconstant "GLU_TESS_ERROR1" 100151)
(swig-defconstant "GLU_TESS_ERROR2" 100152)
(swig-defconstant "GLU_TESS_ERROR3" 100153)
(swig-defconstant "GLU_TESS_ERROR4" 100154)
(swig-defconstant "GLU_TESS_ERROR5" 100155)
(swig-defconstant "GLU_TESS_ERROR6" 100156)
(swig-defconstant "GLU_TESS_ERROR7" 100157)
(swig-defconstant "GLU_TESS_ERROR8" 100158)
(swig-defconstant "GLU_TESS_MISSING_BEGIN_POLYGON" 100151)
(swig-defconstant "GLU_TESS_MISSING_BEGIN_CONTOUR" 100152)
(swig-defconstant "GLU_TESS_MISSING_END_POLYGON" 100153)
(swig-defconstant "GLU_TESS_MISSING_END_CONTOUR" 100154)
(swig-defconstant "GLU_TESS_COORD_TOO_LARGE" 100155)
(swig-defconstant "GLU_TESS_NEED_COMBINE_CALLBACK" 100156)
(swig-defconstant "GLU_TESS_WINDING_ODD" 100130)
(swig-defconstant "GLU_TESS_WINDING_NONZERO" 100131)
(swig-defconstant "GLU_TESS_WINDING_POSITIVE" 100132)
(swig-defconstant "GLU_TESS_WINDING_NEGATIVE" 100133)
(swig-defconstant "GLU_TESS_WINDING_ABS_GEQ_TWO" 100134)
(swig-defconstant "GLU_TESS_MAX_COORD" 1.0d150)
(swig-defun ("gluBeginCurve" "gluBeginCurve")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBeginPolygon" "gluBeginPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBeginSurface" "gluBeginSurface")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBeginTrim" "gluBeginTrim")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild1DMipmapLevels" "gluBuild1DMipmapLevels")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalFormat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_base  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_max  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM8_data  (* :void) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalFormat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_format))
  (cl::let ((SWIG_arg4 PARM4_type))
  (cl::let ((SWIG_arg5 PARM5_level))
  (cl::let ((SWIG_arg6 PARM6_base))
  (cl::let ((SWIG_arg7 PARM7_max))
  (cl::let ((SWIG_arg8 PARM8_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild1DMipmaps" "gluBuild1DMipmaps")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalFormat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_data  (* :void) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalFormat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_format))
  (cl::let ((SWIG_arg4 PARM4_type))
  (cl::let ((SWIG_arg5 PARM5_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild2DMipmapLevels" "gluBuild2DMipmapLevels")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalFormat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_base  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM8_max  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_data  (* :void) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalFormat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_level))
  (cl::let ((SWIG_arg7 PARM7_base))
  (cl::let ((SWIG_arg8 PARM8_max))
  (cl::let ((SWIG_arg9 PARM9_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9))))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild2DMipmaps" "gluBuild2DMipmaps")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalFormat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM5_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_data  (* :void) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalFormat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_format))
  (cl::let ((SWIG_arg5 PARM5_type))
  (cl::let ((SWIG_arg6 PARM6_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6)))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild3DMipmapLevels" "gluBuild3DMipmapLevels")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalFormat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_depth  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_level  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM8_base  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_max  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM10_data  (* :void) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalFormat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_depth))
  (cl::let ((SWIG_arg5 PARM5_format))
  (cl::let ((SWIG_arg6 PARM6_type))
  (cl::let ((SWIG_arg7 PARM7_level))
  (cl::let ((SWIG_arg8 PARM8_base))
  (cl::let ((SWIG_arg9 PARM9_max))
  (cl::let ((SWIG_arg10 PARM10_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9 SWIG_arg10)))))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluBuild3DMipmaps" "gluBuild3DMipmaps")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalFormat  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_width  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM4_depth  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM5_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM6_type  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM7_data  (* :void) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalFormat))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_depth))
  (cl::let ((SWIG_arg5 PARM5_format))
  (cl::let ((SWIG_arg6 PARM6_type))
  (cl::let ((SWIG_arg7 PARM7_data))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluCheckExtension" "gluCheckExtension")
  ((:p+ PARM0_extName  (* #.(swig-insert-id "GLubyte" () :type :type)) )
   (:p+ PARM1_extString  (* #.(swig-insert-id "GLubyte" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLboolean" () :type :type) cl:integer)
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_extName))
  (cl::let ((SWIG_arg1 PARM1_extString))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluCylinder" "gluCylinder")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_base  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_top  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_height  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_base))
  (cl::let ((SWIG_arg2 PARM2_top))
  (cl::let ((SWIG_arg3 PARM3_height))
  (cl::let ((SWIG_arg4 PARM4_slices))
  (cl::let ((SWIG_arg5 PARM5_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDeleteNurbsRenderer" "gluDeleteNurbsRenderer")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDeleteQuadric" "gluDeleteQuadric")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDeleteTess" "gluDeleteTess")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluDisk" "gluDisk")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_inner  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_outer  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_loops  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_inner))
  (cl::let ((SWIG_arg2 PARM2_outer))
  (cl::let ((SWIG_arg3 PARM3_slices))
  (cl::let ((SWIG_arg4 PARM4_loops))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndCurve" "gluEndCurve")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndPolygon" "gluEndPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndSurface" "gluEndSurface")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluEndTrim" "gluEndTrim")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluErrorString" "gluErrorString")
  ((:p+ PARM0_error  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* #.(swig-insert-id "GLubyte" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_error))
    (cl:let* ((address (swig-ff-call SWIG_arg0)))
    (cl:setq ACL_ffresult (cl:if (cl:eq address 0) 0
      	     		  	 (excl:native-to-string address))))  )
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluGetNurbsProperty" "gluGetNurbsProperty")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_property  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_data  (* #.(swig-insert-id "GLfloat" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_property))
  (cl::let ((SWIG_arg2 PARM2_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluGetString" "gluGetString")
  ((:p+ PARM0_name  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning ((* #.(swig-insert-id "GLubyte" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
    (cl:let* ((address (swig-ff-call SWIG_arg0)))
    (cl:setq ACL_ffresult (cl:if (cl:eq address 0) 0
      	     		  	 (excl:native-to-string address))))  )
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluGetTessProperty" "gluGetTessProperty")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_data  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluLoadSamplingMatrices" "gluLoadSamplingMatrices")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_model  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM2_perspective  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM3_view  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_model))
  (cl::let ((SWIG_arg2 PARM2_perspective))
  (cl::let ((SWIG_arg3 PARM3_view))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluLookAt" "gluLookAt")
  ((:p+ PARM0_eyeX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_eyeY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_eyeZ  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_centerX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_centerY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM5_centerZ  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM6_upX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM7_upY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM8_upZ  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_eyeX))
  (cl::let ((SWIG_arg1 PARM1_eyeY))
  (cl::let ((SWIG_arg2 PARM2_eyeZ))
  (cl::let ((SWIG_arg3 PARM3_centerX))
  (cl::let ((SWIG_arg4 PARM4_centerY))
  (cl::let ((SWIG_arg5 PARM5_centerZ))
  (cl::let ((SWIG_arg6 PARM6_upX))
  (cl::let ((SWIG_arg7 PARM7_upY))
  (cl::let ((SWIG_arg8 PARM8_upZ))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNewNurbsRenderer" "gluNewNurbsRenderer")
  (:void)
  (:returning ((* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance 'ff:foreign-pointer :foreign-address address)))
     (cl:when (cl:and nil (cl:not (cl:zerop address)))
       (excl:schedule-finalization new-inst #'identity))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNewQuadric" "gluNewQuadric")
  (:void)
  (:returning ((* #.(swig-insert-id "GLUquadric" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance 'ff:foreign-pointer :foreign-address address)))
     (cl:when (cl:and nil (cl:not (cl:zerop address)))
       (excl:schedule-finalization new-inst #'identity))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNewTess" "gluNewTess")
  (:void)
  (:returning ((* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance 'ff:foreign-pointer :foreign-address address)))
     (cl:when (cl:and nil (cl:not (cl:zerop address)))
       (excl:schedule-finalization new-inst #'identity))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNextContour" "gluNextContour")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsCallback" "gluNurbsCallback")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_CallBackFunc  (* (:function ( ) #.(swig-insert-id "GLvoid" () :type :type))) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_CallBackFunc))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsCallbackData" "gluNurbsCallbackData")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_userData  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_userData))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsCallbackDataEXT" "gluNurbsCallbackDataEXT")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_userData  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_userData))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsCurve" "gluNurbsCurve")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_knotCount  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_knots  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_control  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM5_order  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_knotCount))
  (cl::let ((SWIG_arg2 PARM2_knots))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_control))
  (cl::let ((SWIG_arg5 PARM5_order))
  (cl::let ((SWIG_arg6 PARM6_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsProperty" "gluNurbsProperty")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_property  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_value  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_property))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluNurbsSurface" "gluNurbsSurface")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_sKnotCount  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_sKnots  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM3_tKnotCount  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_tKnots  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM5_sStride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM6_tStride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM7_control  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM8_sOrder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM9_tOrder  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM10_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_sKnotCount))
  (cl::let ((SWIG_arg2 PARM2_sKnots))
  (cl::let ((SWIG_arg3 PARM3_tKnotCount))
  (cl::let ((SWIG_arg4 PARM4_tKnots))
  (cl::let ((SWIG_arg5 PARM5_sStride))
  (cl::let ((SWIG_arg6 PARM6_tStride))
  (cl::let ((SWIG_arg7 PARM7_control))
  (cl::let ((SWIG_arg8 PARM8_sOrder))
  (cl::let ((SWIG_arg9 PARM9_tOrder))
  (cl::let ((SWIG_arg10 PARM10_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9 SWIG_arg10))))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluOrtho2D" "gluOrtho2D")
  ((:p+ PARM0_left  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_right  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_bottom  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_top  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_left))
  (cl::let ((SWIG_arg1 PARM1_right))
  (cl::let ((SWIG_arg2 PARM2_bottom))
  (cl::let ((SWIG_arg3 PARM3_top))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPartialDisk" "gluPartialDisk")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_inner  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_outer  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_loops  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM5_start  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM6_sweep  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_inner))
  (cl::let ((SWIG_arg2 PARM2_outer))
  (cl::let ((SWIG_arg3 PARM3_slices))
  (cl::let ((SWIG_arg4 PARM4_loops))
  (cl::let ((SWIG_arg5 PARM5_start))
  (cl::let ((SWIG_arg6 PARM6_sweep))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPerspective" "gluPerspective")
  ((:p+ PARM0_fovy  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_aspect  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_zNear  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_zFar  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_fovy))
  (cl::let ((SWIG_arg1 PARM1_aspect))
  (cl::let ((SWIG_arg2 PARM2_zNear))
  (cl::let ((SWIG_arg3 PARM3_zFar))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPickMatrix" "gluPickMatrix")
  ((:p+ PARM0_x  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_y  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_delX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_delY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_viewport  (* #.(swig-insert-id "GLint" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_delX))
  (cl::let ((SWIG_arg3 PARM3_delY))
  (cl::let ((SWIG_arg4 PARM4_viewport))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluProject" "gluProject")
  ((:p+ PARM0_objX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_objY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_objZ  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_model  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM4_proj  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM5_view  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM6_winX  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM7_winY  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM8_winZ  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_objX))
  (cl::let ((SWIG_arg1 PARM1_objY))
  (cl::let ((SWIG_arg2 PARM2_objZ))
  (cl::let ((SWIG_arg3 PARM3_model))
  (cl::let ((SWIG_arg4 PARM4_proj))
  (cl::let ((SWIG_arg5 PARM5_view))
  (cl::let ((SWIG_arg6 PARM6_winX))
  (cl::let ((SWIG_arg7 PARM7_winY))
  (cl::let ((SWIG_arg8 PARM8_winZ))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluPwlCurve" "gluPwlCurve")
  ((:p+ PARM0_nurb  (* #.(swig-insert-id "GLUnurbs" () :type :type)) )
   (:p+ PARM1_count  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_data  (* #.(swig-insert-id "GLfloat" () :type :type)) )
   (:p+ PARM3_stride  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM4_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_nurb))
  (cl::let ((SWIG_arg1 PARM1_count))
  (cl::let ((SWIG_arg2 PARM2_data))
  (cl::let ((SWIG_arg3 PARM3_stride))
  (cl::let ((SWIG_arg4 PARM4_type))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricCallback" "gluQuadricCallback")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_CallBackFunc  (* (:function ( ) #.(swig-insert-id "GLvoid" () :type :type))) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_CallBackFunc))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricDrawStyle" "gluQuadricDrawStyle")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_draw  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_draw))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricNormals" "gluQuadricNormals")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_normal  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_normal))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricOrientation" "gluQuadricOrientation")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_orientation  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_orientation))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluQuadricTexture" "gluQuadricTexture")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_texture  #.(swig-insert-id "GLboolean" () :type :type) cl:integer))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_texture))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluScaleImage" "gluScaleImage")
  ((:p+ PARM0_format  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_wIn  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM2_hIn  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM3_typeIn  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM4_dataIn  (* :void) )
   (:p+ PARM5_wOut  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM6_hOut  #.(swig-insert-id "GLsizei" () :type :type) )
   (:p+ PARM7_typeOut  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM8_dataOut  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_format))
  (cl::let ((SWIG_arg1 PARM1_wIn))
  (cl::let ((SWIG_arg2 PARM2_hIn))
  (cl::let ((SWIG_arg3 PARM3_typeIn))
  (cl::let ((SWIG_arg4 PARM4_dataIn))
  (cl::let ((SWIG_arg5 PARM5_wOut))
  (cl::let ((SWIG_arg6 PARM6_hOut))
  (cl::let ((SWIG_arg7 PARM7_typeOut))
  (cl::let ((SWIG_arg8 PARM8_dataOut))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluSphere" "gluSphere")
  ((:p+ PARM0_quad  (* #.(swig-insert-id "GLUquadric" () :type :type)) )
   (:p+ PARM1_radius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_quad))
  (cl::let ((SWIG_arg1 PARM1_radius))
  (cl::let ((SWIG_arg2 PARM2_slices))
  (cl::let ((SWIG_arg3 PARM3_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessBeginContour" "gluTessBeginContour")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessBeginPolygon" "gluTessBeginPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessCallback" "gluTessCallback")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_CallBackFunc  (* (:function ( ) #.(swig-insert-id "GLvoid" () :type :type))) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_CallBackFunc))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessEndContour" "gluTessEndContour")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessEndPolygon" "gluTessEndPolygon")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessNormal" "gluTessNormal")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_valueX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_valueY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_valueZ  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_valueX))
  (cl::let ((SWIG_arg2 PARM2_valueY))
  (cl::let ((SWIG_arg3 PARM3_valueZ))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessProperty" "gluTessProperty")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_which  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_data  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_which))
  (cl::let ((SWIG_arg2 PARM2_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluTessVertex" "gluTessVertex")
  ((:p+ PARM0_tess  (* #.(swig-insert-id "GLUtesselator" () :type :type)) )
   (:p+ PARM1_location  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM2_data  (* #.(swig-insert-id "GLvoid" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_tess))
  (cl::let ((SWIG_arg1 PARM1_location))
  (cl::let ((SWIG_arg2 PARM2_data))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluUnProject" "gluUnProject")
  ((:p+ PARM0_winX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_winY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_winZ  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_model  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM4_proj  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM5_view  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM6_objX  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM7_objY  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM8_objZ  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_winX))
  (cl::let ((SWIG_arg1 PARM1_winY))
  (cl::let ((SWIG_arg2 PARM2_winZ))
  (cl::let ((SWIG_arg3 PARM3_model))
  (cl::let ((SWIG_arg4 PARM4_proj))
  (cl::let ((SWIG_arg5 PARM5_view))
  (cl::let ((SWIG_arg6 PARM6_objX))
  (cl::let ((SWIG_arg7 PARM7_objY))
  (cl::let ((SWIG_arg8 PARM8_objZ))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8)))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("gluUnProject4" "gluUnProject4")
  ((:p+ PARM0_winX  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_winY  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_winZ  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM3_clipW  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM4_model  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM5_proj  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM6_view  (* #.(swig-insert-id "GLint" () :type :type)) )
   (:p+ PARM7_near  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM8_far  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM9_objX  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM10_objY  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM11_objZ  (* #.(swig-insert-id "GLdouble" () :type :type)) )
   (:p+ PARM12_objW  (* #.(swig-insert-id "GLdouble" () :type :type)) ))
  (:returning (#.(swig-insert-id "GLint" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_winX))
  (cl::let ((SWIG_arg1 PARM1_winY))
  (cl::let ((SWIG_arg2 PARM2_winZ))
  (cl::let ((SWIG_arg3 PARM3_clipW))
  (cl::let ((SWIG_arg4 PARM4_model))
  (cl::let ((SWIG_arg5 PARM5_proj))
  (cl::let ((SWIG_arg6 PARM6_view))
  (cl::let ((SWIG_arg7 PARM7_near))
  (cl::let ((SWIG_arg8 PARM8_far))
  (cl::let ((SWIG_arg9 PARM9_objX))
  (cl::let ((SWIG_arg10 PARM10_objY))
  (cl::let ((SWIG_arg11 PARM11_objZ))
  (cl::let ((SWIG_arg12 PARM12_objW))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4 SWIG_arg5 SWIG_arg6 SWIG_arg7 SWIG_arg8 SWIG_arg9 SWIG_arg10 SWIG_arg11 SWIG_arg12)))))))))))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defconstant "GLUT_API_VERSION" 5)
(swig-defconstant "GLUT_XLIB_IMPLEMENTATION" 15)
(swig-defconstant "GLUT_MACOSX_IMPLEMENTATION" 2)
(swig-defconstant "GLUT_RGB" 0)
(swig-defconstant "GLUT_RGBA" 0)
(swig-defconstant "GLUT_INDEX" 1)
(swig-defconstant "GLUT_SINGLE" 0)
(swig-defconstant "GLUT_DOUBLE" 2)
(swig-defconstant "GLUT_ACCUM" 4)
(swig-defconstant "GLUT_ALPHA" 8)
(swig-defconstant "GLUT_DEPTH" 16)
(swig-defconstant "GLUT_STENCIL" 32)
(swig-defconstant "GLUT_MULTISAMPLE" 128)
(swig-defconstant "GLUT_STEREO" 256)
(swig-defconstant "GLUT_LUMINANCE" 512)
(swig-defconstant "GLUT_LEFT_BUTTON" 0)
(swig-defconstant "GLUT_MIDDLE_BUTTON" 1)
(swig-defconstant "GLUT_RIGHT_BUTTON" 2)
(swig-defconstant "GLUT_DOWN" 0)
(swig-defconstant "GLUT_UP" 1)
(swig-defconstant "GLUT_KEY_F1" 1)
(swig-defconstant "GLUT_KEY_F2" 2)
(swig-defconstant "GLUT_KEY_F3" 3)
(swig-defconstant "GLUT_KEY_F4" 4)
(swig-defconstant "GLUT_KEY_F5" 5)
(swig-defconstant "GLUT_KEY_F6" 6)
(swig-defconstant "GLUT_KEY_F7" 7)
(swig-defconstant "GLUT_KEY_F8" 8)
(swig-defconstant "GLUT_KEY_F9" 9)
(swig-defconstant "GLUT_KEY_F10" 10)
(swig-defconstant "GLUT_KEY_F11" 11)
(swig-defconstant "GLUT_KEY_F12" 12)
(swig-defconstant "GLUT_KEY_LEFT" 100)
(swig-defconstant "GLUT_KEY_UP" 101)
(swig-defconstant "GLUT_KEY_RIGHT" 102)
(swig-defconstant "GLUT_KEY_DOWN" 103)
(swig-defconstant "GLUT_KEY_PAGE_UP" 104)
(swig-defconstant "GLUT_KEY_PAGE_DOWN" 105)
(swig-defconstant "GLUT_KEY_HOME" 106)
(swig-defconstant "GLUT_KEY_END" 107)
(swig-defconstant "GLUT_KEY_INSERT" 108)
(swig-defconstant "GLUT_LEFT" 0)
(swig-defconstant "GLUT_ENTERED" 1)
(swig-defconstant "GLUT_MENU_NOT_IN_USE" 0)
(swig-defconstant "GLUT_MENU_IN_USE" 1)
(swig-defconstant "GLUT_NOT_VISIBLE" 0)
(swig-defconstant "GLUT_VISIBLE" 1)
(swig-defconstant "GLUT_HIDDEN" 0)
(swig-defconstant "GLUT_FULLY_RETAINED" 1)
(swig-defconstant "GLUT_PARTIALLY_RETAINED" 2)
(swig-defconstant "GLUT_FULLY_COVERED" 3)
(swig-defconstant "GLUT_RED" 0)
(swig-defconstant "GLUT_GREEN" 1)
(swig-defconstant "GLUT_BLUE" 2)
(swig-defconstant "GLUT_NORMAL" 0)
(swig-defconstant "GLUT_OVERLAY" 1)
(swig-defvar "glutStrokeRoman" "glutStrokeRoman" :type :variable)
(swig-defvar "glutStrokeMonoRoman" "glutStrokeMonoRoman" :type :variable)
(swig-defvar "glutBitmap9By15" "glutBitmap9By15" :type :variable)
(swig-defvar "glutBitmap8By13" "glutBitmap8By13" :type :variable)
(swig-defvar "glutBitmapTimesRoman10" "glutBitmapTimesRoman10" :type :variable)
(swig-defvar "glutBitmapTimesRoman24" "glutBitmapTimesRoman24" :type :variable)
(swig-defvar "glutBitmapHelvetica10" "glutBitmapHelvetica10" :type :variable)
(swig-defvar "glutBitmapHelvetica12" "glutBitmapHelvetica12" :type :variable)
(swig-defvar "glutBitmapHelvetica18" "glutBitmapHelvetica18" :type :variable)
(swig-defconstant "GLUT_WINDOW_X" 100)
(swig-defconstant "GLUT_WINDOW_Y" 101)
(swig-defconstant "GLUT_WINDOW_WIDTH" 102)
(swig-defconstant "GLUT_WINDOW_HEIGHT" 103)
(swig-defconstant "GLUT_WINDOW_BUFFER_SIZE" 104)
(swig-defconstant "GLUT_WINDOW_STENCIL_SIZE" 105)
(swig-defconstant "GLUT_WINDOW_DEPTH_SIZE" 106)
(swig-defconstant "GLUT_WINDOW_RED_SIZE" 107)
(swig-defconstant "GLUT_WINDOW_GREEN_SIZE" 108)
(swig-defconstant "GLUT_WINDOW_BLUE_SIZE" 109)
(swig-defconstant "GLUT_WINDOW_ALPHA_SIZE" 110)
(swig-defconstant "GLUT_WINDOW_ACCUM_RED_SIZE" 111)
(swig-defconstant "GLUT_WINDOW_ACCUM_GREEN_SIZE" 112)
(swig-defconstant "GLUT_WINDOW_ACCUM_BLUE_SIZE" 113)
(swig-defconstant "GLUT_WINDOW_ACCUM_ALPHA_SIZE" 114)
(swig-defconstant "GLUT_WINDOW_DOUBLEBUFFER" 115)
(swig-defconstant "GLUT_WINDOW_RGBA" 116)
(swig-defconstant "GLUT_WINDOW_PARENT" 117)
(swig-defconstant "GLUT_WINDOW_NUM_CHILDREN" 118)
(swig-defconstant "GLUT_WINDOW_COLORMAP_SIZE" 119)
(swig-defconstant "GLUT_WINDOW_NUM_SAMPLES" 120)
(swig-defconstant "GLUT_WINDOW_STEREO" 121)
(swig-defconstant "GLUT_WINDOW_CURSOR" 122)
(swig-defconstant "GLUT_SCREEN_WIDTH" 200)
(swig-defconstant "GLUT_SCREEN_HEIGHT" 201)
(swig-defconstant "GLUT_SCREEN_WIDTH_MM" 202)
(swig-defconstant "GLUT_SCREEN_HEIGHT_MM" 203)
(swig-defconstant "GLUT_MENU_NUM_ITEMS" 300)
(swig-defconstant "GLUT_DISPLAY_MODE_POSSIBLE" 400)
(swig-defconstant "GLUT_INIT_WINDOW_X" 500)
(swig-defconstant "GLUT_INIT_WINDOW_Y" 501)
(swig-defconstant "GLUT_INIT_WINDOW_WIDTH" 502)
(swig-defconstant "GLUT_INIT_WINDOW_HEIGHT" 503)
(swig-defconstant "GLUT_INIT_DISPLAY_MODE" 504)
(swig-defconstant "GLUT_ELAPSED_TIME" 700)
(swig-defconstant "GLUT_WINDOW_FORMAT_ID" 123)
(swig-defconstant "GLUT_HAS_KEYBOARD" 600)
(swig-defconstant "GLUT_HAS_MOUSE" 601)
(swig-defconstant "GLUT_HAS_SPACEBALL" 602)
(swig-defconstant "GLUT_HAS_DIAL_AND_BUTTON_BOX" 603)
(swig-defconstant "GLUT_HAS_TABLET" 604)
(swig-defconstant "GLUT_NUM_MOUSE_BUTTONS" 605)
(swig-defconstant "GLUT_NUM_SPACEBALL_BUTTONS" 606)
(swig-defconstant "GLUT_NUM_BUTTON_BOX_BUTTONS" 607)
(swig-defconstant "GLUT_NUM_DIALS" 608)
(swig-defconstant "GLUT_NUM_TABLET_BUTTONS" 609)
(swig-defconstant "GLUT_DEVICE_IGNORE_KEY_REPEAT" 610)
(swig-defconstant "GLUT_DEVICE_KEY_REPEAT" 611)
(swig-defconstant "GLUT_HAS_JOYSTICK" 612)
(swig-defconstant "GLUT_OWNS_JOYSTICK" 613)
(swig-defconstant "GLUT_JOYSTICK_BUTTONS" 614)
(swig-defconstant "GLUT_JOYSTICK_AXES" 615)
(swig-defconstant "GLUT_JOYSTICK_POLL_RATE" 616)
(swig-defconstant "GLUT_OVERLAY_POSSIBLE" 800)
(swig-defconstant "GLUT_LAYER_IN_USE" 801)
(swig-defconstant "GLUT_HAS_OVERLAY" 802)
(swig-defconstant "GLUT_TRANSPARENT_INDEX" 803)
(swig-defconstant "GLUT_NORMAL_DAMAGED" 804)
(swig-defconstant "GLUT_OVERLAY_DAMAGED" 805)
(swig-defconstant "GLUT_VIDEO_RESIZE_POSSIBLE" 900)
(swig-defconstant "GLUT_VIDEO_RESIZE_IN_USE" 901)
(swig-defconstant "GLUT_VIDEO_RESIZE_X_DELTA" 902)
(swig-defconstant "GLUT_VIDEO_RESIZE_Y_DELTA" 903)
(swig-defconstant "GLUT_VIDEO_RESIZE_WIDTH_DELTA" 904)
(swig-defconstant "GLUT_VIDEO_RESIZE_HEIGHT_DELTA" 905)
(swig-defconstant "GLUT_VIDEO_RESIZE_X" 906)
(swig-defconstant "GLUT_VIDEO_RESIZE_Y" 907)
(swig-defconstant "GLUT_VIDEO_RESIZE_WIDTH" 908)
(swig-defconstant "GLUT_VIDEO_RESIZE_HEIGHT" 909)
(swig-defconstant "GLUT_ACTIVE_SHIFT" 1)
(swig-defconstant "GLUT_ACTIVE_CTRL" 2)
(swig-defconstant "GLUT_ACTIVE_ALT" 4)
(swig-defconstant "GLUT_CURSOR_RIGHT_ARROW" 0)
(swig-defconstant "GLUT_CURSOR_LEFT_ARROW" 1)
(swig-defconstant "GLUT_CURSOR_INFO" 2)
(swig-defconstant "GLUT_CURSOR_DESTROY" 3)
(swig-defconstant "GLUT_CURSOR_HELP" 4)
(swig-defconstant "GLUT_CURSOR_CYCLE" 5)
(swig-defconstant "GLUT_CURSOR_SPRAY" 6)
(swig-defconstant "GLUT_CURSOR_WAIT" 7)
(swig-defconstant "GLUT_CURSOR_TEXT" 8)
(swig-defconstant "GLUT_CURSOR_CROSSHAIR" 9)
(swig-defconstant "GLUT_CURSOR_UP_DOWN" 10)
(swig-defconstant "GLUT_CURSOR_LEFT_RIGHT" 11)
(swig-defconstant "GLUT_CURSOR_TOP_SIDE" 12)
(swig-defconstant "GLUT_CURSOR_BOTTOM_SIDE" 13)
(swig-defconstant "GLUT_CURSOR_LEFT_SIDE" 14)
(swig-defconstant "GLUT_CURSOR_RIGHT_SIDE" 15)
(swig-defconstant "GLUT_CURSOR_TOP_LEFT_CORNER" 16)
(swig-defconstant "GLUT_CURSOR_TOP_RIGHT_CORNER" 17)
(swig-defconstant "GLUT_CURSOR_BOTTOM_RIGHT_CORNER" 18)
(swig-defconstant "GLUT_CURSOR_BOTTOM_LEFT_CORNER" 19)
(swig-defconstant "GLUT_CURSOR_INHERIT" 100)
(swig-defconstant "GLUT_CURSOR_NONE" 101)
(swig-defconstant "GLUT_CURSOR_FULL_CROSSHAIR" 102)
(swig-defun ("glutInit" "glutInit")
  ((:p+ PARM0_argcp  (* :int) )
   (:p+ PARM1_argv  (* (* :char)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_argcp))
  (cl::let ((SWIG_arg1 PARM1_argv))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutInitDisplayMode" "glutInitDisplayMode")
  ((:p+ PARM0_mode  :unsigned-int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutInitDisplayString" "glutInitDisplayString")
  ((:p+ PARM0_string  (* :char) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_string))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutInitWindowPosition" "glutInitWindowPosition")
  ((:p+ PARM0_x  :int )
   (:p+ PARM1_y  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutInitWindowSize" "glutInitWindowSize")
  ((:p+ PARM0_width  :int )
   (:p+ PARM1_height  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (cl::let ((SWIG_arg1 PARM1_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutMainLoop" "glutMainLoop")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutCreateWindow" "glutCreateWindow")
  ((:p+ PARM0_title  (* :char) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_title))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutCreateSubWindow" "glutCreateSubWindow")
  ((:p+ PARM0_win  :int )
   (:p+ PARM1_x  :int )
   (:p+ PARM2_y  :int )
   (:p+ PARM3_width  :int )
   (:p+ PARM4_height  :int ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_win))
  (cl::let ((SWIG_arg1 PARM1_x))
  (cl::let ((SWIG_arg2 PARM2_y))
  (cl::let ((SWIG_arg3 PARM3_width))
  (cl::let ((SWIG_arg4 PARM4_height))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4)))))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutDestroyWindow" "glutDestroyWindow")
  ((:p+ PARM0_win  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_win))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPostRedisplay" "glutPostRedisplay")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPostWindowRedisplay" "glutPostWindowRedisplay")
  ((:p+ PARM0_win  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_win))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSwapBuffers" "glutSwapBuffers")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutGetWindow" "glutGetWindow")
  (:void)
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::setq ACL_ffresult (swig-ff-call))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetWindow" "glutSetWindow")
  ((:p+ PARM0_win  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_win))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetWindowTitle" "glutSetWindowTitle")
  ((:p+ PARM0_title  (* :char) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_title))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetIconTitle" "glutSetIconTitle")
  ((:p+ PARM0_title  (* :char) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_title))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPositionWindow" "glutPositionWindow")
  ((:p+ PARM0_x  :int )
   (:p+ PARM1_y  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutReshapeWindow" "glutReshapeWindow")
  ((:p+ PARM0_width  :int )
   (:p+ PARM1_height  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_width))
  (cl::let ((SWIG_arg1 PARM1_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPopWindow" "glutPopWindow")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPushWindow" "glutPushWindow")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutIconifyWindow" "glutIconifyWindow")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutShowWindow" "glutShowWindow")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutHideWindow" "glutHideWindow")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutFullScreen" "glutFullScreen")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetCursor" "glutSetCursor")
  ((:p+ PARM0_cursor  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_cursor))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWarpPointer" "glutWarpPointer")
  ((:p+ PARM0_x  :int )
   (:p+ PARM1_y  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSurfaceTexture" "glutSurfaceTexture")
  ((:p+ PARM0_target  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM1_internalformat  #.(swig-insert-id "GLenum" () :type :type) )
   (:p+ PARM2_surfacewin  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_target))
  (cl::let ((SWIG_arg1 PARM1_internalformat))
  (cl::let ((SWIG_arg2 PARM2_surfacewin))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWMCloseFunc" "glutWMCloseFunc")
  ((:p+ PARM0_func  (* (:function (:void ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutCheckLoop" "glutCheckLoop")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutEstablishOverlay" "glutEstablishOverlay")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutRemoveOverlay" "glutRemoveOverlay")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutUseLayer" "glutUseLayer")
  ((:p+ PARM0_layer  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_layer))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPostOverlayRedisplay" "glutPostOverlayRedisplay")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPostWindowOverlayRedisplay" "glutPostWindowOverlayRedisplay")
  ((:p+ PARM0_win  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_win))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutShowOverlay" "glutShowOverlay")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutHideOverlay" "glutHideOverlay")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutCreateMenu" "glutCreateMenu")
  ((:p+ PARM0_arg1  (* (:function (:int ) :void)) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_arg1))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutDestroyMenu" "glutDestroyMenu")
  ((:p+ PARM0_menu  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_menu))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutGetMenu" "glutGetMenu")
  (:void)
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::setq ACL_ffresult (swig-ff-call))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetMenu" "glutSetMenu")
  ((:p+ PARM0_menu  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_menu))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutAddMenuEntry" "glutAddMenuEntry")
  ((:p+ PARM0_label  (* :char) )
   (:p+ PARM1_value  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_label))
  (cl::let ((SWIG_arg1 PARM1_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutAddSubMenu" "glutAddSubMenu")
  ((:p+ PARM0_label  (* :char) )
   (:p+ PARM1_submenu  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_label))
  (cl::let ((SWIG_arg1 PARM1_submenu))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutChangeToMenuEntry" "glutChangeToMenuEntry")
  ((:p+ PARM0_item  :int )
   (:p+ PARM1_label  (* :char) )
   (:p+ PARM2_value  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_item))
  (cl::let ((SWIG_arg1 PARM1_label))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutChangeToSubMenu" "glutChangeToSubMenu")
  ((:p+ PARM0_item  :int )
   (:p+ PARM1_label  (* :char) )
   (:p+ PARM2_submenu  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_item))
  (cl::let ((SWIG_arg1 PARM1_label))
  (cl::let ((SWIG_arg2 PARM2_submenu))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutRemoveMenuItem" "glutRemoveMenuItem")
  ((:p+ PARM0_item  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_item))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutAttachMenu" "glutAttachMenu")
  ((:p+ PARM0_button  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_button))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutDetachMenu" "glutDetachMenu")
  ((:p+ PARM0_button  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_button))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutDisplayFunc" "glutDisplayFunc")
  ((:p+ PARM0_func  (* (:function (:void ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutReshapeFunc" "glutReshapeFunc")
  ((:p+ PARM0_func  (* (:function (:int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutKeyboardFunc" "glutKeyboardFunc")
  ((:p+ PARM0_func  (* (:function (:unsigned-char :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutMouseFunc" "glutMouseFunc")
  ((:p+ PARM0_func  (* (:function (:int :int :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutMotionFunc" "glutMotionFunc")
  ((:p+ PARM0_func  (* (:function (:int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutPassiveMotionFunc" "glutPassiveMotionFunc")
  ((:p+ PARM0_func  (* (:function (:int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutEntryFunc" "glutEntryFunc")
  ((:p+ PARM0_func  (* (:function (:int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutVisibilityFunc" "glutVisibilityFunc")
  ((:p+ PARM0_func  (* (:function (:int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutIdleFunc" "glutIdleFunc")
  ((:p+ PARM0_func  (* (:function (:void ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutTimerFunc" "glutTimerFunc")
  ((:p+ PARM0_millis  :unsigned-int )
   (:p+ PARM1_func  (* (:function (:int ) :void)) )
   (:p+ PARM2_value  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_millis))
  (cl::let ((SWIG_arg1 PARM1_func))
  (cl::let ((SWIG_arg2 PARM2_value))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutMenuStateFunc" "glutMenuStateFunc")
  ((:p+ PARM0_func  (* (:function (:int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSpecialFunc" "glutSpecialFunc")
  ((:p+ PARM0_func  (* (:function (:int :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSpaceballMotionFunc" "glutSpaceballMotionFunc")
  ((:p+ PARM0_func  (* (:function (:int :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSpaceballRotateFunc" "glutSpaceballRotateFunc")
  ((:p+ PARM0_func  (* (:function (:int :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSpaceballButtonFunc" "glutSpaceballButtonFunc")
  ((:p+ PARM0_func  (* (:function (:int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutButtonBoxFunc" "glutButtonBoxFunc")
  ((:p+ PARM0_func  (* (:function (:int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutDialsFunc" "glutDialsFunc")
  ((:p+ PARM0_func  (* (:function (:int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutTabletMotionFunc" "glutTabletMotionFunc")
  ((:p+ PARM0_func  (* (:function (:int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutTabletButtonFunc" "glutTabletButtonFunc")
  ((:p+ PARM0_func  (* (:function (:int :int :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutMenuStatusFunc" "glutMenuStatusFunc")
  ((:p+ PARM0_func  (* (:function (:int :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutOverlayDisplayFunc" "glutOverlayDisplayFunc")
  ((:p+ PARM0_func  (* (:function (:void ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWindowStatusFunc" "glutWindowStatusFunc")
  ((:p+ PARM0_func  (* (:function (:int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutKeyboardUpFunc" "glutKeyboardUpFunc")
  ((:p+ PARM0_func  (* (:function (:unsigned-char :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSpecialUpFunc" "glutSpecialUpFunc")
  ((:p+ PARM0_func  (* (:function (:int :int :int ) :void)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutJoystickFunc" "glutJoystickFunc")
  ((:p+ PARM0_func  (* (:function (:unsigned-int :int :int :int ) :void)) )
   (:p+ PARM1_pollInterval  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_func))
  (cl::let ((SWIG_arg1 PARM1_pollInterval))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetColor" "glutSetColor")
  ((:p+ PARM0_arg1  :int )
   (:p+ PARM1_red  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM2_green  #.(swig-insert-id "GLfloat" () :type :type) )
   (:p+ PARM3_blue  #.(swig-insert-id "GLfloat" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_arg1))
  (cl::let ((SWIG_arg1 PARM1_red))
  (cl::let ((SWIG_arg2 PARM2_green))
  (cl::let ((SWIG_arg3 PARM3_blue))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutGetColor" "glutGetColor")
  ((:p+ PARM0_ndx  :int )
   (:p+ PARM1_component  :int ))
  (:returning (#.(swig-insert-id "GLfloat" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_ndx))
  (cl::let ((SWIG_arg1 PARM1_component))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutCopyColormap" "glutCopyColormap")
  ((:p+ PARM0_win  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_win))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutGet" "glutGet")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutDeviceGet" "glutDeviceGet")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutExtensionSupported" "glutExtensionSupported")
  ((:p+ PARM0_name  (* :char) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_name))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutGetModifiers" "glutGetModifiers")
  (:void)
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::setq ACL_ffresult (swig-ff-call))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutLayerGet" "glutLayerGet")
  ((:p+ PARM0_type  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_type))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutGetProcAddress" "glutGetProcAddress")
  ((:p+ PARM0_procName  (* :char) ))
  (:returning ((* :void) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_procName))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutBitmapCharacter" "glutBitmapCharacter")
  ((:p+ PARM0_font  (* :void) )
   (:p+ PARM1_character  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_font))
  (cl::let ((SWIG_arg1 PARM1_character))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutBitmapWidth" "glutBitmapWidth")
  ((:p+ PARM0_font  (* :void) )
   (:p+ PARM1_character  :int ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_font))
  (cl::let ((SWIG_arg1 PARM1_character))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutStrokeCharacter" "glutStrokeCharacter")
  ((:p+ PARM0_font  (* :void) )
   (:p+ PARM1_character  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_font))
  (cl::let ((SWIG_arg1 PARM1_character))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutStrokeWidth" "glutStrokeWidth")
  ((:p+ PARM0_font  (* :void) )
   (:p+ PARM1_character  :int ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_font))
  (cl::let ((SWIG_arg1 PARM1_character))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutBitmapLength" "glutBitmapLength")
  ((:p+ PARM0_font  (* :void) )
   (:p+ PARM1_string  (* :unsigned-char) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_font))
  (cl::let ((SWIG_arg1 PARM1_string))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutStrokeLength" "glutStrokeLength")
  ((:p+ PARM0_font  (* :void) )
   (:p+ PARM1_string  (* :unsigned-char) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_font))
  (cl::let ((SWIG_arg1 PARM1_string))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0 SWIG_arg1))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireSphere" "glutWireSphere")
  ((:p+ PARM0_radius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_radius))
  (cl::let ((SWIG_arg1 PARM1_slices))
  (cl::let ((SWIG_arg2 PARM2_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidSphere" "glutSolidSphere")
  ((:p+ PARM0_radius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM2_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_radius))
  (cl::let ((SWIG_arg1 PARM1_slices))
  (cl::let ((SWIG_arg2 PARM2_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireCone" "glutWireCone")
  ((:p+ PARM0_base  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_height  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_base))
  (cl::let ((SWIG_arg1 PARM1_height))
  (cl::let ((SWIG_arg2 PARM2_slices))
  (cl::let ((SWIG_arg3 PARM3_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidCone" "glutSolidCone")
  ((:p+ PARM0_base  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_height  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_slices  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_stacks  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_base))
  (cl::let ((SWIG_arg1 PARM1_height))
  (cl::let ((SWIG_arg2 PARM2_slices))
  (cl::let ((SWIG_arg3 PARM3_stacks))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireCube" "glutWireCube")
  ((:p+ PARM0_size  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidCube" "glutSolidCube")
  ((:p+ PARM0_size  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireTorus" "glutWireTorus")
  ((:p+ PARM0_innerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_outerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_sides  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_rings  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_innerRadius))
  (cl::let ((SWIG_arg1 PARM1_outerRadius))
  (cl::let ((SWIG_arg2 PARM2_sides))
  (cl::let ((SWIG_arg3 PARM3_rings))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidTorus" "glutSolidTorus")
  ((:p+ PARM0_innerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM1_outerRadius  #.(swig-insert-id "GLdouble" () :type :type) )
   (:p+ PARM2_sides  #.(swig-insert-id "GLint" () :type :type) )
   (:p+ PARM3_rings  #.(swig-insert-id "GLint" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_innerRadius))
  (cl::let ((SWIG_arg1 PARM1_outerRadius))
  (cl::let ((SWIG_arg2 PARM2_sides))
  (cl::let ((SWIG_arg3 PARM3_rings))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireDodecahedron" "glutWireDodecahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidDodecahedron" "glutSolidDodecahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireTeapot" "glutWireTeapot")
  ((:p+ PARM0_size  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidTeapot" "glutSolidTeapot")
  ((:p+ PARM0_size  #.(swig-insert-id "GLdouble" () :type :type) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_size))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireOctahedron" "glutWireOctahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidOctahedron" "glutSolidOctahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireTetrahedron" "glutWireTetrahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidTetrahedron" "glutSolidTetrahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutWireIcosahedron" "glutWireIcosahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSolidIcosahedron" "glutSolidIcosahedron")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutVideoResizeGet" "glutVideoResizeGet")
  ((:p+ PARM0_param  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_param))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetupVideoResizing" "glutSetupVideoResizing")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutStopVideoResizing" "glutStopVideoResizing")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutVideoResize" "glutVideoResize")
  ((:p+ PARM0_x  :int )
   (:p+ PARM1_y  :int )
   (:p+ PARM2_width  :int )
   (:p+ PARM3_height  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutVideoPan" "glutVideoPan")
  ((:p+ PARM0_x  :int )
   (:p+ PARM1_y  :int )
   (:p+ PARM2_width  :int )
   (:p+ PARM3_height  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_x))
  (cl::let ((SWIG_arg1 PARM1_y))
  (cl::let ((SWIG_arg2 PARM2_width))
  (cl::let ((SWIG_arg3 PARM3_height))
  (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutReportErrors" "glutReportErrors")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defconstant "GLUT_KEY_REPEAT_OFF" 0)
(swig-defconstant "GLUT_KEY_REPEAT_ON" 1)
(swig-defconstant "GLUT_KEY_REPEAT_DEFAULT" 2)
(swig-defconstant "GLUT_JOYSTICK_BUTTON_A" 1)
(swig-defconstant "GLUT_JOYSTICK_BUTTON_B" 2)
(swig-defconstant "GLUT_JOYSTICK_BUTTON_C" 4)
(swig-defconstant "GLUT_JOYSTICK_BUTTON_D" 8)
(swig-defun ("glutIgnoreKeyRepeat" "glutIgnoreKeyRepeat")
  ((:p+ PARM0_ignore  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_ignore))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutSetKeyRepeat" "glutSetKeyRepeat")
  ((:p+ PARM0_repeatMode  :int ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_repeatMode))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutForceJoystickFunc" "glutForceJoystickFunc")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defconstant "GLUT_GAME_MODE_ACTIVE" 0)
(swig-defconstant "GLUT_GAME_MODE_POSSIBLE" 1)
(swig-defconstant "GLUT_GAME_MODE_WIDTH" 2)
(swig-defconstant "GLUT_GAME_MODE_HEIGHT" 3)
(swig-defconstant "GLUT_GAME_MODE_PIXEL_DEPTH" 4)
(swig-defconstant "GLUT_GAME_MODE_REFRESH_RATE" 5)
(swig-defconstant "GLUT_GAME_MODE_DISPLAY_CHANGED" 6)
(swig-defun ("glutGameModeString" "glutGameModeString")
  ((:p+ PARM0_string  (* :char) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_string))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutEnterGameMode" "glutEnterGameMode")
  (:void)
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::setq ACL_ffresult (swig-ff-call))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutLeaveGameMode" "glutLeaveGameMode")
  (:void)
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (swig-ff-call)
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("glutGameModeGet" "glutGameModeGet")
  ((:p+ PARM0_mode  #.(swig-insert-id "GLenum" () :type :type) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig.opengl:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_mode))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig.opengl:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))



(in-package :swig.opengl)

(macrolet ((swig-do-export ()
                 `(dolist (s ',*swig-export-list*)
                    (apply #'export s))))
   (swig-do-export))

(setq *swig-export-list* nil)

