/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.JavaLinkDist;

public class LispConnector {
    public static boolean lispAdvertises = true;
    public static boolean advertInFile = false;
    public static String lispFile = "";
    public static String lispHost = "";
    public static int lispPort = 4321;
    public static int pollInterval = 1000;
    public static int pollCount = 300;
    public static int javaTimeout = -1;
    public static String javaFile = "";
    public static String javaHost = "";
    public static int javaPort = 0;
    public static boolean debug = false;

    public static synchronized boolean go() {
        return LispConnector.go(false, null);
    }

    public static synchronized boolean go(boolean ver) {
        return LispConnector.go(ver, null);
    }

    public static synchronized boolean go(boolean ver, String[] throwErr) {
        String why = "";
        JavaLinkCommon.sdebug = debug;
        if (JavaLinkDist.query(ver)) {
            return true;
        }
        if (lispAdvertises) {
            if (advertInFile) {
                if (!JavaLinkDist.connect(lispFile, javaHost, javaPort, pollInterval, pollCount)) {
                    why = "Connect to Lisp file failed.";
                }
            } else if (!JavaLinkDist.connect(lispHost, lispPort, javaHost, javaPort, pollInterval, pollCount)) {
                why = "Connect to Lisp port failed.";
            }
        } else if (advertInFile) {
            if (!JavaLinkDist.advertise(javaFile, javaHost, javaPort, javaTimeout)) {
                why = "Lisp did not connect to file.";
            }
        } else if (!JavaLinkDist.advertise(javaPort, javaTimeout)) {
            why = "Lisp did not connect to port.";
        }
        if (why.length() == 0) {
            return true;
        }
        why = "LispConnector.go: " + why;
        if (throwErr == null) {
            throw new IllegalArgumentException(why);
        }
        if (throwErr.length > 0) {
            throwErr[0] = why;
        }
        return false;
    }
}

