/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.JavaLinkRoot;
import com.franz.jlinker.LispCall;
import com.franz.jlinker.LispCallSocket;
import com.franz.jlinker.TranStruct;
import com.franz.jlinker.Transport;

public class JLCommonSocket
extends JavaLinkCommon {
    static final int socket_version = 6005007;
    public static Transport javaToLispPort;
    public int notify_seq = -1;
    public static String default_l2j;
    public String l2j_ior = "";
    public static String default_j2l;
    public String j2l_ior = "";
    public static JavaLinkRoot lispToJavaThread;
    int linkPort = 0;
    String linkHost = "";
    String javaHost = "";
    int javaPort = 0;
    public static String server_key;
    public String client_key = "" + (double)System.currentTimeMillis() * Math.random();

    static {
        default_l2j = "LispToJava.trp";
        default_j2l = "JavaToLisp.trp";
    }

    public JLCommonSocket(String[] pp) throws IllegalArgumentException {
        JavaLinkCommon.ltoj_anchor = this;
        this.linkPort = 0;
        this.linkHost = "";
        this.javaHost = "";
        this.javaPort = 0;
        this.j2l_ior = "";
        this.scanargs(pp);
        if (this.javaPort == 0) {
            this.javaPort = -this.linkPort;
        }
        if (this.javaPort != -this.linkPort) {
            throw new IllegalArgumentException("Using obsolete connection protocol: -jport command line arg.");
        }
        if ("".equals(this.javaHost)) {
            this.javaHost = this.linkHost;
        }
        if (!this.linkHost.equals(this.javaHost)) {
            throw new IllegalArgumentException("Using obsolete connection protocol: -jhost command line arg.");
        }
        this.startWithConnect();
    }

    public JLCommonSocket(String j2l, String lhost, int lport) throws IllegalArgumentException {
        JavaLinkCommon.ltoj_anchor = this;
        this.linkPort = lport;
        this.linkHost = lhost;
        this.javaHost = lhost;
        this.javaPort = -lport;
        this.j2l_ior = j2l;
        this.startWithConnect();
    }

    private void startWithConnect() {
        Object r;
        Object tr;
        lispToJavaThread = null;
        JLCommonSocket.dsprint("JLCommonSocket.startWithConnect: starting up.");
        if (this.linkPort == 0) {
            if (this.j2l_ior == "") {
                this.j2l_ior = default_j2l;
            }
            if ((tr = Transport.connectToServer(this.j2l_ior)) instanceof Object[]) {
                r = (Object[])tr;
                this.linkPort = (Integer)r[0];
                this.javaHost = this.linkHost = (String)r[2];
                this.javaPort = -this.linkPort;
                tr = r[1];
                JLCommonSocket.dsprint("JLCommonSocket.startWithConnect: connection 1 to " + this.linkHost + ":" + this.linkPort);
            }
        } else {
            tr = Transport.connectToServer(this.linkHost, this.linkPort);
        }
        JLCommonSocket.dsprint("JLCommonSocket.startWithConnect: starting up.");
        javaToLispPort = null;
        if (tr instanceof Transport) {
            javaToLispPort = (Transport)tr;
            JLCommonSocket.dsprint("JLCommonSocket.startWithConnect: client_object is set - " + javaToLispPort);
            r = javaToLispPort.request("Java", 0, new int[0], new String[]{this.client_key});
            if (!(r instanceof String)) {
                javaToLispPort.shutdown();
                throw new CannotConnect("Did not receive a server key " + JLCommonSocket.showRes(r));
            }
            server_key = (String)r;
        } else {
            JLCommonSocket.dsprint("JLCommonSocket.startWithConnect: connectToServer failed " + tr);
            throw new IllegalArgumentException("Lisp to Java: connectToServer failed " + tr);
        }
        lispToJavaThread = new JavaLinkRoot("", this.javaHost, this.javaPort);
        JavaLinkDist.getServerInstances();
        lispToJavaThread.start();
        this.startMessages("startWithConnect");
    }

    void startMessages(String from) {
        JLCommonSocket.dsprint("JLCommonSocket." + from + ": " + "serverState==" + JLCommonSocket.lispToJavaThread.serverState);
        JLCommonSocket.dsprint("JLCommonSocket." + from + ": " + "Java VM version " + JLCommonSocket.versionStringOfJDK());
        JLCommonSocket.dsprint("JLCommonSocket." + from + ": " + "jLinker version " + 6005007);
    }

    public JLCommonSocket(Object sr, int port, String host) throws IllegalArgumentException {
        JavaLinkCommon.ltoj_anchor = this;
        lispToJavaThread = null;
        this.linkPort = port;
        this.linkHost = host;
        this.javaHost = host;
        this.javaPort = port;
        this.j2l_ior = "";
        this.startByAdvertising(sr);
    }

    static String showRes(Object r) {
        String v = "";
        if (r instanceof Object[]) {
            v = "[";
            Object[] a = (Object[])r;
            int i = 0;
            while (i < a.length) {
                v = String.valueOf(v) + a[i] + " ";
                ++i;
            }
        } else {
            v = String.valueOf(v) + r;
        }
        return v;
    }

    void startByAdvertising(Object tr) throws IllegalArgumentException {
        JLCommonSocket.dsprint("JLCommonSocket.startByAdvertising: starting up.");
        javaToLispPort = null;
        if (tr instanceof Transport) {
            javaToLispPort = (Transport)tr;
            JLCommonSocket.dsprint("JLCommonSocket.startByAdvertising: client_object is set - " + javaToLispPort);
            lispToJavaThread = new JavaLinkRoot("", this.javaHost, this.javaPort);
            JavaLinkDist.getServerInstances();
            lispToJavaThread.start();
            Object r = javaToLispPort.request("Java", 0, new int[0], new String[]{this.client_key});
            if (!(r instanceof String)) {
                javaToLispPort.shutdown();
                throw new CannotConnect("Did not receive a server key " + JLCommonSocket.showRes(r));
            }
            server_key = (String)r;
        } else {
            JLCommonSocket.dsprint("JLCommonSocket.startByAdvertising: connectToServer failed " + tr);
            throw new IllegalArgumentException("Lisp to Java: connectToServer failed " + tr);
        }
        this.startMessages("startByAdvertising");
    }

    public int message(int what, String[] data) {
        String d0;
        int dn = data.length;
        int res = 0;
        switch (dn) {
            case 1: {
                d0 = data[0];
                break;
            }
            case 0: {
                d0 = "<String[0]>";
                break;
            }
            default: {
                d0 = String.valueOf(data[0]) + "..." + dn;
            }
        }
        JLCommonSocket.dsprint("JLCommonSocket.message: " + what + "  Data: " + d0);
        switch (what) {
            case 1: {
                if (javaToLispPort == null) {
                    res = 2;
                    break;
                }
                this.notifyLisp("connectToServer", 0, "");
                res = 1;
                break;
            }
            case 2: {
                if (!JavaLinkDist.defaultRemotePAndSet()) break;
                res = 1;
                break;
            }
            case 3: {
                res = 3;
                break;
            }
            default: {
                JLCommonSocket.dsprint("JLCommonSocket.message: round-trip message ignored.");
                res = -1;
            }
        }
        JLCommonSocket.dsprint("JLCommonSocket.message: returning " + res);
        return res;
    }

    public void activate(int what, String[] data) {
        String from = "JLCommonSocket.activate: ";
        JLCommonSocket.dsprint(String.valueOf(from) + new Integer(what).toString());
        switch (what) {
            case 1: {
                JLCommonSocket.dsprint(String.valueOf(from) + "simple round-trip query.");
                if (javaToLispPort == null) {
                    JLCommonSocket.dsprint(String.valueOf(from) + "client_object==null");
                    break;
                }
                this.notifyLisp("serverIsLive", 0, "");
                break;
            }
            case 99: {
                JLCommonSocket.dsprint(String.valueOf(from) + "shutdown.");
                try {
                    if (javaToLispPort != null) {
                        javaToLispPort.disconnect();
                    }
                    Thread.sleep(100L);
                    JavaLinkDist.closeDist();
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                JLCommonSocket.dsprint(String.valueOf(from) + "one-way message ignored.");
            }
        }
    }

    public void scanargs(String[] pp) {
        int i = 0;
        while (i < pp.length) {
            if (pp[i].equals("-debug")) {
                JavaLinkCommon.sdebug = true;
            } else if (pp[i].equals("-lhost")) {
                this.linkHost = pp[++i];
            } else if (pp[i].equals("-jhost")) {
                this.javaHost = pp[++i];
            } else if (pp[i].equals("-lport")) {
                try {
                    this.linkPort = Integer.parseInt(pp[++i]);
                }
                catch (Exception exception) {}
            } else if (pp[i].equals("-jport")) {
                try {
                    this.javaPort = Integer.parseInt(pp[++i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    void notifyLisp(String ev, int h, String p) {
        ++this.notify_seq;
        JLCommonSocket.dsprint("JLCommonSocket.notifyLisp: sending " + ev);
        this.notifyLispShort(ev, h, this.notify_seq, p);
        JLCommonSocket.dsprint("JLCommonSocket.notifyLisp: sent " + ev);
    }

    void notifyLisp(String ev, int h, String[] p, int[] l) {
        ++this.notify_seq;
        JLCommonSocket.dsprint("JLCommonSocket.notifyLisp: sending " + ev);
        this.notifyLispBoth(ev, h, this.notify_seq, p, l);
        JLCommonSocket.dsprint("JLCommonSocket.notifyLisp: sent " + ev);
    }

    void notifyLispShort(String ev, int h, int notify_seq, String p) {
        this.notifyLispBoth(ev, h, notify_seq, new String[]{p}, new int[0]);
    }

    void notifyLispStrings(String ev, int h, int notify_seq, String[] p) {
        this.notifyLispBoth(ev, h, notify_seq, p, new int[0]);
    }

    void notifyLispBoth(String ev, int h, int notify_seq, String[] p, int[] l) {
        int[] nums = new int[4 + l.length];
        nums[0] = -1;
        nums[1] = 5;
        nums[2] = h;
        nums[3] = notify_seq;
        int i = 0;
        while (i < l.length) {
            nums[4 + i] = l[i];
            ++i;
        }
        String[] strings = new String[1 + p.length];
        strings[0] = ev;
        i = 0;
        while (i < p.length) {
            strings[1 + i] = p[i];
            ++i;
        }
        TranStruct d = new TranStruct("Self", 7680, nums, strings, new double[0]);
        if (Transport.exData == 0) {
            d.type |= 0xE000;
        }
        Object v = javaToLispPort.invoke(new TranStruct[]{d}, true);
        JavaLinkCommon.dsprint("JLCommonSocket.notifyLispBoth: invoke=> " + v);
    }

    int isRegistered(Object x) {
        if (javaToLispPort == null) {
            JLCommonSocket.dsprint("JLCommonSocket.callLisp: client_object==null, ignoring");
            return 0;
        }
        int h = JavaLinkCommon.getSObHandle(x);
        if (h == 0) {
            return 0;
        }
        return h;
    }

    public int callLisp(String ev, Object target, String[] s, int[] l) {
        int h = this.isRegistered(target);
        if (h == 0) {
            return 0;
        }
        this.notifyLisp(ev, h, s, l);
        return this.notify_seq;
    }

    public static String versionStringOfJDK() {
        try {
            return System.getProperty("java.vm.version", "1.1");
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public Object[] lispValuesOp(Object rr, String called, int min, int max, boolean firstRefP) {
        TranStruct[] res = (TranStruct[])rr;
        String err = "";
        int vct = -1;
        int rlen = res.length;
        if (rlen == 1 && JavaLinkDist.errorP(res[0])) {
            err = "LispError from " + called + ": " + JavaLinkDist.stringValue(res[0], 0) + " " + JavaLinkDist.stringValue(res[0], 1);
            JavaLinkDist.discardInLisp(res[0]);
        } else if (JavaLinkDist.integerP(res[0])) {
            vct = JavaLinkDist.intValue(res[0]);
            if (vct != rlen - 1) {
                err = "Strange result (r[0] not length) " + called + ": " + res.toString();
            } else if (vct < min || vct > max) {
                err = "Unexpected values count from " + called + ": " + new Integer(vct).toString();
            } else if (vct > 0 && firstRefP && !JavaLinkDist.pointerP(res[1])) {
                err = "Unexpected value returned from " + called + ": " + res[1].toString();
            }
        } else {
            err = rlen == 0 ? "Strange zero-length result." : (rlen == 1 ? "Strange result(not err, not String) " + called + ": len=" + rlen + " " + res[0] : (rlen == 2 ? "Strange result(not err, not String) " + called + ": len=" + rlen + " " + res[0] + " " + res[1] : "Strange result(not err, not String) " + called + ": len=" + rlen + " " + res[0] + " " + res[1] + " ..."));
        }
        return new Object[]{new Integer(vct), err};
    }

    public static void main(String[] pp) throws IllegalArgumentException, InterruptedException {
        JLCommonSocket.dsprint("JLCommonSocket: starting main.");
        new JLCommonSocket(pp);
        LispCall.prototype = new LispCallSocket();
        lispToJavaThread.join();
        JLCommonSocket.dsprint("JLCommonSocket: leaving main.");
        System.exit(0);
    }

    public static class CannotConnect
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public CannotConnect(String string) {
            super(string);
        }
    }

    public static class V6005007 {
    }
}

