;; -*- mode: common-lisp -*-
;; Simple wrapper for generate-application.
;;
;; This code is in the public domain.

(in-package :excl)

(provide :genexe)

;; [rfe6329]
#+process-autoloads
(autoload-from "code/misc.cl"
	       generate-executable)
	       
(defun generate-executable (name input-files
			    &rest rest
			    &key (runtime :standard)
				 include-compiler
				 include-devel-env
				 include-ide
				 (discard-xref-info t)
				 (discard-source-file-info t)
				 (discard-local-name-info t)
				 (discard-arglists t)
				 (restart-init-function 'user::main)
				 (suppress-allegro-cl-banner t)
				 (ignore-command-line-arguments t)
				 (application-administration
				  '(:resource-command-line "-Q"))
				 read-init-files
				 print-startup-message
				 purify
			    &allow-other-keys)
  (let* ((name (pathname-name name))
	 (output-directory (pathname-as-directory name))
	 (temp-cl (merge-pathnames
		   (make-pathname :type "cl")
		   (sys:make-temp-file-name name)))
	 (temp-fasl (merge-pathnames
		     (make-pathname :type *fasl-default-type*)
		     temp-cl))
	 (real-main (gentemp name (find-package :common-lisp-user))))

    (with-standard-io-syntax
      (with-open-file (s temp-cl :direction :output)
	(print `(in-package :common-lisp-user) s)
	(print `(defun ,real-main ()
		  (handler-case
		      (let ((args (sys:command-line-arguments)))
			(apply ',restart-init-function
			       (cons (car args)
				     (cdddr args)))
			(exit 0 :quiet t))
		    (error (c)
		      (format *error-output* "~a~%" c)
		      (force-output *error-output*)
		      (exit 1 :quiet t))))
	       s)))
    
    (unwind-protect
	(progn
	  (compile-file temp-cl)
    
	  (apply
	   #'generate-application
	   name
	   output-directory
	   (append (list temp-fasl
			 ;; needed by ,real-main:
			 :list2)
		   input-files)
	   :restart-init-function real-main
	   :application-administration application-administration
	   :read-init-files read-init-files
	   :print-startup-message print-startup-message
	   :purify purify
	   :runtime runtime
	   :include-compiler include-compiler
	   :include-devel-env include-devel-env
	   :include-ide include-ide
	   :discard-arglists discard-arglists
	   :discard-local-name-info discard-local-name-info
	   :discard-source-file-info discard-source-file-info
	   :discard-xref-info discard-xref-info
	   :ignore-command-line-arguments ignore-command-line-arguments
	   :suppress-allegro-cl-banner suppress-allegro-cl-banner
	   rest))
      (delete-file temp-cl)
      (ignore-errors (delete-file temp-fasl)))))
