;
;#include <gtk/gtk.h>
;
;/* Get the selected filename and print it to the console */
;void file_ok_sel( GtkWidget        *w,
;		   GtkFileSelection *fs )
;{
;    g_print ("%s\n", gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
;}
;
;int main( int   argc,
;	   char *argv[] )
;{
;    GtkWidget *filew;
;    
;    gtk_init (&argc, &argv);
;    
;    /* Create a new file selection widget */
;    filew = gtk_file_selection_new ("File selection");
;    
;    g_signal_connect (G_OBJECT (filew), "destroy",
;		       G_CALLBACK (gtk_main_quit), NULL);
;    /* Connect the ok_button to file_ok_sel function */
;    g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
;		       "clicked", 
;		       G_CALLBACK (file_ok_sel), filew);
;    
;    /* Connect the cancel_button to destroy the widget */
;    g_signal_connect_swapped (G_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
;			       "clicked", 
;			       G_CALLBACK (gtk_widget_destroy), filew);
;    
;    /* Lets set the filename, as if this were a save dialog, and we are giving
;     a default filename */
;    gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), 
;				      "penguin.png");
;    
;    gtk_widget_show (filew);
;    gtk_main ();
;    return 0;
;}

(defpackage "09.13-filesel" (:use :excl :common-lisp))
(in-package "09.13-filesel")

(ff:defun-foreign-callable file-ok-sel ((w (* gtk:GtkWidget))
					(fs (* gtk:GtkFileSelection)))
  (declare (ignore w))
  (format t "~&~s~%"
	  (native-to-string
	   (gtk:gtk_file_selection_get_filename (gtk:GTK_FILE_SELECTION fs)))))

(ff:defun-foreign-callable cb-gtk-main-quit ()
  (gtk:gtk-main-quit))

(defun filesel ()
  (let ((filew nil))
    (gtk:gtk_init 0 0)
    
    (setq filew (gtk:gtk_file_selection_new "File selection"))

    (gtk:g_signal_connect (gtk:G_OBJECT filew) "destroy"
			  (gtk:G_CALLBACK
			   (ff:register-foreign-callable 'cb-gtk-main-quit))
			  gtk:NULL)

    (gtk:g_signal_connect (gtk:G_OBJECT
			   (ff:fslot-value-typed
			    'gtk:GtkFileSelection nil
			    (gtk:GTK_FILE_SELECTION filew) 'gtk::ok_button))
			  "clicked"
			  (gtk:G_CALLBACK
			   (ff:register-foreign-callable 'file-ok-sel))
			  filew)

    (gtk:g_signal_connect_swapped (gtk:GTK_OBJECT
				   (ff:fslot-value-typed
				    'gtk:GtkFileSelection nil
				    (gtk:GTK_FILE_SELECTION filew)
				    'gtk::cancel_button))
				  "clicked"
				  (gtk:G_CALLBACK
				   (ff:get-entry-point "gtk_widget_destroy"))
				  filew)

    (gtk:gtk_file_selection_set_filename (gtk:GTK_FILE_SELECTION filew) 
					 "penguin.png")

    (gtk:gtk_widget_show filew)
    #+original (gtk:gtk_main)
    #-original (gtk:gtk-main)))

(flet ((run-example (name function)
	 ;; workaround for bogus (imo) redef. warnings generated by defvar
	 (declare (special gtk::*run-example*))
	 (unless (boundp 'gtk::*run-example*)
	   (setq gtk::*run-example* t))
	 (when gtk::*run-example*
	   (mp:process-run-function
	    (format nil "GTK+ Example: ~a" name)
	    function))))
  (run-example "09.13-filesel" #'filesel))
