;
;#include <stdlib.h>
;#include <gtk/gtk.h>
;#include <glib.h>
;
;GtkWidget *status_bar;
;
;void push_item( GtkWidget *widget,
;		 gpointer   data )
;{
;  static int count = 1;
;  char buff[20];
;
;  g_snprintf (buff, 20, "Item %d", count++);
;  gtk_statusbar_push (GTK_STATUSBAR (status_bar), GPOINTER_TO_INT (data), buff);
;
;  return;
;}
;
;void pop_item( GtkWidget *widget,
;		gpointer   data )
;{
;  gtk_statusbar_pop (GTK_STATUSBAR (status_bar), GPOINTER_TO_INT (data));
;  return;
;}
;
;int main( int   argc,
;	   char *argv[] )
;{
;
;    GtkWidget *window;
;    GtkWidget *vbox;
;    GtkWidget *button;
;
;    gint context_id;
;
;    gtk_init (&argc, &argv);
;
;    /* create a new window */
;    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
;    gtk_widget_set_size_request (GTK_WIDGET (window), 200, 100);
;    gtk_window_set_title (GTK_WINDOW (window), "GTK Statusbar Example");
;    g_signal_connect (G_OBJECT (window), "delete_event",
;		       G_CALLBACK (exit), NULL);
; 
;    vbox = gtk_vbox_new (FALSE, 1);
;    gtk_container_add (GTK_CONTAINER (window), vbox);
;    gtk_widget_show (vbox);
;	   
;    status_bar = gtk_statusbar_new ();      
;    gtk_box_pack_start (GTK_BOX (vbox), status_bar, TRUE, TRUE, 0);
;    gtk_widget_show (status_bar);
;
;    context_id = gtk_statusbar_get_context_id(
;			   GTK_STATUSBAR (status_bar), "Statusbar example");
;
;    button = gtk_button_new_with_label ("push item");
;    g_signal_connect (G_OBJECT (button), "clicked",
;		       G_CALLBACK (push_item), GINT_TO_POINTER (context_id));
;    gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 2);
;    gtk_widget_show (button);              
;
;    button = gtk_button_new_with_label ("pop last item");
;    g_signal_connect (G_OBJECT (button), "clicked",
;		       G_CALLBACK (pop_item), GINT_TO_POINTER (context_id));
;    gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 2);
;    gtk_widget_show (button);
;
;    /* always display the window as the last step so it all splashes on
;     * the screen at once. */
;    gtk_widget_show (window);
;
;    gtk_main ();
;
;    return 0;
;}

(defpackage "09.08-statusbar" (:use :excl :common-lisp))
(in-package "09.08-statusbar")

(defvar status-bar nil)

(let ((count 1))
  (defun push-item-closure (widget data)
    (declare (ignore widget))
    (let ((buff (format nil "Item ~d" count)))
      (incf count)
      (gtk:gtk_statusbar_push
       (gtk:GTK_STATUSBAR status-bar) (gtk:GPOINTER_TO_INT data) buff))))

(ff:defun-foreign-callable push-item ((widget (* gtk:GtkWidget))
				      (data gtk:gpointer))
  (push-item-closure widget data))

(ff:defun-foreign-callable pop-item ((widget (* gtk:GtkWidget))
				     (data gtk:gpointer))
  (declare (ignore widget))
  (gtk:gtk_statusbar_pop (gtk:GTK_STATUSBAR status-bar)
			 (gtk:GPOINTER_TO_INT data)))


(defun statusbar ()
  (let ((window nil)
	(vbox nil)
	(button nil)
	(context-id nil))

    (gtk:gtk_init 0 0)

    (setq window (gtk:gtk_window_new gtk:GTK_WINDOW_TOPLEVEL))
    (gtk:gtk_widget_set_size_request (gtk:GTK_WIDGET window) 200 100)
    (gtk:gtk_window_set_title (gtk:GTK_WINDOW window) "GTK Statusbar Example")
    (gtk:g_signal_connect (gtk:G_OBJECT window) "delete_event"
			  (gtk:G_CALLBACK (ff:get-entry-point "exit"))
			  gtk:NULL)

    (setq vbox (gtk:gtk_vbox_new gtk:FALSE 1))
    (gtk:gtk_container_add (gtk:GTK_CONTAINER window) vbox)
    (gtk:gtk_widget_show vbox)

    (setq status-bar (gtk:gtk_statusbar_new))
    (gtk:gtk_box_pack_start (gtk:GTK_BOX vbox) status-bar gtk:TRUE gtk:TRUE 0)
    (gtk:gtk_widget_show status-bar)

    (setq context-id (gtk:gtk_statusbar_get_context_id
		      (gtk:GTK_STATUSBAR status-bar)
		      "Statusbar example"))

    (setq button (gtk:gtk_button_new_with_label "push item"))
    (gtk:g_signal_connect (gtk:G_OBJECT button) "clicked"
			  (gtk:G_CALLBACK
			   (ff:register-foreign-callable 'push-item))
			  (gtk:GINT_TO_POINTER context-id))
    (gtk:gtk_box_pack_start (gtk:GTK_BOX vbox) button gtk:TRUE gtk:TRUE 2)
    (gtk:gtk_widget_show button)

    (setq button (gtk:gtk_button_new_with_label "pop last item"))
    (gtk:g_signal_connect (gtk:G_OBJECT button) "clicked"
			  (gtk:G_CALLBACK
			   (ff:register-foreign-callable 'pop-item))
			  (gtk:GINT_TO_POINTER context-id))
    (gtk:gtk_box_pack_start (gtk:GTK_BOX vbox) button gtk:TRUE gtk:TRUE 2)
    (gtk:gtk_widget_show button)

    (gtk:gtk_widget_show window)

    #+original (gtk:gtk_main)
    #-original (gtk:gtk-main)))


(flet ((run-example (name function)
	 ;; workaround for bogus (imo) redef. warnings generated by defvar
	 (declare (special gtk::*run-example*))
	 (unless (boundp 'gtk::*run-example*)
	   (setq gtk::*run-example* t))
	 (when gtk::*run-example*
	   (mp:process-run-function
	    (format nil "GTK+ Example: ~a" name)
	    function))))
  (run-example "09.08-statusbar" #'statusbar))
