/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JLWrapper;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.LispCall;
import com.franz.jlinker.LispCallImplementation;
import com.franz.jlinker.TranStruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LispCallSocket
extends LispCallImplementation {
    static Class<?> opclass = TranStruct.class;
    LispCall lci;

    static {
        try {
            opclass = Class.forName("com.franz.jlinker.TranStruct");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    Class<?> getOpClass() {
        return opclass;
    }

    LispCallSocket() {
    }

    @Override
    LispCallImplementation builder(LispCall parent, String op) {
        LispCallSocket x = new LispCallSocket();
        x.lci = parent;
        if (!op.equals("")) {
            parent.lispOp = JavaLinkDist.newDistOb(op);
        }
        return x;
    }

    @Override
    void setOp(String op) {
        this.setOp(JavaLinkDist.newDistOb(op));
    }

    @Override
    void setOp(Object op) {
        this.lci.lispOp = op;
        if (this.lci.state == 0) {
            this.lci.state = 1;
        }
    }

    synchronized int addArgWrapped(TranStruct x) {
        if (this.lci.state != 1) {
            throw new IllegalArgumentException("Wrong state");
        }
        return this.lci.newHolder(x);
    }

    @Override
    synchronized int addArg(int x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(short x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(byte x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(long x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(boolean x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(int[] x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(short[] x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(byte[] x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(String x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(String[] x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(double x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(float x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(double[] x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(float[] x) {
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addArg(Object x) {
        if (opclass.isInstance(x)) {
            return this.addArgWrapped((TranStruct)x);
        }
        return this.addArgWrapped(JavaLinkDist.newDistOb(x));
    }

    @Override
    synchronized int addSymbol(String x) {
        return this.addArgWrapped(JavaLinkDist.newDistSym(x, "", 0));
    }

    @Override
    synchronized int addSymbol(String x, String pk) {
        return this.addArgWrapped(JavaLinkDist.newDistSym(x, pk, 0));
    }

    @Override
    synchronized int addSymbol(String x, String pk, int act) {
        return this.addArgWrapped(JavaLinkDist.newDistSym(x, pk, act));
    }

    @Override
    synchronized void assemble(String where) {
        TranStruct[] argarray;
        if (this.lci.state != 1) {
            this.lci.throwWrongState(where, "");
        }
        this.lci.args = argarray = new TranStruct[this.lci.count];
        int i = 0;
        while (i < this.lci.count) {
            argarray[this.lci.count - i - 1] = (TranStruct)this.lci.chain.arg;
            this.lci.chain = this.lci.chain.next;
            ++i;
        }
        this.lci.count = 0;
        this.lci.state = 2;
    }

    @Override
    synchronized int call() throws JavaLinkDist.JLinkerException {
        TranStruct[] resarray;
        if (this.lci.state == 1) {
            this.assemble("call");
        }
        if (this.lci.state != 2) {
            this.lci.throwWrongState("call", "");
        }
        this.lci.res = resarray = JavaLinkDist.invokeInLispEx(this.lci.callStyle, (TranStruct)this.lci.lispOp, (TranStruct[])this.lci.args);
        if (!this.lci.retain) {
            this.lci.args = null;
        }
        if (this.lci.callStyle >= 3) {
            this.lci.waitref = resarray[1];
            this.lci.res = null;
            this.lci.state = 4;
            return 0;
        }
        this.lci.waitref = null;
        this.lci.state = 3;
        if (resarray.length == 0) {
            return 0;
        }
        return JavaLinkDist.intValue(resarray[0]);
    }

    @Override
    synchronized TranStruct getValue(int i) {
        TranStruct[] resarray = (TranStruct[])this.lci.res;
        TranStruct r = resarray[i + 1];
        if (r == null) {
            this.lci.throwWrongState("getValue", "when value already retrieved once");
        }
        if (!this.lci.retain) {
            resarray[i + 1] = null;
        }
        return r;
    }

    @Override
    @Deprecated
    int typeOf(JLWrapper vv) {
        TranStruct v = (TranStruct)vv;
        if (JavaLinkDist.nullP(v)) {
            return LispCall.RES_NULL;
        }
        if (JavaLinkDist.booleanP(v)) {
            return LispCall.RES_BOOLEAN;
        }
        if (JavaLinkDist.longP(v)) {
            return LispCall.RES_LONG;
        }
        if (JavaLinkDist.integerP(v)) {
            return LispCall.RES_INTEGER;
        }
        if (JavaLinkDist.realP(v)) {
            return LispCall.RES_REAL;
        }
        if (JavaLinkDist.errorP(v)) {
            return LispCall.RES_ERROR;
        }
        if (JavaLinkDist.symbolP(v)) {
            return LispCall.RES_SYMBOL;
        }
        if (JavaLinkDist.stringP(v)) {
            return LispCall.RES_STRING;
        }
        Object w = JavaLinkDist.pointerValue(v);
        if (w == v) {
            return LispCall.RES_LISP_POINTER;
        }
        String s = w.getClass().getName();
        if (s.equals("[I")) {
            return LispCall.RES_INT_ARRAY;
        }
        if (s.equals("[D")) {
            return LispCall.RES_DOUBLE_ARRAY;
        }
        if (s.equals("[Ljava.lang.String;")) {
            return LispCall.RES_STRING_ARRAY;
        }
        return LispCall.RES_JAVA_POINTER;
    }

    JLWrapper.TypeCode getTypeCode(TranStruct v) {
        if (JavaLinkDist.nullP(v)) {
            return JLWrapper.TypeCode.NULL;
        }
        if (JavaLinkDist.booleanP(v)) {
            return JLWrapper.TypeCode.BOOL;
        }
        if (JavaLinkDist.longP(v)) {
            return JLWrapper.TypeCode.LONG;
        }
        if (JavaLinkDist.integerP(v)) {
            return JLWrapper.TypeCode.INT;
        }
        if (JavaLinkDist.realP(v)) {
            return JLWrapper.TypeCode.DOUBLE;
        }
        if (JavaLinkDist.errorP(v)) {
            return JLWrapper.TypeCode.ERROR;
        }
        if (JavaLinkDist.symbolP(v)) {
            return JLWrapper.TypeCode.SYMBOL;
        }
        if (JavaLinkDist.stringP(v)) {
            return JLWrapper.TypeCode.STRING;
        }
        Object w = JavaLinkDist.pointerValue(v);
        if (w == v) {
            return JLWrapper.TypeCode.LISP_POINTER;
        }
        String s = w.getClass().getName();
        if (s.equals("[I")) {
            return JLWrapper.TypeCode.INT_ARRAY;
        }
        if (s.equals("[D")) {
            return JLWrapper.TypeCode.DOUBLE_ARRAY;
        }
        if (s.equals("[Ljava.lang.String;")) {
            return JLWrapper.TypeCode.STRING_ARRAY;
        }
        return JLWrapper.TypeCode.JAVA_POINTER;
    }

    @Override
    @Deprecated
    synchronized int typeOf(int i) {
        TranStruct[] resarray = (TranStruct[])this.lci.res;
        if (i + 1 >= resarray.length) {
            return LispCall.RES_MISSING;
        }
        return this.typeOf(this.getValue(i));
    }

    @Override
    JLWrapper.TypeCode getTypeCode(int i) {
        return this.getTypeCode(this.getValue(i));
    }

    TranStruct getValueTr(int i) {
        return this.getValue(i);
    }

    @Override
    synchronized int intValue(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.integerP(v)) {
            return JavaLinkDist.intValue(v);
        }
        throw new UnsupportedOperationException("intValue of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized long longValue(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.longP(v)) {
            return JavaLinkDist.longValue(v);
        }
        if (JavaLinkDist.integerP(v)) {
            return JavaLinkDist.intValue(v);
        }
        throw new UnsupportedOperationException("longValue of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized double doubleValue(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.realP(v)) {
            return JavaLinkDist.doubleValue(v);
        }
        throw new UnsupportedOperationException("doubleValue of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized boolean booleanValue(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.booleanP(v)) {
            return JavaLinkDist.boolValue(v);
        }
        throw new UnsupportedOperationException("booleanValue of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized String stringValue(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.stringP(v)) {
            return JavaLinkDist.stringValue(v);
        }
        throw new UnsupportedOperationException("stringValue of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized int[] intArrayValue(int i) {
        TranStruct v = this.getValueTr(i);
        int s = this.typeOf(v);
        if (s == LispCall.RES_INT_ARRAY) {
            return (int[])JavaLinkDist.pointerValue(v);
        }
        throw new UnsupportedOperationException("intArrayValue of " + LispCall.nameOfType(s));
    }

    @Override
    synchronized String[] stringArrayValue(int i) {
        TranStruct v = this.getValueTr(i);
        int s = this.typeOf(v);
        if (s == LispCall.RES_STRING_ARRAY) {
            return (String[])JavaLinkDist.pointerValue(v);
        }
        throw new UnsupportedOperationException("stringArrayValue of " + LispCall.nameOfType(s));
    }

    @Override
    synchronized double[] doubleArrayValue(int i) {
        TranStruct v = this.getValueTr(i);
        int s = this.typeOf(v);
        if (s == LispCall.RES_DOUBLE_ARRAY) {
            return (double[])JavaLinkDist.pointerValue(v);
        }
        throw new UnsupportedOperationException("doubleArrayValue of " + LispCall.nameOfType(s));
    }

    @Override
    synchronized Object objectValue(int i) {
        Object w;
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.pointerP(v) && (w = JavaLinkDist.pointerValue(v)) != v) {
            return w;
        }
        throw new UnsupportedOperationException("objectValue of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized String symbolName(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.symbolP(v)) {
            return JavaLinkDist.symbolName(v);
        }
        throw new UnsupportedOperationException("symbolName of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized String symbolPackage(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.symbolP(v)) {
            return JavaLinkDist.symbolPackage(v);
        }
        throw new UnsupportedOperationException("symbolPackage of " + LispCall.nameOfType(this.typeOf(v)));
    }

    @Override
    synchronized String lispType(int i) {
        TranStruct v = this.getValueTr(i);
        if (JavaLinkDist.pointerP(v) && v == JavaLinkDist.pointerValue(v)) {
            return JavaLinkDist.stringValue(v);
        }
        return LispCall.nameOfType(this.typeOf(v));
    }

    @Override
    synchronized int query(boolean doquery, boolean dofetch) throws JavaLinkDist.JLinkerException {
        TranStruct[] resarray = null;
        if (this.lci.res != null) {
            resarray = (TranStruct[])this.lci.res;
        }
        switch (this.lci.state) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return -100;
            }
            case 3: {
                if (this.lci.res == null) {
                    return -99;
                }
                if (resarray.length == 0) {
                    return 0;
                }
                return JavaLinkDist.intValue(resarray[0]);
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return -100;
            }
        }
        if (this.lci.waitref == null) {
            return -100;
        }
        if (doquery && this.lci.state == 4) {
            this.lci.res = resarray = JavaLinkDist.invokeInLispEx(2, JavaLinkDist.newDistOb("cl:car"), new TranStruct[]{(TranStruct)this.lci.waitref});
            int rc = JavaLinkDist.intValue(resarray[1]);
            if (rc >= 0) {
                this.lci.waitres = rc;
                this.lci.state = 5;
            } else if (rc == -98) {
                this.lci.waitres = rc;
                this.lci.res = null;
                this.lci.state = 5;
            } else if (rc == -99) {
                this.lci.res = null;
                this.lci.state = 3;
                return -99;
            }
        }
        if (dofetch && this.lci.state == 5) {
            this.lci.res = resarray = JavaLinkDist.invokeInLispEx(2, JavaLinkDist.newDistOb("net.jlinker::jl-async-results"), new TranStruct[]{(TranStruct)this.lci.waitref});
            this.lci.state = 3;
            if (this.lci.res == null) {
                return 0;
            }
            if (((TranStruct[])this.lci.res).length == 0) {
                return 0;
            }
            return JavaLinkDist.intValue(resarray[0]);
        }
        if (this.lci.state == 5) {
            if (doquery) {
                return this.lci.waitres;
            }
            return -11;
        }
        return -10;
    }

    @Override
    synchronized void close() {
    }

    @Override
    synchronized void reset() {
    }

    synchronized void setArgWrapped(int i, JLWrapper aa) {
        TranStruct arg = (TranStruct)aa;
        switch (this.lci.state) {
            case 1: {
                this.assemble("setArg");
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.lci.throwWrongState("setArg", "");
            }
        }
        ((TranStruct[])this.lci.args)[i] = arg;
    }

    @Override
    synchronized void setArg(int i, boolean arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, int arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, byte arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, short arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, long arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, double arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, float arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, String arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, Object arg) {
        if (opclass.isInstance(arg)) {
            this.setArgWrapped(i, (JLWrapper)arg);
        } else {
            this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
        }
    }

    @Override
    synchronized void setArg(int i, int[] arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, byte[] arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, short[] arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, double[] arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, float[] arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setArg(int i, String[] arg) {
        this.setArgWrapped(i, JavaLinkDist.newDistOb(arg));
    }

    @Override
    synchronized void setSymbol(int i, String name) {
        this.setArg(i, JavaLinkDist.newDistSym(name, "", 0));
    }

    @Override
    synchronized void setSymbol(int i, String name, String pk) {
        this.setArg(i, JavaLinkDist.newDistSym(name, pk, 0));
    }

    @Override
    synchronized void setSymbol(int i, String name, String pk, int act) {
        this.setArg(i, JavaLinkDist.newDistSym(name, pk, act));
    }

    @Override
    int mayCall() {
        return 2;
    }
}

