/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JLCommonSocket;
import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.TranStruct;
import com.franz.jlinker.Transport;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLinkDist {
    public static final String TR_HOMEImmediate = "Self";
    public static final int TR_NONE = 0;
    public static final int TR_RemoteWidth = 3;
    public static final int TR_IndirectShift = 0;
    public static final int TR_IMMEDIATE = 0;
    public static final int TR_INDIRECT = 1;
    public static final int TR_LastShift = 1;
    public static final int TR_KEEP = 0;
    public static final int TR_DISCARD = 1;
    public static final int TR_DiscardShift = 2;
    public static final int TR_LIVE = 0;
    public static final int TR_DISCARDED = 1;
    public static final int TR_RankWidth = 5;
    public static final int TR_RankShift = 3;
    public static final int TR_HIRANK = 31;
    public static final int TR_BaseWidth = 5;
    public static final int TR_ExtnWidth = 3;
    public static final int TR_BaseShift = 8;
    public static final int TR_ExtnShift = 13;
    public static final int TR_BYTE = 1;
    public static final int TR_SHORT = 2;
    public static final int TR_INT = 3;
    public static final int TR_LONG = 4;
    public static final int TR_CHAR = 5;
    public static final int TR_STRING = 6;
    public static final int TR_SINGLE = 7;
    public static final int TR_DOUBLE = 8;
    public static final int TR_BOOL = 9;
    public static final int TR_SYMBOL = 10;
    public static final int TR_MESSAGE = 30;
    public static final int TR_NULL = 31;
    public static final int TR_AggrWidth = 8;
    public static final int TR_AggrShift = 16;
    public static final int TR_AggrMask = 255;
    public static final int TR_POINTER = 1;
    public static final int TR_ARRAY = 4;
    public static final int TR_CLASS = 5;
    public static final int TR_CONSTRUCTOR = 6;
    public static final int TR_METHOD = 7;
    public static final int TR_ERROR = 61;
    public static final int TR_INDEXWIDTH = 29;
    public static final int TR_MKActivate = 1;
    public static final int TR_MKMessage = 2;
    public static final int TR_MKDiscard = 3;
    public static final int TR_MKInvoke = 4;
    public static final int TR_MKNotify = 5;
    public static final int TR_EXTNMASK = 57344;
    public static final int TR_EXBYTES = 8192;
    public static final int TR_EXSHORTS = 16384;
    public static final int TR_EXFLOATS = 24576;
    static JavaLinkDist localServer = null;
    static boolean remoteReady = false;
    static Hashtable<Integer, Object> table;
    static int connectIndex;
    static int nextIndex;
    static int tableLive;
    static int tableFree;
    static int oldestFree;
    static int newestFree;
    static int topIndex;
    String localName = "Java";
    Object nullMarker = new Integer(0);
    Object[] ans = new Object[3];
    static final int IGNORE = 0;
    static final int setIMM = 1;
    static final int setIND = 2;
    static final int setLIVE = 1;
    static final int setLAST = 2;
    static final int setDEAD = 3;
    public static boolean end;

    static {
        connectIndex = -1;
        topIndex = 0x20000000;
        end = false;
    }

    public static Object lispError(LispException x) {
        return x.lispErr;
    }

    public static boolean query() {
        return JavaLinkDist.query(false);
    }

    public static boolean query(boolean verify) {
        if (JavaLinkDist.defaultRemoteP()) {
            if (verify) {
                TranStruct[] r = JavaLinkDist.invokeInLisp(2, JavaLinkDist.newDistOb("cl:values"), new TranStruct[0]);
                if (r.length == 1 && JavaLinkDist.integerP(r[0]) && JavaLinkDist.intValue(r[0]) == 0) {
                    return true;
                }
                JavaLinkDist.closeDist();
            } else {
                return true;
            }
        }
        return false;
    }

    public static void disconnect() {
        JavaLinkCommon.ltoj_anchor.activate(99, new String[0]);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (JLCommonSocket.javaToLispPort != null) {
            JLCommonSocket.javaToLispPort.shutdown();
        }
        if (JLCommonSocket.lispToJavaThread != null) {
            JLCommonSocket.lispToJavaThread.shutdown();
        }
    }

    public static boolean advertise(int port, int timeoutSeconds) {
        return JavaLinkDist.advertiseInner(false, "", "", port, timeoutSeconds);
    }

    public static boolean advertise(String l2j, String host, int port, int timeoutSeconds) {
        if ("".equals(l2j)) {
            l2j = JLCommonSocket.default_l2j;
        }
        return JavaLinkDist.advertiseInner(true, l2j, host, port, timeoutSeconds);
    }

    static boolean advertiseInner(boolean writeFile, String l2j, String host, int port, int timeoutSeconds) {
        JavaLinkCommon.dsprint("JavaLinkDist.advertiseInner: Advertising connection " + (writeFile ? "in file " + l2j : "") + " at " + host + ":" + port + " timeout=" + timeoutSeconds + "seconds");
        Transport.timeout = timeoutSeconds * 1000;
        Object cp = Transport.makeClientDataPort(l2j, host, port);
        if (cp instanceof Object[]) {
            port = (Integer)((Object[])cp)[0];
            cp = ((Object[])cp)[1];
        }
        new JLCommonSocket(cp, port, host);
        if (!JavaLinkDist.connectionComplete()) {
            return false;
        }
        JavaLinkCommon.dsprint("JavaLinkDist.advertiseInner: done.");
        return true;
    }

    public static boolean connectionComplete() {
        int wc = 0;
        while (!JavaLinkDist.defaultRemoteP()) {
            block8: {
                block7: {
                    if (!JavaLinkDist.defaultRemoteP()) break block7;
                    return true;
                }
                Thread.sleep(100L);
                if (!JavaLinkDist.defaultRemoteP()) break block8;
                return true;
            }
            try {
                if (++wc > 300) {
                    JavaLinkCommon.dsprint("JavaLinkDist.connectionComplete: failing with timeout.");
                    if (JLCommonSocket.lispToJavaThread != null && JLCommonSocket.lispToJavaThread.adFactory instanceof Object[]) {
                        JLCommonSocket.lispToJavaThread.adFactory[0] = null;
                        Thread.sleep(2000L);
                    }
                    throw new JLCommonSocket.CannotConnect("Timeout waiting for remote server.");
                }
                if (wc != 4 && wc != 24 && wc != 154) continue;
                JavaLinkCommon.dsprint("JavaLinkDist.connectionComplete: waiting for remote server...");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean connect(String j2l, int pollInterval, int pollCount) {
        return JavaLinkDist.connectLoop(true, j2l, "", 0, pollInterval, pollCount);
    }

    public static boolean connect(String j2l, String javaHost, int javaPort, int pollInterval, int pollCount) {
        return JavaLinkDist.connectLoop(true, j2l, "", 0, pollInterval, pollCount);
    }

    public static boolean connect(String host, int port, int pollInterval, int pollCount) {
        return JavaLinkDist.connectLoop(false, "", host, port, pollInterval, pollCount);
    }

    public static boolean connect(String lispHost, int lispPort, String javaHost, int javaPort, int pollInterval, int pollCount) {
        return JavaLinkDist.connectLoop(false, "", lispHost, lispPort, pollInterval, pollCount);
    }

    /*
     * Unable to fully structure code
     */
    static boolean connectLoop(boolean findFile, String j2l, String lHost, int lPort, int pollInterval, int pollCount) {
        if (!JavaLinkDist.query(false)) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            pollCount = pollInterval < 0 ? -1 : --pollCount;
            if (pollCount < 0) {
                return false;
            }
            try {
                Thread.sleep(pollInterval);
                continue;
            }
            catch (Exception var6_6) {
                // empty catch block
            }
lbl11:
            // 3 sources

            ** while (!JavaLinkDist.connectInner((boolean)findFile, (String)j2l, (String)lHost, (int)lPort))
        }
lbl12:
        // 1 sources

        return true;
    }

    static boolean connectInner(boolean findFile, String j2l, String lHost, int lPort) {
        if (JavaLinkDist.query(false)) {
            return true;
        }
        if (findFile) {
            JavaLinkCommon.dsprint("JavaLinkDist.connectInner(" + j2l + ")");
            try {
                new JLCommonSocket(j2l, "", 0);
            }
            catch (Exception e) {
                JavaLinkCommon.dsprint("JavaLinkDist.connectInner: failed " + e);
                return false;
            }
        }
        JavaLinkCommon.dsprint("JavaLinkDist.connectInner(" + lHost + ":" + lPort + ")");
        try {
            new JLCommonSocket("", lHost, lPort);
        }
        catch (JLCommonSocket.CannotConnect e) {
            throw e;
        }
        catch (Exception e) {
            JavaLinkCommon.dsprint("JavaLinkDist.connectInner: failed " + e);
            return false;
        }
        if (!JavaLinkDist.connectionComplete()) {
            return false;
        }
        JavaLinkCommon.dsprint("JavaLinkDist.connectInner: done.");
        return true;
    }

    public static synchronized void initDist() {
        table = new Hashtable();
        nextIndex = 1001;
        tableLive = 0;
        tableFree = 0;
        oldestFree = 0;
        newestFree = 0;
        connectIndex = (int)(System.currentTimeMillis() >> 13 & (long)(topIndex - 1));
    }

    public static synchronized void closeDist() {
        JavaLinkDist.initDist();
        localServer = null;
        remoteReady = false;
    }

    public static int getServerInstances() {
        if (localServer == null) {
            localServer = new JavaLinkDist();
        }
        return 1;
    }

    public JavaLinkDist() {
        localServer = this;
        JavaLinkDist.initDist();
    }

    synchronized void registerJavaObject(Object x, TranStruct struct) {
        int ix;
        if (nextIndex < topIndex && (tableFree == 0 || 2 * tableFree < tableLive)) {
            ix = nextIndex++;
        } else {
            ix = oldestFree;
            oldestFree = (Integer)table.get(new Integer(oldestFree));
            --tableFree;
        }
        table.put(new Integer(ix), x);
        struct.nums[0] = ix;
        struct.nums[1] = connectIndex;
        ++tableLive;
    }

    synchronized String extractJavaType(TranStruct ob) {
        if (ob == this.ans[2]) {
            return (String)this.ans[0];
        }
        this.ans[1] = null;
        this.ans[2] = ob;
        this.extractJavaItem(ob);
        return (String)this.ans[0];
    }

    synchronized Object extractJavaRef(TranStruct ob) {
        if (ob == this.ans[2]) {
            return this.ans[1];
        }
        this.ans[1] = null;
        this.ans[2] = ob;
        this.extractJavaItem(ob);
        return this.ans[1];
    }

    void extractJavaItem(TranStruct ob) {
        if (!JavaLinkDist.liveP(ob)) {
            this.ans[0] = "err";
            this.ans[1] = "Discarded Object 1";
            return;
        }
        if (JavaLinkDist.remoteP(ob)) {
            this.ans[0] = "remote";
            this.ans[1] = ob;
            return;
        }
        if (JavaLinkDist.indirectP(ob)) {
            Object v = table.get(new Integer(ob.nums[0]));
            if (v == null) {
                this.ans[0] = "err";
                this.ans[1] = "Unregistered object 2";
                return;
            }
            if (v == this.nullMarker) {
                this.ans[0] = "err";
                this.ans[1] = "Discarded object";
                return;
            }
            this.ans[0] = "indirect";
            this.ans[1] = v;
            return;
        }
        if (JavaLinkDist.rankP(ob, 0)) {
            this.ans[0] = "immediate";
            switch (JavaLinkDist.getTypeBits(ob, 5, 8)) {
                case 10: {
                    this.ans[0] = "remote";
                    this.ans[1] = ob;
                    return;
                }
                case 1: {
                    this.ans[1] = new Byte((byte)ob.nums[0]);
                    break;
                }
                case 2: {
                    this.ans[1] = new Short((short)ob.nums[0]);
                    break;
                }
                case 3: {
                    this.ans[1] = new Integer(ob.nums[0]);
                    break;
                }
                case 4: {
                    this.ans[1] = new Long(JavaLinkDist.longValue(ob));
                    break;
                }
                case 7: {
                    this.ans[1] = new Float((float)ob.reals[0]);
                    break;
                }
                case 8: {
                    this.ans[1] = new Double(ob.reals[0]);
                    break;
                }
                case 5: {
                    this.ans[1] = new Character(ob.strings[0].charAt(0));
                    break;
                }
                case 6: {
                    this.ans[1] = ob.strings[0];
                    break;
                }
                case 9: {
                    if (ob.nums[0] == 0) {
                        this.ans[1] = Boolean.FALSE;
                        break;
                    }
                    this.ans[1] = Boolean.TRUE;
                    break;
                }
                case 31: {
                    break;
                }
                default: {
                    this.ans[1] = "Unknown object base type";
                    this.ans[0] = "err";
                }
            }
            return;
        }
        if (JavaLinkDist.rankP(ob, 1)) {
            this.ans[0] = "immediate";
            switch (JavaLinkDist.getTypeBits(ob, 5, 8)) {
                case 3: {
                    this.ans[1] = ob.nums.clone();
                    break;
                }
                case 6: {
                    this.ans[1] = ob.strings.clone();
                    break;
                }
                case 8: {
                    this.ans[1] = ob.reals.clone();
                    break;
                }
                case 1: {
                    if (8192 == (0xE000 & ob.type)) {
                        this.ans[1] = ob.getExdata();
                        break;
                    }
                    byte[] ta = new byte[ob.nums.length];
                    int i = 0;
                    while (i < ta.length) {
                        ta[i] = (byte)ob.nums[i];
                        ++i;
                    }
                    this.ans[1] = ta;
                    break;
                }
                case 2: {
                    if (16384 == (0xE000 & ob.type)) {
                        this.ans[1] = ob.getExdata();
                        break;
                    }
                    short[] ta = new short[ob.nums.length];
                    int i = 0;
                    while (i < ta.length) {
                        ta[i] = (short)ob.nums[i];
                        ++i;
                    }
                    this.ans[1] = ta;
                    break;
                }
                case 7: {
                    if (24576 == (0xE000 & ob.type)) {
                        this.ans[1] = ob.getExdata();
                        break;
                    }
                    float[] ta = new float[ob.reals.length];
                    int i = 0;
                    while (i < ta.length) {
                        ta[i] = (float)ob.reals[i];
                        ++i;
                    }
                    this.ans[1] = ta;
                    break;
                }
                default: {
                    this.ans[1] = "Unknown object base type";
                    this.ans[0] = "err";
                }
            }
            return;
        }
        this.ans[0] = "err";
        this.ans[1] = "Unknown object type";
    }

    public Class<?> extractClassRef(TranStruct ob, Object jv) throws ClassNotFoundException, ClassCastException {
        if (JavaLinkDist.stringP(ob)) {
            String s = (String)jv;
            if (s.equals("bool")) {
                return Boolean.TYPE;
            }
            if (s.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (s.equals("byte")) {
                return Byte.TYPE;
            }
            if (s.equals("char")) {
                return Character.TYPE;
            }
            if (s.equals("double")) {
                return Double.TYPE;
            }
            if (s.equals("float")) {
                return Float.TYPE;
            }
            if (s.equals("int")) {
                return Integer.TYPE;
            }
            if (s.equals("long")) {
                return Long.TYPE;
            }
            if (s.equals("short")) {
                return Short.TYPE;
            }
            if (s.equals("void")) {
                return Void.TYPE;
            }
            return Class.forName(s);
        }
        return (Class)jv;
    }

    public void discard(int[] nums) {
        int i = 0;
        while (i < nums.length) {
            this.discard(nums[i]);
            ++i;
        }
    }

    public void discard(int num) {
        if (tableFree == 0) {
            oldestFree = num;
        } else {
            table.put(new Integer(newestFree), new Integer(num));
        }
        ++tableFree;
        newestFree = num;
        table.put(new Integer(num), this.nullMarker);
        --tableLive;
    }

    public TranStruct[] invoke(int style, TranStruct op, TranStruct[] args) {
        TranStruct[] res;
        int i;
        boolean FORNAME = true;
        int GETMETH = 2;
        int GETCONS = 3;
        int METHOD = 4;
        int NEWINST = 5;
        int NEWARRAY = 6;
        int GETFIELD = 7;
        int SETFIELD = 8;
        int GETSTATIC = 9;
        int SETSTATIC = 10;
        int QUERYFREE = 51;
        int QUERYLIVE = 52;
        int ERROR = 99;
        int rtype = 1;
        String rclass = "";
        Class<?> target = null;
        String name = "";
        int argerrs = 0;
        String argerrm = "Arg err:";
        boolean errp = false;
        Object v = null;
        String errm = "";
        Object errv = "";
        try {
            int call = 99;
            TranStruct dop = op;
            String s = this.extractJavaType(dop);
            Object jmeth = this.extractJavaRef(dop);
            Object job = new Object();
            if (s.equalsIgnoreCase("err")) {
                errm = "Op err: " + jmeth;
            } else if (JavaLinkDist.stringP(dop)) {
                s = (String)jmeth;
                if (args.length == 1 && s.equalsIgnoreCase("forName")) {
                    call = 1;
                } else if (args.length > 1 && s.equalsIgnoreCase("getMethod")) {
                    call = 2;
                } else if (args.length > 0 && s.equalsIgnoreCase("getConstructor")) {
                    call = 3;
                } else if (args.length > 1 && s.equalsIgnoreCase("newArray")) {
                    call = 6;
                } else if (args.length == 3 && s.equalsIgnoreCase("getField")) {
                    call = 7;
                } else if (args.length == 4 && s.equalsIgnoreCase("setField")) {
                    call = 8;
                } else if (args.length == 2 && s.equalsIgnoreCase("getStatic")) {
                    call = 9;
                } else if (args.length == 3 && s.equalsIgnoreCase("setStatic")) {
                    call = 10;
                } else if (args.length == 0 && s.equalsIgnoreCase("queryFree")) {
                    call = 51;
                } else if (args.length == 0 && s.equalsIgnoreCase("queryLive")) {
                    call = 52;
                } else {
                    errm = "Unknown op string: " + s;
                }
            } else if (s.equalsIgnoreCase("indirect")) {
                s = jmeth.getClass().getName();
                if (args.length > 0 && s.equals("java.lang.reflect.Method")) {
                    call = 4;
                } else if (s.equals("java.lang.reflect.Constructor")) {
                    call = 5;
                } else {
                    errm = "Bad op class: " + s;
                }
            } else {
                errm = "Unknown op: " + s;
            }
            switch (call) {
                case 1: {
                    v = this.extractClassRef(args[0], this.extractJavaRef(args[0]));
                    break;
                }
                case 2: {
                    Object jarg;
                    TranStruct darg;
                    Class[] cargs = new Class[args.length - 2];
                    i = 0;
                    while (i < args.length) {
                        darg = args[i];
                        s = this.extractJavaType(darg);
                        jarg = this.extractJavaRef(darg);
                        if (s.equalsIgnoreCase("err")) {
                            ++argerrs;
                            argerrm = String.valueOf(argerrm) + " " + i + ": " + (String)jarg + " ";
                        }
                        switch (i) {
                            case 0: {
                                target = this.extractClassRef(darg, jarg);
                                break;
                            }
                            case 1: {
                                name = (String)jarg;
                                break;
                            }
                            default: {
                                cargs[i - 2] = this.extractClassRef(darg, jarg);
                            }
                        }
                        ++i;
                    }
                    if (argerrs > 0) {
                        errp = true;
                        errm = argerrm;
                        break;
                    }
                    v = target.getMethod(name, cargs);
                    break;
                }
                case 3: {
                    Object jarg;
                    TranStruct darg;
                    Class[] cargs = new Class[args.length - 1];
                    i = 0;
                    while (i < args.length) {
                        darg = args[i];
                        s = this.extractJavaType(darg);
                        jarg = this.extractJavaRef(darg);
                        if (s.equalsIgnoreCase("err")) {
                            ++argerrs;
                            argerrm = String.valueOf(argerrm) + " " + i + ": " + (String)jarg + " ";
                        }
                        switch (i) {
                            case 0: {
                                target = this.extractClassRef(darg, jarg);
                                break;
                            }
                            default: {
                                cargs[i - 1] = this.extractClassRef(darg, jarg);
                            }
                        }
                        ++i;
                    }
                    if (argerrs > 0) {
                        errp = true;
                        errm = argerrm;
                        break;
                    }
                    v = target.getConstructor(cargs);
                    break;
                }
                case 6: {
                    Object jarg;
                    TranStruct darg;
                    int[] iargs = new int[args.length - 1];
                    i = 0;
                    while (i < args.length) {
                        darg = args[i];
                        s = this.extractJavaType(darg);
                        jarg = this.extractJavaRef(darg);
                        if (s.equalsIgnoreCase("err")) {
                            ++argerrs;
                            argerrm = String.valueOf(argerrm) + " " + i + ": " + (String)jarg + " ";
                        }
                        switch (i) {
                            case 0: {
                                target = this.extractClassRef(darg, jarg);
                                break;
                            }
                            default: {
                                iargs[i - 1] = ((Number)jarg).intValue();
                            }
                        }
                        ++i;
                    }
                    if (argerrs > 0) {
                        errp = true;
                        errm = argerrm;
                        break;
                    }
                    v = Array.newInstance(target, iargs);
                    break;
                }
                case 7: {
                    target = this.extractClassRef(args[0], this.extractJavaRef(args[0]));
                    s = JavaLinkDist.stringValue(args[1]);
                    Object jarg = this.extractJavaRef(args[2]);
                    Field fieldHandle = target.getField(s);
                    v = fieldHandle.get(jarg);
                    rtype = 2;
                    rclass = fieldHandle.getType().getName();
                    break;
                }
                case 8: {
                    target = this.extractClassRef(args[0], this.extractJavaRef(args[0]));
                    s = JavaLinkDist.stringValue(args[1]);
                    Object jarg = this.extractJavaRef(args[2]);
                    Field fieldHandle = target.getField(s);
                    job = this.extractJavaRef(args[3]);
                    fieldHandle.set(jarg, job);
                    rtype = 0;
                    v = new Integer(0);
                    break;
                }
                case 9: {
                    target = this.extractClassRef(args[0], this.extractJavaRef(args[0]));
                    s = JavaLinkDist.stringValue(args[1]);
                    Field fieldHandle = target.getField(s);
                    v = fieldHandle.get(null);
                    rtype = 2;
                    rclass = fieldHandle.getType().getName();
                    break;
                }
                case 10: {
                    target = this.extractClassRef(args[0], this.extractJavaRef(args[0]));
                    s = JavaLinkDist.stringValue(args[1]);
                    Field fieldHandle = target.getField(s);
                    job = this.extractJavaRef(args[2]);
                    fieldHandle.set(null, job);
                    rtype = 0;
                    v = new Integer(0);
                    break;
                }
                case 4: {
                    Object jarg;
                    TranStruct darg;
                    Object[] jargs = new Object[args.length - 1];
                    i = 0;
                    while (i < args.length) {
                        darg = args[i];
                        s = this.extractJavaType(darg);
                        jarg = this.extractJavaRef(darg);
                        if (s.equalsIgnoreCase("err")) {
                            ++argerrs;
                            argerrm = String.valueOf(argerrm) + " " + i + ": " + (String)jarg + " ";
                        }
                        if (i == 0) {
                            job = jarg;
                        } else {
                            jargs[i - 1] = jarg;
                        }
                        ++i;
                    }
                    if (argerrs > 0) {
                        errp = true;
                        errm = argerrm;
                        break;
                    }
                    v = ((Method)jmeth).invoke(job, jargs);
                    rtype = 2;
                    rclass = ((Method)jmeth).getReturnType().getName();
                    break;
                }
                case 5: {
                    Object jarg;
                    TranStruct darg;
                    Object[] jargs = new Object[args.length];
                    i = 0;
                    while (i < args.length) {
                        darg = args[i];
                        s = this.extractJavaType(darg);
                        jarg = this.extractJavaRef(darg);
                        if (s.equalsIgnoreCase("err")) {
                            ++argerrs;
                            argerrm = String.valueOf(argerrm) + " " + i + ": " + (String)jarg + " ";
                        }
                        jargs[i] = jarg;
                        ++i;
                    }
                    if (argerrs > 0) {
                        errp = true;
                        errm = argerrm;
                        break;
                    }
                    v = ((Constructor)jmeth).newInstance(jargs);
                    break;
                }
                case 51: {
                    v = new Integer(tableFree);
                    rtype = 0;
                    break;
                }
                case 52: {
                    v = new Integer(tableLive);
                    rtype = 0;
                    break;
                }
                case 99: {
                    errp = true;
                    break;
                }
                default: {
                    errp = true;
                    errm = "Bad method ref";
                    break;
                }
            }
        }
        catch (InvocationTargetException e) {
            errp = true;
            errv = e.getTargetException();
            errm = errv.toString();
        }
        catch (Throwable e) {
            errp = true;
            errm = e.toString();
            errv = e;
        }
        if (errp) {
            res = new TranStruct[]{JavaLinkDist.newDistOb(errm), JavaLinkDist.newDistOb(errv)};
        } else if (style < 1) {
            res = new TranStruct[]{};
        } else {
            res = new TranStruct[2];
            res[0] = JavaLinkDist.newDistOb(1);
            res[1] = v == null ? JavaLinkDist.nullDistOb() : (rtype == 0 ? this.unwrap(v) : (rtype == 1 ? this.wrap(v) : (rclass.equals("java.lang.String") ? (style == 1 ? this.wrap(v) : this.unwrap(v)) : (rclass.equals("boolean") || rclass.equals("byte") || rclass.equals("char") || rclass.equals("double") || rclass.equals("float") || rclass.equals("int") || rclass.equals("long") || rclass.equals("short") ? this.unwrap(v) : (style == 1 ? this.wrap(v) : this.unwrap(v))))));
        }
        if (JavaLinkDist.lastUseP(op)) {
            this.discard(op.nums[0]);
        }
        i = 0;
        while (i < args.length) {
            if (JavaLinkDist.lastUseP(args[i])) {
                this.discard(args[i].nums[0]);
            }
            ++i;
        }
        return res;
    }

    TranStruct wrap(Object x) {
        if (x instanceof TranStruct) {
            return (TranStruct)x;
        }
        return JavaLinkDist.newDistOb(x);
    }

    TranStruct unwrap(Object ref) {
        if (ref instanceof Boolean) {
            return JavaLinkDist.newDistOb((Boolean)ref);
        }
        if (ref instanceof Character) {
            return JavaLinkDist.newDistOb(((Character)ref).charValue());
        }
        if (ref instanceof Byte) {
            return JavaLinkDist.newDistOb((Byte)ref);
        }
        if (ref instanceof Short) {
            return JavaLinkDist.newDistOb((Short)ref);
        }
        if (ref instanceof Integer) {
            return JavaLinkDist.newDistOb((Integer)ref);
        }
        if (ref instanceof Long) {
            return JavaLinkDist.newDistOb((Long)ref);
        }
        if (ref instanceof Float) {
            return JavaLinkDist.newDistOb(((Float)ref).floatValue());
        }
        if (ref instanceof Double) {
            return JavaLinkDist.newDistOb((Double)ref);
        }
        if (ref instanceof String) {
            return JavaLinkDist.newDistOb((String)ref);
        }
        String s = ref.getClass().getName();
        if (s.equals("[Ljava.lang.String;")) {
            return JavaLinkDist.newDistOb((String[])ref);
        }
        if (s.equals("[B")) {
            return JavaLinkDist.newDistOb((byte[])ref);
        }
        if (s.equals("[S")) {
            return JavaLinkDist.newDistOb((short[])ref);
        }
        if (s.equals("[I")) {
            return JavaLinkDist.newDistOb((int[])ref);
        }
        if (s.equals("[F")) {
            return JavaLinkDist.newDistOb((float[])ref);
        }
        if (s.equals("[D")) {
            return JavaLinkDist.newDistOb((double[])ref);
        }
        return this.wrap(ref);
    }

    public static int getBits(int base, int width, int shift) {
        int mask = (1 << width) - 1 << shift;
        return (base & mask) >> shift;
    }

    public static int setBits(int inbase, int newbase, int width, int shift) {
        int base = inbase;
        int mask = (1 << width) - 1 << shift;
        base |= mask;
        base ^= mask;
        return base |= mask & newbase << shift;
    }

    static int getTypeBits(TranStruct struct, int width, int shift) {
        return JavaLinkDist.getBits(struct.type, width, shift);
    }

    static TranStruct setImmediate(TranStruct str) {
        return JavaLinkDist.setRemote(str, 1, 1);
    }

    static TranStruct setRemote(TranStruct str, int indirection, int discard) {
        int base = str.type;
        switch (indirection) {
            case 1: {
                base = JavaLinkDist.setBits(base, 0, 1, 0);
                break;
            }
            case 2: {
                base = JavaLinkDist.setBits(base, 1, 1, 0);
            }
        }
        switch (discard) {
            case 1: {
                base = JavaLinkDist.setBits(base, 0, 1, 1);
                base = JavaLinkDist.setBits(base, 0, 1, 2);
                break;
            }
            case 2: {
                base = JavaLinkDist.setBits(base, 1, 1, 1);
                break;
            }
            case 3: {
                base = JavaLinkDist.setBits(base, 0, 1, 1);
                base = JavaLinkDist.setBits(base, 1, 1, 2);
            }
        }
        str.type = base;
        return str;
    }

    static TranStruct setType(TranStruct str, int base, int rank, int aggr) {
        int obtype = str.type;
        obtype = JavaLinkDist.setBits(obtype, base, 5, 8);
        obtype = JavaLinkDist.setBits(obtype, rank, 5, 3);
        str.type = obtype = JavaLinkDist.setBits(obtype, aggr, 8, 16);
        return str;
    }

    public static TranStruct nullDistOb() {
        TranStruct x = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        JavaLinkDist.setImmediate(x);
        JavaLinkDist.setType(x, 31, 0, 0);
        if (Transport.exData == 0) {
            x.type |= 0xE000;
        }
        return x;
    }

    public static TranStruct newDistOb(boolean x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        str.nums[0] = x ? 1 : 0;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 9, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(byte x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        str.nums[0] = x;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 1, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(short x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        str.nums[0] = x;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 2, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(int x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[0], new double[0]);
        str.nums[0] = x;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 3, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(long x) {
        int bits;
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[4], new String[0], new double[0]);
        int mask = 0x1FFFFFFF;
        int sign = 1;
        if (x < 0L) {
            sign = -1;
            x = -(x + 1L);
        }
        str.nums[0] = bits = (int)(x & (long)mask);
        str.nums[1] = bits = (int)((x >>= 29) & (long)mask);
        str.nums[2] = (int)(x >>= 29);
        str.nums[3] = sign;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 4, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(char x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[1], new double[0]);
        char[] s = new char[]{x};
        str.strings[0] = new String(s);
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 5, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(String x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[1], new double[0]);
        str.strings[0] = x;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 6, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(float x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[1]);
        str.reals[0] = x;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 7, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(double x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[1]);
        str.reals[0] = x;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 8, 0, 0);
        return str;
    }

    public static TranStruct newDistOb(String[] x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], x, new double[0]);
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 6, 1, 0);
        return str;
    }

    public static TranStruct newDistOb(byte[] x) {
        if (Transport.exData == 0) {
            int[] cp = new int[x.length];
            int i = 0;
            while (i < x.length) {
                cp[i] = x[i];
                ++i;
            }
            TranStruct str = new TranStruct(TR_HOMEImmediate, 0, cp, new String[0], new double[0]);
            JavaLinkDist.setImmediate(str);
            JavaLinkDist.setType(str, 1, 1, 0);
            return str;
        }
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        str.setExdata(x);
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 1, 1, 0);
        str.type |= 0x2000;
        return str;
    }

    public static TranStruct newDistOb(short[] x) {
        if (Transport.exData == 0) {
            int[] cp = new int[x.length];
            int i = 0;
            while (i < x.length) {
                cp[i] = x[i];
                ++i;
            }
            TranStruct str = new TranStruct(TR_HOMEImmediate, 0, cp, new String[0], new double[0]);
            JavaLinkDist.setImmediate(str);
            JavaLinkDist.setType(str, 2, 1, 0);
            return str;
        }
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        str.setExdata(x);
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 2, 1, 0);
        str.type |= 0x4000;
        return str;
    }

    public static TranStruct newDistOb(int[] x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, x, new String[0], new double[0]);
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 3, 1, 0);
        return str;
    }

    public static TranStruct newDistOb(float[] x) {
        if (Transport.exData == 0) {
            double[] cp = new double[x.length];
            int i = 0;
            while (i < x.length) {
                cp[i] = x[i];
                ++i;
            }
            TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], cp);
            JavaLinkDist.setImmediate(str);
            JavaLinkDist.setType(str, 7, 1, 0);
            return str;
        }
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], new double[0]);
        str.setExdata(x);
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 7, 1, 0);
        str.type |= 0x6000;
        return str;
    }

    public static TranStruct newDistOb(double[] x) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[0], new String[0], x);
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 8, 1, 0);
        return str;
    }

    public static TranStruct newDistOb(TranStruct x) {
        return x;
    }

    public static TranStruct newDistOb(Object x) {
        return JavaLinkDist.newDistOb(x, localServer);
    }

    public static TranStruct newDistOb(Throwable x) {
        return JavaLinkDist.newDistOb(x, localServer);
    }

    public static TranStruct newDistOb(Object x, JavaLinkDist server) {
        int tt;
        int rr;
        String[] ss;
        int[] nn;
        if (x == null) {
            return JavaLinkDist.nullDistOb();
        }
        if (x instanceof TranStruct) {
            return (TranStruct)x;
        }
        if (x instanceof LispException) {
            return JavaLinkDist.newDistOb(((LispException)x).lispErr);
        }
        if (x instanceof Throwable) {
            return JavaLinkDist.newDistOb((Throwable)x, server);
        }
        String cln = x.getClass().getName();
        if (cln.startsWith("[")) {
            int[] nArray = new int[3];
            nArray[2] = Array.getLength(x);
            nn = nArray;
            ss = new String[]{cln};
            rr = 1;
            tt = 4;
        } else if (x instanceof Class) {
            nn = new int[2];
            ss = new String[]{cln, ((Class)x).getName()};
            rr = 0;
            tt = 5;
        } else if (x instanceof Constructor) {
            nn = new int[2];
            ss = JavaLinkDist.addSig(((Constructor)x).getParameterTypes(), cln, ((Constructor)x).getDeclaringClass().getName(), "");
            rr = 0;
            tt = 6;
        } else if (x instanceof Method) {
            nn = new int[2];
            ss = JavaLinkDist.addSig(((Method)x).getParameterTypes(), cln, ((Method)x).getDeclaringClass().getName(), ((Method)x).getName());
            rr = 0;
            tt = 7;
        } else {
            nn = new int[2];
            ss = new String[]{cln};
            rr = 0;
            tt = 1;
        }
        TranStruct str = new TranStruct(server.localName, 0, nn, ss, new double[0]);
        JavaLinkDist.setRemote(str, 2, 1);
        JavaLinkDist.setType(str, 0, rr, tt);
        server.registerJavaObject(x, str);
        return str;
    }

    static String[] addSig(Class<?>[] args, String s0, String s1, String s2) {
        int l = 2;
        if (s2.length() > 0) {
            ++l;
        }
        String[] ss = new String[l + args.length];
        ss[0] = s0;
        ss[1] = s1;
        if (l == 3) {
            ss[2] = s2;
        }
        int i = 0;
        while (i < args.length) {
            ss[l + i] = args[i].getName();
            ++i;
        }
        return ss;
    }

    public static TranStruct newDistOb(Throwable x, JavaLinkDist server) {
        TranStruct str = new TranStruct(server.localName, 0, new int[2], new String[2], new double[0]);
        str.strings[0] = x.getClass().getName();
        str.strings[1] = x.toString();
        JavaLinkDist.setRemote(str, 2, 1);
        JavaLinkDist.setType(str, 0, 0, 61);
        server.registerJavaObject(x, str);
        return str;
    }

    public static TranStruct newDistSym(String name, String pkg, int cmd) {
        TranStruct str = new TranStruct(TR_HOMEImmediate, 0, new int[1], new String[2], new double[0]);
        str.strings[0] = name;
        str.strings[1] = pkg;
        str.nums[0] = cmd;
        JavaLinkDist.setImmediate(str);
        JavaLinkDist.setType(str, 10, 0, 0);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean liveP(TranStruct str) {
        TranStruct tranStruct = str;
        synchronized (tranStruct) {
            block6: {
                block5: {
                    if (!JavaLinkDist.immediateP(str)) break block5;
                    return true;
                }
                if (!JavaLinkDist.localP(str) || connectIndex == str.nums[1]) break block6;
                JavaLinkDist.setRemote(str, 0, 3);
                return false;
            }
            return JavaLinkDist.getTypeBits(str, 1, 2) == 0;
        }
    }

    static boolean immediateP(TranStruct str) {
        return JavaLinkDist.getTypeBits(str, 1, 0) == 0;
    }

    static boolean indirectP(TranStruct str) {
        return 1 == JavaLinkDist.getTypeBits(str, 1, 0);
    }

    static boolean localP(TranStruct str) {
        return str.home.equalsIgnoreCase(JavaLinkDist.localServer.localName);
    }

    static boolean remoteP(TranStruct str) {
        return !str.home.equalsIgnoreCase(TR_HOMEImmediate) && !str.home.equalsIgnoreCase(JavaLinkDist.localServer.localName);
    }

    static boolean lastUseP(TranStruct str) {
        return 1 == JavaLinkDist.getTypeBits(str, 1, 1);
    }

    public static TranStruct lastUse(TranStruct str) {
        return JavaLinkDist.setRemote(str, 0, 2);
    }

    static boolean aggrP(TranStruct str, int tp) {
        return tp == JavaLinkDist.getTypeBits(str, 8, 16);
    }

    static boolean rankP(TranStruct str, int n) {
        int r = JavaLinkDist.getTypeBits(str, 5, 3);
        if (r == 31) {
            return n == str.nums[2];
        }
        return n == r;
    }

    static boolean baseP(TranStruct str, int tp) {
        return tp == JavaLinkDist.getTypeBits(str, 5, 8);
    }

    public static boolean nullP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 31);
    }

    public static boolean booleanP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 9);
    }

    public static boolean integerP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && (JavaLinkDist.baseP(str, 1) || JavaLinkDist.baseP(str, 2) || JavaLinkDist.baseP(str, 3));
    }

    public static boolean byteP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 1);
    }

    public static boolean shortP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 2);
    }

    public static boolean intP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 3);
    }

    public static boolean longP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 4);
    }

    public static boolean charP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 5);
    }

    public static boolean realP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && (JavaLinkDist.baseP(str, 7) || JavaLinkDist.baseP(str, 8));
    }

    public static boolean singleP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 7);
    }

    public static boolean doubleP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 8);
    }

    public static boolean stringP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 6);
    }

    public static boolean symbolP(TranStruct str) {
        return JavaLinkDist.immediateP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.baseP(str, 10);
    }

    public static boolean errorP(TranStruct str) {
        return JavaLinkDist.indirectP(str) && JavaLinkDist.liveP(str) && JavaLinkDist.remoteP(str) && JavaLinkDist.rankP(str, 0) && JavaLinkDist.aggrP(str, 61);
    }

    public static boolean pointerP(TranStruct str) {
        return JavaLinkDist.indirectP(str) && JavaLinkDist.liveP(str);
    }

    public static boolean boolValue(TranStruct str) {
        return JavaLinkDist.intValue(str) != 0;
    }

    public static int intValue(TranStruct str) {
        return JavaLinkDist.intValue(str, 0);
    }

    public static int intValue(TranStruct str, int i) {
        if (i < str.nums.length) {
            return str.nums[i];
        }
        return 0;
    }

    public static long longValue(TranStruct str) {
        long x0 = JavaLinkDist.intValue(str, 0);
        long x1 = JavaLinkDist.intValue(str, 1);
        long x2 = JavaLinkDist.intValue(str, 2);
        long sign = JavaLinkDist.intValue(str, 3);
        if (sign == 0L) {
            sign = 1L;
        }
        return sign * (x0 + (x1 + (x2 << 29) << 29));
    }

    public static double doubleValue(TranStruct str) {
        return JavaLinkDist.doubleValue(str, 0);
    }

    public static double doubleValue(TranStruct str, int i) {
        if (i < str.reals.length) {
            return str.reals[0];
        }
        return 0.0;
    }

    public static char charValue(TranStruct str) {
        return JavaLinkDist.charValue(str, 0, 0);
    }

    public static char charValue(TranStruct str, int j) {
        return JavaLinkDist.charValue(str, j, 0);
    }

    public static char charValue(TranStruct str, int j, int i) {
        if (i < str.strings.length && j < str.strings[i].length()) {
            return str.strings[i].charAt(j);
        }
        return '\u0000';
    }

    public static String stringValue(TranStruct str) {
        return JavaLinkDist.stringValue(str, 0);
    }

    public static String stringValue(TranStruct str, int i) {
        if (i < str.strings.length) {
            return str.strings[i];
        }
        return "";
    }

    public static String symbolName(TranStruct str) {
        return JavaLinkDist.stringValue(str, 0);
    }

    public static String symbolPackage(TranStruct str) {
        return JavaLinkDist.stringValue(str, 1);
    }

    public static int symbolCaseModes(TranStruct str) {
        return JavaLinkDist.intValue(str, 0);
    }

    public static Object pointerValue(TranStruct x) {
        return JavaLinkDist.pointerValue(x, localServer);
    }

    public static Object pointerValue(TranStruct x, JavaLinkDist server) {
        return server.extractJavaRef(x);
    }

    public static boolean defaultRemoteP() {
        if (localServer == null) {
            return false;
        }
        return remoteReady;
    }

    public static boolean defaultRemotePAndSet() {
        if (localServer == null) {
            return false;
        }
        remoteReady = true;
        return true;
    }

    public static void discardInLisp(TranStruct str) {
        if (JavaLinkDist.liveP(str) && JavaLinkDist.remoteP(str)) {
            int[] anum = new int[]{str.nums[0]};
            localServer.discardInLispConn(anum);
            JavaLinkDist.setRemote(str, 0, 3);
        }
    }

    public static TranStruct[] applyInLisp(int style, TranStruct fn, TranStruct arglist) {
        TranStruct[] args = new TranStruct[]{fn, arglist};
        return JavaLinkDist.invokeInLisp(style, JavaLinkDist.newDistOb("cl:apply"), args);
    }

    public static TranStruct[] applyInLispEx(int style, TranStruct fn, TranStruct arglist) throws JLinkerException {
        TranStruct[] args = new TranStruct[]{fn, arglist};
        return JavaLinkDist.invokeInLispEx(style, JavaLinkDist.newDistOb("cl:apply"), args);
    }

    public static TranStruct[] invokeInLisp(int style, String op, int arg) {
        return JavaLinkDist.invokeInLisp(style, JavaLinkDist.newDistOb(op), new TranStruct[]{JavaLinkDist.newDistOb(arg)});
    }

    public static TranStruct[] invokeInLispEx(int style, String op, int arg) throws JLinkerException {
        return JavaLinkDist.invokeInLispEx(style, JavaLinkDist.newDistOb(op), new TranStruct[]{JavaLinkDist.newDistOb(arg)});
    }

    public static TranStruct[] invokeInLisp(int style, String op, String arg) {
        return JavaLinkDist.invokeInLisp(style, JavaLinkDist.newDistOb(op), new TranStruct[]{JavaLinkDist.newDistOb(arg)});
    }

    public static TranStruct[] invokeInLispEx(int style, String op, String arg) throws JLinkerException {
        return JavaLinkDist.invokeInLispEx(style, JavaLinkDist.newDistOb(op), new TranStruct[]{JavaLinkDist.newDistOb(arg)});
    }

    public static TranStruct[] invokeInLisp(int style, String op) {
        return JavaLinkDist.invokeInLisp(style, JavaLinkDist.newDistOb(op), new TranStruct[0]);
    }

    public static TranStruct[] invokeInLispEx(int style, String op) throws JLinkerException {
        return JavaLinkDist.invokeInLispEx(style, JavaLinkDist.newDistOb(op), new TranStruct[0]);
    }

    public static TranStruct[] invokeInLisp(int style, TranStruct op, TranStruct[] args) {
        TranStruct[] result = localServer.invokeInLispConn(style, op, args);
        int i = 0;
        while (i < args.length) {
            if (JavaLinkDist.lastUseP(args[i])) {
                JavaLinkDist.setRemote(args[i], 0, 3);
            }
            ++i;
        }
        return result;
    }

    public static TranStruct[] invokeInLispEx(int style, TranStruct op, TranStruct[] args) throws JLinkerException {
        TranStruct[] result = JavaLinkDist.invokeInLisp(style, op, args);
        if (result.length == 0) {
            if (style == -1) {
                return result;
            }
            if (style == 0) {
                return result;
            }
            throw new InvokeException("Nothing returned from Lisp");
        }
        if (JavaLinkDist.integerP(result[0]) && JavaLinkDist.intValue(result[0]) == result.length - 1) {
            return result;
        }
        if (1 == result.length && JavaLinkDist.errorP(result[0])) {
            throw new LispException(JavaLinkDist.stringValue(result[0], 1), result[0]);
        }
        if (1 == result.length && JavaLinkDist.stringP(result[0]) && JavaLinkDist.stringValue(result[0]).equalsIgnoreCase("Throw in Lisp")) {
            throw new LispThrow();
        }
        if (1 == result.length) {
            throw new InvokeException("Unexpected value: " + result[0].toString());
        }
        throw new InvokeException("Unexpected result: " + result.toString());
    }

    public void discardInLispConn(int[] nums) {
        int[] numseq = new int[2 + nums.length];
        numseq[0] = -1;
        numseq[1] = 3;
        int i = 0;
        while (i < nums.length) {
            numseq[2 + i] = nums[i];
            ++i;
        }
        TranStruct d = new TranStruct(TR_HOMEImmediate, 7680, numseq, new String[0], new double[0]);
        if (Transport.exData == 0) {
            d.type |= 0xE000;
        }
        TranStruct[] s = new TranStruct[]{d};
        JLCommonSocket.javaToLispPort.invoke(s, true);
    }

    public TranStruct[] invokeInLispConn(int style, TranStruct op, TranStruct[] args) {
        TranStruct[] s = new TranStruct[2 + args.length];
        TranStruct d = new TranStruct(TR_HOMEImmediate, 7680, new int[]{style, 4}, new String[0], new double[0]);
        if (Transport.exData == 0) {
            d.type |= 0xE000;
        }
        s[0] = d;
        s[1] = op;
        int i = 0;
        while (i < args.length) {
            s[2 + i] = args[i];
            ++i;
        }
        switch (style) {
            case -1: {
                JLCommonSocket.javaToLispPort.invoke(s, true);
                return new TranStruct[0];
            }
            case 0: {
                JLCommonSocket.javaToLispPort.invoke(s);
                return new TranStruct[0];
            }
        }
        Object v = JLCommonSocket.javaToLispPort.invoke(s);
        try {
            if (TranStruct.getArrayLength(v) >= 0) {
                return (TranStruct[])v;
            }
            if (TranStruct.getObjectArrayLength(v) >= 0) {
                return TranStruct.toArray(v);
            }
            return new TranStruct[]{JavaLinkDist.newDistOb(v.toString())};
        }
        catch (Exception e) {
            return new TranStruct[]{JavaLinkDist.newDistOb(e), JavaLinkDist.newDistOb(v)};
        }
    }

    public static void main(String[] args) throws Exception {
        int p = 0;
        Transport.notifier = new Transport.PortPrinter();
        JavaLinkCommon.sdebug = true;
        JavaLinkDist.advertise(p, 600);
        while (!end) {
            Thread.sleep(2000L);
        }
        JavaLinkDist.disconnect();
    }

    public static class InvokeException
    extends JLinkerException {
        private static final long serialVersionUID = 1L;

        InvokeException(String x) {
            super(x);
        }
    }

    public static class JLinkerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        JLinkerException(String x) {
            super(x);
        }
    }

    public static class LispException
    extends JLinkerException {
        private static final long serialVersionUID = 1L;
        Object lispErr;

        LispException(String y, Object l) {
            super(y);
            this.lispErr = l;
        }
    }

    public static class LispThrow
    extends JLinkerException {
        private static final long serialVersionUID = 1L;

        LispThrow() {
            super("Throw in Lisp");
        }
    }
}

