/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JavaLinkCommon;
import com.franz.jlinker.TranStruct;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class Transport {
    public static final int ONE_WAY_CODE = 15;
    public static final int MESSAGE_CODE = 17;
    public static final int RESPONSE_CODE = 33;
    public static final int REQUEST_CODE = 18;
    public static final int REPLY_CODE = 34;
    public static final int ERROR_CODE = 62;
    public static final int DISCONNECT_CODE = 63;
    public static final int INVOKE_CODE = 19;
    public static final int ARGLIST_CODE = 20;
    public static final int RESULT_CODE = 35;
    public static final int ANSWER_CODE = 36;
    public static final int STRING_CODE = 66;
    public static final int INT_CODE = 65;
    public static final int SEQINT_CODE = 99;
    public static final int SEQSTRING_CODE = 101;
    public static final int SEQREAL_CODE = 103;
    public static final int EMPTY_SEQI_CODE = 98;
    public static final int EMPTY_SEQS_CODE = 100;
    public static final int EMPTY_SEQR_CODE = 102;
    public static final int EMPTY_SEQB_CODE = 104;
    public static final int SEQBYTE_CODE = 105;
    public static final int EMPTY_SEQK_CODE = 106;
    public static final int SEQSHORT_CODE = 107;
    public static final int EMPTY_SEQF_CODE = 110;
    public static final int SEQFLOAT_CODE = 111;
    public static final int NULL_CODE = 96;
    public static final int DEFAULT_BUFFER_SIZE = 512;
    public static final int SEQ_LENGTH_LIMIT = 0x1000000;
    public static final int PORT_IDLE = 0;
    public static final int PORT_CLOSED = -1;
    public static final int PORT_REQUEST = 3;
    public static final int PORT_WAITING_RESPONSE = 2;
    public static final int PORT_WAITING_REPLY = 4;
    public static final int PORT_MESSAGE = 1;
    public static final int PORT_INVOKE = 5;
    public static final int PORT_WAITING_RESULT = 6;
    public static final int TM_EXTNMASK = 57344;
    public static final int TM_EXBYTES = 8192;
    public static final int TM_EXSHORTS = 16384;
    public static final int TM_EXFLOATS = 24576;
    public static final String lispHomeName = "Lisp";
    public static int varInt = 0;
    public static int exData = 0;
    private boolean kindServer = false;
    private boolean kindClient = false;
    int state = -1;
    int oneWay = 0;
    public static final int ERR_PORT_CLASS = -101;
    public static final int ERR_PORT_STATE = -102;
    public static final int ERR_CALLBACK = -103;
    public static final int ERR_PROTOCOL = -104;
    public static final int ERR_REQUEST = -105;
    public static final int ERR_VAL_TYPE = -106;
    public static final int ERR_TOO_LONG = -107;
    public static final int ERR_PORT_IO = -108;
    public static final int ERR_FLUSH_IO = -108;
    public static final int ERR_THROW = -109;
    public static final int ERR_RESPONSE = -110;
    public static final int ERR_BUSY = -111;
    Socket socket;
    InputStream inStream;
    OutputStream outStream;
    byte[] buffer = new byte[512];
    int endpos = 0;
    Object[] iData;
    Thread softLock = null;
    static int debugClient = 0;
    static int debugServer = 0;
    public static final Class<Transport> thisClass = Transport.class;
    static boolean makeFlag = false;
    public static PortNotifier notifier = null;
    public static long timeout = 86400000L;
    static boolean connectFlag = false;
    int haveCode = 1000000;

    public static String debug(int cl, int sr) {
        int oldc = debugClient;
        if (cl >= 0) {
            debugClient = cl;
        }
        int olds = debugServer;
        if (sr >= 0) {
            debugServer = sr;
        }
        return "Client was " + oldc + " now " + debugClient + "  Server was " + olds + " now " + debugServer;
    }

    boolean debugP(int level) {
        return level <= (this.kindServer ? debugServer : debugClient);
    }

    Transport() {
    }

    Transport(String k, Socket s) throws IOException {
        if (k.equals("server")) {
            this.kindServer = true;
        } else {
            this.kindClient = true;
        }
        this.socket = s;
        this.inStream = new BufferedInputStream(s.getInputStream());
        this.outStream = new BufferedOutputStream(s.getOutputStream());
        this.state = 0;
        this.softLock = null;
    }

    private void printKind(int level, String msg) {
        if (this.debugP(level)) {
            System.out.println(String.valueOf(this.kindServer ? "server" : "client") + msg);
        }
    }

    public static Object makeServerDataPort(String file, int port) {
        return Transport.makeServerDataPort(file, "", port);
    }

    private static File advertFile(String file, String host, int port) throws IOException {
        JavaLinkCommon.dsprint("Transport.advertFile: Writing file " + file + " host:port=" + host + ":" + port);
        File fl = new File(file);
        FileWriter prt = null;
        try {
            prt = new FileWriter(fl);
            if (host.equals("")) {
                host = "localhost";
            }
            String pn = String.valueOf(host) + " " + String.valueOf(port) + "\n";
            prt.write(pn, 0, pn.length());
        }
        finally {
            if (prt != null) {
                prt.close();
            }
        }
        return fl;
    }

    public static Object makeServerDataPort(String file, String host, int port) {
        return Transport.makeDataPort("server", file, host, port);
    }

    public static Object makeClientDataPort(String file, String host, int port) {
        return Transport.makeDataPort("client", file, host, port);
    }

    /*
     * Exception decompiling
     */
    private static Object makeDataPort(String kind, String file, String host, int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] makeServerDataPort(int port) {
        ServerSocket factory = null;
        Object[] res = new Object[2];
        try {
            Class<Transport> clazz = thisClass;
            synchronized (clazz) {
                block10: {
                    if (!makeFlag) break block10;
                    res[0] = new Integer(-111);
                    res[1] = "makeServerDataPort is busy, try again later";
                    Object[] objectArray = res;
                    return objectArray;
                }
                makeFlag = true;
            }
            try {
                factory = new ServerSocket();
                factory.setReuseAddress(true);
                factory.bind(new InetSocketAddress(port));
                res[0] = new Integer(factory.getLocalPort());
                res[1] = factory;
            }
            catch (Exception e) {
                res[0] = new Integer(0);
                res[1] = e;
            }
            Object[] objectArray = res;
            return objectArray;
        }
        finally {
            makeFlag = false;
        }
    }

    /*
     * Exception decompiling
     */
    public static Object makeServerDataPort(Object[] h) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object makeServerDataPort(int port, String host) {
        try {
            Class<Transport> clazz = thisClass;
            synchronized (clazz) {
                block11: {
                    if (!makeFlag) break block11;
                    return "makeServerDataPort is busy, try again later";
                }
                makeFlag = true;
            }
            Transport connection = null;
            try {
                Socket client = new Socket(host, port);
                client.setTcpNoDelay(true);
                connection = new Transport("server", client);
            }
            catch (Exception e) {
                Exception exception = e;
                makeFlag = false;
                return exception;
            }
            Transport transport = connection;
            return transport;
        }
        finally {
            makeFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object connectToServer(String file) {
        try {
            Object[] objectArray;
            InputStreamReader str;
            block24: {
                Class<Transport> clazz = thisClass;
                synchronized (clazz) {
                    block23: {
                        if (!connectFlag) break block23;
                        return "connectToServer is busy, try again later";
                    }
                    connectFlag = true;
                }
                str = null;
                Transport connection = null;
                File fl = new File(file);
                str = new FileReader(fl);
                char[] bf = new char[100];
                int b = 0;
                int port = 0;
                b = str.read(bf, 0, 100);
                str.close();
                String s = new String(bf, 0, b);
                int n = s.indexOf(" ", 0);
                if (n < 1) {
                    throw new IOException("Ill-formed file");
                }
                String host = s.substring(0, n);
                while (s.startsWith(" ", n)) {
                    ++n;
                }
                port = Integer.parseInt(s.substring(n, b).trim());
                Socket server = new Socket(host, port);
                server.setTcpNoDelay(true);
                connection = new Transport("client", server);
                objectArray = new Object[]{new Integer(port), connection, host};
                if (str == null) break block24;
                try {
                    str.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return objectArray;
            catch (Exception e) {
                Exception exception;
                block25: {
                    try {
                        exception = e;
                        if (str == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (str != null) {
                            try {
                                str.close();
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        str.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                connectFlag = false;
                return exception;
            }
        }
        finally {
            connectFlag = false;
        }
    }

    public static Object connectToServer(int port) {
        return Transport.connectToServer("localhost", port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object connectToServer(String host, int port) {
        try {
            Class<Transport> clazz = thisClass;
            synchronized (clazz) {
                block11: {
                    if (!connectFlag) break block11;
                    return "connectToServer is busy, try again later";
                }
                connectFlag = true;
            }
            Transport connection = null;
            try {
                Socket server = new Socket(host, port);
                server.setTcpNoDelay(true);
                connection = new Transport("client", server);
            }
            catch (Exception e) {
                Exception exception = e;
                connectFlag = false;
                return exception;
            }
            Transport transport = connection;
            return transport;
        }
        finally {
            connectFlag = false;
        }
    }

    public void shutdown() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean disconnect() {
        switch (this.state) {
            case -1: {
                return false;
            }
            case 0: {
                if (!this.kindClient) break;
                this.message(-1, 63, true);
                try {
                    Thread.sleep(100L);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            this.state = -1;
            this.socket = null;
            this.inStream = null;
            this.outStream = null;
            this.socket.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Object doServer(Handler handler) {
        Object rep = "";
        this.oneWay = 0;
        while (this.state == 0) {
            int code = this.streamInCode();
            switch (code) {
                case 15: {
                    this.oneWay = 1;
                    break;
                }
                case 63: {
                    this.disconnect();
                    rep = "Disconnected";
                    break;
                }
                case 17: {
                    rep = this.doServerMessage(handler);
                    this.oneWay = 0;
                    break;
                }
                case 18: {
                    rep = this.doServerRequest(handler);
                    this.oneWay = 0;
                    break;
                }
                case 19: {
                    rep = this.doServerInvoke();
                    break;
                }
                case 20: {
                    rep = this.doServerArglist(handler);
                    break;
                }
                default: {
                    rep = "Bad code " + code;
                }
            }
            if (this.stringEqual("", rep)) continue;
            return rep;
        }
        return "Bad server state";
    }

    boolean stringEqual(Object x, Object y) {
        if (x instanceof String && y instanceof String) {
            return ((String)x).equals(y);
        }
        return false;
    }

    int streamInInt() throws IOException {
        return (Integer)this.streamInValue();
    }

    private Object doServerMessage(Handler handler) {
        int res = 0;
        int m = -1;
        try {
            m = this.portInInt();
        }
        catch (Exception e) {
            m = -1;
        }
        if (m <= 0) {
            return "Bad message code " + m;
        }
        res = -1;
        try {
            res = handler.doMessage(m);
        }
        catch (Exception e) {
            if (this.oneWay == 0) {
                this.respond(e);
            }
            if (this.debugP(1)) {
                return "Message " + m + " throws " + e;
            }
            return "";
        }
        try {
            if (this.oneWay == 0) {
                this.respond(res);
            }
        }
        catch (Exception e) {
            return "Respond to " + m + " throws " + e;
        }
        return "";
    }

    private Object doServerRequest(Handler handler) {
        Object rep = "No handler";
        String home = "";
        int kind = 0;
        try {
            home = (String)this.streamInValue();
            kind = this.streamInInt();
            int[] nums = (int[])this.streamInValue();
            String[] strings = (String[])this.streamInValue();
            double[] reals = (double[])this.streamInValue();
            rep = handler.doRequest(home, kind, nums, strings, reals);
        }
        catch (Exception e) {
            if (this.oneWay == 0) {
                this.respond(e);
            }
            return "Request " + home + " " + kind + " throws " + e;
        }
        try {
            if (this.oneWay == 0) {
                this.reply(rep);
            }
        }
        catch (Exception e) {
            return "Reply to " + home + " " + kind + " throws " + e;
        }
        return "";
    }

    private Object doServerInvoke() {
        int length = -1;
        TranStruct[] idt = null;
        try {
            length = this.portInInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (length < 0) {
            return "Bad invoke length " + length;
        }
        idt = new TranStruct[length];
        if (this.debugP(2)) {
            System.out.println("Transport.doInvoke length=" + length);
        }
        this.iData = new Object[]{new Integer(0), new Integer(length), idt};
        return "";
    }

    private Object doServerArglist(Handler handler) {
        int index;
        TranStruct[] idua;
        int ilen;
        int inext;
        block17: {
            if (this.iData == null) {
                return "bad server state";
            }
            Object[] ida = this.iData;
            inext = (Integer)ida[0];
            ilen = (Integer)ida[1];
            Object idu = ida[2];
            idua = (TranStruct[])idu;
            index = -1;
            try {
                index = this.portInInt();
                if (index == inext) break block17;
                return "protocol error";
            }
            catch (Exception e) {
                return "doInvokeArglist throws " + e;
            }
        }
        idua[index] = this.newTS(index, "Transport.doInvoke arg=");
        if (++inext == ilen) {
            TranStruct[] rdata;
            if (this.debugP(2)) {
                System.out.println("Transport.doInvoke calling");
            }
            try {
                rdata = handler.doInvoke(idua);
            }
            catch (Exception e) {
                if (this.oneWay == 0) {
                    this.respond(e);
                }
                return "doInvoke throws " + e;
            }
            if (this.debugP(2)) {
                System.out.println("Transport.doInvoke returns");
            }
            if (this.oneWay == 0) {
                try {
                    int rdlength = rdata.length;
                    if (this.debugP(2)) {
                        System.out.println("Transport.doInvoke result length=" + rdlength);
                    }
                    this.streamOutCode(35);
                    this.portOut(rdlength);
                    this.streamOutFlush();
                    int i = 0;
                    while (i < rdlength) {
                        this.sendResultPart(i, rdata[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    return "sendResultPart throws " + e;
                }
            } else {
                this.oneWay = 0;
            }
            this.iData = null;
        } else {
            ida[0] = new Integer(inext);
        }
        return "";
    }

    TranStruct newTS(int index, String where) throws IOException {
        String home = (String)this.streamInValue();
        int kind = this.streamInInt();
        int[] nums = (int[])this.streamInValue();
        String[] strings = (String[])this.streamInValue();
        double[] reals = (double[])this.streamInValue();
        if (this.debugP(2)) {
            System.out.println(String.valueOf(where) + index);
        }
        TranStruct ts = new TranStruct(home, kind, nums, strings, reals);
        switch (0xE000 & kind) {
            case 8192: 
            case 16384: 
            case 24576: {
                ts.setExdata(this.streamInValue());
            }
        }
        return ts;
    }

    public Object message(int messageValue) {
        return this.message(messageValue, 17, false);
    }

    public Object message(int messageValue, boolean ignore) {
        return this.message(messageValue, 17, ignore);
    }

    /*
     * Unable to fully structure code
     */
    synchronized String grabSoftLock(String from) {
        block4: {
            block3: {
                cur = Thread.currentThread();
                if (this.softLock != null) break block3;
                this.softLock = cur;
                break block4;
            }
            if (this.softLock != cur) ** GOTO lbl13
            return "Recursive call to" + from;
lbl-1000:
            // 1 sources

            {
                try {
                    this.wait();
                    continue;
                }
                catch (Exception var3_3) {
                    // empty catch block
                }
lbl13:
                // 3 sources

                ** while (this.softLock != null)
            }
lbl14:
            // 1 sources

            this.softLock = cur;
        }
        return "";
    }

    synchronized void dropSoftLock() {
        if (this.softLock == null) {
            return;
        }
        this.softLock = null;
        this.notifyAll();
    }

    Object message(int messageValue, int code, boolean ignore) {
        try {
            String gv = this.grabSoftLock("message()");
            if (gv.length() > 0) {
                String string = gv;
                return string;
            }
            int old = this.state;
            int ret = 0;
            Object eret = "";
            String eret0 = eret;
            try {
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        if (ignore) {
                            ret = this.streamOutCode(15);
                        }
                        if (ret >= 0) {
                            ret = this.streamOutCode(code);
                        }
                        if (ret >= 0 && messageValue >= 0) {
                            ret = this.portOut(messageValue);
                        }
                        if (ret >= 0) {
                            ret = this.streamOutFlush();
                        }
                        if (ret >= 0 && !ignore) {
                            eret = this.responseIn();
                        }
                        break;
                    }
                    default: {
                        ret = -102;
                        break;
                    }
                }
            }
            finally {
                this.state = old;
            }
            if (eret == eret0) {
                Integer n = new Integer(ret);
                return n;
            }
            String string = eret;
            return string;
        }
        finally {
            this.dropSoftLock();
        }
    }

    public Object request(String home) {
        return this.request(home, 0, new int[0], new String[0], new double[0]);
    }

    public Object request(String home, int type) {
        return this.request(home, type, new int[0], new String[0], new double[0]);
    }

    public Object request(String home, int type, int[] nums) {
        return this.request(home, type, nums, new String[0], new double[0]);
    }

    public Object request(String home, int type, int[] nums, String[] strings) {
        return this.request(home, type, nums, strings, new double[0]);
    }

    public Object request(String home, int type, int[] nums, String[] strings, double[] reals) {
        try {
            String gv = this.grabSoftLock("request()");
            if (gv.length() > 0) {
                Object[] objectArray = new Object[]{new Integer(-111), gv};
                return objectArray;
            }
            int old = this.state;
            int rc = 0;
            if (!this.kindClient) {
                Object[] objectArray = new Object[]{new Integer(-101), "request"};
                return objectArray;
            }
            try {
                switch (this.state) {
                    case 0: {
                        Object res;
                        this.state = 3;
                        rc = this.streamOutCode(18);
                        if (rc >= 0) {
                            rc = this.streamOut(home);
                        }
                        if (rc >= 0) {
                            rc = this.streamOut(type);
                        }
                        if (rc >= 0) {
                            rc = this.streamOut(nums);
                        }
                        if (rc >= 0) {
                            rc = this.streamOutStrings(home, strings);
                        }
                        if (rc >= 0) {
                            rc = this.streamOut(reals);
                        }
                        if (rc < 0) break;
                        Object object = res = this.replyIn();
                        return object;
                    }
                }
                rc = -102;
            }
            finally {
                this.state = old;
            }
            Object[] objectArray = new Object[]{new Integer(rc), "request"};
            return objectArray;
        }
        finally {
            this.dropSoftLock();
        }
    }

    int streamOutStrings(String home, String[] strings) {
        if (home.equalsIgnoreCase(lispHomeName)) {
            return this.streamOut(new String[0]);
        }
        return this.streamOut(strings);
    }

    public Object invoke(TranStruct[] args) {
        return this.invoke(args, false);
    }

    public Object invoke(TranStruct[] args, boolean ignore) {
        try {
            String gv = this.grabSoftLock("invoke()");
            if (gv.length() > 0) {
                Object[] objectArray = new Object[]{new Integer(-111), gv};
                return objectArray;
            }
            int old = this.state;
            int rc = 0;
            if (!this.kindClient) {
                Object[] objectArray = new Object[]{new Integer(-101), "invoke"};
                return objectArray;
            }
            try {
                switch (this.state) {
                    case 0: {
                        this.state = 5;
                        if (ignore) {
                            rc = this.streamOutCode(15);
                        }
                        if (rc >= 0) {
                            rc = this.streamOutCode(19);
                        }
                        if (rc >= 0) {
                            rc = this.portOut(args.length);
                        }
                        if (rc >= 0) {
                            rc = this.streamOutFlush();
                        }
                        if (rc >= 0) {
                            int i = 0;
                            while (i < args.length) {
                                if (args[i] != null && rc >= 0) {
                                    rc = this.invokeArg(i, args[i]);
                                }
                                ++i;
                            }
                        }
                        if (ignore) {
                            Object[] objectArray = new Object[]{};
                            return objectArray;
                        }
                        if (rc >= 0) {
                            Object v = this.resultIn();
                            this.printKind(1, " invoke => isArrayLen:" + TranStruct.getArrayLength(v) + " isArrayOfLen:" + TranStruct.getObjectArrayLength(v) + "  " + v);
                            Object object = v;
                            return object;
                        }
                        break;
                    }
                    default: {
                        rc = -102;
                        break;
                    }
                }
            }
            finally {
                this.state = old;
            }
            Object[] objectArray = new Object[]{new Integer(rc), "invoke"};
            return objectArray;
        }
        finally {
            this.dropSoftLock();
        }
    }

    int invokeArg(int i, TranStruct arg) {
        int rc;
        switch (this.state) {
            case 5: {
                rc = this.sendTS(20, i, arg, "invokeArg");
                break;
            }
            default: {
                rc = -102;
            }
        }
        return rc;
    }

    int sendTS(int code, int i, TranStruct arg, String where) {
        int rc;
        if (this.debugP(2)) {
            System.out.println(String.valueOf(where) + i);
        }
        if ((rc = this.streamOutCode(code)) >= 0) {
            rc = this.portOut(i);
        }
        if (rc >= 0) {
            rc = this.streamOut(arg.home);
        }
        if (rc >= 0) {
            rc = this.streamOut(arg.type);
        }
        if (rc >= 0) {
            rc = this.streamOut(arg.nums);
        }
        if (rc >= 0) {
            rc = this.streamOutStrings(arg.home, arg.strings);
        }
        if (rc >= 0) {
            rc = this.streamOut(arg.reals);
        }
        Object ex = arg.getExdata();
        switch (arg.type & 0xE000) {
            case 0: {
                break;
            }
            case 8192: {
                if (ex == null) {
                    ex = new byte[0];
                }
                this.streamOut((byte[])ex);
                break;
            }
            case 16384: {
                if (ex == null) {
                    ex = new short[0];
                }
                this.streamOut((short[])ex);
                break;
            }
            case 24576: {
                if (ex == null) {
                    ex = new float[0];
                }
                this.streamOut((float[])ex);
            }
        }
        this.streamOutFlush();
        return rc;
    }

    public synchronized int respond(int value) {
        this.streamOutCode(33);
        this.portOut(value);
        this.streamOutFlush();
        return 0;
    }

    synchronized int respond(Exception value) {
        this.streamOutCode(62);
        this.portOut(value.toString());
        this.streamOutFlush();
        return 0;
    }

    synchronized int reply(Object value) {
        this.streamOutCode(34);
        this.streamOut(value);
        this.streamOutFlush();
        return 0;
    }

    synchronized int sendResultPart(int i, TranStruct part) {
        return this.sendTS(36, i, part, "Transport.doInvoke resultPart ");
    }

    Object responseIn() {
        int old = this.state;
        int ret = 0;
        Object eret = "";
        String eret0 = eret;
        if (!this.kindClient) {
            return "responseIn: ERR_PORT_CLASS";
        }
        try {
            block3 : switch (this.state) {
                case 1: {
                    this.streamOutFlush();
                    this.state = 2;
                    switch (this.streamInCode()) {
                        case 33: {
                            try {
                                ret = this.portInInt();
                            }
                            catch (Exception e) {
                                eret = "responseIn->portInInt: " + e;
                            }
                            break block3;
                        }
                        case 62: {
                            try {
                                eret = this.portInString();
                            }
                            catch (Exception e) {
                                eret = "responseIn->portInString: " + e;
                            }
                            break block3;
                        }
                        case 18: {
                            eret = "responseIn: ERR_CALLBACK";
                            break block3;
                        }
                    }
                    eret = "responseIn: ERR_PROTOCOL";
                    break;
                }
                default: {
                    eret = "responseIn: ERR_PORT_STATE";
                    break;
                }
            }
        }
        finally {
            this.state = old;
        }
        if (eret == eret0) {
            eret = new Integer(ret);
        }
        this.printKind(1, " responseIn " + eret);
        return eret;
    }

    Object replyIn() {
        int old = this.state;
        Object res = null;
        if (!this.kindClient) {
            return "replyIn: ERR_PORT_CLASS";
        }
        try {
            block4 : switch (this.state) {
                case 3: {
                    this.streamOutFlush();
                    this.state = 4;
                    switch (this.streamInCode()) {
                        case 34: {
                            try {
                                res = this.streamInValue();
                            }
                            catch (Exception e) {
                                res = e;
                            }
                            this.printKind(1, " replyIn " + res);
                            Object object = res;
                            return object;
                        }
                        case 62: {
                            try {
                                res = this.portInString();
                            }
                            catch (Exception e) {
                                res = e;
                            }
                            this.printKind(1, " replyIn Err" + res);
                            break block4;
                        }
                        case 18: {
                            res = "replyIn: ERR_CALLBACK";
                            break block4;
                        }
                    }
                    res = "replyIn: ERR_PROTOCOL";
                    break;
                }
                default: {
                    res = "replyIn: ERR_PORT_STATE";
                    break;
                }
            }
        }
        finally {
            this.state = old;
        }
        return res;
    }

    Object resultIn() {
        Object[] eres;
        block17: {
            int old = this.state;
            if (!this.kindClient) {
                return "resultIn: ERR_PORT_CLASS";
            }
            try {
                block3 : switch (this.state) {
                    case 5: {
                        this.streamOutFlush();
                        this.state = 6;
                        switch (this.streamInCode()) {
                            case 35: {
                                try {
                                    int l = this.portInInt();
                                    Object[] res = new Object[l];
                                    this.printKind(1, " resultIn " + l);
                                    int i = 0;
                                    while (i < l) {
                                        res[i] = this.resultPartIn(i);
                                        ++i;
                                    }
                                    eres = res;
                                }
                                catch (Exception e) {
                                    eres = e;
                                }
                                break block17;
                            }
                            case 62: {
                                try {
                                    eres = this.portInString();
                                }
                                catch (Exception e) {
                                    eres = e;
                                }
                                this.printKind(1, " resultIn Err" + eres);
                                break block3;
                            }
                            case 18: {
                                eres = "resultIn: ERR_CALLBACK";
                                break block3;
                            }
                        }
                        eres = "resultIn: ERR_PROTOCOL";
                        break;
                    }
                    default: {
                        eres = "resultIn: ERR_PORT_STATE";
                        break;
                    }
                }
            }
            finally {
                this.state = old;
            }
        }
        return eres;
    }

    Object resultPartIn(int i) {
        int code = this.streamInCode();
        switch (code) {
            case 36: {
                try {
                    int inx = this.portInInt();
                    if (i != inx) {
                        return new Object[]{new Integer(-104), new Integer(i), new Integer(inx), "resultPartIn"};
                    }
                    return this.newTS(inx, "resultPartIn");
                }
                catch (Exception e) {
                    return e;
                }
            }
        }
        return new Object[]{new Integer(-104), new Integer(code), "resultPartIn"};
    }

    int streamOutFlush() {
        return this.portFlush();
    }

    int streamOutCode(int code) {
        return this.portOut((byte)code);
    }

    int streamOut(Object v) {
        if (v == null) {
            return this.streamOutCode(96);
        }
        if (v instanceof Integer) {
            return this.streamOut((Integer)v);
        }
        if (v instanceof String) {
            return this.streamOut((String)v);
        }
        String type = v.getClass().getName();
        if (type.equals("[I")) {
            return this.streamOut((int[])v);
        }
        if (type.equals("[D")) {
            return this.streamOut((double[])v);
        }
        if (type.equals("[Ljava.lang.String;")) {
            return this.streamOut((String[])v);
        }
        return -106;
    }

    int streamOut(String s) {
        this.printKind(2, " streamOut STRING: " + s);
        this.portOut((byte)66);
        return this.portOut(s);
    }

    int streamOut(int v) {
        this.printKind(2, " streamOut INT: " + v);
        this.portOut((byte)65);
        return this.portOut(v);
    }

    int streamOut(byte[] a) {
        if (a.length == 0) {
            this.printKind(2, " streamOut EMPTY_SEQB");
            this.portOut((byte)104);
            return 0;
        }
        if (a.length >= 0x1000000) {
            return -107;
        }
        this.printKind(2, " streamOut SEQBYTE " + a.length);
        this.portOut((byte)105);
        this.portOut(a.length);
        this.portOut(a);
        return a.length;
    }

    int streamOut(short[] a) {
        if (a.length == 0) {
            this.printKind(2, " streamOut EMPTY_SEQK");
            this.portOut((byte)106);
            return 0;
        }
        if (a.length >= 0x1000000) {
            return -107;
        }
        this.printKind(2, " streamOut SEQSHORT " + a.length);
        this.portOut((byte)107);
        this.portOut(a.length);
        int i = 0;
        while (i < a.length) {
            this.portOut(a[i]);
            ++i;
        }
        return a.length;
    }

    int streamOut(int[] a) {
        if (a.length == 0) {
            this.printKind(2, " streamOut EMPTY_SEQI");
            this.portOut((byte)98);
            return 0;
        }
        if (a.length >= 0x1000000) {
            return -107;
        }
        this.printKind(2, " streamOut SEQINT " + a.length);
        this.portOut((byte)99);
        this.portOut(a.length);
        int i = 0;
        while (i < a.length) {
            this.portOut(a[i]);
            ++i;
        }
        return a.length;
    }

    int streamOut(float[] a) {
        if (a.length == 0) {
            this.printKind(2, " streamOut EMPTY_SEQF");
            this.portOut((byte)110);
            return 0;
        }
        if (a.length >= 0x1000000) {
            return -107;
        }
        this.printKind(2, " streamOut SEQFLOAT " + a.length);
        this.portOut((byte)111);
        this.portOut(a.length);
        int i = 0;
        while (i < a.length) {
            this.portOut(a[i]);
            ++i;
        }
        return a.length;
    }

    int streamOut(double[] a) {
        if (a.length == 0) {
            this.printKind(2, " streamOut EMPTY_SEQR");
            this.portOut((byte)102);
            return 0;
        }
        if (a.length >= 0x1000000) {
            return -107;
        }
        this.printKind(2, " streamOut SEQREAL " + a.length);
        this.portOut((byte)103);
        this.portOut(a.length);
        int i = 0;
        while (i < a.length) {
            this.portOut(a[i]);
            ++i;
        }
        return a.length;
    }

    int streamOut(String[] a) {
        if (a.length == 0) {
            this.printKind(2, " streamOut EMPTY_SEQS");
            this.portOut((byte)100);
            return 0;
        }
        if (a.length >= 0x1000000) {
            return -107;
        }
        this.printKind(2, " streamOut SEQSTRING " + a.length);
        this.portOut((byte)101);
        this.portOut(a.length);
        int i = 0;
        while (i < a.length) {
            this.portOut(a[i]);
            ++i;
        }
        return a.length;
    }

    int streamInCode() {
        if (this.haveCode == 1000000) {
            return this.portIn_8();
        }
        int r = this.haveCode;
        this.haveCode = 1000000;
        return r;
    }

    int streamInCode(int code) {
        if (this.haveCode == 1000000) {
            this.haveCode = code;
            return code;
        }
        return -104;
    }

    Object streamInValue() throws IOException {
        String type;
        Object w = null;
        int code = this.streamInCode();
        switch (code) {
            case 66: {
                type = "STRING";
                w = this.portInString();
                break;
            }
            case 65: {
                type = "INT";
                w = new Integer(this.portInInt());
                break;
            }
            case 99: {
                type = "SEQINT";
                w = this.portInSeqInt();
                break;
            }
            case 101: {
                type = "SEQSTRING";
                w = this.portInSeqString();
                break;
            }
            case 103: {
                type = "SEQREAL";
                w = this.portInSeqReal();
                break;
            }
            case 105: {
                type = "SEQBYTE";
                w = this.portInSeqByte();
                break;
            }
            case 107: {
                type = "SEQSHORT";
                w = this.portInSeqShort();
                break;
            }
            case 111: {
                type = "SEQFLOAT";
                w = this.portInSeqFloat();
                break;
            }
            case 98: {
                type = "EMPTY_SEQI";
                w = new int[0];
                break;
            }
            case 102: {
                type = "EMPTY_SEQR";
                w = new double[0];
                break;
            }
            case 100: {
                type = "EMPTY_SEQS";
                w = new String[]{};
                break;
            }
            case 104: {
                type = "EMPTY_SEQB";
                w = new byte[0];
                break;
            }
            case 106: {
                type = "EMPTY_SEQK";
                w = new short[0];
                break;
            }
            case 110: {
                type = "EMPTY_SEQF";
                w = new float[0];
                break;
            }
            case 96: {
                type = "NULL";
                w = null;
                break;
            }
            default: {
                type = "NOT_DATA";
                w = null;
                this.streamInCode(code);
            }
        }
        this.printKind(2, " streamIn " + type + ": " + w);
        return w;
    }

    int portIn_8() {
        int res;
        try {
            res = this.inStream.read();
            this.printKind(5, " portIn_8: " + res);
        }
        catch (IOException e) {
            res = -108;
        }
        return res;
    }

    int portIn_16() {
        int lo = this.portIn_8();
        if (lo < 0) {
            return lo;
        }
        int hi = this.portIn_8();
        if (hi < 0) {
            return hi;
        }
        hi = lo + (hi << 8);
        this.printKind(4, " portIn_16: " + hi);
        return hi;
    }

    int portInInt() throws IOException {
        boolean neg;
        int count;
        int s = this.portIn_8();
        if (s < 0) {
            throw new IOException("portInInt->portIn_8=" + s);
        }
        switch (s) {
            case 0: {
                count = 4;
                neg = false;
                break;
            }
            case 1: {
                count = 4;
                neg = true;
                break;
            }
            case 2: {
                count = 3;
                neg = false;
                break;
            }
            case 3: {
                count = 3;
                neg = true;
                break;
            }
            case 4: {
                count = 2;
                neg = false;
                break;
            }
            case 5: {
                count = 2;
                neg = true;
                break;
            }
            case 6: {
                count = 1;
                neg = false;
                break;
            }
            case 7: {
                count = 1;
                neg = true;
                break;
            }
            case 8: {
                return -1;
            }
            default: {
                return s - 9;
            }
        }
        int v = 0;
        int shift = 0;
        int j = 0;
        while (j < count) {
            int w = this.portIn_8();
            if (w < 0) {
                throw new IOException("portInInt->portIn_8=" + w);
            }
            v |= w << shift;
            shift += 8;
            ++j;
        }
        if (neg) {
            v = -v;
        }
        this.printKind(3, " portInInt: " + v);
        return v;
    }

    String portInString() throws IOException {
        int len = this.portInInt();
        if (len < 0) {
            return null;
        }
        StringBuffer s = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            int b = this.portIn_16();
            if (b < 0) {
                throw new IOException("portIn=" + b);
            }
            s.append((char)b);
            ++i;
        }
        String v = s.toString();
        this.printKind(3, " portInString: " + v);
        return v;
    }

    int[] portInSeqInt() throws IOException {
        int len = this.portInInt();
        this.printKind(3, " portInSeqInt: " + len);
        int[] a = new int[len];
        int i = 0;
        while (i < len) {
            a[i] = this.portInInt();
            ++i;
        }
        return a;
    }

    short[] portInSeqShort() throws IOException {
        int len = this.portInInt();
        this.printKind(3, " portInSeqShort: " + len);
        short[] a = new short[len];
        int i = 0;
        while (i < len) {
            a[i] = (short)this.portInInt();
            ++i;
        }
        return a;
    }

    byte[] portInSeqByte() throws IOException {
        int len = this.portInInt();
        this.printKind(3, " portInSeqByte: " + len);
        byte[] a = new byte[len];
        int bytes = this.inStream.read(a);
        int s = len - bytes;
        if (bytes < len) {
            throw new IOException("streamInSeqByte short: " + s);
        }
        return a;
    }

    String[] portInSeqString() throws IOException {
        int len = this.portInInt();
        this.printKind(3, " portInSeqString: " + len);
        String[] a = new String[len];
        int i = 0;
        while (i < len) {
            a[i] = this.portInString();
            ++i;
        }
        return a;
    }

    float[] portInSeqFloat() throws IOException {
        int len = this.portInInt();
        this.printKind(3, " portInSeqFloat: " + len);
        float[] a = new float[len];
        int i = 0;
        while (i < len) {
            a[i] = this.portInFloat();
            ++i;
        }
        return a;
    }

    double[] portInSeqReal() throws IOException {
        int len = this.portInInt();
        this.printKind(3, " portInSeqReal: " + len);
        double[] a = new double[len];
        int i = 0;
        while (i < len) {
            a[i] = this.portInReal();
            ++i;
        }
        return a;
    }

    double portInReal() throws IOException {
        int s = this.portIn_8();
        if (s < 0) {
            throw new IOException("portInReal->portIn_8=" + s);
        }
        long e0 = this.portIn_8();
        if (e0 < 0L) {
            throw new IOException("portInReal->portIn_8=" + e0);
        }
        long e1 = this.portIn_8();
        if (e1 < 0L) {
            throw new IOException("portInReal->portIn_8=" + e1);
        }
        long v = 0L;
        int shift = 0;
        while (shift < 51) {
            long w = this.portIn_8();
            if (w < 0L) {
                throw new IOException("portInReal->portIn_8=" + w);
            }
            v |= w << shift;
            shift += 8;
        }
        v |= (e1 << 8 | e0) << 52;
        if (s != 0) {
            v |= Long.MIN_VALUE;
        }
        double r = Double.longBitsToDouble(v);
        this.printKind(3, " portInReal: " + r);
        return r;
    }

    float portInFloat() throws IOException {
        int s = this.portIn_8();
        if (s < 0) {
            throw new IOException("portInFloat->portIn_8=" + s);
        }
        int e0 = this.portIn_8();
        if (e0 < 0) {
            throw new IOException("portInFloat->portIn_8=" + e0);
        }
        int e1 = this.portIn_8();
        if (e1 < 0) {
            throw new IOException("portInFloat->portIn_8=" + e1);
        }
        int v = 0;
        int shift = 0;
        while (shift < 23) {
            int w = this.portIn_8();
            if (w < 0) {
                throw new IOException("portInFloat->portIn_8=" + w);
            }
            v |= w << shift;
            shift += 8;
        }
        v |= (e1 << 8 | e0) << 23;
        if (s != 0) {
            v |= Integer.MIN_VALUE;
        }
        float r = Float.intBitsToFloat(v);
        this.printKind(3, " portInFloat: " + r);
        return r;
    }

    int portFlush() {
        if (this.endpos > 0) {
            try {
                this.printKind(4, " portFlush " + this.endpos + " bytes: " + this.buffer[0] + " " + this.buffer[1] + "...");
                this.outStream.write(this.buffer, 0, this.endpos);
                this.outStream.flush();
            }
            catch (Exception e) {
                return -108;
            }
        }
        this.endpos = 0;
        return 0;
    }

    int portReserveSpace(int size) {
        int rc = 0;
        if (this.endpos + size > this.buffer.length) {
            rc = this.portFlush();
        }
        if (rc < 0) {
            return rc;
        }
        return this.endpos + size;
    }

    int portOut(byte x) {
        int rc = this.portReserveSpace(1);
        if (rc < 0) {
            return rc;
        }
        this.printKind(3, " portOut byte: " + x);
        this.bufferOut_8(x);
        return this.endpos;
    }

    int portOut(byte[] x) {
        int free = this.buffer.length - this.endpos;
        if (free < x.length) {
            this.portFlush();
        }
        int i = 0;
        while (i < x.length) {
            int rc = this.portReserveSpace(100);
            if (rc < 0) {
                return rc;
            }
            int end = i + 100;
            if (x.length < end) {
                end = x.length;
            }
            int j = i;
            while (j < end) {
                this.bufferOut_8(x[j]);
                ++j;
            }
            i += 100;
        }
        return this.endpos;
    }

    int portOut(char x) {
        int rc = this.portReserveSpace(2);
        if (rc < 0) {
            return rc;
        }
        this.printKind(4, " portOut char: " + x);
        this.bufferOut_16(x);
        return this.endpos;
    }

    int portOut(short x) {
        return this.portOut((int)x);
    }

    int portOut(int x) {
        int len;
        int top;
        int tag;
        long v = x;
        if (v < 0L) {
            v = -v;
            if (varInt == 0) {
                tag = 1;
                top = 32;
                len = 5;
            } else if (v == 1L) {
                tag = 8;
                top = 0;
                len = 1;
            } else if (v < 256L) {
                tag = 7;
                top = 8;
                len = 2;
            } else if (v < 65536L) {
                tag = 5;
                top = 16;
                len = 3;
            } else if (v < 0x1000000L) {
                tag = 3;
                top = 24;
                len = 4;
            } else {
                tag = 1;
                top = 32;
                len = 5;
            }
        } else if (varInt == 0) {
            tag = 0;
            top = 32;
            len = 5;
        } else if (v < 247L) {
            tag = x + 9;
            top = 0;
            len = 1;
        } else if (v < 256L) {
            tag = 6;
            top = 8;
            len = 2;
        } else if (v < 65536L) {
            tag = 4;
            top = 16;
            len = 3;
        } else if (v < 0x1000000L) {
            tag = 2;
            top = 24;
            len = 4;
        } else {
            tag = 0;
            top = 32;
            len = 5;
        }
        int rc = this.portReserveSpace(len);
        if (rc < 0) {
            return rc;
        }
        this.printKind(3, " portOut int: " + x);
        this.bufferOut_8(tag);
        int shift = 0;
        while (shift < top) {
            this.bufferOut_8((int)(0xFFL & v >> shift));
            shift += 8;
        }
        return this.endpos;
    }

    int portOut(float x) {
        int rc = this.portReserveSpace(6);
        if (rc < 0) {
            return rc;
        }
        this.printKind(3, " portOut float: " + x);
        int b = Float.floatToRawIntBits(x);
        int s = 0;
        if (b < 0) {
            b ^= Integer.MIN_VALUE;
            s = 1;
        }
        int e = b >> 23;
        b |= 0x7F800000;
        b ^= 0x7F800000;
        this.bufferOut_8(s);
        this.bufferOut_16(e);
        int shift = 0;
        while (shift < 23) {
            this.bufferOut_8((int)(0xFFL & (long)(b >> shift)));
            shift += 8;
        }
        return this.endpos;
    }

    int portOut(double x) {
        int rc = this.portReserveSpace(10);
        if (rc < 0) {
            return rc;
        }
        this.printKind(3, " portOut double: " + x);
        long b = Double.doubleToRawLongBits(x);
        int s = 0;
        if (b < 0L) {
            b ^= Long.MIN_VALUE;
            s = 1;
        }
        int e = (int)(b >> 52);
        b |= 0x7FF0000000000000L;
        b ^= 0x7FF0000000000000L;
        this.bufferOut_8(s);
        this.bufferOut_16(e);
        int shift = 0;
        while (shift < 52) {
            this.bufferOut_8((int)(0xFFL & b >> shift));
            shift += 8;
        }
        return this.endpos;
    }

    int portOut(String x) {
        if (x == null) {
            int rc = varInt == 0 ? this.portOut(0) : this.portOut(-1);
            if (rc < 0) {
                return rc;
            }
            this.printKind(3, " portOut String: " + x);
        } else {
            int rc = this.portOut(x.length());
            if (rc < 0) {
                return rc;
            }
            this.printKind(3, " portOut String: " + x);
            int i = 0;
            while (i < x.length()) {
                rc = this.portOut(x.charAt(i));
                if (rc < 0) {
                    return rc;
                }
                ++i;
            }
        }
        return this.endpos;
    }

    int bufferOut_8(int x) {
        this.printKind(5, " bufferOut_8: " + x);
        this.buffer[this.endpos] = (byte)(0xFF & x);
        ++this.endpos;
        return this.endpos;
    }

    int bufferOut_16(int x) {
        this.printKind(5, " bufferOut_16: " + x);
        this.buffer[this.endpos] = (byte)(0xFF & x);
        ++this.endpos;
        this.buffer[this.endpos] = (byte)(0xFF & x >> 8);
        ++this.endpos;
        return this.endpos;
    }

    static interface Handler {
        public int doMessage(int var1);

        public Object doRequest(String var1, int var2, int[] var3, String[] var4, double[] var5);

        public TranStruct[] doInvoke(TranStruct[] var1);
    }

    public static interface PortNotifier {
        public void rePort(int var1);
    }

    public static class PortPrinter
    implements PortNotifier {
        public void rePort(int p) {
            System.out.println("Listening at port " + p);
        }
    }
}

