;/* example-start filesel filesel.c */
;
;#include <gtk/gtk.h>
;
;/* Get the selected filename and print it to the console */
;void file_ok_sel( GtkWidget        *w,
;		   GtkFileSelection *fs )
;{
;    g_print ("%s\n", gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs)));
;}
;
;void destroy( GtkWidget *widget,
;	       gpointer   data )
;{
;    gtk_main_quit ();
;}
;
;int main( int   argc,
;	   char *argv[] )
;{
;    GtkWidget *filew;
;    
;    gtk_init (&argc, &argv);
;    
;    /* Create a new file selection widget */
;    filew = gtk_file_selection_new ("File selection");
;    
;    gtk_signal_connect (GTK_OBJECT (filew), "destroy",
;			 (GtkSignalFunc) destroy, &filew);
;    /* Connect the ok_button to file_ok_sel function */
;    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
;			 "clicked", (GtkSignalFunc) file_ok_sel, filew );
;    
;    /* Connect the cancel_button to destroy the widget */
;    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION
;					     (filew)->cancel_button),
;				"clicked", (GtkSignalFunc) gtk_widget_destroy,
;				GTK_OBJECT (filew));
;    
;    /* Lets set the filename, as if this were a save dialog, and we are giving
;     a default filename */
;    gtk_file_selection_set_filename (GTK_FILE_SELECTION(filew), 
;				      "penguin.png");
;    
;    gtk_widget_show(filew);
;    gtk_main ();
;    return 0;
;}
;/* example-end */

(defpackage "09.14-filesel" (:use :excl :common-lisp))
(in-package "09.14-filesel")

(ff:defun-foreign-callable file-ok-sel ((w (* gtk:GtkWidget))
					(fs (* gtk:GtkFileSelection)))
  (declare (ignore w))
  (format t "~&~s~%"
	  (gtk:gtk_file_selection_get_filename (gtk:GTK_FILE_SELECTION fs))))

(ff:defun-foreign-callable destroy ((widget (* gtk:GtkWidget))
				    (data gtk:gpointer))
  (declare (ignore widget data))
  #+original (gtk:gtk_main_quit)
  #-original (gtk:gtk-main-quit))

(defun filesel ()
  (let ((filew nil))
    (gtk:gtk_init 0 0)
    
    (setq filew (gtk:gtk_file_selection_new "File selection"))

    (gtk:gtk_signal_connect (gtk:GTK_OBJECT filew) "destroy"
			    (ff:register-foreign-callable 'destroy)
			    ;; Source specifies '&filew', but isn't used
			    gtk:NULL)

    (gtk:gtk_signal_connect (gtk:GTK_OBJECT
			     (ff:fslot-value-typed
			      'gtk:GtkFileSelection nil
			      (gtk:GTK_FILE_SELECTION filew) 'gtk::ok_button))
			    "clicked"
			    (ff:register-foreign-callable 'file-ok-sel)
			    filew)

    (gtk:gtk_signal_connect_object (gtk:GTK_OBJECT
				    (ff:fslot-value-typed
				     'gtk:GtkFileSelection nil
				     (gtk:GTK_FILE_SELECTION filew)
				     'gtk::cancel_button))
				   "clicked"
				   (ff:get-entry-point "gtk_widget_destroy")
				   (gtk:GTK_OBJECT filew))

    (gtk:gtk_file_selection_set_filename (gtk:GTK_FILE_SELECTION filew) 
					 "penguin.png")

    (gtk:gtk_widget_show filew)
    #+original (gtk:gtk_main)
    #-original (gtk:gtk-main)))

(flet ((run-example (name function)
	 ;; workaround for bogus (imo) redef. warnings generated by defvar
	 (declare (special gtk::*run-example*))
	 (unless (boundp 'gtk::*run-example*)
	   (setq gtk::*run-example* t))
	 (when gtk::*run-example*
	   (mp:process-run-function
	    (format nil "GTK+ Example: ~a" name)
	    function))))
  (run-example "09.14-filesel" #'filesel))
