/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JLCommon;
import com.franz.jlinker.JLCommonJNI;
import com.franz.jlinker.JLWrapper;
import com.franz.jlinker.JNIWrapper;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.LispCall;
import com.franz.jlinker.LispCallImplementation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispCallJNI
extends LispCallImplementation {
    static Class<Object> opclass = Object.class;
    LispCall lci;
    String argtypes = "";
    int rescount = -1;
    public String restypes = null;
    JLWrapper.TypeCode[] resCodes = null;
    public Object res0 = null;
    public Object res1 = null;
    public Object res2 = null;
    public Object res3 = null;
    public Object res4 = null;
    public int int0 = 0;
    public float float0 = 0.0f;
    public double double0 = 0.0;
    static Object[] eventQueue = null;
    static int eventCount = 0;
    static Thread lispThread;
    static int callFlag;

    static {
        callFlag = 0;
    }

    @Override
    Class<?> getOpClass() {
        return opclass;
    }

    @Override
    LispCallImplementation builder(LispCall parent, String op) {
        LispCallJNI x = new LispCallJNI();
        x.lci = parent;
        if (!op.equals("")) {
            parent.lispOp = op;
        }
        return x;
    }

    @Override
    void setOp(String op) {
        this.setOp((Object)op);
    }

    @Override
    void setOp(Object op) {
        this.lci.lispOp = op;
        if (this.lci.state == 0) {
            this.lci.state = 1;
        }
    }

    synchronized int addArgWrapped(String type, Object x) {
        if (this.lci.state != 1) {
            throw new IllegalArgumentException("Wrong state");
        }
        int n = this.lci.newHolder(x);
        this.argtypes = n == 1 ? type : String.valueOf(this.argtypes) + type;
        return n;
    }

    @Override
    synchronized int addArg(int x) {
        return this.addArgWrapped("I", new Integer(x));
    }

    @Override
    synchronized int addArg(short x) {
        return this.addArgWrapped("S", new Integer(x));
    }

    @Override
    synchronized int addArg(byte x) {
        return this.addArgWrapped("B", new Integer(x));
    }

    @Override
    synchronized int addArg(long x) {
        return this.addArgWrapped("J", new Long(x));
    }

    @Override
    synchronized int addArg(boolean x) {
        int y = 0;
        if (x) {
            y = 1;
        }
        return this.addArgWrapped("Z", new Integer(y));
    }

    @Override
    synchronized int addArg(int[] x) {
        return this.addArgWrapped("N", x);
    }

    @Override
    synchronized int addArg(short[] x) {
        return this.addArgWrapped("M", x);
    }

    @Override
    synchronized int addArg(byte[] x) {
        return this.addArgWrapped("K", x);
    }

    @Override
    synchronized int addArg(String x) {
        return this.addArgWrapped("T", x);
    }

    @Override
    synchronized int addArg(String[] x) {
        return this.addArgWrapped("U", x);
    }

    @Override
    synchronized int addArg(double x) {
        return this.addArgWrapped("D", new Double(x));
    }

    @Override
    synchronized int addArg(float x) {
        return this.addArgWrapped("F", new Float(x));
    }

    @Override
    synchronized int addArg(double[] x) {
        return this.addArgWrapped("E", x);
    }

    @Override
    synchronized int addArg(float[] x) {
        return this.addArgWrapped("G", x);
    }

    @Override
    synchronized int addArg(Object x) {
        return this.addArgWrapped("X", x);
    }

    @Override
    synchronized int addSymbol(String x) {
        return this.addArgWrapped("Y", new JNIWrapper(x, "", 0));
    }

    @Override
    synchronized int addSymbol(String x, String pk) {
        return this.addArgWrapped("Y", new JNIWrapper(x, pk, 0));
    }

    @Override
    synchronized int addSymbol(String x, String pk, int act) {
        return this.addArgWrapped("Y", new JNIWrapper(x, pk, act));
    }

    @Override
    synchronized void assemble(String where) {
        Object[] argarray;
        if (this.lci.state != 1) {
            this.lci.throwWrongState(where, "");
        }
        this.lci.args = argarray = new Object[this.lci.count];
        int i = 0;
        while (i < this.lci.count) {
            argarray[this.lci.count - i - 1] = this.lci.chain.arg;
            this.lci.chain = this.lci.chain.next;
            ++i;
        }
        this.lci.count = 0;
        this.lci.state = 2;
    }

    native int callInLisp(int var1, Object var2, int var3, String var4, Object[] var5);

    native int nthIntValue(int var1, JNIWrapper var2);

    native Object nthObjectValue(int var1, JNIWrapper var2);

    static synchronized int callLispWithEvent(String ev, int h, String[] s, int[] i) {
        if (callFlag == 2) {
            return LispCallJNI.callLispHandler(ev, h, s, i);
        }
        eventQueue = new Object[]{ev, new Integer(h), s, i, eventQueue};
        ++eventCount;
        return 0;
    }

    public static synchronized int pollEventQueue(int n) {
        int done = 0;
        int i = 0;
        while (i < n) {
            if (eventQueue == null) {
                return done;
            }
            Object[] ev = eventQueue;
            Object[] prev = null;
            while (ev[4] != null) {
                prev = ev;
                ev = (Object[])ev[4];
            }
            if (prev == null) {
                eventQueue = null;
            } else {
                prev[4] = null;
            }
            --eventCount;
            --done;
            LispCallJNI.callLispHandler((String)ev[0], (Integer)ev[1], (String[])ev[2], (int[])ev[3]);
            ++i;
        }
        return eventCount;
    }

    static native int callLispHandler(String var0, int var1, String[] var2, int[] var3);

    int setLispError(String desc) {
        this.rescount = -1;
        this.res0 = null;
        this.restypes = "R";
        this.resCodes = null;
        this.res1 = desc;
        return 0;
    }

    @Override
    synchronized int call() throws JavaLinkDist.JLinkerException {
        if (this.lci.state == 1) {
            this.assemble("call");
        }
        if (this.lci.state != 2) {
            this.lci.throwWrongState("call", "");
        }
        this.rescount = this.callInLisp(this.lci.callStyle, this.lci.lispOp, this.lci.lispOpKind, this.argtypes, (Object[])this.lci.args);
        if (this.rescount < 0) {
            throw new JavaLinkDist.JLinkerException("Lisp error " + this.res1.toString());
        }
        if (!this.lci.retain) {
            this.lci.args = null;
        }
        if (this.lci.callStyle >= 3) {
            this.lci.waitref = this.res0;
            this.lci.state = 4;
            return 0;
        }
        this.lci.waitref = null;
        this.lci.state = 3;
        this.lci.res = this.lci;
        return this.rescount;
    }

    @Override
    synchronized Object getValue(int i) {
        Object v = null;
        if (i >= 0 && i < this.rescount) {
            JLWrapper.TypeCode restype = this.getResCode(i);
            if (restype == null) {
                this.lci.throwWrongState("getValue", " when result is not available.");
            }
            if (restype == JLWrapper.TypeCode.SEEN) {
                this.lci.throwWrongState("getValue", " when value already retrieved once.");
            }
            if (restype == JLWrapper.TypeCode.MISSING) {
                this.lci.throwWrongState("getValue", " when result is missing.");
            }
            if (restype == JLWrapper.TypeCode.WRONG_STATE) {
                this.lci.throwWrongState("getValue", " when LispCall is in wrong state.");
            }
            if (restype == JLWrapper.TypeCode.UNKNOWN) {
                this.lci.throwWrongState("getValue", " when result type is unknown.");
            } else {
                v = restype == JLWrapper.TypeCode.NULL ? null : (restype == JLWrapper.TypeCode.BOOL ? new Boolean(this.int0 == 1) : (restype == JLWrapper.TypeCode.CHAR ? new Character((char)this.int0) : (restype == JLWrapper.TypeCode.BYTE ? new Byte((byte)this.int0) : (restype == JLWrapper.TypeCode.SHORT ? new Short((short)this.int0) : (restype == JLWrapper.TypeCode.INT ? new Integer(this.int0) : (restype == JLWrapper.TypeCode.FLOAT ? new Float(this.float0) : (restype == JLWrapper.TypeCode.DOUBLE ? new Double(this.double0) : (i == 0 ? this.res0 : (i == 1 ? this.res1 : (i == 2 ? this.res2 : (i == 3 ? this.res3 : (this.rescount == 5 ? this.res4 : this.nthObjectValue(i - 4, (JNIWrapper)this.res4)))))))))))));
            }
            if (!this.lci.retain) {
                switch (i) {
                    case 0: {
                        this.res0 = null;
                    }
                    case 1: {
                        this.res1 = null;
                    }
                    case 2: {
                        this.res2 = null;
                    }
                    case 3: {
                        this.res3 = null;
                    }
                    case 4: {
                        if (this.rescount != 5) break;
                        this.res4 = null;
                    }
                }
                this.resCodes[i] = JLWrapper.TypeCode.SEEN;
            }
        } else {
            this.lci.throwWrongState("getValue", " when index is out of range.");
        }
        return v;
    }

    @Override
    @Deprecated
    int typeOf(JLWrapper vv) {
        if (vv instanceof JNIWrapper) {
            JNIWrapper v = (JNIWrapper)vv;
            return v.type.getTypeNum();
        }
        return JLWrapper.TypeCode.UNKNOWN.getTypeNum();
    }

    @Override
    @Deprecated
    int typeOf(int i) {
        return this.getTypeCode(i).getTypeNum();
    }

    @Override
    JLWrapper.TypeCode getTypeCode(int i) {
        JLWrapper.TypeCode rtc = this.getResCode(i);
        if (rtc == JLWrapper.TypeCode.WRAPPER) {
            rtc = ((JNIWrapper)this.getValue((int)i)).type;
        }
        if (rtc != null) {
            return rtc;
        }
        if (i < 0 || this.rescount <= i) {
            return JLWrapper.TypeCode.MISSING;
        }
        return JLWrapper.TypeCode.UNKNOWN;
    }

    @Override
    synchronized int intValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (i == 0) {
            if (tp == JLWrapper.TypeCode.INT || tp == JLWrapper.TypeCode.SHORT || tp == JLWrapper.TypeCode.BYTE) {
                return this.int0;
            }
        } else {
            if (tp == JLWrapper.TypeCode.INT) {
                return (Integer)this.getValue(i);
            }
            if (tp == JLWrapper.TypeCode.SHORT) {
                return ((Short)this.getValue(i)).shortValue();
            }
            if (tp == JLWrapper.TypeCode.BYTE) {
                return ((Byte)this.getValue(i)).byteValue();
            }
        }
        throw new UnsupportedOperationException("intValue of " + tp.nameOfType());
    }

    @Override
    synchronized long longValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (i == 0) {
            if (tp == JLWrapper.TypeCode.INT || tp == JLWrapper.TypeCode.SHORT || tp == JLWrapper.TypeCode.BYTE) {
                return this.int0;
            }
            if (tp == JLWrapper.TypeCode.LONG) {
                return (Long)this.res0;
            }
        } else {
            if (tp == JLWrapper.TypeCode.LONG) {
                return (Long)this.getValue(i);
            }
            if (tp == JLWrapper.TypeCode.INT) {
                return ((Integer)this.getValue(i)).intValue();
            }
            if (tp == JLWrapper.TypeCode.SHORT) {
                return ((Short)this.getValue(i)).shortValue();
            }
            if (tp == JLWrapper.TypeCode.BYTE) {
                return ((Byte)this.getValue(i)).byteValue();
            }
        }
        throw new UnsupportedOperationException("longValue of " + tp.nameOfType());
    }

    @Override
    synchronized double doubleValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (i == 0) {
            if (tp == JLWrapper.TypeCode.DOUBLE) {
                return this.double0;
            }
            if (tp == JLWrapper.TypeCode.FLOAT) {
                return this.float0;
            }
        } else {
            if (tp == JLWrapper.TypeCode.DOUBLE) {
                return (Double)this.getValue(i);
            }
            if (tp == JLWrapper.TypeCode.FLOAT) {
                return ((Float)this.getValue(i)).floatValue();
            }
        }
        throw new UnsupportedOperationException("doubleValue of " + tp.nameOfType());
    }

    synchronized float floatValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (i == 0) {
            if (tp == JLWrapper.TypeCode.DOUBLE) {
                return (float)this.double0;
            }
            if (tp == JLWrapper.TypeCode.FLOAT) {
                return this.float0;
            }
        } else {
            if (tp == JLWrapper.TypeCode.DOUBLE) {
                return (float)((Double)this.getValue(i)).doubleValue();
            }
            if (tp == JLWrapper.TypeCode.FLOAT) {
                return ((Float)this.getValue(i)).floatValue();
            }
        }
        throw new UnsupportedOperationException("floatValue of " + tp.nameOfType());
    }

    @Override
    synchronized boolean booleanValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (i == 0) {
            if (tp == JLWrapper.TypeCode.BOOL) {
                return 1 == this.int0;
            }
        } else if (tp == JLWrapper.TypeCode.BOOL) {
            return (Boolean)this.getValue(i);
        }
        throw new UnsupportedOperationException("booleanValue of " + tp.nameOfType());
    }

    @Override
    synchronized String stringValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.STRING) {
            return (String)this.getValue(i);
        }
        throw new UnsupportedOperationException("stringValue of " + tp.nameOfType());
    }

    @Override
    synchronized int[] intArrayValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.INT_ARRAY) {
            return (int[])this.getValue(i);
        }
        throw new UnsupportedOperationException("intArrayValue of " + tp.nameOfType());
    }

    @Override
    synchronized String[] stringArrayValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.STRING_ARRAY) {
            return (String[])this.getValue(i);
        }
        throw new UnsupportedOperationException("stringArrayValue of " + tp.nameOfType());
    }

    @Override
    synchronized double[] doubleArrayValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.DOUBLE_ARRAY) {
            return (double[])this.getValue(i);
        }
        throw new UnsupportedOperationException("doubleArrayValue of " + tp.nameOfType());
    }

    synchronized float[] floatArrayValue(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.FLOAT_ARRAY) {
            return (float[])this.getValue(i);
        }
        throw new UnsupportedOperationException("floatArrayValue of " + tp.nameOfType());
    }

    @Override
    synchronized Object objectValue(int i) {
        return this.getValue(i);
    }

    @Override
    synchronized String symbolName(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.SYMBOL) {
            return (String)((JNIWrapper)this.getValue((int)i)).data;
        }
        throw new UnsupportedOperationException("symbolName of " + tp.nameOfType());
    }

    @Override
    synchronized String symbolPackage(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.SYMBOL) {
            return ((JNIWrapper)this.getValue((int)i)).packageName;
        }
        throw new UnsupportedOperationException("symbolPackage of " + tp.nameOfType());
    }

    @Override
    synchronized String lispType(int i) {
        JLWrapper.TypeCode tp = this.getTypeCode(i);
        if (tp == JLWrapper.TypeCode.LISP_POINTER) {
            return ((JNIWrapper)this.getValue(i)).getLispType();
        }
        if (tp == JLWrapper.TypeCode.SYMBOL) {
            return "symbol";
        }
        return tp.nameOfType();
    }

    @Override
    synchronized int query(boolean doquery, boolean dofetch) throws JavaLinkDist.JLinkerException {
        switch (this.lci.state) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return -100;
            }
            case 3: {
                if (this.rescount == -1) {
                    return -99;
                }
                return this.rescount;
            }
            case 5: {
                break;
            }
            case 4: {
                break;
            }
            default: {
                return -100;
            }
        }
        if (this.lci.waitref == null) {
            return -100;
        }
        if (doquery && this.lci.state == 4) {
            int rc = this.nthIntValue(0, (JNIWrapper)this.lci.waitref);
            if (rc >= 0) {
                this.lci.waitres = rc;
                this.lci.state = 5;
            } else if (rc == -98) {
                this.lci.waitres = rc;
                this.lci.state = 5;
            } else if (rc == -99) {
                this.lci.state = 3;
                this.lci.res = this.lci;
                return -99;
            }
        }
        if (dofetch && this.lci.state == 5) {
            this.rescount = this.callInLisp(2, "net.jlinker::jl-async-results", 0, "P", new Object[]{this.lci.waitref});
            this.lci.state = 3;
            this.lci.res = this.lci;
            if (this.rescount == -1) {
                return 0;
            }
            return this.rescount;
        }
        if (this.lci.state == 5) {
            if (doquery) {
                return this.lci.waitres;
            }
            return -11;
        }
        return -10;
    }

    @Override
    synchronized void close() {
        this.reset();
    }

    @Override
    synchronized void reset() {
        this.rescount = -1;
        this.restypes = null;
        this.resCodes = null;
        this.res0 = null;
        this.res1 = null;
        this.res2 = null;
        this.res3 = null;
        this.res4 = null;
        this.int0 = 0;
        this.float0 = 0.0f;
        this.double0 = 0.0;
    }

    JLWrapper.TypeCode getResCode(int i) {
        JLWrapper.TypeCode r = null;
        if (this.restypes == null) {
            return null;
        }
        int ln = this.restypes.length();
        if (i >= 0 && i < ln) {
            if (this.resCodes == null) {
                this.resCodes = new JLWrapper.TypeCode[ln];
            }
            if ((r = this.resCodes[i]) == null) {
                this.resCodes[i] = JLWrapper.encodeType(this.restypes.substring(i, i + 1));
            }
            r = this.resCodes[i];
        }
        return r;
    }

    synchronized void setArgWrapped(int i, JLWrapper.TypeCode type, Object arg) {
        this.setArgWrapped(i, type.getTypeChar(), arg);
    }

    synchronized void setArgWrapped(int i, String type, Object arg) {
        switch (this.lci.state) {
            case 1: {
                this.assemble("setArg");
                break;
            }
            case 2: {
                break;
            }
            default: {
                this.lci.throwWrongState("setArg", "");
            }
        }
        this.argtypes = String.valueOf(this.argtypes.substring(0, i)) + type + this.argtypes.substring(i + 1);
        Object[] argarray = (Object[])this.lci.args;
        argarray[i] = arg;
    }

    @Override
    synchronized void setArg(int i, boolean arg) {
        int v = 0;
        if (arg) {
            v = 1;
        }
        this.setArgWrapped(i, "Z", (Object)new Integer(v));
    }

    @Override
    synchronized void setArg(int i, int arg) {
        this.setArgWrapped(i, "I", (Object)new Integer(arg));
    }

    @Override
    synchronized void setArg(int i, byte arg) {
        this.setArgWrapped(i, JLWrapper.TypeCode.BOOL, (Object)arg);
    }

    @Override
    synchronized void setArg(int i, short arg) {
        this.setArgWrapped(i, JLWrapper.TypeCode.SHORT, (Object)arg);
    }

    @Override
    synchronized void setArg(int i, short[] arg) {
        this.setArgWrapped(i, JLWrapper.TypeCode.SHORT_ARRAY, (Object)arg);
    }

    @Override
    synchronized void setArg(int i, long arg) {
        this.setArgWrapped(i, "J", (Object)new Long(arg));
    }

    @Override
    synchronized void setArg(int i, double arg) {
        this.setArgWrapped(i, "D", (Object)new Double(arg));
    }

    @Override
    synchronized void setArg(int i, float arg) {
        this.setArgWrapped(i, JLWrapper.TypeCode.FLOAT, (Object)new Double(arg));
    }

    @Override
    synchronized void setArg(int i, String arg) {
        this.setArgWrapped(i, "T", (Object)arg);
    }

    @Override
    synchronized void setArg(int i, Object arg) {
        this.setArgWrapped(i, "P", arg);
    }

    @Override
    synchronized void setArg(int i, int[] arg) {
        this.setArgWrapped(i, "N", (Object)arg);
    }

    @Override
    synchronized void setArg(int i, byte[] arg) {
        this.setArgWrapped(i, JLWrapper.TypeCode.BYTE_ARRAY, (Object)arg);
    }

    @Override
    synchronized void setArg(int i, double[] arg) {
        this.setArgWrapped(i, "E", (Object)arg);
    }

    @Override
    synchronized void setArg(int i, float[] arg) {
        this.setArgWrapped(i, JLWrapper.TypeCode.FLOAT_ARRAY, (Object)arg);
    }

    @Override
    synchronized void setArg(int i, String[] arg) {
        this.setArgWrapped(i, "U", (Object)arg);
    }

    @Override
    synchronized void setSymbol(int i, String name) {
        this.setArgWrapped(i, "Y", (Object)new JNIWrapper(name, "", 0));
    }

    @Override
    synchronized void setSymbol(int i, String name, String pk) {
        this.setArgWrapped(i, "Y", (Object)new JNIWrapper(name, pk, 0));
    }

    @Override
    synchronized void setSymbol(int i, String name, String pk, int act) {
        this.setArgWrapped(i, "Y", (Object)new JNIWrapper(name, pk, act));
    }

    @Override
    int mayCall() {
        switch (callFlag) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        if (lispThread.equals(Thread.currentThread())) {
            return 1;
        }
        return -1;
    }

    public static void setLispThread(int flag) {
        LispCall.prototype = new LispCallJNI();
        JLCommon.ltoj_anchor = new JLCommonJNI();
        if (flag == 2) {
            callFlag = 2;
        } else {
            lispThread = Thread.currentThread();
            callFlag = 1;
        }
    }

    public static byte[] getLongFieldBytes(Field field, Object instance) throws IllegalArgumentException, IllegalAccessException {
        byte[] val = new byte[9];
        long v = field.getLong(instance);
        val[0] = 1;
        if (v < 0L) {
            val[0] = -1;
            v = -(v + 1L);
        }
        int i = 8;
        while (i > 0) {
            val[i] = (byte)(v & 0xFFL);
            v >>= 8;
            --i;
        }
        return val;
    }

    public static byte[] getLongValueBytes(Long input) throws IllegalArgumentException {
        byte[] val = new byte[9];
        long v = input;
        val[0] = 1;
        if (v < 0L) {
            val[0] = -1;
            v = -(v + 1L);
        }
        int i = 8;
        while (i > 0) {
            val[i] = (byte)(v & 0xFFL);
            v >>= 8;
            --i;
        }
        return val;
    }

    public static void setLongFieldBytes(Field field, Object instance, int sign, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8) throws IllegalArgumentException, IllegalAccessException {
        long v = (long)(b1 & 0xFF) | (long)(b2 & 0xFF) << 8 | (long)(b3 & 0xFF) << 16 | (long)(b4 & 0xFF) << 24 | (long)(b5 & 0xFF) << 32 | (long)(b6 & 0xFF) << 40 | (long)(b7 & 0xFF) << 48 | (long)(b8 & 0xFF) << 56;
        if (sign < 0) {
            v = -v - 1L;
        }
        field.setLong(instance, v);
    }
}

