/*
 * Decompiled with CFR 0.152.
 */
package com.franz.jlinker;

import com.franz.jlinker.JLCommon;
import com.franz.jlinker.JLWrapper;
import com.franz.jlinker.JavaLinkDist;
import com.franz.jlinker.LispCallImplementation;
import com.franz.jlinker.LispCallSocket;

public class LispCall {
    public static final int STYLE_ONEWAY = -1;
    public static final int STYLE_IGNORE = 0;
    public static final int STYLE_REF = 1;
    public static final int STYLE_COPY = 2;
    public static final int STYLE_ASYNC_BR = 3;
    static final int STYLE_ASYNC = 3;
    public static final int STYLE_ASYNC_GO = 4;
    static final int STYLE_TOP = 4;
    public static final int STATE_NEW = 0;
    public static final int STATE_COLLECTING = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DONE = 3;
    public static final int STATE_WAITING = 4;
    public static final int STATE_WAITDONE = 5;
    public static final int STATE_CLOSED = 6;
    public static final int RES_NULL = JLWrapper.TypeCode.NULL.getTypeNum();
    public static final int RES_BOOLEAN = JLWrapper.TypeCode.BOOL.getTypeNum();
    public static final int RES_INTEGER = JLWrapper.TypeCode.INT.getTypeNum();
    public static final int RES_LONG = JLWrapper.TypeCode.LONG.getTypeNum();
    public static final int RES_REAL = JLWrapper.TypeCode.DOUBLE.getTypeNum();
    public static final int RES_STRING = JLWrapper.TypeCode.STRING.getTypeNum();
    public static final int RES_SYMBOL = JLWrapper.TypeCode.SYMBOL.getTypeNum();
    public static final int RES_LISP_POINTER = JLWrapper.TypeCode.LISP_POINTER.getTypeNum();
    public static final int RES_ERROR = JLWrapper.TypeCode.ERROR.getTypeNum();
    public static final int RES_INT_ARRAY = JLWrapper.TypeCode.INT_ARRAY.getTypeNum();
    public static final int RES_DOUBLE_ARRAY = JLWrapper.TypeCode.DOUBLE_ARRAY.getTypeNum();
    public static final int RES_STRING_ARRAY = JLWrapper.TypeCode.STRING_ARRAY.getTypeNum();
    public static final int RES_JAVA_POINTER = JLWrapper.TypeCode.JAVA_POINTER.getTypeNum();
    public static final int RES_WRONG_STATE = JLWrapper.TypeCode.WRONG_STATE.getTypeNum();
    public static final int RES_MISSING = JLWrapper.TypeCode.MISSING.getTypeNum();
    public static final int RES_WRAPPER = JLWrapper.TypeCode.WRAPPER.getTypeNum();
    public static final int RES_UNKNOWN = JLWrapper.TypeCode.UNKNOWN.getTypeNum();
    int state;
    boolean retain = true;
    int callStyle = 2;
    Object lispOp = null;
    int lispOpKind = 0;
    Object args = null;
    Object res = null;
    Holder chain = null;
    int count = 0;
    Object waitref = null;
    int waitres = -99;
    LispCallImplementation implementation;
    static LispCallImplementation prototype = new LispCallSocket();
    public static Object connectError = null;
    public static int readTimeout = 30000;
    public static int replyTimeout = 300000;
    public static int requestTimeout = 0;

    int newHolder(Object x) {
        this.chain = new Holder(x, this.chain);
        ++this.count;
        return this.count;
    }

    public LispCall() {
        this.implementation = prototype.builder(this, "");
        this.state = 0;
    }

    public LispCall(boolean r) {
        this.implementation = prototype.builder(this, "");
        this.retain = r;
        this.state = 0;
    }

    public LispCall(int s) {
        this.implementation = prototype.builder(this, "");
        this.setStyle(s);
        this.state = 0;
    }

    public LispCall(String op) {
        this.implementation = prototype.builder(this, op);
        this.state = 1;
    }

    public int getState() {
        return this.state;
    }

    public Object getOp() {
        return this.lispOp;
    }

    public int getStyle() {
        return this.callStyle;
    }

    public void setOp(String op) {
        this.lispOpKind = 0;
        this.implementation.setOp(op);
    }

    public void setOp(Object op) {
        this.castObject(op);
        this.lispOpKind = 1;
        this.implementation.setOp(op);
    }

    void castObject(Object op) {
        if (!this.implementation.getOpClass().isInstance(op)) {
            throw new ClassCastException("Cannot cast object of class " + op.getClass().getName() + " to " + this.implementation.getOpClass().getName());
        }
    }

    public void setStyle(int s) {
        if (-1 > s || s > 4) {
            throw new IllegalArgumentException("Unknown call style " + s + ".");
        }
        this.callStyle = s;
    }

    public synchronized boolean getRetain() {
        return this.retain;
    }

    public synchronized void setRetain(boolean r) {
        this.retain = r;
    }

    public synchronized int addArg(byte x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(short x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(int x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(long x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(boolean x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(byte[] x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(short[] x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(int[] x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(String x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(String[] x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(float x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(double x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(float[] x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(double[] x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addArg(Object x) {
        return this.implementation.addArg(x);
    }

    public synchronized int addSymbol(String x) {
        return this.implementation.addSymbol(x);
    }

    public synchronized int addSymbol(String x, String pk) {
        return this.implementation.addSymbol(x, pk);
    }

    public synchronized int addSymbol(String x, String pk, int action) {
        switch (action) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("addSymbol action must be 0, 1, 2, 0r 3. ?:" + action);
            }
        }
        return this.implementation.addSymbol(x, pk, action);
    }

    public synchronized int call() throws JavaLinkDist.JLinkerException {
        switch (this.implementation.mayCall()) {
            case 0: {
                throw new IllegalStateException("Lisp is not ready for a call.");
            }
            case -1: {
                throw new IllegalStateException("May not call Lisp in this thread.");
            }
        }
        return this.implementation.call();
    }

    public synchronized int callOneWay() throws JavaLinkDist.JLinkerException {
        this.callStyle = -1;
        return this.call();
    }

    public synchronized int callIgnore() throws JavaLinkDist.JLinkerException {
        this.callStyle = 0;
        return this.call();
    }

    public synchronized int callRef() throws JavaLinkDist.JLinkerException {
        this.callStyle = 1;
        return this.call();
    }

    public synchronized int callCopy() throws JavaLinkDist.JLinkerException {
        this.callStyle = 2;
        return this.call();
    }

    public synchronized int callAsyncBr() throws JavaLinkDist.JLinkerException {
        this.callStyle = 3;
        return this.call();
    }

    public synchronized int callAsyncGo() throws JavaLinkDist.JLinkerException {
        this.callStyle = 4;
        return this.call();
    }

    public synchronized Object getValue() {
        return this.getValue(0);
    }

    public synchronized Object getValue(int i) {
        if (this.state != 3) {
            this.throwWrongState("getValue", "");
        }
        if (this.res == null) {
            this.throwWrongState("getValue", " when result from Lisp is null");
        }
        return this.implementation.getValue(i);
    }

    public static String nameOfType(int type) {
        JLWrapper.TypeCode tc = JLWrapper.encodeType(type);
        return tc.nameOfType();
    }

    public static Object identity(Object arg) {
        return arg;
    }

    public synchronized int typeOf() {
        return this.typeOf(0);
    }

    public synchronized int typeOf(int i) {
        if (this.state != 3) {
            return RES_WRONG_STATE;
        }
        if (this.res == null) {
            return RES_MISSING;
        }
        return this.implementation.typeOf(i);
    }

    public synchronized JLWrapper.TypeCode getTypeCode() {
        return this.getTypeCode(0);
    }

    public synchronized JLWrapper.TypeCode getTypeCode(int i) {
        return this.implementation.getTypeCode(i);
    }

    public synchronized int intValue() {
        return this.intValue(0);
    }

    public synchronized int intValue(int i) {
        return this.implementation.intValue(i);
    }

    public synchronized long longValue() {
        return this.longValue(0);
    }

    public synchronized long longValue(int i) {
        return this.implementation.longValue(i);
    }

    public synchronized double doubleValue() {
        return this.doubleValue(0);
    }

    public synchronized double doubleValue(int i) {
        return this.implementation.doubleValue(i);
    }

    public synchronized boolean booleanValue() {
        return this.booleanValue(0);
    }

    public synchronized boolean booleanValue(int i) {
        return this.implementation.booleanValue(i);
    }

    public synchronized String stringValue() {
        return this.stringValue(0);
    }

    public synchronized String stringValue(int i) {
        return this.implementation.stringValue(i);
    }

    public synchronized int[] intArrayValue() {
        return this.intArrayValue(0);
    }

    public synchronized int[] intArrayValue(int i) {
        return this.implementation.intArrayValue(i);
    }

    public synchronized String[] stringArrayValue() {
        return this.stringArrayValue(0);
    }

    public synchronized String[] stringArrayValue(int i) {
        return this.implementation.stringArrayValue(i);
    }

    public synchronized double[] doubleArrayValue() {
        return this.doubleArrayValue(0);
    }

    public synchronized double[] doubleArrayValue(int i) {
        return this.implementation.doubleArrayValue(i);
    }

    public synchronized Object objectValue() {
        return this.objectValue(0);
    }

    public synchronized Object objectValue(int i) {
        return this.implementation.objectValue(i);
    }

    public synchronized String symbolName() {
        return this.symbolName(0);
    }

    public synchronized String symbolName(int i) {
        return this.implementation.symbolName(i);
    }

    public synchronized String symbolPackage() {
        return this.symbolPackage(0);
    }

    public synchronized String symbolPackage(int i) {
        return this.implementation.symbolPackage(i);
    }

    public synchronized String lispType() {
        return this.lispType(0);
    }

    public synchronized String lispType(int i) {
        return this.implementation.lispType(i);
    }

    public synchronized int query() {
        int r = -99;
        try {
            r = this.query(false, false);
        }
        catch (JavaLinkDist.JLinkerException jLinkerException) {
            // empty catch block
        }
        return r;
    }

    public synchronized int query(boolean doquery, boolean dofetch) throws JavaLinkDist.JLinkerException {
        return this.implementation.query(doquery, dofetch);
    }

    public synchronized void close() {
        this.waitref = null;
        this.waitres = -99;
        this.res = null;
        this.args = null;
        this.count = 0;
        this.chain = null;
        if (this.state != 0) {
            this.state = 6;
        }
        this.implementation.close();
    }

    public synchronized boolean reset() {
        this.waitref = null;
        this.waitres = -99;
        this.res = null;
        if (this.state == 1) {
            this.implementation.assemble("reset");
        }
        this.count = 0;
        this.chain = null;
        switch (this.state) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.args == null) {
                    this.state = 1;
                    break;
                }
                this.state = 2;
                break;
            }
            case 6: {
                if (this.lispOp == null) {
                    this.state = 0;
                    break;
                }
                this.state = 1;
                break;
            }
            default: {
                this.throwWrongState("reset", "");
            }
        }
        this.implementation.reset();
        return this.state == 2;
    }

    public synchronized void setArg(int i, boolean arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, int arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, long arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, double arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, String arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, Object arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, int[] arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, double[] arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setArg(int i, String[] arg) {
        this.implementation.setArg(i, arg);
    }

    public synchronized void setSymbol(int i, String name) {
        this.implementation.setSymbol(i, name);
    }

    public synchronized void setSymbol(int i, String name, String pkg) {
        this.implementation.setSymbol(i, name, pkg);
    }

    public synchronized void setSymbol(int i, String name, String pkg, int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("addSymbol action must be 0, 1, 2, 0r 3. ?:" + mode);
            }
        }
        this.implementation.setSymbol(i, name, pkg, mode);
    }

    void throwWrongState(String where, String more) {
        String sn;
        switch (this.state) {
            case 0: {
                sn = "STATE_NEW";
                break;
            }
            case 1: {
                sn = "STATE_COLLECTING";
                break;
            }
            case 2: {
                sn = "STATE_READY";
                break;
            }
            case 3: {
                sn = "STATE_DONE";
                break;
            }
            case 4: {
                sn = "STATE_WAITING";
                break;
            }
            case 5: {
                sn = "STATE_WAITDONE";
                break;
            }
            case 6: {
                sn = "STATE_CLOSED";
                break;
            }
            default: {
                sn = "STATE_???";
            }
        }
        throw new IllegalStateException(String.valueOf(where) + " cannot be called in " + sn + " state" + more + ".");
    }

    public int mayCall() {
        return this.implementation.mayCall();
    }

    public static int dispatchEvent(String ev, Object target, String[] s, int[] l) {
        return JLCommon.ltoj_anchor.sendRegisteredEvent(ev, target, s, l);
    }

    public static boolean connect(String host, int port, int pollInterval, int pollCount) {
        if (prototype instanceof LispCallSocket) {
            return JavaLinkDist.connect(host, port, pollInterval, pollCount);
        }
        return true;
    }

    public static boolean connect(String com, int pollInterval, int pollCount) {
        if (prototype instanceof LispCallSocket) {
            return JavaLinkDist.connect(com, pollInterval, pollCount);
        }
        return true;
    }

    public static boolean advertise(int port, int timeoutSeconds) {
        if (prototype instanceof LispCallSocket) {
            return JavaLinkDist.advertise(port, timeoutSeconds);
        }
        return true;
    }

    public static boolean advertise(String l2j, String host, int port, int timeoutSeconds) {
        if (prototype instanceof LispCallSocket) {
            return JavaLinkDist.advertise(l2j, host, port, timeoutSeconds);
        }
        return true;
    }

    public static void disconnect() {
        if (prototype instanceof LispCallSocket) {
            JavaLinkDist.disconnect();
        }
    }

    class Holder {
        Holder next;
        Object arg;

        Holder(Object a, Holder n) {
            this.next = n;
            this.arg = a;
        }
    }
}

