{
    function renderBackdrop() {
        // Create a new div element
        var backdrop = document.createElement("div");

        // Set its style properties
        backdrop.style.position = 'fixed';
        backdrop.style.top = '0';
        backdrop.style.left = '0';
        backdrop.style.width = '100vw';
        backdrop.style.height = '100vh';
        backdrop.style.backgroundColor = 'rgba(0, 0, 0, 0.5)';
        backdrop.style.zIndex = '9999';
        backdrop.style.display = 'flex';
        backdrop.style.justifyContent = 'center';
        backdrop.style.alignItems = 'center';
        backdrop.style.color = 'white';
        backdrop.style.fontSize = '2em';

        // Set its text content
        backdrop.textContent = 'Loading...';

        // Append it to the body of the document
        document.body.appendChild(backdrop);
        document.body.style.overflow = 'hidden';
        return backdrop;
    }
    const searchParams = new URLSearchParams(window.location.search);
    const xpath = searchParams.get('xpath');
    if (xpath) {
        var backdrop = renderBackdrop();
    }
    window.onload = function () {
        try {
            if (xpath) {
                document.body.removeChild(backdrop);
                document.body.style.overflow = 'auto'; // Add this line
                const matchingElement = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
                if (matchingElement) {
                    matchingElement.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    const origBgColor = matchingElement.style['background-color'];
                    matchingElement.style['background-color'] = 'orange';
                    setTimeout(() => {
                        matchingElement.style['background-color'] = origBgColor;
                    }, 3000);
                }
            }
        } catch (err) {
            console.error(err);
        }
    };
}
