const e=[{nlQuery:"Show me one hundred triples",sparqlQuery:`SELECT ?s ?p ?o WHERE { 
  ?s ?p ?o . 
}
LIMIT 100
`},{nlQuery:"How many triples are in the database?",sparqlQuery:`SELECT (COUNT(*) as ?tripleCount) WHERE { 
  ?s ?p ?o .
}
`},{nlQuery:"What are the predicates in the database?",sparqlQuery:`SELECT DISTINCT ?p WHERE {
  ?s ?p ?o .
}
`},{nlQuery:"What are the classes in the repo?",sparqlQuery:`SELECT DISTINCT ?class WHERE { 
  ?s a ?class .
}`},{nlQuery:"How many instances of each class are there?",sparqlQuery:`SELECT ?class (COUNT(?s) AS ?count) WHERE {
  ?s a ?class .
}
GROUP BY ?class
ORDER BY desc(?count)
`},{nlQuery:"What are the distinct graphs?",sparqlQuery:`SELECT DISTINCT ?graph WHERE { 
  GRAPH ?graph { 
    ?s ?p ?o .
  }
}`},{nlQuery:"How many triples per named graph?",sparqlQuery:`SELECT DISTINCT ?graph (COUNT(?graph) as ?count) WHERE { 
  GRAPH ?graph {
    ?s ?p ?o .
  }
}
GROUP BY ?graph
`},{nlQuery:"Show me the various literal types in the database and how many there are",sparqlQuery:`SELECT DISTINCT ?datatype (COUNT(?o) AS ?count) WHERE {
  ?s ?p ?o .
  FILTER(isLiteral(?o)) .
  BIND(datatype(?o) AS ?datatype)
}
GROUP BY ?datatype
`},{nlQuery:"Show me the number of distinct subjects in the database",sparqlQuery:`SELECT (COUNT(DISTINCT ?subject) as ?count) WHERE {
  ?subject ?p ?o .
}
`},{nlQuery:"Show me the predicates for each class",sparqlQuery:`SELECT DISTINCT ?class ?predicate WHERE {
  ?subject a ?class ;
           ?predicate ?object .
}
ORDER BY ?class
`},{nlQuery:"What are the object properties in the database?",sparqlQuery:`SELECT DISTINCT ?predicate WHERE {
  ?subject ?predicate ?object .
  FILTER ( isiri(?object) ) . 
}
ORDER BY ?predicate
`},{nlQuery:"What are the data properties and their corresponding literals/datatypes?",sparqlQuery:`SELECT DISTINCT ?predicate ?datatype WHERE {
  ?subject ?predicate ?object .
  FILTER ( isliteral(?object) ) . 
  BIND ( datatype(?object) as ?datatype ) .
}
ORDER BY ?predicate`},{nlQuery:"What are the domain and range of the object properties in the graph?",sparqlQuery:`SELECT DISTINCT ?domain ?predicate ?range WHERE {
  ?domainInstance a ?domain ;
                  ?predicate ?rangeInstance .
  ?rangeInstance a ?range . 
}
ORDER BY ?domain
`}],r=[{nlQuery:"Find all concepts and their preflabels",sparqlQuery:`SELECT ?concept ?pref WHERE {
	?concept a skos:Concept ;
	         skos:prefLabel ?pref .
}
`},{nlQuery:"Find all concepts and their english preflabels",sparqlQuery:`SELECT ?concept ?pref WHERE {
	?concept a skos:Concept ;
	         skos:prefLabel ?pref .
  FILTER ( langMatches (lang (?pref), "en") )
}
`},{nlQuery:"Find which concepts have german labels",sparqlQuery:`SELECT DISTINCT ?concept WHERE {
	?concept a skos:Concept ;
	{ ?concept skos:prefLabel ?label . }
  UNION
  { ?concept skos:altLabel ?label . }
  FILTER ( langMatches (lang (?label), "de") )
}
`},{nlQuery:'Find the narrower concepts of "term A"',sparqlQuery:`SELECT ?narrowerConcept WHERE {
	?concept a skos:Concept ;
	         skos:prefLabel "term A" .
  ?concept skos:narrower ?narrowerConcept .
}
`},{nlQuery:'Get the broader concepts of "term A"',sparqlQuery:`SELECT ?broaderConcept WHERE {
	?concept a skos:Concept ;
	         skos:prefLabel "term A" .
  ?concept skos:broader ?broaderConcept .
}
`},{nlQuery:"Find the number of leaves in the taxonomy",sparqlQuery:`SELECT (COUNT(?concept) as ?count) WHERE { 
  ?concept a skos:Concept . 
  FILTER NOT EXISTS { ?concept skos:narrower ?narrowerConcept }
}`},{nlQuery:"Find the leaves in the taxonomy",sparqlQuery:`SELECT ?concept WHERE { 
  ?concept a skos:Concept . 
  FILTER NOT EXISTS { ?concept skos:narrower ?narrowerConcept }
}`},{nlQuery:"Find the languages present in the taxonomy",sparqlQuery:`SELECT DISTINCT (lang(?label) AS ?language) WHERE {
  ?concept a skos:Concept ;
           skos:prefLabel ?label .
  FILTER(lang(?label) != "")
}`},{nlQuery:"Order the top concepts by number of leaves it has",sparqlQuery:`SELECT ?topConcept (COUNT(?leaf) AS ?leafCount) WHERE {
  # Find top-level concepts (concepts with no broader concepts)
  ?topConcept a skos:Concept .
  FILTER NOT EXISTS { ?topConcept skos:broader ?broaderConcept } .

  # Find leaves (concepts with no narrower concepts)
  ?leaf a skos:Concept .
  ?leaf skos:broader+ ?topConcept .
  FILTER NOT EXISTS { ?leaf skos:narrower ?narrowerConcept } .
}
GROUP BY ?topConcept
ORDER BY DESC(?leafCount)`},{nlQuery:"What are the concept schemes in the taxonomy?",sparqlQuery:`SELECT ?conceptScheme ?title WHERE {
  ?conceptScheme a skos:ConceptScheme ;
                dcterms:title ?title .
}`},{nlQuery:'Given this start concept "term A" go three levels down in the narrower path. The result should include the start concept and all preflabels of narrower concepts',sparqlQuery:`SELECT ?narrowerConcept ?pref WHERE {
	?concept a skos:Concept ;
           skos:prefLabel "term A" ;
           skos:narrower{0,3} ?narrowerConcept .
	?narrowerConcept skos:prefLabel ?pref .
}`},{nlQuery:'Given the starting concept "term A" go three levels up using the broader path, not including the starting concept',sparqlQuery:`SELECT ?broaderConcept ?pref WHERE {
	?concept a skos:Concept ;
           skos:prefLabel "term A" ;
           skos:broader{1,3} ?broaderConcept .
	?broaderConcept skos:prefLabel ?pref .
}`},{nlQuery:'Given this concept "X" in scheme "S" return the closest concepts in other schemes',sparqlQuery:`SELECT ?relatedConcept ?relatedScheme
WHERE {
  # Bind the given concept "X" and scheme "S"
  ?concept skos:prefLabel "X" .
  ?concept skos:inScheme ?scheme .
  ?scheme skos:prefLabel|dcterms:title "S" .

  # Find exact matches to the concept in other schemes
  ?concept skos:exactMatch|owl:sameAs ?relatedConcept .

  # Ensure the related concept is in a different scheme
  ?relatedConcept skos:inScheme ?relatedScheme .
  FILTER (?relatedScheme != ?scheme)
}`},{nlQuery:'Find all narrower concepts of "term A", any level deep',sparqlQuery:`SELECT ?narrowerConcept WHERE {
	?concept a skos:Concept ;
	         skos:prefLabel "term A" .
  ?concept skos:narrower+ ?narrowerConcept .
}`}];export{e as q,r as t};
